/*
 * BSBathTile - generate bathtiles with cloudy pattern
 *
 * DESCRIPTION:
 *   Create Bathroom tiles with a swirly couldlike pattern
 *
 * PARAMETERS
 *   Ka, Ks, Kd, Kr - the usual meaning for the tiles
 *   Ka_groove, Kd_groove, Ks_groove, Kr_groove - properties for the groove
 *   roughn_tile - roughness of the tiles themselves
 *   roughn_groove - roughness of the groove
 *   specularcolor - color of specular reflections
 *   groovewidth - width of groove between tiles
 *   s_freq, t_freq - number of tile in s and t direction
 *   txtscale - scale of cloudy pattern
 *   darkcolor, lightcolor - colors of tile pattern
 *   groovecolor - color of groove 
 *   octaves, omega, lambda, threshold - noise parameters for pattern
 *
 * AUTHOR: Bernd Sieker, based on shiny by Larry Gritz,
 *         puffcloudsclouds by Ken Musgrave and RManNotes
 */

#define hard_pulse(a,b,x) (step((a),(x)) \
			 - step((b),(x)))

#define repeat(x,freq)    (mod((x) * (freq), 1.0))

/* Use signed Perlin noise */
#define snoise(x) ((2*noise(x))-1)


surface BSBathTile(float Ka = 0.1;
		     float Kd = 0.5;
		     float Ks = 0.7;
		     float Kr = 0.1;
		     float roughn_tile = 0.0001;
		     float Ka_groove = 0.2;
		     float Kd_groove = 1.0;
		     float Ks_groove = 0.2;
		     float Kr_groove = 0.0;
		     float roughn_groove = 0.001;
		     color specularcolor = color(1.0,1.0,1.0);
		     float groovewidth = 0.04;
		     float s_freq = 4;
		     float t_freq = 4;
		     float txtscale = 4.0;
		     color darkcolor = color(.15, .15, .6);
		     color lightcolor = color(1.0,1.0,1.0);
		     color groovecolor = color(1.0,1.0,1.0);
		     float octaves = 8, omega = 1.0, lambda = 2;
		     float threshold = 0;
		   )
{
  color surface_color, layer_color;
  float groovy;
  float ss, tt;
  float left = groovewidth * 0.5;
  float right = 1 - groovewidth * 0.5;
  float top = left;
  float bottom = right;
  float value;
  point PP;
  float i, a, l, o;

  point Nf, V, refldir;
  color env;

  /* repeat pattern in the following layers 'freq' times 
     horizontally & vertically */

  ss = repeat(s, s_freq);
  tt = repeat(t, t_freq);

  /* make individual tiles */

  PP = txtscale * transform ("shader", P);

  /* Use fractional Brownian motion to compute a value for this point */
  /*  value = fBm (PP, omega, lambda, octaves); */
  value = 0;
  l = 1;  o = 1;  a = 0;
  for (i = 0;  i < octaves;  i += 1) {
      a += o * snoise (PP*l);
      l *= 2;  o *= omega;
    }
  value = a;

  layer_color = mix (darkcolor, lightcolor, smoothstep (threshold, 1, value));

  groovy = hard_pulse(left, right, ss)
         * hard_pulse(top, bottom, tt);
  surface_color = mix(groovecolor, layer_color, groovy);

/* now calculate reflexions */

  Nf = faceforward (normalize(N), I);
  V = normalize (I);
  refldir = reflect (V, Nf);

  if (groovy > 0.5) {
    env = Ks * specular(Nf,-V,roughn_tile);
    env += Kr * trace (P, refldir);
    env *= specularcolor;
    Ci = Oi * (surface_color * (Ka * ambient()
				+ Kd * diffuse(Nf)) + env);
  }

  else {
    env = Ks_groove * specular(Nf,-V,roughn_groove);
    env += Kr_groove * trace (P, refldir);
    env *= specularcolor;
    Ci = Oi * (surface_color * (Ka_groove * ambient()
				+ Kd_groove * diffuse(Nf)) + env);
  }

  Oi = Os;

}
