/*
 * paintedplastic.sl -- Make a texture mapped plastic
 *
 * DESCRIPTION:
 *    Makes a plastic surface with an optional texture map
 *
 * PARAMETERS:
 *    Ka, Kd, Ks, roughness, specularcolor - The usual meaning
 *    Kr - coefficient for mirror-like reflections of environment
 *    texturename - name of the image map
 *    xmin, ymin, xman, ymax, texture dimensions in shader space
 *
 * AUTHOR: written by Bernd Sieker, 1998,
 *
 * HISTORY:
 *      Oct 1998 -- written
 *
 */


surface BSpaintedplastic( float Ks=.5,
			        Kd=.5,
			        Ka=1,
			        Kr=0.2,
			        roughness=.1;
			  color specularcolor= color(1.0, 1.0, 1.0);
			  string texturename = "";
			  float xmin = -1,
			        ymin = -1,
			        xmax =  1,
			        ymax =  1 )
{
  uniform point scale, zero;
  point objP, cubeP;

  point Nf, V, refldir;
  color Ct, env;

  Nf = faceforward( normalize(N), I );
  V = normalize(I);
  env = Ks * specular(Nf,-V,roughness);

  if (Kr > 0)
    { refldir = reflect (V, Nf); env += Kr * trace (P, refldir); }
  env *= specularcolor;

  /* check for zero scale component */

  if ((xmax == xmin) || (ymax == ymin)) {
    printf("bad bounding box (%f %f %f %f) in BSPaintedPlastic\n",
	   xmin, xmax, ymin, ymax);
  } else {
    scale = point (1/(xmax-xmin), 1/(ymax-ymin), 0);
    zero = point (xmin, ymin, 0);

    objP = transform ("shader", P);
    cubeP = (objP - zero) * scale;

    if (texturename != "") {
      Ct = texture(texturename, xcomp(cubeP), ycomp(cubeP));
    } else {
      Ct = Cs;
    }

    Oi = Os;
    Ci = Os * ( Cs * Ct * (Ka*ambient() + Kd*diffuse(Nf)) + env);
  }
}
