
/*
	title: "Beware the Frowning SandFish"
	author: Lachlan Cox 
	email: <lachie@zip.com.au>
	homepage: <www.cse.unsw.edu.au/~s2211017>
	desc:
		my entry for the oct 1998 IRTC (www.irtc.org) (topic: water)
	disclaimer: if you are ever going to employ me - this is _not_
	how I code!! ;)
*/


#version 3.1;
global_settings { 
	assumed_gamma 2.2 
	//ambient_light .5
	max_trace_level 10
}

#declare PI = 3.14156;


#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "metals.inc"

camera {
    location <0.5,0,-6>
    //location <0,.5,-3>
    direction z*1.3
    up y
    right x*1.33
    look_at <0.0, 0.0, 0.00>
	//rotate y*.01
	/*
	aperture .1
	focal_point <1, 0, 0>
	blur_samples 20
	*/
	//confidence 0.975           // default is 0.9
	//variance 1/255             // default is 1/128 (0.0078125)
}

light_source { <0, 10, 0> color White
	area_light <5,0,0>, <0,0,5>, 5,5
	adaptive 1
	jitter
}
light_source { <0, 2, -6> color <.6, .6, .6> }
light_source { <0, 20, 60> color <.6, .6, .6> }

light_source{ <0,3,-6> color Gray50 shadowless }

// converts to color map index, for sky sphere
#macro cm_index( ang )
	(1 - cos(radians(ang))) / 2
#end

sky_sphere {
	pigment {
		gradient y
		color_map {
			[0.5 color rgb <.5,.5,1>]
			[1.0 color rgb 1]
		}
	}
}

//#default { pigment { Red } finish { Shiny } } // ambient .5 } }
//#default { finish{ Shiny } }
#declare scl=.5;


/* Textures */

#declare sandy = texture {
	pigment {
		granite
			color_map {
				[0.0 color rgb <.86,.86,0.67>]
				[0.1 color rgb <.948,.823,0.542>]
				//[1.0 color rgb <.86,.86,0.67>]
				[1.0 color rgb <.871,.592,0.212>]
					//[1.0 color rgb <0.8,0.8,0.4>]
			}
		turbulence .7
	}
	finish{ 
		diffuse .6 
		ambient .6
	}
}
#declare sandy_wet = texture {
	pigment {
		granite
			color_map {
				[0.0 color rgb <.86,.86,0.67>-.3]
				[0.1 color rgb <.948,.823,0.542>-.3]
				//[1.0 color rgb <.86,.86,0.67>]
				[1.0 color rgb <.871,.592,0.212>-.3]
					//[1.0 color rgb <0.8,0.8,0.4>]
			}
		turbulence .7
	}
	finish{ 
		Shiny
		//diffuse .6 
		//ambient .4
	}
}

#declare watery= texture {
	pigment{ color rgbf<.7, .8, .8, .8> }
}

/** fish textures **/
//1. tex_body
/*
#declare tex_body = texture {
	//pigment{ color Orange }
	pigment{ scales  }
}
*/
//2. tex_tail
#declare tex_tail = texture {
	pigment{ color Orange }
}
//3. tex_lips
#declare tex_lips = texture {
	pigment{ color Orange }
}
//4. tex_eyes
#declare er = 0.275;
#declare tex_eyes = texture {
	pigment {
		image_map {
			png "eye.PNG"
			map_type 2
			once
		}
		rotate y*(180+50)
		scale <1,er*2,1>
		translate <0, -er, 0>
		
		//translate y*.8
	}	
}
//5. tex_brows
#declare tex_brows = texture {
	pigment{ color Orange }
}
//6. tex_arms
#declare tex_arms = texture {
	pigment{ color Orange }
}
//7. tex_dorsal
#declare tex_dorsal = texture {
	pigment{ color Orange }
}


/* end Textures */

// switches
#declare no_shoe=1;
//#declare no_fish=1;
//#declare no_spout=1;
//#declare no_bowl=1;

// the planet
#declare planet_r = 30;
#declare planet_t = -1;

//sphere {
	//<0,-planet_r,0>, planet_r
difference {
	cylinder{ <-30, -planet_r, 0>, <30,-planet_r,0>, planet_r
	translate y*planet_t
	}
	sphere{x,1.25}
	texture{ 
		sandy
		scale .2
	}
	normal{ gradient <1,0,0>, 1 sine_wave }

}
plane { y, 0
	texture{ 
		sandy
		scale .2
	}
	normal{ gradient <1,0,1>, 1 sine_wave }
	translate y*-planet_r
	finish{ ambient .6 }
}


box{ <-1000, 0, 125>, <1000, 5, 125> 
	pigment {
		gradient y
		color_map{
			//[0 color rgbf<1,1,1,0>]
			[0 color rgbt<.871,.592,0.212,.333>]
			[1 color rgbt<1,1,1,1>]
		}
		scale y*5
		//translate y*-2.5
	}
	translate y*-.5

} 


#declare pill = 
superellipsoid { <1, .635 >
	scale <1,1,.428>
}

#declare pills = 
union{ 
	object{ pill scale .2 translate <0,.25,0> }
	object{ pill scale .2 translate <0,-.25,0> }
}

#declare strip =
union {
	difference {
		box{0,<2.5, 1, .05> translate <-1.25,-.5,0>}
		sphere {<-1,.25,0>, .2}
	}
	difference {
		sphere {<-1,.25,0>, .2}
		sphere {<-1,.25,0>, .19}
		box{ 0, <-4,2,-2> 
		scale z*.5
	}

	}
	//object{ pills translate x*-1 }
	object{ pill scale .2 translate <-1,-.25,0> }
	object{ pills translate x*-.5 }
	object{ pills translate x*0 }
	object{ pills translate x*.5 }
	object{ pills translate x*1 }
}

#declare pill_box =
difference {
	box{ 0,1
		pigment{
			image_map {
				png "hydrol.png"
				once
			}
		}
		scale <5.77/3, 3.06/3+.1, .2>
		translate <-5.77/3/2, -3.06/3/2, 0>
	}
	/*
	box{ 0,1
		scale <(5.77/3)*1.1, (3.06/3)*.9, .2*.9>
		translate <-5.77/3/2, -3.06/3/2, 0>
	}
	*/
}

union {
	object{ pill_box
		pigment { White }
		/*
		rotate x*90
		rotate <0,30,-10>
		scale .3
		translate <1.2,-1,-2>
		*/
		//scale 1.3
		translate <.6,0,-.1>
	}

	object{ strip
		pigment { White }
	}
	rotate x*90
	rotate y*10
	rotate x*-30
	scale .4
	translate <1.4,-1,-2.4>
	finish{Shiny}
}
	
// end planet

#ifndef (no_sign)
#declare sign = object {
box{ 0, 1
	pigment{
		image_map{
			png "sign.PNG"
			once
		}
	}
	scale <2.5,1,.05>
	scale .5
	rotate x*15
	translate <-2.5*.5/2,-1,-1.26>
	rotate y*30
}
}
#end

#ifndef (no_bowl)
// the bowl 
// texture for the top of the water
#declare w_top = texture {
	pigment { color rgbt<1,1,1,1> }
	normal{ ripples 1 scale .4 }
}



#include "bowl.inc"
// the bowl

#declare all_bowl = union {
object {
	bowl
	/*
	pigment{ Green }
	*/
	pigment{ color rgbt<1,1,1, .9> }
	interior { ior 1.5 }

	finish{ Shiny }
	scale 1.25
}

difference {
	object {
		water
		/*
		pigment { Red }
		*/

		pigment{ color rgbt<.7,.7,.8,.8> }
		interior { ior 1.3 }
		finish{ Shiny }
		scale 1.249
	}
	// the eyes! the eyes!
	sphere{ 0, .275 
		//pigment { color White}
		texture{tex_eyes}
		translate <.5, 1.1, -.4>
		scale .355
		rotate (y*90)+(y*-30)
		translate y*-.5
		translate x*.2
	}
	sphere{ 0, .275 
		//pigment { color White}
		texture{tex_eyes}
		//rotate y*-10
		translate <.5, 1.1, .4>
		scale .355
		rotate (y*90)+(y*-30)
		translate y*-.5
		translate x*.2
	}
}
object {
	grit
	pigment{ color rgb< .7, 0, 0 > }
	normal{ bumps 1 scale .05 }
	scale 1.25
}
}
#end

#ifndef (no_spout)
#include "spout.inc"
#declare spout = object {
	w_spout
	//pigment {Red}
	rotate x*-1
}
#end

/********/
/* fish */
/********/

#ifndef (no_fish)

#declare tex_body = texture {
	pigment {
		image_map {
			png "scales3.PNG"
			map_type 0
		}
		scale .4
	}
	normal {
		bump_map {
			png "scalesob.png"
			map_type 0
			bump_size .2
			use_color
		}
		scale .4
	}
}

// gun
#declare gun =
union {
	cylinder{ 0, y*1.5, .66 
		scale z*.5
		rotate z*-10
	}
	box{ <-.66-.1, 1.5, 1.5*.5>, <4*.66, 2.5, -1.5*.5> }
	cylinder{ <4*.66, 2.25, 0 >, <8*.66, 2.25, 0>, .2 }

	difference {
		torus{ .66+.3, .3 }
		box{ <0,-1,-2>, <.7,1,2> }
		translate y*(1.5-.3)
		pigment { Orange }
	}
	translate x*-1
}

#include "fish1.inc"
#declare the_fish = union {
union {
	object {
		fish
	}
	sphere{ 0, .275 
		//pigment { color White}
		texture{tex_eyes}
		translate <.5, 1.1, -.4>
	}
	sphere{ 0, .275 
		//pigment { color White }
		texture{tex_eyes}
		rotate y*5
		translate <.5, 1.1, .4>
	}
		scale .35
		rotate (y*90)+(y*-30)
		translate y*-.5
		translate x*.2
}
//sphere{ 0,1 texture{ tex_eyes } }

object{ gun 
	texture { T_Chrome_1A }
	rotate <0,29,60>
	scale .05
	translate <.5,-.1,-.1>
	translate x*.2
}
}
// end gun & fish

#end
//stuff
union {
	object{ spout }
	object{ all_bowl }
	object{ the_fish }
	object{ sign }
	translate x*1
}

/****
shoe
****/

#ifndef (no_shoe)

#declare shoe_top = texture {
	pigment {color rgb<.592,.412,.11> }
}
#declare shoe_tongue = texture {
	pigment {color Brown }
}
#declare shoe_base = texture {
	pigment {color rgb<.404,.281,.075> }
}

#declare skin = texture {
	pigment{ color rgb <.737,.612,.471> }
}
#declare hair = texture {
	pigment{
		gradient y
		color_map {
			[0.0 0.1	color Gray50 color Gray50]
			[0.1 1.0	color rgbt <1,1,1,1>  color rgbt<1,1,1,1>]
		}
		scale .1
		turbulence 10
	}
}

#include "shoe.inc"

object {
	shoe
	scale z*.6
	pigment {color Red }
	rotate <0,-140,0>
	translate <-1.7,-.4,-1>
}

#end

#include "foot1.inc"
union {
object {
	foot
	pigment{ color rgb <.737,.612,.471> }
}
object {
	bit
	pigment{ rgb <.5, 1, .5> }
}
object {
	thong
	pigment{ rgb <.5, 1, .5> }
}
object {
	strap
	pigment{ White }
}
object {
	nails
	pigment{ rgbf<1,1,1,.4> }
	finish{ Shiny }
}
	rotate z*90
	rotate y*90
	rotate <0,-140,0>
	translate <-1.7,-.7,-1>
}


// puddle
sphere { 0, .05
	scale x*1.7 + y*.05
	translate <0,-1.14,-3>
	rotate y*15
	pigment { color rgbt <.3,0,0,.4> }
	finish{ Shiny }
}
sphere { 0, .1
	scale x*1.7 + y*.05
	translate <0,-1.14,-3>
	rotate y*5
	pigment { color rgbt <.3,0,0,.4> }
	finish{ Shiny }
}
sphere { 0, .3
	scale x*1.7 + y*.05
	translate <0,-1.15,-3.2>
	rotate y*30
	pigment { color rgbt <.3,0,0,.4> }
	finish{ Shiny }
}


//cactus
/*
#include "cactus.inc"
union {
	object{ cactus
		translate <15,0,40>
	}
	object{ cactus
		translate <5,0,50>
	}
	object{ cactus
		translate <-20,0,40>
	}
	object{ cactus
		translate <-5,0,40>
	}
	/*
	object{ cactus
		translate <3,0,0>
	}
	*/
	translate y*-1
		pigment{ color rgb<0,.4,0> }
}
*/


