#include "colors.inc"
#include "stones.inc"
#include "goldfish_textures.inc"

#include "G1_anal.inc"
#include "G1_body.inc"
#include "G1_dorsal.inc"
#include "G1_pectoral.inc"
#include "G1_pelvic.inc"

#include "hyacinth.pov"

global_settings {max_trace_level 5
ambient_light 1
}

//camera {location <3, 0, -1> look_at <0, 0, -1> angle 40}

//camera {location <0, 2, -1> look_at <0, 0, -1>}

camera {location <15, 10, -15>
look_at <1, 3, .5>
focal_point <1, 1, .5>
aperture .4
blur_samples 100
confidence .95
variance 1/1000
angle 30}

//camera {location <0, 3, 1.7> look_at 1.7*z angle 50}

//camera {location <0, 3, .5> look_at .5*z angle 90 up 1*z right 1*x}

light_source {<0, 0, -930000> color rgb <1.5, 1.5, 1.2>
//area_light <4000, 0, 0>, <0, 4000, 0>, 3, 3
//rotate <50, -70, 0>
rotate <55, 10, 0>
}

background {color 0.7*White}

sky_sphere {
pigment {
gradient y
color_map {
[0 color rgb <.91,.91,.9>]
[1 color rgb <0.6, 0.6, 1>]
}
}

pigment {
bozo
turbulence .4
omega .7
color_map {
[0 color rgbt <.6,.6,.6,1>]
[.5 color rgbt <.6,.6,.6,.6>]
[1 color rgbt <.6,.6,.6,.2>]
}
}

}


#declare Temp =
texture {
pigment {color White}
finish {diffuse .8 ambient 1}
}

#declare Body_texture =
texture {
pigment {
image_map {
tga "body.tga"
map_type 2
once
}
rotate -90*x
scale 2.5
translate 1.15*z
rotate -90*z
}
finish {diffuse .8 phong .3 phong_size 2 specular .6 roughness .005 metallic}
normal {
bump_map {
gif "scales.gif"
map_type 2
interpolate 4
once
bump_size -2
}
rotate -90*x
scale 2.5
translate 1.15*z
rotate -90*z
}
}

#declare Tail_texture =
texture {
pigment {
image_map {
tga "tail.tga"
once
}
translate <-.5, -.5, 0>
rotate 90*x
scale <2.5, 2.2, 2.2>
translate 1.75*z
}
finish {diffuse .9 }

normal {
bump_map {
tga "tail_bump.tga"
once
bump_size 1
}
translate <-.5, -.5, 0>
rotate 90*x
scale <2.5, 2.2, 2.2>
translate 1.75*z
}

}

#declare Tail_and_body =
material {
texture {Tail_texture }
texture {Body_texture }

interior { //needed because default is 1
ior 1.33
}

}

#declare Dorsal_texture =
material {
texture {
pigment {
image_map {
tga "dorsal.tga"
interpolate 2
}
rotate -90*y
scale 1.3
translate <0, .15, -.05>
}
finish {diffuse .8}
}

interior { //needed because default is 1
ior 1.33
}

}

#declare Anal_texture =
material {

texture {
pigment {
image_map {
tga "anal.tga"
interpolate 2
once
}
rotate -90*y
scale .6
translate <0, -.4, .7>
}
finish {diffuse .8}
}

interior { //needed because default is 1
ior 1.33
}

}


#declare Pelvic_texture =
material {
texture {
pigment {
image_map {
tga "pelvic.tga"
interpolate 2
once
}
rotate -90*y
scale .6
translate <0, -1, 0>
}
finish {diffuse .8 }
}

interior { //needed because default is 1
ior 1.33
}

}

#declare Pectoral_texture =
material {
texture {
pigment {
image_map {
tga "pectoral.tga"
interpolate 2
once
}
rotate -90*y
scale .6
translate <0, -.8, -.4>
}
finish {diffuse .8}
}

interior { //needed because default is 1
ior 1.33
}

}

#declare Goldfish =

union {

object {Body
material {Tail_and_body}
}

object {Anal_fin
material {Anal_texture}
}

object {Dorsal_fin
material {Dorsal_texture}
}

object {Pectoral_fin
material {Pectoral_texture}
}

object {Pelvic_fin
material {Pelvic_texture}
}

//left eye
/*
sphere {<.25, .025, -.75>, .125
pigment {color rgb <0, 0, 0>}
finish {phong 1}
}
*/

sphere {<0, 0, 0>, .12
scale <1, .5, 1>
rotate <-70, -60, 0>
translate <.245, .075, -.780>
pigment {color rgb <0, 0, 0>}
finish {phong 1}
}


torus {.085, .035
pigment {
radial
turbulence .05
color_map {
[0 .2  color 0.2*<.8, .498, .196> color rgb .3+<.8, .498, .196>]
[.5 .8 color rgb .3+<.8, .498, .196> color 0.2*<.8, .498, .196> ]
}
frequency 2
}
finish {diffuse .6 phong 1 phong_size 10 metallic}
normal {granite .1 scale .05}
rotate <-70, -60, 0>
translate <.27, .077, -.780>
}

//right eye

/*
sphere {<-.2, .1, -.75>, .125
pigment {color rgb <0, 0, 0>}
finish {phong 1}
}
*/

sphere {<0, 0, 0>, .12
scale <1, .5, 1>
rotate <-70, 60, 0>
translate <-.245, .075, -.780>
pigment {color rgb <0, 0, 0>}
finish {phong 1}
}

torus {.085, .035
pigment {
radial
turbulence .05
color_map {
[0 .2  color 0.2*<.8, .498, .196> color rgb .3+<.8, .498, .196>]
[.5 .8 color rgb .3+<.8, .498, .196> color 0.2*<.8, .498, .196> ]
}
frequency 2
}
finish {diffuse .6 phong 1 phong_size 10 metallic}
normal {granite .1 scale .05}
rotate <-70, 60, 0>
translate <-.27, .077, -.780>
}

}



union {

object {water_hyacinth
texture {Hyacinth_texture}
}

#include "stem.inc"

object {stem
pigment {color rgb <.6, .8, .5>}
finish {diffuse .7}
}

#include "flower2.inc"

#declare new_flower =
union {
object {flower}
cylinder {<0, 3.3, -.5>, <0, 3.2, -1.3>, .01
pigment {color rgbt <1, 1, 1, .4>}
finish {diffuse .7 ambient .3}
}
sphere {<0, 3.2, -1.3>, .012
pigment {color rgbt <.6, .6, .6, .4>}
finish {diffuse .7 ambient .3}
}
}

/*
#declare R1 = seed (2343);

#declare change = 0;
#declare change2 = 0;
#while (change < 13)

object {new_flower
pigment {
image_map {
tga "flower.tga"
}
translate <-.5, -.5, 0>
}
finish {diffuse .8 ambient .2}
scale 1.5
translate <0, 2, .5>
rotate (90+rand(R1)*5) *change*y
translate change2*2*y
translate -.7*z
}

#declare change2 = change2 + 1/12;
#declare change = change + 1;
#end
*/

#declare change = 0;
#while (change < 360)

object {new_flower
pigment {
image_map {
tga "flower2.tga"
interpolate 4
once
}
translate <-.5, -.5, 0>
scale 2
translate <0, 3.27, 0>
}
finish {diffuse 1 ambient <.3, .2, .3>}
rotate (60+change)*y
}

object {new_flower
pigment {
image_map {
tga "flower2.tga"
interpolate 4
once
}
translate <-.5, -.5, 0>
scale 2
translate <0, 3.27, 0>
}
finish {diffuse 1 ambient <.3, .2, .3>}
translate -3.3*y
rotate 20*x
translate <0, 3, .1>

translate 1*y
rotate change*y
}

#declare change = change + 120;
#end


translate <-3.2, 1.7, -.8>
}



//foreground plant

union {

object {water_hyacinth
texture {Hyacinth_texture}
}

#include "stem.inc"

object {stem
pigment {color rgb <.6, .8, .5>}
finish {diffuse .7}
}

#include "flower2.inc"

#declare new_flower =
union {
object {flower}
cylinder {<0, 3.3, -.5>, <0, 3.2, -1.3>, .01
pigment {color rgbt <1, 1, 1, .4>}
finish {diffuse .7 ambient .3}
}
sphere {<0, 3.2, -1.3>, .012
pigment {color rgbt <.6, .6, .6, .4>}
finish {diffuse .7 ambient .3}
}
}

#declare change = 0;
#while (change < 360)

object {new_flower
pigment {
image_map {
tga "flower2.tga"
interpolate 4
once
}
translate <-.5, -.5, 0>
scale 2
translate <0, 3.27, 0>
}
finish {diffuse 1 ambient <.3, .2, .3>}
rotate (60+change)*y
}

object {new_flower
pigment {
image_map {
tga "flower2.tga"
interpolate 4
once
}
translate <-.5, -.5, 0>
scale 2
translate <0, 3.27, 0>
}
finish {diffuse 1 ambient <.3, .2, .3>}
translate -3.3*y
rotate 20*x
translate <0, 3, .1>

translate 1*y
rotate change*y
}

#declare change = change + 120;
#end

rotate 225*y
translate <5.5, 1.7, 1>
}



/*
object {water_hyacinth
texture {Hyacinth_texture}

rotate 45*y
translate <-1, 1.7, 12>
}
*/

/*
object {water_hyacinth
pigment {color rgbf <.6, .8, .5, 0>}
finish {diffuse .7 phong .3 phong_size 10}
//rotate 70*y
translate <2, 2, 2>
}
*/


#include "hyacinth_mesh.inc"

/*
object {hyacinth_mesh
pigment {color rgbf <.6, .8, .5, .2>}
finish {diffuse .7 phong .3 phong_size 10}
rotate 70*y
translate <-1, 1.7, 12>
}
*/

object {hyacinth_mesh
pigment {color rgb <.6, .8, .5>}
finish {diffuse .7 phong .3 phong_size 10}
rotate 158*y
translate <-4, 1.7, 6>
}

/*
object {hyacinth_mesh
pigment {color rgb <.6, .8, .5>}
finish {diffuse .7 phong .3 phong_size 10}
rotate 35*y
translate <2.5, 1.7, 8>
}

object {hyacinth_mesh
pigment {color rgb <.7, .8, .5>}
finish {diffuse .7 phong .3 phong_size 10}
rotate -45*y
translate <-2, 1.7, 8>
}

*/

//-----Aqua Tints
#declare T_Grnt8a =
texture {
pigment
 {granite
 turbulence 0.4
 omega .5
 lambda 7
  color_map
   {[0.000, 0.119   color rgbf <0.310, 0.384, 0.420, 0.631>
                    color rgbf <0.322, 0.369, 0.416, 0.847>]
    [0.119, 0.322   color rgbf <0.322, 0.369, 0.416, 0.847>
                    color rgbf <0.424, 0.369, 0.420, 0.549>]
    [0.33, 0.449   color rgbf <0.424, 0.369, 0.420, 0.549>
                    color rgbf <0.373, 0.424, 0.518, 0.965>]
    [0.45, 0.729   color rgbf <0.373, 0.424, 0.518, 0.965>
                    color rgbf <0.482, 0.573, 0.533, 0.741>]
    [0.73, 1.001   color rgbf <0.482, 0.573, 0.533, 0.741>
                    color rgbf <0.310, 0.384, 0.420, 0.631>]
   }
 }
 }

//--------- Light Grays
#declare T_Grnt24 =
texture {
pigment
 {marble
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.894, 0.886, 0.886, 0.000>
                    color rgbf <0.745, 0.745, 0.753, 0.000>]
    [0.154, 0.308   color rgbf <0.745, 0.745, 0.753, 0.000>
                    color rgbf <0.902, 0.902, 0.859, 0.000>]
    [0.308, 0.444   color rgbf <0.902, 0.902, 0.859, 0.000>
                    color rgbf <0.729, 0.706, 0.694, 0.000>]
    [0.444, 0.615   color rgbf <0.729, 0.706, 0.694, 0.000>
                    color rgbf <0.588, 0.592, 0.635, 0.000>]
    [0.615, 0.803   color rgbf <0.588, 0.592, 0.635, 0.000>
                    color rgbf <0.608, 0.616, 0.659, 0.000>]
    [0.803, 1.001   color rgbf <0.608, 0.616, 0.659, 0.000>
                    color rgbf <0.894, 0.886, 0.886, 0.000>]
   }
 }
 }


#declare New_stone =
texture {
T_Grnt24
scale <2, 5, 2> rotate <0, 0, 50>
finish { ambient 0.2 crand 0.03}
}
texture {
T_Grnt8a
scale <1, 3, 2> rotate <0, 0, -30>
normal {granite .3 scale .05}
}



//rocky bottom

height_field {
gif "rocks.gif"
smooth
translate <-.5, 0, -.5>
scale <30, 2.5, 30>
rotate <20, 0, 20> //make water deeper
translate -2.8*y
texture {
pigment {color 0.6*White}
}

texture {
pigment {
bozo
turbulence .7
omega .4
lambda 7
color_map {
[0 .5 color rgbt <1, 1, 1, 1> color rgbt <1, 1, 1, 1>]
[.7 .9 color rgbft <.2, .3, .25, .2, .2> color rgbft <.2, .35, .25, .2, .2>]
}
scale .8
}
finish {diffuse .7 crand .05 phong .2 phong_size 30}
normal {granite .3 scale .05}
}

}

plane {y, 0
pigment {color rgb <.6, .56, .53>}
finish { diffuse .7 phong .3 phong_size 20}
normal {
bump_map {
gif "rocks.gif"
interpolate 4
bump_size 15
}
translate <-.5, -.5, 0>
rotate 90*x
scale 30
}
rotate <20, 0, 20> //make water deeper
translate -2.5*y

}


union {
#include "rock1.inc"

object {rock1
rotate 45*y
translate <1.5, -2.5, 2>
texture {New_stone}
}

object {rock1
rotate 130*y
translate <5, -2.5, 0>
texture {New_stone}
}

#include "rock2.inc"

object {rock2
texture {New_stone}
rotate 20*y
translate <-1, -2.5, -1>
}

object {rock2
texture {New_stone}
rotate 100*y
scale <3, 3.5, 3>
translate <-1, -2.5, 7>
}

#include "rock3.inc"

object {rock3
texture {New_stone}
translate <-2, -2.5, 2>
}

#include "rock4.inc"

object {rock4
texture {New_stone}
scale 1.5
translate <-4, -2.9, 2>
}

#include "rock5.inc"

object {rock5
texture {New_stone}
translate <1.5, -2.5, -2>
}

object {rock5
texture {New_stone scale .9 rotate 45}
scale 1.7
rotate 120*y
translate <-4.1, -2.5, -3.2>
}

translate 2.5*y
rotate <20, 0, 20>
translate -2.5*y
}




plane {y, 2
pigment {color rgbf <1, 1, 1, 1>}
finish {phong .2 phong_size 40
reflection_min .04 reflection_max .97 reflection_falloff 2

}
/*
normal {
average
normal_map {
[1 gradient x .2 sine_wave scale 2.5 turbulence .2 rotate 50*y translate <-100, 0, -100>]
[1 ripples .05 scale 1000 frequency 3000 turbulence .05]
}
*/
normal {
average
normal_map {
[1 gradient x .4 sine_wave scale 2.5 turbulence .2 rotate 50*y translate <-100, 0, -100>]
[1 waves 0.05 frequency 5000 scale 3000]
}


}
interior {
ior 1.33

media {
absorption <.064, .068, .07>
samples 2, 5
}

}
hollow
}





//object {Goldfish translate <.2, 0, -1>}

#include "goldfish2.inc"

object {Goldfish2 scale .8 rotate -120*y translate <1.5, 0, -3>}

#include "goldfish3.inc"

object {Goldfish3 scale 1 rotate -80*y translate <0, 0, 1>}


object {Goldfish scale .8 rotate 0*y translate <3.2, 0, -.1>}




//fake plane for caustics
plane {y, 1.99
pigment {color rgbt <1, 1, 1, 1>}
finish {ambient 0 phong 0 diffuse 0}
normal {
average
normal_map {
[1 bumps 1.5 scale <1, 1, 5> translate .5*x rotate 50*y turbulence .1]
[1 bumps .7 scale 3 turbulence 1]
}
}
interior {ior 1.33 caustics .5
media {
absorption <.064, .068, .07>
samples 2, 5
}
}
hollow
}


//camera {location <0, -1, -5> look_at <0, -2, 0>}

/*
height_field {
pgm "terrain.pgm"
translate <-.5, -.1, -.5>
scale <10, 30, 200>
pigment {
gradient y
turbulence 1
omega .7
lambda 4
color_map {
[0 color rgb <.3, .4, .35>]
[1 color rgb <.1, .2, .12>]
}
scale <10, 10, .5>
}
finish {phong 0 phong_size 1 metallic}
normal {granite .3 scale <3, 10, 3>}
rotate 50*y
translate <-80, 0, 80>
}
*/



#include "leaf.inc"


#declare Water_lily = union {

#declare lily_leaf =
object {leaf

pigment {
image_map {
tga "leaf.tga"
interpolate 4
once
}
translate <-.5, -.5, 0>
rotate 90*x
translate <0, 0, .05>
scale 1.5
}
finish {diffuse 1 phong .2 phong_size .1}
normal {
bump_map {
gif "leaf.gif"
interpolate 4
bump_size 1
once
}
translate <-.5, -.5, 0>
rotate 90*x
translate <0, 0, .05>
scale 1.5
}

scale 2

}

#declare R1 = seed (5345);
#declare R2 = seed (82712);
#declare R3 = seed (6873);

#declare make_plant = 0;
#while (make_plant < 9)
#declare Trans = (2+(rand(R2)*4));
#declare Rot = (rand(R3)*360);

object {lily_leaf
scale 1+(rand(R1)*1.2)
translate 2.001*y
translate Trans*z
rotate Rot*y
}
//stems
cone {vrotate (<0, 1.95, Trans>, <0, Rot, 0>), .02, vrotate (<0, -2, .2>, <0, Rot, 0>), .03
pigment {
gradient y
color_map {
[0 color rgb <.35, .15, .15>]
[1 color rgb <.4, .45, .34>]
}
scale 2.5
}
finish {diffuse .7}
}
#declare make_plant = make_plant + 1;
#end

//unopen flower
cone {<0, -2, 0>, .03, <-1, 2.2, -1>, .02
pigment {color rgb <.35, .15, .15>}
finish {diffuse .7}
}

lathe{
	cubic_spline
	13,
	<0.000000,1.005196>,
	<0.000000,1.000477>,
	<0.037754,0.991038>,
	<0.099104,0.920250>,
	<0.181690,0.717323>,
	<0.221804,0.471923>,
	<0.235961,0.266636>,
	<0.212365,0.139217>,
	<0.143936,0.056631>,
	<0.075508,0.018877>,
	<0.033035,0.004719>,
	<0.000000,0.000000>,
	<0.004719,-0.084946>

    pigment {
    image_map {
    tga "leaf.tga"
    map_type 2
    interpolate 4
    }
    }
    scale 1
    translate <-1, 2.2, -1>

}


//open flower

cone {<0, -2, 0>, .04, <1, 3, 0>, .03
pigment {color rgb <.35, .15, .15>}
finish {diffuse .7}
}

#include "sepal.inc"

#include "petal.inc"

#declare change = 0;
#while (change < 360)
object {sepal
pigment {color rgb .8*<1, .4, 1>}
finish {diffuse .7 ambient <.4, .2, .4>}
rotate -4*x
rotate (60+change)*y
translate <1, 3, 0>
}

object {petal
pigment {color rgb <1, .4, 1>}
finish {diffuse .7 ambient <.4, .2, .4>}
rotate -5*x
translate 0*y
rotate change*y
translate <1, 3, 0>
}

#declare change = change + 120;
#end

#declare change2 = 0;
#while (change2 < 360)
object {petal
pigment {
gradient z
color_map {
[0 color rgb <1, .6, 1>]
[1 color rgb <1, .3, 1>]
}
scale 1.5
}
finish {diffuse .7 ambient <.4, .2, .4>}
rotate -25*x
translate <0, 0, .2>
rotate (30+change2)*y
translate <1, 3, 0>
}

object {petal
pigment {
gradient z
color_map {
[0 color rgb <1, .6, 1>]
[1 color rgb <1, .4, 1>]
}
scale 1.5
}
finish {diffuse .7 ambient <.4, .2, .4>}
rotate -30*x
translate .01*y
rotate change2*y
translate <1, 3, 0>
}

#declare change2 = change2 +60;
#end

//center
difference {
cone {<0, 0, 0>, .15, <0, .25, 0>, .2}
sphere {<0, .5, 0>, .35}
pigment {color rgb <1, .9, .4>}
finish {diffuse .8 ambient <.4, .39, .2>}
translate <1, 3, 0>
}

#declare change3 = 0;
#while (change3 < 360)
union {
cone {<0, .24, .2>, .03, <0, .5, .25>, .025}
sphere {<0, .5, .25>, .025}
pigment {
gradient y
color_map {
[0 color rgb <1, .9, .4>]
[.2 color rgb <1, .9, .4>]
[.25 color rgb <1, .5, 1>]
[.8 color rgb <1, .5, 1>]
[.9 color rgb <1, .9, 1>]
[1 color rgb <1, .9, 1>]
}
scale .25
translate .24*y
}
finish {diffuse .7}
scale <1, .7, 1>
rotate change3*y
translate <1, 3, 0>
}
#declare change3 = change3 + 15;
#end

}

object {Water_lily translate <-9, 0, 5>}
object {Water_lily rotate 173*y translate <-8, 0, 20>}
object {Water_lily rotate 90*y translate <-25, 0, 15>}

//camera {location <0, 30, 0> look_at <0, 0, 0>}
