// +A0.15 +AM2 +R3 +QR +W800 +H445

camera {
    location <0,10,-21>
    right x
    up (.55625)*y
    look_at <0,4.5,0>
    }



light_source {
    <0,5,0>
    color rgb 1
    shadowless
    }
light_source {
    <-7,0,-3>
    color rgb <0,.6,1>
    shadowless
    }
light_source {
    <7,0,-3>
    color rgb <0,.6,1>
    shadowless
    }


global_settings {
    ambient_light .3
    radiosity {
        brightness 3.3
        count 1200
        distance_maximum 30
        error_bound 0.33
        low_error_factor 0.6
        nearest_count 8
        recursion_limit 2
        }
    }




#declare screwrevolutions = 5;
#declare screwdiameter = 1.5;
#declare screwrevolutionoffset = 1;
#declare screwthickness = .125;
#declare screwsmoothness = 5;
#include "c:\POVRay\myincludes\screw.inc"




#declare scienceballdulltex =
    texture {
        pigment {
            color rgb <1,1,1>
            }
        finish {
            reflection .25
            metallic 1
            }
        }
#declare scienceballambienttex =
    texture {
        pigment {   
            color rgb <1,1,1>
            }
        finish {
            reflection 1
            metallic 1
            ambient <1,1.5,1.7>
            }
        }
#declare scienceballtex =
    texture {
        gradient y
        texture_map {
            [0.0 scienceballdulltex ]
            [0.3 scienceballdulltex ]
            [1.0 scienceballambienttex ]
            }
        }




#declare intervalnumber = 20;
#declare samplenumber1 = 10;
#declare samplenumber2 = 70;
#declare variancenumber = 1.0/128;
#declare confidencenumber = .95;

/*
#declare intervalnumber = 5;
#declare samplenumber1 = 1;
#declare samplenumber2 = 5;
#declare variancenumber = 1.0/128;
#declare confidencenumber = .9;
*/

#declare electricitymedia =
    media {
        intervals intervalnumber
        samples samplenumber1,samplenumber2
        variance variancenumber
        confidence confidencenumber
        emission 1
        density {
            gradient x
            density_map {
                [0.0 color 0]
                [0.3        
                gradient z
                density_map {
                    [0.0 color 0 ]
                    [0.4 color 0 ]
                    [0.5
                        gradient y
                        color_map {
                            [0.0 color rgb 0]
                            [0.3 color rgb 0]
                            [0.4 color rgb <0,.2,.3>]
                            [0.5 color rgb 1]
                            [0.6 color rgb <0,.2,.3>]
                            [0.7 color rgb 0]
                            [1.0 color rgb 0]
                            }
                        ]
                    [0.6 color 0 ]
                    [1.0 color 0 ]
                    }
                turbulence .375
                ]
                [0.7
                gradient z
                density_map {
                    [0.0 color 0 ]
                    [0.4 color 0 ]
                    [0.5
                        gradient y
                        color_map {
                            [0.0 color rgb 0]
                            [0.3 color rgb 0]
                            [0.4 color rgb <0,.2,.3>]
                            [0.5 color rgb 1]
                            [0.6 color rgb <0,.2,.3>]
                            [0.7 color rgb 0]
                            [1.0 color rgb 0]
                            }
                        ]
                    [0.6 color 0 ]
                    [1.0 color 0 ]
                    }
                turbulence .375
                ]
                [1.0 color 0]
                }
            }
        translate <0,.5,.5>
        scale <1,1.75,1.75>
        }
#declare ballelectricity1 =
    media {
        intervals intervalnumber
        samples samplenumber1,samplenumber2
        variance variancenumber
        confidence confidencenumber
        emission 1
        density {
            spherical
            color_map {
                [0.0 color 0]
                [0.15 color 0]
                [0.3 color rgb <0,.2,.3>]
                [0.5 color rgb .5]
                [0.7 color rgb <0,.2,.3>]
                [0.85 color 0]
                [1.0 color 0]
                }
            turbulence .5
            }
        scale .375
        }
#declare ballelectricity2 =
    media {
        intervals intervalnumber
        samples samplenumber1,samplenumber2
        variance variancenumber
        confidence confidencenumber
        emission 1
        density {
            spherical
            color_map {
                [0.0 color 0]
                [0.15 color 0]
                [0.3 color rgb <0,.2,.3>]
                [0.5 color rgb .5]
                [0.7 color rgb <0,.2,.3>]
                [0.85 color 0]
                [1.0 color 0]
                }
            turbulence .35
            }
        scale .375
        }
#declare ballelectricity3 =
    media {
        intervals intervalnumber
        samples samplenumber1,samplenumber2
        variance variancenumber
        confidence confidencenumber
        emission 1
        density {
            spherical
            color_map {
                [0.0 color 0]
                [0.15 color 0]
                [0.3 color rgb <0,.2,.3>]
                [0.5 color rgb .5]
                [0.7 color rgb <0,.2,.3>]
                [0.85 color 0]
                [1.0 color 0]
                }
            turbulence .5
            }
        scale .2
        rotate <50,20,185>
        }

#declare GreenColor = <0,.3,.5>;
#declare GreenHazeScale = 1;
#declare greenhaze1 =
    media {
        intervals intervalnumber
        samples samplenumber1,samplenumber2
        variance variancenumber
        confidence confidencenumber
        emission 1
        density {
            cylindrical
            color_map {
                [0.0 color 0]
                [1 color rgb GreenColor ]
                }
            turbulence .75
            }
        scale GreenHazeScale
        }
#declare greenhaze2 =
    media {
        intervals intervalnumber
        samples samplenumber1,samplenumber2
        variance variancenumber
        confidence confidencenumber
        emission 1
        density {
            cylindrical
            color_map {
                [0.0 color 0]
                [1 color rgb GreenColor ]
                }
            turbulence .85
            }
        scale GreenHazeScale
        }




#declare scienceball =
    sphere {
        <0,0,0>,.75+.125
        }
#declare scienceballstandradius = .8;
#declare scienceballstandheight = 1.1;
#declare scienceballleg =
    union {
        cylinder {
            <0,0,0><1,-1,0>,.1
            translate x*scienceballstandradius
            }
        sphere {
            <1,-1,0>,.1
            translate x*scienceballstandradius
            }
        }
#declare scienceballstand =
    union {
        torus {
            scienceballstandradius,.1
            }
        object {
            scienceballleg
            }
        object {
            scienceballleg
            rotate y*120
            }
        object {
            scienceballleg
            rotate y*-120
            }
        translate y*scienceballstandheight
        }
#declare scienceobject =
    union {
        union {
            object { scienceball }
            object {
                scienceball
                translate y*5
                }            
            cylinder {
                <0,0,0><0,5,0>,.25
                }   
            object {
                screw
                }
            translate y*(scienceballstandheight+.6)
            }
        object {
            scienceballstand
            }
        }





object {
    scienceobject
    translate x*-7
    texture { scienceballtex scale y*7.7}
    }
object {
    scienceobject
    translate x*7
    texture { scienceballtex scale y*7.7}
    }
sphere {
    <0,7.5,0>,1.5
    texture {
        pigment {
            bozo
            color_map {
                [0.0 color rgb <0,.2,.3>]
                [0.5 color rgb 1]
                [1.0 color rgb <0,.2,.3>]
                }
            }
        finish {
            reflection 1
            phong 1
            ambient 1
            }
        }
    }



difference {
union {
sphere {
    <0,0,0>,1
    texture {
        pigment {
            color rgbt 1
            }
        }
    interior {
        media {
            electricitymedia
            }
        }
    scale <8,5,5>
    hollow
    translate <0,6.7,0>
    }
sphere {
    <0,0,0>,1
    texture {
        pigment {
            color rgbt 1
            }
        }
    interior {
        media {
            ballelectricity1
            }
        }
    hollow
    scale 7
    translate <-7,6.7,0>
    }
sphere {
    <0,0,0>,1
    texture {
        pigment {
            color rgbt 1
            }
        }
    interior {
        media {
            ballelectricity2
            }
        }
    hollow
    scale 7
    translate <-7,6.7,0>
    rotate y*180
    }
sphere {
    <0,0,0>,1
    texture {
        pigment {
            color rgbt 1
            }
        }
    interior {
        media {
            ballelectricity3
            }
        }
    hollow
    scale 14
    translate <0,7.5,0>
    }
}
box {
    <-100,0,-100><100,-100,100>
    texture {
        pigment {
            color rgbt <1,1,1,1>
            }
        }
    interior {
        media {
            emission 0
            }
        }
    hollow
    }
}




#declare GreenHazeCylinderScale = <3,1.75,3>;
#declare TranslateDistance = 7.5;
cylinder {
    <0,0,0><0,1,0>,1
    texture {
        pigment {
            color rgbt 1
            }
        }
    interior {
        media {
            greenhaze1
            //scale .5
            }
        }
    hollow
    scale GreenHazeCylinderScale
    translate x*-TranslateDistance
    }
cylinder {
    <0,0,0><0,1,0>,1
    texture {
        pigment {
            color rgbt 1
            }
        }
    interior {
        media {
            greenhaze2
            scale .5
            }
        }
    hollow
    scale 1.5*GreenHazeCylinderScale
    translate x*TranslateDistance
    translate z*-.5
    }