// Persistence of Vision Ray Tracer Scene
// Pov-Ray for windows  3.1

// Carrelag.inc
// Septembre 1998 
// description: suite de box pour fond aquarium
//              texture  dclarer T_PaveBleu  
//                                 T_PaveJaune 
//
//  Martial Rameaux - Martial@Biosys.net ---------------                                 
        
//--------------------------------------------------- 
//-------------- Le carrelage de la piscine -----------  

#declare Pavej= merge { 
                cylinder { <0,0.0,0>,<0,0.4,0>,0.8}
                box { <-1,0.05,-1>,<1,0.2,1> } 
                        texture { T_PaveBleu } 
                    }     
                                                      
   
#declare Paveb=  merge { 
                cylinder { <0,0.0,0>,<0,0.4,0>,0.8}
                box { <-1,0.05,-1>,<1,0.2,1> } 
                         texture { T_PaveJaune }   
                        } 
                            
#declare Offset = 2.1;
                   
#declare Lignep = union {
    object { Pavej }
    object { Paveb translate z*Offset }
    object { Pavej translate z*Offset*2 }
    object { Paveb translate z*Offset*3 }
    object { Pavej translate z*Offset*4 }
    object { Paveb translate z*Offset*5 }
    object { Pavej translate z*Offset*6 }
    object { Paveb translate z*Offset*7 }
    object { Pavej translate z*Offset*8 }
    object { Paveb translate z*Offset*9 }
    object { Pavej translate z*Offset*10 }
    object { Paveb translate -z*Offset }
    object { Pavej translate -z*Offset*2 }
    object { Paveb translate -z*Offset*3 }
    object { Pavej translate -z*Offset*4 }
    object { Paveb translate -z*Offset*5 }
    object { Pavej translate -z*Offset*6 }
        }
 #declare Lignei = union {
    object { Paveb }
    object { Pavej translate z*Offset }
    object { Paveb translate z*Offset*2 }
    object { Pavej translate z*Offset*3 }
    object { Paveb translate z*Offset*4 }
    object { Pavej translate z*Offset*5 }
    object { Paveb translate z*Offset*6 }
    object { Pavej translate z*Offset*7 }
    object { Paveb translate z*Offset*8 }
    object { Pavej translate z*Offset*9 }
    object { Paveb translate z*Offset*10 }
    object { Pavej translate -z*Offset }
    object { Paveb translate -z*Offset*2 }
    object { Pavej translate -z*Offset*3 }
    object { Paveb translate -z*Offset*4 }
    object { Pavej translate -z*Offset*5 }
    object { Paveb translate -z*Offset*6 }
 }   

#declare FondPiscine=
union {      
  object { Lignei }
  object { Lignep  translate  x*Offset   }
  object { Lignei  translate  x*Offset*2 }
  object { Lignep  translate  x*Offset*3 }
  object { Lignei  translate  x*Offset*4 }
  object { Lignep  translate  x*Offset*5 }
  object { Lignei  translate  x*Offset*6 }
  object { Lignep  translate  x*Offset*7 }
  object { Lignep  translate -x*Offset   }
  object { Lignei  translate -x*Offset*2 }
  object { Lignep  translate -x*Offset*3 }
  object { Lignei  translate -x*Offset*4 }
  object { Lignep  translate -x*Offset*5 }
  object { Lignei  translate -x*Offset*6 }
  object { Lignep  translate -x*Offset*7 } 
  object { Lignep  translate -x*Offset*8 } 

  plane { y,-0.05 pigment { color rgb 0.8 } }    // les joints
} 
//..............fin de carrelage 

//object { FondPiscine    translate y*-16 }                