// Persistence of Vision Ray Tracer Scene
// Pov-Ray for windows  3.1
//
// Ist_cold.pov  Martial Rameaux 
// Septembre-Octobre 1998 pour l'IRTC d'octobre 1998
// 
// description : Fichier traceur 
//               Dclaration gnrale
//               Lumires
//               Textures
//               Angle de vue
//
//Cette scene fonctione avec les fichiers include suivant:
//                              carelage.inc, fish.inc, 
//                              eclabous.inc, doigt.inc 
//    
// "mile"---> Martial@Biosys.net        
//  7h43 30
//===============================================     

      
//==========declaration gnrales================
#version 3.1;
#include "colors.inc"
#include "textures.inc"
#include "consts.inc"
#declare Rad_Quality = 5;
#include "rad_def.inc"

global_settings { assumed_gamma  1.0      
                  max_trace_level 12
                  number_of_waves 10     
                  radiosity { distance_maximum 10 } // dpend de la scene 1/3 de la distance}
                  }   
//=======================Dbut de la scene====================
 
//===========================Lumire==========================
                 
light_source { 0*x color rgb <1,1,1> translate <0,100,50> media_attenuation on } // shadowless fade_distance 50 fade_power 1 

light_source { 0*x color rgb <1,0,0> translate < 20,100,-50> media_interaction off   } // shadowless fade_distance 50 fade_power 1 
light_source { 0*x color rgb <0,0,1> translate <  0,100,-50> media_interaction off   } // shadowless fade_distance 50 fade_power 1 
light_source { 0*x color rgb <0,1,1> translate <-20,100,-50> media_interaction off  } // shadowless fade_distance 50 fade_power 1 

//-----Eaux troubles----------------
media {
  intervals 5
  emission rgb 0.001 //  absorption 0.02
  scattering  { 1, rgb 0.01 }
  samples 1,1         
  confidence 0.9999
  variance 1/1000   // variance 1/1000
  ratio 0.9
}  


//=================Textures===========

//-----------------Finitions----------

#declare F_Eau          = finish { ambient 0.2 diffuse 0.3 phong 1 phong_size 10  }
#declare F_Eclabous     = finish { ambient 0.2 diffuse 0.3 phong 1}   
#declare F_Toutbillon   = finish { ambient 0.2 diffuse 0.3   } 

#declare F_doigt        = finish { ambient 0.2 diffuse 0.7 crand 0.01}  //  phong 0.0008
#declare F_ongle        = finish { ambient 0.5 diffuse 0.7 phong 1 } 

#declare F_PaveBleu     = finish { ambient 0.3 diffuse 0.4 phong 0.3} 
#declare F_PaveJaune    = finish { ambient 0.3 diffuse 0.4 phong 0.3}  

//-----------------Ior 

#declare I_Eau          = interior {ior 1.01 caustics 1}   // media {Flamme}fade_distance 50 fade_power 1 
#declare I_Eclabous     = interior {ior 1.33 caustics 1 }
//=======================================   


#declare P_Eau= pigment { color rgbf <0.9,0.9,1,0.9> }     

//--------------Tourbillon material
#declare T_Tourbillon= material {
                                texture {
                                        pigment  { color rgbf <0.8,0.8,1,0.75>}
                                        normal    {   ripples 2 }
                                        finish    {   F_Toutbillon   }
                                }					
}
//--------------Eau material
#declare T_Eau=  material {
                         texture {
                                  pigment { P_Eau }
                                  normal { waves normal_map 
                                    {
                                    [0 ripples 2  scale <2,.2,1>]
                                    [1 waves 2 ] 
                                   }  
                                 }
                                 finish { F_Eau }
                                 } 
                        interior { I_Eau }
} 
//-------------Remous material
#declare T_Remous= material
                 {texture 
                { 
                 pigment
                {   bozo 
                    turbulence 0.6
                    octaves 6
                    lambda 2.0  
                    omega 0.6
                    frequency 2    
                    color_map  {    [0.0, 0.2  color rgbf <1,1,1,0> color Clear ]  
                                    [0.3, 0.4  color rgbf <1,1,1,0> color Clear  ]
                                    [0.5, 0.6 color rgbf <1,1,1,0> color Clear] 
                                    [0.7, 0.8 color rgbf <1,1,1,0> color Clear]
                                    [1.0,1.0001 color rgbf <1,1,1,1> color Clear] 
                    } 
                    }
                finish { diffuse 0.7 ambient 0.0  }   
                } 
               }
                
//--------------Eclaboussure material
#declare T_Eclabous= material {   
                        texture {
                                  pigment { P_Eau  }   
                                  finish  { F_Eclabous }
                          }
                         interior { I_Eclabous }                          
}                                       
          
//------------------------Rond dans l'eau                     
#declare T_Rondeau= material 
                         {  
                          texture 
                              { 
                               pigment { P_Eau }
                               normal { ripples 2 frequency 0.9 scale 0.5}    
                                 finish { ambient 0.2 diffuse 0.3 phong 1 phong_size 10  }       
                                 scale 0.5  }    
                              interior {ior 1.33 caustics 1}        
                              }             
                                         
                                  
//--------------Ongles texture
#declare T_ongle     = texture  { 
                                pigment { color rgb <1,0.9,0.9> } 
                                finish { F_ongle  }
}
//--------------Doigts texture  
//#include "texturedoigt.inc"
#declare T_Doigts = texture  
                    {
          pigment
                {   crackle
                    pigment_map  {  [0.0 color rgb <0.96,0.80,0.69> ]  
                                    [0.3 color rgb <0.96,0.86,0.75> ] 
                                    [0.6 color rgb <0.96,0.80,0.69> ] 
                                    [1.0 color rgb <0.96,0.80,0.53> ]
                    } 
                }   
                
normal   { wrinkles 0.2 } 
finish  { F_doigt   }
                    }  
                    
      
                                                            
//-----------------Pav de la piscine                     
#declare T_PaveBleu=  texture {  pigment { color rgb <0.0,0.0,0.7> }           //color rgb <0,0,0.7> } 
                                    normal { granite 0.5 }   
                                    normal{ bumps 0.5 }  
                                    finish {F_PaveBleu }       
} 

#declare T_PaveJaune=  texture {     pigment { color rgb <1.0,1.0,0.2>}    // color rgb <0.8,0.8,0.1>} 
                                        normal { granite 0.5 }  
                                        normal{ bumps 0.5 }
                                        finish {F_PaveJaune }          
} 
//------fish textures----- 
#declare T_Qfish=  texture {
                               pigment { wood frequency 6
                                pigment_map {
                                                [0.0 color rgb <1,0.5,0>]
                                                [0.5 color rgb <0.2,0.2,0>]
                                                [0.8 color rgb <0,0,0.5> ]
                                                [1.0 color rgb <0,1,1> ]
                                }
                         rotate x*180    
                          translate x*0.5     }   
                           }    
                               
#declare T_Fish= material {
                               texture {
                               pigment { wood  
                                pigment_map {
                                                [0.0 color rgb <1,0.5,0>]
                                                [0.5 color rgb <0.2,0.2,0>]
                                                [0.8 color rgb <0,0,0.5> ]
                                                [1.0 color rgb <0,1,1> ]
                                } 
                                turbulence y*0.01
                       rotate x*90   
                       scale <1,1,2.8>
                           } 
                          finish { ambient 0.5 diffuse 0.7 phong 1}
                               }
                                     } 
                                       

#declare P_Oeil=pigment {
                       wood pigment_map {[0.0 color rgb <0,0,0> ] 
                                            [0.2 color rgb <0,0,0> ]
                                            [0.5 color rgb <0.8,0.8,0.3>]
                                            [1.0 color rgb 0 ]
                                            }
} 

#declare Oeil=merge { 
                 torus { 0.25,0.05  pigment {color rgbf <0.8,0.8,0.8,0.8>} rotate x*90  }           
                 torus { 0.18,0.05  pigment { color rgb <0.85,0.85,0.65> } rotate x*90  }           
                 sphere { 0,0.15 pigment {color rgbf <0,0,0.1,0.8>}  }
                 finish { reflection 1 metallic phong 1 }
                 scale 0.8
                 } 

    
//...............fin des textures.......

//=================faisons l'O et l'tourbillon
#declare surface = 0.6
#declare Eau     = box {<-100,-100,-100>,<100,surface,100> material { T_Eau } hollow } 
//-----------et des ronds dans  l'O    

cylinder { <0,surface-0.01,0>,<0,surface,0>,1 material { T_Rondeau  } scale <1,2,1> translate <-0.3,0,-5.0> }              
  
//.....Fin de tourbillon......
       
       
//===============tout tracer  ===============      

#include "Carelage.inc"
#include "Eclabous.inc"   
#include "doigt.inc"       
#include "fish.inc" 


object { FondPiscine    translate y*-20} 
    
object {Doigt translate <1,1,-6>}

object {Eclaboussure scale 0.78 translate <1.1,0,-6>}               

object { Eau  translate <0.2,0,-7> hollow }

object { Fish rotate y*140 translate <-0.5,-15,-5> }//      
     
       

//==============Camera=========

 
 camera
        {
          location  <0.0 , 10.0 ,-10.0>  
          angle 50
          look_at   <0.0 , -20.0 , 0.0>
        }


//........Fin de its-cold...............//
