global_settings {
	max_trace_level 20
	}

camera {
	location <-0.2,1.2,-0.5>
	sky y
	right 4/3*x
	look_at <-0.1,1,-0.3>
}

sky_sphere {
	pigment {
		gradient y
		turbulence 0.1
		colour_map {
			[0 rgb <0,0.5,1>]
			[1 rgb <0,0.1,1>]
		}
	}
}

#declare mainlight = light_source {
	<0,0,0>
	rgb <1,1,1>
}

#declare sublight = light_source {
	<0,0,0>
	rgb <0.2,0.2,0.2>
}

#declare skylight = light_source {
	<0,1000,0>
	rgb <0.2,0.2,0.5>
	area_light <2000,0,0> <0,0,2000> 100 100
	adaptive 0
	}

#declare water_texture = texture {
	pigment { rgbf <0.99,0.99,1,0.999> }
	finish {
		ambient 0
		diffuse 0
		specular 0.2
		reflection 0.05
	}
}

#declare water_interior = interior {
	ior 1.333
	caustics 1
}

#declare seroundedness = <0.5,0.5>;	

#declare glass = union {
	sphere { <0,1000,0> 1 }
	difference {
		superellipsoid {
			seroundedness
			scale <1,2,1>
		}
		superellipsoid {
			seroundedness
			scale 0.99
		}
		plane { <0,-1,0> ,-0.75 }
		plane { y ,-1 }
		pigment { gradient y
			colour_map {
				[ 0 rgbf <1,1,1,0.999>]
				[ 0.25 rgbf <1,0.75,0.5,0.999>]
				[ 0.5 rgbf <0.75,1,0.75,0.999>]
				[ 0.75 rgbf <0.5,0.75,1,0.999>]
				[ 1 rgbf <1,1,1,0.999>]
			}                      
		}
		interior {
			ior 1.5
			caustics 1
		}
		finish {
			ambient 0
			diffuse 0
			specular 0.2
			reflection 0.05
		}
	}
	intersection {
		superellipsoid {
			seroundedness
			scale 0.949
			texture { water_texture }
			interior { water_interior }
		}
		plane {
			y 0.4
			texture { water_texture }
			interior { water_interior }
			normal { waves 0.2
				translate <-0.5,-0.5,0.1>
				frequency 10
				sine_wave
			}
		}
	}
	translate y*1
	scale 0.04
}

#declare table_top_texture_1 = texture {
	pigment {
		wood
		frequency 1.5
		colour_map {
			[0 rgb <0.1,0.025,0>]
			[0.3 rgb <0.1,0.025,0>]
			[0.4 rgb <0.4,0.1,0>]
			[1 rgb <0.4,0.1,0>]
		}
		rotate x*90
		translate 1000*y
		scale 0.02
		translate <0.5,0,0.5>
		warp { turbulence 0.1 }
		warp { repeat 1*x offset y*0.02 }
		warp { repeat 1*z offset y*0.02 }
	}
	finish {
		ambient 0
		diffuse 0.9
		specular 0.1
	}
}

#declare table_top_texture_2 = texture {
	pigment {
		wood
		frequency 2
		colour_map {
			[0 rgb <0.2,0.15,0.075>]
			[0.2 rgb <0.2,0.15,0.075>]
			[0.3 rgb <0.8,0.6,0.3>]
			[1 rgb <0.8,0.6,0.3>]
		}
		rotate x*90
		translate <0.5,0,0.5>
		translate -1000*y
		scale 0.03
		warp { turbulence 0.1 }
		warp { repeat 1*x offset y*0.02 }
		warp { repeat 1*z offset y*0.02 }
	}
	finish {
		ambient 0
		diffuse 0.9
		specular 0.1
	}
}

#declare table_texture = texture {
	pigment {
		wood
		colour_map {
			[0 rgb <0.2,0.15,0.075>]
			[0.2 rgb <0.2,0.15,0.075>]
			[0.3 rgb <0.8,0.6,0.3>]
			[1 rgb <0.8,0.6,0.3>]
		}
		rotate x*90
		translate <0.5,0,0.5>
		scale 0.001
		warp { turbulence 0.1 }
	}
	finish {
		ambient 0
		diffuse 0.9
		specular 0.1
	}
}

#declare table_top_texture_3 = texture {
	pigment { rgb <0.8,0.7,0.05> }
	finish {
		specular 1
		metallic
		diffuse 0
		ambient 0
		reflection 0.1
	}
}

#declare table = union {
	cylinder { <0,0.9,0> <0,1,0> 0.5
		texture {
			onion
			scale 0.1
			translate y*0.99
			texture_map {
				[0 table_top_texture_1 ]
				[0.45 table_top_texture_1]
				[0.45 table_top_texture_3]
				[0.5 table_top_texture_3]
				[0.5 table_top_texture_2]
				[0.95 table_top_texture_2]
				[0.95 table_top_texture_3]
				[1 table_top_texture_3]
			}
		}
	}
	torus { 0.53 0.03
		scale <1,1/3,1>
		translate 1*y
	}
	difference {
		cylinder { <0,0,0> <0,1,0> 0.56 }
		cylinder { <0,0.9,0> <0,1.01,0> 0.5001 }
	}
	texture { table_texture }
	rotate y*30
}

#declare beer_mat = cylinder {
	<0,1,0> <0,1.001,0> 0.06
	pigment {
		image_map {
                        gif "jw_break.gif"
			interpolate 2
			once
		}
		rotate x*90
		translate <-0.5,-0.5,-0.5>
		scale 0.12
	}
	finish {
		diffuse 0.8
		ambient 0.2
	} 
}

#declare paper_weight = union {
	object { beer_mat }
	difference {
		sphere { <0,0,0> 1 }
		plane { y 0 }
		pigment { gradient y
			colour_map {
				[ 0 rgbf <1,1,1,0.99>]
				[ 0.25 rgbf <1,0,0,0.9>]
				[ 0.5 rgbf <0,1,0,0.9>]
				[ 0.75 rgbf <0,0,1,0.9>]
				[ 1 rgbf <1,1,1,0.99>]
			}                      
		}
		interior {
			ior 1.5
			caustics 1
		}
		finish {
			ambient 0
			diffuse 0
			specular 0.95
			reflection 0.05
		}
		scale 0.06
		translate y*1.0001
	}
}

#declare sky_plane = plane {
	y 1000
	no_shadow
	hollow
	pigment {
		bozo
		turbulence 1
		colour_map {
			[0 rgbt <1,1,1,1> ]
			[2/3 rgbt <1,1,1,0.5>]
			[1 rgbt <1,1,1,0>]
		}
		scale 100
	}
	finish {
		ambient 0.7
		diffuse 0.3
	}
}

#declare distant_fog = fog {
	fog_type 2
	distance 50
	rgb <0,0.2,0.1>
	fog_offset 0
	fog_alt 1
}

#declare picture = box {
	<-1.06,0,-1.5> <1.06,0.001,1.5>
	texture {
		pigment { rgb <1,1,1> }
	}
	texture {
		pigment {
			image_map {
				tga "brush.tga"
				interpolate 2
				once
			}
		translate <-0.5,-0.5,-0.5>
		rotate x*90
		scale <4.24,1,6>
		scale 0.45
		}
	}
	finish {
		ambient 0.2
		diffuse 0.8
	}
	scale 0.15
}

object { table }

object { paper_weight rotate y*-15 translate z*-0.2 translate x*0.1 }

object { glass translate y*1.0011 translate z*-0.25 translate x*-0.2 }

object { beer_mat rotate y*37 translate z*-0.25 translate x*-0.2 }

object { picture rotate y*-45 translate y*1 translate z*-0.3 translate x*-0.05 }

object { mainlight translate <1000,2000,10000> }

object { sublight translate <0,10000,0> }

object { sky_plane translate y*1000 }

fog { distant_fog }
