#include "colors.inc"
#include "textures.inc"

global_settings {max_trace_level 7}
//rendering times
#declare simple = 0  //basic picture
 #declare simple = 1      // fogging
//#declare simple = 2 // area light

camera {
        location <0, 10, -29>
        look_at <0, 0, 0.01>
//location <0, 40, 0>
//look_at <0, 0, 0.01>
}

#if (simple < 2)
    light_source { <10, 50, -10> color White }
#end
#if (simple = 2)
     light_source { <0, 0, 0> color White
                   area_light
                   <8, 0, 0>, <0, 0, 8>
                   3, 3
                   adaptive 1
                   jitter
                   translate <10, 50, -14>}
#end
// filler
light_source {<0, 25, -30> color Gray50 shadowless }


// ---------------------------------
// corals

#declare R1=seed (5543)

#include "coral1.inc"

object {Coral_1
       translate <13, 1.1, -8>
}
object {Coral_1
        rotate <30, 170, 0>
        translate <-10, 2.5, -4.5>
}
object {Coral_1
        translate <-7, 2, -5>
}

object {Coral_2
       translate <5, 0.3, -4>
}
object {Coral_2
        rotate <0, 30, 0>
        translate <-11, 0, -13>
}

object {Coral_3
       translate <12, 0, -3>
}
object {Coral_3
        translate <0, 0.5, -8>
}
object {Coral_3
        translate <-9.5, 4.5, 3>
}
object {Coral_3
        scale <1.5, 1, 1>
        translate <10, 0, -10>
}
object {Coral_3
        translate <7, 4, 7>
}

#declare Count = 0
#while (Count < 10)

object {Coral_3
        scale <rand(R1)+1, rand(R1), rand(R1) + 1>
        pigment {color rgb <0.7+rand(R1)*0.1, 0.7+rand(R1)*0.1, 0.7>}
        translate <10-rand(R1)*20, 0, -6-rand(R1)*13>
}

#declare Count=Count + 1
#end

object {Anemome
        translate <6.2, 0.1, -17>
}
object {Anemome
        translate <-4, 0, 0.5>
}

// --------------------------------
// Fishes

#include "fish.inc"
object {Clownfish
        rotate <0, 180, 0>
        translate <5.6, 1, -17>}
object {Clownfish
        rotate <20, 20, 40>
        translate <7, 1, -16>}
object {Clownfish
        rotate <20, -30, 40>
        translate <6, 1, -18>}

object {Blue_Surgeon
       translate <0, 3, 0>
}
object {Blue_Surgeon
        rotate <0, -20, 20>
       translate <-14, 4, -5>
}
object {Blue_Surgeon
        scale <1, 1, -1>    // to reverse it (only one side defined)
        rotate <10, 170, 0>
        translate <10, 6, -12>
}
object {Long_Nose_Butterflyfish
        rotate <0, 0, -10>
        translate <-5, 3, -14>
}
#declare Count = 0
#while (Count < 15)
object {Humbug_Damsel
        rotate <0, rand(R1)*360, 0>
        translate <-5-rand(R1)*8, 3+rand(R1)*3, -4-rand(R1)*8>
}
object {Humbug_Damsel
        rotate <0, rand(R1)*360, 0>
        translate <7+rand(R1)*7, 2+rand(R1)*3, -6-rand(R1)*8>
}
object {Humbug_Damsel
        rotate <0, rand(R1)*360, 0>
        translate <3-rand(R1)*10, 2+rand(R1)*3, -14-rand(R1)*8>
}

#declare Count=Count + 1
#end

// --------------------------------
// background

// colouring and distance blur
plane {
       z, 35
       hollow
       pigment {gradient y
                turbulence 0.02
                color_map {
                [0.0 color rgb <0.15, 0.328, 0.407>]
                [1.0 color rgb <0.25, 0.628, 0.607>]
                }
                scale 28
                }
       finish {ambient 1}
}

#if (simple > 0)
#declare Count = 0
#while (Count < 26)
plane {z, -20 + Count
       pigment { color rgbf <0.9-(Count/200), 0.95-(Count/200), 0.94-(Count/200), 0.98-(Count/200)> }
       finish {crand 0.05}
}
#declare Count = Count + 5
#end

#end // if

// sea bed
height_field {gif
             "seabed.gif"
             smooth
             translate <-0.5, 0, -0.5>
             scale <40, 10, 40>
             pigment {
               image_map {
                  gif
                  "seabedmap.gif"}
                  translate <-0.5, 0, -0.5>
                  scale <40, 10, 40>
                  }
}

// sea surface ripples
#if (simple = 1)
plane { y, 20
        hollow
        texture {
                pigment {
                        crackle
                        turbulence 0.3
                        color_map {
                        [0.0 color Clear]
                        [1.0 color White]}
                        scale 4
                        }
               finish {caustics 1}
        }
}
#end
