#include "colors.inc"
#include "textures.inc"
#include "skies.inc"

background { SkyBlue }

camera {
        location  <0, 800, -1000>
        direction <0, 0,  1>
        up        <0, 1,  0>
        right   <4/3, 0,  0>
        look_at   <0, 800, 0>
}

light_source {<0, 1000, -1500> color White*.9}
light_source {<5000, 1000, -1500> color White*.7}
light_source {<-5000, 1000, -1500> color White*.7}
light_source {<-3000, 400, 3000> color Orange}
light_source {<5000, 600, 13000> color Orange}

// The Water
// /*
plane { <0,1,0>, 0
        hollow
        texture { pigment { onion
                            turbulence 2.0
                            color_map { [ 0.0 color White ]
                                        [ 1.0 color rgb <0, .5, 1> ]
                                      }
                           scale .4          
                          }
                  normal {bumps 0.5 scale .8}
                  finish {phong 1 reflection .5 ambient 0.3 diffuse 0.3}
                }
        scale 50
        //rotate <1, 0, 0>
}
// */

// /*
#declare Galleon = object { #include "galleon.inc" }
object { Galleon  //#1 
         rotate <-90, 0,0>
         rotate <0, 130, 0>
         scale 6
         translate <600, 175, 1500>
       }
object { Galleon  //#2 
         rotate <-90, 0,0>
         rotate <0, 110, 0>
         scale 6
         translate <-1800, 175, 2800>
       }
object { Galleon  //#3 
         rotate <-90, 0,0>
         rotate <0, 130, 0>
         scale 6
         translate <0, 175, 1200>
       }
object { Galleon  //#4 
         rotate <-90, 0,0>
         rotate <0, 110, 0>
         scale 6
         translate <-800, 175, 725>
       }
object { Galleon  //#5 
         rotate <-90, 0,0>
         rotate <0, 110, 0>
         scale 6
         translate <-500, 175, 4500>
       }

// */

// /*
height_field { tga "gforge.tga" //water_level .01
               texture { pigment { image_map { gif "gforge.gif" 
                                              interpolate 2 }
                                 rotate x*90 }
                 finish {crand 0.05 reflection 0.0 diffuse 0.7 ambient 0.3}
                }
                //smooth     // doesn't work for tga?
                translate <-.5, 0, -.5>
                rotate <0, 120, 0>
                scale <4000, 3000, 4000>
                translate <1500, -1500, 4000> 
             }
height_field { tga "gforge.tga" //water_level .01
               texture { pigment { image_map { gif "gforge.gif" 
                                              interpolate 2 }
                                 rotate x*90 }
                 finish {crand 0.05 reflection 0.0 diffuse 0.7 ambient 0.3}
                }
                //smooth     // doesn't work for tga?
                translate <-.5, 0, -.5>
                rotate <0, 90, 0>
                scale <4000, 3000, 4000>
                translate <4000, -1000, 8000> 
             }
height_field { tga "gforge.tga" //water_level .01
               texture { pigment { image_map { gif "gforge.gif" 
                                              interpolate 2 }
                                 rotate x*90 }
                 finish {crand 0.05 reflection 0.0 diffuse 0.7 ambient 0.3}
                }
                //smooth     // doesn't work for tga?
                translate <-.5, 0, -.5>
                rotate <0, 45, 0>
                scale <4000, 3000, 4000>
                translate <6000, -1000, 12000> 
             }
// */

// ***************** The Volcano *********************
// /* Temp Out Volcano
sphere { 0, 1
         hollow
         pigment { color rgbt <1,1,1,1> }
                   // /* <----- Temp Out Halo
                   halo { emitting
                             spherical_mapping
                             linear
                             turbulence 1.0
                             max_value 2
                             aa_level 2
                             aa_threshold 0.5
                             color_map { [ 0.0 color rgbt <1, 0, 0,  1.0> ]
                                         [ 0.5 color rgbt <1, 1, 0, -1.0> ]
                                         [ 1.0 color rgbt <1, 0, 0,  1.0> ]
                                       } 
                             frequency 2          
                             samples 20
                             scale .6
                           }
                   // <--- End Out Halo */     
         scale <20, 10, 10>
         translate <0, 8, 0>
         scale <175, 125, 125>
         translate <200, 500, 3000>
      }
// <------- End Out Volcano */


sky_sphere { S_Cloud4 }

// Upper Cloud
// /* <-------- Upper Cloud Temp Out
sphere { 0, 2
         pigment { color rgbt <1, 1, 1, 1> } 
         hollow
         halo { emitting 
                spherical_mapping
                linear
                turbulence <.7, 1.5, .7>
                color_map {
                           [ 0.40 color rgbt <0.90, 0.91, 0.99,  1> ] //Silver
                           [ 0.50 color rgbt <0.30, 0.30, 0.50, -1> ] //GrayBlue
                           [ 0.60 color rgbt <0.90, 0.75, 0.59,  -1> ] //Gold
                           [ 0.70 color rgbt <1.0, 1.0, 1.0, +1> ] //Clear                           
                           [ 1.00 color rgbt <1.0, 1.0, 1.0, +1> ] //Clear
                          } 
                samples 25
                aa_threshold 0.3
                aa_level 2
                jitter .2
              }
         rotate <0, -180, 0>
         scale <600, 600, 600>
         translate <-200, 800, 500>
       }
// <--------- End Upper Cloud Out */
        

// /*
#include "temple.inc"
object { DreamTemple
         translate <0, 21, 0>
         scale 5
         rotate <0, 60, 0>
         translate <-1150, 0, 3000>
       }
// */

// /*
#include "balloon.inc"
object { Balloon
         scale 3
         rotate <-90, 0, 0>
         rotate <0, 0, 20>
         translate <-1400, 750, 2800>
       }
object { Balloon
         scale 3
         rotate <-90, 0, 0>
         rotate <0, 0, 0>
         translate <-1450, 1200, 2000>
       }
object { Balloon
         scale 3
         rotate <-90, 0, 0>
         rotate <0, 0, 10>
         translate <-1000, 1200, 3500>
       }
object { Balloon
         scale 3
         rotate <-90, 0, 0>
         rotate <0, 0, 10>
         translate <0, 1200, 4500>
       }
// */

//The Mountain
// /* <<======= Temp Out Mountain
height_field { gif "atlantis.gif" water_level 1/255
               texture { pigment { image_map { gif "atlantis.gif" 
                                           interpolate 2 transmit 0, 1.0 }
                         rotate x*90 
                         //scale 1.03
                         //translate <-.005, 0, -.005> 
                       }
                 finish { diffuse 0.5 ambient 0.5}
                }
                //smooth     
                translate <-.5, 0, 0>
                rotate <-90, 0, 0>
                scale <12000, 6000, .1>
                translate <5000, -200, 16000> 
             }
// <<===== End Mountain Out */
