
// declare an unidentified parameters
#ifndef (phi)
  #declare phi = 85 // angle of glass
#end

#ifndef (base_t)
  #declare base_t = 0.5  // thickness of base
#end

#ifndef (base_w)
  #declare base_w = 4  // width of base
#end

#ifndef (edge_r)
  #declare edge_r = 0.05  // half the thickness of the sides
#end

#ifndef (glass_h)
  #declare glass_h = 8  //  height of glass
#end

#ifndef (water_d)
  #declare water_d = 3  // depth of the water
#end

#ifndef (menisc)
  #declare menisc = 0.1  //  meniscus of the water
#end

//  Convert to radians, and calculate various coordinates on the glass
#declare phi = phi * 3.1415926535898 / 180
#declare Fv = edge_r
#declare Lv = base_w/2
#declare Gv = edge_r*(1-cos(phi))
#declare Uv = Lv + edge_r * sin(phi)
#declare Ev = base_t
#declare Cv = base_t + edge_r
#declare Jv = base_t + water_d
#declare Hv = Jv + menisc
#declare Iv = Jv + menisc * (1- cos(phi))
#declare Bv = glass_h - edge_r
#declare Nv = Lv + (Bv - Fv)/tan(phi)
#declare Av = Bv + Nv / tan(phi)
#declare Pv = Nv + edge_r * sin(phi)
#declare Qv = Bv - edge_r * cos(phi)
#declare Dv = Cv - edge_r * cos(phi)
#declare Tv = Pv + (Av - Qv) / tan(phi)
#declare Rv = Tv - 2 * edge_r / sin(phi)
#declare Sv = Rv - (Av - Dv) / tan(phi)
#declare Vv = Rv - (Av - Iv) / tan(phi)
#declare Kv = Sv - edge_r * sin(phi)
#declare Mv = Vv - menisc * sin(phi)
#declare PPv = Av * tan(phi)

// Declare the basic components to be combined to form the glass and the water
#declare GWcon1 = cone { Av*y, 0, 0*y, PPv }
#declare GWcon2 = cone { Av*y, Rv, Dv*y, Sv }
#declare GWcon3 = cone { Av*y, Tv, Gv*y, Uv }
#declare GWcon4 = cone { Iv*y, Vv, Dv*y, Sv }

#declare GWcyl1 = cylinder { 0*y,  Ev*y,  Lv }
#declare GWcyl2 = cylinder { Ev*y,  Cv*y,  Kv }
#declare GWcyl3 = cylinder { Jv*y,  Hv*y,  Mv }

#declare GWtor1 = torus { Nv , edge_r translate Bv*y }
#declare GWtor2 = torus { Lv , edge_r translate Fv*y }
#declare GWtor3 = torus { Kv , edge_r translate Cv*y }
#declare GWtor4 = torus { Mv , menisc translate Hv*y }


// Combine some of these components to form the drinking glass

#declare DrinkingGlass = merge
{
  object{GWtor1}
  object{GWtor2}
  object{GWcyl1}
  difference
  {
    intersection
    {
      object{GWcon1}
      object{GWcon3}
    }
    merge
    {
      object{GWcon2}
      object{GWcyl2}
      object{GWtor3}
    }
  }
}

// Combine some of the components to form the drinking glass

#declare DrinkingWater = difference
{
  merge
  {
    object{GWcyl2}
    object{GWtor3}
    object{GWcon4}
  }
  merge
  {
    object{GWcyl3}
    object{GWtor4}
  }
  scale 1.000001
}

// Convert back to degrees
#declare phi = phi * 180 / 3.1415926535898

// Finished !

