
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

#include "colors.inc"
#include "textures.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <-3, 1, 50>
  look_at   <0.0, 0.0,  -250>
  angle 29
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color White/2 // light's color
  translate <-30, 70, 70>
}
light_source
{
  0*x // light's position (translated below)
  color White/2  // light's color
  translate <70, 30, 90>
}
light_source
{
  0*x // light's position (translated below)
  color White/2  // light's color
  translate <-70, -70, 110>
}

// ----------------------------------------

#declare str1=seed(700)

#declare i=1
#while (i<778)


  #declare O1 = <0,0,0>
  #declare H1 = <0,-0.96,0>   //  Bond length in H2O is about 0.96 angstroms
  #declare H2 = <0,-0.96 * cos(109*pi/180), -0.96*sin(109*pi/180)> // angle is abt 109 degrees

//  Now, randomly rotate the water molecule. First, choose an axis of rotation.
  #declare axis=<2*rand(str1)-1,2*rand(str1)-1,2*rand(str1)-1>
  #while (vlength(axis)>1)
    #declare axis=<2*rand(str1)-1,2*rand(str1)-1,2*rand(str1)-1>
  #end
// Now choose an angle to rotate by, and do the rotation.
  #declare axis=vaxis_rotate(<1,2,3>,axis,90)
  #declare th0 = rand(str1)*360+90
  #declare H1=vaxis_rotate(H1,axis,th0)
  #declare H2=vaxis_rotate(H2,axis,th0)
  #declare O1=vaxis_rotate(O1,axis,th0)
// Finally, choose a random position for the molecule (within camera range!!)
  #declare posz = 70 - 300*pow(rand(str1),1/3)
  #declare posy = (rand(str1)*2-1)*(70-posz)*0.36397
  #declare posx = (rand(str1)*2-1)*(70-posz)*0.36397
  #declare pos1 = <posx,posy,posz>

  #declare factor = 2
  blob
  {
    threshold (1 / factor)
    sphere { O1, factor*0.66, 1 texture{pigment{color Red}}} // radius of Oxygen atom: 0.66
    sphere { H1, factor*0.3, 1 texture{pigment{color White}}} // radius of Hydrogen atom: 0.3
    sphere { H2, factor*0.3, 1 texture{pigment{color White}}} // radius of Hydrogen atom: 0.3
    translate pos1  //  Move to correct position
    texture{pigment {color Aquamarine} finish{Shiny specular 1 roughness 0.01} }
  }
  #declare i=i+1
#end

