

// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"

global_settings
{
  assumed_gamma 1.0
  max_trace_level 14
}

// ----------------------------------------
camera
{
//  location  <-120, 110, -150>
// look_at <0,32,0>
//  angle 15
    location <-80,84,-100>
    look_at <0,32,0>
    angle 25
    rotate <0,-13,0>
}

sky_sphere
{
  S_Cloud2
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-300000, 300000, -300000>
}

// ----------------------------------------

#declare Pool = union {
// Tiles for the length of the pool
#declare numtile_y = 1
#declare numtile_x = 100
#declare tile_y = 20
#declare tile_x = 8
#declare tile_z = 0.5
#declare cement_w = 1
#declare tile_texture = texture { T_Grnt1 } // or 23 ?
#declare scale_texture = no
#include "tiling.inc"

object {
  WallTiling
  rotate <90,90,0>
  translate <-600-tile_y/2,0,0>
}
object {
  WallTiling
  rotate <90,90,0>
  translate <+600+tile_y/2,0,0>
}

#declare numtile_x = 150
#include "tiling.inc"
object {
  WallTiling
  rotate <90,0,0>
  translate <0,0,-400-tile_y/2>
}

object {
  WallTiling
  rotate <90,0,0>
  translate <0,0,+400+tile_y/2>
}

#declare numtile_y = 10
#declare numtile_x = 5
#declare tile_y = 23
#declare tile_x = 23
#declare tile_z = 1
#declare cement_w = 1
#declare tile_texture = texture { T_Stone40 }
#declare scale_texture = no
#include "tiling.inc"

object {
  WallTiling
  rotate <90,90,0>
  translate <-510,0,-420-5*tile_y/2>
}


#declare numtile_x = 1
#declare numtile_y = 1
#declare tile_x = 20
#declare tile_y = 20
#declare tile_texture = texture { T_Grnt23 }  // or 26 ?
#include "tiling.inc"
object {
  WallTiling
  rotate <90,0,0>
  translate <600+tile_x/2,0,+400+tile_y/2>
}
object {
  WallTiling
  rotate <90,0,0>
  translate <-600-tile_x/2,0,+400+tile_y/2>
}
object {
  WallTiling
  rotate <90,0,0>
  translate <600+tile_x/2,0,-400-tile_y/2>
}
object {
  WallTiling
  rotate <90,0,0>
  translate <-600-tile_x/2,0,-400-tile_y/2>
}


// Black stripes for the bottom of the pool...

#declare numtile_x = 1
#declare numtile_y = 32
#declare tile_x = 25
#declare tile_y = 25
#declare tile_texture = texture { pigment{color Black} finish {Shiny roughness 0.03} }
#include "tiling.inc"

object{ WallTiling rotate <90,90,0> translate <0,-125,0> }
object{ WallTiling rotate <90,90,0> translate <0,-125,200> }
object{ WallTiling rotate <90,90,0> translate <0,-125,-200> }

#declare numtile_y = 3
#include "tiling.inc"

object{ WallTiling rotate <90,0,0> translate <412.5,-125,0> }
object{ WallTiling rotate <90,0,0> translate <412.5,-125,200> }
object{ WallTiling rotate <90,0,0> translate <412.5,-125,-200> }
object{ WallTiling rotate <90,0,0> translate <-412.5,-125,0> }
object{ WallTiling rotate <90,0,0> translate <-412.5,-125,200> }
object{ WallTiling rotate <90,0,0> translate <-412.5,-125,-200> }

#declare FinalVersion = yes
#ifdef (FinalVersion)
// Cyan tiles for the floor and sides of the pool - only do these for the final version.
// Why? Because it's very memory-hungry!!!! It's abt 2500 objects!!
  #declare numtile_x = 48
  #declare numtile_y = 5
  #declare tile_x = 25
  #declare tile_y = 25
  #declare tile_texture = texture { pigment{color Cyan} finish {Shiny roughness 0.03} }
  #include "tiling.inc"

  object{ WallTiling translate <0,-62.5,-400>}
  object{ WallTiling translate <0,-62.5,400>}

  #declare numtile_x = 32
  #include "tiling.inc"

  object{ WallTiling rotate <0,90,0> translate <-600,-62.5,0>}
  object{ WallTiling rotate <0,90,0> translate <600,-62.5,0>}

  #declare numtile_x = 32
  #declare numtile_y = 6
  #include "tiling.inc"

  object{ WallTiling rotate <90,90,0> translate <500,-125,0>}
  object{ WallTiling rotate <90,90,0> translate <-500,-125,0>}

  #declare numtile_x = 34
  #declare numtile_y = 6
  #include "tiling.inc"

  object{ WallTiling rotate <90,0,0> translate <0,-125,325>}
  object{ WallTiling rotate <90,0,0> translate <0,-125,-325>}

  #declare numtile_x = 34
  #declare numtile_y = 4
  #include "tiling.inc"

  object{ WallTiling rotate <90,0,0> translate <0,-125,100>}
  object{ WallTiling rotate <90,0,0> translate <0,-125,-100>}

  #declare numtile_x = 32
  #declare numtile_y = 1
  #include "tiling.inc"

  object{ WallTiling rotate <90,0,0> translate <0,-125,237.5>}
  object{ WallTiling rotate <90,0,0> translate <0,-125,162.5>}
  object{ WallTiling rotate <90,0,0> translate <0,-125,37.5>}
  object{ WallTiling rotate <90,0,0> translate <0,-125,-37.5>}
  object{ WallTiling rotate <90,0,0> translate <0,-125,-162.5>}
  object{ WallTiling rotate <90,0,0> translate <0,-125,-237.5>}

  #declare numtile_x = 32
  #declare numtile_y = 1
  #declare tile_y = 12.5
  #include "tiling.inc"

  object{ WallTiling rotate <90,0,0> translate <0,-125,218.75>}
  object{ WallTiling rotate <90,0,0> translate <0,-125,181.25>}
  object{ WallTiling rotate <90,0,0> translate <0,-125,18.75>}
  object{ WallTiling rotate <90,0,0> translate <0,-125,-18.75>}
  object{ WallTiling rotate <90,0,0> translate <0,-125,-181.25>}
  object{ WallTiling rotate <90,0,0> translate <0,-125,-218.75>}

  #declare numtile_x = 1
  #declare numtile_y = 1
  #declare tile_y = 12.5
  #include "tiling.inc"

  object{ WallTiling rotate <90,0,0> translate <412.5,-125,243.75>}
  object{ WallTiling rotate <90,0,0> translate <412.5,-125,156.25>}
  object{ WallTiling rotate <90,0,0> translate <412.5,-125,43.75>}
  object{ WallTiling rotate <90,0,0> translate <412.5,-125,-43.75>}
  object{ WallTiling rotate <90,0,0> translate <412.5,-125,-156.25>}
  object{ WallTiling rotate <90,0,0> translate <412.5,-125,-243.75>}
  object{ WallTiling rotate <90,0,0> translate <-412.5,-125,243.75>}
  object{ WallTiling rotate <90,0,0> translate <-412.5,-125,156.25>}
  object{ WallTiling rotate <90,0,0> translate <-412.5,-125,43.75>}
  object{ WallTiling rotate <90,0,0> translate <-412.5,-125,-43.75>}
  object{ WallTiling rotate <90,0,0> translate <-412.5,-125,-156.25>}
  object{ WallTiling rotate <90,0,0> translate <-412.5,-125,-243.75>}
#end  // of the wall and floor tilings for the pool (whew!)

//  The Pool itself
difference {
  plane { y, -0.0001 pigment {Green/2} }
  box { <-600.001,-125.001,-400.001>, <600.001,1,400.001> texture{ pigment {color Cyan} } }
}


box { <-600.002,-125.002,-400.002>, <600.002,-8.5,400.002>
      texture {Glass
         pigment {color Cyan/3+2*White/3 filter 1}
         normal {waves 0.1 scale 10.1}
         finish {ior 1.33 caustics 0.8}
      }
   }

}  // end of pool

object {Pool translate <500,0,455> }
// object {Pool}



/*
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */


/*
 *
 *
 *
 *
 *
 *
 *
 *
 */

#declare Table = union {
// Objects On Table

#declare phi=75
#declare pic_h = 12
#declare pic_w = 16
#declare frame_t = 0.5
#declare PictureTexture = texture{pigment{
// texture pigment {} attribute
// create a texture that lays an image's colors onto a surface
// image maps into X-Y plane from <0,0,0> to <1,1,0>
image_map
{
  tga "molecule.tga" // the file to read (iff/gif/tga/png/sys)
  map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
 // interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  // [filter N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [transmit N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [use_color | use_index]
  // [once]
} // image_map
scale <-1,1,1>
}}
#include "photo.inc"

object{PictureFrame  texture {Copper_Metal} rotate 25*y translate -11*x}
object{PictureStand  texture {Copper_Metal} rotate 25*y translate -11*x}
object{PictureImage rotate 25*y translate -11*x}

#declare PictureTexture = texture{pigment{
// texture pigment {} attribute
// create a texture that lays an image's colors onto a surface
// image maps into X-Y plane from <0,0,0> to <1,1,0>
image_map
{
  tga "sunset.tga" // the file to read (iff/gif/tga/png/sys)
  map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
 // interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  // [filter N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [transmit N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [use_color | use_index]
  // [once]
} // image_map
scale <-1,1,1>
}}
#declare pic_h = 12
#declare pic_w = 16
#include "photo.inc"
object{PictureFrame  texture {Copper_Metal} rotate -25*y translate 11*x}
object{PictureStand  texture {Copper_Metal} rotate -25*y translate 11*x}
object{PictureImage rotate -25*y translate 11*x}

#declare phi=83
#declare water_d=8
#declare base_w = 6
#declare glass_h = 13
#declare edge_r = 0.1
#declare menisc=0.2
#include "cup.inc"
object{ DrinkingGlass texture{pigment {color rgbf <0.9,1,0.95,0.95>} finish {Glass_Finish} } translate -15*x+13*z }
object{ DrinkingWater texture{pigment {color Clear} finish{Glass_Finish ior 1.33}} translate -15*x+13*z }
//object{ DrinkingWater texture{pigment {color Yellow} finish{Shiny}} translate -15*x+13*z }

//object{ DrinkingGlass texture{pigment {color rgbf <0.9,1,0.95,0.95>} finish {Glass_Finish} } }
//object{ DrinkingWater texture{pigment {color Clear} finish{Glass_Finish ior 1.33} } }

//sphere { 5.0*y, 5 texture {pigment {radial frequency 8} finish{specular 1}} }

// Glass tabletop - new version
merge {
  box{ <-25,-1,-20>, <25,0,20> }
  intersection {
    cylinder { <-25,-3,-20>, <25,-3,-20>, 3 }
    box { <-25,-1,-22> , <25,0,-20> }
  }
  intersection {
    cylinder { <-25,-3,20>, <25,-3,20>, 3 }
    box { <-25,-1,20> , <25,0,22> }
  }
  intersection {
    cylinder { <-25,-3,-20>, <-25,-3,20>, 3 }
    box { <-27,-1,-20> , <-25,0,20> }
  }
  intersection {
    cylinder { <25,-3,-20>, <25,-3,20>, 3 }
    box { <25,-1,-20> , <27,0,20> }
  }
  intersection {
    sphere { <-25,-3,-20> , 3 }
    cylinder { <-25,-1,-20>, <-25,0,-20>, 2 }
  }
  intersection {
    sphere { <25,-3,-20> , 3 }
    cylinder { <25,-1,-20>, <25,0,-20>, 2 }
  }
  intersection {
    sphere { <-25,-3,20> , 3 }
    cylinder { <-25,-1,20>, <-25,0,20>, 2 }
  }
  intersection {
    sphere { <25,-3,20> , 3 }
    cylinder { <25,-1,20>, <25,0,20>, 2 }
  }
  texture{Glass}
}

/*
// Glass tabletop - original version...
intersection{
  merge {
    box { <-25,-6,-20>, <25,0,20> }
    cylinder { <-25,-3,-20>, <+25,-3,-20>, 3 }
    cylinder { <-25,-3,+20>, <+25,-3,+20>, 3 }
    cylinder { <-25,-3,-20>, <-25,-3,+20>, 3 }
    cylinder { <+25,-3,-20>, <+25,-3,+20>, 3 }
    sphere { <-25,-3,-20>, 3 }
    sphere { <+25,-3,-20>, 3 }
    sphere { <-25,-3,+20>, 3 }
    sphere { <+25,-3,+20>, 3 }
  }
  merge {
    cylinder { <-25,-1,-20>, <-25,0.1,-20>, 2 }
    cylinder { <+25,-1,-20>, <+25,0.1,-20>, 2 }
    cylinder { <-25,-1,+20>, <-25,0.1,+20>, 2 }
    cylinder { <+25,-1,+20>, <+25,0.1,+20>, 2 }
    box { <-27,-1,-20>, <27,0.001,20> }
    box { <-25,-1,-22>, <25,0.001,22> }
  }
  texture{Glass }
}
*/

// Rubber things that the glass rests on (four).
union{
  intersection {
    torus { 1.3, 0.55 }
    box { <-2,-0.56,-2>, <2,0.50001,2> }
    translate <11.5,-1.5,11.5>
  }
  intersection {
    torus { 1.3, 0.55 }
    box { <-2,-0.56,-2>, <2,0.50001,2> }
    translate <11.5,-1.5,-11.5>
  }
  intersection {
    torus { 1.3, 0.55 }
    box { <-2,-0.56,-2>, <2,0.50001,2> }
    translate <-11.5,-1.5,11.5>
  }
  intersection {
    torus { 1.3, 0.55 }
    box { <-2,-0.56,-2>, <2,0.50001,2> }
    translate <-11.5,-1.5,-11.5>
  }
  texture { pigment {color Gray10} finish {Shiny roughness 0.1} }
}

// Table Legs...
#declare OneLeg = merge {
  intersection {
    torus { 10*sqrt(2), 2 }
    merge {
      plane { -x, 0 rotate 10*y}
      plane { -x, 0 rotate -10*y}
    }
  }
  sphere { <0,0,-10*sqrt(2)>, 2 rotate 10*y}
  sphere { <0,0,+10*sqrt(2)>, 2 rotate -10*y}
  rotate 90*x
  rotate -45*y
  translate <-12,-10*sqrt(2)-3.5,-12>
}
union{
  object{OneLeg}
  object{OneLeg rotate 90*y}
  object{OneLeg rotate 180*y}
  object{OneLeg rotate 270*y}
  texture {Copper_Metal}
}

// Plastic bits to protect the legs on the floor (four).
union{
  intersection {
    torus { 1.3, 0.55 }
    box { <-2,-0.5,-2>, <2,0.56,2> }
    translate <11.5,-33.75,11.5>
  }
  intersection {
    torus { 1.3, 0.55 }
    box { <-2,-0.5,-2>, <2,0.56,2> }
    translate <-11.5,-33.75,11.5>
  }
  intersection {
    torus { 1.3, 0.55 }
    box { <-2,-0.5,-2>, <2,0.56,2> }
    translate <11.5,-33.75,-11.5>
  }
  intersection {
    torus { 1.3, 0.55 }
    box { <-2,-0.5,-2>, <2,0.56,2> }
    translate <-11.5,-33.75,-11.5>
  }

  texture { pigment {color Gray90} }
}

translate 34.25*y

}  // End of #declare Table = ...

//object{Table rotate <30,30,30> translate -40*y}
object{Table rotate 200*y}

// plane { y, 0 pigment {checker color rgb <0.7,0.5,0.3> color Brown scale 5}}




