
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

#include "colors.inc"
#include "textures.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 200, 0>
  look_at 3*z + (200 - 0.3333)*y
  angle 30
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color (Orange+Red)/2]
                [0.2 color Magenta]
                [0.3 color Blue/2]
                [1.0 color Black] }
  }
}


// A spotlight to light up the clouds near the sun...

light_source
{
  200*y                     // light's position (translated below)
  color rgb (Red+2*Orange)*10       // light's color
  spotlight               // this kind of light source
//  translate <40, 80, -40> // <x y z> position of light
  point_at 3000000*z      // direction of spotlight
  radius 5                 // hotspot (inner, in degrees)
  tightness 5            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 15               // intensity falloff radius (outer, in degrees)
  fade_distance 30000
  fade_power 0.1         //  so that the light doesn't affect the colour of the sun!!
}


light_source
{
  200*x // light's position (translated below)
  color red 1.0  green 1.0  blue 0.3333  // light's color
  translate 3000000*z
  
// light_source { ...
  // put this inside a light_source to give it a visible appearance
  looks_like { sphere { 3000000*z-100000*y, 300000
       texture {pigment {color (Yellow+White)/2 }
                finish {ambient 1}}} }

}

// ----------------------------------------
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

// Sea
sphere { 640000*(-y), 640000 texture{Glass finish{ior 1.33 reflection 0.75 roughness 0.3} normal{
waves 0.1 
scale 100} 
  //bumps 0.3 // bumpy surface (0...1)
} }

// Sea Floor
sphere { 640000*(-y), 639990 texture{
// texture pigment/normal pattern
pigment{bozo // use color map to swirl colors
color_map
{
  //  [ END_VAL color red R green G blue B filter F transmit T]
  [  0.8  color Aquamarine]
  [  0.9  color Black]
//  [  0.5  color red 0.0 green 0.0 blue 0.0]
//  [  0.7  color red 0.0 green 0.0 blue 0.8]
//  [  1.0  color red 0.8 green 0.8 blue 0.8 filter 1.0]
}
 // color_map
//turbulence 0.2
scale 200

}
finish {ambient 0.333}
}
}

// Clouds
sphere { 640000*(-y), 641000 texture{
pigment{
marble // use color map to swirl colors
turbulence 1.0
// texture pigment {} attribute
// create a smooth color gradation map
color_map
{
  //  [ END_VAL color red R green G blue B filter F transmit T]
  [  0.15  color red 1 green 1 blue 1]
//  [  0.2  color red 0.8 green 0.4 blue 0.2]
//  [  0.5  color red 0.0 green 0.0 blue 0.0]
//  [  0.7  color red 0.0 green 0.0 blue 0.8 filter 0.5]
//  [  1.0  color red 0.8 green 0.8 blue 0.8 filter 1.0]
    [  0.3  color red 1 green 1 blue 1 filter 1]
} // color_map


// turbulence 0.3
// color_map...

}
scale 8000
rotate 30*y
}
}

