
#include "cathand.inc"
#include "foot.pov"

#declare tv2=<0,-1.1732,1>*0.06;
#macro vs2()
translate <0,-1.732,1>*0.06
#end

#macro versch1()
translate <0,0,-.2>
rotate x*60
translate <0,0,.24>

#end

#macro distortmap()

#declare dmr=seed(random_start);

#if (distortmap_on=true)

#declare s_rad=qual*1.3;

#declare countx=crnr1.x;
#while (countx<crnr2.x)
  #declare countx=countx+qual.x;

  #declare county=crnr1.y;
  #while (county<crnr2.y)
    #declare county=county+qual.y;

    #declare countz=crnr1.z;
    #while (countz<crnr2.z)
      #declare countz=countz+qual.z;
     
        sphere{ 0,1,((max_thresh-min_thresh)*rand(dmr)+min_thresh) scale qual 
          rotate sph_rotate
          translate<countx+(rand(dmr)-.5)*qual.x*.3,county+(rand(dmr)-.5)*qual.y*.3,countz+(rand(dmr)-.5)*qual.z*.3>

         #if (county>y_stopp_value)  scale 0.00001 #end
            
             }         
      #end
    #end
  #end

#end
#end



#declare man_kleid= 
blob{ threshold .5
 cylinder{ <-.1,.05,-.2> ,<-.1,.05,.2>  ,.125, 1 scale <1.1,1,1> vs2()}  
 cylinder{ <.1,.05,-.2>,<.1,.05,.2>,.125,1 scale <1.1,1,1> vs2()}
 cylinder{ <-.05,.03,-.2> ,<-.05,.03,.2>  ,.125, 1 scale <1.1,1,1> vs2()}  
 cylinder{ <.05,.03,-.2>,<.05,.03,.2>,.125,1 scale <1.1,1,1> vs2()}
 cylinder{ <0,0.02,-.2>,<0,0.02,.2>,0.125,1 scale <1.75,1,1> vs2()}

 cylinder{ <-.1,.04,-1> ,<-.1,.05,.17>  ,.067, -5 scale <1.1,1,1> vs2()}  
 cylinder{ <.1,.04,-1>,<.1,.05,.17>,.067,-5 scale <1.1,1,1> vs2()}
 cylinder{ <-.05,.02,-1> ,<-.05,.03,.17>,.067, -5 scale <1.1,1,1> vs2()}  
 cylinder{ <.05,.02,-1>,<.05,.03,.17>,.067,-5 scale <1.1,1,1> vs2()}
 cylinder{ <0,0.01,-1>,<0,0.02,.17>,0.067,-5 scale <1.75,1,1> vs2()}

 cylinder{ <-.1,.0,-.25-.12> ,<-.1,.05,.2-.08>  ,.13, 1 scale <1.1,1,1> versch1() vs2()}  
 cylinder{ <.1,.0,-.25-.12>,<.1,.05,.2-.08>,.13,1 scale <1.1,1,1> versch1() vs2()}
 cylinder{ <-.05,-.02,-.25-.12> ,<-.05,.05,.2-.08>  ,.13, 1 scale <1.1,1,1> versch1() vs2()}  
 cylinder{ <.05,-.02,-.25-.12>,<.05,.03,.2-.08>,.13,1 scale <1.1,1,1> versch1() vs2()}
 cylinder{ <0,-.03,-.25-.12>,<0,0.02,.2-0.08>,0.13,1 scale <1.75,1,1> versch1() vs2()}


 cylinder{ <0,0,0>, <0,.4,0>, .18,2.4 scale<1.5,1,.85> 
           translate <0,.48,-.01>}

 cylinder{ <0,-.025>,<0,.3,0>, .13,1 
           rotate x*30
           rotate z*50
           scale <1,1.5,1>
           translate <-.16,.9,.01>
           }          

 cylinder{ <0,-.025>,<0,.3,0>, .13,1 
           rotate x*30
           rotate z*-50
           scale <1,1.5,1>
           translate <.16,.9,.01>
           }          

#declare distortmap_on=true;

#declare random_start=71;
#declare crnr1=<-.25,.1,-.3>+tv2;
#declare crnr2=<.25,1,.3>;
#declare qual=<0.05,0.2,0.05>;
#declare y_stopp_value=.99;
#declare max_thresh=.25;
#declare min_thresh=-.25;
#declare sph_rotate=z*20;
distortmap()

#declare crnr1=<-.25,-.1,-.3>+tv2;
#declare crnr2=<.25,.2,.3>+tv2;
#declare qual=<0.05,0.05,0.2>*.7;
#declare max_thresh=.1;
#declare min_thresh=-.05;
#declare sph_rotate=x*-50;
#declare y_stopp_value=100;
distortmap()

#declare crnr1=<-.7,.8,-.3>;
#declare crnr2=<-.1,1.2,.3>;
#declare qual=<0.2,0.2,0.0295>*.7;
#declare max_thresh=.2;
#declare min_thresh=-.075;
#declare sph_rotate=y*-30;
distortmap()

#declare crnr1=<.1,.8,-.3>;
#declare crnr2=<.7,1.2,.3>;
#declare qual=<0.2,0.2,0.0295>*.7;
#declare max_thresh=.2;
#declare min_thresh=-.075;
#declare sph_rotate=y*35;
distortmap()

}

//-------------------------------------------------------------------

#declare bounding_object_man1=union{

box{
<-.22,-.1,-.27>,<0.22,1,0.335> 
//pigment{Green}
}

box{
<-.4375,.795,-0.075>
  ,<.435,1.325,.24>
//pigment{Yellow}
}
}

//-----------------------------------------------------------------

#declare bounding_object_man2= 
union{
cylinder{<0,0.05,-.27>,<0,0.05,.335>,.125*.83 scale <2,1,1> vs2() //pigment{Green}
                           }
cylinder{<0,0.02,-.27-.12>,<0,0.02,.2>,.13 scale <1.8,1.3,1>  //pigment{Red} 
                                                       versch1() vs2()}
cylinder{ <0,-.15,0>, <0,.55,0>, .18*0.85 scale<1.5,1,.85> 
           translate <0,.48,-.01> //pigment{Blue}
                 }
cylinder{ <0,-.025-.1,0>,<0,.3+.1,0>, .13*.85
           rotate x*30
           rotate z*50
           scale <1,1.5,1>
           translate <-.16,.9,.01>
  //         pigment{Yellow}
           }          
cylinder{ <0,-.025-.1>,<0,.3+.1,0>, .13*.85
           rotate x*30
           rotate z*-50
           scale <1,1.5,1>
           translate <.16,.9,.01>
//           pigment{Yellow}
           }          

}

///--------------------------------------------

#declare uat=0.06

#declare bounding_object_kopfbedeckung=union{

cylinder{<0,.07,0>,<0,1.1,0>,.35*.85 scale <.7,.35,.6> scale <1,1,0.3> translate <0,-.05-uat,-.1> 
// pigment{Yellow}
}

sphere{0,0.11*1.35*.9 scale <1.25,1,1.4> rotate x*-45 translate <0,1.22,-.015>-<0,0.85,-.1> 
  rotate x*-15 //pigment{Green}
     }

 rotate x*15
 scale <0.8,1,1>
 translate <0,.825,-.1>
}


union{


difference{
object{man_kleid}

difference{
 union{
 plane{-z,0  rotate y*-30 translate <-.372,0,.18>}
 plane{-z,0 rotate y*50 translate <.375,0,.18>}
 }
 plane{y,0 translate <0,1,0>}
}


bounded_by{bounding_object_man2} clipped_by{bounded_by}
pigment{White}
finish{ambient 0.2}

}


#declare kopfbedeckung=blob{ threshold .5

cylinder{<0,.17,0>,<0,1,0>,.35,1 scale <1,.35,.6> scale <1,1,0.3> translate <0,-.05-uat,-.1> }
cylinder{0,<0,1,0>,.35,-.4 scale <1,.35,.6> scale <1,1,.3> rotate x*5 translate <0,-.05-uat,-.14> }
sphere{0,0.11*1.35,2 scale <1.25,1,1.4> rotate x*-45 translate <0,1.22,-.005>-<0,0.85,-.1> rotate x*-15 }
sphere{0,0.11*1,-1 scale <1.25,1,1.4> rotate x*-45 translate <0,1.18,-.005>-<0,0.85,-.1> rotate x*-15 }

#declare random_start=144
#declare crnr1=<-.35,-.2,-.25>;
#declare crnr2=<.35,.6,.2>;
#declare qual=<0.0295,0.1,0.2>*1.3;//*.7;//<0.05,0.4,0.2>
#declare max_thresh=.2;
#declare min_thresh=-.175;
//#declare sph_rotate=y*35;
#declare sph_rotate=z*-13;
distortmap()

#declare random_start=144
#declare crnr1=<-0.20,-.0,-.29>+<0,1.18,-.005>-<0,0.85,-.1>;
#declare crnr2=<.20,.25,.20>+<0,1.18,-.005>-<0,0.85,-.1>;
#declare qual=<0.1,0.03,0.2>*.7;//*.7;//<0.05,0.4,0.2>
#declare max_thresh=.17;
#declare min_thresh=-.075;
#declare sph_rotate=x*-45;
distortmap()

#declare random_start=144
#declare crnr1=<-0.20,.0,-.30>+<0,1.18,-.005>-<0,0.85,-.1>;
#declare crnr2=<.20,.3,-.15>+<0,1.18,-.005>-<0,0.85,-.1>;
#declare qual=<0.1,0.1,0.03>*.7;//*.7;//<0.05,0.4,0.2>
#declare max_thresh=.05;
#declare min_thresh=-.275;
#declare sph_rotate=x*-45;
//distortmap()

rotate x*15
scale <0.8,1,1>
translate <0,.825,-.1>

bounded_by{bounding_object_kopfbedeckung} clipped_by{bounded_by}

pigment{White}
}

//box{<-.35,-.2,-.3>,<.35,.5,.3> pigment{Green} rotate x*15 scale <0.8,1,1> translate <0,.825,-.1> }

cylinder{0,<0,0.16,0>,.07 translate <0,0.9,0> pigment{Flesh}}
sphere{0,0.09 scale <1,1.3,1.5> rotate x*-45 translate <0,1.15,0> pigment{Flesh} }

//object{bounding_object_man2}

#declare haut=texture{pigment{Flesh} finish{diffuse 0.45}}

object{Arm scale 0.025
           rotate x*-5
           translate <0,.3,0>
           scale <-1,1,1>
           rotate y*-100
           rotate x*30
           rotate z*40
           translate <0,.045,0>
           translate <-.16,.9,.01>

}

object{Arm scale 0.025
           translate <0,.3,0>
           rotate y*130
           rotate x*30
           rotate z*-40
           translate <0,0.045,0>
           translate <.16,.9,.01>

}

object{FOOT scale 0.85 scale 0.9 rotate x*100 translate <-.1,-0,-.35> texture{haut}}//pigment{Flesh}}
object{FOOT scale <-1,1,1> scale 0.85 scale 0.9 rotate x*90 translate
<0.095,-.0225,-.35> texture{haut}}//pigment{Flesh}}

cylinder{ <0,0,-.24>,<0,0,.1>,.04 translate <0,0,.24> rotate x*10 translate <0,0,-.24>
       scale <0.7*0.85,0.85*0.85,1>*.95 translate <-.13,-.01,0> texture{haut}}//pigment{Flesh}}
cylinder{ <0,0,-.24>,<0,0,.1>,.04 translate <0,0,.24> rotate x*5 translate <0,0,-.24>
         scale <0.9*0.85,1*0.85,1>*.95 translate <.1,-.035,0> texture{haut}}//pigment{Flesh}}

object{kopfbedeckung finish{ambient .2}}

scale <1.8,1.5,1.5>*.33
rotate x*4
rotate y*-20
translate <18,2.68,3>
//translate <19-.5,2.5+.5,4>
}

