#include "colors.inc"

#macro distortmap()

#declare dmr=seed(random_start);

#if (distortmap_on=true)

#declare s_rad=qual*1.3;

#declare countx=crnr1.x;
#while (countx<crnr2.x)
  #declare countx=countx+qual.x;

  #declare county=crnr1.y;
  #while (county<crnr2.y)
    #declare county=county+qual.y;

    #declare countz=crnr1.z;
    #while (countz<crnr2.z)
      #declare countz=countz+qual.z;
     
        sphere{ 0,1,((max_thresh-min_thresh)*rand(dmr)+min_thresh) scale qual 
          rotate sph_rotate
          translate<countx+(rand(dmr)-.5)*qual.x*.3,county+(rand(dmr)-.5)*qual.y*.3,countz+(rand(dmr)-.5)*qual.z*.3>

         #if (county>y_stopp_value)  scale 0.00001 #end
            
             }         
      #end
    #end
  #end

#end
#end

//_----------

#declare distortmap_on=true


#declare stabr=seed(7787);

#declare stab=blob{ threshold .8

// cylinder{ <0,0,0>,<0,0,6>, .1,1 scale <1,1,0.5>}

#declare i=0;
#declare stabtx=0;
#declare stabty=0;
#while(i<3)

#declare stabtx=stabtx+(rand(stabr)-.5)*0.006;
#declare stabty=stabty+(rand(stabr)-.5)*0.006;
sphere{0,.05,.1 scale <1+i*.15,1+i*.15,3> translate <stabtx,stabty,i> }
#declare i=i+.005;

#end

#declare random_start=71;
#declare crnr1=<-.1,-.1,-.1>*2;
#declare crnr2=<.2,.2,3.1>;
#declare qual=<0.03,0.03,0.03>;
#declare y_stopp_value=999;
#declare max_thresh=.5;
#declare min_thresh=-.5;
#declare sph_rotate=0*x;
distortmap()

#declare random_start=71;
#declare crnr1=<-.1,-.1,-.1>*2;
#declare crnr2=<.2,.2,3.1>;
#declare qual=<0.1,0.1,0.1>;
#declare y_stopp_value=999;
#declare max_thresh=.15;
#declare min_thresh=-.15;
#declare sph_rotate=0*x;
distortmap()


pigment{Brown}

}

/*

camera{location <0,2,-2>
look_at <0,0,2>
}

light_source{ <40,40,-40>
color White
}


*/

