global_settings { max_trace_level 20 }
#include "glas.inc"

camera
  {
  location  <-1,1,-2>
  up        <0,.5,0>
  right     <0.66,0,0>
  look_at   <0,.75,0>
  }

polygon
  {
  5,
  <-.5,.5,0>,<.5,.5,0>,<.5,-.5,0>,<-.5,-.5,0>,<-.5,.5,0>
  pigment
    {
    image_map { png "signature.png" }
    translate -.5
    translate <-.0125,0,0>
    }
  finish
    {
    ambient 1
    }
  scale <1.33,1,1>
  rotate <6,0,0>
  rotate <0,27.5,0>
  scale .285
  translate 0.751*<-1,1-.75,-2>
  translate <0,.75,0>
  }

polygon
  {
  5,
  <-1,1,0>,<1,1,0>,<1,-1,0>,<-1,-1,0>,<-1,1,0>
  scale <1.33,1,1>
  rotate <6,0,0>
  rotate <0,27.5,0>
  scale .2
  translate 0.75*<-1,1-.75,-2>
  translate <0,.75,0>
  pigment
    {
    bozo    
    frequency 1
    turbulence 1
    scale .0001
    rotate <45,45,45>
    
    color_map
      {
      [0.0 color rgbt <1.,1.,1.,.85> ]
      [0.5 color rgbt <.5,.5,.5,1.> ]
      [1.0 color rgbt <.0,.0,.0,.85> ]
      }
    }
  finish
    {
    ambient .5
    }
  }
  
sky_sphere
  {
    pigment { gradient y
              scale .5
              translate <0,.5,0>
              color_map
	        {
	        [ 0.00 color rgb <.0,.0,.0> ]
		[ 0.45 color rgb <.2,.2,.2> ]
	        [ 0.92 color rgb <.3,.3,.3> ]
	        [ 0.98 color rgb <.4,.4,.4> ]
	        [ 1.00 color rgb <.5,.5,.5> ]
	        }
	     }
    pigment { bozo
              turbulence .4
	      translate <0,.2,0>
              scale <.5,.05,.1>
	      color_map
	        {
		[ 0.00 color rgbt <1,1,1,1> ]
		[ 0.70 color rgbt <1,1,1,1> ]
		[ 1.00 color rgbt <1,1,1,0> ]
	        }
	     }
  }

plane { <0,1,0>,0 
        pigment { color rgb <.3,.3,.3> }
	finish  { ambient .33
	          reflection .3 
		  phong_size 600 
		  phong 1.5
		  specular 0.5
		  roughness 0.003 }
	normal  { waves .5 turbulence .125 frequency .5 translate <-70,0,-100>} }

light_source { <1000,300,1000> color rgb <1,1,1>
               area_light <500,0,0>,
	                  <0,500,0>,
			  3,3
                          adaptive .1
			  jitter 
                          }


union
  {
  object
    {
    glass
    pigment { color rgbf <1,1,1,.96> }
    finish  { ambient .0
	      phong_size 400
	      roughness 0.003
	      specular .5
	      phong 1.5
	      reflection .04
	      ior 1.523
	      refraction on
	      caustics 0.75  }
    normal  { waves 0.5 turbulence .125 frequency .5 rotate 20 } 
    scale .25
    }

  object
    {
    wasser
    pigment { color rgbf <1,1,1,.98> }
    finish  { ambient .0
              roughness 0.0003
	      specular .5
	      phong 1
	      reflection .02
	      ior 1.33
	      refraction on
	      caustics .5
	      phong_size 400 }
     scale .25
     }

  object
    {
    strohhalm
    }
  translate <-.25,.55,0>
  }


merge
  {
  cylinder { <0,.05,0>,<0,0,0>,1 }
  torus    { 1,.05 }
  texture
    {
    material_map { png "material.png"
      texture
        {
	pigment
	  {
	  color rgb <0,0,0>
	  }
	finish
	  {
	  phong 1
	  phong_size 100
	  reflection .2
	  }
	}
      texture
        {
	pigment
	  {
	  wood
	  scale <.01,1,1>
	  rotate 2
	  turbulence .2
	  color_map
	    {
	    [ 0.0 color rgb <.7,.7,.7> ]
	    [ 0.7 color rgb <.7,.7,.7> ]
	    [ 1.0 color rgb <.4,.4,.4> ]
	    }
	  }
        finish { ambient .3 phong .25 phong_size 25 reflection .1 }
	normal { wood 0.1 scale <.01,1,1> rotate 2 turbulence .2 }
        }
      texture
        {
	pigment
	  {
	  wood
	  scale <.02,.5,.5>
	  rotate -1
	  turbulence .2
	  color_map
	    {
	    [ 0.0 color rgb <.6,.6,.6> ]
	    [ 0.9 color rgb <.7,.7,.7> ]
	    [ 1.0 color rgb <.2,.2,.2> ]
	    }
	  }
        finish { ambient .3 phong .25 phong_size 25 reflection .1 }
	normal { wood .05  scale <.02,.5,.5> rotate -1  turbulence .2}
        }
      texture
        {
	pigment
	  {
	  wood
	  scale <.02,.5,.5>
	  rotate -3
	  turbulence .3
	  color_map
	    {
	    [ 0.0 color rgb <.5,.5,.5> ]
	    [ 0.9 color rgb <.7,.7,.7> ]
	    [ 1.0 color rgb <.4,.4,.4> ]
	    }
	  }
        finish { ambient .3 phong .25 phong_size 25 reflection .1 }
        normal { wood 0.1 scale <.02,.5,.5> rotate -3 turbulence .3 }
	}
      texture
        {
	pigment
	  {
	  wood
	  scale <.005,.2,.5>
	  rotate 3
	  turbulence .3
	  color_map
	    {
	    [ 0.0 color rgb <.5,.5,.5> ]
	    [ 0.5 color rgb <.7,.7,.7> ]
	    [ 1.0 color rgb <.4,.4,.4> ]
	    }
	  }
        finish { ambient .3 phong .25 phong_size 25 reflection .1 }
	normal { wood 0.05 scale <.005,.2,.5> rotate 3 turbulence .3 }
        }
      }
    scale <1,2.2,1>
    translate -1.1
    rotate <90,0,0>
    }
  translate <-1,.5,0>
  }
  
box { <-.5,-.5,-.5>,<.5,.5,.5>
      pigment
        {
	image_map { png "photography.png" once }
	translate -.5
	}
      finish
        {
	phong_size 200
	phong .7
	ambient .625
	reflection .15
	}
      scale <.3,.5,.00125>
      rotate <90,0,0>
      translate <0,.000625,0>
      rotate <0,-10,0>
      translate <-.4,.55,-.35>
      }

box { <-.5,-.5,-.5>,<.5,.5,.5>
      pigment
        {
	image_map { png "letter.png" once }
	translate -.5
	scale 1.01
	}
      finish
        {
	phong_size 1
	phong 0
	ambient .375
	reflection 0
	}
      normal
        {
	wrinkles 0.75
	frequency 4
	scale .75
	}
      scale <.42,.75,.00124>
      rotate <90,0,0>
      translate <0,.000625,0>
      rotate <0,-2,0>
      translate <-.6,.55,-.25>
      }

union
  {
  #declare Count=19
  #declare R=seed(0)
  #while (Count>=0)
    sphere { 0,rand(R)*.01+0.01
             scale <.75,1,.25> scale .5
	     translate <(rand(R)-.5)*.3,(rand(R)-.5)*.5,0>
             pigment { color rgbf <1,1,1,.9> }
             finish  { ambient 0
                       roughness 0.03
	               specular .75
	               phong 1
	               reflection 0.3
	               ior 1.34
	               refraction on
	               caustics .5
	               phong_size 200 }
           }
  #declare Count=Count-1 #end
  rotate <90,0,0>
  translate <0,.005,0>
  rotate <0,-10,0>
  translate <-.5,.55,-.5>
  }

union {
union
  {
  cylinder { <-1,.5,0>,<1,.5,0>,0.04 }
  cylinder { <-1,.25,0>,<1,.25,0>,0.04 }
  pigment { color rgb <.7,.7,.7> }
  finish  { ambient .3
	    reflection .125
	    metallic
	    phong 1
	    phong_size 200
	    specular .5
	    roughness 0.1
	  }
  }

union
  {
  cylinder { <.5,.5,0>,<.5,0,0>,0.04 }
  sphere   { <.5,.5,0>,0.07 }
  sphere   { <.5,.25,0>,0.07 }
  texture
    {
    pigment { color rgb <1,1,1> }
    finish  { ambient .2
	      reflection .05
	      specular .5
	      phong 1
	      phong_size 400
	      roughness 0.05
	    }
    normal  {
            bumps 0.5
	    frequency 100
	    scale .25
	    }
    }
  }
rotate <0,20,0>
}
