
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "stones.inc"


camera
{
rotate 90*x
  location  <-5 , 12.0 ,-25.0>
  look_at   <0.0 , 12.0 , 0.0>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-15, 15, -15>
}

plane {y,1 pigment {rgbt <0,.4,1,.5>} normal {bumps scallop_wave}}
plane {y,.9 pigment {Black}}

height_field {gif "ray-trace\imap1.gif" water_level .01 pigment {Gray10} translate <-.5,0,-.5> rotate 90*y scale <6,18,6> }
height_field {gif "ray-trace\splash.gif" water_level .01 pigment {Gray10}  scale <3,3,3> rotate 90*y translate <-5,0,3>}
height_field {gif "ray-trace\splash.gif" water_level .01 pigment {Gray10} scale <3,3,3>  rotate 180*y translate <-5,0,5>}
height_field {gif "ray-trace\splash.gif" water_level .01 pigment {Gray10} scale <3,3,3>  rotate 236*y translate <6,0,2>}

#declare flash= cone {<-.5,0,0>,0,<.5,0,0>,1 hollow pigment {White filter 1}
halo {emitting color_map {[0.0 rgbt <0,0,1,.8>][0.5 rgbt <0,.25,1,.8>]
    [0.500 0.510 color White
               color Very_Light_Purple filter 0.65]
    [0.510 0.520 color Very_Light_Purple filter 0.65
               color Very_Light_Purple filter 0.65]
    [0.520 0.530 color Very_Light_Purple filter 0.65
               color Light_Purple      filter 0.85]
    [0.530 0.545 color Light_Purple      filter 0.85
               color Light_Purple      filter 0.85]
    [0.545 0.565 color Light_Purple      filter 0.85
               color Med_Purple        filter 0.95]
    [0.565 0.6 color Med_Purple        filter 0.95
               color Med_Purple        filter 0.95]
                          [0.6 rgbt <0,.25,1,.5>][1 rgbt <0,0,1,.5>]} turbulence .5 planar_mapping linear
                          max_value 1 rotate 90*y}
translate .5*x
scale <5,5,5>
}

object {flash translate <-1.62,20.32,1.2>}
object {flash rotate 72*z translate <-1.62,20.32,1.2>}
object {flash rotate 144*z translate <-1.62,20.32,1.2>}
object {flash rotate 226*z translate <-1.62,20.32,1.2>}
object {flash rotate 298*z translate <-1.62,20.32,1.2>}


#declare segment1=difference
{
torus
{
  0.8,
  0.2
}
box
{
  <0,-1,1>  // one corner position <X1 Y1 Z1>
  < 1,  1,  -1>  // other corner position <X2 Y2 Z2>
}
}

#declare segment2=difference
{
torus
{
  0.8,
  0.2
}
box
{
  <0,-1,1>  // one corner position <X1 Y1 Z1>
  < -1,  1,  -1>  // other corner position <X2 Y2 Z2>
}
}
merge {
object {segment2 rotate 18*x translate -.5*y  scale <4,7,4>}
object {segment1 rotate -18*x scale <4,7,4>}
object {segment2 rotate 18*x translate .5*y scale <4,7,4>}
object {segment1 rotate -18*x translate 1*y scale <4,7,4>}
object {segment2 rotate 18*x translate 1.5*y scale <4,7,4>}
object {segment1 rotate -18*x translate 2*y scale <4,7,4>}
//object {segment2 rotate 18*x translate 2.5*y  scale <4,7,4>}
//object {segment1 rotate -18*x translate 3*y  scale <4,7,4>}

translate <-.8,3,1>
hollow
pigment {rgbt <0,.4,1,.5>}normal { waves 1 scale .1 turbulence 2 }
}
//fog {fog_type 2 distance 5 color Gray40 fog_offset -20 fog_alt .5 up y rotate 180*z}
fog {fog_type 2 distance 5 color Gray40 fog_offset 4 fog_alt .5 up y}

sky_sphere {
    pigment {
      gradient y
      color_map {
        [0.000 0.002 color rgb <0.0, 0.0, 0.1>
                     color rgb <0.0, 0.0, 0.1>]
        [0.002 0.200 color rgb <0.0, 0.01, 0.075>
                     color rgb <0.02, 0.0, 0.075>]
      }
      scale 2
      translate -1
    }
    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.085, 0.085, 0.085>
                   color rgb <0.075, 0.075, 0.075>]
          [0.1 0.5 color rgb <0.075, 0.075, 0.075>
                   color rgbt <0.1, .1, .1, 1>]
          [0.5 1.0 color rgbt <.1, .1, .1, 1>
                   color rgbt <.1, .1, .1, 1>]
      }
      scale <0.2, 0.5, 0.2>
    }
    rotate -135*x
  }

#declare lefthand=blob {
    threshold .65

    sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
    sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
    sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel

    cylinder { <-.65,-.28,0>, <-.65,.28,-.05>, .26, 1 }    //lower pinky
    cylinder { <-.65,.28,-.05>, <-.65, .68,-.2>, .26, 1 }  //upper pinky

    cylinder { <-.3,-.28,0>, <-.3,.44,-.05>, .26, 1 }      //lower ring
    cylinder { <-.3,.44,-.05>, <-.3, .9,-.2>, .26, 1 }     //upper ring

    cylinder { <.05,-.28,0>, <.05, .49,-.05>, .26, 1 }     //lower middle
    cylinder { <.05,.49,-.05>, <.05, .95,-.2>, .26, 1 }    //upper middle

    cylinder { <.4,-.4,0>, <.4, .512, -.05>, .26, 1 }      //lower index
    cylinder { <.4,.512,-.05>, <.4, .85, -.2>, .26, 1 }    //upper index

    cylinder { <.41, -.95,0>, <.85, -.68, -.05>, .25, 1 }  //lower thumb
    cylinder { <.85,-.68,-.05>, <1.2, -.4, -.2>, .25, 1 }  //upper thumb

 sphere { <-.65,.28,-.05>, .26, -1 } //counteract pinky knuckle bulge
  sphere { <-.65,-.28,0>, .26, -1 }   //counteract pinky palm bulge

  sphere { <-.3,.44,-.05>, .26, -1 }  //counteract ring knuckle bulge
  sphere { <-.3,-.28,0>, .26, -1 }    //counteract ring palm bulge

  sphere { <.05,.49,-.05>, .26, -1 }  //counteract middle knuckle bulge
  sphere { <.05,-.28,0>, .26, -1 }    //counteract middle palm bulge

  sphere { <.4,.512,-.05>, .26, -1 }  //counteract index knuckle bulge
  sphere { <.4,-.4,0>, .26, -1 }      //counteract index palm bulge

  sphere { <.85,-.68,-.05>, .25, -1 } //counteract thumb knuckle bulge
  sphere { <.41,-.7,0>, .25, -.89 }   //counteract thumb heel bulge

  pigment {Flesh}

  scale <.06,.1,.1>
  rotate -180*y
  rotate -80*z
  translate <1.05,.8,-.9>
  }

#declare righthand = blob {
    threshold .65

    sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
    sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
    sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel

    cylinder { <-.65,-.28,0>, <-.65,.28,-.05>, .26, 1 rotate 60*x}    //lower pinky
    cylinder { <-.65,.28,-.05>, <-.65, .68,-.2>, .26, 1 rotate 120*x}  //upper pinky

    cylinder { <-.3,-.28,0>, <-.3,.44,-.05>, .26, 1 rotate 60*x}      //lower ring
    cylinder { <-.3,.44,-.05>, <-.3, .9,-.2>, .26, 1 rotate 120*x}     //upper ring

    cylinder { <.05,-.28,0>, <.05, .49,-.05>, .26, 1 rotate 60*x}     //lower middle
    cylinder { <.05,.49,-.05>, <.05, .95,-.2>, .26, 1 rotate 120*x}    //upper middle

    cylinder { <.4,-.4,0>, <.4, .512, -.05>, .26, 1 rotate 60*x}      //lower index
    cylinder { <.4,.512,-.05>, <.4, .85, -.2>, .26, 1 rotate 120*x}    //upper index

    cylinder { <.41, -.95,0>, <.85, -.68, -.05>, .25, 1 }  //lower thumb
    cylinder { <.85,-.68,-.05>, <1.2, -.4, -.2>, .25, 1 }  //upper thumb

 sphere { <-.65,.28,-.05>, .26, -1  rotate 120*x} //counteract pinky knuckle bulge
  sphere { <-.65,-.28,0>, .26, -1 rotate 60*x}   //counteract pinky palm bulge

  sphere { <-.3,.44,-.05>, .26, -1  rotate 120*x}  //counteract ring knuckle bulge
  sphere { <-.3,-.28,0>, .26, -1 rotate 60*x}    //counteract ring palm bulge

  sphere { <.05,.49,-.05>, .26, -1  rotate 120*x}  //counteract middle knuckle bulge
  sphere { <.05,-.28,0>, .26, -1 rotate 60*x}    //counteract middle palm bulge

  sphere { <.4,.512,-.05>, .26, -1 rotate 120*x }  //counteract index knuckle bulge
  sphere { <.4,-.4,0>, .26, -1 rotate 60*x}      //counteract index palm bulge

  sphere { <.85,-.68,-.05>, .25, -1 } //counteract thumb knuckle bulge
  sphere { <.41,-.7,0>, .25, -.89 }   //counteract thumb heel bulge

  pigment {Flesh}

  scale <.1,.06,.1>
  //rotate -120*y
  rotate 100*z
translate <.05,.75,-.9>
 }

#declare head=merge{
torus
{
  0.4,
  0.1
texture {Gold_Metal}
scale <1,2,1>
}

cone
{
  1*y,  0.0,
  -1*y, .1
texture {Gold_Metal}
  // open
  scale <1,.2,1>
translate <.4*sin(-5*pi/6), .3, .4*cos(-5*pi/6)>
}
cone
{
  1*y,  0.0,
  -1*y, .1
texture {Gold_Metal}
  scale <1,.2,1>
translate <.4*sin(-pi/2), .3, .4*cos(-pi/2)>
  // open
}
cone
{
  1*y,  0.0,
  -1*y, .1
texture {Gold_Metal}
  scale <1,.2,1>
translate <.4*sin(-pi/6), .3, .4*cos(-pi/6)>
   // open
}
cone
{
  1*y,  0.0,
  -1*y, .1
texture {Gold_Metal}
  scale <1,.2,1>
translate <.4*sin(5*pi/6), .3, .4*cos(5*pi/6)>
   // open
}
cone
{
  1*y,  0.0,
  -1*y, .1
texture {Gold_Metal}

scale <1,.2,1>
translate <.4*sin(pi/2), .3, .4*cos(pi/2)>
   // open
}
cone
{
  1*y,  0.0,
  -1*y, .1
texture {Gold_Metal}
scale <1,.2,1>
translate <.4*sin(pi/6), .3, .4*cos(pi/6)>
   // open
}

sphere
{
  1*y,  0.1
pigment {Blue}
  // open

translate <.4*sin(-5*pi/6), -.6, .4*cos(-5*pi/6)>
}
sphere
{
  1*y,  0.1

pigment {Blue}

translate <.4*sin(-pi/2), -.6, .4*cos(-pi/2)>
  // open
}
sphere
{
  1*y,  0.1

pigment {Blue}

translate <.4*sin(-pi/6), -.6, .4*cos(-pi/6)>
   // open
}
sphere
{
  1*y,  0.1

pigment {Blue}

translate <.4*sin(5*pi/6), -.6, .4*cos(5*pi/6)>
   // open
}
sphere
{
  1*y,  .1

pigment {Blue}


translate <.4*sin(pi/2), -.6, .4*cos(pi/2)>
   // open
}
sphere
{
  1*y,  .1

pigment {Blue}

translate <.4*sin(pi/6), -.6, .4*cos(pi/6)>
   // open
}

blob{
threshold .1

  sphere { 0*y, 2.4,10
    finish {
      ambient .1
}
pigment {Flesh}
translate <0, 4.6, 5>
  }
sphere {0*y,.4,1
pigment{color rgbf <0.1, 0.7, 1, 0.7>}
finish {ambient 10}
translate <.5,5,3>}
sphere {0*y,.4,1
pigment{color rgbf <0.1, 0.7, 1, 0.7>}
finish {ambient 10}
translate <-.5,5,3>
}

sphere {0*y,.5,1
pigment {Flesh}
translate <0,4.9,3.5>
finish {ambient .1}}
translate <0,-6,-4.8>
rotate -20*x
rotate 15*y
scale <.25,.3,.3>
}}

#declare Man=
merge
{
height_field {gif "imap2.gif" water_level .9 rotate -90*x
pigment {image_map {gif "imap2a.gif"}}}
object {head scale .27 translate <.52,.9,-.9>}
object {righthand}
object {lefthand}
cylinder {<0,0,0>,<0,1,0>,.03 texture {Gold_Metal} rotate 20*z translate <.3,.1,-.9>}
torus {.03,.04 rotate 20*z texture {Gold_Metal} translate <-.03,1,-.9>}
sphere {<0,0,0>,.06 pigment{color rgbf <0.1, 0.1, 1, 0.7>} normal {ripples 1 turbulence 6} translate <-.06,1.06,-.9> finish {ambient 10}}
}

object {Man scale 2 translate <-1.5,18.2,4>}
