//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 6 textures and 11 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 10/18/1998    (18.10.1998)
//



/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-6, -170, 393.390>
  direction <0.0,     0.0,  1.4297>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.460, -189.862, 389.936>
}

//
// *******  L I G H T S *******
//

light_source {   // Spotlight SpotLite001
  <-4.580, -174.962, 396.954>
  color  rgb <1.1000, 0.837, 0.2>
  spotlight
    point_at  <-4.181, -175.851, 397.180>
    falloff   47.97  // outer radius (in deg)
      radius    47.97  // inner radius
  fade_distance 60.0
  fade_power 1.5
  
  
}

//light_source {   // Light1
//  <0.540, -190.347, 389.571>
//  color rgb <0.530, 0.530, 0.530>
//  fade_distance  50.0
//  fade_power 1.3
//  atmospheric_attenuation on
//}

light_source {   // Light1
  <0.169, -190.610, 392.719>
  color rgb <1.00, 0.375, 0.375>
  fade_distance  60.0
  fade_power 1.5
  atmospheric_attenuation on
}


//
// ********  TEXTURES  *******
//

#include "e:\tim\water\tite\tite3.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

cylinder { // Cylndr002
  <0,0,1>, <0,0,0>, 1
  no_shadow
  hollow
  scale <0.2, 0.2, 10.0>
  translate  <-0.002429, -189.666047, 393.313342>
  texture {
    soda_straw
  }
}




sphere { // Sphere001
  <0,0,0>,1
  texture {
    drop_water
  }
  no_shadow
  scale <0.35, 0.35, 0.45>
  translate  <-0.005554, -189.668207, 392.890941>
}


plane { // Plane001
  z,0
  hollow
  scale 500.0
  rotate 2.39533*y
  translate  <-6.09708, -105.594784, 333.154551>
  texture {
    Cave_Water
  }
}


union { // Group001
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 500.0
    rotate -102.524223*x
    translate  <-26.331742, -1158.785931, 55.469757>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <400.0, 500.0, 500.0>
    rotate <-91.535454, 72.738602, 178.533676>
    translate  -116.090464*y
  }
  cone { // Cone3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 500.0
    rotate 92.66433*x
    translate  <-26.331742, 394.043767, -54.809713>
  }
  hollow
  texture {
    Marianna_Limestone
  }
}




#declare Seed = seed(0.5)
//#declare Rough = 0.5
//#declare rock320 = object {#include "e:\tim\water\tite\ROCK320.INC" }
//#declare rockscale = 1.0

#declare Rough = 6.0
#declare rockscale = 0.12500

#declare rock = object {#include "Rock.INC" }

object {rock

//ROCK1
  scale <rockscale*60.0, rockscale*75.0, rockscale*60.0>
  translate  <167.332378, -322.330515, 322.621451>
  texture {
    Marianna_Limestone
 }
}

object {rock

//ROCK2
  scale <rockscale*60.0, rockscale*75.0, rockscale*55.0>
  rotate -50.736168*z
  translate  <125.693172, -412.629844, 292.3132>
  texture {
    Marianna_Limestone
}
}

object {rock

//ROCK3
  scale <rockscale*60.0, rockscale*75.0, rockscale*80.0>
  rotate <118.219597, 36.685925, 99.077805>
  translate  <-81.809535, -365.272259, 301.405675>
  texture {
    Marianna_Limestone
  }
}

