//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 1 lights, 19 textures and 148 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.0 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 10/18/1998    (18.10.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.537,0.600,0.800> }

camera {  //  Camera Camera01
  location  <81.832, -51.510, 73.586>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <141.361, 86.702, 91.311>
}

//
// *******  L I G H T S *******
//

light_source {   // Sun
  <166.150, -377.286, 254.277>
  color rgb <0.700, 0.700, 0.700>
}


//
// ********  TEXTURES  *******
//

#include "wyrm.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare BaseSpike1 = object {
  cone { // BaseSpike1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.5, 0.5, 5.0>
    rotate -50.0*x
    translate  <0.0, -5.288889, 16.164632>
  }
}
#declare UpperSpike = object {
  cone { // UpperSpike
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.2, 0.2, 2.0>
    rotate -90.0*x
    translate  <-0.018174, -2.46014, 7.92406>
  }
}


#declare Railing1 = object {
  box { // Railing1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Maple
      rotate -90.0*z
    }
    scale <2.0, 23.0, 1.0>
    translate  <9.215853, 1.015649, -10.810857>
  }
}
#declare Support1 = object {
  box { // Support1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Maple
      rotate <0.0, -90.0, -90.0>
      translate <0.000000, -8.036365, 0.120714>
    }
    scale <2.0, 1.6, 5.0>
    rotate -90.0*z
    translate  <8.844615, -55.110199, -16.470861>
  }
}
#declare Hull1 = object {
  box { // Hull1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BallWoodNicked
      rotate <0.0, -90.0, -90.0>
    }
    scale <0.35, 35.0, 1.0>
    translate  <10.852088, -35.451937, -12.371256>
  }
}
#declare Spar1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, 3.988908, -0.194935>, <0.426328, 3.597497, -0.110946>, <0.426328, 3.079822, 0.023837>, <0.426328, 2.684205, 0.085027>, 
      <0.426328, 3.988908, -0.246432>, <0.426328, 3.597497, -0.162443>, <0.426328, 3.079822, -0.027660>, <0.426328, 2.684205, 0.033530>, 
      <0.426328, 3.988908, -0.315095>, <0.426328, 3.597497, -0.231107>, <0.426328, 3.079821, -0.096324>, <0.426328, 2.684205, -0.035134>, 
      <0.426328, 3.988908, -0.366592>, <0.426328, 3.597497, -0.282604>, <0.426328, 3.079821, -0.147821>, <0.426328, 2.684205, -0.086631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, 3.988908, -0.194935>, <0.170531, 3.988908, -0.194935>, <-0.170531, 3.988908, -0.194935>, <-0.426328, 3.988908, -0.194935>, 
      <0.426328, 3.597497, -0.110946>, <0.170531, 3.597497, -0.110946>, <-0.170531, 3.597497, -0.110946>, <-0.426328, 3.597497, -0.110946>, 
      <0.426328, 3.079822, 0.023837>, <0.170531, 3.079822, 0.023837>, <-0.170531, 3.079822, 0.023837>, <-0.426328, 3.079822, 0.023837>, 
      <0.426328, 2.684205, 0.085027>, <0.170531, 2.684205, 0.085027>, <-0.170531, 2.684205, 0.085027>, <-0.426328, 2.684205, 0.085027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, 3.988908, -0.194935>, <0.426328, 3.988908, -0.246432>, <0.426328, 3.988908, -0.315095>, <0.426328, 3.988908, -0.366592>, 
      <0.426328, 3.988908, -0.194935>, <0.170531, 3.988908, -0.246432>, <0.170531, 3.988908, -0.263598>, <0.170531, 3.988908, -0.315095>, 
      <0.426328, 3.988908, -0.194935>, <0.170531, 3.988908, -0.246432>, <0.085266, 3.988908, -0.246432>, <-0.170531, 3.988908, -0.246432>, 
      <0.426328, 3.988908, -0.194935>, <0.170531, 3.988908, -0.194935>, <-0.170531, 3.988908, -0.194935>, <-0.426328, 3.988908, -0.194935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 3.988908, -0.366592>, <-0.426328, 3.597497, -0.282604>, <-0.426328, 3.079821, -0.147821>, <-0.426328, 2.684205, -0.086631>, 
      <-0.426328, 3.988908, -0.315095>, <-0.426328, 3.597497, -0.231107>, <-0.426328, 3.079821, -0.096324>, <-0.426328, 2.684205, -0.035134>, 
      <-0.426328, 3.988908, -0.246432>, <-0.426328, 3.597497, -0.162443>, <-0.426328, 3.079822, -0.027660>, <-0.426328, 2.684205, 0.033530>, 
      <-0.426328, 3.988908, -0.194935>, <-0.426328, 3.597497, -0.110946>, <-0.426328, 3.079822, 0.023837>, <-0.426328, 2.684205, 0.085027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 3.988908, -0.366592>, <-0.426328, 3.988908, -0.315095>, <-0.426328, 3.988908, -0.246432>, <-0.426328, 3.988908, -0.194935>, 
      <-0.426328, 3.988908, -0.366592>, <-0.170531, 3.988908, -0.315095>, <-0.170531, 3.988908, -0.297929>, <-0.170531, 3.988908, -0.246432>, 
      <-0.426328, 3.988908, -0.366592>, <-0.170531, 3.988908, -0.315095>, <-0.085266, 3.988908, -0.315095>, <0.170531, 3.988908, -0.315095>, 
      <-0.426328, 3.988908, -0.366592>, <-0.170531, 3.988908, -0.366592>, <0.170531, 3.988908, -0.366592>, <0.426328, 3.988908, -0.366592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 3.988908, -0.366592>, <-0.170531, 3.988908, -0.366592>, <0.170531, 3.988908, -0.366592>, <0.426328, 3.988908, -0.366592>, 
      <-0.426328, 3.597497, -0.282604>, <-0.170531, 3.597497, -0.282604>, <0.170531, 3.597497, -0.282604>, <0.426328, 3.597497, -0.282604>, 
      <-0.426328, 3.079821, -0.147821>, <-0.170531, 3.079821, -0.147821>, <0.170531, 3.079821, -0.147821>, <0.426328, 3.079821, -0.147821>, 
      <-0.426328, 2.684205, -0.086631>, <-0.170531, 2.684205, -0.086631>, <0.170531, 2.684205, -0.086631>, <0.426328, 2.684205, -0.086631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, 1.599333, 0.174660>, <0.426328, 1.599333, 0.123163>, <0.426328, 1.599333, 0.054500>, <0.426328, 1.599333, 0.003003>, 
      <0.426328, 1.925790, 0.183282>, <0.426328, 1.925790, 0.131785>, <0.426328, 1.925790, 0.063122>, <0.426328, 1.925790, 0.011625>, 
      <0.426328, 2.361472, 0.134944>, <0.426328, 2.361472, 0.083447>, <0.426328, 2.361472, 0.014783>, <0.426328, 2.361472, -0.036714>, 
      <0.426328, 2.684205, 0.085027>, <0.426328, 2.684205, 0.033530>, <0.426328, 2.684205, -0.035134>, <0.426328, 2.684205, -0.086631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 1.599333, 0.174660>, <-0.170531, 1.599333, 0.174660>, <0.170531, 1.599333, 0.174660>, <0.426328, 1.599333, 0.174660>, 
      <-0.426328, 1.925790, 0.183282>, <-0.170531, 1.925790, 0.183282>, <0.170531, 1.925790, 0.183282>, <0.426328, 1.925790, 0.183282>, 
      <-0.426328, 2.361472, 0.134944>, <-0.170531, 2.361472, 0.134944>, <0.170531, 2.361472, 0.134944>, <0.426328, 2.361472, 0.134944>, 
      <-0.426328, 2.684205, 0.085027>, <-0.170531, 2.684205, 0.085027>, <0.170531, 2.684205, 0.085027>, <0.426328, 2.684205, 0.085027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 1.599333, 0.003003>, <-0.426328, 1.599333, 0.054500>, <-0.426328, 1.599333, 0.123163>, <-0.426328, 1.599333, 0.174660>, 
      <-0.426328, 1.925790, 0.011625>, <-0.426328, 1.925790, 0.063122>, <-0.426328, 1.925790, 0.131785>, <-0.426328, 1.925790, 0.183282>, 
      <-0.426328, 2.361472, -0.036714>, <-0.426328, 2.361472, 0.014783>, <-0.426328, 2.361472, 0.083447>, <-0.426328, 2.361472, 0.134944>, 
      <-0.426328, 2.684205, -0.086631>, <-0.426328, 2.684205, -0.035134>, <-0.426328, 2.684205, 0.033530>, <-0.426328, 2.684205, 0.085027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 1.599333, 0.003003>, <-0.426328, 1.925790, 0.011625>, <-0.426328, 2.361472, -0.036714>, <-0.426328, 2.684205, -0.086631>, 
      <-0.170531, 1.599333, 0.003003>, <-0.170531, 1.925790, 0.011625>, <-0.170531, 2.361472, -0.036714>, <-0.170531, 2.684205, -0.086631>, 
      <0.170531, 1.599333, 0.003003>, <0.170531, 1.925790, 0.011625>, <0.170531, 2.361472, -0.036714>, <0.170531, 2.684205, -0.086631>, 
      <0.426328, 1.599333, 0.003003>, <0.426328, 1.925790, 0.011625>, <0.426328, 2.361472, -0.036714>, <0.426328, 2.684205, -0.086631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, 0.551870, 0.028709>, <0.426328, 0.551870, -0.022788>, <0.426328, 0.551870, -0.091452>, <0.426328, 0.551870, -0.142949>, 
      <0.426328, 0.863594, 0.087795>, <0.426328, 0.863594, 0.036297>, <0.426328, 0.863595, -0.032366>, <0.426328, 0.863595, -0.083863>, 
      <0.426328, 1.282169, 0.166283>, <0.426328, 1.282169, 0.114786>, <0.426328, 1.282169, 0.046123>, <0.426328, 1.282169, -0.005374>, 
      <0.426328, 1.599333, 0.174660>, <0.426328, 1.599333, 0.123163>, <0.426328, 1.599333, 0.054500>, <0.426328, 1.599333, 0.003003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 0.551870, 0.028709>, <-0.170531, 0.551870, 0.028709>, <0.170531, 0.551870, 0.028709>, <0.426328, 0.551870, 0.028709>, 
      <-0.426328, 0.863594, 0.087795>, <-0.170531, 0.863594, 0.087795>, <0.170531, 0.863594, 0.087795>, <0.426328, 0.863594, 0.087795>, 
      <-0.426328, 1.282169, 0.166283>, <-0.170531, 1.282169, 0.166283>, <0.170531, 1.282169, 0.166283>, <0.426328, 1.282169, 0.166283>, 
      <-0.426328, 1.599333, 0.174660>, <-0.170531, 1.599333, 0.174660>, <0.170531, 1.599333, 0.174660>, <0.426328, 1.599333, 0.174660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 0.551870, -0.142949>, <-0.426328, 0.551870, -0.091452>, <-0.426328, 0.551870, -0.022788>, <-0.426328, 0.551870, 0.028709>, 
      <-0.426328, 0.863595, -0.083863>, <-0.426328, 0.863595, -0.032366>, <-0.426328, 0.863594, 0.036297>, <-0.426328, 0.863594, 0.087795>, 
      <-0.426328, 1.282169, -0.005374>, <-0.426328, 1.282169, 0.046123>, <-0.426328, 1.282169, 0.114786>, <-0.426328, 1.282169, 0.166283>, 
      <-0.426328, 1.599333, 0.003003>, <-0.426328, 1.599333, 0.054500>, <-0.426328, 1.599333, 0.123163>, <-0.426328, 1.599333, 0.174660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 0.551870, -0.142949>, <-0.426328, 0.863595, -0.083863>, <-0.426328, 1.282169, -0.005374>, <-0.426328, 1.599333, 0.003003>, 
      <-0.170531, 0.551870, -0.142949>, <-0.170531, 0.863595, -0.083863>, <-0.170531, 1.282169, -0.005374>, <-0.170531, 1.599333, 0.003003>, 
      <0.170531, 0.551870, -0.142949>, <0.170531, 0.863595, -0.083863>, <0.170531, 1.282169, -0.005374>, <0.170531, 1.599333, 0.003003>, 
      <0.426328, 0.551870, -0.142949>, <0.426328, 0.863595, -0.083863>, <0.426328, 1.282169, -0.005374>, <0.426328, 1.599333, 0.003003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, -0.350580, -0.194935>, <0.426328, -0.350580, -0.246432>, <0.426328, -0.350580, -0.315095>, <0.426328, -0.350580, -0.366592>, 
      <0.426328, -0.079845, -0.127842>, <0.426328, -0.079845, -0.179339>, <0.426328, -0.079845, -0.248002>, <0.426328, -0.079845, -0.299499>, 
      <0.426328, 0.277825, -0.023235>, <0.426328, 0.277825, -0.074732>, <0.426328, 0.277825, -0.143395>, <0.426328, 0.277825, -0.194893>, 
      <0.426328, 0.551870, 0.028709>, <0.426328, 0.551870, -0.022788>, <0.426328, 0.551870, -0.091452>, <0.426328, 0.551870, -0.142949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, -0.350580, -0.194935>, <0.170531, -0.350580, -0.194935>, <-0.170531, -0.350580, -0.194935>, <-0.426328, -0.350580, -0.194935>, 
      <0.426328, -0.350580, -0.194935>, <0.170531, -0.350580, -0.246432>, <0.085266, -0.350580, -0.246432>, <-0.170531, -0.350580, -0.246432>, 
      <0.426328, -0.350580, -0.194935>, <0.170531, -0.350580, -0.246432>, <0.170531, -0.350580, -0.263598>, <0.170531, -0.350580, -0.315095>, 
      <0.426328, -0.350580, -0.194935>, <0.426328, -0.350580, -0.246432>, <0.426328, -0.350580, -0.315095>, <0.426328, -0.350580, -0.366592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, -0.350580, -0.194935>, <0.426328, -0.079845, -0.127842>, <0.426328, 0.277825, -0.023235>, <0.426328, 0.551870, 0.028709>, 
      <0.170531, -0.350580, -0.194935>, <0.170531, -0.079845, -0.127842>, <0.170531, 0.277825, -0.023235>, <0.170531, 0.551870, 0.028709>, 
      <-0.170531, -0.350580, -0.194935>, <-0.170531, -0.079845, -0.127842>, <-0.170531, 0.277825, -0.023235>, <-0.170531, 0.551870, 0.028709>, 
      <-0.426328, -0.350580, -0.194935>, <-0.426328, -0.079845, -0.127842>, <-0.426328, 0.277825, -0.023235>, <-0.426328, 0.551870, 0.028709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, -0.350580, -0.366592>, <-0.426328, -0.350580, -0.315095>, <-0.426328, -0.350580, -0.246432>, <-0.426328, -0.350580, -0.194935>, 
      <-0.426328, -0.079845, -0.299499>, <-0.426328, -0.079845, -0.248002>, <-0.426328, -0.079845, -0.179339>, <-0.426328, -0.079845, -0.127842>, 
      <-0.426328, 0.277825, -0.194893>, <-0.426328, 0.277825, -0.143395>, <-0.426328, 0.277825, -0.074732>, <-0.426328, 0.277825, -0.023235>, 
      <-0.426328, 0.551870, -0.142949>, <-0.426328, 0.551870, -0.091452>, <-0.426328, 0.551870, -0.022788>, <-0.426328, 0.551870, 0.028709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, -0.350580, -0.366592>, <-0.426328, -0.079845, -0.299499>, <-0.426328, 0.277825, -0.194893>, <-0.426328, 0.551870, -0.142949>, 
      <-0.170531, -0.350580, -0.366592>, <-0.170531, -0.079845, -0.299499>, <-0.170531, 0.277825, -0.194893>, <-0.170531, 0.551870, -0.142949>, 
      <0.170531, -0.350580, -0.366592>, <0.170531, -0.079845, -0.299499>, <0.170531, 0.277825, -0.194893>, <0.170531, 0.551870, -0.142949>, 
      <0.426328, -0.350580, -0.366592>, <0.426328, -0.079845, -0.299499>, <0.426328, 0.277825, -0.194893>, <0.426328, 0.551870, -0.142949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, -0.350580, -0.366592>, <-0.170531, -0.350580, -0.366592>, <0.170531, -0.350580, -0.366592>, <0.426328, -0.350580, -0.366592>, 
      <-0.426328, -0.350580, -0.366592>, <-0.170531, -0.350580, -0.315095>, <-0.085266, -0.350580, -0.315095>, <0.170531, -0.350580, -0.315095>, 
      <-0.426328, -0.350580, -0.366592>, <-0.170531, -0.350580, -0.315095>, <-0.170531, -0.350580, -0.297929>, <-0.170531, -0.350580, -0.246432>, 
      <-0.426328, -0.350580, -0.366592>, <-0.426328, -0.350580, -0.315095>, <-0.426328, -0.350580, -0.246432>, <-0.426328, -0.350580, -0.194935>
    }
  }
  texture {
    BallWoodNicked
  }
  scale <1.0, 1.3, 1.5>
  rotate -90.0*x
  translate  <0.01863, 1.6, 0.0>
}
#declare BarrelDone = union {
  cone { // BandTop1
    <0,0,0>, 0.94, <0,0,1>, 1.0
    texture {
      Brushed_AluminumRusty
    }
    scale <1.6, 1.6, 0.4>
    translate  -4.722594*z
  }
  cone { // BandTop
    <0,0,0>, 0.94, <0,0,1>, 1.0
    texture {
      Brushed_AluminumRusty
    }
    scale <1.6, 1.6, 0.4>
    rotate 180.0*x
    translate  0.15*z
  }
  object { Spar1 }
  object { // Spar2->Spar1
    Spar1
    rotate <-0.0, 0.0, -30.0>
  }
  object { // Spar3->Spar1
    Spar1
    rotate <-0.0, 0.0, -60.0>
    translate  0.0*x
  }
  object { // Spar4->Spar1
    Spar1
    rotate <-0.0, 0.0, -90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Spar5->Spar1
    Spar1
    rotate <-0.0, 0.0, -120.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Spar6->Spar1
    Spar1
    rotate <-0.0, 0.0, -150.0>
    translate  -0.0*y
  }
  object { // Spar7->Spar1
    Spar1
    rotate <-0.0, 0.0, 180.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Spar8->Spar1
    Spar1
    rotate <-0.0, 0.0, 150.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Spar9->Spar1
    Spar1
    rotate <-0.0, 0.0, 120.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Spar10->Spar1
    Spar1
    rotate <-0.0, 0.0, 90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Spar11->Spar1
    Spar1
    rotate <-0.0, 0.0, 60.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Spar12->Spar1
    Spar1
    rotate <-0.0, 0.0, 30.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Spar13->Spar1
    Spar1
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 0.0, 0.0>
  }
  cylinder { // BarrelTop
    <0,0,1>, <0,0,0>, 1 
    texture {
      OakNicked
    }
    scale <1.3, 1.3, 0.1>
    translate  -4.95*z
  }
  scale <1.85, 1.85, 1.4>
  rotate <156.597, 48.330238, -130.786575>
  translate  <0.07265, -29.996221, -18.184825>
}
#declare Banister1 = lathe {
  linear_spline
  12  // control points
  <0.053208, -1.0>,
  <0.185055, -1.000587>,
  <0.184664, -0.750391>,
  <0.122066, -0.685782>,
  <0.161189, -0.582473>,
  <0.122066, -0.204225>,
  <0.1259, -0.033998>,
  <0.081577, 0.158547>,
  <0.146668, 0.34968>,
  <0.093526, 0.612721>,
  <0.117159, 0.872268>,
  <0.029734, 0.874804>
  rotate <90,0,90>
  texture {
    BallWoodNicked
  }
  scale 3.5
  translate  <130.0, 168.104022, 60.588765>
}
#declare Stairs1 = union {
  object { Banister1 }
  superellipsoid { // Stair1
    <0.1, 0.1>
    texture {
      MapleNicked
    }
    scale <8.0, 3.0, 0.2>
    translate  <135.5, 168.032082, 56.99571>
  }
  box { // StairFront1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BallWoodNicked
      rotate <0.0, -90.0, -90.0>
    }
    scale <0.35, 7.5, 1.5>
    rotate -90.0*z
    translate  <135.5, 166.003764, 55.36189>
  }
  box { // StairFront2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BallWoodNicked
      rotate <0.0, -90.0, -90.0>
    }
    scale <0.35, 21.0, 1.7>
    translate  <128.386072, 186.805362, 55.36189>
  }
  rotate -0.0*y
  translate  <-132.659533, -132.808742, -74.857875>
}
#declare BackBannister1 = lathe {
  linear_spline
  25  // control points
  <0.115806, -1.046948>,
  <0.302817, -1.04734>,
  <0.302034, -0.867762>,
  <0.184664, -0.771897>,
  <0.184664, -0.665772>,
  <0.262911, -0.605493>,
  <0.317684, -0.546792>,
  <0.309859, -0.462441>,
  <0.248661, -0.404456>,
  <0.160777, -0.395725>,
  <0.163954, -0.311241>,
  <0.104776, -0.152545>,
  <0.117136, 0.01205>,
  <0.237229, 0.0263>,
  <0.279669, 0.064723>,
  <0.231218, 0.121871>,
  <0.143671, 0.131646>,
  <0.219144, 0.284356>,
  <0.217834, 0.359678>,
  <0.294116, 0.417887>,
  <0.312363, 0.471362>,
  <0.282786, 0.538967>,
  <0.199296, 0.562128>,
  <0.195102, 0.705853>,
  <0.029734, 0.710485>
  rotate <90,0,90>
  texture {
    BallWoodNicked
  }
  scale <5.0, 5.0, 6.5>
  translate  <9.195917, 63.046465, 5.022528>
}
#declare S = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  11  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, -0.799687>,
  <-0.5577, 0.710485>,
  <2.5956, 0.710485>,
  <2.875796, 0.976526>,
  <-0.926478, 0.976526>,
  <-0.930133, 0.757433>,
  <0.677152, -0.807512>,
  <-1.0, -0.807512>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    SigRed
  }
}
#declare L = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <2.5956, 0.710485>,
  <1.003777, -0.796667>,
  <1.006157, -1.007512>,
  <3.003491, -1.010638>,
  <3.002266, -0.788267>,
  <1.450215, -0.788716>,
  <2.999068, 0.727934>,
  <3.007532, 0.973396>,
  <2.852321, 0.976526>,
  <2.5956, 0.710485>
  rotate -x*90
  texture {
    Sig_Green
  }
}
#declare Signature = union {
  object { S }
  object { L }
  scale <1.0, 1.0, 0.3>
  rotate <25.0, 11.899342, -82.947678>
  translate  <-7.753979, -0.414518, 1.0>
}




//
// ********  OBJECTS  *******
//

#declare BtmMiddle = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.184128, 18.439613, -4.580057>, <0.184128, 18.290712, -4.017610>, <0.184128, 18.239597, -3.205947>, <0.184128, 17.943280, -2.705234>, 
      <0.078897, 18.515691, -4.577654>, <0.078897, 18.366790, -4.015207>, <0.078897, 18.303781, -3.165033>, <0.078897, 18.007464, -2.664320>, 
      <0.023673, 18.696560, -4.571943>, <0.023673, 18.530445, -3.953752>, <0.023673, 18.484611, -3.118791>, <0.023673, 18.160054, -2.567051>, 
      <-0.045093, 18.806678, -4.568466>, <-0.045093, 18.640563, -3.950276>, <-0.045093, 18.577517, -3.059570>, <-0.045093, 18.252960, -2.507830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.686796, 18.277550, -4.585177>, <0.686796, 18.136250, -4.047341>, <0.686796, 18.090389, -3.270582>, <0.686796, 17.806547, -2.792391>, 
      <0.528426, 18.282627, -4.585016>, <0.528426, 18.141326, -4.047181>, <0.528425, 18.094674, -3.267851>, <0.528425, 17.810830, -2.789660>, 
      <0.312514, 18.346794, -4.582989>, <0.312514, 18.197893, -4.020542>, <0.312514, 18.161290, -3.255864>, <0.312514, 17.864971, -2.755151>, 
      <0.184128, 18.439613, -4.580057>, <0.184128, 18.290712, -4.017610>, <0.184128, 18.239597, -3.205947>, <0.184128, 17.943280, -2.705234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.127177, 18.409378, -4.581013>, <1.127177, 18.261896, -4.023158>, <1.127177, 18.211762, -3.218006>, <1.127177, 17.917770, -2.721495>, 
      <1.015707, 18.328213, -4.583577>, <1.015707, 18.180731, -4.025722>, <1.015707, 18.143286, -3.261656>, <1.015707, 17.849294, -2.765144>, 
      <0.824638, 18.273131, -4.585317>, <0.824638, 18.131830, -4.047481>, <0.824638, 18.086661, -3.272959>, <0.824638, 17.802818, -2.794768>, 
      <0.686796, 18.277550, -4.585177>, <0.686796, 18.136250, -4.047341>, <0.686796, 18.090389, -3.270582>, <0.686796, 17.806547, -2.792391>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.371970, 18.776443, -4.569417>, <1.371970, 18.611746, -3.955819>, <1.371970, 18.549680, -3.071626>, <1.371970, 18.227450, -2.524091>, 
      <1.298532, 18.666325, -4.572896>, <1.298532, 18.501627, -3.959298>, <1.298532, 18.456778, -3.130847>, <1.298532, 18.134546, -2.583312>, 
      <1.234197, 18.487302, -4.578551>, <1.234197, 18.339821, -4.020696>, <1.234196, 18.277504, -3.176100>, <1.234196, 17.983514, -2.679588>, 
      <1.127177, 18.409378, -4.581013>, <1.127177, 18.261896, -4.023158>, <1.127177, 18.211762, -3.218006>, <1.127177, 17.917770, -2.721495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.184128, 16.573982, -1.427542>, <0.078897, 16.616757, -1.364581>, <0.023673, 16.718443, -1.214899>, <-0.045093, 16.780355, -1.123766>, 
      <0.184128, 17.078686, -1.674416>, <0.078897, 17.121459, -1.611456>, <0.023673, 17.261224, -1.485020>, <-0.045093, 17.323138, -1.393887>, 
      <0.184128, 17.657134, -2.221712>, <0.078897, 17.721318, -2.180798>, <0.023673, 17.852656, -2.044478>, <-0.045093, 17.945560, -1.985257>, 
      <0.184128, 17.943280, -2.705234>, <0.078897, 18.007464, -2.664320>, <0.023673, 18.160054, -2.567051>, <-0.045093, 18.252960, -2.507830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.686796, 16.482862, -1.561663>, <0.528426, 16.485718, -1.557461>, <0.312514, 16.521797, -1.504357>, <0.184128, 16.573982, -1.427542>, 
      <0.686796, 16.970768, -1.798228>, <0.528426, 16.973624, -1.794026>, <0.312514, 17.026501, -1.751231>, <0.184128, 17.078686, -1.674416>, 
      <0.686796, 17.529776, -2.326115>, <0.528425, 17.534059, -2.323385>, <0.312514, 17.578827, -2.271629>, <0.184128, 17.657134, -2.221712>, 
      <0.686796, 17.806547, -2.792391>, <0.528425, 17.810830, -2.789660>, <0.312514, 17.864971, -2.755151>, <0.184128, 17.943280, -2.705234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.127177, 16.556982, -1.452563>, <1.015706, 16.511349, -1.519733>, <0.824638, 16.480378, -1.565320>, <0.686796, 16.482862, -1.561663>, 
      <1.127177, 17.058552, -1.697517>, <1.015706, 17.012918, -1.764687>, <0.824638, 16.968283, -1.801886>, <0.686796, 16.970768, -1.798228>, 
      <1.127177, 17.633374, -2.241189>, <1.015707, 17.564899, -2.284839>, <0.824638, 17.526046, -2.328492>, <0.686796, 17.529776, -2.326115>, 
      <1.127177, 17.917770, -2.721495>, <1.015707, 17.849294, -2.765144>, <0.824638, 17.802818, -2.794768>, <0.686796, 17.806547, -2.792391>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.371970, 16.763355, -1.148789>, <1.298532, 16.701443, -1.239921>, <1.234196, 16.600794, -1.388075>, <1.127177, 16.556982, -1.452563>, 
      <1.371970, 17.303000, -1.417000>, <1.298532, 17.241086, -1.508133>, <1.234196, 17.102363, -1.633029>, <1.127177, 17.058552, -1.697517>, 
      <1.371970, 17.921800, -2.004735>, <1.298532, 17.828898, -2.063956>, <1.234196, 17.699118, -2.199283>, <1.127177, 17.633374, -2.241189>, 
      <1.371970, 18.227450, -2.524091>, <1.298532, 18.134546, -2.583312>, <1.234196, 17.983514, -2.679588>, <1.127177, 17.917770, -2.721495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.184128, 14.871126, -1.202500>, <0.078897, 14.875752, -1.126525>, <0.023673, 14.886754, -0.945902>, <-0.045093, 14.893450, -0.835931>, 
      <0.184128, 15.375920, -1.098979>, <0.078897, 15.380546, -1.023003>, <0.023673, 15.450654, -0.846363>, <-0.045093, 15.457352, -0.736392>, 
      <0.184128, 16.111093, -1.201121>, <0.078897, 16.153867, -1.138161>, <0.023673, 16.205797, -0.959775>, <-0.045093, 16.267710, -0.868642>, 
      <0.184128, 16.573982, -1.427542>, <0.078897, 16.616757, -1.364581>, <0.023673, 16.718443, -1.214899>, <-0.045093, 16.780355, -1.123766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.686796, 14.861270, -1.364346>, <0.528426, 14.861579, -1.359276>, <0.312514, 14.865482, -1.295193>, <0.184128, 14.871126, -1.202500>, 
      <0.686796, 15.339898, -1.259080>, <0.528426, 15.340206, -1.254010>, <0.312514, 15.370275, -1.191672>, <0.184128, 15.375920, -1.098979>, 
      <0.686796, 16.041898, -1.347856>, <0.528426, 16.044752, -1.343654>, <0.312514, 16.058909, -1.277936>, <0.184128, 16.111093, -1.201121>, 
      <0.686796, 16.482862, -1.561663>, <0.528426, 16.485718, -1.557461>, <0.312514, 16.521797, -1.504357>, <0.184128, 16.573982, -1.427542>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.127177, 14.869286, -1.232693>, <1.015707, 14.864350, -1.313748>, <0.824638, 14.861002, -1.368759>, <0.686796, 14.861270, -1.364346>, 
      <1.127177, 15.369202, -1.128845>, <1.015707, 15.364266, -1.209900>, <0.824638, 15.339629, -1.263493>, <0.686796, 15.339898, -1.259080>, 
      <1.127177, 16.098184, -1.228498>, <1.015706, 16.052552, -1.295668>, <0.824638, 16.039411, -1.351514>, <0.686796, 16.041898, -1.347856>, 
      <1.127177, 16.556982, -1.452563>, <1.015706, 16.511349, -1.519733>, <0.824638, 16.480378, -1.565320>, <0.686796, 16.482862, -1.561663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.371970, 14.891611, -0.866127>, <1.298532, 14.884914, -0.976097>, <1.234196, 14.874026, -1.154875>, <1.127177, 14.869286, -1.232693>, 
      <1.371970, 15.450651, -0.766259>, <1.298532, 15.443954, -0.876229>, <1.234196, 15.373941, -1.051027>, <1.127177, 15.369202, -1.128845>, 
      <1.371970, 16.254814, -0.896036>, <1.298532, 16.192902, -0.987168>, <1.234196, 16.141997, -1.164010>, <1.127177, 16.098184, -1.228498>, 
      <1.371970, 16.763355, -1.148789>, <1.298532, 16.701443, -1.239921>, <1.234196, 16.600794, -1.388075>, <1.127177, 16.556982, -1.452563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.184128, 13.415118, -2.075352>, <0.078897, 13.381138, -2.007242>, <0.023673, 13.300353, -1.845319>, <-0.045093, 13.251168, -1.746733>, 
      <0.184128, 13.788093, -1.728575>, <0.078897, 13.754114, -1.660465>, <0.023673, 13.722422, -1.472149>, <-0.045093, 13.673238, -1.373563>, 
      <0.184128, 14.372230, -1.304812>, <0.078897, 14.376858, -1.228837>, <0.023673, 14.331949, -1.043835>, <-0.045093, 14.338646, -0.933864>, 
      <0.184128, 14.871126, -1.202500>, <0.078897, 14.875752, -1.126525>, <0.023673, 14.886754, -0.945902>, <-0.045093, 14.893450, -0.835931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.686796, 13.487506, -2.220443>, <0.528426, 13.485238, -2.215897>, <0.312514, 13.456576, -2.158449>, <0.184128, 13.415118, -2.075352>, 
      <0.686796, 13.838982, -1.885365>, <0.528426, 13.836714, -1.880820>, <0.312514, 13.829552, -1.811672>, <0.184128, 13.788093, -1.728575>, 
      <0.686796, 14.387002, -1.468654>, <0.528426, 14.387310, -1.463584>, <0.312514, 14.366586, -1.397505>, <0.184128, 14.372230, -1.304812>, 
      <0.686796, 14.861270, -1.364346>, <0.528426, 14.861579, -1.359276>, <0.312514, 14.865482, -1.295193>, <0.184128, 14.871126, -1.202500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.127177, 13.428622, -2.102420>, <1.015707, 13.464877, -2.175084>, <0.824638, 13.489480, -2.224400>, <0.686796, 13.487506, -2.220443>, 
      <1.127177, 13.797578, -1.757824>, <1.015707, 13.833830, -1.830487>, <0.824638, 13.840955, -1.889322>, <0.686796, 13.838982, -1.885365>, 
      <1.127177, 14.374989, -1.335374>, <1.015707, 14.370053, -1.416429>, <0.824638, 14.386733, -1.473067>, <0.686796, 14.387002, -1.468654>, 
      <1.127177, 14.869286, -1.232693>, <1.015707, 14.864350, -1.313748>, <0.824638, 14.861002, -1.368759>, <0.686796, 14.861270, -1.364346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.371970, 13.264674, -1.773802>, <1.298532, 13.313858, -1.872387>, <1.234197, 13.393818, -2.032658>, <1.127177, 13.428622, -2.102420>, 
      <1.371970, 13.682680, -1.402800>, <1.298532, 13.731866, -1.501386>, <1.234197, 13.762773, -1.688061>, <1.127177, 13.797578, -1.757824>, 
      <1.371970, 14.341419, -0.964415>, <1.298532, 14.334722, -1.074385>, <1.234196, 14.379728, -1.257556>, <1.127177, 14.374989, -1.335374>, 
      <1.371970, 14.891611, -0.866127>, <1.298532, 14.884914, -0.976097>, <1.234196, 14.874026, -1.154875>, <1.127177, 14.869286, -1.232693>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.184128, 12.014953, -3.858056>, <0.078897, 11.952793, -3.814126>, <0.023673, 11.805015, -3.709688>, <-0.045093, 11.715042, -3.646102>, 
      <0.184128, 12.351446, -3.267093>, <0.078897, 12.289286, -3.223164>, <0.023673, 12.171075, -3.074821>, <-0.045093, 12.081102, -3.011235>, 
      <0.184128, 12.917079, -2.538409>, <0.078897, 12.883098, -2.470299>, <0.023673, 12.751330, -2.330735>, <-0.045093, 12.702145, -2.232149>, 
      <0.184128, 13.415118, -2.075352>, <0.078897, 13.381138, -2.007242>, <0.023673, 13.300353, -1.845319>, <-0.045093, 13.251168, -1.746733>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.686796, 12.147366, -3.951636>, <0.528426, 12.143218, -3.948704>, <0.312514, 12.090790, -3.911652>, <0.184128, 12.014953, -3.858056>, 
      <0.686796, 12.470742, -3.379973>, <0.528426, 12.466594, -3.377041>, <0.312514, 12.427283, -3.320689>, <0.184128, 12.351446, -3.267093>, 
      <0.686796, 13.012130, -2.673641>, <0.528426, 13.009862, -2.669095>, <0.312514, 12.958537, -2.621506>, <0.184128, 12.917079, -2.538409>, 
      <0.686796, 13.487506, -2.220443>, <0.528426, 13.485238, -2.215897>, <0.312514, 13.456576, -2.158449>, <0.184128, 13.415118, -2.075352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.127177, 12.039657, -3.875513>, <1.015707, 12.105972, -3.922380>, <0.824638, 12.150977, -3.954188>, <0.686796, 12.147366, -3.951636>, 
      <1.127177, 12.373706, -3.288156>, <1.015707, 12.440022, -3.335022>, <0.824638, 12.474353, -3.382524>, <0.686796, 12.470742, -3.379973>, 
      <1.127177, 12.934805, -2.563637>, <1.015707, 12.971058, -2.636301>, <0.824638, 13.014104, -2.677597>, <0.686796, 13.012130, -2.673641>, 
      <1.127177, 13.428622, -2.102420>, <1.015707, 13.464877, -2.175084>, <0.824638, 13.489480, -2.224400>, <0.686796, 13.487506, -2.220443>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.371970, 11.739746, -3.663561>, <1.298532, 11.829719, -3.727147>, <1.234197, 11.975990, -3.830518>, <1.127177, 12.039657, -3.875513>, 
      <1.371970, 12.103376, -3.032319>, <1.298532, 12.193350, -3.095905>, <1.234197, 12.310038, -3.243160>, <1.127177, 12.373706, -3.288156>, 
      <1.371970, 12.719834, -2.257375>, <1.298532, 12.769018, -2.355960>, <1.234197, 12.900000, -2.493875>, <1.127177, 12.934805, -2.563637>, 
      <1.371970, 13.264674, -1.773802>, <1.298532, 13.313858, -1.872387>, <1.234197, 13.393818, -2.032658>, <1.127177, 13.428622, -2.102420>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.184128, 11.830949, -4.857529>, <0.078897, 11.754867, -4.855244>, <0.023673, 11.573992, -4.849811>, <-0.045093, 11.463867, -4.846503>, 
      <0.184128, 11.886150, -4.557687>, <0.078897, 11.810069, -4.555402>, <0.023673, 11.649345, -4.489690>, <-0.045093, 11.539220, -4.486382>, 
      <0.184128, 11.864094, -4.122998>, <0.078897, 11.801935, -4.079068>, <0.023673, 11.621238, -4.028420>, <-0.045093, 11.531264, -3.964834>, 
      <0.184128, 12.014953, -3.858056>, <0.078897, 11.952793, -3.814126>, <0.023673, 11.805015, -3.709688>, <-0.045093, 11.715042, -3.646102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.686796, 11.993021, -4.862396>, <0.528426, 11.987942, -4.862244>, <0.312514, 11.923772, -4.860317>, <0.184128, 11.830949, -4.857529>, 
      <0.686796, 12.039325, -4.589168>, <0.528426, 12.034246, -4.589016>, <0.312514, 11.978974, -4.560475>, <0.184128, 11.886150, -4.557687>, 
      <0.686796, 12.010922, -4.192842>, <0.528426, 12.006774, -4.189911>, <0.312514, 11.939932, -4.176594>, <0.184128, 11.864094, -4.122998>, 
      <0.686796, 12.147366, -3.951636>, <0.528426, 12.143218, -3.948704>, <0.312514, 12.090790, -3.911652>, <0.184128, 12.014953, -3.858056>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.127177, 11.861185, -4.858436>, <1.015707, 11.942354, -4.860874>, <0.824638, 11.997440, -4.862528>, <0.686796, 11.993021, -4.862396>, 
      <1.127177, 11.914726, -4.563559>, <1.015707, 11.995894, -4.565997>, <0.824638, 12.043744, -4.589300>, <0.686796, 12.039325, -4.589168>, 
      <1.127177, 11.891494, -4.136026>, <1.015707, 11.957810, -4.182893>, <0.824638, 12.014533, -4.195394>, <0.686796, 12.010922, -4.192842>, 
      <1.127177, 12.039657, -3.875513>, <1.015707, 12.105972, -3.922380>, <0.824638, 12.150977, -3.954188>, <0.686796, 12.147366, -3.951636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.371970, 11.494104, -4.847412>, <1.298532, 11.604229, -4.850720>, <1.234197, 11.783258, -4.856096>, <1.127177, 11.861185, -4.858436>, 
      <1.371970, 11.567797, -4.492257>, <1.298532, 11.677922, -4.495564>, <1.234197, 11.836798, -4.561219>, <1.127177, 11.914726, -4.563559>, 
      <1.371970, 11.558691, -3.977862>, <1.298532, 11.648665, -4.041448>, <1.234197, 11.827826, -4.091030>, <1.127177, 11.891494, -4.136026>, 
      <1.371970, 11.739746, -3.663561>, <1.298532, 11.829719, -3.727147>, <1.234197, 11.975990, -3.830518>, <1.127177, 12.039657, -3.875513>
    }
  }
  texture {
    LowerNeck
  }
}
#declare TopBump = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.291949, 19.271102, -4.550233>, <1.291949, 19.082661, -3.861665>, <1.291949, 19.003672, -2.871063>, <1.291949, 18.642962, -2.255007>, 
      <1.381724, 19.120534, -4.560929>, <1.381724, 18.932093, -3.872362>, <1.381724, 18.879675, -2.957144>, <1.381724, 18.518965, -2.341088>, 
      <1.336153, 18.863830, -4.560533>, <1.336153, 18.702112, -3.960474>, <1.336153, 18.614472, -3.006709>, <1.336153, 18.298046, -2.471828>, 
      <1.355098, 18.689285, -4.564947>, <1.355098, 18.527566, -3.964888>, <1.355098, 18.466650, -3.099632>, <1.355098, 18.150224, -2.564751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.726420, 19.743686, -4.490042>, <0.726420, 19.526146, -3.731611>, <0.726420, 19.421352, -2.640388>, <0.726420, 19.018552, -1.961938>, 
      <0.948254, 19.743686, -4.490042>, <0.948254, 19.526146, -3.731611>, <0.948254, 19.421352, -2.640388>, <0.948254, 19.018552, -1.961938>, 
      <1.178554, 19.461285, -4.536722>, <1.178554, 19.272843, -3.848154>, <1.178554, 19.160291, -2.762333>, <1.178554, 18.799581, -2.146278>, 
      <1.291949, 19.271102, -4.550233>, <1.291949, 19.082661, -3.861665>, <1.291949, 19.003672, -2.871063>, <1.291949, 18.642962, -2.255007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.103847, 19.271102, -4.550233>, <0.103847, 19.082661, -3.861665>, <0.103847, 19.003672, -2.871063>, <0.103847, 18.642962, -2.255007>, 
      <0.240374, 19.462101, -4.536442>, <0.240374, 19.273659, -3.847874>, <0.240373, 19.160851, -2.761675>, <0.240373, 18.800141, -2.145620>, 
      <0.491239, 19.743686, -4.490042>, <0.491239, 19.526146, -3.731611>, <0.491239, 19.421352, -2.640388>, <0.491239, 19.018552, -1.961938>, 
      <0.726420, 19.743686, -4.490042>, <0.726420, 19.526146, -3.731611>, <0.726420, 19.421352, -2.640388>, <0.726420, 19.018552, -1.961938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.005658, 18.719523, -4.563993>, <-0.005658, 18.556387, -3.959343>, <-0.005658, 18.494490, -3.087576>, <-0.005658, 18.175738, -2.548492>, 
      <0.027193, 18.884997, -4.559865>, <0.027193, 18.721861, -3.955215>, <0.027193, 18.634658, -2.999531>, <0.027193, 18.315904, -2.460446>, 
      <0.005882, 19.134053, -4.560129>, <0.005882, 18.945610, -3.871561>, <0.005882, 18.890888, -2.949554>, <0.005882, 18.530178, -2.333498>, 
      <0.103847, 19.271102, -4.550233>, <0.103847, 19.082661, -3.861665>, <0.103847, 19.003672, -2.871063>, <0.103847, 18.642962, -2.255007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.291949, 17.038589, -0.737323>, <1.381724, 16.958741, -0.865422>, <1.336153, 16.807531, -1.072867>, <1.355098, 16.708507, -1.216672>, 
      <1.291949, 17.629859, -1.036259>, <1.381724, 17.550011, -1.164358>, <1.336153, 17.338661, -1.334648>, <1.355098, 17.239637, -1.478453>, 
      <1.291949, 18.308195, -1.683259>, <1.381724, 18.184198, -1.769341>, <1.336153, 17.996554, -1.962190>, <1.355098, 17.848731, -2.055113>, 
      <1.291949, 18.642962, -2.255007>, <1.381724, 18.518965, -2.341088>, <1.336153, 18.298046, -2.471828>, <1.355098, 18.150224, -2.564751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.726420, 17.267672, -0.319615>, <0.948254, 17.267672, -0.319615>, <1.178554, 17.139446, -0.575521>, <1.291949, 17.038589, -0.737323>, 
      <0.726420, 17.911322, -0.642674>, <0.948254, 17.911322, -0.642674>, <1.178554, 17.730717, -0.874457>, <1.291949, 17.629859, -1.036259>, 
      <0.726420, 18.650894, -1.342680>, <0.948254, 18.650894, -1.342680>, <1.178554, 18.464814, -1.574530>, <1.291949, 18.308195, -1.683259>, 
      <0.726420, 19.018552, -1.961938>, <0.948254, 19.018552, -1.961938>, <1.178554, 18.799581, -2.146278>, <1.291949, 18.642962, -2.255007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.103847, 17.038589, -0.737323>, <0.240373, 17.139698, -0.574696>, <0.491239, 17.267672, -0.319615>, <0.726420, 17.267672, -0.319615>, 
      <0.103847, 17.629859, -1.036259>, <0.240373, 17.730968, -0.873632>, <0.491239, 17.911322, -0.642674>, <0.726420, 17.911322, -0.642674>, 
      <0.103847, 18.308195, -1.683259>, <0.240373, 18.465374, -1.573872>, <0.491239, 18.650894, -1.342680>, <0.726420, 18.650894, -1.342680>, 
      <0.103847, 18.642962, -2.255007>, <0.240373, 18.800141, -2.145620>, <0.491239, 19.018552, -1.961938>, <0.726420, 19.018552, -1.961938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.005658, 16.725510, -1.191650>, <0.027193, 16.819434, -1.055352>, <0.005882, 16.966040, -0.854017>, <0.103847, 17.038589, -0.737323>, 
      <-0.005658, 17.259778, -1.455345>, <0.027193, 17.353701, -1.319047>, <0.005882, 17.557310, -1.152953>, <0.103847, 17.629859, -1.036259>, 
      <-0.005658, 17.872494, -2.035637>, <0.027193, 18.012661, -1.947591>, <0.005882, 18.195411, -1.761751>, <0.103847, 18.308195, -1.683259>, 
      <-0.005658, 18.175738, -2.548492>, <0.027193, 18.315904, -2.460446>, <0.005882, 18.530178, -2.333498>, <0.103847, 18.642962, -2.255007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.291949, 14.918149, -0.371805>, <1.381724, 14.914907, -0.522718>, <1.336153, 14.890826, -0.778292>, <1.355098, 14.879117, -0.952500>, 
      <1.291949, 15.556629, -0.276767>, <1.381724, 15.553387, -0.427680>, <1.336153, 15.435882, -0.676329>, <1.355098, 15.424171, -0.850537>, 
      <1.291949, 16.462517, -0.446070>, <1.381724, 16.382667, -0.574169>, <1.336153, 16.310154, -0.827722>, <1.355098, 16.211130, -0.971526>, 
      <1.291949, 17.038589, -0.737323>, <1.381724, 16.958741, -0.865422>, <1.336153, 16.807531, -1.072867>, <1.355098, 16.708507, -1.216672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.726420, 14.901819, 0.104316>, <0.948254, 14.901819, 0.104316>, <1.178554, 14.922245, -0.181187>, <1.291949, 14.918149, -0.371805>, 
      <0.726420, 15.616314, 0.201401>, <0.948254, 15.616314, 0.201401>, <1.178554, 15.560725, -0.086149>, <1.291949, 15.556629, -0.276767>, 
      <0.726420, 16.623230, 0.003840>, <0.948254, 16.623230, 0.003840>, <1.178554, 16.563373, -0.284268>, <1.291949, 16.462517, -0.446070>, 
      <0.726420, 17.267672, -0.319615>, <0.948254, 17.267672, -0.319615>, <1.178554, 17.139446, -0.575521>, <1.291949, 17.038589, -0.737323>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.103847, 14.918149, -0.371805>, <0.240373, 14.922040, -0.180349>, <0.491239, 14.901819, 0.104316>, <0.726420, 14.901819, 0.104316>, 
      <0.103847, 15.556629, -0.276767>, <0.240373, 15.560520, -0.085311>, <0.491239, 15.616314, 0.201401>, <0.726420, 15.616314, 0.201401>, 
      <0.103847, 16.462517, -0.446070>, <0.240373, 16.563626, -0.283443>, <0.491239, 16.623230, 0.003840>, <0.726420, 16.623230, 0.003840>, 
      <0.103847, 17.038589, -0.737323>, <0.240373, 17.139698, -0.574696>, <0.491239, 17.267672, -0.319615>, <0.726420, 17.267672, -0.319615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.005658, 14.880957, -0.922305>, <0.027193, 14.892115, -0.757155>, <0.005882, 14.915357, -0.509185>, <0.103847, 14.918149, -0.371805>, 
      <-0.005658, 15.430878, -0.820671>, <0.027193, 15.442035, -0.655521>, <0.005882, 15.553838, -0.414147>, <0.103847, 15.556629, -0.276767>, 
      <-0.005658, 16.224032, -0.944138>, <0.027193, 16.317955, -0.807840>, <0.005882, 16.389966, -0.562764>, <0.103847, 16.462517, -0.446070>, 
      <-0.005658, 16.725510, -1.191650>, <0.027193, 16.819434, -1.055352>, <0.005882, 16.966040, -0.854017>, <0.103847, 17.038589, -0.737323>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.291949, 13.040496, -1.332439>, <1.381724, 13.113145, -1.464754>, <1.336153, 13.220076, -1.698128>, <1.355098, 13.297039, -1.854852>, 
      <1.291949, 13.525131, -0.925641>, <1.381724, 13.597781, -1.057956>, <1.336153, 13.626085, -1.332470>, <1.355098, 13.703048, -1.489194>, 
      <1.291949, 14.292307, -0.464962>, <1.381724, 14.289066, -0.615874>, <1.336153, 14.353747, -0.878762>, <1.355098, 14.342037, -1.052971>, 
      <1.291949, 14.918149, -0.371805>, <1.381724, 14.914907, -0.522718>, <1.336153, 14.890826, -0.778292>, <1.355098, 14.879117, -0.952500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.726420, 12.788292, -0.928270>, <0.948254, 12.788292, -0.928270>, <1.178554, 12.948734, -1.165311>, <1.291949, 13.040496, -1.332439>, 
      <0.726420, 13.335100, -0.482185>, <0.948254, 13.335100, -0.482185>, <1.178554, 13.433368, -0.758514>, <1.291949, 13.525131, -0.925641>, 
      <0.726420, 14.202560, 0.009301>, <0.948254, 14.202560, 0.009301>, <1.178554, 14.296402, -0.274344>, <1.291949, 14.292307, -0.464962>, 
      <0.726420, 14.901819, 0.104316>, <0.948254, 14.901819, 0.104316>, <1.178554, 14.922245, -0.181187>, <1.291949, 14.918149, -0.371805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.103847, 13.040496, -1.332439>, <0.240373, 12.948138, -1.164688>, <0.491239, 12.788292, -0.928270>, <0.726420, 12.788292, -0.928270>, 
      <0.103847, 13.525131, -0.925641>, <0.240373, 13.432773, -0.757890>, <0.491239, 13.335100, -0.482185>, <0.726420, 13.335100, -0.482185>, 
      <0.103847, 14.292307, -0.464962>, <0.240373, 14.296198, -0.273506>, <0.491239, 14.202560, 0.009301>, <0.726420, 14.202560, 0.009301>, 
      <0.103847, 14.918149, -0.371805>, <0.240373, 14.922040, -0.180349>, <0.491239, 14.901819, 0.104316>, <0.726420, 14.901819, 0.104316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.005658, 13.283534, -1.827781>, <0.027193, 13.210622, -1.679178>, <0.005882, 13.106768, -1.452809>, <0.103847, 13.040496, -1.332439>, 
      <-0.005658, 13.693595, -1.459952>, <0.027193, 13.620683, -1.311349>, <0.005882, 13.591403, -1.046011>, <0.103847, 13.525131, -0.925641>, 
      <-0.005658, 14.339269, -1.022417>, <0.027193, 14.350427, -0.857267>, <0.005882, 14.289515, -0.602342>, <0.103847, 14.292307, -0.464962>, 
      <-0.005658, 14.880957, -0.922305>, <0.027193, 14.892115, -0.757155>, <0.005882, 14.915357, -0.509185>, <0.103847, 14.918149, -0.371805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.291949, 11.333437, -3.380771>, <1.381724, 11.460039, -3.462972>, <1.336153, 11.664654, -3.617989>, <1.355098, 11.806606, -3.719654>, 
      <1.291949, 11.740774, -2.692330>, <1.381724, 11.867376, -2.774531>, <1.336153, 12.025018, -2.999089>, <1.355098, 12.166970, -3.100754>, 
      <1.291949, 12.427808, -1.846722>, <1.381724, 12.500457, -1.979037>, <1.336153, 12.687914, -2.177402>, <1.355098, 12.764878, -2.334126>, 
      <1.291949, 13.040496, -1.332439>, <1.381724, 13.113145, -1.464754>, <1.336153, 13.220076, -1.698128>, <1.355098, 13.297039, -1.854852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.726420, 10.920034, -3.144010>, <0.948254, 10.920034, -3.144010>, <1.178554, 11.173526, -3.276942>, <1.291949, 11.333437, -3.380771>, 
      <0.726420, 11.357966, -2.392874>, <0.948254, 11.357966, -2.392874>, <1.178554, 11.580863, -2.588501>, <1.291949, 11.740774, -2.692330>, 
      <0.726420, 12.114567, -1.477892>, <0.948254, 12.114567, -1.477892>, <1.178554, 12.336046, -1.679595>, <1.291949, 12.427808, -1.846722>, 
      <0.726420, 12.788292, -0.928270>, <0.948254, 12.788292, -0.928270>, <1.178554, 12.948734, -1.165311>, <1.291949, 13.040496, -1.332439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.103847, 11.333437, -3.380771>, <0.240373, 11.172706, -3.276675>, <0.491239, 10.920034, -3.144010>, <0.726420, 10.920034, -3.144010>, 
      <0.103847, 11.740774, -2.692330>, <0.240373, 11.580043, -2.588233>, <0.491239, 11.357966, -2.392874>, <0.726420, 11.357966, -2.392874>, 
      <0.103847, 12.427808, -1.846722>, <0.240373, 12.335450, -1.678971>, <0.491239, 12.114567, -1.477892>, <0.726420, 12.114567, -1.477892>, 
      <0.103847, 13.040496, -1.332439>, <0.240373, 12.948138, -1.164688>, <0.491239, 12.788292, -0.928270>, <0.726420, 12.788292, -0.928270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.005658, 11.781901, -3.702194>, <0.027193, 11.647362, -3.605767>, <0.005882, 11.448770, -3.455466>, <0.103847, 11.333437, -3.380771>, 
      <-0.005658, 12.144682, -3.079668>, <0.027193, 12.010143, -2.983241>, <0.005882, 11.856106, -2.767025>, <0.103847, 11.740774, -2.692330>, 
      <-0.005658, 12.747179, -2.308897>, <0.027193, 12.674268, -2.160295>, <0.005882, 12.494079, -1.967092>, <0.103847, 12.427808, -1.846722>, 
      <-0.005658, 13.283534, -1.827781>, <0.027193, 13.210622, -1.679178>, <0.005882, 13.106768, -1.452809>, <0.103847, 13.040496, -1.332439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.291949, 10.954103, -4.858657>, <1.381724, 11.105044, -4.857250>, <1.336153, 11.361238, -4.873449>, <1.355098, 11.535725, -4.879789>, 
      <1.291949, 11.067903, -4.415291>, <1.381724, 11.218845, -4.413884>, <1.336153, 11.442503, -4.525409>, <1.355098, 11.616989, -4.531748>, 
      <1.291949, 11.100347, -3.774716>, <1.381724, 11.226950, -3.856918>, <1.336153, 11.484817, -3.926849>, <1.355098, 11.626767, -4.028514>, 
      <1.291949, 11.333437, -3.380771>, <1.381724, 11.460039, -3.462972>, <1.336153, 11.664654, -3.617989>, <1.355098, 11.806606, -3.719654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.726420, 10.478710, -4.889642>, <0.948254, 10.478710, -4.889642>, <1.178554, 10.763450, -4.860434>, <1.291949, 10.954103, -4.858657>, 
      <0.726420, 10.611107, -4.365952>, <0.948254, 10.611107, -4.365952>, <1.178554, 10.877250, -4.417068>, <1.291949, 11.067903, -4.415291>, 
      <0.726420, 10.647966, -3.610657>, <0.948254, 10.647966, -3.610657>, <1.178554, 10.940436, -3.670888>, <1.291949, 11.100347, -3.774716>, 
      <0.726420, 10.920034, -3.144010>, <0.948254, 10.920034, -3.144010>, <1.178554, 11.173526, -3.276942>, <1.291949, 11.333437, -3.380771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.103847, 10.954103, -4.858657>, <0.240373, 10.762618, -4.860664>, <0.491239, 10.478710, -4.889642>, <0.726420, 10.478710, -4.889642>, 
      <0.103847, 11.067903, -4.415291>, <0.240373, 10.876418, -4.417298>, <0.491239, 10.611107, -4.365952>, <0.726420, 10.611107, -4.365952>, 
      <0.103847, 11.100347, -3.774716>, <0.240373, 10.939616, -3.670620>, <0.491239, 10.647966, -3.610657>, <0.726420, 10.647966, -3.610657>, 
      <0.103847, 11.333437, -3.380771>, <0.240373, 11.172706, -3.276675>, <0.491239, 10.920034, -3.144010>, <0.726420, 10.920034, -3.144010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.005658, 11.505486, -4.878880>, <0.027193, 11.340070, -4.872813>, <0.005882, 11.091504, -4.857217>, <0.103847, 10.954103, -4.858657>, 
      <-0.005658, 11.588410, -4.525874>, <0.027193, 11.422995, -4.519807>, <0.005882, 11.205304, -4.413851>, <0.103847, 11.067903, -4.415291>, 
      <-0.005658, 11.599324, -4.015492>, <0.027193, 11.464786, -3.919064>, <0.005882, 11.215680, -3.849411>, <0.103847, 11.100347, -3.774716>, 
      <-0.005658, 11.781901, -3.702194>, <0.027193, 11.647362, -3.605767>, <0.005882, 11.448770, -3.455466>, <0.103847, 11.333437, -3.380771>
    }
  }
  texture {
    UpperNeck
  }
}
union { // midBump
  object { BtmMiddle }
  object { TopBump }
  scale 7.0
  rotate <4.046727, -2.196092, -54.665085>
  translate  <147.08142, 131.77258, 110.0>
}


#declare Tail = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.600590, 0.730154, -11.199926>, <-0.640846, 0.730154, -10.512762>, <-0.791154, 0.666811, -9.592477>, <-0.734777, 0.730154, -8.909377>, 
      <-0.684973, 1.097987, -11.274969>, <-0.725229, 1.097987, -10.587805>, <-0.875537, 1.034643, -9.667519>, <-0.819160, 1.097987, -8.984420>, 
      <-0.442807, 1.472174, -11.354956>, <-0.483063, 1.472174, -10.667791>, <-0.584910, 1.402505, -9.749168>, <-0.576993, 1.472174, -9.064406>, 
      <-0.067421, 1.553991, -11.376028>, <-0.107677, 1.553991, -10.688864>, <-0.209523, 1.484322, -9.770241>, <-0.201607, 1.553991, -9.085478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.241789, 0.206123, -11.101044>, <0.201533, 0.206123, -10.413879>, <0.074419, 0.130037, -9.493814>, <0.107602, 0.206123, -8.810494>, 
      <-0.133597, 0.124306, -11.079971>, <-0.173853, 0.124306, -10.392807>, <-0.300968, 0.048220, -9.472742>, <-0.267784, 0.124306, -8.789422>, 
      <-0.516207, 0.362322, -11.124884>, <-0.556463, 0.362322, -10.437719>, <-0.706771, 0.298978, -9.517434>, <-0.650394, 0.362321, -8.834334>, 
      <-0.600590, 0.730154, -11.199926>, <-0.640846, 0.730154, -10.512762>, <-0.791154, 0.666811, -9.592477>, <-0.734777, 0.730154, -8.909377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.774957, 1.029960, -11.277142>, <0.734701, 1.029960, -10.589978>, <0.669706, 0.944924, -9.669051>, <0.640771, 1.029960, -8.986594>, 
      <0.859340, 0.662128, -11.202100>, <0.819084, 0.662128, -10.514935>, <0.754089, 0.577092, -9.594009>, <0.725154, 0.662128, -8.911551>, 
      <0.617175, 0.287940, -11.122116>, <0.576919, 0.287940, -10.434952>, <0.449805, 0.211853, -9.514887>, <0.482988, 0.287940, -8.831567>, 
      <0.241789, 0.206123, -11.101044>, <0.201533, 0.206123, -10.413879>, <0.074419, 0.130037, -9.493814>, <0.107602, 0.206123, -8.810494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.774957, 1.029960, -11.277142>, <0.690574, 1.397792, -11.352186>, <0.307965, 1.635808, -11.397101>, <-0.067421, 1.553991, -11.376028>, 
      <0.734701, 1.029960, -10.589978>, <0.650318, 1.397792, -10.665021>, <0.267709, 1.635808, -10.709936>, <-0.107677, 1.553991, -10.688864>, 
      <0.669706, 0.944924, -9.669051>, <0.585323, 1.312756, -9.744094>, <0.165862, 1.566139, -9.791313>, <-0.209523, 1.484322, -9.770241>, 
      <0.640771, 1.029960, -8.986594>, <0.556388, 1.397792, -9.061637>, <0.173779, 1.635808, -9.106551>, <-0.201607, 1.553991, -9.085478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.311958, 1.054449, -7.702702>, <-0.424883, 1.422282, -7.702702>, <-0.297077, 1.796469, -7.923401>, <-0.030572, 1.878286, -8.188606>, 
      <-0.491208, 0.926512, -8.031491>, <-0.604132, 1.294344, -8.031491>, <-0.461154, 1.725196, -8.152510>, <-0.194650, 1.807013, -8.417715>, 
      <-0.702366, 0.766570, -8.516663>, <-0.786749, 1.134403, -8.591706>, <-0.573650, 1.501594, -8.775243>, <-0.198264, 1.583411, -8.796315>, 
      <-0.734777, 0.730154, -8.909377>, <-0.819160, 1.097987, -8.984420>, <-0.576993, 1.472174, -9.064406>, <-0.201607, 1.553991, -9.085478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.383223, 0.530418, -8.188606>, <0.116718, 0.448601, -7.923401>, <-0.199034, 0.686616, -7.702702>, <-0.311958, 1.054449, -7.702702>, 
      <0.300817, 0.460289, -8.387101>, <0.034312, 0.378472, -8.121896>, <-0.378283, 0.558679, -8.031491>, <-0.491208, 0.926512, -8.031491>, 
      <0.118500, 0.231112, -8.586071>, <-0.256886, 0.149295, -8.564998>, <-0.617983, 0.398738, -8.441621>, <-0.702366, 0.766570, -8.516663>, 
      <0.107602, 0.206123, -8.810494>, <-0.267784, 0.124306, -8.789422>, <-0.650394, 0.362321, -8.834334>, <-0.734777, 0.730154, -8.909377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.664609, 1.354255, -8.674509>, <0.777533, 0.986423, -8.674509>, <0.649727, 0.612235, -8.453812>, <0.383223, 0.530418, -8.188606>, 
      <0.593123, 1.329009, -8.786466>, <0.706048, 0.961176, -8.786466>, <0.567321, 0.542106, -8.652306>, <0.300817, 0.460289, -8.387101>, 
      <0.635087, 1.046664, -8.852540>, <0.719470, 0.678831, -8.777498>, <0.493886, 0.312929, -8.607143>, <0.118500, 0.231112, -8.586071>, 
      <0.640771, 1.029960, -8.986594>, <0.725154, 0.662128, -8.911551>, <0.482988, 0.287940, -8.831567>, <0.107602, 0.206123, -8.810494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.664609, 1.354255, -8.674509>, <0.593123, 1.329009, -8.786466>, <0.635087, 1.046664, -8.852540>, <0.640771, 1.029960, -8.986594>, 
      <0.551685, 1.722087, -8.674509>, <0.480199, 1.696841, -8.786466>, <0.550704, 1.414496, -8.927582>, <0.556388, 1.397792, -9.061637>, 
      <0.235932, 1.960103, -8.453812>, <0.071855, 1.888830, -8.682921>, <0.177122, 1.665228, -8.817387>, <0.173779, 1.635808, -9.106551>, 
      <-0.030572, 1.878286, -8.188606>, <-0.194650, 1.807013, -8.417715>, <-0.198264, 1.583411, -8.796315>, <-0.201607, 1.553991, -9.085478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.374296, 1.521743, -6.875056>, <0.462725, 1.896220, -6.875056>, <0.762098, 2.154536, -7.095754>, <1.033417, 2.090466, -7.360960>, 
      <0.162128, 1.468629, -7.150466>, <0.250557, 1.843106, -7.150466>, <0.463844, 2.193386, -7.373465>, <0.735163, 2.129316, -7.638671>, 
      <-0.152655, 1.168150, -7.410499>, <-0.265579, 1.535982, -7.410499>, <-0.065996, 1.896847, -7.600734>, <0.200508, 1.978664, -7.865938>, 
      <-0.311958, 1.054449, -7.702702>, <-0.424883, 1.422282, -7.702702>, <-0.297077, 1.796469, -7.923401>, <-0.030572, 1.878286, -8.188606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.709381, 0.718249, -7.360960>, <0.438063, 0.782318, -7.095754>, <0.285867, 1.147266, -6.875056>, <0.374296, 1.521743, -6.875056>, 
      <0.617085, 0.716190, -7.617624>, <0.345766, 0.780260, -7.352418>, <0.073699, 1.094152, -7.150466>, <0.162128, 1.468629, -7.150466>, 
      <0.482647, 0.615030, -7.949118>, <0.216143, 0.533213, -7.683912>, <-0.039730, 0.800317, -7.410499>, <-0.152655, 1.168150, -7.410499>, 
      <0.383223, 0.530418, -8.188606>, <0.116718, 0.448601, -7.923401>, <-0.199034, 0.686616, -7.702702>, <-0.311958, 1.054449, -7.702702>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.368504, 1.286970, -7.846864>, <1.280075, 0.912493, -7.846864>, <0.980700, 0.654180, -7.626166>, <0.709381, 0.718249, -7.360960>, 
      <1.194275, 1.372279, -8.109574>, <1.105846, 0.997801, -8.109574>, <0.888403, 0.652121, -7.882830>, <0.617085, 0.716190, -7.617624>, 
      <0.837268, 1.415232, -8.404102>, <0.950192, 1.047400, -8.404102>, <0.749152, 0.696847, -8.214323>, <0.482647, 0.615030, -7.949118>, 
      <0.664609, 1.354255, -8.674509>, <0.777533, 0.986423, -8.674509>, <0.649727, 0.612235, -8.453812>, <0.383223, 0.530418, -8.188606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.368504, 1.286970, -7.846864>, <1.194275, 1.372279, -8.109574>, <0.837268, 1.415232, -8.404102>, <0.664609, 1.354255, -8.674509>, 
      <1.456933, 1.661448, -7.846864>, <1.282704, 1.746756, -8.109574>, <0.724343, 1.783064, -8.404102>, <0.551685, 1.722087, -8.674509>, 
      <1.304736, 2.026397, -7.626166>, <1.006482, 2.065247, -7.903878>, <0.467013, 2.060481, -8.131143>, <0.235932, 1.960103, -8.453812>, 
      <1.033417, 2.090466, -7.360960>, <0.735163, 2.129316, -7.638671>, <0.200508, 1.978664, -7.865938>, <-0.030572, 1.878286, -8.188606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121000, 1.413176, -5.842613>, <1.370703, 1.705924, -5.842613>, <1.755008, 1.798987, -6.063312>, <1.967112, 1.618070, -6.328518>, 
      <0.931048, 1.440843, -6.174771>, <1.180752, 1.733591, -6.174771>, <1.527909, 1.965768, -6.402560>, <1.740012, 1.784851, -6.667766>, 
      <0.605735, 1.579682, -6.574630>, <0.694164, 1.954159, -6.574630>, <1.083391, 2.112684, -6.796591>, <1.354710, 2.048615, -7.061797>, 
      <0.374296, 1.521743, -6.875056>, <0.462725, 1.896220, -6.875056>, <0.762098, 2.154536, -7.095754>, <1.033417, 2.090466, -7.360960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.052112, 0.545339, -6.328518>, <0.840008, 0.726256, -6.063312>, <0.871297, 1.120428, -5.842613>, <1.121000, 1.413176, -5.842613>, 
      <1.002041, 0.561256, -6.654764>, <0.789937, 0.742172, -6.389558>, <0.681345, 1.148095, -6.174771>, <0.931048, 1.440843, -6.174771>, 
      <0.821198, 0.720743, -7.050014>, <0.549879, 0.784813, -6.784808>, <0.517306, 1.205205, -6.574630>, <0.605735, 1.579682, -6.574630>, 
      <0.709381, 0.718249, -7.360960>, <0.438063, 0.782318, -7.095754>, <0.285867, 1.147266, -6.875056>, <0.374296, 1.521743, -6.875056>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.898223, 0.750234, -6.814421>, <1.648520, 0.457487, -6.814421>, <1.264215, 0.364423, -6.593724>, <1.052112, 0.545339, -6.328518>, 
      <1.812852, 0.905693, -7.154510>, <1.563149, 0.612945, -7.154510>, <1.214144, 0.380339, -6.919970>, <1.002041, 0.561256, -6.654764>, 
      <1.573135, 1.186775, -7.538314>, <1.484706, 0.812298, -7.538314>, <1.092516, 0.656674, -7.315219>, <0.821198, 0.720743, -7.050014>, 
      <1.368504, 1.286970, -7.846864>, <1.280075, 0.912493, -7.846864>, <0.980700, 0.654180, -7.626166>, <0.709381, 0.718249, -7.360960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.898223, 0.750234, -6.814421>, <1.812852, 0.905693, -7.154510>, <1.573135, 1.186775, -7.538314>, <1.368504, 1.286970, -7.846864>, 
      <2.147926, 1.042981, -6.814421>, <2.062555, 1.198440, -7.154510>, <1.661565, 1.561253, -7.538314>, <1.456933, 1.661448, -7.846864>, 
      <2.179215, 1.437154, -6.593723>, <1.952116, 1.603935, -6.932971>, <1.626029, 1.984545, -7.327003>, <1.304736, 2.026397, -7.626166>, 
      <1.967112, 1.618070, -6.328518>, <1.740012, 1.784851, -6.667766>, <1.354710, 2.048615, -7.061797>, <1.033417, 2.090466, -7.360960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.464052, 1.363015, -4.969457>, <1.820791, 1.507202, -4.969457>, <2.204597, 1.412101, -5.190155>, <2.309065, 1.153634, -5.455361>, 
      <1.348958, 1.410514, -5.222304>, <1.705698, 1.554701, -5.222304>, <2.126886, 1.596871, -5.431763>, <2.231354, 1.338404, -5.696968>, 
      <1.260549, 1.392850, -5.598591>, <1.510253, 1.685598, -5.598591>, <1.916673, 1.680260, -5.821813>, <2.128777, 1.499344, -6.087018>, 
      <1.121000, 1.413176, -5.842613>, <1.370703, 1.705924, -5.842613>, <1.755008, 1.798987, -6.063312>, <1.967112, 1.618070, -6.328518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.001846, 0.625281, -5.455361>, <0.897378, 0.883748, -5.190155>, <1.107313, 1.218828, -4.969457>, <1.464052, 1.363015, -4.969457>, 
      <1.015274, 0.594248, -5.716657>, <0.910806, 0.852715, -5.451451>, <0.992219, 1.266327, -5.222304>, <1.348958, 1.410514, -5.222304>, 
      <1.092035, 0.532648, -6.068395>, <0.879931, 0.713565, -5.803189>, <1.010846, 1.100102, -5.598591>, <1.260549, 1.392850, -5.598591>, 
      <1.052112, 0.545339, -6.328518>, <0.840008, 0.726256, -6.063312>, <0.871297, 1.120428, -5.842613>, <1.121000, 1.413176, -5.842613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.846859, 0.415900, -5.941265>, <1.490120, 0.271713, -5.941265>, <1.106314, 0.366814, -5.720567>, <1.001846, 0.625281, -5.455361>, 
      <1.893437, 0.531282, -6.193120>, <1.536698, 0.387095, -6.193120>, <1.119741, 0.335781, -5.981862>, <1.015274, 0.594248, -5.716657>, 
      <1.960749, 0.636377, -6.565341>, <1.711046, 0.343629, -6.565341>, <1.304138, 0.351732, -6.333600>, <1.092035, 0.532648, -6.068395>, 
      <1.898223, 0.750234, -6.814421>, <1.648520, 0.457487, -6.814421>, <1.264215, 0.364423, -6.593724>, <1.052112, 0.545339, -6.328518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.846859, 0.415900, -5.941265>, <1.893437, 0.531282, -6.193120>, <1.960749, 0.636377, -6.565341>, <1.898223, 0.750234, -6.814421>, 
      <2.203598, 0.560087, -5.941265>, <2.250176, 0.675469, -6.193120>, <2.210451, 0.929124, -6.565341>, <2.147926, 1.042981, -6.814421>, 
      <2.413533, 0.895167, -5.720567>, <2.335822, 1.079937, -5.962174>, <2.340880, 1.318428, -6.352224>, <2.179215, 1.437154, -6.593723>, 
      <2.309065, 1.153634, -5.455361>, <2.231354, 1.338404, -5.696968>, <2.128777, 1.499344, -6.087018>, <1.967112, 1.618070, -6.328518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.721276, 1.165442, -4.523883>, <2.105225, 1.140229, -4.523883>, <2.409536, 0.887752, -4.744583>, <2.391269, 0.609570, -5.009788>, 
      <1.665323, 1.235847, -4.662622>, <2.049273, 1.210634, -4.662622>, <2.425093, 1.047494, -4.883713>, <2.406826, 0.769312, -5.148919>, 
      <1.531570, 1.335150, -4.821129>, <1.888309, 1.479338, -4.821129>, <2.257177, 1.287085, -5.026682>, <2.361645, 1.028618, -5.291888>, 
      <1.464052, 1.363015, -4.969457>, <1.820791, 1.507202, -4.969457>, <2.204597, 1.412101, -5.190155>, <2.309065, 1.153634, -5.455361>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.984344, 0.701959, -5.009788>, <1.002611, 0.980141, -4.744582>, <1.337327, 1.190655, -4.523883>, <1.721276, 1.165442, -4.523883>, 
      <0.990353, 0.677729, -5.143211>, <1.008620, 0.955911, -4.878005>, <1.281374, 1.261060, -4.662622>, <1.665323, 1.235847, -4.662622>, 
      <0.994928, 0.641269, -5.320745>, <0.890460, 0.899736, -5.055539>, <1.174831, 1.190963, -4.821129>, <1.531570, 1.335150, -4.821129>, 
      <1.001846, 0.625281, -5.455361>, <0.897378, 0.883748, -5.190155>, <1.107313, 1.218828, -4.969457>, <1.464052, 1.363015, -4.969457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.654338, 0.146086, -5.495691>, <1.270389, 0.171299, -5.495691>, <0.966077, 0.423778, -5.274994>, <0.984344, 0.701959, -5.009788>, 
      <1.729919, 0.208031, -5.630622>, <1.345970, 0.233243, -5.630622>, <0.972086, 0.399548, -5.408417>, <0.990353, 0.677729, -5.143211>, 
      <1.819235, 0.347471, -5.791898>, <1.462496, 0.203284, -5.791898>, <1.099396, 0.382802, -5.585951>, <0.994928, 0.641269, -5.320745>, 
      <1.846859, 0.415900, -5.941265>, <1.490120, 0.271713, -5.941265>, <1.106314, 0.366814, -5.720567>, <1.001846, 0.625281, -5.455361>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.654338, 0.146086, -5.495691>, <1.729919, 0.208031, -5.630622>, <1.819235, 0.347471, -5.791898>, <1.846859, 0.415900, -5.941265>, 
      <2.038287, 0.120873, -5.495691>, <2.113868, 0.182818, -5.630622>, <2.175974, 0.491658, -5.791898>, <2.203598, 0.560087, -5.941265>, 
      <2.373002, 0.331389, -5.274994>, <2.388558, 0.491131, -5.414124>, <2.466112, 0.770151, -5.557094>, <2.413533, 0.895167, -5.720567>, 
      <2.391269, 0.609570, -5.009788>, <2.406826, 0.769312, -5.148919>, <2.361645, 1.028618, -5.291888>, <2.309065, 1.153634, -5.455361>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.823447, 0.910791, -4.078310>, <2.163947, 0.731592, -4.078310>, <2.339258, 0.377167, -4.299009>, <2.209423, 0.130466, -4.564214>, 
      <1.812847, 0.994684, -4.210573>, <2.153347, 0.815485, -4.210573>, <2.414225, 0.509777, -4.434278>, <2.284391, 0.263075, -4.699483>, 
      <1.774402, 1.098594, -4.392153>, <2.158351, 1.073381, -4.392153>, <2.394616, 0.734541, -4.611141>, <2.376348, 0.456359, -4.876346>, 
      <1.721276, 1.165442, -4.523883>, <2.105225, 1.140229, -4.523883>, <2.409536, 0.887752, -4.744583>, <2.391269, 0.609570, -5.009788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.961710, 0.787115, -4.564214>, <1.091545, 1.033817, -4.299008>, <1.482947, 1.089990, -4.078310>, <1.823447, 0.910791, -4.078310>, 
      <0.968639, 0.776762, -4.699904>, <1.098474, 1.023464, -4.434698>, <1.472347, 1.173883, -4.210573>, <1.812847, 0.994684, -4.210573>, 
      <0.978312, 0.726282, -4.875852>, <0.996579, 1.004464, -4.610646>, <1.390453, 1.123807, -4.392153>, <1.774402, 1.098594, -4.392153>, 
      <0.984344, 0.701959, -5.009788>, <1.002611, 0.980141, -4.744582>, <1.337327, 1.190655, -4.523883>, <1.721276, 1.165442, -4.523883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.347686, 0.006789, -5.050118>, <1.007186, 0.185988, -5.050118>, <0.831875, 0.540414, -4.829420>, <0.961710, 0.787115, -4.564214>, 
      <1.440159, 0.043182, -5.185033>, <1.099659, 0.222381, -5.185033>, <0.838804, 0.530061, -4.965110>, <0.968639, 0.776762, -4.699904>, 
      <1.578320, 0.083783, -5.359980>, <1.194371, 0.108996, -5.359980>, <0.960044, 0.448101, -5.141058>, <0.978312, 0.726282, -4.875852>, 
      <1.654338, 0.146086, -5.495691>, <1.270389, 0.171299, -5.495691>, <0.966077, 0.423778, -5.274994>, <0.984344, 0.701959, -5.009788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.347686, 0.006789, -5.050118>, <1.440159, 0.043182, -5.185033>, <1.578320, 0.083783, -5.359980>, <1.654338, 0.146086, -5.495691>, 
      <1.688186, -0.172410, -5.050118>, <1.780660, -0.136017, -5.185033>, <1.962269, 0.058571, -5.359980>, <2.038287, 0.120873, -5.495691>, 
      <2.079588, -0.116236, -4.829420>, <2.154556, 0.016374, -4.964689>, <2.358081, 0.178178, -5.141552>, <2.373002, 0.331389, -5.274994>, 
      <2.209423, 0.130466, -4.564214>, <2.284391, 0.263075, -4.699483>, <2.376348, 0.456359, -4.876346>, <2.391269, 0.609570, -5.009788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.792694, 0.600194, -3.632736>, <2.054281, 0.318015, -3.632736>, <2.101832, -0.074529, -3.853434>, <1.897385, -0.264055, -4.118640>, 
      <1.815558, 0.683966, -3.770922>, <2.077145, 0.401786, -3.770922>, <2.211414, 0.021497, -3.992756>, <2.006967, -0.168029, -4.257961>, 
      <1.834467, 0.823573, -3.940806>, <2.174967, 0.644374, -3.940806>, <2.265074, 0.245945, -4.165154>, <2.135239, -0.000757, -4.430360>, 
      <1.823447, 0.910791, -4.078310>, <2.163947, 0.731592, -4.078310>, <2.339258, 0.377167, -4.299009>, <2.209423, 0.130466, -4.564214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.938839, 0.769950, -4.118640>, <1.143286, 0.959476, -3.853434>, <1.531107, 0.882373, -3.632736>, <1.792694, 0.600194, -3.632736>, 
      <0.945642, 0.768638, -4.252408>, <1.150088, 0.958164, -3.987202>, <1.553972, 0.966145, -3.770922>, <1.815558, 0.683966, -3.770922>, 
      <0.954899, 0.797292, -4.430828>, <1.084734, 1.043994, -4.165622>, <1.493967, 1.002772, -3.940806>, <1.834467, 0.823573, -3.940806>, 
      <0.961710, 0.787115, -4.564214>, <1.091545, 1.033817, -4.299008>, <1.482947, 1.089990, -4.078310>, <1.823447, 0.910791, -4.078310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.043529, -0.094298, -4.604544>, <0.781943, 0.187881, -4.604544>, <0.734393, 0.580424, -4.383846>, <0.938839, 0.769950, -4.118640>, 
      <1.135197, -0.084312, -4.740967>, <0.873610, 0.197867, -4.740967>, <0.741195, 0.579111, -4.517614>, <0.945642, 0.768638, -4.252408>, 
      <1.256814, -0.028974, -4.917539>, <0.916314, 0.150225, -4.917539>, <0.825064, 0.550590, -4.696034>, <0.954899, 0.797292, -4.430828>, 
      <1.347686, 0.006789, -5.050118>, <1.007186, 0.185988, -5.050118>, <0.831875, 0.540414, -4.829420>, <0.961710, 0.787115, -4.564214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.043529, -0.094298, -4.604544>, <1.135197, -0.084312, -4.740967>, <1.256814, -0.028974, -4.917539>, <1.347686, 0.006789, -5.050118>, 
      <1.305116, -0.376478, -4.604544>, <1.396784, -0.366491, -4.740967>, <1.597314, -0.208173, -4.917539>, <1.688186, -0.172410, -5.050118>, 
      <1.692938, -0.453582, -4.383846>, <1.802521, -0.357556, -4.523167>, <2.005404, -0.247458, -4.695566>, <2.079588, -0.116236, -4.829420>, 
      <1.897385, -0.264055, -4.118640>, <2.006967, -0.168029, -4.257961>, <2.135239, -0.000757, -4.430360>, <2.209423, 0.130466, -4.564214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.675998, 0.370554, -3.187163>, <1.837583, 0.021351, -3.187163>, <1.761504, -0.366674, -3.407862>, <1.508497, -0.483747, -3.673067>, 
      <1.751883, 0.454809, -3.291961>, <1.913468, 0.105605, -3.291961>, <1.912921, -0.308922, -3.505641>, <1.659913, -0.425996, -3.770847>, 
      <1.771063, 0.520941, -3.502004>, <2.032650, 0.238761, -3.502004>, <1.998948, -0.164684, -3.722629>, <1.794501, -0.354211, -3.987835>, 
      <1.792694, 0.600194, -3.632736>, <2.054281, 0.318015, -3.632736>, <2.101832, -0.074529, -3.853434>, <1.897385, -0.264055, -4.118640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.916391, 0.795858, -3.673067>, <1.169398, 0.912931, -3.407862>, <1.514413, 0.719757, -3.187163>, <1.675998, 0.370554, -3.187163>, 
      <0.950558, 0.807098, -3.802219>, <1.203565, 0.924171, -3.537013>, <1.590298, 0.804012, -3.291961>, <1.751883, 0.454809, -3.291961>, 
      <0.932030, 0.771264, -3.984752>, <1.136477, 0.960790, -3.719547>, <1.509477, 0.803120, -3.502004>, <1.771063, 0.520941, -3.502004>, 
      <0.938839, 0.769950, -4.118640>, <1.143286, 0.959476, -3.853434>, <1.531107, 0.882373, -3.632736>, <1.792694, 0.600194, -3.632736>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.748890, -0.058443, -4.158970>, <0.587305, 0.290760, -4.158970>, <0.663384, 0.678785, -3.938272>, <0.916391, 0.795858, -3.673067>, 
      <0.866763, -0.072115, -4.267211>, <0.705177, 0.277088, -4.267211>, <0.697551, 0.690025, -4.067424>, <0.950558, 0.807098, -3.802219>, 
      <0.954115, -0.104039, -4.471475>, <0.692529, 0.178141, -4.471475>, <0.727584, 0.581737, -4.249958>, <0.932030, 0.771264, -3.984752>, 
      <1.043529, -0.094298, -4.604544>, <0.781943, 0.187881, -4.604544>, <0.734393, 0.580424, -4.383846>, <0.938839, 0.769950, -4.118640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.748890, -0.058443, -4.158970>, <0.866763, -0.072115, -4.267211>, <0.954115, -0.104039, -4.471475>, <1.043529, -0.094298, -4.604544>, 
      <0.910475, -0.407646, -4.158970>, <1.028348, -0.421319, -4.267211>, <1.215702, -0.386218, -4.471475>, <1.305116, -0.376478, -4.604544>, 
      <1.255490, -0.600820, -3.938272>, <1.406906, -0.543069, -4.036052>, <1.590054, -0.543737, -4.253041>, <1.692938, -0.453582, -4.383846>, 
      <1.508497, -0.483747, -3.673067>, <1.659913, -0.425996, -3.770847>, <1.794501, -0.354211, -3.987835>, <1.897385, -0.264055, -4.118640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.252121, 0.000000, -2.886203>, <1.252121, -0.384777, -2.886203>, <1.020126, -0.704978, -3.106902>, <0.741345, -0.704978, -3.372108>, 
      <1.408745, 0.074589, -2.967356>, <1.408745, -0.310188, -2.967356>, <1.252064, -0.662631, -3.206578>, <0.973283, -0.662631, -3.471783>, 
      <1.581870, 0.266044, -3.057172>, <1.743455, -0.083159, -3.057172>, <1.556723, -0.444779, -3.275620>, <1.303715, -0.561852, -3.540826>, 
      <1.675998, 0.370554, -3.187163>, <1.837583, 0.021351, -3.187163>, <1.761504, -0.366674, -3.407862>, <1.508497, -0.483747, -3.673067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.741345, 0.704978, -3.372108>, <1.020126, 0.704978, -3.106902>, <1.252121, 0.384777, -2.886203>, <1.252121, 0.000000, -2.886203>, 
      <0.823468, 0.717024, -3.441127>, <1.102249, 0.717024, -3.175921>, <1.408745, 0.459365, -2.967356>, <1.408745, 0.074589, -2.967356>, 
      <0.888880, 0.786807, -3.569076>, <1.141888, 0.903880, -3.303870>, <1.420284, 0.615247, -3.057172>, <1.581870, 0.266044, -3.057172>, 
      <0.916391, 0.795858, -3.673067>, <1.169398, 0.912931, -3.407862>, <1.514413, 0.719757, -3.187163>, <1.675998, 0.370554, -3.187163>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.230569, 0.000000, -3.858011>, <0.230569, 0.384776, -3.858011>, <0.462564, 0.704978, -3.637314>, <0.741345, 0.704978, -3.372108>, 
      <0.384897, -0.008564, -3.951542>, <0.384897, 0.376212, -3.951542>, <0.544687, 0.717024, -3.706333>, <0.823468, 0.717024, -3.441127>, 
      <0.616306, -0.043064, -4.037219>, <0.454721, 0.306139, -4.037219>, <0.635873, 0.669734, -3.834282>, <0.888880, 0.786807, -3.569076>, 
      <0.748890, -0.058443, -4.158970>, <0.587305, 0.290760, -4.158970>, <0.663384, 0.678785, -3.938272>, <0.916391, 0.795858, -3.673067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.230569, 0.000000, -3.858011>, <0.384897, -0.008564, -3.951542>, <0.616306, -0.043064, -4.037219>, <0.748890, -0.058443, -4.158970>, 
      <0.230569, -0.384776, -3.858011>, <0.384897, -0.393340, -3.951542>, <0.777891, -0.392267, -4.037219>, <0.910475, -0.407646, -4.158970>, 
      <0.462564, -0.704978, -3.637314>, <0.694503, -0.662631, -3.736989>, <1.050708, -0.678925, -3.806031>, <1.255490, -0.600820, -3.938272>, 
      <0.741345, -0.704978, -3.372108>, <0.973283, -0.662631, -3.471783>, <1.303715, -0.561852, -3.540826>, <1.508497, -0.483747, -3.673067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.897901, 0.000000, -2.783998>, <0.897901, -0.384776, -2.783998>, <0.624882, -0.704978, -2.951301>, <0.296805, -0.704978, -3.152343>, 
      <0.981809, 0.000000, -2.856054>, <0.981809, -0.384776, -2.856054>, <0.734616, -0.704978, -3.051753>, <0.406539, -0.704978, -3.252795>, 
      <1.161673, -0.043074, -2.839338>, <1.161673, -0.427851, -2.839338>, <0.885328, -0.729590, -3.048973>, <0.606547, -0.729590, -3.314178>, 
      <1.252121, 0.000000, -2.886203>, <1.252121, -0.384777, -2.886203>, <1.020126, -0.704978, -3.106902>, <0.741345, -0.704978, -3.372108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.296805, 0.704978, -3.152343>, <0.624882, 0.704978, -2.951301>, <0.897901, 0.384776, -2.783998>, <0.897901, 0.000000, -2.783998>, 
      <0.406539, 0.704978, -3.252795>, <0.734616, 0.704978, -3.051753>, <0.981809, 0.384776, -2.856054>, <0.981809, 0.000000, -2.856054>, 
      <0.628168, 0.688377, -3.276990>, <0.906949, 0.688377, -3.011784>, <1.161673, 0.341702, -2.839338>, <1.161673, -0.043074, -2.839338>, 
      <0.741345, 0.704978, -3.372108>, <1.020126, 0.704978, -3.106902>, <1.252121, 0.384777, -2.886203>, <1.252121, 0.000000, -2.886203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.304291, 0.000000, -3.520688>, <-0.304291, 0.384776, -3.520688>, <-0.031272, 0.704978, -3.353385>, <0.296805, 0.704978, -3.152343>, 
      <-0.167388, 0.000000, -3.652009>, <-0.167388, 0.384776, -3.652009>, <0.078462, 0.704978, -3.453837>, <0.406539, 0.704978, -3.252795>, 
      <0.068516, 0.008993, -3.759799>, <0.068516, 0.393769, -3.759799>, <0.349387, 0.688377, -3.542195>, <0.628168, 0.688377, -3.276990>, 
      <0.230569, 0.000000, -3.858011>, <0.230569, 0.384776, -3.858011>, <0.462564, 0.704978, -3.637314>, <0.741345, 0.704978, -3.372108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.304291, 0.000000, -3.520688>, <-0.167388, 0.000000, -3.652009>, <0.068516, 0.008993, -3.759799>, <0.230569, 0.000000, -3.858011>, 
      <-0.304291, -0.384776, -3.520688>, <-0.167388, -0.384776, -3.652009>, <0.068516, -0.375783, -3.759799>, <0.230569, -0.384776, -3.858011>, 
      <-0.031272, -0.704978, -3.353385>, <0.078462, -0.704978, -3.453837>, <0.327766, -0.729590, -3.579384>, <0.462564, -0.704978, -3.637314>, 
      <0.296805, -0.704978, -3.152343>, <0.406539, -0.704978, -3.252795>, <0.606547, -0.729590, -3.314178>, <0.741345, -0.704978, -3.372108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.636655, 0.000000, -2.357676>, <0.636655, -0.384776, -2.357676>, <0.363636, -0.704978, -2.524979>, <0.035559, -0.704978, -2.726021>, 
      <0.699767, 0.000000, -2.493752>, <0.699767, -0.384776, -2.493752>, <0.413821, -0.718395, -2.665697>, <0.085744, -0.718395, -2.866739>, 
      <0.784103, 0.000000, -2.686274>, <0.784103, -0.384776, -2.686274>, <0.514240, -0.704978, -2.850018>, <0.186163, -0.704978, -3.051060>, 
      <0.897901, 0.000000, -2.783998>, <0.897901, -0.384776, -2.783998>, <0.624882, -0.704978, -2.951301>, <0.296805, -0.704978, -3.152343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.035559, 0.704978, -2.726021>, <0.363636, 0.704978, -2.524979>, <0.636655, 0.384776, -2.357676>, <0.636655, 0.000000, -2.357676>, 
      <0.085744, 0.718395, -2.866739>, <0.413821, 0.718395, -2.665697>, <0.699767, 0.384776, -2.493752>, <0.699767, 0.000000, -2.493752>, 
      <0.186163, 0.704978, -3.051060>, <0.514240, 0.704978, -2.850018>, <0.784103, 0.384776, -2.686274>, <0.784103, 0.000000, -2.686274>, 
      <0.296805, 0.704978, -3.152343>, <0.624882, 0.704978, -2.951301>, <0.897901, 0.384776, -2.783998>, <0.897901, 0.000000, -2.783998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.565537, 0.000000, -3.094365>, <-0.565537, 0.384776, -3.094365>, <-0.292518, 0.704978, -2.927063>, <0.035559, 0.704978, -2.726021>, 
      <-0.524269, 0.000000, -3.238576>, <-0.524269, 0.384776, -3.238576>, <-0.242334, 0.718395, -3.067781>, <0.085744, 0.718395, -2.866739>, 
      <-0.412541, 0.000000, -3.416852>, <-0.412541, 0.384776, -3.416852>, <-0.141914, 0.704978, -3.252102>, <0.186163, 0.704978, -3.051060>, 
      <-0.304291, 0.000000, -3.520688>, <-0.304291, 0.384776, -3.520688>, <-0.031272, 0.704978, -3.353385>, <0.296805, 0.704978, -3.152343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.565537, 0.000000, -3.094365>, <-0.524269, 0.000000, -3.238576>, <-0.412541, 0.000000, -3.416852>, <-0.304291, 0.000000, -3.520688>, 
      <-0.565537, -0.384776, -3.094365>, <-0.524269, -0.384776, -3.238576>, <-0.412541, -0.384776, -3.416852>, <-0.304291, -0.384776, -3.520688>, 
      <-0.292518, -0.704978, -2.927063>, <-0.242334, -0.718395, -3.067781>, <-0.141914, -0.704978, -3.252102>, <-0.031272, -0.704978, -3.353385>, 
      <0.035559, -0.704978, -2.726021>, <0.085744, -0.718395, -2.866739>, <0.186163, -0.704978, -3.051060>, <0.296805, -0.704978, -3.152343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.555173, 0.000000, -2.045041>, <0.555173, -0.336308, -2.045041>, <0.286953, -0.616176, -2.124941>, <-0.035359, -0.616176, -2.220954>, 
      <0.599547, 0.017265, -2.129463>, <0.599547, -0.319043, -2.129463>, <0.334861, -0.637930, -2.271065>, <0.012549, -0.637930, -2.367078>, 
      <0.595874, 0.000000, -2.269749>, <0.595874, -0.384776, -2.269749>, <0.311676, -0.691087, -2.379281>, <-0.016402, -0.691087, -2.580323>, 
      <0.636655, 0.000000, -2.357676>, <0.636655, -0.384776, -2.357676>, <0.363636, -0.704978, -2.524979>, <0.035559, -0.704978, -2.726021>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.035359, 0.616176, -2.220954>, <0.286953, 0.616176, -2.124941>, <0.555173, 0.336308, -2.045041>, <0.555173, 0.000000, -2.045041>, 
      <0.003786, 0.657008, -2.365595>, <0.326097, 0.657008, -2.269582>, <0.599547, 0.353573, -2.129463>, <0.599547, 0.017265, -2.129463>, 
      <-0.016402, 0.691087, -2.580323>, <0.311676, 0.691087, -2.379281>, <0.595874, 0.384776, -2.269749>, <0.595874, 0.000000, -2.269749>, 
      <0.035559, 0.704978, -2.726021>, <0.363636, 0.704978, -2.524979>, <0.636655, 0.384776, -2.357676>, <0.636655, 0.000000, -2.357676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.625891, 0.000000, -2.396867>, <-0.625891, 0.336308, -2.396867>, <-0.357671, 0.616176, -2.316967>, <-0.035359, 0.616176, -2.220954>, 
      <-0.605494, 0.003682, -2.605873>, <-0.605494, 0.339990, -2.605873>, <-0.318526, 0.657008, -2.461608>, <0.003786, 0.657008, -2.365595>, 
      <-0.623321, 0.000000, -2.892439>, <-0.623321, 0.384776, -2.892439>, <-0.344479, 0.691087, -2.781365>, <-0.016402, 0.691087, -2.580323>, 
      <-0.565537, 0.000000, -3.094365>, <-0.565537, 0.384776, -3.094365>, <-0.292518, 0.704978, -2.927063>, <0.035559, 0.704978, -2.726021>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.625891, 0.000000, -2.396867>, <-0.605494, 0.003682, -2.605873>, <-0.623321, 0.000000, -2.892439>, <-0.565537, 0.000000, -3.094365>, 
      <-0.625891, -0.336308, -2.396867>, <-0.605494, -0.332626, -2.605873>, <-0.623321, -0.384776, -2.892439>, <-0.565537, -0.384776, -3.094365>, 
      <-0.357671, -0.616176, -2.316967>, <-0.309762, -0.637930, -2.463091>, <-0.344479, -0.691087, -2.781365>, <-0.292518, -0.704978, -2.927063>, 
      <-0.035359, -0.616176, -2.220954>, <0.012549, -0.637930, -2.367078>, <-0.016402, -0.691087, -2.580323>, <0.035559, -0.704978, -2.726021>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.127683, -0.198031, -1.389340>, <0.140613, -0.452333, -1.487513>, <-0.031281, -0.623536, -1.697969>, <-0.250771, -0.574965, -1.852692>, 
      <0.262266, -0.092588, -1.560923>, <0.275196, -0.346889, -1.659096>, <0.071693, -0.616674, -1.774675>, <-0.147797, -0.568103, -1.929399>, 
      <0.444279, -0.043147, -1.834061>, <0.444279, -0.379455, -1.834061>, <0.247287, -0.598165, -2.003958>, <-0.075024, -0.598165, -2.099971>, 
      <0.555173, 0.000000, -2.045041>, <0.555173, -0.336308, -2.045041>, <0.286953, -0.616176, -2.124941>, <-0.035359, -0.616176, -2.220954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.298150, 0.356884, -1.492952>, <-0.078661, 0.308313, -1.338229>, <0.114753, 0.056270, -1.291168>, <0.127683, -0.198031, -1.389340>, 
      <-0.204045, 0.445383, -1.700984>, <0.015445, 0.396812, -1.546260>, <0.249336, 0.161713, -1.462751>, <0.262266, -0.092588, -1.560923>, 
      <-0.097079, 0.551795, -1.992895>, <0.225232, 0.551795, -1.896882>, <0.444279, 0.293161, -1.834061>, <0.444279, -0.043147, -1.834061>, 
      <-0.035359, 0.616176, -2.220954>, <0.286953, 0.616176, -2.124941>, <0.555173, 0.336308, -2.045041>, <0.555173, 0.000000, -2.045041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.676604, -0.020050, -1.956302>, <-0.689534, 0.234251, -1.858130>, <-0.517639, 0.405455, -1.647676>, <-0.298150, 0.356884, -1.492952>, 
      <-0.612852, -0.014868, -2.073115>, <-0.625782, 0.239434, -1.974942>, <-0.423534, 0.493954, -1.855708>, <-0.204045, 0.445383, -1.700984>, 
      <-0.638825, -0.002335, -2.264339>, <-0.638825, 0.333973, -2.264339>, <-0.419391, 0.551795, -2.088908>, <-0.097079, 0.551795, -1.992895>, 
      <-0.625891, 0.000000, -2.396867>, <-0.625891, 0.336308, -2.396867>, <-0.357671, 0.616176, -2.316967>, <-0.035359, 0.616176, -2.220954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.676604, -0.020050, -1.956302>, <-0.612852, -0.014868, -2.073115>, <-0.638825, -0.002335, -2.264339>, <-0.625891, 0.000000, -2.396867>, 
      <-0.663674, -0.274351, -2.054475>, <-0.599923, -0.269168, -2.171288>, <-0.638825, -0.338643, -2.264339>, <-0.625891, -0.336308, -2.396867>, 
      <-0.470260, -0.526394, -2.007416>, <-0.367286, -0.519532, -2.084122>, <-0.397336, -0.598165, -2.195984>, <-0.357671, -0.616176, -2.316967>, 
      <-0.250771, -0.574965, -1.852692>, <-0.147797, -0.568103, -1.929399>, <-0.075024, -0.598165, -2.099971>, <-0.035359, -0.616176, -2.220954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.173319, -0.570761, -1.116269>, <-0.167493, -0.762323, -1.362758>, <-0.370098, -0.800627, -1.666907>, <-0.619389, -0.655092, -1.785904>, 
      <-0.069009, -0.467404, -1.192464>, <-0.063183, -0.658967, -1.438953>, <-0.275886, -0.756192, -1.715466>, <-0.525177, -0.610657, -1.834463>, 
      <0.035764, -0.270048, -1.272151>, <0.048694, -0.524349, -1.370324>, <-0.123317, -0.629668, -1.629410>, <-0.342807, -0.581097, -1.784134>, 
      <0.127683, -0.198031, -1.389340>, <0.140613, -0.452333, -1.487513>, <-0.031281, -0.623536, -1.697969>, <-0.250771, -0.574965, -1.852692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.640740, 0.046861, -0.882681>, <-0.391448, -0.098674, -0.763683>, <-0.179146, -0.379199, -0.869780>, <-0.173319, -0.570761, -1.116269>, 
      <-0.522133, 0.171006, -1.035169>, <-0.272842, 0.025471, -0.916172>, <-0.074836, -0.275842, -0.945975>, <-0.069009, -0.467404, -1.192464>, 
      <-0.386398, 0.273894, -1.297870>, <-0.166908, 0.225323, -1.143146>, <0.022835, -0.015747, -1.173978>, <0.035764, -0.270048, -1.272151>, 
      <-0.298150, 0.356884, -1.492952>, <-0.078661, 0.308313, -1.338229>, <0.114753, 0.056270, -1.291168>, <0.127683, -0.198031, -1.389340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.086811, -0.037470, -1.552317>, <-1.092637, 0.154093, -1.305828>, <-0.890031, 0.192396, -1.001678>, <-0.640740, 0.046861, -0.882681>, 
      <-0.974592, 0.019890, -1.670541>, <-0.980419, 0.211453, -1.424051>, <-0.771425, 0.316541, -1.154166>, <-0.522133, 0.171006, -1.035169>, 
      <-0.759323, -0.026775, -1.804736>, <-0.772252, 0.227527, -1.706563>, <-0.605887, 0.322465, -1.452593>, <-0.386398, 0.273894, -1.297870>, 
      <-0.676604, -0.020050, -1.956302>, <-0.689534, 0.234251, -1.858130>, <-0.517639, 0.405455, -1.647676>, <-0.298150, 0.356884, -1.492952>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.086811, -0.037470, -1.552317>, <-0.974592, 0.019890, -1.670541>, <-0.759323, -0.026775, -1.804736>, <-0.676604, -0.020050, -1.956302>, 
      <-1.080985, -0.229032, -1.798806>, <-0.968766, -0.171672, -1.917030>, <-0.746393, -0.281075, -1.902909>, <-0.663674, -0.274351, -2.054475>, 
      <-0.868681, -0.509557, -1.904901>, <-0.774468, -0.465122, -1.953460>, <-0.562296, -0.532527, -1.938857>, <-0.470260, -0.526394, -2.007416>, 
      <-0.619389, -0.655092, -1.785904>, <-0.525177, -0.610657, -1.834463>, <-0.342807, -0.581097, -1.784134>, <-0.250771, -0.574965, -1.852692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.466707, -0.786990, -0.955159>, <-0.461614, -0.954422, -1.170599>, <-0.638699, -0.987900, -1.436437>, <-0.856589, -0.860697, -1.540445>, 
      <-0.396206, -0.709961, -1.013357>, <-0.391113, -0.877393, -1.228797>, <-0.566899, -0.908893, -1.490228>, <-0.784789, -0.781690, -1.594237>, 
      <-0.248694, -0.645447, -1.061210>, <-0.242868, -0.837010, -1.307699>, <-0.468095, -0.846847, -1.616398>, <-0.717386, -0.701312, -1.735395>, 
      <-0.173319, -0.570761, -1.116269>, <-0.167493, -0.762323, -1.362758>, <-0.370098, -0.800627, -1.666907>, <-0.619389, -0.655092, -1.785904>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.875249, -0.247165, -0.750996>, <-0.657360, -0.374368, -0.646988>, <-0.471799, -0.619557, -0.739718>, <-0.466707, -0.786990, -0.955159>, 
      <-0.803275, -0.173886, -0.812157>, <-0.585385, -0.301089, -0.708149>, <-0.401298, -0.542528, -0.797916>, <-0.396206, -0.709961, -1.013357>, 
      <-0.702484, -0.017767, -0.803298>, <-0.453193, -0.163302, -0.684300>, <-0.254521, -0.453885, -0.814721>, <-0.248694, -0.645447, -1.061210>, 
      <-0.640740, 0.046861, -0.882681>, <-0.391448, -0.098674, -0.763683>, <-0.179146, -0.379199, -0.869780>, <-0.173319, -0.570761, -1.116269>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.265132, -0.320873, -1.336281>, <-1.270224, -0.153440, -1.120841>, <-1.093139, -0.119962, -0.855004>, <-0.875249, -0.247165, -0.750996>, 
      <-1.191764, -0.245517, -1.393110>, <-1.196857, -0.078085, -1.177670>, <-1.021164, -0.046683, -0.916165>, <-0.803275, -0.173886, -0.812157>, 
      <-1.164444, -0.077151, -1.470529>, <-1.170271, 0.114411, -1.224040>, <-0.951776, 0.127768, -0.922295>, <-0.702484, -0.017767, -0.803298>, 
      <-1.086811, -0.037470, -1.552317>, <-1.092637, 0.154093, -1.305828>, <-0.890031, 0.192396, -1.001678>, <-0.640740, 0.046861, -0.882681>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.265132, -0.320873, -1.336281>, <-1.191764, -0.245517, -1.393110>, <-1.164444, -0.077151, -1.470529>, <-1.086811, -0.037470, -1.552317>, 
      <-1.260039, -0.488305, -1.551721>, <-1.186672, -0.412950, -1.608551>, <-1.158618, -0.268714, -1.717018>, <-1.080985, -0.229032, -1.798806>, 
      <-1.074478, -0.733494, -1.644453>, <-1.002678, -0.654487, -1.698244>, <-0.966678, -0.555777, -1.854392>, <-0.868681, -0.509557, -1.904901>, 
      <-0.856589, -0.860697, -1.540445>, <-0.784789, -0.781690, -1.594237>, <-0.717386, -0.701312, -1.735395>, <-0.619389, -0.655092, -1.785904>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.578927, -1.013925, -0.781445>, <-0.572910, -1.211735, -1.035973>, <-0.775319, -1.260212, -1.353352>, <-1.032741, -1.109930, -1.476230>, 
      <-0.512986, -0.962399, -0.819931>, <-0.506970, -1.160209, -1.074458>, <-0.719398, -1.209962, -1.409048>, <-0.976820, -1.059681, -1.531927>, 
      <-0.521029, -0.846341, -0.910317>, <-0.515936, -1.013774, -1.125757>, <-0.694896, -1.049737, -1.394336>, <-0.912786, -0.922534, -1.498344>, 
      <-0.466707, -0.786990, -0.955159>, <-0.461614, -0.954422, -1.170599>, <-0.638699, -0.987900, -1.436437>, <-0.856589, -0.860697, -1.540445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.055095, -0.375003, -0.530578>, <-0.797673, -0.525285, -0.407700>, <-0.584943, -0.816115, -0.526917>, <-0.578927, -1.013925, -0.781445>, 
      <-0.999703, -0.307350, -0.563880>, <-0.742281, -0.457631, -0.441002>, <-0.519003, -0.764589, -0.565403>, <-0.512986, -0.962399, -0.819931>, 
      <-0.931582, -0.304519, -0.703126>, <-0.713693, -0.431722, -0.599118>, <-0.526121, -0.678909, -0.694877>, <-0.521029, -0.846341, -0.910317>, 
      <-0.875249, -0.247165, -0.750996>, <-0.657360, -0.374368, -0.646988>, <-0.471799, -0.619557, -0.739718>, <-0.466707, -0.786990, -0.955159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.508909, -0.471007, -1.225365>, <-1.514926, -0.273197, -0.970836>, <-1.312517, -0.224722, -0.653457>, <-1.055095, -0.375003, -0.530578>, 
      <-1.465266, -0.406463, -1.274494>, <-1.471283, -0.208653, -1.019966>, <-1.257125, -0.157068, -0.686759>, <-0.999703, -0.307350, -0.563880>, 
      <-1.321662, -0.378935, -1.292493>, <-1.326755, -0.211503, -1.077053>, <-1.149472, -0.177316, -0.807134>, <-0.931582, -0.304519, -0.703126>, 
      <-1.265132, -0.320873, -1.336281>, <-1.270224, -0.153440, -1.120841>, <-1.093139, -0.119962, -0.855004>, <-0.875249, -0.247165, -0.750996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.508909, -0.471007, -1.225365>, <-1.465266, -0.406463, -1.274494>, <-1.321662, -0.378935, -1.292493>, <-1.265132, -0.320873, -1.336281>, 
      <-1.502893, -0.668817, -1.479893>, <-1.459249, -0.604274, -1.529022>, <-1.316570, -0.546368, -1.507933>, <-1.260039, -0.488305, -1.551721>, 
      <-1.290163, -0.959649, -1.599108>, <-1.234242, -0.909400, -1.654805>, <-1.130675, -0.795331, -1.602352>, <-1.074478, -0.733494, -1.644453>, 
      <-1.032741, -1.109930, -1.476230>, <-0.976820, -1.059681, -1.531927>, <-0.912786, -0.922534, -1.498344>, <-0.856589, -0.860697, -1.540445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.696225, -0.966336, -0.821202>, <-0.691627, -1.117494, -1.015700>, <-0.851499, -1.147718, -1.255697>, <-1.048209, -1.032880, -1.349595>, 
      <-0.680078, -0.994877, -0.798639>, <-0.675481, -1.146035, -0.993137>, <-0.862041, -1.184583, -1.278697>, <-1.058751, -1.069745, -1.372595>, 
      <-0.607422, -1.036191, -0.764814>, <-0.601406, -1.234002, -1.019341>, <-0.802042, -1.284224, -1.326736>, <-1.059464, -1.133943, -1.449614>, 
      <-0.578927, -1.013925, -0.781445>, <-0.572910, -1.211735, -1.035973>, <-0.775319, -1.260212, -1.353352>, <-1.032741, -1.109930, -1.476230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.065056, -0.478986, -0.636884>, <-0.868346, -0.593823, -0.542986>, <-0.700822, -0.815179, -0.626703>, <-0.696225, -0.966336, -0.821202>, 
      <-1.077112, -0.466058, -0.595815>, <-0.880402, -0.580896, -0.501917>, <-0.684675, -0.843719, -0.604141>, <-0.680078, -0.994877, -0.798639>, 
      <-1.081565, -0.407333, -0.514664>, <-0.824143, -0.557614, -0.391786>, <-0.613439, -0.838381, -0.510286>, <-0.607422, -1.036191, -0.764814>, 
      <-1.055095, -0.375003, -0.530578>, <-0.797673, -0.525285, -0.407700>, <-0.584943, -0.816115, -0.526917>, <-0.578927, -1.013925, -0.781445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.417040, -0.545529, -1.165278>, <-1.421638, -0.394371, -0.970779>, <-1.261766, -0.364147, -0.730782>, <-1.065056, -0.478986, -0.636884>, 
      <-1.456455, -0.541634, -1.169236>, <-1.461052, -0.390476, -0.974738>, <-1.273822, -0.351220, -0.689713>, <-1.077112, -0.466058, -0.595815>, 
      <-1.527769, -0.498899, -1.204134>, <-1.533786, -0.301088, -0.949606>, <-1.338987, -0.257051, -0.637543>, <-1.081565, -0.407333, -0.514664>, 
      <-1.508909, -0.471007, -1.225365>, <-1.514926, -0.273197, -0.970836>, <-1.312517, -0.224722, -0.653457>, <-1.055095, -0.375003, -0.530578>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.417040, -0.545529, -1.165278>, <-1.456455, -0.541634, -1.169236>, <-1.527769, -0.498899, -1.204134>, <-1.508909, -0.471007, -1.225365>, 
      <-1.412443, -0.696686, -1.359776>, <-1.451857, -0.692792, -1.363735>, <-1.521753, -0.696709, -1.458663>, <-1.502893, -0.668817, -1.479893>, 
      <-1.244919, -0.918042, -1.443493>, <-1.255461, -0.954906, -1.466493>, <-1.316886, -0.983661, -1.572493>, <-1.290163, -0.959649, -1.599108>, 
      <-1.048209, -1.032880, -1.349595>, <-1.058751, -1.069745, -1.372595>, <-1.059464, -1.133943, -1.449614>, <-1.032741, -1.109930, -1.476230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.617159, -0.946346, -0.834869>, <-0.612066, -1.113779, -1.050309>, <-0.789151, -1.147257, -1.316146>, <-1.007040, -1.020054, -1.420154>, 
      <-0.640879, -0.952343, -0.830769>, <-0.635786, -1.119776, -1.046209>, <-0.801501, -1.151105, -1.294979>, <-1.019391, -1.023902, -1.398986>, 
      <-0.706288, -0.948549, -0.835264>, <-0.701690, -1.099706, -1.029762>, <-0.845650, -1.127265, -1.242936>, <-1.042360, -1.012427, -1.336834>, 
      <-0.696225, -0.966336, -0.821202>, <-0.691627, -1.117494, -1.015700>, <-0.851499, -1.147718, -1.255697>, <-1.048209, -1.032880, -1.349595>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.025701, -0.406521, -0.630705>, <-0.807812, -0.533725, -0.526697>, <-0.622251, -0.778914, -0.619429>, <-0.617159, -0.946346, -0.834869>, 
      <-1.037508, -0.428261, -0.632559>, <-0.819618, -0.555464, -0.528551>, <-0.645971, -0.784911, -0.615328>, <-0.640879, -0.952343, -0.830769>, 
      <-1.058366, -0.486158, -0.659670>, <-0.861657, -0.600996, -0.565772>, <-0.710885, -0.797391, -0.640765>, <-0.706288, -0.948549, -0.835264>, 
      <-1.065056, -0.478986, -0.636884>, <-0.868346, -0.593823, -0.542986>, <-0.700822, -0.815179, -0.626703>, <-0.696225, -0.966336, -0.821202>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.025701, -0.406521, -0.630705>, <-1.020103, -0.590581, -0.867540>, <-1.012638, -0.835994, -1.183319>, <-1.007040, -1.020054, -1.420154>, 
      <-1.025701, -0.406521, -0.630705>, <-0.802213, -0.717784, -0.763532>, <-0.794749, -0.963197, -1.079312>, <-0.789151, -1.147257, -1.316146>, 
      <-1.025701, -0.406521, -0.630705>, <-0.802213, -0.717784, -0.763532>, <-0.617159, -0.946346, -0.834869>, <-0.612066, -1.113779, -1.050309>, 
      <-1.025701, -0.406521, -0.630705>, <-0.807812, -0.533725, -0.526697>, <-0.622251, -0.778914, -0.619429>, <-0.617159, -0.946346, -0.834869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.415584, -0.480229, -1.215991>, <-1.420676, -0.312797, -1.000550>, <-1.243591, -0.279318, -0.734713>, <-1.025701, -0.406521, -0.630705>, 
      <-1.416020, -0.499819, -1.200777>, <-1.421113, -0.332387, -0.985336>, <-1.255397, -0.301058, -0.736567>, <-1.037508, -0.428261, -0.632559>, 
      <-1.392475, -0.547956, -1.162810>, <-1.397073, -0.396799, -0.968312>, <-1.255076, -0.371320, -0.753568>, <-1.058366, -0.486158, -0.659670>, 
      <-1.417040, -0.545529, -1.165278>, <-1.421638, -0.394371, -0.970779>, <-1.261766, -0.364147, -0.730782>, <-1.065056, -0.478986, -0.636884>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.415584, -0.480229, -1.215991>, <-1.416020, -0.499819, -1.200777>, <-1.392475, -0.547956, -1.162810>, <-1.417040, -0.545529, -1.165278>, 
      <-1.410491, -0.647662, -1.431431>, <-1.410928, -0.667252, -1.416217>, <-1.387878, -0.699114, -1.357309>, <-1.412443, -0.696686, -1.359776>, 
      <-1.224930, -0.892851, -1.524162>, <-1.237280, -0.896699, -1.502994>, <-1.239070, -0.897589, -1.430732>, <-1.244919, -0.918042, -1.443493>, 
      <-1.007040, -1.020054, -1.420154>, <-1.019391, -1.023902, -1.398986>, <-1.042360, -1.012427, -1.336834>, <-1.048209, -1.032880, -1.349595>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.415584, -0.480229, -1.215991>, <-1.410491, -0.647662, -1.431431>, <-1.224930, -0.892851, -1.524162>, <-1.007040, -1.020054, -1.420154>, 
      <-1.415584, -0.480229, -1.215991>, <-1.415584, -0.480229, -1.215991>, <-1.230528, -0.708791, -1.287327>, <-1.012638, -0.835994, -1.183319>, 
      <-1.415584, -0.480229, -1.215991>, <-1.415584, -0.480229, -1.215991>, <-1.237993, -0.463378, -0.971548>, <-1.020103, -0.590581, -0.867540>, 
      <-1.415584, -0.480229, -1.215991>, <-1.420676, -0.312797, -1.000550>, <-1.243591, -0.279318, -0.734713>, <-1.025701, -0.406521, -0.630705>
    }
  }
  texture {
    UpperNeck
  }
  scale 4.3
  rotate <-94.811691, 38.03891, 18.591406>
  translate  <213.979347, 217.409532, 90.211433>
}
#declare tailSpike = union {
  cone { // CtrSpike
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <2.1, 2.1, 21.0>
  }
  object { BaseSpike1 }
  object { // BaseSpike2->BaseSpike1
    BaseSpike1
    rotate <-0.0, 0.0, -37.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // BaseSpike3->BaseSpike1
    BaseSpike1
    rotate <-0.0, 0.0, -74.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // BaseSpike4->BaseSpike1
    BaseSpike1
    rotate <-0.0, 0.0, -111.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // BaseSpike5->BaseSpike1
    BaseSpike1
    rotate <-0.0, 0.0, -148.0>
    translate  -0.0*y
  }
  object { // BaseSpike6->BaseSpike1
    BaseSpike1
    rotate <-0.0, 0.0, 175.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // BaseSpike7->BaseSpike1
    BaseSpike1
    rotate <-0.0, 0.0, 138.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // BaseSpike8->BaseSpike1
    BaseSpike1
    rotate <-0.0, 0.0, 101.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // BaseSpike9->BaseSpike1
    BaseSpike1
    rotate <-0.0, 0.0, 64.0>
    translate  0.0*x
  }
  object { // BaseSpike10->BaseSpike1
    BaseSpike1
    rotate <-0.0, 0.0, 27.0>
    translate  -0.0*x
  }
  object { UpperSpike }
  object { // UpperSpike1->UpperSpike
    UpperSpike
    rotate <0.0, 0.0, -60.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // UpperSpike2->UpperSpike
    UpperSpike
    rotate <0.0, 0.0, -120.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // UpperSpike3->UpperSpike
    UpperSpike
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // UpperSpike4->UpperSpike
    UpperSpike
    rotate <0.0, 0.0, 120.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // UpperSpike5->UpperSpike
    UpperSpike
    rotate <0.0, 0.0, 60.0>
    translate  <0.0, -0.0, 0.0>
  }
  texture {
    Shiny_White
  }
  rotate <151.780838, 23.713583, 70.228027>
  translate  <207.105689, 223.579688, 112.514926>
}
union { // TailDone
  object { Tail }
  object { tailSpike }
  scale 0.85
  rotate <50.644981, 49.553604, 35.15033>
  translate  <97.643473, 27.0, 155.0>
}


plane { // Sky
  z,0
  texture {
    fullCloud
  }
  no_shadow
  hollow
  translate  <200.0, 400.0, 300.0>
}


#declare Deck1 = union {
  box { // Plank1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <9.215853, 0.0, -21.220725>
  }
  box { // Plank2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <5.0, -11.333762, -21.220725>
  }
  box { // Plank3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <0.9, -19.333762, -21.220725>
  }
  box { // Plank4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
      translate <0.000000, 0.206528, -0.000000>
    }
    scale <2.0, 17.0, 0.3>
    translate  <-3.2, -27.333762, -21.220725>
  }
  box { // Plank5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-7.3, -35.333762, -21.220725>
  }
  box { // Plank6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-11.4, -43.333762, -21.220725>
  }
  box { // Plank7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-15.5, -51.333762, -21.220725>
  }
  box { // Plank8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <5.081812, 22.781737, -21.220725>
  }
  box { // Plank9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <1.195067, 14.568481, -21.220725>
  }
  box { // Plank10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-3.118188, 6.781737, -21.220725>
  }
  box { // Plank11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-7.218188, -1.218263, -21.220725>
  }
  box { // Plank12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-11.318188, -9.218263, -21.220725>
  }
  box { // Plank13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-15.418188, -17.218263, -21.220725>
  }
  box { // Plank14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <9.102644, -34.171174, -21.220725>
  }
  box { // Plank15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <5.17568, -45.461195, -21.220725>
  }
  box { // Plank16
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <1.07568, -53.461195, -21.220725>
  }
  box { // Plank17
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-3.02432, -61.461195, -21.220725>
  }
  box { // Plank18
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-7.12432, -69.461195, -21.220725>
  }
  box { // Plank19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-11.22432, -77.461195, -21.220725>
  }
  box { // Plank20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-15.32432, -85.461195, -21.220725>
  }
  box { // Plank21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <9.102644, -68.592648, -21.220725>
  }
  box { // Plank22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <5.24328, -79.447108, -21.220725>
  }
  box { // Plank23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <1.022102, -87.527651, -21.220725>
  }
  box { // Plank24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-3.078472, -95.608193, -21.220725>
  }
  box { // Plank25
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-15.418188, 16.826372, -21.220725>
  }
  box { // Plank26
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <-11.318188, 24.826372, -21.220725>
  }
  box { // Plank27
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 10.135033, 0.3>
    translate  <-7.115147, 26.087284, -21.220725>
  }
  box { // Plank28
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 10.135033, 0.3>
    translate  <-2.912106, 34.073063, -21.220725>
  }
  box { // Plank29
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 17.0, 0.3>
    translate  <9.215853, 34.324838, -21.220725>
  }
  translate  15.0*y
}
#declare BoatBody = union {
  object { Railing1 }
  object { Support1 }
  object { Hull1 }
  object { // Hull2->Hull1
    Hull1
    rotate <-0.0, 0.0, -0.0>
    translate  -2.1*z
  }
  object { // Hull3->Hull1
    Hull1
    rotate <-0.0, 0.0, -0.0>
    translate  -4.2*z
  }
  object { // Hull4->Hull1
    Hull1
    rotate <-0.0, 0.0, -0.0>
    translate  -6.3*z
  }
  object { // Hull5->Hull1
    Hull1
    rotate <-0.0, 0.0, -0.0>
    translate  -8.4*z
  }
  object { Deck1 }
  object { // Railing2->Railing1
    Railing1
    translate  <-0.0, -46.495044, 0.0>
  }
  box { // Hull7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BallWoodNicked
      rotate <0.0, -90.0, -90.0>
    }
    scale <0.35, 35.0, 1.0>
    translate  <10.852088, 34.851975, -12.371256>
  }
  object { // Hull8->Hull1
    Hull1
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 70.61252, -2.1>
  }
  object { // Hull9->Hull1
    Hull1
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 70.367762, -4.2>
  }
  object { // Hull10->Hull1
    Hull1
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 70.61252, -6.3>
  }
  object { // Hull11->Hull1
    Hull1
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 70.633894, -8.4>
  }
  box { // Railing3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 20.0, 1.0>
    rotate <32.0, -0.0, -0.0>
    translate  <9.215853, 40.159789, -0.313163>
  }
  box { // CabinWall1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      OakNicked
      rotate <0.0, -90.0, -90.0>
    }
    scale <0.35, 9.7, 5.0>
    rotate <-90.0, -0.0, -90.0>
    translate  <5.741244, 56.441309, -11.535107>
  }
  box { // CabinWall2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      OakNicked
      rotate <0.0, -90.0, -90.0>
    }
    scale <0.35, 9.7, 5.0>
    rotate <-90.0, -0.0, -90.0>
    translate  <-2.0, 56.441309, -11.535107>
  }
  box { // RampWall
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BallWoodNicked
      rotate <0.0, -90.0, -90.0>
    }
    scale <0.35, 20.0, 10.0>
    rotate 32.0*x
    translate  <11.184897, 42.888704, -11.129194>
  }
  box { // Railing4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MapleNicked
      rotate -90.0*z
    }
    scale <2.0, 35.0, 1.0>
    translate  <9.167307, 91.945223, 10.11433>
  }
  box { // BackWall
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BallWoodNicked
      rotate <0.0, -90.0, -90.0>
    }
    scale <0.35, 3.0, 10.0>
    translate  <11.184897, 57.874419, -0.490507>
  }
  object { // Support2->Support1
    Support1
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 20.0, 0.0>
  }
  object { // Support3->Support1
    Support1
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 40.0, 0.0>
  }
  object { // Support4->Support1
    Support1
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 60.0, 0.0>
  }
  box { // Caulking
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Shiny_White
      rotate <0.0, -90.0, -90.0>
    }
    scale <0.29, 60.0, 6.0>
    translate  <10.852088, -3.069811, -17.0>
  }
}
#declare BrassRailDone = union {
  sphere { // RoundEnd
    <0,0,0>,1
    texture {
      Bright_Bronze
    }
    scale 1.3
    translate  -1.399342*z
  }
  cylinder { // LongRail
    <0,0,1>, <0,0,0>, 1 
    texture {
      MapleNicked
    }
    scale <1.0, 1.0, 70.0>
  }
  rotate -90.0*x
  translate  <8.708943, 59.253332, 13.172756>
}
#declare Spar14 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, 3.988908, -0.194935>, <0.426328, 3.597497, -0.110946>, <0.426328, 3.079822, 0.023837>, <0.426328, 2.684205, 0.085027>, 
      <0.426328, 3.988908, -0.246432>, <0.426328, 3.597497, -0.162443>, <0.426328, 3.079822, -0.027660>, <0.426328, 2.684205, 0.033530>, 
      <0.426328, 3.988908, -0.315095>, <0.426328, 3.597497, -0.231107>, <0.426328, 3.079821, -0.096324>, <0.426328, 2.684205, -0.035134>, 
      <0.426328, 3.988908, -0.366592>, <0.426328, 3.597497, -0.282604>, <0.426328, 3.079821, -0.147821>, <0.426328, 2.684205, -0.086631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, 3.988908, -0.194935>, <0.170531, 3.988908, -0.194935>, <-0.170531, 3.988908, -0.194935>, <-0.426328, 3.988908, -0.194935>, 
      <0.426328, 3.597497, -0.110946>, <0.170531, 3.597497, -0.110946>, <-0.170531, 3.597497, -0.110946>, <-0.426328, 3.597497, -0.110946>, 
      <0.426328, 3.079822, 0.023837>, <0.170531, 3.079822, 0.023837>, <-0.170531, 3.079822, 0.023837>, <-0.426328, 3.079822, 0.023837>, 
      <0.426328, 2.684205, 0.085027>, <0.170531, 2.684205, 0.085027>, <-0.170531, 2.684205, 0.085027>, <-0.426328, 2.684205, 0.085027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, 3.988908, -0.194935>, <0.426328, 3.988908, -0.246432>, <0.426328, 3.988908, -0.315095>, <0.426328, 3.988908, -0.366592>, 
      <0.426328, 3.988908, -0.194935>, <0.170531, 3.988908, -0.246432>, <0.170531, 3.988908, -0.263598>, <0.170531, 3.988908, -0.315095>, 
      <0.426328, 3.988908, -0.194935>, <0.170531, 3.988908, -0.246432>, <0.085266, 3.988908, -0.246432>, <-0.170531, 3.988908, -0.246432>, 
      <0.426328, 3.988908, -0.194935>, <0.170531, 3.988908, -0.194935>, <-0.170531, 3.988908, -0.194935>, <-0.426328, 3.988908, -0.194935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 3.988908, -0.366592>, <-0.426328, 3.597497, -0.282604>, <-0.426328, 3.079821, -0.147821>, <-0.426328, 2.684205, -0.086631>, 
      <-0.426328, 3.988908, -0.315095>, <-0.426328, 3.597497, -0.231107>, <-0.426328, 3.079821, -0.096324>, <-0.426328, 2.684205, -0.035134>, 
      <-0.426328, 3.988908, -0.246432>, <-0.426328, 3.597497, -0.162443>, <-0.426328, 3.079822, -0.027660>, <-0.426328, 2.684205, 0.033530>, 
      <-0.426328, 3.988908, -0.194935>, <-0.426328, 3.597497, -0.110946>, <-0.426328, 3.079822, 0.023837>, <-0.426328, 2.684205, 0.085027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 3.988908, -0.366592>, <-0.426328, 3.988908, -0.315095>, <-0.426328, 3.988908, -0.246432>, <-0.426328, 3.988908, -0.194935>, 
      <-0.426328, 3.988908, -0.366592>, <-0.170531, 3.988908, -0.315095>, <-0.170531, 3.988908, -0.297929>, <-0.170531, 3.988908, -0.246432>, 
      <-0.426328, 3.988908, -0.366592>, <-0.170531, 3.988908, -0.315095>, <-0.085266, 3.988908, -0.315095>, <0.170531, 3.988908, -0.315095>, 
      <-0.426328, 3.988908, -0.366592>, <-0.170531, 3.988908, -0.366592>, <0.170531, 3.988908, -0.366592>, <0.426328, 3.988908, -0.366592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 3.988908, -0.366592>, <-0.170531, 3.988908, -0.366592>, <0.170531, 3.988908, -0.366592>, <0.426328, 3.988908, -0.366592>, 
      <-0.426328, 3.597497, -0.282604>, <-0.170531, 3.597497, -0.282604>, <0.170531, 3.597497, -0.282604>, <0.426328, 3.597497, -0.282604>, 
      <-0.426328, 3.079821, -0.147821>, <-0.170531, 3.079821, -0.147821>, <0.170531, 3.079821, -0.147821>, <0.426328, 3.079821, -0.147821>, 
      <-0.426328, 2.684205, -0.086631>, <-0.170531, 2.684205, -0.086631>, <0.170531, 2.684205, -0.086631>, <0.426328, 2.684205, -0.086631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, 1.599333, 0.174660>, <0.426328, 1.599333, 0.123163>, <0.426328, 1.599333, 0.054500>, <0.426328, 1.599333, 0.003003>, 
      <0.426328, 1.925790, 0.183282>, <0.426328, 1.925790, 0.131785>, <0.426328, 1.925790, 0.063122>, <0.426328, 1.925790, 0.011625>, 
      <0.426328, 2.361472, 0.134944>, <0.426328, 2.361472, 0.083447>, <0.426328, 2.361472, 0.014783>, <0.426328, 2.361472, -0.036714>, 
      <0.426328, 2.684205, 0.085027>, <0.426328, 2.684205, 0.033530>, <0.426328, 2.684205, -0.035134>, <0.426328, 2.684205, -0.086631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 1.599333, 0.174660>, <-0.170531, 1.599333, 0.174660>, <0.170531, 1.599333, 0.174660>, <0.426328, 1.599333, 0.174660>, 
      <-0.426328, 1.925790, 0.183282>, <-0.170531, 1.925790, 0.183282>, <0.170531, 1.925790, 0.183282>, <0.426328, 1.925790, 0.183282>, 
      <-0.426328, 2.361472, 0.134944>, <-0.170531, 2.361472, 0.134944>, <0.170531, 2.361472, 0.134944>, <0.426328, 2.361472, 0.134944>, 
      <-0.426328, 2.684205, 0.085027>, <-0.170531, 2.684205, 0.085027>, <0.170531, 2.684205, 0.085027>, <0.426328, 2.684205, 0.085027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 1.599333, 0.003003>, <-0.426328, 1.599333, 0.054500>, <-0.426328, 1.599333, 0.123163>, <-0.426328, 1.599333, 0.174660>, 
      <-0.426328, 1.925790, 0.011625>, <-0.426328, 1.925790, 0.063122>, <-0.426328, 1.925790, 0.131785>, <-0.426328, 1.925790, 0.183282>, 
      <-0.426328, 2.361472, -0.036714>, <-0.426328, 2.361472, 0.014783>, <-0.426328, 2.361472, 0.083447>, <-0.426328, 2.361472, 0.134944>, 
      <-0.426328, 2.684205, -0.086631>, <-0.426328, 2.684205, -0.035134>, <-0.426328, 2.684205, 0.033530>, <-0.426328, 2.684205, 0.085027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 1.599333, 0.003003>, <-0.426328, 1.925790, 0.011625>, <-0.426328, 2.361472, -0.036714>, <-0.426328, 2.684205, -0.086631>, 
      <-0.170531, 1.599333, 0.003003>, <-0.170531, 1.925790, 0.011625>, <-0.170531, 2.361472, -0.036714>, <-0.170531, 2.684205, -0.086631>, 
      <0.170531, 1.599333, 0.003003>, <0.170531, 1.925790, 0.011625>, <0.170531, 2.361472, -0.036714>, <0.170531, 2.684205, -0.086631>, 
      <0.426328, 1.599333, 0.003003>, <0.426328, 1.925790, 0.011625>, <0.426328, 2.361472, -0.036714>, <0.426328, 2.684205, -0.086631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, 0.551870, 0.028709>, <0.426328, 0.551870, -0.022788>, <0.426328, 0.551870, -0.091452>, <0.426328, 0.551870, -0.142949>, 
      <0.426328, 0.863594, 0.087795>, <0.426328, 0.863594, 0.036297>, <0.426328, 0.863595, -0.032366>, <0.426328, 0.863595, -0.083863>, 
      <0.426328, 1.282169, 0.166283>, <0.426328, 1.282169, 0.114786>, <0.426328, 1.282169, 0.046123>, <0.426328, 1.282169, -0.005374>, 
      <0.426328, 1.599333, 0.174660>, <0.426328, 1.599333, 0.123163>, <0.426328, 1.599333, 0.054500>, <0.426328, 1.599333, 0.003003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 0.551870, 0.028709>, <-0.170531, 0.551870, 0.028709>, <0.170531, 0.551870, 0.028709>, <0.426328, 0.551870, 0.028709>, 
      <-0.426328, 0.863594, 0.087795>, <-0.170531, 0.863594, 0.087795>, <0.170531, 0.863594, 0.087795>, <0.426328, 0.863594, 0.087795>, 
      <-0.426328, 1.282169, 0.166283>, <-0.170531, 1.282169, 0.166283>, <0.170531, 1.282169, 0.166283>, <0.426328, 1.282169, 0.166283>, 
      <-0.426328, 1.599333, 0.174660>, <-0.170531, 1.599333, 0.174660>, <0.170531, 1.599333, 0.174660>, <0.426328, 1.599333, 0.174660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 0.551870, -0.142949>, <-0.426328, 0.551870, -0.091452>, <-0.426328, 0.551870, -0.022788>, <-0.426328, 0.551870, 0.028709>, 
      <-0.426328, 0.863595, -0.083863>, <-0.426328, 0.863595, -0.032366>, <-0.426328, 0.863594, 0.036297>, <-0.426328, 0.863594, 0.087795>, 
      <-0.426328, 1.282169, -0.005374>, <-0.426328, 1.282169, 0.046123>, <-0.426328, 1.282169, 0.114786>, <-0.426328, 1.282169, 0.166283>, 
      <-0.426328, 1.599333, 0.003003>, <-0.426328, 1.599333, 0.054500>, <-0.426328, 1.599333, 0.123163>, <-0.426328, 1.599333, 0.174660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, 0.551870, -0.142949>, <-0.426328, 0.863595, -0.083863>, <-0.426328, 1.282169, -0.005374>, <-0.426328, 1.599333, 0.003003>, 
      <-0.170531, 0.551870, -0.142949>, <-0.170531, 0.863595, -0.083863>, <-0.170531, 1.282169, -0.005374>, <-0.170531, 1.599333, 0.003003>, 
      <0.170531, 0.551870, -0.142949>, <0.170531, 0.863595, -0.083863>, <0.170531, 1.282169, -0.005374>, <0.170531, 1.599333, 0.003003>, 
      <0.426328, 0.551870, -0.142949>, <0.426328, 0.863595, -0.083863>, <0.426328, 1.282169, -0.005374>, <0.426328, 1.599333, 0.003003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, -0.350580, -0.194935>, <0.426328, -0.350580, -0.246432>, <0.426328, -0.350580, -0.315095>, <0.426328, -0.350580, -0.366592>, 
      <0.426328, -0.079845, -0.127842>, <0.426328, -0.079845, -0.179339>, <0.426328, -0.079845, -0.248002>, <0.426328, -0.079845, -0.299499>, 
      <0.426328, 0.277825, -0.023235>, <0.426328, 0.277825, -0.074732>, <0.426328, 0.277825, -0.143395>, <0.426328, 0.277825, -0.194893>, 
      <0.426328, 0.551870, 0.028709>, <0.426328, 0.551870, -0.022788>, <0.426328, 0.551870, -0.091452>, <0.426328, 0.551870, -0.142949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, -0.350580, -0.194935>, <0.170531, -0.350580, -0.194935>, <-0.170531, -0.350580, -0.194935>, <-0.426328, -0.350580, -0.194935>, 
      <0.426328, -0.350580, -0.194935>, <0.170531, -0.350580, -0.246432>, <0.085266, -0.350580, -0.246432>, <-0.170531, -0.350580, -0.246432>, 
      <0.426328, -0.350580, -0.194935>, <0.170531, -0.350580, -0.246432>, <0.170531, -0.350580, -0.263598>, <0.170531, -0.350580, -0.315095>, 
      <0.426328, -0.350580, -0.194935>, <0.426328, -0.350580, -0.246432>, <0.426328, -0.350580, -0.315095>, <0.426328, -0.350580, -0.366592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426328, -0.350580, -0.194935>, <0.426328, -0.079845, -0.127842>, <0.426328, 0.277825, -0.023235>, <0.426328, 0.551870, 0.028709>, 
      <0.170531, -0.350580, -0.194935>, <0.170531, -0.079845, -0.127842>, <0.170531, 0.277825, -0.023235>, <0.170531, 0.551870, 0.028709>, 
      <-0.170531, -0.350580, -0.194935>, <-0.170531, -0.079845, -0.127842>, <-0.170531, 0.277825, -0.023235>, <-0.170531, 0.551870, 0.028709>, 
      <-0.426328, -0.350580, -0.194935>, <-0.426328, -0.079845, -0.127842>, <-0.426328, 0.277825, -0.023235>, <-0.426328, 0.551870, 0.028709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, -0.350580, -0.366592>, <-0.426328, -0.350580, -0.315095>, <-0.426328, -0.350580, -0.246432>, <-0.426328, -0.350580, -0.194935>, 
      <-0.426328, -0.079845, -0.299499>, <-0.426328, -0.079845, -0.248002>, <-0.426328, -0.079845, -0.179339>, <-0.426328, -0.079845, -0.127842>, 
      <-0.426328, 0.277825, -0.194893>, <-0.426328, 0.277825, -0.143395>, <-0.426328, 0.277825, -0.074732>, <-0.426328, 0.277825, -0.023235>, 
      <-0.426328, 0.551870, -0.142949>, <-0.426328, 0.551870, -0.091452>, <-0.426328, 0.551870, -0.022788>, <-0.426328, 0.551870, 0.028709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, -0.350580, -0.366592>, <-0.426328, -0.079845, -0.299499>, <-0.426328, 0.277825, -0.194893>, <-0.426328, 0.551870, -0.142949>, 
      <-0.170531, -0.350580, -0.366592>, <-0.170531, -0.079845, -0.299499>, <-0.170531, 0.277825, -0.194893>, <-0.170531, 0.551870, -0.142949>, 
      <0.170531, -0.350580, -0.366592>, <0.170531, -0.079845, -0.299499>, <0.170531, 0.277825, -0.194893>, <0.170531, 0.551870, -0.142949>, 
      <0.426328, -0.350580, -0.366592>, <0.426328, -0.079845, -0.299499>, <0.426328, 0.277825, -0.194893>, <0.426328, 0.551870, -0.142949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.426328, -0.350580, -0.366592>, <-0.170531, -0.350580, -0.366592>, <0.170531, -0.350580, -0.366592>, <0.426328, -0.350580, -0.366592>, 
      <-0.426328, -0.350580, -0.366592>, <-0.170531, -0.350580, -0.315095>, <-0.085266, -0.350580, -0.315095>, <0.170531, -0.350580, -0.315095>, 
      <-0.426328, -0.350580, -0.366592>, <-0.170531, -0.350580, -0.315095>, <-0.170531, -0.350580, -0.297929>, <-0.170531, -0.350580, -0.246432>, 
      <-0.426328, -0.350580, -0.366592>, <-0.426328, -0.350580, -0.315095>, <-0.426328, -0.350580, -0.246432>, <-0.426328, -0.350580, -0.194935>
    }
  }
  texture {
    BallWoodNicked
  }
  scale <1.0, 1.3, 1.5>
  rotate -90.0*x
  translate  <0.01863, 1.6, 0.0>
}
#declare Signatures = union {
  object { Signature }
  object { // Signature1->Signature
    Signature
    rotate <-153.300812, -28.536703, 93.037239>
    translate  <-0.853122, 4.596041, 3.312954>
  }
  object { // Signature2->Signature
    Signature
    rotate <-13.599463, -73.725449, 149.851456>
    translate  <-3.316742, 2.065723, 1.833652>
  }
  object { // Signature3->Signature
    Signature
    rotate <78.069931, 18.715513, 33.341686>
    translate  <3.700635, 5.31709, -0.971208>
  }
  object { // Signature4->Signature
    Signature
    rotate <21.153252, 17.563755, 45.967171>
    translate  <-1.266131, 4.507483, -3.130089>
  }
  object { // Signature5->Signature
    Signature
    rotate <56.128849, 27.161917, -104.875542>
    translate  <0.068393, -7.054261, -7.201355>
  }
  scale 0.416667
  rotate <-2.123639, 14.852327, -8.23152>
  translate  <0.417468, -0.281843, 1.515003>
}
#declare Barrel_of_Signatures = union {
  cone { // BandTop2
    <0,0,0>, 0.94, <0,0,1>, 1.0
    open
    texture {
      Brushed_AluminumRusty
    }
    hollow
    scale <1.6, 1.6, 0.4>
    translate  -4.722594*z
  }
  cone { // BandTop3
    <0,0,0>, 0.94, <0,0,1>, 1.0
    open
    texture {
      Brushed_AluminumRusty
    }
    no_shadow
    hollow
    scale <1.6, 1.6, 0.4>
    rotate 180.0*x
    translate  0.15*z
  }
  object { Spar14 }
  object { // Spar15->Spar1
    Spar1
    rotate <-0.0, 0.0, -30.0>
  }
  object { // Spar16->Spar1
    Spar1
    rotate <-0.0, 0.0, -60.0>
    translate  0.0*x
  }
  object { // Spar17->Spar1
    Spar1
    rotate <-0.0, 0.0, -90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Spar18->Spar1
    Spar1
    rotate <-0.0, 0.0, -120.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Spar19->Spar1
    Spar1
    rotate <-0.0, 0.0, -150.0>
    translate  -0.0*y
  }
  object { // Spar20->Spar1
    Spar1
    rotate <-0.0, 0.0, 180.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Spar21->Spar1
    Spar1
    rotate <-0.0, 0.0, 150.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Spar22->Spar1
    Spar1
    rotate <-0.0, 0.0, 120.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Spar23->Spar1
    Spar1
    rotate <-0.0, 0.0, 90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Spar24->Spar1
    Spar1
    rotate <-0.0, 0.0, 60.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Spar25->Spar1
    Spar1
    rotate <-0.0, 0.0, 30.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Spar26->Spar1
    Spar1
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 0.0, 0.0>
  }
  cylinder { // BarrelTop1
    <0,0,1>, <0,0,0>, 1 
    texture {
      OakNicked
    }
    scale <1.3, 1.3, 0.1>
    translate  <0.0, 0.0, -4.0>
  }
  object { Signatures }
  scale 1.4
  rotate <24.195036, -71.936478, 50.243473>
  translate  <-8.576385, -71.0, -10.0>
}
union { // BoatDone
  object { BoatBody }
  object { BarrelDone }
  object { Stairs1 }
  superellipsoid { // Rail
    <1.0, 0.1>
    texture {
      OakNicked
      scale 0.1
      translate <0.000000, -8.107517, 0.086960>
    }
    scale <0.5, 0.5, 16.0>
    rotate <-55.150665, 0.0, -0.0>
    translate  <-2.573402, 46.150312, -3.428215>
  }
  object { BrassRailDone }
  object { BackBannister1 }
  object { // BackBannister2->BackBannister1
    BackBannister1
    rotate 0.0*x
    translate  15.0*y
  }
  object { // BackBannister3->BackBannister1
    BackBannister1
    rotate 0.0*x
    translate  30.0*y
  }
  object { // BackBannister4->BackBannister1
    BackBannister1
    rotate 0.0*x
    translate  45.0*y
  }
  object { // BackBannister5->BackBannister1
    BackBannister1
    rotate 0.0*x
    translate  60.0*y
  }
  object { // BarrelDone1->BarrelDone
    BarrelDone
    rotate <32.134869, -63.77457, 1.917673>
    translate  <-43.639834, -49.580048, 3.88001>
  }
  object { Barrel_of_Signatures }
  object { // Stairs2->Stairs1
    Stairs1
    rotate 0.0*y
    translate  <0.0, 4.5, 3.2>
  }
  object { // Stairs3->Stairs1
    Stairs1
    rotate 0.0*y
    translate  <0.0, 9.0, 6.4>
  }
  object { // Stairs4->Stairs1
    Stairs1
    rotate 0.0*y
    translate  <0.0, 13.5, 9.6>
  }
  object { // Stairs5->Stairs1
    Stairs1
    rotate 0.0*y
    translate  <0.0, 18.0, 12.8>
  }
  object { // Stairs6->Stairs1
    Stairs1
    rotate 0.0*y
    translate  <0.0, 22.5, 16.0>
  }
  object { // BarrelDone3->BarrelDone
    BarrelDone
    rotate <12.916288, -6.966106, 56.53418>
    translate  <-39.916156, -27.755929, 10.695502>
  }
  scale 1.2
  rotate <-0.0, -15.0, 7.95469>
  translate  <119.343004, 97.440128, 87.0>
}




#declare LeftHorn = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.515322, 1.355055, 1.500000>, <1.515322, 1.355055, 1.457586>, <1.480026, 1.355055, 1.422289>, <1.437611, 1.355055, 1.422289>, 
      <1.548337, 1.411030, 1.500000>, <1.548337, 1.411030, 1.457586>, <1.481195, 1.417848, 1.389596>, <1.438781, 1.417848, 1.389596>, 
      <1.603563, 1.480421, 1.500000>, <1.603563, 1.480421, 1.398495>, <1.532280, 1.483608, 1.329067>, <1.431541, 1.496061, 1.329067>, 
      <1.625372, 1.541639, 1.500000>, <1.625372, 1.541639, 1.398495>, <1.542248, 1.551914, 1.313313>, <1.441510, 1.564366, 1.313313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.437611, 1.355055, 1.577711>, <1.480026, 1.355055, 1.577711>, <1.515322, 1.355055, 1.542415>, <1.515322, 1.355055, 1.500000>, 
      <1.438781, 1.417848, 1.610404>, <1.481195, 1.417848, 1.610404>, <1.548337, 1.411030, 1.542415>, <1.548337, 1.411030, 1.500000>, 
      <1.431541, 1.496061, 1.670933>, <1.532280, 1.483608, 1.670933>, <1.603563, 1.480421, 1.601505>, <1.603563, 1.480421, 1.500000>, 
      <1.441510, 1.564366, 1.686687>, <1.542248, 1.551914, 1.686687>, <1.625372, 1.541639, 1.601505>, <1.625372, 1.541639, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.359900, 1.355055, 1.500000>, <1.359900, 1.355055, 1.542415>, <1.395196, 1.355055, 1.577711>, <1.437611, 1.355055, 1.577711>, 
      <1.329224, 1.424666, 1.500000>, <1.329224, 1.424666, 1.542415>, <1.396366, 1.417848, 1.610404>, <1.438781, 1.417848, 1.610404>, 
      <1.258172, 1.511024, 1.500000>, <1.258172, 1.511024, 1.601505>, <1.330803, 1.508513, 1.670933>, <1.431541, 1.496061, 1.670933>, 
      <1.257648, 1.587093, 1.500000>, <1.257648, 1.587093, 1.601505>, <1.340771, 1.576818, 1.686687>, <1.441510, 1.564366, 1.686687>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.359900, 1.355055, 1.500000>, <1.329224, 1.424666, 1.500000>, <1.258172, 1.511024, 1.500000>, <1.257648, 1.587093, 1.500000>, 
      <1.359900, 1.355055, 1.457586>, <1.329224, 1.424666, 1.457586>, <1.258172, 1.511024, 1.398495>, <1.257648, 1.587093, 1.398495>, 
      <1.395196, 1.355055, 1.422289>, <1.396366, 1.417848, 1.389596>, <1.330803, 1.508513, 1.329067>, <1.340771, 1.576818, 1.313313>, 
      <1.437611, 1.355055, 1.422289>, <1.438781, 1.417848, 1.389596>, <1.431541, 1.496061, 1.329067>, <1.441510, 1.564366, 1.313313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.683568, 1.827323, 1.500000>, <1.653998, 1.745008, 1.500000>, <1.654725, 1.624032, 1.500000>, <1.625372, 1.541639, 1.500000>, 
      <1.683568, 1.827323, 1.392417>, <1.653998, 1.745008, 1.392417>, <1.654725, 1.624032, 1.398495>, <1.625372, 1.541639, 1.398495>, 
      <1.614108, 1.864920, 1.292880>, <1.573074, 1.764793, 1.289369>, <1.557491, 1.656359, 1.289223>, <1.542248, 1.551914, 1.313313>, 
      <1.519496, 1.916131, 1.292880>, <1.478463, 1.816004, 1.289369>, <1.456753, 1.668811, 1.289223>, <1.441510, 1.564366, 1.313313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.519496, 1.916131, 1.707120>, <1.478463, 1.816004, 1.710631>, <1.456753, 1.668811, 1.710777>, <1.441510, 1.564366, 1.686687>, 
      <1.614108, 1.864920, 1.707120>, <1.573074, 1.764793, 1.710631>, <1.557491, 1.656359, 1.710777>, <1.542248, 1.551914, 1.686687>, 
      <1.683568, 1.827323, 1.607583>, <1.653998, 1.745008, 1.607583>, <1.654725, 1.624032, 1.601505>, <1.625372, 1.541639, 1.601505>, 
      <1.683568, 1.827323, 1.500000>, <1.653998, 1.745008, 1.500000>, <1.654725, 1.624032, 1.500000>, <1.625372, 1.541639, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.355424, 2.004940, 1.500000>, <1.302207, 1.887714, 1.500000>, <1.256761, 1.715830, 1.500000>, <1.257648, 1.587093, 1.500000>, 
      <1.355424, 2.004940, 1.607583>, <1.302207, 1.887714, 1.607583>, <1.256761, 1.715830, 1.601505>, <1.257648, 1.587093, 1.601505>, 
      <1.424884, 1.967342, 1.707120>, <1.383850, 1.867216, 1.710631>, <1.356014, 1.681263, 1.710777>, <1.340771, 1.576818, 1.686687>, 
      <1.519496, 1.916131, 1.707120>, <1.478463, 1.816004, 1.710631>, <1.456753, 1.668811, 1.710777>, <1.441510, 1.564366, 1.686687>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.355424, 2.004940, 1.500000>, <1.355424, 2.004940, 1.392417>, <1.424884, 1.967342, 1.292880>, <1.519496, 1.916131, 1.292880>, 
      <1.302207, 1.887714, 1.500000>, <1.302207, 1.887714, 1.392417>, <1.383850, 1.867216, 1.289369>, <1.478463, 1.816004, 1.289369>, 
      <1.256761, 1.715830, 1.500000>, <1.256761, 1.715830, 1.398495>, <1.356014, 1.681263, 1.289223>, <1.456753, 1.668811, 1.289223>, 
      <1.257648, 1.587093, 1.500000>, <1.257648, 1.587093, 1.398495>, <1.340771, 1.576818, 1.313313>, <1.441510, 1.564366, 1.313313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.826094, 2.100394, 1.500000>, <1.773203, 2.024619, 1.500000>, <1.714809, 1.914290, 1.500000>, <1.683568, 1.827323, 1.500000>, 
      <1.826094, 2.100394, 1.413043>, <1.773203, 2.024619, 1.413043>, <1.714809, 1.914290, 1.392417>, <1.683568, 1.827323, 1.392417>, 
      <1.766274, 2.127693, 1.334334>, <1.709553, 2.057412, 1.327368>, <1.648440, 1.948693, 1.295818>, <1.614108, 1.864920, 1.292880>, 
      <1.687166, 2.163795, 1.334334>, <1.630445, 2.093514, 1.327368>, <1.553827, 1.999904, 1.295818>, <1.519496, 1.916131, 1.292880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.687166, 2.163795, 1.665666>, <1.630445, 2.093514, 1.672632>, <1.553827, 1.999904, 1.704182>, <1.519496, 1.916131, 1.707120>, 
      <1.766274, 2.127693, 1.665666>, <1.709553, 2.057412, 1.672632>, <1.648440, 1.948693, 1.704182>, <1.614108, 1.864920, 1.707120>, 
      <1.826094, 2.100394, 1.586957>, <1.773203, 2.024619, 1.586957>, <1.714809, 1.914290, 1.607583>, <1.683568, 1.827323, 1.607583>, 
      <1.826094, 2.100394, 1.500000>, <1.773203, 2.024619, 1.500000>, <1.714809, 1.914290, 1.500000>, <1.683568, 1.827323, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.548237, 2.227197, 1.500000>, <1.489264, 2.161517, 1.500000>, <1.391913, 2.085316, 1.500000>, <1.355424, 2.004940, 1.500000>, 
      <1.548237, 2.227197, 1.586957>, <1.489264, 2.161517, 1.586957>, <1.391913, 2.085316, 1.607583>, <1.355424, 2.004940, 1.607583>, 
      <1.608057, 2.199897, 1.665666>, <1.551336, 2.129616, 1.672632>, <1.459215, 2.051116, 1.704182>, <1.424884, 1.967342, 1.707120>, 
      <1.687166, 2.163795, 1.665666>, <1.630445, 2.093514, 1.672632>, <1.553827, 1.999904, 1.704182>, <1.519496, 1.916131, 1.707120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.548237, 2.227197, 1.500000>, <1.548237, 2.227197, 1.413043>, <1.608057, 2.199897, 1.334334>, <1.687166, 2.163795, 1.334334>, 
      <1.489264, 2.161517, 1.500000>, <1.489264, 2.161517, 1.413043>, <1.551336, 2.129616, 1.327368>, <1.630445, 2.093514, 1.327368>, 
      <1.391913, 2.085316, 1.500000>, <1.391913, 2.085316, 1.392417>, <1.459215, 2.051116, 1.295818>, <1.553827, 1.999904, 1.295818>, 
      <1.355424, 2.004940, 1.500000>, <1.355424, 2.004940, 1.392417>, <1.424884, 1.967342, 1.292880>, <1.519496, 1.916131, 1.292880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.993235, 2.270966, 1.500000>, <1.949077, 2.214550, 1.500000>, <1.867100, 2.159142, 1.500000>, <1.826094, 2.100394, 1.500000>, 
      <1.993235, 2.270966, 1.413691>, <1.949077, 2.214550, 1.413691>, <1.867100, 2.159142, 1.413043>, <1.826094, 2.100394, 1.413043>, 
      <1.941241, 2.315351, 1.334334>, <1.895432, 2.259577, 1.331567>, <1.811502, 2.183733, 1.339888>, <1.766274, 2.127693, 1.334334>, 
      <1.857058, 2.334389, 1.334334>, <1.811249, 2.278615, 1.331567>, <1.732394, 2.219835, 1.339888>, <1.687166, 2.163795, 1.334334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.857058, 2.334389, 1.665666>, <1.811249, 2.278615, 1.668433>, <1.732394, 2.219835, 1.660112>, <1.687166, 2.163795, 1.665666>, 
      <1.941241, 2.315351, 1.665666>, <1.895432, 2.259577, 1.668433>, <1.811502, 2.183733, 1.660112>, <1.766274, 2.127693, 1.665666>, 
      <1.993235, 2.270966, 1.586309>, <1.949077, 2.214550, 1.586309>, <1.867100, 2.159142, 1.586957>, <1.826094, 2.100394, 1.586957>, 
      <1.993235, 2.270966, 1.500000>, <1.949077, 2.214550, 1.500000>, <1.867100, 2.159142, 1.500000>, <1.826094, 2.100394, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.661621, 2.345961, 1.500000>, <1.631588, 2.306916, 1.500000>, <1.581147, 2.263850, 1.500000>, <1.548237, 2.227197, 1.500000>, 
      <1.661621, 2.345961, 1.598980>, <1.631588, 2.306916, 1.598980>, <1.581147, 2.263850, 1.586957>, <1.548237, 2.227197, 1.586957>, 
      <1.760516, 2.356222, 1.665666>, <1.714707, 2.300448, 1.668433>, <1.653285, 2.255937, 1.660112>, <1.608057, 2.199897, 1.665666>, 
      <1.857058, 2.334389, 1.665666>, <1.811249, 2.278615, 1.668433>, <1.732394, 2.219835, 1.660112>, <1.687166, 2.163795, 1.665666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.661621, 2.345961, 1.500000>, <1.661621, 2.345961, 1.401020>, <1.760516, 2.356222, 1.334334>, <1.857058, 2.334389, 1.334334>, 
      <1.631588, 2.306916, 1.500000>, <1.631588, 2.306916, 1.401020>, <1.714707, 2.300448, 1.331567>, <1.811249, 2.278615, 1.331567>, 
      <1.581147, 2.263850, 1.500000>, <1.581147, 2.263850, 1.413043>, <1.653285, 2.255937, 1.339888>, <1.732394, 2.219835, 1.339888>, 
      <1.548237, 2.227197, 1.500000>, <1.548237, 2.227197, 1.413043>, <1.608057, 2.199897, 1.334334>, <1.687166, 2.163795, 1.334334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.027515, 2.357728, 1.500000>, <2.032401, 2.330171, 1.500000>, <2.010485, 2.293005, 1.500000>, <1.993235, 2.270966, 1.500000>, 
      <2.027515, 2.357728, 1.414468>, <2.032401, 2.330171, 1.414468>, <2.010485, 2.293005, 1.413691>, <1.993235, 2.270966, 1.413691>, 
      <1.948355, 2.350580, 1.345477>, <1.943982, 2.334379, 1.342134>, <1.952093, 2.328564, 1.334990>, <1.941241, 2.315351, 1.334334>, 
      <1.871635, 2.388392, 1.345477>, <1.867262, 2.372191, 1.342134>, <1.867910, 2.347602, 1.334990>, <1.857058, 2.334389, 1.334334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.871635, 2.388392, 1.654523>, <1.867262, 2.372191, 1.657866>, <1.867910, 2.347602, 1.665010>, <1.857058, 2.334389, 1.665666>, 
      <1.948355, 2.350580, 1.654523>, <1.943982, 2.334379, 1.657866>, <1.952093, 2.328564, 1.665010>, <1.941241, 2.315351, 1.665666>, 
      <2.027515, 2.357728, 1.585532>, <2.032401, 2.330171, 1.585532>, <2.010485, 2.293005, 1.586309>, <1.993235, 2.270966, 1.586309>, 
      <2.027515, 2.357728, 1.500000>, <2.032401, 2.330171, 1.500000>, <2.010485, 2.293005, 1.500000>, <1.993235, 2.270966, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.871635, 2.388392, 1.654523>, <1.871635, 2.388392, 1.561809>, <1.871635, 2.388392, 1.438191>, <1.871635, 2.388392, 1.345477>, 
      <1.871635, 2.388392, 1.654523>, <1.948355, 2.350580, 1.561809>, <1.948355, 2.350580, 1.438191>, <1.948355, 2.350580, 1.345477>, 
      <1.871635, 2.388392, 1.654523>, <1.948355, 2.350580, 1.561809>, <2.027515, 2.357728, 1.500000>, <2.027515, 2.357728, 1.414468>, 
      <1.871635, 2.388392, 1.654523>, <1.948355, 2.350580, 1.654523>, <2.027515, 2.357728, 1.585532>, <2.027515, 2.357728, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.752790, 2.493129, 1.500000>, <1.735515, 2.444150, 1.500000>, <1.693286, 2.387127, 1.500000>, <1.661621, 2.345961, 1.500000>, 
      <1.752790, 2.493129, 1.585406>, <1.735515, 2.444150, 1.585406>, <1.693286, 2.387127, 1.598980>, <1.661621, 2.345961, 1.598980>, 
      <1.795028, 2.426149, 1.654523>, <1.790655, 2.409948, 1.657866>, <1.771368, 2.369435, 1.665010>, <1.760516, 2.356222, 1.665666>, 
      <1.871635, 2.388392, 1.654523>, <1.867262, 2.372191, 1.657866>, <1.867910, 2.347602, 1.665010>, <1.857058, 2.334389, 1.665666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.752790, 2.493129, 1.500000>, <1.752790, 2.493129, 1.414594>, <1.795028, 2.426149, 1.345477>, <1.871635, 2.388392, 1.345477>, 
      <1.735515, 2.444150, 1.500000>, <1.735515, 2.444150, 1.414594>, <1.790655, 2.409948, 1.342134>, <1.867262, 2.372191, 1.342134>, 
      <1.693286, 2.387127, 1.500000>, <1.693286, 2.387127, 1.401020>, <1.771368, 2.369435, 1.334990>, <1.867910, 2.347602, 1.334990>, 
      <1.661621, 2.345961, 1.500000>, <1.661621, 2.345961, 1.401020>, <1.760516, 2.356222, 1.334334>, <1.857058, 2.334389, 1.334334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.752790, 2.493129, 1.500000>, <1.752790, 2.493129, 1.414594>, <1.795028, 2.426149, 1.345477>, <1.871635, 2.388392, 1.345477>, 
      <1.752790, 2.493129, 1.500000>, <1.752790, 2.493129, 1.500000>, <1.795028, 2.426149, 1.438191>, <1.871635, 2.388392, 1.438191>, 
      <1.752790, 2.493129, 1.500000>, <1.752790, 2.493129, 1.500000>, <1.795028, 2.426149, 1.561809>, <1.871635, 2.388392, 1.561809>, 
      <1.752790, 2.493129, 1.500000>, <1.752790, 2.493129, 1.585406>, <1.795028, 2.426149, 1.654523>, <1.871635, 2.388392, 1.654523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.873447, 2.946547, 1.500000>, <1.919667, 2.769901, 1.500000>, <1.995636, 2.537516, 1.500000>, <2.027515, 2.357728, 1.500000>, 
      <1.873447, 2.946547, 1.500000>, <1.919667, 2.769901, 1.500000>, <1.995636, 2.537516, 1.414468>, <2.027515, 2.357728, 1.414468>, 
      <1.873447, 2.946547, 1.500000>, <1.872903, 2.779100, 1.453643>, <1.948899, 2.518026, 1.391834>, <1.948355, 2.350580, 1.345477>, 
      <1.873447, 2.946547, 1.500000>, <1.872903, 2.779100, 1.453643>, <1.872179, 2.555839, 1.391834>, <1.871635, 2.388392, 1.345477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.873447, 2.946547, 1.500000>, <1.873447, 2.946547, 1.500000>, <1.873447, 2.946547, 1.500000>, <1.873447, 2.946547, 1.500000>, 
      <1.919667, 2.769901, 1.500000>, <1.919667, 2.769901, 1.500000>, <1.872903, 2.779100, 1.546357>, <1.872903, 2.779100, 1.546357>, 
      <1.995636, 2.537516, 1.500000>, <1.995636, 2.537516, 1.585532>, <1.948899, 2.518026, 1.608166>, <1.872179, 2.555839, 1.608166>, 
      <2.027515, 2.357728, 1.500000>, <2.027515, 2.357728, 1.585532>, <1.948355, 2.350580, 1.654523>, <1.871635, 2.388392, 1.654523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.873447, 2.946547, 1.500000>, <1.837250, 2.810522, 1.500000>, <1.799609, 2.625874, 1.500000>, <1.752790, 2.493129, 1.500000>, 
      <1.873447, 2.946547, 1.500000>, <1.837250, 2.810522, 1.500000>, <1.799609, 2.625874, 1.585406>, <1.752790, 2.493129, 1.585406>, 
      <1.873447, 2.946547, 1.500000>, <1.872903, 2.779100, 1.546357>, <1.795572, 2.593595, 1.608166>, <1.795028, 2.426149, 1.654523>, 
      <1.873447, 2.946547, 1.500000>, <1.872903, 2.779100, 1.546357>, <1.872179, 2.555839, 1.608166>, <1.871635, 2.388392, 1.654523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.873447, 2.946547, 1.500000>, <1.873447, 2.946547, 1.500000>, <1.873447, 2.946547, 1.500000>, <1.873447, 2.946547, 1.500000>, 
      <1.837250, 2.810522, 1.500000>, <1.837250, 2.810522, 1.500000>, <1.872903, 2.779100, 1.453643>, <1.872903, 2.779100, 1.453643>, 
      <1.799609, 2.625874, 1.500000>, <1.799609, 2.625874, 1.414594>, <1.795572, 2.593595, 1.391834>, <1.872179, 2.555839, 1.391834>, 
      <1.752790, 2.493129, 1.500000>, <1.752790, 2.493129, 1.414594>, <1.795028, 2.426149, 1.345477>, <1.871635, 2.388392, 1.345477>
    }
  }
  texture {
    Shiny_White
  }
  translate  0.05*z
}
#declare LeftHornroot = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.700436, 1.438456, 1.513633>, <1.798963, 1.534493, 1.414910>, <1.529057, 1.626869, 1.341967>, <1.455609, 1.707617, 1.268396>, 
      <1.682598, 1.400783, 1.526970>, <1.781125, 1.496820, 1.428247>, <1.526634, 1.522918, 1.340533>, <1.453186, 1.603666, 1.266962>, 
      <1.652979, 1.352696, 1.571722>, <1.729926, 1.364621, 1.458705>, <1.511955, 1.450433, 1.352842>, <1.453922, 1.464903, 1.264501>, 
      <1.640977, 1.312879, 1.558088>, <1.717924, 1.324804, 1.445070>, <1.505566, 1.346644, 1.351958>, <1.447533, 1.361115, 1.263617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.195088, 1.453680, 1.529435>, <1.304013, 1.333929, 1.638543>, <1.586855, 1.327745, 1.627440>, <1.700436, 1.438456, 1.513633>, 
      <1.210570, 1.416573, 1.538186>, <1.319495, 1.296822, 1.647293>, <1.569017, 1.290072, 1.640777>, <1.682598, 1.400783, 1.526970>, 
      <1.238999, 1.368108, 1.572054>, <1.321852, 1.347449, 1.698179>, <1.567584, 1.339462, 1.697148>, <1.652979, 1.352696, 1.571722>, 
      <1.246695, 1.329990, 1.558603>, <1.329549, 1.309330, 1.684727>, <1.555583, 1.299645, 1.683513>, <1.640977, 1.312879, 1.558088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.195088, 1.453680, 1.529435>, <1.210570, 1.416573, 1.538186>, <1.238999, 1.368108, 1.572054>, <1.246695, 1.329990, 1.558603>, 
      <1.098665, 1.559687, 1.432850>, <1.114147, 1.522580, 1.441601>, <1.163794, 1.386861, 1.457574>, <1.171490, 1.348743, 1.444122>, 
      <1.377453, 1.631436, 1.346708>, <1.375030, 1.527485, 1.345274>, <1.393671, 1.455566, 1.352996>, <1.387282, 1.351778, 1.352113>, 
      <1.455609, 1.707617, 1.268396>, <1.453186, 1.603666, 1.266962>, <1.453922, 1.464903, 1.264501>, <1.447533, 1.361115, 1.263617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.598143, 1.099095, 1.397427>, <1.613226, 1.159635, 1.449474>, <1.618695, 1.238958, 1.532776>, <1.640977, 1.312879, 1.558088>, 
      <1.662974, 1.178775, 1.341898>, <1.678057, 1.239315, 1.393946>, <1.695642, 1.250883, 1.419758>, <1.717924, 1.324804, 1.445070>, 
      <1.548042, 1.310545, 1.261399>, <1.552888, 1.324662, 1.260970>, <1.504649, 1.331742, 1.351831>, <1.505566, 1.346644, 1.351958>, 
      <1.431382, 1.314060, 1.265046>, <1.436227, 1.328177, 1.264617>, <1.446616, 1.346213, 1.263490>, <1.447533, 1.361115, 1.263617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.264652, 1.109142, 1.407853>, <1.258989, 1.166305, 1.464104>, <1.261733, 1.255511, 1.532321>, <1.246695, 1.329990, 1.558603>, 
      <1.335657, 1.017612, 1.464220>, <1.329994, 1.074775, 1.520471>, <1.344586, 1.234851, 1.658445>, <1.329549, 1.309330, 1.684727>, 
      <1.526618, 1.011188, 1.458690>, <1.541701, 1.071728, 1.510737>, <1.533301, 1.225724, 1.658201>, <1.555583, 1.299645, 1.683513>, 
      <1.598143, 1.099095, 1.397427>, <1.613226, 1.159635, 1.449474>, <1.618695, 1.238958, 1.532776>, <1.640977, 1.312879, 1.558088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.264652, 1.109142, 1.407853>, <1.200772, 1.191487, 1.357143>, <1.315591, 1.317548, 1.268666>, <1.431382, 1.314060, 1.265046>, 
      <1.258989, 1.166305, 1.464104>, <1.195110, 1.248650, 1.413395>, <1.320437, 1.331665, 1.268237>, <1.436227, 1.328177, 1.264617>, 
      <1.261733, 1.255511, 1.532321>, <1.186528, 1.274264, 1.417840>, <1.386364, 1.336875, 1.351986>, <1.446616, 1.346213, 1.263490>, 
      <1.246695, 1.329990, 1.558603>, <1.171490, 1.348743, 1.444122>, <1.387282, 1.351778, 1.352113>, <1.447533, 1.361115, 1.263617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.562699, 0.998689, 1.287974>, <1.573332, 1.028811, 1.320810>, <1.589639, 1.064961, 1.368082>, <1.598143, 1.099095, 1.397427>, 
      <1.623476, 0.983202, 1.264158>, <1.634109, 1.013324, 1.296994>, <1.654470, 1.144641, 1.312553>, <1.662974, 1.178775, 1.341898>, 
      <1.459207, 0.987780, 1.224911>, <1.464166, 1.087067, 1.245060>, <1.543084, 1.211259, 1.241250>, <1.548042, 1.310545, 1.261399>, 
      <1.414853, 0.983105, 1.197884>, <1.419812, 1.082392, 1.218033>, <1.426423, 1.214773, 1.244897>, <1.431382, 1.314060, 1.265046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.277594, 1.018081, 1.251670>, <1.273711, 1.045399, 1.298525>, <1.268482, 1.070481, 1.369809>, <1.264652, 1.109142, 1.407853>, 
      <1.372148, 1.028048, 1.309287>, <1.368266, 1.055366, 1.356142>, <1.339487, 0.978951, 1.426175>, <1.335657, 1.017612, 1.464220>, 
      <1.461985, 1.024353, 1.327440>, <1.472618, 1.054475, 1.360276>, <1.518114, 0.977054, 1.429344>, <1.526618, 1.011188, 1.458690>, 
      <1.562699, 0.998689, 1.287974>, <1.573332, 1.028811, 1.320810>, <1.589639, 1.064961, 1.368082>, <1.598143, 1.099095, 1.397427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.277594, 1.018081, 1.251670>, <1.227861, 1.012839, 1.221365>, <1.373675, 0.993598, 1.214020>, <1.414853, 0.983105, 1.197884>, 
      <1.273711, 1.045399, 1.298525>, <1.223978, 1.040157, 1.268220>, <1.378634, 1.092884, 1.234168>, <1.419812, 1.082392, 1.218033>, 
      <1.268482, 1.070481, 1.369809>, <1.204602, 1.152825, 1.319099>, <1.310633, 1.218262, 1.248517>, <1.426423, 1.214773, 1.244897>, 
      <1.264652, 1.109142, 1.407853>, <1.200772, 1.191487, 1.357143>, <1.315591, 1.317548, 1.268666>, <1.431382, 1.314060, 1.265046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.683957, 1.116165, 1.431236>, <1.683957, 1.143517, 1.442152>, <1.662780, 1.174486, 1.460768>, <1.653704, 1.199480, 1.473425>, 
      <1.784714, 1.169193, 1.332718>, <1.784714, 1.196545, 1.343635>, <1.753269, 1.271572, 1.368118>, <1.744193, 1.296567, 1.380775>, 
      <1.512201, 1.233231, 1.254112>, <1.512871, 1.280993, 1.289521>, <1.504657, 1.334061, 1.289831>, <1.505806, 1.390938, 1.307128>, 
      <1.438592, 1.283402, 1.178202>, <1.439262, 1.331164, 1.213611>, <1.441272, 1.416115, 1.218561>, <1.442421, 1.472992, 1.235858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.171778, 1.142978, 1.439086>, <1.171778, 1.169838, 1.449037>, <1.198316, 1.199197, 1.463629>, <1.209689, 1.223291, 1.474148>, 
      <1.296284, 1.058116, 1.567484>, <1.296284, 1.084977, 1.577435>, <1.284770, 1.087280, 1.560839>, <1.296143, 1.111374, 1.571358>, 
      <1.551481, 1.046443, 1.560768>, <1.551481, 1.073795, 1.571684>, <1.566840, 1.071550, 1.559000>, <1.557764, 1.096545, 1.571656>, 
      <1.683957, 1.116165, 1.431236>, <1.683957, 1.143517, 1.442152>, <1.662780, 1.174486, 1.460768>, <1.653704, 1.199480, 1.473425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.171778, 1.142978, 1.439086>, <1.074999, 1.208941, 1.339282>, <1.358548, 1.241275, 1.256467>, <1.438592, 1.283402, 1.178202>, 
      <1.171778, 1.169838, 1.449037>, <1.074999, 1.235802, 1.349233>, <1.359218, 1.289037, 1.291876>, <1.439262, 1.331164, 1.213611>, 
      <1.198316, 1.199197, 1.463629>, <1.117376, 1.303976, 1.372621>, <1.371453, 1.341205, 1.290048>, <1.441272, 1.416115, 1.218561>, 
      <1.209689, 1.223291, 1.474148>, <1.128750, 1.328069, 1.383140>, <1.372601, 1.398082, 1.307345>, <1.442421, 1.472992, 1.235858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.653704, 0.914207, 1.359573>, <1.661815, 0.939173, 1.418956>, <1.683957, 1.055864, 1.407170>, <1.683957, 1.116165, 1.431236>, 
      <1.742197, 1.015866, 1.230218>, <1.750308, 1.040832, 1.289601>, <1.784714, 1.108892, 1.308652>, <1.784714, 1.169193, 1.332718>, 
      <1.503125, 1.114314, 1.131341>, <1.503308, 1.141989, 1.173087>, <1.511637, 1.192998, 1.224285>, <1.512201, 1.233231, 1.254112>, 
      <1.438592, 1.200074, 1.033527>, <1.438775, 1.227749, 1.075273>, <1.438028, 1.243169, 1.148375>, <1.438592, 1.283402, 1.178202>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.209689, 0.937114, 1.368127>, <1.200622, 0.963690, 1.428196>, <1.171778, 1.080800, 1.416051>, <1.171778, 1.142978, 1.439086>, 
      <1.285959, 0.835758, 1.483729>, <1.276892, 0.862333, 1.543798>, <1.296284, 0.995938, 1.544449>, <1.296284, 1.058116, 1.567484>, 
      <1.572406, 0.820813, 1.478411>, <1.580517, 0.845779, 1.537794>, <1.551481, 0.986142, 1.536701>, <1.551481, 1.046443, 1.560768>, 
      <1.653704, 0.914207, 1.359573>, <1.661815, 0.939173, 1.418956>, <1.683957, 1.055864, 1.407170>, <1.683957, 1.116165, 1.431236>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.209689, 0.937114, 1.368127>, <1.126810, 1.047253, 1.242508>, <1.369921, 1.121186, 1.133907>, <1.438592, 1.200074, 1.033527>, 
      <1.200622, 0.963690, 1.428196>, <1.117744, 1.073829, 1.302576>, <1.370104, 1.148861, 1.175653>, <1.438775, 1.227749, 1.075273>, 
      <1.171778, 1.080800, 1.416051>, <1.074999, 1.146763, 1.316247>, <1.357983, 1.201042, 1.226640>, <1.438028, 1.243169, 1.148375>, 
      <1.171778, 1.142978, 1.439086>, <1.074999, 1.208941, 1.339282>, <1.358548, 1.241275, 1.256467>, <1.438592, 1.283402, 1.178202>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.591867, 0.832694, 0.756981>, <1.610418, 0.857148, 0.937759>, <1.630798, 0.843698, 1.191863>, <1.653704, 0.914207, 1.359573>, 
      <1.657537, 0.928850, 0.802194>, <1.676088, 0.953304, 0.982971>, <1.719291, 0.945358, 1.062508>, <1.742197, 1.015866, 1.230218>, 
      <1.483669, 1.011162, 0.845136>, <1.484057, 1.044890, 0.890319>, <1.502920, 1.083159, 1.084345>, <1.503125, 1.114314, 1.131341>, 
      <1.437298, 1.087648, 0.882916>, <1.437686, 1.121376, 0.928099>, <1.438386, 1.168919, 0.986531>, <1.438592, 1.200074, 1.033527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.272820, 0.846813, 0.769675>, <1.253881, 0.873903, 0.949211>, <1.234651, 0.863947, 1.202751>, <1.209689, 0.937114, 1.368127>, 
      <1.331729, 0.749646, 0.721679>, <1.312789, 0.776736, 0.901215>, <1.310921, 0.762591, 1.318353>, <1.285959, 0.835758, 1.483729>, 
      <1.527018, 0.737739, 0.712333>, <1.545569, 0.762193, 0.893111>, <1.549500, 0.750305, 1.310701>, <1.572406, 0.820813, 1.478411>, 
      <1.591867, 0.832694, 0.756981>, <1.610418, 0.857148, 0.937759>, <1.630798, 0.843698, 1.191863>, <1.653704, 0.914207, 1.359573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.272820, 0.846813, 0.769675>, <1.215157, 0.941926, 0.816656>, <1.387955, 1.015398, 0.848944>, <1.437298, 1.087648, 0.882916>, 
      <1.253881, 0.873903, 0.949211>, <1.196217, 0.969016, 0.996192>, <1.388343, 1.049125, 0.894127>, <1.437686, 1.121376, 0.928099>, 
      <1.234651, 0.863947, 1.202751>, <1.151773, 0.974086, 1.077132>, <1.369715, 1.090031, 1.086911>, <1.438386, 1.168919, 0.986531>, 
      <1.209689, 0.937114, 1.368127>, <1.126810, 1.047253, 1.242508>, <1.369921, 1.121186, 1.133907>, <1.438592, 1.200074, 1.033527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.655116, 0.891610, 0.929976>, <1.665075, 0.925531, 0.974652>, <1.668343, 1.008077, 0.992678>, <1.674011, 1.057992, 1.019550>, 
      <1.745804, 1.052031, 0.956334>, <1.755764, 1.085951, 1.001010>, <1.765716, 1.107715, 1.042292>, <1.771385, 1.157630, 1.069164>, 
      <1.496687, 1.182575, 0.995105>, <1.498866, 1.203069, 1.035720>, <1.505603, 1.236045, 1.082513>, <1.508038, 1.238712, 1.127915>, 
      <1.428789, 1.307274, 1.023017>, <1.430968, 1.327769, 1.063632>, <1.434472, 1.313496, 1.128955>, <1.436907, 1.316163, 1.174357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193808, 0.891610, 0.954720>, <1.188684, 0.925531, 1.000205>, <1.187364, 1.008077, 1.018477>, <1.184603, 1.057992, 1.045802>, 
      <1.277467, 0.737966, 0.920329>, <1.272343, 0.771886, 0.965814>, <1.304405, 0.880638, 0.942061>, <1.301643, 0.930553, 0.969385>, 
      <1.568259, 0.737966, 0.904731>, <1.578218, 0.771886, 0.949407>, <1.543799, 0.880638, 0.929220>, <1.549468, 0.930553, 0.956092>, 
      <1.655116, 0.891610, 0.929976>, <1.665075, 0.925531, 0.974652>, <1.668343, 1.008077, 0.992678>, <1.674011, 1.057992, 1.019550>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193808, 0.891610, 0.954720>, <1.106460, 1.052031, 0.990628>, <1.358295, 1.182575, 1.002528>, <1.428789, 1.307274, 1.023017>, 
      <1.188684, 0.925531, 1.000205>, <1.101336, 1.085951, 1.036113>, <1.360473, 1.203069, 1.043143>, <1.430968, 1.327769, 1.063632>, 
      <1.187364, 1.008077, 1.018477>, <1.095857, 1.107715, 1.078224>, <1.358780, 1.236045, 1.090389>, <1.434472, 1.313496, 1.128955>, 
      <1.184603, 1.057992, 1.045802>, <1.093095, 1.157630, 1.105548>, <1.361216, 1.238712, 1.135791>, <1.436907, 1.316163, 1.174357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.597041, 0.795845, 0.674283>, <1.614039, 0.811692, 0.754738>, <1.640476, 0.841749, 0.864306>, <1.655116, 0.891610, 0.929976>, 
      <1.668981, 0.901154, 0.670303>, <1.685979, 0.917001, 0.750757>, <1.731164, 1.002170, 0.890664>, <1.745804, 1.052031, 0.956334>, 
      <1.538018, 1.068710, 0.677134>, <1.543474, 1.140279, 0.778848>, <1.490732, 1.126556, 0.884090>, <1.496687, 1.182575, 0.995105>, 
      <1.410603, 1.068710, 0.683968>, <1.416059, 1.140279, 0.785683>, <1.422834, 1.251255, 0.912002>, <1.428789, 1.307274, 1.023017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.224199, 0.795845, 0.694282>, <1.217059, 0.802337, 0.777468>, <1.201339, 0.841749, 0.887860>, <1.193808, 0.891610, 0.954720>, 
      <1.305459, 0.676916, 0.690061>, <1.298319, 0.683408, 0.773247>, <1.284998, 0.688105, 0.853469>, <1.277467, 0.737966, 0.920329>, 
      <1.515796, 0.676916, 0.678778>, <1.532794, 0.692763, 0.759233>, <1.553619, 0.688105, 0.839061>, <1.568259, 0.737966, 0.904731>, 
      <1.597041, 0.795845, 0.674283>, <1.614039, 0.811692, 0.754738>, <1.640476, 0.841749, 0.864306>, <1.655116, 0.891610, 0.929976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.224199, 0.795845, 0.694282>, <1.152246, 0.901154, 0.698020>, <1.283188, 1.068710, 0.690802>, <1.410603, 1.068710, 0.683968>, 
      <1.217059, 0.802337, 0.777468>, <1.145106, 0.907646, 0.781206>, <1.288644, 1.140279, 0.792517>, <1.416059, 1.140279, 0.785683>, 
      <1.201339, 0.841749, 0.887860>, <1.113991, 1.002170, 0.923768>, <1.352340, 1.126556, 0.891513>, <1.422834, 1.251255, 0.912002>, 
      <1.193808, 0.891610, 0.954720>, <1.106460, 1.052031, 0.990628>, <1.358295, 1.182575, 1.002528>, <1.428789, 1.307274, 1.023017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.557415, 0.800526, 0.467534>, <1.569303, 0.799122, 0.529559>, <1.584219, 0.783892, 0.613595>, <1.597041, 0.795845, 0.674283>, 
      <1.629589, 0.807857, 0.423993>, <1.641477, 0.806452, 0.486017>, <1.656160, 0.889201, 0.609614>, <1.668981, 0.901154, 0.670303>, 
      <1.441711, 0.846642, 0.377890>, <1.447255, 0.907333, 0.481239>, <1.532474, 1.008019, 0.573785>, <1.538018, 1.068710, 0.677134>, 
      <1.392124, 0.866406, 0.339471>, <1.397668, 0.927097, 0.442820>, <1.405059, 1.008019, 0.580619>, <1.410603, 1.068710, 0.683968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.238669, 0.850820, 0.432048>, <1.234328, 0.834328, 0.510718>, <1.231062, 0.789605, 0.614321>, <1.224199, 0.795845, 0.694282>, 
      <1.333132, 0.813170, 0.505236>, <1.328791, 0.796677, 0.583906>, <1.312322, 0.670676, 0.610100>, <1.305459, 0.676916, 0.690061>, 
      <1.450540, 0.789671, 0.532010>, <1.462428, 0.788267, 0.594035>, <1.502975, 0.664963, 0.618090>, <1.515796, 0.676916, 0.678778>, 
      <1.557415, 0.800526, 0.467534>, <1.569303, 0.799122, 0.529559>, <1.584219, 0.783892, 0.613595>, <1.597041, 0.795845, 0.674283>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.238669, 0.850820, 0.432048>, <1.186323, 0.871684, 0.391492>, <1.346088, 0.861730, 0.367244>, <1.392124, 0.866406, 0.339471>, 
      <1.234328, 0.834328, 0.510718>, <1.181982, 0.855191, 0.470162>, <1.351631, 0.922421, 0.470593>, <1.397668, 0.927097, 0.442820>, 
      <1.231062, 0.789605, 0.614321>, <1.159109, 0.894914, 0.618058>, <1.277645, 1.008019, 0.587453>, <1.405059, 1.008019, 0.580619>, 
      <1.224199, 0.795845, 0.694282>, <1.152246, 0.901154, 0.698020>, <1.283188, 1.068710, 0.690802>, <1.410603, 1.068710, 0.683968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674011, 1.017595, 0.726670>, <1.771385, 1.117233, 0.776284>, <1.508038, 1.198315, 0.835035>, <1.436907, 1.275766, 0.881477>, 
      <1.668343, 0.967681, 0.699798>, <1.765716, 1.067318, 0.749412>, <1.505603, 1.195648, 0.789633>, <1.434472, 1.273099, 0.836075>, 
      <1.665075, 0.885133, 0.681772>, <1.755764, 1.045554, 0.708130>, <1.498866, 1.162673, 0.742840>, <1.430968, 1.287372, 0.770752>, 
      <1.655116, 0.851213, 0.637096>, <1.745804, 1.011634, 0.663454>, <1.496687, 1.142178, 0.702225>, <1.428789, 1.266877, 0.730137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.184603, 1.017595, 0.752922>, <1.301643, 0.890156, 0.676505>, <1.549468, 0.890156, 0.663212>, <1.674011, 1.017595, 0.726670>, 
      <1.187364, 0.967681, 0.725597>, <1.304405, 0.840241, 0.649181>, <1.543799, 0.840241, 0.636340>, <1.668343, 0.967681, 0.699798>, 
      <1.188684, 0.885134, 0.707325>, <1.272343, 0.731489, 0.672934>, <1.578218, 0.731489, 0.656527>, <1.665075, 0.885133, 0.681772>, 
      <1.193808, 0.851213, 0.661840>, <1.277467, 0.697569, 0.627449>, <1.568259, 0.697569, 0.611851>, <1.655116, 0.851213, 0.637096>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.184603, 1.017595, 0.752922>, <1.187364, 0.967681, 0.725597>, <1.188684, 0.885134, 0.707325>, <1.193808, 0.851213, 0.661840>, 
      <1.093095, 1.117233, 0.812668>, <1.095857, 1.067318, 0.785343>, <1.101336, 1.045554, 0.743233>, <1.106460, 1.011634, 0.697748>, 
      <1.361216, 1.198315, 0.842911>, <1.358780, 1.195648, 0.797509>, <1.360473, 1.162673, 0.750263>, <1.358295, 1.142178, 0.709648>, 
      <1.436907, 1.275766, 0.881477>, <1.434472, 1.273099, 0.836075>, <1.430968, 1.287372, 0.770752>, <1.428789, 1.266877, 0.730137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.597041, 0.755448, 0.381403>, <1.614039, 0.771295, 0.461858>, <1.640476, 0.801352, 0.571426>, <1.655116, 0.851213, 0.637096>, 
      <1.668981, 0.860757, 0.377422>, <1.685979, 0.876604, 0.457877>, <1.731164, 0.961773, 0.597784>, <1.745804, 1.011634, 0.663454>, 
      <1.538018, 1.028313, 0.384254>, <1.543474, 1.099882, 0.485968>, <1.490732, 1.086159, 0.591210>, <1.496687, 1.142178, 0.702225>, 
      <1.410603, 1.028313, 0.391088>, <1.416059, 1.099882, 0.492803>, <1.422834, 1.210859, 0.619122>, <1.428789, 1.266877, 0.730137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.224199, 0.755448, 0.401402>, <1.217059, 0.761940, 0.484588>, <1.201339, 0.801352, 0.594980>, <1.193808, 0.851213, 0.661840>, 
      <1.305459, 0.636519, 0.397181>, <1.298319, 0.643011, 0.480367>, <1.284998, 0.647708, 0.560589>, <1.277467, 0.697569, 0.627449>, 
      <1.515796, 0.636519, 0.385898>, <1.532794, 0.652366, 0.466353>, <1.553619, 0.647708, 0.546181>, <1.568259, 0.697569, 0.611851>, 
      <1.597041, 0.755448, 0.381403>, <1.614039, 0.771295, 0.461858>, <1.640476, 0.801352, 0.571426>, <1.655116, 0.851213, 0.637096>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.224199, 0.755448, 0.401402>, <1.152246, 0.860757, 0.405140>, <1.283188, 1.028313, 0.397923>, <1.410603, 1.028313, 0.391088>, 
      <1.217059, 0.761940, 0.484588>, <1.145106, 0.867249, 0.488326>, <1.288644, 1.099882, 0.499637>, <1.416059, 1.099882, 0.492803>, 
      <1.201339, 0.801352, 0.594980>, <1.113991, 0.961773, 0.630888>, <1.352340, 1.086159, 0.598633>, <1.422834, 1.210859, 0.619122>, 
      <1.193808, 0.851213, 0.661840>, <1.106460, 1.011634, 0.697748>, <1.358295, 1.142178, 0.709648>, <1.428789, 1.266877, 0.730137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.557415, 0.760129, 0.174654>, <1.569303, 0.758725, 0.236679>, <1.584219, 0.743495, 0.320715>, <1.597041, 0.755448, 0.381403>, 
      <1.629589, 0.767459, 0.131113>, <1.641477, 0.766055, 0.193137>, <1.656160, 0.848804, 0.316734>, <1.668981, 0.860757, 0.377422>, 
      <1.441711, 0.806245, 0.085010>, <1.447255, 0.866936, 0.188359>, <1.532474, 0.967622, 0.280905>, <1.538018, 1.028313, 0.384254>, 
      <1.392124, 0.826009, 0.046591>, <1.397668, 0.886700, 0.149940>, <1.405059, 0.967622, 0.287739>, <1.410603, 1.028313, 0.391088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.238669, 0.810423, 0.139168>, <1.234328, 0.793931, 0.217838>, <1.231062, 0.749208, 0.321441>, <1.224199, 0.755448, 0.401402>, 
      <1.333132, 0.772773, 0.212356>, <1.328791, 0.756280, 0.291026>, <1.312322, 0.630279, 0.317219>, <1.305459, 0.636519, 0.397181>, 
      <1.450540, 0.749274, 0.239130>, <1.462428, 0.747870, 0.301155>, <1.502975, 0.624566, 0.325210>, <1.515796, 0.636519, 0.385898>, 
      <1.557415, 0.760129, 0.174654>, <1.569303, 0.758725, 0.236679>, <1.584219, 0.743495, 0.320715>, <1.597041, 0.755448, 0.381403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.238669, 0.810423, 0.139168>, <1.186323, 0.831287, 0.098612>, <1.346088, 0.821333, 0.074364>, <1.392124, 0.826009, 0.046591>, 
      <1.234328, 0.793931, 0.217838>, <1.181982, 0.814794, 0.177282>, <1.351631, 0.882024, 0.177713>, <1.397668, 0.886700, 0.149940>, 
      <1.231062, 0.749208, 0.321441>, <1.159109, 0.854517, 0.325178>, <1.277645, 0.967622, 0.294573>, <1.405059, 0.967622, 0.287739>, 
      <1.224199, 0.755448, 0.401402>, <1.152246, 0.860757, 0.405140>, <1.283188, 1.028313, 0.397923>, <1.410603, 1.028313, 0.391088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.653812, 0.988573, 0.233525>, <1.751186, 1.099580, 0.241698>, <1.487839, 1.196874, 0.265355>, <1.416708, 1.286146, 0.278997>, 
      <1.648144, 0.932199, 0.227564>, <1.745517, 1.043206, 0.235737>, <1.485404, 1.177207, 0.224347>, <1.414273, 1.266479, 0.237989>, 
      <1.644877, 0.848975, 0.242152>, <1.735565, 1.007425, 0.205776>, <1.478667, 1.128964, 0.193533>, <1.410769, 1.254943, 0.172128>, 
      <1.634917, 0.800659, 0.213655>, <1.725605, 0.959109, 0.177280>, <1.476488, 1.094611, 0.163709>, <1.408590, 1.220590, 0.142303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.164404, 0.998517, 0.257821>, <1.281444, 0.851628, 0.235375>, <1.529269, 0.846592, 0.223072>, <1.653812, 0.988573, 0.233525>, 
      <1.167166, 0.941971, 0.251441>, <1.284206, 0.795082, 0.228995>, <1.523600, 0.790218, 0.217111>, <1.648144, 0.932199, 0.227564>, 
      <1.168486, 0.858655, 0.265801>, <1.252144, 0.703433, 0.292175>, <1.558019, 0.697218, 0.276991>, <1.644877, 0.848975, 0.242152>, 
      <1.173609, 0.810032, 0.236555>, <1.257268, 0.654810, 0.262929>, <1.548060, 0.648902, 0.248494>, <1.634917, 0.800659, 0.213655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.164404, 0.998517, 0.257821>, <1.167166, 0.941971, 0.251441>, <1.168486, 0.858655, 0.265801>, <1.173609, 0.810032, 0.236555>, 
      <1.072896, 1.113362, 0.275370>, <1.075658, 1.056817, 0.268991>, <1.081137, 1.020722, 0.238263>, <1.086261, 0.972099, 0.209018>, 
      <1.341017, 1.199857, 0.272644>, <1.338581, 1.180191, 0.231636>, <1.340274, 1.131776, 0.200403>, <1.338096, 1.097423, 0.170579>, 
      <1.416708, 1.286146, 0.278997>, <1.414273, 1.266479, 0.237989>, <1.410769, 1.254943, 0.172128>, <1.408590, 1.220590, 0.142303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.576842, 0.615171, 0.013294>, <1.593840, 0.660314, 0.081750>, <1.620277, 0.729637, 0.171767>, <1.634917, 0.800659, 0.213655>, 
      <1.648782, 0.711124, -0.030282>, <1.665780, 0.756267, 0.038174>, <1.710965, 0.888087, 0.135391>, <1.725605, 0.959109, 0.177280>, 
      <1.517819, 0.868781, -0.087432>, <1.523275, 0.973547, -0.020409>, <1.470533, 1.000714, 0.082188>, <1.476488, 1.094611, 0.163709>, 
      <1.390404, 0.871370, -0.081107>, <1.395860, 0.976136, -0.014084>, <1.402635, 1.126693, 0.060782>, <1.408590, 1.220590, 0.142303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.204000, 0.622747, 0.031803>, <1.196860, 0.660267, 0.106330>, <1.181140, 0.738560, 0.193566>, <1.173609, 0.810032, 0.236555>, 
      <1.285259, 0.511082, 0.072948>, <1.278120, 0.548602, 0.147475>, <1.264799, 0.583338, 0.219940>, <1.257268, 0.654810, 0.262929>, 
      <1.495597, 0.506808, 0.062506>, <1.512595, 0.551951, 0.130962>, <1.533420, 0.577880, 0.206606>, <1.548060, 0.648902, 0.248494>, 
      <1.576842, 0.615171, 0.013294>, <1.593840, 0.660314, 0.081750>, <1.620277, 0.729637, 0.171767>, <1.634917, 0.800659, 0.213655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.204000, 0.622747, 0.031803>, <1.132047, 0.721624, -0.004630>, <1.262989, 0.873959, -0.074782>, <1.390404, 0.871370, -0.081107>, 
      <1.196860, 0.660267, 0.106330>, <1.124907, 0.759144, 0.069897>, <1.268445, 0.978725, -0.007759>, <1.395860, 0.976136, -0.014084>, 
      <1.181140, 0.738560, 0.193566>, <1.093792, 0.900627, 0.166029>, <1.332141, 1.003525, 0.089058>, <1.402635, 1.126693, 0.060782>, 
      <1.173609, 0.810032, 0.236555>, <1.086261, 0.972099, 0.209018>, <1.338096, 1.097423, 0.170579>, <1.408590, 1.220590, 0.142303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.537216, 0.541184, -0.179820>, <1.549104, 0.563380, -0.121886>, <1.564020, 0.581119, -0.038343>, <1.576842, 0.615171, 0.013294>, 
      <1.609390, 0.531474, -0.222893>, <1.621278, 0.553670, -0.164959>, <1.635961, 0.677072, -0.081920>, <1.648782, 0.711124, -0.030282>, 
      <1.421512, 0.549905, -0.280253>, <1.427056, 0.645223, -0.207596>, <1.512275, 0.773463, -0.160089>, <1.517819, 0.868781, -0.087432>, 
      <1.371925, 0.553643, -0.323295>, <1.377469, 0.648961, -0.250639>, <1.384860, 0.776052, -0.153763>, <1.390404, 0.871370, -0.081107>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.218470, 0.574288, -0.231713>, <1.214129, 0.588826, -0.152658>, <1.210863, 0.586682, -0.039835>, <1.204000, 0.622747, 0.031803>, 
      <1.312933, 0.567168, -0.149717>, <1.308592, 0.581705, -0.070663>, <1.292123, 0.475017, 0.001310>, <1.285259, 0.511082, 0.072948>, 
      <1.430341, 0.555562, -0.116037>, <1.442229, 0.577759, -0.058103>, <1.482776, 0.472756, 0.010869>, <1.495597, 0.506808, 0.062506>, 
      <1.537216, 0.541184, -0.179820>, <1.549104, 0.563380, -0.121886>, <1.564020, 0.581119, -0.038343>, <1.576842, 0.615171, 0.013294>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.218470, 0.574288, -0.231713>, <1.166124, 0.578234, -0.277150>, <1.325889, 0.559836, -0.295820>, <1.371925, 0.553643, -0.323295>, 
      <1.214129, 0.588826, -0.152658>, <1.161783, 0.592771, -0.198096>, <1.331432, 0.655155, -0.223164>, <1.377469, 0.648961, -0.250639>, 
      <1.210863, 0.586682, -0.039835>, <1.138910, 0.685558, -0.076268>, <1.257445, 0.778641, -0.147438>, <1.384860, 0.776052, -0.153763>, 
      <1.204000, 0.622747, 0.031803>, <1.132047, 0.721624, -0.004630>, <1.262989, 0.873959, -0.074782>, <1.390404, 0.871370, -0.081107>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.653812, 1.017595, 0.453989>, <1.751186, 1.117233, 0.503603>, <1.487839, 1.198315, 0.562354>, <1.416708, 1.275766, 0.608796>, 
      <1.648144, 0.967681, 0.427117>, <1.745517, 1.067318, 0.476731>, <1.485404, 1.195648, 0.516952>, <1.414273, 1.273099, 0.563394>, 
      <1.644877, 0.885133, 0.409091>, <1.735565, 1.045554, 0.435449>, <1.478667, 1.162673, 0.470159>, <1.410769, 1.287372, 0.498071>, 
      <1.634917, 0.851213, 0.364415>, <1.725605, 1.011634, 0.390773>, <1.476488, 1.142178, 0.429544>, <1.408590, 1.266877, 0.457456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.164404, 1.017595, 0.480241>, <1.281444, 0.890156, 0.403824>, <1.529269, 0.890156, 0.390531>, <1.653812, 1.017595, 0.453989>, 
      <1.167166, 0.967681, 0.452916>, <1.284206, 0.840241, 0.376500>, <1.523600, 0.840241, 0.363659>, <1.648144, 0.967681, 0.427117>, 
      <1.168486, 0.885134, 0.434644>, <1.252144, 0.731489, 0.400253>, <1.558019, 0.731489, 0.383846>, <1.644877, 0.885133, 0.409091>, 
      <1.173609, 0.851213, 0.389159>, <1.257268, 0.697569, 0.354768>, <1.548060, 0.697569, 0.339170>, <1.634917, 0.851213, 0.364415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.164404, 1.017595, 0.480241>, <1.167166, 0.967681, 0.452916>, <1.168486, 0.885134, 0.434644>, <1.173609, 0.851213, 0.389159>, 
      <1.072896, 1.117233, 0.539987>, <1.075658, 1.067318, 0.512662>, <1.081137, 1.045554, 0.470552>, <1.086261, 1.011634, 0.425067>, 
      <1.341017, 1.198315, 0.570230>, <1.338581, 1.195648, 0.524828>, <1.340274, 1.162673, 0.477582>, <1.338096, 1.142178, 0.436967>, 
      <1.416708, 1.275766, 0.608796>, <1.414273, 1.273099, 0.563394>, <1.410769, 1.287372, 0.498071>, <1.408590, 1.266877, 0.457456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.576842, 0.755448, 0.108722>, <1.593840, 0.771295, 0.189177>, <1.620277, 0.801352, 0.298745>, <1.634917, 0.851213, 0.364415>, 
      <1.648782, 0.860757, 0.104741>, <1.665780, 0.876604, 0.185196>, <1.710965, 0.961773, 0.325103>, <1.725605, 1.011634, 0.390773>, 
      <1.517819, 1.028313, 0.111573>, <1.523275, 1.099882, 0.213287>, <1.470533, 1.086159, 0.318529>, <1.476488, 1.142178, 0.429544>, 
      <1.390404, 1.028313, 0.118407>, <1.395860, 1.099882, 0.220122>, <1.402635, 1.210859, 0.346441>, <1.408590, 1.266877, 0.457456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.204000, 0.755448, 0.128721>, <1.196860, 0.761940, 0.211907>, <1.181140, 0.801352, 0.322299>, <1.173609, 0.851213, 0.389159>, 
      <1.285260, 0.636519, 0.124500>, <1.278120, 0.643011, 0.207686>, <1.264799, 0.647708, 0.287908>, <1.257268, 0.697569, 0.354768>, 
      <1.495597, 0.636519, 0.113217>, <1.512595, 0.652366, 0.193672>, <1.533420, 0.647708, 0.273500>, <1.548060, 0.697569, 0.339170>, 
      <1.576842, 0.755448, 0.108722>, <1.593840, 0.771295, 0.189177>, <1.620277, 0.801352, 0.298745>, <1.634917, 0.851213, 0.364415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.204000, 0.755448, 0.128721>, <1.132047, 0.860757, 0.132459>, <1.262989, 1.028313, 0.125242>, <1.390404, 1.028313, 0.118407>, 
      <1.196860, 0.761940, 0.211907>, <1.124907, 0.867249, 0.215645>, <1.268445, 1.099882, 0.226956>, <1.395860, 1.099882, 0.220122>, 
      <1.181140, 0.801352, 0.322299>, <1.093792, 0.961773, 0.358207>, <1.332141, 1.086159, 0.325952>, <1.402635, 1.210859, 0.346441>, 
      <1.173609, 0.851213, 0.389159>, <1.086261, 1.011634, 0.425067>, <1.338096, 1.142178, 0.436967>, <1.408590, 1.266877, 0.457456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.537216, 0.760129, -0.098027>, <1.549104, 0.758725, -0.036002>, <1.564020, 0.743495, 0.048034>, <1.576842, 0.755448, 0.108722>, 
      <1.609390, 0.767459, -0.141568>, <1.621278, 0.766055, -0.079544>, <1.635961, 0.848804, 0.044053>, <1.648782, 0.860757, 0.104741>, 
      <1.421512, 0.806245, -0.187671>, <1.427056, 0.866936, -0.084322>, <1.512275, 0.967622, 0.008223>, <1.517819, 1.028313, 0.111573>, 
      <1.371925, 0.826009, -0.226090>, <1.377469, 0.886700, -0.122741>, <1.384860, 0.967622, 0.015058>, <1.390404, 1.028313, 0.118407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.218470, 0.810423, -0.133513>, <1.214129, 0.793931, -0.054843>, <1.210863, 0.749208, 0.048760>, <1.204000, 0.755448, 0.128721>, 
      <1.312933, 0.772773, -0.060325>, <1.308592, 0.756280, 0.018345>, <1.292123, 0.630279, 0.044539>, <1.285260, 0.636519, 0.124500>, 
      <1.430341, 0.749274, -0.033551>, <1.442229, 0.747870, 0.028474>, <1.482775, 0.624566, 0.052529>, <1.495597, 0.636519, 0.113217>, 
      <1.537216, 0.760129, -0.098027>, <1.549104, 0.758725, -0.036002>, <1.564020, 0.743495, 0.048034>, <1.576842, 0.755448, 0.108722>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.218470, 0.810423, -0.133513>, <1.166124, 0.831287, -0.174069>, <1.325889, 0.821333, -0.198317>, <1.371925, 0.826009, -0.226090>, 
      <1.214129, 0.793931, -0.054843>, <1.161783, 0.814794, -0.095399>, <1.331432, 0.882024, -0.094968>, <1.377469, 0.886700, -0.122741>, 
      <1.210863, 0.749208, 0.048760>, <1.138910, 0.854517, 0.052498>, <1.257446, 0.967622, 0.021892>, <1.384860, 0.967622, 0.015058>, 
      <1.204000, 0.755448, 0.128721>, <1.132047, 0.860757, 0.132459>, <1.262989, 1.028313, 0.125242>, <1.390404, 1.028313, 0.118407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.640964, 0.877485, 0.015616>, <1.735540, 0.990971, 0.022481>, <1.469425, 1.083322, 0.028068>, <1.395908, 1.171538, 0.033404>, 
      <1.636743, 0.861433, -0.006810>, <1.731319, 0.974919, 0.000056>, <1.469425, 1.061459, -0.011887>, <1.395908, 1.149675, -0.006551>, 
      <1.631282, 0.842820, -0.039035>, <1.720428, 0.948832, -0.054720>, <1.465204, 1.052183, -0.059591>, <1.395908, 1.134588, -0.071784>, 
      <1.626894, 0.823977, -0.059136>, <1.716040, 0.929988, -0.074822>, <1.465204, 1.016257, -0.087586>, <1.395908, 1.098662, -0.099779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.150852, 0.877485, 0.015616>, <1.271818, 0.732333, 0.006835>, <1.519998, 0.732333, 0.006835>, <1.640964, 0.877485, 0.015616>, 
      <1.155073, 0.861433, -0.006810>, <1.276039, 0.716281, -0.015590>, <1.515777, 0.716281, -0.015590>, <1.636743, 0.861433, -0.006810>, 
      <1.160534, 0.842820, -0.039035>, <1.274554, 0.707229, -0.018972>, <1.517262, 0.707229, -0.018972>, <1.631282, 0.842820, -0.039035>, 
      <1.164922, 0.823977, -0.059136>, <1.278943, 0.688386, -0.039074>, <1.512873, 0.688386, -0.039074>, <1.626894, 0.823977, -0.059136>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.150852, 0.877485, 0.015616>, <1.155073, 0.861433, -0.006810>, <1.160534, 0.842820, -0.039035>, <1.164922, 0.823977, -0.059136>, 
      <1.056276, 0.990971, 0.022481>, <1.060497, 0.974919, 0.000056>, <1.071387, 0.948832, -0.054720>, <1.075776, 0.929988, -0.074822>, 
      <1.322391, 1.083322, 0.028068>, <1.322391, 1.061459, -0.011887>, <1.326612, 1.052183, -0.059591>, <1.326612, 1.016257, -0.087586>, 
      <1.395908, 1.171538, 0.033404>, <1.395908, 1.149675, -0.006551>, <1.395908, 1.134588, -0.071784>, <1.395908, 1.098662, -0.099779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.582597, 0.626850, -0.251753>, <1.594086, 0.692779, -0.201410>, <1.613722, 0.767417, -0.119473>, <1.626894, 0.823977, -0.059136>, 
      <1.654648, 0.669658, -0.272150>, <1.666136, 0.735586, -0.221807>, <1.702869, 0.873428, -0.135158>, <1.716040, 0.929988, -0.074822>, 
      <1.482162, 0.737768, -0.304604>, <1.482162, 0.846036, -0.243157>, <1.465204, 0.918059, -0.164105>, <1.465204, 1.016257, -0.087586>, 
      <1.395908, 0.737768, -0.304604>, <1.395908, 0.846036, -0.243157>, <1.395908, 1.000465, -0.176298>, <1.395908, 1.098662, -0.099779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.209219, 0.626850, -0.251753>, <1.198299, 0.686066, -0.193553>, <1.178094, 0.767417, -0.119473>, <1.164922, 0.823977, -0.059136>, 
      <1.329590, 0.555334, -0.217676>, <1.318670, 0.614550, -0.159476>, <1.292114, 0.631825, -0.099410>, <1.278943, 0.688386, -0.039074>, 
      <1.462226, 0.555334, -0.217676>, <1.473715, 0.621262, -0.167333>, <1.499702, 0.631825, -0.099410>, <1.512873, 0.688386, -0.039074>, 
      <1.582597, 0.626850, -0.251753>, <1.594086, 0.692779, -0.201410>, <1.613722, 0.767417, -0.119473>, <1.626894, 0.823977, -0.059136>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.209219, 0.626850, -0.251753>, <1.137169, 0.669658, -0.272150>, <1.309654, 0.737768, -0.304604>, <1.395908, 0.737768, -0.304604>, 
      <1.198299, 0.686066, -0.193553>, <1.126248, 0.728874, -0.213950>, <1.309654, 0.846036, -0.243157>, <1.395908, 0.846036, -0.243157>, 
      <1.178094, 0.767417, -0.119473>, <1.088947, 0.873428, -0.135158>, <1.326612, 0.918059, -0.164105>, <1.395908, 1.000465, -0.176298>, 
      <1.164922, 0.823977, -0.059136>, <1.075776, 0.929988, -0.074822>, <1.326612, 1.016257, -0.087586>, <1.395908, 1.098662, -0.099779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.554102, 0.406267, -0.378101>, <1.562650, 0.472442, -0.340197>, <1.572069, 0.566436, -0.297886>, <1.582597, 0.626850, -0.251753>, 
      <1.628504, 0.395945, -0.417042>, <1.637053, 0.462120, -0.379138>, <1.644119, 0.609243, -0.318283>, <1.654648, 0.669658, -0.272150>, 
      <1.443366, 0.406999, -0.484342>, <1.443366, 0.506136, -0.416761>, <1.482162, 0.638632, -0.372185>, <1.482162, 0.737768, -0.304604>, 
      <1.395908, 0.407313, -0.529874>, <1.395908, 0.506450, -0.462293>, <1.395908, 0.638632, -0.372185>, <1.395908, 0.737768, -0.304604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.237714, 0.429260, -0.447078>, <1.229166, 0.488537, -0.388481>, <1.220145, 0.567602, -0.309984>, <1.209219, 0.626850, -0.251753>, 
      <1.328122, 0.428662, -0.360340>, <1.319573, 0.487939, -0.301743>, <1.340516, 0.496086, -0.275907>, <1.329590, 0.555334, -0.217676>, 
      <1.443927, 0.421552, -0.320437>, <1.452475, 0.487727, -0.282533>, <1.451698, 0.494919, -0.263809>, <1.462226, 0.555334, -0.217676>, 
      <1.554102, 0.406267, -0.378101>, <1.562650, 0.472442, -0.340197>, <1.572069, 0.566436, -0.297886>, <1.582597, 0.626850, -0.251753>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.237714, 0.429260, -0.447078>, <1.187615, 0.429591, -0.495143>, <1.348450, 0.413897, -0.505035>, <1.395908, 0.407313, -0.529874>, 
      <1.229166, 0.488537, -0.388481>, <1.179067, 0.488868, -0.436546>, <1.348450, 0.513034, -0.437454>, <1.395908, 0.506450, -0.462293>, 
      <1.220145, 0.567602, -0.309984>, <1.148095, 0.610410, -0.330381>, <1.309654, 0.638632, -0.372185>, <1.395908, 0.638632, -0.372185>, 
      <1.209219, 0.626850, -0.251753>, <1.137169, 0.669658, -0.272150>, <1.309654, 0.737768, -0.304604>, <1.395908, 0.737768, -0.304604>
    }
  }
  texture {
    HornGradient
    scale <0.5, 0.55, 0.5>
    translate <0.000000, 1.200000, 0.000000>
  }
}
#declare HairSpikes = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.608637, -0.677998, -0.008902>, <-0.660385, -0.696427, -0.006984>, <-0.745116, -0.761733, -0.006807>, <-0.785555, -0.724962, -0.000995>, 
      <-0.607955, -0.625931, -0.031441>, <-0.659702, -0.644360, -0.029523>, <-0.718639, -0.667137, -0.030354>, <-0.759077, -0.630366, -0.024542>, 
      <-0.600817, -0.536450, -0.025898>, <-0.636444, -0.542769, -0.024041>, <-0.687947, -0.519255, -0.020778>, <-0.713707, -0.494071, -0.016927>, 
      <-0.593222, -0.490077, 0.005903>, <-0.628849, -0.496396, 0.007760>, <-0.653329, -0.431315, 0.014889>, <-0.679089, -0.406131, 0.018740>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.066074, -0.468734, -0.027656>, <-0.204036, -0.575659, -0.027415>, <-0.444306, -0.619475, -0.014991>, <-0.608637, -0.677998, -0.008902>, 
      <-0.024855, -0.436789, -0.027728>, <-0.162818, -0.543713, -0.027487>, <-0.443624, -0.567408, -0.037530>, <-0.607955, -0.625931, -0.031441>, 
      <-0.080841, -0.307138, -0.013044>, <-0.228881, -0.313131, -0.003619>, <-0.454830, -0.510556, -0.033508>, <-0.600817, -0.536450, -0.025898>, 
      <-0.132842, -0.309243, -0.009733>, <-0.280882, -0.315237, -0.000309>, <-0.447235, -0.464183, -0.001706>, <-0.593222, -0.490077, 0.005903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.737235, -0.508946, 0.013973>, <-0.703255, -0.498895, 0.012541>, <-0.696533, -0.436976, 0.017310>, <-0.679089, -0.406131, 0.018740>, 
      <-0.773472, -0.519664, 0.015500>, <-0.739492, -0.509614, 0.014068>, <-0.731151, -0.524916, -0.018357>, <-0.713707, -0.494071, -0.016927>, 
      <-0.817241, -0.472679, 0.022396>, <-0.797449, -0.553027, 0.014296>, <-0.820249, -0.574743, -0.015751>, <-0.759077, -0.630366, -0.024542>, 
      <-0.851530, -0.457136, 0.026006>, <-0.831738, -0.537484, 0.017906>, <-0.846726, -0.669339, 0.007796>, <-0.785555, -0.724962, -0.000995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.120101, -0.325255, 0.093351>, <-0.123923, -0.320451, 0.062426>, <-0.129020, -0.314047, 0.021192>, <-0.132842, -0.309243, -0.009733>, 
      <-0.268141, -0.331249, 0.102776>, <-0.271963, -0.326446, 0.071850>, <-0.277060, -0.320040, 0.030617>, <-0.280882, -0.315237, -0.000309>, 
      <-0.434494, -0.480196, 0.101380>, <-0.438316, -0.475392, 0.070454>, <-0.443015, -0.438415, 0.015965>, <-0.447235, -0.464183, -0.001706>, 
      <-0.580481, -0.506089, 0.108989>, <-0.584303, -0.501285, 0.078063>, <-0.589002, -0.464309, 0.023574>, <-0.593222, -0.490077, 0.005903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.053333, -0.484745, 0.075429>, <-0.057155, -0.479942, 0.044504>, <-0.062252, -0.473537, 0.003269>, <-0.066074, -0.468734, -0.027656>, 
      <-0.012115, -0.452800, 0.075357>, <-0.015937, -0.447996, 0.044431>, <-0.021033, -0.441592, 0.003197>, <-0.024855, -0.436789, -0.027728>, 
      <-0.068100, -0.323149, 0.090040>, <-0.071923, -0.318346, 0.059115>, <-0.077019, -0.311941, 0.017882>, <-0.080841, -0.307138, -0.013044>, 
      <-0.120101, -0.325255, 0.093351>, <-0.123923, -0.320451, 0.062426>, <-0.129020, -0.314047, 0.021192>, <-0.132842, -0.309243, -0.009733>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.595895, -0.694010, 0.094182>, <-0.599718, -0.689206, 0.063257>, <-0.609016, -0.706930, 0.003622>, <-0.608637, -0.677998, -0.008902>, 
      <-0.431565, -0.635487, 0.088092>, <-0.435387, -0.630683, 0.057167>, <-0.444686, -0.648407, -0.002467>, <-0.444306, -0.619475, -0.014991>, 
      <-0.191295, -0.591670, 0.075670>, <-0.195117, -0.586867, 0.044745>, <-0.200214, -0.580462, 0.003511>, <-0.204036, -0.575659, -0.027415>, 
      <-0.053333, -0.484745, 0.075429>, <-0.057155, -0.479942, 0.044504>, <-0.062252, -0.473537, 0.003269>, <-0.066074, -0.468734, -0.027656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.772813, -0.740973, 0.102091>, <-0.776636, -0.736170, 0.071165>, <-0.793820, -0.754488, 0.006355>, <-0.785555, -0.724962, -0.000995>, 
      <-0.732375, -0.777744, 0.096279>, <-0.736197, -0.772940, 0.065353>, <-0.753381, -0.791258, 0.000543>, <-0.745116, -0.761733, -0.006807>, 
      <-0.647643, -0.712439, 0.096100>, <-0.651465, -0.707635, 0.065174>, <-0.660764, -0.725359, 0.005540>, <-0.660385, -0.696427, -0.006984>, 
      <-0.595895, -0.694010, 0.094182>, <-0.599718, -0.689206, 0.063257>, <-0.609016, -0.706930, 0.003622>, <-0.608637, -0.677998, -0.008902>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.838790, -0.473147, 0.129092>, <-0.842612, -0.468344, 0.098166>, <-0.847708, -0.461939, 0.056932>, <-0.851530, -0.457136, 0.026006>, 
      <-0.818997, -0.553495, 0.120992>, <-0.822819, -0.548692, 0.090066>, <-0.827916, -0.542287, 0.048832>, <-0.831738, -0.537484, 0.017906>, 
      <-0.833985, -0.685350, 0.110883>, <-0.837807, -0.680547, 0.079957>, <-0.854991, -0.698865, 0.015146>, <-0.846726, -0.669339, 0.007796>, 
      <-0.772813, -0.740973, 0.102091>, <-0.776636, -0.736170, 0.071165>, <-0.793820, -0.754488, 0.006355>, <-0.785555, -0.724962, -0.000995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.724496, -0.524958, 0.117058>, <-0.728318, -0.520154, 0.086133>, <-0.733413, -0.513750, 0.044899>, <-0.737235, -0.508946, 0.013973>, 
      <-0.760733, -0.535676, 0.118585>, <-0.764554, -0.530873, 0.087660>, <-0.769650, -0.524468, 0.046425>, <-0.773472, -0.519664, 0.015500>, 
      <-0.804502, -0.488690, 0.125482>, <-0.808324, -0.483887, 0.094556>, <-0.813419, -0.477482, 0.053322>, <-0.817241, -0.472679, 0.022396>, 
      <-0.838790, -0.473147, 0.129092>, <-0.842612, -0.468344, 0.098166>, <-0.847708, -0.461939, 0.056932>, <-0.851530, -0.457136, 0.026006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.666349, -0.422142, 0.121824>, <-0.670171, -0.417339, 0.090899>, <-0.668284, -0.378683, 0.029872>, <-0.679089, -0.406131, 0.018740>, 
      <-0.683793, -0.452987, 0.120394>, <-0.687615, -0.448184, 0.089469>, <-0.685728, -0.409528, 0.028442>, <-0.696533, -0.436976, 0.017310>, 
      <-0.690515, -0.514907, 0.115626>, <-0.694337, -0.510104, 0.084700>, <-0.699433, -0.503699, 0.043467>, <-0.703255, -0.498895, 0.012541>, 
      <-0.724496, -0.524958, 0.117058>, <-0.728318, -0.520154, 0.086133>, <-0.733413, -0.513750, 0.044899>, <-0.737235, -0.508946, 0.013973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.666349, -0.422142, 0.121824>, <-0.640589, -0.447326, 0.117974>, <-0.616108, -0.512408, 0.110846>, <-0.580481, -0.506089, 0.108989>, 
      <-0.670171, -0.417339, 0.090899>, <-0.644411, -0.442523, 0.087048>, <-0.619930, -0.507605, 0.079920>, <-0.584303, -0.501285, 0.078063>, 
      <-0.668284, -0.378683, 0.029872>, <-0.642524, -0.403867, 0.026021>, <-0.624628, -0.470628, 0.025431>, <-0.589002, -0.464309, 0.023574>, 
      <-0.679089, -0.406131, 0.018740>, <-0.653329, -0.431315, 0.014889>, <-0.628849, -0.496396, 0.007760>, <-0.593222, -0.490077, 0.005903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.692236, -0.876460, 0.284477>, <-0.743984, -0.894889, 0.286395>, <-0.828715, -0.960194, 0.286572>, <-0.869153, -0.923424, 0.292384>, 
      <-0.691553, -0.824393, 0.261938>, <-0.743301, -0.842822, 0.263856>, <-0.802237, -0.865599, 0.263025>, <-0.842675, -0.828828, 0.268837>, 
      <-0.684416, -0.734912, 0.267481>, <-0.720043, -0.741231, 0.269338>, <-0.771546, -0.717717, 0.272601>, <-0.797307, -0.692533, 0.276452>, 
      <-0.676821, -0.688539, 0.299282>, <-0.712448, -0.694858, 0.301139>, <-0.736929, -0.629777, 0.308268>, <-0.762689, -0.604593, 0.312119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.149673, -0.667196, 0.265723>, <-0.287635, -0.774121, 0.265964>, <-0.527905, -0.817937, 0.278388>, <-0.692236, -0.876460, 0.284477>, 
      <-0.108455, -0.635251, 0.265651>, <-0.246417, -0.742175, 0.265892>, <-0.527223, -0.765870, 0.255849>, <-0.691553, -0.824393, 0.261938>, 
      <-0.164439, -0.505600, 0.280336>, <-0.312479, -0.511593, 0.289760>, <-0.538429, -0.709018, 0.259871>, <-0.684416, -0.734912, 0.267481>, 
      <-0.216440, -0.507705, 0.283646>, <-0.364480, -0.513699, 0.293070>, <-0.530834, -0.662645, 0.291673>, <-0.676821, -0.688539, 0.299282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.820835, -0.707408, 0.307352>, <-0.786855, -0.697357, 0.305920>, <-0.780133, -0.635437, 0.310689>, <-0.762689, -0.604593, 0.312119>, 
      <-0.857071, -0.718126, 0.308879>, <-0.823091, -0.708075, 0.307447>, <-0.814751, -0.723377, 0.275022>, <-0.797307, -0.692533, 0.276452>, 
      <-0.900841, -0.671141, 0.315775>, <-0.881048, -0.751489, 0.307675>, <-0.903847, -0.773205, 0.277628>, <-0.842675, -0.828828, 0.268837>, 
      <-0.935129, -0.655598, 0.319385>, <-0.915336, -0.735946, 0.311285>, <-0.930324, -0.867801, 0.301175>, <-0.869153, -0.923424, 0.292384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.203700, -0.523717, 0.386730>, <-0.207522, -0.518913, 0.355805>, <-0.212618, -0.512509, 0.314571>, <-0.216440, -0.507705, 0.283646>, 
      <-0.351740, -0.529711, 0.396155>, <-0.355562, -0.524907, 0.365229>, <-0.360658, -0.518502, 0.323996>, <-0.364480, -0.513699, 0.293070>, 
      <-0.518093, -0.678658, 0.394759>, <-0.521915, -0.673854, 0.363833>, <-0.526613, -0.636877, 0.309344>, <-0.530834, -0.662645, 0.291673>, 
      <-0.664080, -0.704551, 0.402368>, <-0.667902, -0.699747, 0.371442>, <-0.672601, -0.662771, 0.316953>, <-0.676821, -0.688539, 0.299282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.136932, -0.683207, 0.368808>, <-0.140754, -0.678404, 0.337882>, <-0.145851, -0.671999, 0.296648>, <-0.149673, -0.667196, 0.265723>, 
      <-0.095714, -0.651262, 0.368736>, <-0.099536, -0.646458, 0.337811>, <-0.104632, -0.640054, 0.296577>, <-0.108455, -0.635251, 0.265651>, 
      <-0.151699, -0.521612, 0.383420>, <-0.155521, -0.516808, 0.352494>, <-0.160617, -0.510403, 0.311261>, <-0.164439, -0.505600, 0.280336>, 
      <-0.203700, -0.523717, 0.386730>, <-0.207522, -0.518913, 0.355805>, <-0.212618, -0.512509, 0.314571>, <-0.216440, -0.507705, 0.283646>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.679495, -0.892472, 0.387561>, <-0.683317, -0.887668, 0.356636>, <-0.692615, -0.905392, 0.297001>, <-0.692236, -0.876460, 0.284477>, 
      <-0.515164, -0.833949, 0.381471>, <-0.518987, -0.829145, 0.350546>, <-0.528285, -0.846869, 0.290912>, <-0.527905, -0.817937, 0.278388>, 
      <-0.274894, -0.790132, 0.369049>, <-0.278717, -0.785329, 0.338124>, <-0.283813, -0.778924, 0.296889>, <-0.287635, -0.774121, 0.265964>, 
      <-0.136932, -0.683207, 0.368808>, <-0.140754, -0.678404, 0.337882>, <-0.145851, -0.671999, 0.296648>, <-0.149673, -0.667196, 0.265723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.856413, -0.939435, 0.395470>, <-0.860235, -0.934632, 0.364544>, <-0.877417, -0.952950, 0.299734>, <-0.869153, -0.923424, 0.292384>, 
      <-0.815975, -0.976206, 0.389658>, <-0.819797, -0.971402, 0.358732>, <-0.836979, -0.989720, 0.293922>, <-0.828715, -0.960194, 0.286572>, 
      <-0.731243, -0.910901, 0.389479>, <-0.735065, -0.906097, 0.358553>, <-0.744363, -0.923821, 0.298919>, <-0.743984, -0.894889, 0.286395>, 
      <-0.679495, -0.892472, 0.387561>, <-0.683317, -0.887668, 0.356636>, <-0.692615, -0.905392, 0.297001>, <-0.692236, -0.876460, 0.284477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.922388, -0.671609, 0.422471>, <-0.926210, -0.666806, 0.391545>, <-0.931307, -0.660401, 0.350311>, <-0.935129, -0.655598, 0.319385>, 
      <-0.902596, -0.751957, 0.414371>, <-0.906418, -0.747154, 0.383445>, <-0.911514, -0.740749, 0.342210>, <-0.915336, -0.735946, 0.311285>, 
      <-0.917584, -0.883812, 0.404262>, <-0.921406, -0.879009, 0.373336>, <-0.938589, -0.897327, 0.308525>, <-0.930324, -0.867801, 0.301175>, 
      <-0.856413, -0.939435, 0.395470>, <-0.860235, -0.934632, 0.364544>, <-0.877417, -0.952950, 0.299734>, <-0.869153, -0.923424, 0.292384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.808095, -0.723420, 0.410437>, <-0.811917, -0.718616, 0.379512>, <-0.817013, -0.712212, 0.338278>, <-0.820835, -0.707408, 0.307352>, 
      <-0.844331, -0.734138, 0.411964>, <-0.848153, -0.729335, 0.381039>, <-0.853249, -0.722930, 0.339804>, <-0.857071, -0.718126, 0.308879>, 
      <-0.888100, -0.687152, 0.418861>, <-0.891922, -0.682349, 0.387935>, <-0.897019, -0.675944, 0.346701>, <-0.900841, -0.671141, 0.315775>, 
      <-0.922388, -0.671609, 0.422471>, <-0.926210, -0.666806, 0.391545>, <-0.931307, -0.660401, 0.350311>, <-0.935129, -0.655598, 0.319385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.749947, -0.620604, 0.415203>, <-0.753770, -0.615801, 0.384278>, <-0.751884, -0.577145, 0.323251>, <-0.762689, -0.604593, 0.312119>, 
      <-0.767391, -0.651449, 0.413773>, <-0.771214, -0.646645, 0.382848>, <-0.769328, -0.607990, 0.321821>, <-0.780133, -0.635437, 0.310689>, 
      <-0.774114, -0.713369, 0.409005>, <-0.777936, -0.708566, 0.378079>, <-0.783033, -0.702161, 0.336846>, <-0.786855, -0.697357, 0.305920>, 
      <-0.808095, -0.723420, 0.410437>, <-0.811917, -0.718616, 0.379512>, <-0.817013, -0.712212, 0.338278>, <-0.820835, -0.707408, 0.307352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.749947, -0.620604, 0.415203>, <-0.724187, -0.645788, 0.411353>, <-0.699707, -0.710870, 0.404225>, <-0.664080, -0.704551, 0.402368>, 
      <-0.753770, -0.615801, 0.384278>, <-0.728009, -0.640985, 0.380427>, <-0.703529, -0.706067, 0.373299>, <-0.667902, -0.699747, 0.371442>, 
      <-0.751884, -0.577145, 0.323251>, <-0.726124, -0.602329, 0.319400>, <-0.708228, -0.669090, 0.318810>, <-0.672601, -0.662771, 0.316953>, 
      <-0.762689, -0.604593, 0.312119>, <-0.736929, -0.629777, 0.308268>, <-0.712448, -0.694858, 0.301139>, <-0.676821, -0.688539, 0.299282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.758848, -1.084580, 0.547834>, <-0.810596, -1.103009, 0.549751>, <-0.895327, -1.168315, 0.549929>, <-0.935765, -1.131544, 0.555741>, 
      <-0.758165, -1.032513, 0.525296>, <-0.809913, -1.050942, 0.527213>, <-0.868849, -1.073719, 0.526382>, <-0.909287, -1.036948, 0.532194>, 
      <-0.751028, -0.943032, 0.530839>, <-0.786655, -0.949351, 0.532696>, <-0.838158, -0.925837, 0.535958>, <-0.863919, -0.900653, 0.539809>, 
      <-0.743433, -0.896659, 0.562640>, <-0.779060, -0.902978, 0.564497>, <-0.803541, -0.837897, 0.571625>, <-0.829301, -0.812713, 0.575476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.216284, -0.875315, 0.529080>, <-0.354247, -0.982240, 0.529321>, <-0.594517, -1.026057, 0.541745>, <-0.758848, -1.084580, 0.547834>, 
      <-0.175066, -0.843370, 0.529008>, <-0.313029, -0.950295, 0.529249>, <-0.593834, -0.973990, 0.519206>, <-0.758165, -1.032513, 0.525296>, 
      <-0.231052, -0.713720, 0.543693>, <-0.379092, -0.719715, 0.553117>, <-0.605041, -0.917138, 0.523230>, <-0.751028, -0.943032, 0.530839>, 
      <-0.283052, -0.715826, 0.547003>, <-0.431092, -0.721820, 0.556428>, <-0.597446, -0.870766, 0.555030>, <-0.743433, -0.896659, 0.562640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.887446, -0.915528, 0.570709>, <-0.853466, -0.905477, 0.569277>, <-0.846745, -0.843557, 0.574046>, <-0.829301, -0.812713, 0.575476>, 
      <-0.923683, -0.926246, 0.572236>, <-0.889703, -0.916196, 0.570804>, <-0.881362, -0.931497, 0.538379>, <-0.863919, -0.900653, 0.539809>, 
      <-0.967452, -0.879260, 0.579133>, <-0.947659, -0.959608, 0.571032>, <-0.970459, -0.981325, 0.540986>, <-0.909287, -1.036948, 0.532194>, 
      <-1.001740, -0.863717, 0.582743>, <-0.981947, -0.944065, 0.574642>, <-0.996936, -1.075921, 0.564533>, <-0.935765, -1.131544, 0.555741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.270312, -0.731838, 0.650088>, <-0.274134, -0.727034, 0.619162>, <-0.279230, -0.720630, 0.577928>, <-0.283052, -0.715826, 0.547003>, 
      <-0.418352, -0.737832, 0.659513>, <-0.422174, -0.733028, 0.628587>, <-0.427270, -0.726624, 0.587353>, <-0.431092, -0.721820, 0.556428>, 
      <-0.584705, -0.886777, 0.658116>, <-0.588527, -0.881973, 0.627190>, <-0.593225, -0.844997, 0.572701>, <-0.597446, -0.870766, 0.555030>, 
      <-0.730692, -0.912670, 0.665725>, <-0.734514, -0.907867, 0.634799>, <-0.739213, -0.870891, 0.580311>, <-0.743433, -0.896659, 0.562640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.203543, -0.891326, 0.632165>, <-0.207365, -0.886523, 0.601240>, <-0.212462, -0.880118, 0.560006>, <-0.216284, -0.875315, 0.529080>, 
      <-0.162325, -0.859381, 0.632093>, <-0.166147, -0.854578, 0.601168>, <-0.171243, -0.848173, 0.559933>, <-0.175066, -0.843370, 0.529008>, 
      <-0.218312, -0.729733, 0.646778>, <-0.222134, -0.724929, 0.615852>, <-0.227230, -0.718524, 0.574618>, <-0.231052, -0.713720, 0.543693>, 
      <-0.270312, -0.731838, 0.650088>, <-0.274134, -0.727034, 0.619162>, <-0.279230, -0.720630, 0.577928>, <-0.283052, -0.715826, 0.547003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.746108, -1.100592, 0.650918>, <-0.749930, -1.095788, 0.619993>, <-0.759228, -1.113512, 0.560358>, <-0.758848, -1.084580, 0.547834>, 
      <-0.581777, -1.042069, 0.644829>, <-0.585599, -1.037265, 0.613903>, <-0.594897, -1.054989, 0.554269>, <-0.594517, -1.026057, 0.541745>, 
      <-0.341506, -0.998251, 0.632406>, <-0.345329, -0.993448, 0.601480>, <-0.350425, -0.987043, 0.560246>, <-0.354247, -0.982240, 0.529321>, 
      <-0.203543, -0.891326, 0.632165>, <-0.207365, -0.886523, 0.601240>, <-0.212462, -0.880118, 0.560006>, <-0.216284, -0.875315, 0.529080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.923024, -1.147555, 0.658826>, <-0.926846, -1.142752, 0.627900>, <-0.944029, -1.161070, 0.563091>, <-0.935765, -1.131544, 0.555741>, 
      <-0.882586, -1.184325, 0.653014>, <-0.886408, -1.179522, 0.622089>, <-0.903591, -1.197840, 0.557279>, <-0.895327, -1.168315, 0.549929>, 
      <-0.797855, -1.119021, 0.652836>, <-0.801677, -1.114217, 0.621910>, <-0.810975, -1.131941, 0.562276>, <-0.810596, -1.103009, 0.549751>, 
      <-0.746108, -1.100592, 0.650918>, <-0.749930, -1.095788, 0.619993>, <-0.759228, -1.113512, 0.560358>, <-0.758848, -1.084580, 0.547834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.989000, -0.879729, 0.685828>, <-0.992822, -0.874925, 0.654903>, <-0.997918, -0.868521, 0.613668>, <-1.001740, -0.863717, 0.582743>, 
      <-0.969207, -0.960077, 0.677727>, <-0.973029, -0.955273, 0.646802>, <-0.978125, -0.948869, 0.605568>, <-0.981947, -0.944065, 0.574642>, 
      <-0.984195, -1.091932, 0.667618>, <-0.988017, -1.087128, 0.636692>, <-1.005201, -1.105446, 0.571882>, <-0.996936, -1.075921, 0.564533>, 
      <-0.923024, -1.147555, 0.658826>, <-0.926846, -1.142752, 0.627900>, <-0.944029, -1.161070, 0.563091>, <-0.935765, -1.131544, 0.555741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.874706, -0.931540, 0.673794>, <-0.878528, -0.926736, 0.642868>, <-0.883624, -0.920332, 0.601634>, <-0.887446, -0.915528, 0.570709>, 
      <-0.910943, -0.942258, 0.675321>, <-0.914765, -0.937455, 0.644396>, <-0.919861, -0.931050, 0.603162>, <-0.923683, -0.926246, 0.572236>, 
      <-0.954712, -0.895272, 0.682218>, <-0.958534, -0.890469, 0.651292>, <-0.963630, -0.884064, 0.610058>, <-0.967452, -0.879260, 0.579133>, 
      <-0.989000, -0.879729, 0.685828>, <-0.992822, -0.874925, 0.654903>, <-0.997918, -0.868521, 0.613668>, <-1.001740, -0.863717, 0.582743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.816559, -0.828724, 0.678560>, <-0.820382, -0.823921, 0.647635>, <-0.818496, -0.785265, 0.586608>, <-0.829301, -0.812713, 0.575476>, 
      <-0.834003, -0.859569, 0.677130>, <-0.837826, -0.854765, 0.646205>, <-0.835940, -0.816110, 0.585178>, <-0.846745, -0.843557, 0.574046>, 
      <-0.840726, -0.921489, 0.672362>, <-0.844548, -0.916686, 0.641436>, <-0.849644, -0.910281, 0.600202>, <-0.853466, -0.905477, 0.569277>, 
      <-0.874706, -0.931540, 0.673794>, <-0.878528, -0.926736, 0.642868>, <-0.883624, -0.920332, 0.601634>, <-0.887446, -0.915528, 0.570709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.816559, -0.828724, 0.678560>, <-0.790799, -0.853908, 0.674709>, <-0.766319, -0.918989, 0.667582>, <-0.730692, -0.912670, 0.665725>, 
      <-0.820382, -0.823921, 0.647635>, <-0.794622, -0.849105, 0.643784>, <-0.770141, -0.914186, 0.636656>, <-0.734514, -0.907867, 0.634799>, 
      <-0.818496, -0.785265, 0.586608>, <-0.792736, -0.810449, 0.582758>, <-0.774840, -0.877210, 0.582168>, <-0.739213, -0.870891, 0.580311>, 
      <-0.829301, -0.812713, 0.575476>, <-0.803541, -0.837897, 0.571625>, <-0.779060, -0.902978, 0.564497>, <-0.743433, -0.896659, 0.562640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.758848, -1.084580, 0.547834>, <-0.810596, -1.103009, 0.549751>, <-0.895327, -1.168315, 0.549929>, <-0.935765, -1.131544, 0.555741>, 
      <-0.758165, -1.032513, 0.525296>, <-0.809913, -1.050942, 0.527213>, <-0.868849, -1.073719, 0.526382>, <-0.909287, -1.036948, 0.532194>, 
      <-0.751028, -0.943032, 0.530839>, <-0.786655, -0.949351, 0.532696>, <-0.838158, -0.925837, 0.535958>, <-0.863919, -0.900653, 0.539809>, 
      <-0.743433, -0.896659, 0.562640>, <-0.779060, -0.902978, 0.564497>, <-0.803541, -0.837897, 0.571625>, <-0.829301, -0.812713, 0.575476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.216284, -0.875315, 0.529080>, <-0.354247, -0.982240, 0.529321>, <-0.594517, -1.026057, 0.541745>, <-0.758848, -1.084580, 0.547834>, 
      <-0.175066, -0.843370, 0.529008>, <-0.313029, -0.950295, 0.529249>, <-0.593834, -0.973990, 0.519206>, <-0.758165, -1.032513, 0.525296>, 
      <-0.231052, -0.713720, 0.543693>, <-0.379092, -0.719715, 0.553117>, <-0.605041, -0.917138, 0.523230>, <-0.751028, -0.943032, 0.530839>, 
      <-0.283052, -0.715826, 0.547003>, <-0.431092, -0.721820, 0.556428>, <-0.597446, -0.870766, 0.555030>, <-0.743433, -0.896659, 0.562640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.887446, -0.915528, 0.570709>, <-0.853466, -0.905477, 0.569277>, <-0.846745, -0.843557, 0.574046>, <-0.829301, -0.812713, 0.575476>, 
      <-0.923683, -0.926246, 0.572236>, <-0.889703, -0.916196, 0.570804>, <-0.881362, -0.931497, 0.538379>, <-0.863919, -0.900653, 0.539809>, 
      <-0.967452, -0.879260, 0.579133>, <-0.947659, -0.959608, 0.571032>, <-0.970459, -0.981325, 0.540986>, <-0.909287, -1.036948, 0.532194>, 
      <-1.001740, -0.863717, 0.582743>, <-0.981947, -0.944065, 0.574642>, <-0.996936, -1.075921, 0.564533>, <-0.935765, -1.131544, 0.555741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.270312, -0.731838, 0.650088>, <-0.274134, -0.727034, 0.619162>, <-0.279230, -0.720630, 0.577928>, <-0.283052, -0.715826, 0.547003>, 
      <-0.418352, -0.737832, 0.659513>, <-0.422174, -0.733028, 0.628587>, <-0.427270, -0.726624, 0.587353>, <-0.431092, -0.721820, 0.556428>, 
      <-0.584705, -0.886777, 0.658116>, <-0.588527, -0.881973, 0.627190>, <-0.593225, -0.844997, 0.572701>, <-0.597446, -0.870766, 0.555030>, 
      <-0.730692, -0.912670, 0.665725>, <-0.734514, -0.907867, 0.634799>, <-0.739213, -0.870891, 0.580311>, <-0.743433, -0.896659, 0.562640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.203543, -0.891326, 0.632165>, <-0.207365, -0.886523, 0.601240>, <-0.212462, -0.880118, 0.560006>, <-0.216284, -0.875315, 0.529080>, 
      <-0.162325, -0.859381, 0.632093>, <-0.166147, -0.854578, 0.601168>, <-0.171243, -0.848173, 0.559933>, <-0.175066, -0.843370, 0.529008>, 
      <-0.218312, -0.729733, 0.646778>, <-0.222134, -0.724929, 0.615852>, <-0.227230, -0.718524, 0.574618>, <-0.231052, -0.713720, 0.543693>, 
      <-0.270312, -0.731838, 0.650088>, <-0.274134, -0.727034, 0.619162>, <-0.279230, -0.720630, 0.577928>, <-0.283052, -0.715826, 0.547003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.746108, -1.100592, 0.650918>, <-0.749930, -1.095788, 0.619993>, <-0.759228, -1.113512, 0.560358>, <-0.758848, -1.084580, 0.547834>, 
      <-0.581777, -1.042069, 0.644829>, <-0.585599, -1.037265, 0.613903>, <-0.594897, -1.054989, 0.554269>, <-0.594517, -1.026057, 0.541745>, 
      <-0.341506, -0.998251, 0.632406>, <-0.345329, -0.993448, 0.601480>, <-0.350425, -0.987043, 0.560246>, <-0.354247, -0.982240, 0.529321>, 
      <-0.203543, -0.891326, 0.632165>, <-0.207365, -0.886523, 0.601240>, <-0.212462, -0.880118, 0.560006>, <-0.216284, -0.875315, 0.529080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.923024, -1.147555, 0.658826>, <-0.926846, -1.142752, 0.627900>, <-0.944029, -1.161070, 0.563091>, <-0.935765, -1.131544, 0.555741>, 
      <-0.882586, -1.184325, 0.653014>, <-0.886408, -1.179522, 0.622089>, <-0.903591, -1.197840, 0.557279>, <-0.895327, -1.168315, 0.549929>, 
      <-0.797855, -1.119021, 0.652836>, <-0.801677, -1.114217, 0.621910>, <-0.810975, -1.131941, 0.562276>, <-0.810596, -1.103009, 0.549751>, 
      <-0.746108, -1.100592, 0.650918>, <-0.749930, -1.095788, 0.619993>, <-0.759228, -1.113512, 0.560358>, <-0.758848, -1.084580, 0.547834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.989000, -0.879729, 0.685828>, <-0.992822, -0.874925, 0.654903>, <-0.997918, -0.868521, 0.613668>, <-1.001740, -0.863717, 0.582743>, 
      <-0.969207, -0.960077, 0.677727>, <-0.973029, -0.955273, 0.646802>, <-0.978125, -0.948869, 0.605568>, <-0.981947, -0.944065, 0.574642>, 
      <-0.984195, -1.091932, 0.667618>, <-0.988017, -1.087128, 0.636692>, <-1.005201, -1.105446, 0.571882>, <-0.996936, -1.075921, 0.564533>, 
      <-0.923024, -1.147555, 0.658826>, <-0.926846, -1.142752, 0.627900>, <-0.944029, -1.161070, 0.563091>, <-0.935765, -1.131544, 0.555741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.874706, -0.931540, 0.673794>, <-0.878528, -0.926736, 0.642868>, <-0.883624, -0.920332, 0.601634>, <-0.887446, -0.915528, 0.570709>, 
      <-0.910943, -0.942258, 0.675321>, <-0.914765, -0.937455, 0.644396>, <-0.919861, -0.931050, 0.603162>, <-0.923683, -0.926246, 0.572236>, 
      <-0.954712, -0.895272, 0.682218>, <-0.958534, -0.890469, 0.651292>, <-0.963630, -0.884064, 0.610058>, <-0.967452, -0.879260, 0.579133>, 
      <-0.989000, -0.879729, 0.685828>, <-0.992822, -0.874925, 0.654903>, <-0.997918, -0.868521, 0.613668>, <-1.001740, -0.863717, 0.582743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.816559, -0.828724, 0.678560>, <-0.820382, -0.823921, 0.647635>, <-0.818496, -0.785265, 0.586608>, <-0.829301, -0.812713, 0.575476>, 
      <-0.834003, -0.859569, 0.677130>, <-0.837826, -0.854765, 0.646205>, <-0.835940, -0.816110, 0.585178>, <-0.846745, -0.843557, 0.574046>, 
      <-0.840726, -0.921489, 0.672362>, <-0.844548, -0.916686, 0.641436>, <-0.849644, -0.910281, 0.600202>, <-0.853466, -0.905477, 0.569277>, 
      <-0.874706, -0.931540, 0.673794>, <-0.878528, -0.926736, 0.642868>, <-0.883624, -0.920332, 0.601634>, <-0.887446, -0.915528, 0.570709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.816559, -0.828724, 0.678560>, <-0.790799, -0.853908, 0.674709>, <-0.766319, -0.918989, 0.667582>, <-0.730692, -0.912670, 0.665725>, 
      <-0.820382, -0.823921, 0.647635>, <-0.794622, -0.849105, 0.643784>, <-0.770141, -0.914186, 0.636656>, <-0.734514, -0.907867, 0.634799>, 
      <-0.818496, -0.785265, 0.586608>, <-0.792736, -0.810449, 0.582758>, <-0.774840, -0.877210, 0.582168>, <-0.739213, -0.870891, 0.580311>, 
      <-0.829301, -0.812713, 0.575476>, <-0.803541, -0.837897, 0.571625>, <-0.779060, -0.902978, 0.564497>, <-0.743433, -0.896659, 0.562640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.891103, -0.677998, -0.008902>, <1.942851, -0.696427, -0.006984>, <2.027583, -0.761733, -0.006807>, <2.068021, -0.724962, -0.000995>, 
      <1.890421, -0.625931, -0.031441>, <1.942168, -0.644360, -0.029523>, <2.001105, -0.667137, -0.030354>, <2.041543, -0.630366, -0.024542>, 
      <1.883283, -0.536450, -0.025898>, <1.918910, -0.542769, -0.024041>, <1.970413, -0.519255, -0.020778>, <1.996173, -0.494071, -0.016927>, 
      <1.875688, -0.490077, 0.005903>, <1.911315, -0.496396, 0.007760>, <1.935795, -0.431315, 0.014889>, <1.961555, -0.406131, 0.018740>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.348540, -0.468734, -0.027656>, <1.486502, -0.575659, -0.027415>, <1.726772, -0.619475, -0.014991>, <1.891103, -0.677998, -0.008902>, 
      <1.307321, -0.436789, -0.027728>, <1.445284, -0.543713, -0.027487>, <1.726090, -0.567408, -0.037530>, <1.890421, -0.625931, -0.031441>, 
      <1.363307, -0.307138, -0.013044>, <1.511347, -0.313131, -0.003619>, <1.737296, -0.510556, -0.033508>, <1.883283, -0.536450, -0.025898>, 
      <1.415308, -0.309243, -0.009733>, <1.563348, -0.315237, -0.000309>, <1.729701, -0.464183, -0.001706>, <1.875688, -0.490077, 0.005903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.019701, -0.508946, 0.013973>, <1.985721, -0.498895, 0.012541>, <1.978999, -0.436976, 0.017310>, <1.961555, -0.406131, 0.018740>, 
      <2.055938, -0.519664, 0.015500>, <2.021958, -0.509614, 0.014068>, <2.013617, -0.524916, -0.018357>, <1.996173, -0.494071, -0.016927>, 
      <2.099708, -0.472679, 0.022396>, <2.079915, -0.553027, 0.014296>, <2.102714, -0.574743, -0.015751>, <2.041543, -0.630366, -0.024542>, 
      <2.133996, -0.457136, 0.026006>, <2.114203, -0.537484, 0.017906>, <2.129192, -0.669339, 0.007796>, <2.068021, -0.724962, -0.000995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.402567, -0.325255, 0.093351>, <1.406389, -0.320451, 0.062426>, <1.411486, -0.314047, 0.021192>, <1.415308, -0.309243, -0.009733>, 
      <1.550607, -0.331249, 0.102776>, <1.554429, -0.326446, 0.071850>, <1.559526, -0.320040, 0.030617>, <1.563348, -0.315237, -0.000309>, 
      <1.716960, -0.480196, 0.101380>, <1.720782, -0.475392, 0.070454>, <1.725481, -0.438415, 0.015965>, <1.729701, -0.464183, -0.001706>, 
      <1.862947, -0.506089, 0.108989>, <1.866769, -0.501285, 0.078063>, <1.871467, -0.464309, 0.023574>, <1.875688, -0.490077, 0.005903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.335799, -0.484745, 0.075429>, <1.339621, -0.479942, 0.044504>, <1.344718, -0.473537, 0.003269>, <1.348540, -0.468734, -0.027656>, 
      <1.294581, -0.452800, 0.075357>, <1.298403, -0.447996, 0.044431>, <1.303499, -0.441592, 0.003197>, <1.307321, -0.436789, -0.027728>, 
      <1.350566, -0.323149, 0.090040>, <1.354389, -0.318346, 0.059115>, <1.359485, -0.311941, 0.017882>, <1.363307, -0.307138, -0.013044>, 
      <1.402567, -0.325255, 0.093351>, <1.406389, -0.320451, 0.062426>, <1.411486, -0.314047, 0.021192>, <1.415308, -0.309243, -0.009733>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.878361, -0.694010, 0.094182>, <1.882184, -0.689206, 0.063257>, <1.891482, -0.706930, 0.003622>, <1.891103, -0.677998, -0.008902>, 
      <1.714031, -0.635487, 0.088092>, <1.717853, -0.630683, 0.057167>, <1.727152, -0.648407, -0.002467>, <1.726772, -0.619475, -0.014991>, 
      <1.473761, -0.591670, 0.075670>, <1.477583, -0.586867, 0.044745>, <1.482680, -0.580462, 0.003511>, <1.486502, -0.575659, -0.027415>, 
      <1.335799, -0.484745, 0.075429>, <1.339621, -0.479942, 0.044504>, <1.344718, -0.473537, 0.003269>, <1.348540, -0.468734, -0.027656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.055279, -0.740973, 0.102091>, <2.059102, -0.736170, 0.071165>, <2.076285, -0.754488, 0.006355>, <2.068021, -0.724962, -0.000995>, 
      <2.014840, -0.777744, 0.096279>, <2.018663, -0.772940, 0.065353>, <2.035847, -0.791258, 0.000543>, <2.027583, -0.761733, -0.006807>, 
      <1.930109, -0.712439, 0.096100>, <1.933931, -0.707635, 0.065174>, <1.943230, -0.725359, 0.005540>, <1.942851, -0.696427, -0.006984>, 
      <1.878361, -0.694010, 0.094182>, <1.882184, -0.689206, 0.063257>, <1.891482, -0.706930, 0.003622>, <1.891103, -0.677998, -0.008902>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.121256, -0.473147, 0.129092>, <2.125078, -0.468344, 0.098166>, <2.130174, -0.461939, 0.056932>, <2.133996, -0.457136, 0.026006>, 
      <2.101463, -0.553495, 0.120992>, <2.105285, -0.548692, 0.090066>, <2.110381, -0.542287, 0.048832>, <2.114203, -0.537484, 0.017906>, 
      <2.116451, -0.685350, 0.110883>, <2.120273, -0.680547, 0.079957>, <2.137457, -0.698865, 0.015146>, <2.129192, -0.669339, 0.007796>, 
      <2.055279, -0.740973, 0.102091>, <2.059102, -0.736170, 0.071165>, <2.076285, -0.754488, 0.006355>, <2.068021, -0.724962, -0.000995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.006962, -0.524958, 0.117058>, <2.010784, -0.520154, 0.086133>, <2.015879, -0.513750, 0.044899>, <2.019701, -0.508946, 0.013973>, 
      <2.043199, -0.535676, 0.118585>, <2.047020, -0.530873, 0.087660>, <2.052116, -0.524468, 0.046425>, <2.055938, -0.519664, 0.015500>, 
      <2.086968, -0.488690, 0.125482>, <2.090790, -0.483887, 0.094556>, <2.095886, -0.477482, 0.053322>, <2.099708, -0.472679, 0.022396>, 
      <2.121256, -0.473147, 0.129092>, <2.125078, -0.468344, 0.098166>, <2.130174, -0.461939, 0.056932>, <2.133996, -0.457136, 0.026006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.948815, -0.422142, 0.121824>, <1.952637, -0.417339, 0.090899>, <1.950750, -0.378683, 0.029872>, <1.961555, -0.406131, 0.018740>, 
      <1.966259, -0.452987, 0.120394>, <1.970081, -0.448184, 0.089469>, <1.968194, -0.409528, 0.028442>, <1.978999, -0.436976, 0.017310>, 
      <1.972982, -0.514907, 0.115626>, <1.976803, -0.510104, 0.084700>, <1.981899, -0.503699, 0.043467>, <1.985721, -0.498895, 0.012541>, 
      <2.006962, -0.524958, 0.117058>, <2.010784, -0.520154, 0.086133>, <2.015879, -0.513750, 0.044899>, <2.019701, -0.508946, 0.013973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.948815, -0.422142, 0.121824>, <1.923055, -0.447326, 0.117974>, <1.898574, -0.512408, 0.110846>, <1.862947, -0.506089, 0.108989>, 
      <1.952637, -0.417339, 0.090899>, <1.926877, -0.442523, 0.087048>, <1.902396, -0.507605, 0.079920>, <1.866769, -0.501285, 0.078063>, 
      <1.950750, -0.378683, 0.029872>, <1.924990, -0.403867, 0.026021>, <1.907094, -0.470628, 0.025431>, <1.871467, -0.464309, 0.023574>, 
      <1.961555, -0.406131, 0.018740>, <1.935795, -0.431315, 0.014889>, <1.911315, -0.496396, 0.007760>, <1.875688, -0.490077, 0.005903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.974702, -0.876460, 0.284477>, <2.026449, -0.894889, 0.286395>, <2.111181, -0.960194, 0.286572>, <2.151619, -0.923424, 0.292384>, 
      <1.974019, -0.824393, 0.261938>, <2.025767, -0.842822, 0.263856>, <2.084703, -0.865599, 0.263025>, <2.125141, -0.828828, 0.268837>, 
      <1.966882, -0.734912, 0.267481>, <2.002509, -0.741231, 0.269338>, <2.054013, -0.717717, 0.272601>, <2.079773, -0.692533, 0.276452>, 
      <1.959287, -0.688539, 0.299282>, <1.994914, -0.694858, 0.301139>, <2.019395, -0.629777, 0.308268>, <2.045155, -0.604593, 0.312119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.432139, -0.667196, 0.265723>, <1.570102, -0.774121, 0.265964>, <1.810371, -0.817937, 0.278388>, <1.974702, -0.876460, 0.284477>, 
      <1.390921, -0.635251, 0.265651>, <1.528883, -0.742175, 0.265892>, <1.809689, -0.765870, 0.255849>, <1.974019, -0.824393, 0.261938>, 
      <1.446905, -0.505600, 0.280336>, <1.594945, -0.511593, 0.289760>, <1.820895, -0.709018, 0.259871>, <1.966882, -0.734912, 0.267481>, 
      <1.498906, -0.507705, 0.283646>, <1.646946, -0.513699, 0.293070>, <1.813300, -0.662645, 0.291673>, <1.959287, -0.688539, 0.299282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.103301, -0.707408, 0.307352>, <2.069321, -0.697357, 0.305920>, <2.062599, -0.635437, 0.310689>, <2.045155, -0.604593, 0.312119>, 
      <2.139538, -0.718126, 0.308879>, <2.105557, -0.708075, 0.307447>, <2.097217, -0.723377, 0.275022>, <2.079773, -0.692533, 0.276452>, 
      <2.183307, -0.671141, 0.315775>, <2.163514, -0.751489, 0.307675>, <2.186312, -0.773205, 0.277628>, <2.125141, -0.828828, 0.268837>, 
      <2.217595, -0.655598, 0.319385>, <2.197802, -0.735946, 0.311285>, <2.212790, -0.867801, 0.301175>, <2.151619, -0.923424, 0.292384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.486166, -0.523717, 0.386730>, <1.489988, -0.518913, 0.355805>, <1.495084, -0.512509, 0.314571>, <1.498906, -0.507705, 0.283646>, 
      <1.634206, -0.529711, 0.396155>, <1.638028, -0.524907, 0.365229>, <1.643124, -0.518502, 0.323996>, <1.646946, -0.513699, 0.293070>, 
      <1.800559, -0.678658, 0.394759>, <1.804381, -0.673854, 0.363833>, <1.809079, -0.636877, 0.309344>, <1.813300, -0.662645, 0.291673>, 
      <1.946546, -0.704551, 0.402368>, <1.950368, -0.699747, 0.371442>, <1.955067, -0.662771, 0.316953>, <1.959287, -0.688539, 0.299282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.419398, -0.683207, 0.368808>, <1.423220, -0.678404, 0.337882>, <1.428317, -0.671999, 0.296648>, <1.432139, -0.667196, 0.265723>, 
      <1.378180, -0.651262, 0.368736>, <1.382002, -0.646458, 0.337811>, <1.387098, -0.640054, 0.296577>, <1.390921, -0.635251, 0.265651>, 
      <1.434165, -0.521612, 0.383420>, <1.437987, -0.516808, 0.352494>, <1.443083, -0.510403, 0.311261>, <1.446905, -0.505600, 0.280336>, 
      <1.486166, -0.523717, 0.386730>, <1.489988, -0.518913, 0.355805>, <1.495084, -0.512509, 0.314571>, <1.498906, -0.507705, 0.283646>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.961961, -0.892472, 0.387561>, <1.965783, -0.887668, 0.356636>, <1.975081, -0.905392, 0.297001>, <1.974702, -0.876460, 0.284477>, 
      <1.797630, -0.833949, 0.381471>, <1.801453, -0.829145, 0.350546>, <1.810751, -0.846869, 0.290912>, <1.810371, -0.817937, 0.278388>, 
      <1.557360, -0.790132, 0.369049>, <1.561183, -0.785329, 0.338124>, <1.566279, -0.778924, 0.296889>, <1.570102, -0.774121, 0.265964>, 
      <1.419398, -0.683207, 0.368808>, <1.423220, -0.678404, 0.337882>, <1.428317, -0.671999, 0.296648>, <1.432139, -0.667196, 0.265723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.138879, -0.939435, 0.395470>, <2.142701, -0.934632, 0.364544>, <2.159883, -0.952950, 0.299734>, <2.151619, -0.923424, 0.292384>, 
      <2.098441, -0.976206, 0.389658>, <2.102263, -0.971402, 0.358732>, <2.119445, -0.989720, 0.293922>, <2.111181, -0.960194, 0.286572>, 
      <2.013709, -0.910901, 0.389479>, <2.017531, -0.906097, 0.358553>, <2.026829, -0.923821, 0.298919>, <2.026449, -0.894889, 0.286395>, 
      <1.961961, -0.892472, 0.387561>, <1.965783, -0.887668, 0.356636>, <1.975081, -0.905392, 0.297001>, <1.974702, -0.876460, 0.284477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.204854, -0.671609, 0.422471>, <2.208676, -0.666806, 0.391545>, <2.213773, -0.660401, 0.350311>, <2.217595, -0.655598, 0.319385>, 
      <2.185061, -0.751957, 0.414371>, <2.188884, -0.747154, 0.383445>, <2.193980, -0.740749, 0.342210>, <2.197802, -0.735946, 0.311285>, 
      <2.200050, -0.883812, 0.404262>, <2.203872, -0.879009, 0.373336>, <2.221055, -0.897327, 0.308525>, <2.212790, -0.867801, 0.301175>, 
      <2.138879, -0.939435, 0.395470>, <2.142701, -0.934632, 0.364544>, <2.159883, -0.952950, 0.299734>, <2.151619, -0.923424, 0.292384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.090561, -0.723420, 0.410437>, <2.094383, -0.718616, 0.379512>, <2.099479, -0.712212, 0.338278>, <2.103301, -0.707408, 0.307352>, 
      <2.126797, -0.734138, 0.411964>, <2.130620, -0.729335, 0.381039>, <2.135715, -0.722930, 0.339804>, <2.139538, -0.718126, 0.308879>, 
      <2.170566, -0.687152, 0.418861>, <2.174388, -0.682349, 0.387935>, <2.179485, -0.675944, 0.346701>, <2.183307, -0.671141, 0.315775>, 
      <2.204854, -0.671609, 0.422471>, <2.208676, -0.666806, 0.391545>, <2.213773, -0.660401, 0.350311>, <2.217595, -0.655598, 0.319385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.032413, -0.620604, 0.415203>, <2.036236, -0.615801, 0.384278>, <2.034350, -0.577145, 0.323251>, <2.045155, -0.604593, 0.312119>, 
      <2.049857, -0.651449, 0.413773>, <2.053680, -0.646645, 0.382848>, <2.051794, -0.607990, 0.321821>, <2.062599, -0.635437, 0.310689>, 
      <2.056580, -0.713369, 0.409005>, <2.060402, -0.708566, 0.378079>, <2.065499, -0.702161, 0.336846>, <2.069321, -0.697357, 0.305920>, 
      <2.090561, -0.723420, 0.410437>, <2.094383, -0.718616, 0.379512>, <2.099479, -0.712212, 0.338278>, <2.103301, -0.707408, 0.307352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.032413, -0.620604, 0.415203>, <2.006653, -0.645788, 0.411353>, <1.982173, -0.710870, 0.404225>, <1.946546, -0.704551, 0.402368>, 
      <2.036236, -0.615801, 0.384278>, <2.010475, -0.640985, 0.380427>, <1.985995, -0.706067, 0.373299>, <1.950368, -0.699747, 0.371442>, 
      <2.034350, -0.577145, 0.323251>, <2.008590, -0.602329, 0.319400>, <1.990693, -0.669090, 0.318810>, <1.955067, -0.662771, 0.316953>, 
      <2.045155, -0.604593, 0.312119>, <2.019395, -0.629777, 0.308268>, <1.994914, -0.694858, 0.301139>, <1.959287, -0.688539, 0.299282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.041314, -1.084580, 0.547834>, <2.093061, -1.103009, 0.549751>, <2.177793, -1.168315, 0.549929>, <2.218231, -1.131544, 0.555741>, 
      <2.040631, -1.032513, 0.525296>, <2.092378, -1.050942, 0.527213>, <2.151315, -1.073719, 0.526382>, <2.191753, -1.036948, 0.532194>, 
      <2.033494, -0.943032, 0.530839>, <2.069121, -0.949351, 0.532696>, <2.120625, -0.925837, 0.535958>, <2.146385, -0.900653, 0.539809>, 
      <2.025899, -0.896659, 0.562640>, <2.061526, -0.902978, 0.564497>, <2.086007, -0.837897, 0.571625>, <2.111767, -0.812713, 0.575476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.498750, -0.875315, 0.529080>, <1.636713, -0.982240, 0.529321>, <1.876983, -1.026057, 0.541745>, <2.041314, -1.084580, 0.547834>, 
      <1.457532, -0.843370, 0.529008>, <1.595495, -0.950295, 0.529249>, <1.876300, -0.973990, 0.519206>, <2.040631, -1.032513, 0.525296>, 
      <1.513518, -0.713720, 0.543693>, <1.661558, -0.719715, 0.553117>, <1.887507, -0.917138, 0.523230>, <2.033494, -0.943032, 0.530839>, 
      <1.565518, -0.715826, 0.547003>, <1.713558, -0.721820, 0.556428>, <1.879912, -0.870766, 0.555030>, <2.025899, -0.896659, 0.562640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.169912, -0.915528, 0.570709>, <2.135932, -0.905477, 0.569277>, <2.129210, -0.843557, 0.574046>, <2.111767, -0.812713, 0.575476>, 
      <2.206149, -0.926246, 0.572236>, <2.172169, -0.916196, 0.570804>, <2.163828, -0.931497, 0.538379>, <2.146385, -0.900653, 0.539809>, 
      <2.249918, -0.879260, 0.579133>, <2.230125, -0.959608, 0.571032>, <2.252925, -0.981325, 0.540986>, <2.191753, -1.036948, 0.532194>, 
      <2.284206, -0.863717, 0.582743>, <2.264413, -0.944065, 0.574642>, <2.279402, -1.075921, 0.564533>, <2.218231, -1.131544, 0.555741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.552778, -0.731838, 0.650088>, <1.556600, -0.727034, 0.619162>, <1.561696, -0.720630, 0.577928>, <1.565518, -0.715826, 0.547003>, 
      <1.700818, -0.737832, 0.659513>, <1.704640, -0.733028, 0.628587>, <1.709736, -0.726624, 0.587353>, <1.713558, -0.721820, 0.556428>, 
      <1.867171, -0.886777, 0.658116>, <1.870994, -0.881973, 0.627190>, <1.875692, -0.844998, 0.572701>, <1.879912, -0.870766, 0.555030>, 
      <2.013158, -0.912670, 0.665725>, <2.016980, -0.907867, 0.634799>, <2.021679, -0.870891, 0.580311>, <2.025899, -0.896659, 0.562640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.486009, -0.891326, 0.632165>, <1.489831, -0.886523, 0.601240>, <1.494928, -0.880118, 0.560006>, <1.498750, -0.875315, 0.529080>, 
      <1.444791, -0.859381, 0.632093>, <1.448613, -0.854578, 0.601168>, <1.453710, -0.848173, 0.559933>, <1.457532, -0.843370, 0.529008>, 
      <1.500778, -0.729733, 0.646778>, <1.504600, -0.724929, 0.615852>, <1.509696, -0.718524, 0.574618>, <1.513518, -0.713720, 0.543693>, 
      <1.552778, -0.731838, 0.650088>, <1.556600, -0.727034, 0.619162>, <1.561696, -0.720630, 0.577928>, <1.565518, -0.715826, 0.547003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.028574, -1.100592, 0.650918>, <2.032396, -1.095788, 0.619993>, <2.041693, -1.113512, 0.560358>, <2.041314, -1.084580, 0.547834>, 
      <1.864243, -1.042069, 0.644829>, <1.868065, -1.037265, 0.613903>, <1.877362, -1.054989, 0.554269>, <1.876983, -1.026057, 0.541745>, 
      <1.623972, -0.998251, 0.632406>, <1.627795, -0.993448, 0.601480>, <1.632891, -0.987043, 0.560246>, <1.636713, -0.982240, 0.529321>, 
      <1.486009, -0.891326, 0.632165>, <1.489831, -0.886523, 0.601240>, <1.494928, -0.880118, 0.560006>, <1.498750, -0.875315, 0.529080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.205490, -1.147555, 0.658826>, <2.209312, -1.142752, 0.627900>, <2.226495, -1.161070, 0.563091>, <2.218231, -1.131544, 0.555741>, 
      <2.165052, -1.184325, 0.653014>, <2.168875, -1.179522, 0.622089>, <2.186057, -1.197840, 0.557279>, <2.177793, -1.168315, 0.549929>, 
      <2.080321, -1.119021, 0.652836>, <2.084143, -1.114217, 0.621910>, <2.093441, -1.131941, 0.562276>, <2.093061, -1.103009, 0.549751>, 
      <2.028574, -1.100592, 0.650918>, <2.032396, -1.095788, 0.619993>, <2.041693, -1.113512, 0.560358>, <2.041314, -1.084580, 0.547834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.271466, -0.879729, 0.685828>, <2.275288, -0.874925, 0.654903>, <2.280384, -0.868521, 0.613668>, <2.284206, -0.863717, 0.582743>, 
      <2.251673, -0.960077, 0.677727>, <2.255495, -0.955273, 0.646802>, <2.260591, -0.948869, 0.605568>, <2.264413, -0.944065, 0.574642>, 
      <2.266661, -1.091932, 0.667618>, <2.270483, -1.087128, 0.636692>, <2.287667, -1.105446, 0.571882>, <2.279402, -1.075921, 0.564533>, 
      <2.205490, -1.147555, 0.658826>, <2.209312, -1.142752, 0.627900>, <2.226495, -1.161070, 0.563091>, <2.218231, -1.131544, 0.555741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.157172, -0.931540, 0.673794>, <2.160994, -0.926736, 0.642868>, <2.166090, -0.920332, 0.601634>, <2.169912, -0.915528, 0.570709>, 
      <2.193409, -0.942258, 0.675321>, <2.197231, -0.937455, 0.644396>, <2.202327, -0.931050, 0.603162>, <2.206149, -0.926246, 0.572236>, 
      <2.237178, -0.895272, 0.682218>, <2.241000, -0.890469, 0.651292>, <2.246096, -0.884064, 0.610058>, <2.249918, -0.879260, 0.579133>, 
      <2.271466, -0.879729, 0.685828>, <2.275288, -0.874925, 0.654903>, <2.280384, -0.868521, 0.613668>, <2.284206, -0.863717, 0.582743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.099025, -0.828724, 0.678560>, <2.102848, -0.823921, 0.647635>, <2.100962, -0.785265, 0.586608>, <2.111767, -0.812713, 0.575476>, 
      <2.116469, -0.859569, 0.677130>, <2.120292, -0.854765, 0.646205>, <2.118406, -0.816110, 0.585178>, <2.129210, -0.843557, 0.574046>, 
      <2.123192, -0.921489, 0.672362>, <2.127014, -0.916686, 0.641436>, <2.132110, -0.910281, 0.600202>, <2.135932, -0.905477, 0.569277>, 
      <2.157172, -0.931540, 0.673794>, <2.160994, -0.926736, 0.642868>, <2.166090, -0.920332, 0.601634>, <2.169912, -0.915528, 0.570709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.099025, -0.828724, 0.678560>, <2.073265, -0.853908, 0.674709>, <2.048785, -0.918989, 0.667582>, <2.013158, -0.912670, 0.665725>, 
      <2.102848, -0.823921, 0.647635>, <2.077087, -0.849105, 0.643784>, <2.052607, -0.914186, 0.636656>, <2.016980, -0.907867, 0.634799>, 
      <2.100962, -0.785265, 0.586608>, <2.075202, -0.810449, 0.582758>, <2.057306, -0.877210, 0.582168>, <2.021679, -0.870891, 0.580311>, 
      <2.111767, -0.812713, 0.575476>, <2.086007, -0.837897, 0.571625>, <2.061526, -0.902978, 0.564497>, <2.025899, -0.896659, 0.562640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.041314, -1.084580, 0.547834>, <2.093061, -1.103009, 0.549751>, <2.177793, -1.168315, 0.549929>, <2.218231, -1.131544, 0.555741>, 
      <2.040631, -1.032513, 0.525296>, <2.092378, -1.050942, 0.527213>, <2.151315, -1.073719, 0.526382>, <2.191753, -1.036948, 0.532194>, 
      <2.033494, -0.943032, 0.530839>, <2.069121, -0.949351, 0.532696>, <2.120625, -0.925837, 0.535958>, <2.146385, -0.900653, 0.539809>, 
      <2.025899, -0.896659, 0.562640>, <2.061526, -0.902978, 0.564497>, <2.086007, -0.837897, 0.571625>, <2.111767, -0.812713, 0.575476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.498750, -0.875315, 0.529080>, <1.636713, -0.982240, 0.529321>, <1.876983, -1.026057, 0.541745>, <2.041314, -1.084580, 0.547834>, 
      <1.457532, -0.843370, 0.529008>, <1.595495, -0.950295, 0.529249>, <1.876300, -0.973990, 0.519206>, <2.040631, -1.032513, 0.525296>, 
      <1.513518, -0.713720, 0.543693>, <1.661558, -0.719715, 0.553117>, <1.887507, -0.917138, 0.523230>, <2.033494, -0.943032, 0.530839>, 
      <1.565518, -0.715826, 0.547003>, <1.713558, -0.721820, 0.556428>, <1.879912, -0.870766, 0.555030>, <2.025899, -0.896659, 0.562640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.169912, -0.915528, 0.570709>, <2.135932, -0.905477, 0.569277>, <2.129210, -0.843557, 0.574046>, <2.111767, -0.812713, 0.575476>, 
      <2.206149, -0.926246, 0.572236>, <2.172169, -0.916196, 0.570804>, <2.163828, -0.931497, 0.538379>, <2.146385, -0.900653, 0.539809>, 
      <2.249918, -0.879260, 0.579133>, <2.230125, -0.959608, 0.571032>, <2.252925, -0.981325, 0.540986>, <2.191753, -1.036948, 0.532194>, 
      <2.284206, -0.863717, 0.582743>, <2.264413, -0.944065, 0.574642>, <2.279402, -1.075921, 0.564533>, <2.218231, -1.131544, 0.555741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.552778, -0.731838, 0.650088>, <1.556600, -0.727034, 0.619162>, <1.561696, -0.720630, 0.577928>, <1.565518, -0.715826, 0.547003>, 
      <1.700818, -0.737832, 0.659513>, <1.704640, -0.733028, 0.628587>, <1.709736, -0.726624, 0.587353>, <1.713558, -0.721820, 0.556428>, 
      <1.867171, -0.886777, 0.658116>, <1.870994, -0.881973, 0.627190>, <1.875692, -0.844998, 0.572701>, <1.879912, -0.870766, 0.555030>, 
      <2.013158, -0.912670, 0.665725>, <2.016980, -0.907867, 0.634799>, <2.021679, -0.870891, 0.580311>, <2.025899, -0.896659, 0.562640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.486009, -0.891326, 0.632165>, <1.489831, -0.886523, 0.601240>, <1.494928, -0.880118, 0.560006>, <1.498750, -0.875315, 0.529080>, 
      <1.444791, -0.859381, 0.632093>, <1.448613, -0.854578, 0.601168>, <1.453710, -0.848173, 0.559933>, <1.457532, -0.843370, 0.529008>, 
      <1.500778, -0.729733, 0.646778>, <1.504600, -0.724929, 0.615852>, <1.509696, -0.718524, 0.574618>, <1.513518, -0.713720, 0.543693>, 
      <1.552778, -0.731838, 0.650088>, <1.556600, -0.727034, 0.619162>, <1.561696, -0.720630, 0.577928>, <1.565518, -0.715826, 0.547003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.028574, -1.100592, 0.650918>, <2.032396, -1.095788, 0.619993>, <2.041693, -1.113512, 0.560358>, <2.041314, -1.084580, 0.547834>, 
      <1.864243, -1.042069, 0.644829>, <1.868065, -1.037265, 0.613903>, <1.877362, -1.054989, 0.554269>, <1.876983, -1.026057, 0.541745>, 
      <1.623972, -0.998251, 0.632406>, <1.627795, -0.993448, 0.601480>, <1.632891, -0.987043, 0.560246>, <1.636713, -0.982240, 0.529321>, 
      <1.486009, -0.891326, 0.632165>, <1.489831, -0.886523, 0.601240>, <1.494928, -0.880118, 0.560006>, <1.498750, -0.875315, 0.529080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.205490, -1.147555, 0.658826>, <2.209312, -1.142752, 0.627900>, <2.226495, -1.161070, 0.563091>, <2.218231, -1.131544, 0.555741>, 
      <2.165052, -1.184325, 0.653014>, <2.168875, -1.179522, 0.622089>, <2.186057, -1.197840, 0.557279>, <2.177793, -1.168315, 0.549929>, 
      <2.080321, -1.119021, 0.652836>, <2.084143, -1.114217, 0.621910>, <2.093441, -1.131941, 0.562276>, <2.093061, -1.103009, 0.549751>, 
      <2.028574, -1.100592, 0.650918>, <2.032396, -1.095788, 0.619993>, <2.041693, -1.113512, 0.560358>, <2.041314, -1.084580, 0.547834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.271466, -0.879729, 0.685828>, <2.275288, -0.874925, 0.654903>, <2.280384, -0.868521, 0.613668>, <2.284206, -0.863717, 0.582743>, 
      <2.251673, -0.960077, 0.677727>, <2.255495, -0.955273, 0.646802>, <2.260591, -0.948869, 0.605568>, <2.264413, -0.944065, 0.574642>, 
      <2.266661, -1.091932, 0.667618>, <2.270483, -1.087128, 0.636692>, <2.287667, -1.105446, 0.571882>, <2.279402, -1.075921, 0.564533>, 
      <2.205490, -1.147555, 0.658826>, <2.209312, -1.142752, 0.627900>, <2.226495, -1.161070, 0.563091>, <2.218231, -1.131544, 0.555741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.157172, -0.931540, 0.673794>, <2.160994, -0.926736, 0.642868>, <2.166090, -0.920332, 0.601634>, <2.169912, -0.915528, 0.570709>, 
      <2.193409, -0.942258, 0.675321>, <2.197231, -0.937455, 0.644396>, <2.202327, -0.931050, 0.603162>, <2.206149, -0.926246, 0.572236>, 
      <2.237178, -0.895272, 0.682218>, <2.241000, -0.890469, 0.651292>, <2.246096, -0.884064, 0.610058>, <2.249918, -0.879260, 0.579133>, 
      <2.271466, -0.879729, 0.685828>, <2.275288, -0.874925, 0.654903>, <2.280384, -0.868521, 0.613668>, <2.284206, -0.863717, 0.582743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.099025, -0.828724, 0.678560>, <2.102848, -0.823921, 0.647635>, <2.100962, -0.785265, 0.586608>, <2.111767, -0.812713, 0.575476>, 
      <2.116469, -0.859569, 0.677130>, <2.120292, -0.854765, 0.646205>, <2.118406, -0.816110, 0.585178>, <2.129210, -0.843557, 0.574046>, 
      <2.123192, -0.921489, 0.672362>, <2.127014, -0.916686, 0.641436>, <2.132110, -0.910281, 0.600202>, <2.135932, -0.905477, 0.569277>, 
      <2.157172, -0.931540, 0.673794>, <2.160994, -0.926736, 0.642868>, <2.166090, -0.920332, 0.601634>, <2.169912, -0.915528, 0.570709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.099025, -0.828724, 0.678560>, <2.073265, -0.853908, 0.674709>, <2.048785, -0.918989, 0.667582>, <2.013158, -0.912670, 0.665725>, 
      <2.102848, -0.823921, 0.647635>, <2.077087, -0.849105, 0.643784>, <2.052607, -0.914186, 0.636656>, <2.016980, -0.907867, 0.634799>, 
      <2.100962, -0.785265, 0.586608>, <2.075202, -0.810449, 0.582758>, <2.057306, -0.877210, 0.582168>, <2.021679, -0.870891, 0.580311>, 
      <2.111767, -0.812713, 0.575476>, <2.086007, -0.837897, 0.571625>, <2.061526, -0.902978, 0.564497>, <2.025899, -0.896659, 0.562640>
    }
  }
  texture {
    BumbySpikes
  }
  scale <1.5, 1.0, 0.35>
  rotate <-116.025993, -0.0, -180.0>
  translate  <1.676149, -0.274259, -0.223663>
}
#declare RightHornRoot = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.389168, 1.438456, 1.513633>, <-0.487695, 1.534493, 1.414910>, <-0.217789, 1.626869, 1.341967>, <-0.144341, 1.707617, 1.268396>, 
      <-0.371330, 1.400783, 1.526970>, <-0.469857, 1.496820, 1.428247>, <-0.215366, 1.522918, 1.340533>, <-0.141918, 1.603666, 1.266962>, 
      <-0.341711, 1.352696, 1.571722>, <-0.418658, 1.364621, 1.458705>, <-0.200687, 1.450433, 1.352842>, <-0.142654, 1.464903, 1.264501>, 
      <-0.329709, 1.312879, 1.558088>, <-0.406656, 1.324804, 1.445070>, <-0.194298, 1.346644, 1.351958>, <-0.136265, 1.361115, 1.263617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.116180, 1.453680, 1.529435>, <0.007255, 1.333929, 1.638543>, <-0.275587, 1.327745, 1.627440>, <-0.389168, 1.438456, 1.513633>, 
      <0.100698, 1.416573, 1.538186>, <-0.008227, 1.296822, 1.647293>, <-0.257749, 1.290072, 1.640777>, <-0.371330, 1.400783, 1.526970>, 
      <0.072269, 1.368108, 1.572054>, <-0.010584, 1.347449, 1.698179>, <-0.256316, 1.339462, 1.697148>, <-0.341711, 1.352696, 1.571722>, 
      <0.064573, 1.329990, 1.558603>, <-0.018281, 1.309330, 1.684727>, <-0.244314, 1.299645, 1.683513>, <-0.329709, 1.312879, 1.558088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.116180, 1.453680, 1.529435>, <0.100698, 1.416573, 1.538186>, <0.072269, 1.368108, 1.572054>, <0.064573, 1.329990, 1.558603>, 
      <0.212603, 1.559687, 1.432850>, <0.197121, 1.522580, 1.441601>, <0.147474, 1.386861, 1.457574>, <0.139778, 1.348743, 1.444122>, 
      <-0.066185, 1.631436, 1.346708>, <-0.063762, 1.527485, 1.345274>, <-0.082403, 1.455566, 1.352996>, <-0.076014, 1.351778, 1.352113>, 
      <-0.144341, 1.707617, 1.268396>, <-0.141918, 1.603666, 1.266962>, <-0.142654, 1.464903, 1.264501>, <-0.136265, 1.361115, 1.263617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.286875, 1.099095, 1.397427>, <-0.301958, 1.159635, 1.449474>, <-0.307427, 1.238958, 1.532776>, <-0.329709, 1.312879, 1.558088>, 
      <-0.351706, 1.178775, 1.341898>, <-0.366789, 1.239315, 1.393946>, <-0.384374, 1.250883, 1.419758>, <-0.406656, 1.324804, 1.445070>, 
      <-0.236774, 1.310545, 1.261399>, <-0.241620, 1.324662, 1.260970>, <-0.193381, 1.331742, 1.351831>, <-0.194298, 1.346644, 1.351958>, 
      <-0.120114, 1.314060, 1.265046>, <-0.124959, 1.328177, 1.264617>, <-0.135348, 1.346213, 1.263490>, <-0.136265, 1.361115, 1.263617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.046616, 1.109142, 1.407853>, <0.052279, 1.166305, 1.464104>, <0.049535, 1.255511, 1.532321>, <0.064573, 1.329990, 1.558603>, 
      <-0.024389, 1.017612, 1.464220>, <-0.018726, 1.074775, 1.520471>, <-0.033318, 1.234851, 1.658445>, <-0.018281, 1.309330, 1.684727>, 
      <-0.215350, 1.011188, 1.458690>, <-0.230433, 1.071728, 1.510737>, <-0.222033, 1.225724, 1.658201>, <-0.244314, 1.299645, 1.683513>, 
      <-0.286875, 1.099095, 1.397427>, <-0.301958, 1.159635, 1.449474>, <-0.307427, 1.238958, 1.532776>, <-0.329709, 1.312879, 1.558088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.046616, 1.109142, 1.407853>, <0.110496, 1.191487, 1.357143>, <-0.004323, 1.317548, 1.268666>, <-0.120114, 1.314060, 1.265046>, 
      <0.052279, 1.166305, 1.464104>, <0.116159, 1.248650, 1.413395>, <-0.009169, 1.331665, 1.268237>, <-0.124959, 1.328177, 1.264617>, 
      <0.049535, 1.255511, 1.532321>, <0.124740, 1.274264, 1.417840>, <-0.075096, 1.336875, 1.351986>, <-0.135348, 1.346213, 1.263490>, 
      <0.064573, 1.329990, 1.558603>, <0.139778, 1.348743, 1.444122>, <-0.076014, 1.351778, 1.352113>, <-0.136265, 1.361115, 1.263617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.251431, 0.998689, 1.287974>, <-0.262064, 1.028811, 1.320810>, <-0.278371, 1.064961, 1.368082>, <-0.286875, 1.099095, 1.397427>, 
      <-0.312208, 0.983202, 1.264158>, <-0.322841, 1.013324, 1.296994>, <-0.343202, 1.144641, 1.312553>, <-0.351706, 1.178775, 1.341898>, 
      <-0.147939, 0.987780, 1.224911>, <-0.152897, 1.087067, 1.245060>, <-0.231816, 1.211259, 1.241250>, <-0.236774, 1.310545, 1.261399>, 
      <-0.103585, 0.983105, 1.197884>, <-0.108544, 1.082392, 1.218033>, <-0.115155, 1.214773, 1.244897>, <-0.120114, 1.314060, 1.265046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.033674, 1.018081, 1.251670>, <0.037557, 1.045399, 1.298525>, <0.042786, 1.070481, 1.369809>, <0.046616, 1.109142, 1.407853>, 
      <-0.060880, 1.028048, 1.309287>, <-0.056998, 1.055366, 1.356142>, <-0.028219, 0.978951, 1.426175>, <-0.024389, 1.017612, 1.464220>, 
      <-0.150717, 1.024353, 1.327440>, <-0.161350, 1.054475, 1.360276>, <-0.206846, 0.977054, 1.429344>, <-0.215350, 1.011188, 1.458690>, 
      <-0.251431, 0.998689, 1.287974>, <-0.262064, 1.028811, 1.320810>, <-0.278371, 1.064961, 1.368082>, <-0.286875, 1.099095, 1.397427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.033674, 1.018081, 1.251670>, <0.083407, 1.012839, 1.221365>, <-0.062407, 0.993598, 1.214020>, <-0.103585, 0.983105, 1.197884>, 
      <0.037557, 1.045399, 1.298525>, <0.087290, 1.040157, 1.268220>, <-0.067366, 1.092884, 1.234168>, <-0.108544, 1.082392, 1.218033>, 
      <0.042786, 1.070481, 1.369809>, <0.106666, 1.152825, 1.319099>, <0.000635, 1.218262, 1.248517>, <-0.115155, 1.214773, 1.244897>, 
      <0.046616, 1.109142, 1.407853>, <0.110496, 1.191487, 1.357143>, <-0.004323, 1.317548, 1.268666>, <-0.120114, 1.314060, 1.265046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.372689, 1.116165, 1.431236>, <-0.372689, 1.143517, 1.442152>, <-0.351512, 1.174486, 1.460768>, <-0.342436, 1.199480, 1.473425>, 
      <-0.473446, 1.169193, 1.332718>, <-0.473446, 1.196545, 1.343635>, <-0.442001, 1.271572, 1.368118>, <-0.432925, 1.296567, 1.380775>, 
      <-0.200933, 1.233231, 1.254112>, <-0.201604, 1.280993, 1.289521>, <-0.193389, 1.334061, 1.289831>, <-0.194538, 1.390938, 1.307128>, 
      <-0.127324, 1.283402, 1.178202>, <-0.127994, 1.331164, 1.213611>, <-0.130004, 1.416115, 1.218561>, <-0.131153, 1.472992, 1.235858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.139490, 1.142978, 1.439086>, <0.139490, 1.169838, 1.449037>, <0.112952, 1.199197, 1.463629>, <0.101579, 1.223291, 1.474148>, 
      <0.014984, 1.058116, 1.567484>, <0.014984, 1.084977, 1.577435>, <0.026498, 1.087280, 1.560839>, <0.015125, 1.111374, 1.571358>, 
      <-0.240213, 1.046443, 1.560768>, <-0.240213, 1.073795, 1.571684>, <-0.255572, 1.071550, 1.559000>, <-0.246496, 1.096545, 1.571656>, 
      <-0.372689, 1.116165, 1.431236>, <-0.372689, 1.143517, 1.442152>, <-0.351512, 1.174486, 1.460768>, <-0.342436, 1.199480, 1.473425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.139490, 1.142978, 1.439086>, <0.236269, 1.208941, 1.339282>, <-0.047280, 1.241275, 1.256467>, <-0.127324, 1.283402, 1.178202>, 
      <0.139490, 1.169838, 1.449037>, <0.236269, 1.235802, 1.349233>, <-0.047950, 1.289037, 1.291876>, <-0.127994, 1.331164, 1.213611>, 
      <0.112952, 1.199197, 1.463629>, <0.193892, 1.303976, 1.372621>, <-0.060185, 1.341205, 1.290048>, <-0.130004, 1.416115, 1.218561>, 
      <0.101579, 1.223291, 1.474148>, <0.182519, 1.328069, 1.383140>, <-0.061333, 1.398082, 1.307345>, <-0.131153, 1.472992, 1.235858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.342436, 0.914207, 1.359573>, <-0.350547, 0.939173, 1.418956>, <-0.372689, 1.055864, 1.407170>, <-0.372689, 1.116165, 1.431236>, 
      <-0.430929, 1.015866, 1.230218>, <-0.439040, 1.040832, 1.289601>, <-0.473446, 1.108892, 1.308652>, <-0.473446, 1.169193, 1.332718>, 
      <-0.191858, 1.114314, 1.131341>, <-0.192041, 1.141989, 1.173087>, <-0.200369, 1.192998, 1.224285>, <-0.200933, 1.233231, 1.254112>, 
      <-0.127324, 1.200074, 1.033527>, <-0.127507, 1.227749, 1.075273>, <-0.126760, 1.243169, 1.148375>, <-0.127324, 1.283402, 1.178202>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.101579, 0.937114, 1.368127>, <0.110646, 0.963690, 1.428196>, <0.139490, 1.080800, 1.416051>, <0.139490, 1.142978, 1.439086>, 
      <0.025309, 0.835758, 1.483729>, <0.034376, 0.862333, 1.543798>, <0.014984, 0.995938, 1.544449>, <0.014984, 1.058116, 1.567484>, 
      <-0.261138, 0.820813, 1.478411>, <-0.269249, 0.845779, 1.537793>, <-0.240213, 0.986142, 1.536701>, <-0.240213, 1.046443, 1.560768>, 
      <-0.342436, 0.914207, 1.359573>, <-0.350547, 0.939173, 1.418956>, <-0.372689, 1.055864, 1.407170>, <-0.372689, 1.116165, 1.431236>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.101579, 0.937114, 1.368127>, <0.184458, 1.047253, 1.242508>, <-0.058653, 1.121186, 1.133907>, <-0.127324, 1.200074, 1.033527>, 
      <0.110646, 0.963690, 1.428196>, <0.193524, 1.073829, 1.302576>, <-0.058836, 1.148861, 1.175653>, <-0.127507, 1.227749, 1.075273>, 
      <0.139490, 1.080800, 1.416051>, <0.236269, 1.146763, 1.316247>, <-0.046715, 1.201042, 1.226640>, <-0.126760, 1.243169, 1.148375>, 
      <0.139490, 1.142978, 1.439086>, <0.236269, 1.208941, 1.339282>, <-0.047280, 1.241275, 1.256467>, <-0.127324, 1.283402, 1.178202>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.280599, 0.832694, 0.756981>, <-0.299150, 0.857148, 0.937759>, <-0.319530, 0.843698, 1.191863>, <-0.342436, 0.914207, 1.359573>, 
      <-0.346269, 0.928850, 0.802194>, <-0.364820, 0.953304, 0.982971>, <-0.408023, 0.945358, 1.062508>, <-0.430929, 1.015866, 1.230218>, 
      <-0.172401, 1.011162, 0.845136>, <-0.172789, 1.044890, 0.890319>, <-0.191652, 1.083159, 1.084345>, <-0.191858, 1.114314, 1.131341>, 
      <-0.126030, 1.087648, 0.882916>, <-0.126418, 1.121376, 0.928099>, <-0.127118, 1.168919, 0.986531>, <-0.127324, 1.200074, 1.033527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.038448, 0.846813, 0.769675>, <0.057387, 0.873903, 0.949211>, <0.076617, 0.863947, 1.202751>, <0.101579, 0.937114, 1.368127>, 
      <-0.020461, 0.749646, 0.721679>, <-0.001521, 0.776736, 0.901215>, <0.000347, 0.762591, 1.318353>, <0.025309, 0.835758, 1.483729>, 
      <-0.215750, 0.737739, 0.712333>, <-0.234301, 0.762193, 0.893111>, <-0.238232, 0.750305, 1.310701>, <-0.261138, 0.820813, 1.478411>, 
      <-0.280599, 0.832694, 0.756981>, <-0.299150, 0.857148, 0.937759>, <-0.319530, 0.843698, 1.191863>, <-0.342436, 0.914207, 1.359573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.038448, 0.846813, 0.769675>, <0.096111, 0.941926, 0.816656>, <-0.076687, 1.015398, 0.848944>, <-0.126030, 1.087648, 0.882916>, 
      <0.057387, 0.873903, 0.949211>, <0.115051, 0.969016, 0.996192>, <-0.077075, 1.049125, 0.894127>, <-0.126418, 1.121376, 0.928099>, 
      <0.076617, 0.863947, 1.202751>, <0.159495, 0.974086, 1.077132>, <-0.058447, 1.090031, 1.086911>, <-0.127118, 1.168919, 0.986531>, 
      <0.101579, 0.937114, 1.368127>, <0.184458, 1.047253, 1.242508>, <-0.058653, 1.121186, 1.133907>, <-0.127324, 1.200074, 1.033527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.343848, 0.891610, 0.929976>, <-0.353808, 0.925531, 0.974652>, <-0.357075, 1.008077, 0.992678>, <-0.362743, 1.057992, 1.019550>, 
      <-0.434536, 1.052031, 0.956334>, <-0.444496, 1.085951, 1.001010>, <-0.454448, 1.107715, 1.042292>, <-0.460117, 1.157630, 1.069164>, 
      <-0.185419, 1.182575, 0.995105>, <-0.187598, 1.203069, 1.035720>, <-0.194335, 1.236045, 1.082513>, <-0.196770, 1.238712, 1.127915>, 
      <-0.117521, 1.307274, 1.023017>, <-0.119700, 1.327769, 1.063632>, <-0.123204, 1.313496, 1.128955>, <-0.125639, 1.316163, 1.174357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.117460, 0.891610, 0.954720>, <0.122584, 0.925531, 1.000205>, <0.123904, 1.008077, 1.018477>, <0.126665, 1.057992, 1.045802>, 
      <0.033801, 0.737966, 0.920329>, <0.038925, 0.771886, 0.965814>, <0.006863, 0.880638, 0.942061>, <0.009625, 0.930553, 0.969386>, 
      <-0.256991, 0.737966, 0.904731>, <-0.266950, 0.771886, 0.949407>, <-0.232531, 0.880638, 0.929220>, <-0.238200, 0.930553, 0.956092>, 
      <-0.343848, 0.891610, 0.929976>, <-0.353808, 0.925531, 0.974652>, <-0.357075, 1.008077, 0.992678>, <-0.362743, 1.057992, 1.019550>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.117460, 0.891610, 0.954720>, <0.204808, 1.052031, 0.990628>, <-0.047027, 1.182575, 1.002528>, <-0.117521, 1.307274, 1.023017>, 
      <0.122584, 0.925531, 1.000205>, <0.209932, 1.085951, 1.036113>, <-0.049205, 1.203069, 1.043143>, <-0.119700, 1.327769, 1.063632>, 
      <0.123904, 1.008077, 1.018477>, <0.215411, 1.107715, 1.078224>, <-0.047512, 1.236045, 1.090389>, <-0.123204, 1.313496, 1.128955>, 
      <0.126665, 1.057992, 1.045802>, <0.218172, 1.157630, 1.105548>, <-0.049948, 1.238712, 1.135791>, <-0.125639, 1.316163, 1.174357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.285773, 0.795845, 0.674283>, <-0.302771, 0.811692, 0.754738>, <-0.329208, 0.841749, 0.864306>, <-0.343848, 0.891610, 0.929976>, 
      <-0.357713, 0.901154, 0.670303>, <-0.374711, 0.917001, 0.750757>, <-0.419896, 1.002170, 0.890664>, <-0.434536, 1.052031, 0.956334>, 
      <-0.226750, 1.068710, 0.677134>, <-0.232206, 1.140279, 0.778848>, <-0.179464, 1.126556, 0.884090>, <-0.185419, 1.182575, 0.995105>, 
      <-0.099335, 1.068710, 0.683968>, <-0.104791, 1.140279, 0.785683>, <-0.111566, 1.251255, 0.912002>, <-0.117521, 1.307274, 1.023017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.087069, 0.795845, 0.694282>, <0.094209, 0.802337, 0.777468>, <0.109929, 0.841749, 0.887860>, <0.117460, 0.891610, 0.954720>, 
      <0.005810, 0.676916, 0.690061>, <0.012949, 0.683408, 0.773247>, <0.026270, 0.688105, 0.853469>, <0.033801, 0.737966, 0.920329>, 
      <-0.204528, 0.676916, 0.678778>, <-0.221526, 0.692763, 0.759233>, <-0.242351, 0.688105, 0.839061>, <-0.256991, 0.737966, 0.904731>, 
      <-0.285773, 0.795845, 0.674283>, <-0.302771, 0.811692, 0.754738>, <-0.329208, 0.841749, 0.864306>, <-0.343848, 0.891610, 0.929976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.087069, 0.795845, 0.694282>, <0.159023, 0.901154, 0.698020>, <0.028080, 1.068710, 0.690802>, <-0.099335, 1.068710, 0.683968>, 
      <0.094209, 0.802337, 0.777468>, <0.166162, 0.907646, 0.781206>, <0.022624, 1.140279, 0.792517>, <-0.104791, 1.140279, 0.785683>, 
      <0.109929, 0.841749, 0.887860>, <0.197277, 1.002170, 0.923768>, <-0.041072, 1.126556, 0.891513>, <-0.111566, 1.251255, 0.912002>, 
      <0.117460, 0.891610, 0.954720>, <0.204808, 1.052031, 0.990628>, <-0.047027, 1.182575, 1.002528>, <-0.117521, 1.307274, 1.023017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.246147, 0.800526, 0.467534>, <-0.258035, 0.799122, 0.529559>, <-0.272951, 0.783892, 0.613595>, <-0.285773, 0.795845, 0.674283>, 
      <-0.318321, 0.807857, 0.423993>, <-0.330209, 0.806452, 0.486017>, <-0.344892, 0.889201, 0.609614>, <-0.357713, 0.901154, 0.670303>, 
      <-0.130443, 0.846642, 0.377890>, <-0.135987, 0.907333, 0.481239>, <-0.221206, 1.008019, 0.573785>, <-0.226750, 1.068710, 0.677134>, 
      <-0.080856, 0.866406, 0.339471>, <-0.086400, 0.927097, 0.442820>, <-0.093791, 1.008019, 0.580619>, <-0.099335, 1.068710, 0.683968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.072599, 0.850820, 0.432048>, <0.076940, 0.834328, 0.510718>, <0.080206, 0.789605, 0.614321>, <0.087069, 0.795845, 0.694282>, 
      <-0.021864, 0.813170, 0.505236>, <-0.017523, 0.796677, 0.583906>, <-0.001054, 0.670676, 0.610100>, <0.005810, 0.676916, 0.690061>, 
      <-0.139272, 0.789671, 0.532010>, <-0.151160, 0.788267, 0.594035>, <-0.191707, 0.664963, 0.618090>, <-0.204528, 0.676916, 0.678778>, 
      <-0.246147, 0.800526, 0.467534>, <-0.258035, 0.799122, 0.529559>, <-0.272951, 0.783892, 0.613595>, <-0.285773, 0.795845, 0.674283>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.072599, 0.850820, 0.432048>, <0.124945, 0.871684, 0.391492>, <-0.034820, 0.861730, 0.367244>, <-0.080856, 0.866406, 0.339471>, 
      <0.076940, 0.834328, 0.510718>, <0.129286, 0.855191, 0.470162>, <-0.040363, 0.922421, 0.470593>, <-0.086400, 0.927097, 0.442820>, 
      <0.080206, 0.789605, 0.614321>, <0.152159, 0.894914, 0.618058>, <0.033624, 1.008019, 0.587453>, <-0.093791, 1.008019, 0.580619>, 
      <0.087069, 0.795845, 0.694282>, <0.159023, 0.901154, 0.698020>, <0.028080, 1.068710, 0.690802>, <-0.099335, 1.068710, 0.683968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.362743, 1.017595, 0.726670>, <-0.460117, 1.117233, 0.776284>, <-0.196770, 1.198315, 0.835035>, <-0.125639, 1.275766, 0.881477>, 
      <-0.357075, 0.967681, 0.699798>, <-0.454448, 1.067318, 0.749412>, <-0.194335, 1.195648, 0.789633>, <-0.123204, 1.273099, 0.836075>, 
      <-0.353808, 0.885133, 0.681772>, <-0.444496, 1.045554, 0.708130>, <-0.187598, 1.162673, 0.742840>, <-0.119700, 1.287372, 0.770752>, 
      <-0.343848, 0.851213, 0.637096>, <-0.434536, 1.011634, 0.663454>, <-0.185419, 1.142178, 0.702225>, <-0.117521, 1.266877, 0.730137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.126665, 1.017595, 0.752922>, <0.009625, 0.890156, 0.676505>, <-0.238200, 0.890156, 0.663212>, <-0.362743, 1.017595, 0.726670>, 
      <0.123904, 0.967681, 0.725597>, <0.006863, 0.840241, 0.649181>, <-0.232531, 0.840241, 0.636340>, <-0.357075, 0.967681, 0.699798>, 
      <0.122584, 0.885134, 0.707325>, <0.038925, 0.731489, 0.672934>, <-0.266950, 0.731489, 0.656527>, <-0.353808, 0.885133, 0.681772>, 
      <0.117460, 0.851213, 0.661840>, <0.033801, 0.697569, 0.627449>, <-0.256991, 0.697569, 0.611851>, <-0.343848, 0.851213, 0.637096>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.126665, 1.017595, 0.752922>, <0.123904, 0.967681, 0.725597>, <0.122584, 0.885134, 0.707325>, <0.117460, 0.851213, 0.661840>, 
      <0.218172, 1.117233, 0.812668>, <0.215411, 1.067318, 0.785343>, <0.209932, 1.045554, 0.743233>, <0.204808, 1.011634, 0.697748>, 
      <-0.049948, 1.198315, 0.842911>, <-0.047512, 1.195648, 0.797509>, <-0.049205, 1.162673, 0.750263>, <-0.047027, 1.142178, 0.709648>, 
      <-0.125639, 1.275766, 0.881477>, <-0.123204, 1.273099, 0.836075>, <-0.119700, 1.287372, 0.770752>, <-0.117521, 1.266877, 0.730137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.285773, 0.755448, 0.381403>, <-0.302771, 0.771295, 0.461858>, <-0.329208, 0.801352, 0.571426>, <-0.343848, 0.851213, 0.637096>, 
      <-0.357713, 0.860757, 0.377422>, <-0.374711, 0.876604, 0.457877>, <-0.419896, 0.961773, 0.597784>, <-0.434536, 1.011634, 0.663454>, 
      <-0.226750, 1.028313, 0.384254>, <-0.232206, 1.099882, 0.485968>, <-0.179464, 1.086159, 0.591210>, <-0.185419, 1.142178, 0.702225>, 
      <-0.099335, 1.028313, 0.391088>, <-0.104791, 1.099882, 0.492803>, <-0.111566, 1.210859, 0.619122>, <-0.117521, 1.266877, 0.730137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.087069, 0.755448, 0.401402>, <0.094209, 0.761940, 0.484588>, <0.109929, 0.801352, 0.594980>, <0.117460, 0.851213, 0.661840>, 
      <0.005810, 0.636519, 0.397181>, <0.012949, 0.643011, 0.480367>, <0.026270, 0.647708, 0.560589>, <0.033801, 0.697569, 0.627449>, 
      <-0.204528, 0.636519, 0.385898>, <-0.221526, 0.652366, 0.466353>, <-0.242351, 0.647708, 0.546181>, <-0.256991, 0.697569, 0.611851>, 
      <-0.285773, 0.755448, 0.381403>, <-0.302771, 0.771295, 0.461858>, <-0.329208, 0.801352, 0.571426>, <-0.343848, 0.851213, 0.637096>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.087069, 0.755448, 0.401402>, <0.159023, 0.860757, 0.405140>, <0.028080, 1.028313, 0.397923>, <-0.099335, 1.028313, 0.391088>, 
      <0.094209, 0.761940, 0.484588>, <0.166162, 0.867249, 0.488326>, <0.022624, 1.099882, 0.499637>, <-0.104791, 1.099882, 0.492803>, 
      <0.109929, 0.801352, 0.594980>, <0.197277, 0.961773, 0.630888>, <-0.041072, 1.086159, 0.598633>, <-0.111566, 1.210859, 0.619122>, 
      <0.117460, 0.851213, 0.661840>, <0.204808, 1.011634, 0.697748>, <-0.047027, 1.142178, 0.709648>, <-0.117521, 1.266877, 0.730137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.246147, 0.760129, 0.174654>, <-0.258035, 0.758725, 0.236679>, <-0.272951, 0.743495, 0.320715>, <-0.285773, 0.755448, 0.381403>, 
      <-0.318321, 0.767459, 0.131113>, <-0.330209, 0.766055, 0.193137>, <-0.344892, 0.848804, 0.316734>, <-0.357713, 0.860757, 0.377422>, 
      <-0.130443, 0.806245, 0.085010>, <-0.135987, 0.866936, 0.188359>, <-0.221206, 0.967622, 0.280905>, <-0.226750, 1.028313, 0.384254>, 
      <-0.080856, 0.826009, 0.046591>, <-0.086400, 0.886700, 0.149940>, <-0.093791, 0.967622, 0.287739>, <-0.099335, 1.028313, 0.391088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.072599, 0.810423, 0.139168>, <0.076940, 0.793931, 0.217838>, <0.080206, 0.749208, 0.321441>, <0.087069, 0.755448, 0.401402>, 
      <-0.021864, 0.772773, 0.212356>, <-0.017523, 0.756280, 0.291026>, <-0.001054, 0.630279, 0.317219>, <0.005810, 0.636519, 0.397181>, 
      <-0.139272, 0.749274, 0.239130>, <-0.151160, 0.747870, 0.301155>, <-0.191707, 0.624566, 0.325210>, <-0.204528, 0.636519, 0.385898>, 
      <-0.246147, 0.760129, 0.174654>, <-0.258035, 0.758725, 0.236679>, <-0.272951, 0.743495, 0.320715>, <-0.285773, 0.755448, 0.381403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.072599, 0.810423, 0.139168>, <0.124945, 0.831287, 0.098612>, <-0.034820, 0.821333, 0.074364>, <-0.080856, 0.826009, 0.046591>, 
      <0.076940, 0.793931, 0.217838>, <0.129286, 0.814794, 0.177282>, <-0.040363, 0.882024, 0.177713>, <-0.086400, 0.886700, 0.149940>, 
      <0.080206, 0.749208, 0.321441>, <0.152159, 0.854517, 0.325179>, <0.033624, 0.967622, 0.294573>, <-0.093791, 0.967622, 0.287739>, 
      <0.087069, 0.755448, 0.401402>, <0.159023, 0.860757, 0.405140>, <0.028080, 1.028313, 0.397923>, <-0.099335, 1.028313, 0.391088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.342544, 0.988573, 0.233525>, <-0.439918, 1.099580, 0.241698>, <-0.176571, 1.196874, 0.265355>, <-0.105440, 1.286146, 0.278997>, 
      <-0.336875, 0.932199, 0.227564>, <-0.434249, 1.043206, 0.235737>, <-0.174136, 1.177207, 0.224347>, <-0.103005, 1.266479, 0.237989>, 
      <-0.333608, 0.848975, 0.242152>, <-0.424297, 1.007425, 0.205776>, <-0.167399, 1.128964, 0.193533>, <-0.099501, 1.254943, 0.172128>, 
      <-0.323649, 0.800659, 0.213655>, <-0.414337, 0.959109, 0.177280>, <-0.165220, 1.094611, 0.163709>, <-0.097322, 1.220590, 0.142303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.146864, 0.998517, 0.257821>, <0.029824, 0.851628, 0.235375>, <-0.218001, 0.846592, 0.223072>, <-0.342544, 0.988573, 0.233525>, 
      <0.144102, 0.941971, 0.251441>, <0.027062, 0.795082, 0.228995>, <-0.212332, 0.790218, 0.217111>, <-0.336875, 0.932199, 0.227564>, 
      <0.142783, 0.858655, 0.265801>, <0.059124, 0.703433, 0.292175>, <-0.246751, 0.697218, 0.276991>, <-0.333608, 0.848975, 0.242152>, 
      <0.137659, 0.810032, 0.236555>, <0.054000, 0.654810, 0.262929>, <-0.236792, 0.648902, 0.248494>, <-0.323649, 0.800659, 0.213655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.146864, 0.998517, 0.257821>, <0.144102, 0.941971, 0.251441>, <0.142783, 0.858655, 0.265801>, <0.137659, 0.810032, 0.236555>, 
      <0.238372, 1.113362, 0.275370>, <0.235610, 1.056817, 0.268991>, <0.230131, 1.020722, 0.238263>, <0.225007, 0.972099, 0.209017>, 
      <-0.029749, 1.199857, 0.272644>, <-0.027313, 1.180191, 0.231636>, <-0.029006, 1.131776, 0.200403>, <-0.026828, 1.097423, 0.170579>, 
      <-0.105440, 1.286146, 0.278997>, <-0.103005, 1.266479, 0.237989>, <-0.099501, 1.254943, 0.172128>, <-0.097322, 1.220590, 0.142303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.265574, 0.615171, 0.013294>, <-0.282572, 0.660314, 0.081750>, <-0.309009, 0.729637, 0.171767>, <-0.323649, 0.800659, 0.213655>, 
      <-0.337514, 0.711124, -0.030282>, <-0.354512, 0.756267, 0.038174>, <-0.399697, 0.888087, 0.135391>, <-0.414337, 0.959109, 0.177280>, 
      <-0.206551, 0.868781, -0.087432>, <-0.212007, 0.973547, -0.020409>, <-0.159265, 1.000714, 0.082188>, <-0.165220, 1.094611, 0.163709>, 
      <-0.079136, 0.871370, -0.081107>, <-0.084592, 0.976136, -0.014084>, <-0.091367, 1.126693, 0.060782>, <-0.097322, 1.220590, 0.142303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107268, 0.622747, 0.031803>, <0.114408, 0.660267, 0.106330>, <0.130128, 0.738560, 0.193566>, <0.137659, 0.810032, 0.236555>, 
      <0.026009, 0.511082, 0.072948>, <0.033148, 0.548602, 0.147475>, <0.046469, 0.583338, 0.219940>, <0.054000, 0.654810, 0.262929>, 
      <-0.184329, 0.506808, 0.062506>, <-0.201327, 0.551951, 0.130962>, <-0.222152, 0.577880, 0.206606>, <-0.236792, 0.648902, 0.248494>, 
      <-0.265574, 0.615171, 0.013294>, <-0.282572, 0.660314, 0.081750>, <-0.309009, 0.729637, 0.171767>, <-0.323649, 0.800659, 0.213655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107268, 0.622747, 0.031803>, <0.179222, 0.721624, -0.004630>, <0.048279, 0.873959, -0.074782>, <-0.079136, 0.871370, -0.081107>, 
      <0.114408, 0.660267, 0.106330>, <0.186361, 0.759144, 0.069897>, <0.042823, 0.978725, -0.007759>, <-0.084592, 0.976136, -0.014084>, 
      <0.130128, 0.738560, 0.193566>, <0.217476, 0.900627, 0.166029>, <-0.020873, 1.003525, 0.089058>, <-0.091367, 1.126693, 0.060782>, 
      <0.137659, 0.810032, 0.236555>, <0.225007, 0.972099, 0.209017>, <-0.026828, 1.097423, 0.170579>, <-0.097322, 1.220590, 0.142303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225948, 0.541184, -0.179820>, <-0.237836, 0.563380, -0.121886>, <-0.252752, 0.581119, -0.038343>, <-0.265574, 0.615171, 0.013294>, 
      <-0.298122, 0.531474, -0.222893>, <-0.310010, 0.553670, -0.164959>, <-0.324693, 0.677072, -0.081920>, <-0.337514, 0.711124, -0.030282>, 
      <-0.110244, 0.549905, -0.280253>, <-0.115788, 0.645223, -0.207596>, <-0.201007, 0.773463, -0.160089>, <-0.206551, 0.868781, -0.087432>, 
      <-0.060657, 0.553643, -0.323295>, <-0.066201, 0.648961, -0.250639>, <-0.073592, 0.776052, -0.153763>, <-0.079136, 0.871370, -0.081107>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.092798, 0.574288, -0.231713>, <0.097139, 0.588826, -0.152658>, <0.100405, 0.586682, -0.039835>, <0.107268, 0.622747, 0.031803>, 
      <-0.001665, 0.567168, -0.149717>, <0.002676, 0.581705, -0.070663>, <0.019145, 0.475017, 0.001310>, <0.026009, 0.511082, 0.072948>, 
      <-0.119073, 0.555562, -0.116037>, <-0.130961, 0.577759, -0.058103>, <-0.171508, 0.472756, 0.010869>, <-0.184329, 0.506808, 0.062506>, 
      <-0.225948, 0.541184, -0.179820>, <-0.237836, 0.563380, -0.121886>, <-0.252752, 0.581119, -0.038343>, <-0.265574, 0.615171, 0.013294>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.092798, 0.574288, -0.231713>, <0.145144, 0.578234, -0.277150>, <-0.014621, 0.559836, -0.295820>, <-0.060657, 0.553643, -0.323295>, 
      <0.097139, 0.588826, -0.152658>, <0.149485, 0.592771, -0.198096>, <-0.020164, 0.655155, -0.223164>, <-0.066201, 0.648961, -0.250639>, 
      <0.100405, 0.586682, -0.039835>, <0.172358, 0.685558, -0.076268>, <0.053823, 0.778641, -0.147438>, <-0.073592, 0.776052, -0.153763>, 
      <0.107268, 0.622747, 0.031803>, <0.179222, 0.721624, -0.004630>, <0.048279, 0.873959, -0.074782>, <-0.079136, 0.871370, -0.081107>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.342544, 1.017595, 0.453989>, <-0.439918, 1.117233, 0.503603>, <-0.176571, 1.198315, 0.562354>, <-0.105440, 1.275766, 0.608796>, 
      <-0.336875, 0.967681, 0.427117>, <-0.434249, 1.067318, 0.476731>, <-0.174136, 1.195648, 0.516952>, <-0.103005, 1.273099, 0.563394>, 
      <-0.333608, 0.885133, 0.409091>, <-0.424297, 1.045554, 0.435449>, <-0.167399, 1.162673, 0.470159>, <-0.099501, 1.287372, 0.498071>, 
      <-0.323649, 0.851213, 0.364415>, <-0.414337, 1.011634, 0.390773>, <-0.165220, 1.142178, 0.429544>, <-0.097322, 1.266877, 0.457456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.146864, 1.017595, 0.480241>, <0.029824, 0.890156, 0.403824>, <-0.218001, 0.890156, 0.390531>, <-0.342544, 1.017595, 0.453989>, 
      <0.144102, 0.967681, 0.452916>, <0.027062, 0.840241, 0.376500>, <-0.212332, 0.840241, 0.363659>, <-0.336875, 0.967681, 0.427117>, 
      <0.142783, 0.885134, 0.434644>, <0.059124, 0.731489, 0.400253>, <-0.246751, 0.731489, 0.383846>, <-0.333608, 0.885133, 0.409091>, 
      <0.137659, 0.851213, 0.389159>, <0.054000, 0.697569, 0.354768>, <-0.236792, 0.697569, 0.339170>, <-0.323649, 0.851213, 0.364415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.146864, 1.017595, 0.480241>, <0.144102, 0.967681, 0.452916>, <0.142783, 0.885134, 0.434644>, <0.137659, 0.851213, 0.389159>, 
      <0.238371, 1.117233, 0.539987>, <0.235610, 1.067318, 0.512662>, <0.230131, 1.045554, 0.470552>, <0.225007, 1.011634, 0.425067>, 
      <-0.029749, 1.198315, 0.570230>, <-0.027313, 1.195648, 0.524828>, <-0.029006, 1.162673, 0.477582>, <-0.026828, 1.142178, 0.436967>, 
      <-0.105440, 1.275766, 0.608796>, <-0.103005, 1.273099, 0.563394>, <-0.099501, 1.287372, 0.498071>, <-0.097322, 1.266877, 0.457456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.265574, 0.755448, 0.108722>, <-0.282572, 0.771295, 0.189177>, <-0.309009, 0.801352, 0.298745>, <-0.323649, 0.851213, 0.364415>, 
      <-0.337514, 0.860757, 0.104741>, <-0.354512, 0.876604, 0.185196>, <-0.399697, 0.961773, 0.325103>, <-0.414337, 1.011634, 0.390773>, 
      <-0.206551, 1.028313, 0.111573>, <-0.212007, 1.099882, 0.213287>, <-0.159265, 1.086159, 0.318529>, <-0.165220, 1.142178, 0.429544>, 
      <-0.079136, 1.028313, 0.118407>, <-0.084592, 1.099882, 0.220122>, <-0.091367, 1.210859, 0.346441>, <-0.097322, 1.266877, 0.457456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107268, 0.755448, 0.128721>, <0.114408, 0.761940, 0.211907>, <0.130128, 0.801352, 0.322299>, <0.137659, 0.851213, 0.389159>, 
      <0.026009, 0.636519, 0.124500>, <0.033148, 0.643011, 0.207686>, <0.046469, 0.647708, 0.287908>, <0.054000, 0.697569, 0.354768>, 
      <-0.184329, 0.636519, 0.113217>, <-0.201327, 0.652366, 0.193672>, <-0.222152, 0.647708, 0.273500>, <-0.236792, 0.697569, 0.339170>, 
      <-0.265574, 0.755448, 0.108722>, <-0.282572, 0.771295, 0.189177>, <-0.309009, 0.801352, 0.298745>, <-0.323649, 0.851213, 0.364415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107268, 0.755448, 0.128721>, <0.179222, 0.860757, 0.132459>, <0.048279, 1.028313, 0.125241>, <-0.079136, 1.028313, 0.118407>, 
      <0.114408, 0.761940, 0.211907>, <0.186361, 0.867249, 0.215645>, <0.042823, 1.099882, 0.226956>, <-0.084592, 1.099882, 0.220122>, 
      <0.130128, 0.801352, 0.322299>, <0.217476, 0.961773, 0.358207>, <-0.020873, 1.086159, 0.325952>, <-0.091367, 1.210859, 0.346441>, 
      <0.137659, 0.851213, 0.389159>, <0.225007, 1.011634, 0.425067>, <-0.026828, 1.142178, 0.436967>, <-0.097322, 1.266877, 0.457456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225948, 0.760129, -0.098027>, <-0.237836, 0.758725, -0.036002>, <-0.252752, 0.743495, 0.048034>, <-0.265574, 0.755448, 0.108722>, 
      <-0.298122, 0.767459, -0.141568>, <-0.310010, 0.766055, -0.079544>, <-0.324693, 0.848804, 0.044053>, <-0.337514, 0.860757, 0.104741>, 
      <-0.110244, 0.806245, -0.187671>, <-0.115788, 0.866936, -0.084322>, <-0.201007, 0.967622, 0.008223>, <-0.206551, 1.028313, 0.111573>, 
      <-0.060657, 0.826009, -0.226090>, <-0.066201, 0.886700, -0.122741>, <-0.073592, 0.967622, 0.015058>, <-0.079136, 1.028313, 0.118407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.092798, 0.810423, -0.133513>, <0.097139, 0.793931, -0.054843>, <0.100405, 0.749208, 0.048760>, <0.107268, 0.755448, 0.128721>, 
      <-0.001665, 0.772773, -0.060325>, <0.002676, 0.756280, 0.018345>, <0.019145, 0.630279, 0.044539>, <0.026009, 0.636519, 0.124500>, 
      <-0.119073, 0.749274, -0.033551>, <-0.130961, 0.747870, 0.028474>, <-0.171508, 0.624566, 0.052529>, <-0.184329, 0.636519, 0.113217>, 
      <-0.225948, 0.760129, -0.098027>, <-0.237836, 0.758725, -0.036002>, <-0.252752, 0.743495, 0.048034>, <-0.265574, 0.755448, 0.108722>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.092798, 0.810423, -0.133513>, <0.145144, 0.831287, -0.174069>, <-0.014621, 0.821333, -0.198317>, <-0.060657, 0.826009, -0.226090>, 
      <0.097139, 0.793931, -0.054843>, <0.149485, 0.814794, -0.095399>, <-0.020164, 0.882024, -0.094968>, <-0.066201, 0.886700, -0.122741>, 
      <0.100405, 0.749208, 0.048760>, <0.172358, 0.854517, 0.052498>, <0.053823, 0.967622, 0.021892>, <-0.073592, 0.967622, 0.015058>, 
      <0.107268, 0.755448, 0.128721>, <0.179222, 0.860757, 0.132459>, <0.048279, 1.028313, 0.125241>, <-0.079136, 1.028313, 0.118407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.329696, 0.877485, 0.015616>, <-0.424272, 0.990971, 0.022481>, <-0.158157, 1.083322, 0.028068>, <-0.084640, 1.171538, 0.033404>, 
      <-0.325475, 0.861433, -0.006810>, <-0.420052, 0.974919, 0.000056>, <-0.158157, 1.061459, -0.011887>, <-0.084640, 1.149675, -0.006551>, 
      <-0.320014, 0.842820, -0.039035>, <-0.409160, 0.948832, -0.054720>, <-0.153936, 1.052183, -0.059591>, <-0.084640, 1.134588, -0.071784>, 
      <-0.315626, 0.823977, -0.059136>, <-0.404772, 0.929988, -0.074822>, <-0.153936, 1.016257, -0.087586>, <-0.084640, 1.098662, -0.099779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.160416, 0.877485, 0.015616>, <0.039450, 0.732333, 0.006835>, <-0.208730, 0.732333, 0.006835>, <-0.329696, 0.877485, 0.015616>, 
      <0.156195, 0.861433, -0.006810>, <0.035229, 0.716281, -0.015590>, <-0.204509, 0.716281, -0.015590>, <-0.325475, 0.861433, -0.006810>, 
      <0.150734, 0.842820, -0.039035>, <0.036714, 0.707229, -0.018972>, <-0.205994, 0.707229, -0.018972>, <-0.320014, 0.842820, -0.039035>, 
      <0.146346, 0.823977, -0.059136>, <0.032326, 0.688385, -0.039074>, <-0.201605, 0.688385, -0.039074>, <-0.315626, 0.823977, -0.059136>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.160416, 0.877485, 0.015616>, <0.156195, 0.861433, -0.006810>, <0.150734, 0.842820, -0.039035>, <0.146346, 0.823977, -0.059136>, 
      <0.254992, 0.990971, 0.022481>, <0.250771, 0.974919, 0.000056>, <0.239881, 0.948832, -0.054720>, <0.235492, 0.929988, -0.074822>, 
      <-0.011123, 1.083322, 0.028068>, <-0.011123, 1.061459, -0.011887>, <-0.015344, 1.052183, -0.059591>, <-0.015344, 1.016257, -0.087586>, 
      <-0.084640, 1.171538, 0.033404>, <-0.084640, 1.149675, -0.006551>, <-0.084640, 1.134588, -0.071784>, <-0.084640, 1.098662, -0.099779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.271329, 0.626850, -0.251753>, <-0.282818, 0.692779, -0.201410>, <-0.302455, 0.767417, -0.119473>, <-0.315626, 0.823977, -0.059136>, 
      <-0.343379, 0.669658, -0.272150>, <-0.354868, 0.735586, -0.221807>, <-0.391601, 0.873428, -0.135158>, <-0.404772, 0.929988, -0.074822>, 
      <-0.170894, 0.737768, -0.304604>, <-0.170894, 0.846036, -0.243157>, <-0.153936, 0.918059, -0.164105>, <-0.153936, 1.016257, -0.087586>, 
      <-0.084640, 0.737768, -0.304604>, <-0.084640, 0.846036, -0.243157>, <-0.084640, 1.000465, -0.176298>, <-0.084640, 1.098662, -0.099779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.102049, 0.626850, -0.251753>, <0.112969, 0.686066, -0.193553>, <0.133175, 0.767417, -0.119473>, <0.146346, 0.823977, -0.059136>, 
      <-0.018322, 0.555334, -0.217676>, <-0.007402, 0.614550, -0.159476>, <0.019154, 0.631825, -0.099410>, <0.032326, 0.688385, -0.039074>, 
      <-0.150958, 0.555334, -0.217676>, <-0.162447, 0.621262, -0.167333>, <-0.188434, 0.631825, -0.099410>, <-0.201605, 0.688385, -0.039074>, 
      <-0.271329, 0.626850, -0.251753>, <-0.282818, 0.692779, -0.201410>, <-0.302455, 0.767417, -0.119473>, <-0.315626, 0.823977, -0.059136>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.102049, 0.626850, -0.251753>, <0.174099, 0.669658, -0.272150>, <0.001614, 0.737768, -0.304604>, <-0.084640, 0.737768, -0.304604>, 
      <0.112969, 0.686066, -0.193553>, <0.185020, 0.728874, -0.213950>, <0.001614, 0.846036, -0.243157>, <-0.084640, 0.846036, -0.243157>, 
      <0.133175, 0.767417, -0.119473>, <0.222321, 0.873428, -0.135158>, <-0.015344, 0.918059, -0.164105>, <-0.084640, 1.000465, -0.176298>, 
      <0.146346, 0.823977, -0.059136>, <0.235492, 0.929988, -0.074822>, <-0.015344, 1.016257, -0.087586>, <-0.084640, 1.098662, -0.099779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.242834, 0.406267, -0.378101>, <-0.251383, 0.472442, -0.340197>, <-0.260801, 0.566436, -0.297886>, <-0.271329, 0.626850, -0.251753>, 
      <-0.317236, 0.395945, -0.417042>, <-0.325785, 0.462120, -0.379138>, <-0.332851, 0.609243, -0.318283>, <-0.343379, 0.669658, -0.272150>, 
      <-0.132098, 0.406999, -0.484342>, <-0.132098, 0.506136, -0.416761>, <-0.170894, 0.638632, -0.372185>, <-0.170894, 0.737768, -0.304604>, 
      <-0.084640, 0.407313, -0.529874>, <-0.084640, 0.506450, -0.462293>, <-0.084640, 0.638632, -0.372185>, <-0.084640, 0.737768, -0.304604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.073554, 0.429260, -0.447078>, <0.082102, 0.488537, -0.388481>, <0.091123, 0.567602, -0.309984>, <0.102049, 0.626850, -0.251753>, 
      <-0.016854, 0.428662, -0.360340>, <-0.008305, 0.487939, -0.301743>, <-0.029248, 0.496086, -0.275907>, <-0.018322, 0.555334, -0.217676>, 
      <-0.132659, 0.421552, -0.320437>, <-0.141207, 0.487727, -0.282533>, <-0.140430, 0.494919, -0.263809>, <-0.150958, 0.555334, -0.217676>, 
      <-0.242834, 0.406267, -0.378101>, <-0.251383, 0.472442, -0.340197>, <-0.260801, 0.566436, -0.297886>, <-0.271329, 0.626850, -0.251753>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.073554, 0.429260, -0.447078>, <0.123653, 0.429591, -0.495143>, <-0.037182, 0.413897, -0.505035>, <-0.084640, 0.407313, -0.529874>, 
      <0.082102, 0.488537, -0.388481>, <0.132201, 0.488868, -0.436546>, <-0.037182, 0.513034, -0.437454>, <-0.084640, 0.506450, -0.462293>, 
      <0.091123, 0.567602, -0.309984>, <0.163173, 0.610410, -0.330381>, <0.001614, 0.638632, -0.372185>, <-0.084640, 0.638632, -0.372185>, 
      <0.102049, 0.626850, -0.251753>, <0.174099, 0.669658, -0.272150>, <0.001614, 0.737768, -0.304604>, <-0.084640, 0.737768, -0.304604>
    }
  }
  texture {
    HornGradient
    scale <0.5, 0.55, 0.5>
    translate <0.000000, 1.200000, 0.000000>
  }
}
#declare RightHorn = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.204054, 1.355055, 1.500000>, <-0.204054, 1.355055, 1.457586>, <-0.168758, 1.355055, 1.422289>, <-0.126343, 1.355055, 1.422289>, 
      <-0.237069, 1.411030, 1.500000>, <-0.237069, 1.411030, 1.457586>, <-0.169927, 1.417848, 1.389596>, <-0.127513, 1.417848, 1.389596>, 
      <-0.295784, 1.479289, 1.500000>, <-0.295784, 1.479289, 1.398495>, <-0.221012, 1.483608, 1.329067>, <-0.120273, 1.496061, 1.329067>, 
      <-0.314104, 1.541639, 1.500000>, <-0.314104, 1.541639, 1.398495>, <-0.230981, 1.551914, 1.313313>, <-0.130242, 1.564366, 1.313313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.126343, 1.355055, 1.577711>, <-0.168758, 1.355055, 1.577711>, <-0.204054, 1.355055, 1.542415>, <-0.204054, 1.355055, 1.500000>, 
      <-0.127513, 1.417848, 1.610404>, <-0.169927, 1.417848, 1.610404>, <-0.237069, 1.411030, 1.542415>, <-0.237069, 1.411030, 1.500000>, 
      <-0.120273, 1.496061, 1.670933>, <-0.221012, 1.483608, 1.670933>, <-0.295784, 1.479289, 1.601505>, <-0.295784, 1.479289, 1.500000>, 
      <-0.130242, 1.564366, 1.686687>, <-0.230981, 1.551914, 1.686687>, <-0.314104, 1.541639, 1.601505>, <-0.314104, 1.541639, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.048632, 1.355055, 1.500000>, <-0.048632, 1.355055, 1.542415>, <-0.083928, 1.355055, 1.577711>, <-0.126343, 1.355055, 1.577711>, 
      <-0.017956, 1.424666, 1.500000>, <-0.017956, 1.424666, 1.542415>, <-0.085098, 1.417848, 1.610404>, <-0.127513, 1.417848, 1.610404>, 
      <0.049256, 1.511148, 1.500000>, <0.049256, 1.511148, 1.601505>, <-0.019535, 1.508513, 1.670933>, <-0.120273, 1.496061, 1.670933>, 
      <0.053620, 1.587093, 1.500000>, <0.053620, 1.587093, 1.601505>, <-0.029503, 1.576818, 1.686687>, <-0.130242, 1.564366, 1.686687>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.048632, 1.355055, 1.500000>, <-0.017956, 1.424666, 1.500000>, <0.049256, 1.511148, 1.500000>, <0.053620, 1.587093, 1.500000>, 
      <-0.048632, 1.355055, 1.457586>, <-0.017956, 1.424666, 1.457586>, <0.049256, 1.511148, 1.398495>, <0.053620, 1.587093, 1.398495>, 
      <-0.083928, 1.355055, 1.422289>, <-0.085098, 1.417848, 1.389596>, <-0.019535, 1.508513, 1.329067>, <-0.029503, 1.576818, 1.313313>, 
      <-0.126343, 1.355055, 1.422289>, <-0.127513, 1.417848, 1.389596>, <-0.120273, 1.496061, 1.329067>, <-0.130242, 1.564366, 1.313313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.342817, 1.827323, 1.500000>, <-0.309784, 1.747772, 1.500000>, <-0.338386, 1.624283, 1.500000>, <-0.314104, 1.541639, 1.500000>, 
      <-0.342817, 1.827323, 1.398696>, <-0.309784, 1.747772, 1.398696>, <-0.338386, 1.624283, 1.398495>, <-0.314104, 1.541639, 1.398495>, 
      <-0.303495, 1.881684, 1.292880>, <-0.262462, 1.781557, 1.289369>, <-0.246224, 1.656359, 1.289223>, <-0.230981, 1.551914, 1.313313>, 
      <-0.208228, 1.916131, 1.292880>, <-0.167195, 1.816004, 1.289369>, <-0.145485, 1.668811, 1.289223>, <-0.130242, 1.564366, 1.313313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.208228, 1.916131, 1.707120>, <-0.167195, 1.816004, 1.710631>, <-0.145485, 1.668811, 1.710777>, <-0.130242, 1.564366, 1.686687>, 
      <-0.303495, 1.881684, 1.707120>, <-0.262462, 1.781557, 1.710631>, <-0.246224, 1.656359, 1.710777>, <-0.230981, 1.551914, 1.686687>, 
      <-0.342817, 1.827323, 1.601304>, <-0.309784, 1.747772, 1.601304>, <-0.338386, 1.624283, 1.601505>, <-0.314104, 1.541639, 1.601505>, 
      <-0.342817, 1.827323, 1.500000>, <-0.309784, 1.747772, 1.500000>, <-0.338386, 1.624283, 1.500000>, <-0.314104, 1.541639, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014673, 1.945974, 1.500000>, <0.030631, 1.846180, 1.500000>, <0.059908, 1.696509, 1.500000>, <0.053620, 1.587093, 1.500000>, 
      <-0.014673, 1.945974, 1.610011>, <0.030631, 1.846180, 1.610011>, <0.059908, 1.696509, 1.601505>, <0.053620, 1.587093, 1.601505>, 
      <-0.104772, 1.953539, 1.707120>, <-0.063739, 1.853412, 1.710631>, <-0.044747, 1.681263, 1.710777>, <-0.029503, 1.576818, 1.686687>, 
      <-0.208228, 1.916131, 1.707120>, <-0.167195, 1.816004, 1.710631>, <-0.145485, 1.668811, 1.710777>, <-0.130242, 1.564366, 1.686687>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014673, 1.945974, 1.500000>, <-0.014673, 1.945974, 1.389989>, <-0.104772, 1.953539, 1.292880>, <-0.208228, 1.916131, 1.292880>, 
      <0.030631, 1.846180, 1.500000>, <0.030631, 1.846180, 1.389989>, <-0.063739, 1.853412, 1.289369>, <-0.167195, 1.816004, 1.289369>, 
      <0.059908, 1.696509, 1.500000>, <0.059908, 1.696509, 1.398495>, <-0.044747, 1.681263, 1.289223>, <-0.145485, 1.668811, 1.289223>, 
      <0.053620, 1.587093, 1.500000>, <0.053620, 1.587093, 1.398495>, <-0.029503, 1.576818, 1.313313>, <-0.130242, 1.564366, 1.313313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.536938, 2.078282, 1.500000>, <-0.479131, 2.002664, 1.500000>, <-0.379319, 1.915228, 1.500000>, <-0.342817, 1.827323, 1.500000>, 
      <-0.536938, 2.078282, 1.404922>, <-0.479131, 2.002664, 1.404922>, <-0.379319, 1.915228, 1.398696>, <-0.342817, 1.827323, 1.398696>, 
      <-0.461060, 2.121518, 1.334334>, <-0.404338, 2.051237, 1.327368>, <-0.337827, 1.965457, 1.295818>, <-0.303495, 1.881684, 1.292880>, 
      <-0.375898, 2.163795, 1.334334>, <-0.319177, 2.093514, 1.327368>, <-0.242560, 1.999904, 1.295818>, <-0.208228, 1.916131, 1.292880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.375898, 2.163795, 1.665666>, <-0.319177, 2.093514, 1.672632>, <-0.242560, 1.999904, 1.704182>, <-0.208228, 1.916131, 1.707120>, 
      <-0.461060, 2.121518, 1.665666>, <-0.404338, 2.051237, 1.672632>, <-0.337827, 1.965457, 1.704182>, <-0.303495, 1.881684, 1.707120>, 
      <-0.536938, 2.078282, 1.595078>, <-0.479131, 2.002664, 1.595078>, <-0.379319, 1.915228, 1.601304>, <-0.342817, 1.827323, 1.601304>, 
      <-0.536938, 2.078282, 1.500000>, <-0.479131, 2.002664, 1.500000>, <-0.379319, 1.915228, 1.500000>, <-0.342817, 1.827323, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.236969, 2.227197, 1.500000>, <-0.167837, 2.144821, 1.500000>, <-0.059127, 2.043897, 1.500000>, <-0.014673, 1.945974, 1.500000>, 
      <-0.236969, 2.227197, 1.586957>, <-0.167837, 2.144821, 1.586957>, <-0.059127, 2.043897, 1.610011>, <-0.014673, 1.945974, 1.610011>, 
      <-0.298010, 2.202461, 1.665666>, <-0.241289, 2.132180, 1.672632>, <-0.139104, 2.037312, 1.704182>, <-0.104772, 1.953539, 1.707120>, 
      <-0.375898, 2.163795, 1.665666>, <-0.319177, 2.093514, 1.672632>, <-0.242560, 1.999904, 1.704182>, <-0.208228, 1.916131, 1.707120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.236969, 2.227197, 1.500000>, <-0.236969, 2.227197, 1.413043>, <-0.298010, 2.202461, 1.334334>, <-0.375898, 2.163795, 1.334334>, 
      <-0.167837, 2.144821, 1.500000>, <-0.167837, 2.144821, 1.413043>, <-0.241289, 2.132180, 1.327368>, <-0.319177, 2.093514, 1.327368>, 
      <-0.059127, 2.043897, 1.500000>, <-0.059127, 2.043897, 1.389989>, <-0.139104, 2.037312, 1.295818>, <-0.242560, 1.999904, 1.295818>, 
      <-0.014673, 1.945974, 1.500000>, <-0.014673, 1.945974, 1.389989>, <-0.104772, 1.953539, 1.292880>, <-0.208228, 1.916131, 1.292880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.681967, 2.270966, 1.500000>, <-0.642895, 2.210074, 1.500000>, <-0.580878, 2.135760, 1.500000>, <-0.536938, 2.078282, 1.500000>, 
      <-0.681967, 2.270966, 1.413691>, <-0.642895, 2.210074, 1.413691>, <-0.580878, 2.135760, 1.404922>, <-0.536938, 2.078282, 1.404922>, 
      <-0.629973, 2.315351, 1.334334>, <-0.584163, 2.259577, 1.331567>, <-0.506288, 2.177558, 1.339888>, <-0.461060, 2.121518, 1.334334>, 
      <-0.545790, 2.334389, 1.334334>, <-0.499981, 2.278615, 1.331567>, <-0.421126, 2.219835, 1.339888>, <-0.375898, 2.163795, 1.334334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.545790, 2.334389, 1.665666>, <-0.499981, 2.278615, 1.668433>, <-0.421126, 2.219835, 1.660112>, <-0.375898, 2.163795, 1.665666>, 
      <-0.629973, 2.315351, 1.665666>, <-0.584163, 2.259577, 1.668433>, <-0.506288, 2.177558, 1.660112>, <-0.461060, 2.121518, 1.665666>, 
      <-0.681967, 2.270966, 1.586309>, <-0.642895, 2.210074, 1.586309>, <-0.580878, 2.135760, 1.595078>, <-0.536938, 2.078282, 1.595078>, 
      <-0.681967, 2.270966, 1.500000>, <-0.642895, 2.210074, 1.500000>, <-0.580878, 2.135760, 1.500000>, <-0.536938, 2.078282, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.350353, 2.345961, 1.500000>, <-0.323267, 2.304817, 1.500000>, <-0.268635, 2.264929, 1.500000>, <-0.236969, 2.227197, 1.500000>, 
      <-0.350353, 2.345961, 1.598980>, <-0.323267, 2.304817, 1.598980>, <-0.268635, 2.264929, 1.586957>, <-0.236969, 2.227197, 1.586957>, 
      <-0.449248, 2.356222, 1.665666>, <-0.403439, 2.300448, 1.668433>, <-0.343238, 2.258501, 1.660112>, <-0.298010, 2.202461, 1.665666>, 
      <-0.545790, 2.334389, 1.665666>, <-0.499981, 2.278615, 1.668433>, <-0.421126, 2.219835, 1.660112>, <-0.375898, 2.163795, 1.665666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.350353, 2.345961, 1.500000>, <-0.350353, 2.345961, 1.401020>, <-0.449248, 2.356222, 1.334334>, <-0.545790, 2.334389, 1.334334>, 
      <-0.323267, 2.304817, 1.500000>, <-0.323267, 2.304817, 1.401020>, <-0.403439, 2.300448, 1.331567>, <-0.499981, 2.278615, 1.331567>, 
      <-0.268635, 2.264929, 1.500000>, <-0.268635, 2.264929, 1.413043>, <-0.343238, 2.258501, 1.339888>, <-0.421126, 2.219835, 1.339888>, 
      <-0.236969, 2.227197, 1.500000>, <-0.236969, 2.227197, 1.413043>, <-0.298010, 2.202461, 1.334334>, <-0.375898, 2.163795, 1.334334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.716247, 2.357728, 1.500000>, <-0.721133, 2.330171, 1.500000>, <-0.697081, 2.294521, 1.500000>, <-0.681967, 2.270966, 1.500000>, 
      <-0.716247, 2.357728, 1.414468>, <-0.721133, 2.330171, 1.414468>, <-0.697081, 2.294521, 1.413691>, <-0.681967, 2.270966, 1.413691>, 
      <-0.638509, 2.353612, 1.345477>, <-0.634136, 2.337411, 1.342134>, <-0.640825, 2.328564, 1.334990>, <-0.629973, 2.315351, 1.334334>, 
      <-0.560367, 2.388392, 1.345477>, <-0.555994, 2.372191, 1.342134>, <-0.556642, 2.347602, 1.334990>, <-0.545790, 2.334389, 1.334334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560367, 2.388392, 1.654523>, <-0.555994, 2.372191, 1.657866>, <-0.556642, 2.347602, 1.665010>, <-0.545790, 2.334389, 1.665666>, 
      <-0.638509, 2.353612, 1.654523>, <-0.634136, 2.337411, 1.657866>, <-0.640825, 2.328564, 1.665010>, <-0.629973, 2.315351, 1.665666>, 
      <-0.716247, 2.357728, 1.585532>, <-0.721133, 2.330171, 1.585532>, <-0.697081, 2.294521, 1.586309>, <-0.681967, 2.270966, 1.586309>, 
      <-0.716247, 2.357728, 1.500000>, <-0.721133, 2.330171, 1.500000>, <-0.697081, 2.294521, 1.500000>, <-0.681967, 2.270966, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560367, 2.388392, 1.654523>, <-0.560367, 2.388392, 1.561809>, <-0.560367, 2.388392, 1.438191>, <-0.560367, 2.388392, 1.345477>, 
      <-0.560367, 2.388392, 1.654523>, <-0.638509, 2.353612, 1.561809>, <-0.638509, 2.353612, 1.438191>, <-0.638509, 2.353612, 1.345477>, 
      <-0.560367, 2.388392, 1.654523>, <-0.638509, 2.353612, 1.561809>, <-0.716247, 2.357728, 1.500000>, <-0.716247, 2.357728, 1.414468>, 
      <-0.560367, 2.388392, 1.654523>, <-0.638509, 2.353612, 1.654523>, <-0.716247, 2.357728, 1.585532>, <-0.716247, 2.357728, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.412038, 2.493129, 1.500000>, <-0.396115, 2.447983, 1.500000>, <-0.376676, 2.385946, 1.500000>, <-0.350353, 2.345961, 1.500000>, 
      <-0.412038, 2.493129, 1.592019>, <-0.396115, 2.447983, 1.592019>, <-0.376676, 2.385946, 1.598980>, <-0.350353, 2.345961, 1.598980>, 
      <-0.476299, 2.425810, 1.654523>, <-0.471926, 2.409609, 1.657866>, <-0.460100, 2.369435, 1.665010>, <-0.449248, 2.356222, 1.665666>, 
      <-0.560367, 2.388392, 1.654523>, <-0.555994, 2.372191, 1.657866>, <-0.556642, 2.347602, 1.665010>, <-0.545790, 2.334389, 1.665666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.412038, 2.493129, 1.500000>, <-0.412038, 2.493129, 1.407981>, <-0.476299, 2.425810, 1.345477>, <-0.560367, 2.388392, 1.345477>, 
      <-0.396115, 2.447983, 1.500000>, <-0.396115, 2.447983, 1.407981>, <-0.471926, 2.409609, 1.342134>, <-0.555994, 2.372191, 1.342134>, 
      <-0.376676, 2.385946, 1.500000>, <-0.376676, 2.385946, 1.401020>, <-0.460100, 2.369435, 1.334990>, <-0.556642, 2.347602, 1.334990>, 
      <-0.350353, 2.345961, 1.500000>, <-0.350353, 2.345961, 1.401020>, <-0.449248, 2.356222, 1.334334>, <-0.545790, 2.334389, 1.334334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.412038, 2.493129, 1.500000>, <-0.412038, 2.493129, 1.407981>, <-0.476299, 2.425810, 1.345477>, <-0.560367, 2.388392, 1.345477>, 
      <-0.412038, 2.493129, 1.500000>, <-0.412038, 2.493129, 1.500000>, <-0.476299, 2.425810, 1.438191>, <-0.560367, 2.388392, 1.438191>, 
      <-0.412038, 2.493129, 1.500000>, <-0.412038, 2.493129, 1.500000>, <-0.476299, 2.425810, 1.561809>, <-0.560367, 2.388392, 1.561809>, 
      <-0.412038, 2.493129, 1.500000>, <-0.412038, 2.493129, 1.592019>, <-0.476299, 2.425810, 1.654523>, <-0.560367, 2.388392, 1.654523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562179, 2.946547, 1.500000>, <-0.608399, 2.769901, 1.500000>, <-0.684369, 2.537516, 1.500000>, <-0.716247, 2.357728, 1.500000>, 
      <-0.562179, 2.946547, 1.500000>, <-0.608399, 2.769901, 1.500000>, <-0.684369, 2.537516, 1.414468>, <-0.716247, 2.357728, 1.414468>, 
      <-0.562179, 2.946547, 1.500000>, <-0.561635, 2.779100, 1.453643>, <-0.639052, 2.521058, 1.391834>, <-0.638509, 2.353612, 1.345477>, 
      <-0.562179, 2.946547, 1.500000>, <-0.561635, 2.779100, 1.453643>, <-0.560911, 2.555839, 1.391834>, <-0.560367, 2.388392, 1.345477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562179, 2.946547, 1.500000>, <-0.562179, 2.946547, 1.500000>, <-0.562179, 2.946547, 1.500000>, <-0.562179, 2.946547, 1.500000>, 
      <-0.608399, 2.769901, 1.500000>, <-0.608399, 2.769901, 1.500000>, <-0.561635, 2.779100, 1.546357>, <-0.561635, 2.779100, 1.546357>, 
      <-0.684369, 2.537516, 1.500000>, <-0.684369, 2.537516, 1.585532>, <-0.639052, 2.521058, 1.608166>, <-0.560911, 2.555839, 1.608166>, 
      <-0.716247, 2.357728, 1.500000>, <-0.716247, 2.357728, 1.585532>, <-0.638509, 2.353612, 1.654523>, <-0.560367, 2.388392, 1.654523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562179, 2.946547, 1.500000>, <-0.517137, 2.810522, 1.500000>, <-0.459698, 2.628259, 1.500000>, <-0.412038, 2.493129, 1.500000>, 
      <-0.562179, 2.946547, 1.500000>, <-0.517137, 2.810522, 1.500000>, <-0.459698, 2.628259, 1.592019>, <-0.412038, 2.493129, 1.592019>, 
      <-0.562179, 2.946547, 1.500000>, <-0.561635, 2.779100, 1.546357>, <-0.476843, 2.593256, 1.608166>, <-0.476299, 2.425810, 1.654523>, 
      <-0.562179, 2.946547, 1.500000>, <-0.561635, 2.779100, 1.546357>, <-0.560911, 2.555839, 1.608166>, <-0.560367, 2.388392, 1.654523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562179, 2.946547, 1.500000>, <-0.562179, 2.946547, 1.500000>, <-0.562179, 2.946547, 1.500000>, <-0.562179, 2.946547, 1.500000>, 
      <-0.517137, 2.810522, 1.500000>, <-0.517137, 2.810522, 1.500000>, <-0.561635, 2.779100, 1.453643>, <-0.561635, 2.779100, 1.453643>, 
      <-0.459698, 2.628259, 1.500000>, <-0.459698, 2.628259, 1.407981>, <-0.476843, 2.593256, 1.391834>, <-0.560911, 2.555839, 1.391834>, 
      <-0.412038, 2.493129, 1.500000>, <-0.412038, 2.493129, 1.407981>, <-0.476299, 2.425810, 1.345477>, <-0.560367, 2.388392, 1.345477>
    }
  }
  texture {
    Shiny_White
  }
  translate  0.05*z
}
#declare CentreSpike = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.895659, 0.780117, 0.327174>, <0.990235, 0.999624, 0.548513>, <0.724120, 1.178251, 0.728631>, <0.650603, 1.348880, 0.900684>, 
      <0.891438, 0.772343, 0.285942>, <0.986014, 0.991851, 0.507281>, <0.724120, 1.132892, 0.640208>, <0.650603, 1.303521, 0.812261>, 
      <0.885574, 0.766626, 0.229835>, <0.974720, 0.937781, 0.390466>, <0.719899, 1.111554, 0.568686>, <0.650603, 1.244597, 0.693549>, 
      <0.881589, 0.754205, 0.189733>, <0.970735, 0.925360, 0.350364>, <0.719899, 1.064639, 0.481079>, <0.650603, 1.197682, 0.605942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.405547, 0.780117, 0.327174>, <0.460463, 0.652660, 0.198653>, <0.840743, 0.652660, 0.198653>, <0.895659, 0.780117, 0.327174>, 
      <0.409768, 0.772343, 0.285942>, <0.464684, 0.644886, 0.157421>, <0.836522, 0.644886, 0.157421>, <0.891438, 0.772343, 0.285942>, 
      <0.415632, 0.766626, 0.229835>, <0.478934, 0.645091, 0.115773>, <0.822272, 0.645091, 0.115773>, <0.885574, 0.766626, 0.229835>, 
      <0.419617, 0.754205, 0.189733>, <0.482919, 0.632670, 0.075671>, <0.818287, 0.632670, 0.075671>, <0.881589, 0.754205, 0.189733>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.405547, 0.780117, 0.327174>, <0.409768, 0.772343, 0.285942>, <0.415632, 0.766626, 0.229835>, <0.419617, 0.754205, 0.189733>, 
      <0.310971, 0.999624, 0.548513>, <0.315192, 0.991851, 0.507281>, <0.326486, 0.937781, 0.390466>, <0.330471, 0.925360, 0.350364>, 
      <0.577086, 1.178251, 0.728631>, <0.577086, 1.132892, 0.640208>, <0.581307, 1.111554, 0.568686>, <0.581307, 1.064639, 0.481079>, 
      <0.650603, 1.348880, 0.900684>, <0.650603, 1.303521, 0.812261>, <0.650603, 1.244597, 0.693549>, <0.650603, 1.197682, 0.605942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.837292, 0.598190, -0.260169>, <0.848365, 0.637686, -0.122685>, <0.868031, 0.711945, 0.053298>, <0.881589, 0.754205, 0.189733>, 
      <0.909342, 0.677590, -0.204895>, <0.920416, 0.717086, -0.067411>, <0.957177, 0.883099, 0.213929>, <0.970735, 0.925360, 0.350364>, 
      <0.771230, 0.803922, -0.116949>, <0.771230, 0.922050, 0.099918>, <0.719899, 0.948056, 0.263377>, <0.719899, 1.064639, 0.481079>, 
      <0.650603, 0.803922, -0.116949>, <0.650603, 0.922050, 0.099918>, <0.650603, 1.081099, 0.388240>, <0.650603, 1.197682, 0.605942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.463914, 0.598190, -0.260169>, <0.452841, 0.637686, -0.122685>, <0.433175, 0.711945, 0.053298>, <0.419617, 0.754205, 0.189733>, 
      <0.549986, 0.503339, -0.326199>, <0.538912, 0.542835, -0.188716>, <0.496477, 0.590410, -0.060765>, <0.482919, 0.632670, 0.075671>, 
      <0.751221, 0.503339, -0.326199>, <0.762294, 0.542835, -0.188716>, <0.804729, 0.590410, -0.060765>, <0.818287, 0.632670, 0.075671>, 
      <0.837292, 0.598190, -0.260169>, <0.848365, 0.637686, -0.122685>, <0.868031, 0.711945, 0.053298>, <0.881589, 0.754205, 0.189733>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.463914, 0.598190, -0.260169>, <0.391864, 0.677590, -0.204895>, <0.529976, 0.803922, -0.116949>, <0.650603, 0.803922, -0.116949>, 
      <0.452841, 0.637686, -0.122685>, <0.380790, 0.717086, -0.067411>, <0.529976, 0.922050, 0.099918>, <0.650603, 0.922050, 0.099918>, 
      <0.433175, 0.711945, 0.053298>, <0.344029, 0.883099, 0.213929>, <0.581307, 0.948056, 0.263377>, <0.650603, 1.081099, 0.388240>, 
      <0.419617, 0.754205, 0.189733>, <0.330471, 0.925360, 0.350364>, <0.581307, 1.064639, 0.481079>, <0.650603, 1.197682, 0.605942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.808797, 0.494577, -0.714024>, <0.817345, 0.525661, -0.577867>, <0.826493, 0.559672, -0.394250>, <0.837292, 0.598190, -0.260169>, 
      <0.869850, 0.485465, -0.748976>, <0.878399, 0.516549, -0.612820>, <0.898543, 0.639072, -0.338976>, <0.909342, 0.677590, -0.204895>, 
      <0.698061, 0.478050, -0.777419>, <0.698061, 0.577936, -0.571127>, <0.771230, 0.704036, -0.323241>, <0.771230, 0.803922, -0.116949>, 
      <0.650603, 0.470967, -0.804588>, <0.650603, 0.570854, -0.598296>, <0.650603, 0.704036, -0.323241>, <0.650603, 0.803922, -0.116949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.492409, 0.494577, -0.714024>, <0.483861, 0.525661, -0.577867>, <0.474713, 0.559672, -0.394250>, <0.463914, 0.598190, -0.260169>, 
      <0.597501, 0.510262, -0.653860>, <0.588952, 0.541346, -0.517704>, <0.560785, 0.464821, -0.460280>, <0.549986, 0.503339, -0.326199>, 
      <0.703705, 0.510262, -0.653860>, <0.712254, 0.541346, -0.517704>, <0.740421, 0.464821, -0.460280>, <0.751221, 0.503339, -0.326199>, 
      <0.808797, 0.494577, -0.714024>, <0.817345, 0.525661, -0.577867>, <0.826493, 0.559672, -0.394250>, <0.837292, 0.598190, -0.260169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.492409, 0.494577, -0.714024>, <0.431356, 0.485465, -0.748976>, <0.603145, 0.478050, -0.777419>, <0.650603, 0.470967, -0.804588>, 
      <0.483861, 0.525661, -0.577867>, <0.422808, 0.516549, -0.612820>, <0.603145, 0.577936, -0.571127>, <0.650603, 0.570854, -0.598296>, 
      <0.474713, 0.559672, -0.394250>, <0.402663, 0.639072, -0.338976>, <0.529976, 0.704036, -0.323241>, <0.650603, 0.704036, -0.323241>, 
      <0.463914, 0.598190, -0.260169>, <0.391864, 0.677590, -0.204895>, <0.529976, 0.803922, -0.116949>, <0.650603, 0.803922, -0.116949>
    }
  }
  texture {
    Shiny_LightBlue
  }
}
#declare eyes = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.429316, 0.104352>, <-0.510983, 0.307167, 0.104352>, <-0.367434, 0.307167, 0.104352>, 
      <-0.633130, 0.716414, 0.104352>, <-0.633130, 0.572865, 0.104352>, <-0.510983, 0.307167, 0.247901>, <-0.367434, 0.307167, 0.247901>, 
      <-0.510983, 0.838561, 0.104352>, <-0.510983, 0.838561, 0.247900>, <-0.367434, 0.572865, 0.370047>, <-0.367434, 0.429316, 0.370047>, 
      <-0.367434, 0.838561, 0.104352>, <-0.367434, 0.838561, 0.247900>, <-0.367434, 0.716413, 0.370047>, <-0.367434, 0.572865, 0.370047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.429316, 0.104352>, <-0.510983, 0.307167, 0.104352>, <-0.367434, 0.307167, 0.104352>, 
      <-0.633130, 0.716414, 0.104352>, <-0.633130, 0.572865, 0.104352>, <-0.510983, 0.307167, -0.039197>, <-0.367434, 0.307167, -0.039197>, 
      <-0.510983, 0.838561, 0.104352>, <-0.510983, 0.838561, -0.039196>, <-0.367434, 0.572864, -0.161343>, <-0.367434, 0.429316, -0.161343>, 
      <-0.367434, 0.838561, 0.104352>, <-0.367434, 0.838561, -0.039196>, <-0.367434, 0.716413, -0.161343>, <-0.367434, 0.572865, -0.161343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.716414, 0.104352>, <-0.510983, 0.838561, 0.104352>, <-0.367434, 0.838561, 0.104352>, 
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.716414, -0.039196>, <-0.510983, 0.838561, -0.039196>, <-0.367434, 0.838561, -0.039196>, 
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.716414, -0.039196>, <-0.510982, 0.716413, -0.161343>, <-0.367434, 0.716413, -0.161343>, 
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.572865, -0.039196>, <-0.510982, 0.572865, -0.161343>, <-0.367434, 0.572865, -0.161343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.429316, 0.104352>, <-0.510983, 0.307167, 0.104352>, <-0.367434, 0.307167, 0.104352>, 
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.429316, -0.039196>, <-0.510983, 0.307167, -0.039197>, <-0.367434, 0.307167, -0.039197>, 
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.429316, -0.039196>, <-0.510982, 0.429316, -0.161343>, <-0.367434, 0.429316, -0.161343>, 
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.572865, -0.039196>, <-0.510982, 0.572865, -0.161343>, <-0.367434, 0.572865, -0.161343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.429316, 0.104352>, <-0.510983, 0.307167, 0.104352>, <-0.367434, 0.307167, 0.104352>, 
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.429316, 0.247900>, <-0.510983, 0.307167, 0.247901>, <-0.367434, 0.307167, 0.247901>, 
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.429316, 0.247900>, <-0.510982, 0.429316, 0.370047>, <-0.367434, 0.429316, 0.370047>, 
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.572865, 0.247900>, <-0.510982, 0.572865, 0.370047>, <-0.367434, 0.572865, 0.370047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.572865, 0.247900>, <-0.510982, 0.572865, 0.370047>, <-0.367434, 0.572865, 0.370047>, 
      <-0.633130, 0.572865, -0.039196>, <-0.633130, 0.572865, 0.104352>, <-0.510982, 0.429316, 0.370047>, <-0.367434, 0.429316, 0.370047>, 
      <-0.510982, 0.572865, -0.161343>, <-0.510982, 0.429316, -0.161343>, <-0.367434, 0.307167, 0.104352>, <-0.367434, 0.307167, 0.247901>, 
      <-0.367434, 0.572865, -0.161343>, <-0.367434, 0.429316, -0.161343>, <-0.367434, 0.307167, -0.039197>, <-0.367434, 0.307167, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.716414, 0.104352>, <-0.510983, 0.838561, 0.104352>, <-0.367434, 0.838561, 0.104352>, 
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.716414, 0.247900>, <-0.510983, 0.838561, 0.247900>, <-0.367434, 0.838561, 0.247900>, 
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.716414, 0.247900>, <-0.510982, 0.716413, 0.370047>, <-0.367434, 0.716413, 0.370047>, 
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.572865, 0.247900>, <-0.510982, 0.572865, 0.370047>, <-0.367434, 0.572865, 0.370047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.633130, 0.572865, 0.104352>, <-0.633130, 0.572865, -0.039196>, <-0.510982, 0.572865, -0.161343>, <-0.367434, 0.572865, -0.161343>, 
      <-0.633130, 0.572865, 0.247900>, <-0.633130, 0.572865, 0.104352>, <-0.510982, 0.716413, -0.161343>, <-0.367434, 0.716413, -0.161343>, 
      <-0.510982, 0.572865, 0.370047>, <-0.510982, 0.716413, 0.370047>, <-0.367434, 0.838561, 0.104352>, <-0.367434, 0.838561, -0.039196>, 
      <-0.367434, 0.572865, 0.370047>, <-0.367434, 0.716413, 0.370047>, <-0.367434, 0.838561, 0.247900>, <-0.367434, 0.838561, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.716413, 0.104352>, <-0.223886, 0.838561, 0.104352>, <-0.367434, 0.838561, 0.104352>, 
      <-0.101739, 0.429316, 0.104352>, <-0.101739, 0.572865, 0.104352>, <-0.223886, 0.838561, -0.039196>, <-0.367434, 0.838561, -0.039196>, 
      <-0.223885, 0.307167, 0.104352>, <-0.223885, 0.307167, -0.039197>, <-0.367434, 0.572864, -0.161343>, <-0.367434, 0.716413, -0.161343>, 
      <-0.367434, 0.307167, 0.104352>, <-0.367434, 0.307167, -0.039197>, <-0.367434, 0.429316, -0.161343>, <-0.367434, 0.572865, -0.161343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.716413, 0.104352>, <-0.223886, 0.838561, 0.104352>, <-0.367434, 0.838561, 0.104352>, 
      <-0.101739, 0.429316, 0.104352>, <-0.101739, 0.572865, 0.104352>, <-0.223886, 0.838561, 0.247900>, <-0.367434, 0.838561, 0.247900>, 
      <-0.223885, 0.307167, 0.104352>, <-0.223885, 0.307167, 0.247901>, <-0.367434, 0.572865, 0.370047>, <-0.367434, 0.716413, 0.370047>, 
      <-0.367434, 0.307167, 0.104352>, <-0.367434, 0.307167, 0.247901>, <-0.367434, 0.429316, 0.370047>, <-0.367434, 0.572865, 0.370047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.429316, 0.104352>, <-0.223885, 0.307167, 0.104352>, <-0.367434, 0.307167, 0.104352>, 
      <-0.101739, 0.572865, 0.247900>, <-0.101739, 0.429316, 0.247900>, <-0.367434, 0.307167, 0.104352>, <-0.510983, 0.307167, 0.104352>, 
      <-0.223886, 0.572865, 0.370047>, <-0.367434, 0.572865, 0.370047>, <-0.633130, 0.429316, 0.247900>, <-0.633130, 0.429316, 0.104352>, 
      <-0.367434, 0.572865, 0.370047>, <-0.510982, 0.572865, 0.370047>, <-0.633130, 0.572865, 0.247900>, <-0.633130, 0.572865, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.572865, 0.247900>, <-0.223886, 0.572865, 0.370047>, <-0.367434, 0.572865, 0.370047>, 
      <-0.101739, 0.716413, 0.104352>, <-0.101739, 0.716413, 0.247900>, <-0.367434, 0.572865, 0.370047>, <-0.510982, 0.572865, 0.370047>, 
      <-0.223886, 0.838561, 0.104352>, <-0.367434, 0.838561, 0.104352>, <-0.633130, 0.716414, 0.247900>, <-0.633130, 0.572865, 0.247900>, 
      <-0.367434, 0.838561, 0.104352>, <-0.510983, 0.838561, 0.104352>, <-0.633130, 0.716414, 0.104352>, <-0.633130, 0.572865, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.572865, 0.247900>, <-0.223886, 0.572865, 0.370047>, <-0.367434, 0.572865, 0.370047>, 
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.429316, 0.247900>, <-0.223886, 0.429316, 0.370047>, <-0.367434, 0.429316, 0.370047>, 
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.429316, 0.247900>, <-0.223885, 0.307167, 0.247901>, <-0.367434, 0.307167, 0.247901>, 
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.429316, 0.104352>, <-0.223885, 0.307167, 0.104352>, <-0.367434, 0.307167, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.716413, 0.104352>, <-0.223886, 0.838561, 0.104352>, <-0.367434, 0.838561, 0.104352>, 
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.716413, 0.247900>, <-0.223886, 0.838561, 0.247900>, <-0.367434, 0.838561, 0.247900>, 
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.716413, 0.247900>, <-0.223886, 0.716413, 0.370047>, <-0.367434, 0.716413, 0.370047>, 
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.572865, 0.247900>, <-0.223886, 0.572865, 0.370047>, <-0.367434, 0.572865, 0.370047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.429316, 0.104352>, <-0.223885, 0.307167, 0.104352>, <-0.367434, 0.307167, 0.104352>, 
      <-0.101739, 0.572865, -0.039196>, <-0.101739, 0.429316, -0.039196>, <-0.367434, 0.307167, 0.104352>, <-0.510983, 0.307167, 0.104352>, 
      <-0.223886, 0.572865, -0.161343>, <-0.367434, 0.572865, -0.161343>, <-0.633130, 0.429316, -0.039196>, <-0.633130, 0.429316, 0.104352>, 
      <-0.367434, 0.572865, -0.161343>, <-0.510982, 0.572865, -0.161343>, <-0.633130, 0.572865, -0.039196>, <-0.633130, 0.572865, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.716413, 0.104352>, <-0.223886, 0.838561, 0.104352>, <-0.367434, 0.838561, 0.104352>, 
      <-0.101739, 0.572865, -0.039196>, <-0.101739, 0.716413, -0.039196>, <-0.367434, 0.838561, 0.104352>, <-0.510983, 0.838561, 0.104352>, 
      <-0.223886, 0.572865, -0.161343>, <-0.367434, 0.572865, -0.161343>, <-0.633130, 0.716414, -0.039196>, <-0.633130, 0.716414, 0.104352>, 
      <-0.367434, 0.572865, -0.161343>, <-0.510982, 0.572865, -0.161343>, <-0.633130, 0.572865, -0.039196>, <-0.633130, 0.572865, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.716413, 0.104352>, <-0.223886, 0.838561, 0.104352>, <-0.367434, 0.838561, 0.104352>, 
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.716413, -0.039196>, <-0.223886, 0.838561, -0.039196>, <-0.367434, 0.838561, -0.039196>, 
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.716413, -0.039196>, <-0.223886, 0.716413, -0.161343>, <-0.367434, 0.716413, -0.161343>, 
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.572865, -0.039196>, <-0.223886, 0.572865, -0.161343>, <-0.367434, 0.572865, -0.161343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.572865, 0.247900>, <-0.223886, 0.572865, 0.370047>, <-0.367434, 0.572865, 0.370047>, 
      <-0.101739, 0.572865, -0.039196>, <-0.101739, 0.572865, 0.104352>, <-0.223886, 0.716413, 0.370047>, <-0.367434, 0.716413, 0.370047>, 
      <-0.223886, 0.572865, -0.161343>, <-0.223886, 0.716413, -0.161343>, <-0.367434, 0.838561, 0.104352>, <-0.367434, 0.838561, 0.247900>, 
      <-0.367434, 0.572865, -0.161343>, <-0.367434, 0.716413, -0.161343>, <-0.367434, 0.838561, -0.039196>, <-0.367434, 0.838561, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.429316, 0.104352>, <-0.223885, 0.307167, 0.104352>, <-0.367434, 0.307167, 0.104352>, 
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.429316, -0.039196>, <-0.223885, 0.307167, -0.039197>, <-0.367434, 0.307167, -0.039197>, 
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.429316, -0.039196>, <-0.223886, 0.429316, -0.161343>, <-0.367434, 0.429316, -0.161343>, 
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.572865, -0.039196>, <-0.223886, 0.572865, -0.161343>, <-0.367434, 0.572865, -0.161343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101739, 0.572865, 0.104352>, <-0.101739, 0.572865, -0.039196>, <-0.223886, 0.572865, -0.161343>, <-0.367434, 0.572865, -0.161343>, 
      <-0.101739, 0.572865, 0.247900>, <-0.101739, 0.572865, 0.104352>, <-0.223886, 0.429316, -0.161343>, <-0.367434, 0.429316, -0.161343>, 
      <-0.223886, 0.572865, 0.370047>, <-0.223886, 0.429316, 0.370047>, <-0.367434, 0.307167, 0.104352>, <-0.367434, 0.307167, -0.039197>, 
      <-0.367434, 0.572865, 0.370047>, <-0.367434, 0.429316, 0.370047>, <-0.367434, 0.307167, 0.247901>, <-0.367434, 0.307167, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.429316, 0.104352>, <1.793449, 0.307167, 0.104352>, <1.649900, 0.307167, 0.104352>, 
      <1.915596, 0.716414, 0.104352>, <1.915596, 0.572865, 0.104352>, <1.793449, 0.307167, 0.247901>, <1.649900, 0.307167, 0.247901>, 
      <1.793448, 0.838561, 0.104352>, <1.793448, 0.838561, 0.247900>, <1.649900, 0.572865, 0.370047>, <1.649900, 0.429316, 0.370047>, 
      <1.649900, 0.838561, 0.104352>, <1.649900, 0.838561, 0.247900>, <1.649900, 0.716413, 0.370047>, <1.649900, 0.572865, 0.370047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.429316, 0.104352>, <1.793449, 0.307167, 0.104352>, <1.649900, 0.307167, 0.104352>, 
      <1.915596, 0.716414, 0.104352>, <1.915596, 0.572865, 0.104352>, <1.793449, 0.307167, -0.039197>, <1.649900, 0.307167, -0.039197>, 
      <1.793448, 0.838561, 0.104352>, <1.793448, 0.838561, -0.039196>, <1.649900, 0.572864, -0.161343>, <1.649900, 0.429316, -0.161343>, 
      <1.649900, 0.838561, 0.104352>, <1.649900, 0.838561, -0.039196>, <1.649900, 0.716413, -0.161343>, <1.649900, 0.572865, -0.161343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.716414, 0.104352>, <1.793448, 0.838561, 0.104352>, <1.649900, 0.838561, 0.104352>, 
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.716414, -0.039196>, <1.793448, 0.838561, -0.039196>, <1.649900, 0.838561, -0.039196>, 
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.716414, -0.039196>, <1.793448, 0.716413, -0.161343>, <1.649900, 0.716413, -0.161343>, 
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.572865, -0.039196>, <1.793448, 0.572865, -0.161343>, <1.649900, 0.572865, -0.161343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.429316, 0.104352>, <1.793449, 0.307167, 0.104352>, <1.649900, 0.307167, 0.104352>, 
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.429316, -0.039196>, <1.793449, 0.307167, -0.039197>, <1.649900, 0.307167, -0.039197>, 
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.429316, -0.039196>, <1.793448, 0.429316, -0.161343>, <1.649900, 0.429316, -0.161343>, 
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.572865, -0.039196>, <1.793448, 0.572865, -0.161343>, <1.649900, 0.572865, -0.161343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.429316, 0.104352>, <1.793449, 0.307167, 0.104352>, <1.649900, 0.307167, 0.104352>, 
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.429316, 0.247900>, <1.793449, 0.307167, 0.247901>, <1.649900, 0.307167, 0.247901>, 
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.429316, 0.247900>, <1.793448, 0.429316, 0.370047>, <1.649900, 0.429316, 0.370047>, 
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.572865, 0.247900>, <1.793448, 0.572865, 0.370047>, <1.649900, 0.572865, 0.370047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.572865, 0.247900>, <1.793448, 0.572865, 0.370047>, <1.649900, 0.572865, 0.370047>, 
      <1.915596, 0.572865, -0.039196>, <1.915596, 0.572865, 0.104352>, <1.793448, 0.429316, 0.370047>, <1.649900, 0.429316, 0.370047>, 
      <1.793448, 0.572865, -0.161343>, <1.793448, 0.429316, -0.161343>, <1.649900, 0.307167, 0.104352>, <1.649900, 0.307167, 0.247901>, 
      <1.649900, 0.572865, -0.161343>, <1.649900, 0.429316, -0.161343>, <1.649900, 0.307167, -0.039197>, <1.649900, 0.307167, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.716414, 0.104352>, <1.793448, 0.838561, 0.104352>, <1.649900, 0.838561, 0.104352>, 
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.716414, 0.247900>, <1.793448, 0.838561, 0.247900>, <1.649900, 0.838561, 0.247900>, 
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.716414, 0.247900>, <1.793448, 0.716413, 0.370047>, <1.649900, 0.716413, 0.370047>, 
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.572865, 0.247900>, <1.793448, 0.572865, 0.370047>, <1.649900, 0.572865, 0.370047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.915596, 0.572865, 0.104352>, <1.915596, 0.572865, -0.039196>, <1.793448, 0.572865, -0.161343>, <1.649900, 0.572865, -0.161343>, 
      <1.915596, 0.572865, 0.247900>, <1.915596, 0.572865, 0.104352>, <1.793448, 0.716413, -0.161343>, <1.649900, 0.716413, -0.161343>, 
      <1.793448, 0.572865, 0.370047>, <1.793448, 0.716413, 0.370047>, <1.649900, 0.838561, 0.104352>, <1.649900, 0.838561, -0.039196>, 
      <1.649900, 0.572865, 0.370047>, <1.649900, 0.716413, 0.370047>, <1.649900, 0.838561, 0.247900>, <1.649900, 0.838561, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.716413, 0.104352>, <1.506352, 0.838561, 0.104352>, <1.649900, 0.838561, 0.104352>, 
      <1.384205, 0.429316, 0.104352>, <1.384205, 0.572864, 0.104352>, <1.506352, 0.838561, -0.039196>, <1.649900, 0.838561, -0.039196>, 
      <1.506351, 0.307167, 0.104352>, <1.506351, 0.307167, -0.039197>, <1.649900, 0.572864, -0.161343>, <1.649900, 0.716413, -0.161343>, 
      <1.649900, 0.307167, 0.104352>, <1.649900, 0.307167, -0.039197>, <1.649900, 0.429316, -0.161343>, <1.649900, 0.572865, -0.161343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.716413, 0.104352>, <1.506352, 0.838561, 0.104352>, <1.649900, 0.838561, 0.104352>, 
      <1.384205, 0.429316, 0.104352>, <1.384205, 0.572864, 0.104352>, <1.506352, 0.838561, 0.247900>, <1.649900, 0.838561, 0.247900>, 
      <1.506351, 0.307167, 0.104352>, <1.506351, 0.307167, 0.247901>, <1.649900, 0.572865, 0.370047>, <1.649900, 0.716413, 0.370047>, 
      <1.649900, 0.307167, 0.104352>, <1.649900, 0.307167, 0.247901>, <1.649900, 0.429316, 0.370047>, <1.649900, 0.572865, 0.370047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.429316, 0.104352>, <1.506351, 0.307167, 0.104352>, <1.649900, 0.307167, 0.104352>, 
      <1.384205, 0.572865, 0.247900>, <1.384205, 0.429316, 0.247900>, <1.649900, 0.307167, 0.104352>, <1.793449, 0.307167, 0.104352>, 
      <1.506352, 0.572865, 0.370047>, <1.649900, 0.572865, 0.370047>, <1.915596, 0.429316, 0.247900>, <1.915596, 0.429316, 0.104352>, 
      <1.649900, 0.572865, 0.370047>, <1.793448, 0.572865, 0.370047>, <1.915596, 0.572865, 0.247900>, <1.915596, 0.572865, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.572865, 0.247900>, <1.506352, 0.572865, 0.370047>, <1.649900, 0.572865, 0.370047>, 
      <1.384205, 0.716413, 0.104352>, <1.384205, 0.716413, 0.247900>, <1.649900, 0.572865, 0.370047>, <1.793448, 0.572865, 0.370047>, 
      <1.506352, 0.838561, 0.104352>, <1.649900, 0.838561, 0.104352>, <1.915596, 0.716414, 0.247900>, <1.915596, 0.572865, 0.247900>, 
      <1.649900, 0.838561, 0.104352>, <1.793448, 0.838561, 0.104352>, <1.915596, 0.716414, 0.104352>, <1.915596, 0.572865, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.572865, 0.247900>, <1.506352, 0.572865, 0.370047>, <1.649900, 0.572865, 0.370047>, 
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.429316, 0.247900>, <1.506352, 0.429316, 0.370047>, <1.649900, 0.429316, 0.370047>, 
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.429316, 0.247900>, <1.506351, 0.307167, 0.247901>, <1.649900, 0.307167, 0.247901>, 
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.429316, 0.104352>, <1.506351, 0.307167, 0.104352>, <1.649900, 0.307167, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.716413, 0.104352>, <1.506352, 0.838561, 0.104352>, <1.649900, 0.838561, 0.104352>, 
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.716413, 0.247900>, <1.506352, 0.838561, 0.247900>, <1.649900, 0.838561, 0.247900>, 
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.716413, 0.247900>, <1.506352, 0.716413, 0.370047>, <1.649900, 0.716413, 0.370047>, 
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.572865, 0.247900>, <1.506352, 0.572865, 0.370047>, <1.649900, 0.572865, 0.370047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.429316, 0.104352>, <1.506351, 0.307167, 0.104352>, <1.649900, 0.307167, 0.104352>, 
      <1.384205, 0.572865, -0.039196>, <1.384205, 0.429316, -0.039196>, <1.649900, 0.307167, 0.104352>, <1.793449, 0.307167, 0.104352>, 
      <1.506352, 0.572865, -0.161343>, <1.649900, 0.572865, -0.161343>, <1.915596, 0.429316, -0.039196>, <1.915596, 0.429316, 0.104352>, 
      <1.649900, 0.572865, -0.161343>, <1.793448, 0.572865, -0.161343>, <1.915596, 0.572865, -0.039196>, <1.915596, 0.572865, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.716413, 0.104352>, <1.506352, 0.838561, 0.104352>, <1.649900, 0.838561, 0.104352>, 
      <1.384205, 0.572865, -0.039196>, <1.384205, 0.716413, -0.039196>, <1.649900, 0.838561, 0.104352>, <1.793448, 0.838561, 0.104352>, 
      <1.506352, 0.572865, -0.161343>, <1.649900, 0.572865, -0.161343>, <1.915596, 0.716414, -0.039196>, <1.915596, 0.716414, 0.104352>, 
      <1.649900, 0.572865, -0.161343>, <1.793448, 0.572865, -0.161343>, <1.915596, 0.572865, -0.039196>, <1.915596, 0.572865, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.716413, 0.104352>, <1.506352, 0.838561, 0.104352>, <1.649900, 0.838561, 0.104352>, 
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.716413, -0.039196>, <1.506352, 0.838561, -0.039196>, <1.649900, 0.838561, -0.039196>, 
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.716413, -0.039196>, <1.506352, 0.716413, -0.161343>, <1.649900, 0.716413, -0.161343>, 
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.572865, -0.039196>, <1.506352, 0.572865, -0.161343>, <1.649900, 0.572865, -0.161343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.572865, 0.247900>, <1.506352, 0.572865, 0.370047>, <1.649900, 0.572865, 0.370047>, 
      <1.384205, 0.572865, -0.039196>, <1.384205, 0.572865, 0.104352>, <1.506352, 0.716413, 0.370047>, <1.649900, 0.716413, 0.370047>, 
      <1.506352, 0.572865, -0.161343>, <1.506352, 0.716413, -0.161343>, <1.649900, 0.838561, 0.104352>, <1.649900, 0.838561, 0.247900>, 
      <1.649900, 0.572865, -0.161343>, <1.649900, 0.716413, -0.161343>, <1.649900, 0.838561, -0.039196>, <1.649900, 0.838561, 0.104352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.429316, 0.104352>, <1.506351, 0.307167, 0.104352>, <1.649900, 0.307167, 0.104352>, 
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.429316, -0.039196>, <1.506351, 0.307167, -0.039197>, <1.649900, 0.307167, -0.039197>, 
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.429316, -0.039196>, <1.506352, 0.429316, -0.161343>, <1.649900, 0.429316, -0.161343>, 
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.572865, -0.039196>, <1.506352, 0.572865, -0.161343>, <1.649900, 0.572865, -0.161343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.384205, 0.572865, 0.104352>, <1.384205, 0.572865, -0.039196>, <1.506352, 0.572865, -0.161343>, <1.649900, 0.572865, -0.161343>, 
      <1.384205, 0.572865, 0.247900>, <1.384205, 0.572865, 0.104352>, <1.506352, 0.429316, -0.161343>, <1.649900, 0.429316, -0.161343>, 
      <1.506352, 0.572865, 0.370047>, <1.506352, 0.429316, 0.370047>, <1.649900, 0.307167, 0.104352>, <1.649900, 0.307167, -0.039197>, 
      <1.649900, 0.572865, 0.370047>, <1.649900, 0.429316, 0.370047>, <1.649900, 0.307167, 0.247901>, <1.649900, 0.307167, 0.104352>
    }
  }
  texture {
    Shiny_Red
  }
}
#declare EarFlaps = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.873739, 0.072945, 1.319456>, <-0.895753, 0.228466, 1.287862>, <-0.915156, 0.425545, 1.202350>, <-0.932906, 0.576659, 1.152162>, 
      <-0.816658, 0.072945, 1.217313>, <-0.838671, 0.228466, 1.185718>, <-0.861754, 0.369410, 1.146429>, <-0.879504, 0.520524, 1.096241>, 
      <-0.763386, 0.072945, 1.069725>, <-0.762662, 0.183675, 1.070230>, <-0.780170, 0.371699, 1.020210>, <-0.779445, 0.482428, 1.020715>, 
      <-0.716092, 0.072945, 0.962698>, <-0.715368, 0.183675, 0.963203>, <-0.714401, 0.331314, 0.963875>, <-0.713676, 0.442044, 0.964380>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.809360, -0.296154, 1.329473>, <-0.808624, -0.183716, 1.329985>, <-0.858290, -0.036201, 1.341629>, <-0.873739, 0.072945, 1.319456>, 
      <-0.762675, -0.296154, 1.225637>, <-0.761940, -0.183716, 1.226150>, <-0.801208, -0.036201, 1.239485>, <-0.816658, 0.072945, 1.217313>, 
      <-0.745762, -0.296154, 1.071553>, <-0.745038, -0.185424, 1.072058>, <-0.764111, -0.037785, 1.069221>, <-0.763386, 0.072945, 1.069725>, 
      <-0.718506, -0.296154, 0.961016>, <-0.717782, -0.185424, 0.961521>, <-0.716816, -0.037785, 0.962193>, <-0.716092, 0.072945, 0.962698>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.878568, -0.665253, 1.316092>, <-0.859833, -0.554572, 1.326430>, <-0.810098, -0.408881, 1.328959>, <-0.809360, -0.296154, 1.329473>, 
      <-0.821487, -0.665253, 1.213949>, <-0.802752, -0.554572, 1.224286>, <-0.763413, -0.408881, 1.225124>, <-0.762675, -0.296154, 1.225637>, 
      <-0.768215, -0.665253, 1.066361>, <-0.767190, -0.554624, 1.061668>, <-0.746487, -0.406884, 1.071049>, <-0.745762, -0.296154, 1.071553>, 
      <-0.720921, -0.665253, 0.959334>, <-0.719896, -0.554624, 0.954640>, <-0.719230, -0.406884, 0.960511>, <-0.718506, -0.296154, 0.961016>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.878568, -0.665253, 1.316092>, <-0.821487, -0.665253, 1.213949>, <-0.768215, -0.665253, 1.066361>, <-0.720921, -0.665253, 0.959334>, 
      <-0.897384, -0.776414, 1.305709>, <-0.840303, -0.776414, 1.203566>, <-0.768265, -0.670624, 1.066589>, <-0.720971, -0.670624, 0.959562>, 
      <-0.917590, -0.923622, 1.277194>, <-0.853383, -0.828123, 1.176822>, <-0.785354, -0.777468, 1.056691>, <-0.721648, -0.667853, 0.971583>, 
      <-0.934314, -1.034352, 1.260524>, <-0.870106, -0.938853, 1.160152>, <-0.785666, -0.778582, 1.061940>, <-0.721960, -0.668967, 0.976833>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.089546, -0.665253, 1.618963>, <-1.026253, -0.665253, 1.528102>, <-0.932587, -0.665253, 1.412755>, <-0.878568, -0.665253, 1.316092>, 
      <-1.112130, -0.852393, 1.618715>, <-1.048836, -0.852393, 1.527853>, <-0.951403, -0.776414, 1.402373>, <-0.897384, -0.776414, 1.305709>, 
      <-1.125174, -1.103554, 1.627405>, <-1.052243, -1.027105, 1.522708>, <-0.980135, -1.016647, 1.374966>, <-0.917590, -0.923622, 1.277194>, 
      <-1.140443, -1.291397, 1.631023>, <-1.067512, -1.214948, 1.526326>, <-0.996858, -1.127377, 1.358296>, <-0.934314, -1.034352, 1.260524>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.020338, -0.296154, 1.632345>, <-0.957045, -0.296154, 1.541483>, <-0.854768, -0.296154, 1.430468>, <-0.809360, -0.296154, 1.329473>, 
      <-1.021076, -0.408881, 1.631831>, <-0.957782, -0.408881, 1.540969>, <-0.855505, -0.408881, 1.429955>, <-0.810098, -0.408881, 1.328959>, 
      <-1.076040, -0.553334, 1.619112>, <-1.012747, -0.553334, 1.528250>, <-0.913852, -0.554572, 1.423093>, <-0.859833, -0.554572, 1.326430>, 
      <-1.089546, -0.665253, 1.618963>, <-1.026253, -0.665253, 1.528102>, <-0.932587, -0.665253, 1.412755>, <-0.878568, -0.665253, 1.316092>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.084717, 0.072945, 1.622328>, <-1.146782, 0.370538, 1.611335>, <-1.237957, 0.765423, 1.594217>, <-1.303631, 1.062200, 1.582169>, 
      <-1.021424, 0.072945, 1.531466>, <-1.083489, 0.370538, 1.520474>, <-1.134417, 0.632579, 1.446365>, <-1.200091, 0.929355, 1.434317>, 
      <-0.927758, 0.072945, 1.416120>, <-0.949772, 0.228466, 1.384526>, <-1.040410, 0.557211, 1.333514>, <-1.058160, 0.708325, 1.283325>, 
      <-0.873739, 0.072945, 1.319456>, <-0.895753, 0.228466, 1.287862>, <-0.915156, 0.425545, 1.202350>, <-0.932906, 0.576659, 1.152162>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.084717, 0.072945, 1.622328>, <-1.021424, 0.072945, 1.531466>, <-0.927758, 0.072945, 1.416120>, <-0.873739, 0.072945, 1.319456>, 
      <-1.061776, -0.037056, 1.626391>, <-0.998482, -0.037056, 1.535530>, <-0.912309, -0.036201, 1.438292>, <-0.858290, -0.036201, 1.341629>, 
      <-1.019603, -0.183716, 1.632858>, <-0.956309, -0.183716, 1.541996>, <-0.854032, -0.183716, 1.430981>, <-0.808624, -0.183716, 1.329985>, 
      <-1.020338, -0.296154, 1.632345>, <-0.957045, -0.296154, 1.541483>, <-0.854768, -0.296154, 1.430468>, <-0.809360, -0.296154, 1.329473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.072945, 1.925199>, <-1.343669, 0.419731, 1.912627>, <-1.398470, 0.883237, 1.893470>, <-1.442517, 1.230505, 1.879872>, 
      <-1.214013, 0.072945, 1.850433>, <-1.261988, 0.419731, 1.837861>, <-1.356804, 0.832745, 1.804159>, <-1.400851, 1.180013, 1.790561>, 
      <-1.148010, 0.072945, 1.713189>, <-1.210075, 0.370538, 1.702197>, <-1.289114, 0.831060, 1.667268>, <-1.354789, 1.127837, 1.655221>, 
      <-1.084717, 0.072945, 1.622328>, <-1.146782, 0.370538, 1.611335>, <-1.237957, 0.765423, 1.594217>, <-1.303631, 1.062200, 1.582169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295694, 0.072945, 1.925199>, <-1.384953, 0.072945, 2.006903>, <-1.537992, 0.072945, 2.070158>, <-1.641834, 0.072945, 2.132284>, 
      <-1.343669, 0.419731, 1.912627>, <-1.432929, 0.419731, 1.994331>, <-1.530176, 0.471259, 2.066885>, <-1.634018, 0.471259, 2.129011>, 
      <-1.398470, 0.883237, 1.893470>, <-1.440136, 0.933729, 1.982781>, <-1.557867, 0.950559, 2.074676>, <-1.599532, 1.001051, 2.163987>, 
      <-1.442517, 1.230505, 1.879872>, <-1.484183, 1.280997, 1.969183>, <-1.539737, 1.348319, 2.088263>, <-1.581403, 1.398811, 2.177574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.231315, -0.296154, 1.935217>, <-1.332070, -0.296154, 2.030010>, <-1.499657, -0.296154, 2.114617>, <-1.614661, -0.296154, 2.191502>, 
      <-1.230579, -0.183716, 1.935729>, <-1.331334, -0.183716, 2.030523>, <-1.499678, -0.183716, 2.115513>, <-1.614682, -0.183716, 2.192398>, 
      <-1.280295, -0.038364, 1.929234>, <-1.369555, -0.038364, 2.010938>, <-1.540198, -0.039471, 2.071082>, <-1.644040, -0.039471, 2.133208>, 
      <-1.295694, 0.072945, 1.925199>, <-1.384953, 0.072945, 2.006903>, <-1.537992, 0.072945, 2.070158>, <-1.641834, 0.072945, 2.132284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.231315, -0.296154, 1.935217>, <-1.230579, -0.183716, 1.935729>, <-1.280295, -0.038364, 1.929234>, <-1.295694, 0.072945, 1.925199>, 
      <-1.150665, -0.296154, 1.859339>, <-1.149930, -0.183716, 1.859851>, <-1.198614, -0.038364, 1.854468>, <-1.214013, 0.072945, 1.850433>, 
      <-1.083631, -0.296154, 1.723207>, <-1.082896, -0.183716, 1.723719>, <-1.125069, -0.037056, 1.717253>, <-1.148010, 0.072945, 1.713189>, 
      <-1.020338, -0.296154, 1.632345>, <-1.019603, -0.183716, 1.632858>, <-1.061776, -0.037056, 1.626391>, <-1.084717, 0.072945, 1.622328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.300524, -0.665253, 1.921835>, <-1.326224, -0.908050, 1.907654>, <-1.339546, -1.233238, 1.882937>, <-1.356269, -1.476660, 1.866266>, 
      <-1.388392, -0.665253, 2.002588>, <-1.414092, -0.908050, 1.988407>, <-1.404116, -1.316193, 1.960201>, <-1.420840, -1.559616, 1.943530>, 
      <-1.539343, -0.665253, 2.065031>, <-1.520987, -1.005160, 2.044643>, <-1.512843, -1.361189, 2.038404>, <-1.480425, -1.700575, 2.030936>, 
      <-1.641694, -0.665253, 2.126400>, <-1.623338, -1.005160, 2.106012>, <-1.566053, -1.457153, 2.108976>, <-1.533635, -1.796538, 2.101509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.300524, -0.665253, 1.921835>, <-1.218992, -0.665253, 1.846905>, <-1.152839, -0.665253, 1.709825>, <-1.089546, -0.665253, 1.618963>, 
      <-1.326224, -0.908050, 1.907654>, <-1.244692, -0.908050, 1.832724>, <-1.175423, -0.852393, 1.709576>, <-1.112130, -0.852393, 1.618715>, 
      <-1.339546, -1.233238, 1.882937>, <-1.284740, -1.162828, 1.817357>, <-1.179468, -1.160466, 1.705347>, <-1.125174, -1.103554, 1.627405>, 
      <-1.356269, -1.476660, 1.866266>, <-1.301463, -1.406250, 1.800687>, <-1.194737, -1.348310, 1.708965>, <-1.140443, -1.291397, 1.631023>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.300524, -0.665253, 1.921835>, <-1.388392, -0.665253, 2.002588>, <-1.539343, -0.665253, 2.065031>, <-1.641694, -0.665253, 2.126400>, 
      <-1.288678, -0.553337, 1.928372>, <-1.376546, -0.553337, 2.009125>, <-1.545411, -0.552887, 2.071770>, <-1.647762, -0.552887, 2.133140>, 
      <-1.232053, -0.408881, 1.934703>, <-1.332807, -0.408881, 2.029497>, <-1.499636, -0.408881, 2.113718>, <-1.614640, -0.408881, 2.190603>, 
      <-1.231315, -0.296154, 1.935217>, <-1.332070, -0.296154, 2.030010>, <-1.499657, -0.296154, 2.114617>, <-1.614661, -0.296154, 2.191502>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.300524, -0.665253, 1.921835>, <-1.288678, -0.553337, 1.928372>, <-1.232053, -0.408881, 1.934703>, <-1.231315, -0.296154, 1.935217>, 
      <-1.218992, -0.665253, 1.846905>, <-1.207146, -0.553337, 1.853442>, <-1.151403, -0.408881, 1.858825>, <-1.150665, -0.296154, 1.859339>, 
      <-1.152839, -0.665253, 1.709825>, <-1.139333, -0.553334, 1.709973>, <-1.084369, -0.408881, 1.722693>, <-1.083631, -0.296154, 1.723207>, 
      <-1.089546, -0.665253, 1.618963>, <-1.076040, -0.553334, 1.619112>, <-1.021076, -0.408881, 1.631831>, <-1.020338, -0.296154, 1.632345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.121722, -0.369099, 1.330481>, <2.141420, -0.524620, 1.297394>, <2.154658, -0.721699, 1.210713>, <2.168773, -0.872813, 1.159384>, 
      <2.057481, -0.369099, 1.232681>, <2.077179, -0.524620, 1.199594>, <2.097393, -0.665563, 1.158754>, <2.111509, -0.816678, 1.107425>, 
      <1.993791, -0.369099, 1.089282>, <1.993104, -0.479829, 1.089837>, <2.006990, -0.667853, 1.038693>, <2.006304, -0.778582, 1.039249>, 
      <1.938963, -0.369099, 0.985911>, <1.938277, -0.479829, 0.986466>, <1.937361, -0.627468, 0.987207>, <1.936674, -0.738198, 0.987762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.058224, 0.000000, 1.345077>, <2.057527, -0.112438, 1.345641>, <2.107898, -0.259953, 1.353702>, <2.121722, -0.369099, 1.330481>, 
      <2.004232, 0.000000, 1.244846>, <2.003535, -0.112438, 1.245410>, <2.043657, -0.259953, 1.255902>, <2.057481, -0.369099, 1.232681>, 
      <1.976343, 0.000000, 1.092366>, <1.975656, -0.110730, 1.092921>, <1.994477, -0.258369, 1.088727>, <1.993791, -0.369099, 1.089282>, 
      <1.941251, 0.000000, 0.984061>, <1.940565, -0.110730, 0.984616>, <1.939650, -0.258369, 0.985356>, <1.938963, -0.369099, 0.985911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.126298, 0.369099, 1.326780>, <2.108350, 0.258418, 1.338431>, <2.058923, 0.112727, 1.344512>, <2.058224, 0.000000, 1.345077>, 
      <2.062057, 0.369099, 1.228980>, <2.044110, 0.258418, 1.240632>, <2.004931, 0.112727, 1.244281>, <2.004232, 0.000000, 1.244846>, 
      <1.998367, 0.369099, 1.085581>, <1.997009, 0.258470, 1.080973>, <1.977029, 0.110730, 1.091811>, <1.976343, 0.000000, 1.092366>, 
      <1.943540, 0.369099, 0.982210>, <1.942182, 0.258470, 0.977602>, <1.941938, 0.110730, 0.983506>, <1.941251, 0.000000, 0.984061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.126298, 0.369099, 1.326780>, <2.062057, 0.369099, 1.228980>, <1.998367, 0.369099, 1.085581>, <1.943540, 0.369099, 0.982210>, 
      <2.144323, 0.480260, 1.315078>, <2.080083, 0.480260, 1.217278>, <1.998433, 0.374470, 1.085805>, <1.943606, 0.374470, 0.982434>, 
      <2.162438, 0.627468, 1.285191>, <2.091217, 0.531969, 1.189668>, <2.014771, 0.481314, 1.074709>, <1.945142, 0.371699, 0.994376>, 
      <2.177927, 0.738198, 1.267367>, <2.106705, 0.642699, 1.171844>, <2.015458, 0.482428, 1.079923>, <1.945828, 0.372813, 0.999590>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.358397, 0.369099, 1.613787>, <2.288767, 0.369099, 1.527685>, <2.187092, 0.369099, 1.419333>, <2.126298, 0.369099, 1.326780>, 
      <2.380905, 0.556239, 1.611924>, <2.311276, 0.556239, 1.525822>, <2.205117, 0.480260, 1.407631>, <2.144323, 0.480260, 1.315078>, 
      <2.394537, 0.807400, 1.619659>, <2.314305, 0.730951, 1.520446>, <2.231815, 0.720494, 1.378239>, <2.162438, 0.627468, 1.285191>, 
      <2.410026, 0.995243, 1.622175>, <2.329794, 0.918794, 1.522962>, <2.247304, 0.831223, 1.360415>, <2.177927, 0.738198, 1.267367>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.290323, 0.000000, 1.632084>, <2.220693, 0.000000, 1.545982>, <2.110739, 0.000000, 1.442566>, <2.058224, 0.000000, 1.345077>, 
      <2.291022, 0.112727, 1.631519>, <2.221392, 0.112727, 1.545417>, <2.111437, 0.112727, 1.442001>, <2.058923, 0.112727, 1.344512>, 
      <2.344936, 0.257180, 1.614901>, <2.275306, 0.257180, 1.528799>, <2.169144, 0.258418, 1.430984>, <2.108350, 0.258418, 1.338431>, 
      <2.358397, 0.369099, 1.613787>, <2.288767, 0.369099, 1.527685>, <2.187092, 0.369099, 1.419333>, <2.126298, 0.369099, 1.326780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.353821, -0.369099, 1.617488>, <2.414941, -0.666692, 1.602085>, <2.504658, -1.061577, 1.578490>, <2.569302, -1.358354, 1.561776>, 
      <2.284191, -0.369099, 1.531386>, <2.345311, -0.666692, 1.515983>, <2.390809, -0.928733, 1.438422>, <2.455453, -1.225509, 1.421708>, 
      <2.182516, -0.369099, 1.423034>, <2.202214, -0.524620, 1.389946>, <2.288972, -0.853365, 1.332583>, <2.303087, -1.004479, 1.281254>, 
      <2.121722, -0.369099, 1.330481>, <2.141420, -0.524620, 1.297394>, <2.154658, -0.721699, 1.210713>, <2.168773, -0.872813, 1.159384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.353821, -0.369099, 1.617488>, <2.284191, -0.369099, 1.531386>, <2.182516, -0.369099, 1.423034>, <2.121722, -0.369099, 1.330481>, 
      <2.331229, -0.259098, 1.623182>, <2.261599, -0.259098, 1.537079>, <2.168692, -0.259953, 1.446255>, <2.107898, -0.259953, 1.353702>, 
      <2.289626, -0.112438, 1.632648>, <2.219996, -0.112438, 1.546545>, <2.110041, -0.112438, 1.443130>, <2.057527, -0.112438, 1.345641>, 
      <2.290323, 0.000000, 1.632084>, <2.220693, 0.000000, 1.545982>, <2.110739, 0.000000, 1.442566>, <2.058224, 0.000000, 1.345077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.585919, -0.369099, 1.904495>, <2.632872, -0.715885, 1.888524>, <2.686162, -1.179391, 1.865497>, <2.729124, -1.526659, 1.848783>, 
      <2.499100, -0.369099, 1.835762>, <2.546053, -0.715885, 1.819791>, <2.638216, -1.128899, 1.779395>, <2.681178, -1.476167, 1.762681>, 
      <2.423450, -0.369099, 1.703590>, <2.484570, -0.666692, 1.688187>, <2.560909, -1.127214, 1.647695>, <2.625553, -1.423991, 1.630982>, 
      <2.353821, -0.369099, 1.617488>, <2.414941, -0.666692, 1.602085>, <2.504658, -1.061577, 1.578490>, <2.569302, -1.358354, 1.561776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.585919, -0.369099, 1.904495>, <2.680793, -0.369099, 1.979606>, <2.837964, -0.369099, 2.031754>, <2.945983, -0.369099, 2.086294>, 
      <2.632872, -0.715885, 1.888524>, <2.727747, -0.715885, 1.963635>, <2.829934, -0.767413, 2.029049>, <2.937953, -0.767413, 2.083588>, 
      <2.686162, -1.179391, 1.865497>, <2.734109, -1.229883, 1.951599>, <2.858110, -1.246713, 2.034839>, <2.906057, -1.297205, 2.120941>, 
      <2.729124, -1.526659, 1.848783>, <2.777071, -1.577151, 1.934885>, <2.840999, -1.644473, 2.049688>, <2.888946, -1.694965, 2.135790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.522421, 0.000000, 1.919091>, <2.629697, 0.000000, 2.006435>, <2.802907, 0.000000, 2.078840>, <2.923115, 0.000000, 2.147303>, 
      <2.521724, -0.112438, 1.919655>, <2.629000, -0.112438, 2.006999>, <2.802992, -0.112438, 2.079732>, <2.923200, -0.112438, 2.148196>, 
      <2.570848, -0.257790, 1.909621>, <2.665723, -0.257790, 1.984732>, <2.840230, -0.256683, 2.032518>, <2.948249, -0.256683, 2.087058>, 
      <2.585919, -0.369099, 1.904495>, <2.680793, -0.369099, 1.979606>, <2.837964, -0.369099, 2.031754>, <2.945983, -0.369099, 2.086294>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.522421, 0.000000, 1.919091>, <2.521724, -0.112438, 1.919655>, <2.570848, -0.257790, 1.909621>, <2.585919, -0.369099, 1.904495>, 
      <2.436551, 0.000000, 1.849176>, <2.435854, -0.112438, 1.849739>, <2.484029, -0.257790, 1.840888>, <2.499100, -0.369099, 1.835762>, 
      <2.359952, 0.000000, 1.718186>, <2.359255, -0.112438, 1.718750>, <2.400858, -0.259098, 1.709284>, <2.423450, -0.369099, 1.703590>, 
      <2.290323, 0.000000, 1.632084>, <2.289626, -0.112438, 1.632648>, <2.331229, -0.259098, 1.623182>, <2.353821, -0.369099, 1.617488>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.590496, 0.369099, 1.900794>, <2.615116, 0.611896, 1.884811>, <2.626636, 0.937084, 1.859204>, <2.642124, 1.180506, 1.841380>, 
      <2.683915, 0.369099, 1.975056>, <2.708534, 0.611896, 1.959073>, <2.696265, 0.992663, 1.924966>, <2.711753, 1.236085, 1.907142>, 
      <2.838945, 0.369099, 2.026543>, <2.828240, 0.668127, 2.007556>, <2.825953, 1.011189, 2.000778>, <2.804593, 1.310189, 1.994823>, 
      <2.945423, 0.369099, 2.080435>, <2.934718, 0.668127, 2.061449>, <2.895583, 1.066767, 2.066540>, <2.874223, 1.365768, 2.060585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.590496, 0.369099, 1.900794>, <2.503814, 0.369099, 1.831887>, <2.428027, 0.369099, 1.699889>, <2.358397, 0.369099, 1.613787>, 
      <2.615116, 0.611896, 1.884811>, <2.528434, 0.611896, 1.815904>, <2.450535, 0.556239, 1.698026>, <2.380905, 0.556239, 1.611924>, 
      <2.626636, 0.937084, 1.859204>, <2.557006, 0.881505, 1.793443>, <2.454267, 0.864313, 1.693518>, <2.394537, 0.807400, 1.619659>, 
      <2.642124, 1.180506, 1.841380>, <2.572495, 1.124927, 1.775619>, <2.469755, 1.052156, 1.696034>, <2.410026, 0.995243, 1.622175>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.590496, 0.369099, 1.900794>, <2.683915, 0.369099, 1.975056>, <2.838945, 0.369099, 2.026543>, <2.945423, 0.369099, 2.080435>, 
      <2.579148, 0.257183, 1.908161>, <2.672567, 0.257183, 1.982423>, <2.842970, 0.256666, 2.033681>, <2.949448, 0.256666, 2.087574>, 
      <2.523120, 0.112727, 1.918526>, <2.630396, 0.112727, 2.005870>, <2.802821, 0.112727, 2.077945>, <2.923029, 0.112727, 2.146408>, 
      <2.522421, 0.000000, 1.919091>, <2.629697, 0.000000, 2.006435>, <2.802907, 0.000000, 2.078840>, <2.923115, 0.000000, 2.147303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.590496, 0.369099, 1.900794>, <2.579148, 0.257183, 1.908161>, <2.523120, 0.112727, 1.918526>, <2.522421, 0.000000, 1.919091>, 
      <2.503814, 0.369099, 1.831887>, <2.492466, 0.257183, 1.839255>, <2.437250, 0.112727, 1.848611>, <2.436551, 0.000000, 1.849176>, 
      <2.428027, 0.369099, 1.699889>, <2.414566, 0.257180, 1.701003>, <2.360651, 0.112727, 1.717621>, <2.359952, 0.000000, 1.718186>, 
      <2.358397, 0.369099, 1.613787>, <2.344936, 0.257180, 1.614901>, <2.291022, 0.112727, 1.631519>, <2.290323, 0.000000, 1.632084>
    }
  }
  texture {
    Mesh
  }
}
#declare EarSpikes = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.850330, 0.965996>, <-0.827823, -0.917591, 0.965996>, <-0.748777, -0.917591, 0.965996>, 
      <-0.895084, -0.692238, 0.965996>, <-0.895084, -0.771284, 0.965996>, <-0.827823, -0.917591, 1.045042>, <-0.748777, -0.917591, 1.045042>, 
      <-0.827823, -0.624977, 0.965996>, <-0.827823, -0.624977, 1.045042>, <-0.748777, -0.771284, 1.112303>, <-0.748777, -0.850330, 1.112303>, 
      <-0.748777, -0.624977, 0.965996>, <-0.748777, -0.624977, 1.045042>, <-0.748777, -0.692238, 1.112303>, <-0.748777, -0.771284, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.850330, 0.965996>, <-0.827823, -0.917591, 0.965996>, <-0.748777, -0.917591, 0.965996>, 
      <-0.895084, -0.692238, 0.965996>, <-0.895084, -0.771284, 0.965996>, <-0.827823, -0.917591, 0.886950>, <-0.748777, -0.917591, 0.886950>, 
      <-0.827823, -0.624977, 0.965996>, <-0.827823, -0.624977, 0.886950>, <-0.748777, -0.771284, 0.819690>, <-0.748777, -0.850329, 0.819690>, 
      <-0.748777, -0.624977, 0.965996>, <-0.748777, -0.624977, 0.886950>, <-0.748777, -0.692238, 0.819690>, <-0.748777, -0.771284, 0.819690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.692238, 0.965996>, <-0.827823, -0.624977, 0.965996>, <-0.748777, -0.624977, 0.965996>, 
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.692238, 0.886950>, <-0.827823, -0.624977, 0.886950>, <-0.748777, -0.624977, 0.886950>, 
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.692238, 0.886950>, <-0.827823, -0.692238, 0.819690>, <-0.748777, -0.692238, 0.819690>, 
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.771284, 0.886950>, <-0.827823, -0.771284, 0.819690>, <-0.748777, -0.771284, 0.819690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.850330, 0.965996>, <-0.827823, -0.917591, 0.965996>, <-0.748777, -0.917591, 0.965996>, 
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.850330, 0.886950>, <-0.827823, -0.917591, 0.886950>, <-0.748777, -0.917591, 0.886950>, 
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.850330, 0.886950>, <-0.827823, -0.850329, 0.819690>, <-0.748777, -0.850329, 0.819690>, 
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.771284, 0.886950>, <-0.827823, -0.771284, 0.819690>, <-0.748777, -0.771284, 0.819690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.850330, 0.965996>, <-0.827823, -0.917591, 0.965996>, <-0.748777, -0.917591, 0.965996>, 
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.850330, 1.045042>, <-0.827823, -0.917591, 1.045042>, <-0.748777, -0.917591, 1.045042>, 
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.850330, 1.045042>, <-0.827823, -0.850330, 1.112303>, <-0.748777, -0.850330, 1.112303>, 
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.771284, 1.045042>, <-0.827823, -0.771284, 1.112303>, <-0.748777, -0.771284, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.771284, 1.045042>, <-0.827823, -0.771284, 1.112303>, <-0.748777, -0.771284, 1.112303>, 
      <-0.895084, -0.771284, 0.886950>, <-0.895084, -0.771284, 0.965996>, <-0.827823, -0.850330, 1.112303>, <-0.748777, -0.850330, 1.112303>, 
      <-0.827823, -0.771284, 0.819690>, <-0.827823, -0.850329, 0.819690>, <-0.748777, -0.917591, 0.965996>, <-0.748777, -0.917591, 1.045042>, 
      <-0.748777, -0.771284, 0.819690>, <-0.748777, -0.850329, 0.819690>, <-0.748777, -0.917591, 0.886950>, <-0.748777, -0.917591, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.692238, 0.965996>, <-0.827823, -0.624977, 0.965996>, <-0.748777, -0.624977, 0.965996>, 
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.692238, 1.045042>, <-0.827823, -0.624977, 1.045042>, <-0.748777, -0.624977, 1.045042>, 
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.692238, 1.045042>, <-0.827823, -0.692238, 1.112303>, <-0.748777, -0.692238, 1.112303>, 
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.771284, 1.045042>, <-0.827823, -0.771284, 1.112303>, <-0.748777, -0.771284, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, -0.771284, 0.965996>, <-0.895084, -0.771284, 0.886950>, <-0.827823, -0.771284, 0.819690>, <-0.748777, -0.771284, 0.819690>, 
      <-0.895084, -0.771284, 1.045042>, <-0.895084, -0.771284, 0.965996>, <-0.827823, -0.692238, 0.819690>, <-0.748777, -0.692238, 0.819690>, 
      <-0.827823, -0.771284, 1.112303>, <-0.827823, -0.692238, 1.112303>, <-0.748777, -0.624977, 0.965996>, <-0.748777, -0.624977, 0.886950>, 
      <-0.748777, -0.771284, 1.112303>, <-0.748777, -0.692238, 1.112303>, <-0.748777, -0.624977, 1.045042>, <-0.748777, -0.624977, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.692238, 0.965996>, <-0.669732, -0.624977, 0.965996>, <-0.748777, -0.624977, 0.965996>, 
      <-0.602471, -0.850329, 0.965996>, <-0.602471, -0.771284, 0.965996>, <-0.669732, -0.624977, 0.886950>, <-0.748777, -0.624977, 0.886950>, 
      <-0.669732, -0.917591, 0.965996>, <-0.669732, -0.917591, 0.886950>, <-0.748777, -0.771284, 0.819690>, <-0.748777, -0.692238, 0.819690>, 
      <-0.748777, -0.917591, 0.965996>, <-0.748777, -0.917591, 0.886950>, <-0.748777, -0.850329, 0.819690>, <-0.748777, -0.771284, 0.819690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.692238, 0.965996>, <-0.669732, -0.624977, 0.965996>, <-0.748777, -0.624977, 0.965996>, 
      <-0.602471, -0.850329, 0.965996>, <-0.602471, -0.771284, 0.965996>, <-0.669732, -0.624977, 1.045042>, <-0.748777, -0.624977, 1.045042>, 
      <-0.669732, -0.917591, 0.965996>, <-0.669732, -0.917591, 1.045042>, <-0.748777, -0.771284, 1.112303>, <-0.748777, -0.692238, 1.112303>, 
      <-0.748777, -0.917591, 0.965996>, <-0.748777, -0.917591, 1.045042>, <-0.748777, -0.850330, 1.112303>, <-0.748777, -0.771284, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.850329, 0.965996>, <-0.669732, -0.917591, 0.965996>, <-0.748777, -0.917591, 0.965996>, 
      <-0.602471, -0.771284, 1.045042>, <-0.602471, -0.850329, 1.045042>, <-0.748777, -0.917591, 0.965996>, <-0.827823, -0.917591, 0.965996>, 
      <-0.669732, -0.771284, 1.112303>, <-0.748777, -0.771284, 1.112303>, <-0.895084, -0.850330, 1.045042>, <-0.895084, -0.850330, 0.965996>, 
      <-0.748777, -0.771284, 1.112303>, <-0.827823, -0.771284, 1.112303>, <-0.895084, -0.771284, 1.045042>, <-0.895084, -0.771284, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.771284, 1.045042>, <-0.669732, -0.771284, 1.112303>, <-0.748777, -0.771284, 1.112303>, 
      <-0.602471, -0.692238, 0.965996>, <-0.602471, -0.692238, 1.045042>, <-0.748777, -0.771284, 1.112303>, <-0.827823, -0.771284, 1.112303>, 
      <-0.669732, -0.624977, 0.965996>, <-0.748777, -0.624977, 0.965996>, <-0.895084, -0.692238, 1.045042>, <-0.895084, -0.771284, 1.045042>, 
      <-0.748777, -0.624977, 0.965996>, <-0.827823, -0.624977, 0.965996>, <-0.895084, -0.692238, 0.965996>, <-0.895084, -0.771284, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.771284, 1.045042>, <-0.669732, -0.771284, 1.112303>, <-0.748777, -0.771284, 1.112303>, 
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.850329, 1.045042>, <-0.669732, -0.850330, 1.112303>, <-0.748777, -0.850330, 1.112303>, 
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.850329, 1.045042>, <-0.669732, -0.917591, 1.045042>, <-0.748777, -0.917591, 1.045042>, 
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.850329, 0.965996>, <-0.669732, -0.917591, 0.965996>, <-0.748777, -0.917591, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.692238, 0.965996>, <-0.669732, -0.624977, 0.965996>, <-0.748777, -0.624977, 0.965996>, 
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.692238, 1.045042>, <-0.669732, -0.624977, 1.045042>, <-0.748777, -0.624977, 1.045042>, 
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.692238, 1.045042>, <-0.669732, -0.692238, 1.112303>, <-0.748777, -0.692238, 1.112303>, 
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.771284, 1.045042>, <-0.669732, -0.771284, 1.112303>, <-0.748777, -0.771284, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.850329, 0.965996>, <-0.669732, -0.917591, 0.965996>, <-0.748777, -0.917591, 0.965996>, 
      <-0.602471, -0.771284, 0.886951>, <-0.602471, -0.850329, 0.886951>, <-0.748777, -0.917591, 0.965996>, <-0.827823, -0.917591, 0.965996>, 
      <-0.669732, -0.771284, 0.819690>, <-0.748777, -0.771284, 0.819690>, <-0.895084, -0.850330, 0.886950>, <-0.895084, -0.850330, 0.965996>, 
      <-0.748777, -0.771284, 0.819690>, <-0.827823, -0.771284, 0.819690>, <-0.895084, -0.771284, 0.886950>, <-0.895084, -0.771284, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.692238, 0.965996>, <-0.669732, -0.624977, 0.965996>, <-0.748777, -0.624977, 0.965996>, 
      <-0.602471, -0.771284, 0.886951>, <-0.602471, -0.692238, 0.886951>, <-0.748777, -0.624977, 0.965996>, <-0.827823, -0.624977, 0.965996>, 
      <-0.669732, -0.771284, 0.819690>, <-0.748777, -0.771284, 0.819690>, <-0.895084, -0.692238, 0.886950>, <-0.895084, -0.692238, 0.965996>, 
      <-0.748777, -0.771284, 0.819690>, <-0.827823, -0.771284, 0.819690>, <-0.895084, -0.771284, 0.886950>, <-0.895084, -0.771284, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.692238, 0.965996>, <-0.669732, -0.624977, 0.965996>, <-0.748777, -0.624977, 0.965996>, 
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.692238, 0.886951>, <-0.669732, -0.624977, 0.886950>, <-0.748777, -0.624977, 0.886950>, 
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.692238, 0.886951>, <-0.669732, -0.692238, 0.819690>, <-0.748777, -0.692238, 0.819690>, 
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.771284, 0.886951>, <-0.669732, -0.771284, 0.819690>, <-0.748777, -0.771284, 0.819690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.771284, 1.045042>, <-0.669732, -0.771284, 1.112303>, <-0.748777, -0.771284, 1.112303>, 
      <-0.602471, -0.771284, 0.886951>, <-0.602471, -0.771284, 0.965996>, <-0.669732, -0.692238, 1.112303>, <-0.748777, -0.692238, 1.112303>, 
      <-0.669732, -0.771284, 0.819690>, <-0.669732, -0.692238, 0.819690>, <-0.748777, -0.624977, 0.965996>, <-0.748777, -0.624977, 1.045042>, 
      <-0.748777, -0.771284, 0.819690>, <-0.748777, -0.692238, 0.819690>, <-0.748777, -0.624977, 0.886950>, <-0.748777, -0.624977, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.850329, 0.965996>, <-0.669732, -0.917591, 0.965996>, <-0.748777, -0.917591, 0.965996>, 
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.850329, 0.886951>, <-0.669732, -0.917591, 0.886950>, <-0.748777, -0.917591, 0.886950>, 
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.850329, 0.886951>, <-0.669732, -0.850329, 0.819690>, <-0.748777, -0.850329, 0.819690>, 
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.771284, 0.886951>, <-0.669732, -0.771284, 0.819690>, <-0.748777, -0.771284, 0.819690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, -0.771284, 0.965996>, <-0.602471, -0.771284, 0.886951>, <-0.669732, -0.771284, 0.819690>, <-0.748777, -0.771284, 0.819690>, 
      <-0.602471, -0.771284, 1.045042>, <-0.602471, -0.771284, 0.965996>, <-0.669732, -0.850329, 0.819690>, <-0.748777, -0.850329, 0.819690>, 
      <-0.669732, -0.771284, 1.112303>, <-0.669732, -0.850330, 1.112303>, <-0.748777, -0.917591, 0.965996>, <-0.748777, -0.917591, 0.886950>, 
      <-0.748777, -0.771284, 1.112303>, <-0.748777, -0.850330, 1.112303>, <-0.748777, -0.917591, 1.045042>, <-0.748777, -0.917591, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.407066, 0.965996>, <-0.827824, 0.339804, 0.965996>, <-0.748778, 0.339804, 0.965996>, 
      <-0.895084, 0.565156, 0.965996>, <-0.895084, 0.486111, 0.965996>, <-0.827824, 0.339804, 1.045042>, <-0.748778, 0.339804, 1.045042>, 
      <-0.827824, 0.632418, 0.965996>, <-0.827824, 0.632418, 1.045042>, <-0.748778, 0.486111, 1.112303>, <-0.748778, 0.407065, 1.112303>, 
      <-0.748778, 0.632418, 0.965996>, <-0.748778, 0.632418, 1.045042>, <-0.748778, 0.565157, 1.112303>, <-0.748778, 0.486111, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.407066, 0.965996>, <-0.827824, 0.339804, 0.965996>, <-0.748778, 0.339804, 0.965996>, 
      <-0.895084, 0.565156, 0.965996>, <-0.895084, 0.486111, 0.965996>, <-0.827824, 0.339804, 0.886950>, <-0.748778, 0.339804, 0.886950>, 
      <-0.827824, 0.632418, 0.965996>, <-0.827824, 0.632418, 0.886950>, <-0.748778, 0.486111, 0.819689>, <-0.748778, 0.407065, 0.819689>, 
      <-0.748778, 0.632418, 0.965996>, <-0.748778, 0.632418, 0.886950>, <-0.748778, 0.565157, 0.819689>, <-0.748778, 0.486111, 0.819689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.565156, 0.965996>, <-0.827824, 0.632418, 0.965996>, <-0.748778, 0.632418, 0.965996>, 
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.565156, 0.886950>, <-0.827824, 0.632418, 0.886950>, <-0.748778, 0.632418, 0.886950>, 
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.565156, 0.886950>, <-0.827824, 0.565157, 0.819689>, <-0.748778, 0.565157, 0.819689>, 
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.486111, 0.886950>, <-0.827824, 0.486111, 0.819689>, <-0.748778, 0.486111, 0.819689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.407066, 0.965996>, <-0.827824, 0.339804, 0.965996>, <-0.748778, 0.339804, 0.965996>, 
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.407066, 0.886950>, <-0.827824, 0.339804, 0.886950>, <-0.748778, 0.339804, 0.886950>, 
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.407066, 0.886950>, <-0.827824, 0.407065, 0.819689>, <-0.748778, 0.407065, 0.819689>, 
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.486111, 0.886950>, <-0.827824, 0.486111, 0.819689>, <-0.748778, 0.486111, 0.819689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.407066, 0.965996>, <-0.827824, 0.339804, 0.965996>, <-0.748778, 0.339804, 0.965996>, 
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.407066, 1.045042>, <-0.827824, 0.339804, 1.045042>, <-0.748778, 0.339804, 1.045042>, 
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.407066, 1.045042>, <-0.827824, 0.407065, 1.112303>, <-0.748778, 0.407065, 1.112303>, 
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.486111, 1.045042>, <-0.827824, 0.486111, 1.112303>, <-0.748778, 0.486111, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.486111, 1.045042>, <-0.827824, 0.486111, 1.112303>, <-0.748778, 0.486111, 1.112303>, 
      <-0.895084, 0.486111, 0.886950>, <-0.895084, 0.486111, 0.965996>, <-0.827824, 0.407065, 1.112303>, <-0.748778, 0.407065, 1.112303>, 
      <-0.827824, 0.486111, 0.819689>, <-0.827824, 0.407065, 0.819689>, <-0.748778, 0.339804, 0.965996>, <-0.748778, 0.339804, 1.045042>, 
      <-0.748778, 0.486111, 0.819689>, <-0.748778, 0.407065, 0.819689>, <-0.748778, 0.339804, 0.886950>, <-0.748778, 0.339804, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.565156, 0.965996>, <-0.827824, 0.632418, 0.965996>, <-0.748778, 0.632418, 0.965996>, 
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.565156, 1.045042>, <-0.827824, 0.632418, 1.045042>, <-0.748778, 0.632418, 1.045042>, 
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.565156, 1.045042>, <-0.827824, 0.565157, 1.112303>, <-0.748778, 0.565157, 1.112303>, 
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.486111, 1.045042>, <-0.827824, 0.486111, 1.112303>, <-0.748778, 0.486111, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895084, 0.486111, 0.965996>, <-0.895084, 0.486111, 0.886950>, <-0.827824, 0.486111, 0.819689>, <-0.748778, 0.486111, 0.819689>, 
      <-0.895084, 0.486111, 1.045042>, <-0.895084, 0.486111, 0.965996>, <-0.827824, 0.565157, 0.819689>, <-0.748778, 0.565157, 0.819689>, 
      <-0.827824, 0.486111, 1.112303>, <-0.827824, 0.565157, 1.112303>, <-0.748778, 0.632418, 0.965996>, <-0.748778, 0.632418, 0.886950>, 
      <-0.748778, 0.486111, 1.112303>, <-0.748778, 0.565157, 1.112303>, <-0.748778, 0.632418, 1.045042>, <-0.748778, 0.632418, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.565157, 0.965996>, <-0.669732, 0.632418, 0.965996>, <-0.748778, 0.632418, 0.965996>, 
      <-0.602471, 0.407065, 0.965996>, <-0.602471, 0.486111, 0.965996>, <-0.669732, 0.632418, 0.886950>, <-0.748778, 0.632418, 0.886950>, 
      <-0.669732, 0.339804, 0.965996>, <-0.669732, 0.339804, 0.886950>, <-0.748778, 0.486111, 0.819689>, <-0.748778, 0.565157, 0.819689>, 
      <-0.748778, 0.339804, 0.965996>, <-0.748778, 0.339804, 0.886950>, <-0.748778, 0.407065, 0.819689>, <-0.748778, 0.486111, 0.819689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.565157, 0.965996>, <-0.669732, 0.632418, 0.965996>, <-0.748778, 0.632418, 0.965996>, 
      <-0.602471, 0.407065, 0.965996>, <-0.602471, 0.486111, 0.965996>, <-0.669732, 0.632418, 1.045042>, <-0.748778, 0.632418, 1.045042>, 
      <-0.669732, 0.339804, 0.965996>, <-0.669732, 0.339804, 1.045042>, <-0.748778, 0.486111, 1.112303>, <-0.748778, 0.565157, 1.112303>, 
      <-0.748778, 0.339804, 0.965996>, <-0.748778, 0.339804, 1.045042>, <-0.748778, 0.407065, 1.112303>, <-0.748778, 0.486111, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.407065, 0.965996>, <-0.669732, 0.339804, 0.965996>, <-0.748778, 0.339804, 0.965996>, 
      <-0.602471, 0.486111, 1.045042>, <-0.602471, 0.407065, 1.045042>, <-0.748778, 0.339804, 0.965996>, <-0.827824, 0.339804, 0.965996>, 
      <-0.669732, 0.486111, 1.112303>, <-0.748778, 0.486111, 1.112303>, <-0.895084, 0.407066, 1.045042>, <-0.895084, 0.407066, 0.965996>, 
      <-0.748778, 0.486111, 1.112303>, <-0.827824, 0.486111, 1.112303>, <-0.895084, 0.486111, 1.045042>, <-0.895084, 0.486111, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.486111, 1.045042>, <-0.669732, 0.486111, 1.112303>, <-0.748778, 0.486111, 1.112303>, 
      <-0.602471, 0.565157, 0.965996>, <-0.602471, 0.565157, 1.045042>, <-0.748778, 0.486111, 1.112303>, <-0.827824, 0.486111, 1.112303>, 
      <-0.669732, 0.632418, 0.965996>, <-0.748778, 0.632418, 0.965996>, <-0.895084, 0.565156, 1.045042>, <-0.895084, 0.486111, 1.045042>, 
      <-0.748778, 0.632418, 0.965996>, <-0.827824, 0.632418, 0.965996>, <-0.895084, 0.565156, 0.965996>, <-0.895084, 0.486111, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.486111, 1.045042>, <-0.669732, 0.486111, 1.112303>, <-0.748778, 0.486111, 1.112303>, 
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.407065, 1.045042>, <-0.669732, 0.407065, 1.112303>, <-0.748778, 0.407065, 1.112303>, 
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.407065, 1.045042>, <-0.669732, 0.339804, 1.045042>, <-0.748778, 0.339804, 1.045042>, 
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.407065, 0.965996>, <-0.669732, 0.339804, 0.965996>, <-0.748778, 0.339804, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.565157, 0.965996>, <-0.669732, 0.632418, 0.965996>, <-0.748778, 0.632418, 0.965996>, 
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.565157, 1.045042>, <-0.669732, 0.632418, 1.045042>, <-0.748778, 0.632418, 1.045042>, 
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.565157, 1.045042>, <-0.669732, 0.565157, 1.112303>, <-0.748778, 0.565157, 1.112303>, 
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.486111, 1.045042>, <-0.669732, 0.486111, 1.112303>, <-0.748778, 0.486111, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.407065, 0.965996>, <-0.669732, 0.339804, 0.965996>, <-0.748778, 0.339804, 0.965996>, 
      <-0.602471, 0.486111, 0.886950>, <-0.602471, 0.407065, 0.886950>, <-0.748778, 0.339804, 0.965996>, <-0.827824, 0.339804, 0.965996>, 
      <-0.669732, 0.486111, 0.819689>, <-0.748778, 0.486111, 0.819689>, <-0.895084, 0.407066, 0.886950>, <-0.895084, 0.407066, 0.965996>, 
      <-0.748778, 0.486111, 0.819689>, <-0.827824, 0.486111, 0.819689>, <-0.895084, 0.486111, 0.886950>, <-0.895084, 0.486111, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.565157, 0.965996>, <-0.669732, 0.632418, 0.965996>, <-0.748778, 0.632418, 0.965996>, 
      <-0.602471, 0.486111, 0.886950>, <-0.602471, 0.565157, 0.886950>, <-0.748778, 0.632418, 0.965996>, <-0.827824, 0.632418, 0.965996>, 
      <-0.669732, 0.486111, 0.819689>, <-0.748778, 0.486111, 0.819689>, <-0.895084, 0.565156, 0.886950>, <-0.895084, 0.565156, 0.965996>, 
      <-0.748778, 0.486111, 0.819689>, <-0.827824, 0.486111, 0.819689>, <-0.895084, 0.486111, 0.886950>, <-0.895084, 0.486111, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.565157, 0.965996>, <-0.669732, 0.632418, 0.965996>, <-0.748778, 0.632418, 0.965996>, 
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.565157, 0.886950>, <-0.669732, 0.632418, 0.886950>, <-0.748778, 0.632418, 0.886950>, 
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.565157, 0.886950>, <-0.669732, 0.565157, 0.819689>, <-0.748778, 0.565157, 0.819689>, 
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.486111, 0.886950>, <-0.669732, 0.486111, 0.819689>, <-0.748778, 0.486111, 0.819689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.486111, 1.045042>, <-0.669732, 0.486111, 1.112303>, <-0.748778, 0.486111, 1.112303>, 
      <-0.602471, 0.486111, 0.886950>, <-0.602471, 0.486111, 0.965996>, <-0.669732, 0.565157, 1.112303>, <-0.748778, 0.565157, 1.112303>, 
      <-0.669732, 0.486111, 0.819689>, <-0.669732, 0.565157, 0.819689>, <-0.748778, 0.632418, 0.965996>, <-0.748778, 0.632418, 1.045042>, 
      <-0.748778, 0.486111, 0.819689>, <-0.748778, 0.565157, 0.819689>, <-0.748778, 0.632418, 0.886950>, <-0.748778, 0.632418, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.407065, 0.965996>, <-0.669732, 0.339804, 0.965996>, <-0.748778, 0.339804, 0.965996>, 
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.407065, 0.886950>, <-0.669732, 0.339804, 0.886950>, <-0.748778, 0.339804, 0.886950>, 
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.407065, 0.886950>, <-0.669732, 0.407065, 0.819689>, <-0.748778, 0.407065, 0.819689>, 
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.486111, 0.886950>, <-0.669732, 0.486111, 0.819689>, <-0.748778, 0.486111, 0.819689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.602471, 0.486111, 0.965996>, <-0.602471, 0.486111, 0.886950>, <-0.669732, 0.486111, 0.819689>, <-0.748778, 0.486111, 0.819689>, 
      <-0.602471, 0.486111, 1.045042>, <-0.602471, 0.486111, 0.965996>, <-0.669732, 0.407065, 0.819689>, <-0.748778, 0.407065, 0.819689>, 
      <-0.669732, 0.486111, 1.112303>, <-0.669732, 0.407065, 1.112303>, <-0.748778, 0.339804, 0.965996>, <-0.748778, 0.339804, 0.886950>, 
      <-0.748778, 0.486111, 1.112303>, <-0.748778, 0.407065, 1.112303>, <-0.748778, 0.339804, 1.045042>, <-0.748778, 0.339804, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.623037, -1.757084, 2.019570>, <-1.601246, -1.741388, 2.049302>, <-1.572192, -1.720460, 2.088944>, <-1.550401, -1.704764, 2.118676>, 
      <-1.623037, -1.757084, 2.019570>, <-1.626146, -1.715136, 2.053693>, <-1.597091, -1.694209, 2.093335>, <-1.575300, -1.678513, 2.123067>, 
      <-1.623037, -1.757084, 2.019570>, <-1.626146, -1.715136, 2.053693>, <-1.632341, -1.682823, 2.077168>, <-1.612518, -1.668544, 2.104215>, 
      <-1.623037, -1.757084, 2.019570>, <-1.647937, -1.730832, 2.023961>, <-1.652165, -1.697102, 2.050120>, <-1.632341, -1.682823, 2.077168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.541096, -1.779023, 2.061078>, <-1.521273, -1.764744, 2.088125>, <-1.525502, -1.731015, 2.114285>, <-1.550401, -1.704764, 2.118676>, 
      <-1.541096, -1.779023, 2.061078>, <-1.541096, -1.779023, 2.061078>, <-1.547292, -1.746711, 2.084553>, <-1.572192, -1.720460, 2.088944>, 
      <-1.541096, -1.779023, 2.061078>, <-1.541096, -1.779023, 2.061078>, <-1.576347, -1.767640, 2.044911>, <-1.601246, -1.741388, 2.049302>, 
      <-1.541096, -1.779023, 2.061078>, <-1.560919, -1.793302, 2.034031>, <-1.598138, -1.783336, 2.015179>, <-1.623037, -1.757084, 2.019570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.652530, -1.804513, 2.156204>, <-1.652530, -1.804513, 2.156204>, <-1.652530, -1.804513, 2.156204>, <-1.652530, -1.804513, 2.156204>, 
      <-1.646473, -1.768006, 2.132493>, <-1.646473, -1.768006, 2.132493>, <-1.621891, -1.774588, 2.144946>, <-1.621891, -1.774588, 2.144946>, 
      <-1.649113, -1.712363, 2.105055>, <-1.629290, -1.698084, 2.132102>, <-1.605939, -1.708437, 2.134325>, <-1.581040, -1.734689, 2.129934>, 
      <-1.632341, -1.682823, 2.077168>, <-1.612518, -1.668544, 2.104215>, <-1.575300, -1.678513, 2.123067>, <-1.550401, -1.704764, 2.118676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.652530, -1.804513, 2.156204>, <-1.652530, -1.804513, 2.156204>, <-1.652530, -1.804513, 2.156204>, <-1.652530, -1.804513, 2.156204>, 
      <-1.643682, -1.790284, 2.115214>, <-1.643682, -1.790284, 2.115214>, <-1.646473, -1.768006, 2.132493>, <-1.646473, -1.768006, 2.132493>, 
      <-1.631885, -1.771313, 2.060560>, <-1.656785, -1.745061, 2.064951>, <-1.668937, -1.726642, 2.078008>, <-1.649113, -1.712363, 2.105055>, 
      <-1.623037, -1.757084, 2.019570>, <-1.647937, -1.730832, 2.023961>, <-1.652165, -1.697102, 2.050120>, <-1.632341, -1.682823, 2.077168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.652530, -1.804513, 2.156204>, <-1.652530, -1.804513, 2.156204>, <-1.652530, -1.804513, 2.156204>, <-1.652530, -1.804513, 2.156204>, 
      <-1.619100, -1.796866, 2.127666>, <-1.619100, -1.796866, 2.127666>, <-1.643682, -1.790284, 2.115214>, <-1.643682, -1.790284, 2.115214>, 
      <-1.567752, -1.798661, 2.090982>, <-1.587576, -1.812940, 2.063935>, <-1.606985, -1.797564, 2.056170>, <-1.631885, -1.771313, 2.060560>, 
      <-1.541096, -1.779023, 2.061078>, <-1.560919, -1.793302, 2.034031>, <-1.598138, -1.783336, 2.015179>, <-1.623037, -1.757084, 2.019570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.652530, -1.804513, 2.156204>, <-1.619100, -1.796866, 2.127666>, <-1.567752, -1.798661, 2.090982>, <-1.541096, -1.779023, 2.061078>, 
      <-1.652530, -1.804513, 2.156204>, <-1.619100, -1.796866, 2.127666>, <-1.547929, -1.784382, 2.118029>, <-1.521273, -1.764744, 2.088125>, 
      <-1.652530, -1.804513, 2.156204>, <-1.621891, -1.774588, 2.144946>, <-1.556140, -1.760940, 2.125544>, <-1.525502, -1.731015, 2.114285>, 
      <-1.652530, -1.804513, 2.156204>, <-1.621891, -1.774588, 2.144946>, <-1.581040, -1.734689, 2.129934>, <-1.550401, -1.704764, 2.118676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.860734, -0.721981, 1.004403>, <-0.876110, -0.763223, 1.037444>, <-0.890587, -0.822798, 1.079506>, <-0.911986, -0.859454, 1.114541>, 
      <-0.825310, -0.696465, 1.052736>, <-0.840686, -0.737707, 1.085778>, <-0.870764, -0.808519, 1.106554>, <-0.892162, -0.845175, 1.141589>, 
      <-0.758803, -0.714277, 1.086424>, <-0.793524, -0.750339, 1.109665>, <-0.823534, -0.821113, 1.130415>, <-0.854945, -0.855144, 1.160439>, 
      <-0.714308, -0.761188, 1.078579>, <-0.749029, -0.797250, 1.101820>, <-0.798635, -0.847364, 1.126025>, <-0.830045, -0.881396, 1.156049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.844107, -0.854683, 0.901478>, <-0.861679, -0.878392, 0.948118>, <-0.880119, -0.906057, 1.014846>, <-0.902680, -0.933714, 1.056944>, 
      <-0.888602, -0.807772, 0.909323>, <-0.906174, -0.831481, 0.955963>, <-0.905019, -0.879805, 1.019236>, <-0.927580, -0.907462, 1.061334>, 
      <-0.896158, -0.747497, 0.956070>, <-0.911534, -0.788739, 0.989111>, <-0.910411, -0.837076, 1.052459>, <-0.931809, -0.873732, 1.087493>, 
      <-0.860734, -0.721981, 1.004403>, <-0.876110, -0.763223, 1.037444>, <-0.890587, -0.822798, 1.079506>, <-0.911986, -0.859454, 1.114541>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.697681, -0.893889, 0.975653>, <-0.734599, -0.912419, 1.012493>, <-0.788153, -0.930638, 1.061363>, <-0.820740, -0.955655, 1.098453>, 
      <-0.733105, -0.919405, 0.927320>, <-0.770023, -0.937935, 0.964160>, <-0.807977, -0.944916, 1.034315>, <-0.840563, -0.969934, 1.071406>, 
      <-0.799612, -0.901594, 0.893633>, <-0.817184, -0.925303, 0.940272>, <-0.855220, -0.932308, 1.010456>, <-0.877780, -0.959966, 1.052554>, 
      <-0.844107, -0.854683, 0.901478>, <-0.861679, -0.878392, 0.948118>, <-0.880119, -0.906057, 1.014846>, <-0.902680, -0.933714, 1.056944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.697681, -0.893889, 0.975653>, <-0.662257, -0.868373, 1.023986>, <-0.669813, -0.808099, 1.070733>, <-0.714308, -0.761188, 1.078579>, 
      <-0.734599, -0.912419, 1.012493>, <-0.699175, -0.886903, 1.060826>, <-0.704534, -0.844162, 1.093975>, <-0.749029, -0.797250, 1.101820>, 
      <-0.788153, -0.930638, 1.061363>, <-0.768330, -0.916359, 1.088410>, <-0.773736, -0.873615, 1.121635>, <-0.798635, -0.847364, 1.126025>, 
      <-0.820740, -0.955655, 1.098453>, <-0.800917, -0.941377, 1.125500>, <-0.805146, -0.907647, 1.151659>, <-0.830045, -0.881396, 1.156049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.999141, -0.959074, 1.231009>, <-0.967496, -0.935851, 1.195556>, <-0.932551, -0.894682, 1.148211>, <-0.911986, -0.859454, 1.114541>, 
      <-0.979318, -0.944795, 1.258056>, <-0.947673, -0.921572, 1.222603>, <-0.912728, -0.880404, 1.175259>, <-0.892162, -0.845175, 1.141589>, 
      <-0.942101, -0.954763, 1.276907>, <-0.921004, -0.928663, 1.236025>, <-0.885046, -0.887758, 1.189212>, <-0.854945, -0.855144, 1.160439>, 
      <-0.917202, -0.981014, 1.272517>, <-0.896105, -0.954914, 1.231635>, <-0.860147, -0.914010, 1.184822>, <-0.830045, -0.881396, 1.156049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.989836, -1.033334, 1.173411>, <-0.959342, -1.000465, 1.145351>, <-0.924301, -0.960219, 1.097289>, <-0.902680, -0.933714, 1.056944>, 
      <-1.014736, -1.007082, 1.177801>, <-0.984241, -0.974213, 1.149742>, <-0.949200, -0.933967, 1.101679>, <-0.927580, -0.907462, 1.061334>, 
      <-1.018964, -0.973353, 1.203961>, <-0.987319, -0.950130, 1.168508>, <-0.952375, -0.908961, 1.121164>, <-0.931809, -0.873732, 1.087493>, 
      <-0.999141, -0.959074, 1.231009>, <-0.967496, -0.935851, 1.195556>, <-0.932551, -0.894682, 1.148211>, <-0.911986, -0.859454, 1.114541>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.907896, -1.055275, 1.214920>, <-0.887970, -1.019508, 1.181434>, <-0.851881, -0.979562, 1.133898>, <-0.820740, -0.955655, 1.098453>, 
      <-0.927719, -1.069554, 1.187873>, <-0.907793, -1.033787, 1.154387>, <-0.871704, -0.993841, 1.106850>, <-0.840563, -0.969934, 1.071406>, 
      <-0.964937, -1.059586, 1.169021>, <-0.934442, -1.026717, 1.140961>, <-0.899401, -0.986471, 1.092898>, <-0.877780, -0.959966, 1.052554>, 
      <-0.989836, -1.033334, 1.173411>, <-0.959342, -1.000465, 1.145351>, <-0.924301, -0.960219, 1.097289>, <-0.902680, -0.933714, 1.056944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.907896, -1.055275, 1.214920>, <-0.887970, -1.019508, 1.181434>, <-0.851881, -0.979562, 1.133898>, <-0.820740, -0.955655, 1.098453>, 
      <-0.888073, -1.040996, 1.241968>, <-0.868147, -1.005229, 1.208482>, <-0.832058, -0.965284, 1.160945>, <-0.800917, -0.941377, 1.125500>, 
      <-0.892303, -1.007266, 1.268126>, <-0.871206, -0.981166, 1.227244>, <-0.835248, -0.940261, 1.180432>, <-0.805146, -0.907647, 1.151659>, 
      <-0.917202, -0.981014, 1.272517>, <-0.896105, -0.954914, 1.231635>, <-0.860147, -0.914010, 1.184822>, <-0.830045, -0.881396, 1.156049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.054058, -0.963714, 1.273707>, <-1.043719, -0.951896, 1.259891>, <-1.011654, -0.968257, 1.245028>, <-0.999141, -0.959074, 1.231009>, 
      <-1.022740, -0.941155, 1.316439>, <-1.012401, -0.929337, 1.302622>, <-0.991832, -0.953978, 1.272075>, <-0.979318, -0.944795, 1.258056>, 
      <-0.963940, -0.956902, 1.346222>, <-0.953650, -0.945140, 1.332472>, <-0.950403, -0.965034, 1.292996>, <-0.942101, -0.954763, 1.276907>, 
      <-0.924602, -0.998376, 1.339286>, <-0.914312, -0.986615, 1.325535>, <-0.925504, -0.991285, 1.288606>, <-0.917202, -0.981014, 1.272517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.039358, -1.081036, 1.182710>, <-1.029068, -1.069274, 1.168959>, <-1.001837, -1.046270, 1.184454>, <-0.989836, -1.033334, 1.173411>, 
      <-1.078696, -1.039562, 1.189646>, <-1.068406, -1.027800, 1.175896>, <-1.026736, -1.020018, 1.188844>, <-1.014736, -1.007082, 1.177801>, 
      <-1.085376, -0.986273, 1.230976>, <-1.075037, -0.974455, 1.217159>, <-1.031477, -0.982536, 1.217980>, <-1.018964, -0.973353, 1.203961>, 
      <-1.054058, -0.963714, 1.273707>, <-1.043719, -0.951896, 1.259891>, <-1.011654, -0.968257, 1.245028>, <-0.999141, -0.959074, 1.231009>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.909902, -1.115698, 1.248289>, <-0.899661, -1.103993, 1.234604>, <-0.915700, -1.069284, 1.228035>, <-0.907896, -1.055275, 1.214920>, 
      <-0.941220, -1.138257, 1.205558>, <-0.930980, -1.126552, 1.191872>, <-0.935523, -1.083563, 1.200988>, <-0.927719, -1.069554, 1.187873>, 
      <-1.000020, -1.122510, 1.175774>, <-0.989730, -1.110749, 1.162023>, <-0.976938, -1.072521, 1.180063>, <-0.964937, -1.059586, 1.169021>, 
      <-1.039358, -1.081036, 1.182710>, <-1.029068, -1.069274, 1.168959>, <-1.001837, -1.046270, 1.184454>, <-0.989836, -1.033334, 1.173411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.909902, -1.115698, 1.248289>, <-0.899661, -1.103993, 1.234604>, <-0.915700, -1.069284, 1.228035>, <-0.907896, -1.055275, 1.214920>, 
      <-0.878584, -1.093139, 1.291020>, <-0.868343, -1.081434, 1.277336>, <-0.895877, -1.055005, 1.255083>, <-0.888073, -1.040996, 1.241968>, 
      <-0.885264, -1.039850, 1.332350>, <-0.874974, -1.028089, 1.318599>, <-0.900605, -1.017537, 1.284216>, <-0.892303, -1.007266, 1.268126>, 
      <-0.924602, -0.998376, 1.339286>, <-0.914312, -0.986615, 1.325535>, <-0.925504, -0.991285, 1.288606>, <-0.917202, -0.981014, 1.272517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.144400, -1.125107, 1.425122>, <-1.114459, -1.079159, 1.378921>, <-1.089506, -1.004232, 1.321077>, <-1.054058, -0.963714, 1.273707>, 
      <-1.124577, -1.110828, 1.452169>, <-1.094636, -1.064880, 1.405968>, <-1.058188, -0.981673, 1.363809>, <-1.022740, -0.941155, 1.316439>, 
      <-1.087359, -1.120794, 1.471021>, <-1.047813, -1.077390, 1.429653>, <-0.999447, -0.997486, 1.393671>, <-0.963940, -0.956902, 1.346222>, 
      <-1.062460, -1.147046, 1.466631>, <-1.022914, -1.103641, 1.425263>, <-0.960109, -1.038961, 1.386735>, <-0.924602, -0.998376, 1.339286>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.135096, -1.199366, 1.367524>, <-1.104050, -1.162084, 1.314558>, <-1.074865, -1.121620, 1.230158>, <-1.039358, -1.081036, 1.182710>, 
      <-1.159995, -1.173115, 1.371914>, <-1.128949, -1.135833, 1.318948>, <-1.114203, -1.080146, 1.237095>, <-1.078696, -1.039562, 1.189646>, 
      <-1.164223, -1.139386, 1.398075>, <-1.134282, -1.093438, 1.351874>, <-1.120825, -1.026791, 1.278346>, <-1.085376, -0.986273, 1.230976>, 
      <-1.144400, -1.125107, 1.425122>, <-1.114459, -1.079159, 1.378921>, <-1.089506, -1.004232, 1.321077>, <-1.054058, -0.963714, 1.273707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.053155, -1.221307, 1.409034>, <-1.012498, -1.186574, 1.360900>, <-0.945467, -1.156349, 1.295816>, <-0.909902, -1.115698, 1.248289>, 
      <-1.072978, -1.235586, 1.381986>, <-1.032322, -1.200853, 1.333852>, <-0.976786, -1.178908, 1.253084>, <-0.941220, -1.138257, 1.205558>, 
      <-1.110196, -1.225618, 1.363134>, <-1.079150, -1.188336, 1.310168>, <-1.035527, -1.163094, 1.223222>, <-1.000020, -1.122510, 1.175774>, 
      <-1.135096, -1.199366, 1.367524>, <-1.104050, -1.162084, 1.314558>, <-1.074865, -1.121620, 1.230158>, <-1.039358, -1.081036, 1.182710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.053155, -1.221307, 1.409034>, <-1.012498, -1.186574, 1.360900>, <-0.945467, -1.156349, 1.295816>, <-0.909902, -1.115698, 1.248289>, 
      <-1.033332, -1.207028, 1.436082>, <-0.992675, -1.172295, 1.387948>, <-0.914149, -1.133790, 1.338548>, <-0.878584, -1.093139, 1.291020>, 
      <-1.037560, -1.173298, 1.462241>, <-0.998014, -1.129893, 1.420873>, <-0.920770, -1.080435, 1.379798>, <-0.885264, -1.039850, 1.332350>, 
      <-1.062460, -1.147046, 1.466631>, <-1.022914, -1.103641, 1.425263>, <-0.960109, -1.038961, 1.386735>, <-0.924602, -0.998376, 1.339286>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.202505, -1.191520, 1.502767>, <-1.180332, -1.177581, 1.479157>, <-1.159123, -1.147701, 1.447841>, <-1.144400, -1.125107, 1.425122>, 
      <-1.182682, -1.177241, 1.529814>, <-1.160508, -1.163302, 1.506204>, <-1.139300, -1.133423, 1.474888>, <-1.124577, -1.110828, 1.452169>, 
      <-1.145465, -1.187208, 1.548665>, <-1.132585, -1.170737, 1.520272>, <-1.106774, -1.142103, 1.491330>, <-1.087359, -1.120794, 1.471021>, 
      <-1.120565, -1.213459, 1.544275>, <-1.107685, -1.196988, 1.515881>, <-1.081874, -1.168354, 1.486939>, <-1.062460, -1.147046, 1.466631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.193199, -1.265778, 1.445170>, <-1.172038, -1.243341, 1.428076>, <-1.150337, -1.217669, 1.393526>, <-1.135096, -1.199366, 1.367524>, 
      <-1.218098, -1.239527, 1.449560>, <-1.196938, -1.217091, 1.432466>, <-1.175237, -1.191417, 1.397916>, <-1.159995, -1.173115, 1.371914>, 
      <-1.222328, -1.205798, 1.475720>, <-1.200154, -1.191859, 1.452110>, <-1.178946, -1.161980, 1.420793>, <-1.164223, -1.139386, 1.398075>, 
      <-1.202505, -1.191520, 1.502767>, <-1.180332, -1.177581, 1.479157>, <-1.159123, -1.147701, 1.447841>, <-1.144400, -1.125107, 1.425122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.111259, -1.287719, 1.486678>, <-1.099415, -1.262727, 1.464804>, <-1.073081, -1.238330, 1.432625>, <-1.053155, -1.221307, 1.409034>, 
      <-1.131082, -1.301998, 1.459631>, <-1.119238, -1.277006, 1.437756>, <-1.092905, -1.252609, 1.405577>, <-1.072978, -1.235586, 1.381986>, 
      <-1.168299, -1.292029, 1.440780>, <-1.147139, -1.269593, 1.423685>, <-1.125437, -1.243920, 1.389136>, <-1.110196, -1.225618, 1.363134>, 
      <-1.193199, -1.265778, 1.445170>, <-1.172038, -1.243341, 1.428076>, <-1.150337, -1.217669, 1.393526>, <-1.135096, -1.199366, 1.367524>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.111259, -1.287719, 1.486678>, <-1.099415, -1.262727, 1.464804>, <-1.073081, -1.238330, 1.432625>, <-1.053155, -1.221307, 1.409034>, 
      <-1.091436, -1.273440, 1.513726>, <-1.079592, -1.248448, 1.491851>, <-1.053258, -1.224051, 1.459673>, <-1.033332, -1.207028, 1.436082>, 
      <-1.095665, -1.239710, 1.539885>, <-1.082786, -1.223239, 1.511491>, <-1.056974, -1.194606, 1.482549>, <-1.037560, -1.173298, 1.462241>, 
      <-1.120565, -1.213459, 1.544275>, <-1.107685, -1.196988, 1.515881>, <-1.081874, -1.168354, 1.486939>, <-1.062460, -1.147046, 1.466631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.257421, -1.196157, 1.545465>, <-1.247082, -1.184339, 1.531649>, <-1.215657, -1.199788, 1.516771>, <-1.202505, -1.191520, 1.502767>, 
      <-1.226103, -1.173598, 1.588196>, <-1.215764, -1.161781, 1.574380>, <-1.195834, -1.185509, 1.543818>, <-1.182682, -1.177241, 1.529814>, 
      <-1.167304, -1.189346, 1.617979>, <-1.157014, -1.177585, 1.604228>, <-1.153067, -1.196931, 1.565426>, <-1.145465, -1.187208, 1.548665>, 
      <-1.127966, -1.230820, 1.611043>, <-1.117677, -1.219059, 1.597293>, <-1.128168, -1.223182, 1.561036>, <-1.120565, -1.213459, 1.544275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.242721, -1.313480, 1.454468>, <-1.232431, -1.301719, 1.440718>, <-1.205691, -1.279023, 1.455261>, <-1.193199, -1.265778, 1.445170>, 
      <-1.282059, -1.272005, 1.461404>, <-1.271769, -1.260244, 1.447653>, <-1.230590, -1.252772, 1.459652>, <-1.218098, -1.239527, 1.449560>, 
      <-1.288739, -1.218716, 1.502733>, <-1.278401, -1.206899, 1.488917>, <-1.235480, -1.214066, 1.489724>, <-1.222328, -1.205798, 1.475720>, 
      <-1.257421, -1.196157, 1.545465>, <-1.247082, -1.184339, 1.531649>, <-1.215657, -1.199788, 1.516771>, <-1.202505, -1.191520, 1.502767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.113265, -1.348142, 1.520048>, <-1.103024, -1.336437, 1.506363>, <-1.118218, -1.302402, 1.499529>, <-1.111259, -1.287719, 1.486678>, 
      <-1.144583, -1.370701, 1.477316>, <-1.134343, -1.358996, 1.463631>, <-1.138041, -1.316681, 1.472482>, <-1.131082, -1.301998, 1.459631>, 
      <-1.203383, -1.354955, 1.447532>, <-1.193093, -1.343193, 1.433782>, <-1.180791, -1.305274, 1.450871>, <-1.168299, -1.292029, 1.440780>, 
      <-1.242721, -1.313480, 1.454468>, <-1.232431, -1.301719, 1.440718>, <-1.205691, -1.279023, 1.455261>, <-1.193199, -1.265778, 1.445170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.113265, -1.348142, 1.520048>, <-1.103024, -1.336437, 1.506363>, <-1.118218, -1.302402, 1.499529>, <-1.111259, -1.287719, 1.486678>, 
      <-1.081947, -1.325583, 1.562779>, <-1.071706, -1.313878, 1.549094>, <-1.098394, -1.288123, 1.526577>, <-1.091436, -1.273440, 1.513726>, 
      <-1.088628, -1.272294, 1.604107>, <-1.078339, -1.260533, 1.590357>, <-1.103268, -1.249433, 1.556645>, <-1.095665, -1.239710, 1.539885>, 
      <-1.127966, -1.230820, 1.611043>, <-1.117677, -1.219059, 1.597293>, <-1.128168, -1.223182, 1.561036>, <-1.120565, -1.213459, 1.544275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.318711, -1.324345, 1.658057>, <-1.296861, -1.288731, 1.623242>, <-1.284306, -1.226887, 1.581392>, <-1.257421, -1.196157, 1.545465>, 
      <-1.298888, -1.310066, 1.685104>, <-1.277038, -1.274452, 1.650289>, <-1.252988, -1.204328, 1.624124>, <-1.226103, -1.173598, 1.588196>, 
      <-1.261671, -1.320032, 1.703957>, <-1.231100, -1.286720, 1.673521>, <-1.194247, -1.220142, 1.653984>, <-1.167304, -1.189346, 1.617979>, 
      <-1.236772, -1.346284, 1.699567>, <-1.206201, -1.312971, 1.669131>, <-1.154909, -1.261616, 1.647048>, <-1.127966, -1.230820, 1.611043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.309407, -1.398604, 1.600461>, <-1.286550, -1.370848, 1.559500>, <-1.269664, -1.344276, 1.490472>, <-1.242721, -1.313480, 1.454468>, 
      <-1.334306, -1.372353, 1.604851>, <-1.311449, -1.344597, 1.563889>, <-1.309002, -1.302801, 1.497408>, <-1.282059, -1.272005, 1.461404>, 
      <-1.338534, -1.338624, 1.631010>, <-1.316683, -1.303010, 1.596195>, <-1.315625, -1.249446, 1.538661>, <-1.288739, -1.218716, 1.502733>, 
      <-1.318711, -1.324345, 1.658057>, <-1.296861, -1.288731, 1.623242>, <-1.284306, -1.226887, 1.581392>, <-1.257421, -1.196157, 1.545465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.227467, -1.420546, 1.641970>, <-1.195881, -1.395100, 1.605387>, <-1.140266, -1.379004, 1.556130>, <-1.113265, -1.348142, 1.520048>, 
      <-1.247290, -1.434825, 1.614923>, <-1.215705, -1.409379, 1.578340>, <-1.171584, -1.401564, 1.513398>, <-1.144583, -1.370701, 1.477316>, 
      <-1.284508, -1.424856, 1.596071>, <-1.261651, -1.397101, 1.555110>, <-1.230326, -1.385751, 1.483537>, <-1.203383, -1.354955, 1.447532>, 
      <-1.309407, -1.398604, 1.600461>, <-1.286550, -1.370848, 1.559500>, <-1.269664, -1.344276, 1.490472>, <-1.242721, -1.313480, 1.454468>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.227467, -1.420546, 1.641970>, <-1.195881, -1.395100, 1.605387>, <-1.140266, -1.379004, 1.556130>, <-1.113265, -1.348142, 1.520048>, 
      <-1.207644, -1.406267, 1.669018>, <-1.176058, -1.380821, 1.632435>, <-1.108948, -1.356445, 1.598861>, <-1.081947, -1.325583, 1.562779>, 
      <-1.211872, -1.372536, 1.695177>, <-1.181302, -1.339223, 1.664742>, <-1.115571, -1.303090, 1.640112>, <-1.088628, -1.272294, 1.604107>, 
      <-1.236772, -1.346284, 1.699567>, <-1.206201, -1.312971, 1.669131>, <-1.154909, -1.261616, 1.647048>, <-1.127966, -1.230820, 1.611043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.376816, -1.390757, 1.735702>, <-1.354643, -1.376818, 1.712092>, <-1.332878, -1.347435, 1.680630>, <-1.318711, -1.324345, 1.658057>, 
      <-1.356992, -1.376478, 1.762750>, <-1.334819, -1.362539, 1.739140>, <-1.313055, -1.333157, 1.707677>, <-1.298888, -1.310066, 1.685104>, 
      <-1.319774, -1.386446, 1.781602>, <-1.306895, -1.369974, 1.753209>, <-1.281449, -1.341584, 1.723647>, <-1.261671, -1.320032, 1.703957>, 
      <-1.294874, -1.412698, 1.777212>, <-1.281995, -1.396226, 1.748818>, <-1.256550, -1.367836, 1.719258>, <-1.236772, -1.346284, 1.699567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.367511, -1.465017, 1.678106>, <-1.346350, -1.442580, 1.661012>, <-1.324194, -1.416561, 1.626962>, <-1.309407, -1.398604, 1.600461>, 
      <-1.392410, -1.438765, 1.682496>, <-1.371249, -1.416329, 1.665402>, <-1.349093, -1.390310, 1.631352>, <-1.334306, -1.372353, 1.604851>, 
      <-1.396640, -1.405035, 1.708655>, <-1.374466, -1.391096, 1.685045>, <-1.352701, -1.361714, 1.653583>, <-1.338534, -1.338624, 1.631010>, 
      <-1.376816, -1.390757, 1.735702>, <-1.354643, -1.376818, 1.712092>, <-1.332878, -1.347435, 1.680630>, <-1.318711, -1.324345, 1.658057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.285571, -1.486957, 1.719614>, <-1.273727, -1.461965, 1.697740>, <-1.247858, -1.436973, 1.665587>, <-1.227467, -1.420546, 1.641970>, 
      <-1.305394, -1.501235, 1.692567>, <-1.293551, -1.476243, 1.670693>, <-1.267681, -1.451252, 1.638539>, <-1.247290, -1.434825, 1.614923>, 
      <-1.342612, -1.491268, 1.673716>, <-1.321451, -1.468832, 1.656622>, <-1.299295, -1.442813, 1.622572>, <-1.284508, -1.424856, 1.596071>, 
      <-1.367511, -1.465017, 1.678106>, <-1.346350, -1.442580, 1.661012>, <-1.324194, -1.416561, 1.626962>, <-1.309407, -1.398604, 1.600461>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.285571, -1.486957, 1.719614>, <-1.273727, -1.461965, 1.697740>, <-1.247858, -1.436973, 1.665587>, <-1.227467, -1.420546, 1.641970>, 
      <-1.265748, -1.472679, 1.746661>, <-1.253904, -1.447686, 1.724787>, <-1.228034, -1.422694, 1.692634>, <-1.207644, -1.406267, 1.669018>, 
      <-1.269975, -1.438950, 1.772822>, <-1.257096, -1.422478, 1.744428>, <-1.231651, -1.394088, 1.714868>, <-1.211872, -1.372536, 1.695177>, 
      <-1.294874, -1.412698, 1.777212>, <-1.281995, -1.396226, 1.748818>, <-1.256550, -1.367836, 1.719258>, <-1.236772, -1.346284, 1.699567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.431732, -1.395397, 1.778401>, <-1.421393, -1.383579, 1.764585>, <-1.389968, -1.399025, 1.749706>, <-1.376816, -1.390757, 1.735702>, 
      <-1.400414, -1.372839, 1.821133>, <-1.390075, -1.361021, 1.807316>, <-1.370144, -1.384746, 1.776754>, <-1.356992, -1.376478, 1.762750>, 
      <-1.341614, -1.388586, 1.850916>, <-1.331324, -1.376824, 1.837166>, <-1.327377, -1.396169, 1.798363>, <-1.319774, -1.386446, 1.781602>, 
      <-1.302276, -1.430060, 1.843980>, <-1.291986, -1.418299, 1.830230>, <-1.302477, -1.422421, 1.793973>, <-1.294874, -1.412698, 1.777212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.417033, -1.512718, 1.687403>, <-1.406743, -1.500957, 1.673653>, <-1.380003, -1.478261, 1.688197>, <-1.367511, -1.465017, 1.678106>, 
      <-1.456371, -1.471244, 1.694339>, <-1.446081, -1.459482, 1.680589>, <-1.404902, -1.452010, 1.692587>, <-1.392410, -1.438765, 1.682496>, 
      <-1.463051, -1.417955, 1.735669>, <-1.452712, -1.406138, 1.721853>, <-1.409791, -1.413304, 1.722659>, <-1.396640, -1.405035, 1.708655>, 
      <-1.431732, -1.395397, 1.778401>, <-1.421393, -1.383579, 1.764585>, <-1.389968, -1.399025, 1.749706>, <-1.376816, -1.390757, 1.735702>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.287575, -1.547382, 1.752982>, <-1.277334, -1.535677, 1.739297>, <-1.292530, -1.501640, 1.732465>, <-1.285571, -1.486957, 1.719614>, 
      <-1.318894, -1.569941, 1.710250>, <-1.308653, -1.558235, 1.696565>, <-1.312353, -1.515919, 1.705418>, <-1.305394, -1.501235, 1.692567>, 
      <-1.377694, -1.554193, 1.680466>, <-1.367404, -1.542432, 1.666716>, <-1.355103, -1.504513, 1.683807>, <-1.342612, -1.491268, 1.673716>, 
      <-1.417033, -1.512718, 1.687403>, <-1.406743, -1.500957, 1.673653>, <-1.380003, -1.478261, 1.688197>, <-1.367511, -1.465017, 1.678106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.287575, -1.547382, 1.752982>, <-1.277334, -1.535677, 1.739297>, <-1.292530, -1.501640, 1.732465>, <-1.285571, -1.486957, 1.719614>, 
      <-1.256256, -1.524824, 1.795714>, <-1.246015, -1.513118, 1.782029>, <-1.272706, -1.487362, 1.759513>, <-1.265748, -1.472679, 1.746661>, 
      <-1.262938, -1.471535, 1.837044>, <-1.252648, -1.459773, 1.823293>, <-1.277577, -1.448673, 1.789583>, <-1.269975, -1.438950, 1.772822>, 
      <-1.302276, -1.430060, 1.843980>, <-1.291986, -1.418299, 1.830230>, <-1.302477, -1.422421, 1.793973>, <-1.294874, -1.412698, 1.777212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.493022, -1.523583, 1.890993>, <-1.469333, -1.489642, 1.855713>, <-1.458617, -1.426127, 1.814328>, <-1.431732, -1.395397, 1.778401>, 
      <-1.473199, -1.509304, 1.918040>, <-1.449510, -1.475363, 1.882760>, <-1.427298, -1.403568, 1.857060>, <-1.400414, -1.372839, 1.821133>, 
      <-1.435982, -1.519271, 1.936892>, <-1.403340, -1.484633, 1.910336>, <-1.368558, -1.419381, 1.886921>, <-1.341614, -1.388586, 1.850916>, 
      <-1.411083, -1.545523, 1.932502>, <-1.378441, -1.510884, 1.905945>, <-1.329219, -1.460856, 1.879984>, <-1.302276, -1.430060, 1.843980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.493022, -1.523583, 1.890993>, <-1.529849, -1.576348, 1.945840>, <-1.600075, -1.625995, 2.023520>, <-1.632341, -1.682823, 2.077168>, 
      <-1.473199, -1.509304, 1.918040>, <-1.510026, -1.562069, 1.972887>, <-1.580252, -1.611717, 2.050567>, <-1.612518, -1.668544, 2.104215>, 
      <-1.435982, -1.519271, 1.936892>, <-1.477777, -1.567044, 1.992744>, <-1.533505, -1.630740, 2.067214>, <-1.575300, -1.678513, 2.123067>, 
      <-1.411083, -1.545523, 1.932502>, <-1.452878, -1.593295, 1.988354>, <-1.508606, -1.656992, 2.062824>, <-1.550401, -1.704764, 2.118676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.483719, -1.597843, 1.833396>, <-1.463713, -1.572306, 1.789598>, <-1.443976, -1.543514, 1.723407>, <-1.417033, -1.512718, 1.687403>, 
      <-1.508618, -1.571591, 1.837786>, <-1.488612, -1.546054, 1.793988>, <-1.483314, -1.502040, 1.730344>, <-1.456371, -1.471244, 1.694339>, 
      <-1.512845, -1.537862, 1.863946>, <-1.489156, -1.503921, 1.828665>, <-1.489935, -1.448685, 1.771596>, <-1.463051, -1.417955, 1.735669>, 
      <-1.493022, -1.523583, 1.890993>, <-1.469333, -1.489642, 1.855713>, <-1.458617, -1.426127, 1.814328>, <-1.431732, -1.395397, 1.778401>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.483719, -1.597843, 1.833396>, <-1.525514, -1.645615, 1.889248>, <-1.581242, -1.709312, 1.963718>, <-1.623037, -1.757084, 2.019570>, 
      <-1.508618, -1.571591, 1.837786>, <-1.550413, -1.619363, 1.893638>, <-1.606141, -1.683060, 1.968109>, <-1.647937, -1.730832, 2.023961>, 
      <-1.512845, -1.537862, 1.863946>, <-1.549672, -1.590627, 1.918792>, <-1.619899, -1.640274, 1.996473>, <-1.652165, -1.697102, 2.050120>, 
      <-1.493022, -1.523583, 1.890993>, <-1.529849, -1.576348, 1.945840>, <-1.600075, -1.625995, 2.023520>, <-1.632341, -1.682823, 2.077168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.483719, -1.597843, 1.833396>, <-1.508618, -1.571591, 1.837786>, <-1.512845, -1.537862, 1.863946>, <-1.493022, -1.523583, 1.890993>, 
      <-1.483719, -1.597843, 1.833396>, <-1.486827, -1.555895, 1.867518>, <-1.493022, -1.523583, 1.890993>, <-1.473199, -1.509304, 1.918040>, 
      <-1.483719, -1.597843, 1.833396>, <-1.486827, -1.555895, 1.867518>, <-1.457772, -1.534967, 1.907160>, <-1.435982, -1.519271, 1.936892>, 
      <-1.483719, -1.597843, 1.833396>, <-1.461928, -1.582147, 1.863128>, <-1.432874, -1.561219, 1.902770>, <-1.411083, -1.545523, 1.932502>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.401780, -1.619783, 1.874905>, <-1.371765, -1.592359, 1.838429>, <-1.314576, -1.578244, 1.789064>, <-1.287575, -1.547382, 1.752982>, 
      <-1.421603, -1.634062, 1.847858>, <-1.391588, -1.606637, 1.811382>, <-1.345895, -1.600803, 1.746332>, <-1.318894, -1.569941, 1.710250>, 
      <-1.458820, -1.624095, 1.829006>, <-1.438814, -1.598557, 1.785208>, <-1.404637, -1.584989, 1.716471>, <-1.377694, -1.554193, 1.680466>, 
      <-1.483719, -1.597843, 1.833396>, <-1.463713, -1.572306, 1.789598>, <-1.443976, -1.543514, 1.723407>, <-1.417033, -1.512718, 1.687403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.401780, -1.619783, 1.874905>, <-1.448240, -1.662233, 1.931366>, <-1.490580, -1.741807, 2.004408>, <-1.541096, -1.779023, 2.061078>, 
      <-1.421603, -1.634062, 1.847858>, <-1.468063, -1.676512, 1.904319>, <-1.510403, -1.756086, 1.977360>, <-1.560919, -1.793302, 2.034031>, 
      <-1.458820, -1.624095, 1.829006>, <-1.500616, -1.671867, 1.884858>, <-1.556342, -1.735563, 1.959327>, <-1.598138, -1.783336, 2.015179>, 
      <-1.483719, -1.597843, 1.833396>, <-1.525514, -1.645615, 1.889248>, <-1.581242, -1.709312, 1.963718>, <-1.623037, -1.757084, 2.019570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.401780, -1.619783, 1.874905>, <-1.371765, -1.592359, 1.838429>, <-1.314576, -1.578244, 1.789064>, <-1.287575, -1.547382, 1.752982>, 
      <-1.381957, -1.605504, 1.901952>, <-1.351942, -1.578080, 1.865476>, <-1.283258, -1.555686, 1.831796>, <-1.256256, -1.524824, 1.795714>, 
      <-1.386184, -1.571775, 1.928112>, <-1.353542, -1.537136, 1.901555>, <-1.289881, -1.502330, 1.873048>, <-1.262938, -1.471535, 1.837044>, 
      <-1.411083, -1.545523, 1.932502>, <-1.378441, -1.510884, 1.905945>, <-1.329219, -1.460856, 1.879984>, <-1.302276, -1.430060, 1.843980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.401780, -1.619783, 1.874905>, <-1.421603, -1.634062, 1.847858>, <-1.458820, -1.624095, 1.829006>, <-1.483719, -1.597843, 1.833396>, 
      <-1.401780, -1.619783, 1.874905>, <-1.401780, -1.619783, 1.874905>, <-1.437029, -1.608399, 1.858738>, <-1.461928, -1.582147, 1.863128>, 
      <-1.401780, -1.619783, 1.874905>, <-1.401780, -1.619783, 1.874905>, <-1.407975, -1.587471, 1.898380>, <-1.432874, -1.561219, 1.902770>, 
      <-1.401780, -1.619783, 1.874905>, <-1.381957, -1.605504, 1.901952>, <-1.386184, -1.571775, 1.928112>, <-1.411083, -1.545523, 1.932502>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.401780, -1.619783, 1.874905>, <-1.381957, -1.605504, 1.901952>, <-1.386184, -1.571775, 1.928112>, <-1.411083, -1.545523, 1.932502>, 
      <-1.448240, -1.662233, 1.931366>, <-1.428417, -1.647955, 1.958413>, <-1.427979, -1.619547, 1.983964>, <-1.452878, -1.593295, 1.988354>, 
      <-1.490580, -1.741807, 2.004408>, <-1.470757, -1.727529, 2.031455>, <-1.483706, -1.683243, 2.058433>, <-1.508606, -1.656992, 2.062824>, 
      <-1.541096, -1.779023, 2.061078>, <-1.521273, -1.764744, 2.088125>, <-1.525502, -1.731015, 2.114285>, <-1.550401, -1.704764, 2.118676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.534559, 1.457496, 2.107037>, <-1.569260, 1.443329, 2.092885>, <-1.615529, 1.424440, 2.074014>, <-1.650230, 1.410273, 2.059862>, 
      <-1.534559, 1.457496, 2.107037>, <-1.568255, 1.416376, 2.117399>, <-1.614523, 1.397487, 2.098528>, <-1.649225, 1.383320, 2.084376>, 
      <-1.534559, 1.457496, 2.107037>, <-1.568255, 1.416376, 2.117399>, <-1.590552, 1.384499, 2.128366>, <-1.622121, 1.371611, 2.115491>, 
      <-1.534559, 1.457496, 2.107037>, <-1.533553, 1.430543, 2.131552>, <-1.558984, 1.397387, 2.141241>, <-1.590553, 1.384499, 2.128366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.594238, 1.483269, 2.038533>, <-1.625806, 1.470381, 2.025658>, <-1.651236, 1.437226, 2.035348>, <-1.650230, 1.410273, 2.059862>, 
      <-1.594238, 1.483269, 2.038533>, <-1.594238, 1.483269, 2.038533>, <-1.616534, 1.451393, 2.049501>, <-1.615529, 1.424440, 2.074014>, 
      <-1.594238, 1.483269, 2.038533>, <-1.594238, 1.483269, 2.038533>, <-1.570266, 1.470282, 2.068370>, <-1.569260, 1.443329, 2.092885>, 
      <-1.594238, 1.483269, 2.038533>, <-1.562670, 1.496157, 2.051408>, <-1.535565, 1.484449, 2.082523>, <-1.534559, 1.457496, 2.107037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.658012, 1.507468, 2.170681>, <-1.658012, 1.507468, 2.170681>, <-1.658012, 1.507468, 2.170681>, <-1.658012, 1.507468, 2.170681>, 
      <-1.637774, 1.470577, 2.157986>, <-1.637774, 1.470577, 2.157986>, <-1.655677, 1.478309, 2.137435>, <-1.655677, 1.478309, 2.137435>, 
      <-1.612427, 1.414177, 2.152291>, <-1.643995, 1.401290, 2.139416>, <-1.651559, 1.412479, 2.117622>, <-1.652565, 1.439431, 2.093108>, 
      <-1.590553, 1.384499, 2.128366>, <-1.622121, 1.371611, 2.115491>, <-1.649225, 1.383320, 2.084376>, <-1.650230, 1.410273, 2.059862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.658012, 1.507468, 2.170681>, <-1.658012, 1.507468, 2.170681>, <-1.658012, 1.507468, 2.170681>, <-1.658012, 1.507468, 2.170681>, 
      <-1.620976, 1.492476, 2.151588>, <-1.620976, 1.492476, 2.151588>, <-1.637774, 1.470577, 2.157986>, <-1.637774, 1.470577, 2.157986>, 
      <-1.571595, 1.472488, 2.126130>, <-1.570589, 1.445534, 2.150645>, <-1.580858, 1.427065, 2.165166>, <-1.612427, 1.414177, 2.152291>, 
      <-1.534559, 1.457496, 2.107037>, <-1.533553, 1.430543, 2.131552>, <-1.558984, 1.397387, 2.141241>, <-1.590553, 1.384499, 2.128366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.658012, 1.507468, 2.170681>, <-1.658012, 1.507468, 2.170681>, <-1.658012, 1.507468, 2.170681>, <-1.658012, 1.507468, 2.170681>, 
      <-1.638880, 1.500208, 2.131037>, <-1.638880, 1.500208, 2.131037>, <-1.620976, 1.492476, 2.151588>, <-1.620976, 1.492476, 2.151588>, 
      <-1.615960, 1.502773, 2.072270>, <-1.584392, 1.515661, 2.085145>, <-1.572601, 1.499441, 2.101616>, <-1.571595, 1.472488, 2.126130>, 
      <-1.594238, 1.483269, 2.038533>, <-1.562670, 1.496157, 2.051408>, <-1.535565, 1.484449, 2.082523>, <-1.534559, 1.457496, 2.107037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.658012, 1.507468, 2.170681>, <-1.638880, 1.500208, 2.131037>, <-1.615960, 1.502773, 2.072270>, <-1.594238, 1.483269, 2.038533>, 
      <-1.658012, 1.507468, 2.170681>, <-1.638880, 1.500208, 2.131037>, <-1.647528, 1.489885, 2.059395>, <-1.625806, 1.470381, 2.025658>, 
      <-1.658012, 1.507468, 2.170681>, <-1.655677, 1.478309, 2.137435>, <-1.653570, 1.466384, 2.068594>, <-1.651236, 1.437226, 2.035348>, 
      <-1.658012, 1.507468, 2.170681>, <-1.655677, 1.478309, 2.137435>, <-1.652565, 1.439431, 2.093108>, <-1.650230, 1.410273, 2.059862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.774394, 0.422451, 1.090211>, <-0.801209, 0.464002, 1.114365>, <-0.836363, 0.524137, 1.140364>, <-0.863777, 0.560956, 1.170726>, 
      <-0.830805, 0.399421, 1.067204>, <-0.857620, 0.440972, 1.091358>, <-0.867931, 0.511249, 1.127490>, <-0.895345, 0.548068, 1.157851>, 
      <-0.879240, 0.420343, 1.011601>, <-0.891965, 0.455810, 1.051930>, <-0.902270, 0.526049, 1.087988>, <-0.922449, 0.559777, 1.126736>, 
      <-0.881037, 0.468507, 0.967795>, <-0.893762, 0.503974, 1.008123>, <-0.903275, 0.553002, 1.063475>, <-0.923455, 0.586730, 1.102223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.674335, 0.552895, 1.052097>, <-0.714370, 0.577212, 1.081287>, <-0.773512, 0.605979, 1.116397>, <-0.807784, 0.633953, 1.149398>, 
      <-0.672538, 0.504730, 1.095903>, <-0.712573, 0.529048, 1.125094>, <-0.772506, 0.579025, 1.140911>, <-0.806778, 0.607000, 1.173912>, 
      <-0.717982, 0.445482, 1.113218>, <-0.744797, 0.487033, 1.137373>, <-0.804795, 0.537025, 1.153239>, <-0.832209, 0.573844, 1.183601>, 
      <-0.774394, 0.422451, 1.090211>, <-0.801209, 0.464002, 1.114365>, <-0.836363, 0.524137, 1.140364>, <-0.863777, 0.560956, 1.170726>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.780980, 0.598951, 0.929681>, <-0.806925, 0.617184, 0.975045>, <-0.840425, 0.634860, 1.039493>, <-0.867462, 0.659727, 1.080895>, 
      <-0.724568, 0.621982, 0.952688>, <-0.750513, 0.640215, 0.998052>, <-0.808857, 0.647748, 1.052368>, <-0.835894, 0.672615, 1.093770>, 
      <-0.676132, 0.601059, 1.008291>, <-0.716167, 0.625377, 1.037481>, <-0.774517, 0.632932, 1.091884>, <-0.808790, 0.660906, 1.124885>, 
      <-0.674335, 0.552895, 1.052097>, <-0.714370, 0.577212, 1.081287>, <-0.773512, 0.605979, 1.116397>, <-0.807784, 0.633953, 1.149398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.780980, 0.598951, 0.929681>, <-0.837392, 0.575920, 0.906674>, <-0.882834, 0.516671, 0.923989>, <-0.881037, 0.468507, 0.967795>, 
      <-0.806925, 0.617184, 0.975045>, <-0.863336, 0.594153, 0.952038>, <-0.895560, 0.552138, 0.964317>, <-0.893762, 0.503974, 1.008123>, 
      <-0.840425, 0.634860, 1.039493>, <-0.871993, 0.621972, 1.026619>, <-0.904281, 0.579956, 1.038961>, <-0.903275, 0.553002, 1.063475>, 
      <-0.867462, 0.659727, 1.080895>, <-0.899030, 0.646839, 1.068020>, <-0.924461, 0.613683, 1.077709>, <-0.923455, 0.586730, 1.102223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.951708, 0.660597, 1.286591>, <-0.925964, 0.637534, 1.246554>, <-0.890123, 0.596341, 1.199905>, <-0.863777, 0.560956, 1.170726>, 
      <-0.983276, 0.647709, 1.273716>, <-0.957532, 0.624646, 1.233679>, <-0.921691, 0.583453, 1.187031>, <-0.895345, 0.548068, 1.157851>, 
      <-1.010381, 0.659417, 1.242601>, <-0.976873, 0.632982, 1.211361>, <-0.941788, 0.592099, 1.163870>, <-0.922449, 0.559777, 1.126736>, 
      <-1.011387, 0.686370, 1.218087>, <-0.977879, 0.659934, 1.186846>, <-0.942794, 0.619052, 1.139357>, <-0.923455, 0.586730, 1.102223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895716, 0.733593, 1.265262>, <-0.877174, 0.701048, 1.227918>, <-0.840628, 0.660762, 1.181023>, <-0.807784, 0.633953, 1.149398>, 
      <-0.894710, 0.706641, 1.289776>, <-0.876168, 0.674095, 1.252432>, <-0.839623, 0.633808, 1.205537>, <-0.806778, 0.607000, 1.173912>, 
      <-0.920140, 0.673485, 1.299466>, <-0.894396, 0.650421, 1.259429>, <-0.858555, 0.609229, 1.212780>, <-0.832209, 0.573844, 1.183601>, 
      <-0.951708, 0.660597, 1.286591>, <-0.925964, 0.637534, 1.246554>, <-0.890123, 0.596341, 1.199905>, <-0.863777, 0.560956, 1.170726>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.955394, 0.759366, 1.196757>, <-0.929087, 0.723427, 1.168229>, <-0.893299, 0.683490, 1.120459>, <-0.867462, 0.659727, 1.080895>, 
      <-0.923826, 0.772254, 1.209632>, <-0.897518, 0.736315, 1.181104>, <-0.861731, 0.696378, 1.133333>, <-0.835894, 0.672615, 1.093770>, 
      <-0.896722, 0.760546, 1.240748>, <-0.878179, 0.728000, 1.203404>, <-0.841634, 0.687715, 1.156510>, <-0.808790, 0.660906, 1.124885>, 
      <-0.895716, 0.733593, 1.265262>, <-0.877174, 0.701048, 1.227918>, <-0.840628, 0.660762, 1.181023>, <-0.807784, 0.633953, 1.149398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.955394, 0.759366, 1.196757>, <-0.929087, 0.723427, 1.168229>, <-0.893299, 0.683490, 1.120459>, <-0.867462, 0.659727, 1.080895>, 
      <-0.986962, 0.746478, 1.183882>, <-0.960655, 0.710539, 1.155354>, <-0.924867, 0.670602, 1.107584>, <-0.899030, 0.646839, 1.068020>, 
      <-1.012393, 0.713323, 1.193573>, <-0.978885, 0.686887, 1.162332>, <-0.943799, 0.646006, 1.114843>, <-0.924461, 0.613683, 1.077709>, 
      <-1.011387, 0.686370, 1.218087>, <-0.977879, 0.659934, 1.186846>, <-0.942794, 0.619052, 1.139357>, <-0.923455, 0.586730, 1.102223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.979355, 0.664499, 1.350473>, <-0.968924, 0.652679, 1.336728>, <-0.961888, 0.669717, 1.302423>, <-0.951708, 0.660597, 1.286591>, 
      <-1.029229, 0.644138, 1.330133>, <-1.018798, 0.632318, 1.316388>, <-0.993456, 0.656829, 1.289548>, <-0.983276, 0.647709, 1.273716>, 
      <-1.072051, 0.662635, 1.280975>, <-1.061670, 0.650871, 1.267296>, <-1.023568, 0.669821, 1.254896>, <-1.010381, 0.659417, 1.242601>, 
      <-1.073640, 0.705217, 1.242246>, <-1.063259, 0.693453, 1.228567>, <-1.024574, 0.696774, 1.230382>, <-1.011387, 0.686370, 1.218087>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.890893, 0.779824, 1.316777>, <-0.880511, 0.768060, 1.303098>, <-0.903013, 0.746401, 1.279959>, <-0.895716, 0.733593, 1.265262>, 
      <-0.889304, 0.737242, 1.355506>, <-0.878922, 0.725478, 1.341827>, <-0.902007, 0.719449, 1.304473>, <-0.894710, 0.706641, 1.289776>, 
      <-0.929481, 0.684860, 1.370813>, <-0.919050, 0.673040, 1.357069>, <-0.930320, 0.682605, 1.315297>, <-0.920140, 0.673485, 1.299466>, 
      <-0.979355, 0.664499, 1.350473>, <-0.968924, 0.652679, 1.336728>, <-0.961888, 0.669717, 1.302423>, <-0.951708, 0.660597, 1.286591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.985178, 0.820542, 1.208549>, <-0.974846, 0.808834, 1.194935>, <-0.965698, 0.773443, 1.207931>, <-0.955394, 0.759366, 1.196757>, 
      <-0.935304, 0.840903, 1.228890>, <-0.924972, 0.829195, 1.215275>, <-0.934130, 0.786330, 1.220806>, <-0.923826, 0.772254, 1.209632>, 
      <-0.892482, 0.822406, 1.278048>, <-0.882100, 0.810642, 1.264368>, <-0.904019, 0.773354, 1.255444>, <-0.896722, 0.760546, 1.240748>, 
      <-0.890893, 0.779824, 1.316777>, <-0.880511, 0.768060, 1.303098>, <-0.903013, 0.746401, 1.279959>, <-0.895716, 0.733593, 1.265262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.985178, 0.820542, 1.208549>, <-0.974846, 0.808834, 1.194935>, <-0.965698, 0.773443, 1.207931>, <-0.955394, 0.759366, 1.196757>, 
      <-1.035052, 0.800181, 1.188209>, <-1.024720, 0.788473, 1.174594>, <-0.997266, 0.760555, 1.195056>, <-0.986962, 0.746478, 1.183882>, 
      <-1.075229, 0.747799, 1.203517>, <-1.064848, 0.736035, 1.189838>, <-1.025580, 0.723726, 1.205867>, <-1.012393, 0.713323, 1.193573>, 
      <-1.073640, 0.705217, 1.242246>, <-1.063259, 0.693453, 1.228567>, <-1.024574, 0.696774, 1.230382>, <-1.011387, 0.686370, 1.218087>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.098262, 0.826665, 1.479699>, <-1.062455, 0.780558, 1.438055>, <-1.015119, 0.705025, 1.397598>, <-0.979355, 0.664499, 1.350473>, 
      <-1.129830, 0.813777, 1.466825>, <-1.094023, 0.767671, 1.425180>, <-1.064993, 0.684664, 1.377258>, <-1.029229, 0.644138, 1.330133>, 
      <-1.156934, 0.825485, 1.435709>, <-1.128092, 0.782370, 1.386026>, <-1.107874, 0.703228, 1.328178>, <-1.072051, 0.662635, 1.280975>, 
      <-1.157940, 0.852438, 1.411195>, <-1.129098, 0.809323, 1.361512>, <-1.109463, 0.745810, 1.289449>, <-1.073640, 0.705217, 1.242246>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.042270, 0.899660, 1.458369>, <-0.999891, 0.862071, 1.414207>, <-0.926716, 0.820417, 1.363979>, <-0.890893, 0.779824, 1.316777>, 
      <-1.041264, 0.872708, 1.482883>, <-0.998885, 0.835119, 1.438721>, <-0.925127, 0.777835, 1.402709>, <-0.889304, 0.737242, 1.355506>, 
      <-1.066694, 0.839553, 1.492573>, <-1.030887, 0.793446, 1.450929>, <-0.965245, 0.725387, 1.417939>, <-0.929481, 0.684860, 1.370813>, 
      <-1.098262, 0.826665, 1.479699>, <-1.062455, 0.780558, 1.438055>, <-1.015119, 0.705025, 1.397598>, <-0.979355, 0.664499, 1.350473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.101948, 0.925434, 1.389865>, <-1.066534, 0.890843, 1.337659>, <-1.021060, 0.861202, 1.255829>, <-0.985178, 0.820542, 1.208549>, 
      <-1.070380, 0.938322, 1.402740>, <-1.034966, 0.903730, 1.350534>, <-0.971186, 0.881563, 1.276170>, <-0.935304, 0.840903, 1.228890>, 
      <-1.043276, 0.926613, 1.433855>, <-1.000897, 0.889024, 1.389693>, <-0.928305, 0.862999, 1.325250>, <-0.892482, 0.822406, 1.278048>, 
      <-1.042270, 0.899660, 1.458369>, <-0.999891, 0.862071, 1.414207>, <-0.926716, 0.820417, 1.363979>, <-0.890893, 0.779824, 1.316777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.101948, 0.925434, 1.389865>, <-1.066534, 0.890843, 1.337659>, <-1.021060, 0.861202, 1.255829>, <-0.985178, 0.820542, 1.208549>, 
      <-1.133516, 0.912546, 1.376991>, <-1.098103, 0.877955, 1.324784>, <-1.070934, 0.840841, 1.235489>, <-1.035052, 0.800181, 1.188209>, 
      <-1.158946, 0.879390, 1.386681>, <-1.130103, 0.836275, 1.336998>, <-1.111052, 0.788392, 1.250720>, <-1.075229, 0.747799, 1.203517>, 
      <-1.157940, 0.852438, 1.411195>, <-1.129098, 0.809323, 1.361512>, <-1.109463, 0.745810, 1.289449>, <-1.073640, 0.705217, 1.242246>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.156885, 0.893091, 1.556942>, <-1.139960, 0.879294, 1.529255>, <-1.115870, 0.849337, 1.500177>, <-1.098262, 0.826665, 1.479699>, 
      <-1.188453, 0.880203, 1.544067>, <-1.171528, 0.866406, 1.516380>, <-1.147438, 0.836449, 1.487302>, <-1.129830, 0.813777, 1.466825>, 
      <-1.215556, 0.891912, 1.512952>, <-1.191791, 0.875146, 1.493015>, <-1.171094, 0.846652, 1.460100>, <-1.156934, 0.825485, 1.435709>, 
      <-1.216562, 0.918864, 1.488438>, <-1.192796, 0.902098, 1.468501>, <-1.172100, 0.873604, 1.435586>, <-1.157940, 0.852438, 1.411195>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.100891, 0.966087, 1.535613>, <-1.090313, 0.943937, 1.510297>, <-1.063075, 0.918113, 1.480049>, <-1.042270, 0.899660, 1.458369>, 
      <-1.099886, 0.939134, 1.560127>, <-1.089308, 0.916984, 1.534812>, <-1.062069, 0.891161, 1.504563>, <-1.041264, 0.872708, 1.482883>, 
      <-1.125317, 0.905979, 1.569817>, <-1.108392, 0.892182, 1.542129>, <-1.084302, 0.862225, 1.513051>, <-1.066694, 0.839553, 1.492573>, 
      <-1.156885, 0.893091, 1.556942>, <-1.139960, 0.879294, 1.529255>, <-1.115870, 0.849337, 1.500177>, <-1.098262, 0.826665, 1.479699>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.160570, 0.991861, 1.467108>, <-1.143150, 0.966718, 1.449564>, <-1.119305, 0.942388, 1.415452>, <-1.101948, 0.925434, 1.389865>, 
      <-1.129001, 1.004749, 1.479983>, <-1.111582, 0.979606, 1.462439>, <-1.087737, 0.955276, 1.428327>, <-1.070380, 0.938322, 1.402740>, 
      <-1.101897, 0.993040, 1.511098>, <-1.091319, 0.970890, 1.485783>, <-1.064081, 0.945066, 1.455535>, <-1.043276, 0.926613, 1.433855>, 
      <-1.100891, 0.966087, 1.535613>, <-1.090313, 0.943937, 1.510297>, <-1.063075, 0.918113, 1.480049>, <-1.042270, 0.899660, 1.458369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.160570, 0.991861, 1.467108>, <-1.143150, 0.966718, 1.449564>, <-1.119305, 0.942388, 1.415452>, <-1.101948, 0.925434, 1.389865>, 
      <-1.192138, 0.978973, 1.454233>, <-1.174719, 0.953830, 1.436690>, <-1.150873, 0.929500, 1.402578>, <-1.133516, 0.912546, 1.376991>, 
      <-1.217568, 0.945817, 1.463924>, <-1.193802, 0.929051, 1.443987>, <-1.173105, 0.900557, 1.411071>, <-1.158946, 0.879390, 1.386681>, 
      <-1.216562, 0.918864, 1.488438>, <-1.192796, 0.902098, 1.468501>, <-1.172100, 0.873604, 1.435586>, <-1.157940, 0.852438, 1.411195>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.184531, 0.896991, 1.620824>, <-1.174100, 0.885171, 1.607079>, <-1.166924, 0.901275, 1.573364>, <-1.156885, 0.893091, 1.556942>, 
      <-1.234405, 0.876629, 1.600483>, <-1.223974, 0.864810, 1.586739>, <-1.198492, 0.888387, 1.560490>, <-1.188453, 0.880203, 1.544067>, 
      <-1.277226, 0.895128, 1.551325>, <-1.266844, 0.883364, 1.537646>, <-1.229586, 0.901809, 1.524721>, <-1.215556, 0.891912, 1.512952>, 
      <-1.278815, 0.937710, 1.512596>, <-1.268434, 0.925946, 1.498917>, <-1.230591, 0.928761, 1.500207>, <-1.216562, 0.918864, 1.488438>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.096069, 1.012318, 1.587127>, <-1.085687, 1.000554, 1.573448>, <-1.107135, 0.979163, 1.550557>, <-1.100891, 0.966087, 1.535613>, 
      <-1.094480, 0.969735, 1.625857>, <-1.084098, 0.957972, 1.612177>, <-1.106130, 0.952210, 1.575071>, <-1.099886, 0.939134, 1.560127>, 
      <-1.134657, 0.917353, 1.641165>, <-1.124226, 0.905533, 1.627420>, <-1.135356, 0.914162, 1.586239>, <-1.125317, 0.905979, 1.569817>, 
      <-1.184531, 0.896991, 1.620824>, <-1.174100, 0.885171, 1.607079>, <-1.166924, 0.901275, 1.573364>, <-1.156885, 0.893091, 1.556942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.190354, 1.053036, 1.478899>, <-1.180022, 1.041328, 1.465285>, <-1.170804, 1.006632, 1.477415>, <-1.160570, 0.991861, 1.467108>, 
      <-1.140480, 1.073398, 1.499239>, <-1.130148, 1.061690, 1.485625>, <-1.139236, 1.019520, 1.490290>, <-1.129001, 1.004749, 1.479983>, 
      <-1.097658, 1.054900, 1.548398>, <-1.087276, 1.043136, 1.534719>, <-1.108141, 1.006115, 1.526043>, <-1.101897, 0.993040, 1.511098>, 
      <-1.096069, 1.012318, 1.587127>, <-1.085687, 1.000554, 1.573448>, <-1.107135, 0.979163, 1.550557>, <-1.100891, 0.966087, 1.535613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.190354, 1.053036, 1.478899>, <-1.180022, 1.041328, 1.465285>, <-1.170804, 1.006632, 1.477415>, <-1.160570, 0.991861, 1.467108>, 
      <-1.240228, 1.032674, 1.458559>, <-1.229896, 1.020967, 1.444945>, <-1.202372, 0.993745, 1.464540>, <-1.192138, 0.978973, 1.454233>, 
      <-1.280404, 0.980292, 1.473867>, <-1.270023, 0.968529, 1.460188>, <-1.231597, 0.955714, 1.475693>, <-1.217568, 0.945817, 1.463924>, 
      <-1.278815, 0.937710, 1.512596>, <-1.268434, 0.925946, 1.498917>, <-1.230591, 0.928761, 1.500207>, <-1.216562, 0.918864, 1.488438>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.274128, 1.025945, 1.711428>, <-1.247003, 0.990188, 1.680710>, <-1.211656, 0.927728, 1.656565>, <-1.184531, 0.896991, 1.620824>, 
      <-1.305696, 1.013057, 1.698553>, <-1.278571, 0.977300, 1.667836>, <-1.261529, 0.907366, 1.636225>, <-1.234405, 0.876629, 1.600483>, 
      <-1.332801, 1.024765, 1.667438>, <-1.311991, 0.991717, 1.629419>, <-1.304409, 0.925930, 1.587143>, <-1.277226, 0.895128, 1.551325>, 
      <-1.333806, 1.051718, 1.642924>, <-1.312997, 1.018669, 1.604905>, <-1.305998, 0.968513, 1.548414>, <-1.278815, 0.937710, 1.512596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.218135, 1.098941, 1.690099>, <-1.185040, 1.070908, 1.657091>, <-1.123252, 1.043120, 1.622945>, <-1.096069, 1.012318, 1.587127>, 
      <-1.217130, 1.071988, 1.714613>, <-1.184035, 1.043956, 1.681605>, <-1.121663, 1.000538, 1.661674>, <-1.094480, 0.969735, 1.625857>, 
      <-1.242560, 1.038833, 1.724303>, <-1.215434, 1.003076, 1.693585>, <-1.161781, 0.948089, 1.676906>, <-1.134657, 0.917353, 1.641165>, 
      <-1.274128, 1.025945, 1.711428>, <-1.247003, 0.990188, 1.680710>, <-1.211656, 0.927728, 1.656565>, <-1.184531, 0.896991, 1.620824>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.277813, 1.124715, 1.621594>, <-1.251035, 1.099399, 1.581277>, <-1.217595, 1.083905, 1.514794>, <-1.190354, 1.053036, 1.478899>, 
      <-1.246245, 1.137603, 1.634469>, <-1.219467, 1.112287, 1.594152>, <-1.167722, 1.104266, 1.535134>, <-1.140480, 1.073398, 1.499239>, 
      <-1.219141, 1.125894, 1.665585>, <-1.186046, 1.097861, 1.632576>, <-1.124841, 1.085703, 1.584216>, <-1.097658, 1.054900, 1.548398>, 
      <-1.218135, 1.098941, 1.690099>, <-1.185040, 1.070908, 1.657091>, <-1.123252, 1.043120, 1.622945>, <-1.096069, 1.012318, 1.587127>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.277813, 1.124715, 1.621594>, <-1.251035, 1.099399, 1.581277>, <-1.217595, 1.083905, 1.514794>, <-1.190354, 1.053036, 1.478899>, 
      <-1.309382, 1.111827, 1.608719>, <-1.282604, 1.086511, 1.568402>, <-1.267469, 1.063543, 1.494453>, <-1.240228, 1.032674, 1.458559>, 
      <-1.334812, 1.078671, 1.618410>, <-1.314002, 1.045622, 1.580391>, <-1.307587, 1.011095, 1.509685>, <-1.280404, 0.980292, 1.473867>, 
      <-1.333806, 1.051718, 1.642924>, <-1.312997, 1.018669, 1.604905>, <-1.305998, 0.968513, 1.548414>, <-1.278815, 0.937710, 1.512596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.332748, 1.092371, 1.788671>, <-1.315824, 1.078574, 1.760984>, <-1.291715, 1.049128, 1.731344>, <-1.274128, 1.025945, 1.711428>, 
      <-1.364316, 1.079483, 1.775796>, <-1.347392, 1.065686, 1.748109>, <-1.323283, 1.036240, 1.718469>, <-1.305696, 1.013057, 1.698553>, 
      <-1.391421, 1.091192, 1.744681>, <-1.367655, 1.074426, 1.724744>, <-1.346263, 1.046147, 1.692035>, <-1.332801, 1.024765, 1.667438>, 
      <-1.392427, 1.118145, 1.720167>, <-1.368661, 1.101379, 1.700230>, <-1.347269, 1.073099, 1.667521>, <-1.333806, 1.051718, 1.642924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.276756, 1.165367, 1.767342>, <-1.266179, 1.143217, 1.742026>, <-1.239546, 1.117077, 1.711454>, <-1.218135, 1.098941, 1.690099>, 
      <-1.275750, 1.138414, 1.791856>, <-1.265173, 1.116264, 1.766540>, <-1.238540, 1.090124, 1.735968>, <-1.217130, 1.071988, 1.714613>, 
      <-1.301180, 1.105258, 1.801546>, <-1.284256, 1.091461, 1.773859>, <-1.260146, 1.062015, 1.744219>, <-1.242560, 1.038833, 1.724303>, 
      <-1.332748, 1.092371, 1.788671>, <-1.315824, 1.078574, 1.760984>, <-1.291715, 1.049128, 1.731344>, <-1.274128, 1.025945, 1.711428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.336435, 1.191141, 1.698838>, <-1.319015, 1.165998, 1.681295>, <-1.295100, 1.141058, 1.647622>, <-1.277813, 1.124715, 1.621594>, 
      <-1.304867, 1.204029, 1.711713>, <-1.287447, 1.178885, 1.694169>, <-1.263532, 1.153946, 1.660497>, <-1.246245, 1.137603, 1.634469>, 
      <-1.277762, 1.192320, 1.742828>, <-1.267185, 1.170170, 1.717512>, <-1.240552, 1.144030, 1.686940>, <-1.219141, 1.125894, 1.665585>, 
      <-1.276756, 1.165367, 1.767342>, <-1.266179, 1.143217, 1.742026>, <-1.239546, 1.117077, 1.711454>, <-1.218135, 1.098941, 1.690099>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.336435, 1.191141, 1.698838>, <-1.319015, 1.165998, 1.681295>, <-1.295100, 1.141058, 1.647622>, <-1.277813, 1.124715, 1.621594>, 
      <-1.368003, 1.178254, 1.685963>, <-1.350583, 1.153110, 1.668420>, <-1.326669, 1.128171, 1.634747>, <-1.309382, 1.111827, 1.608719>, 
      <-1.393433, 1.145098, 1.695653>, <-1.369667, 1.128332, 1.675716>, <-1.348274, 1.100052, 1.643006>, <-1.334812, 1.078671, 1.618410>, 
      <-1.392427, 1.118145, 1.720167>, <-1.368661, 1.101379, 1.700230>, <-1.347269, 1.073099, 1.667521>, <-1.333806, 1.051718, 1.642924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.360395, 1.096273, 1.852553>, <-1.349964, 1.084453, 1.838808>, <-1.342787, 1.100555, 1.805093>, <-1.332748, 1.092371, 1.788671>, 
      <-1.410269, 1.075912, 1.832213>, <-1.399838, 1.064092, 1.818468>, <-1.374355, 1.087667, 1.792219>, <-1.364316, 1.079483, 1.775796>, 
      <-1.453092, 1.094410, 1.783055>, <-1.442710, 1.082646, 1.769375>, <-1.405450, 1.101089, 1.756450>, <-1.391421, 1.091192, 1.744681>, 
      <-1.454681, 1.136992, 1.744325>, <-1.444299, 1.125228, 1.730646>, <-1.406456, 1.128042, 1.731936>, <-1.392427, 1.118145, 1.720167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.271933, 1.211598, 1.818856>, <-1.261551, 1.199834, 1.805177>, <-1.283000, 1.178443, 1.782286>, <-1.276756, 1.165367, 1.767342>, 
      <-1.270344, 1.169016, 1.857585>, <-1.259962, 1.157252, 1.843906>, <-1.281994, 1.151490, 1.806800>, <-1.275750, 1.138414, 1.791856>, 
      <-1.310521, 1.116634, 1.872893>, <-1.300090, 1.104814, 1.859149>, <-1.311219, 1.113442, 1.817968>, <-1.301180, 1.105258, 1.801546>, 
      <-1.360395, 1.096273, 1.852553>, <-1.349964, 1.084453, 1.838808>, <-1.342787, 1.100555, 1.805093>, <-1.332748, 1.092371, 1.788671>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.366218, 1.252317, 1.710627>, <-1.355886, 1.240609, 1.697013>, <-1.346669, 1.205913, 1.709145>, <-1.336435, 1.191141, 1.698838>, 
      <-1.316344, 1.272678, 1.730968>, <-1.306011, 1.260970, 1.717353>, <-1.315101, 1.218800, 1.722020>, <-1.304867, 1.204029, 1.711713>, 
      <-1.273522, 1.254180, 1.780126>, <-1.263140, 1.242417, 1.766447>, <-1.284006, 1.205396, 1.757772>, <-1.277762, 1.192320, 1.742828>, 
      <-1.271933, 1.211598, 1.818856>, <-1.261551, 1.199834, 1.805177>, <-1.283000, 1.178443, 1.782286>, <-1.276756, 1.165367, 1.767342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.366218, 1.252317, 1.710627>, <-1.355886, 1.240609, 1.697013>, <-1.346669, 1.205913, 1.709145>, <-1.336435, 1.191141, 1.698838>, 
      <-1.416092, 1.231956, 1.690287>, <-1.405760, 1.220248, 1.676673>, <-1.378237, 1.193025, 1.696270>, <-1.368003, 1.178254, 1.685963>, 
      <-1.456270, 1.179574, 1.705595>, <-1.445888, 1.167810, 1.691916>, <-1.407463, 1.154995, 1.707422>, <-1.393433, 1.145098, 1.695653>, 
      <-1.454681, 1.136992, 1.744325>, <-1.444299, 1.125228, 1.730646>, <-1.406456, 1.128042, 1.731936>, <-1.392427, 1.118145, 1.720167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.449992, 1.225225, 1.943156>, <-1.422814, 1.191189, 1.910586>, <-1.387520, 1.127009, 1.888294>, <-1.360395, 1.096273, 1.852553>, 
      <-1.481560, 1.212337, 1.930281>, <-1.454381, 1.178302, 1.897712>, <-1.437394, 1.106648, 1.867953>, <-1.410269, 1.075912, 1.832213>, 
      <-1.508664, 1.224045, 1.899167>, <-1.492167, 1.189843, 1.860068>, <-1.480275, 1.125212, 1.818872>, <-1.453092, 1.094410, 1.783055>, 
      <-1.509670, 1.250998, 1.874653>, <-1.493173, 1.216796, 1.835555>, <-1.481864, 1.167794, 1.780143>, <-1.454681, 1.136992, 1.744325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.449992, 1.225225, 1.943156>, <-1.492244, 1.278137, 1.993789>, <-1.548474, 1.327406, 2.082341>, <-1.590553, 1.384499, 2.128366>, 
      <-1.481560, 1.212337, 1.930281>, <-1.523812, 1.265249, 1.980914>, <-1.580042, 1.314518, 2.069467>, <-1.622121, 1.371611, 2.115491>, 
      <-1.508664, 1.224045, 1.899167>, <-1.550832, 1.271828, 1.954729>, <-1.607057, 1.335538, 2.028813>, <-1.649225, 1.383320, 2.084376>, 
      <-1.509670, 1.250998, 1.874653>, <-1.551838, 1.298781, 1.930216>, <-1.608062, 1.362490, 2.004299>, <-1.650230, 1.410273, 2.059862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.393999, 1.298222, 1.921828>, <-1.357379, 1.272235, 1.890936>, <-1.299116, 1.242401, 1.854674>, <-1.271933, 1.211598, 1.818856>, 
      <-1.392993, 1.271269, 1.946342>, <-1.356373, 1.245282, 1.915450>, <-1.297527, 1.199819, 1.893403>, <-1.270344, 1.169016, 1.857585>, 
      <-1.418424, 1.238113, 1.956031>, <-1.391245, 1.204078, 1.923461>, <-1.337646, 1.147370, 1.908634>, <-1.310521, 1.116634, 1.872893>, 
      <-1.449992, 1.225225, 1.943156>, <-1.422814, 1.191189, 1.910586>, <-1.387520, 1.127009, 1.888294>, <-1.360395, 1.096273, 1.852553>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.393999, 1.298222, 1.921828>, <-1.436167, 1.346004, 1.977391>, <-1.492391, 1.409714, 2.051474>, <-1.534559, 1.457496, 2.107037>, 
      <-1.392993, 1.271269, 1.946342>, <-1.435161, 1.319051, 2.001905>, <-1.491385, 1.382761, 2.075989>, <-1.533553, 1.430543, 2.131552>, 
      <-1.418424, 1.238113, 1.956031>, <-1.460675, 1.291025, 2.006664>, <-1.516905, 1.340294, 2.095217>, <-1.558984, 1.397387, 2.141241>, 
      <-1.449992, 1.225225, 1.943156>, <-1.492244, 1.278137, 1.993789>, <-1.548474, 1.327406, 2.082341>, <-1.590553, 1.384499, 2.128366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.393999, 1.298222, 1.921828>, <-1.392993, 1.271269, 1.946342>, <-1.418424, 1.238113, 1.956031>, <-1.449992, 1.225225, 1.943156>, 
      <-1.393999, 1.298222, 1.921828>, <-1.427694, 1.257102, 1.932189>, <-1.449992, 1.225225, 1.943156>, <-1.481560, 1.212337, 1.930281>, 
      <-1.393999, 1.298222, 1.921828>, <-1.427694, 1.257102, 1.932189>, <-1.473963, 1.238212, 1.913319>, <-1.508664, 1.224045, 1.899167>, 
      <-1.393999, 1.298222, 1.921828>, <-1.428700, 1.284055, 1.907676>, <-1.474969, 1.265165, 1.888806>, <-1.509670, 1.250998, 1.874653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.453679, 1.323995, 1.853324>, <-1.426683, 1.296652, 1.814503>, <-1.393460, 1.283186, 1.746522>, <-1.366218, 1.252317, 1.710627>, 
      <-1.422111, 1.336883, 1.866199>, <-1.395115, 1.309540, 1.827378>, <-1.343585, 1.303547, 1.766863>, <-1.316344, 1.272678, 1.730968>, 
      <-1.395005, 1.325175, 1.897314>, <-1.358385, 1.299188, 1.866422>, <-1.300705, 1.284983, 1.815944>, <-1.273522, 1.254180, 1.780126>, 
      <-1.393999, 1.298222, 1.921828>, <-1.357379, 1.272235, 1.890936>, <-1.299116, 1.242401, 1.854674>, <-1.271933, 1.211598, 1.818856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.453679, 1.323995, 1.853324>, <-1.495466, 1.366319, 1.913416>, <-1.553073, 1.446306, 1.974598>, <-1.594238, 1.483269, 2.038533>, 
      <-1.422111, 1.336883, 1.866199>, <-1.463897, 1.379207, 1.926291>, <-1.521505, 1.459194, 1.987473>, <-1.562670, 1.496157, 2.051408>, 
      <-1.395005, 1.325175, 1.897314>, <-1.437173, 1.372957, 1.952877>, <-1.493397, 1.436667, 2.026960>, <-1.535565, 1.484449, 2.082523>, 
      <-1.393999, 1.298222, 1.921828>, <-1.436167, 1.346004, 1.977391>, <-1.492391, 1.409714, 2.051474>, <-1.534559, 1.457496, 2.107037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.453679, 1.323995, 1.853324>, <-1.426683, 1.296652, 1.814503>, <-1.393460, 1.283186, 1.746522>, <-1.366218, 1.252317, 1.710627>, 
      <-1.485247, 1.311107, 1.840449>, <-1.458251, 1.283764, 1.801628>, <-1.443334, 1.262825, 1.726182>, <-1.416092, 1.231956, 1.690287>, 
      <-1.510676, 1.277951, 1.850139>, <-1.494180, 1.243749, 1.811041>, <-1.483453, 1.210376, 1.741413>, <-1.456270, 1.179574, 1.705595>, 
      <-1.509670, 1.250998, 1.874653>, <-1.493173, 1.216796, 1.835555>, <-1.481864, 1.167794, 1.780143>, <-1.454681, 1.136992, 1.744325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.453679, 1.323995, 1.853324>, <-1.422111, 1.336883, 1.866199>, <-1.395005, 1.325175, 1.897314>, <-1.393999, 1.298222, 1.921828>, 
      <-1.453679, 1.323995, 1.853324>, <-1.453679, 1.323995, 1.853324>, <-1.429707, 1.311008, 1.883161>, <-1.428700, 1.284055, 1.907676>, 
      <-1.453679, 1.323995, 1.853324>, <-1.453679, 1.323995, 1.853324>, <-1.475975, 1.292118, 1.864292>, <-1.474969, 1.265165, 1.888806>, 
      <-1.453679, 1.323995, 1.853324>, <-1.485247, 1.311107, 1.840449>, <-1.510676, 1.277951, 1.850139>, <-1.509670, 1.250998, 1.874653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.453679, 1.323995, 1.853324>, <-1.485247, 1.311107, 1.840449>, <-1.510676, 1.277951, 1.850139>, <-1.509670, 1.250998, 1.874653>, 
      <-1.495466, 1.366319, 1.913416>, <-1.527034, 1.353431, 1.900541>, <-1.552844, 1.325733, 1.905702>, <-1.551838, 1.298781, 1.930216>, 
      <-1.553073, 1.446306, 1.974598>, <-1.584641, 1.433419, 1.961723>, <-1.609068, 1.389443, 1.979785>, <-1.608062, 1.362490, 2.004299>, 
      <-1.594238, 1.483269, 2.038533>, <-1.625806, 1.470381, 2.025658>, <-1.651236, 1.437226, 2.035348>, <-1.650230, 1.410273, 2.059862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.850330, 0.965996>, <2.130214, -0.917591, 0.965996>, <2.051168, -0.917591, 0.965996>, 
      <2.197475, -0.692238, 0.965996>, <2.197475, -0.771284, 0.965996>, <2.130214, -0.917591, 1.045042>, <2.051168, -0.917591, 1.045042>, 
      <2.130214, -0.624977, 0.965996>, <2.130214, -0.624977, 1.045042>, <2.051168, -0.771284, 1.112303>, <2.051168, -0.850330, 1.112303>, 
      <2.051168, -0.624977, 0.965996>, <2.051168, -0.624977, 1.045042>, <2.051168, -0.692238, 1.112303>, <2.051168, -0.771284, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.850330, 0.965996>, <2.130214, -0.917591, 0.965996>, <2.051168, -0.917591, 0.965996>, 
      <2.197475, -0.692238, 0.965996>, <2.197475, -0.771284, 0.965996>, <2.130214, -0.917591, 0.886950>, <2.051168, -0.917591, 0.886950>, 
      <2.130214, -0.624977, 0.965996>, <2.130214, -0.624977, 0.886950>, <2.051168, -0.771284, 0.819690>, <2.051168, -0.850329, 0.819690>, 
      <2.051168, -0.624977, 0.965996>, <2.051168, -0.624977, 0.886950>, <2.051168, -0.692238, 0.819690>, <2.051168, -0.771284, 0.819690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.692238, 0.965996>, <2.130214, -0.624977, 0.965996>, <2.051168, -0.624977, 0.965996>, 
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.692238, 0.886950>, <2.130214, -0.624977, 0.886950>, <2.051168, -0.624977, 0.886950>, 
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.692238, 0.886950>, <2.130213, -0.692238, 0.819690>, <2.051168, -0.692238, 0.819690>, 
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.771284, 0.886950>, <2.130213, -0.771284, 0.819690>, <2.051168, -0.771284, 0.819690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.850330, 0.965996>, <2.130214, -0.917591, 0.965996>, <2.051168, -0.917591, 0.965996>, 
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.850330, 0.886950>, <2.130214, -0.917591, 0.886950>, <2.051168, -0.917591, 0.886950>, 
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.850330, 0.886950>, <2.130213, -0.850329, 0.819690>, <2.051168, -0.850329, 0.819690>, 
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.771284, 0.886950>, <2.130213, -0.771284, 0.819690>, <2.051168, -0.771284, 0.819690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.850330, 0.965996>, <2.130214, -0.917591, 0.965996>, <2.051168, -0.917591, 0.965996>, 
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.850330, 1.045042>, <2.130214, -0.917591, 1.045042>, <2.051168, -0.917591, 1.045042>, 
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.850330, 1.045042>, <2.130214, -0.850330, 1.112303>, <2.051168, -0.850330, 1.112303>, 
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.771284, 1.045042>, <2.130214, -0.771284, 1.112303>, <2.051168, -0.771284, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.771284, 1.045042>, <2.130214, -0.771284, 1.112303>, <2.051168, -0.771284, 1.112303>, 
      <2.197475, -0.771284, 0.886950>, <2.197475, -0.771284, 0.965996>, <2.130214, -0.850330, 1.112303>, <2.051168, -0.850330, 1.112303>, 
      <2.130213, -0.771284, 0.819690>, <2.130213, -0.850329, 0.819690>, <2.051168, -0.917591, 0.965996>, <2.051168, -0.917591, 1.045042>, 
      <2.051168, -0.771284, 0.819690>, <2.051168, -0.850329, 0.819690>, <2.051168, -0.917591, 0.886950>, <2.051168, -0.917591, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.692238, 0.965996>, <2.130214, -0.624977, 0.965996>, <2.051168, -0.624977, 0.965996>, 
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.692238, 1.045042>, <2.130214, -0.624977, 1.045042>, <2.051168, -0.624977, 1.045042>, 
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.692238, 1.045042>, <2.130214, -0.692238, 1.112303>, <2.051168, -0.692238, 1.112303>, 
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.771284, 1.045042>, <2.130214, -0.771284, 1.112303>, <2.051168, -0.771284, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, -0.771284, 0.965996>, <2.197475, -0.771284, 0.886950>, <2.130213, -0.771284, 0.819690>, <2.051168, -0.771284, 0.819690>, 
      <2.197475, -0.771284, 1.045042>, <2.197475, -0.771284, 0.965996>, <2.130213, -0.692238, 0.819690>, <2.051168, -0.692238, 0.819690>, 
      <2.130214, -0.771284, 1.112303>, <2.130214, -0.692238, 1.112303>, <2.051168, -0.624977, 0.965996>, <2.051168, -0.624977, 0.886950>, 
      <2.051168, -0.771284, 1.112303>, <2.051168, -0.692238, 1.112303>, <2.051168, -0.624977, 1.045042>, <2.051168, -0.624977, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.692238, 0.965996>, <1.972122, -0.624977, 0.965996>, <2.051168, -0.624977, 0.965996>, 
      <1.904862, -0.850329, 0.965996>, <1.904862, -0.771284, 0.965996>, <1.972122, -0.624977, 0.886950>, <2.051168, -0.624977, 0.886950>, 
      <1.972122, -0.917591, 0.965996>, <1.972122, -0.917591, 0.886950>, <2.051168, -0.771284, 0.819690>, <2.051168, -0.692238, 0.819690>, 
      <2.051168, -0.917591, 0.965996>, <2.051168, -0.917591, 0.886950>, <2.051168, -0.850329, 0.819690>, <2.051168, -0.771284, 0.819690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.692238, 0.965996>, <1.972122, -0.624977, 0.965996>, <2.051168, -0.624977, 0.965996>, 
      <1.904862, -0.850329, 0.965996>, <1.904862, -0.771284, 0.965996>, <1.972122, -0.624977, 1.045042>, <2.051168, -0.624977, 1.045042>, 
      <1.972122, -0.917591, 0.965996>, <1.972122, -0.917591, 1.045042>, <2.051168, -0.771284, 1.112303>, <2.051168, -0.692238, 1.112303>, 
      <2.051168, -0.917591, 0.965996>, <2.051168, -0.917591, 1.045042>, <2.051168, -0.850330, 1.112303>, <2.051168, -0.771284, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.850329, 0.965996>, <1.972122, -0.917591, 0.965996>, <2.051168, -0.917591, 0.965996>, 
      <1.904862, -0.771284, 1.045042>, <1.904862, -0.850329, 1.045042>, <2.051168, -0.917591, 0.965996>, <2.130214, -0.917591, 0.965996>, 
      <1.972122, -0.771284, 1.112303>, <2.051168, -0.771284, 1.112303>, <2.197475, -0.850330, 1.045042>, <2.197475, -0.850330, 0.965996>, 
      <2.051168, -0.771284, 1.112303>, <2.130214, -0.771284, 1.112303>, <2.197475, -0.771284, 1.045042>, <2.197475, -0.771284, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.771284, 1.045042>, <1.972122, -0.771284, 1.112303>, <2.051168, -0.771284, 1.112303>, 
      <1.904862, -0.692238, 0.965996>, <1.904862, -0.692238, 1.045042>, <2.051168, -0.771284, 1.112303>, <2.130214, -0.771284, 1.112303>, 
      <1.972122, -0.624977, 0.965996>, <2.051168, -0.624977, 0.965996>, <2.197475, -0.692238, 1.045042>, <2.197475, -0.771284, 1.045042>, 
      <2.051168, -0.624977, 0.965996>, <2.130214, -0.624977, 0.965996>, <2.197475, -0.692238, 0.965996>, <2.197475, -0.771284, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.771284, 1.045042>, <1.972122, -0.771284, 1.112303>, <2.051168, -0.771284, 1.112303>, 
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.850329, 1.045042>, <1.972122, -0.850330, 1.112303>, <2.051168, -0.850330, 1.112303>, 
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.850329, 1.045042>, <1.972122, -0.917591, 1.045042>, <2.051168, -0.917591, 1.045042>, 
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.850329, 0.965996>, <1.972122, -0.917591, 0.965996>, <2.051168, -0.917591, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.692238, 0.965996>, <1.972122, -0.624977, 0.965996>, <2.051168, -0.624977, 0.965996>, 
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.692238, 1.045042>, <1.972122, -0.624977, 1.045042>, <2.051168, -0.624977, 1.045042>, 
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.692238, 1.045042>, <1.972122, -0.692238, 1.112303>, <2.051168, -0.692238, 1.112303>, 
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.771284, 1.045042>, <1.972122, -0.771284, 1.112303>, <2.051168, -0.771284, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.850329, 0.965996>, <1.972122, -0.917591, 0.965996>, <2.051168, -0.917591, 0.965996>, 
      <1.904862, -0.771284, 0.886951>, <1.904862, -0.850329, 0.886951>, <2.051168, -0.917591, 0.965996>, <2.130214, -0.917591, 0.965996>, 
      <1.972123, -0.771284, 0.819690>, <2.051168, -0.771284, 0.819690>, <2.197475, -0.850330, 0.886950>, <2.197475, -0.850330, 0.965996>, 
      <2.051168, -0.771284, 0.819690>, <2.130213, -0.771284, 0.819690>, <2.197475, -0.771284, 0.886950>, <2.197475, -0.771284, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.692238, 0.965996>, <1.972122, -0.624977, 0.965996>, <2.051168, -0.624977, 0.965996>, 
      <1.904862, -0.771284, 0.886951>, <1.904862, -0.692238, 0.886951>, <2.051168, -0.624977, 0.965996>, <2.130214, -0.624977, 0.965996>, 
      <1.972123, -0.771284, 0.819690>, <2.051168, -0.771284, 0.819690>, <2.197475, -0.692238, 0.886950>, <2.197475, -0.692238, 0.965996>, 
      <2.051168, -0.771284, 0.819690>, <2.130213, -0.771284, 0.819690>, <2.197475, -0.771284, 0.886950>, <2.197475, -0.771284, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.692238, 0.965996>, <1.972122, -0.624977, 0.965996>, <2.051168, -0.624977, 0.965996>, 
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.692238, 0.886951>, <1.972122, -0.624977, 0.886950>, <2.051168, -0.624977, 0.886950>, 
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.692238, 0.886951>, <1.972123, -0.692238, 0.819690>, <2.051168, -0.692238, 0.819690>, 
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.771284, 0.886951>, <1.972123, -0.771284, 0.819690>, <2.051168, -0.771284, 0.819690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.771284, 1.045042>, <1.972122, -0.771284, 1.112303>, <2.051168, -0.771284, 1.112303>, 
      <1.904862, -0.771284, 0.886951>, <1.904862, -0.771284, 0.965996>, <1.972122, -0.692238, 1.112303>, <2.051168, -0.692238, 1.112303>, 
      <1.972123, -0.771284, 0.819690>, <1.972123, -0.692238, 0.819690>, <2.051168, -0.624977, 0.965996>, <2.051168, -0.624977, 1.045042>, 
      <2.051168, -0.771284, 0.819690>, <2.051168, -0.692238, 0.819690>, <2.051168, -0.624977, 0.886950>, <2.051168, -0.624977, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.850329, 0.965996>, <1.972122, -0.917591, 0.965996>, <2.051168, -0.917591, 0.965996>, 
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.850329, 0.886951>, <1.972122, -0.917591, 0.886950>, <2.051168, -0.917591, 0.886950>, 
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.850329, 0.886951>, <1.972123, -0.850329, 0.819690>, <2.051168, -0.850329, 0.819690>, 
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.771284, 0.886951>, <1.972123, -0.771284, 0.819690>, <2.051168, -0.771284, 0.819690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, -0.771284, 0.965996>, <1.904862, -0.771284, 0.886951>, <1.972123, -0.771284, 0.819690>, <2.051168, -0.771284, 0.819690>, 
      <1.904862, -0.771284, 1.045042>, <1.904862, -0.771284, 0.965996>, <1.972123, -0.850329, 0.819690>, <2.051168, -0.850329, 0.819690>, 
      <1.972122, -0.771284, 1.112303>, <1.972122, -0.850330, 1.112303>, <2.051168, -0.917591, 0.965996>, <2.051168, -0.917591, 0.886950>, 
      <2.051168, -0.771284, 1.112303>, <2.051168, -0.850330, 1.112303>, <2.051168, -0.917591, 1.045042>, <2.051168, -0.917591, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.407066, 0.965996>, <2.130214, 0.339804, 0.965996>, <2.051169, 0.339804, 0.965996>, 
      <2.197475, 0.565156, 0.965996>, <2.197475, 0.486111, 0.965996>, <2.130214, 0.339804, 1.045042>, <2.051169, 0.339804, 1.045042>, 
      <2.130214, 0.632418, 0.965996>, <2.130214, 0.632418, 1.045042>, <2.051169, 0.486111, 1.112303>, <2.051169, 0.407065, 1.112303>, 
      <2.051169, 0.632418, 0.965996>, <2.051169, 0.632418, 1.045042>, <2.051169, 0.565157, 1.112303>, <2.051169, 0.486111, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.407066, 0.965996>, <2.130214, 0.339804, 0.965996>, <2.051169, 0.339804, 0.965996>, 
      <2.197475, 0.565156, 0.965996>, <2.197475, 0.486111, 0.965996>, <2.130214, 0.339804, 0.886950>, <2.051169, 0.339804, 0.886950>, 
      <2.130214, 0.632418, 0.965996>, <2.130214, 0.632418, 0.886950>, <2.051169, 0.486111, 0.819689>, <2.051169, 0.407065, 0.819689>, 
      <2.051169, 0.632418, 0.965996>, <2.051169, 0.632418, 0.886950>, <2.051169, 0.565157, 0.819689>, <2.051169, 0.486111, 0.819689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.565156, 0.965996>, <2.130214, 0.632418, 0.965996>, <2.051169, 0.632418, 0.965996>, 
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.565156, 0.886950>, <2.130214, 0.632418, 0.886950>, <2.051169, 0.632418, 0.886950>, 
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.565156, 0.886950>, <2.130214, 0.565157, 0.819689>, <2.051169, 0.565157, 0.819689>, 
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.486111, 0.886950>, <2.130214, 0.486111, 0.819689>, <2.051169, 0.486111, 0.819689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.407066, 0.965996>, <2.130214, 0.339804, 0.965996>, <2.051169, 0.339804, 0.965996>, 
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.407066, 0.886950>, <2.130214, 0.339804, 0.886950>, <2.051169, 0.339804, 0.886950>, 
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.407066, 0.886950>, <2.130214, 0.407065, 0.819689>, <2.051169, 0.407065, 0.819689>, 
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.486111, 0.886950>, <2.130214, 0.486111, 0.819689>, <2.051169, 0.486111, 0.819689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.407066, 0.965996>, <2.130214, 0.339804, 0.965996>, <2.051169, 0.339804, 0.965996>, 
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.407066, 1.045042>, <2.130214, 0.339804, 1.045042>, <2.051169, 0.339804, 1.045042>, 
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.407066, 1.045042>, <2.130214, 0.407065, 1.112303>, <2.051169, 0.407065, 1.112303>, 
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.486111, 1.045042>, <2.130214, 0.486111, 1.112303>, <2.051169, 0.486111, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.486111, 1.045042>, <2.130214, 0.486111, 1.112303>, <2.051169, 0.486111, 1.112303>, 
      <2.197475, 0.486111, 0.886950>, <2.197475, 0.486111, 0.965996>, <2.130214, 0.407065, 1.112303>, <2.051169, 0.407065, 1.112303>, 
      <2.130214, 0.486111, 0.819689>, <2.130214, 0.407065, 0.819689>, <2.051169, 0.339804, 0.965996>, <2.051169, 0.339804, 1.045042>, 
      <2.051169, 0.486111, 0.819689>, <2.051169, 0.407065, 0.819689>, <2.051169, 0.339804, 0.886950>, <2.051169, 0.339804, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.565156, 0.965996>, <2.130214, 0.632418, 0.965996>, <2.051169, 0.632418, 0.965996>, 
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.565156, 1.045042>, <2.130214, 0.632418, 1.045042>, <2.051169, 0.632418, 1.045042>, 
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.565156, 1.045042>, <2.130214, 0.565157, 1.112303>, <2.051169, 0.565157, 1.112303>, 
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.486111, 1.045042>, <2.130214, 0.486111, 1.112303>, <2.051169, 0.486111, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.197475, 0.486111, 0.965996>, <2.197475, 0.486111, 0.886950>, <2.130214, 0.486111, 0.819689>, <2.051169, 0.486111, 0.819689>, 
      <2.197475, 0.486111, 1.045042>, <2.197475, 0.486111, 0.965996>, <2.130214, 0.565157, 0.819689>, <2.051169, 0.565157, 0.819689>, 
      <2.130214, 0.486111, 1.112303>, <2.130214, 0.565157, 1.112303>, <2.051169, 0.632418, 0.965996>, <2.051169, 0.632418, 0.886950>, 
      <2.051169, 0.486111, 1.112303>, <2.051169, 0.565157, 1.112303>, <2.051169, 0.632418, 1.045042>, <2.051169, 0.632418, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.565157, 0.965996>, <1.972123, 0.632418, 0.965996>, <2.051169, 0.632418, 0.965996>, 
      <1.904862, 0.407065, 0.965996>, <1.904862, 0.486111, 0.965996>, <1.972123, 0.632418, 0.886950>, <2.051169, 0.632418, 0.886950>, 
      <1.972123, 0.339804, 0.965996>, <1.972123, 0.339804, 0.886950>, <2.051169, 0.486111, 0.819689>, <2.051169, 0.565157, 0.819689>, 
      <2.051169, 0.339804, 0.965996>, <2.051169, 0.339804, 0.886950>, <2.051169, 0.407065, 0.819689>, <2.051169, 0.486111, 0.819689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.565157, 0.965996>, <1.972123, 0.632418, 0.965996>, <2.051169, 0.632418, 0.965996>, 
      <1.904862, 0.407065, 0.965996>, <1.904862, 0.486111, 0.965996>, <1.972123, 0.632418, 1.045042>, <2.051169, 0.632418, 1.045042>, 
      <1.972123, 0.339804, 0.965996>, <1.972123, 0.339804, 1.045042>, <2.051169, 0.486111, 1.112303>, <2.051169, 0.565157, 1.112303>, 
      <2.051169, 0.339804, 0.965996>, <2.051169, 0.339804, 1.045042>, <2.051169, 0.407065, 1.112303>, <2.051169, 0.486111, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.407065, 0.965996>, <1.972123, 0.339804, 0.965996>, <2.051169, 0.339804, 0.965996>, 
      <1.904862, 0.486111, 1.045042>, <1.904862, 0.407065, 1.045042>, <2.051169, 0.339804, 0.965996>, <2.130214, 0.339804, 0.965996>, 
      <1.972123, 0.486111, 1.112303>, <2.051169, 0.486111, 1.112303>, <2.197475, 0.407066, 1.045042>, <2.197475, 0.407066, 0.965996>, 
      <2.051169, 0.486111, 1.112303>, <2.130214, 0.486111, 1.112303>, <2.197475, 0.486111, 1.045042>, <2.197475, 0.486111, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.486111, 1.045042>, <1.972123, 0.486111, 1.112303>, <2.051169, 0.486111, 1.112303>, 
      <1.904862, 0.565157, 0.965996>, <1.904862, 0.565157, 1.045042>, <2.051169, 0.486111, 1.112303>, <2.130214, 0.486111, 1.112303>, 
      <1.972123, 0.632418, 0.965996>, <2.051169, 0.632418, 0.965996>, <2.197475, 0.565156, 1.045042>, <2.197475, 0.486111, 1.045042>, 
      <2.051169, 0.632418, 0.965996>, <2.130214, 0.632418, 0.965996>, <2.197475, 0.565156, 0.965996>, <2.197475, 0.486111, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.486111, 1.045042>, <1.972123, 0.486111, 1.112303>, <2.051169, 0.486111, 1.112303>, 
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.407065, 1.045042>, <1.972123, 0.407065, 1.112303>, <2.051169, 0.407065, 1.112303>, 
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.407065, 1.045042>, <1.972123, 0.339804, 1.045042>, <2.051169, 0.339804, 1.045042>, 
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.407065, 0.965996>, <1.972123, 0.339804, 0.965996>, <2.051169, 0.339804, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.565157, 0.965996>, <1.972123, 0.632418, 0.965996>, <2.051169, 0.632418, 0.965996>, 
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.565157, 1.045042>, <1.972123, 0.632418, 1.045042>, <2.051169, 0.632418, 1.045042>, 
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.565157, 1.045042>, <1.972123, 0.565157, 1.112303>, <2.051169, 0.565157, 1.112303>, 
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.486111, 1.045042>, <1.972123, 0.486111, 1.112303>, <2.051169, 0.486111, 1.112303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.407065, 0.965996>, <1.972123, 0.339804, 0.965996>, <2.051169, 0.339804, 0.965996>, 
      <1.904862, 0.486111, 0.886950>, <1.904862, 0.407065, 0.886950>, <2.051169, 0.339804, 0.965996>, <2.130214, 0.339804, 0.965996>, 
      <1.972123, 0.486111, 0.819689>, <2.051169, 0.486111, 0.819689>, <2.197475, 0.407066, 0.886950>, <2.197475, 0.407066, 0.965996>, 
      <2.051169, 0.486111, 0.819689>, <2.130214, 0.486111, 0.819689>, <2.197475, 0.486111, 0.886950>, <2.197475, 0.486111, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.565157, 0.965996>, <1.972123, 0.632418, 0.965996>, <2.051169, 0.632418, 0.965996>, 
      <1.904862, 0.486111, 0.886950>, <1.904862, 0.565157, 0.886950>, <2.051169, 0.632418, 0.965996>, <2.130214, 0.632418, 0.965996>, 
      <1.972123, 0.486111, 0.819689>, <2.051169, 0.486111, 0.819689>, <2.197475, 0.565156, 0.886950>, <2.197475, 0.565156, 0.965996>, 
      <2.051169, 0.486111, 0.819689>, <2.130214, 0.486111, 0.819689>, <2.197475, 0.486111, 0.886950>, <2.197475, 0.486111, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.565157, 0.965996>, <1.972123, 0.632418, 0.965996>, <2.051169, 0.632418, 0.965996>, 
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.565157, 0.886950>, <1.972123, 0.632418, 0.886950>, <2.051169, 0.632418, 0.886950>, 
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.565157, 0.886950>, <1.972123, 0.565157, 0.819689>, <2.051169, 0.565157, 0.819689>, 
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.486111, 0.886950>, <1.972123, 0.486111, 0.819689>, <2.051169, 0.486111, 0.819689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.486111, 1.045042>, <1.972123, 0.486111, 1.112303>, <2.051169, 0.486111, 1.112303>, 
      <1.904862, 0.486111, 0.886950>, <1.904862, 0.486111, 0.965996>, <1.972123, 0.565157, 1.112303>, <2.051169, 0.565157, 1.112303>, 
      <1.972123, 0.486111, 0.819689>, <1.972123, 0.565157, 0.819689>, <2.051169, 0.632418, 0.965996>, <2.051169, 0.632418, 1.045042>, 
      <2.051169, 0.486111, 0.819689>, <2.051169, 0.565157, 0.819689>, <2.051169, 0.632418, 0.886950>, <2.051169, 0.632418, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.407065, 0.965996>, <1.972123, 0.339804, 0.965996>, <2.051169, 0.339804, 0.965996>, 
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.407065, 0.886950>, <1.972123, 0.339804, 0.886950>, <2.051169, 0.339804, 0.886950>, 
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.407065, 0.886950>, <1.972123, 0.407065, 0.819689>, <2.051169, 0.407065, 0.819689>, 
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.486111, 0.886950>, <1.972123, 0.486111, 0.819689>, <2.051169, 0.486111, 0.819689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904862, 0.486111, 0.965996>, <1.904862, 0.486111, 0.886950>, <1.972123, 0.486111, 0.819689>, <2.051169, 0.486111, 0.819689>, 
      <1.904862, 0.486111, 1.045042>, <1.904862, 0.486111, 0.965996>, <1.972123, 0.407065, 0.819689>, <2.051169, 0.407065, 0.819689>, 
      <1.972123, 0.486111, 1.112303>, <1.972123, 0.407065, 1.112303>, <2.051169, 0.339804, 0.965996>, <2.051169, 0.339804, 0.886950>, 
      <2.051169, 0.486111, 1.112303>, <2.051169, 0.407065, 1.112303>, <2.051169, 0.339804, 1.045042>, <2.051169, 0.339804, 0.965996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.925428, -1.757084, 2.019570>, <2.903637, -1.741388, 2.049302>, <2.874583, -1.720460, 2.088944>, <2.852792, -1.704764, 2.118676>, 
      <2.925428, -1.757084, 2.019570>, <2.928537, -1.715136, 2.053693>, <2.899482, -1.694209, 2.093335>, <2.877691, -1.678513, 2.123067>, 
      <2.925428, -1.757084, 2.019570>, <2.928537, -1.715136, 2.053693>, <2.934732, -1.682823, 2.077168>, <2.914909, -1.668544, 2.104215>, 
      <2.925428, -1.757084, 2.019570>, <2.950328, -1.730832, 2.023961>, <2.954556, -1.697102, 2.050120>, <2.934732, -1.682823, 2.077168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.843487, -1.779023, 2.061078>, <2.823664, -1.764744, 2.088125>, <2.827893, -1.731015, 2.114285>, <2.852792, -1.704764, 2.118676>, 
      <2.843487, -1.779023, 2.061078>, <2.843487, -1.779023, 2.061078>, <2.849684, -1.746711, 2.084553>, <2.874583, -1.720460, 2.088944>, 
      <2.843487, -1.779023, 2.061078>, <2.843487, -1.779023, 2.061078>, <2.878738, -1.767640, 2.044911>, <2.903637, -1.741388, 2.049302>, 
      <2.843487, -1.779023, 2.061078>, <2.863310, -1.793302, 2.034031>, <2.900528, -1.783336, 2.015179>, <2.925428, -1.757084, 2.019570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.954921, -1.804513, 2.156204>, <2.954921, -1.804513, 2.156204>, <2.954921, -1.804513, 2.156204>, <2.954921, -1.804513, 2.156204>, 
      <2.948864, -1.768006, 2.132493>, <2.948864, -1.768006, 2.132493>, <2.924282, -1.774588, 2.144946>, <2.924282, -1.774588, 2.144946>, 
      <2.951504, -1.712363, 2.105055>, <2.931681, -1.698084, 2.132102>, <2.908330, -1.708437, 2.134325>, <2.883431, -1.734689, 2.129934>, 
      <2.934732, -1.682823, 2.077168>, <2.914909, -1.668544, 2.104215>, <2.877691, -1.678513, 2.123067>, <2.852792, -1.704764, 2.118676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.954921, -1.804513, 2.156204>, <2.954921, -1.804513, 2.156204>, <2.954921, -1.804513, 2.156204>, <2.954921, -1.804513, 2.156204>, 
      <2.946073, -1.790284, 2.115214>, <2.946073, -1.790284, 2.115214>, <2.948864, -1.768006, 2.132493>, <2.948864, -1.768006, 2.132493>, 
      <2.934276, -1.771313, 2.060560>, <2.959176, -1.745061, 2.064951>, <2.971328, -1.726642, 2.078008>, <2.951504, -1.712363, 2.105055>, 
      <2.925428, -1.757084, 2.019570>, <2.950328, -1.730832, 2.023961>, <2.954556, -1.697102, 2.050120>, <2.934732, -1.682823, 2.077168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.954921, -1.804513, 2.156204>, <2.954921, -1.804513, 2.156204>, <2.954921, -1.804513, 2.156204>, <2.954921, -1.804513, 2.156204>, 
      <2.921491, -1.796866, 2.127666>, <2.921491, -1.796866, 2.127666>, <2.946073, -1.790284, 2.115214>, <2.946073, -1.790284, 2.115214>, 
      <2.870143, -1.798661, 2.090982>, <2.889967, -1.812940, 2.063935>, <2.909376, -1.797564, 2.056170>, <2.934276, -1.771313, 2.060560>, 
      <2.843487, -1.779023, 2.061078>, <2.863310, -1.793302, 2.034031>, <2.900528, -1.783336, 2.015179>, <2.925428, -1.757084, 2.019570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.954921, -1.804513, 2.156204>, <2.921491, -1.796866, 2.127666>, <2.870143, -1.798661, 2.090982>, <2.843487, -1.779023, 2.061078>, 
      <2.954921, -1.804513, 2.156204>, <2.921491, -1.796866, 2.127666>, <2.850320, -1.784382, 2.118029>, <2.823664, -1.764744, 2.088125>, 
      <2.954921, -1.804513, 2.156204>, <2.924282, -1.774588, 2.144946>, <2.858531, -1.760940, 2.125544>, <2.827893, -1.731015, 2.114285>, 
      <2.954921, -1.804513, 2.156204>, <2.924282, -1.774588, 2.144946>, <2.883431, -1.734689, 2.129934>, <2.852792, -1.704764, 2.118676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.163125, -0.721981, 1.004403>, <2.178501, -0.763223, 1.037445>, <2.192978, -0.822798, 1.079506>, <2.214377, -0.859454, 1.114541>, 
      <2.127701, -0.696465, 1.052736>, <2.143077, -0.737707, 1.085778>, <2.173155, -0.808519, 1.106554>, <2.194553, -0.845175, 1.141589>, 
      <2.061194, -0.714277, 1.086424>, <2.095915, -0.750339, 1.109665>, <2.125925, -0.821113, 1.130415>, <2.157336, -0.855144, 1.160439>, 
      <2.016699, -0.761188, 1.078579>, <2.051420, -0.797250, 1.101820>, <2.101026, -0.847364, 1.126025>, <2.132436, -0.881396, 1.156049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.146498, -0.854683, 0.901478>, <2.164070, -0.878392, 0.948118>, <2.182510, -0.906057, 1.014846>, <2.205071, -0.933714, 1.056944>, 
      <2.190993, -0.807772, 0.909323>, <2.208565, -0.831481, 0.955963>, <2.207410, -0.879805, 1.019236>, <2.229970, -0.907462, 1.061334>, 
      <2.198549, -0.747497, 0.956070>, <2.213924, -0.788739, 0.989111>, <2.212801, -0.837076, 1.052459>, <2.234200, -0.873732, 1.087493>, 
      <2.163125, -0.721981, 1.004403>, <2.178501, -0.763223, 1.037445>, <2.192978, -0.822798, 1.079506>, <2.214377, -0.859454, 1.114541>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.000072, -0.893889, 0.975653>, <2.036990, -0.912419, 1.012493>, <2.090544, -0.930638, 1.061363>, <2.123131, -0.955655, 1.098453>, 
      <2.035496, -0.919405, 0.927320>, <2.072413, -0.937935, 0.964160>, <2.110368, -0.944916, 1.034315>, <2.142954, -0.969934, 1.071406>, 
      <2.102003, -0.901594, 0.893633>, <2.119575, -0.925303, 0.940272>, <2.157611, -0.932308, 1.010456>, <2.180171, -0.959966, 1.052554>, 
      <2.146498, -0.854683, 0.901478>, <2.164070, -0.878392, 0.948118>, <2.182510, -0.906057, 1.014846>, <2.205071, -0.933714, 1.056944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.000072, -0.893889, 0.975653>, <1.964648, -0.868373, 1.023986>, <1.972204, -0.808099, 1.070733>, <2.016699, -0.761188, 1.078579>, 
      <2.036990, -0.912419, 1.012493>, <2.001566, -0.886903, 1.060826>, <2.006925, -0.844162, 1.093975>, <2.051420, -0.797250, 1.101820>, 
      <2.090544, -0.930638, 1.061363>, <2.070721, -0.916359, 1.088410>, <2.076127, -0.873615, 1.121635>, <2.101026, -0.847364, 1.126025>, 
      <2.123131, -0.955655, 1.098453>, <2.103308, -0.941377, 1.125500>, <2.107537, -0.907647, 1.151659>, <2.132436, -0.881396, 1.156049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.301532, -0.959074, 1.231009>, <2.269887, -0.935851, 1.195556>, <2.234942, -0.894682, 1.148211>, <2.214377, -0.859454, 1.114541>, 
      <2.281709, -0.944795, 1.258056>, <2.250064, -0.921572, 1.222603>, <2.215119, -0.880404, 1.175259>, <2.194553, -0.845175, 1.141589>, 
      <2.244492, -0.954763, 1.276907>, <2.223395, -0.928663, 1.236025>, <2.187437, -0.887758, 1.189212>, <2.157336, -0.855144, 1.160439>, 
      <2.219593, -0.981014, 1.272517>, <2.198496, -0.954914, 1.231635>, <2.162538, -0.914010, 1.184822>, <2.132436, -0.881396, 1.156049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.292227, -1.033334, 1.173411>, <2.261733, -1.000465, 1.145351>, <2.226691, -0.960219, 1.097289>, <2.205071, -0.933714, 1.056944>, 
      <2.317127, -1.007082, 1.177801>, <2.286632, -0.974213, 1.149742>, <2.251591, -0.933967, 1.101679>, <2.229970, -0.907462, 1.061334>, 
      <2.321355, -0.973353, 1.203961>, <2.289710, -0.950130, 1.168508>, <2.254766, -0.908961, 1.121164>, <2.234200, -0.873732, 1.087493>, 
      <2.301532, -0.959074, 1.231009>, <2.269887, -0.935851, 1.195556>, <2.234942, -0.894682, 1.148211>, <2.214377, -0.859454, 1.114541>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.210287, -1.055275, 1.214920>, <2.190361, -1.019508, 1.181434>, <2.154272, -0.979562, 1.133898>, <2.123131, -0.955655, 1.098453>, 
      <2.230110, -1.069554, 1.187873>, <2.210184, -1.033787, 1.154387>, <2.174095, -0.993841, 1.106850>, <2.142954, -0.969934, 1.071406>, 
      <2.267328, -1.059586, 1.169021>, <2.236834, -1.026717, 1.140961>, <2.201792, -0.986471, 1.092898>, <2.180171, -0.959966, 1.052554>, 
      <2.292227, -1.033334, 1.173411>, <2.261733, -1.000465, 1.145351>, <2.226691, -0.960219, 1.097289>, <2.205071, -0.933714, 1.056944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.210287, -1.055275, 1.214920>, <2.190361, -1.019508, 1.181434>, <2.154272, -0.979562, 1.133898>, <2.123131, -0.955655, 1.098453>, 
      <2.190464, -1.040996, 1.241968>, <2.170538, -1.005229, 1.208482>, <2.134449, -0.965284, 1.160945>, <2.103308, -0.941377, 1.125500>, 
      <2.194694, -1.007266, 1.268126>, <2.173597, -0.981166, 1.227244>, <2.137639, -0.940261, 1.180432>, <2.107537, -0.907647, 1.151659>, 
      <2.219593, -0.981014, 1.272517>, <2.198496, -0.954914, 1.231635>, <2.162538, -0.914010, 1.184822>, <2.132436, -0.881396, 1.156049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.356449, -0.963714, 1.273707>, <2.346110, -0.951896, 1.259891>, <2.314045, -0.968257, 1.245028>, <2.301532, -0.959074, 1.231009>, 
      <2.325131, -0.941155, 1.316439>, <2.314792, -0.929337, 1.302622>, <2.294223, -0.953978, 1.272075>, <2.281709, -0.944795, 1.258056>, 
      <2.266331, -0.956902, 1.346222>, <2.256042, -0.945140, 1.332472>, <2.252795, -0.965034, 1.292996>, <2.244492, -0.954763, 1.276907>, 
      <2.226993, -0.998376, 1.339286>, <2.216703, -0.986615, 1.325535>, <2.227895, -0.991285, 1.288606>, <2.219593, -0.981014, 1.272517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.341749, -1.081036, 1.182710>, <2.331459, -1.069274, 1.168959>, <2.304228, -1.046270, 1.184454>, <2.292227, -1.033334, 1.173411>, 
      <2.381087, -1.039562, 1.189646>, <2.370797, -1.027800, 1.175896>, <2.329128, -1.020018, 1.188844>, <2.317127, -1.007082, 1.177801>, 
      <2.387767, -0.986273, 1.230976>, <2.377428, -0.974455, 1.217159>, <2.333869, -0.982536, 1.217980>, <2.321355, -0.973353, 1.203961>, 
      <2.356449, -0.963714, 1.273707>, <2.346110, -0.951896, 1.259891>, <2.314045, -0.968257, 1.245028>, <2.301532, -0.959074, 1.231009>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.212293, -1.115698, 1.248289>, <2.202052, -1.103993, 1.234604>, <2.218091, -1.069284, 1.228035>, <2.210287, -1.055275, 1.214920>, 
      <2.243611, -1.138257, 1.205558>, <2.233371, -1.126552, 1.191872>, <2.237914, -1.083563, 1.200988>, <2.230110, -1.069554, 1.187873>, 
      <2.302411, -1.122510, 1.175774>, <2.292121, -1.110749, 1.162023>, <2.279329, -1.072521, 1.180063>, <2.267328, -1.059586, 1.169021>, 
      <2.341749, -1.081036, 1.182710>, <2.331459, -1.069274, 1.168959>, <2.304228, -1.046270, 1.184454>, <2.292227, -1.033334, 1.173411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.212293, -1.115698, 1.248289>, <2.202052, -1.103993, 1.234604>, <2.218091, -1.069284, 1.228035>, <2.210287, -1.055275, 1.214920>, 
      <2.180975, -1.093139, 1.291021>, <2.170734, -1.081434, 1.277336>, <2.198268, -1.055005, 1.255083>, <2.190464, -1.040996, 1.241968>, 
      <2.187655, -1.039850, 1.332350>, <2.177365, -1.028089, 1.318599>, <2.202996, -1.017537, 1.284216>, <2.194694, -1.007266, 1.268126>, 
      <2.226993, -0.998376, 1.339286>, <2.216703, -0.986615, 1.325535>, <2.227895, -0.991285, 1.288606>, <2.219593, -0.981014, 1.272517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.446791, -1.125107, 1.425122>, <2.416849, -1.079159, 1.378921>, <2.391897, -1.004232, 1.321077>, <2.356449, -0.963714, 1.273707>, 
      <2.426968, -1.110828, 1.452169>, <2.397026, -1.064880, 1.405968>, <2.360579, -0.981673, 1.363809>, <2.325131, -0.941155, 1.316439>, 
      <2.389750, -1.120794, 1.471021>, <2.350204, -1.077390, 1.429653>, <2.301838, -0.997486, 1.393671>, <2.266331, -0.956902, 1.346222>, 
      <2.364851, -1.147046, 1.466631>, <2.325305, -1.103641, 1.425263>, <2.262500, -1.038961, 1.386735>, <2.226993, -0.998376, 1.339286>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.437487, -1.199366, 1.367524>, <2.406441, -1.162084, 1.314558>, <2.377256, -1.121620, 1.230158>, <2.341749, -1.081036, 1.182710>, 
      <2.462386, -1.173115, 1.371914>, <2.431340, -1.135833, 1.318948>, <2.416594, -1.080146, 1.237095>, <2.381087, -1.039562, 1.189646>, 
      <2.466614, -1.139386, 1.398075>, <2.436672, -1.093438, 1.351874>, <2.423216, -1.026791, 1.278346>, <2.387767, -0.986273, 1.230976>, 
      <2.446791, -1.125107, 1.425122>, <2.416849, -1.079159, 1.378921>, <2.391897, -1.004232, 1.321077>, <2.356449, -0.963714, 1.273707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.355546, -1.221307, 1.409034>, <2.314889, -1.186574, 1.360900>, <2.247858, -1.156349, 1.295816>, <2.212293, -1.115698, 1.248289>, 
      <2.375370, -1.235586, 1.381986>, <2.334713, -1.200853, 1.333852>, <2.279176, -1.178908, 1.253084>, <2.243611, -1.138257, 1.205558>, 
      <2.412587, -1.225618, 1.363134>, <2.381541, -1.188336, 1.310168>, <2.337918, -1.163095, 1.223222>, <2.302411, -1.122510, 1.175774>, 
      <2.437487, -1.199366, 1.367524>, <2.406441, -1.162084, 1.314558>, <2.377256, -1.121620, 1.230158>, <2.341749, -1.081036, 1.182710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.355546, -1.221307, 1.409034>, <2.314889, -1.186574, 1.360900>, <2.247858, -1.156349, 1.295816>, <2.212293, -1.115698, 1.248289>, 
      <2.335723, -1.207028, 1.436082>, <2.295066, -1.172295, 1.387948>, <2.216540, -1.133790, 1.338548>, <2.180975, -1.093139, 1.291021>, 
      <2.339951, -1.173298, 1.462241>, <2.300405, -1.129893, 1.420873>, <2.223161, -1.080435, 1.379798>, <2.187655, -1.039850, 1.332350>, 
      <2.364851, -1.147046, 1.466631>, <2.325305, -1.103641, 1.425263>, <2.262500, -1.038961, 1.386735>, <2.226993, -0.998376, 1.339286>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.504896, -1.191520, 1.502767>, <2.482722, -1.177581, 1.479157>, <2.461514, -1.147701, 1.447841>, <2.446791, -1.125107, 1.425122>, 
      <2.485073, -1.177241, 1.529814>, <2.462899, -1.163302, 1.506204>, <2.441691, -1.133423, 1.474888>, <2.426968, -1.110828, 1.452169>, 
      <2.447855, -1.187208, 1.548665>, <2.434976, -1.170737, 1.520272>, <2.409164, -1.142103, 1.491330>, <2.389750, -1.120794, 1.471021>, 
      <2.422956, -1.213459, 1.544275>, <2.410076, -1.196988, 1.515881>, <2.384265, -1.168354, 1.486939>, <2.364851, -1.147046, 1.466631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.495590, -1.265778, 1.445170>, <2.474429, -1.243341, 1.428076>, <2.452728, -1.217669, 1.393526>, <2.437487, -1.199366, 1.367524>, 
      <2.520489, -1.239527, 1.449560>, <2.499329, -1.217091, 1.432466>, <2.477628, -1.191417, 1.397916>, <2.462386, -1.173115, 1.371914>, 
      <2.524719, -1.205798, 1.475720>, <2.502545, -1.191859, 1.452110>, <2.481337, -1.161980, 1.420793>, <2.466614, -1.139386, 1.398075>, 
      <2.504896, -1.191520, 1.502767>, <2.482722, -1.177581, 1.479157>, <2.461514, -1.147701, 1.447841>, <2.446791, -1.125107, 1.425122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.413650, -1.287719, 1.486678>, <2.401806, -1.262727, 1.464804>, <2.375472, -1.238330, 1.432625>, <2.355546, -1.221307, 1.409034>, 
      <2.433473, -1.301998, 1.459631>, <2.421629, -1.277006, 1.437756>, <2.395296, -1.252609, 1.405577>, <2.375370, -1.235586, 1.381986>, 
      <2.470690, -1.292029, 1.440780>, <2.449530, -1.269593, 1.423685>, <2.427828, -1.243921, 1.389136>, <2.412587, -1.225618, 1.363134>, 
      <2.495590, -1.265778, 1.445170>, <2.474429, -1.243341, 1.428076>, <2.452728, -1.217669, 1.393526>, <2.437487, -1.199366, 1.367524>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.413650, -1.287719, 1.486678>, <2.401806, -1.262727, 1.464804>, <2.375472, -1.238330, 1.432625>, <2.355546, -1.221307, 1.409034>, 
      <2.393827, -1.273440, 1.513726>, <2.381983, -1.248448, 1.491851>, <2.355649, -1.224051, 1.459673>, <2.335723, -1.207028, 1.436082>, 
      <2.398056, -1.239710, 1.539885>, <2.385177, -1.223239, 1.511491>, <2.359365, -1.194606, 1.482549>, <2.339951, -1.173298, 1.462241>, 
      <2.422956, -1.213459, 1.544275>, <2.410076, -1.196988, 1.515881>, <2.384265, -1.168354, 1.486939>, <2.364851, -1.147046, 1.466631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.559812, -1.196157, 1.545465>, <2.549473, -1.184339, 1.531649>, <2.518048, -1.199788, 1.516771>, <2.504896, -1.191520, 1.502767>, 
      <2.528494, -1.173598, 1.588196>, <2.518155, -1.161781, 1.574380>, <2.498225, -1.185509, 1.543818>, <2.485073, -1.177241, 1.529814>, 
      <2.469695, -1.189346, 1.617979>, <2.459405, -1.177585, 1.604228>, <2.455458, -1.196931, 1.565426>, <2.447855, -1.187208, 1.548665>, 
      <2.430357, -1.230820, 1.611043>, <2.420067, -1.219059, 1.597293>, <2.430559, -1.223182, 1.561036>, <2.422956, -1.213459, 1.544275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.545112, -1.313480, 1.454468>, <2.534822, -1.301719, 1.440718>, <2.508081, -1.279023, 1.455261>, <2.495590, -1.265778, 1.445170>, 
      <2.584450, -1.272005, 1.461404>, <2.574160, -1.260244, 1.447653>, <2.532981, -1.252772, 1.459652>, <2.520489, -1.239527, 1.449560>, 
      <2.591130, -1.218716, 1.502733>, <2.580791, -1.206899, 1.488917>, <2.537871, -1.214066, 1.489724>, <2.524719, -1.205798, 1.475720>, 
      <2.559812, -1.196157, 1.545465>, <2.549473, -1.184339, 1.531649>, <2.518048, -1.199788, 1.516771>, <2.504896, -1.191520, 1.502767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.415656, -1.348142, 1.520048>, <2.405415, -1.336437, 1.506363>, <2.420609, -1.302402, 1.499529>, <2.413650, -1.287719, 1.486678>, 
      <2.446975, -1.370701, 1.477316>, <2.436734, -1.358996, 1.463632>, <2.440432, -1.316681, 1.472482>, <2.433473, -1.301998, 1.459631>, 
      <2.505774, -1.354955, 1.447532>, <2.495484, -1.343193, 1.433782>, <2.483182, -1.305274, 1.450871>, <2.470690, -1.292029, 1.440780>, 
      <2.545112, -1.313480, 1.454468>, <2.534822, -1.301719, 1.440718>, <2.508081, -1.279023, 1.455261>, <2.495590, -1.265778, 1.445170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.415656, -1.348142, 1.520048>, <2.405415, -1.336437, 1.506363>, <2.420609, -1.302402, 1.499529>, <2.413650, -1.287719, 1.486678>, 
      <2.384338, -1.325583, 1.562779>, <2.374097, -1.313878, 1.549094>, <2.400785, -1.288123, 1.526577>, <2.393827, -1.273440, 1.513726>, 
      <2.391019, -1.272294, 1.604107>, <2.380729, -1.260533, 1.590357>, <2.405659, -1.249433, 1.556645>, <2.398056, -1.239710, 1.539885>, 
      <2.430357, -1.230820, 1.611043>, <2.420067, -1.219059, 1.597293>, <2.430559, -1.223182, 1.561036>, <2.422956, -1.213459, 1.544275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.621102, -1.324345, 1.658057>, <2.599252, -1.288731, 1.623242>, <2.586697, -1.226887, 1.581392>, <2.559812, -1.196157, 1.545465>, 
      <2.601279, -1.310066, 1.685104>, <2.579429, -1.274452, 1.650289>, <2.555379, -1.204328, 1.624124>, <2.528494, -1.173598, 1.588196>, 
      <2.564062, -1.320032, 1.703957>, <2.533491, -1.286720, 1.673521>, <2.496638, -1.220142, 1.653984>, <2.469695, -1.189346, 1.617979>, 
      <2.539163, -1.346284, 1.699567>, <2.508592, -1.312971, 1.669131>, <2.457300, -1.261616, 1.647048>, <2.430357, -1.230820, 1.611043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.611798, -1.398604, 1.600461>, <2.588942, -1.370848, 1.559500>, <2.572055, -1.344276, 1.490473>, <2.545112, -1.313480, 1.454468>, 
      <2.636697, -1.372353, 1.604851>, <2.613840, -1.344597, 1.563889>, <2.611393, -1.302801, 1.497408>, <2.584450, -1.272005, 1.461404>, 
      <2.640925, -1.338624, 1.631010>, <2.619074, -1.303010, 1.596195>, <2.618016, -1.249446, 1.538661>, <2.591130, -1.218716, 1.502733>, 
      <2.621102, -1.324345, 1.658057>, <2.599252, -1.288731, 1.623242>, <2.586697, -1.226887, 1.581392>, <2.559812, -1.196157, 1.545465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.529858, -1.420546, 1.641970>, <2.498273, -1.395100, 1.605387>, <2.442657, -1.379004, 1.556130>, <2.415656, -1.348142, 1.520048>, 
      <2.549681, -1.434825, 1.614923>, <2.518096, -1.409379, 1.578340>, <2.473975, -1.401563, 1.513399>, <2.446975, -1.370701, 1.477316>, 
      <2.586899, -1.424856, 1.596071>, <2.564042, -1.397101, 1.555110>, <2.532717, -1.385751, 1.483537>, <2.505774, -1.354955, 1.447532>, 
      <2.611798, -1.398604, 1.600461>, <2.588942, -1.370848, 1.559500>, <2.572055, -1.344276, 1.490473>, <2.545112, -1.313480, 1.454468>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.529858, -1.420546, 1.641970>, <2.498273, -1.395100, 1.605387>, <2.442657, -1.379004, 1.556130>, <2.415656, -1.348142, 1.520048>, 
      <2.510035, -1.406267, 1.669018>, <2.478449, -1.380821, 1.632435>, <2.411339, -1.356445, 1.598861>, <2.384338, -1.325583, 1.562779>, 
      <2.514264, -1.372536, 1.695177>, <2.483693, -1.339223, 1.664742>, <2.417962, -1.303090, 1.640112>, <2.391019, -1.272294, 1.604107>, 
      <2.539163, -1.346284, 1.699567>, <2.508592, -1.312971, 1.669131>, <2.457300, -1.261616, 1.647048>, <2.430357, -1.230820, 1.611043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.679207, -1.390757, 1.735702>, <2.657034, -1.376818, 1.712092>, <2.635269, -1.347435, 1.680630>, <2.621102, -1.324345, 1.658057>, 
      <2.659383, -1.376478, 1.762750>, <2.637210, -1.362539, 1.739140>, <2.615446, -1.333157, 1.707677>, <2.601279, -1.310066, 1.685104>, 
      <2.622165, -1.386446, 1.781602>, <2.609286, -1.369974, 1.753209>, <2.583840, -1.341584, 1.723647>, <2.564062, -1.320032, 1.703957>, 
      <2.597265, -1.412698, 1.777212>, <2.584386, -1.396226, 1.748818>, <2.558941, -1.367836, 1.719258>, <2.539163, -1.346284, 1.699567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.669902, -1.465017, 1.678106>, <2.648741, -1.442580, 1.661012>, <2.626585, -1.416561, 1.626962>, <2.611798, -1.398604, 1.600461>, 
      <2.694801, -1.438765, 1.682496>, <2.673640, -1.416329, 1.665402>, <2.651484, -1.390310, 1.631352>, <2.636697, -1.372353, 1.604851>, 
      <2.699030, -1.405035, 1.708655>, <2.676857, -1.391096, 1.685045>, <2.655092, -1.361714, 1.653583>, <2.640925, -1.338624, 1.631010>, 
      <2.679207, -1.390757, 1.735702>, <2.657034, -1.376818, 1.712092>, <2.635269, -1.347435, 1.680630>, <2.621102, -1.324345, 1.658057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.587962, -1.486957, 1.719614>, <2.576118, -1.461965, 1.697740>, <2.550249, -1.436973, 1.665586>, <2.529858, -1.420546, 1.641970>, 
      <2.607785, -1.501235, 1.692567>, <2.595942, -1.476243, 1.670693>, <2.570072, -1.451252, 1.638539>, <2.549681, -1.434825, 1.614923>, 
      <2.645003, -1.491268, 1.673716>, <2.623842, -1.468832, 1.656622>, <2.601686, -1.442813, 1.622572>, <2.586899, -1.424856, 1.596071>, 
      <2.669902, -1.465017, 1.678106>, <2.648741, -1.442580, 1.661012>, <2.626585, -1.416561, 1.626962>, <2.611798, -1.398604, 1.600461>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.587962, -1.486957, 1.719614>, <2.576118, -1.461965, 1.697740>, <2.550249, -1.436973, 1.665586>, <2.529858, -1.420546, 1.641970>, 
      <2.568138, -1.472679, 1.746661>, <2.556294, -1.447687, 1.724787>, <2.530425, -1.422694, 1.692634>, <2.510035, -1.406267, 1.669018>, 
      <2.572366, -1.438950, 1.772822>, <2.559487, -1.422478, 1.744428>, <2.534042, -1.394088, 1.714868>, <2.514264, -1.372536, 1.695177>, 
      <2.597265, -1.412698, 1.777212>, <2.584386, -1.396226, 1.748818>, <2.558941, -1.367836, 1.719258>, <2.539163, -1.346284, 1.699567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.734123, -1.395397, 1.778401>, <2.723784, -1.383579, 1.764585>, <2.692359, -1.399025, 1.749706>, <2.679207, -1.390757, 1.735702>, 
      <2.702804, -1.372839, 1.821133>, <2.692465, -1.361021, 1.807316>, <2.672535, -1.384746, 1.776754>, <2.659383, -1.376478, 1.762750>, 
      <2.644005, -1.388586, 1.850916>, <2.633715, -1.376824, 1.837166>, <2.629768, -1.396169, 1.798363>, <2.622165, -1.386446, 1.781602>, 
      <2.604667, -1.430060, 1.843980>, <2.594377, -1.418299, 1.830230>, <2.604868, -1.422421, 1.793973>, <2.597265, -1.412698, 1.777212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.719424, -1.512718, 1.687403>, <2.709134, -1.500957, 1.673653>, <2.682394, -1.478261, 1.688197>, <2.669902, -1.465017, 1.678106>, 
      <2.758762, -1.471244, 1.694339>, <2.748472, -1.459482, 1.680589>, <2.707293, -1.452010, 1.692587>, <2.694801, -1.438765, 1.682496>, 
      <2.765441, -1.417955, 1.735669>, <2.755102, -1.406138, 1.721853>, <2.712182, -1.413304, 1.722659>, <2.699030, -1.405035, 1.708655>, 
      <2.734123, -1.395397, 1.778401>, <2.723784, -1.383579, 1.764585>, <2.692359, -1.399025, 1.749706>, <2.679207, -1.390757, 1.735702>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.589966, -1.547382, 1.752982>, <2.579725, -1.535677, 1.739297>, <2.594920, -1.501640, 1.732465>, <2.587962, -1.486957, 1.719614>, 
      <2.621285, -1.569941, 1.710250>, <2.611044, -1.558235, 1.696565>, <2.614744, -1.515919, 1.705418>, <2.607785, -1.501235, 1.692567>, 
      <2.680085, -1.554193, 1.680466>, <2.669795, -1.542432, 1.666716>, <2.657494, -1.504513, 1.683807>, <2.645003, -1.491268, 1.673716>, 
      <2.719424, -1.512718, 1.687403>, <2.709134, -1.500957, 1.673653>, <2.682394, -1.478261, 1.688197>, <2.669902, -1.465017, 1.678106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.589966, -1.547382, 1.752982>, <2.579725, -1.535677, 1.739297>, <2.594920, -1.501640, 1.732465>, <2.587962, -1.486957, 1.719614>, 
      <2.558647, -1.524824, 1.795714>, <2.548406, -1.513118, 1.782029>, <2.575097, -1.487362, 1.759513>, <2.568138, -1.472679, 1.746661>, 
      <2.565329, -1.471535, 1.837044>, <2.555039, -1.459773, 1.823293>, <2.579968, -1.448673, 1.789583>, <2.572366, -1.438950, 1.772822>, 
      <2.604667, -1.430060, 1.843980>, <2.594377, -1.418299, 1.830230>, <2.604868, -1.422421, 1.793973>, <2.597265, -1.412698, 1.777212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.795413, -1.523583, 1.890993>, <2.771724, -1.489642, 1.855713>, <2.761008, -1.426127, 1.814328>, <2.734123, -1.395397, 1.778401>, 
      <2.775590, -1.509304, 1.918040>, <2.751901, -1.475363, 1.882760>, <2.729689, -1.403568, 1.857060>, <2.702804, -1.372839, 1.821133>, 
      <2.738373, -1.519271, 1.936892>, <2.705731, -1.484633, 1.910336>, <2.670948, -1.419381, 1.886921>, <2.644005, -1.388586, 1.850916>, 
      <2.713474, -1.545523, 1.932502>, <2.680832, -1.510884, 1.905945>, <2.631610, -1.460856, 1.879984>, <2.604667, -1.430060, 1.843980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.795413, -1.523583, 1.890993>, <2.832240, -1.576348, 1.945840>, <2.902466, -1.625995, 2.023520>, <2.934732, -1.682823, 2.077168>, 
      <2.775590, -1.509304, 1.918040>, <2.812417, -1.562069, 1.972887>, <2.882643, -1.611717, 2.050567>, <2.914909, -1.668544, 2.104215>, 
      <2.738373, -1.519271, 1.936892>, <2.780168, -1.567044, 1.992744>, <2.835896, -1.630740, 2.067214>, <2.877691, -1.678513, 2.123067>, 
      <2.713474, -1.545523, 1.932502>, <2.755270, -1.593295, 1.988354>, <2.810997, -1.656992, 2.062824>, <2.852792, -1.704764, 2.118676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.786110, -1.597843, 1.833396>, <2.766104, -1.572306, 1.789598>, <2.746367, -1.543514, 1.723407>, <2.719424, -1.512718, 1.687403>, 
      <2.811009, -1.571591, 1.837786>, <2.791003, -1.546054, 1.793988>, <2.785705, -1.502040, 1.730344>, <2.758762, -1.471244, 1.694339>, 
      <2.815236, -1.537862, 1.863946>, <2.791547, -1.503921, 1.828665>, <2.792326, -1.448685, 1.771596>, <2.765441, -1.417955, 1.735669>, 
      <2.795413, -1.523583, 1.890993>, <2.771724, -1.489642, 1.855713>, <2.761008, -1.426127, 1.814328>, <2.734123, -1.395397, 1.778401>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.786110, -1.597843, 1.833396>, <2.827905, -1.645615, 1.889248>, <2.883632, -1.709312, 1.963718>, <2.925428, -1.757084, 2.019570>, 
      <2.811009, -1.571591, 1.837786>, <2.852804, -1.619363, 1.893638>, <2.908532, -1.683060, 1.968109>, <2.950328, -1.730832, 2.023961>, 
      <2.815236, -1.537862, 1.863946>, <2.852063, -1.590627, 1.918792>, <2.922290, -1.640274, 1.996473>, <2.954556, -1.697102, 2.050120>, 
      <2.795413, -1.523583, 1.890993>, <2.832240, -1.576348, 1.945840>, <2.902466, -1.625995, 2.023520>, <2.934732, -1.682823, 2.077168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.786110, -1.597843, 1.833396>, <2.811009, -1.571591, 1.837786>, <2.815236, -1.537862, 1.863946>, <2.795413, -1.523583, 1.890993>, 
      <2.786110, -1.597843, 1.833396>, <2.789218, -1.555895, 1.867518>, <2.795413, -1.523583, 1.890993>, <2.775590, -1.509304, 1.918040>, 
      <2.786110, -1.597843, 1.833396>, <2.789218, -1.555895, 1.867518>, <2.760164, -1.534967, 1.907160>, <2.738373, -1.519271, 1.936892>, 
      <2.786110, -1.597843, 1.833396>, <2.764319, -1.582147, 1.863128>, <2.735265, -1.561219, 1.902770>, <2.713474, -1.545523, 1.932502>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.704171, -1.619783, 1.874905>, <2.674156, -1.592359, 1.838429>, <2.616967, -1.578244, 1.789064>, <2.589966, -1.547382, 1.752982>, 
      <2.723994, -1.634062, 1.847858>, <2.693979, -1.606637, 1.811382>, <2.648286, -1.600803, 1.746332>, <2.621285, -1.569941, 1.710250>, 
      <2.761211, -1.624095, 1.829006>, <2.741205, -1.598557, 1.785208>, <2.707028, -1.584989, 1.716471>, <2.680085, -1.554193, 1.680466>, 
      <2.786110, -1.597843, 1.833396>, <2.766104, -1.572306, 1.789598>, <2.746367, -1.543514, 1.723407>, <2.719424, -1.512718, 1.687403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.704171, -1.619783, 1.874905>, <2.750631, -1.662233, 1.931366>, <2.792971, -1.741807, 2.004408>, <2.843487, -1.779023, 2.061078>, 
      <2.723994, -1.634062, 1.847858>, <2.770454, -1.676512, 1.904319>, <2.812794, -1.756086, 1.977360>, <2.863310, -1.793302, 2.034031>, 
      <2.761211, -1.624095, 1.829006>, <2.803007, -1.671867, 1.884858>, <2.858733, -1.735563, 1.959327>, <2.900528, -1.783336, 2.015179>, 
      <2.786110, -1.597843, 1.833396>, <2.827905, -1.645615, 1.889248>, <2.883632, -1.709312, 1.963718>, <2.925428, -1.757084, 2.019570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.704171, -1.619783, 1.874905>, <2.674156, -1.592359, 1.838429>, <2.616967, -1.578244, 1.789064>, <2.589966, -1.547382, 1.752982>, 
      <2.684348, -1.605504, 1.901952>, <2.654333, -1.578080, 1.865476>, <2.585649, -1.555686, 1.831796>, <2.558647, -1.524824, 1.795714>, 
      <2.688575, -1.571775, 1.928112>, <2.655933, -1.537136, 1.901555>, <2.592272, -1.502330, 1.873048>, <2.565329, -1.471535, 1.837044>, 
      <2.713474, -1.545523, 1.932502>, <2.680832, -1.510884, 1.905945>, <2.631610, -1.460856, 1.879984>, <2.604667, -1.430060, 1.843980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.704171, -1.619783, 1.874905>, <2.723994, -1.634062, 1.847858>, <2.761211, -1.624095, 1.829006>, <2.786110, -1.597843, 1.833396>, 
      <2.704171, -1.619783, 1.874905>, <2.704171, -1.619783, 1.874905>, <2.739420, -1.608399, 1.858738>, <2.764319, -1.582147, 1.863128>, 
      <2.704171, -1.619783, 1.874905>, <2.704171, -1.619783, 1.874905>, <2.710366, -1.587471, 1.898380>, <2.735265, -1.561219, 1.902770>, 
      <2.704171, -1.619783, 1.874905>, <2.684348, -1.605504, 1.901952>, <2.688575, -1.571775, 1.928112>, <2.713474, -1.545523, 1.932502>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.704171, -1.619783, 1.874905>, <2.684348, -1.605504, 1.901952>, <2.688575, -1.571775, 1.928112>, <2.713474, -1.545523, 1.932502>, 
      <2.750631, -1.662233, 1.931366>, <2.730808, -1.647955, 1.958413>, <2.730371, -1.619547, 1.983964>, <2.755270, -1.593295, 1.988354>, 
      <2.792971, -1.741807, 2.004408>, <2.773148, -1.727529, 2.031455>, <2.786097, -1.683243, 2.058433>, <2.810997, -1.656992, 2.062824>, 
      <2.843487, -1.779023, 2.061078>, <2.823664, -1.764744, 2.088125>, <2.827893, -1.731015, 2.114285>, <2.852792, -1.704764, 2.118676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.836950, 1.457496, 2.107037>, <2.871651, 1.443329, 2.092885>, <2.917920, 1.424440, 2.074014>, <2.952621, 1.410273, 2.059862>, 
      <2.836950, 1.457496, 2.107037>, <2.870646, 1.416376, 2.117399>, <2.916914, 1.397487, 2.098528>, <2.951615, 1.383320, 2.084376>, 
      <2.836950, 1.457496, 2.107037>, <2.870646, 1.416376, 2.117399>, <2.892944, 1.384499, 2.128366>, <2.924512, 1.371611, 2.115491>, 
      <2.836950, 1.457496, 2.107037>, <2.835944, 1.430543, 2.131552>, <2.861376, 1.397387, 2.141241>, <2.892944, 1.384499, 2.128366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.896629, 1.483269, 2.038533>, <2.928197, 1.470381, 2.025658>, <2.953627, 1.437226, 2.035348>, <2.952621, 1.410273, 2.059862>, 
      <2.896629, 1.483269, 2.038533>, <2.896629, 1.483269, 2.038533>, <2.918925, 1.451393, 2.049501>, <2.917920, 1.424440, 2.074014>, 
      <2.896629, 1.483269, 2.038533>, <2.896629, 1.483269, 2.038533>, <2.872657, 1.470282, 2.068370>, <2.871651, 1.443329, 2.092885>, 
      <2.896629, 1.483269, 2.038533>, <2.865061, 1.496157, 2.051408>, <2.837956, 1.484449, 2.082523>, <2.836950, 1.457496, 2.107037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.960403, 1.507468, 2.170681>, <2.960403, 1.507468, 2.170681>, <2.960403, 1.507468, 2.170681>, <2.960403, 1.507468, 2.170681>, 
      <2.940165, 1.470577, 2.157986>, <2.940165, 1.470577, 2.157986>, <2.958068, 1.478309, 2.137435>, <2.958068, 1.478309, 2.137435>, 
      <2.914818, 1.414177, 2.152291>, <2.946386, 1.401290, 2.139416>, <2.953950, 1.412479, 2.117622>, <2.954956, 1.439431, 2.093108>, 
      <2.892944, 1.384499, 2.128366>, <2.924512, 1.371611, 2.115491>, <2.951615, 1.383320, 2.084376>, <2.952621, 1.410273, 2.059862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.960403, 1.507468, 2.170681>, <2.960403, 1.507468, 2.170681>, <2.960403, 1.507468, 2.170681>, <2.960403, 1.507468, 2.170681>, 
      <2.923367, 1.492476, 2.151588>, <2.923367, 1.492476, 2.151588>, <2.940165, 1.470577, 2.157986>, <2.940165, 1.470577, 2.157986>, 
      <2.873986, 1.472488, 2.126130>, <2.872980, 1.445534, 2.150645>, <2.883249, 1.427065, 2.165166>, <2.914818, 1.414177, 2.152291>, 
      <2.836950, 1.457496, 2.107037>, <2.835944, 1.430543, 2.131552>, <2.861376, 1.397387, 2.141241>, <2.892944, 1.384499, 2.128366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.960403, 1.507468, 2.170681>, <2.960403, 1.507468, 2.170681>, <2.960403, 1.507468, 2.170681>, <2.960403, 1.507468, 2.170681>, 
      <2.941271, 1.500208, 2.131037>, <2.941271, 1.500208, 2.131037>, <2.923367, 1.492476, 2.151588>, <2.923367, 1.492476, 2.151588>, 
      <2.918351, 1.502773, 2.072270>, <2.886783, 1.515661, 2.085145>, <2.874992, 1.499441, 2.101616>, <2.873986, 1.472488, 2.126130>, 
      <2.896629, 1.483269, 2.038533>, <2.865061, 1.496157, 2.051408>, <2.837956, 1.484449, 2.082523>, <2.836950, 1.457496, 2.107037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.960403, 1.507468, 2.170681>, <2.941271, 1.500208, 2.131037>, <2.918351, 1.502773, 2.072270>, <2.896629, 1.483269, 2.038533>, 
      <2.960403, 1.507468, 2.170681>, <2.941271, 1.500208, 2.131037>, <2.949919, 1.489885, 2.059395>, <2.928197, 1.470381, 2.025658>, 
      <2.960403, 1.507468, 2.170681>, <2.958068, 1.478309, 2.137435>, <2.955961, 1.466384, 2.068594>, <2.953627, 1.437226, 2.035348>, 
      <2.960403, 1.507468, 2.170681>, <2.958068, 1.478309, 2.137435>, <2.954956, 1.439431, 2.093108>, <2.952621, 1.410273, 2.059862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.076785, 0.422451, 1.090211>, <2.103600, 0.464002, 1.114365>, <2.138754, 0.524137, 1.140364>, <2.166168, 0.560956, 1.170726>, 
      <2.133197, 0.399421, 1.067204>, <2.160012, 0.440972, 1.091358>, <2.170322, 0.511249, 1.127490>, <2.197736, 0.548068, 1.157851>, 
      <2.181631, 0.420343, 1.011601>, <2.194356, 0.455810, 1.051930>, <2.204661, 0.526049, 1.087988>, <2.224840, 0.559777, 1.126737>, 
      <2.183428, 0.468507, 0.967795>, <2.196153, 0.503974, 1.008123>, <2.205666, 0.553002, 1.063475>, <2.225846, 0.586730, 1.102223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.976726, 0.552895, 1.052097>, <2.016761, 0.577212, 1.081287>, <2.075902, 0.605979, 1.116397>, <2.110175, 0.633953, 1.149398>, 
      <1.974929, 0.504730, 1.095903>, <2.014964, 0.529048, 1.125094>, <2.074897, 0.579025, 1.140911>, <2.109169, 0.607000, 1.173912>, 
      <2.020373, 0.445482, 1.113218>, <2.047188, 0.487033, 1.137373>, <2.107186, 0.537025, 1.153239>, <2.134600, 0.573844, 1.183601>, 
      <2.076785, 0.422451, 1.090211>, <2.103600, 0.464002, 1.114365>, <2.138754, 0.524137, 1.140364>, <2.166168, 0.560956, 1.170726>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.083371, 0.598951, 0.929681>, <2.109316, 0.617184, 0.975045>, <2.142816, 0.634860, 1.039493>, <2.169853, 0.659727, 1.080895>, 
      <2.026959, 0.621982, 0.952688>, <2.052904, 0.640215, 0.998052>, <2.111248, 0.647748, 1.052368>, <2.138285, 0.672615, 1.093770>, 
      <1.978523, 0.601059, 1.008291>, <2.018558, 0.625377, 1.037481>, <2.076908, 0.632932, 1.091884>, <2.111181, 0.660906, 1.124885>, 
      <1.976726, 0.552895, 1.052097>, <2.016761, 0.577212, 1.081287>, <2.075902, 0.605979, 1.116397>, <2.110175, 0.633953, 1.149398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.083371, 0.598951, 0.929681>, <2.139782, 0.575920, 0.906674>, <2.185225, 0.516671, 0.923989>, <2.183428, 0.468507, 0.967795>, 
      <2.109316, 0.617184, 0.975045>, <2.165727, 0.594153, 0.952038>, <2.197951, 0.552138, 0.964317>, <2.196153, 0.503974, 1.008123>, 
      <2.142816, 0.634860, 1.039493>, <2.174384, 0.621972, 1.026619>, <2.206672, 0.579956, 1.038961>, <2.205666, 0.553002, 1.063475>, 
      <2.169853, 0.659727, 1.080895>, <2.201421, 0.646839, 1.068020>, <2.226852, 0.613683, 1.077709>, <2.225846, 0.586730, 1.102223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.254099, 0.660597, 1.286591>, <2.228355, 0.637534, 1.246554>, <2.192514, 0.596341, 1.199905>, <2.166168, 0.560956, 1.170726>, 
      <2.285667, 0.647709, 1.273716>, <2.259923, 0.624646, 1.233679>, <2.224082, 0.583453, 1.187031>, <2.197736, 0.548068, 1.157851>, 
      <2.312772, 0.659417, 1.242601>, <2.279264, 0.632982, 1.211361>, <2.244179, 0.592099, 1.163870>, <2.224840, 0.559777, 1.126737>, 
      <2.313778, 0.686370, 1.218087>, <2.280270, 0.659934, 1.186846>, <2.245185, 0.619052, 1.139357>, <2.225846, 0.586730, 1.102223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.198107, 0.733593, 1.265262>, <2.179564, 0.701048, 1.227918>, <2.143019, 0.660762, 1.181024>, <2.110175, 0.633953, 1.149398>, 
      <2.197101, 0.706641, 1.289776>, <2.178559, 0.674095, 1.252432>, <2.142014, 0.633808, 1.205537>, <2.109169, 0.607000, 1.173912>, 
      <2.222531, 0.673485, 1.299466>, <2.196787, 0.650421, 1.259429>, <2.160946, 0.609229, 1.212780>, <2.134600, 0.573844, 1.183601>, 
      <2.254099, 0.660597, 1.286591>, <2.228355, 0.637534, 1.246554>, <2.192514, 0.596341, 1.199905>, <2.166168, 0.560956, 1.170726>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.257785, 0.759366, 1.196757>, <2.231478, 0.723427, 1.168229>, <2.195690, 0.683490, 1.120459>, <2.169853, 0.659727, 1.080895>, 
      <2.226217, 0.772254, 1.209632>, <2.199909, 0.736315, 1.181104>, <2.164122, 0.696378, 1.133333>, <2.138285, 0.672615, 1.093770>, 
      <2.199113, 0.760546, 1.240748>, <2.180570, 0.728000, 1.203404>, <2.144025, 0.687715, 1.156510>, <2.111181, 0.660906, 1.124885>, 
      <2.198107, 0.733593, 1.265262>, <2.179564, 0.701048, 1.227918>, <2.143019, 0.660762, 1.181024>, <2.110175, 0.633953, 1.149398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.257785, 0.759366, 1.196757>, <2.231478, 0.723427, 1.168229>, <2.195690, 0.683490, 1.120459>, <2.169853, 0.659727, 1.080895>, 
      <2.289353, 0.746478, 1.183882>, <2.263046, 0.710539, 1.155354>, <2.227258, 0.670603, 1.107584>, <2.201421, 0.646839, 1.068020>, 
      <2.314784, 0.713323, 1.193573>, <2.281276, 0.686887, 1.162332>, <2.246191, 0.646006, 1.114843>, <2.226852, 0.613683, 1.077709>, 
      <2.313778, 0.686370, 1.218087>, <2.280270, 0.659934, 1.186846>, <2.245185, 0.619052, 1.139357>, <2.225846, 0.586730, 1.102223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.281746, 0.664499, 1.350473>, <2.271315, 0.652679, 1.336728>, <2.264279, 0.669717, 1.302423>, <2.254099, 0.660597, 1.286591>, 
      <2.331620, 0.644138, 1.330133>, <2.321188, 0.632318, 1.316388>, <2.295847, 0.656829, 1.289548>, <2.285667, 0.647709, 1.273716>, 
      <2.374442, 0.662635, 1.280975>, <2.364060, 0.650871, 1.267296>, <2.325959, 0.669821, 1.254896>, <2.312772, 0.659417, 1.242601>, 
      <2.376031, 0.705217, 1.242246>, <2.365649, 0.693453, 1.228567>, <2.326965, 0.696774, 1.230382>, <2.313778, 0.686370, 1.218087>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.193284, 0.779824, 1.316777>, <2.182902, 0.768060, 1.303098>, <2.205404, 0.746401, 1.279959>, <2.198107, 0.733593, 1.265262>, 
      <2.191695, 0.737242, 1.355506>, <2.181313, 0.725478, 1.341827>, <2.204398, 0.719449, 1.304473>, <2.197101, 0.706641, 1.289776>, 
      <2.231872, 0.684860, 1.370813>, <2.221441, 0.673040, 1.357069>, <2.232711, 0.682605, 1.315298>, <2.222531, 0.673485, 1.299466>, 
      <2.281746, 0.664499, 1.350473>, <2.271315, 0.652679, 1.336728>, <2.264279, 0.669717, 1.302423>, <2.254099, 0.660597, 1.286591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.287569, 0.820542, 1.208549>, <2.277237, 0.808834, 1.194935>, <2.268089, 0.773443, 1.207931>, <2.257785, 0.759366, 1.196757>, 
      <2.237695, 0.840903, 1.228890>, <2.227363, 0.829195, 1.215275>, <2.236521, 0.786331, 1.220806>, <2.226217, 0.772254, 1.209632>, 
      <2.194873, 0.822406, 1.278048>, <2.184491, 0.810642, 1.264368>, <2.206410, 0.773354, 1.255444>, <2.199113, 0.760546, 1.240748>, 
      <2.193284, 0.779824, 1.316777>, <2.182902, 0.768060, 1.303098>, <2.205404, 0.746401, 1.279959>, <2.198107, 0.733593, 1.265262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.287569, 0.820542, 1.208549>, <2.277237, 0.808834, 1.194935>, <2.268089, 0.773443, 1.207931>, <2.257785, 0.759366, 1.196757>, 
      <2.337443, 0.800181, 1.188209>, <2.327111, 0.788473, 1.174594>, <2.299657, 0.760555, 1.195056>, <2.289353, 0.746478, 1.183882>, 
      <2.377620, 0.747799, 1.203517>, <2.367239, 0.736035, 1.189838>, <2.327971, 0.723726, 1.205867>, <2.314784, 0.713323, 1.193573>, 
      <2.376031, 0.705217, 1.242246>, <2.365649, 0.693453, 1.228567>, <2.326965, 0.696774, 1.230382>, <2.313778, 0.686370, 1.218087>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.400653, 0.826665, 1.479699>, <2.364845, 0.780558, 1.438055>, <2.317510, 0.705025, 1.397598>, <2.281746, 0.664499, 1.350473>, 
      <2.432221, 0.813777, 1.466825>, <2.396414, 0.767671, 1.425180>, <2.367384, 0.684664, 1.377258>, <2.331620, 0.644138, 1.330133>, 
      <2.459325, 0.825485, 1.435709>, <2.430483, 0.782370, 1.386026>, <2.410265, 0.703228, 1.328178>, <2.374442, 0.662635, 1.280975>, 
      <2.460331, 0.852438, 1.411195>, <2.431489, 0.809323, 1.361512>, <2.411854, 0.745810, 1.289449>, <2.376031, 0.705217, 1.242246>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.344661, 0.899660, 1.458369>, <2.302282, 0.862071, 1.414207>, <2.229107, 0.820417, 1.363979>, <2.193284, 0.779824, 1.316777>, 
      <2.343655, 0.872708, 1.482883>, <2.301276, 0.835119, 1.438721>, <2.227518, 0.777835, 1.402709>, <2.191695, 0.737242, 1.355506>, 
      <2.369085, 0.839553, 1.492574>, <2.333277, 0.793446, 1.450929>, <2.267636, 0.725387, 1.417939>, <2.231872, 0.684860, 1.370813>, 
      <2.400653, 0.826665, 1.479699>, <2.364845, 0.780558, 1.438055>, <2.317510, 0.705025, 1.397598>, <2.281746, 0.664499, 1.350473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.404339, 0.925434, 1.389865>, <2.368925, 0.890843, 1.337659>, <2.323451, 0.861202, 1.255829>, <2.287569, 0.820542, 1.208549>, 
      <2.372771, 0.938322, 1.402740>, <2.337357, 0.903730, 1.350534>, <2.273577, 0.881563, 1.276170>, <2.237695, 0.840903, 1.228890>, 
      <2.345667, 0.926613, 1.433855>, <2.303288, 0.889024, 1.389693>, <2.230696, 0.862999, 1.325250>, <2.194873, 0.822406, 1.278048>, 
      <2.344661, 0.899660, 1.458369>, <2.302282, 0.862071, 1.414207>, <2.229107, 0.820417, 1.363979>, <2.193284, 0.779824, 1.316777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.404339, 0.925434, 1.389865>, <2.368925, 0.890843, 1.337659>, <2.323451, 0.861202, 1.255829>, <2.287569, 0.820542, 1.208549>, 
      <2.435907, 0.912546, 1.376991>, <2.400493, 0.877955, 1.324784>, <2.373325, 0.840841, 1.235489>, <2.337443, 0.800181, 1.188209>, 
      <2.461337, 0.879390, 1.386681>, <2.432494, 0.836275, 1.336998>, <2.413443, 0.788392, 1.250720>, <2.377620, 0.747799, 1.203517>, 
      <2.460331, 0.852438, 1.411195>, <2.431489, 0.809323, 1.361512>, <2.411854, 0.745810, 1.289449>, <2.376031, 0.705217, 1.242246>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.459276, 0.893091, 1.556942>, <2.442351, 0.879294, 1.529255>, <2.418261, 0.849337, 1.500177>, <2.400653, 0.826665, 1.479699>, 
      <2.490844, 0.880203, 1.544067>, <2.473919, 0.866406, 1.516380>, <2.449829, 0.836449, 1.487302>, <2.432221, 0.813777, 1.466825>, 
      <2.517947, 0.891912, 1.512952>, <2.494182, 0.875146, 1.493015>, <2.473485, 0.846652, 1.460100>, <2.459325, 0.825485, 1.435709>, 
      <2.518953, 0.918864, 1.488438>, <2.495187, 0.902098, 1.468501>, <2.474490, 0.873604, 1.435586>, <2.460331, 0.852438, 1.411195>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.403282, 0.966087, 1.535613>, <2.392704, 0.943937, 1.510297>, <2.365466, 0.918113, 1.480049>, <2.344661, 0.899660, 1.458369>, 
      <2.402276, 0.939134, 1.560127>, <2.391699, 0.916984, 1.534812>, <2.364460, 0.891161, 1.504563>, <2.343655, 0.872708, 1.482883>, 
      <2.427708, 0.905979, 1.569817>, <2.410783, 0.892182, 1.542129>, <2.386693, 0.862225, 1.513051>, <2.369085, 0.839553, 1.492574>, 
      <2.459276, 0.893091, 1.556942>, <2.442351, 0.879294, 1.529255>, <2.418261, 0.849337, 1.500177>, <2.400653, 0.826665, 1.479699>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.462961, 0.991861, 1.467108>, <2.445541, 0.966718, 1.449564>, <2.421696, 0.942388, 1.415452>, <2.404339, 0.925434, 1.389865>, 
      <2.431392, 1.004749, 1.479983>, <2.413973, 0.979606, 1.462439>, <2.390128, 0.955276, 1.428327>, <2.372771, 0.938322, 1.402740>, 
      <2.404288, 0.993040, 1.511098>, <2.393710, 0.970890, 1.485783>, <2.366472, 0.945066, 1.455535>, <2.345667, 0.926613, 1.433855>, 
      <2.403282, 0.966087, 1.535613>, <2.392704, 0.943937, 1.510297>, <2.365466, 0.918113, 1.480049>, <2.344661, 0.899660, 1.458369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.462961, 0.991861, 1.467108>, <2.445541, 0.966718, 1.449564>, <2.421696, 0.942388, 1.415452>, <2.404339, 0.925434, 1.389865>, 
      <2.494529, 0.978973, 1.454233>, <2.477109, 0.953830, 1.436690>, <2.453264, 0.929500, 1.402578>, <2.435907, 0.912546, 1.376991>, 
      <2.519959, 0.945817, 1.463924>, <2.496193, 0.929051, 1.443987>, <2.475496, 0.900557, 1.411071>, <2.461337, 0.879390, 1.386681>, 
      <2.518953, 0.918864, 1.488438>, <2.495187, 0.902098, 1.468501>, <2.474490, 0.873604, 1.435586>, <2.460331, 0.852438, 1.411195>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.486922, 0.896991, 1.620824>, <2.476491, 0.885171, 1.607079>, <2.469315, 0.901275, 1.573364>, <2.459276, 0.893091, 1.556942>, 
      <2.536796, 0.876630, 1.600484>, <2.526365, 0.864810, 1.586739>, <2.500883, 0.888387, 1.560490>, <2.490844, 0.880203, 1.544067>, 
      <2.579617, 0.895128, 1.551325>, <2.569236, 0.883364, 1.537646>, <2.531977, 0.901809, 1.524721>, <2.517947, 0.891912, 1.512952>, 
      <2.581206, 0.937710, 1.512596>, <2.570825, 0.925946, 1.498917>, <2.532982, 0.928761, 1.500207>, <2.518953, 0.918864, 1.488438>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.398460, 1.012318, 1.587127>, <2.388078, 1.000554, 1.573448>, <2.409526, 0.979163, 1.550557>, <2.403282, 0.966087, 1.535613>, 
      <2.396871, 0.969735, 1.625857>, <2.386490, 0.957971, 1.612177>, <2.408520, 0.952210, 1.575071>, <2.402276, 0.939134, 1.560127>, 
      <2.437048, 0.917353, 1.641165>, <2.426617, 0.905533, 1.627420>, <2.437747, 0.914162, 1.586239>, <2.427708, 0.905979, 1.569817>, 
      <2.486922, 0.896991, 1.620824>, <2.476491, 0.885171, 1.607079>, <2.469315, 0.901275, 1.573364>, <2.459276, 0.893091, 1.556942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.492745, 1.053036, 1.478899>, <2.482413, 1.041328, 1.465285>, <2.473195, 1.006633, 1.477415>, <2.462961, 0.991861, 1.467108>, 
      <2.442871, 1.073398, 1.499240>, <2.432539, 1.061690, 1.485626>, <2.441627, 1.019521, 1.490290>, <2.431392, 1.004749, 1.479983>, 
      <2.400049, 1.054900, 1.548398>, <2.389668, 1.043136, 1.534719>, <2.410532, 1.006115, 1.526043>, <2.404288, 0.993040, 1.511098>, 
      <2.398460, 1.012318, 1.587127>, <2.388078, 1.000554, 1.573448>, <2.409526, 0.979163, 1.550557>, <2.403282, 0.966087, 1.535613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.492745, 1.053036, 1.478899>, <2.482413, 1.041328, 1.465285>, <2.473195, 1.006633, 1.477415>, <2.462961, 0.991861, 1.467108>, 
      <2.542619, 1.032674, 1.458559>, <2.532287, 1.020967, 1.444945>, <2.504763, 0.993745, 1.464540>, <2.494529, 0.978973, 1.454233>, 
      <2.582795, 0.980292, 1.473867>, <2.572414, 0.968529, 1.460188>, <2.533988, 0.955714, 1.475693>, <2.519959, 0.945817, 1.463924>, 
      <2.581206, 0.937710, 1.512596>, <2.570825, 0.925946, 1.498917>, <2.532982, 0.928761, 1.500207>, <2.518953, 0.918864, 1.488438>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.576519, 1.025945, 1.711428>, <2.549394, 0.990188, 1.680710>, <2.514047, 0.927728, 1.656565>, <2.486922, 0.896991, 1.620824>, 
      <2.608087, 1.013057, 1.698553>, <2.580962, 0.977300, 1.667835>, <2.563921, 0.907366, 1.636225>, <2.536796, 0.876630, 1.600484>, 
      <2.635191, 1.024765, 1.667438>, <2.614382, 0.991717, 1.629419>, <2.606801, 0.925930, 1.587143>, <2.579617, 0.895128, 1.551325>, 
      <2.636197, 1.051718, 1.642924>, <2.615388, 1.018669, 1.604905>, <2.608389, 0.968513, 1.548414>, <2.581206, 0.937710, 1.512596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.520526, 1.098941, 1.690099>, <2.487431, 1.070908, 1.657091>, <2.425643, 1.043120, 1.622945>, <2.398460, 1.012318, 1.587127>, 
      <2.519520, 1.071988, 1.714613>, <2.486426, 1.043956, 1.681605>, <2.424054, 1.000538, 1.661674>, <2.396871, 0.969735, 1.625857>, 
      <2.544951, 1.038833, 1.724303>, <2.517825, 1.003076, 1.693585>, <2.464173, 0.948089, 1.676906>, <2.437048, 0.917353, 1.641165>, 
      <2.576519, 1.025945, 1.711428>, <2.549394, 0.990188, 1.680710>, <2.514047, 0.927728, 1.656565>, <2.486922, 0.896991, 1.620824>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.580204, 1.124715, 1.621594>, <2.553426, 1.099399, 1.581277>, <2.519986, 1.083905, 1.514794>, <2.492745, 1.053036, 1.478899>, 
      <2.548635, 1.137603, 1.634469>, <2.521858, 1.112287, 1.594152>, <2.470112, 1.104266, 1.535134>, <2.442871, 1.073398, 1.499240>, 
      <2.521532, 1.125894, 1.665585>, <2.488437, 1.097861, 1.632576>, <2.427232, 1.085703, 1.584216>, <2.400049, 1.054900, 1.548398>, 
      <2.520526, 1.098941, 1.690099>, <2.487431, 1.070908, 1.657091>, <2.425643, 1.043120, 1.622945>, <2.398460, 1.012318, 1.587127>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.580204, 1.124715, 1.621594>, <2.553426, 1.099399, 1.581277>, <2.519986, 1.083905, 1.514794>, <2.492745, 1.053036, 1.478899>, 
      <2.611773, 1.111827, 1.608719>, <2.584995, 1.086511, 1.568402>, <2.569860, 1.063543, 1.494453>, <2.542619, 1.032674, 1.458559>, 
      <2.637203, 1.078671, 1.618410>, <2.616394, 1.045622, 1.580391>, <2.609978, 1.011095, 1.509685>, <2.582795, 0.980292, 1.473867>, 
      <2.636197, 1.051718, 1.642924>, <2.615388, 1.018669, 1.604905>, <2.608389, 0.968513, 1.548414>, <2.581206, 0.937710, 1.512596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.635139, 1.092371, 1.788671>, <2.618215, 1.078574, 1.760984>, <2.594106, 1.049128, 1.731344>, <2.576519, 1.025945, 1.711428>, 
      <2.666708, 1.079483, 1.775796>, <2.649783, 1.065686, 1.748109>, <2.625674, 1.036240, 1.718469>, <2.608087, 1.013057, 1.698553>, 
      <2.693812, 1.091192, 1.744681>, <2.670046, 1.074426, 1.724744>, <2.648654, 1.046147, 1.692035>, <2.635191, 1.024765, 1.667438>, 
      <2.694818, 1.118145, 1.720167>, <2.671052, 1.101379, 1.700230>, <2.649660, 1.073099, 1.667521>, <2.636197, 1.051718, 1.642924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.579147, 1.165367, 1.767342>, <2.568570, 1.143217, 1.742026>, <2.541937, 1.117077, 1.711454>, <2.520526, 1.098941, 1.690099>, 
      <2.578141, 1.138414, 1.791856>, <2.567564, 1.116264, 1.766540>, <2.540931, 1.090124, 1.735968>, <2.519520, 1.071988, 1.714613>, 
      <2.603571, 1.105258, 1.801546>, <2.586647, 1.091461, 1.773859>, <2.562537, 1.062015, 1.744219>, <2.544951, 1.038833, 1.724303>, 
      <2.635139, 1.092371, 1.788671>, <2.618215, 1.078574, 1.760984>, <2.594106, 1.049128, 1.731344>, <2.576519, 1.025945, 1.711428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.638826, 1.191141, 1.698838>, <2.621406, 1.165998, 1.681294>, <2.597491, 1.141058, 1.647622>, <2.580204, 1.124715, 1.621594>, 
      <2.607257, 1.204029, 1.711713>, <2.589838, 1.178885, 1.694169>, <2.565923, 1.153946, 1.660496>, <2.548635, 1.137603, 1.634469>, 
      <2.580153, 1.192320, 1.742828>, <2.569576, 1.170170, 1.717512>, <2.542943, 1.144030, 1.686940>, <2.521532, 1.125894, 1.665585>, 
      <2.579147, 1.165367, 1.767342>, <2.568570, 1.143217, 1.742026>, <2.541937, 1.117077, 1.711454>, <2.520526, 1.098941, 1.690099>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.638826, 1.191141, 1.698838>, <2.621406, 1.165998, 1.681294>, <2.597491, 1.141058, 1.647622>, <2.580204, 1.124715, 1.621594>, 
      <2.670394, 1.178254, 1.685963>, <2.652974, 1.153110, 1.668420>, <2.629060, 1.128171, 1.634747>, <2.611773, 1.111827, 1.608719>, 
      <2.695824, 1.145098, 1.695653>, <2.672058, 1.128332, 1.675716>, <2.650666, 1.100052, 1.643006>, <2.637203, 1.078671, 1.618410>, 
      <2.694818, 1.118145, 1.720167>, <2.671052, 1.101379, 1.700230>, <2.649660, 1.073099, 1.667521>, <2.636197, 1.051718, 1.642924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.662786, 1.096273, 1.852553>, <2.652355, 1.084453, 1.838808>, <2.645178, 1.100555, 1.805093>, <2.635139, 1.092371, 1.788671>, 
      <2.712660, 1.075912, 1.832213>, <2.702229, 1.064092, 1.818468>, <2.676746, 1.087667, 1.792219>, <2.666708, 1.079483, 1.775796>, 
      <2.755483, 1.094410, 1.783055>, <2.745101, 1.082646, 1.769375>, <2.707841, 1.101089, 1.756450>, <2.693812, 1.091192, 1.744681>, 
      <2.757072, 1.136992, 1.744325>, <2.746690, 1.125228, 1.730646>, <2.708847, 1.128042, 1.731936>, <2.694818, 1.118145, 1.720167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.574324, 1.211598, 1.818856>, <2.563942, 1.199834, 1.805177>, <2.585391, 1.178443, 1.782286>, <2.579147, 1.165367, 1.767342>, 
      <2.572735, 1.169016, 1.857585>, <2.562353, 1.157252, 1.843906>, <2.584385, 1.151490, 1.806800>, <2.578141, 1.138414, 1.791856>, 
      <2.612912, 1.116634, 1.872893>, <2.602481, 1.104814, 1.859149>, <2.613610, 1.113442, 1.817968>, <2.603571, 1.105258, 1.801546>, 
      <2.662786, 1.096273, 1.852553>, <2.652355, 1.084453, 1.838808>, <2.645178, 1.100555, 1.805093>, <2.635139, 1.092371, 1.788671>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.668609, 1.252317, 1.710627>, <2.658277, 1.240609, 1.697013>, <2.649060, 1.205913, 1.709145>, <2.638826, 1.191141, 1.698838>, 
      <2.618734, 1.272678, 1.730968>, <2.608402, 1.260970, 1.717353>, <2.617491, 1.218800, 1.722020>, <2.607257, 1.204029, 1.711713>, 
      <2.575913, 1.254180, 1.780126>, <2.565531, 1.242417, 1.766447>, <2.586397, 1.205395, 1.757772>, <2.580153, 1.192320, 1.742828>, 
      <2.574324, 1.211598, 1.818856>, <2.563942, 1.199834, 1.805177>, <2.585391, 1.178443, 1.782286>, <2.579147, 1.165367, 1.767342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.668609, 1.252317, 1.710627>, <2.658277, 1.240609, 1.697013>, <2.649060, 1.205913, 1.709145>, <2.638826, 1.191141, 1.698838>, 
      <2.718483, 1.231956, 1.690287>, <2.708151, 1.220248, 1.676673>, <2.680628, 1.193025, 1.696270>, <2.670394, 1.178254, 1.685963>, 
      <2.758661, 1.179574, 1.705595>, <2.748279, 1.167810, 1.691916>, <2.709853, 1.154995, 1.707422>, <2.695824, 1.145098, 1.695653>, 
      <2.757072, 1.136992, 1.744325>, <2.746690, 1.125228, 1.730646>, <2.708847, 1.128042, 1.731936>, <2.694818, 1.118145, 1.720167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.752383, 1.225225, 1.943156>, <2.725204, 1.191189, 1.910586>, <2.689911, 1.127009, 1.888294>, <2.662786, 1.096273, 1.852553>, 
      <2.783951, 1.212337, 1.930281>, <2.756772, 1.178302, 1.897712>, <2.739785, 1.106648, 1.867953>, <2.712660, 1.075912, 1.832213>, 
      <2.811055, 1.224045, 1.899167>, <2.794558, 1.189843, 1.860068>, <2.782666, 1.125212, 1.818872>, <2.755483, 1.094410, 1.783055>, 
      <2.812061, 1.250998, 1.874653>, <2.795564, 1.216796, 1.835555>, <2.784255, 1.167794, 1.780143>, <2.757072, 1.136992, 1.744325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.752383, 1.225225, 1.943156>, <2.794635, 1.278137, 1.993789>, <2.850865, 1.327406, 2.082341>, <2.892944, 1.384499, 2.128366>, 
      <2.783951, 1.212337, 1.930281>, <2.826203, 1.265249, 1.980914>, <2.882433, 1.314518, 2.069467>, <2.924512, 1.371611, 2.115491>, 
      <2.811055, 1.224045, 1.899167>, <2.853223, 1.271828, 1.954729>, <2.909447, 1.335538, 2.028813>, <2.951615, 1.383320, 2.084376>, 
      <2.812061, 1.250998, 1.874653>, <2.854229, 1.298781, 1.930216>, <2.910453, 1.362490, 2.004299>, <2.952621, 1.410273, 2.059862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.696390, 1.298222, 1.921828>, <2.659770, 1.272235, 1.890936>, <2.601507, 1.242401, 1.854674>, <2.574324, 1.211598, 1.818856>, 
      <2.695384, 1.271269, 1.946342>, <2.658764, 1.245282, 1.915450>, <2.599918, 1.199819, 1.893403>, <2.572735, 1.169016, 1.857585>, 
      <2.720815, 1.238113, 1.956031>, <2.693636, 1.204078, 1.923461>, <2.640037, 1.147370, 1.908634>, <2.612912, 1.116634, 1.872893>, 
      <2.752383, 1.225225, 1.943156>, <2.725204, 1.191189, 1.910586>, <2.689911, 1.127009, 1.888294>, <2.662786, 1.096273, 1.852553>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.696390, 1.298222, 1.921828>, <2.738558, 1.346004, 1.977391>, <2.794782, 1.409714, 2.051474>, <2.836950, 1.457496, 2.107037>, 
      <2.695384, 1.271269, 1.946342>, <2.737552, 1.319051, 2.001905>, <2.793776, 1.382761, 2.075989>, <2.835944, 1.430543, 2.131552>, 
      <2.720815, 1.238113, 1.956031>, <2.763067, 1.291025, 2.006664>, <2.819297, 1.340294, 2.095216>, <2.861376, 1.397387, 2.141241>, 
      <2.752383, 1.225225, 1.943156>, <2.794635, 1.278137, 1.993789>, <2.850865, 1.327406, 2.082341>, <2.892944, 1.384499, 2.128366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.696390, 1.298222, 1.921828>, <2.695384, 1.271269, 1.946342>, <2.720815, 1.238113, 1.956031>, <2.752383, 1.225225, 1.943156>, 
      <2.696390, 1.298222, 1.921828>, <2.730085, 1.257102, 1.932189>, <2.752383, 1.225225, 1.943156>, <2.783951, 1.212337, 1.930281>, 
      <2.696390, 1.298222, 1.921828>, <2.730085, 1.257102, 1.932189>, <2.776354, 1.238212, 1.913319>, <2.811055, 1.224045, 1.899167>, 
      <2.696390, 1.298222, 1.921828>, <2.731091, 1.284055, 1.907676>, <2.777360, 1.265165, 1.888806>, <2.812061, 1.250998, 1.874653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.756070, 1.323995, 1.853324>, <2.729074, 1.296652, 1.814503>, <2.695851, 1.283186, 1.746522>, <2.668609, 1.252317, 1.710627>, 
      <2.724501, 1.336883, 1.866199>, <2.697506, 1.309540, 1.827378>, <2.645976, 1.303547, 1.766863>, <2.618734, 1.272678, 1.730968>, 
      <2.697396, 1.325175, 1.897314>, <2.660776, 1.299188, 1.866422>, <2.603096, 1.284983, 1.815944>, <2.575913, 1.254180, 1.780126>, 
      <2.696390, 1.298222, 1.921828>, <2.659770, 1.272235, 1.890936>, <2.601507, 1.242401, 1.854674>, <2.574324, 1.211598, 1.818856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.756070, 1.323995, 1.853324>, <2.797857, 1.366319, 1.913416>, <2.855464, 1.446306, 1.974598>, <2.896629, 1.483269, 2.038533>, 
      <2.724501, 1.336883, 1.866199>, <2.766288, 1.379207, 1.926291>, <2.823896, 1.459194, 1.987473>, <2.865061, 1.496157, 2.051408>, 
      <2.697396, 1.325175, 1.897314>, <2.739564, 1.372957, 1.952877>, <2.795788, 1.436667, 2.026960>, <2.837956, 1.484449, 2.082523>, 
      <2.696390, 1.298222, 1.921828>, <2.738558, 1.346004, 1.977391>, <2.794782, 1.409714, 2.051474>, <2.836950, 1.457496, 2.107037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.756070, 1.323995, 1.853324>, <2.729074, 1.296652, 1.814503>, <2.695851, 1.283186, 1.746522>, <2.668609, 1.252317, 1.710627>, 
      <2.787638, 1.311107, 1.840449>, <2.760642, 1.283764, 1.801628>, <2.745725, 1.262825, 1.726182>, <2.718483, 1.231956, 1.690287>, 
      <2.813067, 1.277951, 1.850139>, <2.796571, 1.243749, 1.811041>, <2.785844, 1.210376, 1.741413>, <2.758661, 1.179574, 1.705595>, 
      <2.812061, 1.250998, 1.874653>, <2.795564, 1.216796, 1.835555>, <2.784255, 1.167794, 1.780143>, <2.757072, 1.136992, 1.744325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.756070, 1.323995, 1.853324>, <2.724501, 1.336883, 1.866199>, <2.697396, 1.325175, 1.897314>, <2.696390, 1.298222, 1.921828>, 
      <2.756070, 1.323995, 1.853324>, <2.756069, 1.323995, 1.853324>, <2.732097, 1.311008, 1.883161>, <2.731091, 1.284055, 1.907676>, 
      <2.756070, 1.323995, 1.853324>, <2.756069, 1.323995, 1.853324>, <2.778366, 1.292118, 1.864292>, <2.777360, 1.265165, 1.888806>, 
      <2.756070, 1.323995, 1.853324>, <2.787638, 1.311107, 1.840449>, <2.813067, 1.277951, 1.850139>, <2.812061, 1.250998, 1.874653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.756070, 1.323995, 1.853324>, <2.787638, 1.311107, 1.840449>, <2.813067, 1.277951, 1.850139>, <2.812061, 1.250998, 1.874653>, 
      <2.797857, 1.366319, 1.913416>, <2.829425, 1.353431, 1.900541>, <2.855235, 1.325733, 1.905702>, <2.854229, 1.298781, 1.930216>, 
      <2.855464, 1.446306, 1.974598>, <2.887032, 1.433419, 1.961723>, <2.911459, 1.389443, 1.979785>, <2.910453, 1.362490, 2.004299>, 
      <2.896629, 1.483269, 2.038533>, <2.928197, 1.470381, 2.025658>, <2.953627, 1.437226, 2.035348>, <2.952621, 1.410273, 2.059862>
    }
  }
  texture {
    BumbySpikes
  }
}
#declare Tongue = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.028069, -3.490194, -4.291677>, <1.028543, -3.491030, -4.292734>, <1.030234, -3.493970, -4.289840>, <1.029918, -3.493327, -4.288604>, 
      <0.928803, -3.315163, -4.070392>, <0.929277, -3.315999, -4.071449>, <0.965658, -3.362304, -4.036892>, <0.965343, -3.361660, -4.035656>, 
      <0.707186, -3.097550, -3.783540>, <0.741284, -3.139892, -3.752620>, <0.787049, -3.151497, -3.733660>, <0.821147, -3.193839, -3.702740>, 
      <0.698978, -2.909794, -3.550866>, <0.733075, -2.952136, -3.519946>, <0.778539, -3.008591, -3.478720>, <0.812636, -3.050933, -3.447800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.017014, -3.409481, -4.264410>, <0.016227, -3.409993, -4.265466>, <0.016743, -3.406537, -4.268339>, <0.017644, -3.405927, -4.267437>, 
      <0.200228, -3.290307, -4.018656>, <0.199441, -3.290819, -4.019712>, <0.230753, -3.261737, -4.054274>, <0.231654, -3.261127, -4.053372>, 
      <0.529494, -3.148762, -3.728224>, <0.559997, -3.124270, -3.759144>, <0.599173, -3.142594, -3.776579>, <0.629676, -3.118102, -3.807499>, 
      <0.628700, -3.008458, -3.447800>, <0.659203, -2.983966, -3.478720>, <0.699874, -2.951310, -3.519946>, <0.730377, -2.926818, -3.550866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313817, -0.882904, -0.431113>, <0.313817, -0.834027, -0.422749>, <0.384188, -0.785856, -0.414505>, <0.429906, -0.766928, -0.411266>, 
      <0.313817, -0.862854, -0.548273>, <0.313817, -0.813978, -0.539909>, <0.384188, -0.765806, -0.531665>, <0.429906, -0.746878, -0.528426>, 
      <0.313817, -0.810866, -0.702898>, <0.313817, -0.761989, -0.694533>, <0.384188, -0.712647, -0.686347>, <0.429906, -0.693719, -0.683108>, 
      <0.313817, -0.816072, -0.821647>, <0.313817, -0.767195, -0.813283>, <0.384188, -0.719024, -0.805039>, <0.429906, -0.700096, -0.801800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.429906, -0.998881, -0.450960>, <0.384188, -0.979953, -0.447721>, <0.313817, -0.931781, -0.439477>, <0.313817, -0.882904, -0.431113>, 
      <0.429906, -0.978831, -0.568120>, <0.384188, -0.959903, -0.564881>, <0.313817, -0.911731, -0.556638>, <0.313817, -0.862854, -0.548273>, 
      <0.429906, -0.928244, -0.722692>, <0.384188, -0.909316, -0.719452>, <0.313817, -0.859743, -0.711262>, <0.313817, -0.810866, -0.702898>, 
      <0.429906, -0.932048, -0.841494>, <0.384188, -0.913120, -0.838255>, <0.313817, -0.864949, -0.830011>, <0.313817, -0.816072, -0.821647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.046944, -0.459186>, <0.624728, -1.046944, -0.459186>, <0.508550, -1.031441, -0.456532>, <0.429906, -0.998881, -0.450960>, 
      <0.710028, -1.026895, -0.576346>, <0.624728, -1.026895, -0.576346>, <0.508550, -1.011392, -0.573693>, <0.429906, -0.978831, -0.568120>, 
      <0.710028, -0.976973, -0.730897>, <0.624728, -0.976973, -0.730897>, <0.508550, -0.960804, -0.728263>, <0.429906, -0.928244, -0.722692>, 
      <0.710028, -0.980112, -0.849719>, <0.624728, -0.980112, -0.849719>, <0.508550, -0.964608, -0.847066>, <0.429906, -0.932048, -0.841494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -0.998881, -0.450960>, <0.911505, -1.031441, -0.456532>, <0.795328, -1.046944, -0.459186>, <0.710028, -1.046944, -0.459186>, 
      <0.990149, -0.978831, -0.568120>, <0.911505, -1.011391, -0.573693>, <0.795328, -1.026895, -0.576346>, <0.710028, -1.026895, -0.576346>, 
      <0.990149, -0.928244, -0.722692>, <0.911505, -0.960804, -0.728263>, <0.795328, -0.976973, -0.730897>, <0.710028, -0.976973, -0.730897>, 
      <0.990149, -0.932048, -0.841494>, <0.911505, -0.964608, -0.847066>, <0.795328, -0.980112, -0.849719>, <0.710028, -0.980112, -0.849719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106238, -0.882904, -0.431113>, <1.106238, -0.931781, -0.439477>, <1.035867, -0.979953, -0.447721>, <0.990149, -0.998881, -0.450960>, 
      <1.106238, -0.862854, -0.548273>, <1.106238, -0.911731, -0.556638>, <1.035867, -0.959903, -0.564881>, <0.990149, -0.978831, -0.568120>, 
      <1.106238, -0.810866, -0.702898>, <1.106238, -0.859743, -0.711262>, <1.035867, -0.909316, -0.719452>, <0.990149, -0.928244, -0.722692>, 
      <1.106238, -0.816072, -0.821647>, <1.106238, -0.864949, -0.830011>, <1.035867, -0.913120, -0.838255>, <0.990149, -0.932048, -0.841494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -0.766928, -0.411266>, <1.035867, -0.785856, -0.414505>, <1.106238, -0.834027, -0.422749>, <1.106238, -0.882904, -0.431113>, 
      <0.990149, -0.746878, -0.528426>, <1.035867, -0.765806, -0.531666>, <1.106238, -0.813978, -0.539909>, <1.106238, -0.862854, -0.548273>, 
      <0.990149, -0.693719, -0.683108>, <1.035867, -0.712647, -0.686347>, <1.106238, -0.761989, -0.694533>, <1.106238, -0.810866, -0.702898>, 
      <0.990149, -0.700096, -0.801800>, <1.035867, -0.719024, -0.805039>, <1.106238, -0.767195, -0.813283>, <1.106238, -0.816072, -0.821647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -0.718865, -0.403041>, <0.795328, -0.718865, -0.403041>, <0.911505, -0.734368, -0.405694>, <0.990149, -0.766928, -0.411266>, 
      <0.710028, -0.698815, -0.520201>, <0.795328, -0.698815, -0.520201>, <0.911505, -0.714318, -0.522854>, <0.990149, -0.746878, -0.528426>, 
      <0.710028, -0.645225, -0.674907>, <0.795328, -0.645225, -0.674907>, <0.911505, -0.661159, -0.677536>, <0.990149, -0.693719, -0.683108>, 
      <0.710028, -0.652033, -0.793575>, <0.795328, -0.652033, -0.793575>, <0.911505, -0.667536, -0.796228>, <0.990149, -0.700096, -0.801800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -0.718865, -0.403041>, <0.710028, -0.698815, -0.520201>, <0.710028, -0.645225, -0.674907>, <0.710028, -0.652033, -0.793575>, 
      <0.624728, -0.718865, -0.403041>, <0.624728, -0.698815, -0.520201>, <0.624728, -0.645225, -0.674907>, <0.624728, -0.652033, -0.793575>, 
      <0.508550, -0.734368, -0.405694>, <0.508550, -0.714318, -0.522854>, <0.508550, -0.661159, -0.677536>, <0.508550, -0.667536, -0.796228>, 
      <0.429906, -0.766928, -0.411266>, <0.429906, -0.746878, -0.528426>, <0.429906, -0.693719, -0.683108>, <0.429906, -0.700096, -0.801800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313817, -0.920308, -1.284298>, <0.313817, -0.857961, -1.156412>, <0.313817, -0.822303, -0.963785>, <0.313817, -0.816072, -0.821647>, 
      <0.313817, -0.876705, -1.307913>, <0.313817, -0.814358, -1.180027>, <0.313817, -0.773427, -0.955421>, <0.313817, -0.767195, -0.813283>, 
      <0.384188, -0.833731, -1.331187>, <0.384188, -0.762527, -1.181995>, <0.384188, -0.727893, -0.970114>, <0.384188, -0.719024, -0.805039>, 
      <0.429906, -0.816845, -1.340332>, <0.429906, -0.745641, -1.191140>, <0.429906, -0.708965, -0.966874>, <0.429906, -0.700096, -0.801800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.429906, -1.023771, -1.228264>, <0.429906, -0.970327, -1.121661>, <0.429906, -0.935864, -0.960682>, <0.429906, -0.932048, -0.841494>, 
      <0.384188, -1.006885, -1.237409>, <0.384188, -0.953441, -1.130807>, <0.384188, -0.916936, -0.957443>, <0.384188, -0.913120, -0.838255>, 
      <0.313817, -0.963911, -1.260683>, <0.313817, -0.901564, -1.132797>, <0.313817, -0.871180, -0.972149>, <0.313817, -0.864949, -0.830011>, 
      <0.313817, -0.920308, -1.284298>, <0.313817, -0.857961, -1.156412>, <0.313817, -0.822303, -0.963785>, <0.313817, -0.816072, -0.821647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.066649, -1.205042>, <0.710028, -1.016913, -1.107250>, <0.710028, -0.983009, -0.959393>, <0.710028, -0.980112, -0.849719>, 
      <0.624728, -1.066649, -1.205042>, <0.624728, -1.016913, -1.107250>, <0.624728, -0.983009, -0.959393>, <0.624728, -0.980112, -0.849719>, 
      <0.508550, -1.052818, -1.212532>, <0.508550, -0.999374, -1.105930>, <0.508550, -0.968425, -0.966254>, <0.508550, -0.964608, -0.847066>, 
      <0.429906, -1.023771, -1.228264>, <0.429906, -0.970327, -1.121661>, <0.429906, -0.935864, -0.960682>, <0.429906, -0.932048, -0.841494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -1.023771, -1.228264>, <0.990149, -0.970327, -1.121661>, <0.990149, -0.935864, -0.960682>, <0.990149, -0.932048, -0.841494>, 
      <0.911505, -1.052818, -1.212532>, <0.911505, -0.999374, -1.105930>, <0.911505, -0.968425, -0.966254>, <0.911505, -0.964608, -0.847066>, 
      <0.795328, -1.066649, -1.205042>, <0.795328, -1.016913, -1.107250>, <0.795328, -0.983009, -0.959393>, <0.795328, -0.980112, -0.849719>, 
      <0.710028, -1.066649, -1.205042>, <0.710028, -1.016913, -1.107250>, <0.710028, -0.983009, -0.959393>, <0.710028, -0.980112, -0.849719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106238, -0.920308, -1.284298>, <1.106238, -0.857961, -1.156412>, <1.106238, -0.822303, -0.963785>, <1.106238, -0.816072, -0.821647>, 
      <1.106238, -0.963911, -1.260683>, <1.106238, -0.901564, -1.132797>, <1.106238, -0.871180, -0.972149>, <1.106238, -0.864949, -0.830011>, 
      <1.035867, -1.006885, -1.237409>, <1.035867, -0.953441, -1.130807>, <1.035867, -0.916936, -0.957443>, <1.035867, -0.913120, -0.838255>, 
      <0.990149, -1.023771, -1.228264>, <0.990149, -0.970327, -1.121661>, <0.990149, -0.935864, -0.960682>, <0.990149, -0.932048, -0.841494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -0.816845, -1.340332>, <0.990149, -0.745641, -1.191140>, <0.990149, -0.708965, -0.966874>, <0.990149, -0.700096, -0.801800>, 
      <1.035867, -0.833731, -1.331187>, <1.035867, -0.762527, -1.181995>, <1.035867, -0.727893, -0.970114>, <1.035867, -0.719024, -0.805039>, 
      <1.106238, -0.876705, -1.307913>, <1.106238, -0.814358, -1.180027>, <1.106238, -0.773427, -0.955421>, <1.106238, -0.767195, -0.813283>, 
      <1.106238, -0.920308, -1.284298>, <1.106238, -0.857961, -1.156412>, <1.106238, -0.822303, -0.963785>, <1.106238, -0.816072, -0.821647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -0.773967, -1.363554>, <0.710028, -0.699102, -1.205528>, <0.710028, -0.662048, -0.968151>, <0.710028, -0.652033, -0.793575>, 
      <0.795328, -0.773967, -1.363554>, <0.795328, -0.699102, -1.205528>, <0.795328, -0.662048, -0.968151>, <0.795328, -0.652033, -0.793575>, 
      <0.911505, -0.787798, -1.356064>, <0.911505, -0.716594, -1.206872>, <0.911505, -0.676405, -0.961302>, <0.911505, -0.667536, -0.796228>, 
      <0.990149, -0.816845, -1.340332>, <0.990149, -0.745641, -1.191140>, <0.990149, -0.708965, -0.966874>, <0.990149, -0.700096, -0.801800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -0.773967, -1.363554>, <0.624728, -0.773967, -1.363554>, <0.508550, -0.787798, -1.356064>, <0.429906, -0.816845, -1.340332>, 
      <0.710028, -0.699102, -1.205528>, <0.624728, -0.699102, -1.205528>, <0.508550, -0.716594, -1.206872>, <0.429906, -0.745641, -1.191140>, 
      <0.710028, -0.662048, -0.968151>, <0.624728, -0.662048, -0.968151>, <0.508550, -0.676405, -0.961302>, <0.429906, -0.708965, -0.966874>, 
      <0.710028, -0.652033, -0.793575>, <0.624728, -0.652033, -0.793575>, <0.508550, -0.667536, -0.796228>, <0.429906, -0.700096, -0.801800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313817, -1.195156, -1.599225>, <0.313817, -1.102801, -1.514400>, <0.313817, -0.975260, -1.397015>, <0.313817, -0.920308, -1.284298>, 
      <0.313817, -1.166082, -1.639395>, <0.313817, -1.073727, -1.554570>, <0.313817, -0.931657, -1.420630>, <0.313817, -0.876705, -1.307913>, 
      <0.384188, -1.137428, -1.678985>, <0.384188, -1.034149, -1.582878>, <0.384188, -0.894497, -1.458508>, <0.384188, -0.833731, -1.331187>, 
      <0.429906, -1.126169, -1.694541>, <0.429906, -1.022890, -1.598435>, <0.429906, -0.877611, -1.467653>, <0.429906, -0.816845, -1.340332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.429906, -1.264143, -1.503908>, <0.429906, -1.182788, -1.430290>, <0.429906, -1.072944, -1.326347>, <0.429906, -1.023771, -1.228264>, 
      <0.384188, -1.252884, -1.519465>, <0.384188, -1.171529, -1.445847>, <0.384188, -1.056058, -1.335492>, <0.384188, -1.006885, -1.237409>, 
      <0.313817, -1.224230, -1.559055>, <0.313817, -1.131874, -1.474230>, <0.313817, -1.018863, -1.373400>, <0.313817, -0.963911, -1.260683>, 
      <0.313817, -1.195156, -1.599225>, <0.313817, -1.102801, -1.514400>, <0.313817, -0.975260, -1.397015>, <0.313817, -0.920308, -1.284298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.292733, -1.464407>, <0.710028, -1.215962, -1.395408>, <0.710028, -1.113442, -1.297048>, <0.710028, -1.066649, -1.205042>, 
      <0.624728, -1.292733, -1.464407>, <0.624728, -1.215962, -1.395408>, <0.624728, -1.113442, -1.297048>, <0.624728, -1.066649, -1.205042>, 
      <0.508550, -1.283511, -1.477148>, <0.508550, -1.202156, -1.403530>, <0.508550, -1.101991, -1.310615>, <0.508550, -1.052818, -1.212532>, 
      <0.429906, -1.264143, -1.503908>, <0.429906, -1.182788, -1.430290>, <0.429906, -1.072944, -1.326347>, <0.429906, -1.023771, -1.228264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -1.264143, -1.503908>, <0.990149, -1.182788, -1.430290>, <0.990149, -1.072944, -1.326347>, <0.990149, -1.023771, -1.228264>, 
      <0.911505, -1.283511, -1.477148>, <0.911505, -1.202156, -1.403530>, <0.911505, -1.101991, -1.310615>, <0.911505, -1.052818, -1.212532>, 
      <0.795328, -1.292733, -1.464407>, <0.795328, -1.215962, -1.395408>, <0.795328, -1.113442, -1.297048>, <0.795328, -1.066649, -1.205042>, 
      <0.710028, -1.292733, -1.464407>, <0.710028, -1.215962, -1.395408>, <0.710028, -1.113442, -1.297048>, <0.710028, -1.066649, -1.205042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106238, -1.195156, -1.599225>, <1.106238, -1.102801, -1.514400>, <1.106238, -0.975260, -1.397015>, <1.106238, -0.920308, -1.284298>, 
      <1.106238, -1.224230, -1.559055>, <1.106238, -1.131874, -1.474230>, <1.106238, -1.018863, -1.373400>, <1.106238, -0.963911, -1.260683>, 
      <1.035867, -1.252884, -1.519465>, <1.035867, -1.171529, -1.445847>, <1.035867, -1.056058, -1.335492>, <1.035867, -1.006885, -1.237409>, 
      <0.990149, -1.264143, -1.503908>, <0.990149, -1.182788, -1.430290>, <0.990149, -1.072944, -1.326347>, <0.990149, -1.023771, -1.228264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -1.126169, -1.694541>, <0.990149, -1.022890, -1.598435>, <0.990149, -0.877611, -1.467653>, <0.990149, -0.816845, -1.340332>, 
      <1.035867, -1.137428, -1.678985>, <1.035867, -1.034149, -1.582878>, <1.035867, -0.894497, -1.458508>, <1.035867, -0.833731, -1.331187>, 
      <1.106238, -1.166082, -1.639395>, <1.106238, -1.073727, -1.554570>, <1.106238, -0.931657, -1.420630>, <1.106238, -0.876705, -1.307913>, 
      <1.106238, -1.195156, -1.599225>, <1.106238, -1.102801, -1.514400>, <1.106238, -0.975260, -1.397015>, <1.106238, -0.920308, -1.284298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.097579, -1.734042>, <0.710028, -0.989792, -1.633242>, <0.710028, -0.837150, -1.496921>, <0.710028, -0.773967, -1.363554>, 
      <0.795328, -1.097579, -1.734042>, <0.795328, -0.989792, -1.633242>, <0.795328, -0.837150, -1.496921>, <0.795328, -0.773967, -1.363554>, 
      <0.911505, -1.106801, -1.721301>, <0.911505, -1.003521, -1.625194>, <0.911505, -0.848563, -1.483385>, <0.911505, -0.787798, -1.356064>, 
      <0.990149, -1.126169, -1.694541>, <0.990149, -1.022890, -1.598435>, <0.990149, -0.877611, -1.467653>, <0.990149, -0.816845, -1.340332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.097579, -1.734042>, <0.624728, -1.097579, -1.734042>, <0.508550, -1.106801, -1.721301>, <0.429906, -1.126169, -1.694541>, 
      <0.710028, -0.989792, -1.633242>, <0.624728, -0.989792, -1.633242>, <0.508550, -1.003521, -1.625195>, <0.429906, -1.022890, -1.598435>, 
      <0.710028, -0.837150, -1.496921>, <0.624728, -0.837150, -1.496921>, <0.508550, -0.848563, -1.483385>, <0.429906, -0.877611, -1.467653>, 
      <0.710028, -0.773967, -1.363554>, <0.624728, -0.773967, -1.363554>, <0.508550, -0.787798, -1.356064>, <0.429906, -0.816845, -1.340332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313817, -1.516120, -1.831529>, <0.313817, -1.426244, -1.753743>, <0.313817, -1.282698, -1.679629>, <0.313817, -1.195156, -1.599225>, 
      <0.313817, -1.487046, -1.871699>, <0.313817, -1.397170, -1.793912>, <0.313817, -1.253625, -1.719799>, <0.313817, -1.166082, -1.639395>, 
      <0.384188, -1.458392, -1.911289>, <0.384188, -1.367741, -1.834406>, <0.384188, -1.224445, -1.759958>, <0.384188, -1.137428, -1.678985>, 
      <0.429906, -1.447133, -1.926845>, <0.429906, -1.356482, -1.849963>, <0.429906, -1.213185, -1.775514>, <0.429906, -1.126169, -1.694541>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.429906, -1.585107, -1.736213>, <0.429906, -1.495918, -1.657639>, <0.429906, -1.352279, -1.583661>, <0.429906, -1.264143, -1.503908>, 
      <0.384188, -1.573848, -1.751769>, <0.384188, -1.484659, -1.673195>, <0.384188, -1.341020, -1.599218>, <0.384188, -1.252884, -1.519465>, 
      <0.313817, -1.545194, -1.791359>, <0.313817, -1.455317, -1.713573>, <0.313817, -1.311772, -1.639459>, <0.313817, -1.224230, -1.559055>, 
      <0.313817, -1.516120, -1.831529>, <0.313817, -1.426244, -1.753743>, <0.313817, -1.282698, -1.679629>, <0.313817, -1.195156, -1.599225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.613697, -1.696712>, <0.710028, -1.524771, -1.617841>, <0.710028, -1.381137, -1.543862>, <0.710028, -1.292733, -1.464407>, 
      <0.624728, -1.613697, -1.696712>, <0.624728, -1.524771, -1.617841>, <0.624728, -1.381137, -1.543862>, <0.624728, -1.292733, -1.464407>, 
      <0.508550, -1.604475, -1.709453>, <0.508550, -1.515286, -1.630879>, <0.508550, -1.371647, -1.556901>, <0.508550, -1.283511, -1.477148>, 
      <0.429906, -1.585107, -1.736213>, <0.429906, -1.495918, -1.657639>, <0.429906, -1.352279, -1.583661>, <0.429906, -1.264143, -1.503908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -1.585107, -1.736213>, <0.990149, -1.495918, -1.657639>, <0.990149, -1.352279, -1.583661>, <0.990149, -1.264143, -1.503908>, 
      <0.911505, -1.604475, -1.709453>, <0.911505, -1.515286, -1.630879>, <0.911505, -1.371647, -1.556901>, <0.911505, -1.283511, -1.477148>, 
      <0.795328, -1.613697, -1.696712>, <0.795328, -1.524771, -1.617841>, <0.795328, -1.381137, -1.543862>, <0.795328, -1.292733, -1.464407>, 
      <0.710028, -1.613697, -1.696712>, <0.710028, -1.524771, -1.617841>, <0.710028, -1.381137, -1.543862>, <0.710028, -1.292733, -1.464407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106238, -1.516120, -1.831529>, <1.106238, -1.426244, -1.753743>, <1.106238, -1.282698, -1.679629>, <1.106238, -1.195156, -1.599225>, 
      <1.106238, -1.545194, -1.791359>, <1.106238, -1.455317, -1.713573>, <1.106238, -1.311772, -1.639459>, <1.106238, -1.224230, -1.559055>, 
      <1.035867, -1.573848, -1.751769>, <1.035867, -1.484659, -1.673195>, <1.035867, -1.341020, -1.599218>, <1.035867, -1.252884, -1.519465>, 
      <0.990149, -1.585107, -1.736213>, <0.990149, -1.495918, -1.657639>, <0.990149, -1.352279, -1.583661>, <0.990149, -1.264143, -1.503908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -1.447133, -1.926845>, <0.990149, -1.356482, -1.849963>, <0.990149, -1.213185, -1.775514>, <0.990149, -1.126169, -1.694541>, 
      <1.035867, -1.458392, -1.911289>, <1.035867, -1.367741, -1.834406>, <1.035867, -1.224445, -1.759958>, <1.035867, -1.137428, -1.678985>, 
      <1.106238, -1.487046, -1.871699>, <1.106238, -1.397170, -1.793912>, <1.106238, -1.253625, -1.719799>, <1.106238, -1.166082, -1.639395>, 
      <1.106238, -1.516120, -1.831529>, <1.106238, -1.426244, -1.753743>, <1.106238, -1.282698, -1.679629>, <1.106238, -1.195156, -1.599225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.418543, -1.966347>, <0.710028, -1.327541, -1.889880>, <0.710028, -1.184395, -1.815230>, <0.710028, -1.097579, -1.734042>, 
      <0.795328, -1.418543, -1.966347>, <0.795328, -1.327541, -1.889880>, <0.795328, -1.184395, -1.815230>, <0.795328, -1.097579, -1.734042>, 
      <0.911505, -1.427765, -1.953605>, <0.911505, -1.337114, -1.876723>, <0.911505, -1.193817, -1.802274>, <0.911505, -1.106801, -1.721301>, 
      <0.990149, -1.447133, -1.926845>, <0.990149, -1.356482, -1.849963>, <0.990149, -1.213185, -1.775514>, <0.990149, -1.126169, -1.694541>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.418543, -1.966347>, <0.624728, -1.418543, -1.966347>, <0.508550, -1.427765, -1.953605>, <0.429906, -1.447133, -1.926845>, 
      <0.710028, -1.327541, -1.889880>, <0.624728, -1.327541, -1.889880>, <0.508550, -1.337114, -1.876723>, <0.429906, -1.356482, -1.849963>, 
      <0.710028, -1.184395, -1.815230>, <0.624728, -1.184395, -1.815230>, <0.508550, -1.193817, -1.802274>, <0.429906, -1.213185, -1.775514>, 
      <0.710028, -1.097579, -1.734042>, <0.624728, -1.097579, -1.734042>, <0.508550, -1.106801, -1.721301>, <0.429906, -1.126169, -1.694541>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313817, -1.812773, -2.133762>, <0.313817, -1.753955, -2.021148>, <0.313817, -1.612185, -1.914672>, <0.313817, -1.516120, -1.831529>, 
      <0.313817, -1.768887, -2.156847>, <0.313817, -1.710070, -2.044234>, <0.313817, -1.583112, -1.954842>, <0.313817, -1.487046, -1.871699>, 
      <0.384188, -1.725634, -2.179600>, <0.384188, -1.673050, -2.081859>, <0.384188, -1.543037, -1.983077>, <0.384188, -1.458392, -1.911289>, 
      <0.429906, -1.708639, -2.188540>, <0.429906, -1.656055, -2.090800>, <0.429906, -1.531778, -1.998633>, <0.429906, -1.447133, -1.926845>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.429906, -1.916907, -2.078985>, <0.429906, -1.851776, -1.951547>, <0.429906, -1.692494, -1.830820>, <0.429906, -1.585107, -1.736213>, 
      <0.384188, -1.899912, -2.087925>, <0.384188, -1.834780, -1.960487>, <0.384188, -1.681235, -1.846376>, <0.384188, -1.573848, -1.751769>, 
      <0.313817, -1.856659, -2.110677>, <0.313817, -1.797841, -1.998063>, <0.313817, -1.641259, -1.874502>, <0.313817, -1.545194, -1.791359>, 
      <0.313817, -1.812773, -2.133762>, <0.313817, -1.753955, -2.021148>, <0.313817, -1.612185, -1.914672>, <0.313817, -1.516120, -1.831529>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.960063, -2.056284>, <0.710028, -1.892299, -1.922712>, <0.710028, -1.725751, -1.796097>, <0.710028, -1.613697, -1.696712>, 
      <0.624728, -1.960063, -2.056284>, <0.624728, -1.892299, -1.922712>, <0.624728, -1.725751, -1.796097>, <0.624728, -1.613697, -1.696712>, 
      <0.508550, -1.946143, -2.063606>, <0.508550, -1.881011, -1.936168>, <0.508550, -1.711863, -1.804060>, <0.508550, -1.604475, -1.709453>, 
      <0.429906, -1.916907, -2.078985>, <0.429906, -1.851776, -1.951547>, <0.429906, -1.692494, -1.830820>, <0.429906, -1.585107, -1.736213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -1.916907, -2.078985>, <0.990149, -1.851776, -1.951547>, <0.990149, -1.692494, -1.830820>, <0.990149, -1.585107, -1.736213>, 
      <0.911505, -1.946143, -2.063606>, <0.911505, -1.881011, -1.936168>, <0.911505, -1.711863, -1.804060>, <0.911505, -1.604475, -1.709453>, 
      <0.795328, -1.960063, -2.056284>, <0.795328, -1.892299, -1.922712>, <0.795328, -1.725751, -1.796097>, <0.795328, -1.613697, -1.696712>, 
      <0.710028, -1.960063, -2.056284>, <0.710028, -1.892299, -1.922712>, <0.710028, -1.725751, -1.796097>, <0.710028, -1.613697, -1.696712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106238, -1.812773, -2.133762>, <1.106238, -1.753955, -2.021148>, <1.106238, -1.612185, -1.914672>, <1.106238, -1.516120, -1.831529>, 
      <1.106238, -1.856659, -2.110677>, <1.106238, -1.797841, -1.998063>, <1.106238, -1.641259, -1.874502>, <1.106238, -1.545194, -1.791359>, 
      <1.035867, -1.899911, -2.087925>, <1.035867, -1.834780, -1.960487>, <1.035867, -1.681235, -1.846376>, <1.035867, -1.573848, -1.751769>, 
      <0.990149, -1.916907, -2.078985>, <0.990149, -1.851776, -1.951547>, <0.990149, -1.692494, -1.830820>, <0.990149, -1.585107, -1.736213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -1.708639, -2.188540>, <0.990149, -1.656055, -2.090800>, <0.990149, -1.531778, -1.998633>, <0.990149, -1.447133, -1.926845>, 
      <1.035867, -1.725634, -2.179600>, <1.035867, -1.673050, -2.081859>, <1.035867, -1.543037, -1.983077>, <1.035867, -1.458392, -1.911289>, 
      <1.106238, -1.768887, -2.156847>, <1.106238, -1.710070, -2.044234>, <1.106238, -1.583112, -1.954842>, <1.106238, -1.487046, -1.871699>, 
      <1.106238, -1.812773, -2.133762>, <1.106238, -1.753955, -2.021148>, <1.106238, -1.612185, -1.914672>, <1.106238, -1.516120, -1.831529>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.665484, -2.211241>, <0.710028, -1.615449, -2.119687>, <0.710028, -1.498422, -2.033468>, <0.710028, -1.418543, -1.966347>, 
      <0.795328, -1.665484, -2.211241>, <0.795328, -1.615449, -2.119687>, <0.795328, -1.498422, -2.033468>, <0.795328, -1.418543, -1.966347>, 
      <0.911505, -1.679404, -2.203919>, <0.911505, -1.626820, -2.106178>, <0.911505, -1.512410, -2.025393>, <0.911505, -1.427765, -1.953605>, 
      <0.990149, -1.708639, -2.188540>, <0.990149, -1.656055, -2.090800>, <0.990149, -1.531778, -1.998633>, <0.990149, -1.447133, -1.926845>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.665484, -2.211241>, <0.624728, -1.665484, -2.211241>, <0.508550, -1.679404, -2.203919>, <0.429906, -1.708639, -2.188540>, 
      <0.710028, -1.615449, -2.119687>, <0.624728, -1.615449, -2.119687>, <0.508550, -1.626820, -2.106179>, <0.429906, -1.656055, -2.090800>, 
      <0.710028, -1.498422, -2.033468>, <0.624728, -1.498422, -2.033468>, <0.508550, -1.512410, -2.025393>, <0.429906, -1.531778, -1.998633>, 
      <0.710028, -1.418543, -1.966347>, <0.624728, -1.418543, -1.966347>, <0.508550, -1.427765, -1.953605>, <0.429906, -1.447133, -1.926845>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313817, -1.854983, -2.480324>, <0.313817, -1.833662, -2.377780>, <0.313817, -1.861261, -2.226599>, <0.313817, -1.812773, -2.133762>, 
      <0.313817, -1.805690, -2.474932>, <0.313817, -1.784369, -2.372388>, <0.313817, -1.817375, -2.249684>, <0.313817, -1.768887, -2.156847>, 
      <0.384188, -1.757108, -2.469617>, <0.384188, -1.739100, -2.387407>, <0.384188, -1.765508, -2.253714>, <0.384188, -1.725634, -2.179600>, 
      <0.429906, -1.738019, -2.467529>, <0.429906, -1.720011, -2.385319>, <0.429906, -1.748512, -2.262654>, <0.429906, -1.708639, -2.188540>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.429906, -1.971948, -2.493118>, <0.429906, -1.947820, -2.370130>, <0.429906, -1.973945, -2.190587>, <0.429906, -1.916907, -2.078985>, 
      <0.384188, -1.952858, -2.491030>, <0.384188, -1.928730, -2.368042>, <0.384188, -1.956949, -2.199527>, <0.384188, -1.899912, -2.087925>, 
      <0.313817, -1.904276, -2.485716>, <0.313817, -1.882956, -2.383172>, <0.313817, -1.905147, -2.203514>, <0.313817, -1.856659, -2.110677>, 
      <0.313817, -1.854983, -2.480324>, <0.313817, -1.833662, -2.377780>, <0.313817, -1.861261, -2.226599>, <0.313817, -1.812773, -2.133762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -2.020421, -2.498421>, <0.710028, -1.995289, -2.366930>, <0.710028, -2.020630, -2.175670>, <0.710028, -1.960063, -2.056284>, 
      <0.624728, -2.020421, -2.498421>, <0.624728, -1.995289, -2.366930>, <0.624728, -2.020630, -2.175670>, <0.624728, -1.960063, -2.056284>, 
      <0.508550, -2.004786, -2.496710>, <0.508550, -1.980658, -2.373722>, <0.508550, -2.003181, -2.175208>, <0.508550, -1.946143, -2.063606>, 
      <0.429906, -1.971948, -2.493118>, <0.429906, -1.947820, -2.370130>, <0.429906, -1.973945, -2.190587>, <0.429906, -1.916907, -2.078985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -1.971948, -2.493118>, <0.990149, -1.947820, -2.370130>, <0.990149, -1.973945, -2.190587>, <0.990149, -1.916907, -2.078985>, 
      <0.911505, -2.004786, -2.496710>, <0.911505, -1.980658, -2.373722>, <0.911505, -2.003181, -2.175208>, <0.911505, -1.946143, -2.063606>, 
      <0.795328, -2.020421, -2.498421>, <0.795328, -1.995289, -2.366930>, <0.795328, -2.020630, -2.175670>, <0.795328, -1.960063, -2.056284>, 
      <0.710028, -2.020421, -2.498421>, <0.710028, -1.995289, -2.366930>, <0.710028, -2.020630, -2.175670>, <0.710028, -1.960063, -2.056284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106238, -1.854983, -2.480324>, <1.106238, -1.833662, -2.377780>, <1.106238, -1.861261, -2.226599>, <1.106238, -1.812773, -2.133762>, 
      <1.106238, -1.904276, -2.485716>, <1.106238, -1.882956, -2.383172>, <1.106238, -1.905147, -2.203514>, <1.106238, -1.856659, -2.110677>, 
      <1.035867, -1.952858, -2.491030>, <1.035867, -1.928730, -2.368042>, <1.035867, -1.956949, -2.199527>, <1.035867, -1.899911, -2.087925>, 
      <0.990149, -1.971948, -2.493118>, <0.990149, -1.947820, -2.370130>, <0.990149, -1.973945, -2.190587>, <0.990149, -1.916907, -2.078985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -1.738019, -2.467529>, <0.990149, -1.720011, -2.385319>, <0.990149, -1.748512, -2.262654>, <0.990149, -1.708639, -2.188540>, 
      <1.035867, -1.757108, -2.469617>, <1.035867, -1.739100, -2.387407>, <1.035867, -1.765508, -2.253714>, <1.035867, -1.725634, -2.179600>, 
      <1.106238, -1.805690, -2.474932>, <1.106238, -1.784369, -2.372388>, <1.106238, -1.817375, -2.249684>, <1.106238, -1.768887, -2.156847>, 
      <1.106238, -1.854983, -2.480324>, <1.106238, -1.833662, -2.377780>, <1.106238, -1.861261, -2.226599>, <1.106238, -1.812773, -2.133762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.689546, -2.462226>, <0.710028, -1.673048, -2.388406>, <0.710028, -1.701759, -2.277616>, <0.710028, -1.665484, -2.211241>, 
      <0.795328, -1.689546, -2.462226>, <0.795328, -1.673048, -2.388406>, <0.795328, -1.701759, -2.277616>, <0.795328, -1.665484, -2.211241>, 
      <0.911505, -1.705181, -2.463937>, <0.911505, -1.687173, -2.381727>, <0.911505, -1.719277, -2.278033>, <0.911505, -1.679404, -2.203919>, 
      <0.990149, -1.738019, -2.467529>, <0.990149, -1.720011, -2.385319>, <0.990149, -1.748512, -2.262654>, <0.990149, -1.708639, -2.188540>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.689546, -2.462226>, <0.624728, -1.689546, -2.462226>, <0.508550, -1.705181, -2.463937>, <0.429906, -1.738019, -2.467529>, 
      <0.710028, -1.673048, -2.388406>, <0.624728, -1.673048, -2.388406>, <0.508550, -1.687173, -2.381727>, <0.429906, -1.720011, -2.385319>, 
      <0.710028, -1.701759, -2.277616>, <0.624728, -1.701759, -2.277616>, <0.508550, -1.719277, -2.278033>, <0.429906, -1.748512, -2.262654>, 
      <0.710028, -1.665484, -2.211241>, <0.624728, -1.665484, -2.211241>, <0.508550, -1.679404, -2.203919>, <0.429906, -1.708639, -2.188540>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313817, -1.944581, -2.767704>, <0.313817, -1.892580, -2.693872>, <0.313817, -1.873366, -2.568740>, <0.313817, -1.854983, -2.480324>, 
      <0.313817, -1.905218, -2.797861>, <0.313817, -1.853217, -2.724029>, <0.313817, -1.824073, -2.563348>, <0.313817, -1.805690, -2.474932>, 
      <0.384188, -1.866423, -2.827583>, <0.384188, -1.800587, -2.731382>, <0.384188, -1.782052, -2.583490>, <0.384188, -1.757108, -2.469617>, 
      <0.429906, -1.851179, -2.839262>, <0.429906, -1.785343, -2.743061>, <0.429906, -1.762963, -2.581402>, <0.429906, -1.738019, -2.467529>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.429906, -2.037983, -2.696146>, <0.429906, -1.999878, -2.644665>, <0.429906, -1.984278, -2.555969>, <0.429906, -1.971948, -2.493118>, 
      <0.384188, -2.022739, -2.707825>, <0.384188, -1.984634, -2.656343>, <0.384188, -1.965189, -2.553881>, <0.384188, -1.952858, -2.491030>, 
      <0.313817, -1.983944, -2.737547>, <0.313817, -1.931943, -2.663715>, <0.313817, -1.922660, -2.574132>, <0.313817, -1.904276, -2.485716>, 
      <0.313817, -1.944581, -2.767704>, <0.313817, -1.892580, -2.693872>, <0.313817, -1.873366, -2.568740>, <0.313817, -1.854983, -2.480324>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -2.076692, -2.666492>, <0.710028, -2.044384, -2.624261>, <0.710028, -2.030403, -2.550648>, <0.710028, -2.020421, -2.498421>, 
      <0.624728, -2.076692, -2.666492>, <0.624728, -2.044384, -2.624261>, <0.624728, -2.030403, -2.550648>, <0.624728, -2.020421, -2.498421>, 
      <0.508550, -2.064206, -2.676056>, <0.508550, -2.026101, -2.624575>, <0.508550, -2.017116, -2.559561>, <0.508550, -2.004786, -2.496710>, 
      <0.429906, -2.037983, -2.696146>, <0.429906, -1.999878, -2.644665>, <0.429906, -1.984278, -2.555969>, <0.429906, -1.971948, -2.493118>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -2.037983, -2.696146>, <0.990149, -1.999878, -2.644665>, <0.990149, -1.984278, -2.555969>, <0.990149, -1.971948, -2.493118>, 
      <0.911505, -2.064206, -2.676056>, <0.911505, -2.026101, -2.624575>, <0.911505, -2.017116, -2.559561>, <0.911505, -2.004786, -2.496710>, 
      <0.795328, -2.076692, -2.666492>, <0.795328, -2.044384, -2.624261>, <0.795328, -2.030403, -2.550648>, <0.795328, -2.020421, -2.498421>, 
      <0.710028, -2.076692, -2.666492>, <0.710028, -2.044384, -2.624261>, <0.710028, -2.030403, -2.550648>, <0.710028, -2.020421, -2.498421>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106238, -1.944581, -2.767704>, <1.106238, -1.892580, -2.693872>, <1.106238, -1.873366, -2.568740>, <1.106238, -1.854983, -2.480324>, 
      <1.106238, -1.983944, -2.737547>, <1.106238, -1.931943, -2.663715>, <1.106238, -1.922660, -2.574132>, <1.106238, -1.904276, -2.485716>, 
      <1.035867, -2.022739, -2.707825>, <1.035867, -1.984634, -2.656343>, <1.035867, -1.965189, -2.553881>, <1.035867, -1.952858, -2.491030>, 
      <0.990149, -2.037983, -2.696146>, <0.990149, -1.999878, -2.644665>, <0.990149, -1.984278, -2.555969>, <0.990149, -1.971948, -2.493118>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -1.851179, -2.839262>, <0.990149, -1.785343, -2.743061>, <0.990149, -1.762963, -2.581402>, <0.990149, -1.738019, -2.467529>, 
      <1.035867, -1.866423, -2.827583>, <1.035867, -1.800587, -2.731382>, <1.035867, -1.782052, -2.583490>, <1.035867, -1.757108, -2.469617>, 
      <1.106238, -1.905218, -2.797861>, <1.106238, -1.853217, -2.724029>, <1.106238, -1.824073, -2.563348>, <1.106238, -1.805690, -2.474932>, 
      <1.106238, -1.944581, -2.767704>, <1.106238, -1.892580, -2.693872>, <1.106238, -1.873366, -2.568740>, <1.106238, -1.854983, -2.480324>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.812471, -2.868917>, <0.710028, -1.740911, -2.763443>, <0.710028, -1.717347, -2.586616>, <0.710028, -1.689546, -2.462226>, 
      <0.795328, -1.812471, -2.868917>, <0.795328, -1.740911, -2.763443>, <0.795328, -1.717347, -2.586616>, <0.795328, -1.689546, -2.462226>, 
      <0.911505, -1.824956, -2.859352>, <0.911505, -1.759120, -2.763150>, <0.911505, -1.730125, -2.577809>, <0.911505, -1.705181, -2.463937>, 
      <0.990149, -1.851179, -2.839262>, <0.990149, -1.785343, -2.743061>, <0.990149, -1.762963, -2.581402>, <0.990149, -1.738019, -2.467529>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -1.812471, -2.868917>, <0.624728, -1.812471, -2.868917>, <0.508550, -1.824956, -2.859352>, <0.429906, -1.851179, -2.839262>, 
      <0.710028, -1.740911, -2.763443>, <0.624728, -1.740911, -2.763443>, <0.508550, -1.759120, -2.763150>, <0.429906, -1.785343, -2.743061>, 
      <0.710028, -1.717347, -2.586616>, <0.624728, -1.717347, -2.586616>, <0.508550, -1.730125, -2.577809>, <0.429906, -1.762963, -2.581402>, 
      <0.710028, -1.689546, -2.462226>, <0.624728, -1.689546, -2.462226>, <0.508550, -1.705181, -2.463937>, <0.429906, -1.738019, -2.467529>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313817, -2.158995, -2.911963>, <0.313817, -2.088174, -2.880419>, <0.313817, -1.989224, -2.831088>, <0.313817, -1.944581, -2.767704>, 
      <0.313817, -2.141519, -2.958369>, <0.313817, -2.070698, -2.926825>, <0.313817, -1.949861, -2.861245>, <0.313817, -1.905218, -2.797861>, 
      <0.384188, -2.124296, -3.004105>, <0.384188, -2.036091, -2.963948>, <0.384188, -1.921158, -2.907563>, <0.384188, -1.866423, -2.827583>, 
      <0.429906, -2.117528, -3.022076>, <0.429906, -2.029323, -2.981919>, <0.429906, -1.905914, -2.919242>, <0.429906, -1.851179, -2.839262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.429906, -2.200462, -2.801850>, <0.429906, -2.147058, -2.778839>, <0.429906, -2.072579, -2.742887>, <0.429906, -2.037983, -2.696146>, 
      <0.384188, -2.193694, -2.819821>, <0.384188, -2.140290, -2.796810>, <0.384188, -2.057335, -2.754565>, <0.384188, -2.022739, -2.707825>, 
      <0.313817, -2.176471, -2.865557>, <0.313817, -2.105650, -2.834013>, <0.313817, -2.028587, -2.800931>, <0.313817, -1.983944, -2.737547>, 
      <0.313817, -2.158995, -2.911963>, <0.313817, -2.088174, -2.880419>, <0.313817, -1.989224, -2.831088>, <0.313817, -1.944581, -2.767704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -2.217648, -2.756217>, <0.710028, -2.171475, -2.736703>, <0.710028, -2.107151, -2.706304>, <0.710028, -2.076692, -2.666492>, 
      <0.624728, -2.217648, -2.756217>, <0.624728, -2.171475, -2.736703>, <0.624728, -2.107151, -2.706304>, <0.624728, -2.076692, -2.666492>, 
      <0.508550, -2.212104, -2.770936>, <0.508550, -2.158700, -2.747925>, <0.508550, -2.098802, -2.722797>, <0.508550, -2.064206, -2.676056>, 
      <0.429906, -2.200462, -2.801850>, <0.429906, -2.147058, -2.778839>, <0.429906, -2.072579, -2.742887>, <0.429906, -2.037983, -2.696146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -2.200462, -2.801850>, <0.990149, -2.147058, -2.778839>, <0.990149, -2.072579, -2.742887>, <0.990149, -2.037983, -2.696146>, 
      <0.911505, -2.212104, -2.770936>, <0.911505, -2.158700, -2.747925>, <0.911505, -2.098802, -2.722797>, <0.911505, -2.064206, -2.676056>, 
      <0.795328, -2.217648, -2.756217>, <0.795328, -2.171475, -2.736703>, <0.795328, -2.107151, -2.706304>, <0.795328, -2.076692, -2.666492>, 
      <0.710028, -2.217648, -2.756217>, <0.710028, -2.171475, -2.736703>, <0.710028, -2.107151, -2.706304>, <0.710028, -2.076692, -2.666492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106238, -2.158995, -2.911963>, <1.106238, -2.088174, -2.880419>, <1.106238, -1.989224, -2.831088>, <1.106238, -1.944581, -2.767704>, 
      <1.106238, -2.176471, -2.865557>, <1.106238, -2.105650, -2.834013>, <1.106238, -2.028587, -2.800931>, <1.106238, -1.983944, -2.737547>, 
      <1.035867, -2.193694, -2.819821>, <1.035867, -2.140290, -2.796810>, <1.035867, -2.057335, -2.754565>, <1.035867, -2.022739, -2.707825>, 
      <0.990149, -2.200462, -2.801850>, <0.990149, -2.147058, -2.778839>, <0.990149, -2.072579, -2.742887>, <0.990149, -2.037983, -2.696146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -2.117528, -3.022076>, <0.990149, -2.029323, -2.981919>, <0.990149, -1.905914, -2.919242>, <0.990149, -1.851179, -2.839262>, 
      <1.035867, -2.124296, -3.004105>, <1.035867, -2.036091, -2.963948>, <1.035867, -1.921158, -2.907563>, <1.035867, -1.866423, -2.827583>, 
      <1.106238, -2.141519, -2.958369>, <1.106238, -2.070698, -2.926825>, <1.106238, -1.949861, -2.861245>, <1.106238, -1.905218, -2.797861>, 
      <1.106238, -2.158995, -2.911963>, <1.106238, -2.088174, -2.880419>, <1.106238, -1.989224, -2.831088>, <1.106238, -1.944581, -2.767704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -2.100343, -3.067710>, <0.710028, -2.004940, -3.023969>, <0.710028, -1.871395, -2.955767>, <0.710028, -1.812471, -2.868917>, 
      <0.795328, -2.100343, -3.067710>, <0.795328, -2.004940, -3.023969>, <0.795328, -1.871395, -2.955767>, <0.795328, -1.812471, -2.868917>, 
      <0.911505, -2.105886, -3.052990>, <0.911505, -2.017682, -3.012833>, <0.911505, -1.879691, -2.939332>, <0.911505, -1.824956, -2.859352>, 
      <0.990149, -2.117528, -3.022076>, <0.990149, -2.029323, -2.981919>, <0.990149, -1.905914, -2.919242>, <0.990149, -1.851179, -2.839262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -2.100343, -3.067710>, <0.624728, -2.100343, -3.067710>, <0.508550, -2.105886, -3.052990>, <0.429906, -2.117528, -3.022076>, 
      <0.710028, -2.004940, -3.023969>, <0.624728, -2.004940, -3.023969>, <0.508550, -2.017681, -3.012833>, <0.429906, -2.029323, -2.981919>, 
      <0.710028, -1.871395, -2.955767>, <0.624728, -1.871395, -2.955767>, <0.508550, -1.879691, -2.939332>, <0.429906, -1.905914, -2.919242>, 
      <0.710028, -1.812471, -2.868917>, <0.624728, -1.812471, -2.868917>, <0.508550, -1.824956, -2.859352>, <0.429906, -1.851179, -2.839262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313817, -2.420059, -2.979485>, <0.313817, -2.345840, -2.947301>, <0.313817, -2.232893, -2.944878>, <0.313817, -2.158995, -2.911963>, 
      <0.313817, -2.419008, -3.029061>, <0.313817, -2.344790, -2.996877>, <0.313817, -2.215417, -2.991283>, <0.313817, -2.141519, -2.958369>, 
      <0.384188, -2.417974, -3.077921>, <0.384188, -2.331396, -3.044557>, <0.384188, -2.208741, -3.042550>, <0.384188, -2.124296, -3.004105>, 
      <0.429906, -2.417567, -3.097120>, <0.429906, -2.330989, -3.063756>, <0.429906, -2.201973, -3.060521>, <0.429906, -2.117528, -3.022076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.429906, -2.422552, -2.861849>, <0.429906, -2.360155, -2.832357>, <0.429906, -2.263844, -2.829160>, <0.429906, -2.200462, -2.801850>, 
      <0.384188, -2.422145, -2.881048>, <0.384188, -2.359748, -2.851556>, <0.384188, -2.257076, -2.847131>, <0.384188, -2.193694, -2.819821>, 
      <0.313817, -2.421109, -2.929909>, <0.313817, -2.346891, -2.897725>, <0.313817, -2.250368, -2.898472>, <0.313817, -2.176471, -2.865557>, 
      <0.313817, -2.420059, -2.979485>, <0.313817, -2.345840, -2.947301>, <0.313817, -2.232893, -2.944878>, <0.313817, -2.158995, -2.911963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -2.423585, -2.813097>, <0.710028, -2.365954, -2.785048>, <0.710028, -2.276686, -2.781168>, <0.710028, -2.217648, -2.756217>, 
      <0.624728, -2.423585, -2.813097>, <0.624728, -2.365954, -2.785048>, <0.624728, -2.276686, -2.781168>, <0.624728, -2.217648, -2.756217>, 
      <0.508550, -2.423252, -2.828823>, <0.508550, -2.360855, -2.799331>, <0.508550, -2.275486, -2.798246>, <0.508550, -2.212104, -2.770936>, 
      <0.429906, -2.422552, -2.861849>, <0.429906, -2.360155, -2.832357>, <0.429906, -2.263844, -2.829160>, <0.429906, -2.200462, -2.801850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -2.422552, -2.861849>, <0.990149, -2.360155, -2.832357>, <0.990149, -2.263844, -2.829160>, <0.990149, -2.200462, -2.801850>, 
      <0.911505, -2.423252, -2.828823>, <0.911505, -2.360855, -2.799331>, <0.911505, -2.275486, -2.798246>, <0.911505, -2.212104, -2.770936>, 
      <0.795328, -2.423585, -2.813097>, <0.795328, -2.365954, -2.785048>, <0.795328, -2.276686, -2.781168>, <0.795328, -2.217648, -2.756217>, 
      <0.710028, -2.423585, -2.813097>, <0.710028, -2.365954, -2.785048>, <0.710028, -2.276686, -2.781168>, <0.710028, -2.217648, -2.756217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106238, -2.420059, -2.979485>, <1.106238, -2.345840, -2.947301>, <1.106238, -2.232893, -2.944878>, <1.106238, -2.158995, -2.911963>, 
      <1.106238, -2.421109, -2.929909>, <1.106238, -2.346891, -2.897725>, <1.106238, -2.250368, -2.898472>, <1.106238, -2.176471, -2.865557>, 
      <1.035867, -2.422145, -2.881048>, <1.035867, -2.359748, -2.851556>, <1.035867, -2.257076, -2.847131>, <1.035867, -2.193694, -2.819821>, 
      <0.990149, -2.422552, -2.861849>, <0.990149, -2.360155, -2.832357>, <0.990149, -2.263844, -2.829160>, <0.990149, -2.200462, -2.801850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -2.417567, -3.097120>, <0.990149, -2.330989, -3.063756>, <0.990149, -2.201973, -3.060521>, <0.990149, -2.117528, -3.022076>, 
      <1.035867, -2.417974, -3.077921>, <1.035867, -2.331396, -3.044557>, <1.035867, -2.208741, -3.042550>, <1.035867, -2.124296, -3.004105>, 
      <1.106238, -2.419008, -3.029061>, <1.106238, -2.344790, -2.996877>, <1.106238, -2.215417, -2.991283>, <1.106238, -2.141519, -2.958369>, 
      <1.106238, -2.420059, -2.979485>, <1.106238, -2.345840, -2.947301>, <1.106238, -2.232893, -2.944878>, <1.106238, -2.158995, -2.911963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -2.416533, -3.145872>, <0.710028, -2.324651, -3.112625>, <0.710028, -2.189165, -3.108433>, <0.710028, -2.100343, -3.067710>, 
      <0.795328, -2.416533, -3.145872>, <0.795328, -2.324651, -3.112625>, <0.795328, -2.189165, -3.108433>, <0.795328, -2.100343, -3.067710>, 
      <0.911505, -2.416867, -3.130146>, <0.911505, -2.330289, -3.096782>, <0.911505, -2.190331, -3.091435>, <0.911505, -2.105886, -3.052990>, 
      <0.990149, -2.417567, -3.097120>, <0.990149, -2.330989, -3.063756>, <0.990149, -2.201973, -3.060521>, <0.990149, -2.117528, -3.022076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -2.416533, -3.145872>, <0.624728, -2.416533, -3.145872>, <0.508550, -2.416867, -3.130146>, <0.429906, -2.417567, -3.097120>, 
      <0.710028, -2.324651, -3.112625>, <0.624728, -2.324651, -3.112625>, <0.508550, -2.330289, -3.096782>, <0.429906, -2.330989, -3.063756>, 
      <0.710028, -2.189165, -3.108433>, <0.624728, -2.189165, -3.108433>, <0.508550, -2.190331, -3.091435>, <0.429906, -2.201973, -3.060521>, 
      <0.710028, -2.100343, -3.067710>, <0.624728, -2.100343, -3.067710>, <0.508550, -2.105886, -3.052990>, <0.429906, -2.117528, -3.022076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313817, -2.724182, -3.157047>, <0.313817, -2.650471, -3.081361>, <0.313817, -2.516987, -3.021516>, <0.313817, -2.420059, -2.979485>, 
      <0.313817, -2.681465, -3.182230>, <0.313817, -2.607754, -3.106544>, <0.313817, -2.515937, -3.071092>, <0.313817, -2.419008, -3.029061>, 
      <0.384188, -2.639364, -3.207048>, <0.355452, -2.590661, -3.163654>, <0.384188, -2.484485, -3.103553>, <0.384188, -2.417974, -3.077921>, 
      <0.429906, -2.622821, -3.216800>, <0.401170, -2.574119, -3.173406>, <0.429906, -2.484078, -3.122751>, <0.429906, -2.417567, -3.097120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.429906, -2.825541, -3.097292>, <0.397242, -2.729269, -3.001013>, <0.429906, -2.549142, -2.921681>, <0.429906, -2.422552, -2.861849>, 
      <0.384188, -2.808998, -3.107044>, <0.351524, -2.712726, -3.010765>, <0.384188, -2.548735, -2.940881>, <0.384188, -2.422145, -2.881048>, 
      <0.313817, -2.766899, -3.131865>, <0.313817, -2.693188, -3.056178>, <0.313817, -2.518038, -2.971940>, <0.313817, -2.421109, -2.929909>, 
      <0.313817, -2.724182, -3.157047>, <0.313817, -2.650471, -3.081361>, <0.313817, -2.516987, -3.021516>, <0.313817, -2.420059, -2.979485>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -2.867549, -3.072529>, <0.704953, -2.756620, -2.965450>, <0.710028, -2.562291, -2.880606>, <0.710028, -2.423585, -2.813097>, 
      <0.624728, -2.867549, -3.072529>, <0.619653, -2.756620, -2.965450>, <0.624728, -2.562291, -2.880606>, <0.624728, -2.423585, -2.813097>, 
      <0.508550, -2.853998, -3.080516>, <0.475886, -2.757726, -2.984236>, <0.508550, -2.549842, -2.888655>, <0.508550, -2.423252, -2.828823>, 
      <0.429906, -2.825541, -3.097292>, <0.397242, -2.729269, -3.001013>, <0.429906, -2.549142, -2.921681>, <0.429906, -2.422552, -2.861849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -2.825541, -3.097292>, <1.018479, -2.725255, -3.003777>, <0.990149, -2.549142, -2.921681>, <0.990149, -2.422552, -2.861849>, 
      <0.911505, -2.853998, -3.080516>, <0.939835, -2.753711, -2.987001>, <0.911505, -2.549842, -2.888655>, <0.911505, -2.423252, -2.828823>, 
      <0.795328, -2.867549, -3.072529>, <0.790253, -2.756620, -2.965450>, <0.795328, -2.562291, -2.880606>, <0.795328, -2.423585, -2.813097>, 
      <0.710028, -2.867549, -3.072529>, <0.704953, -2.756620, -2.965450>, <0.710028, -2.562291, -2.880606>, <0.710028, -2.423585, -2.813097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106238, -2.724182, -3.157047>, <1.106238, -2.650471, -3.081361>, <1.106238, -2.516987, -3.021516>, <1.106238, -2.420059, -2.979485>, 
      <1.106238, -2.766899, -3.131865>, <1.106238, -2.693188, -3.056178>, <1.106238, -2.518038, -2.971940>, <1.106238, -2.421109, -2.929909>, 
      <1.035867, -2.808998, -3.107044>, <1.064197, -2.708712, -3.013529>, <1.035867, -2.548735, -2.940881>, <1.035867, -2.422145, -2.881048>, 
      <0.990149, -2.825541, -3.097292>, <1.018479, -2.725255, -3.003777>, <0.990149, -2.549142, -2.921681>, <0.990149, -2.422552, -2.861849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.990149, -2.622821, -3.216800>, <1.018578, -2.574761, -3.172497>, <0.990149, -2.484078, -3.122751>, <0.990149, -2.417567, -3.097120>, 
      <1.035867, -2.639364, -3.207048>, <1.064296, -2.591304, -3.162745>, <1.035867, -2.484485, -3.103553>, <1.035867, -2.417974, -3.077921>, 
      <1.106238, -2.681465, -3.182230>, <1.106238, -2.607754, -3.106544>, <1.106238, -2.515937, -3.071092>, <1.106238, -2.419008, -3.029061>, 
      <1.106238, -2.724182, -3.157047>, <1.106238, -2.650471, -3.081361>, <1.106238, -2.516987, -3.021516>, <1.106238, -2.420059, -2.979485>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -2.580815, -3.241564>, <0.709310, -2.537291, -3.204710>, <0.710028, -2.470166, -3.165279>, <0.710028, -2.416533, -3.145872>, 
      <0.795328, -2.580815, -3.241564>, <0.794610, -2.537291, -3.204710>, <0.795328, -2.470166, -3.165279>, <0.795328, -2.416533, -3.145872>, 
      <0.911505, -2.594364, -3.233576>, <0.939934, -2.546304, -3.189273>, <0.911505, -2.483379, -3.155778>, <0.911505, -2.416867, -3.130146>, 
      <0.990149, -2.622821, -3.216800>, <1.018578, -2.574761, -3.172497>, <0.990149, -2.484078, -3.122751>, <0.990149, -2.417567, -3.097120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.710028, -2.580815, -3.241564>, <0.624728, -2.580815, -3.241564>, <0.508550, -2.594364, -3.233576>, <0.429906, -2.622821, -3.216800>, 
      <0.709310, -2.537291, -3.204710>, <0.624010, -2.537291, -3.204710>, <0.479815, -2.545662, -3.190182>, <0.401170, -2.574119, -3.173406>, 
      <0.710028, -2.470166, -3.165279>, <0.624728, -2.470166, -3.165279>, <0.508550, -2.483379, -3.155778>, <0.429906, -2.484078, -3.122751>, 
      <0.710028, -2.416533, -3.145872>, <0.624728, -2.416533, -3.145872>, <0.508550, -2.416867, -3.130146>, <0.429906, -2.417567, -3.097120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313817, -2.925394, -3.498362>, <0.340612, -2.864708, -3.399733>, <0.313817, -2.807112, -3.242200>, <0.313817, -2.724182, -3.157047>, 
      <0.390870, -2.863526, -3.576467>, <0.417665, -2.802840, -3.477838>, <0.313817, -2.764395, -3.267382>, <0.313817, -2.681465, -3.182230>, 
      <0.606484, -2.928421, -3.528213>, <0.655326, -2.835643, -3.403740>, <0.449798, -2.750563, -3.306127>, <0.384188, -2.639364, -3.207048>, 
      <0.730377, -2.926818, -3.550866>, <0.779219, -2.834040, -3.426393>, <0.495517, -2.734020, -3.315879>, <0.429906, -2.622821, -3.216800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313817, -2.925394, -3.498362>, <0.253336, -2.973956, -3.437055>, <0.535581, -2.979209, -3.463550>, <0.628700, -3.008458, -3.447800>, 
      <0.340612, -2.864708, -3.399733>, <0.280132, -2.913270, -3.338427>, <0.575627, -2.922574, -3.350352>, <0.668746, -2.951822, -3.334602>, 
      <0.313817, -2.807112, -3.242200>, <0.313817, -2.849829, -3.217017>, <0.415159, -2.900279, -3.198333>, <0.460877, -2.916822, -3.188580>, 
      <0.313817, -2.724182, -3.157047>, <0.313817, -2.766899, -3.131865>, <0.384188, -2.808998, -3.107044>, <0.429906, -2.825541, -3.097292>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313817, -2.925394, -3.498362>, <0.253336, -2.973956, -3.437055>, <0.535581, -2.979209, -3.463550>, <0.628700, -3.008458, -3.447800>, 
      <0.313817, -2.925394, -3.498362>, <0.330389, -2.912087, -3.515160>, <0.566084, -2.954717, -3.494470>, <0.659203, -2.983966, -3.478720>, 
      <0.313817, -2.925394, -3.498362>, <0.330389, -2.912087, -3.515160>, <0.575981, -2.952913, -3.497293>, <0.699874, -2.951310, -3.519946>, 
      <0.313817, -2.925394, -3.498362>, <0.390870, -2.863526, -3.576467>, <0.606484, -2.928421, -3.528213>, <0.730377, -2.926818, -3.550866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.739096, -3.058973, -3.426432>, <0.739137, -3.020851, -3.311572>, <0.714009, -2.954575, -3.156534>, <0.710028, -2.867549, -3.072529>, 
      <0.703063, -3.050652, -3.426432>, <0.703104, -3.012530, -3.311572>, <0.628709, -2.954575, -3.156534>, <0.624728, -2.867549, -3.072529>, 
      <0.663531, -3.019398, -3.441908>, <0.703577, -2.962762, -3.328711>, <0.539521, -2.945279, -3.171804>, <0.508550, -2.853998, -3.080516>, 
      <0.628700, -3.008458, -3.447800>, <0.668746, -2.951822, -3.334602>, <0.460877, -2.916822, -3.188580>, <0.429906, -2.825541, -3.097292>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.739096, -3.058973, -3.426432>, <0.761604, -3.064171, -3.426432>, <0.791286, -3.058701, -3.443617>, <0.812636, -3.050933, -3.447800>, 
      <0.739137, -3.020851, -3.311572>, <0.761645, -3.026049, -3.311572>, <0.787331, -2.992285, -3.325133>, <0.808681, -2.984517, -3.329316>, 
      <0.714009, -2.954575, -3.156534>, <0.799310, -2.954575, -3.156534>, <0.884011, -2.951325, -3.171272>, <0.962655, -2.922868, -3.188048>, 
      <0.710028, -2.867549, -3.072529>, <0.795328, -2.867549, -3.072529>, <0.911505, -2.853998, -3.080516>, <0.990149, -2.825541, -3.097292>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106238, -2.925394, -3.498362>, <1.112601, -2.858887, -3.400052>, <1.106238, -2.807112, -3.242200>, <1.106238, -2.724182, -3.157047>, 
      <1.159115, -2.991056, -3.450412>, <1.165478, -2.924550, -3.352103>, <1.106238, -2.849829, -3.217017>, <1.106238, -2.766899, -3.131865>, 
      <0.902272, -3.018320, -3.465361>, <0.898317, -2.951904, -3.346877>, <1.008372, -2.906326, -3.197800>, <1.035867, -2.808998, -3.107044>, 
      <0.812636, -3.050933, -3.447800>, <0.808681, -2.984517, -3.329316>, <0.962655, -2.922868, -3.188048>, <0.990149, -2.825541, -3.097292>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106238, -2.925394, -3.498362>, <1.039028, -2.841933, -3.559309>, <0.820064, -2.911428, -3.527778>, <0.698978, -2.909794, -3.550866>, 
      <1.112601, -2.858887, -3.400052>, <1.045390, -2.775427, -3.460999>, <0.815717, -2.812001, -3.404565>, <0.694631, -2.810367, -3.427653>, 
      <1.106238, -2.807112, -3.242200>, <1.106238, -2.764395, -3.267382>, <0.972696, -2.746156, -3.305490>, <0.926978, -2.729613, -3.315243>, 
      <1.106238, -2.724182, -3.157047>, <1.106238, -2.681465, -3.182230>, <1.035867, -2.639364, -3.207048>, <0.990149, -2.622821, -3.216800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106238, -2.925394, -3.498362>, <1.039028, -2.841933, -3.559309>, <0.820064, -2.911428, -3.527778>, <0.698978, -2.909794, -3.550866>, 
      <1.106238, -2.925394, -3.498362>, <1.091905, -2.907595, -3.511360>, <0.854161, -2.953769, -3.496858>, <0.733075, -2.952136, -3.519946>, 
      <1.106238, -2.925394, -3.498362>, <1.091905, -2.907595, -3.511360>, <0.868175, -2.975978, -3.496281>, <0.778539, -3.008591, -3.478720>, 
      <1.106238, -2.925394, -3.498362>, <1.159115, -2.991056, -3.450412>, <0.902272, -3.018320, -3.465361>, <0.812636, -3.050933, -3.447800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.718333, -2.920160, -3.572324>, <0.718378, -2.802619, -3.492322>, <0.711817, -2.689316, -3.333438>, <0.710028, -2.580815, -3.241564>, 
      <0.710236, -2.915770, -3.572324>, <0.710281, -2.798229, -3.492322>, <0.797117, -2.689316, -3.333438>, <0.795328, -2.580815, -3.241564>, 
      <0.689932, -2.909672, -3.552591>, <0.685585, -2.810245, -3.429378>, <0.848334, -2.701156, -3.332019>, <0.911505, -2.594364, -3.233576>, 
      <0.698978, -2.909794, -3.550866>, <0.694631, -2.810367, -3.427653>, <0.926978, -2.729613, -3.315243>, <0.990149, -2.622821, -3.216800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.718333, -2.920160, -3.572324>, <0.725056, -2.923805, -3.572324>, <0.737899, -2.926721, -3.552241>, <0.730377, -2.926818, -3.550866>, 
      <0.718378, -2.802619, -3.492322>, <0.725101, -2.806264, -3.492322>, <0.786741, -2.833943, -3.427768>, <0.779219, -2.834040, -3.426393>, 
      <0.711817, -2.689316, -3.333438>, <0.626517, -2.689316, -3.333438>, <0.574161, -2.705564, -3.332655>, <0.495517, -2.734020, -3.315879>, 
      <0.710028, -2.580815, -3.241564>, <0.624728, -2.580815, -3.241564>, <0.508550, -2.594364, -3.233576>, <0.429906, -2.622821, -3.216800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012559, -3.406472, -4.265924>, <0.102936, -3.262149, -4.035656>, <0.249255, -3.071613, -3.736002>, <0.313817, -2.925394, -3.498362>, 
      <0.012773, -3.405265, -4.266952>, <0.103150, -3.260942, -4.036684>, <0.326308, -3.009745, -3.814107>, <0.390870, -2.863526, -3.576467>, 
      <0.016119, -3.406090, -4.266983>, <0.230128, -3.261291, -4.052918>, <0.505783, -3.119705, -3.784846>, <0.606484, -2.928421, -3.528213>, 
      <0.017644, -3.405927, -4.267437>, <0.231654, -3.261127, -4.053372>, <0.629676, -3.118102, -3.807499>, <0.730377, -2.926818, -3.550866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012559, -3.406472, -4.265924>, <0.012773, -3.405265, -4.266952>, <0.016119, -3.406090, -4.266983>, <0.017644, -3.405927, -4.267437>, 
      <0.012559, -3.406472, -4.265924>, <0.012549, -3.406529, -4.265875>, <0.015217, -3.406700, -4.267885>, <0.016743, -3.406537, -4.268339>, 
      <0.012559, -3.406472, -4.265924>, <0.012549, -3.406529, -4.265875>, <0.014890, -3.409090, -4.265920>, <0.016227, -3.409993, -4.265466>, 
      <0.012559, -3.406472, -4.265924>, <0.012335, -3.407736, -4.264847>, <0.015678, -3.408578, -4.264864>, <0.017014, -3.409481, -4.264410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012559, -3.406472, -4.265924>, <0.012335, -3.407736, -4.264847>, <0.015678, -3.408578, -4.264864>, <0.017014, -3.409481, -4.264410>, 
      <0.102936, -3.262149, -4.035656>, <0.102712, -3.263413, -4.034579>, <0.198892, -3.289404, -4.019110>, <0.200228, -3.290307, -4.018656>, 
      <0.249255, -3.071613, -3.736002>, <0.188775, -3.120175, -3.674695>, <0.436375, -3.119513, -3.743974>, <0.529494, -3.148762, -3.728224>, 
      <0.313817, -2.925394, -3.498362>, <0.253336, -2.973956, -3.437055>, <0.535581, -2.979209, -3.463550>, <0.628700, -3.008458, -3.447800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.032903, -3.490721, -4.290140>, <1.054904, -3.321123, -4.052606>, <1.090570, -3.089163, -3.740444>, <1.106238, -2.925394, -3.498362>, 
      <1.033398, -3.491560, -4.289318>, <1.055399, -3.321962, -4.051784>, <1.143447, -3.154825, -3.692495>, <1.159115, -2.991056, -3.450412>, 
      <1.030814, -3.492545, -4.289065>, <0.966238, -3.360879, -4.036117>, <0.910783, -3.161226, -3.720301>, <0.902272, -3.018320, -3.465361>, 
      <1.029918, -3.493327, -4.288604>, <0.965343, -3.361660, -4.035656>, <0.821147, -3.193839, -3.702740>, <0.812636, -3.050933, -3.447800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.032903, -3.490721, -4.290140>, <1.033398, -3.491560, -4.289318>, <1.030814, -3.492545, -4.289065>, <1.029918, -3.493327, -4.288604>, 
      <1.032903, -3.490721, -4.290140>, <1.032804, -3.490553, -4.290305>, <1.031129, -3.493188, -4.290301>, <1.030234, -3.493970, -4.289840>, 
      <1.032903, -3.490721, -4.290140>, <1.032804, -3.490553, -4.290305>, <1.029993, -3.491188, -4.292273>, <1.028543, -3.491030, -4.292734>, 
      <1.032903, -3.490721, -4.290140>, <1.032309, -3.489715, -4.291128>, <1.029519, -3.490352, -4.291216>, <1.028069, -3.490194, -4.291677>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.032903, -3.490721, -4.290140>, <1.032309, -3.489715, -4.291128>, <1.029519, -3.490352, -4.291216>, <1.028069, -3.490194, -4.291677>, 
      <1.054904, -3.321123, -4.052606>, <1.054310, -3.320117, -4.053594>, <0.930253, -3.315321, -4.069930>, <0.928803, -3.315163, -4.070392>, 
      <1.090570, -3.089163, -3.740444>, <1.023360, -3.005702, -3.801391>, <0.828272, -3.099184, -3.760452>, <0.707186, -3.097550, -3.783540>, 
      <1.106238, -2.925394, -3.498362>, <1.039028, -2.841933, -3.559309>, <0.820064, -2.911428, -3.527778>, <0.698978, -2.909794, -3.550866>
    }
  }
  texture {
    TongueRed
    // Transform to world space
    translate <-139.304316, -98.322123, -103.000000>
    rotate z*-145.960693
    rotate y*-4.570000
    rotate x*-80.300003
    scale <1.0/8.000000, 1.0/8.000000, 1.0/8.000000>
  }
}
#declare Head = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.383769, -2.156188, -1.364696>, <0.388713, -2.087926, -1.314766>, <0.411449, -1.980890, -1.276610>, <0.413971, -1.907457, -1.234439>, 
      <0.546797, -2.168630, -1.342299>, <0.551741, -2.100368, -1.292368>, <0.557754, -1.989872, -1.266816>, <0.560276, -1.916439, -1.224645>, 
      <0.770837, -2.168630, -1.342299>, <0.765892, -2.100368, -1.292368>, <0.759879, -1.989872, -1.266816>, <0.757357, -1.916439, -1.224645>, 
      <0.933864, -2.156188, -1.364696>, <0.928920, -2.087926, -1.314766>, <0.906184, -1.980890, -1.276610>, <0.903662, -1.907457, -1.234439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.938350, -2.386375, -1.584745>, <0.771223, -2.393311, -1.572477>, <0.546410, -2.393311, -1.572477>, <0.379283, -2.386375, -1.584745>, 
      <0.937703, -2.318281, -1.517728>, <0.770576, -2.325217, -1.505460>, <0.547057, -2.325217, -1.505460>, <0.379930, -2.318281, -1.517728>, 
      <0.939440, -2.233172, -1.421006>, <0.776413, -2.245615, -1.398609>, <0.541220, -2.245615, -1.398609>, <0.378193, -2.233172, -1.421006>, 
      <0.933864, -2.156188, -1.364696>, <0.770837, -2.168630, -1.342299>, <0.546797, -2.168630, -1.342299>, <0.383769, -2.156188, -1.364696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.938350, -2.386375, -1.584745>, <0.771223, -2.393311, -1.572477>, <0.546410, -2.393311, -1.572477>, <0.379283, -2.386375, -1.584745>, 
      <0.939049, -2.459870, -1.657077>, <0.771922, -2.466806, -1.644808>, <0.545711, -2.466806, -1.644808>, <0.378584, -2.459870, -1.657077>, 
      <0.918404, -2.553949, -1.760297>, <0.752073, -2.572162, -1.771795>, <0.559107, -2.571085, -1.771397>, <0.392776, -2.552872, -1.759899>, 
      <0.938350, -2.628094, -1.829134>, <0.772019, -2.646307, -1.840632>, <0.545614, -2.646307, -1.840632>, <0.379283, -2.628094, -1.829134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.315694, -2.847373, -1.540558>, <0.297124, -2.858982, -1.581279>, <0.272365, -2.874462, -1.635573>, <0.253795, -2.886071, -1.676294>, 
      <0.502287, -2.847678, -1.540136>, <0.483718, -2.859288, -1.580856>, <0.508082, -2.874157, -1.635996>, <0.489513, -2.885766, -1.676717>, 
      <0.754579, -2.838858, -1.504459>, <0.806337, -2.841553, -1.514266>, <0.773248, -2.874360, -1.635714>, <0.803802, -2.885360, -1.677280>, 
      <0.937672, -2.848390, -1.539150>, <0.989430, -2.851084, -1.548957>, <1.008966, -2.874056, -1.636137>, <1.039520, -2.885055, -1.677703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.055377, -2.794911, -1.941261>, <1.062238, -2.857911, -1.886585>, <1.044277, -2.858012, -1.756770>, <1.039520, -2.885055, -1.677703>, 
      <0.820606, -2.847486, -1.978092>, <0.827467, -2.910486, -1.923416>, <0.808560, -2.858316, -1.756348>, <0.803802, -2.885360, -1.677280>, 
      <0.478002, -2.833734, -1.978499>, <0.455818, -2.896499, -1.924027>, <0.486658, -2.853026, -1.756207>, <0.489513, -2.885766, -1.676717>, 
      <0.244281, -2.776936, -1.941261>, <0.222098, -2.839701, -1.886789>, <0.250941, -2.853331, -1.755784>, <0.253795, -2.886071, -1.676294>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.326600, -2.680077, -1.855070>, <0.281159, -2.685832, -1.860055>, <0.256163, -2.743316, -1.970439>, <0.244281, -2.776936, -1.941261>, 
      <0.530899, -2.654203, -1.832657>, <0.485458, -2.659958, -1.837642>, <0.489884, -2.800114, -2.007677>, <0.478002, -2.833734, -1.978499>, 
      <0.813847, -2.647037, -1.832443>, <0.857579, -2.653928, -1.837615>, <0.816953, -2.813936, -2.007209>, <0.820606, -2.847486, -1.978092>, 
      <1.017087, -2.679062, -1.856480>, <1.060819, -2.685953, -1.861652>, <1.051723, -2.761361, -1.970378>, <1.055377, -2.794911, -1.941261>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.326600, -2.680077, -1.855070>, <0.530899, -2.654203, -1.832657>, <0.813847, -2.647037, -1.832443>, <1.017087, -2.679062, -1.856480>, 
      <0.342405, -2.664482, -1.847289>, <0.546704, -2.638608, -1.824877>, <0.790226, -2.631747, -1.824239>, <0.993466, -2.663771, -1.848276>, 
      <0.376205, -2.645256, -1.844930>, <0.542536, -2.663469, -1.856428>, <0.777688, -2.667381, -1.860197>, <0.944019, -2.649168, -1.848699>, 
      <0.379283, -2.628094, -1.829134>, <0.545614, -2.646307, -1.840632>, <0.772019, -2.646307, -1.840632>, <0.938350, -2.628094, -1.829134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.615159, -1.159661, 1.734230>, <0.844186, -1.159661, 1.734230>, <1.147331, -1.110967, 1.734230>, <1.375405, -1.090098, 1.734230>, 
      <0.615159, -1.159661, 1.734230>, <0.835343, -1.099059, 1.912344>, <0.915508, -1.045223, 1.901441>, <1.143582, -1.024354, 1.901441>, 
      <0.615159, -1.159661, 1.734230>, <0.835343, -1.099059, 1.912344>, <0.842496, -1.031046, 1.961573>, <0.834484, -0.936695, 2.124389>, 
      <0.615159, -1.159661, 1.734230>, <0.606317, -1.099059, 1.912344>, <0.610672, -0.965302, 2.128784>, <0.602660, -0.870951, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.617679, -0.038500, -2.963660>, <0.509961, -0.143431, -2.978737>, <0.584294, -0.389026, -2.944339>, <0.569986, -0.539251, -2.936058>, 
      <0.642362, -0.038500, -2.963660>, <0.534644, -0.143431, -2.978737>, <0.535346, -0.370011, -2.935218>, <0.521038, -0.520236, -2.926938>, 
      <0.675272, -0.038500, -2.963660>, <0.782989, -0.143431, -2.978737>, <0.782288, -0.370011, -2.935218>, <0.796596, -0.520236, -2.926938>, 
      <0.699954, -0.038500, -2.963660>, <0.807672, -0.143431, -2.978737>, <0.733339, -0.389026, -2.944339>, <0.747647, -0.539251, -2.936058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.573079, 0.125788, -2.732492>, <0.526305, 0.134318, -2.752134>, <0.791328, 0.134318, -2.752134>, <0.744554, 0.125788, -2.732492>, 
      <0.581252, 0.088507, -2.809699>, <0.534478, 0.097037, -2.829341>, <0.783154, 0.097037, -2.829341>, <0.736381, 0.088507, -2.809699>, 
      <0.564107, 0.019920, -2.929973>, <0.588789, 0.019920, -2.929973>, <0.728844, 0.019920, -2.929973>, <0.753526, 0.019920, -2.929973>, 
      <0.617679, -0.038500, -2.963660>, <0.642362, -0.038500, -2.963660>, <0.675272, -0.038500, -2.963660>, <0.699954, -0.038500, -2.963660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.596884, -2.723270, -1.370059>, <0.633217, -2.720959, -1.365654>, <0.682660, -2.723831, -1.361687>, <0.719012, -2.726317, -1.365832>, 
      <0.531120, -2.775829, -1.433551>, <0.567453, -2.773518, -1.429146>, <0.731989, -2.773114, -1.420726>, <0.768341, -2.775600, -1.424871>, 
      <0.400051, -2.810142, -1.489408>, <0.586644, -2.810447, -1.488986>, <0.688981, -2.802236, -1.452463>, <0.872074, -2.811768, -1.487155>, 
      <0.315694, -2.847373, -1.540558>, <0.502287, -2.847678, -1.540136>, <0.754579, -2.838858, -1.504459>, <0.937672, -2.848390, -1.539150>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.675588, -2.586550, -1.225480>, <0.665736, -2.586422, -1.223436>, <0.651897, -2.586422, -1.223436>, <0.642045, -2.586550, -1.225480>, 
      <0.680946, -2.633951, -1.263232>, <0.671093, -2.633822, -1.261188>, <0.646296, -2.633699, -1.261915>, <0.636443, -2.633827, -1.263959>, 
      <0.686168, -2.693503, -1.326523>, <0.649816, -2.691017, -1.322378>, <0.671395, -2.690447, -1.328795>, <0.635062, -2.692758, -1.333200>, 
      <0.719012, -2.726317, -1.365832>, <0.682660, -2.723831, -1.361687>, <0.633217, -2.720959, -1.365654>, <0.596884, -2.723270, -1.370059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.675588, -2.342128, -1.059850>, <0.665914, -2.344301, -1.058133>, <0.651719, -2.344301, -1.058133>, <0.642045, -2.342128, -1.059850>, 
      <0.675588, -2.413929, -1.111720>, <0.665914, -2.416102, -1.110003>, <0.651719, -2.416102, -1.110003>, <0.642045, -2.413929, -1.111720>, 
      <0.667787, -2.517532, -1.170512>, <0.657935, -2.517404, -1.168468>, <0.660003, -2.518012, -1.167758>, <0.650151, -2.518140, -1.169801>, 
      <0.675588, -2.586550, -1.225480>, <0.665736, -2.586422, -1.223436>, <0.651897, -2.586422, -1.223436>, <0.642045, -2.586550, -1.225480>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.675588, -2.089147, -0.866149>, <0.665783, -2.090658, -0.864464>, <0.651850, -2.090658, -0.864464>, <0.642045, -2.089147, -0.866149>, 
      <0.675588, -2.165520, -0.923628>, <0.665783, -2.167031, -0.921943>, <0.651850, -2.167031, -0.921943>, <0.642045, -2.165520, -0.923628>, 
      <0.675588, -2.264645, -1.003875>, <0.665914, -2.266819, -1.002158>, <0.651719, -2.266819, -1.002158>, <0.642045, -2.264645, -1.003875>, 
      <0.675588, -2.342128, -1.059850>, <0.665914, -2.344301, -1.058133>, <0.651719, -2.344301, -1.058133>, <0.642045, -2.342128, -1.059850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.642045, -1.805290, -0.655819>, <0.642045, -1.891202, -0.717886>, <0.642045, -2.004464, -0.802415>, <0.642045, -2.089147, -0.866149>, 
      <0.651738, -1.806226, -0.653285>, <0.651738, -1.892138, -0.715352>, <0.651850, -2.005975, -0.800730>, <0.651850, -2.090658, -0.864464>, 
      <0.665895, -1.806226, -0.653285>, <0.665895, -1.892138, -0.715352>, <0.665783, -2.005975, -0.800730>, <0.665783, -2.090658, -0.864464>, 
      <0.675588, -1.805290, -0.655819>, <0.675588, -1.891202, -0.717886>, <0.675588, -2.004464, -0.802415>, <0.675588, -2.089147, -0.866149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.675588, -1.607798, -0.518399>, <0.668514, -1.650897, -0.575865>, <0.675588, -1.746782, -0.613550>, <0.675588, -1.805290, -0.655819>, 
      <0.665907, -1.610334, -0.517343>, <0.658833, -1.653433, -0.574808>, <0.665895, -1.747718, -0.611016>, <0.665895, -1.806226, -0.653285>, 
      <0.651726, -1.610334, -0.517343>, <0.658800, -1.653433, -0.574808>, <0.651738, -1.747718, -0.611016>, <0.651738, -1.806226, -0.653285>, 
      <0.642045, -1.607798, -0.518399>, <0.649119, -1.650897, -0.575865>, <0.642045, -1.746782, -0.613550>, <0.642045, -1.805290, -0.655819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.735894, -1.437864, -0.165914>, <0.738834, -1.504649, -0.264095>, <0.687229, -1.536874, -0.423833>, <0.675588, -1.607798, -0.518399>, 
      <0.694592, -1.449327, -0.148550>, <0.697532, -1.516112, -0.246731>, <0.677548, -1.539410, -0.422777>, <0.665907, -1.610334, -0.517343>, 
      <0.623041, -1.449327, -0.148550>, <0.620101, -1.516112, -0.246731>, <0.640085, -1.539410, -0.422777>, <0.651726, -1.610334, -0.517343>, 
      <0.581739, -1.437864, -0.165914>, <0.578799, -1.504649, -0.264095>, <0.630404, -1.536874, -0.423833>, <0.642045, -1.607798, -0.518399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.526651, 0.376715, -2.103779>, <0.482938, 0.442878, -2.103779>, <0.834695, 0.442878, -2.103779>, <0.790982, 0.376715, -2.103779>, 
      <0.535306, 0.312412, -2.296720>, <0.491593, 0.378575, -2.296720>, <0.826040, 0.378575, -2.296720>, <0.782327, 0.312412, -2.296720>, 
      <0.553762, 0.213903, -2.550013>, <0.506988, 0.222433, -2.569654>, <0.810645, 0.222433, -2.569654>, <0.763872, 0.213903, -2.550013>, 
      <0.573079, 0.125788, -2.732492>, <0.526305, 0.134318, -2.752134>, <0.791328, 0.134318, -2.752134>, <0.744554, 0.125788, -2.732492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.526651, 0.470725, -1.697508>, <0.479088, 0.534162, -1.696172>, <0.838545, 0.534162, -1.696172>, <0.790982, 0.470725, -1.697508>, 
      <0.521418, 0.458162, -1.821867>, <0.473855, 0.521600, -1.820531>, <0.843778, 0.521600, -1.820531>, <0.796215, 0.458162, -1.821867>, 
      <0.521332, 0.416234, -1.985202>, <0.477619, 0.482397, -1.985202>, <0.840014, 0.482397, -1.985202>, <0.796301, 0.416234, -1.985202>, 
      <0.526651, 0.376715, -2.103779>, <0.482938, 0.442878, -2.103779>, <0.834695, 0.442878, -2.103779>, <0.790982, 0.376715, -2.103779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.756854, 0.458644, -1.292761>, <0.780532, 0.512435, -1.290313>, <0.537101, 0.512435, -1.290313>, <0.560779, 0.458644, -1.292761>, 
      <0.763434, 0.434806, -1.412135>, <0.787112, 0.488596, -1.409688>, <0.530521, 0.488596, -1.409688>, <0.554199, 0.434806, -1.412135>, 
      <0.785883, 0.482967, -1.576323>, <0.833446, 0.546405, -1.574986>, <0.484187, 0.546405, -1.574986>, <0.531751, 0.482967, -1.576323>, 
      <0.790982, 0.470725, -1.697508>, <0.838545, 0.534162, -1.696172>, <0.479088, 0.534162, -1.696172>, <0.526651, 0.470725, -1.697508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.750369, 0.607307, 2.676861>, <0.734892, 0.717918, 2.575048>, <0.721428, 0.848354, 2.418643>, <0.714973, 0.929953, 2.291600>, 
      <0.695743, 0.613090, 2.676861>, <0.680266, 0.723700, 2.575048>, <0.688319, 0.854605, 2.418643>, <0.681864, 0.936204, 2.291600>, 
      <0.621890, 0.613090, 2.676862>, <0.637367, 0.723700, 2.575049>, <0.629314, 0.854605, 2.418644>, <0.635769, 0.936204, 2.291600>, 
      <0.567264, 0.607307, 2.676862>, <0.582741, 0.717918, 2.575049>, <0.596205, 0.848354, 2.418644>, <0.602660, 0.929953, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.811542, 0.239801, 2.926861>, <0.876371, 0.337333, 2.860513>, <0.764153, 0.508794, 2.767539>, <0.750369, 0.607307, 2.676861>, 
      <0.767407, 0.173402, 2.972030>, <0.832236, 0.270934, 2.905683>, <0.709527, 0.514577, 2.767539>, <0.695743, 0.613090, 2.676861>, 
      <0.550226, 0.173401, 2.972031>, <0.485397, 0.270934, 2.905684>, <0.608106, 0.514577, 2.767540>, <0.621890, 0.613090, 2.676862>, 
      <0.506091, 0.239801, 2.926862>, <0.441262, 0.337333, 2.860515>, <0.553480, 0.508794, 2.767540>, <0.567264, 0.607307, 2.676862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.486988, 0.078629, 2.993608>, <0.590065, 0.080471, 2.994431>, <0.727568, 0.080471, 2.994431>, <0.830645, 0.078629, 2.993608>, 
      <0.486988, 0.131276, 2.993608>, <0.590065, 0.133118, 2.994431>, <0.727568, 0.133118, 2.994431>, <0.830645, 0.131276, 2.993608>, 
      <0.556632, 0.226603, 2.933423>, <0.600768, 0.160204, 2.978591>, <0.716865, 0.160204, 2.978591>, <0.761000, 0.226603, 2.933422>, 
      <0.506091, 0.239801, 2.926862>, <0.550226, 0.173401, 2.972031>, <0.767407, 0.173402, 2.972030>, <0.811542, 0.239801, 2.926861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.506091, -0.166375, 2.926862>, <0.497808, -0.096674, 2.957018>, <0.486988, 0.002234, 2.993608>, <0.486988, 0.078629, 2.993608>, 
      <0.597718, -0.167628, 2.926862>, <0.589435, -0.097927, 2.957018>, <0.590065, 0.004076, 2.994431>, <0.590065, 0.080471, 2.994431>, 
      <0.719915, -0.167628, 2.926861>, <0.728198, -0.097927, 2.957017>, <0.727568, 0.004076, 2.994431>, <0.727568, 0.080471, 2.994431>, 
      <0.811542, -0.166375, 2.926861>, <0.819825, -0.096674, 2.957017>, <0.830645, 0.002234, 2.993608>, <0.830645, 0.078629, 2.993608>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.615159, 1.212754, 1.734230>, <0.606336, 1.153523, 1.911952>, <0.610670, 1.031212, 2.133949>, <0.602660, 0.929953, 2.291600>, 
      <0.640424, 1.219671, 1.734230>, <0.631601, 1.160439, 1.911952>, <0.643779, 1.037463, 2.133949>, <0.635769, 0.936204, 2.291600>, 
      <0.677209, 1.219670, 1.734230>, <0.686032, 1.160438, 1.911952>, <0.673854, 1.037463, 2.133949>, <0.681864, 0.936204, 2.291600>, 
      <0.702474, 1.212753, 1.734230>, <0.711297, 1.153522, 1.911952>, <0.706963, 1.031211, 2.133949>, <0.714973, 0.929953, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.662480, 1.282354, 1.234230>, <0.660385, 1.283021, 1.234230>, <0.657247, 1.283021, 1.234230>, <0.655153, 1.282354, 1.234230>, 
      <0.666879, 1.310204, 1.383512>, <0.664785, 1.310871, 1.383512>, <0.652848, 1.310871, 1.383512>, <0.650754, 1.310204, 1.383512>, 
      <0.695327, 1.260735, 1.590262>, <0.670062, 1.267651, 1.590262>, <0.647571, 1.267652, 1.590263>, <0.622306, 1.260736, 1.590263>, 
      <0.702474, 1.212753, 1.734230>, <0.677209, 1.219670, 1.734230>, <0.640424, 1.219671, 1.734230>, <0.615159, 1.212754, 1.734230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.662480, 0.959570, 0.377120>, <0.660301, 0.959843, 0.377203>, <0.657332, 0.959843, 0.377203>, <0.655153, 0.959570, 0.377120>, 
      <0.662480, 1.055850, 0.634462>, <0.660301, 1.056123, 0.634544>, <0.657332, 1.056123, 0.634544>, <0.655153, 1.055850, 0.634462>, 
      <0.654524, 1.231985, 0.964241>, <0.652429, 1.232652, 0.964241>, <0.665204, 1.232651, 0.964241>, <0.663110, 1.231985, 0.964241>, 
      <0.662480, 1.282354, 1.234230>, <0.660385, 1.283021, 1.234230>, <0.657247, 1.283021, 1.234230>, <0.655153, 1.282354, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.655153, 0.861582, 0.109568>, <0.655153, 0.892577, 0.189230>, <0.655153, 0.929617, 0.297060>, <0.655153, 0.959570, 0.377120>, 
      <0.657348, 0.861658, 0.109484>, <0.657348, 0.892653, 0.189146>, <0.657332, 0.929890, 0.297143>, <0.657332, 0.959843, 0.377203>, 
      <0.660285, 0.861658, 0.109484>, <0.660285, 0.892653, 0.189146>, <0.660301, 0.929890, 0.297143>, <0.660301, 0.959843, 0.377203>, 
      <0.662480, 0.861582, 0.109568>, <0.662480, 0.892577, 0.189230>, <0.662480, 0.929617, 0.297060>, <0.662480, 0.959570, 0.377120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.745575, 0.635222, -0.873763>, <0.781950, 0.672043, -0.868212>, <0.535683, 0.672043, -0.868212>, <0.572058, 0.635222, -0.873763>, 
      <0.760046, 0.606790, -1.006429>, <0.796421, 0.643611, -1.000877>, <0.521212, 0.643611, -1.000877>, <0.557587, 0.606790, -1.006429>, 
      <0.749489, 0.485325, -1.159150>, <0.773167, 0.539116, -1.156703>, <0.544466, 0.539116, -1.156703>, <0.568144, 0.485325, -1.159150>, 
      <0.756854, 0.458644, -1.292761>, <0.780532, 0.512435, -1.290313>, <0.537101, 0.512435, -1.290313>, <0.560779, 0.458644, -1.292761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.662480, 0.749551, -0.162665>, <0.660282, 0.749553, -0.162673>, <0.657351, 0.749553, -0.162673>, <0.655153, 0.749551, -0.162665>, 
      <0.662313, 0.784871, -0.081720>, <0.660115, 0.784873, -0.081728>, <0.657519, 0.784873, -0.081728>, <0.655320, 0.784871, -0.081720>, 
      <0.662480, 0.829559, 0.027263>, <0.660285, 0.829635, 0.027179>, <0.657348, 0.829635, 0.027179>, <0.655153, 0.829559, 0.027263>, 
      <0.662480, 0.861582, 0.109568>, <0.660285, 0.861658, 0.109484>, <0.657348, 0.861658, 0.109484>, <0.655153, 0.861582, 0.109568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.663434, 0.660341, -0.351629>, <0.643603, 0.635267, -0.507585>, <0.588942, 0.668395, -0.718976>, <0.572058, 0.635222, -0.873763>, 
      <0.660675, 0.660591, -0.351600>, <0.640844, 0.635517, -0.507556>, <0.552566, 0.705215, -0.713425>, <0.535683, 0.672043, -0.868212>, 
      <0.656958, 0.660591, -0.351600>, <0.676789, 0.635517, -0.507556>, <0.765067, 0.705215, -0.713425>, <0.781950, 0.672043, -0.868212>, 
      <0.654199, 0.660341, -0.351629>, <0.674030, 0.635267, -0.507585>, <0.728692, 0.668395, -0.718976>, <0.745575, 0.635222, -0.873763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.663434, 0.660341, -0.351629>, <0.660675, 0.660591, -0.351600>, <0.656958, 0.660591, -0.351600>, <0.654199, 0.660341, -0.351629>, 
      <0.671243, 0.670215, -0.290216>, <0.668484, 0.670465, -0.290187>, <0.649149, 0.670465, -0.290187>, <0.646390, 0.670215, -0.290216>, 
      <0.662599, 0.724480, -0.220123>, <0.660401, 0.724482, -0.220131>, <0.657232, 0.724482, -0.220131>, <0.655034, 0.724480, -0.220123>, 
      <0.662480, 0.749551, -0.162665>, <0.660282, 0.749553, -0.162673>, <0.657351, 0.749553, -0.162673>, <0.655153, 0.749551, -0.162665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.655153, -1.310032, -0.080649>, <0.697273, -1.336724, -0.069536>, <0.583004, -1.409139, -0.123685>, <0.581739, -1.437864, -0.165914>, 
      <0.655274, -1.312148, -0.081234>, <0.697395, -1.338839, -0.070121>, <0.624305, -1.420602, -0.106320>, <0.623041, -1.449327, -0.148550>, 
      <0.662359, -1.312148, -0.081234>, <0.620238, -1.338839, -0.070121>, <0.693328, -1.420602, -0.106320>, <0.694592, -1.449327, -0.148550>, 
      <0.662480, -1.310032, -0.080649>, <0.620360, -1.336724, -0.069536>, <0.734630, -1.409139, -0.123685>, <0.735894, -1.437864, -0.165914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.655153, -1.182189, -0.045319>, <0.655153, -1.200997, -0.080384>, <0.652958, -1.271738, -0.070066>, <0.655153, -1.310032, -0.080649>, 
      <0.657317, -1.182542, -0.045158>, <0.657317, -1.201350, -0.080223>, <0.653080, -1.273853, -0.070651>, <0.655274, -1.312148, -0.081234>, 
      <0.660316, -1.182542, -0.045158>, <0.660316, -1.201350, -0.080223>, <0.664554, -1.273853, -0.070651>, <0.662359, -1.312148, -0.081234>, 
      <0.662480, -1.182189, -0.045319>, <0.662480, -1.200997, -0.080384>, <0.664675, -1.271738, -0.070066>, <0.662480, -1.310032, -0.080649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.655153, -1.175422, 0.170303>, <0.655153, -1.171738, 0.105690>, <0.655153, -1.151597, 0.011713>, <0.655153, -1.182189, -0.045319>, 
      <0.657340, -1.175643, 0.170303>, <0.657340, -1.171959, 0.105690>, <0.657317, -1.151950, 0.011873>, <0.657317, -1.182542, -0.045158>, 
      <0.660293, -1.175643, 0.170303>, <0.660293, -1.171959, 0.105690>, <0.660316, -1.151950, 0.011873>, <0.660316, -1.182542, -0.045158>, 
      <0.662480, -1.175422, 0.170303>, <0.662480, -1.171738, 0.105690>, <0.662480, -1.151597, 0.011713>, <0.662480, -1.182189, -0.045319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.655153, -1.217638, 0.576458>, <0.655153, -1.211280, 0.454120>, <0.655153, -1.182395, 0.292607>, <0.655153, -1.175422, 0.170303>, 
      <0.657339, -1.217863, 0.576458>, <0.657339, -1.211505, 0.454120>, <0.657340, -1.182616, 0.292607>, <0.657340, -1.175643, 0.170303>, 
      <0.660293, -1.217863, 0.576458>, <0.660293, -1.211505, 0.454120>, <0.660293, -1.182616, 0.292607>, <0.660293, -1.175643, 0.170303>, 
      <0.662480, -1.217638, 0.576458>, <0.662480, -1.211280, 0.454120>, <0.662480, -1.182395, 0.292607>, <0.662480, -1.175422, 0.170303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.655153, -1.230716, 1.234230>, <0.649913, -1.223119, 1.385931>, <0.622294, -1.208562, 1.590508>, <0.615159, -1.159661, 1.734230>, 
      <0.657340, -1.230940, 1.234230>, <0.652099, -1.223343, 1.385931>, <0.851321, -1.208562, 1.590508>, <0.844186, -1.159661, 1.734230>, 
      <0.660293, -1.230941, 1.234230>, <0.874171, -1.188755, 1.384230>, <0.933454, -1.153153, 1.584230>, <1.147331, -1.110967, 1.734230>, 
      <0.662480, -1.230717, 1.234230>, <0.876358, -1.188531, 1.384230>, <1.161527, -1.132284, 1.584230>, <1.375405, -1.090098, 1.734230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.655153, -1.230716, 1.234230>, <0.661958, -1.240581, 1.037224>, <0.655153, -1.227882, 0.773563>, <0.655153, -1.217638, 0.576458>, 
      <0.657340, -1.230940, 1.234230>, <0.664145, -1.240805, 1.037224>, <0.657339, -1.228107, 0.773563>, <0.657339, -1.217863, 0.576458>, 
      <0.660293, -1.230941, 1.234230>, <0.649930, -1.245515, 1.037671>, <0.660293, -1.228107, 0.773563>, <0.660293, -1.217863, 0.576458>, 
      <0.662480, -1.230717, 1.234230>, <0.652116, -1.245291, 1.037671>, <0.662480, -1.227882, 0.773563>, <0.662480, -1.217638, 0.576458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.750000, -0.600000, 2.700000>, <0.695663, -0.606191, 2.701555>, <0.621969, -0.606191, 2.701556>, <0.567633, -0.600000, 2.700001>, 
      <0.764985, -0.490667, 2.798577>, <0.710649, -0.496858, 2.800132>, <0.606984, -0.496858, 2.800133>, <0.552648, -0.490667, 2.798578>, 
      <0.795499, -0.301380, 2.868451>, <0.703872, -0.302634, 2.868451>, <0.613761, -0.302634, 2.868452>, <0.522134, -0.301381, 2.868452>, 
      <0.811542, -0.166375, 2.926861>, <0.719915, -0.167628, 2.926861>, <0.597718, -0.167628, 2.926862>, <0.506091, -0.166375, 2.926862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.714973, -0.870951, 2.291600>, <0.681357, -0.873247, 2.291600>, <0.636276, -0.873247, 2.291600>, <0.602660, -0.870951, 2.291600>, 
      <0.718108, -0.795145, 2.417982>, <0.684492, -0.797441, 2.417982>, <0.630005, -0.799405, 2.419024>, <0.596389, -0.797109, 2.419024>, 
      <0.735072, -0.708916, 2.601799>, <0.680736, -0.715106, 2.603354>, <0.636898, -0.715106, 2.603355>, <0.582561, -0.708916, 2.601800>, 
      <0.750000, -0.600000, 2.700000>, <0.695663, -0.606191, 2.701555>, <0.621969, -0.606191, 2.701556>, <0.567633, -0.600000, 2.700001>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107632, -2.765197, -1.439958>, <0.136118, -2.822129, -1.504857>, <0.209946, -2.849809, -1.605393>, <0.253795, -2.886071, -1.676294>, 
      <0.233345, -2.802944, -1.369869>, <0.261830, -2.859876, -1.434768>, <0.228516, -2.838199, -1.564672>, <0.272365, -2.874462, -1.635573>, 
      <0.449461, -2.732645, -1.387933>, <0.383697, -2.785204, -1.451425>, <0.381481, -2.821751, -1.530129>, <0.297124, -2.858982, -1.581279>, 
      <0.596884, -2.723270, -1.370059>, <0.531120, -2.775829, -1.433551>, <0.400051, -2.810142, -1.489408>, <0.315694, -2.847373, -1.540558>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -2.514615, -1.757493>, <-0.020317, -2.613038, -1.821154>, <0.109234, -2.744117, -1.919744>, <0.244281, -2.776936, -1.941261>, 
      <-0.172878, -2.552396, -1.650250>, <-0.095174, -2.650819, -1.713911>, <0.087050, -2.806882, -1.865272>, <0.222098, -2.839701, -1.886789>, 
      <-0.007380, -2.730663, -1.504081>, <0.021105, -2.787595, -1.568981>, <0.207092, -2.817068, -1.684883>, <0.250941, -2.853331, -1.755784>, 
      <0.107632, -2.765197, -1.439958>, <0.136118, -2.822129, -1.504857>, <0.209946, -2.849809, -1.605393>, <0.253795, -2.886071, -1.676294>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -2.514615, -1.757493>, <-0.016229, -2.473335, -1.874671>, <0.231771, -2.611942, -1.818937>, <0.379283, -2.628094, -1.829134>, 
      <-0.020317, -2.613038, -1.821154>, <0.061475, -2.571758, -1.938332>, <0.228693, -2.629104, -1.834733>, <0.376205, -2.645256, -1.844930>, 
      <0.109234, -2.744117, -1.919744>, <0.121116, -2.710497, -1.948922>, <0.296964, -2.670237, -1.852274>, <0.342405, -2.664482, -1.847289>, 
      <0.244281, -2.776936, -1.941261>, <0.256163, -2.743316, -1.970439>, <0.281159, -2.685832, -1.860055>, <0.326600, -2.680077, -1.855070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107632, -2.593947, -1.343288>, <0.107632, -2.646562, -1.369974>, <0.089146, -2.728251, -1.397842>, <0.107632, -2.765197, -1.439958>, 
      <0.243795, -2.638690, -1.263191>, <0.243795, -2.691305, -1.289876>, <0.214859, -2.765998, -1.327753>, <0.233345, -2.802944, -1.369869>, 
      <0.481292, -2.588644, -1.258824>, <0.475690, -2.635921, -1.297303>, <0.487639, -2.702133, -1.351074>, <0.449461, -2.732645, -1.387933>, 
      <0.642045, -2.586550, -1.225480>, <0.636443, -2.633827, -1.263959>, <0.635062, -2.692758, -1.333200>, <0.596884, -2.723270, -1.370059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -2.343364, -1.660823>, <-0.098021, -2.394525, -1.690200>, <-0.130618, -2.473327, -1.730787>, <-0.098021, -2.514615, -1.757493>, 
      <-0.186376, -2.410877, -1.582289>, <-0.186376, -2.462038, -1.611666>, <-0.205475, -2.511107, -1.623544>, <-0.172878, -2.552396, -1.650250>, 
      <-0.005264, -2.556849, -1.409699>, <-0.005264, -2.609464, -1.436385>, <-0.025866, -2.693717, -1.461965>, <-0.007380, -2.730663, -1.504081>, 
      <0.107632, -2.593947, -1.343288>, <0.107632, -2.646562, -1.369974>, <0.089146, -2.728251, -1.397842>, <0.107632, -2.765197, -1.439958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -2.343364, -1.660823>, <-0.003540, -2.271170, -1.744802>, <0.234226, -2.380355, -1.595393>, <0.379283, -2.386375, -1.584745>, 
      <-0.098021, -2.394525, -1.690200>, <-0.003540, -2.322331, -1.774179>, <0.233528, -2.453850, -1.667725>, <0.378584, -2.459870, -1.657077>, 
      <-0.130618, -2.473327, -1.730787>, <-0.048826, -2.432046, -1.847965>, <0.245264, -2.536720, -1.749702>, <0.392776, -2.552872, -1.759899>, 
      <-0.098021, -2.514615, -1.757493>, <-0.016229, -2.473335, -1.874671>, <0.231771, -2.611942, -1.818937>, <0.379283, -2.628094, -1.829134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.109302, -1.203288, -0.521260>, <-0.096477, -1.133165, -0.452770>, <0.081322, -1.167557, -0.377864>, <0.116229, -1.142869, -0.288731>, 
      <0.061423, -1.304275, -0.380016>, <0.074248, -1.234152, -0.311526>, <0.225197, -1.236302, -0.293451>, <0.260104, -1.211614, -0.204319>, 
      <0.364270, -1.377508, -0.257344>, <0.365535, -1.348782, -0.215115>, <0.548526, -1.242462, -0.108781>, <0.506405, -1.215770, -0.119894>, 
      <0.581739, -1.437864, -0.165914>, <0.583004, -1.409139, -0.123685>, <0.697273, -1.336724, -0.069536>, <0.655153, -1.310032, -0.080649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.265485, -0.870141, -0.620792>, <-0.172922, -1.009785, -0.580010>, <-0.021273, -1.077169, -0.369404>, <0.116229, -1.142869, -0.288731>, 
      <-0.274166, -0.926288, -0.663086>, <-0.181603, -1.065932, -0.622304>, <-0.056180, -1.101857, -0.458537>, <0.081322, -1.167557, -0.377864>, 
      <-0.166267, -0.958222, -0.723480>, <-0.251011, -0.982028, -0.692696>, <-0.161857, -1.094492, -0.506860>, <-0.096477, -1.133165, -0.452770>, 
      <-0.140338, -1.010743, -0.763302>, <-0.225082, -1.034549, -0.732518>, <-0.174682, -1.164615, -0.575350>, <-0.109302, -1.203288, -0.521260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.366876, -1.069520, -0.694234>, <0.214712, -1.051887, -0.714955>, <0.000137, -0.971281, -0.814330>, <-0.140338, -1.010743, -0.763302>, 
      <0.233949, -0.927461, -0.621227>, <0.081785, -0.909828, -0.641948>, <-0.025793, -0.918760, -0.774508>, <-0.166267, -0.958222, -0.723480>, 
      <0.046527, -0.763660, -0.452050>, <-0.017823, -0.854127, -0.468228>, <-0.260416, -0.837352, -0.596093>, <-0.274166, -0.926288, -0.663086>, 
      <-0.076214, -0.595989, -0.450878>, <-0.140564, -0.686456, -0.467056>, <-0.251735, -0.781205, -0.553799>, <-0.265485, -0.870141, -0.620792>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.059120, -0.154465, 2.926862>, <-0.058060, -0.094961, 2.959151>, <-0.054304, -0.004535, 2.986591>, <-0.048445, 0.062919, 2.986591>, 
      <-0.092164, -0.151442, 2.926862>, <-0.091105, -0.091939, 2.959151>, <-0.070581, -0.005284, 2.986270>, <-0.064722, 0.062170, 2.986270>, 
      <-0.142896, -0.134961, 2.926862>, <-0.120931, -0.096071, 2.955036>, <-0.095862, -0.000865, 2.988939>, <-0.086629, 0.051129, 2.988939>, 
      <-0.158346, -0.105595, 2.926862>, <-0.136381, -0.066705, 2.955036>, <-0.110605, -0.000433, 2.982005>, <-0.101372, 0.051561, 2.982005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.059120, -0.154465, 2.926862>, <-0.058060, -0.094961, 2.959151>, <-0.054304, -0.004535, 2.986591>, <-0.048445, 0.062919, 2.986591>, 
      <0.109776, -0.169915, 2.926862>, <0.110836, -0.110411, 2.959151>, <0.106208, 0.002850, 2.989757>, <0.112067, 0.070304, 2.989757>, 
      <0.336506, -0.164055, 2.926862>, <0.328223, -0.094354, 2.957018>, <0.326306, -0.000638, 2.992326>, <0.326306, 0.075758, 2.992326>, 
      <0.506091, -0.166375, 2.926862>, <0.497808, -0.096674, 2.957018>, <0.486988, 0.002234, 2.993608>, <0.486988, 0.078629, 2.993608>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.027213, 0.212903, 2.926862>, <-0.034111, 0.172567, 2.953539>, <-0.044218, 0.111585, 2.986591>, <-0.048445, 0.062919, 2.986591>, 
      <0.132196, 0.228745, 2.926862>, <0.125299, 0.188409, 2.953539>, <0.116294, 0.118969, 2.989757>, <0.112067, 0.070304, 2.989757>, 
      <0.352302, 0.279960, 2.906899>, <0.402844, 0.266762, 2.913460>, <0.326306, 0.128404, 2.992326>, <0.326306, 0.075758, 2.992326>, 
      <0.506091, 0.239801, 2.926862>, <0.556632, 0.226603, 2.933423>, <0.486988, 0.131276, 2.993608>, <0.486988, 0.078629, 2.993608>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.027213, 0.212903, 2.926862>, <-0.034111, 0.172567, 2.953539>, <-0.044218, 0.111585, 2.986591>, <-0.048445, 0.062919, 2.986591>, 
      <-0.053350, 0.210306, 2.926862>, <-0.060247, 0.169970, 2.953539>, <-0.060496, 0.110836, 2.986270>, <-0.064722, 0.062170, 2.986270>, 
      <-0.089149, 0.197238, 2.926862>, <-0.081215, 0.165258, 2.952330>, <-0.079348, 0.092133, 2.988939>, <-0.086629, 0.051129, 2.988939>, 
      <-0.107845, 0.178790, 2.926862>, <-0.099911, 0.146810, 2.952330>, <-0.094091, 0.092564, 2.982005>, <-0.101372, 0.051561, 2.982005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.031637, 0.531224, 2.676862>, <0.016214, 0.447802, 2.765514>, <-0.009887, 0.314222, 2.859851>, <-0.027213, 0.212903, 2.926862>, 
      <0.189947, 0.566997, 2.676862>, <0.174524, 0.483575, 2.765514>, <0.149522, 0.330064, 2.859851>, <0.132196, 0.228745, 2.926862>, 
      <0.405865, 0.590222, 2.676862>, <0.392080, 0.491709, 2.767540>, <0.287473, 0.377492, 2.840552>, <0.352302, 0.279960, 2.906899>, 
      <0.567264, 0.607307, 2.676862>, <0.553480, 0.508794, 2.767540>, <0.441262, 0.337333, 2.860515>, <0.506091, 0.239801, 2.926862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.196429, 0.434735, 2.676862>, <-0.143547, 0.486915, 2.676862>, <-0.040827, 0.514849, 2.676862>, <0.031637, 0.531224, 2.676862>, 
      <-0.173825, 0.369426, 2.763180>, <-0.120944, 0.421606, 2.763180>, <-0.056250, 0.431427, 2.765514>, <0.016214, 0.447802, 2.765514>, 
      <-0.128910, 0.263704, 2.859240>, <-0.110214, 0.282152, 2.859240>, <-0.036024, 0.311625, 2.859851>, <-0.009887, 0.314222, 2.859851>, 
      <-0.107845, 0.178790, 2.926862>, <-0.089149, 0.197238, 2.926862>, <-0.053350, 0.210306, 2.926862>, <-0.027213, 0.212903, 2.926862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.058611, -0.507874, 2.676862>, <-0.058746, -0.414057, 2.766662>, <-0.061153, -0.268597, 2.864930>, <-0.059120, -0.154465, 2.926862>, 
      <-0.149551, -0.484775, 2.674542>, <-0.149686, -0.390958, 2.764342>, <-0.094197, -0.265575, 2.864930>, <-0.092164, -0.151442, 2.926862>, 
      <-0.295570, -0.452707, 2.676862>, <-0.248235, -0.383623, 2.765366>, <-0.193577, -0.224692, 2.861856>, <-0.142896, -0.134961, 2.926862>, 
      <-0.339271, -0.369645, 2.676862>, <-0.291936, -0.300561, 2.765366>, <-0.209027, -0.195326, 2.861856>, <-0.158346, -0.105595, 2.926862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.058611, -0.507874, 2.676862>, <-0.058746, -0.414057, 2.766662>, <-0.061153, -0.268597, 2.864930>, <-0.059120, -0.154465, 2.926862>, 
      <0.125506, -0.554640, 2.681560>, <0.125371, -0.460823, 2.771360>, <0.107743, -0.284047, 2.864930>, <0.109776, -0.169915, 2.926862>, 
      <0.378909, -0.578498, 2.694601>, <0.363924, -0.469166, 2.793178>, <0.352549, -0.299061, 2.868453>, <0.336506, -0.164055, 2.926862>, 
      <0.567633, -0.600000, 2.700001>, <0.552648, -0.490667, 2.798578>, <0.522134, -0.301381, 2.868452>, <0.506091, -0.166375, 2.926862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175447, 0.066637, 2.926862>, <-0.168578, 0.105317, 2.926862>, <-0.135809, 0.151197, 2.926862>, <-0.107845, 0.178790, 2.926862>, 
      <-0.175447, 0.066637, 2.926862>, <-0.149607, 0.100947, 2.947084>, <-0.127876, 0.119217, 2.952330>, <-0.099911, 0.146810, 2.952330>, 
      <-0.175447, 0.066637, 2.926862>, <-0.149607, 0.100947, 2.947084>, <-0.119483, 0.093308, 2.970063>, <-0.094091, 0.092564, 2.982005>, 
      <-0.175447, 0.066637, 2.926862>, <-0.156475, 0.062266, 2.947084>, <-0.126765, 0.052304, 2.970063>, <-0.101372, 0.051561, 2.982005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175447, 0.066637, 2.926862>, <-0.242728, 0.082137, 2.855145>, <-0.335166, 0.104930, 2.760518>, <-0.387642, 0.117511, 2.676862>, 
      <-0.168578, 0.105317, 2.926862>, <-0.235860, 0.120817, 2.855145>, <-0.315738, 0.214337, 2.760518>, <-0.368213, 0.226918, 2.676862>, 
      <-0.135809, 0.151197, 2.926862>, <-0.156874, 0.236112, 2.859240>, <-0.252921, 0.291380, 2.763180>, <-0.275525, 0.356689, 2.676862>, 
      <-0.107845, 0.178790, 2.926862>, <-0.128910, 0.263704, 2.859240>, <-0.173825, 0.369426, 2.763180>, <-0.196429, 0.434735, 2.676862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175447, 0.066637, 2.926862>, <-0.242728, 0.082137, 2.855145>, <-0.335166, 0.104930, 2.760518>, <-0.387642, 0.117511, 2.676862>, 
      <-0.184526, 0.015513, 2.926862>, <-0.251807, 0.031013, 2.855145>, <-0.360845, -0.039673, 2.760518>, <-0.413321, -0.027092, 2.676862>, 
      <-0.182522, -0.059643, 2.926862>, <-0.233203, -0.149375, 2.861856>, <-0.360318, -0.170587, 2.765366>, <-0.407654, -0.239671, 2.676862>, 
      <-0.158346, -0.105595, 2.926862>, <-0.209027, -0.195326, 2.861856>, <-0.291936, -0.300561, 2.765366>, <-0.339271, -0.369645, 2.676862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175447, 0.066637, 2.926862>, <-0.156475, 0.062266, 2.947084>, <-0.126765, 0.052304, 2.970063>, <-0.101372, 0.051561, 2.982005>, 
      <-0.175447, 0.066637, 2.926862>, <-0.165554, 0.011143, 2.947084>, <-0.135998, 0.000310, 2.970063>, <-0.110605, -0.000433, 2.982005>, 
      <-0.175447, 0.066637, 2.926862>, <-0.165554, 0.011143, 2.947084>, <-0.160557, -0.020753, 2.955036>, <-0.136381, -0.066705, 2.955036>, 
      <-0.175447, 0.066637, 2.926862>, <-0.184526, 0.015513, 2.926862>, <-0.182522, -0.059643, 2.926862>, <-0.158346, -0.105595, 2.926862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175447, 0.066637, 2.926862>, <-0.184526, 0.015513, 2.926862>, <-0.182522, -0.059643, 2.926862>, <-0.158346, -0.105595, 2.926862>, 
      <-0.168578, 0.105317, 2.926862>, <-0.177657, 0.054193, 2.926862>, <-0.160557, -0.020753, 2.955036>, <-0.136381, -0.066705, 2.955036>, 
      <-0.135809, 0.151197, 2.926862>, <-0.127876, 0.119217, 2.952330>, <-0.103324, 0.040570, 2.982005>, <-0.110605, -0.000433, 2.982005>, 
      <-0.107845, 0.178790, 2.926862>, <-0.099911, 0.146810, 2.952330>, <-0.094091, 0.092564, 2.982005>, <-0.101372, 0.051561, 2.982005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083304, 0.810690, 2.291600>, <0.070447, 0.741146, 2.416604>, <0.049689, 0.628869, 2.573096>, <0.031637, 0.531224, 2.676862>, 
      <0.236062, 0.857816, 2.291600>, <0.223205, 0.788272, 2.416604>, <0.207999, 0.664642, 2.573096>, <0.189947, 0.566997, 2.676862>, 
      <0.445573, 0.900294, 2.291600>, <0.439118, 0.818695, 2.418644>, <0.421342, 0.700832, 2.575049>, <0.405865, 0.590222, 2.676862>, 
      <0.602660, 0.929953, 2.291600>, <0.596205, 0.848354, 2.418644>, <0.582741, 0.717918, 2.575049>, <0.567264, 0.607307, 2.676862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.274200, 0.659438, 2.291600>, <-0.191306, 0.741232, 2.291600>, <-0.027976, 0.776360, 2.291600>, <0.083304, 0.810690, 2.291600>, 
      <-0.255194, 0.604525, 2.414361>, <-0.172300, 0.686319, 2.414361>, <-0.040833, 0.706816, 2.416604>, <0.070447, 0.741146, 2.416604>, 
      <-0.224193, 0.514954, 2.570838>, <-0.171312, 0.567134, 2.570838>, <-0.022775, 0.612494, 2.573096>, <0.049689, 0.628869, 2.573096>, 
      <-0.196429, 0.434735, 2.676862>, <-0.143547, 0.486915, 2.676862>, <-0.040827, 0.514849, 2.676862>, <0.031637, 0.531224, 2.676862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.573935, 0.162175, 2.291600>, <-0.543480, 0.333676, 2.291600>, <-0.398187, 0.537097, 2.291600>, <-0.274200, 0.659438, 2.291600>, 
      <-0.529208, 0.151452, 2.412206>, <-0.498752, 0.322952, 2.412206>, <-0.379181, 0.482184, 2.414361>, <-0.255194, 0.604525, 2.414361>, 
      <-0.455683, 0.133824, 2.568392>, <-0.436255, 0.243231, 2.568392>, <-0.303289, 0.436908, 2.570838>, <-0.224193, 0.514954, 2.570838>, 
      <-0.387642, 0.117511, 2.676862>, <-0.368213, 0.226918, 2.676862>, <-0.275525, 0.356689, 2.676862>, <-0.196429, 0.434735, 2.676862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.498112, -0.601464, 2.291600>, <-0.605305, -0.397724, 2.291600>, <-0.614188, -0.064497, 2.291600>, <-0.573935, 0.162175, 2.291600>, 
      <-0.458634, -0.543848, 2.416450>, <-0.565827, -0.340107, 2.416450>, <-0.569460, -0.075220, 2.412206>, <-0.529208, 0.151452, 2.412206>, 
      <-0.394848, -0.450757, 2.572949>, <-0.463231, -0.320783, 2.572949>, <-0.481362, -0.010779, 2.568392>, <-0.455683, 0.133824, 2.568392>, 
      <-0.339271, -0.369645, 2.676862>, <-0.407654, -0.239671, 2.676862>, <-0.413321, -0.027092, 2.676862>, <-0.387642, 0.117511, 2.676862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.058164, -0.818145, 2.291600>, <-0.201068, -0.783160, 2.291600>, <-0.429609, -0.731667, 2.291600>, <-0.498112, -0.601464, 2.291600>, 
      <-0.058276, -0.740161, 2.417858>, <-0.201180, -0.705176, 2.417858>, <-0.390131, -0.674051, 2.416450>, <-0.458634, -0.543848, 2.416450>, 
      <-0.058457, -0.615079, 2.574248>, <-0.149396, -0.591980, 2.571927>, <-0.351147, -0.533818, 2.572949>, <-0.394848, -0.450757, 2.572949>, 
      <-0.058611, -0.507874, 2.676862>, <-0.149551, -0.484775, 2.674542>, <-0.295570, -0.452707, 2.676862>, <-0.339271, -0.369645, 2.676862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.058164, -0.818145, 2.291600>, <-0.058276, -0.740161, 2.417858>, <-0.058457, -0.615079, 2.574248>, <-0.058611, -0.507874, 2.676862>, 
      <0.135010, -0.865437, 2.291600>, <0.134898, -0.787453, 2.417858>, <0.125661, -0.661845, 2.578945>, <0.125506, -0.554640, 2.681560>, 
      <0.404243, -0.857399, 2.291600>, <0.397973, -0.783557, 2.419024>, <0.393837, -0.687414, 2.596400>, <0.378909, -0.578498, 2.694601>, 
      <0.602660, -0.870951, 2.291600>, <0.596389, -0.797109, 2.419024>, <0.582561, -0.708916, 2.601800>, <0.567633, -0.600000, 2.700001>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.128589, 1.055642, 1.734230>, <0.119210, 1.004912, 1.909965>, <0.099699, 0.899374, 2.132193>, <0.083304, 0.810690, 2.291600>, 
      <0.272348, 1.109145, 1.734230>, <0.262969, 1.058414, 1.909965>, <0.252457, 0.946500, 2.132193>, <0.236062, 0.857816, 2.291600>, 
      <0.467211, 1.172251, 1.734230>, <0.458388, 1.113019, 1.911952>, <0.453584, 1.001553, 2.133949>, <0.445573, 0.900294, 2.291600>, 
      <0.615159, 1.212754, 1.734230>, <0.606336, 1.153523, 1.911952>, <0.610670, 1.031212, 2.133949>, <0.602660, 0.929953, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.342366, 0.856391, 1.734230>, <-0.233166, 0.964142, 1.734230>, <-0.015188, 1.002133, 1.734230>, <0.128589, 1.055642, 1.734230>, 
      <-0.328439, 0.816151, 1.907596>, <-0.219239, 0.923902, 1.907596>, <-0.024566, 0.951402, 1.909965>, <0.119210, 1.004912, 1.909965>, 
      <-0.299181, 0.731615, 2.130245>, <-0.216286, 0.813409, 2.130245>, <-0.011580, 0.865043, 2.132193>, <0.099699, 0.899374, 2.132193>, 
      <-0.274200, 0.659438, 2.291600>, <-0.191306, 0.741232, 2.291600>, <-0.027976, 0.776360, 2.291600>, <0.083304, 0.810690, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.737222, 0.201323, 1.734230>, <-0.697102, 0.427249, 1.734230>, <-0.505700, 0.695225, 1.734230>, <-0.342366, 0.856391, 1.734230>, 
      <-0.704256, 0.193419, 1.905542>, <-0.664135, 0.419346, 1.905542>, <-0.491773, 0.654985, 1.907596>, <-0.328439, 0.816151, 1.907596>, 
      <-0.634448, 0.176683, 2.128429>, <-0.603993, 0.348184, 2.128429>, <-0.423167, 0.609274, 2.130245>, <-0.299181, 0.731615, 2.130245>, 
      <-0.573935, 0.162175, 2.291600>, <-0.543480, 0.333676, 2.291600>, <-0.398187, 0.537097, 2.291600>, <-0.274200, 0.659438, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.637336, -0.804654, 1.734230>, <-0.778546, -0.536258, 1.734230>, <-0.790249, -0.097282, 1.734230>, <-0.737222, 0.201323, 1.734230>, 
      <-0.608530, -0.762614, 1.909794>, <-0.749741, -0.494217, 1.909794>, <-0.757282, -0.105186, 1.905542>, <-0.704256, 0.193419, 1.905542>, 
      <-0.548560, -0.675090, 2.132057>, <-0.655753, -0.471350, 2.132057>, <-0.674700, -0.049989, 2.128429>, <-0.634448, 0.176683, 2.128429>, 
      <-0.498112, -0.601464, 2.291600>, <-0.605305, -0.397724, 2.291600>, <-0.614188, -0.064497, 2.291600>, <-0.573935, 0.162175, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.057772, -1.090098, 1.734230>, <-0.244240, -1.037246, 1.734230>, <-0.547094, -0.976176, 1.734230>, <-0.637336, -0.804654, 1.734230>, 
      <-0.057854, -1.033314, 1.911406>, <-0.244321, -0.980461, 1.911406>, <-0.518288, -0.934136, 1.909794>, <-0.608530, -0.762614, 1.909794>, 
      <-0.058023, -0.915916, 2.133307>, <-0.200927, -0.880931, 2.133307>, <-0.480057, -0.805293, 2.132057>, <-0.548560, -0.675090, 2.132057>, 
      <-0.058164, -0.818145, 2.291600>, <-0.201068, -0.783160, 2.291600>, <-0.429609, -0.731667, 2.291600>, <-0.498112, -0.601464, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.057772, -1.090098, 1.734230>, <-0.057854, -1.033314, 1.911406>, <-0.058023, -0.915916, 2.133307>, <-0.058164, -0.818145, 2.291600>, 
      <0.137491, -1.145443, 1.734230>, <0.137409, -1.088659, 1.911406>, <0.135151, -0.963208, 2.133307>, <0.135010, -0.865437, 2.291600>, 
      <0.412204, -1.159661, 1.734230>, <0.403361, -1.099059, 1.912344>, <0.412255, -0.951750, 2.128784>, <0.404243, -0.857399, 2.291600>, 
      <0.615159, -1.159661, 1.734230>, <0.606317, -1.099059, 1.912344>, <0.610672, -0.965302, 2.128784>, <0.602660, -0.870951, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.139735, 1.115928, 1.234230>, <0.162689, 1.136221, 1.382215>, <0.136328, 1.097501, 1.589226>, <0.128589, 1.055642, 1.734230>, 
      <0.292017, 1.172603, 1.234230>, <0.314970, 1.192896, 1.382215>, <0.280087, 1.151004, 1.589226>, <0.272348, 1.109145, 1.734230>, 
      <0.500324, 1.233061, 1.234230>, <0.495925, 1.260911, 1.383512>, <0.474358, 1.220232, 1.590263>, <0.467211, 1.172251, 1.734230>, 
      <0.655153, 1.282354, 1.234230>, <0.650754, 1.310204, 1.383512>, <0.622306, 1.260736, 1.590263>, <0.615159, 1.212754, 1.734230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.359143, 0.904864, 1.234230>, <-0.243468, 1.019003, 1.234230>, <-0.012566, 1.059246, 1.234230>, <0.139735, 1.115928, 1.234230>, 
      <-0.326304, 0.908497, 1.381353>, <-0.210630, 1.022637, 1.381353>, <0.010387, 1.079539, 1.382215>, <0.162689, 1.136221, 1.382215>, 
      <-0.354130, 0.890380, 1.587795>, <-0.244929, 0.998131, 1.587795>, <-0.007449, 1.043992, 1.589226>, <0.136328, 1.097501, 1.589226>, 
      <-0.342366, 0.856391, 1.734230>, <-0.233166, 0.964142, 1.734230>, <-0.015188, 1.002133, 1.734230>, <0.128589, 1.055642, 1.734230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.777409, 0.210958, 1.234230>, <-0.734910, 0.450279, 1.234230>, <-0.532161, 0.734143, 1.234230>, <-0.359143, 0.904864, 1.234230>, 
      <-0.784287, 0.210814, 1.384584>, <-0.741788, 0.450135, 1.384584>, <-0.499322, 0.737776, 1.381353>, <-0.326304, 0.908497, 1.381353>, 
      <-0.765635, 0.208135, 1.586582>, <-0.725514, 0.434061, 1.586582>, <-0.517463, 0.729214, 1.587795>, <-0.354130, 0.890380, 1.587795>, 
      <-0.737222, 0.201323, 1.734230>, <-0.697102, 0.427249, 1.734230>, <-0.505700, 0.695225, 1.734230>, <-0.342366, 0.856391, 1.734230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.671601, -0.854662, 1.234230>, <-0.821183, -0.570353, 1.234230>, <-0.833580, -0.105351, 1.234230>, <-0.777409, 0.210958, 1.234230>, 
      <-0.678046, -0.899802, 1.378284>, <-0.827628, -0.615493, 1.378284>, <-0.840457, -0.105496, 1.384584>, <-0.784287, 0.210814, 1.384584>, 
      <-0.661145, -0.839402, 1.589122>, <-0.802355, -0.571005, 1.589122>, <-0.818661, -0.090470, 1.586582>, <-0.765635, 0.208135, 1.586582>, 
      <-0.637336, -0.804654, 1.734230>, <-0.778546, -0.536258, 1.734230>, <-0.790249, -0.097282, 1.734230>, <-0.737222, 0.201323, 1.734230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.057676, -1.157029, 1.234230>, <-0.255199, -1.101043, 1.234230>, <-0.576009, -1.036353, 1.234230>, <-0.671601, -0.854662, 1.234230>, 
      <-0.064049, -1.149413, 1.385242>, <-0.261571, -1.093427, 1.385242>, <-0.582453, -1.081493, 1.378284>, <-0.678046, -0.899802, 1.378284>, 
      <-0.057706, -1.136287, 1.590113>, <-0.244173, -1.083435, 1.590113>, <-0.570903, -1.010924, 1.589122>, <-0.661145, -0.839402, 1.589122>, 
      <-0.057772, -1.090098, 1.734230>, <-0.244240, -1.037246, 1.734230>, <-0.547094, -0.976176, 1.734230>, <-0.637336, -0.804654, 1.734230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.057676, -1.157029, 1.234230>, <-0.064049, -1.149413, 1.385242>, <-0.057706, -1.136287, 1.590113>, <-0.057772, -1.090098, 1.734230>, 
      <0.149164, -1.215656, 1.234230>, <0.142792, -1.208040, 1.385242>, <0.137558, -1.191633, 1.590113>, <0.137491, -1.145443, 1.734230>, 
      <0.441281, -1.208832, 1.234230>, <0.436041, -1.201236, 1.385931>, <0.419339, -1.208562, 1.590508>, <0.412204, -1.159661, 1.734230>, 
      <0.655153, -1.230716, 1.234230>, <0.649913, -1.223119, 1.385931>, <0.622294, -1.208562, 1.590508>, <0.615159, -1.159661, 1.734230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.178638, -0.324316, -0.689026>, <-0.181831, -0.418056, -0.626627>, <-0.142756, -0.505089, -0.450243>, <-0.076214, -0.595989, -0.450878>, 
      <-0.178638, -0.324316, -0.689026>, <-0.042707, -0.397249, -0.617868>, <-0.053999, -0.380310, -0.427929>, <0.012543, -0.471210, -0.428564>, 
      <-0.178638, -0.324316, -0.689026>, <-0.042707, -0.397249, -0.617868>, <0.007660, -0.345752, -0.528264>, <0.134879, -0.304871, -0.483441>, 
      <-0.178638, -0.324316, -0.689026>, <-0.039515, -0.303509, -0.680267>, <0.098128, -0.220987, -0.542220>, <0.225347, -0.180106, -0.497396>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.454536, -0.281790, -0.540201>, <-0.438746, -0.465071, -0.573578>, <-0.365851, -0.718726, -0.665011>, <-0.265485, -0.870141, -0.620792>, 
      <-0.250571, -0.251285, -0.527359>, <-0.234781, -0.434566, -0.560736>, <-0.352100, -0.629789, -0.598018>, <-0.251735, -0.781205, -0.553799>, 
      <0.042140, -0.184370, -0.401928>, <-0.048329, -0.309135, -0.387973>, <-0.051807, -0.561676, -0.444742>, <-0.140564, -0.686456, -0.467056>, 
      <0.225347, -0.180106, -0.497396>, <0.134879, -0.304871, -0.483441>, <0.012543, -0.471210, -0.428564>, <-0.076214, -0.595989, -0.450878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.454536, -0.281790, -0.540201>, <-0.250571, -0.251285, -0.527359>, <0.042140, -0.184370, -0.401928>, <0.225347, -0.180106, -0.497396>, 
      <-0.454536, -0.281790, -0.540201>, <-0.204182, -0.290236, -0.600420>, <-0.085079, -0.225251, -0.446752>, <0.098128, -0.220987, -0.542220>, 
      <-0.454536, -0.281790, -0.540201>, <-0.204182, -0.290236, -0.600420>, <-0.133194, -0.317519, -0.686165>, <-0.039515, -0.303509, -0.680267>, 
      <-0.454536, -0.281790, -0.540201>, <-0.408147, -0.320742, -0.613261>, <-0.272317, -0.338327, -0.694924>, <-0.178638, -0.324316, -0.689026>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.454536, -0.281790, -0.540201>, <-0.438746, -0.465071, -0.573578>, <-0.365851, -0.718726, -0.665011>, <-0.265485, -0.870141, -0.620792>, 
      <-0.408147, -0.320742, -0.613261>, <-0.392357, -0.504023, -0.646638>, <-0.352100, -0.629789, -0.598018>, <-0.251735, -0.781205, -0.553799>, 
      <-0.272317, -0.338327, -0.694924>, <-0.275510, -0.432067, -0.632525>, <-0.207106, -0.595555, -0.466421>, <-0.140564, -0.686456, -0.467056>, 
      <-0.178638, -0.324316, -0.689026>, <-0.181831, -0.418056, -0.626627>, <-0.142756, -0.505089, -0.450243>, <-0.076214, -0.595989, -0.450878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.454536, -0.281790, -0.540201>, <-0.250571, -0.251285, -0.527359>, <0.042140, -0.184370, -0.401928>, <0.225347, -0.180106, -0.497396>, 
      <-0.408147, -0.320742, -0.613261>, <-0.204182, -0.290236, -0.600420>, <-0.048329, -0.309135, -0.387973>, <0.134879, -0.304871, -0.483441>, 
      <-0.272317, -0.338327, -0.694924>, <-0.275510, -0.432067, -0.632525>, <-0.053999, -0.380310, -0.427929>, <0.012543, -0.471210, -0.428564>, 
      <-0.178638, -0.324316, -0.689026>, <-0.181831, -0.418056, -0.626627>, <-0.142756, -0.505089, -0.450243>, <-0.076214, -0.595989, -0.450878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107632, -2.214532, -1.160666>, <0.141152, -2.321002, -1.219811>, <0.107632, -2.481286, -1.286147>, <0.107632, -2.593947, -1.343288>, 
      <0.244824, -2.263600, -1.077874>, <0.278344, -2.370070, -1.137020>, <0.243795, -2.526029, -1.206050>, <0.243795, -2.638690, -1.263191>, 
      <0.480937, -2.305934, -1.088448>, <0.480937, -2.377734, -1.140318>, <0.489398, -2.520233, -1.203145>, <0.481292, -2.588644, -1.258824>, 
      <0.642045, -2.342128, -1.059850>, <0.642045, -2.413929, -1.111720>, <0.650151, -2.518140, -1.169801>, <0.642045, -2.586550, -1.225480>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -2.077434, -1.506461>, <0.022902, -2.051885, -1.595808>, <0.233113, -2.144690, -1.385394>, <0.383769, -2.156188, -1.364696>, 
      <-0.098021, -2.152209, -1.560479>, <0.022902, -2.126659, -1.649826>, <0.227537, -2.221674, -1.441704>, <0.378193, -2.233172, -1.421006>, 
      <-0.098021, -2.263369, -1.614889>, <-0.003540, -2.191175, -1.698869>, <0.234874, -2.312261, -1.528377>, <0.379930, -2.318281, -1.517728>, 
      <-0.098021, -2.343364, -1.660823>, <-0.003540, -2.271170, -1.744802>, <0.234226, -2.380355, -1.595393>, <0.379283, -2.386375, -1.584745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -2.077434, -1.506461>, <-0.098021, -2.152209, -1.560479>, <-0.098021, -2.263369, -1.614889>, <-0.098021, -2.343364, -1.660823>, 
      <-0.199128, -2.098796, -1.431756>, <-0.199128, -2.173571, -1.485774>, <-0.186376, -2.330882, -1.536355>, <-0.186376, -2.410877, -1.582289>, 
      <0.003243, -2.177196, -1.223662>, <0.036763, -2.283665, -1.282808>, <-0.005264, -2.444188, -1.352558>, <-0.005264, -2.556849, -1.409699>, 
      <0.107632, -2.214532, -1.160666>, <0.141152, -2.321002, -1.219811>, <0.107632, -2.481286, -1.286147>, <0.107632, -2.593947, -1.343288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.088363, -1.971406, -0.997459>, <-0.088363, -2.055250, -1.061838>, <0.079582, -2.125436, -1.111172>, <0.107632, -2.214532, -1.160666>, 
      <0.098579, -2.032835, -0.887490>, <0.098579, -2.116679, -0.951869>, <0.216774, -2.174505, -1.028380>, <0.244824, -2.263600, -1.077874>, 
      <0.422402, -2.055295, -0.903902>, <0.422402, -2.131669, -0.961381>, <0.480937, -2.228451, -1.032473>, <0.480937, -2.305934, -1.088448>, 
      <0.642045, -2.089147, -0.866149>, <0.642045, -2.165520, -0.923628>, <0.642045, -2.264645, -1.003875>, <0.642045, -2.342128, -1.059850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -1.845961, -1.301492>, <0.042145, -1.828117, -1.367616>, <0.258607, -1.897919, -1.244839>, <0.413971, -1.907457, -1.234439>, 
      <-0.098021, -1.919921, -1.357467>, <0.042145, -1.902077, -1.423591>, <0.256085, -1.971352, -1.287010>, <0.411449, -1.980890, -1.276610>, 
      <-0.098021, -2.002247, -1.452145>, <0.022902, -1.976698, -1.541492>, <0.238057, -2.076428, -1.335463>, <0.388713, -2.087926, -1.314766>, 
      <-0.098021, -2.077434, -1.506461>, <0.022902, -2.051885, -1.595808>, <0.233113, -2.144690, -1.385394>, <0.383769, -2.156188, -1.364696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -1.845961, -1.301492>, <-0.098021, -1.919921, -1.357467>, <-0.098021, -2.002247, -1.452145>, <-0.098021, -2.077434, -1.506461>, 
      <-0.186711, -1.857252, -1.259652>, <-0.186711, -1.931211, -1.315627>, <-0.199128, -2.023610, -1.377440>, <-0.199128, -2.098796, -1.431756>, 
      <-0.170225, -1.944506, -1.045614>, <-0.170225, -2.028350, -1.109993>, <-0.024808, -2.088100, -1.174169>, <0.003243, -2.177196, -1.223662>, 
      <-0.088363, -1.971406, -0.997459>, <-0.088363, -2.055250, -1.061838>, <0.079582, -2.125436, -1.111172>, <0.107632, -2.214532, -1.160666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107632, -1.750442, -0.804318>, <0.084550, -1.831711, -0.868126>, <-0.088363, -1.887433, -0.932981>, <-0.088363, -1.971406, -0.997459>, 
      <0.244962, -1.808491, -0.728622>, <0.221881, -1.889760, -0.792430>, <0.098579, -1.948862, -0.823013>, <0.098579, -2.032835, -0.887490>, 
      <0.480975, -1.789735, -0.697933>, <0.480975, -1.875647, -0.760000>, <0.422402, -1.970612, -0.840168>, <0.422402, -2.055295, -0.903902>, 
      <0.642045, -1.805290, -0.655819>, <0.642045, -1.891202, -0.717886>, <0.642045, -2.004464, -0.802415>, <0.642045, -2.089147, -0.866149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -1.492465, -1.063739>, <-0.098021, -1.598873, -1.134527>, <-0.098021, -1.744053, -1.224365>, <-0.098021, -1.845961, -1.301492>, 
      <-0.188018, -1.551350, -0.998270>, <-0.188018, -1.657758, -1.069059>, <-0.186711, -1.755344, -1.182525>, <-0.186711, -1.857252, -1.259652>, 
      <0.004223, -1.706731, -0.861317>, <-0.018859, -1.788000, -0.925124>, <-0.170225, -1.860533, -0.981136>, <-0.170225, -1.944506, -1.045614>, 
      <0.107632, -1.750442, -0.804318>, <0.084550, -1.831711, -0.868126>, <-0.088363, -1.887433, -0.932981>, <-0.088363, -1.971406, -0.997459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.404373, -1.556284, -1.020184>, <0.400516, -1.658508, -1.089279>, <0.417646, -1.800455, -1.172990>, <0.413971, -1.907457, -1.234439>, 
      <0.210480, -1.531654, -1.036993>, <0.206623, -1.633878, -1.106089>, <0.262282, -1.790917, -1.183391>, <0.258607, -1.897919, -1.244839>, 
      <0.010976, -1.421148, -1.143029>, <0.010976, -1.527557, -1.213818>, <0.042145, -1.726210, -1.290489>, <0.042145, -1.828117, -1.367616>, 
      <-0.098021, -1.492465, -1.063739>, <-0.098021, -1.598873, -1.134527>, <-0.098021, -1.744053, -1.224365>, <-0.098021, -1.845961, -1.301492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.060659, -1.446708, -0.585498>, <0.098254, -1.541530, -0.634552>, <0.132308, -1.663559, -0.736103>, <0.107632, -1.750442, -0.804318>, 
      <0.208076, -1.526077, -0.513871>, <0.245671, -1.620899, -0.562925>, <0.269638, -1.721608, -0.660407>, <0.244962, -1.808491, -0.728622>, 
      <0.466859, -1.561905, -0.537515>, <0.473933, -1.605004, -0.594980>, <0.480975, -1.731227, -0.655664>, <0.480975, -1.789735, -0.697933>, 
      <0.642045, -1.607798, -0.518399>, <0.649119, -1.650897, -0.575865>, <0.642045, -1.746782, -0.613550>, <0.642045, -1.805290, -0.655819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.060659, -1.446708, -0.585498>, <0.208076, -1.526077, -0.513871>, <0.466859, -1.561905, -0.537515>, <0.642045, -1.607798, -0.518399>, 
      <0.030391, -1.370366, -0.546004>, <0.177808, -1.449735, -0.474377>, <0.455219, -1.490982, -0.442949>, <0.630404, -1.536874, -0.423833>, 
      <-0.121124, -1.267927, -0.584395>, <0.049601, -1.368914, -0.443151>, <0.361330, -1.444292, -0.355526>, <0.578799, -1.504649, -0.264095>, 
      <-0.109302, -1.203288, -0.521260>, <0.061423, -1.304275, -0.380016>, <0.364270, -1.377508, -0.257344>, <0.581739, -1.437864, -0.165914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -1.209347, -0.877983>, <0.033135, -1.170198, -0.969591>, <0.229643, -1.286382, -0.859182>, <0.435579, -1.334798, -0.847366>, 
      <-0.090470, -1.295304, -0.931592>, <0.040686, -1.256155, -1.023199>, <0.235059, -1.356697, -0.906267>, <0.440996, -1.405114, -0.894451>, 
      <-0.098021, -1.407886, -1.007473>, <0.010976, -1.336569, -1.086763>, <0.213130, -1.461434, -0.989530>, <0.407023, -1.486064, -0.972721>, 
      <-0.098021, -1.492465, -1.063739>, <0.010976, -1.421148, -1.143029>, <0.210480, -1.531654, -1.036993>, <0.404373, -1.556284, -1.020184>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -1.209347, -0.877983>, <-0.103221, -1.150148, -0.841062>, <-0.114725, -1.062622, -0.802638>, <-0.140338, -1.010743, -0.763302>, 
      <0.033135, -1.170198, -0.969591>, <0.027934, -1.110999, -0.932670>, <0.025749, -1.023160, -0.853666>, <0.000137, -0.971281, -0.814330>, 
      <0.229643, -1.286382, -0.859182>, <0.223627, -1.208291, -0.806891>, <0.235323, -1.131470, -0.760894>, <0.214712, -1.051887, -0.714955>, 
      <0.435579, -1.334798, -0.847366>, <0.429563, -1.256707, -0.795074>, <0.387487, -1.149103, -0.740174>, <0.366876, -1.069520, -0.694234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -1.209347, -0.877983>, <-0.090470, -1.295304, -0.931592>, <-0.098021, -1.407886, -1.007473>, <-0.098021, -1.492465, -1.063739>, 
      <-0.195668, -1.238494, -0.809780>, <-0.188117, -1.324450, -0.863389>, <-0.188018, -1.466771, -0.942004>, <-0.188018, -1.551350, -0.998270>, 
      <-0.038606, -1.393264, -0.633729>, <-0.001011, -1.488086, -0.682783>, <0.028899, -1.619848, -0.793102>, <0.004223, -1.706731, -0.861317>, 
      <0.060659, -1.446708, -0.585498>, <0.098254, -1.541530, -0.634552>, <0.132308, -1.663559, -0.736103>, <0.107632, -1.750442, -0.804318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -1.209347, -0.877983>, <-0.195668, -1.238494, -0.809780>, <-0.038606, -1.393264, -0.633729>, <0.060659, -1.446708, -0.585498>, 
      <-0.103221, -1.150148, -0.841062>, <-0.200868, -1.179294, -0.772859>, <-0.068874, -1.316922, -0.594235>, <0.030391, -1.370366, -0.546004>, 
      <-0.114725, -1.062622, -0.802638>, <-0.199469, -1.086428, -0.771854>, <-0.186504, -1.229254, -0.638485>, <-0.121124, -1.267927, -0.584395>, 
      <-0.140338, -1.010743, -0.763302>, <-0.225082, -1.034549, -0.732518>, <-0.174682, -1.164615, -0.575350>, <-0.109302, -1.203288, -0.521260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.493065, -0.148456, -2.890632>, <0.437911, -0.162214, -2.919202>, <0.365319, -0.168673, -2.970289>, <0.309217, -0.194315, -2.985864>, 
      <0.455054, -0.265525, -2.885941>, <0.399900, -0.279282, -2.914510>, <0.384877, -0.276911, -2.985093>, <0.328775, -0.302553, -3.000668>, 
      <0.520780, -0.432163, -2.927299>, <0.466706, -0.433511, -2.925015>, <0.393527, -0.447719, -2.952823>, <0.339454, -0.449067, -2.950539>, 
      <0.532658, -0.553752, -2.943013>, <0.478584, -0.555100, -2.940729>, <0.406486, -0.556898, -2.937684>, <0.352412, -0.558246, -2.935400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.493065, -0.148456, -2.890632>, <0.455054, -0.265525, -2.885941>, <0.520780, -0.432163, -2.927299>, <0.532658, -0.553752, -2.943013>, 
      <0.515785, -0.078482, -2.893436>, <0.477774, -0.195551, -2.888745>, <0.585277, -0.427813, -2.925212>, <0.597155, -0.549402, -2.940927>, 
      <0.654159, -0.088439, -2.992457>, <0.761876, -0.193370, -3.007534>, <0.673941, -0.412100, -2.955405>, <0.688249, -0.562326, -2.947125>, 
      <0.699954, -0.038500, -2.963660>, <0.807672, -0.143431, -2.978737>, <0.733339, -0.389026, -2.944339>, <0.747647, -0.539251, -2.936058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.476437, -0.359713, -2.622880>, <0.558818, -0.355825, -2.611995>, <0.669564, -0.362940, -2.603683>, <0.752333, -0.364323, -2.595455>, 
      <0.495719, -0.389272, -2.730821>, <0.578101, -0.385384, -2.719935>, <0.671543, -0.396217, -2.713617>, <0.754312, -0.397600, -2.705390>, 
      <0.515792, -0.495540, -2.846973>, <0.580288, -0.491190, -2.844887>, <0.689654, -0.509847, -2.844944>, <0.749053, -0.486773, -2.833877>, 
      <0.532658, -0.553752, -2.943013>, <0.597155, -0.549402, -2.940927>, <0.688249, -0.562326, -2.947125>, <0.747647, -0.539251, -2.936058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.184569, -0.391117, -2.670475>, <0.270786, -0.381567, -2.649623>, <0.388087, -0.363882, -2.634554>, <0.476437, -0.359713, -2.622880>, 
      <0.208079, -0.421967, -2.769780>, <0.294297, -0.412417, -2.748929>, <0.407369, -0.393441, -2.742495>, <0.495719, -0.389272, -2.730821>, 
      <0.302059, -0.508107, -2.855922>, <0.356133, -0.506759, -2.858206>, <0.461718, -0.496889, -2.844689>, <0.515792, -0.495540, -2.846973>, 
      <0.352412, -0.558246, -2.935400>, <0.406486, -0.556898, -2.937684>, <0.478584, -0.555100, -2.940729>, <0.532658, -0.553752, -2.943013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.263817, -0.067937, -2.868338>, <0.264163, -0.099861, -2.911312>, <0.299783, -0.142103, -2.978723>, <0.309217, -0.194315, -2.985864>, 
      <0.390907, -0.037408, -2.898855>, <0.391253, -0.069332, -2.941829>, <0.355884, -0.116461, -2.963148>, <0.365319, -0.168673, -2.970289>, 
      <0.604290, 0.054689, -2.950270>, <0.558495, 0.004750, -2.979067>, <0.460630, -0.092240, -2.922006>, <0.437911, -0.162214, -2.919202>, 
      <0.699954, -0.038500, -2.963660>, <0.654159, -0.088439, -2.992457>, <0.515785, -0.078482, -2.893436>, <0.493065, -0.148456, -2.890632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.064743, -0.541827, -2.951272>, <0.020129, -0.505815, -2.893415>, <-0.047372, -0.452076, -2.824580>, <-0.083970, -0.421787, -2.758415>, 
      <0.119190, -0.607744, -2.937660>, <0.074576, -0.571732, -2.879802>, <-0.010928, -0.515097, -2.780184>, <-0.047526, -0.484808, -2.714018>, 
      <0.266111, -0.553320, -2.940162>, <0.215758, -0.503182, -2.860684>, <0.125676, -0.431094, -2.789710>, <0.102165, -0.400245, -2.690404>, 
      <0.352412, -0.558246, -2.935400>, <0.302059, -0.508107, -2.855922>, <0.208079, -0.421967, -2.769780>, <0.184569, -0.391117, -2.670475>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.145243, -0.307435, -2.987195>, <0.102159, -0.368677, -2.981099>, <0.017495, -0.484626, -2.963085>, <0.064743, -0.541827, -2.951272>, 
      <0.179516, -0.258716, -2.992045>, <0.136433, -0.319958, -2.985949>, <0.071942, -0.550542, -2.949472>, <0.119190, -0.607744, -2.937660>, 
      <0.256516, -0.218403, -3.000495>, <0.276074, -0.326641, -3.015299>, <0.253153, -0.444141, -2.955301>, <0.266111, -0.553320, -2.940162>, 
      <0.309217, -0.194315, -2.985864>, <0.328775, -0.302553, -3.000668>, <0.339454, -0.449067, -2.950539>, <0.352412, -0.558246, -2.935400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.145243, -0.307435, -2.987195>, <0.179516, -0.258716, -2.992045>, <0.256516, -0.218403, -3.000495>, <0.309217, -0.194315, -2.985864>, 
      <0.122187, -0.272268, -2.934639>, <0.156460, -0.223549, -2.939489>, <0.247082, -0.166191, -2.993354>, <0.299783, -0.142103, -2.978723>, 
      <0.079429, -0.208849, -2.875736>, <0.128152, -0.159277, -2.891136>, <0.196752, -0.116054, -2.895126>, <0.264163, -0.099861, -2.911312>, 
      <0.068389, -0.190211, -2.812009>, <0.117112, -0.140639, -2.827409>, <0.196406, -0.084130, -2.852151>, <0.263817, -0.067937, -2.868338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.145243, -0.307435, -2.987195>, <0.122187, -0.272268, -2.934639>, <0.079429, -0.208849, -2.875736>, <0.068389, -0.190211, -2.812009>, 
      <0.102159, -0.368677, -2.981099>, <0.079103, -0.333510, -2.928543>, <0.021462, -0.267826, -2.857415>, <0.010422, -0.249189, -2.793688>, 
      <0.017495, -0.484626, -2.963085>, <-0.027119, -0.448614, -2.905228>, <-0.083572, -0.389475, -2.868681>, <-0.120171, -0.359187, -2.802516>, 
      <0.064743, -0.541827, -2.951272>, <0.020129, -0.505815, -2.893415>, <-0.047372, -0.452076, -2.824580>, <-0.083970, -0.421787, -2.758415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.388552, -0.332842, -2.136312>, <0.493259, -0.333595, -2.146574>, <0.630545, -0.319732, -2.175487>, <0.734256, -0.314113, -2.192276>, 
      <0.406497, -0.339501, -2.283625>, <0.511204, -0.340255, -2.293887>, <0.630877, -0.335057, -2.296529>, <0.734588, -0.329438, -2.313318>, 
      <0.451214, -0.321047, -2.481684>, <0.533596, -0.317160, -2.470799>, <0.667462, -0.327598, -2.486924>, <0.750231, -0.328981, -2.478696>, 
      <0.476437, -0.359713, -2.622880>, <0.558818, -0.355825, -2.611995>, <0.669564, -0.362940, -2.603683>, <0.752333, -0.364323, -2.595455>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.163230, -0.310005, -2.136312>, <0.216218, -0.306786, -2.093907>, <0.320935, -0.332356, -2.129685>, <0.388552, -0.332842, -2.136312>, 
      <0.166457, -0.330352, -2.297211>, <0.219444, -0.327133, -2.254806>, <0.338880, -0.339015, -2.276998>, <0.406497, -0.339501, -2.283625>, 
      <0.148798, -0.344178, -2.519379>, <0.235015, -0.334628, -2.498527>, <0.362864, -0.325217, -2.493358>, <0.451214, -0.321047, -2.481684>, 
      <0.184569, -0.391117, -2.670475>, <0.270786, -0.381567, -2.649623>, <0.388087, -0.363882, -2.634554>, <0.476437, -0.359713, -2.622880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.148365, -0.365458, -2.565997>, <-0.113745, -0.413756, -2.417335>, <0.038372, -0.317590, -2.236234>, <0.163230, -0.310005, -2.136312>, 
      <-0.152704, -0.373130, -2.628553>, <-0.118084, -0.421428, -2.479892>, <0.041598, -0.337937, -2.397133>, <0.166457, -0.330352, -2.297211>, 
      <-0.112355, -0.398295, -2.707098>, <-0.075911, -0.461316, -2.662701>, <0.066394, -0.353306, -2.539309>, <0.148798, -0.344178, -2.519379>, 
      <-0.083970, -0.421787, -2.758415>, <-0.047526, -0.484808, -2.714018>, <0.102165, -0.400245, -2.690404>, <0.184569, -0.391117, -2.670475>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.068389, -0.177693, -2.543571>, <0.006782, -0.237667, -2.536192>, <-0.167025, -0.339425, -2.646127>, <-0.148365, -0.365458, -2.565997>, 
      <0.068389, -0.181595, -2.624095>, <0.006782, -0.241569, -2.616716>, <-0.171364, -0.347097, -2.708683>, <-0.152704, -0.373130, -2.628553>, 
      <0.055165, -0.167888, -2.735679>, <-0.002801, -0.226865, -2.717358>, <-0.148556, -0.335695, -2.751199>, <-0.112355, -0.398295, -2.707098>, 
      <0.068389, -0.190211, -2.812009>, <0.010422, -0.249189, -2.793688>, <-0.120171, -0.359187, -2.802516>, <-0.083970, -0.421787, -2.758415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306276, 0.077132, -2.620454>, <0.211598, 0.034638, -2.594001>, <0.144846, -0.103263, -2.552729>, <0.068389, -0.177693, -2.543571>, 
      <0.306276, 0.071806, -2.707392>, <0.211598, 0.029313, -2.680938>, <0.144846, -0.107165, -2.633254>, <0.068389, -0.181595, -2.624095>, 
      <0.263254, -0.015998, -2.798420>, <0.195844, -0.032191, -2.782233>, <0.103888, -0.118316, -2.751079>, <0.055165, -0.167888, -2.735679>, 
      <0.263817, -0.067937, -2.868338>, <0.196406, -0.084130, -2.852151>, <0.117112, -0.140639, -2.827409>, <0.068389, -0.190211, -2.812009>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306276, 0.077132, -2.620454>, <0.306276, 0.071806, -2.707392>, <0.263254, -0.015998, -2.798420>, <0.263817, -0.067937, -2.868338>, 
      <0.426944, 0.131291, -2.654169>, <0.426944, 0.125966, -2.741106>, <0.390344, 0.014531, -2.828937>, <0.390907, -0.037408, -2.898855>, 
      <0.620448, 0.103155, -2.680376>, <0.612275, 0.065874, -2.757583>, <0.657862, 0.113109, -2.916583>, <0.604290, 0.054689, -2.950270>, 
      <0.744554, 0.125788, -2.732492>, <0.736381, 0.088507, -2.809699>, <0.753526, 0.019920, -2.929973>, <0.699954, -0.038500, -2.963660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.381078, -0.324326, -1.840070>, <0.493057, -0.321505, -1.844246>, <0.639547, -0.287301, -1.855272>, <0.750319, -0.271433, -1.861787>, 
      <0.383299, -0.325079, -1.928977>, <0.495278, -0.322258, -1.933152>, <0.637767, -0.301284, -1.954360>, <0.748539, -0.285416, -1.960876>, 
      <0.377808, -0.328855, -2.048116>, <0.482515, -0.329608, -2.058378>, <0.630272, -0.307160, -2.076194>, <0.733984, -0.301542, -2.092983>, 
      <0.388552, -0.332842, -2.136312>, <0.493259, -0.333595, -2.146574>, <0.630545, -0.319732, -2.175487>, <0.734256, -0.314113, -2.192276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.167917, -0.286105, -1.840070>, <0.221893, -0.283626, -1.803996>, <0.316176, -0.325961, -1.837650>, <0.381078, -0.324326, -1.840070>, 
      <0.167219, -0.289348, -1.929181>, <0.221195, -0.286869, -1.893107>, <0.318397, -0.326714, -1.926556>, <0.383299, -0.325079, -1.928977>, 
      <0.161456, -0.298820, -2.047862>, <0.214444, -0.295601, -2.005456>, <0.310191, -0.328369, -2.041489>, <0.377808, -0.328855, -2.048116>, 
      <0.163230, -0.310005, -2.136312>, <0.216218, -0.306786, -2.093907>, <0.320935, -0.332356, -2.129685>, <0.388552, -0.332842, -2.136312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.039781, -0.343658, -2.121343>, <-0.005705, -0.388240, -2.031054>, <0.079598, -0.290162, -1.899096>, <0.167917, -0.286105, -1.840070>, 
      <-0.044969, -0.348697, -2.258624>, <-0.010893, -0.393279, -2.168335>, <0.078900, -0.293405, -1.988207>, <0.167219, -0.289348, -1.929181>, 
      <-0.138923, -0.348764, -2.429870>, <-0.104303, -0.397062, -2.281208>, <0.036598, -0.306405, -2.147784>, <0.161456, -0.298820, -2.047862>, 
      <-0.148365, -0.365458, -2.565997>, <-0.113745, -0.413756, -2.417335>, <0.038372, -0.317590, -2.236234>, <0.163230, -0.310005, -2.136312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.068389, -0.155893, -2.103779>, <0.023722, -0.203349, -2.106363>, <-0.060688, -0.316306, -2.176738>, <-0.039781, -0.343658, -2.121343>, 
      <0.068389, -0.161026, -2.235779>, <0.023722, -0.208482, -2.238363>, <-0.065876, -0.321345, -2.314019>, <-0.044969, -0.348697, -2.258624>, 
      <0.068389, -0.171299, -2.411626>, <0.006782, -0.231273, -2.404247>, <-0.157583, -0.322731, -2.509999>, <-0.138923, -0.348764, -2.429870>, 
      <0.068389, -0.177693, -2.543571>, <0.006782, -0.237667, -2.536192>, <-0.167025, -0.339425, -2.646127>, <-0.148365, -0.365458, -2.565997>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.263817, -0.021102, -2.103779>, <0.206486, -0.063359, -2.103779>, <0.117165, -0.104072, -2.100957>, <0.068389, -0.155893, -2.103779>, 
      <0.271142, -0.028527, -2.261728>, <0.213811, -0.070784, -2.261728>, <0.117165, -0.109204, -2.232957>, <0.068389, -0.161026, -2.235779>, 
      <0.306276, 0.086810, -2.462458>, <0.211598, 0.044317, -2.436005>, <0.144846, -0.096869, -2.420784>, <0.068389, -0.171299, -2.411626>, 
      <0.306276, 0.077132, -2.620454>, <0.211598, 0.034638, -2.594001>, <0.144846, -0.103263, -2.552729>, <0.068389, -0.177693, -2.543571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.263817, -0.021102, -2.103779>, <0.271142, -0.028527, -2.261728>, <0.306276, 0.086810, -2.462458>, <0.306276, 0.077132, -2.620454>, 
      <0.423303, 0.096451, -2.103779>, <0.430628, 0.089027, -2.261728>, <0.426944, 0.140970, -2.496172>, <0.426944, 0.131291, -2.654169>, 
      <0.681766, 0.211408, -2.103779>, <0.673110, 0.147106, -2.296720>, <0.639765, 0.191270, -2.497897>, <0.620448, 0.103155, -2.680376>, 
      <0.790982, 0.376715, -2.103779>, <0.782327, 0.312412, -2.296720>, <0.763872, 0.213903, -2.550013>, <0.744554, 0.125788, -2.732492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.185095, -0.347984, -1.339575>, <-0.197164, -0.346159, -1.144653>, <-0.180575, -0.331416, -0.884191>, <-0.178638, -0.324316, -0.689026>, 
      <-0.063827, -0.323422, -1.205076>, <-0.075896, -0.321597, -1.010154>, <-0.041452, -0.310609, -0.875432>, <-0.039515, -0.303509, -0.680267>, 
      <0.097865, -0.290673, -1.025743>, <0.104494, -0.278191, -0.905619>, <0.205369, -0.218491, -0.598102>, <0.098128, -0.220987, -0.542220>, 
      <0.219133, -0.266111, -0.891244>, <0.225763, -0.253629, -0.771119>, <0.332588, -0.177610, -0.553278>, <0.225347, -0.180106, -0.497396>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.263817, 0.120171, -1.704893>, <0.282393, 0.132130, -1.581887>, <0.393464, 0.033884, -1.433689>, <0.383526, 0.055965, -1.311083>, 
      <0.408199, 0.243411, -1.698415>, <0.426775, 0.255369, -1.575409>, <0.505463, 0.154688, -1.428192>, <0.495524, 0.176769, -1.305586>, 
      <0.677059, 0.318780, -1.700709>, <0.671959, 0.331022, -1.579524>, <0.697087, 0.284079, -1.418993>, <0.690507, 0.307918, -1.299619>, 
      <0.790982, 0.470725, -1.697508>, <0.785883, 0.482967, -1.576323>, <0.763434, 0.434806, -1.412135>, <0.756854, 0.458644, -1.292761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.263817, 0.120171, -1.704893>, <0.244948, 0.108023, -1.829843>, <0.257943, -0.015147, -1.977106>, <0.263817, -0.021102, -2.103779>, 
      <0.408199, 0.243411, -1.698415>, <0.389330, 0.231263, -1.823365>, <0.417428, 0.102406, -1.977106>, <0.423303, 0.096451, -2.103779>, 
      <0.677059, 0.318780, -1.700709>, <0.682292, 0.306217, -1.825068>, <0.687085, 0.250927, -1.985202>, <0.681766, 0.211408, -2.103779>, 
      <0.790982, 0.470725, -1.697508>, <0.796215, 0.458162, -1.821867>, <0.796301, 0.416234, -1.985202>, <0.790982, 0.376715, -2.103779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.373604, -0.327772, -1.537993>, <0.488881, -0.314823, -1.540159>, <0.634150, -0.254653, -1.545594>, <0.745812, -0.223317, -1.548851>, 
      <0.375190, -0.335313, -1.628322>, <0.490466, -0.322365, -1.630487>, <0.638702, -0.266153, -1.639779>, <0.750364, -0.234817, -1.643036>, 
      <0.378814, -0.323558, -1.749445>, <0.490793, -0.320737, -1.753620>, <0.641236, -0.274030, -1.761225>, <0.752008, -0.258162, -1.767740>, 
      <0.381078, -0.324326, -1.840070>, <0.493057, -0.321505, -1.844246>, <0.639547, -0.287301, -1.855272>, <0.750319, -0.271433, -1.861787>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.373604, -0.327772, -1.537993>, <0.370182, -0.311499, -1.343079>, <0.366641, -0.277962, -1.084075>, <0.364422, -0.245109, -0.891244>, 
      <0.488881, -0.314823, -1.540159>, <0.485459, -0.298550, -1.345244>, <0.468654, -0.251105, -1.090591>, <0.466434, -0.218252, -0.897759>, 
      <0.634150, -0.254653, -1.545594>, <0.624938, -0.231381, -1.354983>, <0.614855, -0.202762, -1.097213>, <0.602451, -0.182443, -0.906446>, 
      <0.745812, -0.223317, -1.548851>, <0.736600, -0.200044, -1.358241>, <0.716868, -0.175905, -1.103728>, <0.704463, -0.155586, -0.912961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.167917, -0.288231, -1.537993>, <0.227416, -0.287496, -1.517803>, <0.311172, -0.334785, -1.536820>, <0.373604, -0.327772, -1.537993>, 
      <0.163033, -0.290137, -1.628467>, <0.222533, -0.289402, -1.608277>, <0.312757, -0.342326, -1.627149>, <0.375190, -0.335313, -1.628322>, 
      <0.168626, -0.282809, -1.749507>, <0.222602, -0.280330, -1.713434>, <0.313911, -0.325193, -1.747025>, <0.378814, -0.323558, -1.749445>, 
      <0.167917, -0.286105, -1.840070>, <0.221893, -0.283626, -1.803996>, <0.316176, -0.325961, -1.837650>, <0.381078, -0.324326, -1.840070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.167917, -0.288231, -1.537993>, <0.178411, -0.284134, -1.343574>, <0.208459, -0.286208, -1.084655>, <0.219133, -0.266111, -0.891244>, 
      <0.227416, -0.287496, -1.517803>, <0.237911, -0.283399, -1.323384>, <0.252045, -0.279907, -1.084655>, <0.262720, -0.259810, -0.891244>, 
      <0.311172, -0.334785, -1.536820>, <0.307750, -0.318512, -1.341906>, <0.323055, -0.284262, -1.084075>, <0.320835, -0.251410, -0.891244>, 
      <0.373604, -0.327772, -1.537993>, <0.370182, -0.311499, -1.343079>, <0.366641, -0.277962, -1.084075>, <0.364422, -0.245109, -0.891244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.115790, -0.333820, -1.704058>, <-0.136145, -0.334426, -1.594550>, <-0.178212, -0.349025, -1.450743>, <-0.185095, -0.347984, -1.339575>, 
      <-0.077495, -0.388525, -1.630207>, <-0.097850, -0.389131, -1.520700>, <-0.056943, -0.324463, -1.316243>, <-0.063827, -0.323422, -1.205076>, 
      <0.073639, -0.289396, -1.569984>, <0.084134, -0.285299, -1.375565>, <0.087190, -0.310770, -1.219155>, <0.097865, -0.290673, -1.025743>, 
      <0.167917, -0.288231, -1.537993>, <0.178411, -0.284134, -1.343574>, <0.208459, -0.286208, -1.084655>, <0.219133, -0.266111, -0.891244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.115790, -0.333820, -1.704058>, <-0.077495, -0.388525, -1.630207>, <0.073639, -0.289396, -1.569984>, <0.167917, -0.288231, -1.537993>, 
      <-0.092530, -0.333128, -1.829192>, <-0.054235, -0.387833, -1.755342>, <0.068755, -0.291303, -1.660458>, <0.163033, -0.290137, -1.628467>, 
      <-0.034977, -0.338993, -1.994240>, <-0.000901, -0.383575, -1.903951>, <0.080307, -0.286866, -1.808534>, <0.168626, -0.282809, -1.749507>, 
      <-0.039781, -0.343658, -2.121343>, <-0.005705, -0.388240, -2.031054>, <0.079598, -0.290162, -1.899096>, <0.167917, -0.286105, -1.840070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.068389, -0.146055, -1.729928>, <0.066432, -0.133829, -1.611586>, <0.072056, -0.093830, -1.456224>, <0.055753, -0.076942, -1.339575>, 
      <0.017530, -0.206879, -1.729816>, <0.015574, -0.194653, -1.611474>, <-0.000198, -0.175143, -1.456224>, <-0.016501, -0.158255, -1.339575>, 
      <-0.146286, -0.290257, -1.762867>, <-0.166641, -0.290863, -1.653359>, <-0.105957, -0.267712, -1.450743>, <-0.112841, -0.266671, -1.339575>, 
      <-0.115790, -0.333820, -1.704058>, <-0.136145, -0.334426, -1.594550>, <-0.178212, -0.349025, -1.450743>, <-0.185095, -0.347984, -1.339575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.068389, -0.146055, -1.729928>, <0.132125, -0.069830, -1.730068>, <0.188287, 0.055701, -1.708282>, <0.263817, 0.120171, -1.704893>, 
      <0.066432, -0.133829, -1.611586>, <0.130168, -0.057604, -1.611727>, <0.206863, 0.067660, -1.585276>, <0.282393, 0.132130, -1.581887>, 
      <0.072056, -0.093830, -1.456224>, <0.170388, -0.053958, -1.447677>, <0.295132, -0.005988, -1.442236>, <0.393464, 0.033884, -1.433689>, 
      <0.055753, -0.076942, -1.339575>, <0.154085, -0.037070, -1.331027>, <0.285194, 0.016093, -1.319631>, <0.383526, 0.055965, -1.311083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.068389, -0.146055, -1.729928>, <0.017530, -0.206879, -1.729816>, <-0.146286, -0.290257, -1.762867>, <-0.115790, -0.333820, -1.704058>, 
      <0.070234, -0.157583, -1.841513>, <0.019375, -0.218407, -1.841401>, <-0.123026, -0.289565, -1.888001>, <-0.092530, -0.333128, -1.829192>, 
      <0.068389, -0.151534, -1.991670>, <0.023722, -0.198990, -1.994254>, <-0.055884, -0.311640, -2.049634>, <-0.034977, -0.338993, -1.994240>, 
      <0.068389, -0.155893, -2.103779>, <0.023722, -0.203349, -2.106363>, <-0.060688, -0.316306, -2.176738>, <-0.039781, -0.343658, -2.121343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.068389, -0.146055, -1.729928>, <0.070234, -0.157583, -1.841513>, <0.068389, -0.151534, -1.991670>, <0.068389, -0.155893, -2.103779>, 
      <0.132125, -0.069830, -1.730068>, <0.133970, -0.081358, -1.841653>, <0.117165, -0.099712, -1.988848>, <0.117165, -0.104072, -2.100957>, 
      <0.188287, 0.055701, -1.708282>, <0.169418, 0.043554, -1.833232>, <0.200612, -0.057404, -1.977106>, <0.206486, -0.063359, -2.103779>, 
      <0.263817, 0.120171, -1.704893>, <0.244948, 0.108023, -1.829843>, <0.257943, -0.015147, -1.977106>, <0.263817, -0.021102, -2.103779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361642, -0.150701, -0.498666>, <0.456333, -0.124475, -0.502770>, <0.580869, -0.084142, -0.511413>, <0.674824, -0.055617, -0.516876>, 
      <0.362476, -0.179023, -0.616439>, <0.457167, -0.152797, -0.620543>, <0.589761, -0.114133, -0.630239>, <0.683716, -0.085608, -0.635702>, 
      <0.363048, -0.224766, -0.771838>, <0.465060, -0.197909, -0.778354>, <0.593559, -0.152452, -0.787620>, <0.695571, -0.125595, -0.794135>, 
      <0.364422, -0.245109, -0.891244>, <0.466434, -0.218252, -0.897759>, <0.602451, -0.182443, -0.906446>, <0.704463, -0.155586, -0.912961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361642, -0.150701, -0.498666>, <0.362476, -0.179023, -0.616439>, <0.363048, -0.224766, -0.771838>, <0.364422, -0.245109, -0.891244>, 
      <0.321364, -0.161857, -0.496920>, <0.322198, -0.190179, -0.614694>, <0.319461, -0.231066, -0.771838>, <0.320835, -0.251410, -0.891244>, 
      <0.263105, -0.167973, -0.484093>, <0.370345, -0.165477, -0.539975>, <0.269349, -0.247329, -0.771119>, <0.262720, -0.259810, -0.891244>, 
      <0.225347, -0.180106, -0.497396>, <0.332588, -0.177610, -0.553278>, <0.225763, -0.253629, -0.771119>, <0.219133, -0.266111, -0.891244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056483, -0.016704, -0.836482>, <-0.112469, -0.102815, -0.800892>, <-0.175557, -0.233865, -0.749236>, <-0.178638, -0.324316, -0.689026>, 
      <0.000887, -0.087024, -0.962986>, <-0.055098, -0.173135, -0.927396>, <-0.177494, -0.240965, -0.944400>, <-0.180575, -0.331416, -0.884191>, 
      <0.034421, -0.054844, -1.186944>, <-0.037834, -0.136157, -1.186944>, <-0.124910, -0.264846, -1.144653>, <-0.197164, -0.346159, -1.144653>, 
      <0.055753, -0.076942, -1.339575>, <-0.016501, -0.158255, -1.339575>, <-0.112841, -0.266671, -1.339575>, <-0.185095, -0.347984, -1.339575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.201036, 0.259659, -0.930385>, <0.355492, 0.385204, -0.937564>, <0.606396, 0.494339, -0.895003>, <0.745575, 0.635222, -0.873763>, 
      <0.248199, 0.193986, -1.045441>, <0.402655, 0.319531, -1.052621>, <0.620867, 0.465907, -1.027669>, <0.760046, 0.606790, -1.006429>, 
      <0.372343, 0.080811, -1.173124>, <0.484342, 0.201615, -1.167627>, <0.683142, 0.334599, -1.166008>, <0.749489, 0.485325, -1.159150>, 
      <0.383526, 0.055965, -1.311083>, <0.495524, 0.176769, -1.305586>, <0.690507, 0.307918, -1.299619>, <0.756854, 0.458644, -1.292761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.201036, 0.259659, -0.930385>, <0.248199, 0.193986, -1.045441>, <0.372343, 0.080811, -1.173124>, <0.383526, 0.055965, -1.311083>, 
      <0.110480, 0.186053, -0.926176>, <0.157642, 0.120380, -1.041232>, <0.274011, 0.040939, -1.181671>, <0.285194, 0.016093, -1.319631>, 
      <0.003659, 0.075801, -0.874714>, <0.061030, 0.005481, -1.001219>, <0.132753, -0.014972, -1.178397>, <0.154085, -0.037070, -1.331027>, 
      <-0.056483, -0.016704, -0.836482>, <0.000887, -0.087024, -0.962986>, <0.034421, -0.054844, -1.186944>, <0.055753, -0.076942, -1.339575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.305472, 0.623366, 0.260199>, <-0.374356, 0.658257, 0.279935>, <-0.470132, 0.706240, 0.294121>, <-0.535086, 0.739669, 0.325985>, 
      <-0.341643, 0.562588, 0.255928>, <-0.410527, 0.597479, 0.275664>, <-0.505944, 0.648732, 0.307533>, <-0.570898, 0.682161, 0.339398>, 
      <-0.359850, 0.528083, 0.213570>, <-0.428986, 0.567488, 0.230249>, <-0.522764, 0.616370, 0.254353>, <-0.593694, 0.651463, 0.273009>, 
      <-0.368918, 0.484126, 0.158742>, <-0.438055, 0.523530, 0.175421>, <-0.528442, 0.580381, 0.195683>, <-0.599373, 0.615474, 0.214339>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.257321, 0.671645, 0.171919>, <-0.324801, 0.711216, 0.171486>, <-0.416380, 0.761410, 0.168311>, <-0.482253, 0.803547, 0.170474>, 
      <-0.268839, 0.669286, 0.203250>, <-0.336319, 0.708856, 0.202816>, <-0.432546, 0.763240, 0.218613>, <-0.498420, 0.805377, 0.220776>, 
      <-0.283496, 0.660293, 0.262794>, <-0.352380, 0.695184, 0.282530>, <-0.434864, 0.762874, 0.280912>, <-0.499818, 0.796303, 0.312776>, 
      <-0.305472, 0.623366, 0.260199>, <-0.374356, 0.658257, 0.279935>, <-0.470132, 0.706240, 0.294121>, <-0.535086, 0.739669, 0.325985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.212993, 0.642309, 0.008651>, <-0.274600, 0.667552, -0.005113>, <-0.357315, 0.702021, -0.019912>, <-0.418350, 0.726453, -0.037229>, 
      <-0.226061, 0.665335, 0.069399>, <-0.287668, 0.690578, 0.055635>, <-0.368097, 0.756073, 0.049955>, <-0.429133, 0.780505, 0.032638>, 
      <-0.239591, 0.675277, 0.123692>, <-0.307071, 0.714847, 0.123259>, <-0.395226, 0.759015, 0.102494>, <-0.461100, 0.801152, 0.104657>, 
      <-0.257321, 0.671645, 0.171919>, <-0.324801, 0.711216, 0.171486>, <-0.416380, 0.761410, 0.168311>, <-0.482253, 0.803547, 0.170474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.187467, 0.548564, -0.152797>, <-0.257833, 0.534474, -0.172904>, <-0.362775, 0.518038, -0.177701>, <-0.422019, 0.501599, -0.219819>, 
      <-0.171564, 0.572856, -0.156335>, <-0.241930, 0.558767, -0.176442>, <-0.335138, 0.552809, -0.184710>, <-0.394382, 0.536370, -0.226828>, 
      <-0.198652, 0.617040, -0.058014>, <-0.260259, 0.642283, -0.071778>, <-0.343769, 0.634117, -0.107684>, <-0.404804, 0.658548, -0.125001>, 
      <-0.212993, 0.642309, 0.008651>, <-0.274600, 0.667552, -0.005113>, <-0.357315, 0.702021, -0.019912>, <-0.418350, 0.726453, -0.037229>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.342317, 0.444761, 0.037427>, <-0.409602, 0.473312, 0.026310>, <-0.498543, 0.520038, 0.021305>, <-0.566602, 0.539932, 0.000369>, 
      <-0.291390, 0.462847, -0.050012>, <-0.358675, 0.491398, -0.061129>, <-0.460790, 0.495797, -0.071113>, <-0.528849, 0.515692, -0.092049>, 
      <-0.209946, 0.514227, -0.147795>, <-0.280311, 0.500138, -0.167902>, <-0.388170, 0.486087, -0.171260>, <-0.447415, 0.469648, -0.213378>, 
      <-0.187467, 0.548564, -0.152797>, <-0.257833, 0.534474, -0.172904>, <-0.362775, 0.518038, -0.177701>, <-0.422019, 0.501599, -0.219819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.342317, 0.444761, 0.037427>, <-0.367229, 0.435914, 0.080199>, <-0.375353, 0.452932, 0.119834>, <-0.368918, 0.484126, 0.158742>, 
      <-0.409602, 0.473312, 0.026310>, <-0.434515, 0.464465, 0.069082>, <-0.444490, 0.492336, 0.136513>, <-0.438055, 0.523530, 0.175421>, 
      <-0.498543, 0.520038, 0.021305>, <-0.531060, 0.540916, 0.100904>, <-0.535718, 0.534271, 0.120515>, <-0.528442, 0.580381, 0.195683>, 
      <-0.566602, 0.539932, 0.000369>, <-0.599118, 0.560810, 0.079968>, <-0.606649, 0.569365, 0.139171>, <-0.599373, 0.615474, 0.214339>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.585301, 0.767380, 0.397474>, <-0.575658, 0.756774, 0.374011>, <-0.557495, 0.751202, 0.336978>, <-0.535086, 0.739669, 0.325985>, 
      <-0.635594, 0.699998, 0.417857>, <-0.625952, 0.689392, 0.394394>, <-0.593307, 0.693694, 0.350391>, <-0.570898, 0.682161, 0.339398>, 
      <-0.680902, 0.682975, 0.320138>, <-0.657320, 0.699596, 0.310641>, <-0.620192, 0.664573, 0.279979>, <-0.593694, 0.651463, 0.273009>, 
      <-0.691980, 0.643963, 0.243714>, <-0.668398, 0.660584, 0.234217>, <-0.625870, 0.628584, 0.221308>, <-0.599373, 0.615474, 0.214339>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.537534, 0.850887, 0.181120>, <-0.550163, 0.833151, 0.177531>, <-0.500835, 0.815433, 0.171084>, <-0.482253, 0.803547, 0.170474>, 
      <-0.554499, 0.854106, 0.250023>, <-0.567127, 0.836370, 0.246433>, <-0.517002, 0.817263, 0.221386>, <-0.498420, 0.805377, 0.220776>, 
      <-0.532180, 0.838551, 0.375945>, <-0.522537, 0.827945, 0.352482>, <-0.522227, 0.807835, 0.323769>, <-0.499818, 0.796303, 0.312776>, 
      <-0.585301, 0.767380, 0.397474>, <-0.575658, 0.756774, 0.374011>, <-0.557495, 0.751202, 0.336978>, <-0.535086, 0.739669, 0.325985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.471509, 0.745790, -0.064697>, <-0.481828, 0.731047, -0.059038>, <-0.435286, 0.733232, -0.042034>, <-0.418350, 0.726453, -0.037229>, 
      <-0.495507, 0.807703, 0.018284>, <-0.505826, 0.792959, 0.023942>, <-0.446069, 0.787284, 0.027832>, <-0.429133, 0.780505, 0.032638>, 
      <-0.517804, 0.847144, 0.100986>, <-0.530433, 0.829407, 0.097396>, <-0.479681, 0.813038, 0.105267>, <-0.461100, 0.801152, 0.104657>, 
      <-0.537534, 0.850887, 0.181120>, <-0.550163, 0.833151, 0.177531>, <-0.500835, 0.815433, 0.171084>, <-0.482253, 0.803547, 0.170474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.397734, 0.490218, -0.302280>, <-0.361815, 0.532324, -0.303696>, <-0.440427, 0.665602, -0.172172>, <-0.471509, 0.745790, -0.064697>, 
      <-0.404164, 0.497022, -0.278009>, <-0.368244, 0.539127, -0.279425>, <-0.450747, 0.650859, -0.166513>, <-0.481828, 0.731047, -0.059038>, 
      <-0.442699, 0.495861, -0.234521>, <-0.415062, 0.530631, -0.241530>, <-0.421740, 0.665328, -0.129807>, <-0.435286, 0.733232, -0.042034>, 
      <-0.422019, 0.501599, -0.219819>, <-0.394382, 0.536370, -0.226828>, <-0.404804, 0.658548, -0.125001>, <-0.418350, 0.726453, -0.037229>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.651267, 0.535071, -0.057612>, <-0.588146, 0.502090, -0.174737>, <-0.433504, 0.448287, -0.300870>, <-0.397734, 0.490218, -0.302280>, 
      <-0.635439, 0.560219, -0.049435>, <-0.572318, 0.527238, -0.166560>, <-0.439934, 0.455090, -0.276599>, <-0.404164, 0.497022, -0.278009>, 
      <-0.594973, 0.548225, -0.008358>, <-0.557220, 0.523985, -0.100776>, <-0.468095, 0.463909, -0.228080>, <-0.442699, 0.495861, -0.234521>, 
      <-0.566602, 0.539932, 0.000369>, <-0.528849, 0.515692, -0.092049>, <-0.447415, 0.469648, -0.213378>, <-0.422019, 0.501599, -0.219819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.651267, 0.535071, -0.057612>, <-0.635439, 0.560219, -0.049435>, <-0.594973, 0.548225, -0.008358>, <-0.566602, 0.539932, 0.000369>, 
      <-0.708664, 0.565061, 0.048893>, <-0.692836, 0.590209, 0.057070>, <-0.627489, 0.569103, 0.071241>, <-0.599118, 0.560810, 0.079968>, 
      <-0.707940, 0.587757, 0.133608>, <-0.684359, 0.604378, 0.124111>, <-0.633146, 0.582475, 0.146140>, <-0.606649, 0.569365, 0.139171>, 
      <-0.691980, 0.643963, 0.243714>, <-0.668398, 0.660584, 0.234217>, <-0.625870, 0.628584, 0.221308>, <-0.599373, 0.615474, 0.214339>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.086316, 0.865645, 0.348699>, <-0.031695, 0.934735, 0.618985>, <0.096558, 1.077755, 0.955859>, <0.139735, 1.115928, 1.234230>, 
      <0.135495, 0.888930, 0.324120>, <0.190116, 0.958020, 0.594406>, <0.248840, 1.134430, 0.955859>, <0.292017, 1.172603, 1.234230>, 
      <0.432675, 0.931663, 0.368676>, <0.432675, 1.027943, 0.626017>, <0.508281, 1.182692, 0.964241>, <0.500324, 1.233061, 1.234230>, 
      <0.655153, 0.959570, 0.377120>, <0.655153, 1.055850, 0.634462>, <0.663110, 1.231985, 0.964241>, <0.655153, 1.282354, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.086316, 0.865645, 0.348699>, <-0.031695, 0.934735, 0.618985>, <0.096558, 1.077755, 0.955859>, <0.139735, 1.115928, 1.234230>, 
      <-0.251025, 0.848354, 0.366950>, <-0.196404, 0.917445, 0.637237>, <-0.055743, 1.021074, 0.955859>, <-0.012566, 1.059246, 1.234230>, 
      <-0.505784, 0.946257, 0.476564>, <-0.446684, 0.982185, 0.695228>, <-0.293415, 1.013477, 1.010462>, <-0.243468, 1.019003, 1.234230>, 
      <-0.613893, 0.826349, 0.517743>, <-0.554793, 0.862277, 0.736407>, <-0.409089, 0.899338, 1.010462>, <-0.359143, 0.904864, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.379818, 0.456945, -0.379121>, <-0.481340, 0.257065, -0.420287>, <-0.473786, -0.058347, -0.499511>, <-0.454536, -0.281790, -0.540201>, 
      <-0.287297, 0.319507, -0.523955>, <-0.388819, 0.119627, -0.565121>, <-0.427398, -0.097298, -0.572571>, <-0.408147, -0.320742, -0.613261>, 
      <-0.137573, 0.082689, -0.657676>, <-0.193558, -0.003422, -0.622086>, <-0.269237, -0.247875, -0.755134>, <-0.272317, -0.338327, -0.694924>, 
      <-0.056483, -0.016704, -0.836482>, <-0.112469, -0.102815, -0.800892>, <-0.175557, -0.233865, -0.749236>, <-0.178638, -0.324316, -0.689026>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.747888, 0.510795, 0.274150>, <-0.756630, 0.553719, 0.280617>, <-0.726359, 0.619732, 0.257559>, <-0.691980, 0.643963, 0.243714>, 
      <-0.736555, 0.589994, 0.371705>, <-0.745296, 0.632918, 0.378172>, <-0.715281, 0.658744, 0.333983>, <-0.680902, 0.682975, 0.320138>, 
      <-0.654092, 0.731683, 0.444665>, <-0.664680, 0.725246, 0.405489>, <-0.650005, 0.715848, 0.452921>, <-0.635594, 0.699998, 0.417857>, 
      <-0.613893, 0.826349, 0.517743>, <-0.624482, 0.819912, 0.478567>, <-0.599711, 0.783230, 0.432538>, <-0.585301, 0.767380, 0.397474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.380362, 0.946646, 0.199435>, <-0.435571, 0.948485, 0.204661>, <-0.505779, 0.895484, 0.190146>, <-0.537534, 0.850887, 0.181120>, 
      <-0.432756, 0.942409, 0.311535>, <-0.487966, 0.944248, 0.316761>, <-0.522744, 0.898703, 0.259049>, <-0.554499, 0.854106, 0.250023>, 
      <-0.543834, 0.862438, 0.422251>, <-0.554422, 0.856001, 0.383074>, <-0.546590, 0.854401, 0.411009>, <-0.532180, 0.838551, 0.375945>, 
      <-0.613893, 0.826349, 0.517743>, <-0.624482, 0.819912, 0.478567>, <-0.599711, 0.783230, 0.432538>, <-0.585301, 0.767380, 0.397474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.332502, 0.849106, -0.084306>, <-0.383515, 0.848743, -0.072821>, <-0.442905, 0.786657, -0.080383>, <-0.471509, 0.745790, -0.064697>, 
      <-0.332396, 0.753574, -0.197172>, <-0.383409, 0.753212, -0.185687>, <-0.411823, 0.706469, -0.187858>, <-0.440427, 0.665602, -0.172172>, 
      <-0.365623, 0.574593, -0.290677>, <-0.376424, 0.590638, -0.273769>, <-0.355465, 0.525605, -0.327664>, <-0.361815, 0.532324, -0.303696>, 
      <-0.379818, 0.456945, -0.379121>, <-0.390619, 0.472989, -0.362213>, <-0.391385, 0.483500, -0.326248>, <-0.397734, 0.490218, -0.302280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.332502, 0.849106, -0.084306>, <-0.383515, 0.848743, -0.072821>, <-0.442905, 0.786657, -0.080383>, <-0.471509, 0.745790, -0.064697>, 
      <-0.332567, 0.907994, -0.014733>, <-0.383580, 0.907631, -0.003248>, <-0.466903, 0.848570, 0.002598>, <-0.495507, 0.807703, 0.018284>, 
      <-0.341790, 0.949765, 0.116908>, <-0.396999, 0.951604, 0.122134>, <-0.486049, 0.891741, 0.110012>, <-0.517804, 0.847144, 0.100986>, 
      <-0.380362, 0.946646, 0.199435>, <-0.435571, 0.948485, 0.204661>, <-0.505779, 0.895484, 0.190146>, <-0.537534, 0.850887, 0.181120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.680856, 0.358407, -0.058653>, <-0.614671, 0.348724, -0.176121>, <-0.470129, 0.427384, -0.282981>, <-0.379818, 0.456945, -0.379121>, 
      <-0.689895, 0.411284, -0.055477>, <-0.623710, 0.401601, -0.172945>, <-0.480930, 0.443428, -0.266073>, <-0.390619, 0.472989, -0.362213>, 
      <-0.678867, 0.491221, -0.071870>, <-0.615746, 0.458240, -0.188995>, <-0.427155, 0.441568, -0.324838>, <-0.391385, 0.483500, -0.326248>, 
      <-0.651267, 0.535071, -0.057612>, <-0.588146, 0.502090, -0.174737>, <-0.433504, 0.448287, -0.300870>, <-0.397734, 0.490218, -0.302280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.680856, 0.358407, -0.058653>, <-0.689895, 0.411284, -0.055477>, <-0.678867, 0.491221, -0.071870>, <-0.651267, 0.535071, -0.057612>, 
      <-0.735514, 0.366404, 0.038358>, <-0.744553, 0.419281, 0.041534>, <-0.736264, 0.521212, 0.034635>, <-0.708664, 0.565061, 0.048893>, 
      <-0.757916, 0.440717, 0.187830>, <-0.766658, 0.483641, 0.194297>, <-0.742319, 0.563526, 0.147453>, <-0.707940, 0.587757, 0.133608>, 
      <-0.747888, 0.510795, 0.274150>, <-0.756630, 0.553719, 0.280617>, <-0.726359, 0.619732, 0.257559>, <-0.691980, 0.643963, 0.243714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.684262, 0.202433, 0.576458>, <-0.688584, 0.391441, 0.569549>, <-0.736644, 0.690200, 0.564499>, <-0.613893, 0.826349, 0.517743>, 
      <-0.718304, 0.212436, 0.772591>, <-0.722627, 0.401443, 0.765682>, <-0.677543, 0.726128, 0.783163>, <-0.554793, 0.862277, 0.736407>, 
      <-0.768301, 0.211149, 1.035122>, <-0.725802, 0.450470, 1.035122>, <-0.582107, 0.728617, 1.010462>, <-0.409089, 0.899338, 1.010462>, 
      <-0.777409, 0.210958, 1.234230>, <-0.734910, 0.450279, 1.234230>, <-0.532161, 0.734143, 1.234230>, <-0.359143, 0.904864, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.584980, -0.437943, 0.563958>, <-0.671926, -0.264021, 0.563958>, <-0.679819, 0.008169, 0.583559>, <-0.684262, 0.202433, 0.576458>, 
      <-0.641166, -0.553463, 0.764548>, <-0.728112, -0.379541, 0.764548>, <-0.713862, 0.018172, 0.779692>, <-0.718304, 0.212436, 0.772591>, 
      <-0.661441, -0.783501, 1.007138>, <-0.811024, -0.499192, 1.007138>, <-0.824472, -0.105161, 1.035122>, <-0.768301, 0.211149, 1.035122>, 
      <-0.671601, -0.854662, 1.234230>, <-0.821183, -0.570353, 1.234230>, <-0.833580, -0.105351, 1.234230>, <-0.777409, 0.210958, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008915, -1.148489, 0.576458>, <-0.241245, -1.002419, 0.574116>, <-0.462262, -0.683421, 0.563958>, <-0.584980, -0.437943, 0.563958>, 
      <-0.025186, -1.156895, 0.773498>, <-0.257517, -1.010824, 0.771157>, <-0.518448, -0.798941, 0.764548>, <-0.641166, -0.553463, 0.764548>, 
      <-0.049343, -1.166988, 1.036767>, <-0.246866, -1.111002, 1.036767>, <-0.565849, -0.965193, 1.007138>, <-0.661441, -0.783501, 1.007138>, 
      <-0.057676, -1.157029, 1.234230>, <-0.255199, -1.101043, 1.234230>, <-0.576009, -1.036353, 1.234230>, <-0.671601, -0.854662, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008915, -1.148489, 0.576458>, <-0.025186, -1.156895, 0.773498>, <-0.049343, -1.166988, 1.036767>, <-0.057676, -1.157029, 1.234230>, 
      <0.160647, -1.255096, 0.578167>, <0.144375, -1.263502, 0.775208>, <0.157497, -1.225615, 1.036767>, <0.149164, -1.215656, 1.234230>, 
      <0.455909, -1.197117, 0.576458>, <0.455909, -1.207361, 0.773563>, <0.448087, -1.218698, 1.037224>, <0.441281, -1.208832, 1.234230>, 
      <0.655153, -1.217638, 0.576458>, <0.655153, -1.227882, 0.773563>, <0.661958, -1.240581, 1.037224>, <0.655153, -1.230716, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.081801, 0.835706, 0.137980>, <-0.086489, 0.849962, 0.200057>, <-0.098587, 0.850123, 0.287977>, <-0.086316, 0.865645, 0.348699>, 
      <0.138022, 0.817648, 0.118903>, <0.133333, 0.831905, 0.180979>, <0.123224, 0.873408, 0.263398>, <0.135495, 0.888930, 0.324120>, 
      <0.434061, 0.853895, 0.118008>, <0.434061, 0.884890, 0.197670>, <0.432675, 0.901711, 0.288616>, <0.432675, 0.931663, 0.368676>, 
      <0.655153, 0.861582, 0.109568>, <0.655153, 0.892577, 0.189230>, <0.655153, 0.929617, 0.297060>, <0.655153, 0.959570, 0.377120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.081801, 0.835706, 0.137980>, <-0.178428, 0.843643, 0.146366>, <-0.283534, 0.943421, 0.190269>, <-0.380362, 0.946646, 0.199435>, 
      <-0.086489, 0.849962, 0.200057>, <-0.183116, 0.857900, 0.208442>, <-0.335928, 0.939183, 0.302369>, <-0.432756, 0.942409, 0.311535>, 
      <-0.098587, 0.850123, 0.287977>, <-0.263296, 0.832832, 0.306228>, <-0.435725, 0.982347, 0.381072>, <-0.543834, 0.862438, 0.422251>, 
      <-0.086316, 0.865645, 0.348699>, <-0.251025, 0.848354, 0.366950>, <-0.505784, 0.946257, 0.476564>, <-0.613893, 0.826349, 0.517743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.592746, 0.156699, 0.170303>, <-0.645811, 0.263417, 0.185026>, <-0.724180, 0.394383, 0.256611>, <-0.747888, 0.510795, 0.274150>, 
      <-0.614948, 0.193447, 0.288393>, <-0.668013, 0.300165, 0.303115>, <-0.712847, 0.473583, 0.354167>, <-0.736555, 0.589994, 0.371705>, 
      <-0.662801, 0.196127, 0.452812>, <-0.667124, 0.385135, 0.445903>, <-0.776842, 0.595534, 0.491421>, <-0.654092, 0.731683, 0.444665>, 
      <-0.684262, 0.202433, 0.576458>, <-0.688584, 0.391441, 0.569549>, <-0.736644, 0.690200, 0.564499>, <-0.613893, 0.826349, 0.517743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.373591, -0.241947, 0.170303>, <-0.433754, -0.119449, 0.170303>, <-0.532441, 0.035420, 0.153572>, <-0.592746, 0.156699, 0.170303>, 
      <-0.428555, -0.273275, 0.302301>, <-0.488718, -0.150777, 0.302301>, <-0.554643, 0.072168, 0.271662>, <-0.614948, 0.193447, 0.288393>, 
      <-0.550453, -0.366955, 0.440693>, <-0.637399, -0.193033, 0.440693>, <-0.658358, 0.001864, 0.459913>, <-0.662801, 0.196127, 0.452812>, 
      <-0.584980, -0.437943, 0.563958>, <-0.671926, -0.264021, 0.563958>, <-0.679819, 0.008169, 0.583559>, <-0.684262, 0.202433, 0.576458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.030182, -1.111641, 0.170303>, <0.017677, -1.123443, 0.292002>, <0.001191, -1.143268, 0.454078>, <-0.008915, -1.148489, 0.576458>, 
      <0.169753, -1.238287, 0.170303>, <0.157248, -1.250089, 0.292002>, <0.170753, -1.249875, 0.455787>, <0.160647, -1.255096, 0.578167>, 
      <0.467639, -1.156507, 0.170303>, <0.467639, -1.163480, 0.292607>, <0.455909, -1.190759, 0.454120>, <0.455909, -1.197117, 0.576458>, 
      <0.655153, -1.175422, 0.170303>, <0.655153, -1.182395, 0.292607>, <0.655153, -1.211280, 0.454120>, <0.655153, -1.217638, 0.576458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.030182, -1.111641, 0.170303>, <-0.182846, -0.918341, 0.170303>, <-0.246781, -0.500143, 0.170303>, <-0.373591, -0.241947, 0.170303>, 
      <0.017677, -1.123443, 0.292002>, <-0.195351, -0.930143, 0.292002>, <-0.301745, -0.531471, 0.302301>, <-0.428555, -0.273275, 0.302301>, 
      <0.001191, -1.143268, 0.454078>, <-0.231139, -0.997198, 0.451736>, <-0.427735, -0.612433, 0.440693>, <-0.550453, -0.366955, 0.440693>, 
      <-0.008915, -1.148489, 0.576458>, <-0.241245, -1.002419, 0.574116>, <-0.462262, -0.683421, 0.563958>, <-0.584980, -0.437943, 0.563958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.047891, 0.748802, -0.160072>, <-0.140473, 0.758134, -0.152727>, <-0.241443, 0.849754, -0.104807>, <-0.332502, 0.849106, -0.084306>, 
      <-0.060540, 0.788662, -0.076230>, <-0.153122, 0.797994, -0.068884>, <-0.241509, 0.908641, -0.035234>, <-0.332567, 0.907994, -0.014733>, 
      <-0.074923, 0.814791, 0.046911>, <-0.171550, 0.822729, 0.055296>, <-0.244962, 0.946540, 0.107742>, <-0.341790, 0.949765, 0.116908>, 
      <-0.081801, 0.835706, 0.137980>, <-0.178428, 0.843643, 0.146366>, <-0.283534, 0.943421, 0.190269>, <-0.380362, 0.946646, 0.199435>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.047891, 0.748802, -0.160072>, <-0.060540, 0.788662, -0.076230>, <-0.074923, 0.814791, 0.046911>, <-0.081801, 0.835706, 0.137980>, 
      <0.161310, 0.727715, -0.176670>, <0.148661, 0.767575, -0.092827>, <0.144900, 0.796734, 0.027833>, <0.138022, 0.817648, 0.118903>, 
      <0.444240, 0.749329, -0.161895>, <0.444407, 0.784648, -0.080950>, <0.434061, 0.821872, 0.035703>, <0.434061, 0.853895, 0.118008>, 
      <0.655153, 0.749551, -0.162665>, <0.655320, 0.784871, -0.081720>, <0.655153, 0.829559, 0.027263>, <0.655153, 0.861582, 0.109568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.558951, -0.004976, -0.090052>, <-0.532559, -0.088707, -0.225725>, <-0.533525, -0.215465, -0.415797>, <-0.454536, -0.281790, -0.540201>, 
      <-0.616356, 0.094980, -0.085157>, <-0.589965, 0.011249, -0.220830>, <-0.552775, 0.007979, -0.375107>, <-0.473786, -0.058347, -0.499511>, 
      <-0.661450, 0.244884, -0.065472>, <-0.595266, 0.235201, -0.182941>, <-0.571651, 0.227504, -0.324146>, <-0.481340, 0.257065, -0.420287>, 
      <-0.680856, 0.358407, -0.058653>, <-0.614671, 0.348724, -0.176121>, <-0.470129, 0.427384, -0.282981>, <-0.379818, 0.456945, -0.379121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.558951, -0.004976, -0.090052>, <-0.616356, 0.094980, -0.085157>, <-0.661450, 0.244884, -0.065472>, <-0.680856, 0.358407, -0.058653>, 
      <-0.574057, 0.042951, -0.012394>, <-0.631463, 0.142906, -0.007499>, <-0.716109, 0.252881, 0.031539>, <-0.735514, 0.366404, 0.038358>, 
      <-0.576402, 0.129647, 0.083372>, <-0.629467, 0.236365, 0.098095>, <-0.734208, 0.324305, 0.170292>, <-0.757916, 0.440717, 0.187830>, 
      <-0.592746, 0.156699, 0.170303>, <-0.645811, 0.263417, 0.185026>, <-0.724180, 0.394383, 0.256611>, <-0.747888, 0.510795, 0.274150>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.312651, -0.282722, -0.090052>, <-0.287334, -0.429838, -0.275317>, <-0.279635, -0.693915, -0.461570>, <-0.265485, -0.870141, -0.620792>, 
      <-0.368041, -0.186107, -0.090052>, <-0.342724, -0.333222, -0.275317>, <-0.380000, -0.542500, -0.505790>, <-0.365851, -0.718726, -0.665011>, 
      <-0.503538, -0.101463, -0.094777>, <-0.477146, -0.185194, -0.230451>, <-0.517735, -0.398746, -0.449174>, <-0.438746, -0.465071, -0.573578>, 
      <-0.558951, -0.004976, -0.090052>, <-0.532559, -0.088707, -0.225725>, <-0.533525, -0.215465, -0.415797>, <-0.454536, -0.281790, -0.540201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.312651, -0.282722, -0.090052>, <-0.368041, -0.186107, -0.090052>, <-0.503538, -0.101463, -0.094777>, <-0.558951, -0.004976, -0.090052>, 
      <-0.321286, -0.232547, -0.026866>, <-0.376675, -0.135932, -0.026866>, <-0.518644, -0.053536, -0.017120>, <-0.574057, 0.042951, -0.012394>, 
      <-0.343121, -0.224580, 0.097129>, <-0.403284, -0.102082, 0.097129>, <-0.516097, 0.008368, 0.066641>, <-0.576402, 0.129647, 0.083372>, 
      <-0.373591, -0.241947, 0.170303>, <-0.433754, -0.119449, 0.170303>, <-0.532441, 0.035420, 0.153572>, <-0.592746, 0.156699, 0.170303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.059571, -1.083852, -0.090052>, <0.192509, -1.207403, -0.083907>, <0.476410, -1.153035, -0.058581>, <0.655153, -1.182189, -0.045319>, 
      <0.071421, -1.088153, -0.153267>, <0.204358, -1.211703, -0.147122>, <0.476410, -1.171844, -0.093646>, <0.655153, -1.200997, -0.080384>, 
      <0.138990, -1.126771, -0.230612>, <0.282865, -1.195516, -0.146200>, <0.504211, -1.177476, -0.109311>, <0.652958, -1.271738, -0.070066>, 
      <0.116229, -1.142869, -0.288731>, <0.260104, -1.211614, -0.204319>, <0.506405, -1.215770, -0.119894>, <0.655153, -1.310032, -0.080649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.059571, -1.083852, -0.090052>, <0.045040, -1.078579, -0.012535>, <0.038224, -1.104051, 0.092037>, <0.030182, -1.111641, 0.170303>, 
      <0.192509, -1.207403, -0.083907>, <0.177978, -1.202130, -0.006390>, <0.177795, -1.230697, 0.092037>, <0.169753, -1.238287, 0.170303>, 
      <0.476410, -1.153035, -0.058581>, <0.476410, -1.122443, -0.001549>, <0.467639, -1.152823, 0.105690>, <0.467639, -1.156507, 0.170303>, 
      <0.655153, -1.182189, -0.045319>, <0.655153, -1.151597, 0.011713>, <0.655153, -1.171738, 0.105690>, <0.655153, -1.175422, 0.170303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.059571, -1.083852, -0.090052>, <0.071421, -1.088153, -0.153267>, <0.138990, -1.126771, -0.230612>, <0.116229, -1.142869, -0.288731>, 
      <-0.134439, -0.903541, -0.099019>, <-0.122589, -0.907842, -0.162234>, <0.001488, -1.061071, -0.311286>, <-0.021273, -1.077169, -0.369404>, 
      <-0.180843, -0.512633, -0.090052>, <-0.155526, -0.659748, -0.275317>, <-0.187072, -0.833560, -0.420788>, <-0.172922, -1.009785, -0.580010>, 
      <-0.312651, -0.282722, -0.090052>, <-0.287334, -0.429838, -0.275317>, <-0.279635, -0.693915, -0.461570>, <-0.265485, -0.870141, -0.620792>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.059571, -1.083852, -0.090052>, <-0.134439, -0.903541, -0.099019>, <-0.180843, -0.512633, -0.090052>, <-0.312651, -0.282722, -0.090052>, 
      <0.045040, -1.078579, -0.012535>, <-0.148970, -0.898268, -0.021502>, <-0.189477, -0.462458, -0.026866>, <-0.321286, -0.232547, -0.026866>, 
      <0.038224, -1.104051, 0.092037>, <-0.174804, -0.910751, 0.092037>, <-0.216312, -0.482776, 0.097129>, <-0.343121, -0.224580, 0.097129>, 
      <0.030182, -1.111641, 0.170303>, <-0.182846, -0.918341, 0.170303>, <-0.246781, -0.500143, 0.170303>, <-0.373591, -0.241947, 0.170303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.006872, 0.599587, -0.358680>, <-0.124522, 0.576445, -0.361808>, <-0.326394, 0.562128, -0.357459>, <-0.379818, 0.456945, -0.379121>, 
      <-0.026751, 0.638650, -0.297163>, <-0.144401, 0.615507, -0.300291>, <-0.312199, 0.679776, -0.269014>, <-0.365623, 0.574593, -0.290677>, 
      <-0.037694, 0.716668, -0.227664>, <-0.130275, 0.726000, -0.220319>, <-0.241337, 0.754222, -0.217673>, <-0.332396, 0.753574, -0.197172>, 
      <-0.047891, 0.748802, -0.160072>, <-0.140473, 0.758134, -0.152727>, <-0.241443, 0.849754, -0.104807>, <-0.332502, 0.849106, -0.084306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.006872, 0.599587, -0.358680>, <-0.026751, 0.638650, -0.297163>, <-0.037694, 0.716668, -0.227664>, <-0.047891, 0.748802, -0.160072>, 
      <0.188485, 0.638015, -0.353486>, <0.168606, 0.677077, -0.291969>, <0.171507, 0.695580, -0.244262>, <0.161310, 0.727715, -0.176670>, 
      <0.455855, 0.642364, -0.353715>, <0.448045, 0.652238, -0.292303>, <0.444121, 0.724257, -0.219353>, <0.444240, 0.749329, -0.161895>, 
      <0.654199, 0.660341, -0.351629>, <0.646390, 0.670215, -0.290216>, <0.655034, 0.724480, -0.220123>, <0.655153, 0.749551, -0.162665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.006872, 0.599587, -0.358680>, <0.188485, 0.638015, -0.353486>, <0.455855, 0.642364, -0.353715>, <0.654199, 0.660341, -0.351629>, 
      <0.048149, 0.491471, -0.528944>, <0.243506, 0.529899, -0.523750>, <0.475686, 0.617290, -0.509672>, <0.674030, 0.635267, -0.507585>, 
      <0.130922, 0.357292, -0.759336>, <0.285378, 0.482837, -0.766515>, <0.589512, 0.527512, -0.740217>, <0.728692, 0.668395, -0.718976>, 
      <0.201036, 0.259659, -0.930385>, <0.355492, 0.385204, -0.937564>, <0.606396, 0.494339, -0.895003>, <0.745575, 0.635222, -0.873763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.006872, 0.599587, -0.358680>, <0.048149, 0.491471, -0.528944>, <0.130922, 0.357292, -0.759336>, <0.201036, 0.259659, -0.930385>, 
      <-0.124522, 0.576445, -0.361808>, <-0.069501, 0.468329, -0.532072>, <0.040365, 0.283687, -0.755127>, <0.110480, 0.186053, -0.926176>, 
      <-0.326394, 0.562128, -0.357459>, <-0.233873, 0.424690, -0.502292>, <-0.077430, 0.175194, -0.695908>, <0.003659, 0.075801, -0.874714>, 
      <-0.379818, 0.456945, -0.379121>, <-0.287297, 0.319507, -0.523955>, <-0.137573, 0.082689, -0.657676>, <-0.056483, -0.016704, -0.836482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210001, -2.765198, -1.439959>, <1.175962, -2.823323, -1.506731>, <1.090664, -2.849098, -1.606380>, <1.039520, -2.885055, -1.677703>, 
      <1.084095, -2.803459, -1.369173>, <1.050056, -2.861584, -1.435945>, <1.060110, -2.838099, -1.564814>, <1.008966, -2.874056, -1.636137>, 
      <0.867131, -2.736446, -1.382719>, <0.916460, -2.785729, -1.441757>, <0.923832, -2.814462, -1.496961>, <0.989430, -2.851084, -1.548957>, 
      <0.719012, -2.726317, -1.365832>, <0.768341, -2.775600, -1.424871>, <0.872074, -2.811768, -1.487155>, <0.937672, -2.848390, -1.539150>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -2.514616, -1.757494>, <1.333862, -2.473335, -1.874671>, <1.085862, -2.611942, -1.818937>, <0.938350, -2.628094, -1.829134>, 
      <1.332829, -2.618423, -1.821964>, <1.251038, -2.577142, -1.939142>, <1.091531, -2.633016, -1.838502>, <0.944019, -2.649168, -1.848699>, 
      <1.197772, -2.763023, -1.918922>, <1.194118, -2.729473, -1.948039>, <1.037198, -2.670662, -1.853448>, <0.993466, -2.663771, -1.848276>, 
      <1.055377, -2.794911, -1.941261>, <1.051723, -2.761361, -1.970378>, <1.060819, -2.685953, -1.861652>, <1.017087, -2.679062, -1.856480>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -2.514616, -1.757494>, <1.332829, -2.618423, -1.821964>, <1.197772, -2.763023, -1.918922>, <1.055377, -2.794911, -1.941261>, 
      <1.490512, -2.552397, -1.650251>, <1.407687, -2.656204, -1.714721>, <1.204633, -2.826023, -1.864245>, <1.062238, -2.857911, -1.886585>, 
      <1.324709, -2.730340, -1.504450>, <1.290670, -2.788464, -1.571222>, <1.095421, -2.822055, -1.685447>, <1.044277, -2.858012, -1.756770>, 
      <1.210001, -2.765198, -1.439959>, <1.175962, -2.823323, -1.506731>, <1.090664, -2.849098, -1.606380>, <1.039520, -2.885055, -1.677703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210001, -2.593947, -1.343288>, <1.210001, -2.646562, -1.369974>, <1.231174, -2.729043, -1.398426>, <1.210001, -2.765198, -1.439959>, 
      <1.073838, -2.638690, -1.263191>, <1.073838, -2.691305, -1.289877>, <1.105268, -2.767304, -1.327640>, <1.084095, -2.803459, -1.369173>, 
      <0.836341, -2.588644, -1.258824>, <0.841699, -2.636044, -1.296576>, <0.834286, -2.703632, -1.343409>, <0.867131, -2.736446, -1.382719>, 
      <0.675588, -2.586550, -1.225480>, <0.680946, -2.633951, -1.263232>, <0.686168, -2.693503, -1.326523>, <0.719012, -2.726317, -1.365832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -2.343364, -1.660823>, <1.321173, -2.271170, -1.744802>, <1.083407, -2.380355, -1.595393>, <0.938350, -2.386375, -1.584745>, 
      <1.415654, -2.394526, -1.690200>, <1.321173, -2.322332, -1.774180>, <1.084105, -2.453850, -1.667725>, <0.939049, -2.459870, -1.657077>, 
      <1.448754, -2.473130, -1.731729>, <1.366962, -2.431849, -1.848906>, <1.065916, -2.537797, -1.750100>, <0.918404, -2.553949, -1.760297>, 
      <1.415654, -2.514616, -1.757494>, <1.333862, -2.473335, -1.874671>, <1.085862, -2.611942, -1.818937>, <0.938350, -2.628094, -1.829134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -2.343364, -1.660823>, <1.415654, -2.394526, -1.690200>, <1.448754, -2.473130, -1.731729>, <1.415654, -2.514616, -1.757494>, 
      <1.504009, -2.410877, -1.582289>, <1.504009, -2.462039, -1.611666>, <1.523612, -2.510912, -1.624486>, <1.490512, -2.552397, -1.650251>, 
      <1.322897, -2.556849, -1.409699>, <1.322897, -2.609464, -1.436385>, <1.345883, -2.694185, -1.462916>, <1.324709, -2.730340, -1.504450>, 
      <1.210001, -2.593947, -1.343288>, <1.210001, -2.646562, -1.369974>, <1.231174, -2.729043, -1.398426>, <1.210001, -2.765198, -1.439959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.426935, -1.203288, -0.521260>, <1.414110, -1.133165, -0.452770>, <1.236311, -1.167557, -0.377864>, <1.201404, -1.142869, -0.288731>, 
      <1.256210, -1.304275, -0.380016>, <1.243385, -1.234152, -0.311526>, <1.092436, -1.236302, -0.293451>, <1.057529, -1.211614, -0.204319>, 
      <0.953363, -1.377508, -0.257344>, <0.952098, -1.348782, -0.215115>, <0.769107, -1.242462, -0.108781>, <0.811228, -1.215770, -0.119894>, 
      <0.735894, -1.437864, -0.165914>, <0.734630, -1.409139, -0.123685>, <0.620360, -1.336724, -0.069536>, <0.662480, -1.310032, -0.080649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.583118, -0.870141, -0.620792>, <1.490555, -1.009785, -0.580010>, <1.338906, -1.077169, -0.369404>, <1.201404, -1.142869, -0.288731>, 
      <1.591799, -0.926288, -0.663086>, <1.499236, -1.065932, -0.622304>, <1.373813, -1.101857, -0.458537>, <1.236311, -1.167557, -0.377864>, 
      <1.483900, -0.958222, -0.723480>, <1.568644, -0.982028, -0.692696>, <1.479490, -1.094492, -0.506860>, <1.414110, -1.133165, -0.452770>, 
      <1.457971, -1.010743, -0.763302>, <1.542715, -1.034549, -0.732518>, <1.492315, -1.164615, -0.575350>, <1.426935, -1.203288, -0.521260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.950757, -1.069520, -0.694234>, <1.102921, -1.051887, -0.714955>, <1.317497, -0.971281, -0.814330>, <1.457971, -1.010743, -0.763302>, 
      <1.083684, -0.927461, -0.621227>, <1.235848, -0.909828, -0.641948>, <1.343426, -0.918760, -0.774508>, <1.483900, -0.958222, -0.723480>, 
      <1.271106, -0.763660, -0.452050>, <1.335456, -0.854127, -0.468228>, <1.578049, -0.837352, -0.596093>, <1.591799, -0.926288, -0.663086>, 
      <1.393847, -0.595989, -0.450878>, <1.458197, -0.686456, -0.467056>, <1.569368, -0.781205, -0.553799>, <1.583118, -0.870141, -0.620792>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.376753, -0.154465, 2.926861>, <1.375693, -0.094961, 2.959150>, <1.371937, -0.004535, 2.986591>, <1.366078, 0.062919, 2.986591>, 
      <1.207857, -0.169915, 2.926861>, <1.206798, -0.110411, 2.959150>, <1.211425, 0.002849, 2.989757>, <1.205566, 0.070304, 2.989757>, 
      <0.981127, -0.164055, 2.926861>, <0.989410, -0.094354, 2.957017>, <0.991327, -0.000638, 2.992326>, <0.991327, 0.075758, 2.992326>, 
      <0.811542, -0.166375, 2.926861>, <0.819825, -0.096674, 2.957017>, <0.830645, 0.002234, 2.993608>, <0.830645, 0.078629, 2.993608>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.376753, -0.154465, 2.926861>, <1.409797, -0.151442, 2.926861>, <1.460529, -0.134961, 2.926861>, <1.475979, -0.105595, 2.926861>, 
      <1.375693, -0.094961, 2.959150>, <1.408738, -0.091939, 2.959150>, <1.438564, -0.096071, 2.955035>, <1.454014, -0.066705, 2.955035>, 
      <1.371937, -0.004535, 2.986591>, <1.388214, -0.005284, 2.986270>, <1.413495, -0.000865, 2.988939>, <1.428238, -0.000433, 2.982005>, 
      <1.366078, 0.062919, 2.986591>, <1.382356, 0.062170, 2.986270>, <1.404262, 0.051129, 2.988939>, <1.419005, 0.051561, 2.982005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.344846, 0.212903, 2.926861>, <1.351744, 0.172567, 2.953538>, <1.361851, 0.111585, 2.986591>, <1.366078, 0.062919, 2.986591>, 
      <1.370983, 0.210306, 2.926861>, <1.377880, 0.169970, 2.953538>, <1.378129, 0.110836, 2.986270>, <1.382356, 0.062170, 2.986270>, 
      <1.406782, 0.197238, 2.926861>, <1.398848, 0.165258, 2.952329>, <1.396981, 0.092133, 2.988939>, <1.404262, 0.051129, 2.988939>, 
      <1.425478, 0.178790, 2.926861>, <1.417544, 0.146810, 2.952329>, <1.411724, 0.092564, 2.982005>, <1.419005, 0.051561, 2.982005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.344846, 0.212903, 2.926861>, <1.185437, 0.228745, 2.926861>, <0.965331, 0.279960, 2.906898>, <0.811542, 0.239801, 2.926861>, 
      <1.351744, 0.172567, 2.953538>, <1.192334, 0.188409, 2.953538>, <0.914789, 0.266762, 2.913459>, <0.761000, 0.226603, 2.933422>, 
      <1.361851, 0.111585, 2.986591>, <1.201339, 0.118969, 2.989757>, <0.991327, 0.128404, 2.992326>, <0.830645, 0.131276, 2.993608>, 
      <1.366078, 0.062919, 2.986591>, <1.205566, 0.070304, 2.989757>, <0.991327, 0.075758, 2.992326>, <0.830645, 0.078629, 2.993608>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.285996, 0.531224, 2.676861>, <1.127686, 0.566997, 2.676861>, <0.911768, 0.590222, 2.676861>, <0.750369, 0.607307, 2.676861>, 
      <1.301419, 0.447802, 2.765513>, <1.143109, 0.483575, 2.765513>, <0.925553, 0.491709, 2.767539>, <0.764153, 0.508794, 2.767539>, 
      <1.327520, 0.314222, 2.859850>, <1.168111, 0.330064, 2.859850>, <1.030160, 0.377492, 2.840550>, <0.876371, 0.337333, 2.860513>, 
      <1.344846, 0.212903, 2.926861>, <1.185437, 0.228745, 2.926861>, <0.965331, 0.279960, 2.906898>, <0.811542, 0.239801, 2.926861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.514062, 0.434735, 2.676861>, <1.461180, 0.486915, 2.676861>, <1.358460, 0.514849, 2.676861>, <1.285996, 0.531224, 2.676861>, 
      <1.491458, 0.369426, 2.763179>, <1.438577, 0.421606, 2.763179>, <1.373883, 0.431427, 2.765513>, <1.301419, 0.447802, 2.765513>, 
      <1.446543, 0.263704, 2.859239>, <1.427847, 0.282152, 2.859239>, <1.353657, 0.311625, 2.859850>, <1.327520, 0.314222, 2.859850>, 
      <1.425478, 0.178790, 2.926861>, <1.406782, 0.197238, 2.926861>, <1.370983, 0.210306, 2.926861>, <1.344846, 0.212903, 2.926861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.376244, -0.507874, 2.676861>, <1.376379, -0.414056, 2.766661>, <1.378786, -0.268597, 2.864929>, <1.376753, -0.154465, 2.926861>, 
      <1.192127, -0.554640, 2.681559>, <1.192262, -0.460823, 2.771359>, <1.209890, -0.284047, 2.864929>, <1.207857, -0.169915, 2.926861>, 
      <0.938724, -0.578498, 2.694599>, <0.953709, -0.469166, 2.793176>, <0.965084, -0.299061, 2.868451>, <0.981127, -0.164055, 2.926861>, 
      <0.750000, -0.600000, 2.700000>, <0.764985, -0.490667, 2.798577>, <0.795499, -0.301380, 2.868451>, <0.811542, -0.166375, 2.926861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.376244, -0.507874, 2.676861>, <1.467184, -0.484775, 2.674541>, <1.613203, -0.452707, 2.676861>, <1.656904, -0.369645, 2.676861>, 
      <1.376379, -0.414056, 2.766661>, <1.467319, -0.390958, 2.764341>, <1.564414, -0.374064, 2.756114>, <1.608115, -0.291003, 2.756114>, 
      <1.378786, -0.268597, 2.864929>, <1.411830, -0.265574, 2.864929>, <1.511210, -0.224692, 2.861855>, <1.526660, -0.195326, 2.861855>, 
      <1.376753, -0.154465, 2.926861>, <1.409797, -0.151442, 2.926861>, <1.460529, -0.134961, 2.926861>, <1.475979, -0.105595, 2.926861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.493080, 0.066637, 2.926861>, <1.502159, 0.015513, 2.926861>, <1.500155, -0.059643, 2.926861>, <1.475979, -0.105595, 2.926861>, 
      <1.560361, 0.082137, 2.855144>, <1.569440, 0.031013, 2.855144>, <1.550836, -0.149375, 2.861855>, <1.526660, -0.195326, 2.861855>, 
      <1.652799, 0.104930, 2.760517>, <1.678478, -0.039673, 2.760517>, <1.676498, -0.161028, 2.756114>, <1.608115, -0.291003, 2.756114>, 
      <1.705275, 0.117511, 2.676861>, <1.730954, -0.027092, 2.676861>, <1.725287, -0.239671, 2.676861>, <1.656904, -0.369645, 2.676861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.493080, 0.066637, 2.926861>, <1.502159, 0.015513, 2.926861>, <1.500155, -0.059643, 2.926861>, <1.475979, -0.105595, 2.926861>, 
      <1.493080, 0.066637, 2.926861>, <1.483187, 0.011143, 2.947083>, <1.478190, -0.020753, 2.955035>, <1.454014, -0.066705, 2.955035>, 
      <1.493080, 0.066637, 2.926861>, <1.483187, 0.011143, 2.947083>, <1.453631, 0.000310, 2.970062>, <1.428238, -0.000433, 2.982005>, 
      <1.493080, 0.066637, 2.926861>, <1.474109, 0.062266, 2.947083>, <1.444398, 0.052304, 2.970062>, <1.419005, 0.051561, 2.982005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.493080, 0.066637, 2.926861>, <1.474109, 0.062266, 2.947083>, <1.444398, 0.052304, 2.970062>, <1.419005, 0.051561, 2.982005>, 
      <1.493080, 0.066637, 2.926861>, <1.467240, 0.100947, 2.947083>, <1.437117, 0.093308, 2.970062>, <1.411724, 0.092564, 2.982005>, 
      <1.493080, 0.066637, 2.926861>, <1.467240, 0.100947, 2.947083>, <1.445509, 0.119217, 2.952329>, <1.417544, 0.146810, 2.952329>, 
      <1.493080, 0.066637, 2.926861>, <1.486211, 0.105317, 2.926861>, <1.453442, 0.151197, 2.926861>, <1.425478, 0.178790, 2.926861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.493080, 0.066637, 2.926861>, <1.486211, 0.105317, 2.926861>, <1.453442, 0.151197, 2.926861>, <1.425478, 0.178790, 2.926861>, 
      <1.502159, 0.015513, 2.926861>, <1.495290, 0.054193, 2.926861>, <1.445509, 0.119217, 2.952329>, <1.417544, 0.146810, 2.952329>, 
      <1.500155, -0.059643, 2.926861>, <1.478190, -0.020753, 2.955035>, <1.420957, 0.040570, 2.982005>, <1.411724, 0.092564, 2.982005>, 
      <1.475979, -0.105595, 2.926861>, <1.454014, -0.066705, 2.955035>, <1.428238, -0.000433, 2.982005>, <1.419005, 0.051561, 2.982005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.493080, 0.066637, 2.926861>, <1.560361, 0.082137, 2.855144>, <1.652799, 0.104930, 2.760517>, <1.705275, 0.117511, 2.676861>, 
      <1.486211, 0.105317, 2.926861>, <1.553492, 0.120817, 2.855144>, <1.633371, 0.214337, 2.760517>, <1.685846, 0.226918, 2.676861>, 
      <1.453442, 0.151197, 2.926861>, <1.474508, 0.236112, 2.859239>, <1.570554, 0.291380, 2.763179>, <1.593158, 0.356689, 2.676861>, 
      <1.425478, 0.178790, 2.926861>, <1.446543, 0.263704, 2.859239>, <1.491458, 0.369426, 2.763179>, <1.514062, 0.434735, 2.676861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.234329, 0.810690, 2.291600>, <1.081571, 0.857816, 2.291600>, <0.872060, 0.900294, 2.291600>, <0.714973, 0.929953, 2.291600>, 
      <1.247186, 0.741146, 2.416604>, <1.094428, 0.788272, 2.416604>, <0.878515, 0.818695, 2.418643>, <0.721428, 0.848354, 2.418643>, 
      <1.267944, 0.628869, 2.573095>, <1.109634, 0.664642, 2.573095>, <0.896291, 0.700832, 2.575048>, <0.734892, 0.717918, 2.575048>, 
      <1.285996, 0.531224, 2.676861>, <1.127686, 0.566997, 2.676861>, <0.911768, 0.590222, 2.676861>, <0.750369, 0.607307, 2.676861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.591833, 0.659438, 2.291600>, <1.508939, 0.741232, 2.291600>, <1.345609, 0.776360, 2.291600>, <1.234329, 0.810690, 2.291600>, 
      <1.572827, 0.604525, 2.414361>, <1.489933, 0.686319, 2.414361>, <1.358466, 0.706816, 2.416604>, <1.247186, 0.741146, 2.416604>, 
      <1.541826, 0.514954, 2.570837>, <1.488945, 0.567134, 2.570837>, <1.340408, 0.612494, 2.573095>, <1.267944, 0.628869, 2.573095>, 
      <1.514062, 0.434735, 2.676861>, <1.461180, 0.486915, 2.676861>, <1.358460, 0.514849, 2.676861>, <1.285996, 0.531224, 2.676861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.891568, 0.162175, 2.291600>, <1.852038, 0.331170, 2.306363>, <1.715820, 0.537097, 2.291600>, <1.591833, 0.659438, 2.291600>, 
      <1.846841, 0.151452, 2.412206>, <1.807310, 0.320447, 2.426969>, <1.696814, 0.482184, 2.414361>, <1.572827, 0.604525, 2.414361>, 
      <1.773316, 0.133824, 2.568392>, <1.753888, 0.243231, 2.568392>, <1.620922, 0.436908, 2.570837>, <1.541826, 0.514954, 2.570837>, 
      <1.705275, 0.117511, 2.676861>, <1.685846, 0.226918, 2.676861>, <1.593158, 0.356689, 2.676861>, <1.514062, 0.434735, 2.676861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.949211, -0.868396, 2.158134>, <2.094591, -0.592074, 2.158134>, <1.962427, -0.140757, 2.265137>, <1.891568, 0.162175, 2.291600>, 
      <1.884909, -0.774551, 2.361489>, <2.030289, -0.498229, 2.361489>, <1.917700, -0.151480, 2.385743>, <1.846841, 0.151452, 2.412206>, 
      <1.750206, -0.520039, 2.525299>, <1.818589, -0.390065, 2.525299>, <1.798995, -0.010779, 2.568392>, <1.773316, 0.133824, 2.568392>, 
      <1.656904, -0.369645, 2.676861>, <1.725287, -0.239671, 2.676861>, <1.730954, -0.027092, 2.676861>, <1.705275, 0.117511, 2.676861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.375797, -0.818145, 2.291600>, <1.178071, -0.818554, 2.312981>, <0.913390, -0.857399, 2.291600>, <0.714973, -0.870951, 2.291600>, 
      <1.375656, -0.915916, 2.133307>, <1.177930, -0.916325, 2.154689>, <0.879774, -0.859695, 2.291600>, <0.681357, -0.873247, 2.291600>, 
      <1.375523, -1.008512, 1.901441>, <1.143699, -0.942768, 2.068652>, <0.868099, -0.938991, 2.124389>, <0.636276, -0.873247, 2.291600>, 
      <1.375405, -1.090098, 1.734230>, <1.143582, -1.024354, 1.901441>, <0.834484, -0.936695, 2.124389>, <0.602660, -0.870951, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.375797, -0.818145, 2.291600>, <1.375909, -0.740161, 2.417858>, <1.376090, -0.615079, 2.574247>, <1.376244, -0.507874, 2.676861>, 
      <1.178071, -0.818554, 2.312981>, <1.178183, -0.740570, 2.439239>, <1.191972, -0.661845, 2.578944>, <1.192127, -0.554640, 2.681559>, 
      <0.913390, -0.857399, 2.291600>, <0.916524, -0.781593, 2.417982>, <0.923796, -0.687414, 2.596399>, <0.938724, -0.578498, 2.694599>, 
      <0.714973, -0.870951, 2.291600>, <0.718108, -0.795145, 2.417982>, <0.735072, -0.708916, 2.601799>, <0.750000, -0.600000, 2.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.375797, -0.818145, 2.291600>, <1.552034, -0.817780, 2.272542>, <1.866674, -1.025273, 2.158134>, <1.949211, -0.868396, 2.158134>, 
      <1.375909, -0.740161, 2.417858>, <1.552146, -0.739796, 2.398800>, <1.802372, -0.931428, 2.361489>, <1.884909, -0.774551, 2.361489>, 
      <1.376090, -0.615079, 2.574247>, <1.467029, -0.591980, 2.571927>, <1.706505, -0.603100, 2.525299>, <1.750206, -0.520039, 2.525299>, 
      <1.376244, -0.507874, 2.676861>, <1.467184, -0.484775, 2.674541>, <1.613203, -0.452707, 2.676861>, <1.656904, -0.369645, 2.676861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.189044, 1.055642, 1.734230>, <1.045285, 1.109145, 1.734230>, <0.850422, 1.172250, 1.734230>, <0.702474, 1.212753, 1.734230>, 
      <1.198423, 1.004912, 1.909965>, <1.054664, 1.058414, 1.909965>, <0.859245, 1.113018, 1.911952>, <0.711297, 1.153522, 1.911952>, 
      <1.217934, 0.899374, 2.132193>, <1.065176, 0.946500, 2.132193>, <0.864049, 1.001553, 2.133949>, <0.706963, 1.031211, 2.133949>, 
      <1.234329, 0.810690, 2.291600>, <1.081571, 0.857816, 2.291600>, <0.872060, 0.900294, 2.291600>, <0.714973, 0.929953, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.659999, 0.856391, 1.734230>, <1.550799, 0.964142, 1.734230>, <1.332821, 1.002133, 1.734230>, <1.189044, 1.055642, 1.734230>, 
      <1.646072, 0.816151, 1.907596>, <1.536871, 0.923902, 1.907596>, <1.342199, 0.951402, 1.909965>, <1.198423, 1.004912, 1.909965>, 
      <1.616814, 0.731615, 2.130245>, <1.533919, 0.813409, 2.130245>, <1.329213, 0.865043, 2.132193>, <1.217934, 0.899374, 2.132193>, 
      <1.591833, 0.659438, 2.291600>, <1.508939, 0.741232, 2.291600>, <1.345609, 0.776360, 2.291600>, <1.234329, 0.810690, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.054855, 0.201323, 1.734230>, <2.014735, 0.427249, 1.734230>, <1.823333, 0.695225, 1.734230>, <1.659999, 0.856391, 1.734230>, 
      <2.021889, 0.193419, 1.905542>, <1.981769, 0.419346, 1.905542>, <1.809406, 0.654985, 1.907596>, <1.646072, 0.816151, 1.907596>, 
      <1.952081, 0.176683, 2.128429>, <1.912551, 0.345679, 2.143192>, <1.740800, 0.609274, 2.130245>, <1.616814, 0.731615, 2.130245>, 
      <1.891568, 0.162175, 2.291600>, <1.852038, 0.331170, 2.306363>, <1.715820, 0.537097, 2.291600>, <1.591833, 0.659438, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.954969, -0.804654, 1.734230>, <1.949403, -0.806564, 1.862708>, <1.984703, -0.920194, 2.045891>, <1.949211, -0.868396, 2.158134>, 
      <1.864727, -0.976176, 1.734230>, <1.859161, -0.978086, 1.862708>, <1.902166, -1.077071, 2.045891>, <1.866674, -1.025273, 2.158134>, 
      <1.549274, -1.004465, 1.734230>, <1.549392, -0.922879, 1.901441>, <1.551893, -0.915551, 2.114250>, <1.552034, -0.817780, 2.272542>, 
      <1.375405, -1.090098, 1.734230>, <1.375523, -1.008512, 1.901441>, <1.375656, -0.915916, 2.133307>, <1.375797, -0.818145, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.954969, -0.804654, 1.734230>, <2.096179, -0.536258, 1.734230>, <2.107882, -0.097282, 1.734230>, <2.054855, 0.201323, 1.734230>, 
      <1.949403, -0.806564, 1.862708>, <2.090614, -0.538167, 1.862708>, <2.074915, -0.105186, 1.905542>, <2.021889, 0.193419, 1.905542>, 
      <1.984703, -0.920194, 2.045891>, <2.130083, -0.643872, 2.045891>, <2.022940, -0.126249, 2.101966>, <1.952081, 0.176683, 2.128429>, 
      <1.949211, -0.868396, 2.158134>, <2.094591, -0.592074, 2.158134>, <1.962427, -0.140757, 2.265137>, <1.891568, 0.162175, 2.291600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.177898, 1.115928, 1.234230>, <1.025616, 1.172603, 1.234230>, <0.817309, 1.233061, 1.234230>, <0.662480, 1.282354, 1.234230>, 
      <1.154945, 1.136221, 1.382215>, <1.002663, 1.192896, 1.382215>, <0.821708, 1.260911, 1.383512>, <0.666879, 1.310204, 1.383512>, 
      <1.181305, 1.097501, 1.589226>, <1.037547, 1.151004, 1.589226>, <0.843275, 1.220231, 1.590262>, <0.695327, 1.260735, 1.590262>, 
      <1.189044, 1.055642, 1.734230>, <1.045285, 1.109145, 1.734230>, <0.850422, 1.172250, 1.734230>, <0.702474, 1.212753, 1.734230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.676776, 0.904864, 1.234230>, <1.561101, 1.019003, 1.234230>, <1.330199, 1.059246, 1.234230>, <1.177898, 1.115928, 1.234230>, 
      <1.643937, 0.908497, 1.381353>, <1.528263, 1.022637, 1.381353>, <1.307246, 1.079539, 1.382215>, <1.154945, 1.136221, 1.382215>, 
      <1.671763, 0.890380, 1.587795>, <1.562562, 0.998131, 1.587795>, <1.325082, 1.043992, 1.589226>, <1.181305, 1.097501, 1.589226>, 
      <1.659999, 0.856391, 1.734230>, <1.550799, 0.964142, 1.734230>, <1.332821, 1.002133, 1.734230>, <1.189044, 1.055642, 1.734230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.095042, 0.210958, 1.234230>, <2.052543, 0.450279, 1.234230>, <1.849794, 0.734143, 1.234230>, <1.676776, 0.904864, 1.234230>, 
      <2.101920, 0.210814, 1.384584>, <2.059421, 0.450135, 1.384584>, <1.816955, 0.737776, 1.381353>, <1.643937, 0.908497, 1.381353>, 
      <2.083268, 0.208135, 1.586582>, <2.043148, 0.434061, 1.586582>, <1.835096, 0.729214, 1.587795>, <1.671763, 0.890380, 1.587795>, 
      <2.054855, 0.201323, 1.734230>, <2.014735, 0.427249, 1.734230>, <1.823333, 0.695225, 1.734230>, <1.659999, 0.856391, 1.734230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.989234, -0.854662, 1.234230>, <2.138816, -0.570353, 1.234230>, <2.151212, -0.105351, 1.234230>, <2.095042, 0.210958, 1.234230>, 
      <1.995679, -0.899802, 1.378284>, <2.145261, -0.615493, 1.378284>, <2.158090, -0.105496, 1.384584>, <2.101920, 0.210814, 1.384584>, 
      <1.961508, -0.802410, 1.583290>, <2.102718, -0.534014, 1.583290>, <2.136294, -0.090470, 1.586582>, <2.083268, 0.208135, 1.586582>, 
      <1.954969, -0.804654, 1.734230>, <2.096179, -0.536258, 1.734230>, <2.107882, -0.097282, 1.734230>, <2.054855, 0.201323, 1.734230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.375309, -1.157029, 1.234230>, <1.381682, -1.149413, 1.385242>, <1.375376, -1.110177, 1.584230>, <1.375405, -1.090098, 1.734230>, 
      <1.375309, -1.157029, 1.234230>, <1.174841, -1.208040, 1.385242>, <1.161499, -1.152363, 1.434230>, <1.161527, -1.132284, 1.584230>, 
      <1.375309, -1.157029, 1.234230>, <1.174841, -1.208040, 1.385242>, <1.090229, -1.166648, 1.384230>, <0.876358, -1.188531, 1.384230>, 
      <1.375309, -1.157029, 1.234230>, <1.168469, -1.215656, 1.234230>, <0.876352, -1.208833, 1.234230>, <0.662480, -1.230717, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.375309, -1.157029, 1.234230>, <1.572832, -1.101043, 1.234230>, <1.893641, -1.036353, 1.234230>, <1.989234, -0.854662, 1.234230>, 
      <1.381682, -1.149413, 1.385242>, <1.579204, -1.093427, 1.385242>, <1.900086, -1.081493, 1.378284>, <1.995679, -0.899802, 1.378284>, 
      <1.375376, -1.110177, 1.584230>, <1.549245, -1.024544, 1.584230>, <1.871265, -0.973932, 1.583290>, <1.961508, -0.802410, 1.583290>, 
      <1.375405, -1.090098, 1.734230>, <1.549274, -1.004465, 1.734230>, <1.864727, -0.976176, 1.734230>, <1.954969, -0.804654, 1.734230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.496271, -0.324316, -0.689026>, <1.357148, -0.303509, -0.680267>, <1.219505, -0.220987, -0.542220>, <1.092286, -0.180106, -0.497396>, 
      <1.496271, -0.324316, -0.689026>, <1.360340, -0.397249, -0.617868>, <1.309973, -0.345752, -0.528264>, <1.182754, -0.304871, -0.483441>, 
      <1.496271, -0.324316, -0.689026>, <1.360340, -0.397249, -0.617868>, <1.371632, -0.380310, -0.427929>, <1.305090, -0.471210, -0.428564>, 
      <1.496271, -0.324316, -0.689026>, <1.499464, -0.418056, -0.626627>, <1.460389, -0.505089, -0.450243>, <1.393847, -0.595989, -0.450878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.772169, -0.281790, -0.540201>, <1.756379, -0.465071, -0.573578>, <1.683484, -0.718726, -0.665011>, <1.583118, -0.870141, -0.620792>, 
      <1.568204, -0.251285, -0.527359>, <1.552414, -0.434566, -0.560736>, <1.669733, -0.629789, -0.598018>, <1.569368, -0.781205, -0.553799>, 
      <1.275493, -0.184370, -0.401928>, <1.365962, -0.309135, -0.387973>, <1.369440, -0.561676, -0.444742>, <1.458197, -0.686456, -0.467056>, 
      <1.092286, -0.180106, -0.497396>, <1.182754, -0.304871, -0.483441>, <1.305090, -0.471210, -0.428564>, <1.393847, -0.595989, -0.450878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.772169, -0.281790, -0.540201>, <1.568204, -0.251285, -0.527359>, <1.275493, -0.184370, -0.401928>, <1.092286, -0.180106, -0.497396>, 
      <1.772169, -0.281790, -0.540201>, <1.521815, -0.290236, -0.600420>, <1.402712, -0.225251, -0.446752>, <1.219505, -0.220987, -0.542220>, 
      <1.772169, -0.281790, -0.540201>, <1.521815, -0.290236, -0.600420>, <1.450827, -0.317519, -0.686165>, <1.357148, -0.303509, -0.680267>, 
      <1.772169, -0.281790, -0.540201>, <1.725780, -0.320742, -0.613261>, <1.589950, -0.338327, -0.694924>, <1.496271, -0.324316, -0.689026>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.772169, -0.281790, -0.540201>, <1.568204, -0.251285, -0.527359>, <1.275493, -0.184370, -0.401928>, <1.092286, -0.180106, -0.497396>, 
      <1.725780, -0.320742, -0.613261>, <1.521815, -0.290236, -0.600420>, <1.365962, -0.309135, -0.387973>, <1.182754, -0.304871, -0.483441>, 
      <1.589950, -0.338327, -0.694924>, <1.593143, -0.432067, -0.632525>, <1.371632, -0.380310, -0.427929>, <1.305090, -0.471210, -0.428564>, 
      <1.496271, -0.324316, -0.689026>, <1.499464, -0.418056, -0.626627>, <1.460389, -0.505089, -0.450243>, <1.393847, -0.595989, -0.450878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.772169, -0.281790, -0.540201>, <1.756379, -0.465071, -0.573578>, <1.683484, -0.718726, -0.665011>, <1.583118, -0.870141, -0.620792>, 
      <1.725780, -0.320742, -0.613261>, <1.709990, -0.504023, -0.646638>, <1.669733, -0.629789, -0.598018>, <1.569368, -0.781205, -0.553799>, 
      <1.589950, -0.338327, -0.694924>, <1.593143, -0.432067, -0.632525>, <1.524739, -0.595555, -0.466421>, <1.458197, -0.686456, -0.467056>, 
      <1.496271, -0.324316, -0.689026>, <1.499464, -0.418056, -0.626627>, <1.460389, -0.505089, -0.450243>, <1.393847, -0.595989, -0.450878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210001, -2.214533, -1.160666>, <1.176481, -2.321003, -1.219811>, <1.210001, -2.481286, -1.286147>, <1.210001, -2.593947, -1.343288>, 
      <1.072809, -2.263601, -1.077874>, <1.039289, -2.370071, -1.137020>, <1.073838, -2.526029, -1.206050>, <1.073838, -2.638690, -1.263191>, 
      <0.836696, -2.305934, -1.088448>, <0.836696, -2.377734, -1.140318>, <0.828540, -2.519626, -1.203856>, <0.836341, -2.588644, -1.258824>, 
      <0.675588, -2.342128, -1.059850>, <0.675588, -2.413929, -1.111720>, <0.667787, -2.517532, -1.170512>, <0.675588, -2.586550, -1.225480>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -2.077434, -1.506461>, <1.415654, -2.152209, -1.560479>, <1.415654, -2.263369, -1.614889>, <1.415654, -2.343364, -1.660823>, 
      <1.516761, -2.098797, -1.431756>, <1.516761, -2.173572, -1.485774>, <1.504009, -2.330882, -1.536355>, <1.504009, -2.410877, -1.582289>, 
      <1.314391, -2.177197, -1.223662>, <1.280871, -2.283666, -1.282808>, <1.322897, -2.444188, -1.352558>, <1.322897, -2.556849, -1.409699>, 
      <1.210001, -2.214533, -1.160666>, <1.176481, -2.321003, -1.219811>, <1.210001, -2.481286, -1.286147>, <1.210001, -2.593947, -1.343288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -2.077434, -1.506461>, <1.294731, -2.051884, -1.595808>, <1.084520, -2.144690, -1.385394>, <0.933864, -2.156188, -1.364696>, 
      <1.415654, -2.152209, -1.560479>, <1.294731, -2.126659, -1.649826>, <1.090096, -2.221674, -1.441704>, <0.939440, -2.233172, -1.421006>, 
      <1.415654, -2.263369, -1.614889>, <1.321173, -2.191175, -1.698869>, <1.082760, -2.312261, -1.528377>, <0.937703, -2.318281, -1.517728>, 
      <1.415654, -2.343364, -1.660823>, <1.321173, -2.271170, -1.744802>, <1.083407, -2.380355, -1.595393>, <0.938350, -2.386375, -1.584745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.405996, -1.971406, -0.997459>, <1.405996, -2.055250, -1.061838>, <1.238051, -2.125437, -1.111172>, <1.210001, -2.214533, -1.160666>, 
      <1.219054, -2.032835, -0.887490>, <1.219054, -2.116679, -0.951869>, <1.100859, -2.174505, -1.028380>, <1.072809, -2.263601, -1.077874>, 
      <0.895231, -2.055295, -0.903902>, <0.895231, -2.131669, -0.961381>, <0.836696, -2.228451, -1.032473>, <0.836696, -2.305934, -1.088448>, 
      <0.675588, -2.089147, -0.866149>, <0.675588, -2.165520, -0.923628>, <0.675588, -2.264645, -1.003875>, <0.675588, -2.342128, -1.059850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.845961, -1.301492>, <1.415654, -1.919921, -1.357467>, <1.415654, -2.002247, -1.452145>, <1.415654, -2.077434, -1.506461>, 
      <1.504344, -1.857252, -1.259652>, <1.504344, -1.931211, -1.315627>, <1.516761, -2.023610, -1.377440>, <1.516761, -2.098797, -1.431756>, 
      <1.487858, -1.944506, -1.045614>, <1.487858, -2.028350, -1.109993>, <1.342441, -2.088101, -1.174169>, <1.314391, -2.177197, -1.223662>, 
      <1.405996, -1.971406, -0.997459>, <1.405996, -2.055250, -1.061838>, <1.238051, -2.125437, -1.111172>, <1.210001, -2.214533, -1.160666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.845961, -1.301492>, <1.275488, -1.828117, -1.367616>, <1.059026, -1.897919, -1.244839>, <0.903662, -1.907457, -1.234439>, 
      <1.415654, -1.919921, -1.357467>, <1.275488, -1.902077, -1.423591>, <1.061549, -1.971352, -1.287010>, <0.906184, -1.980890, -1.276610>, 
      <1.415654, -2.002247, -1.452145>, <1.294731, -1.976698, -1.541492>, <1.079576, -2.076428, -1.335463>, <0.928920, -2.087926, -1.314766>, 
      <1.415654, -2.077434, -1.506461>, <1.294731, -2.051884, -1.595808>, <1.084520, -2.144690, -1.385394>, <0.933864, -2.156188, -1.364696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210001, -1.750442, -0.804318>, <1.233083, -1.831711, -0.868126>, <1.405996, -1.887433, -0.932981>, <1.405996, -1.971406, -0.997459>, 
      <1.072671, -1.808491, -0.728622>, <1.095752, -1.889760, -0.792430>, <1.219054, -1.948862, -0.823013>, <1.219054, -2.032835, -0.887490>, 
      <0.836658, -1.789735, -0.697933>, <0.836658, -1.875647, -0.760000>, <0.895231, -1.970612, -0.840168>, <0.895231, -2.055295, -0.903902>, 
      <0.675588, -1.805290, -0.655819>, <0.675588, -1.891202, -0.717886>, <0.675588, -2.004464, -0.802415>, <0.675588, -2.089147, -0.866149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.492465, -1.063739>, <1.415654, -1.598873, -1.134527>, <1.415654, -1.744053, -1.224365>, <1.415654, -1.845961, -1.301492>, 
      <1.505651, -1.551350, -0.998270>, <1.505651, -1.657758, -1.069059>, <1.504344, -1.755344, -1.182525>, <1.504344, -1.857252, -1.259652>, 
      <1.313410, -1.706731, -0.861317>, <1.336492, -1.788000, -0.925124>, <1.487858, -1.860533, -0.981136>, <1.487858, -1.944506, -1.045614>, 
      <1.210001, -1.750442, -0.804318>, <1.233083, -1.831711, -0.868126>, <1.405996, -1.887433, -0.932981>, <1.405996, -1.971406, -0.997459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.913260, -1.556284, -1.020184>, <0.917117, -1.658508, -1.089279>, <0.899987, -1.800455, -1.172990>, <0.903662, -1.907457, -1.234439>, 
      <1.107153, -1.531654, -1.036993>, <1.111010, -1.633878, -1.106089>, <1.055351, -1.790917, -1.183391>, <1.059026, -1.897919, -1.244839>, 
      <1.306657, -1.421148, -1.143029>, <1.306657, -1.527557, -1.213818>, <1.275488, -1.726210, -1.290489>, <1.275488, -1.828117, -1.367616>, 
      <1.415654, -1.492465, -1.063739>, <1.415654, -1.598873, -1.134527>, <1.415654, -1.744053, -1.224365>, <1.415654, -1.845961, -1.301492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.256974, -1.446708, -0.585498>, <1.109557, -1.526077, -0.513871>, <0.850774, -1.561905, -0.537515>, <0.675588, -1.607798, -0.518399>, 
      <1.287242, -1.370366, -0.546004>, <1.139825, -1.449735, -0.474377>, <0.862414, -1.490982, -0.442949>, <0.687229, -1.536874, -0.423833>, 
      <1.438757, -1.267927, -0.584395>, <1.268032, -1.368914, -0.443151>, <0.956303, -1.444292, -0.355526>, <0.738834, -1.504649, -0.264095>, 
      <1.426935, -1.203288, -0.521260>, <1.256210, -1.304275, -0.380016>, <0.953363, -1.377508, -0.257344>, <0.735894, -1.437864, -0.165914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.256974, -1.446708, -0.585498>, <1.219379, -1.541530, -0.634552>, <1.185325, -1.663559, -0.736103>, <1.210001, -1.750442, -0.804318>, 
      <1.109557, -1.526077, -0.513871>, <1.071962, -1.620899, -0.562925>, <1.047995, -1.721608, -0.660407>, <1.072671, -1.808491, -0.728622>, 
      <0.850774, -1.561905, -0.537515>, <0.843700, -1.605004, -0.594980>, <0.836658, -1.731227, -0.655664>, <0.836658, -1.789735, -0.697933>, 
      <0.675588, -1.607798, -0.518399>, <0.668514, -1.650897, -0.575865>, <0.675588, -1.746782, -0.613550>, <0.675588, -1.805290, -0.655819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.209347, -0.877983>, <1.513301, -1.238494, -0.809780>, <1.356239, -1.393264, -0.633729>, <1.256974, -1.446708, -0.585498>, 
      <1.420854, -1.150148, -0.841062>, <1.518501, -1.179294, -0.772859>, <1.386507, -1.316922, -0.594235>, <1.287242, -1.370366, -0.546004>, 
      <1.432359, -1.062622, -0.802638>, <1.517102, -1.086428, -0.771854>, <1.504137, -1.229254, -0.638485>, <1.438757, -1.267927, -0.584395>, 
      <1.457971, -1.010743, -0.763302>, <1.542715, -1.034549, -0.732518>, <1.492315, -1.164615, -0.575350>, <1.426935, -1.203288, -0.521260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.209347, -0.877983>, <1.408103, -1.295304, -0.931592>, <1.415654, -1.407886, -1.007473>, <1.415654, -1.492465, -1.063739>, 
      <1.513301, -1.238494, -0.809780>, <1.505750, -1.324450, -0.863389>, <1.505651, -1.466771, -0.942004>, <1.505651, -1.551350, -0.998270>, 
      <1.356239, -1.393264, -0.633729>, <1.318644, -1.488086, -0.682783>, <1.288734, -1.619848, -0.793101>, <1.313410, -1.706731, -0.861317>, 
      <1.256974, -1.446708, -0.585498>, <1.219379, -1.541530, -0.634552>, <1.185325, -1.663559, -0.736103>, <1.210001, -1.750442, -0.804318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.209347, -0.877983>, <1.420854, -1.150148, -0.841062>, <1.432359, -1.062622, -0.802638>, <1.457971, -1.010743, -0.763302>, 
      <1.284498, -1.170198, -0.969591>, <1.289699, -1.110999, -0.932670>, <1.291884, -1.023160, -0.853666>, <1.317497, -0.971281, -0.814330>, 
      <1.087991, -1.286382, -0.859182>, <1.094006, -1.208291, -0.806891>, <1.082310, -1.131470, -0.760894>, <1.102921, -1.051887, -0.714955>, 
      <0.882054, -1.334798, -0.847366>, <0.888070, -1.256707, -0.795074>, <0.930146, -1.149103, -0.740174>, <0.950757, -1.069520, -0.694234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.209347, -0.877983>, <1.284498, -1.170198, -0.969591>, <1.087991, -1.286382, -0.859182>, <0.882054, -1.334798, -0.847366>, 
      <1.408103, -1.295304, -0.931592>, <1.276947, -1.256155, -1.023199>, <1.082574, -1.356697, -0.906267>, <0.876637, -1.405114, -0.894451>, 
      <1.415654, -1.407886, -1.007473>, <1.306657, -1.336569, -1.086763>, <1.104503, -1.461434, -0.989530>, <0.910610, -1.486064, -0.972721>, 
      <1.415654, -1.492465, -1.063739>, <1.306657, -1.421148, -1.143029>, <1.107153, -1.531654, -1.036993>, <0.913260, -1.556284, -1.020184>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.824568, -0.148456, -2.890632>, <0.879722, -0.162214, -2.919202>, <0.952314, -0.168673, -2.970289>, <1.008416, -0.194315, -2.985864>, 
      <0.862579, -0.265525, -2.885941>, <0.917733, -0.279282, -2.914510>, <0.932757, -0.276911, -2.985093>, <0.988858, -0.302553, -3.000668>, 
      <0.796853, -0.432163, -2.927299>, <0.850927, -0.433511, -2.925015>, <0.924106, -0.447719, -2.952823>, <0.978179, -0.449067, -2.950539>, 
      <0.784975, -0.553752, -2.943013>, <0.839049, -0.555100, -2.940729>, <0.911147, -0.556898, -2.937684>, <0.965221, -0.558246, -2.935400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.824568, -0.148456, -2.890632>, <0.862579, -0.265525, -2.885941>, <0.796853, -0.432163, -2.927299>, <0.784975, -0.553752, -2.943013>, 
      <0.801848, -0.078482, -2.893436>, <0.839859, -0.195551, -2.888745>, <0.732356, -0.427813, -2.925212>, <0.720478, -0.549402, -2.940927>, 
      <0.663474, -0.088439, -2.992457>, <0.555757, -0.193370, -3.007534>, <0.643693, -0.412100, -2.955405>, <0.629385, -0.562326, -2.947125>, 
      <0.617679, -0.038500, -2.963660>, <0.509961, -0.143431, -2.978737>, <0.584294, -0.389026, -2.944339>, <0.569986, -0.539251, -2.936058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.841196, -0.359713, -2.622881>, <0.821914, -0.389272, -2.730821>, <0.801841, -0.495540, -2.846973>, <0.784975, -0.553752, -2.943013>, 
      <0.758815, -0.355825, -2.611996>, <0.739533, -0.385384, -2.719936>, <0.737345, -0.491190, -2.844887>, <0.720478, -0.549402, -2.940927>, 
      <0.648069, -0.362940, -2.603683>, <0.646090, -0.396217, -2.713618>, <0.627979, -0.509847, -2.844944>, <0.629385, -0.562326, -2.947125>, 
      <0.565300, -0.364323, -2.595455>, <0.563321, -0.397600, -2.705390>, <0.568580, -0.486773, -2.833877>, <0.569986, -0.539251, -2.936058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.133064, -0.391117, -2.670475>, <1.109554, -0.421967, -2.769780>, <1.015574, -0.508107, -2.855922>, <0.965221, -0.558246, -2.935400>, 
      <1.046847, -0.381567, -2.649623>, <1.023336, -0.412417, -2.748929>, <0.961500, -0.506759, -2.858206>, <0.911147, -0.556898, -2.937684>, 
      <0.929546, -0.363882, -2.634555>, <0.910264, -0.393441, -2.742495>, <0.855915, -0.496889, -2.844690>, <0.839049, -0.555100, -2.940729>, 
      <0.841196, -0.359713, -2.622881>, <0.821914, -0.389272, -2.730821>, <0.801841, -0.495540, -2.846973>, <0.784975, -0.553752, -2.943013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053816, -0.067937, -2.868338>, <1.053470, -0.099861, -2.911312>, <1.017850, -0.142103, -2.978723>, <1.008416, -0.194315, -2.985864>, 
      <0.926726, -0.037408, -2.898855>, <0.926380, -0.069332, -2.941829>, <0.961749, -0.116461, -2.963148>, <0.952314, -0.168673, -2.970289>, 
      <0.713343, 0.054689, -2.950270>, <0.759139, 0.004750, -2.979067>, <0.857003, -0.092240, -2.922006>, <0.879722, -0.162214, -2.919202>, 
      <0.617679, -0.038500, -2.963660>, <0.663474, -0.088439, -2.992457>, <0.801848, -0.078482, -2.893436>, <0.824568, -0.148456, -2.890632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.252890, -0.541827, -2.951272>, <1.198443, -0.607744, -2.937659>, <1.051522, -0.553320, -2.940162>, <0.965221, -0.558246, -2.935400>, 
      <1.297504, -0.505815, -2.893415>, <1.243057, -0.571732, -2.879802>, <1.101875, -0.503182, -2.860684>, <1.015574, -0.508107, -2.855922>, 
      <1.365005, -0.452076, -2.824580>, <1.328561, -0.515097, -2.780184>, <1.191958, -0.431094, -2.789710>, <1.109554, -0.421967, -2.769780>, 
      <1.401603, -0.421787, -2.758415>, <1.365159, -0.484808, -2.714018>, <1.215468, -0.400245, -2.690404>, <1.133064, -0.391117, -2.670475>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172390, -0.307435, -2.987196>, <1.138117, -0.258716, -2.992046>, <1.061117, -0.218403, -3.000495>, <1.008416, -0.194315, -2.985864>, 
      <1.215474, -0.368677, -2.981100>, <1.181200, -0.319958, -2.985950>, <1.041559, -0.326641, -3.015299>, <0.988858, -0.302553, -3.000668>, 
      <1.300138, -0.484626, -2.963085>, <1.245691, -0.550542, -2.949472>, <1.064480, -0.444141, -2.955301>, <0.978179, -0.449067, -2.950539>, 
      <1.252890, -0.541827, -2.951272>, <1.198443, -0.607744, -2.937659>, <1.051522, -0.553320, -2.940162>, <0.965221, -0.558246, -2.935400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172390, -0.307435, -2.987196>, <1.195446, -0.272268, -2.934640>, <1.238204, -0.208849, -2.875737>, <1.249244, -0.190211, -2.812009>, 
      <1.138117, -0.258716, -2.992046>, <1.161173, -0.223549, -2.939490>, <1.189481, -0.159277, -2.891136>, <1.200521, -0.140639, -2.827409>, 
      <1.061117, -0.218403, -3.000495>, <1.070551, -0.166191, -2.993354>, <1.120881, -0.116054, -2.895126>, <1.121227, -0.084130, -2.852151>, 
      <1.008416, -0.194315, -2.985864>, <1.017850, -0.142103, -2.978723>, <1.053470, -0.099861, -2.911312>, <1.053816, -0.067937, -2.868338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172390, -0.307435, -2.987196>, <1.215474, -0.368677, -2.981100>, <1.300138, -0.484626, -2.963085>, <1.252890, -0.541827, -2.951272>, 
      <1.195446, -0.272268, -2.934640>, <1.238530, -0.333510, -2.928544>, <1.344752, -0.448614, -2.905228>, <1.297504, -0.505815, -2.893415>, 
      <1.238204, -0.208849, -2.875737>, <1.296171, -0.267826, -2.857415>, <1.401205, -0.389475, -2.868681>, <1.365005, -0.452076, -2.824580>, 
      <1.249244, -0.190211, -2.812009>, <1.307211, -0.249189, -2.793688>, <1.437804, -0.359187, -2.802516>, <1.401603, -0.421787, -2.758415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.929081, -0.332842, -2.136312>, <0.911136, -0.339501, -2.283625>, <0.866419, -0.321047, -2.481685>, <0.841196, -0.359713, -2.622881>, 
      <0.824374, -0.333595, -2.146574>, <0.806429, -0.340255, -2.293887>, <0.784038, -0.317160, -2.470800>, <0.758815, -0.355825, -2.611996>, 
      <0.687088, -0.319732, -2.175487>, <0.686756, -0.335057, -2.296529>, <0.650171, -0.327598, -2.486924>, <0.648069, -0.362940, -2.603683>, 
      <0.583377, -0.314113, -2.192276>, <0.583045, -0.329438, -2.313318>, <0.567402, -0.328981, -2.478696>, <0.565300, -0.364323, -2.595455>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.154403, -0.310005, -2.136312>, <1.151177, -0.330352, -2.297211>, <1.168836, -0.344178, -2.519379>, <1.133064, -0.391117, -2.670475>, 
      <1.101415, -0.306786, -2.093907>, <1.098189, -0.327133, -2.254806>, <1.082618, -0.334628, -2.498528>, <1.046847, -0.381567, -2.649623>, 
      <0.996698, -0.332356, -2.129685>, <0.978753, -0.339015, -2.276999>, <0.954769, -0.325217, -2.493359>, <0.929546, -0.363882, -2.634555>, 
      <0.929081, -0.332842, -2.136312>, <0.911136, -0.339501, -2.283625>, <0.866419, -0.321047, -2.481685>, <0.841196, -0.359713, -2.622881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.465998, -0.365458, -2.565997>, <1.470337, -0.373130, -2.628553>, <1.429988, -0.398295, -2.707098>, <1.401603, -0.421787, -2.758415>, 
      <1.431378, -0.413756, -2.417335>, <1.435717, -0.421428, -2.479892>, <1.393544, -0.461316, -2.662701>, <1.365159, -0.484808, -2.714018>, 
      <1.279262, -0.317590, -2.236234>, <1.276035, -0.337937, -2.397133>, <1.251239, -0.353306, -2.539308>, <1.215468, -0.400245, -2.690404>, 
      <1.154403, -0.310005, -2.136312>, <1.151177, -0.330352, -2.297211>, <1.168836, -0.344178, -2.519379>, <1.133064, -0.391117, -2.670475>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.249244, -0.177693, -2.543571>, <1.249244, -0.181595, -2.624095>, <1.262467, -0.167888, -2.735679>, <1.249244, -0.190211, -2.812009>, 
      <1.310851, -0.237667, -2.536192>, <1.310851, -0.241569, -2.616716>, <1.320434, -0.226865, -2.717358>, <1.307211, -0.249189, -2.793688>, 
      <1.484658, -0.339425, -2.646127>, <1.488998, -0.347097, -2.708683>, <1.466188, -0.335695, -2.751199>, <1.437804, -0.359187, -2.802516>, 
      <1.465998, -0.365458, -2.565997>, <1.470337, -0.373130, -2.628553>, <1.429988, -0.398295, -2.707098>, <1.401603, -0.421787, -2.758415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.011357, 0.077132, -2.620454>, <1.011357, 0.071806, -2.707392>, <1.054379, -0.015998, -2.798420>, <1.053816, -0.067937, -2.868338>, 
      <0.890689, 0.131291, -2.654169>, <0.890689, 0.125966, -2.741106>, <0.927289, 0.014531, -2.828937>, <0.926726, -0.037408, -2.898855>, 
      <0.697185, 0.103155, -2.680376>, <0.705359, 0.065874, -2.757583>, <0.659771, 0.113109, -2.916583>, <0.713343, 0.054689, -2.950270>, 
      <0.573079, 0.125788, -2.732492>, <0.581252, 0.088507, -2.809699>, <0.564107, 0.019920, -2.929973>, <0.617679, -0.038500, -2.963660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.011357, 0.077132, -2.620454>, <1.011357, 0.071806, -2.707392>, <1.054379, -0.015998, -2.798420>, <1.053816, -0.067937, -2.868338>, 
      <1.106035, 0.034638, -2.594001>, <1.106035, 0.029313, -2.680938>, <1.121790, -0.032191, -2.782233>, <1.121227, -0.084130, -2.852151>, 
      <1.172787, -0.103263, -2.552729>, <1.172787, -0.107165, -2.633254>, <1.213745, -0.118316, -2.751079>, <1.200521, -0.140639, -2.827409>, 
      <1.249244, -0.177693, -2.543571>, <1.249244, -0.181595, -2.624095>, <1.262467, -0.167888, -2.735679>, <1.249244, -0.190211, -2.812009>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.936555, -0.324326, -1.840070>, <0.934334, -0.325079, -1.928977>, <0.939825, -0.328855, -2.048116>, <0.929081, -0.332842, -2.136312>, 
      <0.824576, -0.321505, -1.844246>, <0.822355, -0.322258, -1.933152>, <0.835118, -0.329608, -2.058378>, <0.824374, -0.333595, -2.146574>, 
      <0.678086, -0.287301, -1.855272>, <0.679866, -0.301284, -1.954360>, <0.687361, -0.307160, -2.076194>, <0.687088, -0.319732, -2.175487>, 
      <0.567314, -0.271433, -1.861787>, <0.569094, -0.285416, -1.960876>, <0.583650, -0.301542, -2.092983>, <0.583377, -0.314113, -2.192276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.149716, -0.286105, -1.840070>, <1.150414, -0.289348, -1.929181>, <1.156177, -0.298820, -2.047862>, <1.154403, -0.310005, -2.136312>, 
      <1.095740, -0.283626, -1.803996>, <1.096438, -0.286869, -1.893107>, <1.103189, -0.295601, -2.005456>, <1.101415, -0.306786, -2.093907>, 
      <1.001457, -0.325961, -1.837650>, <0.999236, -0.326714, -1.926556>, <1.007442, -0.328369, -2.041489>, <0.996698, -0.332356, -2.129685>, 
      <0.936555, -0.324326, -1.840070>, <0.934334, -0.325079, -1.928977>, <0.939825, -0.328855, -2.048116>, <0.929081, -0.332842, -2.136312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.357414, -0.343658, -2.121343>, <1.362602, -0.348697, -2.258624>, <1.456556, -0.348764, -2.429870>, <1.465998, -0.365458, -2.565997>, 
      <1.323337, -0.388240, -2.031054>, <1.328526, -0.393279, -2.168335>, <1.421936, -0.397062, -2.281208>, <1.431378, -0.413756, -2.417335>, 
      <1.238035, -0.290162, -1.899096>, <1.238733, -0.293405, -1.988207>, <1.281035, -0.306405, -2.147784>, <1.279262, -0.317590, -2.236234>, 
      <1.149716, -0.286105, -1.840070>, <1.150414, -0.289348, -1.929181>, <1.156177, -0.298820, -2.047862>, <1.154403, -0.310005, -2.136312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.249244, -0.155893, -2.103779>, <1.249244, -0.161026, -2.235779>, <1.249244, -0.171299, -2.411626>, <1.249244, -0.177693, -2.543571>, 
      <1.293911, -0.203349, -2.106363>, <1.293911, -0.208482, -2.238363>, <1.310851, -0.231273, -2.404247>, <1.310851, -0.237667, -2.536192>, 
      <1.378321, -0.316306, -2.176738>, <1.383509, -0.321345, -2.314019>, <1.475216, -0.322731, -2.509999>, <1.484658, -0.339425, -2.646127>, 
      <1.357414, -0.343658, -2.121343>, <1.362602, -0.348697, -2.258624>, <1.456556, -0.348764, -2.429870>, <1.465998, -0.365458, -2.565997>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053816, -0.021102, -2.103779>, <1.046491, -0.028527, -2.261728>, <1.011357, 0.086810, -2.462458>, <1.011357, 0.077132, -2.620454>, 
      <0.894330, 0.096451, -2.103779>, <0.887005, 0.089027, -2.261728>, <0.890689, 0.140970, -2.496172>, <0.890689, 0.131291, -2.654169>, 
      <0.635868, 0.211408, -2.103779>, <0.644523, 0.147106, -2.296720>, <0.677868, 0.191270, -2.497897>, <0.697185, 0.103155, -2.680376>, 
      <0.526651, 0.376715, -2.103779>, <0.535306, 0.312412, -2.296720>, <0.553762, 0.213903, -2.550013>, <0.573079, 0.125788, -2.732492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053816, -0.021102, -2.103779>, <1.046491, -0.028527, -2.261728>, <1.011357, 0.086810, -2.462458>, <1.011357, 0.077132, -2.620454>, 
      <1.111147, -0.063359, -2.103779>, <1.103822, -0.070784, -2.261728>, <1.106035, 0.044317, -2.436005>, <1.106035, 0.034638, -2.594001>, 
      <1.200468, -0.104072, -2.100957>, <1.200468, -0.109204, -2.232957>, <1.172787, -0.096869, -2.420784>, <1.172787, -0.103263, -2.552729>, 
      <1.249244, -0.155893, -2.103779>, <1.249244, -0.161026, -2.235779>, <1.249244, -0.171299, -2.411626>, <1.249244, -0.177693, -2.543571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.502728, -0.347984, -1.339575>, <1.381460, -0.323422, -1.205076>, <1.219768, -0.290673, -1.025743>, <1.098500, -0.266111, -0.891244>, 
      <1.514797, -0.346159, -1.144653>, <1.393529, -0.321597, -1.010154>, <1.213139, -0.278191, -0.905619>, <1.091870, -0.253629, -0.771119>, 
      <1.498208, -0.331416, -0.884191>, <1.359085, -0.310609, -0.875432>, <1.112264, -0.218491, -0.598102>, <0.985045, -0.177610, -0.553278>, 
      <1.496271, -0.324316, -0.689026>, <1.357148, -0.303509, -0.680267>, <1.219505, -0.220987, -0.542220>, <1.092286, -0.180106, -0.497396>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053816, 0.120171, -1.704893>, <1.072685, 0.108023, -1.829843>, <1.059691, -0.015147, -1.977106>, <1.053816, -0.021102, -2.103779>, 
      <0.909434, 0.243411, -1.698415>, <0.928303, 0.231263, -1.823365>, <0.900205, 0.102406, -1.977106>, <0.894330, 0.096451, -2.103779>, 
      <0.640575, 0.318780, -1.700709>, <0.635341, 0.306217, -1.825068>, <0.630548, 0.250927, -1.985202>, <0.635868, 0.211408, -2.103779>, 
      <0.526651, 0.470725, -1.697508>, <0.521418, 0.458162, -1.821867>, <0.521332, 0.416234, -1.985202>, <0.526651, 0.376715, -2.103779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053816, 0.120171, -1.704893>, <0.909434, 0.243411, -1.698415>, <0.640575, 0.318780, -1.700709>, <0.526651, 0.470725, -1.697508>, 
      <1.035240, 0.132130, -1.581887>, <0.890858, 0.255369, -1.575409>, <0.645674, 0.331022, -1.579524>, <0.531751, 0.482967, -1.576323>, 
      <0.924169, 0.033884, -1.433689>, <0.812170, 0.154688, -1.428192>, <0.620546, 0.284079, -1.418993>, <0.554199, 0.434806, -1.412135>, 
      <0.934107, 0.055965, -1.311083>, <0.822109, 0.176769, -1.305586>, <0.627126, 0.307918, -1.299619>, <0.560779, 0.458644, -1.292761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.944029, -0.327772, -1.537993>, <0.828752, -0.314823, -1.540159>, <0.683483, -0.254653, -1.545594>, <0.571821, -0.223317, -1.548851>, 
      <0.947451, -0.311499, -1.343079>, <0.832174, -0.298550, -1.345244>, <0.692696, -0.231381, -1.354983>, <0.581033, -0.200044, -1.358241>, 
      <0.950992, -0.277962, -1.084075>, <0.848979, -0.251105, -1.090591>, <0.702778, -0.202762, -1.097213>, <0.600765, -0.175905, -1.103728>, 
      <0.953211, -0.245109, -0.891244>, <0.851199, -0.218252, -0.897759>, <0.715182, -0.182443, -0.906446>, <0.613170, -0.155586, -0.912961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.944029, -0.327772, -1.537993>, <0.942443, -0.335313, -1.628322>, <0.938819, -0.323558, -1.749445>, <0.936555, -0.324326, -1.840070>, 
      <0.828752, -0.314823, -1.540159>, <0.827167, -0.322365, -1.630487>, <0.826840, -0.320737, -1.753620>, <0.824576, -0.321505, -1.844246>, 
      <0.683483, -0.254653, -1.545594>, <0.678932, -0.266153, -1.639779>, <0.676397, -0.274030, -1.761225>, <0.678086, -0.287301, -1.855272>, 
      <0.571821, -0.223317, -1.548851>, <0.567269, -0.234817, -1.643036>, <0.565625, -0.258162, -1.767740>, <0.567314, -0.271433, -1.861787>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.149716, -0.288231, -1.537993>, <1.090216, -0.287496, -1.517803>, <1.006461, -0.334785, -1.536820>, <0.944029, -0.327772, -1.537993>, 
      <1.139222, -0.284134, -1.343574>, <1.079722, -0.283399, -1.323384>, <1.009883, -0.318512, -1.341906>, <0.947451, -0.311499, -1.343079>, 
      <1.109174, -0.286208, -1.084655>, <1.065587, -0.279907, -1.084655>, <0.994578, -0.284262, -1.084075>, <0.950992, -0.277962, -1.084075>, 
      <1.098500, -0.266111, -0.891244>, <1.054913, -0.259810, -0.891244>, <0.996798, -0.251410, -0.891244>, <0.953211, -0.245109, -0.891244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.149716, -0.288231, -1.537993>, <1.154600, -0.290137, -1.628467>, <1.149007, -0.282809, -1.749507>, <1.149716, -0.286105, -1.840070>, 
      <1.090216, -0.287496, -1.517803>, <1.095100, -0.289402, -1.608277>, <1.095031, -0.280330, -1.713434>, <1.095740, -0.283626, -1.803996>, 
      <1.006461, -0.334785, -1.536820>, <1.004876, -0.342326, -1.627149>, <1.003721, -0.325193, -1.747025>, <1.001457, -0.325961, -1.837650>, 
      <0.944029, -0.327772, -1.537993>, <0.942443, -0.335313, -1.628322>, <0.938819, -0.323558, -1.749445>, <0.936555, -0.324326, -1.840070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.433423, -0.333820, -1.704058>, <1.395128, -0.388525, -1.630207>, <1.243994, -0.289396, -1.569984>, <1.149716, -0.288231, -1.537993>, 
      <1.453778, -0.334426, -1.594550>, <1.415483, -0.389131, -1.520700>, <1.233499, -0.285299, -1.375565>, <1.139222, -0.284134, -1.343574>, 
      <1.495845, -0.349025, -1.450743>, <1.374576, -0.324463, -1.316243>, <1.230443, -0.310770, -1.219155>, <1.109174, -0.286208, -1.084655>, 
      <1.502728, -0.347984, -1.339575>, <1.381460, -0.323422, -1.205076>, <1.219768, -0.290673, -1.025743>, <1.098500, -0.266111, -0.891244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.433423, -0.333820, -1.704058>, <1.410163, -0.333128, -1.829192>, <1.352610, -0.338993, -1.994240>, <1.357414, -0.343658, -2.121343>, 
      <1.395128, -0.388525, -1.630207>, <1.371868, -0.387833, -1.755342>, <1.318534, -0.383575, -1.903951>, <1.323337, -0.388240, -2.031054>, 
      <1.243994, -0.289396, -1.569984>, <1.248878, -0.291303, -1.660458>, <1.237326, -0.286866, -1.808534>, <1.238035, -0.290162, -1.899096>, 
      <1.149716, -0.288231, -1.537993>, <1.154600, -0.290137, -1.628467>, <1.149007, -0.282809, -1.749507>, <1.149716, -0.286105, -1.840070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.249244, -0.146055, -1.729928>, <1.185508, -0.069830, -1.730068>, <1.129346, 0.055701, -1.708282>, <1.053816, 0.120171, -1.704893>, 
      <1.251201, -0.133829, -1.611586>, <1.187465, -0.057604, -1.611727>, <1.110770, 0.067660, -1.585276>, <1.035240, 0.132130, -1.581887>, 
      <1.245577, -0.093830, -1.456224>, <1.147245, -0.053958, -1.447677>, <1.022501, -0.005988, -1.442236>, <0.924169, 0.033884, -1.433689>, 
      <1.261880, -0.076942, -1.339575>, <1.163548, -0.037070, -1.331027>, <1.032439, 0.016093, -1.319631>, <0.934107, 0.055965, -1.311083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.249244, -0.146055, -1.729928>, <1.300103, -0.206879, -1.729816>, <1.463918, -0.290257, -1.762867>, <1.433423, -0.333820, -1.704058>, 
      <1.251201, -0.133829, -1.611586>, <1.302059, -0.194653, -1.611474>, <1.484274, -0.290863, -1.653359>, <1.453778, -0.334426, -1.594550>, 
      <1.245577, -0.093830, -1.456224>, <1.317831, -0.175143, -1.456224>, <1.423590, -0.267712, -1.450743>, <1.495845, -0.349025, -1.450743>, 
      <1.261880, -0.076942, -1.339575>, <1.334135, -0.158255, -1.339575>, <1.430474, -0.266671, -1.339575>, <1.502728, -0.347984, -1.339575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.249244, -0.146055, -1.729928>, <1.185508, -0.069830, -1.730068>, <1.129346, 0.055701, -1.708282>, <1.053816, 0.120171, -1.704893>, 
      <1.247399, -0.157583, -1.841513>, <1.183663, -0.081358, -1.841653>, <1.148215, 0.043554, -1.833232>, <1.072685, 0.108023, -1.829843>, 
      <1.249244, -0.151534, -1.991670>, <1.200468, -0.099712, -1.988848>, <1.117021, -0.057404, -1.977106>, <1.059691, -0.015147, -1.977106>, 
      <1.249244, -0.155893, -2.103779>, <1.200468, -0.104072, -2.100957>, <1.111147, -0.063359, -2.103779>, <1.053816, -0.021102, -2.103779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.249244, -0.146055, -1.729928>, <1.247399, -0.157583, -1.841513>, <1.249244, -0.151534, -1.991670>, <1.249244, -0.155893, -2.103779>, 
      <1.300103, -0.206879, -1.729816>, <1.298258, -0.218407, -1.841401>, <1.293911, -0.198990, -1.994254>, <1.293911, -0.203349, -2.106363>, 
      <1.463918, -0.290257, -1.762867>, <1.440659, -0.289565, -1.888001>, <1.373517, -0.311640, -2.049634>, <1.378321, -0.316306, -2.176738>, 
      <1.433423, -0.333820, -1.704058>, <1.410163, -0.333128, -1.829192>, <1.352610, -0.338993, -1.994240>, <1.357414, -0.343658, -2.121343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.955991, -0.150701, -0.498666>, <0.996269, -0.161857, -0.496920>, <1.054528, -0.167973, -0.484093>, <1.092286, -0.180106, -0.497396>, 
      <0.955157, -0.179023, -0.616439>, <0.995435, -0.190179, -0.614694>, <0.947287, -0.165477, -0.539975>, <0.985045, -0.177610, -0.553278>, 
      <0.954585, -0.224766, -0.771838>, <0.998172, -0.231066, -0.771838>, <1.048284, -0.247329, -0.771119>, <1.091870, -0.253629, -0.771119>, 
      <0.953211, -0.245109, -0.891244>, <0.996798, -0.251410, -0.891244>, <1.054913, -0.259810, -0.891244>, <1.098500, -0.266111, -0.891244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.955991, -0.150701, -0.498666>, <0.955157, -0.179023, -0.616439>, <0.954585, -0.224766, -0.771838>, <0.953211, -0.245109, -0.891244>, 
      <0.861300, -0.124475, -0.502770>, <0.860466, -0.152797, -0.620543>, <0.852573, -0.197909, -0.778354>, <0.851199, -0.218252, -0.897759>, 
      <0.736764, -0.084142, -0.511413>, <0.727872, -0.114133, -0.630239>, <0.724074, -0.152452, -0.787620>, <0.715182, -0.182443, -0.906446>, 
      <0.642809, -0.055617, -0.516876>, <0.633917, -0.085608, -0.635702>, <0.622062, -0.125595, -0.794135>, <0.613170, -0.155586, -0.912961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.374116, -0.016704, -0.836482>, <1.430101, -0.102815, -0.800892>, <1.493190, -0.233865, -0.749236>, <1.496271, -0.324316, -0.689026>, 
      <1.316746, -0.087024, -0.962986>, <1.372731, -0.173135, -0.927396>, <1.495127, -0.240965, -0.944400>, <1.498208, -0.331416, -0.884191>, 
      <1.283212, -0.054844, -1.186944>, <1.355467, -0.136157, -1.186944>, <1.442543, -0.264846, -1.144653>, <1.514797, -0.346159, -1.144653>, 
      <1.261880, -0.076942, -1.339575>, <1.334135, -0.158255, -1.339575>, <1.430474, -0.266671, -1.339575>, <1.502728, -0.347984, -1.339575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.116597, 0.259659, -0.930385>, <1.207153, 0.186053, -0.926176>, <1.313974, 0.075801, -0.874714>, <1.374116, -0.016704, -0.836482>, 
      <1.069435, 0.193986, -1.045441>, <1.159991, 0.120380, -1.041232>, <1.256603, 0.005481, -1.001219>, <1.316746, -0.087024, -0.962986>, 
      <0.945290, 0.080811, -1.173123>, <1.043622, 0.040939, -1.181671>, <1.184881, -0.014972, -1.178397>, <1.283212, -0.054844, -1.186944>, 
      <0.934107, 0.055965, -1.311083>, <1.032439, 0.016093, -1.319631>, <1.163548, -0.037070, -1.331027>, <1.261880, -0.076942, -1.339575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.116597, 0.259659, -0.930385>, <1.069435, 0.193986, -1.045441>, <0.945290, 0.080811, -1.173123>, <0.934107, 0.055965, -1.311083>, 
      <0.962141, 0.385204, -0.937564>, <0.914978, 0.319531, -1.052621>, <0.833291, 0.201615, -1.167627>, <0.822109, 0.176769, -1.305586>, 
      <0.711237, 0.494339, -0.895003>, <0.696766, 0.465907, -1.027669>, <0.634491, 0.334599, -1.166008>, <0.627126, 0.307918, -1.299619>, 
      <0.572058, 0.635222, -0.873763>, <0.557587, 0.606790, -1.006429>, <0.568144, 0.485325, -1.159150>, <0.560779, 0.458644, -1.292761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.623105, 0.623366, 0.260199>, <1.691989, 0.658257, 0.279935>, <1.787765, 0.706240, 0.294121>, <1.852719, 0.739669, 0.325985>, 
      <1.659275, 0.562588, 0.255928>, <1.728160, 0.597479, 0.275664>, <1.823577, 0.648732, 0.307533>, <1.888531, 0.682161, 0.339398>, 
      <1.677483, 0.528083, 0.213570>, <1.746619, 0.567488, 0.230249>, <1.840397, 0.616370, 0.254353>, <1.911327, 0.651463, 0.273009>, 
      <1.686551, 0.484126, 0.158742>, <1.755687, 0.523530, 0.175421>, <1.846075, 0.580381, 0.195683>, <1.917006, 0.615474, 0.214339>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.574954, 0.671645, 0.171919>, <1.642434, 0.711216, 0.171486>, <1.734012, 0.761410, 0.168311>, <1.799886, 0.803547, 0.170474>, 
      <1.586472, 0.669286, 0.203250>, <1.653952, 0.708856, 0.202816>, <1.750179, 0.763240, 0.218613>, <1.816053, 0.805377, 0.220776>, 
      <1.601129, 0.660293, 0.262794>, <1.670013, 0.695184, 0.282530>, <1.752497, 0.762874, 0.280912>, <1.817451, 0.796303, 0.312776>, 
      <1.623105, 0.623366, 0.260199>, <1.691989, 0.658257, 0.279935>, <1.787765, 0.706240, 0.294121>, <1.852719, 0.739669, 0.325985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.530626, 0.642309, 0.008651>, <1.592233, 0.667552, -0.005113>, <1.674948, 0.702021, -0.019912>, <1.735983, 0.726453, -0.037229>, 
      <1.543694, 0.665335, 0.069399>, <1.605301, 0.690578, 0.055635>, <1.685730, 0.756073, 0.049955>, <1.746766, 0.780505, 0.032638>, 
      <1.557224, 0.675277, 0.123692>, <1.624704, 0.714847, 0.123259>, <1.712859, 0.759015, 0.102494>, <1.778733, 0.801152, 0.104657>, 
      <1.574954, 0.671645, 0.171919>, <1.642434, 0.711216, 0.171486>, <1.734012, 0.761410, 0.168311>, <1.799886, 0.803547, 0.170474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.505100, 0.548564, -0.152797>, <1.575466, 0.534474, -0.172904>, <1.680408, 0.518038, -0.177701>, <1.739652, 0.501599, -0.219819>, 
      <1.489197, 0.572856, -0.156335>, <1.559563, 0.558767, -0.176442>, <1.652771, 0.552809, -0.184710>, <1.712015, 0.536370, -0.226828>, 
      <1.516285, 0.617040, -0.058014>, <1.577892, 0.642283, -0.071778>, <1.661402, 0.634117, -0.107684>, <1.722437, 0.658548, -0.125001>, 
      <1.530626, 0.642309, 0.008651>, <1.592233, 0.667552, -0.005113>, <1.674948, 0.702021, -0.019912>, <1.735983, 0.726453, -0.037229>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.659950, 0.444761, 0.037427>, <1.727236, 0.473312, 0.026310>, <1.816176, 0.520038, 0.021305>, <1.884235, 0.539932, 0.000369>, 
      <1.609023, 0.462847, -0.050012>, <1.676308, 0.491398, -0.061129>, <1.778423, 0.495797, -0.071113>, <1.846482, 0.515692, -0.092049>, 
      <1.527579, 0.514227, -0.147795>, <1.597944, 0.500138, -0.167902>, <1.705804, 0.486087, -0.171260>, <1.765048, 0.469648, -0.213378>, 
      <1.505100, 0.548564, -0.152797>, <1.575466, 0.534474, -0.172904>, <1.680408, 0.518038, -0.177701>, <1.739652, 0.501599, -0.219819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.659950, 0.444761, 0.037427>, <1.684862, 0.435914, 0.080199>, <1.692986, 0.452932, 0.119834>, <1.686551, 0.484126, 0.158742>, 
      <1.727236, 0.473312, 0.026310>, <1.752148, 0.464465, 0.069082>, <1.762123, 0.492336, 0.136513>, <1.755687, 0.523530, 0.175421>, 
      <1.816176, 0.520038, 0.021305>, <1.848693, 0.540916, 0.100904>, <1.853351, 0.534271, 0.120515>, <1.846075, 0.580381, 0.195683>, 
      <1.884235, 0.539932, 0.000369>, <1.916751, 0.560810, 0.079968>, <1.924281, 0.569365, 0.139171>, <1.917006, 0.615474, 0.214339>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.902934, 0.767380, 0.397474>, <1.953228, 0.699998, 0.417857>, <1.998535, 0.682975, 0.320138>, <2.009613, 0.643963, 0.243714>, 
      <1.893291, 0.756774, 0.374011>, <1.943585, 0.689392, 0.394394>, <1.974954, 0.699596, 0.310641>, <1.986031, 0.660584, 0.234217>, 
      <1.875128, 0.751202, 0.336978>, <1.910940, 0.693694, 0.350391>, <1.937825, 0.664573, 0.279979>, <1.943503, 0.628584, 0.221308>, 
      <1.852719, 0.739669, 0.325985>, <1.888531, 0.682161, 0.339398>, <1.911327, 0.651463, 0.273009>, <1.917006, 0.615474, 0.214339>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855167, 0.850887, 0.181120>, <1.872132, 0.854106, 0.250023>, <1.849813, 0.838551, 0.375945>, <1.902934, 0.767380, 0.397474>, 
      <1.867796, 0.833151, 0.177531>, <1.884760, 0.836370, 0.246433>, <1.840170, 0.827945, 0.352482>, <1.893291, 0.756774, 0.374011>, 
      <1.818468, 0.815433, 0.171084>, <1.834635, 0.817263, 0.221386>, <1.839860, 0.807835, 0.323769>, <1.875128, 0.751202, 0.336978>, 
      <1.799886, 0.803547, 0.170474>, <1.816053, 0.805377, 0.220776>, <1.817451, 0.796303, 0.312776>, <1.852719, 0.739669, 0.325985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.789142, 0.745790, -0.064697>, <1.813140, 0.807703, 0.018284>, <1.835437, 0.847144, 0.100986>, <1.855167, 0.850887, 0.181120>, 
      <1.799461, 0.731047, -0.059038>, <1.823460, 0.792959, 0.023942>, <1.848066, 0.829407, 0.097396>, <1.867796, 0.833151, 0.177531>, 
      <1.752919, 0.733232, -0.042034>, <1.763702, 0.787284, 0.027832>, <1.797314, 0.813038, 0.105267>, <1.818468, 0.815433, 0.171084>, 
      <1.735983, 0.726453, -0.037229>, <1.746766, 0.780505, 0.032638>, <1.778733, 0.801152, 0.104657>, <1.799886, 0.803547, 0.170474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.715367, 0.490218, -0.302280>, <1.679448, 0.532324, -0.303696>, <1.758060, 0.665602, -0.172172>, <1.789142, 0.745790, -0.064697>, 
      <1.721797, 0.497022, -0.278009>, <1.685877, 0.539127, -0.279425>, <1.768379, 0.650859, -0.166513>, <1.799461, 0.731047, -0.059038>, 
      <1.760332, 0.495861, -0.234521>, <1.732695, 0.530631, -0.241530>, <1.739373, 0.665328, -0.129807>, <1.752919, 0.733232, -0.042034>, 
      <1.739652, 0.501599, -0.219819>, <1.712015, 0.536370, -0.226828>, <1.722437, 0.658548, -0.125001>, <1.735983, 0.726453, -0.037229>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.968900, 0.535071, -0.057612>, <1.905779, 0.502090, -0.174737>, <1.751137, 0.448287, -0.300870>, <1.715367, 0.490218, -0.302280>, 
      <1.953071, 0.560219, -0.049435>, <1.889951, 0.527238, -0.166560>, <1.757567, 0.455090, -0.276599>, <1.721797, 0.497022, -0.278009>, 
      <1.912605, 0.548225, -0.008358>, <1.874853, 0.523985, -0.100776>, <1.785728, 0.463909, -0.228080>, <1.760332, 0.495861, -0.234521>, 
      <1.884235, 0.539932, 0.000369>, <1.846482, 0.515692, -0.092049>, <1.765048, 0.469648, -0.213378>, <1.739652, 0.501599, -0.219819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.968900, 0.535071, -0.057612>, <1.953071, 0.560219, -0.049435>, <1.912605, 0.548225, -0.008358>, <1.884235, 0.539932, 0.000369>, 
      <2.026297, 0.565061, 0.048893>, <2.010469, 0.590209, 0.057070>, <1.945122, 0.569103, 0.071241>, <1.916751, 0.560810, 0.079968>, 
      <2.025573, 0.587757, 0.133608>, <2.001992, 0.604378, 0.124111>, <1.950779, 0.582475, 0.146140>, <1.924281, 0.569365, 0.139171>, 
      <2.009613, 0.643963, 0.243714>, <1.986031, 0.660584, 0.234217>, <1.943503, 0.628584, 0.221308>, <1.917006, 0.615474, 0.214339>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.403949, 0.865645, 0.348699>, <1.349328, 0.934735, 0.618985>, <1.221075, 1.077755, 0.955859>, <1.177898, 1.115928, 1.234230>, 
      <1.568658, 0.848354, 0.366950>, <1.514037, 0.917445, 0.637237>, <1.373376, 1.021074, 0.955859>, <1.330199, 1.059246, 1.234230>, 
      <1.823418, 0.946257, 0.476564>, <1.764317, 0.982185, 0.695228>, <1.611048, 1.013477, 1.010462>, <1.561101, 1.019003, 1.234230>, 
      <1.931526, 0.826349, 0.517743>, <1.872426, 0.862277, 0.736407>, <1.726722, 0.899338, 1.010462>, <1.676776, 0.904864, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.403949, 0.865645, 0.348699>, <1.182138, 0.888930, 0.324120>, <0.884958, 0.931663, 0.368676>, <0.662480, 0.959570, 0.377120>, 
      <1.349328, 0.934735, 0.618985>, <1.127517, 0.958020, 0.594406>, <0.884958, 1.027943, 0.626017>, <0.662480, 1.055850, 0.634462>, 
      <1.221075, 1.077755, 0.955859>, <1.068793, 1.134430, 0.955859>, <0.809353, 1.182692, 0.964241>, <0.654524, 1.231985, 0.964241>, 
      <1.177898, 1.115928, 1.234230>, <1.025616, 1.172603, 1.234230>, <0.817309, 1.233061, 1.234230>, <0.662480, 1.282354, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.697451, 0.456945, -0.379121>, <1.798973, 0.257065, -0.420287>, <1.791419, -0.058347, -0.499511>, <1.772169, -0.281790, -0.540201>, 
      <1.604930, 0.319507, -0.523955>, <1.706452, 0.119627, -0.565121>, <1.745031, -0.097298, -0.572571>, <1.725780, -0.320742, -0.613261>, 
      <1.455205, 0.082689, -0.657676>, <1.511191, -0.003422, -0.622086>, <1.586870, -0.247875, -0.755134>, <1.589950, -0.338327, -0.694924>, 
      <1.374116, -0.016704, -0.836482>, <1.430101, -0.102815, -0.800892>, <1.493190, -0.233865, -0.749236>, <1.496271, -0.324316, -0.689026>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.065521, 0.510795, 0.274150>, <2.074263, 0.553719, 0.280617>, <2.043992, 0.619732, 0.257559>, <2.009613, 0.643963, 0.243714>, 
      <2.054188, 0.589994, 0.371705>, <2.062929, 0.632918, 0.378172>, <2.032914, 0.658744, 0.333983>, <1.998535, 0.682975, 0.320138>, 
      <1.971725, 0.731683, 0.444665>, <1.982313, 0.725246, 0.405489>, <1.967638, 0.715848, 0.452921>, <1.953228, 0.699998, 0.417857>, 
      <1.931526, 0.826349, 0.517743>, <1.942115, 0.819912, 0.478567>, <1.917344, 0.783230, 0.432538>, <1.902934, 0.767380, 0.397474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.697995, 0.946646, 0.199435>, <1.750389, 0.942409, 0.311535>, <1.861467, 0.862438, 0.422251>, <1.931526, 0.826349, 0.517743>, 
      <1.753204, 0.948485, 0.204661>, <1.805598, 0.944248, 0.316761>, <1.872055, 0.856001, 0.383074>, <1.942115, 0.819912, 0.478567>, 
      <1.823412, 0.895484, 0.190146>, <1.840377, 0.898703, 0.259049>, <1.864223, 0.854401, 0.411009>, <1.917344, 0.783230, 0.432538>, 
      <1.855167, 0.850887, 0.181120>, <1.872132, 0.854106, 0.250023>, <1.849813, 0.838551, 0.375945>, <1.902934, 0.767380, 0.397474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.650135, 0.849106, -0.084306>, <1.701148, 0.848743, -0.072821>, <1.760538, 0.786657, -0.080383>, <1.789142, 0.745790, -0.064697>, 
      <1.650029, 0.753574, -0.197172>, <1.701042, 0.753212, -0.185687>, <1.729456, 0.706469, -0.187858>, <1.758060, 0.665602, -0.172172>, 
      <1.683256, 0.574593, -0.290677>, <1.694057, 0.590638, -0.273769>, <1.673098, 0.525605, -0.327664>, <1.679448, 0.532324, -0.303696>, 
      <1.697451, 0.456945, -0.379121>, <1.708252, 0.472989, -0.362213>, <1.709018, 0.483500, -0.326248>, <1.715367, 0.490218, -0.302280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.650135, 0.849106, -0.084306>, <1.650201, 0.907994, -0.014733>, <1.659423, 0.949765, 0.116908>, <1.697995, 0.946646, 0.199435>, 
      <1.701148, 0.848743, -0.072821>, <1.701213, 0.907631, -0.003248>, <1.714632, 0.951604, 0.122134>, <1.753204, 0.948485, 0.204661>, 
      <1.760538, 0.786657, -0.080383>, <1.784536, 0.848570, 0.002598>, <1.803682, 0.891741, 0.110012>, <1.823412, 0.895484, 0.190146>, 
      <1.789142, 0.745790, -0.064697>, <1.813140, 0.807703, 0.018284>, <1.835437, 0.847144, 0.100986>, <1.855167, 0.850887, 0.181120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.998489, 0.358407, -0.058653>, <1.932304, 0.348724, -0.176121>, <1.787762, 0.427384, -0.282981>, <1.697451, 0.456945, -0.379121>, 
      <2.007528, 0.411284, -0.055477>, <1.941343, 0.401601, -0.172945>, <1.798563, 0.443428, -0.266073>, <1.708252, 0.472989, -0.362213>, 
      <1.996500, 0.491221, -0.071870>, <1.933379, 0.458240, -0.188995>, <1.744788, 0.441568, -0.324838>, <1.709018, 0.483500, -0.326248>, 
      <1.968900, 0.535071, -0.057612>, <1.905779, 0.502090, -0.174737>, <1.751137, 0.448287, -0.300870>, <1.715367, 0.490218, -0.302280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.998489, 0.358407, -0.058653>, <2.007528, 0.411284, -0.055477>, <1.996500, 0.491221, -0.071870>, <1.968900, 0.535071, -0.057612>, 
      <2.053148, 0.366404, 0.038358>, <2.062186, 0.419281, 0.041534>, <2.053897, 0.521212, 0.034635>, <2.026297, 0.565061, 0.048893>, 
      <2.075549, 0.440717, 0.187830>, <2.084291, 0.483641, 0.194297>, <2.059952, 0.563526, 0.147453>, <2.025573, 0.587757, 0.133608>, 
      <2.065521, 0.510795, 0.274150>, <2.074263, 0.553719, 0.280617>, <2.043992, 0.619732, 0.257559>, <2.009613, 0.643963, 0.243714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.001895, 0.202433, 0.576458>, <2.006217, 0.391441, 0.569549>, <2.054276, 0.690200, 0.564499>, <1.931526, 0.826349, 0.517743>, 
      <2.035937, 0.212436, 0.772591>, <2.040260, 0.401443, 0.765682>, <1.995176, 0.726128, 0.783163>, <1.872426, 0.862277, 0.736407>, 
      <2.085934, 0.211149, 1.035122>, <2.043435, 0.450470, 1.035122>, <1.899740, 0.728617, 1.010462>, <1.726722, 0.899338, 1.010462>, 
      <2.095042, 0.210958, 1.234230>, <2.052543, 0.450279, 1.234230>, <1.849794, 0.734143, 1.234230>, <1.676776, 0.904864, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.902613, -0.437943, 0.563958>, <1.989559, -0.264021, 0.563958>, <1.997452, 0.008169, 0.583559>, <2.001895, 0.202433, 0.576458>, 
      <1.958799, -0.553463, 0.764548>, <2.045745, -0.379541, 0.764548>, <2.031495, 0.018172, 0.779692>, <2.035937, 0.212436, 0.772591>, 
      <1.979074, -0.783501, 1.007138>, <2.128657, -0.499192, 1.007138>, <2.142105, -0.105161, 1.035122>, <2.085934, 0.211149, 1.035122>, 
      <1.989234, -0.854662, 1.234230>, <2.138816, -0.570353, 1.234230>, <2.151212, -0.105351, 1.234230>, <2.095042, 0.210958, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.326548, -1.148489, 0.576458>, <1.342819, -1.156895, 0.773498>, <1.366976, -1.166988, 1.036767>, <1.375309, -1.157029, 1.234230>, 
      <1.156986, -1.255096, 0.578167>, <1.173258, -1.263502, 0.775208>, <1.160136, -1.225615, 1.036767>, <1.168469, -1.215656, 1.234230>, 
      <0.861724, -1.197117, 0.576458>, <0.861724, -1.207361, 0.773563>, <0.865988, -1.223408, 1.037671>, <0.876352, -1.208833, 1.234230>, 
      <0.662480, -1.217638, 0.576458>, <0.662480, -1.227882, 0.773563>, <0.652116, -1.245291, 1.037671>, <0.662480, -1.230717, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.326548, -1.148489, 0.576458>, <1.558878, -1.002419, 0.574116>, <1.779895, -0.683421, 0.563958>, <1.902613, -0.437943, 0.563958>, 
      <1.342819, -1.156895, 0.773498>, <1.575150, -1.010824, 0.771157>, <1.836081, -0.798941, 0.764548>, <1.958799, -0.553463, 0.764548>, 
      <1.366976, -1.166988, 1.036767>, <1.564499, -1.111002, 1.036767>, <1.883482, -0.965193, 1.007138>, <1.979074, -0.783501, 1.007138>, 
      <1.375309, -1.157029, 1.234230>, <1.572832, -1.101043, 1.234230>, <1.893641, -1.036353, 1.234230>, <1.989234, -0.854662, 1.234230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.399434, 0.835706, 0.137980>, <1.404122, 0.849962, 0.200057>, <1.416220, 0.850123, 0.287977>, <1.403949, 0.865645, 0.348699>, 
      <1.496061, 0.843643, 0.146366>, <1.500749, 0.857900, 0.208442>, <1.580929, 0.832832, 0.306228>, <1.568658, 0.848354, 0.366950>, 
      <1.601167, 0.943421, 0.190269>, <1.653561, 0.939183, 0.302369>, <1.753358, 0.982347, 0.381072>, <1.823418, 0.946257, 0.476564>, 
      <1.697995, 0.946646, 0.199435>, <1.750389, 0.942409, 0.311535>, <1.861467, 0.862438, 0.422251>, <1.931526, 0.826349, 0.517743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.399434, 0.835706, 0.137980>, <1.179611, 0.817648, 0.118903>, <0.883572, 0.853895, 0.118008>, <0.662480, 0.861582, 0.109568>, 
      <1.404122, 0.849962, 0.200057>, <1.184300, 0.831905, 0.180979>, <0.883572, 0.884890, 0.197670>, <0.662480, 0.892577, 0.189230>, 
      <1.416220, 0.850123, 0.287977>, <1.194409, 0.873408, 0.263398>, <0.884958, 0.901711, 0.288616>, <0.662480, 0.929617, 0.297060>, 
      <1.403949, 0.865645, 0.348699>, <1.182138, 0.888930, 0.324120>, <0.884958, 0.931663, 0.368676>, <0.662480, 0.959570, 0.377120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.910379, 0.156699, 0.170303>, <1.963444, 0.263417, 0.185026>, <2.041813, 0.394383, 0.256611>, <2.065521, 0.510795, 0.274150>, 
      <1.932581, 0.193447, 0.288393>, <1.985646, 0.300165, 0.303115>, <2.030480, 0.473583, 0.354167>, <2.054188, 0.589994, 0.371705>, 
      <1.980434, 0.196127, 0.452812>, <1.984756, 0.385135, 0.445903>, <2.094475, 0.595534, 0.491421>, <1.971725, 0.731683, 0.444665>, 
      <2.001895, 0.202433, 0.576458>, <2.006217, 0.391441, 0.569549>, <2.054276, 0.690200, 0.564499>, <1.931526, 0.826349, 0.517743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.691224, -0.241947, 0.170303>, <1.751387, -0.119449, 0.170303>, <1.850074, 0.035420, 0.153572>, <1.910379, 0.156699, 0.170303>, 
      <1.746188, -0.273275, 0.302301>, <1.806351, -0.150777, 0.302301>, <1.872276, 0.072168, 0.271662>, <1.932581, 0.193447, 0.288393>, 
      <1.868086, -0.366955, 0.440693>, <1.955032, -0.193033, 0.440693>, <1.975991, 0.001864, 0.459913>, <1.980434, 0.196127, 0.452812>, 
      <1.902613, -0.437943, 0.563958>, <1.989559, -0.264021, 0.563958>, <1.997452, 0.008169, 0.583559>, <2.001895, 0.202433, 0.576458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.287451, -1.111641, 0.170303>, <1.500479, -0.918341, 0.170303>, <1.564414, -0.500143, 0.170303>, <1.691224, -0.241947, 0.170303>, 
      <1.299956, -1.123443, 0.292002>, <1.512984, -0.930143, 0.292002>, <1.619378, -0.531471, 0.302301>, <1.746188, -0.273275, 0.302301>, 
      <1.316442, -1.143268, 0.454078>, <1.548772, -0.997198, 0.451736>, <1.745368, -0.612433, 0.440693>, <1.868086, -0.366955, 0.440693>, 
      <1.326548, -1.148489, 0.576458>, <1.558878, -1.002419, 0.574116>, <1.779895, -0.683421, 0.563958>, <1.902613, -0.437943, 0.563958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.287451, -1.111641, 0.170303>, <1.299956, -1.123443, 0.292002>, <1.316442, -1.143268, 0.454078>, <1.326548, -1.148489, 0.576458>, 
      <1.147880, -1.238287, 0.170303>, <1.160385, -1.250089, 0.292002>, <1.146880, -1.249875, 0.455787>, <1.156986, -1.255096, 0.578167>, 
      <0.849994, -1.156507, 0.170303>, <0.849994, -1.163480, 0.292607>, <0.861724, -1.190759, 0.454120>, <0.861724, -1.197117, 0.576458>, 
      <0.662480, -1.175422, 0.170303>, <0.662480, -1.182395, 0.292607>, <0.662480, -1.211280, 0.454120>, <0.662480, -1.217638, 0.576458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.365524, 0.748802, -0.160072>, <1.156323, 0.727715, -0.176670>, <0.873393, 0.749329, -0.161895>, <0.662480, 0.749551, -0.162665>, 
      <1.378173, 0.788662, -0.076230>, <1.168972, 0.767575, -0.092827>, <0.873226, 0.784648, -0.080950>, <0.662313, 0.784871, -0.081720>, 
      <1.392556, 0.814791, 0.046911>, <1.172733, 0.796734, 0.027833>, <0.883572, 0.821872, 0.035703>, <0.662480, 0.829559, 0.027263>, 
      <1.399434, 0.835706, 0.137980>, <1.179611, 0.817648, 0.118903>, <0.883572, 0.853895, 0.118008>, <0.662480, 0.861582, 0.109568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.365524, 0.748802, -0.160072>, <1.378173, 0.788662, -0.076230>, <1.392556, 0.814791, 0.046911>, <1.399434, 0.835706, 0.137980>, 
      <1.458106, 0.758134, -0.152727>, <1.470755, 0.797994, -0.068884>, <1.489183, 0.822729, 0.055296>, <1.496061, 0.843643, 0.146366>, 
      <1.559076, 0.849754, -0.104807>, <1.559142, 0.908641, -0.035234>, <1.562595, 0.946540, 0.107742>, <1.601167, 0.943421, 0.190269>, 
      <1.650135, 0.849106, -0.084306>, <1.650201, 0.907994, -0.014733>, <1.659423, 0.949765, 0.116908>, <1.697995, 0.946646, 0.199435>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.876584, -0.004976, -0.090052>, <1.850192, -0.088707, -0.225725>, <1.851158, -0.215465, -0.415797>, <1.772169, -0.281790, -0.540201>, 
      <1.933989, 0.094980, -0.085157>, <1.907598, 0.011249, -0.220830>, <1.870408, 0.007979, -0.375107>, <1.791419, -0.058347, -0.499511>, 
      <1.979083, 0.244884, -0.065472>, <1.912899, 0.235201, -0.182941>, <1.889284, 0.227504, -0.324146>, <1.798973, 0.257065, -0.420287>, 
      <1.998489, 0.358407, -0.058653>, <1.932304, 0.348724, -0.176121>, <1.787762, 0.427384, -0.282981>, <1.697451, 0.456945, -0.379121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.876584, -0.004976, -0.090052>, <1.933989, 0.094980, -0.085157>, <1.979083, 0.244884, -0.065472>, <1.998489, 0.358407, -0.058653>, 
      <1.891690, 0.042951, -0.012394>, <1.949096, 0.142906, -0.007499>, <2.033742, 0.252881, 0.031539>, <2.053148, 0.366404, 0.038358>, 
      <1.894035, 0.129647, 0.083372>, <1.947100, 0.236365, 0.098095>, <2.051841, 0.324305, 0.170292>, <2.075549, 0.440717, 0.187830>, 
      <1.910379, 0.156699, 0.170303>, <1.963444, 0.263417, 0.185026>, <2.041813, 0.394383, 0.256611>, <2.065521, 0.510795, 0.274150>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.630284, -0.282722, -0.090052>, <1.604967, -0.429838, -0.275317>, <1.597268, -0.693915, -0.461570>, <1.583118, -0.870141, -0.620792>, 
      <1.685674, -0.186107, -0.090052>, <1.660357, -0.333222, -0.275317>, <1.697633, -0.542500, -0.505790>, <1.683484, -0.718726, -0.665011>, 
      <1.821171, -0.101463, -0.094777>, <1.794779, -0.185194, -0.230451>, <1.835368, -0.398746, -0.449174>, <1.756379, -0.465071, -0.573578>, 
      <1.876584, -0.004976, -0.090052>, <1.850192, -0.088707, -0.225725>, <1.851158, -0.215465, -0.415797>, <1.772169, -0.281790, -0.540201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.630284, -0.282722, -0.090052>, <1.685674, -0.186107, -0.090052>, <1.821171, -0.101463, -0.094777>, <1.876584, -0.004976, -0.090052>, 
      <1.638918, -0.232547, -0.026866>, <1.694308, -0.135932, -0.026866>, <1.836277, -0.053536, -0.017120>, <1.891690, 0.042951, -0.012394>, 
      <1.660754, -0.224580, 0.097129>, <1.720917, -0.102082, 0.097129>, <1.833730, 0.008368, 0.066641>, <1.894035, 0.129647, 0.083372>, 
      <1.691224, -0.241947, 0.170303>, <1.751387, -0.119449, 0.170303>, <1.850074, 0.035420, 0.153572>, <1.910379, 0.156699, 0.170303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.258062, -1.083852, -0.090052>, <1.246212, -1.088153, -0.153267>, <1.178643, -1.126771, -0.230612>, <1.201404, -1.142869, -0.288731>, 
      <1.452072, -0.903541, -0.099019>, <1.440222, -0.907842, -0.162234>, <1.316145, -1.061071, -0.311286>, <1.338906, -1.077169, -0.369404>, 
      <1.498476, -0.512633, -0.090052>, <1.473159, -0.659749, -0.275317>, <1.504705, -0.833560, -0.420788>, <1.490555, -1.009785, -0.580010>, 
      <1.630284, -0.282722, -0.090052>, <1.604967, -0.429838, -0.275317>, <1.597268, -0.693915, -0.461570>, <1.583118, -0.870141, -0.620792>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.258062, -1.083852, -0.090052>, <1.452072, -0.903541, -0.099019>, <1.498476, -0.512633, -0.090052>, <1.630284, -0.282722, -0.090052>, 
      <1.272593, -1.078579, -0.012535>, <1.466603, -0.898268, -0.021502>, <1.507110, -0.462458, -0.026866>, <1.638918, -0.232547, -0.026866>, 
      <1.279409, -1.104051, 0.092037>, <1.492437, -0.910751, 0.092037>, <1.533945, -0.482776, 0.097129>, <1.660754, -0.224580, 0.097129>, 
      <1.287451, -1.111641, 0.170303>, <1.500479, -0.918341, 0.170303>, <1.564414, -0.500143, 0.170303>, <1.691224, -0.241947, 0.170303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.258062, -1.083852, -0.090052>, <1.272593, -1.078579, -0.012535>, <1.279409, -1.104051, 0.092037>, <1.287451, -1.111641, 0.170303>, 
      <1.125124, -1.207403, -0.083907>, <1.139655, -1.202130, -0.006390>, <1.139838, -1.230697, 0.092037>, <1.147880, -1.238287, 0.170303>, 
      <0.841223, -1.153035, -0.058581>, <0.841223, -1.122443, -0.001549>, <0.849994, -1.152823, 0.105690>, <0.849994, -1.156507, 0.170303>, 
      <0.662480, -1.182189, -0.045319>, <0.662480, -1.151597, 0.011713>, <0.662480, -1.171738, 0.105690>, <0.662480, -1.175422, 0.170303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.258062, -1.083852, -0.090052>, <1.125124, -1.207403, -0.083907>, <0.841223, -1.153035, -0.058581>, <0.662480, -1.182189, -0.045319>, 
      <1.246212, -1.088153, -0.153267>, <1.113275, -1.211703, -0.147122>, <0.841223, -1.171844, -0.093646>, <0.662480, -1.200997, -0.080384>, 
      <1.178643, -1.126771, -0.230612>, <1.034768, -1.195516, -0.146200>, <0.813422, -1.177476, -0.109311>, <0.664675, -1.271738, -0.070066>, 
      <1.201404, -1.142869, -0.288731>, <1.057529, -1.211614, -0.204319>, <0.811228, -1.215770, -0.119894>, <0.662480, -1.310032, -0.080649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.324505, 0.599587, -0.358680>, <1.442155, 0.576445, -0.361808>, <1.644027, 0.562128, -0.357459>, <1.697451, 0.456945, -0.379121>, 
      <1.269484, 0.491471, -0.528944>, <1.387134, 0.468329, -0.532072>, <1.551506, 0.424690, -0.502292>, <1.604930, 0.319507, -0.523955>, 
      <1.186711, 0.357292, -0.759336>, <1.277268, 0.283687, -0.755127>, <1.395063, 0.175194, -0.695908>, <1.455205, 0.082689, -0.657676>, 
      <1.116597, 0.259659, -0.930385>, <1.207153, 0.186053, -0.926176>, <1.313974, 0.075801, -0.874714>, <1.374116, -0.016704, -0.836482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.324505, 0.599587, -0.358680>, <1.269484, 0.491471, -0.528944>, <1.186711, 0.357292, -0.759336>, <1.116597, 0.259659, -0.930385>, 
      <1.129148, 0.638015, -0.353486>, <1.074127, 0.529899, -0.523750>, <1.032255, 0.482837, -0.766515>, <0.962141, 0.385204, -0.937564>, 
      <0.861778, 0.642364, -0.353715>, <0.841947, 0.617290, -0.509672>, <0.728121, 0.527512, -0.740217>, <0.711237, 0.494339, -0.895003>, 
      <0.663434, 0.660341, -0.351629>, <0.643603, 0.635267, -0.507585>, <0.588942, 0.668395, -0.718976>, <0.572058, 0.635222, -0.873763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.324505, 0.599587, -0.358680>, <1.129148, 0.638015, -0.353486>, <0.861778, 0.642364, -0.353715>, <0.663434, 0.660341, -0.351629>, 
      <1.344384, 0.638650, -0.297163>, <1.149027, 0.677077, -0.291969>, <0.869587, 0.652238, -0.292303>, <0.671243, 0.670215, -0.290216>, 
      <1.355327, 0.716668, -0.227664>, <1.146126, 0.695580, -0.244262>, <0.873512, 0.724257, -0.219353>, <0.662599, 0.724480, -0.220123>, 
      <1.365524, 0.748802, -0.160072>, <1.156323, 0.727715, -0.176670>, <0.873393, 0.749329, -0.161895>, <0.662480, 0.749551, -0.162665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.324505, 0.599587, -0.358680>, <1.344384, 0.638650, -0.297163>, <1.355327, 0.716668, -0.227664>, <1.365524, 0.748802, -0.160072>, 
      <1.442155, 0.576445, -0.361808>, <1.462034, 0.615507, -0.300291>, <1.447908, 0.726000, -0.220319>, <1.458106, 0.758134, -0.152727>, 
      <1.644027, 0.562128, -0.357459>, <1.629832, 0.679776, -0.269014>, <1.558970, 0.754222, -0.217673>, <1.559076, 0.849754, -0.104807>, 
      <1.697451, 0.456945, -0.379121>, <1.683256, 0.574593, -0.290677>, <1.650029, 0.753574, -0.197172>, <1.650135, 0.849106, -0.084306>
    }
  }
  texture {
    HeadQuilt
  }
}
#declare InJaw = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.383769, -1.364696, -2.156188>, <0.546797, -1.342299, -2.168630>, <0.770837, -1.342299, -2.168630>, <0.933864, -1.364696, -2.156188>, 
      <0.388713, -1.314766, -2.087926>, <0.551741, -1.292368, -2.100368>, <0.765892, -1.292368, -2.100368>, <0.928920, -1.314766, -2.087926>, 
      <0.411449, -1.276610, -1.980890>, <0.557754, -1.266816, -1.989872>, <0.759879, -1.266816, -1.989872>, <0.906184, -1.276610, -1.980890>, 
      <0.413971, -1.234439, -1.907457>, <0.560276, -1.224645, -1.916439>, <0.757357, -1.224645, -1.916439>, <0.903662, -1.234439, -1.907457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.938350, -1.584745, -2.386375>, <0.937703, -1.517728, -2.318281>, <0.939440, -1.421006, -2.233172>, <0.933864, -1.364696, -2.156188>, 
      <0.771223, -1.572477, -2.393311>, <0.770576, -1.505460, -2.325217>, <0.776413, -1.398609, -2.245615>, <0.770837, -1.342299, -2.168630>, 
      <0.546410, -1.572477, -2.393311>, <0.547057, -1.505460, -2.325217>, <0.541220, -1.398609, -2.245615>, <0.546797, -1.342299, -2.168630>, 
      <0.379283, -1.584745, -2.386375>, <0.379930, -1.517728, -2.318281>, <0.378193, -1.421006, -2.233172>, <0.383769, -1.364696, -2.156188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.938350, -1.584745, -2.386375>, <0.771223, -1.572477, -2.393311>, <0.546410, -1.572477, -2.393311>, <0.379283, -1.584745, -2.386375>, 
      <0.939049, -1.657077, -2.459870>, <0.771922, -1.644808, -2.466806>, <0.545711, -1.644808, -2.466806>, <0.378584, -1.657077, -2.459870>, 
      <0.918404, -1.760297, -2.553949>, <0.752073, -1.771795, -2.572162>, <0.559107, -1.771397, -2.571085>, <0.392776, -1.759899, -2.552872>, 
      <0.938350, -1.829134, -2.628094>, <0.772019, -1.840632, -2.646307>, <0.545614, -1.840632, -2.646307>, <0.379283, -1.829134, -2.628094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.326600, -1.855070, -2.680077>, <0.281159, -1.860055, -2.685832>, <0.268977, -1.915404, -2.747878>, <0.244281, -1.941261, -2.776936>, 
      <0.530899, -1.832657, -2.654203>, <0.485458, -1.837642, -2.659958>, <0.502697, -1.952642, -2.804677>, <0.478002, -1.978499, -2.833734>, 
      <0.813847, -1.832443, -2.647037>, <0.857579, -1.837615, -2.653928>, <0.809119, -1.952658, -2.812731>, <0.820606, -1.978092, -2.847486>, 
      <1.017087, -1.856480, -2.679062>, <1.060819, -1.861652, -2.685953>, <1.043890, -1.915827, -2.760156>, <1.055377, -1.941261, -2.794911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.326600, -1.855070, -2.680077>, <0.530899, -1.832657, -2.654203>, <0.813847, -1.832443, -2.647037>, <1.017087, -1.856480, -2.679062>, 
      <0.342405, -1.847289, -2.664482>, <0.546704, -1.824877, -2.638608>, <0.790226, -1.824239, -2.631747>, <0.993466, -1.848276, -2.663771>, 
      <0.376205, -1.844930, -2.645256>, <0.542536, -1.856428, -2.663469>, <0.777688, -1.860197, -2.667381>, <0.944019, -1.848699, -2.649168>, 
      <0.379283, -1.829134, -2.628094>, <0.545614, -1.840632, -2.646307>, <0.772019, -1.840632, -2.646307>, <0.938350, -1.829134, -2.628094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -1.757493, -2.514615>, <-0.020317, -1.821154, -2.613038>, <0.109234, -1.919744, -2.744117>, <0.244281, -1.941261, -2.776936>, 
      <-0.245533, -1.767690, -2.530767>, <-0.167828, -1.831351, -2.629190>, <0.133929, -1.893887, -2.715060>, <0.268977, -1.915404, -2.747878>, 
      <0.231771, -1.818937, -2.611942>, <0.228693, -1.834733, -2.629104>, <0.296964, -1.852274, -2.670237>, <0.281159, -1.860055, -2.685832>, 
      <0.379283, -1.829134, -2.628094>, <0.376205, -1.844930, -2.645256>, <0.342405, -1.847289, -2.664482>, <0.326600, -1.855070, -2.680077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -1.660823, -2.343364>, <-0.098021, -1.690200, -2.394525>, <-0.130618, -1.730787, -2.473327>, <-0.098021, -1.757493, -2.514615>, 
      <-0.243078, -1.650175, -2.349384>, <-0.243078, -1.679552, -2.400545>, <-0.278130, -1.740984, -2.489479>, <-0.245533, -1.767690, -2.530767>, 
      <0.234226, -1.595393, -2.380355>, <0.233528, -1.667725, -2.453850>, <0.245264, -1.749702, -2.536720>, <0.231771, -1.818937, -2.611942>, 
      <0.379283, -1.584745, -2.386375>, <0.378584, -1.657077, -2.459870>, <0.392776, -1.759899, -2.552872>, <0.379283, -1.829134, -2.628094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -1.506461, -2.077434>, <-0.098021, -1.560479, -2.152209>, <-0.098021, -1.614889, -2.263369>, <-0.098021, -1.660823, -2.343364>, 
      <-0.248677, -1.485763, -2.088932>, <-0.248677, -1.539781, -2.163707>, <-0.243078, -1.604241, -2.269389>, <-0.243078, -1.650175, -2.349384>, 
      <0.233113, -1.385394, -2.144690>, <0.227537, -1.441704, -2.221674>, <0.234874, -1.528377, -2.312261>, <0.234226, -1.595393, -2.380355>, 
      <0.383769, -1.364696, -2.156188>, <0.378193, -1.421006, -2.233172>, <0.379930, -1.517728, -2.318281>, <0.379283, -1.584745, -2.386375>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -1.301492, -1.845961>, <-0.098021, -1.357467, -1.919921>, <-0.098021, -1.452145, -2.002247>, <-0.098021, -1.506461, -2.077434>, 
      <-0.253385, -1.291092, -1.855499>, <-0.253385, -1.347067, -1.929459>, <-0.248677, -1.431447, -2.013746>, <-0.248677, -1.485763, -2.088932>, 
      <0.258607, -1.244839, -1.897919>, <0.256085, -1.287010, -1.971352>, <0.238057, -1.335463, -2.076428>, <0.233113, -1.385394, -2.144690>, 
      <0.413971, -1.234439, -1.907457>, <0.411449, -1.276610, -1.980890>, <0.388713, -1.314766, -2.087926>, <0.383769, -1.364696, -2.156188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.404373, -1.020184, -1.556284>, <0.210480, -1.036993, -1.531654>, <-0.250068, -1.057190, -1.502060>, <-0.098021, -1.063739, -1.492465>, 
      <0.400516, -1.089279, -1.658508>, <0.206623, -1.106089, -1.633878>, <-0.250068, -1.127979, -1.608469>, <-0.098021, -1.134527, -1.598873>, 
      <0.417646, -1.172990, -1.800455>, <0.262282, -1.183391, -1.790917>, <-0.253385, -1.213965, -1.753592>, <-0.098021, -1.224365, -1.744053>, 
      <0.413971, -1.234439, -1.907457>, <0.258607, -1.244839, -1.897919>, <-0.253385, -1.291092, -1.855499>, <-0.098021, -1.301492, -1.845961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -0.877983, -1.209347>, <-0.090470, -0.931592, -1.295304>, <-0.098021, -1.007473, -1.407886>, <-0.098021, -1.063739, -1.492465>, 
      <-0.261311, -0.872882, -1.230248>, <-0.253760, -0.926491, -1.316205>, <-0.250068, -1.000924, -1.417481>, <-0.250068, -1.057190, -1.502060>, 
      <0.229643, -0.859182, -1.286382>, <0.235059, -0.906267, -1.356697>, <0.213130, -0.989530, -1.461434>, <0.210480, -1.036993, -1.531654>, 
      <0.435579, -0.847366, -1.334798>, <0.440996, -0.894451, -1.405114>, <0.407023, -0.972721, -1.486064>, <0.404373, -1.020184, -1.556284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098021, -0.877983, -1.209347>, <-0.261311, -0.872882, -1.230248>, <0.229643, -0.859182, -1.286382>, <0.435579, -0.847366, -1.334798>, 
      <-0.103221, -0.841062, -1.150148>, <-0.266511, -0.835961, -1.171049>, <0.223627, -0.806891, -1.208291>, <0.429563, -0.795074, -1.256707>, 
      <-0.127643, -0.797706, -1.070324>, <-0.281689, -0.787955, -1.078623>, <0.235323, -0.760894, -1.131470>, <0.387487, -0.740174, -1.149103>, 
      <-0.140338, -0.763302, -1.010743>, <-0.294384, -0.753551, -1.019041>, <0.214712, -0.714955, -1.051887>, <0.366876, -0.694234, -1.069520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.757494, -2.514616>, <1.563166, -1.767691, -2.530768>, <1.085862, -1.818937, -2.611942>, <0.938350, -1.829134, -2.628094>, 
      <1.332829, -1.821964, -2.618423>, <1.480341, -1.832161, -2.634575>, <1.091531, -1.838502, -2.633016>, <0.944019, -1.848699, -2.649168>, 
      <1.197772, -1.918922, -2.763023>, <1.186285, -1.893488, -2.728268>, <1.037198, -1.853448, -2.670662>, <0.993466, -1.848276, -2.663771>, 
      <1.055377, -1.941261, -2.794911>, <1.043890, -1.915827, -2.760156>, <1.060819, -1.861652, -2.685953>, <1.017087, -1.856480, -2.679062>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.757494, -2.514616>, <1.332829, -1.821964, -2.618423>, <1.197772, -1.918922, -2.763023>, <1.055377, -1.941261, -2.794911>, 
      <0.965311, -1.726363, -2.465305>, <0.882487, -1.790834, -2.569112>, <0.963001, -1.955753, -2.815598>, <0.820606, -1.978092, -2.847486>, 
      <0.352322, -1.726363, -2.465305>, <0.430026, -1.790024, -2.563728>, <0.342954, -1.956982, -2.800915>, <0.478002, -1.978499, -2.833734>, 
      <-0.098021, -1.757493, -2.514615>, <-0.020317, -1.821154, -2.613038>, <0.109234, -1.919744, -2.744117>, <0.244281, -1.941261, -2.776936>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.660823, -2.343364>, <1.560711, -1.650175, -2.349384>, <1.083407, -1.595393, -2.380355>, <0.938350, -1.584745, -2.386375>, 
      <1.415654, -1.690200, -2.394526>, <1.560711, -1.679552, -2.400546>, <1.084105, -1.667725, -2.453850>, <0.939049, -1.657077, -2.459870>, 
      <1.448754, -1.731729, -2.473130>, <1.596266, -1.741926, -2.489283>, <1.065916, -1.750100, -2.537797>, <0.918404, -1.760297, -2.553949>, 
      <1.415654, -1.757494, -2.514616>, <1.563166, -1.767691, -2.530768>, <1.085862, -1.818937, -2.611942>, <0.938350, -1.829134, -2.628094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.660823, -2.343364>, <1.415654, -1.690200, -2.394526>, <1.448754, -1.731729, -2.473130>, <1.415654, -1.757494, -2.514616>, 
      <0.963158, -1.694040, -2.324585>, <0.963158, -1.723417, -2.375746>, <0.998412, -1.700598, -2.423820>, <0.965311, -1.726363, -2.465305>, 
      <0.354476, -1.694040, -2.324585>, <0.354476, -1.723417, -2.375746>, <0.319725, -1.699657, -2.424016>, <0.352322, -1.726363, -2.465305>, 
      <-0.098021, -1.660823, -2.343364>, <-0.098021, -1.690200, -2.394525>, <-0.130618, -1.730787, -2.473327>, <-0.098021, -1.757493, -2.514615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.950757, -0.694234, -1.069520>, <1.102921, -0.714955, -1.051887>, <1.612017, -0.753551, -1.019041>, <1.457971, -0.763302, -1.010743>, 
      <0.775593, -0.694234, -1.069520>, <0.927757, -0.714955, -1.051887>, <1.134172, -0.783799, -0.993300>, <0.980126, -0.793550, -0.985002>, 
      <0.542040, -0.694234, -1.069520>, <0.389876, -0.714955, -1.051887>, <0.183461, -0.783799, -0.993300>, <0.337507, -0.793550, -0.985002>, 
      <0.366876, -0.694234, -1.069520>, <0.214712, -0.714955, -1.051887>, <-0.294384, -0.753551, -1.019041>, <-0.140338, -0.763302, -1.010743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.506461, -2.077434>, <1.415654, -1.560479, -2.152209>, <1.415654, -1.614889, -2.263369>, <1.415654, -1.660823, -2.343364>, 
      <0.967058, -1.568091, -2.043197>, <0.967058, -1.622109, -2.117971>, <0.963158, -1.648106, -2.244589>, <0.963158, -1.694040, -2.324585>, 
      <0.350575, -1.568091, -2.043197>, <0.350575, -1.622109, -2.117971>, <0.354476, -1.648106, -2.244589>, <0.354476, -1.694040, -2.324585>, 
      <-0.098021, -1.506461, -2.077434>, <-0.098021, -1.560479, -2.152209>, <-0.098021, -1.614889, -2.263369>, <-0.098021, -1.660823, -2.343364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.506461, -2.077434>, <1.566310, -1.485763, -2.088932>, <1.084520, -1.385394, -2.144690>, <0.933864, -1.364696, -2.156188>, 
      <1.415654, -1.560479, -2.152209>, <1.566310, -1.539781, -2.163707>, <1.090096, -1.441704, -2.221674>, <0.939440, -1.421006, -2.233172>, 
      <1.415654, -1.614889, -2.263369>, <1.560711, -1.604241, -2.269389>, <1.082760, -1.528377, -2.312261>, <0.937703, -1.517728, -2.318281>, 
      <1.415654, -1.660823, -2.343364>, <1.560711, -1.650175, -2.349384>, <1.083407, -1.595393, -2.380355>, <0.938350, -1.584745, -2.386375>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.301492, -1.845961>, <1.415654, -1.357467, -1.919921>, <1.415654, -1.452145, -2.002247>, <1.415654, -1.506461, -2.077434>, 
      <0.963413, -1.331765, -1.818197>, <0.963413, -1.387740, -1.892157>, <0.967058, -1.513775, -1.968010>, <0.967058, -1.568091, -2.043197>, 
      <0.354220, -1.331765, -1.818197>, <0.354220, -1.387740, -1.892157>, <0.350575, -1.513775, -1.968010>, <0.350575, -1.568091, -2.043197>, 
      <-0.098021, -1.301492, -1.845961>, <-0.098021, -1.357467, -1.919921>, <-0.098021, -1.452145, -2.002247>, <-0.098021, -1.506461, -2.077434>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.301492, -1.845961>, <1.571018, -1.291092, -1.855499>, <1.059026, -1.244839, -1.897919>, <0.903662, -1.234439, -1.907457>, 
      <1.415654, -1.357467, -1.919921>, <1.571018, -1.347067, -1.929459>, <1.061549, -1.287010, -1.971352>, <0.906184, -1.276610, -1.980890>, 
      <1.415654, -1.452145, -2.002247>, <1.566310, -1.431447, -2.013746>, <1.079576, -1.335463, -2.076428>, <0.928920, -1.314766, -2.087926>, 
      <1.415654, -1.506461, -2.077434>, <1.566310, -1.485763, -2.088932>, <1.084520, -1.385394, -2.144690>, <0.933864, -1.364696, -2.156188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -1.063739, -1.492465>, <1.415654, -1.134527, -1.598873>, <1.415654, -1.224365, -1.744053>, <1.415654, -1.301492, -1.845961>, 
      <0.962871, -1.083240, -1.463891>, <0.962871, -1.154028, -1.570300>, <0.963413, -1.254638, -1.716289>, <0.963413, -1.331765, -1.818197>, 
      <0.354762, -1.083240, -1.463891>, <0.354762, -1.154028, -1.570300>, <0.354220, -1.254638, -1.716289>, <0.354220, -1.331765, -1.818197>, 
      <-0.098021, -1.063739, -1.492465>, <-0.098021, -1.134527, -1.598873>, <-0.098021, -1.224365, -1.744053>, <-0.098021, -1.301492, -1.845961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.913260, -1.020184, -1.556284>, <0.917117, -1.089279, -1.658508>, <0.899987, -1.172990, -1.800455>, <0.903662, -1.234439, -1.907457>, 
      <1.107153, -1.036993, -1.531654>, <1.111010, -1.106089, -1.633878>, <1.055351, -1.183391, -1.790917>, <1.059026, -1.244839, -1.897919>, 
      <1.567701, -1.057190, -1.502060>, <1.567701, -1.127979, -1.608469>, <1.571018, -1.213965, -1.753592>, <1.571018, -1.291092, -1.855499>, 
      <1.415654, -1.063739, -1.492465>, <1.415654, -1.134527, -1.598873>, <1.415654, -1.224365, -1.744053>, <1.415654, -1.301492, -1.845961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -0.877983, -1.209347>, <1.408103, -0.931592, -1.295304>, <1.415654, -1.007473, -1.407886>, <1.415654, -1.063739, -1.492465>, 
      <0.965442, -0.892047, -1.151719>, <0.957892, -0.945656, -1.237676>, <0.962871, -1.026974, -1.379312>, <0.962871, -1.083240, -1.463891>, 
      <0.352190, -0.892047, -1.151719>, <0.359741, -0.945656, -1.237676>, <0.354762, -1.026974, -1.379312>, <0.354762, -1.083240, -1.463891>, 
      <-0.098021, -0.877983, -1.209347>, <-0.090470, -0.931592, -1.295304>, <-0.098021, -1.007473, -1.407886>, <-0.098021, -1.063739, -1.492465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -0.877983, -1.209347>, <0.965442, -0.892047, -1.151719>, <0.352190, -0.892047, -1.151719>, <-0.098021, -0.877983, -1.209347>, 
      <1.420854, -0.841062, -1.150148>, <0.970643, -0.855126, -1.092520>, <0.346990, -0.855126, -1.092520>, <-0.103221, -0.841062, -1.150148>, 
      <1.445276, -0.797706, -1.070324>, <0.967431, -0.827955, -1.044583>, <0.350202, -0.827955, -1.044583>, <-0.127643, -0.797706, -1.070324>, 
      <1.457971, -0.763302, -1.010743>, <0.980126, -0.793550, -0.985002>, <0.337507, -0.793550, -0.985002>, <-0.140338, -0.763302, -1.010743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -0.877983, -1.209347>, <1.420854, -0.841062, -1.150148>, <1.445276, -0.797706, -1.070324>, <1.457971, -0.763302, -1.010743>, 
      <1.578944, -0.872882, -1.230248>, <1.584144, -0.835961, -1.171049>, <1.599322, -0.787955, -1.078623>, <1.612017, -0.753551, -1.019041>, 
      <1.087991, -0.859182, -1.286382>, <1.094006, -0.806891, -1.208291>, <1.082310, -0.760894, -1.131470>, <1.102921, -0.714955, -1.051887>, 
      <0.882054, -0.847366, -1.334798>, <0.888070, -0.795074, -1.256707>, <0.930146, -0.740174, -1.149103>, <0.950757, -0.694234, -1.069520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415654, -0.877983, -1.209347>, <1.578944, -0.872882, -1.230248>, <1.087991, -0.859182, -1.286382>, <0.882054, -0.847366, -1.334798>, 
      <1.408103, -0.931592, -1.295304>, <1.571393, -0.926491, -1.316205>, <1.082574, -0.906267, -1.356697>, <0.876637, -0.894451, -1.405114>, 
      <1.415654, -1.007473, -1.407886>, <1.567701, -1.000924, -1.417481>, <1.104503, -0.989530, -1.461434>, <0.910610, -0.972721, -1.486064>, 
      <1.415654, -1.063739, -1.492465>, <1.567701, -1.057190, -1.502060>, <1.107153, -1.036993, -1.531654>, <0.913260, -1.020184, -1.556284>
    }
  }
  texture {
    Shiny_Red
  }
  rotate <30.0, -0.0, 0.0>
  translate  <-0.002158, -0.148829, 0.496314>
}
#declare JawBtm = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.402392, -1.390840, -2.116972>, <0.554117, -1.368483, -2.129392>, <0.763551, -1.368483, -2.129392>, <0.915275, -1.390840, -2.116972>, 
      <0.406999, -1.340936, -2.048746>, <0.558724, -1.318579, -2.061166>, <0.758943, -1.318579, -2.061166>, <0.910668, -1.340936, -2.048746>, 
      <0.428201, -1.302725, -1.941623>, <0.564525, -1.292937, -1.950600>, <0.753142, -1.292937, -1.950600>, <0.889466, -1.302725, -1.941623>, 
      <0.430551, -1.260583, -1.868241>, <0.566875, -1.250795, -1.877218>, <0.750792, -1.250795, -1.877218>, <0.887116, -1.260583, -1.868241>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.919457, -1.610889, -2.347159>, <0.918850, -1.542131, -2.280824>, <0.920475, -1.447162, -2.193972>, <0.915275, -1.390840, -2.116972>, 
      <0.763719, -1.598627, -2.354091>, <0.763111, -1.529869, -2.287757>, <0.768750, -1.424805, -2.206392>, <0.763551, -1.368483, -2.129392>, 
      <0.553948, -1.598627, -2.354091>, <0.554552, -1.531611, -2.285998>, <0.548917, -1.424805, -2.206392>, <0.554117, -1.368483, -2.129392>, 
      <0.398210, -1.610889, -2.347159>, <0.398813, -1.543873, -2.279065>, <0.397192, -1.447162, -2.193972>, <0.402392, -1.390840, -2.116972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.919457, -1.610889, -2.347159>, <0.763719, -1.598627, -2.354091>, <0.553948, -1.598627, -2.354091>, <0.398210, -1.610889, -2.347159>, 
      <0.920105, -1.684292, -2.417975>, <0.764367, -1.672030, -2.424907>, <0.553297, -1.670959, -2.427586>, <0.397559, -1.683221, -2.420654>, 
      <0.904270, -1.797503, -2.498242>, <0.749295, -1.808994, -2.516442>, <0.563775, -1.799220, -2.528764>, <0.408651, -1.786265, -2.512970>, 
      <0.919457, -1.864336, -2.573781>, <0.764481, -1.875826, -2.591981>, <0.553334, -1.868233, -2.604672>, <0.398210, -1.855278, -2.588878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.349091, -1.935562, -2.704268>, <0.316728, -1.934217, -2.707037>, <0.295365, -1.913468, -2.753047>, <0.272340, -1.903999, -2.773952>, 
      <0.541372, -1.943556, -2.687818>, <0.509009, -1.942210, -2.690587>, <0.513172, -1.939681, -2.811041>, <0.490146, -1.930212, -2.831946>, 
      <0.800511, -1.940324, -2.696042>, <0.819767, -1.939686, -2.697670>, <0.800201, -1.943313, -2.806407>, <0.810911, -1.937044, -2.821234>, 
      <0.992868, -1.933953, -2.712310>, <1.012124, -1.933315, -2.713939>, <1.017858, -1.919326, -2.746907>, <1.028568, -1.913057, -2.761734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.349091, -1.935562, -2.704268>, <0.541372, -1.943556, -2.687818>, <0.800511, -1.940324, -2.696042>, <0.992868, -1.933953, -2.712310>, 
      <0.363827, -1.911477, -2.669651>, <0.556108, -1.919470, -2.653201>, <0.778488, -1.919439, -2.654483>, <0.970845, -1.913068, -2.670751>, 
      <0.393687, -1.885175, -2.621761>, <0.548811, -1.898130, -2.637556>, <0.772144, -1.909546, -2.630094>, <0.927119, -1.898056, -2.611894>, 
      <0.398210, -1.855278, -2.588878>, <0.553334, -1.868233, -2.604672>, <0.764481, -1.875826, -2.591981>, <0.919457, -1.864336, -2.573781>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.046806, -1.783637, -2.475399>, <0.024575, -1.832179, -2.580476>, <0.141810, -1.888290, -2.739197>, <0.272340, -1.903999, -2.773952>, 
      <-0.184923, -1.793877, -2.491620>, <-0.113543, -1.842419, -2.596697>, <0.164836, -1.897759, -2.718291>, <0.295365, -1.913468, -2.753047>, 
      <0.259960, -1.843732, -2.574802>, <0.255437, -1.873628, -2.607685>, <0.331464, -1.910131, -2.672420>, <0.316728, -1.934217, -2.707037>, 
      <0.398210, -1.855278, -2.588878>, <0.393687, -1.885175, -2.621761>, <0.363827, -1.911477, -2.669651>, <0.349091, -1.935562, -2.704268>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.046806, -1.686967, -2.304148>, <-0.046806, -1.716344, -2.355309>, <-0.077773, -1.762578, -2.429813>, <-0.046806, -1.783637, -2.475399>, 
      <-0.182308, -1.676298, -2.310179>, <-0.182308, -1.705675, -2.361341>, <-0.215891, -1.772818, -2.446034>, <-0.184923, -1.793877, -2.491620>, 
      <0.262708, -1.621558, -2.341127>, <0.262057, -1.693890, -2.414623>, <0.270401, -1.774719, -2.498894>, <0.259960, -1.843732, -2.574802>, 
      <0.398210, -1.610889, -2.347159>, <0.397559, -1.683221, -2.420654>, <0.408651, -1.786265, -2.512970>, <0.398210, -1.855278, -2.588878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.046806, -1.532605, -2.038218>, <-0.046806, -1.586623, -2.112993>, <-0.046806, -1.641033, -2.224153>, <-0.046806, -1.686967, -2.304148>, 
      <-0.188086, -1.511787, -2.049783>, <-0.188086, -1.565805, -2.124557>, <-0.182308, -1.630365, -2.230184>, <-0.182308, -1.676298, -2.310179>, 
      <0.261112, -1.411658, -2.105407>, <0.255913, -1.467980, -2.182407>, <0.263312, -1.554542, -2.273034>, <0.262708, -1.621558, -2.341127>, 
      <0.402392, -1.390840, -2.116972>, <0.397192, -1.447162, -2.193972>, <0.398813, -1.543873, -2.279065>, <0.398210, -1.610889, -2.347159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.046806, -1.327636, -1.806745>, <-0.046806, -1.383611, -1.880705>, <-0.046806, -1.478289, -1.963031>, <-0.046806, -1.532605, -2.038218>, 
      <-0.191904, -1.317218, -1.816299>, <-0.191904, -1.373193, -1.890259>, <-0.188086, -1.457471, -1.974596>, <-0.188086, -1.511787, -2.049783>, 
      <0.285453, -1.271001, -1.858687>, <0.283103, -1.313143, -1.932069>, <0.265720, -1.361754, -2.037181>, <0.261112, -1.411658, -2.105407>, 
      <0.430551, -1.260583, -1.868241>, <0.428201, -1.302725, -1.941623>, <0.406999, -1.340936, -2.048746>, <0.402392, -1.390840, -2.116972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.421602, -1.046328, -1.517068>, <0.240826, -1.063138, -1.492438>, <-0.188752, -1.083326, -1.462857>, <-0.046806, -1.089883, -1.453249>, 
      <0.418006, -1.115425, -1.619295>, <0.237229, -1.132235, -1.594665>, <-0.188752, -1.157369, -1.567026>, <-0.046806, -1.163926, -1.557419>, 
      <0.433978, -1.199133, -1.761237>, <0.288879, -1.209551, -1.751683>, <-0.191904, -1.240091, -1.714392>, <-0.046806, -1.250509, -1.704837>, 
      <0.430551, -1.260583, -1.868241>, <0.285453, -1.271001, -1.858687>, <-0.191904, -1.317218, -1.816299>, <-0.046806, -1.327636, -1.806745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.046806, -0.675369, -0.889085>, <-0.035718, -0.839554, -1.019583>, <-0.046806, -0.968206, -1.282065>, <-0.046806, -1.089883, -1.453249>, 
      <-0.227575, -0.714567, -0.969501>, <-0.216488, -0.878751, -1.099999>, <-0.188752, -0.961649, -1.291672>, <-0.188752, -1.083326, -1.462857>, 
      <0.258692, -0.797040, -1.138699>, <0.263380, -0.865764, -1.188036>, <0.243294, -1.015709, -1.422269>, <0.240826, -1.063138, -1.492438>, 
      <0.450697, -0.873510, -1.295582>, <0.455386, -0.942235, -1.344919>, <0.424071, -0.998900, -1.446900>, <0.421602, -1.046328, -1.517068>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.046806, -0.675369, -0.889085>, <-0.227575, -0.714567, -0.969501>, <0.258692, -0.797040, -1.138699>, <0.450697, -0.873510, -1.295582>, 
      <-0.049986, -0.628278, -0.851656>, <-0.230756, -0.667476, -0.932072>, <0.252461, -0.705708, -1.073133>, <0.444466, -0.782178, -1.230016>, 
      <-0.074424, -0.556582, -0.958958>, <-0.222577, -0.560690, -0.982301>, <0.263988, -0.627308, -1.145021>, <0.405859, -0.635771, -1.193106>, 
      <-0.086260, -0.505673, -0.988904>, <-0.234413, -0.509781, -1.012247>, <0.244771, -0.525420, -1.101103>, <0.386642, -0.533883, -1.149188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.364473, -1.783638, -2.475400>, <1.502139, -1.795135, -2.489417>, <1.056992, -1.854139, -2.557629>, <0.919457, -1.864336, -2.573781>, 
      <1.288613, -1.834698, -2.578741>, <1.426279, -1.846195, -2.592757>, <1.064654, -1.887859, -2.595742>, <0.927119, -1.898056, -2.611894>, 
      <1.160928, -1.898470, -2.725551>, <1.150218, -1.904739, -2.710724>, <0.990101, -1.912430, -2.672380>, <0.970845, -1.913068, -2.670751>, 
      <1.028568, -1.913057, -2.761734>, <1.017858, -1.919326, -2.746907>, <1.012124, -1.933315, -2.713939>, <0.992868, -1.933953, -2.712310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.364473, -1.783638, -2.475400>, <1.288613, -1.834698, -2.578741>, <1.160928, -1.898470, -2.725551>, <1.028568, -1.913057, -2.761734>, 
      <0.944713, -1.748581, -2.432661>, <0.868853, -1.799641, -2.536002>, <0.943271, -1.922457, -2.785051>, <0.810911, -1.937044, -2.821234>, 
      <0.372553, -1.752545, -2.426150>, <0.443933, -1.801087, -2.531227>, <0.359617, -1.914503, -2.797191>, <0.490146, -1.930212, -2.831946>, 
      <-0.046806, -1.783637, -2.475399>, <0.024575, -1.832179, -2.580476>, <0.141810, -1.888290, -2.739197>, <0.272340, -1.903999, -2.773952>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.364473, -1.686967, -2.304148>, <1.499975, -1.676298, -2.310179>, <1.054959, -1.621558, -2.341127>, <0.919457, -1.610889, -2.347159>, 
      <1.364473, -1.716344, -2.355309>, <1.499975, -1.705676, -2.361341>, <1.055607, -1.694961, -2.411944>, <0.920105, -1.684292, -2.417975>, 
      <1.396906, -1.761808, -2.431218>, <1.534573, -1.773305, -2.445235>, <1.041805, -1.787306, -2.482090>, <0.904270, -1.797503, -2.498242>, 
      <1.364473, -1.783638, -2.475400>, <1.502139, -1.795135, -2.489417>, <1.056992, -1.854139, -2.557629>, <0.919457, -1.864336, -2.573781>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.364473, -1.686967, -2.304148>, <1.364473, -1.716344, -2.355309>, <1.396906, -1.761808, -2.431218>, <1.364473, -1.783638, -2.475400>, 
      <0.942811, -1.720166, -2.285378>, <0.942811, -1.749544, -2.336540>, <0.977147, -1.726751, -2.388479>, <0.944713, -1.748581, -2.432661>, 
      <0.374856, -1.720166, -2.285378>, <0.374856, -1.749543, -2.336540>, <0.341585, -1.731486, -2.380564>, <0.372553, -1.752545, -2.426150>, 
      <-0.046806, -1.686967, -2.304148>, <-0.046806, -1.716344, -2.355309>, <-0.077773, -1.762578, -2.429813>, <-0.046806, -1.783637, -2.475399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.931025, -0.533883, -1.149188>, <1.072896, -0.525420, -1.101103>, <1.552081, -0.509781, -1.012247>, <1.403928, -0.505673, -0.988904>, 
      <0.767710, -0.533883, -1.149188>, <0.909581, -0.525420, -1.101103>, <1.110638, -0.497540, -0.942693>, <0.962485, -0.493432, -0.919350>, 
      <0.549957, -0.533883, -1.149188>, <0.408086, -0.525420, -1.101103>, <0.207030, -0.497540, -0.942693>, <0.355183, -0.493432, -0.919350>, 
      <0.386642, -0.533883, -1.149188>, <0.244771, -0.525420, -1.101103>, <-0.234413, -0.509781, -1.012247>, <-0.086260, -0.505673, -0.988904>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.364473, -1.532605, -2.038218>, <1.364473, -1.586623, -2.112993>, <1.364473, -1.641033, -2.224153>, <1.364473, -1.686967, -2.304148>, 
      <0.946979, -1.594124, -2.004043>, <0.946979, -1.648142, -2.078817>, <0.942811, -1.674233, -2.205383>, <0.942811, -1.720166, -2.285378>, 
      <0.370688, -1.594124, -2.004043>, <0.370688, -1.648142, -2.078817>, <0.374856, -1.674233, -2.205383>, <0.374856, -1.720166, -2.285378>, 
      <-0.046806, -1.532605, -2.038218>, <-0.046806, -1.586623, -2.112993>, <-0.046806, -1.641033, -2.224153>, <-0.046806, -1.686967, -2.304148>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.364473, -1.532605, -2.038218>, <1.505753, -1.511787, -2.049783>, <1.056555, -1.411658, -2.105407>, <0.915275, -1.390840, -2.116972>, 
      <1.364473, -1.586623, -2.112993>, <1.505753, -1.565805, -2.124557>, <1.061754, -1.467980, -2.182407>, <0.920475, -1.447162, -2.193972>, 
      <1.364473, -1.641033, -2.224153>, <1.499975, -1.630365, -2.230184>, <1.054352, -1.552800, -2.274793>, <0.918850, -1.542131, -2.280824>, 
      <1.364473, -1.686967, -2.304148>, <1.499975, -1.676298, -2.310179>, <1.054959, -1.621558, -2.341127>, <0.919457, -1.610889, -2.347159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.364473, -1.327636, -1.806745>, <1.364473, -1.383611, -1.880705>, <1.364473, -1.478289, -1.963031>, <1.364473, -1.532605, -2.038218>, 
      <0.943084, -1.357890, -1.778998>, <0.943084, -1.413866, -1.852958>, <0.946979, -1.539808, -1.928856>, <0.946979, -1.594124, -2.004043>, 
      <0.374583, -1.357890, -1.778998>, <0.374583, -1.413866, -1.852958>, <0.370688, -1.539808, -1.928856>, <0.370688, -1.594124, -2.004043>, 
      <-0.046806, -1.327636, -1.806745>, <-0.046806, -1.383611, -1.880705>, <-0.046806, -1.478289, -1.963031>, <-0.046806, -1.532605, -2.038218>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.364473, -1.327636, -1.806745>, <1.509571, -1.317218, -1.816299>, <1.032214, -1.271001, -1.858687>, <0.887116, -1.260583, -1.868241>, 
      <1.364473, -1.383611, -1.880705>, <1.509571, -1.373193, -1.890259>, <1.034564, -1.313143, -1.932069>, <0.889466, -1.302725, -1.941623>, 
      <1.364473, -1.478289, -1.963031>, <1.505753, -1.457471, -1.974596>, <1.051947, -1.361754, -2.037181>, <0.910668, -1.340936, -2.048746>, 
      <1.364473, -1.532605, -2.038218>, <1.505753, -1.511787, -2.049783>, <1.056555, -1.411658, -2.105407>, <0.915275, -1.390840, -2.116972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.364473, -1.089883, -1.453249>, <1.364473, -1.163926, -1.557419>, <1.364473, -1.250509, -1.704837>, <1.364473, -1.327636, -1.806745>, 
      <0.942504, -1.109376, -1.424688>, <0.942504, -1.183419, -1.528857>, <0.943084, -1.280764, -1.677090>, <0.943084, -1.357890, -1.778998>, 
      <0.375163, -1.109376, -1.424688>, <0.375163, -1.183419, -1.528857>, <0.374583, -1.280764, -1.677090>, <0.374583, -1.357890, -1.778998>, 
      <-0.046806, -1.089883, -1.453249>, <-0.046806, -1.163926, -1.557419>, <-0.046806, -1.250509, -1.704837>, <-0.046806, -1.327636, -1.806745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.896065, -1.046328, -1.517068>, <0.899661, -1.115425, -1.619295>, <0.883690, -1.199133, -1.761237>, <0.887116, -1.260583, -1.868241>, 
      <1.076842, -1.063138, -1.492438>, <1.080438, -1.132235, -1.594665>, <1.028788, -1.209551, -1.751683>, <1.032214, -1.271001, -1.858687>, 
      <1.506419, -1.083326, -1.462857>, <1.506419, -1.157369, -1.567026>, <1.509571, -1.240091, -1.714392>, <1.509571, -1.317218, -1.816299>, 
      <1.364473, -1.089883, -1.453249>, <1.364473, -1.163926, -1.557419>, <1.364473, -1.250509, -1.704837>, <1.364473, -1.327636, -1.806745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.364473, -0.675369, -0.889085>, <1.353385, -0.839553, -1.019583>, <1.364473, -0.968206, -1.282065>, <1.364473, -1.089883, -1.453249>, 
      <0.985014, -0.593088, -0.720281>, <0.973926, -0.757273, -0.850779>, <0.942504, -0.987699, -1.253503>, <0.942504, -1.109376, -1.424688>, 
      <0.332653, -0.593088, -0.720281>, <0.343741, -0.757273, -0.850779>, <0.375163, -0.987699, -1.253503>, <0.375163, -1.109376, -1.424688>, 
      <-0.046806, -0.675369, -0.889085>, <-0.035718, -0.839554, -1.019583>, <-0.046806, -0.968206, -1.282065>, <-0.046806, -1.089883, -1.453249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.364473, -0.675369, -0.889085>, <0.985014, -0.593088, -0.720281>, <0.332653, -0.593088, -0.720281>, <-0.046806, -0.675369, -0.889085>, 
      <1.367653, -0.628278, -0.851656>, <0.988195, -0.545998, -0.682852>, <0.329473, -0.545998, -0.682852>, <-0.049986, -0.628278, -0.851656>, 
      <1.392092, -0.556582, -0.958958>, <0.950649, -0.544340, -0.889404>, <0.367019, -0.544340, -0.889404>, <-0.074424, -0.556582, -0.958958>, 
      <1.403928, -0.505673, -0.988904>, <0.962485, -0.493432, -0.919350>, <0.355183, -0.493432, -0.919350>, <-0.086260, -0.505673, -0.988904>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.364473, -0.675369, -0.889085>, <1.367653, -0.628278, -0.851656>, <1.392092, -0.556582, -0.958958>, <1.403928, -0.505673, -0.988904>, 
      <1.545242, -0.714567, -0.969501>, <1.548423, -0.667476, -0.932072>, <1.540245, -0.560690, -0.982301>, <1.552081, -0.509781, -1.012247>, 
      <1.058975, -0.797040, -1.138699>, <1.065206, -0.705708, -1.073133>, <1.053680, -0.627308, -1.145021>, <1.072896, -0.525420, -1.101103>, 
      <0.866970, -0.873510, -1.295582>, <0.873201, -0.782178, -1.230016>, <0.911809, -0.635771, -1.193106>, <0.931025, -0.533883, -1.149188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.364473, -0.675369, -0.889085>, <1.545242, -0.714567, -0.969501>, <1.058975, -0.797040, -1.138699>, <0.866970, -0.873510, -1.295582>, 
      <1.353385, -0.839553, -1.019583>, <1.534154, -0.878751, -1.099999>, <1.054287, -0.865764, -1.188036>, <0.862282, -0.942235, -1.344919>, 
      <1.364473, -0.968206, -1.282065>, <1.506419, -0.961649, -1.291672>, <1.074373, -1.015709, -1.422269>, <0.893597, -0.998900, -1.446900>, 
      <1.364473, -1.089883, -1.453249>, <1.506419, -1.083326, -1.462857>, <1.076842, -1.063138, -1.492438>, <0.896065, -1.046328, -1.517068>
    }
  }
  texture {
    Shiny_Red
  }
  rotate <-90.0, -180.0, 0.0>
  translate  1.35*x
}
#declare Teeth = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.145497, -0.852932, -0.736750>, <0.128425, -0.849804, -0.730175>, <0.128559, -0.871537, -0.771996>, <0.121300, -0.879510, -0.787102>, 
      <0.168470, -0.846431, -0.722524>, <0.151399, -0.843303, -0.715949>, <0.122019, -0.867688, -0.758824>, <0.114760, -0.875662, -0.773930>, 
      <0.198353, -0.855781, -0.774214>, <0.161901, -0.858685, -0.760091>, <0.136674, -0.859151, -0.733964>, <0.106706, -0.874117, -0.754324>, 
      <0.221005, -0.857002, -0.790270>, <0.184553, -0.859906, -0.776147>, <0.129467, -0.851716, -0.722834>, <0.099499, -0.866682, -0.743194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.117474, -0.903027, -0.862567>, <0.095636, -0.899026, -0.854157>, <0.120152, -0.886565, -0.809742>, <0.121300, -0.879510, -0.787102>, 
      <0.110941, -0.907645, -0.867382>, <0.089103, -0.903643, -0.858972>, <0.113612, -0.882717, -0.796569>, <0.114760, -0.875662, -0.773930>, 
      <0.100992, -0.912809, -0.875247>, <0.075035, -0.899547, -0.843751>, <0.073897, -0.890501, -0.776614>, <0.106706, -0.874117, -0.754324>, 
      <0.094989, -0.919933, -0.875885>, <0.069032, -0.906671, -0.844389>, <0.066691, -0.883066, -0.765484>, <0.099499, -0.866682, -0.743194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.191347, -0.892345, -0.814078>, <0.195568, -0.900881, -0.831369>, <0.195370, -0.911673, -0.857380>, <0.205416, -0.920798, -0.871714>, 
      <0.177592, -0.880521, -0.790880>, <0.181813, -0.889057, -0.808171>, <0.219365, -0.899689, -0.841078>, <0.229411, -0.908815, -0.855411>, 
      <0.172584, -0.857895, -0.747182>, <0.195558, -0.851394, -0.732956>, <0.193676, -0.874920, -0.798647>, <0.216328, -0.876141, -0.814703>, 
      <0.145497, -0.852932, -0.736750>, <0.168470, -0.846431, -0.722524>, <0.198353, -0.855781, -0.774214>, <0.221005, -0.857002, -0.790270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.191347, -0.892345, -0.814078>, <0.169185, -0.895550, -0.828625>, <0.142036, -0.907528, -0.872026>, <0.117474, -0.903027, -0.862567>, 
      <0.195568, -0.900881, -0.831369>, <0.173406, -0.904085, -0.845916>, <0.135503, -0.912145, -0.876841>, <0.110941, -0.907645, -0.867382>, 
      <0.195370, -0.911673, -0.857380>, <0.170025, -0.924330, -0.874600>, <0.121044, -0.923055, -0.899579>, <0.100992, -0.912809, -0.875247>, 
      <0.205416, -0.920798, -0.871714>, <0.180071, -0.933455, -0.888934>, <0.115042, -0.930178, -0.900217>, <0.094989, -0.919933, -0.875885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -0.874454, -0.828460>, <0.165121, -0.864107, -0.802473>, <0.121886, -0.859613, -0.751371>, <0.145497, -0.852932, -0.736750>, 
      <0.155619, -0.881093, -0.845133>, <0.161407, -0.870746, -0.819147>, <0.104815, -0.856485, -0.744796>, <0.128425, -0.849804, -0.730175>, 
      <0.130296, -0.893964, -0.853116>, <0.108458, -0.889962, -0.844706>, <0.127411, -0.878592, -0.794636>, <0.128559, -0.871537, -0.771996>, 
      <0.117474, -0.903027, -0.862567>, <0.095636, -0.899026, -0.854157>, <0.120152, -0.886565, -0.809742>, <0.121300, -0.879510, -0.787102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -0.874454, -0.828460>, <0.165121, -0.864107, -0.802473>, <0.121886, -0.859613, -0.751371>, <0.145497, -0.852932, -0.736750>, 
      <0.155619, -0.881093, -0.845133>, <0.161407, -0.870746, -0.819147>, <0.148973, -0.864577, -0.761803>, <0.172584, -0.857895, -0.747182>, 
      <0.130296, -0.893964, -0.853116>, <0.154859, -0.898465, -0.862575>, <0.155430, -0.883726, -0.805426>, <0.177592, -0.880521, -0.790880>, 
      <0.117474, -0.903027, -0.862567>, <0.142036, -0.907528, -0.872026>, <0.169185, -0.895550, -0.828625>, <0.191347, -0.892345, -0.814078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -0.874454, -0.828460>, <0.165121, -0.864107, -0.802473>, <0.121886, -0.859613, -0.751371>, <0.145497, -0.852932, -0.736750>, 
      <0.159333, -0.874454, -0.828460>, <0.149554, -0.861255, -0.796478>, <0.104815, -0.856485, -0.744796>, <0.128425, -0.849804, -0.730175>, 
      <0.159333, -0.874454, -0.828460>, <0.149554, -0.861255, -0.796478>, <0.139969, -0.870020, -0.784404>, <0.128559, -0.871537, -0.771996>, 
      <0.159333, -0.874454, -0.828460>, <0.143765, -0.871602, -0.822465>, <0.132710, -0.877993, -0.799509>, <0.121300, -0.879510, -0.787102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -0.874454, -0.828460>, <0.155619, -0.881093, -0.845133>, <0.130296, -0.893964, -0.853116>, <0.117474, -0.903027, -0.862567>, 
      <0.159333, -0.874454, -0.828460>, <0.140052, -0.878240, -0.839138>, <0.108458, -0.889962, -0.844706>, <0.095636, -0.899026, -0.854157>, 
      <0.159333, -0.874454, -0.828460>, <0.140052, -0.878240, -0.839138>, <0.131562, -0.885048, -0.822149>, <0.120152, -0.886565, -0.809742>, 
      <0.159333, -0.874454, -0.828460>, <0.143765, -0.871602, -0.822465>, <0.132710, -0.877993, -0.799509>, <0.121300, -0.879510, -0.787102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -0.874454, -0.828460>, <0.143765, -0.871602, -0.822465>, <0.132710, -0.877993, -0.799509>, <0.121300, -0.879510, -0.787102>, 
      <0.170204, -0.876446, -0.832646>, <0.154636, -0.873593, -0.826651>, <0.131562, -0.885048, -0.822149>, <0.120152, -0.886565, -0.809742>, 
      <0.181743, -0.886978, -0.818393>, <0.159581, -0.890182, -0.832939>, <0.120198, -0.903526, -0.863616>, <0.095636, -0.899026, -0.854157>, 
      <0.191347, -0.892345, -0.814078>, <0.169185, -0.895550, -0.828625>, <0.142036, -0.907528, -0.872026>, <0.117474, -0.903027, -0.862567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -0.874454, -0.828460>, <0.155619, -0.881093, -0.845133>, <0.130296, -0.893964, -0.853116>, <0.117474, -0.903027, -0.862567>, 
      <0.159333, -0.874454, -0.828460>, <0.166490, -0.883085, -0.849320>, <0.154859, -0.898465, -0.862575>, <0.142036, -0.907528, -0.872026>, 
      <0.159333, -0.874454, -0.828460>, <0.166490, -0.883085, -0.849320>, <0.159581, -0.890182, -0.832939>, <0.169185, -0.895550, -0.828625>, 
      <0.159333, -0.874454, -0.828460>, <0.170204, -0.876446, -0.832646>, <0.181743, -0.886978, -0.818393>, <0.191347, -0.892345, -0.814078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -0.874454, -0.828460>, <0.143765, -0.871602, -0.822465>, <0.132710, -0.877993, -0.799509>, <0.121300, -0.879510, -0.787102>, 
      <0.170204, -0.876446, -0.832646>, <0.154636, -0.873593, -0.826651>, <0.139969, -0.870020, -0.784404>, <0.128559, -0.871537, -0.771996>, 
      <0.181743, -0.886978, -0.818393>, <0.167988, -0.875154, -0.795194>, <0.155513, -0.854767, -0.740607>, <0.128425, -0.849804, -0.730175>, 
      <0.191347, -0.892345, -0.814078>, <0.177592, -0.880521, -0.790880>, <0.172584, -0.857895, -0.747182>, <0.145497, -0.852932, -0.736750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -0.874454, -0.828460>, <0.170204, -0.876446, -0.832646>, <0.181743, -0.886978, -0.818393>, <0.191347, -0.892345, -0.814078>, 
      <0.159333, -0.874454, -0.828460>, <0.175992, -0.866099, -0.806659>, <0.167988, -0.875154, -0.795194>, <0.177592, -0.880521, -0.790880>, 
      <0.159333, -0.874454, -0.828460>, <0.175992, -0.866099, -0.806659>, <0.148973, -0.864577, -0.761803>, <0.172584, -0.857895, -0.747182>, 
      <0.159333, -0.874454, -0.828460>, <0.165121, -0.864107, -0.802473>, <0.121886, -0.859613, -0.751371>, <0.145497, -0.852932, -0.736750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.076798, -0.951297, -0.866890>, <0.082255, -0.941888, -0.869588>, <0.087784, -0.928483, -0.876651>, <0.094989, -0.919933, -0.875885>, 
      <0.075921, -0.915083, -0.820980>, <0.081378, -0.905674, -0.823678>, <0.061827, -0.915221, -0.845155>, <0.069032, -0.906671, -0.844389>, 
      <0.034326, -0.856054, -0.748599>, <0.042109, -0.855859, -0.762500>, <0.059138, -0.875274, -0.753818>, <0.066691, -0.883066, -0.765484>, 
      <0.073875, -0.830583, -0.713855>, <0.081657, -0.830388, -0.727756>, <0.091946, -0.858890, -0.731529>, <0.099499, -0.866682, -0.743194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.076798, -0.951297, -0.866890>, <0.126490, -0.947535, -0.872916>, <0.192747, -0.942518, -0.880950>, <0.242439, -0.938756, -0.886976>, 
      <0.082255, -0.941888, -0.869588>, <0.131948, -0.938125, -0.875614>, <0.181640, -0.937131, -0.876372>, <0.231332, -0.933369, -0.882397>, 
      <0.087784, -0.928483, -0.876651>, <0.107837, -0.938728, -0.900983>, <0.186771, -0.939542, -0.898494>, <0.212117, -0.926885, -0.881274>, 
      <0.094989, -0.919933, -0.875885>, <0.115042, -0.930178, -0.900217>, <0.180071, -0.933455, -0.888934>, <0.205416, -0.920798, -0.871714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.242556, -0.844540, -0.721270>, <0.236091, -0.848279, -0.741970>, <0.227470, -0.853263, -0.769570>, <0.221005, -0.857002, -0.790270>, 
      <0.242521, -0.872805, -0.770982>, <0.236056, -0.876543, -0.791682>, <0.222794, -0.872402, -0.794003>, <0.216328, -0.876141, -0.814703>, 
      <0.242474, -0.910491, -0.837264>, <0.231367, -0.905104, -0.832686>, <0.236112, -0.914902, -0.864972>, <0.229411, -0.908815, -0.855411>, 
      <0.242439, -0.938756, -0.886976>, <0.231332, -0.933369, -0.882397>, <0.212117, -0.926885, -0.881274>, <0.205416, -0.920798, -0.871714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.242556, -0.844540, -0.721270>, <0.191952, -0.840353, -0.719046>, <0.108247, -0.808446, -0.683659>, <0.073875, -0.830583, -0.713855>, 
      <0.236091, -0.848279, -0.741970>, <0.185486, -0.844091, -0.739745>, <0.116029, -0.808251, -0.697561>, <0.081657, -0.830388, -0.727756>, 
      <0.227470, -0.853263, -0.769570>, <0.191019, -0.856167, -0.755447>, <0.121914, -0.843924, -0.711168>, <0.091946, -0.858890, -0.731529>, 
      <0.221005, -0.857002, -0.790270>, <0.184553, -0.859906, -0.776147>, <0.129467, -0.851716, -0.722834>, <0.099499, -0.866682, -0.743194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.258431, -0.882447, -0.643728>, <0.261584, -0.864835, -0.663042>, <0.247319, -0.855912, -0.698007>, <0.242556, -0.844540, -0.721270>, 
      <0.301433, -0.920150, -0.684055>, <0.304587, -0.902539, -0.703368>, <0.247283, -0.884177, -0.747719>, <0.242521, -0.872805, -0.770982>, 
      <0.278231, -1.005824, -0.774170>, <0.281808, -0.982039, -0.801582>, <0.239329, -0.940000, -0.816066>, <0.242474, -0.910491, -0.837264>, 
      <0.231956, -1.037118, -0.816316>, <0.235533, -1.013332, -0.843728>, <0.239294, -0.968265, -0.865778>, <0.242439, -0.938756, -0.886976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.039288, -0.868191, -0.635637>, <0.049664, -0.856909, -0.659102>, <0.060185, -0.830926, -0.689400>, <0.073875, -0.830583, -0.713855>, 
      <0.105031, -0.872468, -0.638064>, <0.115407, -0.861185, -0.661530>, <0.094557, -0.808789, -0.659204>, <0.108247, -0.808446, -0.683659>, 
      <0.217919, -0.846927, -0.605737>, <0.221072, -0.829315, -0.625050>, <0.196714, -0.851725, -0.695783>, <0.191952, -0.840353, -0.719046>, 
      <0.258431, -0.882447, -0.643728>, <0.261584, -0.864835, -0.663042>, <0.247319, -0.855912, -0.698007>, <0.242556, -0.844540, -0.721270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.052683, -1.021585, -0.831120>, <0.058520, -1.005220, -0.848734>, <0.069564, -0.972383, -0.856159>, <0.076798, -0.951297, -0.866890>, 
      <0.006808, -0.981363, -0.788100>, <0.012645, -0.964998, -0.805714>, <0.068687, -0.936169, -0.810249>, <0.075921, -0.915083, -0.820980>, 
      <0.043306, -0.914209, -0.694282>, <0.053683, -0.902927, -0.717747>, <0.020636, -0.856397, -0.724144>, <0.034326, -0.856054, -0.748599>, 
      <0.039288, -0.868191, -0.635637>, <0.049664, -0.856909, -0.659102>, <0.060185, -0.830926, -0.689400>, <0.073875, -0.830583, -0.713855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.052683, -1.021585, -0.831120>, <0.085968, -1.050769, -0.862334>, <0.196138, -1.061340, -0.848939>, <0.231956, -1.037118, -0.816316>, 
      <0.058520, -1.005220, -0.848734>, <0.091805, -1.034404, -0.879948>, <0.199714, -1.037554, -0.876351>, <0.235533, -1.013332, -0.843728>, 
      <0.069564, -0.972383, -0.856159>, <0.119256, -0.968621, -0.862185>, <0.189602, -0.972027, -0.859752>, <0.239294, -0.968265, -0.865778>, 
      <0.076798, -0.951297, -0.866890>, <0.126490, -0.947535, -0.872916>, <0.192747, -0.942518, -0.880950>, <0.242439, -0.938756, -0.886976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.227244, -0.930061, -0.627484>, <0.236600, -0.915777, -0.632357>, <0.256304, -0.894326, -0.630701>, <0.258431, -0.882447, -0.643728>, 
      <0.262241, -0.961355, -0.652153>, <0.271597, -0.947071, -0.657026>, <0.299306, -0.932029, -0.671028>, <0.301433, -0.920150, -0.684055>, 
      <0.262466, -1.034581, -0.720750>, <0.264750, -1.027985, -0.741161>, <0.276115, -1.019894, -0.757955>, <0.278231, -1.005824, -0.774170>, 
      <0.224342, -1.059105, -0.748278>, <0.226626, -1.052509, -0.768689>, <0.229840, -1.051188, -0.800101>, <0.231956, -1.037118, -0.816316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.054104, -0.906878, -0.628278>, <0.049659, -0.895272, -0.630486>, <0.043733, -0.879797, -0.633429>, <0.039288, -0.868191, -0.635637>, 
      <0.091776, -0.882644, -0.601076>, <0.087331, -0.871038, -0.603284>, <0.109476, -0.884074, -0.635857>, <0.105031, -0.872468, -0.638064>, 
      <0.192662, -0.899138, -0.603107>, <0.202018, -0.884853, -0.607981>, <0.215792, -0.858805, -0.592710>, <0.217919, -0.846927, -0.605737>, 
      <0.227244, -0.930061, -0.627484>, <0.236600, -0.915777, -0.632357>, <0.256304, -0.894326, -0.630701>, <0.258431, -0.882447, -0.643728>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.041829, -1.049335, -0.761368>, <0.045085, -1.041010, -0.782294>, <0.047315, -1.036636, -0.814920>, <0.052683, -1.021585, -0.831120>, 
      <0.003158, -1.014756, -0.734109>, <0.006415, -1.006431, -0.755035>, <0.001440, -0.996414, -0.771900>, <0.006808, -0.981363, -0.788100>, 
      <0.011978, -0.933977, -0.658696>, <0.007533, -0.922371, -0.660904>, <0.047751, -0.925815, -0.692074>, <0.043306, -0.914209, -0.694282>, 
      <0.054104, -0.906878, -0.628278>, <0.049659, -0.895272, -0.630486>, <0.043733, -0.879797, -0.633429>, <0.039288, -0.868191, -0.635637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.041829, -1.049335, -0.761368>, <0.078105, -1.081773, -0.786939>, <0.184825, -1.084526, -0.776812>, <0.224342, -1.059105, -0.748278>, 
      <0.045085, -1.041010, -0.782294>, <0.081361, -1.073448, -0.807864>, <0.187109, -1.077930, -0.797224>, <0.226626, -1.052509, -0.768689>, 
      <0.047315, -1.036636, -0.814920>, <0.080600, -1.065820, -0.846134>, <0.194022, -1.075410, -0.832724>, <0.229840, -1.051188, -0.800101>, 
      <0.052683, -1.021585, -0.831120>, <0.085968, -1.050769, -0.862334>, <0.196138, -1.061340, -0.848939>, <0.231956, -1.037118, -0.816316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.179633, -0.852932, -0.736750>, <1.162561, -0.849804, -0.730175>, <1.162695, -0.871537, -0.771996>, <1.155436, -0.879510, -0.787102>, 
      <1.202606, -0.846431, -0.722524>, <1.185535, -0.843303, -0.715949>, <1.156155, -0.867688, -0.758824>, <1.148896, -0.875662, -0.773930>, 
      <1.232489, -0.855781, -0.774214>, <1.196037, -0.858685, -0.760091>, <1.170810, -0.859151, -0.733964>, <1.140842, -0.874117, -0.754324>, 
      <1.255141, -0.857002, -0.790270>, <1.218689, -0.859906, -0.776147>, <1.163603, -0.851716, -0.722834>, <1.133635, -0.866682, -0.743194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151610, -0.903027, -0.862567>, <1.129772, -0.899026, -0.854157>, <1.154288, -0.886565, -0.809742>, <1.155436, -0.879510, -0.787102>, 
      <1.145077, -0.907645, -0.867382>, <1.123239, -0.903643, -0.858972>, <1.147748, -0.882717, -0.796569>, <1.148896, -0.875662, -0.773930>, 
      <1.135128, -0.912809, -0.875247>, <1.109171, -0.899547, -0.843751>, <1.108033, -0.890501, -0.776614>, <1.140842, -0.874117, -0.754324>, 
      <1.129125, -0.919933, -0.875885>, <1.103168, -0.906671, -0.844389>, <1.100827, -0.883066, -0.765484>, <1.133635, -0.866682, -0.743194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.225483, -0.892345, -0.814078>, <1.229704, -0.900881, -0.831369>, <1.229506, -0.911673, -0.857380>, <1.239552, -0.920798, -0.871714>, 
      <1.211728, -0.880521, -0.790880>, <1.215949, -0.889057, -0.808171>, <1.253502, -0.899689, -0.841078>, <1.263548, -0.908815, -0.855411>, 
      <1.206720, -0.857895, -0.747182>, <1.229694, -0.851394, -0.732956>, <1.227812, -0.874920, -0.798647>, <1.250464, -0.876141, -0.814703>, 
      <1.179633, -0.852932, -0.736750>, <1.202606, -0.846431, -0.722524>, <1.232489, -0.855781, -0.774214>, <1.255141, -0.857002, -0.790270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.225483, -0.892345, -0.814078>, <1.203321, -0.895550, -0.828625>, <1.176172, -0.907528, -0.872026>, <1.151610, -0.903027, -0.862567>, 
      <1.229704, -0.900881, -0.831369>, <1.207542, -0.904085, -0.845916>, <1.169639, -0.912145, -0.876841>, <1.145077, -0.907645, -0.867382>, 
      <1.229506, -0.911673, -0.857380>, <1.204161, -0.924330, -0.874600>, <1.155180, -0.923055, -0.899579>, <1.135128, -0.912809, -0.875247>, 
      <1.239552, -0.920798, -0.871714>, <1.214207, -0.933455, -0.888934>, <1.149177, -0.930178, -0.900217>, <1.129125, -0.919933, -0.875885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -0.874454, -0.828460>, <1.199257, -0.864107, -0.802473>, <1.156022, -0.859613, -0.751371>, <1.179633, -0.852932, -0.736750>, 
      <1.189755, -0.881093, -0.845133>, <1.195543, -0.870746, -0.819147>, <1.138951, -0.856485, -0.744796>, <1.162561, -0.849804, -0.730175>, 
      <1.164432, -0.893964, -0.853116>, <1.142595, -0.889962, -0.844706>, <1.161547, -0.878592, -0.794636>, <1.162695, -0.871537, -0.771996>, 
      <1.151610, -0.903027, -0.862567>, <1.129772, -0.899026, -0.854157>, <1.154288, -0.886565, -0.809742>, <1.155436, -0.879510, -0.787102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -0.874454, -0.828460>, <1.199257, -0.864107, -0.802473>, <1.156022, -0.859613, -0.751371>, <1.179633, -0.852932, -0.736750>, 
      <1.189755, -0.881093, -0.845133>, <1.195543, -0.870746, -0.819147>, <1.183109, -0.864577, -0.761803>, <1.206720, -0.857895, -0.747182>, 
      <1.164432, -0.893964, -0.853116>, <1.188994, -0.898465, -0.862575>, <1.189566, -0.883726, -0.805426>, <1.211728, -0.880521, -0.790880>, 
      <1.151610, -0.903027, -0.862567>, <1.176172, -0.907528, -0.872026>, <1.203321, -0.895550, -0.828625>, <1.225483, -0.892345, -0.814078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -0.874454, -0.828460>, <1.199257, -0.864107, -0.802473>, <1.156022, -0.859613, -0.751371>, <1.179633, -0.852932, -0.736750>, 
      <1.193469, -0.874454, -0.828460>, <1.183690, -0.861255, -0.796478>, <1.138951, -0.856485, -0.744796>, <1.162561, -0.849804, -0.730175>, 
      <1.193469, -0.874454, -0.828460>, <1.183690, -0.861255, -0.796478>, <1.174105, -0.870020, -0.784404>, <1.162695, -0.871537, -0.771996>, 
      <1.193469, -0.874454, -0.828460>, <1.177901, -0.871602, -0.822465>, <1.166846, -0.877993, -0.799509>, <1.155436, -0.879510, -0.787102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -0.874454, -0.828460>, <1.189755, -0.881093, -0.845133>, <1.164432, -0.893964, -0.853116>, <1.151610, -0.903027, -0.862567>, 
      <1.193469, -0.874454, -0.828460>, <1.174188, -0.878240, -0.839138>, <1.142595, -0.889962, -0.844706>, <1.129772, -0.899026, -0.854157>, 
      <1.193469, -0.874454, -0.828460>, <1.174188, -0.878240, -0.839138>, <1.165698, -0.885048, -0.822149>, <1.154288, -0.886565, -0.809742>, 
      <1.193469, -0.874454, -0.828460>, <1.177901, -0.871602, -0.822465>, <1.166846, -0.877993, -0.799509>, <1.155436, -0.879510, -0.787102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -0.874454, -0.828460>, <1.177901, -0.871602, -0.822465>, <1.166846, -0.877993, -0.799509>, <1.155436, -0.879510, -0.787102>, 
      <1.204340, -0.876446, -0.832646>, <1.188772, -0.873593, -0.826651>, <1.165698, -0.885048, -0.822149>, <1.154288, -0.886565, -0.809742>, 
      <1.215879, -0.886978, -0.818393>, <1.193717, -0.890182, -0.832939>, <1.154334, -0.903526, -0.863616>, <1.129772, -0.899026, -0.854157>, 
      <1.225483, -0.892345, -0.814078>, <1.203321, -0.895550, -0.828625>, <1.176172, -0.907528, -0.872026>, <1.151610, -0.903027, -0.862567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -0.874454, -0.828460>, <1.189755, -0.881093, -0.845133>, <1.164432, -0.893964, -0.853116>, <1.151610, -0.903027, -0.862567>, 
      <1.193469, -0.874454, -0.828460>, <1.200626, -0.883085, -0.849320>, <1.188994, -0.898465, -0.862575>, <1.176172, -0.907528, -0.872026>, 
      <1.193469, -0.874454, -0.828460>, <1.200626, -0.883085, -0.849320>, <1.193717, -0.890182, -0.832939>, <1.203321, -0.895550, -0.828625>, 
      <1.193469, -0.874454, -0.828460>, <1.204340, -0.876446, -0.832646>, <1.215879, -0.886978, -0.818393>, <1.225483, -0.892345, -0.814078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -0.874454, -0.828460>, <1.177901, -0.871602, -0.822465>, <1.166846, -0.877993, -0.799509>, <1.155436, -0.879510, -0.787102>, 
      <1.204340, -0.876446, -0.832646>, <1.188772, -0.873593, -0.826651>, <1.174105, -0.870020, -0.784404>, <1.162695, -0.871537, -0.771996>, 
      <1.215879, -0.886978, -0.818393>, <1.202124, -0.875154, -0.795194>, <1.189649, -0.854767, -0.740607>, <1.162561, -0.849804, -0.730175>, 
      <1.225483, -0.892345, -0.814078>, <1.211728, -0.880521, -0.790880>, <1.206720, -0.857895, -0.747182>, <1.179633, -0.852932, -0.736750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -0.874454, -0.828460>, <1.204340, -0.876446, -0.832646>, <1.215879, -0.886978, -0.818393>, <1.225483, -0.892345, -0.814078>, 
      <1.193469, -0.874454, -0.828460>, <1.210128, -0.866099, -0.806659>, <1.202124, -0.875154, -0.795194>, <1.211728, -0.880521, -0.790880>, 
      <1.193469, -0.874454, -0.828460>, <1.210128, -0.866099, -0.806659>, <1.183109, -0.864577, -0.761803>, <1.206720, -0.857895, -0.747182>, 
      <1.193469, -0.874454, -0.828460>, <1.199257, -0.864107, -0.802473>, <1.156022, -0.859613, -0.751371>, <1.179633, -0.852932, -0.736750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.110934, -0.951297, -0.866890>, <1.116391, -0.941888, -0.869588>, <1.121920, -0.928483, -0.876651>, <1.129125, -0.919933, -0.875885>, 
      <1.110057, -0.915083, -0.820980>, <1.115514, -0.905674, -0.823678>, <1.095963, -0.915221, -0.845155>, <1.103168, -0.906671, -0.844389>, 
      <1.068462, -0.856054, -0.748599>, <1.076245, -0.855859, -0.762500>, <1.093274, -0.875274, -0.753819>, <1.100827, -0.883066, -0.765484>, 
      <1.108011, -0.830583, -0.713855>, <1.115793, -0.830388, -0.727756>, <1.126082, -0.858890, -0.731529>, <1.133635, -0.866682, -0.743194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.110934, -0.951297, -0.866890>, <1.160626, -0.947535, -0.872916>, <1.226883, -0.942518, -0.880950>, <1.276575, -0.938756, -0.886976>, 
      <1.116391, -0.941888, -0.869588>, <1.166084, -0.938125, -0.875614>, <1.215776, -0.937131, -0.876372>, <1.265468, -0.933369, -0.882397>, 
      <1.121920, -0.928483, -0.876651>, <1.141973, -0.938728, -0.900983>, <1.220907, -0.939542, -0.898494>, <1.246253, -0.926885, -0.881274>, 
      <1.129125, -0.919933, -0.875885>, <1.149177, -0.930178, -0.900217>, <1.214207, -0.933455, -0.888934>, <1.239552, -0.920798, -0.871714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.276692, -0.844540, -0.721270>, <1.270227, -0.848279, -0.741970>, <1.261606, -0.853263, -0.769570>, <1.255141, -0.857002, -0.790270>, 
      <1.276657, -0.872805, -0.770982>, <1.270192, -0.876543, -0.791682>, <1.256930, -0.872402, -0.794003>, <1.250464, -0.876141, -0.814703>, 
      <1.276610, -0.910491, -0.837264>, <1.265503, -0.905104, -0.832686>, <1.270248, -0.914902, -0.864972>, <1.263548, -0.908815, -0.855411>, 
      <1.276575, -0.938756, -0.886976>, <1.265468, -0.933369, -0.882397>, <1.246253, -0.926885, -0.881274>, <1.239552, -0.920798, -0.871714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.276692, -0.844540, -0.721270>, <1.226088, -0.840353, -0.719046>, <1.142383, -0.808446, -0.683659>, <1.108011, -0.830583, -0.713855>, 
      <1.270227, -0.848279, -0.741970>, <1.219622, -0.844091, -0.739745>, <1.150165, -0.808251, -0.697561>, <1.115793, -0.830388, -0.727756>, 
      <1.261606, -0.853263, -0.769570>, <1.225154, -0.856167, -0.755447>, <1.156050, -0.843924, -0.711168>, <1.126082, -0.858890, -0.731529>, 
      <1.255141, -0.857002, -0.790270>, <1.218689, -0.859906, -0.776147>, <1.163603, -0.851716, -0.722834>, <1.133635, -0.866682, -0.743194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.292567, -0.882447, -0.643728>, <1.295720, -0.864835, -0.663042>, <1.281455, -0.855912, -0.698007>, <1.276692, -0.844540, -0.721270>, 
      <1.335569, -0.920150, -0.684055>, <1.338723, -0.902539, -0.703368>, <1.281419, -0.884177, -0.747719>, <1.276657, -0.872805, -0.770982>, 
      <1.312367, -1.005824, -0.774170>, <1.315943, -0.982039, -0.801582>, <1.273465, -0.940000, -0.816066>, <1.276610, -0.910491, -0.837264>, 
      <1.266092, -1.037118, -0.816316>, <1.269669, -1.013332, -0.843728>, <1.273430, -0.968265, -0.865778>, <1.276575, -0.938756, -0.886976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.073424, -0.868191, -0.635637>, <1.083800, -0.856909, -0.659102>, <1.094321, -0.830926, -0.689400>, <1.108011, -0.830583, -0.713855>, 
      <1.139167, -0.872468, -0.638064>, <1.149543, -0.861185, -0.661530>, <1.128693, -0.808789, -0.659204>, <1.142383, -0.808446, -0.683659>, 
      <1.252055, -0.846927, -0.605737>, <1.255208, -0.829315, -0.625050>, <1.230850, -0.851725, -0.695783>, <1.226088, -0.840353, -0.719046>, 
      <1.292567, -0.882447, -0.643728>, <1.295720, -0.864835, -0.663042>, <1.281455, -0.855912, -0.698007>, <1.276692, -0.844540, -0.721270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.086819, -1.021585, -0.831120>, <1.092656, -1.005220, -0.848734>, <1.103700, -0.972383, -0.856159>, <1.110934, -0.951297, -0.866890>, 
      <1.040944, -0.981363, -0.788100>, <1.046781, -0.964998, -0.805714>, <1.102823, -0.936169, -0.810249>, <1.110057, -0.915083, -0.820980>, 
      <1.077443, -0.914209, -0.694282>, <1.087819, -0.902927, -0.717747>, <1.054772, -0.856397, -0.724144>, <1.068462, -0.856054, -0.748599>, 
      <1.073424, -0.868191, -0.635637>, <1.083800, -0.856909, -0.659102>, <1.094321, -0.830926, -0.689400>, <1.108011, -0.830583, -0.713855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.086819, -1.021585, -0.831120>, <1.120104, -1.050769, -0.862334>, <1.230274, -1.061340, -0.848939>, <1.266092, -1.037118, -0.816316>, 
      <1.092656, -1.005220, -0.848734>, <1.125941, -1.034404, -0.879948>, <1.233850, -1.037554, -0.876351>, <1.269669, -1.013332, -0.843728>, 
      <1.103700, -0.972383, -0.856159>, <1.153392, -0.968621, -0.862185>, <1.223738, -0.972027, -0.859752>, <1.273430, -0.968265, -0.865778>, 
      <1.110934, -0.951297, -0.866890>, <1.160626, -0.947535, -0.872916>, <1.226883, -0.942518, -0.880950>, <1.276575, -0.938756, -0.886976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.261380, -0.930061, -0.627484>, <1.270736, -0.915777, -0.632357>, <1.290440, -0.894326, -0.630701>, <1.292567, -0.882447, -0.643728>, 
      <1.296377, -0.961355, -0.652153>, <1.305733, -0.947071, -0.657026>, <1.333442, -0.932029, -0.671028>, <1.335569, -0.920150, -0.684055>, 
      <1.296602, -1.034581, -0.720750>, <1.298886, -1.027985, -0.741161>, <1.310251, -1.019894, -0.757955>, <1.312367, -1.005824, -0.774170>, 
      <1.258478, -1.059105, -0.748278>, <1.260762, -1.052509, -0.768689>, <1.263976, -1.051188, -0.800101>, <1.266092, -1.037118, -0.816316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.088240, -0.906878, -0.628278>, <1.083795, -0.895272, -0.630486>, <1.077869, -0.879797, -0.633429>, <1.073424, -0.868191, -0.635637>, 
      <1.125912, -0.882644, -0.601076>, <1.121467, -0.871038, -0.603284>, <1.143612, -0.884074, -0.635857>, <1.139167, -0.872468, -0.638064>, 
      <1.226798, -0.899138, -0.603107>, <1.236154, -0.884853, -0.607981>, <1.249928, -0.858805, -0.592710>, <1.252055, -0.846927, -0.605737>, 
      <1.261380, -0.930061, -0.627484>, <1.270736, -0.915777, -0.632357>, <1.290440, -0.894326, -0.630701>, <1.292567, -0.882447, -0.643728>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.075965, -1.049335, -0.761368>, <1.079221, -1.041010, -0.782294>, <1.081451, -1.036636, -0.814920>, <1.086819, -1.021585, -0.831120>, 
      <1.037294, -1.014756, -0.734109>, <1.040551, -1.006431, -0.755035>, <1.035576, -0.996414, -0.771900>, <1.040944, -0.981363, -0.788100>, 
      <1.046114, -0.933977, -0.658696>, <1.041669, -0.922371, -0.660904>, <1.081887, -0.925815, -0.692074>, <1.077443, -0.914209, -0.694282>, 
      <1.088240, -0.906878, -0.628278>, <1.083795, -0.895272, -0.630486>, <1.077869, -0.879797, -0.633429>, <1.073424, -0.868191, -0.635637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.075965, -1.049335, -0.761368>, <1.112241, -1.081773, -0.786939>, <1.218961, -1.084526, -0.776812>, <1.258478, -1.059105, -0.748278>, 
      <1.079221, -1.041010, -0.782294>, <1.115497, -1.073448, -0.807864>, <1.221245, -1.077930, -0.797224>, <1.260762, -1.052509, -0.768689>, 
      <1.081451, -1.036636, -0.814920>, <1.114736, -1.065820, -0.846134>, <1.228158, -1.075410, -0.832724>, <1.263976, -1.051188, -0.800101>, 
      <1.086819, -1.021585, -0.831120>, <1.120104, -1.050769, -0.862334>, <1.230274, -1.061340, -0.848939>, <1.266092, -1.037118, -0.816316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.145497, -1.130423, -0.970161>, <0.128425, -1.137386, -0.972287>, <0.128559, -1.092820, -0.956951>, <0.121300, -1.076705, -0.951290>, 
      <0.168470, -1.145451, -0.974496>, <0.151399, -1.152415, -0.976622>, <0.122019, -1.106416, -0.958817>, <0.114760, -1.090301, -0.953156>, 
      <0.198353, -1.092948, -0.972862>, <0.161901, -1.106489, -0.967909>, <0.136674, -1.132263, -0.963600>, <0.106706, -1.109920, -0.951796>, 
      <0.221005, -1.076887, -0.974019>, <0.184553, -1.090428, -0.969066>, <0.129467, -1.144367, -0.969314>, <0.099499, -1.122024, -0.957510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.117474, -0.998599, -0.939145>, <0.095636, -1.007507, -0.941864>, <0.120152, -1.053273, -0.947646>, <0.121300, -1.076705, -0.951290>, 
      <0.110941, -0.993156, -0.935287>, <0.089103, -1.002064, -0.938006>, <0.113612, -1.066869, -0.949512>, <0.114760, -1.090301, -0.953156>, 
      <0.100992, -0.987812, -0.914296>, <0.075035, -1.017723, -0.939815>, <0.073897, -1.085460, -0.938874>, <0.106706, -1.109920, -0.951796>, 
      <0.094989, -0.986131, -0.907344>, <0.069032, -1.016043, -0.932863>, <0.066691, -1.097564, -0.944588>, <0.099499, -1.122024, -0.957510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.191347, -1.048133, -0.942568>, <0.195568, -1.029773, -0.936672>, <0.195370, -1.002455, -0.929830>, <0.205416, -0.990129, -0.905874>, 
      <0.177592, -1.072820, -0.950846>, <0.181813, -1.054460, -0.944950>, <0.219365, -1.020345, -0.939281>, <0.229412, -1.004824, -0.932366>, 
      <0.172584, -1.119374, -0.966788>, <0.195558, -1.134403, -0.971123>, <0.193676, -1.065962, -0.957530>, <0.216328, -1.049901, -0.958688>, 
      <0.145497, -1.130423, -0.970161>, <0.168470, -1.145451, -0.974496>, <0.198353, -1.092948, -0.972862>, <0.221005, -1.076887, -0.974019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.191347, -1.048133, -0.942568>, <0.169185, -1.033273, -0.941541>, <0.142036, -0.988580, -0.936087>, <0.117474, -0.998599, -0.939145>, 
      <0.195568, -1.029773, -0.936672>, <0.173406, -1.014913, -0.935645>, <0.135503, -0.986333, -0.915188>, <0.110941, -0.993156, -0.935287>, 
      <0.195370, -1.002455, -0.929830>, <0.170025, -0.986754, -0.902806>, <0.121044, -0.962236, -0.907746>, <0.100992, -0.987812, -0.914296>, 
      <0.205416, -0.990129, -0.905874>, <0.180071, -0.971233, -0.895891>, <0.115041, -0.960556, -0.900794>, <0.094989, -0.986131, -0.907344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -1.036543, -0.962382>, <0.165121, -1.063771, -0.968788>, <0.121886, -1.114978, -0.965706>, <0.145497, -1.130423, -0.970161>, 
      <0.155619, -1.019074, -0.958272>, <0.161407, -1.046301, -0.964678>, <0.104815, -1.121941, -0.967832>, <0.128425, -1.137386, -0.972287>, 
      <0.130296, -1.009282, -0.946717>, <0.108458, -1.018189, -0.949436>, <0.127411, -1.069389, -0.953308>, <0.128559, -1.092820, -0.956951>, 
      <0.117474, -0.998599, -0.939145>, <0.095636, -1.007507, -0.941864>, <0.120152, -1.053273, -0.947646>, <0.121300, -1.076705, -0.951290>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -1.036543, -0.962382>, <0.165121, -1.063771, -0.968788>, <0.121886, -1.114978, -0.965706>, <0.145497, -1.130423, -0.970161>, 
      <0.155619, -1.019074, -0.958272>, <0.161407, -1.046301, -0.964678>, <0.148973, -1.103929, -0.962333>, <0.172584, -1.119374, -0.966788>, 
      <0.130296, -1.009282, -0.946717>, <0.154859, -0.999263, -0.943659>, <0.155430, -1.057960, -0.949819>, <0.177592, -1.072820, -0.950846>, 
      <0.117474, -0.998599, -0.939145>, <0.142036, -0.988580, -0.936087>, <0.169185, -1.033273, -0.941541>, <0.191347, -1.048133, -0.942568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -1.036543, -0.962382>, <0.165121, -1.063771, -0.968788>, <0.121886, -1.114978, -0.965706>, <0.145497, -1.130423, -0.970161>, 
      <0.159333, -1.036543, -0.962382>, <0.149554, -1.070121, -0.970727>, <0.104815, -1.121941, -0.967832>, <0.128425, -1.137386, -0.972287>, 
      <0.159333, -1.036543, -0.962382>, <0.149554, -1.070121, -0.970727>, <0.139969, -1.080772, -0.960279>, <0.128559, -1.092820, -0.956951>, 
      <0.159333, -1.036543, -0.962382>, <0.143765, -1.042893, -0.964320>, <0.132710, -1.064656, -0.954618>, <0.121300, -1.076705, -0.951290>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -1.036543, -0.962382>, <0.155619, -1.019074, -0.958272>, <0.130296, -1.009282, -0.946717>, <0.117474, -0.998599, -0.939145>, 
      <0.159333, -1.036543, -0.962382>, <0.140052, -1.025423, -0.960210>, <0.108458, -1.018189, -0.949436>, <0.095636, -1.007507, -0.941864>, 
      <0.159333, -1.036543, -0.962382>, <0.140052, -1.025423, -0.960210>, <0.131562, -1.041225, -0.950974>, <0.120152, -1.053273, -0.947646>, 
      <0.159333, -1.036543, -0.962382>, <0.143765, -1.042893, -0.964320>, <0.132710, -1.064656, -0.954618>, <0.121300, -1.076705, -0.951290>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -1.036543, -0.962382>, <0.143765, -1.042893, -0.964320>, <0.132710, -1.064656, -0.954618>, <0.121300, -1.076705, -0.951290>, 
      <0.170204, -1.032109, -0.961028>, <0.154636, -1.038459, -0.962967>, <0.131562, -1.041225, -0.950974>, <0.120152, -1.053273, -0.947646>, 
      <0.181743, -1.044656, -0.948512>, <0.159581, -1.029796, -0.947485>, <0.120198, -0.997488, -0.938806>, <0.095636, -1.007507, -0.941864>, 
      <0.191347, -1.048133, -0.942568>, <0.169185, -1.033273, -0.941541>, <0.142036, -0.988580, -0.936087>, <0.117474, -0.998599, -0.939145>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -1.036543, -0.962382>, <0.155619, -1.019074, -0.958272>, <0.130296, -1.009282, -0.946717>, <0.117474, -0.998599, -0.939145>, 
      <0.159333, -1.036543, -0.962382>, <0.166490, -1.014639, -0.956918>, <0.154859, -0.999263, -0.943659>, <0.142036, -0.988580, -0.936087>, 
      <0.159333, -1.036543, -0.962382>, <0.166490, -1.014639, -0.956918>, <0.159581, -1.029796, -0.947485>, <0.169185, -1.033273, -0.941541>, 
      <0.159333, -1.036543, -0.962382>, <0.170204, -1.032109, -0.961028>, <0.181743, -1.044656, -0.948512>, <0.191347, -1.048133, -0.942568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -1.036543, -0.962382>, <0.143765, -1.042893, -0.964320>, <0.132710, -1.064656, -0.954618>, <0.121300, -1.076705, -0.951290>, 
      <0.170204, -1.032109, -0.961028>, <0.154636, -1.038459, -0.962967>, <0.139969, -1.080772, -0.960279>, <0.128559, -1.092820, -0.956951>, 
      <0.181743, -1.044656, -0.948512>, <0.167988, -1.069343, -0.956790>, <0.155513, -1.126338, -0.968914>, <0.128425, -1.137386, -0.972287>, 
      <0.191347, -1.048133, -0.942568>, <0.177592, -1.072820, -0.950846>, <0.172584, -1.119374, -0.966788>, <0.145497, -1.130423, -0.970161>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159333, -1.036543, -0.962382>, <0.170204, -1.032109, -0.961028>, <0.181743, -1.044656, -0.948512>, <0.191347, -1.048133, -0.942568>, 
      <0.159333, -1.036543, -0.962382>, <0.175992, -1.059336, -0.967435>, <0.167988, -1.069343, -0.956790>, <0.177592, -1.072820, -0.950846>, 
      <0.159333, -1.036543, -0.962382>, <0.175992, -1.059336, -0.967435>, <0.148973, -1.103929, -0.962333>, <0.172584, -1.119374, -0.966788>, 
      <0.159333, -1.036543, -0.962382>, <0.165121, -1.063771, -0.968788>, <0.121886, -1.114978, -0.965706>, <0.145497, -1.130423, -0.970161>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.076798, -0.987213, -0.892039>, <0.082255, -0.989125, -0.884702>, <0.087784, -0.984114, -0.899000>, <0.094989, -0.986131, -0.907344>, 
      <0.075921, -1.037957, -0.921095>, <0.081378, -1.036674, -0.930799>, <0.061827, -1.014026, -0.924520>, <0.069032, -1.016043, -0.932863>, 
      <0.034327, -1.118243, -0.968817>, <0.042109, -1.104523, -0.971058>, <0.059138, -1.110250, -0.950576>, <0.066691, -1.097564, -0.944588>, 
      <0.073875, -1.156360, -0.988893>, <0.081657, -1.142639, -0.991134>, <0.091946, -1.134710, -0.963499>, <0.099499, -1.122024, -0.957510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.076798, -0.987213, -0.892039>, <0.126490, -0.981807, -0.896648>, <0.192747, -0.977795, -0.885751>, <0.242439, -0.972389, -0.890360>, 
      <0.082255, -0.989125, -0.884702>, <0.131948, -0.983719, -0.889310>, <0.181640, -0.983117, -0.890406>, <0.231332, -0.977711, -0.895014>, 
      <0.087784, -0.984114, -0.899000>, <0.107837, -0.958539, -0.892451>, <0.186771, -0.960880, -0.891279>, <0.212117, -0.979776, -0.901262>, 
      <0.094989, -0.986131, -0.907344>, <0.115041, -0.960556, -0.900794>, <0.180071, -0.971233, -0.895891>, <0.205416, -0.990129, -0.905874>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.242556, -1.146970, -0.976181>, <0.236091, -1.125945, -0.975532>, <0.227470, -1.097912, -0.974668>, <0.221005, -1.076887, -0.974019>, 
      <0.242521, -1.093637, -0.955547>, <0.236056, -1.072612, -0.954898>, <0.222794, -1.070926, -0.959336>, <0.216328, -1.049901, -0.958688>, 
      <0.242474, -1.022527, -0.928035>, <0.231367, -1.027849, -0.932689>, <0.236112, -0.994471, -0.927754>, <0.229412, -1.004824, -0.932366>, 
      <0.242439, -0.972389, -0.890360>, <0.231332, -0.977711, -0.895014>, <0.212117, -0.979776, -0.901262>, <0.205416, -0.990129, -0.905874>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.242556, -1.146970, -0.976181>, <0.191952, -1.149787, -0.979995>, <0.108247, -1.189488, -1.006341>, <0.073875, -1.156360, -0.988893>, 
      <0.236091, -1.125945, -0.975532>, <0.185486, -1.128762, -0.979346>, <0.116029, -1.175767, -1.008581>, <0.081657, -1.142639, -0.991134>, 
      <0.227470, -1.097912, -0.974668>, <0.191019, -1.111453, -0.969715>, <0.121914, -1.157053, -0.975302>, <0.091946, -1.134710, -0.963499>, 
      <0.221005, -1.076887, -0.974019>, <0.184553, -1.090428, -0.969066>, <0.129467, -1.144367, -0.969314>, <0.099499, -1.122024, -0.957510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.258431, -1.218083, -0.927265>, <0.261584, -1.201574, -0.947530>, <0.247319, -1.168304, -0.961506>, <0.242556, -1.146970, -0.976181>, 
      <0.301433, -1.172643, -0.895913>, <0.304587, -1.156133, -0.916178>, <0.247283, -1.114971, -0.940872>, <0.242521, -1.093637, -0.955547>, 
      <0.278231, -1.070890, -0.824448>, <0.281808, -1.047281, -0.852012>, <0.239329, -1.039147, -0.895726>, <0.242474, -1.022527, -0.928035>, 
      <0.231956, -1.024594, -0.799704>, <0.235533, -1.000984, -0.827268>, <0.239294, -0.985814, -0.875092>, <0.242439, -0.972389, -0.890360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.039288, -1.228185, -0.940174>, <0.049664, -1.206638, -0.954790>, <0.060185, -1.180498, -0.984951>, <0.073875, -1.156360, -0.988893>, 
      <0.105031, -1.225154, -0.936301>, <0.115407, -1.203607, -0.950917>, <0.094557, -1.213625, -1.002399>, <0.108247, -1.189488, -1.006341>, 
      <0.217918, -1.260892, -0.956802>, <0.221072, -1.244383, -0.977067>, <0.196714, -1.171121, -0.965320>, <0.191952, -1.149787, -0.979995>, 
      <0.258431, -1.218083, -0.927265>, <0.261584, -1.201574, -0.947530>, <0.247319, -1.168304, -0.961506>, <0.242556, -1.146970, -0.976181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.052683, -1.012240, -0.817248>, <0.058520, -0.997229, -0.836029>, <0.069564, -0.994721, -0.869602>, <0.076798, -0.987213, -0.892039>, 
      <0.006808, -1.060716, -0.850694>, <0.012645, -1.045704, -0.869475>, <0.068687, -1.045465, -0.898658>, <0.075921, -1.037957, -0.921095>, 
      <0.043306, -1.163402, -0.903296>, <0.053683, -1.141854, -0.917912>, <0.020636, -1.142381, -0.964876>, <0.034327, -1.118243, -0.968817>, 
      <0.039288, -1.228185, -0.940174>, <0.049664, -1.206638, -0.954790>, <0.060185, -1.180498, -0.984951>, <0.073875, -1.156360, -0.988893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.052683, -1.012240, -0.817248>, <0.085968, -0.977068, -0.792980>, <0.196138, -0.988759, -0.780551>, <0.231956, -1.024594, -0.799704>, 
      <0.058520, -0.997229, -0.836029>, <0.091805, -0.962056, -0.811762>, <0.199714, -0.965149, -0.808115>, <0.235533, -1.000984, -0.827268>, 
      <0.069564, -0.994721, -0.869602>, <0.119256, -0.989315, -0.874210>, <0.189602, -0.991220, -0.870483>, <0.239294, -0.985814, -0.875092>, 
      <0.076798, -0.987213, -0.892039>, <0.126490, -0.981807, -0.896648>, <0.192747, -0.977795, -0.885751>, <0.242439, -0.972389, -0.890360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.227244, -1.227136, -0.877778>, <0.236600, -1.224420, -0.892624>, <0.256304, -1.229218, -0.913597>, <0.258431, -1.218083, -0.927265>, 
      <0.262241, -1.198126, -0.850459>, <0.271597, -1.195410, -0.865305>, <0.299306, -1.183778, -0.882245>, <0.301433, -1.172643, -0.895913>, 
      <0.262466, -1.119492, -0.788137>, <0.264750, -1.100274, -0.797668>, <0.276115, -1.084856, -0.808143>, <0.278231, -1.070890, -0.824448>, 
      <0.224342, -1.088651, -0.767935>, <0.226626, -1.069434, -0.777466>, <0.229840, -1.038559, -0.783399>, <0.231956, -1.024594, -0.799704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.054104, -1.229765, -0.900825>, <0.049659, -1.229291, -0.912630>, <0.043733, -1.228659, -0.928369>, <0.039288, -1.228185, -0.940174>, 
      <0.091776, -1.260240, -0.920787>, <0.087331, -1.259766, -0.932592>, <0.109476, -1.225628, -0.924497>, <0.105031, -1.225154, -0.936301>, 
      <0.192662, -1.255802, -0.904773>, <0.202018, -1.253086, -0.919619>, <0.215792, -1.272027, -0.943134>, <0.217918, -1.260892, -0.956802>, 
      <0.227244, -1.227136, -0.877778>, <0.236600, -1.224420, -0.892624>, <0.256304, -1.229218, -0.913597>, <0.258431, -1.218083, -0.927265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.041829, -1.077143, -0.779526>, <0.045085, -1.057672, -0.790843>, <0.047315, -1.026046, -0.799975>, <0.052683, -1.012240, -0.817248>, 
      <0.003158, -1.109198, -0.809713>, <0.006415, -1.089727, -0.821029>, <0.001440, -1.074522, -0.833421>, <0.006808, -1.060716, -0.850694>, 
      <0.011978, -1.195687, -0.878502>, <0.007533, -1.195213, -0.890307>, <0.047751, -1.163876, -0.891491>, <0.043306, -1.163402, -0.903296>, 
      <0.054104, -1.229765, -0.900825>, <0.049659, -1.229291, -0.912630>, <0.043733, -1.228659, -0.928369>, <0.039288, -1.228185, -0.940174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.041829, -1.077143, -0.779526>, <0.078105, -1.047073, -0.751209>, <0.184825, -1.056683, -0.746995>, <0.224342, -1.088651, -0.767935>, 
      <0.045085, -1.057672, -0.790843>, <0.081361, -1.027602, -0.762525>, <0.187109, -1.037466, -0.756525>, <0.226626, -1.069434, -0.777466>, 
      <0.047315, -1.026046, -0.799975>, <0.080600, -0.990874, -0.775707>, <0.194022, -1.002724, -0.764247>, <0.229840, -1.038559, -0.783399>, 
      <0.052683, -1.012240, -0.817248>, <0.085968, -0.977068, -0.792980>, <0.196138, -0.988759, -0.780551>, <0.231956, -1.024594, -0.799704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.186326, -1.918286, -1.313390>, <0.186326, -1.974247, -1.335914>, <0.169211, -2.037118, -1.379065>, <0.108887, -2.037118, -1.379065>, 
      <0.186326, -1.910617, -1.328727>, <0.186326, -1.966578, -1.351251>, <0.169211, -2.014112, -1.407822>, <0.108887, -2.014112, -1.407822>, 
      <0.191462, -1.899689, -1.349710>, <0.191462, -1.953199, -1.372698>, <0.167126, -1.989931, -1.452874>, <0.108887, -1.989931, -1.452874>, 
      <0.186326, -1.892724, -1.364513>, <0.186326, -1.946234, -1.387502>, <0.167126, -1.960433, -1.474921>, <0.108887, -1.960433, -1.474921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.108887, -1.837796, -1.298840>, <0.152358, -1.837796, -1.298840>, <0.186326, -1.877959, -1.297159>, <0.186326, -1.918286, -1.313390>, 
      <0.108887, -1.817129, -1.326979>, <0.152358, -1.817129, -1.326979>, <0.186326, -1.870290, -1.312496>, <0.186326, -1.910617, -1.328727>, 
      <0.108887, -1.789573, -1.364499>, <0.132119, -1.826718, -1.356061>, <0.191462, -1.846952, -1.327053>, <0.191462, -1.899689, -1.349710>, 
      <0.108887, -1.768906, -1.392638>, <0.132119, -1.806051, -1.384200>, <0.186326, -1.839987, -1.341856>, <0.186326, -1.892724, -1.364513>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.031448, -1.918286, -1.313390>, <0.031448, -1.877959, -1.297159>, <0.065416, -1.837796, -1.298840>, <0.108887, -1.837796, -1.298840>, 
      <0.031448, -1.910617, -1.328727>, <0.031448, -1.870290, -1.312496>, <0.065416, -1.817129, -1.326979>, <0.108887, -1.817129, -1.326979>, 
      <0.027304, -1.900168, -1.349632>, <0.027304, -1.847431, -1.326976>, <0.085655, -1.826718, -1.356061>, <0.108887, -1.789573, -1.364499>, 
      <0.031448, -1.892724, -1.364513>, <0.031448, -1.839987, -1.341856>, <0.085655, -1.806051, -1.384200>, <0.108887, -1.768906, -1.392638>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.031448, -1.918286, -1.313390>, <0.031448, -1.910617, -1.328727>, <0.027304, -1.900168, -1.349632>, <0.031448, -1.892724, -1.364513>, 
      <0.031448, -1.974247, -1.335914>, <0.031448, -1.966578, -1.351251>, <0.027304, -1.953678, -1.372621>, <0.031448, -1.946234, -1.387502>, 
      <0.048563, -2.037118, -1.379065>, <0.048563, -2.014112, -1.407822>, <0.050648, -1.989931, -1.452874>, <0.050648, -1.960433, -1.474921>, 
      <0.108887, -2.037118, -1.379065>, <0.108887, -2.014112, -1.407822>, <0.108887, -1.989931, -1.452874>, <0.108887, -1.960433, -1.474921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.146591, -1.864403, -1.427908>, <0.158082, -1.873697, -1.408999>, <0.179137, -1.882975, -1.385232>, <0.186326, -1.892724, -1.364513>, 
      <0.146736, -1.878350, -1.456365>, <0.158227, -1.887645, -1.437456>, <0.179137, -1.936485, -1.408220>, <0.186326, -1.946234, -1.387502>, 
      <0.137900, -1.881984, -1.489212>, <0.137900, -1.907538, -1.481675>, <0.167126, -1.939093, -1.490871>, <0.167126, -1.960433, -1.474921>, 
      <0.108887, -1.875254, -1.500045>, <0.108887, -1.900808, -1.492508>, <0.108887, -1.939093, -1.490871>, <0.108887, -1.960433, -1.474921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.108203, -1.809396, -1.365673>, <0.108408, -1.797249, -1.373763>, <0.108682, -1.781053, -1.384548>, <0.108887, -1.768906, -1.392638>, 
      <0.140532, -1.816895, -1.353602>, <0.140737, -1.804748, -1.361692>, <0.131913, -1.818198, -1.376111>, <0.132119, -1.806051, -1.384200>, 
      <0.146430, -1.848861, -1.396198>, <0.157921, -1.858156, -1.377289>, <0.179137, -1.830238, -1.362575>, <0.186326, -1.839987, -1.341856>, 
      <0.146591, -1.864403, -1.427908>, <0.158082, -1.873697, -1.408999>, <0.179137, -1.882975, -1.385232>, <0.186326, -1.892724, -1.364513>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.108203, -1.809396, -1.365673>, <0.108408, -1.829153, -1.405985>, <0.108682, -1.855497, -1.459733>, <0.108887, -1.875254, -1.500045>, 
      <0.108203, -1.809396, -1.365673>, <0.140737, -1.836653, -1.393914>, <0.137694, -1.862227, -1.448901>, <0.137900, -1.881984, -1.489212>, 
      <0.108203, -1.809396, -1.365673>, <0.140737, -1.836653, -1.393914>, <0.146574, -1.862809, -1.424655>, <0.146736, -1.878350, -1.456365>, 
      <0.108203, -1.809396, -1.365673>, <0.140532, -1.816895, -1.353602>, <0.146430, -1.848861, -1.396198>, <0.146591, -1.864403, -1.427908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.071183, -1.846910, -1.456064>, <0.055088, -1.865608, -1.434231>, <0.039410, -1.878421, -1.393103>, <0.031448, -1.892724, -1.364513>, 
      <0.070998, -1.829138, -1.419803>, <0.054903, -1.847836, -1.397970>, <0.039410, -1.825684, -1.370446>, <0.031448, -1.839987, -1.341856>, 
      <0.071235, -1.800820, -1.379476>, <0.071440, -1.788673, -1.387566>, <0.085450, -1.818198, -1.376111>, <0.085655, -1.806051, -1.384200>, 
      <0.108203, -1.809396, -1.365673>, <0.108408, -1.797249, -1.373763>, <0.108682, -1.781053, -1.384548>, <0.108887, -1.768906, -1.392638>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.071183, -1.846910, -1.456064>, <0.071297, -1.857864, -1.478414>, <0.086101, -1.869968, -1.508553>, <0.108887, -1.875254, -1.500045>, 
      <0.055088, -1.865608, -1.434231>, <0.055201, -1.876562, -1.456581>, <0.086101, -1.895522, -1.501016>, <0.108887, -1.900808, -1.492508>, 
      <0.039410, -1.878421, -1.393103>, <0.039410, -1.931931, -1.416091>, <0.050648, -1.939093, -1.490871>, <0.108887, -1.939093, -1.490871>, 
      <0.031448, -1.892724, -1.364513>, <0.031448, -1.946234, -1.387502>, <0.050648, -1.960433, -1.474921>, <0.108887, -1.960433, -1.474921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.071183, -1.846910, -1.456064>, <0.071297, -1.857864, -1.478414>, <0.086101, -1.869968, -1.508553>, <0.108887, -1.875254, -1.500045>, 
      <0.071183, -1.846910, -1.456064>, <0.071112, -1.840092, -1.442153>, <0.085896, -1.850211, -1.468241>, <0.108682, -1.855497, -1.459733>, 
      <0.071183, -1.846910, -1.456064>, <0.071112, -1.840092, -1.442153>, <0.071440, -1.820578, -1.419788>, <0.108408, -1.829153, -1.405985>, 
      <0.071183, -1.846910, -1.456064>, <0.070998, -1.829138, -1.419803>, <0.071235, -1.800820, -1.379476>, <0.108203, -1.809396, -1.365673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.123912, -1.842242, -1.467218>, <0.130716, -1.848890, -1.455425>, <0.139337, -1.858535, -1.439846>, <0.146591, -1.864403, -1.427908>, 
      <0.123912, -1.841974, -1.480609>, <0.130716, -1.848622, -1.468816>, <0.139481, -1.872483, -1.468303>, <0.146736, -1.878350, -1.456365>, 
      <0.115200, -1.821458, -1.460973>, <0.116359, -1.839133, -1.474808>, <0.136740, -1.864309, -1.475378>, <0.137900, -1.881984, -1.489212>, 
      <0.105023, -1.816337, -1.453930>, <0.106182, -1.834012, -1.467764>, <0.107728, -1.857579, -1.486211>, <0.108887, -1.875254, -1.500045>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.123912, -1.842242, -1.467218>, <0.123912, -1.842815, -1.438549>, <0.126810, -1.828383, -1.414862>, <0.105023, -1.817420, -1.399784>, 
      <0.130716, -1.848890, -1.455425>, <0.130716, -1.849464, -1.426756>, <0.127764, -1.825976, -1.404629>, <0.105977, -1.815013, -1.389551>, 
      <0.139337, -1.858535, -1.439846>, <0.139175, -1.842994, -1.408136>, <0.139577, -1.819303, -1.363835>, <0.107249, -1.811803, -1.375906>, 
      <0.146591, -1.864403, -1.427908>, <0.146430, -1.848861, -1.396198>, <0.140532, -1.816895, -1.353602>, <0.108203, -1.809396, -1.365673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.089716, -1.825035, -1.443552>, <0.084156, -1.831597, -1.447306>, <0.075768, -1.841584, -1.462283>, <0.071183, -1.846910, -1.456064>, 
      <0.089716, -1.825398, -1.425421>, <0.084156, -1.831960, -1.429174>, <0.075583, -1.823812, -1.426022>, <0.070998, -1.829138, -1.419803>, 
      <0.091244, -1.810487, -1.390248>, <0.092198, -1.808079, -1.380015>, <0.070281, -1.803227, -1.389710>, <0.071235, -1.800820, -1.379476>, 
      <0.105023, -1.817420, -1.399784>, <0.105977, -1.815013, -1.389551>, <0.107249, -1.811803, -1.375906>, <0.108203, -1.809396, -1.365673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.089716, -1.825035, -1.443552>, <0.089716, -1.824877, -1.451438>, <0.099030, -1.813321, -1.449783>, <0.105023, -1.816337, -1.453930>, 
      <0.084156, -1.831597, -1.447306>, <0.084156, -1.831440, -1.455191>, <0.100189, -1.830997, -1.463617>, <0.106182, -1.834012, -1.467764>, 
      <0.075768, -1.841584, -1.462283>, <0.075882, -1.852538, -1.484633>, <0.084942, -1.852293, -1.494718>, <0.107728, -1.857579, -1.486211>, 
      <0.071183, -1.846910, -1.456064>, <0.071297, -1.857864, -1.478414>, <0.086101, -1.869968, -1.508553>, <0.108887, -1.875254, -1.500045>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.179633, -1.130423, -0.970161>, <1.162561, -1.137386, -0.972287>, <1.162695, -1.092820, -0.956951>, <1.155436, -1.076705, -0.951290>, 
      <1.202606, -1.145451, -0.974496>, <1.185535, -1.152415, -0.976622>, <1.156155, -1.106416, -0.958817>, <1.148896, -1.090301, -0.953156>, 
      <1.232489, -1.092948, -0.972862>, <1.196037, -1.106489, -0.967909>, <1.170810, -1.132263, -0.963600>, <1.140842, -1.109920, -0.951796>, 
      <1.255141, -1.076887, -0.974019>, <1.218689, -1.090428, -0.969066>, <1.163603, -1.144367, -0.969314>, <1.133635, -1.122024, -0.957510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151610, -0.998599, -0.939145>, <1.129772, -1.007507, -0.941864>, <1.154288, -1.053273, -0.947646>, <1.155436, -1.076705, -0.951290>, 
      <1.145077, -0.993156, -0.935287>, <1.123239, -1.002064, -0.938006>, <1.147748, -1.066869, -0.949512>, <1.148896, -1.090301, -0.953156>, 
      <1.135128, -0.987812, -0.914296>, <1.109171, -1.017723, -0.939815>, <1.108033, -1.085460, -0.938874>, <1.140842, -1.109920, -0.951796>, 
      <1.129125, -0.986131, -0.907344>, <1.103168, -1.016043, -0.932863>, <1.100827, -1.097564, -0.944588>, <1.133635, -1.122024, -0.957510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.225483, -1.048133, -0.942568>, <1.229704, -1.029773, -0.936672>, <1.229506, -1.002455, -0.929830>, <1.239552, -0.990129, -0.905874>, 
      <1.211728, -1.072820, -0.950846>, <1.215949, -1.054460, -0.944950>, <1.253501, -1.020345, -0.939281>, <1.263548, -1.004824, -0.932366>, 
      <1.206720, -1.119374, -0.966788>, <1.229694, -1.134403, -0.971123>, <1.227812, -1.065962, -0.957530>, <1.250464, -1.049901, -0.958688>, 
      <1.179633, -1.130423, -0.970161>, <1.202606, -1.145451, -0.974496>, <1.232489, -1.092948, -0.972862>, <1.255141, -1.076887, -0.974019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.225483, -1.048133, -0.942568>, <1.203321, -1.033273, -0.941541>, <1.176172, -0.988580, -0.936087>, <1.151610, -0.998599, -0.939145>, 
      <1.229704, -1.029773, -0.936672>, <1.207542, -1.014913, -0.935645>, <1.169639, -0.986332, -0.915188>, <1.145077, -0.993156, -0.935287>, 
      <1.229506, -1.002455, -0.929830>, <1.204161, -0.986754, -0.902806>, <1.155180, -0.962236, -0.907746>, <1.135128, -0.987812, -0.914296>, 
      <1.239552, -0.990129, -0.905874>, <1.214207, -0.971233, -0.895891>, <1.149177, -0.960556, -0.900794>, <1.129125, -0.986131, -0.907344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -1.036543, -0.962382>, <1.199257, -1.063771, -0.968788>, <1.156022, -1.114978, -0.965706>, <1.179633, -1.130423, -0.970161>, 
      <1.189755, -1.019074, -0.958272>, <1.195543, -1.046301, -0.964678>, <1.138951, -1.121941, -0.967832>, <1.162561, -1.137386, -0.972287>, 
      <1.164432, -1.009282, -0.946717>, <1.142594, -1.018189, -0.949436>, <1.161547, -1.069389, -0.953308>, <1.162695, -1.092820, -0.956951>, 
      <1.151610, -0.998599, -0.939145>, <1.129772, -1.007507, -0.941864>, <1.154288, -1.053273, -0.947646>, <1.155436, -1.076705, -0.951290>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -1.036543, -0.962382>, <1.199257, -1.063771, -0.968788>, <1.156022, -1.114978, -0.965706>, <1.179633, -1.130423, -0.970161>, 
      <1.189755, -1.019074, -0.958272>, <1.195543, -1.046301, -0.964678>, <1.183109, -1.103929, -0.962333>, <1.206720, -1.119374, -0.966788>, 
      <1.164432, -1.009282, -0.946717>, <1.188995, -0.999263, -0.943659>, <1.189566, -1.057960, -0.949819>, <1.211728, -1.072820, -0.950846>, 
      <1.151610, -0.998599, -0.939145>, <1.176172, -0.988580, -0.936087>, <1.203321, -1.033273, -0.941541>, <1.225483, -1.048133, -0.942568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -1.036543, -0.962382>, <1.199257, -1.063771, -0.968788>, <1.156022, -1.114978, -0.965706>, <1.179633, -1.130423, -0.970161>, 
      <1.193469, -1.036543, -0.962382>, <1.183690, -1.070121, -0.970727>, <1.138951, -1.121941, -0.967832>, <1.162561, -1.137386, -0.972287>, 
      <1.193469, -1.036543, -0.962382>, <1.183690, -1.070121, -0.970727>, <1.174105, -1.080772, -0.960279>, <1.162695, -1.092820, -0.956951>, 
      <1.193469, -1.036543, -0.962382>, <1.177901, -1.042893, -0.964320>, <1.166846, -1.064656, -0.954618>, <1.155436, -1.076705, -0.951290>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -1.036543, -0.962382>, <1.189755, -1.019074, -0.958272>, <1.164432, -1.009282, -0.946717>, <1.151610, -0.998599, -0.939145>, 
      <1.193469, -1.036543, -0.962382>, <1.174188, -1.025423, -0.960210>, <1.142594, -1.018189, -0.949436>, <1.129772, -1.007507, -0.941864>, 
      <1.193469, -1.036543, -0.962382>, <1.174188, -1.025423, -0.960210>, <1.165698, -1.041225, -0.950974>, <1.154288, -1.053273, -0.947646>, 
      <1.193469, -1.036543, -0.962382>, <1.177901, -1.042893, -0.964320>, <1.166846, -1.064656, -0.954618>, <1.155436, -1.076705, -0.951290>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -1.036543, -0.962382>, <1.177901, -1.042893, -0.964320>, <1.166846, -1.064656, -0.954618>, <1.155436, -1.076705, -0.951290>, 
      <1.204340, -1.032109, -0.961028>, <1.188772, -1.038459, -0.962967>, <1.165698, -1.041225, -0.950974>, <1.154288, -1.053273, -0.947646>, 
      <1.215879, -1.044656, -0.948512>, <1.193717, -1.029796, -0.947485>, <1.154334, -0.997488, -0.938806>, <1.129772, -1.007507, -0.941864>, 
      <1.225483, -1.048133, -0.942568>, <1.203321, -1.033273, -0.941541>, <1.176172, -0.988580, -0.936087>, <1.151610, -0.998599, -0.939145>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -1.036543, -0.962382>, <1.189755, -1.019074, -0.958272>, <1.164432, -1.009282, -0.946717>, <1.151610, -0.998599, -0.939145>, 
      <1.193469, -1.036543, -0.962382>, <1.200626, -1.014639, -0.956918>, <1.188995, -0.999263, -0.943659>, <1.176172, -0.988580, -0.936087>, 
      <1.193469, -1.036543, -0.962382>, <1.200626, -1.014639, -0.956918>, <1.193717, -1.029796, -0.947485>, <1.203321, -1.033273, -0.941541>, 
      <1.193469, -1.036543, -0.962382>, <1.204340, -1.032109, -0.961028>, <1.215879, -1.044656, -0.948512>, <1.225483, -1.048133, -0.942568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -1.036543, -0.962382>, <1.177901, -1.042893, -0.964320>, <1.166846, -1.064656, -0.954618>, <1.155436, -1.076705, -0.951290>, 
      <1.204340, -1.032109, -0.961028>, <1.188772, -1.038459, -0.962967>, <1.174105, -1.080772, -0.960279>, <1.162695, -1.092820, -0.956951>, 
      <1.215879, -1.044656, -0.948512>, <1.202124, -1.069343, -0.956790>, <1.189649, -1.126338, -0.968914>, <1.162561, -1.137386, -0.972287>, 
      <1.225483, -1.048133, -0.942568>, <1.211728, -1.072820, -0.950846>, <1.206720, -1.119374, -0.966788>, <1.179633, -1.130423, -0.970161>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193469, -1.036543, -0.962382>, <1.204340, -1.032109, -0.961028>, <1.215879, -1.044656, -0.948512>, <1.225483, -1.048133, -0.942568>, 
      <1.193469, -1.036543, -0.962382>, <1.210128, -1.059336, -0.967435>, <1.202124, -1.069343, -0.956790>, <1.211728, -1.072820, -0.950846>, 
      <1.193469, -1.036543, -0.962382>, <1.210128, -1.059336, -0.967435>, <1.183109, -1.103929, -0.962333>, <1.206720, -1.119374, -0.966788>, 
      <1.193469, -1.036543, -0.962382>, <1.199257, -1.063771, -0.968788>, <1.156022, -1.114978, -0.965706>, <1.179633, -1.130423, -0.970161>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.110934, -0.987213, -0.892039>, <1.116391, -0.989125, -0.884702>, <1.121920, -0.984114, -0.899000>, <1.129125, -0.986131, -0.907344>, 
      <1.110057, -1.037957, -0.921095>, <1.115514, -1.036674, -0.930799>, <1.095963, -1.014026, -0.924520>, <1.103168, -1.016043, -0.932863>, 
      <1.068463, -1.118243, -0.968817>, <1.076245, -1.104523, -0.971058>, <1.093274, -1.110250, -0.950576>, <1.100827, -1.097564, -0.944588>, 
      <1.108011, -1.156360, -0.988893>, <1.115793, -1.142639, -0.991134>, <1.126082, -1.134710, -0.963499>, <1.133635, -1.122024, -0.957510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.110934, -0.987213, -0.892039>, <1.160626, -0.981807, -0.896648>, <1.226883, -0.977795, -0.885751>, <1.276575, -0.972389, -0.890360>, 
      <1.116391, -0.989125, -0.884702>, <1.166084, -0.983719, -0.889310>, <1.215776, -0.983117, -0.890406>, <1.265468, -0.977711, -0.895014>, 
      <1.121920, -0.984114, -0.899000>, <1.141973, -0.958539, -0.892451>, <1.220907, -0.960880, -0.891279>, <1.246253, -0.979776, -0.901262>, 
      <1.129125, -0.986131, -0.907344>, <1.149177, -0.960556, -0.900794>, <1.214207, -0.971233, -0.895891>, <1.239552, -0.990129, -0.905874>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.276692, -1.146970, -0.976181>, <1.270227, -1.125945, -0.975532>, <1.261606, -1.097912, -0.974668>, <1.255141, -1.076887, -0.974019>, 
      <1.276657, -1.093637, -0.955547>, <1.270192, -1.072612, -0.954898>, <1.256930, -1.070926, -0.959336>, <1.250464, -1.049901, -0.958688>, 
      <1.276610, -1.022527, -0.928035>, <1.265503, -1.027849, -0.932689>, <1.270248, -0.994471, -0.927754>, <1.263548, -1.004824, -0.932366>, 
      <1.276575, -0.972389, -0.890360>, <1.265468, -0.977711, -0.895014>, <1.246253, -0.979776, -0.901262>, <1.239552, -0.990129, -0.905874>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.276692, -1.146970, -0.976181>, <1.226088, -1.149787, -0.979995>, <1.142383, -1.189488, -1.006341>, <1.108011, -1.156360, -0.988893>, 
      <1.270227, -1.125945, -0.975532>, <1.219622, -1.128762, -0.979346>, <1.150165, -1.175767, -1.008581>, <1.115793, -1.142639, -0.991134>, 
      <1.261606, -1.097912, -0.974668>, <1.225154, -1.111453, -0.969715>, <1.156050, -1.157053, -0.975302>, <1.126082, -1.134710, -0.963499>, 
      <1.255141, -1.076887, -0.974019>, <1.218689, -1.090428, -0.969066>, <1.163603, -1.144367, -0.969314>, <1.133635, -1.122024, -0.957510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.292567, -1.218083, -0.927265>, <1.295720, -1.201574, -0.947530>, <1.281455, -1.168304, -0.961506>, <1.276692, -1.146970, -0.976181>, 
      <1.335569, -1.172643, -0.895913>, <1.338723, -1.156133, -0.916178>, <1.281419, -1.114971, -0.940872>, <1.276657, -1.093637, -0.955547>, 
      <1.312367, -1.070890, -0.824448>, <1.315944, -1.047281, -0.852012>, <1.273465, -1.039147, -0.895726>, <1.276610, -1.022527, -0.928035>, 
      <1.266092, -1.024594, -0.799704>, <1.269669, -1.000984, -0.827268>, <1.273430, -0.985814, -0.875092>, <1.276575, -0.972389, -0.890360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.073424, -1.228185, -0.940174>, <1.083800, -1.206638, -0.954790>, <1.094321, -1.180498, -0.984951>, <1.108011, -1.156360, -0.988893>, 
      <1.139167, -1.225154, -0.936301>, <1.149543, -1.203607, -0.950917>, <1.128693, -1.213625, -1.002399>, <1.142383, -1.189488, -1.006341>, 
      <1.252055, -1.260892, -0.956802>, <1.255208, -1.244383, -0.977067>, <1.230850, -1.171121, -0.965320>, <1.226088, -1.149787, -0.979995>, 
      <1.292567, -1.218083, -0.927265>, <1.295720, -1.201574, -0.947530>, <1.281455, -1.168304, -0.961506>, <1.276692, -1.146970, -0.976181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.086819, -1.012240, -0.817248>, <1.092656, -0.997229, -0.836029>, <1.103700, -0.994721, -0.869602>, <1.110934, -0.987213, -0.892039>, 
      <1.040944, -1.060716, -0.850694>, <1.046781, -1.045704, -0.869475>, <1.102823, -1.045465, -0.898658>, <1.110057, -1.037957, -0.921095>, 
      <1.077443, -1.163402, -0.903296>, <1.087819, -1.141854, -0.917912>, <1.054772, -1.142381, -0.964876>, <1.068463, -1.118243, -0.968817>, 
      <1.073424, -1.228185, -0.940174>, <1.083800, -1.206638, -0.954790>, <1.094321, -1.180498, -0.984951>, <1.108011, -1.156360, -0.988893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.086819, -1.012240, -0.817248>, <1.120104, -0.977068, -0.792980>, <1.230274, -0.988759, -0.780551>, <1.266092, -1.024594, -0.799704>, 
      <1.092656, -0.997229, -0.836029>, <1.125941, -0.962056, -0.811762>, <1.233850, -0.965149, -0.808116>, <1.269669, -1.000984, -0.827268>, 
      <1.103700, -0.994721, -0.869602>, <1.153392, -0.989315, -0.874210>, <1.223738, -0.991220, -0.870483>, <1.273430, -0.985814, -0.875092>, 
      <1.110934, -0.987213, -0.892039>, <1.160626, -0.981807, -0.896648>, <1.226883, -0.977795, -0.885751>, <1.276575, -0.972389, -0.890360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.261380, -1.227136, -0.877778>, <1.270736, -1.224420, -0.892624>, <1.290440, -1.229218, -0.913597>, <1.292567, -1.218083, -0.927265>, 
      <1.296377, -1.198126, -0.850459>, <1.305733, -1.195410, -0.865305>, <1.333443, -1.183778, -0.882245>, <1.335569, -1.172643, -0.895913>, 
      <1.296602, -1.119492, -0.788137>, <1.298886, -1.100274, -0.797668>, <1.310251, -1.084856, -0.808143>, <1.312367, -1.070890, -0.824448>, 
      <1.258478, -1.088651, -0.767935>, <1.260762, -1.069434, -0.777466>, <1.263976, -1.038559, -0.783399>, <1.266092, -1.024594, -0.799704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.088240, -1.229765, -0.900825>, <1.083795, -1.229291, -0.912630>, <1.077869, -1.228659, -0.928369>, <1.073424, -1.228185, -0.940174>, 
      <1.125912, -1.260240, -0.920787>, <1.121467, -1.259766, -0.932592>, <1.143612, -1.225628, -0.924497>, <1.139167, -1.225154, -0.936301>, 
      <1.226798, -1.255802, -0.904773>, <1.236154, -1.253086, -0.919619>, <1.249928, -1.272027, -0.943134>, <1.252055, -1.260892, -0.956802>, 
      <1.261380, -1.227136, -0.877778>, <1.270736, -1.224420, -0.892624>, <1.290440, -1.229218, -0.913597>, <1.292567, -1.218083, -0.927265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.075965, -1.077143, -0.779526>, <1.079221, -1.057672, -0.790843>, <1.081451, -1.026046, -0.799975>, <1.086819, -1.012240, -0.817248>, 
      <1.037294, -1.109198, -0.809713>, <1.040551, -1.089727, -0.821029>, <1.035576, -1.074521, -0.833421>, <1.040944, -1.060716, -0.850694>, 
      <1.046114, -1.195687, -0.878502>, <1.041669, -1.195213, -0.890307>, <1.081887, -1.163876, -0.891491>, <1.077443, -1.163402, -0.903296>, 
      <1.088240, -1.229765, -0.900825>, <1.083795, -1.229291, -0.912630>, <1.077869, -1.228659, -0.928369>, <1.073424, -1.228185, -0.940174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.075965, -1.077143, -0.779526>, <1.112241, -1.047073, -0.751209>, <1.218961, -1.056683, -0.746995>, <1.258478, -1.088651, -0.767935>, 
      <1.079221, -1.057672, -0.790843>, <1.115497, -1.027602, -0.762525>, <1.221245, -1.037466, -0.756526>, <1.260762, -1.069434, -0.777466>, 
      <1.081451, -1.026046, -0.799975>, <1.114736, -0.990874, -0.775707>, <1.228158, -1.002724, -0.764247>, <1.263976, -1.038559, -0.783399>, 
      <1.086819, -1.012240, -0.817248>, <1.120104, -0.977068, -0.792980>, <1.230274, -0.988759, -0.780551>, <1.266092, -1.024594, -0.799704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.231001, -1.191163, -0.991281>, <1.248649, -1.187666, -0.982688>, <1.251819, -1.217661, -1.023354>, <1.260741, -1.229017, -1.037100>, 
      <1.205332, -1.180673, -0.980214>, <1.222980, -1.177175, -0.971621>, <1.257528, -1.211737, -1.009247>, <1.266450, -1.223094, -1.022993>, 
      <1.178853, -1.197595, -1.037024>, <1.215833, -1.200271, -1.017058>, <1.239628, -1.197763, -0.986237>, <1.272854, -1.218622, -1.001542>, 
      <1.156504, -1.200352, -1.056628>, <1.193484, -1.203028, -1.036662>, <1.246544, -1.188415, -0.974772>, <1.279770, -1.209273, -0.990076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.271928, -1.266719, -1.112470>, <1.294502, -1.262245, -1.101478>, <1.264097, -1.240328, -1.059711>, <1.260741, -1.229017, -1.037100>, 
      <1.279118, -1.272765, -1.115988>, <1.301692, -1.268292, -1.104995>, <1.269806, -1.234404, -1.045604>, <1.266450, -1.223094, -1.022993>, 
      <1.290263, -1.280083, -1.122203>, <1.315200, -1.262169, -1.087815>, <1.309230, -1.241457, -1.018296>, <1.272854, -1.218622, -1.001542>, 
      <1.296220, -1.288061, -1.120982>, <1.321157, -1.270147, -1.086594>, <1.316145, -1.232108, -1.006831>, <1.279770, -1.209273, -0.990076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.188332, -1.243366, -1.072359>, <1.185237, -1.255068, -1.089770>, <1.187704, -1.270850, -1.115462>, <1.178015, -1.282372, -1.130396>, 
      <1.201133, -1.227705, -1.048036>, <1.198038, -1.239407, -1.065447>, <1.161100, -1.254149, -1.103208>, <1.151411, -1.265671, -1.118142>, 
      <1.203000, -1.196712, -1.004916>, <1.177331, -1.186221, -0.993849>, <1.185306, -1.222201, -1.059154>, <1.162957, -1.224958, -1.078758>, 
      <1.231001, -1.191163, -0.991281>, <1.205332, -1.180673, -0.980214>, <1.178853, -1.197595, -1.037024>, <1.156504, -1.200352, -1.056628>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.188332, -1.243366, -1.072359>, <1.213411, -1.250372, -1.084392>, <1.246538, -1.271751, -1.124834>, <1.271928, -1.266719, -1.112470>, 
      <1.185237, -1.255068, -1.089770>, <1.210316, -1.262074, -1.101803>, <1.253728, -1.277797, -1.128351>, <1.279118, -1.272765, -1.115988>, 
      <1.187704, -1.270850, -1.115462>, <1.215805, -1.288491, -1.128406>, <1.270998, -1.293922, -1.148769>, <1.290263, -1.280083, -1.122203>, 
      <1.178015, -1.282372, -1.130396>, <1.206116, -1.300013, -1.143340>, <1.276955, -1.301900, -1.147548>, <1.296220, -1.288061, -1.120982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.225410, -1.228513, -1.086337>, <1.216957, -1.212907, -1.061306>, <1.257382, -1.201945, -1.002655>, <1.231001, -1.191163, -0.991281>, 
      <1.230834, -1.238526, -1.102397>, <1.222380, -1.222920, -1.077366>, <1.275030, -1.198448, -0.994062>, <1.248649, -1.187666, -0.982688>, 
      <1.257817, -1.254852, -1.105566>, <1.280392, -1.250379, -1.094574>, <1.255175, -1.228971, -1.045965>, <1.251819, -1.217661, -1.023354>, 
      <1.271928, -1.266719, -1.112470>, <1.294502, -1.262245, -1.101478>, <1.264097, -1.240328, -1.059711>, <1.260741, -1.229017, -1.037100>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.225410, -1.228513, -1.086337>, <1.216957, -1.212907, -1.061306>, <1.257382, -1.201945, -1.002655>, <1.231001, -1.191163, -0.991281>, 
      <1.230834, -1.238526, -1.102397>, <1.222380, -1.222920, -1.077366>, <1.229381, -1.207493, -1.016290>, <1.203000, -1.196712, -1.004916>, 
      <1.257817, -1.254852, -1.105566>, <1.232427, -1.259884, -1.117930>, <1.226211, -1.234711, -1.060069>, <1.201133, -1.227705, -1.048036>, 
      <1.271928, -1.266719, -1.112470>, <1.246538, -1.271751, -1.124834>, <1.213411, -1.250372, -1.084392>, <1.188332, -1.243366, -1.072359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.225410, -1.228513, -1.086337>, <1.216957, -1.212907, -1.061306>, <1.257382, -1.201945, -1.002655>, <1.231001, -1.191163, -0.991281>, 
      <1.225410, -1.228513, -1.086337>, <1.233049, -1.209718, -1.053469>, <1.275030, -1.198448, -0.994062>, <1.248649, -1.187666, -0.982688>, 
      <1.225410, -1.228513, -1.086337>, <1.233049, -1.209718, -1.053469>, <1.241220, -1.217510, -1.038125>, <1.251819, -1.217661, -1.023354>, 
      <1.225410, -1.228513, -1.086337>, <1.241503, -1.225324, -1.078501>, <1.250142, -1.228866, -1.051871>, <1.260741, -1.229017, -1.037100>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.225410, -1.228513, -1.086337>, <1.230834, -1.238526, -1.102397>, <1.257817, -1.254852, -1.105566>, <1.271928, -1.266719, -1.112470>, 
      <1.225410, -1.228513, -1.086337>, <1.246926, -1.235337, -1.094561>, <1.280392, -1.250379, -1.094574>, <1.294502, -1.262245, -1.101478>, 
      <1.225410, -1.228513, -1.086337>, <1.246926, -1.235337, -1.094561>, <1.253498, -1.240176, -1.074482>, <1.264097, -1.240328, -1.059711>, 
      <1.225410, -1.228513, -1.086337>, <1.241503, -1.225324, -1.078501>, <1.250142, -1.228866, -1.051871>, <1.260741, -1.229017, -1.037100>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.225410, -1.228513, -1.086337>, <1.241503, -1.225324, -1.078501>, <1.250142, -1.228866, -1.051871>, <1.260741, -1.229017, -1.037100>, 
      <1.214173, -1.230740, -1.091809>, <1.230266, -1.227551, -1.083973>, <1.253498, -1.240176, -1.074482>, <1.264097, -1.240328, -1.059711>, 
      <1.199455, -1.238910, -1.076552>, <1.224534, -1.245916, -1.088586>, <1.269112, -1.267277, -1.113841>, <1.294502, -1.262245, -1.101478>, 
      <1.188332, -1.243366, -1.072359>, <1.213411, -1.250372, -1.084392>, <1.246538, -1.271751, -1.124834>, <1.271928, -1.266719, -1.112470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.225410, -1.228513, -1.086337>, <1.230834, -1.238526, -1.102397>, <1.257817, -1.254852, -1.105566>, <1.271928, -1.266719, -1.112470>, 
      <1.225410, -1.228513, -1.086337>, <1.219597, -1.240752, -1.107869>, <1.232427, -1.259884, -1.117930>, <1.246538, -1.271751, -1.124834>, 
      <1.225410, -1.228513, -1.086337>, <1.219597, -1.240752, -1.107869>, <1.224534, -1.245916, -1.088586>, <1.213411, -1.250372, -1.084392>, 
      <1.225410, -1.228513, -1.086337>, <1.214173, -1.230740, -1.091809>, <1.199455, -1.238910, -1.076552>, <1.188332, -1.243366, -1.072359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.225410, -1.228513, -1.086337>, <1.241503, -1.225324, -1.078501>, <1.250142, -1.228866, -1.051871>, <1.260741, -1.229017, -1.037100>, 
      <1.214173, -1.230740, -1.091809>, <1.230266, -1.227551, -1.083973>, <1.241220, -1.217510, -1.038125>, <1.251819, -1.217661, -1.023354>, 
      <1.199455, -1.238910, -1.076552>, <1.212256, -1.223249, -1.052229>, <1.220648, -1.193215, -0.996323>, <1.248649, -1.187666, -0.982688>, 
      <1.188332, -1.243366, -1.072359>, <1.201133, -1.227705, -1.048036>, <1.203000, -1.196712, -1.004916>, <1.231001, -1.191163, -0.991281>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.225410, -1.228513, -1.086337>, <1.214173, -1.230740, -1.091809>, <1.199455, -1.238910, -1.076552>, <1.188332, -1.243366, -1.072359>, 
      <1.225410, -1.228513, -1.086337>, <1.205720, -1.215134, -1.066777>, <1.212256, -1.223249, -1.052229>, <1.201133, -1.227705, -1.048036>, 
      <1.225410, -1.228513, -1.086337>, <1.205720, -1.215134, -1.066777>, <1.229381, -1.207493, -1.016290>, <1.203000, -1.196712, -1.004916>, 
      <1.225410, -1.228513, -1.086337>, <1.216957, -1.212907, -1.061306>, <1.257382, -1.201945, -1.002655>, <1.231001, -1.191163, -0.991281>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.312290, -1.320777, -1.104196>, <1.309224, -1.311108, -1.110680>, <1.303369, -1.297636, -1.119517>, <1.296220, -1.288061, -1.120982>, 
      <1.349224, -1.291073, -1.062962>, <1.346158, -1.281404, -1.069446>, <1.328306, -1.279722, -1.085128>, <1.321157, -1.270147, -1.086594>, 
      <1.286025, -1.202397, -0.976322>, <1.343951, -1.204089, -1.004915>, <1.323393, -1.222310, -0.994814>, <1.316145, -1.232108, -1.006831>, 
      <1.306251, -1.167496, -0.961647>, <1.299596, -1.169188, -0.977324>, <1.287018, -1.199475, -0.978059>, <1.279770, -1.209273, -0.990076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.312290, -1.320777, -1.104196>, <1.280587, -1.346275, -1.139590>, <1.191026, -1.307609, -1.135075>, <1.139055, -1.301966, -1.148309>, 
      <1.309224, -1.311108, -1.110680>, <1.277521, -1.336605, -1.146074>, <1.202714, -1.301731, -1.129701>, <1.150743, -1.296088, -1.142935>, 
      <1.303369, -1.297636, -1.119517>, <1.284104, -1.311475, -1.146082>, <1.199653, -1.307698, -1.153300>, <1.171552, -1.290057, -1.140357>, 
      <1.296220, -1.288061, -1.120982>, <1.276955, -1.301900, -1.147548>, <1.206116, -1.300013, -1.143340>, <1.178015, -1.282372, -1.130396>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.126389, -1.174497, -0.988555>, <1.135423, -1.182254, -1.008977>, <1.147469, -1.192595, -1.036206>, <1.156504, -1.200352, -1.056628>, 
      <1.130189, -1.212738, -1.036481>, <1.139223, -1.220494, -1.056903>, <1.153923, -1.217202, -1.058337>, <1.162957, -1.224958, -1.078758>, 
      <1.135255, -1.263725, -1.100383>, <1.146943, -1.257847, -1.095009>, <1.144948, -1.273356, -1.128103>, <1.151411, -1.265671, -1.118142>, 
      <1.139055, -1.301966, -1.148309>, <1.150743, -1.296088, -1.142935>, <1.171552, -1.290057, -1.140357>, <1.178015, -1.282372, -1.130396>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.126389, -1.174497, -0.988555>, <1.180348, -1.172397, -0.980483>, <1.267702, -1.137163, -0.937667>, <1.306251, -1.167496, -0.961647>, 
      <1.135423, -1.182254, -1.008977>, <1.189382, -1.180153, -1.000905>, <1.261048, -1.138855, -0.953345>, <1.299596, -1.169188, -0.977324>, 
      <1.147469, -1.192595, -1.036206>, <1.184449, -1.195272, -1.016241>, <1.253791, -1.178617, -0.962755>, <1.287018, -1.199475, -0.978059>, 
      <1.156504, -1.200352, -1.056628>, <1.193484, -1.203028, -1.036662>, <1.246544, -1.188415, -0.974772>, <1.279770, -1.209273, -0.990076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.097689, -1.200907, -0.902723>, <1.097854, -1.185289, -0.926302>, <1.117779, -1.182420, -0.962805>, <1.126389, -1.174497, -0.988555>, 
      <1.053859, -1.245285, -0.944683>, <1.054024, -1.229667, -0.968262>, <1.121579, -1.220661, -1.010732>, <1.130189, -1.212738, -1.036481>, 
      <1.082916, -1.352344, -1.023150>, <1.084021, -1.331509, -1.056309>, <1.134003, -1.291638, -1.072922>, <1.135255, -1.263725, -1.100383>, 
      <1.134881, -1.395010, -1.056772>, <1.135986, -1.374174, -1.089930>, <1.137803, -1.329879, -1.120848>, <1.139055, -1.301966, -1.148309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.331260, -1.196179, -0.868775>, <1.323757, -1.187574, -0.896637>, <1.317958, -1.164519, -0.934067>, <1.306251, -1.167496, -0.961647>, 
      <1.261189, -1.197597, -0.878959>, <1.253686, -1.188992, -0.906821>, <1.279410, -1.134186, -0.910087>, <1.267702, -1.137163, -0.937667>, 
      <1.138982, -1.159099, -0.863193>, <1.139147, -1.143480, -0.886772>, <1.171738, -1.180320, -0.954733>, <1.180348, -1.172397, -0.980483>, 
      <1.097689, -1.200907, -0.902723>, <1.097854, -1.185289, -0.926302>, <1.117779, -1.182420, -0.962805>, <1.126389, -1.174497, -0.988555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.328736, -1.390608, -1.052214>, <1.325754, -1.375885, -1.074140>, <1.319058, -1.342124, -1.089881>, <1.312290, -1.320777, -1.104196>, 
      <1.310914, -1.343266, -0.994536>, <1.307932, -1.328543, -1.016461>, <1.291412, -1.312419, -1.035731>, <1.349224, -1.291073, -1.062962>, 
      <1.330503, -1.254508, -0.923807>, <1.323000, -1.245903, -0.951668>, <1.297733, -1.199420, -0.948742>, <1.286025, -1.202397, -0.976322>, 
      <1.331260, -1.196179, -0.868775>, <1.323757, -1.187574, -0.896637>, <1.317958, -1.164519, -0.934067>, <1.306251, -1.167496, -0.961647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.328736, -1.390608, -1.052214>, <1.294809, -1.424958, -1.084693>, <1.175104, -1.428035, -1.082797>, <1.134881, -1.395010, -1.056772>, 
      <1.325754, -1.375885, -1.074140>, <1.291827, -1.410235, -1.106618>, <1.176208, -1.407199, -1.115955>, <1.135986, -1.374174, -1.089930>, 
      <1.319058, -1.342124, -1.089881>, <1.287356, -1.367621, -1.125275>, <1.189773, -1.335522, -1.107614>, <1.137803, -1.329879, -1.120848>, 
      <1.312290, -1.320777, -1.104196>, <1.280587, -1.346275, -1.139590>, <1.191026, -1.307609, -1.135075>, <1.139055, -1.301966, -1.148309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.125586, -1.250336, -0.874059>, <1.117217, -1.235507, -0.882658>, <1.097578, -1.211441, -0.886820>, <1.097689, -1.200907, -0.902723>, 
      <1.088920, -1.285741, -0.899513>, <1.080551, -1.270912, -0.908113>, <1.053747, -1.255818, -0.928780>, <1.053859, -1.245285, -0.944683>, 
      <1.091404, -1.374767, -0.960226>, <1.091828, -1.371054, -0.983097>, <1.082263, -1.364669, -1.003536>, <1.082916, -1.352344, -1.023150>, 
      <1.133466, -1.407387, -0.980538>, <1.133890, -1.403674, -1.003408>, <1.134228, -1.407334, -1.037158>, <1.134881, -1.395010, -1.056772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.311824, -1.235164, -0.856718>, <1.317655, -1.223469, -0.860335>, <1.325429, -1.207875, -0.865158>, <1.331260, -1.196179, -0.868775>, 
      <1.270260, -1.202931, -0.836647>, <1.276091, -1.191235, -0.840264>, <1.255358, -1.209293, -0.875342>, <1.261189, -1.197597, -0.878959>, 
      <1.161818, -1.215351, -0.848906>, <1.153449, -1.200522, -0.857505>, <1.138870, -1.169632, -0.847290>, <1.138982, -1.159099, -0.863193>, 
      <1.125586, -1.250336, -0.874059>, <1.117217, -1.235507, -0.882658>, <1.097578, -1.211441, -0.886820>, <1.097689, -1.200907, -0.902723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.330157, -1.408982, -0.972844>, <1.329731, -1.403470, -0.996655>, <1.331479, -1.404149, -1.032049>, <1.328736, -1.390608, -1.052214>, 
      <1.306092, -1.369860, -0.931802>, <1.305666, -1.364348, -0.955613>, <1.313657, -1.356807, -0.974370>, <1.310914, -1.343266, -0.994536>, 
      <1.293722, -1.271208, -0.866246>, <1.299553, -1.259512, -0.869863>, <1.324672, -1.266203, -0.920190>, <1.330503, -1.254508, -0.923807>, 
      <1.311824, -1.235164, -0.856718>, <1.317655, -1.223469, -0.860335>, <1.325429, -1.207875, -0.865158>, <1.331260, -1.196179, -0.868775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.330157, -1.408982, -0.972844>, <1.292151, -1.445681, -0.999229>, <1.177066, -1.441199, -1.001592>, <1.133466, -1.407387, -0.980538>, 
      <1.329731, -1.403470, -0.996655>, <1.291725, -1.440169, -1.023040>, <1.177490, -1.437486, -1.024462>, <1.133890, -1.403674, -1.003408>, 
      <1.331479, -1.404149, -1.032049>, <1.297553, -1.438500, -1.064527>, <1.174450, -1.440359, -1.063183>, <1.134228, -1.407334, -1.037158>, 
      <1.328736, -1.390608, -1.052214>, <1.294809, -1.424958, -1.084693>, <1.175104, -1.428035, -1.082797>, <1.134881, -1.395010, -1.056772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.141223, -1.214059, -1.006862>, <0.158870, -1.210562, -0.998269>, <0.162041, -1.240556, -1.038935>, <0.170963, -1.251912, -1.052680>, 
      <0.115555, -1.203569, -0.995795>, <0.133202, -1.200072, -0.987202>, <0.167750, -1.234633, -1.024827>, <0.176672, -1.245989, -1.038573>, 
      <0.089075, -1.220491, -1.052604>, <0.126055, -1.223167, -1.032638>, <0.149850, -1.220658, -1.001817>, <0.183076, -1.241517, -1.017122>, 
      <0.066726, -1.223247, -1.072207>, <0.103706, -1.225923, -1.052242>, <0.156766, -1.211310, -0.990352>, <0.189992, -1.232168, -1.005656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.182150, -1.289614, -1.128050>, <0.204725, -1.285141, -1.117058>, <0.174319, -1.263223, -1.075291>, <0.170963, -1.251912, -1.052680>, 
      <0.189340, -1.295660, -1.131568>, <0.211914, -1.291187, -1.120575>, <0.180028, -1.257299, -1.061184>, <0.176672, -1.245989, -1.038573>, 
      <0.200485, -1.302977, -1.137783>, <0.225422, -1.285063, -1.103395>, <0.219451, -1.264351, -1.033877>, <0.183076, -1.241517, -1.017122>, 
      <0.206442, -1.310955, -1.136562>, <0.231379, -1.293041, -1.102174>, <0.226367, -1.255003, -1.022411>, <0.189992, -1.232168, -1.005656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.098554, -1.266261, -1.087938>, <0.095459, -1.277963, -1.105349>, <0.097927, -1.293745, -1.131042>, <0.088238, -1.305267, -1.145976>, 
      <0.111355, -1.250600, -1.063615>, <0.108260, -1.262302, -1.081027>, <0.071323, -1.277044, -1.118788>, <0.061634, -1.288566, -1.133722>, 
      <0.113223, -1.219608, -1.020496>, <0.087554, -1.209117, -1.009430>, <0.095529, -1.245097, -1.074734>, <0.073180, -1.247853, -1.094338>, 
      <0.141223, -1.214059, -1.006862>, <0.115555, -1.203569, -0.995795>, <0.089075, -1.220491, -1.052604>, <0.066726, -1.223247, -1.072207>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.098554, -1.266261, -1.087938>, <0.123633, -1.273267, -1.099972>, <0.156760, -1.294645, -1.140413>, <0.182150, -1.289614, -1.128050>, 
      <0.095459, -1.277963, -1.105349>, <0.120538, -1.284969, -1.117383>, <0.163949, -1.300691, -1.143931>, <0.189340, -1.295660, -1.131568>, 
      <0.097927, -1.293745, -1.131042>, <0.126028, -1.311385, -1.143986>, <0.181221, -1.316816, -1.164349>, <0.200485, -1.302977, -1.137783>, 
      <0.088238, -1.305267, -1.145976>, <0.116339, -1.322908, -1.158920>, <0.187178, -1.324794, -1.163128>, <0.206442, -1.310955, -1.136562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.135632, -1.251408, -1.101916>, <0.127179, -1.235802, -1.076885>, <0.167603, -1.224840, -1.018236>, <0.141223, -1.214059, -1.006862>, 
      <0.141056, -1.261421, -1.117976>, <0.132602, -1.245815, -1.092945>, <0.185251, -1.221343, -1.009643>, <0.158870, -1.210562, -0.998269>, 
      <0.168039, -1.277748, -1.121146>, <0.190614, -1.273274, -1.110154>, <0.165397, -1.251867, -1.061546>, <0.162041, -1.240556, -1.038935>, 
      <0.182150, -1.289614, -1.128050>, <0.204725, -1.285141, -1.117058>, <0.174319, -1.263223, -1.075291>, <0.170963, -1.251912, -1.052680>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.135632, -1.251408, -1.101916>, <0.127179, -1.235802, -1.076885>, <0.167603, -1.224840, -1.018236>, <0.141223, -1.214059, -1.006862>, 
      <0.141056, -1.261421, -1.117976>, <0.132602, -1.245815, -1.092945>, <0.139603, -1.230389, -1.031870>, <0.113223, -1.219608, -1.020496>, 
      <0.168039, -1.277748, -1.121146>, <0.142649, -1.282779, -1.133509>, <0.136434, -1.257606, -1.075649>, <0.111355, -1.250600, -1.063615>, 
      <0.182150, -1.289614, -1.128050>, <0.156760, -1.294645, -1.140413>, <0.123633, -1.273267, -1.099972>, <0.098554, -1.266261, -1.087938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.135632, -1.251408, -1.101916>, <0.127179, -1.235802, -1.076885>, <0.167603, -1.224840, -1.018236>, <0.141223, -1.214059, -1.006862>, 
      <0.135632, -1.251408, -1.101916>, <0.143271, -1.232613, -1.069049>, <0.185251, -1.221343, -1.009643>, <0.158870, -1.210562, -0.998269>, 
      <0.135632, -1.251408, -1.101916>, <0.143271, -1.232613, -1.069049>, <0.151442, -1.240405, -1.053705>, <0.162041, -1.240556, -1.038935>, 
      <0.135632, -1.251408, -1.101916>, <0.151725, -1.248219, -1.094080>, <0.160364, -1.251761, -1.067451>, <0.170963, -1.251912, -1.052680>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.135632, -1.251408, -1.101916>, <0.141056, -1.261421, -1.117976>, <0.168039, -1.277748, -1.121146>, <0.182150, -1.289614, -1.128050>, 
      <0.135632, -1.251408, -1.101916>, <0.157148, -1.258232, -1.110140>, <0.190614, -1.273274, -1.110154>, <0.204725, -1.285141, -1.117058>, 
      <0.135632, -1.251408, -1.101916>, <0.157148, -1.258232, -1.110140>, <0.163720, -1.263071, -1.090062>, <0.174319, -1.263223, -1.075291>, 
      <0.135632, -1.251408, -1.101916>, <0.151725, -1.248219, -1.094080>, <0.160364, -1.251761, -1.067451>, <0.170963, -1.251912, -1.052680>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.135632, -1.251408, -1.101916>, <0.151725, -1.248219, -1.094080>, <0.160364, -1.251761, -1.067451>, <0.170963, -1.251912, -1.052680>, 
      <0.124395, -1.253635, -1.107388>, <0.140488, -1.250446, -1.099552>, <0.163720, -1.263071, -1.090062>, <0.174319, -1.263223, -1.075291>, 
      <0.109677, -1.261805, -1.092131>, <0.134756, -1.268811, -1.104165>, <0.179334, -1.290172, -1.129421>, <0.204725, -1.285141, -1.117058>, 
      <0.098554, -1.266261, -1.087938>, <0.123633, -1.273267, -1.099972>, <0.156760, -1.294645, -1.140413>, <0.182150, -1.289614, -1.128050>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.135632, -1.251408, -1.101916>, <0.141056, -1.261421, -1.117976>, <0.168039, -1.277748, -1.121146>, <0.182150, -1.289614, -1.128050>, 
      <0.135632, -1.251408, -1.101916>, <0.129819, -1.263647, -1.123448>, <0.142649, -1.282779, -1.133509>, <0.156760, -1.294645, -1.140413>, 
      <0.135632, -1.251408, -1.101916>, <0.129819, -1.263647, -1.123448>, <0.134756, -1.268811, -1.104165>, <0.123633, -1.273267, -1.099972>, 
      <0.135632, -1.251408, -1.101916>, <0.124395, -1.253635, -1.107388>, <0.109677, -1.261805, -1.092131>, <0.098554, -1.266261, -1.087938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.135632, -1.251408, -1.101916>, <0.151725, -1.248219, -1.094080>, <0.160364, -1.251761, -1.067451>, <0.170963, -1.251912, -1.052680>, 
      <0.124395, -1.253635, -1.107388>, <0.140488, -1.250446, -1.099552>, <0.151442, -1.240405, -1.053705>, <0.162041, -1.240556, -1.038935>, 
      <0.109677, -1.261805, -1.092131>, <0.122478, -1.246144, -1.067809>, <0.130870, -1.216111, -1.011903>, <0.158870, -1.210562, -0.998269>, 
      <0.098554, -1.266261, -1.087938>, <0.111355, -1.250600, -1.063615>, <0.113223, -1.219608, -1.020496>, <0.141223, -1.214059, -1.006862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.135632, -1.251408, -1.101916>, <0.124395, -1.253635, -1.107388>, <0.109677, -1.261805, -1.092131>, <0.098554, -1.266261, -1.087938>, 
      <0.135632, -1.251408, -1.101916>, <0.115942, -1.238029, -1.082357>, <0.122478, -1.246144, -1.067809>, <0.111355, -1.250600, -1.063615>, 
      <0.135632, -1.251408, -1.101916>, <0.115942, -1.238029, -1.082357>, <0.139603, -1.230389, -1.031870>, <0.113223, -1.219608, -1.020496>, 
      <0.135632, -1.251408, -1.101916>, <0.127179, -1.235802, -1.076885>, <0.167603, -1.224840, -1.018236>, <0.141223, -1.214059, -1.006862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.222511, -1.343672, -1.119777>, <0.217690, -1.333857, -1.124813>, <0.213591, -1.320530, -1.135097>, <0.206442, -1.310955, -1.136562>, 
      <0.220700, -1.297688, -1.077012>, <0.215879, -1.287873, -1.082047>, <0.238528, -1.302616, -1.100709>, <0.231379, -1.293041, -1.102174>, 
      <0.260827, -1.225292, -1.004817>, <0.254173, -1.226985, -1.020495>, <0.233615, -1.245205, -1.010394>, <0.226367, -1.255003, -1.022411>, 
      <0.216473, -1.190391, -0.977226>, <0.209818, -1.192083, -0.992904>, <0.197240, -1.222370, -0.993639>, <0.189992, -1.232168, -1.005656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.222511, -1.343672, -1.119777>, <0.170541, -1.338029, -1.133011>, <0.101247, -1.330504, -1.150655>, <0.049277, -1.324861, -1.163889>, 
      <0.217690, -1.333857, -1.124813>, <0.165720, -1.328214, -1.138046>, <0.112935, -1.324626, -1.145281>, <0.060965, -1.318983, -1.158515>, 
      <0.213591, -1.320530, -1.135097>, <0.194327, -1.334369, -1.161663>, <0.109876, -1.330593, -1.168881>, <0.081775, -1.312952, -1.155937>, 
      <0.206442, -1.310955, -1.136562>, <0.187178, -1.324794, -1.163128>, <0.116339, -1.322908, -1.158920>, <0.088238, -1.305267, -1.145976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.036610, -1.197391, -1.004134>, <0.045645, -1.205148, -1.024556>, <0.057691, -1.215490, -1.051785>, <0.066726, -1.223247, -1.072207>, 
      <0.040410, -1.235632, -1.052061>, <0.049445, -1.243389, -1.072483>, <0.064145, -1.240096, -1.073916>, <0.073180, -1.247853, -1.094338>, 
      <0.045477, -1.286620, -1.115963>, <0.057165, -1.280742, -1.110589>, <0.055171, -1.296251, -1.143683>, <0.061634, -1.288566, -1.133722>, 
      <0.049277, -1.324861, -1.163889>, <0.060965, -1.318983, -1.158515>, <0.081775, -1.312952, -1.155937>, <0.088238, -1.305267, -1.145976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.036610, -1.197391, -1.004134>, <0.090569, -1.195291, -0.996062>, <0.177924, -1.160058, -0.953246>, <0.216473, -1.190391, -0.977226>, 
      <0.045645, -1.205148, -1.024556>, <0.099604, -1.203048, -1.016484>, <0.171269, -1.161750, -0.968924>, <0.209818, -1.192083, -0.992904>, 
      <0.057691, -1.215490, -1.051785>, <0.094671, -1.218166, -1.031820>, <0.164014, -1.201512, -0.978335>, <0.197240, -1.222370, -0.993639>, 
      <0.066726, -1.223247, -1.072207>, <0.103706, -1.225923, -1.052242>, <0.156766, -1.211310, -0.990352>, <0.189992, -1.232168, -1.005656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.007911, -1.223801, -0.918303>, <0.008076, -1.208183, -0.941882>, <0.028000, -1.205314, -0.978385>, <0.036610, -1.197391, -1.004134>, 
      <0.020050, -1.268179, -0.949499>, <0.020215, -1.252561, -0.973078>, <0.031800, -1.243555, -1.026311>, <0.040410, -1.235632, -1.052061>, 
      <0.049108, -1.375239, -1.027967>, <0.050212, -1.354403, -1.061125>, <0.044225, -1.314533, -1.088502>, <0.045477, -1.286620, -1.115963>, 
      <0.045103, -1.417905, -1.072352>, <0.046208, -1.397070, -1.105511>, <0.048025, -1.352774, -1.136428>, <0.049277, -1.324861, -1.163889>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.241482, -1.219073, -0.884355>, <0.233979, -1.210468, -0.912216>, <0.228180, -1.187414, -0.949646>, <0.216473, -1.190391, -0.977226>, 
      <0.171411, -1.220491, -0.894539>, <0.163908, -1.211887, -0.922401>, <0.189632, -1.157081, -0.925666>, <0.177924, -1.160058, -0.953246>, 
      <0.049204, -1.181992, -0.878773>, <0.049369, -1.166374, -0.902352>, <0.081959, -1.203214, -0.970312>, <0.090569, -1.195291, -0.996062>, 
      <0.007911, -1.223801, -0.918303>, <0.008076, -1.208183, -0.941882>, <0.028000, -1.205314, -0.978385>, <0.036610, -1.197391, -1.004134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.238958, -1.413504, -1.067794>, <0.235975, -1.398781, -1.089720>, <0.227445, -1.364622, -1.104182>, <0.222511, -1.343672, -1.119777>, 
      <0.285716, -1.366162, -1.023031>, <0.282734, -1.351438, -1.044957>, <0.225634, -1.318637, -1.061417>, <0.220700, -1.297688, -1.077012>, 
      <0.240725, -1.277402, -0.939387>, <0.233222, -1.268798, -0.967248>, <0.272535, -1.222315, -0.977237>, <0.260827, -1.225292, -1.004817>, 
      <0.241482, -1.219073, -0.884355>, <0.233979, -1.210468, -0.912216>, <0.228180, -1.187414, -0.949646>, <0.216473, -1.190391, -0.977226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.238958, -1.413504, -1.067794>, <0.205032, -1.447854, -1.100272>, <0.085326, -1.450930, -1.098377>, <0.045103, -1.417905, -1.072352>, 
      <0.235975, -1.398781, -1.089720>, <0.202049, -1.433131, -1.122199>, <0.086430, -1.430095, -1.131535>, <0.046208, -1.397070, -1.105511>, 
      <0.227445, -1.364622, -1.104182>, <0.175475, -1.358978, -1.117416>, <0.099995, -1.358418, -1.123194>, <0.048025, -1.352774, -1.136428>, 
      <0.222511, -1.343672, -1.119777>, <0.170541, -1.338029, -1.133011>, <0.101247, -1.330504, -1.150655>, <0.049277, -1.324861, -1.163889>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.035808, -1.273231, -0.889639>, <0.027439, -1.258402, -0.898238>, <0.007800, -1.234335, -0.902400>, <0.007911, -1.223801, -0.918303>, 
      <-0.000858, -1.308636, -0.915093>, <0.046742, -1.293807, -0.912929>, <0.019938, -1.278713, -0.933596>, <0.020050, -1.268179, -0.949499>, 
      <0.001626, -1.397662, -0.975807>, <0.002050, -1.393949, -0.998677>, <0.048454, -1.387563, -1.008353>, <0.049108, -1.375239, -1.027967>, 
      <0.043688, -1.430282, -0.996118>, <0.044112, -1.426569, -1.018988>, <0.044450, -1.430229, -1.052738>, <0.045103, -1.417905, -1.072352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.222046, -1.258059, -0.872298>, <0.227877, -1.246363, -0.875915>, <0.235651, -1.230769, -0.880738>, <0.241482, -1.219073, -0.884355>, 
      <0.180482, -1.225826, -0.852227>, <0.186313, -1.214130, -0.855844>, <0.165580, -1.232187, -0.890922>, <0.171411, -1.220491, -0.894539>, 
      <0.072040, -1.238246, -0.864486>, <0.063671, -1.223416, -0.873085>, <0.049092, -1.192526, -0.862869>, <0.049204, -1.181992, -0.878773>, 
      <0.035808, -1.273231, -0.889639>, <0.027439, -1.258402, -0.898238>, <0.007800, -1.234335, -0.902400>, <0.007911, -1.223801, -0.918303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.240379, -1.431877, -0.988424>, <0.239953, -1.426365, -1.012235>, <0.241701, -1.427045, -1.047629>, <0.238958, -1.413504, -1.067794>, 
      <0.280894, -1.392756, -0.960298>, <0.280468, -1.387244, -0.984109>, <0.288460, -1.379703, -1.002866>, <0.285716, -1.366162, -1.023031>, 
      <0.268524, -1.294103, -0.894742>, <0.274355, -1.282407, -0.898359>, <0.234894, -1.289098, -0.935770>, <0.240725, -1.277402, -0.939387>, 
      <0.222046, -1.258059, -0.872298>, <0.227877, -1.246363, -0.875915>, <0.235651, -1.230769, -0.880738>, <0.241482, -1.219073, -0.884355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.240379, -1.431877, -0.988424>, <0.202373, -1.468576, -1.014809>, <0.087288, -1.464094, -1.017172>, <0.043688, -1.430282, -0.996118>, 
      <0.239953, -1.426365, -1.012235>, <0.201947, -1.463064, -1.038620>, <0.087712, -1.460381, -1.040042>, <0.044112, -1.426569, -1.018988>, 
      <0.241701, -1.427045, -1.047629>, <0.207775, -1.461396, -1.080107>, <0.084672, -1.463254, -1.078763>, <0.044450, -1.430229, -1.052738>, 
      <0.238958, -1.413504, -1.067794>, <0.205032, -1.447854, -1.100272>, <0.085326, -1.450930, -1.098377>, <0.045103, -1.417905, -1.072352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.133079, -1.404518, -1.144936>, <0.115432, -1.401021, -1.136343>, <0.112261, -1.431016, -1.177009>, <0.103339, -1.442372, -1.190755>, 
      <0.158748, -1.394028, -1.133869>, <0.141100, -1.390530, -1.125276>, <0.106552, -1.425093, -1.162902>, <0.097630, -1.436449, -1.176648>, 
      <0.185227, -1.410950, -1.190679>, <0.148247, -1.413627, -1.170713>, <0.124452, -1.411118, -1.139893>, <0.091226, -1.431977, -1.155197>, 
      <0.207576, -1.413707, -1.210283>, <0.170596, -1.416383, -1.190317>, <0.117537, -1.401770, -1.128427>, <0.084310, -1.422628, -1.143731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.092151, -1.480074, -1.266125>, <0.069577, -1.475601, -1.255132>, <0.099983, -1.453683, -1.213366>, <0.103339, -1.442372, -1.190755>, 
      <0.084961, -1.486120, -1.269643>, <0.062387, -1.481647, -1.258650>, <0.094274, -1.447759, -1.199259>, <0.097630, -1.436449, -1.176648>, 
      <0.073816, -1.493438, -1.275858>, <0.048879, -1.475524, -1.241470>, <0.054851, -1.454812, -1.171951>, <0.091226, -1.431977, -1.155197>, 
      <0.067859, -1.501416, -1.274637>, <0.042922, -1.483502, -1.240249>, <0.047935, -1.445463, -1.160486>, <0.084310, -1.422628, -1.143731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.175747, -1.456721, -1.226014>, <0.178842, -1.468423, -1.243425>, <0.176375, -1.484205, -1.269117>, <0.186064, -1.495727, -1.284051>, 
      <0.162947, -1.441060, -1.201691>, <0.166042, -1.452762, -1.219102>, <0.202979, -1.467504, -1.256863>, <0.212668, -1.479026, -1.271797>, 
      <0.161080, -1.410067, -1.158571>, <0.186748, -1.399576, -1.147504>, <0.178773, -1.435556, -1.212809>, <0.201122, -1.438313, -1.232413>, 
      <0.133079, -1.404518, -1.144936>, <0.158748, -1.394028, -1.133869>, <0.185227, -1.410950, -1.190679>, <0.207576, -1.413707, -1.210283>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.175747, -1.456721, -1.226014>, <0.150668, -1.463727, -1.238047>, <0.117541, -1.485106, -1.278489>, <0.092151, -1.480074, -1.266125>, 
      <0.178842, -1.468423, -1.243425>, <0.153763, -1.475429, -1.255459>, <0.110351, -1.491152, -1.282006>, <0.084961, -1.486120, -1.269643>, 
      <0.176375, -1.484205, -1.269117>, <0.148274, -1.501845, -1.282061>, <0.093080, -1.507277, -1.302424>, <0.073816, -1.493438, -1.275858>, 
      <0.186064, -1.495727, -1.284051>, <0.157963, -1.513368, -1.296994>, <0.087124, -1.515256, -1.301203>, <0.067859, -1.501416, -1.274637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.138670, -1.441868, -1.239992>, <0.147124, -1.426262, -1.214961>, <0.106698, -1.415299, -1.156310>, <0.133079, -1.404518, -1.144936>, 
      <0.133246, -1.451881, -1.256052>, <0.141700, -1.436275, -1.231021>, <0.089051, -1.411802, -1.147717>, <0.115432, -1.401021, -1.136343>, 
      <0.106262, -1.468208, -1.259221>, <0.083688, -1.463734, -1.248229>, <0.108905, -1.442326, -1.199620>, <0.112261, -1.431016, -1.177009>, 
      <0.092151, -1.480074, -1.266125>, <0.069577, -1.475601, -1.255132>, <0.099983, -1.453683, -1.213366>, <0.103339, -1.442372, -1.190755>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.138670, -1.441868, -1.239992>, <0.147124, -1.426262, -1.214961>, <0.106698, -1.415299, -1.156310>, <0.133079, -1.404518, -1.144936>, 
      <0.133246, -1.451881, -1.256052>, <0.141700, -1.436275, -1.231021>, <0.134699, -1.420848, -1.169945>, <0.161080, -1.410067, -1.158571>, 
      <0.106262, -1.468208, -1.259221>, <0.131652, -1.473239, -1.271585>, <0.137868, -1.448066, -1.213724>, <0.162947, -1.441060, -1.201691>, 
      <0.092151, -1.480074, -1.266125>, <0.117541, -1.485106, -1.278489>, <0.150668, -1.463727, -1.238047>, <0.175747, -1.456721, -1.226014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.138670, -1.441868, -1.239992>, <0.147124, -1.426262, -1.214961>, <0.106698, -1.415299, -1.156310>, <0.133079, -1.404518, -1.144936>, 
      <0.138670, -1.441868, -1.239992>, <0.131031, -1.423073, -1.207124>, <0.089051, -1.411802, -1.147717>, <0.115432, -1.401021, -1.136343>, 
      <0.138670, -1.441868, -1.239992>, <0.131031, -1.423073, -1.207124>, <0.122860, -1.430865, -1.191780>, <0.112261, -1.431016, -1.177009>, 
      <0.138670, -1.441868, -1.239992>, <0.122577, -1.438679, -1.232156>, <0.113938, -1.442221, -1.205526>, <0.103339, -1.442372, -1.190755>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.138670, -1.441868, -1.239992>, <0.133246, -1.451881, -1.256052>, <0.106262, -1.468208, -1.259221>, <0.092151, -1.480074, -1.266125>, 
      <0.138670, -1.441868, -1.239992>, <0.117153, -1.448692, -1.248216>, <0.083688, -1.463734, -1.248229>, <0.069577, -1.475601, -1.255132>, 
      <0.138670, -1.441868, -1.239992>, <0.117153, -1.448692, -1.248216>, <0.110582, -1.453531, -1.228137>, <0.099983, -1.453683, -1.213366>, 
      <0.138670, -1.441868, -1.239992>, <0.122577, -1.438679, -1.232156>, <0.113938, -1.442221, -1.205526>, <0.103339, -1.442372, -1.190755>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.138670, -1.441868, -1.239992>, <0.122577, -1.438679, -1.232156>, <0.113938, -1.442221, -1.205526>, <0.103339, -1.442372, -1.190755>, 
      <0.149907, -1.444095, -1.245464>, <0.133814, -1.440906, -1.237627>, <0.110582, -1.453531, -1.228137>, <0.099983, -1.453683, -1.213366>, 
      <0.164624, -1.452265, -1.230207>, <0.139545, -1.459271, -1.242241>, <0.094967, -1.480632, -1.267496>, <0.069577, -1.475601, -1.255132>, 
      <0.175747, -1.456721, -1.226014>, <0.150668, -1.463727, -1.238047>, <0.117541, -1.485106, -1.278489>, <0.092151, -1.480074, -1.266125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.138670, -1.441868, -1.239992>, <0.133246, -1.451881, -1.256052>, <0.106262, -1.468208, -1.259221>, <0.092151, -1.480074, -1.266125>, 
      <0.138670, -1.441868, -1.239992>, <0.144483, -1.454108, -1.261524>, <0.131652, -1.473239, -1.271585>, <0.117541, -1.485106, -1.278489>, 
      <0.138670, -1.441868, -1.239992>, <0.144483, -1.454108, -1.261524>, <0.139545, -1.459271, -1.242241>, <0.150668, -1.463727, -1.238047>, 
      <0.138670, -1.441868, -1.239992>, <0.149907, -1.444095, -1.245464>, <0.164624, -1.452265, -1.230207>, <0.175747, -1.456721, -1.226014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.138670, -1.441868, -1.239992>, <0.122577, -1.438679, -1.232156>, <0.113938, -1.442221, -1.205526>, <0.103339, -1.442372, -1.190755>, 
      <0.149907, -1.444095, -1.245464>, <0.133814, -1.440906, -1.237627>, <0.122860, -1.430865, -1.191780>, <0.112261, -1.431016, -1.177009>, 
      <0.164624, -1.452265, -1.230207>, <0.151824, -1.436604, -1.205884>, <0.143432, -1.406570, -1.149977>, <0.115432, -1.401021, -1.136343>, 
      <0.175747, -1.456721, -1.226014>, <0.162947, -1.441060, -1.201691>, <0.161080, -1.410067, -1.158571>, <0.133079, -1.404518, -1.144936>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.138670, -1.441868, -1.239992>, <0.149907, -1.444095, -1.245464>, <0.164624, -1.452265, -1.230207>, <0.175747, -1.456721, -1.226014>, 
      <0.138670, -1.441868, -1.239992>, <0.158360, -1.428489, -1.220432>, <0.151824, -1.436604, -1.205884>, <0.162947, -1.441060, -1.201691>, 
      <0.138670, -1.441868, -1.239992>, <0.158360, -1.428489, -1.220432>, <0.134699, -1.420848, -1.169945>, <0.161080, -1.410067, -1.158571>, 
      <0.138670, -1.441868, -1.239992>, <0.147124, -1.426262, -1.214961>, <0.106698, -1.415299, -1.156310>, <0.133079, -1.404518, -1.144936>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.051790, -1.534132, -1.257851>, <0.056611, -1.524317, -1.262887>, <0.060710, -1.510991, -1.273171>, <0.067859, -1.501416, -1.274637>, 
      <0.053601, -1.488148, -1.215086>, <0.058422, -1.478333, -1.220122>, <0.035774, -1.493076, -1.238783>, <0.042922, -1.483502, -1.240249>, 
      <0.013474, -1.415752, -1.142893>, <0.020129, -1.417445, -1.158570>, <0.040687, -1.435665, -1.148469>, <0.047935, -1.445463, -1.160486>, 
      <0.057828, -1.380851, -1.115302>, <0.064483, -1.382543, -1.130979>, <0.077062, -1.412830, -1.131714>, <0.084310, -1.422628, -1.143731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.051790, -1.534132, -1.257851>, <0.103761, -1.528489, -1.271085>, <0.173055, -1.520964, -1.288730>, <0.225025, -1.515321, -1.301964>, 
      <0.056611, -1.524317, -1.262887>, <0.108581, -1.518674, -1.276121>, <0.161366, -1.515086, -1.283356>, <0.213337, -1.509443, -1.296590>, 
      <0.060710, -1.510991, -1.273171>, <0.079975, -1.524830, -1.299738>, <0.164426, -1.521053, -1.306955>, <0.192527, -1.503412, -1.294012>, 
      <0.067859, -1.501416, -1.274637>, <0.087124, -1.515256, -1.301203>, <0.157963, -1.513368, -1.296994>, <0.186064, -1.495727, -1.284051>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237691, -1.387852, -1.142210>, <0.228657, -1.395608, -1.162632>, <0.216611, -1.405951, -1.189861>, <0.207576, -1.413707, -1.210283>, 
      <0.233891, -1.426093, -1.190136>, <0.224857, -1.433849, -1.210558>, <0.210157, -1.430557, -1.211992>, <0.201122, -1.438313, -1.232413>, 
      <0.228825, -1.477080, -1.254038>, <0.217137, -1.471202, -1.248664>, <0.219131, -1.486711, -1.281758>, <0.212668, -1.479026, -1.271797>, 
      <0.225025, -1.515321, -1.301964>, <0.213337, -1.509443, -1.296590>, <0.192527, -1.503412, -1.294012>, <0.186064, -1.495727, -1.284051>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237691, -1.387852, -1.142210>, <0.183732, -1.385752, -1.134138>, <0.096377, -1.350518, -1.091322>, <0.057828, -1.380851, -1.115302>, 
      <0.228657, -1.395608, -1.162632>, <0.174698, -1.393508, -1.154560>, <0.103032, -1.352210, -1.107000>, <0.064483, -1.382543, -1.130979>, 
      <0.216611, -1.405951, -1.189861>, <0.179631, -1.408627, -1.169896>, <0.110289, -1.391972, -1.116410>, <0.077062, -1.412830, -1.131714>, 
      <0.207576, -1.413707, -1.210283>, <0.170596, -1.416383, -1.190317>, <0.117537, -1.401770, -1.128427>, <0.084310, -1.422628, -1.143731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.266390, -1.414262, -1.056378>, <0.266225, -1.398644, -1.079957>, <0.246301, -1.395775, -1.116460>, <0.237691, -1.387852, -1.142210>, 
      <0.310221, -1.458640, -1.098338>, <0.310055, -1.443022, -1.121917>, <0.242501, -1.434016, -1.164387>, <0.233891, -1.426093, -1.190136>, 
      <0.281163, -1.565700, -1.176805>, <0.280058, -1.544864, -1.209964>, <0.230077, -1.504994, -1.226577>, <0.228825, -1.477080, -1.254038>, 
      <0.229198, -1.608365, -1.210427>, <0.228093, -1.587530, -1.243586>, <0.226277, -1.543234, -1.274503>, <0.225025, -1.515321, -1.301964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.032819, -1.409534, -1.022430>, <0.040322, -1.400929, -1.050291>, <0.046121, -1.377874, -1.087722>, <0.057828, -1.380851, -1.115302>, 
      <0.102890, -1.410952, -1.032614>, <0.110393, -1.402348, -1.060476>, <0.084669, -1.347541, -1.063742>, <0.096377, -1.350518, -1.091322>, 
      <0.225097, -1.372454, -1.016847>, <0.224932, -1.356835, -1.040427>, <0.192342, -1.393675, -1.108388>, <0.183732, -1.385752, -1.134138>, 
      <0.266390, -1.414262, -1.056378>, <0.266225, -1.398644, -1.079957>, <0.246301, -1.395775, -1.116460>, <0.237691, -1.387852, -1.142210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.035343, -1.603963, -1.205869>, <0.038325, -1.589240, -1.227795>, <0.046856, -1.555081, -1.242256>, <0.051790, -1.534132, -1.257851>, 
      <-0.011415, -1.556621, -1.161107>, <-0.008433, -1.541897, -1.183032>, <0.048667, -1.509097, -1.199492>, <0.053601, -1.488148, -1.215086>, 
      <0.033576, -1.467863, -1.077462>, <0.041079, -1.459258, -1.105323>, <0.001766, -1.412775, -1.115313>, <0.013474, -1.415752, -1.142893>, 
      <0.032819, -1.409534, -1.022430>, <0.040322, -1.400929, -1.050291>, <0.046121, -1.377874, -1.087722>, <0.057828, -1.380851, -1.115302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.035343, -1.603963, -1.205869>, <0.069269, -1.638313, -1.238347>, <0.188975, -1.641390, -1.236452>, <0.229198, -1.608365, -1.210427>, 
      <0.038325, -1.589240, -1.227795>, <0.072252, -1.623590, -1.260273>, <0.187871, -1.620554, -1.269610>, <0.228093, -1.587530, -1.243586>, 
      <0.046856, -1.555081, -1.242256>, <0.098826, -1.549438, -1.255490>, <0.174306, -1.548877, -1.261269>, <0.226277, -1.543234, -1.274503>, 
      <0.051790, -1.534132, -1.257851>, <0.103761, -1.528489, -1.271085>, <0.173055, -1.520964, -1.288730>, <0.225025, -1.515321, -1.301964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.238493, -1.463691, -1.027714>, <0.246862, -1.448862, -1.036313>, <0.266501, -1.424796, -1.040475>, <0.266390, -1.414262, -1.056378>, 
      <0.275159, -1.499096, -1.053168>, <0.283528, -1.484267, -1.061768>, <0.310332, -1.469174, -1.082435>, <0.310221, -1.458640, -1.098338>, 
      <0.272676, -1.588122, -1.113882>, <0.272251, -1.584409, -1.136752>, <0.281816, -1.578024, -1.157191>, <0.281163, -1.565700, -1.176805>, 
      <0.230614, -1.620742, -1.134193>, <0.230189, -1.617029, -1.157063>, <0.229851, -1.620689, -1.190813>, <0.229198, -1.608365, -1.210427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.052256, -1.448519, -1.010373>, <0.046425, -1.436824, -1.013990>, <0.038650, -1.421229, -1.018813>, <0.032819, -1.409534, -1.022430>, 
      <0.093820, -1.416286, -0.990302>, <0.087989, -1.404590, -0.993919>, <0.108721, -1.422648, -1.028997>, <0.102890, -1.410952, -1.032614>, 
      <0.202261, -1.428706, -1.002561>, <0.210631, -1.413877, -1.011160>, <0.225209, -1.382987, -1.000944>, <0.225097, -1.372454, -1.016847>, 
      <0.238493, -1.463691, -1.027714>, <0.246862, -1.448862, -1.036313>, <0.266501, -1.424796, -1.040475>, <0.266390, -1.414262, -1.056378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.033923, -1.622337, -1.126499>, <0.034349, -1.616825, -1.150310>, <0.032600, -1.617504, -1.185704>, <0.035343, -1.603963, -1.205869>, 
      <-0.006592, -1.583216, -1.098373>, <-0.006166, -1.577703, -1.122184>, <-0.014158, -1.570162, -1.140941>, <-0.011415, -1.556621, -1.161107>, 
      <0.005778, -1.484563, -1.032817>, <-0.000053, -1.472867, -1.036434>, <0.039407, -1.479558, -1.073845>, <0.033576, -1.467863, -1.077462>, 
      <0.052256, -1.448519, -1.010373>, <0.046425, -1.436824, -1.013990>, <0.038650, -1.421229, -1.018813>, <0.032819, -1.409534, -1.022430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.033923, -1.622337, -1.126499>, <0.071929, -1.659036, -1.152884>, <0.187015, -1.654554, -1.155247>, <0.230614, -1.620742, -1.134193>, 
      <0.034349, -1.616825, -1.150310>, <0.072355, -1.653524, -1.176695>, <0.186590, -1.650841, -1.178117>, <0.230189, -1.617029, -1.157063>, 
      <0.032600, -1.617504, -1.185704>, <0.066527, -1.651855, -1.218182>, <0.189629, -1.653714, -1.216838>, <0.229851, -1.620689, -1.190813>, 
      <0.035343, -1.603963, -1.205869>, <0.069269, -1.638313, -1.238347>, <0.188975, -1.641390, -1.236452>, <0.229198, -1.608365, -1.210427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.215011, -1.430500, -1.160517>, <1.197880, -1.427105, -1.151817>, <1.195051, -1.455906, -1.192590>, <1.186496, -1.466794, -1.206335>, 
      <1.239934, -1.420314, -1.149310>, <1.222803, -1.416920, -1.140611>, <1.189577, -1.450226, -1.178482>, <1.181023, -1.461115, -1.192228>, 
      <1.265012, -1.436666, -1.206258>, <1.229555, -1.439232, -1.186293>, <1.206938, -1.436842, -1.155533>, <1.174952, -1.456922, -1.170898>, 
      <1.286441, -1.439309, -1.225862>, <1.250984, -1.441875, -1.205897>, <1.200237, -1.427783, -1.143945>, <1.168251, -1.447863, -1.159311>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.175769, -1.502943, -1.281705>, <1.153570, -1.498544, -1.270431>, <1.183278, -1.477639, -1.228946>, <1.186496, -1.466794, -1.206335>, 
      <1.168893, -1.508725, -1.285214>, <1.146694, -1.504326, -1.273940>, <1.177804, -1.471959, -1.214839>, <1.181023, -1.461115, -1.192228>, 
      <1.158202, -1.515740, -1.291441>, <1.134123, -1.498442, -1.256810>, <1.139188, -1.479373, -1.188079>, <1.174952, -1.456922, -1.170898>, 
      <1.152478, -1.523406, -1.290217>, <1.128399, -1.506108, -1.255586>, <1.132487, -1.470314, -1.176492>, <1.168251, -1.447863, -1.159311>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.255923, -1.480552, -1.241593>, <1.258891, -1.491772, -1.259004>, <1.256455, -1.506822, -1.284586>, <1.265815, -1.517952, -1.299631>, 
      <1.243649, -1.465536, -1.217270>, <1.246617, -1.476756, -1.234682>, <1.282292, -1.490602, -1.272174>, <1.291652, -1.501732, -1.287219>, 
      <1.242324, -1.435912, -1.174388>, <1.267247, -1.425727, -1.163181>, <1.258824, -1.460259, -1.228389>, <1.280253, -1.462902, -1.247993>, 
      <1.215011, -1.430500, -1.160517>, <1.239934, -1.420314, -1.149310>, <1.265012, -1.436666, -1.206258>, <1.286441, -1.439309, -1.225862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.255923, -1.480552, -1.241593>, <1.231877, -1.487269, -1.253627>, <1.200104, -1.507765, -1.294063>, <1.175769, -1.502943, -1.281705>, 
      <1.258891, -1.491772, -1.259004>, <1.234844, -1.498489, -1.271038>, <1.193227, -1.513548, -1.297572>, <1.168893, -1.508725, -1.285214>, 
      <1.256455, -1.506822, -1.284586>, <1.229659, -1.523643, -1.297458>, <1.176243, -1.528700, -1.317388>, <1.158202, -1.515740, -1.291441>, 
      <1.265815, -1.517952, -1.299631>, <1.239019, -1.534774, -1.312504>, <1.170519, -1.536367, -1.316165>, <1.152478, -1.523406, -1.290217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.220372, -1.466311, -1.255571>, <1.228544, -1.451226, -1.230335>, <1.188933, -1.441158, -1.172244>, <1.215011, -1.430500, -1.160517>, 
      <1.215282, -1.475707, -1.271290>, <1.223454, -1.460622, -1.246054>, <1.171802, -1.437763, -1.163544>, <1.197880, -1.427105, -1.151817>, 
      <1.189320, -1.491548, -1.274790>, <1.167121, -1.487149, -1.263517>, <1.191832, -1.466751, -1.215200>, <1.195051, -1.455906, -1.192590>, 
      <1.175769, -1.502943, -1.281705>, <1.153570, -1.498544, -1.270431>, <1.183278, -1.477639, -1.228946>, <1.186496, -1.466794, -1.206335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.220372, -1.466311, -1.255571>, <1.228544, -1.451226, -1.230335>, <1.188933, -1.441158, -1.172244>, <1.215011, -1.430500, -1.160517>, 
      <1.215282, -1.475707, -1.271290>, <1.223454, -1.460622, -1.246054>, <1.216246, -1.446570, -1.186114>, <1.242324, -1.435912, -1.174388>, 
      <1.189320, -1.491548, -1.274790>, <1.213654, -1.496370, -1.287148>, <1.219603, -1.472254, -1.229304>, <1.243649, -1.465536, -1.217270>, 
      <1.175769, -1.502943, -1.281705>, <1.200104, -1.507765, -1.294063>, <1.231877, -1.487269, -1.253627>, <1.255923, -1.480552, -1.241593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.220372, -1.466311, -1.255571>, <1.228544, -1.451226, -1.230335>, <1.188933, -1.441158, -1.172244>, <1.215011, -1.430500, -1.160517>, 
      <1.220372, -1.466311, -1.255571>, <1.212801, -1.448106, -1.222341>, <1.171802, -1.437763, -1.163544>, <1.197880, -1.427105, -1.151817>, 
      <1.220372, -1.466311, -1.255571>, <1.212801, -1.448106, -1.222341>, <1.205213, -1.455761, -1.207360>, <1.195051, -1.455906, -1.192590>, 
      <1.220372, -1.466311, -1.255571>, <1.204629, -1.463191, -1.247576>, <1.196659, -1.466649, -1.221106>, <1.186496, -1.466794, -1.206335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.220372, -1.466311, -1.255571>, <1.215282, -1.475707, -1.271290>, <1.189320, -1.491548, -1.274790>, <1.175769, -1.502943, -1.281705>, 
      <1.220372, -1.466311, -1.255571>, <1.199539, -1.472588, -1.263295>, <1.167121, -1.487149, -1.263517>, <1.153570, -1.498544, -1.270431>, 
      <1.220372, -1.466311, -1.255571>, <1.199539, -1.472588, -1.263295>, <1.193441, -1.477494, -1.243717>, <1.183278, -1.477639, -1.228946>, 
      <1.220372, -1.466311, -1.255571>, <1.204629, -1.463191, -1.247576>, <1.196659, -1.466649, -1.221106>, <1.186496, -1.466794, -1.206335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.220372, -1.466311, -1.255571>, <1.204629, -1.463191, -1.247576>, <1.196659, -1.466649, -1.221106>, <1.186496, -1.466794, -1.206335>, 
      <1.231111, -1.468439, -1.261025>, <1.215368, -1.465319, -1.253030>, <1.193441, -1.477494, -1.243717>, <1.183278, -1.477639, -1.228946>, 
      <1.245258, -1.476280, -1.245786>, <1.221212, -1.482997, -1.257820>, <1.177905, -1.503366, -1.282790>, <1.153570, -1.498544, -1.270431>, 
      <1.255923, -1.480552, -1.241593>, <1.231877, -1.487269, -1.253627>, <1.200104, -1.507765, -1.294063>, <1.175769, -1.502943, -1.281705>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.220372, -1.466311, -1.255571>, <1.215282, -1.475707, -1.271290>, <1.189320, -1.491548, -1.274790>, <1.175769, -1.502943, -1.281705>, 
      <1.220372, -1.466311, -1.255571>, <1.226021, -1.477835, -1.276744>, <1.213654, -1.496370, -1.287148>, <1.200104, -1.507765, -1.294063>, 
      <1.220372, -1.466311, -1.255571>, <1.226021, -1.477835, -1.276744>, <1.221212, -1.482997, -1.257820>, <1.231877, -1.487269, -1.253627>, 
      <1.220372, -1.466311, -1.255571>, <1.231111, -1.468439, -1.261025>, <1.245258, -1.476280, -1.245786>, <1.255923, -1.480552, -1.241593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.220372, -1.466311, -1.255571>, <1.204629, -1.463191, -1.247576>, <1.196659, -1.466649, -1.221106>, <1.186496, -1.466794, -1.206335>, 
      <1.231111, -1.468439, -1.261025>, <1.215368, -1.465319, -1.253030>, <1.205213, -1.455761, -1.207360>, <1.195051, -1.455906, -1.192590>, 
      <1.245258, -1.476280, -1.245786>, <1.232984, -1.461264, -1.221464>, <1.225194, -1.432518, -1.165688>, <1.197880, -1.427105, -1.151817>, 
      <1.255923, -1.480552, -1.241593>, <1.243649, -1.465536, -1.217270>, <1.242324, -1.435912, -1.174388>, <1.215011, -1.430500, -1.160517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.220372, -1.466311, -1.255571>, <1.231111, -1.468439, -1.261025>, <1.245258, -1.476280, -1.245786>, <1.255923, -1.480552, -1.241593>, 
      <1.220372, -1.466311, -1.255571>, <1.239282, -1.453354, -1.235789>, <1.232984, -1.461264, -1.221464>, <1.243649, -1.465536, -1.217270>, 
      <1.220372, -1.466311, -1.255571>, <1.239282, -1.453354, -1.235789>, <1.216246, -1.446570, -1.186114>, <1.242324, -1.435912, -1.174388>, 
      <1.220372, -1.466311, -1.255571>, <1.228544, -1.451226, -1.230335>, <1.188933, -1.441158, -1.172244>, <1.215011, -1.430500, -1.160517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.137070, -1.554776, -1.273432>, <1.141692, -1.545365, -1.278468>, <1.145576, -1.532651, -1.288742>, <1.152478, -1.523406, -1.290217>, 
      <1.138807, -1.510685, -1.230667>, <1.143429, -1.501274, -1.235702>, <1.121497, -1.515353, -1.254111>, <1.128399, -1.506108, -1.255586>, 
      <1.099839, -1.441659, -1.158792>, <1.106064, -1.443242, -1.174087>, <1.125610, -1.461017, -1.164599>, <1.132487, -1.470314, -1.176492>, 
      <1.142860, -1.407806, -1.130881>, <1.149085, -1.409389, -1.146175>, <1.161373, -1.438566, -1.147418>, <1.168251, -1.447863, -1.159311>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.137070, -1.554776, -1.273432>, <1.186901, -1.549365, -1.286666>, <1.266877, -1.565299, -1.341092>, <1.303172, -1.536739, -1.317544>, 
      <1.141692, -1.545365, -1.278468>, <1.191523, -1.539954, -1.291701>, <1.262760, -1.554548, -1.348421>, <1.299055, -1.525988, -1.324873>, 
      <1.145576, -1.532651, -1.288742>, <1.163617, -1.545611, -1.314689>, <1.245123, -1.542033, -1.322316>, <1.271919, -1.525211, -1.309444>, 
      <1.152478, -1.523406, -1.290217>, <1.170519, -1.536367, -1.316165>, <1.239019, -1.534774, -1.312504>, <1.265815, -1.517952, -1.299631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.315316, -1.414518, -1.157789>, <1.306653, -1.421955, -1.178211>, <1.295103, -1.431872, -1.205440>, <1.286441, -1.439309, -1.225862>, 
      <1.311673, -1.451184, -1.205715>, <1.303010, -1.458622, -1.226137>, <1.288916, -1.455465, -1.227571>, <1.280253, -1.462902, -1.247993>, 
      <1.345497, -1.503434, -1.290084>, <1.341380, -1.492683, -1.297413>, <1.297756, -1.508992, -1.297031>, <1.291652, -1.501732, -1.287219>, 
      <1.303172, -1.536739, -1.317544>, <1.299055, -1.525988, -1.324873>, <1.271919, -1.525211, -1.309444>, <1.265815, -1.517952, -1.299631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.315316, -1.414518, -1.157789>, <1.263579, -1.412504, -1.149717>, <1.179548, -1.378937, -1.107079>, <1.142860, -1.407806, -1.130881>, 
      <1.306653, -1.421955, -1.178211>, <1.254917, -1.419942, -1.170139>, <1.185772, -1.380521, -1.122373>, <1.149085, -1.409389, -1.146175>, 
      <1.295103, -1.431872, -1.205440>, <1.259646, -1.434438, -1.185475>, <1.193359, -1.418486, -1.132052>, <1.161373, -1.438566, -1.147418>, 
      <1.286441, -1.439309, -1.225862>, <1.250984, -1.441875, -1.205897>, <1.200237, -1.427783, -1.143945>, <1.168251, -1.447863, -1.159311>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.342834, -1.439841, -1.071958>, <1.342675, -1.424783, -1.095667>, <1.323571, -1.422115, -1.132040>, <1.315316, -1.414518, -1.157789>, 
      <1.384979, -1.482512, -1.114036>, <1.384819, -1.467454, -1.137746>, <1.319928, -1.458781, -1.179966>, <1.311673, -1.451184, -1.205715>, 
      <1.357379, -1.584731, -1.192128>, <1.356330, -1.564939, -1.224977>, <1.357071, -1.533657, -1.269481>, <1.345497, -1.503434, -1.290084>, 
      <1.307173, -1.625952, -1.226007>, <1.306124, -1.606161, -1.258856>, <1.314746, -1.566962, -1.296941>, <1.303172, -1.536739, -1.317544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.118880, -1.435308, -1.038010>, <1.126074, -1.427057, -1.065871>, <1.131627, -1.404949, -1.103282>, <1.142860, -1.407806, -1.130881>, 
      <1.186066, -1.436668, -1.048194>, <1.193260, -1.428417, -1.076056>, <1.168314, -1.376081, -1.079479>, <1.179548, -1.378937, -1.107079>, 
      <1.303736, -1.400255, -1.032921>, <1.303577, -1.385197, -1.056631>, <1.271835, -1.420101, -1.123967>, <1.263579, -1.412504, -1.149717>, 
      <1.342834, -1.439841, -1.071958>, <1.342675, -1.424783, -1.095667>, <1.323571, -1.422115, -1.132040>, <1.315316, -1.414518, -1.157789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121300, -1.621732, -1.221449>, <1.124120, -1.607813, -1.243068>, <1.132339, -1.574863, -1.257837>, <1.137070, -1.554776, -1.273432>, 
      <1.076163, -1.576031, -1.176383>, <1.078983, -1.562112, -1.198001>, <1.134076, -1.530772, -1.215072>, <1.138807, -1.510685, -1.230667>, 
      <1.119606, -1.491235, -1.093042>, <1.126800, -1.482984, -1.120903>, <1.088605, -1.438802, -1.131193>, <1.099839, -1.441659, -1.158792>, 
      <1.118880, -1.435308, -1.038010>, <1.126074, -1.427057, -1.065871>, <1.131627, -1.404949, -1.103282>, <1.142860, -1.407806, -1.130881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121300, -1.621732, -1.221449>, <1.153395, -1.654228, -1.253493>, <1.268940, -1.657344, -1.251807>, <1.307173, -1.625952, -1.226007>, 
      <1.124120, -1.607813, -1.243068>, <1.156214, -1.640308, -1.275112>, <1.267891, -1.637552, -1.284656>, <1.306124, -1.606161, -1.258856>, 
      <1.132339, -1.574863, -1.257837>, <1.182170, -1.569452, -1.271071>, <1.278450, -1.595522, -1.320489>, <1.314746, -1.566962, -1.296941>, 
      <1.137070, -1.554776, -1.273432>, <1.186901, -1.549365, -1.286666>, <1.266877, -1.565299, -1.341092>, <1.303172, -1.536739, -1.317544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.125693, -0.282863, -2.259192>, <0.124887, -0.282671, -2.324354>, <0.136109, -0.280090, -2.409356>, <0.201271, -0.280090, -2.410162>, 
      <0.125681, -0.299983, -2.260148>, <0.124875, -0.299792, -2.325310>, <0.136232, -0.316713, -2.399381>, <0.201394, -0.316713, -2.400187>, 
      <0.121438, -0.323410, -2.260563>, <0.120045, -0.318809, -2.318603>, <0.143340, -0.364347, -2.379428>, <0.201574, -0.364347, -2.380149>, 
      <0.125654, -0.339931, -2.262378>, <0.124261, -0.335331, -2.320418>, <0.143448, -0.402165, -2.376192>, <0.201682, -0.402165, -2.376912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.204560, -0.280872, -2.144214>, <0.150748, -0.280872, -2.143548>, <0.126359, -0.283021, -2.205381>, <0.125693, -0.282863, -2.259192>, 
      <0.204539, -0.320043, -2.178911>, <0.150728, -0.320043, -2.178245>, <0.126347, -0.300142, -2.206336>, <0.125681, -0.299983, -2.260148>, 
      <0.204512, -0.372271, -2.225173>, <0.180861, -0.350818, -2.225926>, <0.122421, -0.326655, -2.219613>, <0.121438, -0.323410, -2.260563>, 
      <0.204491, -0.411442, -2.259870>, <0.180840, -0.389989, -2.260623>, <0.126637, -0.343177, -2.221428>, <0.125654, -0.339931, -2.262378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.280559, -0.282863, -2.261107>, <0.281224, -0.283021, -2.207296>, <0.258371, -0.280872, -2.144879>, <0.204560, -0.280872, -2.144214>, 
      <0.280547, -0.299983, -2.262063>, <0.281213, -0.300142, -2.208252>, <0.258351, -0.320043, -2.179576>, <0.204539, -0.320043, -2.178911>, 
      <0.284675, -0.323318, -2.263421>, <0.285640, -0.326503, -2.223240>, <0.227320, -0.350818, -2.226500>, <0.204512, -0.372271, -2.225173>, 
      <0.280520, -0.339931, -2.264294>, <0.281484, -0.343116, -2.224113>, <0.227300, -0.389989, -2.261197>, <0.204491, -0.411442, -2.259870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.280559, -0.282863, -2.261107>, <0.280547, -0.299983, -2.262063>, <0.284675, -0.323318, -2.263421>, <0.280520, -0.339931, -2.264294>, 
      <0.279753, -0.282671, -2.326269>, <0.279741, -0.299792, -2.327225>, <0.283282, -0.318718, -2.321461>, <0.279127, -0.335331, -2.322334>, 
      <0.266433, -0.280090, -2.410968>, <0.266556, -0.316713, -2.400993>, <0.259808, -0.364347, -2.380869>, <0.259916, -0.402165, -2.377633>, 
      <0.201271, -0.280090, -2.410162>, <0.201394, -0.316713, -2.400187>, <0.201574, -0.364347, -2.380149>, <0.201682, -0.402165, -2.376912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.165221, -0.437765, -2.276209>, <0.156588, -0.408250, -2.284806>, <0.133505, -0.370696, -2.265758>, <0.125654, -0.339931, -2.262378>, 
      <0.163833, -0.431621, -2.331415>, <0.155201, -0.402106, -2.340012>, <0.132112, -0.366096, -2.323798>, <0.124261, -0.335331, -2.320418>, 
      <0.146699, -0.515063, -2.394703>, <0.146618, -0.480232, -2.390844>, <0.143547, -0.437082, -2.373203>, <0.143448, -0.402165, -2.376192>, 
      <0.201951, -0.518271, -2.389776>, <0.201870, -0.483439, -2.385917>, <0.201782, -0.437082, -2.373924>, <0.201682, -0.402165, -2.376912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.204425, -0.529225, -2.291344>, <0.204445, -0.493890, -2.281902>, <0.204471, -0.446777, -2.269312>, <0.204491, -0.411442, -2.259870>, 
      <0.165797, -0.526983, -2.294789>, <0.165817, -0.491648, -2.285347>, <0.180820, -0.425324, -2.270065>, <0.180840, -0.389989, -2.260623>, 
      <0.166191, -0.442060, -2.237614>, <0.157559, -0.412545, -2.246211>, <0.134488, -0.373942, -2.224808>, <0.126637, -0.343177, -2.221428>, 
      <0.165221, -0.437765, -2.276209>, <0.156588, -0.408250, -2.284806>, <0.133505, -0.370696, -2.265758>, <0.125654, -0.339931, -2.262378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.204425, -0.529225, -2.291344>, <0.203683, -0.525939, -2.320873>, <0.202693, -0.521557, -2.360246>, <0.201951, -0.518271, -2.389776>, 
      <0.204425, -0.529225, -2.291344>, <0.165055, -0.523696, -2.324318>, <0.147441, -0.518350, -2.365174>, <0.146699, -0.515063, -2.394703>, 
      <0.204425, -0.529225, -2.291344>, <0.165055, -0.523696, -2.324318>, <0.164803, -0.435916, -2.292820>, <0.163833, -0.431621, -2.331415>, 
      <0.204425, -0.529225, -2.291344>, <0.165797, -0.526983, -2.294789>, <0.166191, -0.442060, -2.237614>, <0.165221, -0.437765, -2.276209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.240718, -0.442148, -2.269477>, <0.249249, -0.411655, -2.278574>, <0.272536, -0.371850, -2.265971>, <0.280520, -0.339931, -2.264294>, 
      <0.241651, -0.446280, -2.232344>, <0.250182, -0.415787, -2.241441>, <0.273501, -0.375034, -2.225790>, <0.281484, -0.343116, -2.224113>, 
      <0.241589, -0.531383, -2.288030>, <0.241609, -0.496048, -2.278588>, <0.227280, -0.425324, -2.270639>, <0.227300, -0.389989, -2.261197>, 
      <0.204425, -0.529225, -2.291344>, <0.204445, -0.493890, -2.281902>, <0.204471, -0.446777, -2.269312>, <0.204491, -0.411442, -2.259870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.240718, -0.442148, -2.269477>, <0.239296, -0.435852, -2.326053>, <0.258574, -0.521558, -2.384727>, <0.201951, -0.518271, -2.389776>, 
      <0.249249, -0.411655, -2.278574>, <0.247827, -0.405359, -2.335150>, <0.258494, -0.486727, -2.380868>, <0.201870, -0.483439, -2.385917>, 
      <0.272536, -0.371850, -2.265971>, <0.271143, -0.367249, -2.324011>, <0.260016, -0.437082, -2.374644>, <0.201782, -0.437082, -2.373924>, 
      <0.280520, -0.339931, -2.264294>, <0.279127, -0.335331, -2.322334>, <0.259916, -0.402165, -2.377633>, <0.201682, -0.402165, -2.376912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.240718, -0.442148, -2.269477>, <0.239296, -0.435852, -2.326053>, <0.258574, -0.521558, -2.384727>, <0.201951, -0.518271, -2.389776>, 
      <0.240718, -0.442148, -2.269477>, <0.240229, -0.439984, -2.288920>, <0.259317, -0.524845, -2.355197>, <0.202693, -0.521557, -2.360246>, 
      <0.240718, -0.442148, -2.269477>, <0.240229, -0.439984, -2.288920>, <0.240847, -0.528096, -2.317560>, <0.203683, -0.525939, -2.320873>, 
      <0.240718, -0.442148, -2.269477>, <0.241651, -0.446280, -2.232344>, <0.241589, -0.531383, -2.288030>, <0.204425, -0.529225, -2.291344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.204809, -0.610566, -2.183551>, <0.192933, -0.558726, -2.211349>, <0.181445, -0.493235, -2.260053>, <0.165221, -0.437765, -2.276209>, 
      <0.204809, -0.610566, -2.183551>, <0.192933, -0.558726, -2.211349>, <0.180057, -0.487091, -2.315259>, <0.163833, -0.431621, -2.331415>, 
      <0.204809, -0.610566, -2.183551>, <0.203952, -0.582878, -2.245419>, <0.147556, -0.542752, -2.332836>, <0.146699, -0.515063, -2.394703>, 
      <0.204809, -0.610566, -2.183551>, <0.203952, -0.582878, -2.245419>, <0.202808, -0.545960, -2.327909>, <0.201951, -0.518271, -2.389776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.204809, -0.610566, -2.183551>, <0.204809, -0.610566, -2.183551>, <0.204809, -0.610566, -2.183551>, <0.204809, -0.610566, -2.183551>, 
      <0.192933, -0.558726, -2.211349>, <0.192933, -0.558726, -2.211349>, <0.204694, -0.586164, -2.215889>, <0.204694, -0.586164, -2.215889>, 
      <0.181445, -0.493235, -2.260053>, <0.182415, -0.497530, -2.221457>, <0.165913, -0.551385, -2.262451>, <0.204540, -0.553627, -2.259006>, 
      <0.165221, -0.437765, -2.276209>, <0.166191, -0.442060, -2.237614>, <0.165797, -0.526983, -2.294789>, <0.204425, -0.529225, -2.291344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.204809, -0.610566, -2.183551>, <0.215582, -0.560041, -2.209329>, <0.225768, -0.495587, -2.253534>, <0.240718, -0.442148, -2.269477>, 
      <0.204809, -0.610566, -2.183551>, <0.215582, -0.560041, -2.209329>, <0.226702, -0.499719, -2.216401>, <0.241651, -0.446280, -2.232344>, 
      <0.204809, -0.610566, -2.183551>, <0.204694, -0.586164, -2.215889>, <0.241704, -0.555785, -2.255692>, <0.241589, -0.531383, -2.288030>, 
      <0.204809, -0.610566, -2.183551>, <0.204694, -0.586164, -2.215889>, <0.204540, -0.553627, -2.259006>, <0.204425, -0.529225, -2.291344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.204809, -0.610566, -2.183551>, <0.204809, -0.610566, -2.183551>, <0.204809, -0.610566, -2.183551>, <0.204809, -0.610566, -2.183551>, 
      <0.215582, -0.560041, -2.209329>, <0.215582, -0.560041, -2.209329>, <0.203952, -0.582878, -2.245419>, <0.203952, -0.582878, -2.245419>, 
      <0.225768, -0.495587, -2.253534>, <0.224346, -0.489291, -2.310110>, <0.259432, -0.549247, -2.322860>, <0.202808, -0.545960, -2.327909>, 
      <0.240718, -0.442148, -2.269477>, <0.239296, -0.435852, -2.326053>, <0.258574, -0.521558, -2.384727>, <0.201951, -0.518271, -2.389776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.071203, -0.413219, -2.874958>, <-0.000004, -0.390308, -2.831998>, <-0.059978, -0.342004, -2.755474>, <-0.015417, -0.342004, -2.681614>, 
      <0.069917, -0.431489, -2.874182>, <-0.001291, -0.408578, -2.831221>, <-0.047483, -0.378668, -2.763012>, <-0.002923, -0.378668, -2.689152>, 
      <0.065515, -0.456493, -2.877207>, <0.008613, -0.453180, -2.844063>, <-0.019818, -0.426693, -2.760885>, <0.014241, -0.426693, -2.704430>, 
      <0.066915, -0.474119, -2.872370>, <0.010014, -0.470806, -2.839226>, <-0.007830, -0.464218, -2.763196>, <0.026230, -0.464218, -2.706741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.236695, -0.423120, -2.833716>, <0.202635, -0.423120, -2.890171>, <0.125631, -0.430731, -2.907795>, <0.071203, -0.413219, -2.874958>, 
      <0.237620, -0.439179, -2.832939>, <0.203560, -0.439179, -2.889395>, <0.124344, -0.449001, -2.907018>, <0.069917, -0.431489, -2.874182>, 
      <0.235945, -0.461011, -2.830819>, <0.200512, -0.461011, -2.889552>, <0.124711, -0.459939, -2.911688>, <0.065515, -0.456493, -2.877207>, 
      <0.239777, -0.476650, -2.831128>, <0.204343, -0.476650, -2.889860>, <0.126112, -0.477565, -2.906851>, <0.066915, -0.474119, -2.872370>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.196011, -0.413219, -2.668086>, <0.250439, -0.430731, -2.700923>, <0.270755, -0.423120, -2.777261>, <0.236695, -0.423120, -2.833716>, 
      <0.194724, -0.431489, -2.667310>, <0.249152, -0.449001, -2.700146>, <0.271680, -0.439179, -2.776484>, <0.237620, -0.439179, -2.832939>, 
      <0.194769, -0.456176, -2.663304>, <0.252216, -0.459520, -2.696766>, <0.270332, -0.461011, -2.773823>, <0.235945, -0.461011, -2.830819>, 
      <0.191722, -0.474119, -2.665498>, <0.249169, -0.477463, -2.698960>, <0.274163, -0.476650, -2.774131>, <0.239777, -0.476650, -2.831128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.196011, -0.413219, -2.668086>, <0.194724, -0.431489, -2.667310>, <0.194769, -0.456176, -2.663304>, <0.191722, -0.474119, -2.665498>, 
      <0.124804, -0.390309, -2.625126>, <0.123517, -0.408578, -2.624350>, <0.137868, -0.452863, -2.630160>, <0.134820, -0.470806, -2.632354>, 
      <0.029143, -0.342004, -2.607754>, <0.041638, -0.378668, -2.615292>, <0.048301, -0.426693, -2.647974>, <0.060290, -0.464218, -2.650286>, 
      <-0.015417, -0.342004, -2.681614>, <-0.002923, -0.378668, -2.689152>, <0.014241, -0.426693, -2.704430>, <0.026230, -0.464218, -2.706741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.081998, -0.549082, -2.837675>, <0.078223, -0.524200, -2.838779>, <0.068839, -0.498341, -2.865723>, <0.066915, -0.474119, -2.872370>, 
      <0.035148, -0.552946, -2.806438>, <0.031373, -0.528064, -2.807542>, <0.011938, -0.495028, -2.832580>, <0.010014, -0.470806, -2.839226>, 
      <0.031346, -0.583734, -2.744417>, <0.032594, -0.547595, -2.745170>, <0.003159, -0.498612, -2.765315>, <-0.007830, -0.464218, -2.763196>, 
      <0.060414, -0.579354, -2.696235>, <0.061663, -0.543215, -2.696988>, <0.037219, -0.498612, -2.708860>, <0.026230, -0.464218, -2.706741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.270725, -0.562009, -2.836459>, <0.278557, -0.535897, -2.837617>, <0.246269, -0.503147, -2.831651>, <0.239777, -0.476650, -2.831128>, 
      <0.233124, -0.567674, -2.898784>, <0.240956, -0.541562, -2.899942>, <0.210836, -0.503147, -2.890384>, <0.204343, -0.476650, -2.889860>, 
      <0.142600, -0.544084, -2.878082>, <0.138826, -0.519202, -2.879185>, <0.128036, -0.501787, -2.900204>, <0.126112, -0.477565, -2.906851>, 
      <0.081998, -0.549082, -2.837675>, <0.078223, -0.524200, -2.838779>, <0.068839, -0.498341, -2.865723>, <0.066915, -0.474119, -2.872370>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.175327, -0.535020, -2.682979>, <0.178243, -0.515800, -2.680223>, <0.188459, -0.493337, -2.667848>, <0.191722, -0.474119, -2.665498>, 
      <0.233861, -0.530192, -2.722006>, <0.236777, -0.510973, -2.719250>, <0.245906, -0.496681, -2.701310>, <0.249169, -0.477463, -2.698960>, 
      <0.307043, -0.556537, -2.776261>, <0.314874, -0.530425, -2.777419>, <0.280656, -0.503147, -2.774655>, <0.274163, -0.476650, -2.774131>, 
      <0.270725, -0.562009, -2.836459>, <0.278557, -0.535897, -2.837617>, <0.246269, -0.503147, -2.831651>, <0.239777, -0.476650, -2.831128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.175327, -0.535020, -2.682979>, <0.135642, -0.538293, -2.656519>, <0.085037, -0.575644, -2.655421>, <0.060414, -0.579354, -2.696235>, 
      <0.178243, -0.515800, -2.680223>, <0.138558, -0.519073, -2.653763>, <0.086286, -0.539505, -2.656175>, <0.061663, -0.543215, -2.696988>, 
      <0.188459, -0.493337, -2.667848>, <0.131557, -0.490024, -2.634704>, <0.071278, -0.498612, -2.652405>, <0.037219, -0.498612, -2.708860>, 
      <0.191722, -0.474119, -2.665498>, <0.134820, -0.470806, -2.632354>, <0.060290, -0.464218, -2.650286>, <0.026230, -0.464218, -2.706741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097474, -0.675551, -2.863435>, <0.101117, -0.637139, -2.869092>, <0.087842, -0.587601, -2.835967>, <0.081998, -0.549082, -2.837675>, 
      <0.041759, -0.681689, -2.822211>, <0.045402, -0.643277, -2.827868>, <0.040991, -0.591465, -2.804729>, <0.035148, -0.552946, -2.806438>, 
      <-0.006787, -0.703815, -2.765376>, <-0.006077, -0.668565, -2.761062>, <0.030120, -0.619225, -2.743677>, <0.031346, -0.583734, -2.744417>, 
      <0.018433, -0.689909, -2.702037>, <0.019144, -0.654659, -2.697723>, <0.059188, -0.614845, -2.695495>, <0.060414, -0.579354, -2.696235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.181193, -0.671977, -2.822465>, <0.199111, -0.633782, -2.829356>, <0.258455, -0.602919, -2.834645>, <0.270725, -0.562009, -2.836459>, 
      <0.168145, -0.679172, -2.855235>, <0.186062, -0.640976, -2.862126>, <0.220854, -0.608584, -2.896970>, <0.233124, -0.567674, -2.898784>, 
      <0.126299, -0.672375, -2.884763>, <0.129942, -0.633963, -2.890421>, <0.148444, -0.582603, -2.876373>, <0.142600, -0.544084, -2.878082>, 
      <0.097474, -0.675551, -2.863435>, <0.101117, -0.637139, -2.869092>, <0.087842, -0.587601, -2.835967>, <0.081998, -0.549082, -2.837675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.166975, -0.637230, -2.688889>, <0.170404, -0.606616, -2.689699>, <0.170750, -0.565186, -2.687305>, <0.175327, -0.535020, -2.682979>, 
      <0.209854, -0.632506, -2.720616>, <0.213283, -0.601892, -2.721426>, <0.229284, -0.560358, -2.726332>, <0.233861, -0.530192, -2.722006>, 
      <0.200603, -0.661275, -2.773718>, <0.218521, -0.623079, -2.780610>, <0.294773, -0.597446, -2.774447>, <0.307043, -0.556537, -2.776261>, 
      <0.181193, -0.671977, -2.822465>, <0.199111, -0.633782, -2.829356>, <0.258455, -0.602919, -2.834645>, <0.270725, -0.562009, -2.836459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.166975, -0.637230, -2.688889>, <0.118100, -0.642615, -2.652726>, <0.040557, -0.677710, -2.646474>, <0.018433, -0.689909, -2.702037>, 
      <0.170404, -0.606616, -2.689699>, <0.121528, -0.612001, -2.653536>, <0.041268, -0.642460, -2.642159>, <0.019144, -0.654659, -2.697723>, 
      <0.170750, -0.565186, -2.687305>, <0.131065, -0.568459, -2.660845>, <0.083811, -0.611135, -2.654682>, <0.059188, -0.614845, -2.695495>, 
      <0.175327, -0.535020, -2.682979>, <0.135642, -0.538293, -2.656519>, <0.085037, -0.575644, -2.655421>, <0.060414, -0.579354, -2.696235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.058941, -0.792213, -2.801866>, <0.052755, -0.752923, -2.812717>, <0.093623, -0.716160, -2.857454>, <0.097474, -0.675551, -2.863435>, 
      <0.035262, -0.805559, -2.787581>, <0.029076, -0.766269, -2.798432>, <0.037908, -0.722298, -2.816230>, <0.041759, -0.681689, -2.822211>, 
      <0.039222, -0.803961, -2.749533>, <0.028027, -0.767721, -2.742779>, <-0.007558, -0.742049, -2.770055>, <-0.006787, -0.703815, -2.765376>, 
      <0.055749, -0.810711, -2.724550>, <0.044554, -0.774470, -2.717796>, <0.017662, -0.728143, -2.706717>, <0.018433, -0.689909, -2.702037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.