// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1;

#include "colors.inc"
#include "textures.inc"
#include "bolts.inc"
     
     
#ifndef (UseAsIncludeFile)     
global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera
{
  location  <0/12, 1, -1.0>
  direction 1.5*z
  right     4/3*x
  look_at   <5/12, 0,  0.0>
}

sky_sphere
{   
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}
/*
light_source
{
  0*x // light's position (translated below)
  color  White*2
  translate <-30, 30, -30>
}
*/
// ----------------------------------------
plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

#end


#ifndef (TestMode)
  #declare armTexture = Soft_Silver
#else
  #declare armTexture = texture{pigment{White*.75}}  
#end 

#ifndef (TestMode)
  #declare Darkbronze =  texture { pigment{ rgb <0.55, 0.47, 0.14>*.5} finish{ Metal }}
#else
  #declare Darkbronze = texture { pigment{ rgb <0.55, 0.47, 0.14>*.5}}    
#end

#declare rubberTexture = 
texture {
    pigment {
        granite
        color_map {
            [0.0 rgb <0.15 0.15 0.15>]
            [0.5 rgb <0.20, 0.20 0.20>]
            [0.6 rgb <0.10, 0.10, 0.10>]
            [0.6 rgb <0.10, 0.10, 0.10>]
        }
    }
    finish { ambient 0.2 diffuse 0.6 }
    normal { wrinkles 1 scale 0.05 }
}      
 
#declare difBox =
   box{<-1,0,0-.25>,<3,0.125,-.75>}

//=========================== 

#declare rubberGrip = 
difference{
  box{<0,-.5,0>,<2,.5,-.5>}
  #declare yy = -.4375;
  #while (yy < .5)
    object{difBox translate<0,yy,0>}
    #declare yy = yy + .25;
 #end   
 texture{rubberTexture scale .1} 
}  

#declare griplinkage =
union{     
  cylinder{<.5,.0625,.75>,<.5,.1875,.75>, .125 texture{Darkbronze}} 
  object{silverScrew scale .5 translate<.5,.1875,.75> }
  cylinder{<.5,.125,.75>,<.5,.125,1.5> .03125 texture{armTexture}}
  cylinder{<.5,.0625,1.5>,<.5,.1875,1.5>, .125 texture{Darkbronze}} 
  cylinder{<.5,.125,.75>,<.75,.125,.25> .03125 texture{armTexture}}
  cylinder{<.75,.0625,.25>,<.75,.1875,.25>, .125 texture{Darkbronze}}  
  cylinder{<1.25,.125,.25>,<1.25,.125,1.25> .03125 texture{armTexture}}
  cylinder{<1.25,.0625,.25>,<1.25,.1875,.25>, .125 texture{Darkbronze}} 
//  cylinder{<.5,.125,1.5>,<1.25,.0625,1.25> .03125 pigment{Blue}}
  cylinder{<1.25,.0625,1.25>,<1.25,.1875,1.25>, .125 texture{Darkbronze}} 


  cylinder{<.5,.0625,-.75>,<.5,.1875,-.75>, .125 texture{Darkbronze}}  
  cylinder{<.5,.125,-.75>,<.5,.125,-1.5> .03125 texture{armTexture}}
  cylinder{<.5,.0625,-1.5>,<.5,.1875,-1.5>, .125 texture{Darkbronze}}     
  cylinder{<.5,.125,-.75>,<.75,.125,-.25> .03125 texture{armTexture}}
  cylinder{<.75,.0625,-.25>,<.75,.1875,-.25>, .125 texture{Darkbronze}}
  cylinder{<1.25,.125,-.25>,<1.25,.125,-1.25> .03125 texture{armTexture}}
  cylinder{<1.25,.0625,-.25>,<1.25,.1875,-.25>, .125 texture{Darkbronze}}
//  cylinder{<.5,.125,-1.5>,<1.25,.0625,-1.25> .03125 pigment{Blue}}
  cylinder{<1.25,.0625,-1.25>,<1.25,.1875,-1.25>, .125 texture{Darkbronze}} 
  
}

#declare griplinkage2 =
union{     
  cylinder{<.5,.0625,.75>,<.5,.1875,.75>, .125 texture{Darkbronze}} 
  cylinder{<.5,.125,.75>,<.5,.125,1.5> .03125 texture{armTexture}}
  cylinder{<.5,.0625,1.5>,<.5,.1875,1.5>, .125 texture{Darkbronze}} 
//  cylinder{<.5,.125,.75>,<.75,.125,.25> .03125 texture{armTexture}}
//  cylinder{<.75,.0625,.25>,<.75,.1875,.25>, .125 texture{Darkbronze}}  
  cylinder{<1.25,.125,.25>,<1.25,.125,1.25> .03125 texture{Darkbronze}}
  cylinder{<1.25,.0625,.25>,<1.25,.1875,.25>, .125 texture{armTexture}} 
//  cylinder{<.5,.125,1.5>,<1.25,.0625,1.25> .03125 pigment{Blue}}
  cylinder{<1.25,.0625,1.25>,<1.25,.1875,1.25>, .125 texture{Darkbronze}} 


  cylinder{<.5,.0625,-.75>,<.5,.1875,-.75>, .125 texture{Darkbronze}}  
  cylinder{<.5,.125,-.75>,<.5,.125,-1.5> .03125 texture{armTexture}}
  cylinder{<.5,.0625,-1.5>,<.5,.1875,-1.5>, .125 texture{Darkbronze}}     
  //cylinder{<.5,.125,-.75>,<.75,.125,-.25> .03125 pigment{Blue}}
//  cylinder{<.75,.0625,-.25>,<.75,.1875,-.25>, .125 texture{Darkbronze}}
  cylinder{<1.25,.125,-.25>,<1.25,.125,-1.25> .03125 texture{armTexture}}
  cylinder{<1.25,.0625,-.25>,<1.25,.1875,-.25>, .125 texture{Darkbronze}}
//  cylinder{<.5,.125,-1.5>,<1.25,.0625,-1.25> .03125 pigment{Blue}}
  cylinder{<1.25,.0625,-1.25>,<1.25,.1875,-1.25>, .125 texture{Darkbronze}} 
  
}


#declare armGrip=
union{
  object{griplinkage} 
  object{griplinkage2 translate<0,-.25,0>} 
  box{<-.125,.0625,-.125>,<2,-.0625,.125>  rotate<0,-19.5,0>   translate<.5,0,-1.5> texture{armTexture}}
  box{<-.125,.0625,-.125>,<2,-.0625,.125>  rotate<0,19.5,0>   translate<.5,0,1.5> texture{armTexture}}
        
  object{rubberGrip scale .35  rotate<0,19.5,0> translate<1.75,0,.9375>}
  object{rubberGrip scale .35  rotate<180,0,0> rotate<0,-19.5,0> translate<1.75,0,-.9375>}
  box{<0,-.0625,.25>,<.5,.0625,-.25> texture{armTexture}} 

  difference{      
    box{<.375,-.0625,.875>,<1.5,.0625,-.875> texture{armTexture}} 
  
    box{<0,-1,0>,<5,1,-5> rotate<0,-30,0> translate<.5,0,-.875>}
    box{<0,-1,0>,<5,1,5> rotate<0,30,0> translate<.5,0,.875>} 
    cylinder{<1,2,0>,<1,-2,0>, .25}
    cylinder{<2.125,2,0>,<2.125,-2,0>, .75}
  }  

  rotate<0,0,0>
}  



#declare arm=
union{
  cylinder{<0,0,0>,<1.01/12,0,0>, .5/12  texture{armTexture}} 
  box{<1/12,.5/12,-.5/12>,<1.0625/12,-.5/12,.5/12> texture{armTexture}}   

  union{
    difference{    
      box{<1/12,-.5/12,-.03125/12>,<2/12,.5/12,.03125/12> }
      box{<0,0,.2/12>,<2/12,.5/12,-.2/12>  rotate<0,0,-17> translate<1/12,.5/12,0> }
      box{<0,0,.2/12>,<2/12,-.5/12,-.2/12>  rotate<0,0,17> translate<1/12,-.5/12,0>}  
      box{<1.78/12,-1,.8/12>,<3/12,1,-.8/12>   }  
    }  
    cylinder{<1.765/12,0,.03125/12>,<1.765/12,0,-.03125/12>, .259/12  } 
    translate<0,0,-.5/12>
    texture{armTexture}
  }
  
  union{ 
    difference{    
      box{<1/12,-.5/12,-.03125/12>,<2/12,.5/12,.03125/12> }
      box{<0,0,.2/12>,<2/12,.5/12,-.2/12>  rotate<0,0,-17> translate<1/12,.5/12,0> }
      box{<0,0,.2/12>,<2/12,-.5/12,-.2/12>  rotate<0,0,17> translate<1/12,-.5/12,0>}  
      box{<1.78/12,-1,.8/12>,<3/12,1,-.8/12>  }      
    }
    cylinder{<1.765/12,0,.03125/12>,<1.765/12,0,-.03125/12>, .259/12  } 
    translate<0,0,.5/12>
    texture{armTexture}
  }  
  
  union{
    cylinder{<1.78/12,0,.6/12>,<1.78/12,0,-.6/12>, .125/12  texture{Darkbronze}}
    cylinder{<1.78/12,0,-.40/12>,<1.78/12,0,-.45/12>, .66/12  texture{armTexture}} 
    cylinder{<1.78/12,0,.38/12>,<1.78/12,0,-.38/12>, .65/12  texture{armTexture}} 
    cylinder{<1.78/12,0,.45/12>,<1.78/12,0,.40/12>, .66/12  texture{armTexture}} 
    box{<1.78/12,.35/12,0.35/12>,<3.25/12,-.35/12,-.35/12>  texture{armTexture}}  
    box{<3.00/12,.315/12,0.315/12>,<7/12,-.315/12,-.315/12>  texture{armTexture}}  
    object{blackScrew rotate<90,0,45> scale 1/18 translate<2.7/12,.15/12,.35/12>}
    object{blackScrew rotate<90,0,270> scale 1/18 translate<2.7/12,-.15/12,.35/12>}
    object{blackScrew rotate<90,0,10> scale 1/18 translate<3.1/12,.15/12,.35/12>}
    object{blackScrew rotate<90,0,325> scale 1/18 translate<3.1/12,-.15/12,.35/12>}
    
    box{<7/12,0.35/12,1/12>,<7.70/12,-0.35/12,-1/12>  texture{armTexture}}  

    box{<7/12,0.35/12,-.65/12>,<9/12,-0.35/12,-1/12>  texture{armTexture}}  
    box{<7/12,0.35/12,.65/12>,<9/12,-0.35/12,1/12>  texture{armTexture}}  
   cylinder{<8.65/12,0,-.64/12>,<8.65/12,0,.64/12>, .35/12  texture{armTexture}} 
   
   cylinder{<8.65/12,0,-1.06/12>,<8.65/12,0,>, .125/12 texture{Darkbronze}} 
   cylinder{<8.65/12,0,1.06/12>,<8.65/12,0,>, .125/12 texture{Darkbronze}} 
    
   object{armGrip scale 1/12 rotate<50,0,0> translate<8.875/12,0,0>}
   
    
    translate<-1.78/12,0,-.6/12>
    rotate<0,0,-40>    
    translate<1.78/12,0,.6/12>
  }  


 rotate<-60,0,0>  


}           

#ifndef (UseAsIncludeFile) 
object{arm rotate<0,0,0>}
#end
  

      
     
