// Persistence of Vision Ray Tracer Scene Description File
// Vers: 3.1
// Desc: IRTC First Encounter
// Date: 12/30/98
// Auth: Bob Franke                      

#version 3.1;        
//declare TestMode = 1;

//#declare UseAsIncludeFile = 1;
#include "bolts.inc"                
//#undef UseAsIncludeFile

#ifndef (UseAsIncludeFile)  

#include "colors.inc"
#include "metals.inc"
#include "finish.inc" 
#include "textures.inc"

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera{
  location  <0.0, 0, -1.0>
  direction 2.5*z
  right     4/3*x
  look_at   <0/12, 0.0,  0.0>
}

sky_sphere{
  pigment{
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source{
  0*x // light's position (translated below)
  color White * 2
  translate <-15, 2, -30>
}
            
// ----------------------------------------
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

#end // (UseAsIncludeFile)

#ifndef (TestMode)
  #declare sliverPlate = 
    texture {
      pigment { color  rgb <0.94, 0.93, 0.83>*1.25 }
      finish {
        metallic
        ambient 0.2
        diffuse 0.35
        specular 0.85
        roughness 0.01
        reflection 0.35
        brilliance 1.5
      }
    }
#else
  #declare sliverPlate = texture{pigment{White*.75}}  
#end     
      
#declare rubberTexture = 
texture {
    pigment {
        granite
        color_map {
            [0.0 rgb <0.15 0.15 0.15>]
            [0.5 rgb <0.20, 0.20 0.20>]
            [0.6 rgb <0.10, 0.10, 0.10>]
            [0.6 rgb <0.10, 0.10, 0.10>]
        }
    }
    finish { ambient 0.2 diffuse 0.6 }
    normal { wrinkles 1 scale 0.05 }
}      
      
#declare difBox =
   box{<-1,0,0-.25>,<3,0.125,-.75>}

//===========================  

#ifndef (TestMode)
  #declare Black_Plastic = texture {
    pigment { color rgb <.2, .2, .2> }
    finish { phong 1.0}
  }  
#else
  #declare Black_Plastic = texture {
    pigment { color rgb <.2, .2, .2> }  
  }  
#end  
 

#macro ccdCamera(zz)
union{     
  union{     
    superellipsoid{ <0.2,  0.15>  scale<1,1,.5>/12  } 
  
    difference{       
      cylinder{<0,0,0>,<0,0,-1.0/12> , 0.25/12}   
      cylinder{<0,0,0>,<0,0,-2.25/12> , 0.23/12}   
    }
    difference{
      cylinder{<0,0,-1.125/12>,<0,0,-1.0/12> , 0.375/12}   
      cylinder{<0,0,0>,<0,0,-2.25/12> , 0.23/12}   
    }  
    texture{Black_Plastic} 
  }  
      
  difference{    
    object{flatNut scale <1/200,1/600,1/200> rotate<-90,0,0> rotate<0,0,zz> translate<0,0,-.7075/12>}
    cylinder{<0,0,0>,<0,0,-2.25/12> , 0.25/12}   
  }   
  
  difference{
    difference{
      sphere{<0,0,-.125/12> ,1/12}
      sphere{<0,0,-.125/12> ,.95/12}
    }        
    cylinder{<0,0,-2.375/12>,<0,0,0> , 0.372/12 inverse}   
    #ifndef (TestMode)
      texture{NBglass}
    #else
      pigment{Red}
    #end  
  }    
}  
#end
 
#macro cameraAssy(rotateX,rotateY)
// A macro is used so that the camera can
// be easily rotated on the x & y axis

union{    
  union{
    ccdCamera(0) 
    object{ccdCamera(15)  translate<3/12,0,0>}  
    difference{
      box{<-.6/12,.4375/12,-.7075/12>,<3.6/12,-.4375/12,-.52/12>}
      box{<-.7/12,.01/12,-.9075/12>,<0,-.01/12,-.52/12>}
      box{<3/12,.01/12,-.9075/12>,<4.5/12,-.01/12,-.52/12>}
      cylinder{<0,0,0>,<0,0,-2.25/12> , 0.25/12}
      texture{Bright_Bronze}
    }   
    box{<1.375/12,.375/12,-.50/12>,<1.625/12,-.375/12,.75/12>  texture{Bronze_Texture}}
    object{
      sphere{<1.5/12,0,1.25/12>, .75/12}  
      clipped_by{plane{z,1.375/12}}
      texture{Bronze_Texture}
    }  
    translate<-1.5/12,0,-1.25/12> 
    rotate<rotateX,rotateY,0>
  }  
  union{  
    difference{  
      cone{<1.5/12,0,1.4/12>, 1.06/12, <1.5/12,0,.875/12> .6875/12 }  
      cone{<1.5/12,0,1.41/12>, 1.0/12, <1.5/12,0,.874/12> .625/12 }
      texture{sliverPlate}
    }
    box{<.375/12,1.25/12,1.4/12>,<2.625/12,-1.25/12,1.5/12> texture{sliverPlate}} 
    object{blackScrew rotate<-90,0,0> scale 1/12 translate<2.375/12,1/12,1.4/12> }
    object{blackScrew rotate<-90,0,0> scale 1/12 translate<.625/12,1/12,1.4/12> }

    object{blackScrew rotate<-90,0,0> scale 1/12 translate<2.375/12,-1/12,1.4/12> }
    object{blackScrew rotate<-90,0,0> scale 1/12 translate<.625/12,-1/12,1.4/12> }
    translate<-1.5/12,0,-1.25/12> 
  }  
} 
#end

#ifndef (UseAsIncludeFile)
  object{cameraAssy(-20,20) }
#end  