// Persistence of Vision Ray Tracer Scene Description File
// Vers: 3.1
// Desc: IRTC First Encounter
// Date: 12/30/98
// Auth: Bob Franke                      

#version 3.1;        
//#declare TestMode = 1;

//#declare UseAsIncludeFile = 1;
  #include "bolts.inc"                        

//#undef UseAsIncludeFile


#ifndef (UseAsIncludeFile)  

#include "colors.inc"
#include "metals.inc"
#include "finish.inc" 
#include "textures.inc"

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera{
  location  <6/12, 10/12, -6>
  direction 1.5*z
  right     4/3*x
  look_at   <6/12, 10/12,  0.0>
}

sky_sphere{
  pigment {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source{
  0*x 
  color White * 2
  translate <5, 2, -15>
}
            
// ----------------------------------------
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

#end // (UseAsIncludeFile)

#ifndef (TestMode)   
  #declare chrome = texture{T_Chrome_2D}
  #declare strutTexture = Soft_Silver
  #declare strutPinTexture = Bright_Bronze
  #declare myGoldTexture = 
    texture{
      pigment{rgb <1.00, 0.675, .536>*1.5} 
      finish {
        brilliance 2
        diffuse D_GoldA
        ambient A_GoldA
        reflection R_GoldA
        metallic M
        specular 0.20
        roughness 1/20
      }
    }  
  #declare Black_Plastic = texture {
    pigment { color rgb <.2, .2, .2> }
    finish { phong 1.0}
  }  
#else                                      
  #declare chrome = texture{pigment{White*.6}}
  #declare strutPinTexture = texture{pigment{Yellow*.65}}
  #declare myGoldTexture = texture { pigment { P_Gold4*.5 }}
  #declare strutTexture = texture{pigment{White*.75}} 
  #declare Black_Plastic = 
    texture {
      pigment { color rgb <.2, .2, .2> }  
    }  
#end 

#declare horizGoldLine = 
  box{<-11.75,0,-.03>/12,<23.75,-.2,.03>/12  texture{myGoldTexture}  }

#declare vertGoldLine = 
  box{<-.03,0,-7.875>/12,<.03,-.2,7.875>/12  texture{myGoldTexture}  }

#macro solarPanel(rx,ry,rz)  
  union{
    object{
    union{
      box{<-12,10,-8>/12,<24,10.75,8>/12 texture{strutPinTexture}} 
      box{<-11.75,10.83437,-7.875>/12,<23.75,10.875,7.875>/12 pigment{Black} finish{Shiny}  }  
      #declare zz = -6;
      #while (zz < 8)             
        object{horizGoldLine translate<0,10.975,zz>/12}             
        #declare zz = zz + 2;
      #end  
  
      #declare xx = -6;
      #while (xx < 22)             
        object{vertGoldLine translate<xx,10.975,0>/12}             
        #declare xx = xx + 6;
      #end  
      sphere{<6,7,0>/12, 3/12 texture{Bronze_Texture}}
    }
      translate<-6,-7,0>/12
      rotate<rx,ry,rz>
      translate<6,7,0>/12
    
    }

    difference{  
     cone{<6,7.75,0>/12, 2.91/12, <6,3,0>/12, 4.06/12}  
     cone{<6,7.8,0>/12, 2.87/12, <6,2.9,0>/12, 4.06/12}  
     texture{strutTexture}
    }
  }
#end

#ifndef (UseAsIncludeFile)
  object{solarPanel(-10,0,0)} 
#end 
