// ***********************************************************
// SPLINE GENERATOR INCLUDE FILE FOR PERSISTENCE OF VISION 3.x
//    SPLINE PREVIEW FILE
// ***********************************************************
//
// Created by Chris Colefax, February 1997
//
// See "Spline.txt" for more information.
//
// ***********************************************************

// CHECK DECLARED VARIABLES AND SET DEFAULT VALUES
// ***********************************************
   #declare _SP_tempver = version;
   #ifndef (spline_smoothness) 
     #declare spline_smoothness = 10; 
   #end
   #ifndef (spline_object)
      #declare spline_object = sphere {<0,0,0>, .5
         pigment {rgb <1, 0, 0>}
         finish {ambient 1 diffuse 0}
         no_shadow}
   #end

// CREATE SPLINE PREVIEW OBJECT
// ***********************************************
   #ifdef (spline_file)
      union {
         #declare spline_smoothness = (1 / spline_smoothness);
         #declare spline_clock = 0; #while (spline_clock <= 1)
            #include spline_file
            object {spline_object translate spline_pos}
         #declare spline_clock = spline_clock + spline_smoothness; #end
      }
   #else
      #warning "No spline_file was specified!  "
   #end

   #version _SP_tempver;
