
#macro GrassBlade(num_sections,min_height,max_height,medium_radius,r)

 #local r_leaf=seed(rand(r));
 #local cnt_sections=0;
 #local leaf_height=min_height+(max_height-min_height)*rand(r);
 #local sect_height=leaf_height/num_sections;
 #local leaf_radius=medium_radius*.5+medium_radius*rand(r_leaf);
 #local leaf_decr=leaf_radius/num_sections;
 #local act_height=sect_height;
 #local ant_height=0;
 #local act_z=0;
 #local ant_z=0;
 #local curve_rad=leaf_height*rand(r);
 #local z_decr=sect_height*rand(r);

 mesh{
  #while (cnt_sections<=num_sections)
   triangle{
    <-leaf_radius,ant_height,ant_z>,
    < leaf_radius,ant_height,ant_z>,
    <-leaf_radius,act_height,act_z>
   }
   triangle{
    < leaf_radius,ant_height,ant_z>,
    < leaf_radius,act_height,act_z>,
    <-leaf_radius,act_height,act_z>
   }
   #local ant_z=act_z;
   #local act_z=act_z-z_decr;
   #local ant_height=act_height;
   #local act_height=curve_rad*abs(sin(45*cnt_sections/num_sections));
   #local leaf_radius=leaf_radius-leaf_decr;
   #local cnt_sections=cnt_sections+1;
  #end
 }

#end

// leaf parameters
#declare sections=35;
#declare r_plant=seed(7777);
#declare min_height=8/2;
#declare max_height=12/2;
#declare medium_radius=.1;

// plant param
#declare num_leaves=25;
#declare cnt_leaves=1;
#declare base_radius=.0025;

// call the macro
#declare plant=
union{
#while (cnt_leaves<=num_leaves)
 object{
  GrassBlade(sections,min_height,max_height,medium_radius,r_plant)
  texture{pigment{Gold*.5+DarkGreen*rand(r_plant)} finish{ambient 0 diffuse .5 phong .25}}
  translate -(base_radius*rand(r_plant))*z
  rotate (360*rand(r_plant))*y
 }
 #declare cnt_leaves=cnt_leaves+1;
#end
}