// Author: Frank Epple.

//#declare FAST_RENDER = 1
//#declare FAST_LIGHT = 1

#include "d:\gfx\povray\include\colors.inc"
#include "d:\gfx\povray\include\metals.inc"
#include "d:\gfx\povray\include\woods.inc"
#include "d:\gfx\povray\include\golds.inc"
#include "d:\gfx\povray\include\textures.inc"

#include "chair.inc"
#include "table.inc"
#include "gedeck.inc"
#include "schirm.inc"
#include "napkin.inc"
#include "border.inc"
#include "female.inc"
#include "roseleave.inc"
#include "rose.inc"

// ----------------------------------------------------------------------------------------
// Material declarations
// ----------------------------------------------------------------------------------------

#declare T_WALL = texture
{
  pigment
  {
    color rgb <0.95,0.95,0.95>
  }
  normal
  {
    bumps 0.06
    scale 0.1
  }
  finish
  {
    ambient 0.4
    diffuse 0.6
  }
}

#declare T_CEILING = texture
{
  pigment
  {
    color rgb <1.0,1.0,1.0>
  }
  normal
  {
    bumps 0.02
    scale 0.01
  }
  finish
  {
    ambient 0.4
    diffuse 0.6
  }
}

#declare T_FLOOR = texture
{
  pigment
  {
    image_map
    {
      tga "parkett.tga"
      map_type 0
      interpolate 2
    }
  }

  finish
  {
    ambient 0.4
    diffuse 0.6
  }

  scale 0.5
  rotate <90,0,0>
}

#declare T_DOORFRAME = texture
{
  T_Wood1

  rotate <3,4,-5>
}

#declare T_SNOW = texture
{
  pigment
  {
    image_map
    {
      gif "snow.gif"
      transmit 0, 0.8
      map_type 0
      interpolate 2
    }
  }
  finish
  {
    ambient 0.4
    diffuse 0.6
  }

  scale 3
}

#declare T_PAVEMENT = texture
// Snowy(!) pavement:
{
  pigment
  {
    color rgb <1.0,1.0,1.0>
  }
  normal
  {
    bumps 0.2
    scale 0.1
  }
  finish
  {
    ambient 0.4
    diffuse 0.6
  }
}

#declare T_WINDOWGLASS = texture
{
  pigment
  {
    image_map
    {
      gif "logo.gif"
      transmit 0, 0.9
      once
      map_type 0
      interpolate 2
    }
  }
  finish
  {
    ambient 0.4
    diffuse 0.6
  }

  scale <1.3,1.0,1.0>
  rotate <0,180,0>
  translate <-1.24,1.2,0>
}

// ----------------------------------------------------------------------------------------
// Parameters
// ----------------------------------------------------------------------------------------

// ----------------------------------------------------------------------------------------
// OBJECT DEFINITIONS
// Everything is measured in meters!
// ----------------------------------------------------------------------------------------

#declare WALLS = difference
{
  box
  {
    <-7.40,-0.10,-7.40>
    < 3.00, 3.60, 6.40>
  }
  box
  {
    <-7.00,-0.10,-7.00>
    < 2.60, 3.20, 6.00>
  }
  box
  {
    < 0.00,-0.10, 5.90>
    < 1.20, 2.00, 6.50>
  }
  box
  {
    <-3.00, 0.80, 5.90>
    <-0.80, 2.00, 6.50>
  }
  texture { T_WALL }
}

#declare ROOM = union
{
  object { WALLS }
  #ifndef (FAST_RENDER)
  box
  {
    <-3.00, 0.80, 6.35>
    <-0.80, 2.00, 6.37>
    texture { T_WINDOWGLASS }
  }
  #end
  box
  {
    <-7.00,-0.10,-7.00>
    < 7.00, 0.00, 6.40>
    texture { T_FLOOR }
  }
  box
  {
    <-7.00, 3.50,-7.00>
    < 7.00, 3.10, 6.40>
    texture { T_CEILING }
  }
  difference  // WINDOWRFRAME
  {
    box
    {
      <-3.00, 0.80, 6.30>
      <-0.80, 2.00, 6.40>
    }
    box
    {
      <-2.94, 0.86, 6.29>
      <-0.86, 1.94, 6.41>
    }

    texture { T_DOORFRAME scale 0.5 rotate <-10,27,63>}
  }

  difference  // DOORFRAME
  {
    box
    {
      <-0.02, 0.00, 5.98>
      < 1.22, 2.02, 6.42>
    }
    box
    {
      < 0.05,-0.02, 5.90>
      < 1.15, 1.95, 6.50>
    }

    texture { T_DOORFRAME scale 0.6 rotate <10,17,27>}
  }

  box // DOOR
  {
    < 0.06,-0.02, 6.34>
    < 1.14, 1.94, 6.42>

    texture { T_DOORFRAME scale 0.57 rotate <1,2,91.7>}
  }

  torus
  {
    0.45
    0.035

    scale <1.3,1.0,1.0>
    translate <0.6, 1.00, 6.64>

    texture
    {
      pigment
      {
        color rgb <0.9,0.9,0.9>
      }
      normal
      {
        bumps 0.01
        scale 0.1
      }
      finish
      {
        ambient 0.4
        diffuse 0.6
      }
    }
  }

#ifndef (FAST_RENDER)
  difference
  {
    box
    {
      <-7.0, 3.10, 6.00>
      < 7.0, 3.00, 5.90>
    }

    cylinder
    {
      <-7.0, 3.00, 5.90>
      < 7.0, 3.00, 5.90>
      0.08
    }

    texture { T_CEILING }
  }
  difference
  {
    box
    {
      < 2.60, 3.10, 6.00>
      < 2.50, 3.00, -5.95>
    }

    cylinder
    {
      < 2.50, 3.00, 6.95>
      < 2.50, 3.00, -5.95>
      0.08
    }

    texture { T_CEILING }
  }
#end

  difference
  {
    box
    {
      <-7.0, 0.05, 6.00>
      < 7.0, 0.00, 5.95>
    }

    cylinder
    {
      <-7.0, 0.05, 5.95>
      < 7.0, 0.05, 5.95>
      0.034
    }
    box
    {
      <-0.02, -0.2, 5.48>
      < 1.22, 2.02, 6.42>
    }

    texture { T_DOORFRAME }
  }
  difference
  {
    box
    {
      < 2.60, 0.05, 6.00>
      < 2.55, 0.00, -5.95>
    }

    cylinder
    {
      < 2.55, 0.05, 6.95>
      < 2.55, 0.05, -5.95>
      0.034
    }

    texture { T_DOORFRAME }
  }
}

// ----------------------------------------------------------------------------------------
// Setting all Objects into the Scene:
// ----------------------------------------------------------------------------------------

camera { location <0.00, 1.27, -0.30> look_at <0.60,1.20,3.50> }  // Competition Camera1!
//camera { location <0.45, 1.56, -0.30> look_at <0.45,1.56,3.50> angle 2}  // Competition Camera1!
//camera { location <0.00, 1.27, -0.30> look_at <0.00,0.73,0.90> }  // Competition Camera1!
//camera { location <-3.00, 1.27, 3.0> look_at <0.60,0.00,5.00> angle 15}  // Competition Camera1!
//camera { location <0.00, 1.27, -0.30> look_at <0.29,0.73+0.414,0.90> angle 5}  // Competition Camera1!
//camera { location <2.0, 1.27, 0.00> look_at <0.6,1.20,3.50> }  // Competition Camera2!
//camera { location <1.0, 1.67, 4.00> look_at <-1.62,0.80,6.50> }  // Window Camera!
//camera { location <2.0, 1.47, 0.90> look_at <0.0,0.70,0.90> angle 40}  // Table Camera!
//camera { location <-6.0, 1.7, 2.0> look_at <0.0,1.2,2.0>} // Side Camera!

#ifdef (FAST_LIGHT)
light_source
{
  <1.60,2.6,-2.60>
  rgb 1
}
#else
light_source
{
  <1.60,2.6,-2.60>
  rgb <0.29,0.28,0.27>
}
#end

object { ROOM }

// Table under window:
object
{
  CHAIR

  rotate <0,-35,0>
  translate < -2.50, 0.00,5.50>
}

object
{
  CHAIR

  rotate <0,35,0>
  translate < -0.75, 0.00,5.50>
}

object
{
  TABLE

  rotate    <0,90,0>
  translate < -1.62, 0.00, 5.00>
}

// Table behind the door:
object
{
  CHAIR

  translate < 2.00, 0.00,4.50>
}

object
{
  CHAIR

  rotate <0,180,0>
  translate < 2.00, 0.00,3.50>
}

object
{
  TABLE

  translate < 2.00, 0.00, 4.0>
}

// Table to the right of mine:
object
{
  CHAIR

  translate < 2.00, 0.00, 2.0>
}

object
{
  TABLE

  translate < 2.00, 0.00, 1.4>
}

// My Table:
object
{
  CHAIR

  rotate <0,3,0>
  translate < 0.00, 0.00,1.50>
}

object
{
  TABLE

  translate < 0.00, 0.00, 0.9>
}

// HER things on table

#ifndef (FAST_RENDER)
object
{
  PLATE
  translate <0.00, 0.73, 1.32>
}

object
{
  GLASS

  translate <-0.13, 0.73, 1.16>
}

object
{
  TABLENAPKIN

  translate <-0.17, 0.73, 1.31>
}

// MY things on table

object
{
  PLATE
  translate <0.00, 0.73, 0.50>
}

object
{
  GLASS

  translate <0.13, 0.73, 0.66>
}
#end

// LAMPS

#ifndef (FAST_LIGHT)
#declare CANIN = 0.8
object
{
  CANDLEHOLDER
  translate <0.29, 0.73, 0.90>
}
sphere
{
  <0.00, 00, 0.00>
  0.005

  scale <2,5,2>
  translate <0.29, 0.73+0.412+0.01, 0.9>

  texture
  {
    pigment
    {
      color rgb <1.00,0.96,0.00>
    }
    finish
    {
      ambient 0.7
      diffuse 0.3
    }
  }

  no_shadow
}
light_source
{
  < 0.29, 0.427+0.73, 0.9>
  rgb <0.125, 0.11, 0.10>*CANIN

  fade_distance 2.7
  fade_power 1.5
}
light_source
{
  < 0.29-0.002, 0.434+0.73, 0.9+0.003>
  rgb <0.175, 0.165, 0.15>*CANIN

  fade_distance 2.7
  fade_power 1.5
}
light_source
{
  < 0.29+0.003, 0.437+0.73, 0.9+0.002>
  rgb <0.25, 0.225, 0.20>*CANIN

  fade_distance 2.7
  fade_power 1.5
}

object
{
  CANDLEHOLDER
  translate <-0.29, 0.73, 0.90>
}
sphere
{
  <0.00, 00, 0.00>
  0.005

  scale <2,5,2>
  translate <-0.29, 0.73+0.412+0.01, 0.9>

  texture
  {
    pigment
    {
      color rgb <1.00,0.96,0.00>
    }
    finish
    {
      ambient 0.7
      diffuse 0.3
    }
  }

  no_shadow
}
light_source
{
  <-0.29, 0.427+0.73, 0.0>
  rgb <0.125, 0.11, 0.10>*CANIN

  fade_distance 2.7
  fade_power 1.5
}
light_source
{
  <-0.29-0.002, 0.434+0.73, 0.9+0.003>
  rgb <0.175, 0.165, 0.15>*CANIN

  fade_distance 2.7
  fade_power 1.5
}
light_source
{
  <-0.29+0.003, 0.437+0.73, 0.9-0.002>
  rgb <0.25, 0.225, 0.20>*CANIN

  fade_distance 2.7
  fade_power 1.5
}

object
{
  CANDLEHOLDER
  translate <-1.62, 0.73, 5.00>
}

object
{
  CANDLEHOLDER
  translate < 2.00, 0.73, 4.00>
}
#end

object
{
  SCHIRM

  rotate <0,-90,0>
  translate <-0.4, 1.5, 6.0>
}
#ifndef (FAST_LIGHT)
light_source
{
  <-0.4,1.59,5.95>
  rgb <0.95, 0.95, 0.95>

  fade_distance 1
  fade_power 5
}
#end

object
{
  SCHIRM

  rotate <0,-90,0>
  translate <1.9, 1.5, 6.0>
}
#ifndef (FAST_LIGHT)
light_source
{
  <1.9,1.59,5.95>
  rgb <0.95, 0.95, 0.95>

  fade_distance 1
  fade_power 5
}
#end

object
{
  SCHIRM

  translate <2.6, 1.5, 4.0>
}
#ifndef (FAST_LIGHT)
light_source
{
  <2.55,1.59,4.00>
  rgb <0.95, 0.95, 0.95>

  fade_distance 1
  fade_power 5
}
#end

#ifndef (FAST_RENDER)
object
// xmin=-0.094509, xmax=0.091491
// ymin=-0.359567, ymax=0.392163
// zmin=-0.165152, zmax=0.163865
{
  FEMALE

  scale     <2.35, 2.35, 2.35>
  rotate    <-20,0,0>
  rotate    <0,210,0>
  translate <0.45, 0.85, 5.0>
}

sphere
{
  <0.456, 1.580, 4.88>
  0.0045

  pigment { color rgb <0.3, 0.3, 0.6> }
}

sphere
{
  <0.515, 1.579, 4.884>
  0.0045

  pigment { color rgb <0.3, 0.3, 0.6> }
}
#end

sphere
{
  <0.0, 0.03, 0.0>
  0.03

  scale <0.9,0.6,0.6>
  rotate <0, 30, 0>
  translate <0.08, 0.73, 0.86>

  texture
  {
    pigment
    {
      color rgb <0.7, 0.0, 0.0>
    }
  }
}

union { // union with all limbs and leaves of the tree
  object { roseLimb0 }
  object { roseLimb1 }
  object { roseLimb2 }
  object { roseLimb3 }
  object { roseLimb4 }
  object { roseLimb5 }
  object { roseLeaf0 }
  object { roseLeaf1 }
  object { roseLeaf2 }

  scale 0.02
  rotate <0,-30,0>
  translate <0.23, 0.74, 0.73>
}
