// Author: Frank Epple.

#declare DEGREE = (pi/180.0)

// NULL is on the floor in the middle of the chair
#declare T_CHAIRWOOD = texture
{
  pigment {
      wood
      color_map { 
          [0.0 color rgb <0.60, 0.34, 0.14>]
          [0.1 color rgb <0.63, 0.35, 0.16>]
          [0.2 color rgb <0.60, 0.34, 0.14>]
          [0.6 color rgb <0.57, 0.32, 0.12>]
          [0.7 color rgb <0.54, 0.30, 0.10>]
          [0.9 color rgb <0.60, 0.34, 0.14>]
      }
      turbulence <1.1, 0.9, 1.2>
      octaves 2
      lambda 1.25
      scale <1, 1, 1>
  }
  finish
  {
    ambient 0.4
    diffuse 0.6
  }
}

#declare T_CUSHION = texture
{
  pigment
  {
    color rgb <0.7,0.0,0.0>
  }
  normal
  {
    bumps 0.2
    scale 0.00004
  }
  finish
  {
    ambient 0.4
    diffuse 0.6
  }
}

#declare CHAIR_FOOT_ANGLE = 7.9
#declare CHAIR_BACK_ANGLE = 30
#declare CHAIR_BACK_THICK = 0.020
#declare CWIN             = 7
#declare CLH              = 0.47
#declare CR               = 0.042
#declare CW               = 0.3

#declare CHAIR_TORI = difference
{
  torus
  {
    0.05,CHAIR_BACK_THICK
  }
  prism
  {
    linear_sweep
    -0.06
    0.06
    7
    <0.0,0.0>,<0.0,0.1>,<0.1,0.1>,<0.1,-0.1>,<-0.1,-0.1>,<-0.1,-0.1*tan(CWIN*DEGREE)>,<0.0,0.0>
  }
}

#ifdef (FAST_RENDER)
#declare CHAIR_BACK = box
{
  <-CW/2*1.2,0.0,0.03>
  < CW/2*1.2,0.0,-CLH>
}
#else
#declare CHAIR_BACK = difference
{
  union
  {
    object
    {
      CHAIR_TORI

      translate <-CW/2,0.0,0.0>
    }
    object
    {
      CHAIR_TORI

      scale <-1.0,1.0,1.0>
      translate <CW/2,0.0,0.0>
    }
    cylinder
    {
      <-CW/2,0.0,0.05>
      < CW/2,0.0,0.05>
      CHAIR_BACK_THICK
    }
    cylinder
    {
      < CW/2+0.05*cos(CWIN*DEGREE),0.0,-0.05*sin(CWIN*DEGREE)>
      < CW/2+0.05*cos(CWIN*DEGREE) - (CLH+0.2-0.05*sin(CWIN*DEGREE))*tan(CWIN*DEGREE),0.0,-0.05*sin(CWIN*DEGREE) - (CLH+0.2-0.05*sin(CWIN*DEGREE))>
      CHAIR_BACK_THICK
    }
    cylinder
    {
      <-CW/2-0.05*cos(CWIN*DEGREE),0.0,-0.05*sin(CWIN*DEGREE)>
      <-CW/2-0.05*cos(CWIN*DEGREE) + (CLH+0.2-0.05*sin(CWIN*DEGREE))*tan(CWIN*DEGREE),0.0,-0.05*sin(CWIN*DEGREE) - (CLH+0.2-0.05*sin(CWIN*DEGREE))>
      CHAIR_BACK_THICK
    }

    #declare N = -CW/3
    #while (N<=CW/3)
      cylinder
      {
        <N*0.9,0.0,-0.57>
        <N*1.4,0.0, 0.05>
        0.01
      }
      #declare N = N + ((2/3)*CW)/5
    #end
  }
  box
  {
    <-1,-0.5,-CLH>
    < 1, 0.5,-CLH-0.5>
  }

  texture { T_CHAIRWOOD }
}
#end

#declare CHAIR_CUSHION = difference
{
  superellipsoid
  {
    <0.2,0.4>
  }
  box
  {
    <-2, 0.49,-2>
    < 2,-2, 2>
  }

  translate <0,-0.49,0>
  scale <0.2,0.05,0.2>
}

#ifdef (FAST_RENDER)
#declare CHAIR = union
{
  box
  {
    <-1,-1,-1>
    <1,1,1>

    scale <0.2,0.015,0.23>
    translate <0,0.445,0.03>
  }
  cylinder  // Right front foot.
  {
    < 0.00,-0.10, 0.00>
    < 0.00, 0.45, 0.00>
    0.025

    rotate <CHAIR_FOOT_ANGLE,0,0>
    rotate < 0,0,CHAIR_FOOT_ANGLE>
    translate < 0.20,0.00,-0.20>
  }
  cylinder  // Left front foot.
  {
    < 0.00,-0.10, 0.00>
    < 0.00, 0.45, 0.00>
    0.025

    rotate <CHAIR_FOOT_ANGLE,0,0>
    rotate < 0,0,-CHAIR_FOOT_ANGLE>
    translate <-0.20,0.00,-0.20>
  }
  cylinder  // Right back foot.
  {
    < 0.00,-0.10, 0.00>
    < 0.00, 0.45, 0.00>
    0.025

    rotate <-CHAIR_FOOT_ANGLE,0,0>
    rotate < 0,0,CHAIR_FOOT_ANGLE>
    translate < 0.20,0.00, 0.27>
  }
  cylinder  // Left back foot.
  {
    < 0.00,-0.10, 0.00>
    < 0.00, 0.45, 0.00>
    0.025

    rotate <-CHAIR_FOOT_ANGLE,0,0>
    rotate < 0,0,-CHAIR_FOOT_ANGLE>
    translate <-0.20,0.00, 0.27>
  }

  object
  {
    CHAIR_BACK

    rotate <-80,0,0>
    translate <0,CLH+0.447,0.295>
  }

  texture { T_CHAIRWOOD }
}
#else
#declare CHAIR = union
{
  superellipsoid
  {
    <0.03,0.4>

    scale <0.2,0.015,0.23>
    translate <0,0.445,0.03>
  }
  cylinder  // Right front foot.
  {
    < 0.00,-0.10, 0.00>
    < 0.00, 0.45, 0.00>
    0.025

    rotate <CHAIR_FOOT_ANGLE,0,0>
    rotate < 0,0,CHAIR_FOOT_ANGLE>
    translate < 0.20,0.00,-0.20>
  }
  cylinder  // Left front foot.
  {
    < 0.00,-0.10, 0.00>
    < 0.00, 0.45, 0.00>
    0.025

    rotate <CHAIR_FOOT_ANGLE,0,0>
    rotate < 0,0,-CHAIR_FOOT_ANGLE>
    translate <-0.20,0.00,-0.20>
  }
  cylinder  // Right back foot.
  {
    < 0.00,-0.10, 0.00>
    < 0.00, 0.45, 0.00>
    0.025

    rotate <-CHAIR_FOOT_ANGLE,0,0>
    rotate < 0,0,CHAIR_FOOT_ANGLE>
    translate < 0.20,0.00, 0.27>
  }
  cylinder  // Left back foot.
  {
    < 0.00,-0.10, 0.00>
    < 0.00, 0.45, 0.00>
    0.025

    rotate <-CHAIR_FOOT_ANGLE,0,0>
    rotate < 0,0,-CHAIR_FOOT_ANGLE>
    translate <-0.20,0.00, 0.27>
  }

  object
  {
    CHAIR_BACK

    rotate <-80,0,0>
    translate <0,CLH+0.447,0.295>
  }

  object
  {
    CHAIR_CUSHION

    translate <0,0.445+0.015,0>
    texture { T_CUSHION }
  }

  texture { T_CHAIRWOOD }
}
#end
