// Author: Frank Epple.

#include "d:\gfx\povray\include\glass.inc"

// ----------------------------------------------------------------------------------------
// MATERIALS
// ----------------------------------------------------------------------------------------

#declare T_WAX = texture
{
  pigment
  {
    color rgb <0.95,0.92,0.85>
  }
  finish
  {
    ambient 0.4
    diffuse 0.6
    specular 0.75
    roughness 0.1
  }
}

#declare T_PLATE = texture
{
  pigment
  {
    color rgb <0.95,0.95,0.95>
  }
  finish
  {
    ambient    0.4
    diffuse    0.6
    phong      0.3
    phong_size 60
  }
}

// ----------------------------------------------------------------------------------------
// OBJECTS
// ----------------------------------------------------------------------------------------

/*#declare KNIFE = union
{
}

#declare SPOON = union
{
}

#declare FORK = union
{
}

#declare ROSE = union
{
}*/

#declare PLATE = lathe
{
  cubic_spline
  7  // control points
  <0.013605, 0.0>,
  <0.544218, -0.003401>,
  <1.39219, 0.221003>,
  <1.302041, 0.266105>,
  <0.794739, 0.145205>,
  <0.0, 0.119048>,
  <0.0, 0.115646>
  
  scale 0.1
  texture { T_PLATE }
}

#declare GLASS = lathe
{
  cubic_spline
  16  // control points
  <0.006728, -0.006803>,
  <0.126763, -0.003401>,
  <0.321045, -0.0022>,
  <0.320086, 0.019911>,
  <0.14287, 0.054126>,
  <0.084557, 0.136119>,
  <0.064057, 0.439843>,
  <0.094231, 0.544369>,
  <0.259594, 0.653805>,
  <0.342098, 1.05313>,
  <0.301257, 1.30787>,
  <0.293477, 1.300715>,
  <0.335384, 1.049651>,
  <0.240836, 0.650285>,
  <0.003396, 0.584397>,
  <0.0, 0.604349>

  scale 0.1
  texture { T_Glass4 }
}

#declare CANDLEHOLDER = union
{
  lathe
  {
    cubic_spline
    12  // control points
    <0.142857, -0.22449>,
    <0.353741, -0.003401>,
    <0.184305, 0.189261>,
    <0.134263, 0.488508>,
    <0.19124, 0.775641>,
    <0.144522, 1.02223>,
    <0.195583, 1.293744>,
    <0.191717, 1.469549>,
    <0.326531, 1.622449>,
    <0.177602, 1.791552>,
    <0.127619, 1.688503>,
    <0.05034, 1.668537>

    scale 0.1
    texture { T_Gold_2D }
  }
  cylinder
  {
    <0.00, 0.166, 0.00>
    <0.00, 0.400, 0.00>
    0.012

    texture { T_WAX }
  }
  cylinder
  {
    <0.00, 0.400, 0.00>
    <0.00, 0.414, 0.00>
    0.001

    texture
    {
      pigment
      {
        color rgb <0.00,0.00,0.00>
      }
    }
  }
}
