//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 12 lights, 27 textures and 165 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 12/28/1998    (28.12.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     6.0
  color <0.206275,0.206275,0.206275,0.0,0.1>
  turbulence   <0.4,0.4,0.4>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 1.0
  up           <0,0,1>
  fog_offset   -0.5
  fog_alt      0.4
}

camera {  //  Camera StdCam
  location  <0.001, -13.500, 2.000>
  direction <0.0,     0.0,  1.8317>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.000, -0.104, 0.800>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <-41.860, 206.580, 34.840> // Attached to MoonLight
  direction <0.0,     0.0,  5.2812>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-41.010, 207.107, 34.842> // Following MoonLight
}

*/

//
// *******  L I G H T S *******
//

#declare FireLight = light_source {
  <-0.750, -7.490, 0.190>
  color rgb <0.386, 0.157, 0.000>
  fade_distance  3.5
  fade_power 2.0
}

object { FireLight }

light_source {   // Spotlight MoonLight
  <-41.860, 206.580, 34.840>
  color  rgb <1.000, 0.957, 0.829>
  spotlight
    point_at  <-41.010, 207.107, 34.842>
    falloff   5.50  // outer radius (in deg)
      radius    4.50  // inner radius
  fade_distance  50.0
  fade_power 2.0
}

light_source {   // PointOfViewLight
  <0.001, -13.500, 2.000>
  color rgb <0.400, 0.400, 0.400>
  shadowless
  fade_distance  20.0
  fade_power 2.0
}

light_source { // SunLight
  <-60.190, 5.830, 2.000>
  color  rgb<1.000, 0.829, 0.714>
  area_light <-0.062, -0.035, -6.000>, <-2.933, 5.234, -0.000>, 3, 3
  adaptive 1
  jitter
}


light_source { // SunLight1
  <-60.190, 5.830, 2.000>
  color  rgb<1.000, 0.743, 0.714>
  area_light <-0.062, -0.035, -6.000>, <-2.933, 5.234, -0.000>, 3, 3
  adaptive 1
  jitter
}



//
// ********  TEXTURES  *******
//

#include "byop.inc"
#include "colors.inc"

//
// ********  TREE OBJECTS  *******
//

// ************* TREE #1
object {
	#include "defaults.inc"
    #declare MinXDeg=30;	  	  // 35 Minimum X-rotation of forks
    #declare MaxXDeg=50;	  	  // 55 Maximum X-rotation of forks
    #declare IncXDeg=5;		      // 0 Number of degrees to increment X by at each level
    #declare PlusMinus=5;  	  // 20 Angle of change of terminal fork
    #declare IncSplits=1.2;	  	// 1 To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
    #declare BaseLen=0.3;		      // 1 Base Length (length of smallest twig - determines scale of tree)
    #declare LengthInc=1.7;	    // 1.2 Factor By Which to Increase Base Length
    #declare LeafNum=5;		      // 3 Number of Leaves (not counting leaf object at tip of twig)
    #declare LeafShape=0;		    // 0 Default Oval
    #declare LeafTexture=1;	    // 0 Default PaleGreen
    #declare Leaves=
    	texture {
				pigment { rgb<0,0.2,0>}
			}
    #declare BarkTexture=1;	    // 0 Default Brown
		#declare Bark=
			texture {
				pigment { color rgb<0.12,0.08,0>}
			}
	#include "trees.inc"
  rotate x*90
	translate <-6,9,-1>
}

// ************* TREE #2
object {
	#include "defaults.inc"
    #declare MinXDeg=30;	  	  // 35 Minimum X-rotation of forks
    #declare MaxXDeg=50;	  	  // 55 Maximum X-rotation of forks
    #declare IncXDeg=5;		      // 0 Number of degrees to increment X by at each level
    #declare PlusMinus=5;  	  // 20 Angle of change of terminal fork
    #declare IncSplits=1.2;	  	// 1 To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
    #declare BaseLen=0.3;		      // 1 Base Length (length of smallest twig - determines scale of tree)
    #declare LengthInc=1.3;	    // 1.2 Factor By Which to Increase Base Length
    #declare LeafNum=4;		      // 3 Number of Leaves (not counting leaf object at tip of twig)
    #declare LeafShape=2;		    // 0 Default Oval
    #declare LeafTexture=1;	    // 0 Default PaleGreen
    #declare Leaves=
    	texture {
				pigment { rgb<0,0.2,0>}
			}
    #declare BarkTexture=1;	    // 0 Default Brown
		#declare Bark=
			texture {
				pigment { color rgb<0.12,0.08,0>}
			}
	#include "trees.inc"
  rotate x*90
	translate <-4,15,-1>
}

// ************* TREE #3
object {
	#include "defaults.inc"
    #declare MinXDeg=30;	  	  // 35 Minimum X-rotation of forks
    #declare MaxXDeg=40;	  	  // 55 Maximum X-rotation of forks
    #declare IncXDeg=10;		      // 0 Number of degrees to increment X by at each level
    #declare PlusMinus=5;  	  // 20 Angle of change of terminal fork
    #declare MinSplits=2;	  	  // 3 Minimum number of forks in a section of Tree (minimum of 1)
    #declare IncSplits=1.3;	  	// 1 To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
    #declare BaseLen=0.3;		      // 1 Base Length (length of smallest twig - determines scale of tree)
    #declare LengthInc=1.4;	    // 1.2 Factor By Which to Increase Base Length
    #declare LeafNum=2;		      // 3 Number of Leaves (not counting leaf object at tip of twig)
    #declare LeafShape=8;		    // 0 Default Oval
    #declare LeafTexture=1;	    // 0 Default PaleGreen
    #declare Leaves=
    	texture {
				pigment { rgb<0,0.2,0>}
			}
    #declare BarkTexture=1;	    // 0 Default Brown
		#declare Bark=
			texture {
				pigment { color rgb<0.12,0.08,0>}
			}
	#include "trees.inc"
  rotate x*90
	translate <-0.5,18,-1.5>
}

// ************* TREE #4
object {
	#include "defaults.inc"
    #declare MinXDeg=30;	  	  // 35 Minimum X-rotation of forks
    #declare MaxXDeg=50;	  	  // 55 Maximum X-rotation of forks
    #declare IncXDeg=8;		      // 0 Number of degrees to increment X by at each level
    #declare PlusMinus=5;  	  // 20 Angle of change of terminal fork
    #declare IncSplits=1.2;	  	// 1 To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
    #declare BaseLen=0.4;		      // 1 Base Length (length of smallest twig - determines scale of tree)
    #declare LengthInc=1.3;	    // 1.2 Factor By Which to Increase Base Length
    #declare LeafNum=5;		      // 3 Number of Leaves (not counting leaf object at tip of twig)
    #declare LeafShape=3;		    // 0 Default Oval
    #declare LeafTexture=1;	    // 0 Default PaleGreen
    #declare Leaves=
    	texture {
				pigment { rgb<0,0.2,0>}
			}
    #declare BarkTexture=1;	    // 0 Default Brown
		#declare Bark=
			texture {
				pigment { color rgb<0.12,0.08,0>}
			}
	#include "trees.inc"
  rotate x*90
	translate <4,14,-1>
}

// ************* TREE #5
object {
	#include "defaults.inc"
    #declare MinXDeg=20;	  	  // 35 Minimum X-rotation of forks
    #declare MaxXDeg=40;	  	  // 55 Maximum X-rotation of forks
    #declare IncXDeg=6;		      // 0 Number of degrees to increment X by at each level
    #declare PlusMinus=5;  	  // 20 Angle of change of terminal fork
    #declare IncSplits=1.2;	  	// 1 To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
    #declare BaseLen=0.3;		      // 1 Base Length (length of smallest twig - determines scale of tree)
    #declare LengthInc=1.5;	    // 1.2 Factor By Which to Increase Base Length
    #declare LeafNum=4;		      // 3 Number of Leaves (not counting leaf object at tip of twig)
    #declare LeafShape=7;		    // 0 Default Oval
    #declare LeafTexture=1;	    // 0 Default PaleGreen
    #declare Leaves=
    	texture {
				pigment { rgb<0,0.2,0>}
			}
    #declare BarkTexture=1;	    // 0 Default Brown
		#declare Bark=
			texture {
				pigment { color rgb<0.12,0.08,0>}
			}
	#include "trees.inc"
  rotate x*90
	translate <6,5,-1>
}

//
// ********  REFERENCED OBJECTS  *******
//

#declare Leave = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 3,
      <10.149750, 0.018559, -4.306170>, <10.213709, 0.011557, -4.331905>, <10.161317, 0.000327, -4.410014>, <10.153774, 0.000403, -4.410024>,
      <8.099035, -0.820735, -2.378717>, <8.154730, -0.508330, -2.486756>, <8.118111, -0.011298, -2.813288>, <8.111555, -0.014674, -2.813288>,
      <5.674123, -1.287001, -1.314554>, <5.731608, -0.792419, -1.445280>, <5.708641, -0.012422, -1.840380>, <5.702665, -0.017709, -1.840380>,
      <4.240668, -1.428293, -0.907668>, <4.297433, -0.878207, -1.046694>, <4.279517, -0.011851, -1.466880>, <4.273269, -0.017712, -1.466880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 3,
      <4.240668, -1.428293, -0.907668>, <4.297433, -0.878207, -1.046694>, <4.279517, -0.011851, -1.466880>, <4.273269, -0.017712, -1.466880>,
      <2.807212, -1.569585, -0.500782>, <2.863258, -0.963994, -0.648109>, <2.850393, -0.011280, -1.093380>, <2.843872, -0.017714, -1.093380>,
      <0.358162, -1.773082, -0.250391>, <0.414208, -1.088814, -0.397717>, <0.412699, -0.011762, -0.842989>, <0.406178, -0.019022, -0.842989>,
      <-0.812035, -1.768890, -0.156495>, <-0.755673, -1.082597, -0.303821>, <-0.751763, -0.011925, -0.686494>, <-0.757968, -0.019206, -0.749092>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 3,
      <-0.812035, -1.768890, -0.156495>, <-0.755673, -1.082597, -0.303821>, <-0.751763, -0.011925, -0.686494>, <-0.757968, -0.019206, -0.749092>,
      <-1.982232, -1.764698, -0.062598>, <-1.925554, -1.076380, -0.209924>, <-1.916224, -0.012088, -0.530000>, <-1.922115, -0.019390, -0.592598>,
      <-4.769139, -1.610645, 0.000000>, <-4.704983, -0.984157, -0.147326>, <-4.682807, -0.012016, -0.592598>, <-4.689476, -0.018673, -0.592598>,
      <-8.083704, -1.560995, 0.000000>, <-8.021012, -0.955492, -0.147326>, <-7.987994, -0.012586, -0.592598>, <-7.994510, -0.019030, -0.592598>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 3,
      <10.153774, 0.000403, -4.410024>, <10.146231, 0.000480, -4.410034>, <10.183388, -0.010963, -4.331945>, <10.104268, -0.018767, -4.306231>,
      <8.111555, -0.014674, -2.813288>, <8.104999, -0.018050, -2.813288>, <8.128377, 0.486505, -2.486756>, <8.059505, 0.828112, -2.378717>,
      <5.702665, -0.017709, -1.840380>, <5.696690, -0.022997, -1.840380>, <5.707590, 0.765837, -1.445280>, <5.638097, 1.295667, -1.314554>,
      <4.273269, -0.017712, -1.466880>, <4.267021, -0.023573, -1.466880>, <4.272319, 0.848994, -1.046694>, <4.202997, 1.434383, -0.907668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 3,
      <4.273269, -0.017712, -1.466880>, <4.267021, -0.023573, -1.466880>, <4.272319, 0.848994, -1.046694>, <4.202997, 1.434383, -0.907668>,
      <2.843872, -0.017714, -1.093380>, <2.837352, -0.024148, -1.093380>, <2.837048, 0.932150, -0.648109>, <2.767897, 1.573099, -0.500782>,
      <0.406178, -0.019022, -0.842989>, <0.399658, -0.026282, -0.842989>, <0.387998, 1.050770, -0.397717>, <0.318847, 1.773082, -0.250391>,
      <-0.757968, -0.019206, -0.749092>, <-0.764174, -0.026487, -0.749092>, <-0.780619, 1.063147, -0.303821>, <-0.849453, 1.787483, -0.156495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 3,
      <-0.757968, -0.019206, -0.749092>, <-0.764174, -0.026487, -0.749092>, <-0.780619, 1.063147, -0.303821>, <-0.849453, 1.787483, -0.156495>,
      <-1.922115, -0.019390, -0.592598>, <-1.928006, -0.026692, -0.655196>, <-1.949235, 1.075523, -0.209924>, <-2.017753, 1.801884, -0.062598>,
      <-4.689476, -0.018673, -0.592598>, <-4.696145, -0.025330, -0.592598>, <-4.731789, 0.977674, -0.147326>, <-4.809348, 1.640910, 0.000000>,
      <-7.994510, -0.019030, -0.592598>, <-8.001026, -0.025475, -0.592598>, <-8.047206, 0.943720, -0.147326>, <-8.122994, 1.586774, 0.000000>
    }
  }
  scale 0.5
  rotate -90.0*y
  translate  <1.5, -0.05, 0.6>
}
#declare Stem = union {
  object { Leave }
  translate  <0.63, -0.05, -5.8>
}
#declare LeavePlant = union {
  object { Stem }
  object { // Stem1->Stem
    Stem
    rotate <0.0, 2.5, -80.529999>
    translate  <0.309898, -0.057715, 0.007577>
  }
  object { // Stem2->Stem
    Stem
    rotate <0.0, 5.0, -161.059998>
    translate  <0.112413, -0.111683, 0.005873>
  }
  object { // Stem3->Stem
    Stem
    rotate <0.0, 7.5, 118.410004>
    translate  <0.236938, 0.470415, -0.005103>
  }
  object { // Stem4->Stem
    Stem
    rotate <0.0, 10.0, 37.880005>
    translate  <1.242639, 0.465884, -0.025318>
  }
  object { // Stem5->Stem
    Stem
    rotate <-0.0, 12.5, -42.649994>
    translate  <1.482838, -0.762094, -0.054723>
  }
  object { // Stem6->Stem
    Stem
    rotate <0.0, 15.0, -123.179993>
    translate  <0.086864, -1.152589, -0.093245>
  }
  object { // Stem7->Stem
    Stem
    rotate <0.0, 17.5, 156.289978>
    translate  <-0.520524, 0.550985, -0.140795>
  }
  object { // Stem8->Stem
    Stem
    rotate <-0.0, 20.0, 75.76001>
    translate  <1.441915, 1.649503, -0.197263>
  }
  object { // Stem9->Stem
    Stem
    rotate <0.0, 22.5, -4.77002>
    translate  <3.125769, -0.279484, -0.262521>
  }
  object { // Stem10->Stem
    Stem
    rotate <0.0, 25.0, -85.299988>
    translate  <1.381185, -2.393449, -0.336419>
  }
  object { // Stem11->Stem
    Stem
    rotate <0.0, 27.5, -165.830017>
    translate  <-1.133043, -0.765902, -0.418791>
  }
  object { // Stem12->Stem
    Stem
    rotate <0.0, 30.0, 113.640015>
    translate  <0.29381, 2.32001, -0.509453>
  }
  object { // Stem13->Stem
    Stem
    rotate <-0.0, 32.5, 33.109985>
    translate  <3.951009, 1.406298, -0.608202>
  }
  object { // Stem14->Stem
    Stem
    rotate <0.0, 35.0, -47.420044>
    translate  <3.715903, -2.560352, -0.714817>
  }
  object { // Stem15->Stem
    Stem
    rotate <-0.0, 37.5, -127.949951>
    translate  <-0.405099, -2.919654, -0.829061>
  }
  object { // Stem16->Stem
    Stem
    rotate <0.0, 40.0, 151.52002>
    translate  <-1.381822, 1.413401, -0.950679>
  }
  object { // Stem17->Stem
    Stem
    rotate <0.0, 42.5, 70.98999>
    translate  <3.079582, 3.241624, -1.079402>
  }
  object { // Stem18->Stem
    Stem
    rotate <0.0, 45.0, -9.540039>
    translate  <5.845885, -1.013893, -1.214943>
  }
  object { // Stem19->Stem
    Stem
    rotate <-0.0, 47.5, -90.069946>
    translate  <2.024196, -4.534172, -1.357001>
  }
  texture {
    PlantTex
  }
  scale 0.08
  translate  <1.98, -8.06, 0.74>
}
#declare Palm = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.742582, -2.186350, -1.306472>, <-3.596464, -2.608006, -1.056922>, <-1.998035, -2.928048, -0.862827>, <0.000000, -2.928048, -0.862827>,
      <-5.366968, -1.756899, -0.554557>, <-3.996071, -1.970260, -0.305006>, <-1.998035, -1.970260, -0.110911>, <0.000000, -1.970260, -0.110911>,
      <-4.572400, -0.267008, -0.759625>, <-3.996071, -0.267008, -0.510074>, <-1.998035, -0.267008, -0.315979>, <0.000000, -0.267008, -0.315979>,
      <-4.572400, 0.013671, -0.759625>, <-3.996071, 0.013671, -0.510074>, <-1.998035, 0.013671, -0.315979>, <0.000000, 0.013671, -0.315979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.572400, 0.013671, -0.759625>, <-3.996071, 0.013671, -0.510074>, <-1.998035, 0.013671, -0.315979>, <0.000000, 0.013671, -0.315979>,
      <-4.572400, 0.294351, -0.759625>, <-3.996071, 0.294351, -0.510074>, <-1.998035, 0.294351, -0.315979>, <0.000000, 0.294351, -0.315979>,
      <-5.366968, 1.756899, -0.554557>, <-3.996071, 1.970260, -0.305006>, <-1.998035, 1.970260, -0.110911>, <0.000000, 1.970260, -0.110911>,
      <-4.742582, 2.241035, -1.306472>, <-3.596464, 2.662690, -1.056922>, <-1.998035, 2.982733, -0.862827>, <0.000000, 2.982733, -0.862827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -2.928048, -0.862827>, <1.998035, -2.928048, -0.862827>, <3.596464, -2.608006, -1.029194>, <4.499098, -2.046424, -1.201730>,
      <0.000000, -1.970260, -0.110911>, <1.998035, -1.970260, -0.110911>, <3.996071, -1.970260, -0.277278>, <5.338401, -1.756899, -1.261085>,
      <0.000000, -0.267008, -0.315979>, <1.998035, -0.267008, -0.315979>, <3.996071, -0.267008, -0.482346>, <6.489633, -0.005206, -1.494683>,
      <0.000000, 0.013671, -0.315979>, <1.998035, 0.013671, -0.315979>, <3.996071, 0.013671, -0.482346>, <6.489633, 0.000267, -1.494683>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.013671, -0.315979>, <1.998035, 0.013671, -0.315979>, <3.996071, 0.013671, -0.482346>, <6.489633, 0.000267, -1.494683>,
      <0.000000, 0.294351, -0.315979>, <1.998035, 0.294351, -0.315979>, <3.996071, 0.294351, -0.482346>, <6.489633, 0.005739, -1.494683>,
      <0.000000, 1.970260, -0.110911>, <1.998035, 1.970260, -0.110911>, <3.996071, 1.970260, -0.277278>, <5.338401, 1.756899, -1.261085>,
      <0.000000, 2.982733, -0.862827>, <1.998035, 2.982733, -0.862827>, <3.596464, 2.662690, -1.029194>, <4.499098, 2.097609, -1.201730>
    }
  }
  scale <0.965151, 0.997013, 0.649507>
  rotate <3.77474, -12.538048, 178.994934>
  translate  <-10.141222, 0.015542, 15.875>
}
#declare PalmStem = difference {
  torus { // StemTorus
    1.015, 0.015  rotate -x*90
    scale <-7.99, -14.01, -7.97>
    rotate -90.0*x
    translate  <-8.45, -0.23, 0.76>
  }
  box { // StemSub1
    <-1, -1, -1>, <1, 1, 1>
    scale 7.63
    rotate 46.600006*y
    translate  <-13.89, 0.0, 10.43>
  }
  box { // StemSub2
    <-1, -1, -1>, <1, 1, 1>
    scale 11.84
    rotate 14.699998*y
    translate  <-11.67, 0.0, -10.68>
  }
}
#declare PalmLeave = union {
  object { Palm }
  object { PalmStem }
  translate  <-0.6, 0.46, 0.0>
}
#declare PalmPlant = union {
  object { PalmLeave }
  object { // PalmLeave1->PalmLeave
    PalmLeave
    scale 1.02
    rotate <-1.0, -6.0, -80.529999>
    translate  <-0.962735, -0.216695, 0.072115>
  }
  object { // PalmLeave2->PalmLeave
    PalmLeave
    scale 1.0404
    rotate <-2.0, -12.0, -161.059998>
    translate  <-1.329499, 0.715337, 0.146124>
  }
  object { // PalmLeave3->PalmLeave
    PalmLeave
    scale 1.061208
    rotate <-3.0, -18.0, 118.410004>
    translate  <-0.45558, 1.217622, 0.221056>
  }
  object { // PalmLeave4->PalmLeave
    PalmLeave
    scale 1.082432
    rotate <-4.0, -24.0, 37.880005>
    translate  <0.162131, 0.423575, 0.295889>
  }
  object { // PalmLeave5->PalmLeave
    PalmLeave
    scale 1.104081
    rotate <-5.0, -30.0, -42.649994>
    translate  <-0.537107, -0.285821, 0.369558>
  }
  object { // PalmLeave6->PalmLeave
    PalmLeave
    scale 1.126162
    rotate <-6.0, -36.0, -123.179993>
    translate  <-1.312944, 0.311069, 0.440973>
  }
  object { // PalmLeave7->PalmLeave
    PalmLeave
    scale 1.148686
    rotate <-7.0, -42.0, 156.289978>
    translate  <-0.818612, 1.128815, 0.509027>
  }
  object { // PalmLeave8->PalmLeave
    PalmLeave
    scale 1.171659
    rotate <-8.0, -48.0, 75.76001>
    translate  <0.019317, 0.730626, 0.572618>
  }
  object { // PalmLeave9->PalmLeave
    PalmLeave
    scale 1.195093
    rotate <-9.0, -54.0, -4.77002>
    translate  <-0.29447, -0.110357, 0.630659>
  }
  texture {
    PalmTex
  }
  scale <0.05, 0.05, 0.08>
  rotate -105.899971*z
  translate  <-3.13, -5.31, 0.0>
}
#declare FernBranch = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-15.697658, -2.592005, -2.396296>, <-10.465105, -2.592005, -0.943995>, <-5.232553, -2.592005, 0.000000>, <0.000000, -2.592005, 0.000000>,
      <-15.697658, -1.739993, -1.940667>, <-10.465105, -1.739993, -0.488367>, <-5.232553, -1.739993, 0.455629>, <0.000000, -1.739993, 0.455629>,
      <-15.697658, -0.305587, -3.115709>, <-10.465105, -0.305587, -1.663409>, <-5.232553, -0.305587, -0.719414>, <0.000000, -0.305587, -0.719414>,
      <-15.697658, 0.023980, -3.115709>, <-10.465105, 0.023980, -1.663409>, <-5.232553, 0.023980, -0.719414>, <0.000000, 0.023980, -0.719414>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-15.697658, 0.023980, -3.115709>, <-10.465105, 0.023980, -1.663409>, <-5.232553, 0.023980, -0.719414>, <0.000000, 0.023980, -0.719414>,
      <-15.697658, 0.353548, -3.115709>, <-10.465105, 0.353548, -1.663409>, <-5.232553, 0.353548, -0.719414>, <0.000000, 0.353548, -0.719414>,
      <-15.697658, 1.716013, -1.940667>, <-10.465105, 1.716013, -0.488367>, <-5.232553, 1.716013, 0.455629>, <0.000000, 1.716013, 0.455629>,
      <-15.697658, 2.592005, -2.396296>, <-10.465105, 2.592005, -0.943995>, <-5.232553, 2.592005, 0.000000>, <0.000000, 2.592005, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -2.592005, 0.000000>, <5.232553, -2.592005, 0.000000>, <10.465105, -2.592005, -0.943995>, <15.697658, -2.592005, -2.396296>,
      <0.000000, -1.739993, 0.455629>, <5.232553, -1.739993, 0.455629>, <10.465105, -1.739993, -0.488367>, <15.697658, -1.739993, -1.940667>,
      <0.000000, -0.305587, -0.719414>, <5.232553, -0.305587, -0.719414>, <10.465105, -0.305587, -1.663409>, <15.697658, -0.305587, -3.115709>,
      <0.000000, 0.023980, -0.719414>, <5.232553, 0.023980, -0.719414>, <10.465105, 0.023980, -1.663409>, <15.697658, 0.023980, -3.115709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.023980, -0.719414>, <5.232553, 0.023980, -0.719414>, <10.465105, 0.023980, -1.663409>, <15.697658, 0.023980, -3.115709>,
      <0.000000, 0.353548, -0.719414>, <5.232553, 0.353548, -0.719414>, <10.465105, 0.353548, -1.663409>, <15.697658, 0.353548, -3.115709>,
      <0.000000, 1.716013, 0.455629>, <5.232553, 1.716013, 0.455629>, <10.465105, 1.716013, -0.488367>, <15.697658, 1.716013, -1.940667>,
      <0.000000, 2.592005, 0.000000>, <5.232553, 2.592005, 0.000000>, <10.465105, 2.592005, -0.943995>, <15.697658, 2.592005, -2.396296>
    }
  }
  texture {
    FernTex_1
    scale <16.1, 2.95, 2.45>
  }
  scale 0.04
  rotate <-0.293024, 70.906715, -178.58931>
  translate  <0.22, 0.01, 0.54>
}
#declare Fern = union {
  object { FernBranch }
  object { // FernBranch1->FernBranch
    FernBranch
    scale 1.04
    rotate <0.287955, 4.8052, -79.586655>
    translate  <0.03, -0.02, -0.01>
  }
  object { // FernBranch2->FernBranch
    FernBranch
    scale 1.0816
    rotate <0.735237, 9.604977, -159.163177>
    translate  <-0.01, -0.03, 0.0>
  }
  object { // FernBranch3->FernBranch
    FernBranch
    scale 1.124864
    rotate <1.346887, 14.395339, 121.291199>
    translate  <0.06, 0.08, 0.01>
  }
  object { // FernBranch4->FernBranch
    FernBranch
    scale 1.169859
    rotate <2.132876, 19.172003, 41.799191>
    translate  <0.2, 0.02, 0.02>
  }
  object { // FernBranch5->FernBranch
    FernBranch
    scale 1.216653
    rotate <3.108956, 23.930191, -37.613064>
    translate  <0.08, -0.08, 0.04>
  }
  object { // FernBranch6->FernBranch
    FernBranch
    scale 1.265319
    rotate <4.298073, 28.664333, -116.914139>
    translate  <0.09, -0.08, 0.07>
  }
  object { // FernBranch7->FernBranch
    FernBranch
    scale 1.315932
    rotate <5.732557, 33.367649, 163.935074>
    translate  <-0.05, 0.09, 0.1>
  }
  object { // FernBranch8->FernBranch
    FernBranch
    scale 1.368569
    rotate <7.457478, 38.031574, 84.985291>
    translate  <0.14, 0.19, 0.14>
  }
  object { // FernBranch9->FernBranch
    FernBranch
    scale 1.423312
    rotate <9.535772, 42.644855, 6.30378>
    translate  <0.31, -0.04, 0.19>
  }
  scale 0.57
  rotate -41.500111*z
  translate  <-1.7, -8.44, 0.0>
}


#declare HutWall = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.102216, 0.000000, 0.002496>, <-1.086026, -0.615124, 0.004991>, <-0.615124, -1.118407, 0.000000>, <0.000000, -1.118407, 0.000000>,
      <-1.103755, 0.000000, 0.551878>, <-1.103755, -0.607065, 0.551878>, <-0.607065, -1.103755, 0.551878>, <0.000000, -1.103755, 0.551878>,
      <-1.048170, 0.000000, 1.079009>, <-1.035834, -0.593455, 1.079009>, <-0.593455, -1.079009, 1.079009>, <0.000000, -1.069757, 1.079009>,
      <-0.982435, -0.040091, 1.519912>, <-0.951596, -0.637482, 1.519912>, <-0.557301, -1.013274, 1.519912>, <0.000000, -1.013274, 1.519912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.118407, 0.000000>, <0.615124, -1.118407, 0.000000>, <1.164665, -0.615124, 0.000000>, <1.147704, -0.003084, 0.000000>,
      <0.000000, -1.103755, 0.551878>, <0.607065, -1.103755, 0.551878>, <1.129968, -0.528060, 0.551878>, <1.116862, 0.039502, 0.551878>,
      <0.000000, -1.069757, 1.079009>, <0.593455, -1.060505, 1.079009>, <1.105222, -0.514450, 1.079009>, <1.092115, 0.039502, 1.079009>,
      <0.000000, -1.013274, 1.519912>, <0.557301, -1.013274, 1.519912>, <1.013274, -0.557301, 1.519912>, <1.013274, 0.000000, 1.519912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.147704, -0.003084, 0.000000>, <1.130742, 0.608956, 0.000000>, <0.615124, 1.118407, 0.000000>, <0.000000, 1.118407, 0.000000>,
      <1.116862, 0.039502, 0.551878>, <1.103755, 0.607065, 0.551878>, <0.607065, 1.133703, 0.556869>, <0.000000, 1.118729, 0.554373>,
      <1.092115, 0.039502, 1.079009>, <1.079009, 0.593455, 1.079009>, <0.593455, 1.108957, 1.084000>, <0.000000, 1.093983, 1.081504>,
      <1.013274, 0.000000, 1.519912>, <1.013274, 0.557301, 1.519912>, <0.606643, 1.031778, 1.519912>, <0.033923, 1.010190, 1.519912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.118407, 0.000000>, <-0.615124, 1.118407, 0.000000>, <-1.118407, 0.615124, 0.000000>, <-1.102216, 0.000000, 0.002496>,
      <0.000000, 1.118729, 0.554373>, <-0.607065, 1.103755, 0.551878>, <-1.103755, 0.607065, 0.551878>, <-1.103755, 0.000000, 0.551878>,
      <0.000000, 1.093983, 1.081504>, <-0.593455, 1.079009, 1.079009>, <-1.060505, 0.593455, 1.079009>, <-1.048170, 0.000000, 1.079009>,
      <0.033923, 1.010190, 1.519912>, <-0.538797, 0.988603, 1.519912>, <-1.013274, 0.557301, 1.519912>, <-0.982435, -0.040091, 1.519912>
    }
  }
}
#declare HutRoof = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.017544, -0.008356, 0.000000>, <-1.035088, -0.591854, 0.000000>, <-0.537664, -0.956825, 0.000000>, <0.006168, -0.978413, 0.000000>,
      <-0.846574, -0.025196, 0.493925>, <-0.865143, -0.499249, 0.493925>, <-0.455403, -0.816102, 0.493925>, <-0.003084, -0.754424, 0.493925>,
      <-0.628673, 0.000000, 0.826650>, <-0.628673, -0.353251, 0.826650>, <-0.398653, -0.642343, 0.826650>, <-0.026441, -0.642309, 0.826650>,
      <0.000000, 0.000000, 1.053163>, <0.000000, 0.000000, 1.053163>, <0.000000, 0.000000, 1.053163>, <0.000000, 0.000000, 1.053163>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006168, -0.978413, 0.000000>, <0.550000, -1.000000, 0.000000>, <0.932154, -0.580839, 0.000000>, <0.993832, -0.000000, 0.000000>,
      <-0.003084, -0.754424, 0.493925>, <0.449235, -0.692746, 0.493925>, <0.828005, -0.448856, 0.493925>, <0.828005, 0.000000, 0.493925>,
      <-0.026441, -0.642309, 0.826650>, <0.345770, -0.642274, 0.826650>, <0.628673, -0.353251, 0.826650>, <0.595504, -0.029591, 0.826650>,
      <0.000000, 0.000000, 1.053163>, <-0.000000, 0.000000, 1.053163>, <-0.000000, 0.000000, 1.053163>, <-0.000000, 0.000000, 1.053163>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.993832, -0.000000, 0.000000>, <1.055510, 0.580839, 0.000000>, <0.556168, 1.037007, 0.000000>, <0.006168, 1.006168, 0.000000>,
      <0.828005, 0.000000, 0.493925>, <0.828005, 0.448856, 0.493925>, <0.455403, 0.816102, 0.493925>, <0.004897, 0.780009, 0.493925>,
      <0.595504, -0.029591, 0.826650>, <0.562334, 0.294070, 0.826650>, <0.345770, 0.642274, 0.826650>, <0.000000, 0.642274, 0.826650>,
      <-0.000000, 0.000000, 1.053163>, <-0.000000, -0.000000, 1.053163>, <-0.000000, -0.000000, 1.053163>, <0.000000, -0.000000, 1.053163>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006168, 1.006168, 0.000000>, <-0.543832, 0.975329, 0.000000>, <-1.000000, 0.575143, 0.000000>, <-1.017544, -0.008356, 0.000000>,
      <0.004897, 0.780009, 0.493925>, <-0.445609, 0.743916, 0.493925>, <-0.828005, 0.448856, 0.493925>, <-0.846574, -0.025196, 0.493925>,
      <0.000000, 0.642274, 0.826650>, <-0.345770, 0.642274, 0.826650>, <-0.628673, 0.353251, 0.826650>, <-0.628673, 0.000000, 0.826650>,
      <0.000000, -0.000000, 1.053163>, <0.000000, -0.000000, 1.053163>, <0.000000, -0.000000, 1.053163>, <0.000000, 0.000000, 1.053163>
    }
  }
  scale 1.18
  translate  <0.01, 0.0, 1.3>
}
#declare HutOut = union {
  object { HutWall }
  object { HutRoof }
  texture {
    HutOutTex
  }
}
#declare HutDoorCover = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.801571, -2.579065, -0.480600>, <-2.577494, -2.690085, -0.443715>, <-1.242641, -2.690085, -0.337443>, <0.009221, -2.690085, -0.379167>,
      <-3.838578, -1.757576, -0.314069>, <-2.577494, -1.757576, -0.221674>, <-1.242641, -1.757576, -0.198667>, <0.009221, -1.757576, -0.171004>,
      <-3.801571, -0.878788, -0.147538>, <-2.577494, -0.878788, -0.110654>, <-1.242641, -0.878788, -0.115402>, <0.009221, -0.878788, -0.025289>,
      <-3.820075, 0.000000, -0.147538>, <-2.577494, 0.000000, -0.069021>, <-1.242641, -0.046259, -0.094585>, <0.009221, -0.023129, -0.044919>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.820075, 0.000000, -0.147538>, <-2.577494, 0.000000, -0.069021>, <-1.242641, -0.046259, -0.094585>, <0.009221, -0.023129, -0.044919>,
      <-3.838578, 0.878788, -0.147538>, <-2.577494, 0.878788, -0.027388>, <-1.242641, 0.786271, -0.073769>, <0.009221, 0.832529, -0.046106>,
      <-3.931095, 1.757576, -0.272436>, <-2.577494, 1.757576, -0.277184>, <-1.242641, 1.757576, -0.157034>, <0.009221, 1.757576, -0.150187>,
      <-3.783068, 2.680833, -0.549987>, <-2.577494, 2.717840, -0.443715>, <-1.242641, 2.717840, -0.337443>, <0.009221, 2.717840, -0.344473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.009221, -2.690085, -0.379167>, <1.261084, -2.690085, -0.420891>, <2.522167, -2.690085, -0.374694>, <4.097809, -2.838112, -0.333061>,
      <0.009221, -1.757576, -0.171004>, <1.261084, -1.757576, -0.143340>, <2.522167, -1.757576, -0.124898>, <3.783251, -1.757576, -0.124898>,
      <0.009221, -0.878788, -0.025289>, <1.261084, -0.878788, 0.064823>, <2.596181, -0.878788, 0.083265>, <3.820258, -0.878788, 0.000000>,
      <0.009221, -0.023129, -0.044919>, <1.261084, 0.000000, 0.023190>, <2.559174, 0.000000, 0.020816>, <3.829510, 0.000000, 0.041633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.009221, -0.023129, -0.044919>, <1.261084, 0.000000, 0.023190>, <2.559174, 0.000000, 0.020816>, <3.829510, 0.000000, 0.041633>,
      <0.009221, 0.832529, -0.046106>, <1.261084, 0.878788, -0.018442>, <2.522167, 0.878788, -0.041633>, <3.838761, 0.878788, 0.083265>,
      <0.009221, 1.757576, -0.150187>, <1.261084, 1.757576, -0.143340>, <2.522167, 1.757576, -0.055510>, <3.783251, 1.757576, -0.124898>,
      <0.009221, 2.717840, -0.344473>, <1.261084, 2.717840, -0.351504>, <2.522167, 2.717840, -0.333061>, <4.023795, 2.865867, -0.333061>
    }
  }
  texture {
    HutDoorCoverTex
    scale <-0.48, 1.28, 9.97>
    rotate <-30.573532, -84.06855, 31.422333>
    translate <-4.700000, -0.220000, -0.320000>
  }
  scale <0.16, 0.13, 0.16>
  rotate <4.154418, -86.091927, 0.359167>
  translate  <-1.12, -0.11, 0.66>
}
#declare Hut = union {
  object { HutOut }
  object { // HutOut1->HutOut
    HutOut
    texture {
      HutMidTex
    }
    scale 0.98
    translate  0.01*z
  }
  object { // HutOut2->HutOut
    HutOut
    texture {
      HutInTex
    }
    scale 0.9604
    translate  <0.0, 0.01, 0.02>
  }
  object { HutDoorCover }
  scale <1.52, 1.55, 1.27>
  translate  <3.3, -3.11, -0.1>
}
#declare SpearTip = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-0.333333, 0.0>,
  <-0.0, -1.319728>,
  <0.333333, 0.0>,
  <0.0, 1.319728>,
  <-0.333333, 0.0>
  rotate <90,0,90>
  texture {
    TipTex
  }
  scale <0.08, 0.15, 0.46>
  rotate <-180.0, 0.0, -180.0>
  translate  1.7*z
}
#declare Rope = object {
  torus { // Rope
    1.75, 0.25  rotate -x*90
    scale 0.025
    rotate -3.5*y
    translate  1.1*z
  }
}
#declare Ropes = union {
  object { Rope }
  object { // Rope1->Rope
    Rope
    rotate -0.0*y
    translate  -0.01*z
  }
  object { // Rope2->Rope
    Rope
    rotate -0.0*y
    translate  -0.02*z
  }
  object { // Rope3->Rope
    Rope
    rotate -0.0*y
    translate  -0.03*z
  }
  object { // Rope4->Rope
    Rope
    rotate -0.0*y
    translate  -0.04*z
  }
  object { // Rope5->Rope
    Rope
    rotate -0.0*y
    translate  -0.05*z
  }
  texture {
    CanvasTex
  }
}
#declare Spear = union {
  object { SpearTip }
  object { // TipBack->SpearTip
    SpearTip
    texture {
      TipTex
    }
    scale <1.03, 1.0, 0.45>
    rotate <180.0, 0.0, 180.0>
    translate  1.8*z
  }
  cylinder { // Shaft
    <0,0,1>, <0,0,0>, 1
    texture {
      ShaftwoodTex
    }
    scale <0.04, 0.04, 2.79>
    translate  -1.63*z
  }
  object { Ropes }
  scale 0.46
  rotate <-6.834891, 0.31346, -1.766181>
  translate  <2.64, -4.8, 0.54>
}
#declare MaskShape2 = object {
  cylinder { // MaskShape2
    <0,0,1>, <0,0,0>, 1
    scale <0.83, 1.24, 1.0>
    translate  <-0.37, -0.23, 0.0>
  }
}
#declare MaskShape4 = object {
  cylinder { // MaskShape4
    <0,0,1>, <0,0,0>, 1
    scale <0.17, 0.08, 1.0>
    rotate -20.800001*z
    translate  -0.41*x
  }
}
#declare MaskShapePos = union {
  cylinder { // MaskShape1
    <0,0,1>, <0,0,0>, 1
    scale <1.06, 1.42, 1.0>
    translate  -0.73*y
  }
  object { MaskShape2 }
  object { // MaskShape3->MaskShape2
    MaskShape2
    translate  0.74*x
  }
}
#declare MaskShapeNeg = union {
  object { MaskShape4 }
  object { // MaskShape5->MaskShape4
    MaskShape4
    rotate 41.600006*z
    translate  <0.72, 0.29, 0.0>
  }
}
#declare MaskShape = difference {
  object { MaskShapePos }
  object { MaskShapeNeg }
}
#declare MaskCurvePos = object {
  cylinder { // MaskCurvePos
    <0,0,1>, <0,0,0>, 1
    scale <1.54, 0.93, 3.46>
    rotate -90.0*x
    translate  <-0.05, -2.34, -0.22>
  }
}
#declare MaskCurve = difference {
  object { MaskCurvePos }
  object { // MaskCurveNeg->MaskCurvePos
    MaskCurvePos
    scale <0.9, 1.17, 0.9>
    rotate -0.0*x
    translate  <-0.01, -0.05, -0.04>
  }
}
#declare Mask = intersection {
  object { MaskShape }
  object { MaskCurve }
  texture {
    MaskTex
    scale <0.66, 0.69, 1.0>
    translate <0.000000, -0.540000, 0.000000>
  }
  scale <0.26, 0.33, 0.42>
  rotate <71.199997, -3.8, -53.5>
  translate  <2.13, -4.23, 0.56>
}




#declare FireStick = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.068884, 0.000663, -0.565121>, <-0.068884, -0.030599, -0.565121>, <-0.037886, -0.056177, -0.565121>, <0.000000, -0.056177, -0.565121>,
      <-1.375510, 0.104541, -0.471717>, <-1.375510, -0.965363, -0.471717>, <-0.756531, -1.840738, -0.471717>, <0.000000, -1.840738, -0.471717>,
      <-1.000000, 0.054422, 2.684344>, <-1.000000, -0.502549, 2.684344>, <-0.930952, -2.046688, 2.902031>, <-0.190476, -1.420838, 2.820398>,
      <-1.000000, 0.054422, 4.309077>, <-1.000000, -0.502549, 4.309077>, <-0.740476, -1.502470, 4.417920>, <-0.095238, -1.189545, 4.377104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.056177, -0.565121>, <0.037886, -0.056177, -0.565121>, <0.068884, -0.030599, -0.565121>, <0.068884, 0.000663, -0.565121>,
      <0.000000, -1.840738, -0.471717>, <0.756531, -1.840738, -0.471717>, <1.375510, -0.965363, -0.471717>, <1.375510, 0.104541, -0.471717>,
      <-0.190476, -1.420838, 2.820398>, <0.550000, -0.794987, 2.738766>, <1.000000, -0.502549, 2.684344>, <1.000000, 0.054422, 2.684344>,
      <-0.095238, -1.189545, 4.377104>, <0.550000, -0.876620, 4.336288>, <1.000000, -0.502549, 4.309077>, <1.204082, 0.054422, 4.336288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.068884, 0.000663, -0.565121>, <0.068884, 0.031924, -0.565121>, <0.037886, 0.057502, -0.565121>, <0.000000, 0.057502, -0.565121>,
      <1.375510, 0.104541, -0.471717>, <1.375510, 1.174444, -0.471717>, <0.756531, 2.049819, -0.471717>, <0.000000, 2.049819, -0.471717>,
      <1.000000, 0.054422, 2.684344>, <1.000000, 0.611393, 2.684344>, <0.550000, 1.067096, 2.684344>, <0.000000, 1.067096, 2.684344>,
      <1.204082, 0.054422, 4.336288>, <1.408163, 0.611393, 4.363499>, <0.550000, 1.067096, 4.309077>, <-0.095238, 1.393627, 4.281866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.057502, -0.565121>, <-0.037886, 0.057502, -0.565121>, <-0.068884, 0.031924, -0.565121>, <-0.068884, 0.000663, -0.565121>,
      <0.000000, 2.049819, -0.471717>, <-0.756531, 2.049819, -0.471717>, <-1.375510, 1.174444, -0.471717>, <-1.375510, 0.104541, -0.471717>,
      <0.000000, 1.067096, 2.684344>, <-0.550000, 1.067096, 2.684344>, <-1.000000, 0.611393, 2.684344>, <-1.000000, 0.054422, 2.684344>,
      <-0.095238, 1.393627, 4.281866>, <-0.740476, 1.720157, 4.254655>, <-1.000000, 0.611393, 4.309077>, <-1.000000, 0.054422, 4.309077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.054422, 4.309077>, <-1.000000, -0.502549, 4.309077>, <-0.740476, -1.502470, 4.417920>, <-0.095238, -1.189545, 4.377104>,
      <-1.000000, 0.054422, 5.933809>, <-1.000000, -0.502549, 5.933809>, <-0.550000, -0.958253, 5.933809>, <0.000000, -0.958253, 5.933809>,
      <-1.000000, 0.054422, 9.071900>, <-1.000000, -0.502549, 9.071900>, <-0.550000, -0.958253, 9.071900>, <0.000000, -0.958253, 9.071900>,
      <0.024221, 0.054422, 9.077267>, <0.024221, -0.101407, 9.077267>, <0.013322, -0.228903, 9.077267>, <0.000000, -0.228903, 9.077267>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.095238, -1.189545, 4.377104>, <0.550000, -0.876620, 4.336288>, <1.000000, -0.502549, 4.309077>, <1.204082, 0.054422, 4.336288>,
      <0.000000, -0.958253, 5.933809>, <0.550000, -0.958253, 5.933809>, <1.000000, -0.502549, 5.933809>, <1.408163, 0.054422, 5.988231>,
      <0.000000, -0.958253, 9.071900>, <0.550000, -0.958253, 9.071900>, <1.000000, -0.502549, 9.071900>, <1.000000, 0.054422, 9.071900>,
      <0.000000, -0.228903, 9.077267>, <-0.013322, -0.228903, 9.077267>, <-0.024221, -0.101407, 9.077267>, <-0.024221, 0.054422, 9.077267>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.204082, 0.054422, 4.336288>, <1.408163, 0.611393, 4.363499>, <0.550000, 1.067096, 4.309077>, <-0.095238, 1.393627, 4.281866>,
      <1.408163, 0.054422, 5.988231>, <1.816327, 0.611393, 6.042653>, <0.550000, 1.067096, 5.933809>, <-0.190476, 1.720157, 5.879388>,
      <1.000000, 0.054422, 9.071900>, <1.000000, 0.611393, 9.071900>, <0.550000, 1.067096, 9.071900>, <0.000000, 1.067096, 9.071900>,
      <-0.024221, 0.054422, 9.077267>, <-0.024221, 0.210250, 9.077267>, <-0.013322, 0.337746, 9.077267>, <0.000000, 0.337746, 9.077267>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.095238, 1.393627, 4.281866>, <-0.740476, 1.720157, 4.254655>, <-1.000000, 0.611393, 4.309077>, <-1.000000, 0.054422, 4.309077>,
      <-0.190476, 1.720157, 5.879388>, <-0.930952, 2.373219, 5.824966>, <-1.000000, 0.611393, 5.933809>, <-1.000000, 0.054422, 5.933809>,
      <0.000000, 1.067096, 9.071900>, <-0.550000, 1.067096, 9.071900>, <-1.000000, 0.611393, 9.071900>, <-1.000000, 0.054422, 9.071900>,
      <0.000000, 0.337746, 9.077267>, <0.013322, 0.337746, 9.077267>, <0.024221, 0.210250, 9.077267>, <0.024221, 0.054422, 9.077267>
    }
  }
  scale 0.05
  rotate <90.010689, -9.982901, -36.92395>
  translate  <-1.35, -6.63, -0.41>
}
#declare Charcoal = union {
  box { // Coal
    <-1, -1, -1>, <1, 1, 1>
    scale 0.11
    rotate <-125.149742, -47.483963, 166.289825>
    translate  <1.45, 0.03, 0.0>
  }
  sphere { // CoalCenter
    <0,0,0>,1
    scale 0.11
  }
  rotate -19.700001*y
}




//
// ********  OBJECTS  *******
//

#declare BigTree = blob {
  threshold 0.3
  component 1.0, 0.504329, <0.005048, -0.222222, 0.010101>

  component 1.0, 0.504329, <0.005048, 0.0, 0.010101>

  component 1.0, 0.504329, <-0.015145, 0.242424, 0.010101>

  component 1.0, 0.504329, <0.025242, 0.474747, 0.010101>

  component 1.0, 0.504329, <-0.005048, 0.737374, 0.010101>

  component 1.0, 0.504329, <0.035339, 0.949495, 0.010101>

  component 1.0, 0.504329, <-0.015145, 1.222222, 0.010101>

  component 1.0, 0.504329, <0.035339, 1.424242, 0.010101>

  component 1.0, 0.504329, <-0.005048, 1.707071, 0.010101>

  component 1.0, 0.504329, <0.025242, -0.474747, 0.010101>

  component 1.0, 0.504329, <0.025242, -0.707071, 0.015145>

  component 1.0, 0.504329, <0.025242, -0.979798, 0.005048>

  component 1.0, 0.504329, <0.025242, -1.212121, -0.015145>

  component 1.0, 0.504329, <0.025242, -1.474747, -0.005048>

  component 1.0, 0.504329, <0.025242, -1.686869, 0.075726>

  component 1.0, 0.504329, <0.025242, -1.69697, -0.065629>

  component 1.0, 0.180493, <0.307952, 0.0, -0.272727>

  component 1.0, 0.180493, <0.318049, 0.131313, -0.272727>

  component 1.0, 0.180493, <0.368532, 0.555556, -0.272727>

  component 1.0, 0.180493, <0.358436, 0.727273, -0.272727>

  component 1.0, 0.180493, <0.338242, 0.40404, -0.272727>

  component 1.0, 0.180493, <0.328145, 0.272727, -0.272727>

  component 1.0, 0.180493, <0.358436, 0.878788, -0.297855>

  component 1.0, 0.180493, <0.348339, 1.0, -0.297855>

  component 1.0, 0.180493, <0.348339, 1.161616, -0.287758>

  component 1.0, 0.180493, <0.348339, 1.292929, -0.318049>

  component 1.0, 0.180493, <0.368532, 1.454545, -0.318049>

  component 1.0, 0.180493, <0.368532, 1.626263, -0.318049>

  component 1.0, 0.180493, <0.338242, 1.787879, -0.318049>

  component 1.0, 0.180493, <0.328145, -0.161616, -0.272727>

  component 1.0, 0.180493, <0.328145, -0.313131, -0.318049>

  component 1.0, 0.180493, <0.328145, -0.474747, -0.338242>

  component 1.0, 0.180493, <0.358436, -0.626263, -0.338242>

  component 1.0, 0.180493, <0.348339, -0.79798, -0.338242>

  component 1.0, 0.180493, <0.348339, -0.959596, -0.307952>

  component 1.0, 0.180493, <0.348339, -1.131313, -0.348339>

  component 1.0, 0.180493, <0.348339, -1.292929, -0.348339>

  component 1.0, 0.180493, <0.338242, -1.434343, -0.348339>

  component 1.0, 0.180493, <0.338242, -1.606061, -0.348339>

  component 1.0, 0.180493, <0.338242, -1.787879, -0.318049>

  component 1.0, 0.180493, <0.4385, -1.717172, -0.451179>

  component 1.0, 0.180493, <0.404143, 0.0, -0.122746>

  component 1.0, 0.180493, <0.407961, 0.164592, -0.10747>

  component 1.0, 0.180493, <0.411778, 0.321293, -0.096013>

  component 1.0, 0.180493, <0.419413, 0.495405, -0.096013>

  component 1.0, 0.180493, <0.385056, 0.652106, -0.130384>

  component 1.0, 0.180493, <0.396509, 0.808807, -0.073099>

  component 1.0, 0.180493, <0.396509, 0.948097, -0.103651>

  component 1.0, 0.180493, <0.404143, 1.087387, -0.130384>

  component 1.0, 0.180493, <0.388874, 1.226676, -0.092194>

  component 1.0, 0.180493, <0.388874, 1.348555, -0.06928>

  component 1.0, 0.180493, <0.4385, 1.453022, -0.103651>

  component 1.0, 0.180493, <0.377422, 1.557489, -0.10747>

  component 1.0, 0.180493, <0.377422, 1.783835, -0.073099>

  component 1.0, 0.180493, <0.51096, -1.855108, -0.451179>

  component 1.0, 0.347898, <0.041054, -1.715819, 0.0>

  component 1.0, 0.231932, <0.041054, -1.45465, 0.0>

  component 1.0, 0.649829, <0.02365, -2.046632, 0.0>

  component 1.0, 0.279277, <0.02365, -1.245716, 0.0>

  component 1.0, 0.295667, <0.041054, -1.036781, 0.0>

  component 1.0, 0.186994, <0.041054, -0.862669, 0.0>

  component 1.0, 0.183366, <0.058458, -0.758202, 0.0>

  component 1.0, 0.180493, <0.419413, -0.148809, -0.099832>

  component 1.0, 0.180493, <0.388874, -0.288099, -0.096013>

  component 1.0, 0.180493, <0.385056, -0.462211, -0.092194>

  component 1.0, 0.180493, <0.407961, -0.618912, -0.10747>

  component 1.0, 0.180493, <0.388874, -0.793024, -0.122746>

  component 1.0, 0.180493, <0.396509, -0.967136, -0.122746>

  component 1.0, 0.180493, <0.388874, -1.141249, -0.092194>

  component 1.0, 0.180493, <0.404143, -1.315361, -0.080737>

  component 1.0, 0.180493, <0.404143, -1.489473, -0.084556>

  component 1.0, 0.180493, <0.396509, -1.680996, -0.099832>

  component 1.0, 0.180493, <0.396509, -1.802875, -0.076918>

  component 1.0, 0.180493, <0.568291, -1.680996, -0.160936>

  component 1.0, 0.180493, <0.595013, -1.73323, -0.214402>

  component 1.0, 0.180493, <0.629369, -1.820286, -0.241135>

  component 1.0, 0.180493, <0.518665, -1.59394, -0.134203>

  component 1.0, 0.353163, <-0.127724, 1.4182, -0.430451>

  component 1.0, 0.353163, <-0.080773, 1.487844, -0.656702>

  component 1.0, 0.353163, <0.041054, 1.574901, -0.900357>

  component 1.0, 0.353163, <0.175857, 1.627134, -1.092187>

  component 1.0, 0.180493, <0.140744, 0.0, -0.401532>

  component 1.0, 0.180493, <0.163648, 0.12977, -0.416808>

  component 1.0, 0.180493, <0.159831, 0.26906, -0.424446>

  component 1.0, 0.180493, <0.152196, 0.443172, -0.420627>

  component 1.0, 0.180493, <0.1751, 0.617284, -0.443541>

  component 1.0, 0.180493, <0.140744, 0.739162, -0.432084>

  component 1.0, 0.180493, <0.1751, 0.895863, -0.416808>

  component 1.0, 0.180493, <0.152196, 1.069975, -0.412989>

  component 1.0, 0.180493, <0.140744, 1.244087, -0.443541>

  component 1.0, 0.180493, <0.125474, 1.4182, -0.435903>

  component 1.0, 0.180493, <0.152196, 1.574901, -0.405351>

  component 1.0, 0.180493, <0.148379, 1.71419, -0.374799>

  component 1.0, 0.180493, <0.171283, -0.148809, -0.424446>

  component 1.0, 0.180493, <0.159831, -0.322922, -0.393894>

  component 1.0, 0.180493, <0.144561, -0.497034, -0.416808>

  component 1.0, 0.180493, <0.144561, -0.671146, -0.432084>

  component 1.0, 0.180493, <0.125474, -0.845258, -0.416808>

  component 1.0, 0.180493, <0.148379, -1.001959, -0.416808>

  component 1.0, 0.180493, <0.152196, -1.141249, -0.412989>

  component 1.0, 0.180493, <0.182735, -1.315361, -0.435903>

  component 1.0, 0.180493, <0.163648, -1.472062, -0.428265>

  component 1.0, 0.180493, <0.148379, -1.646174, -0.412989>

  component 1.0, 0.180493, <0.152196, -1.820286, -0.458817>

  component 1.0, 0.180493, <0.156013, -1.959576, -0.454998>

  component 1.0, 0.180493, <0.220909, -1.611351, -0.565748>

  component 1.0, 0.180493, <0.301074, -1.820286, -0.687956>

  component 1.0, 0.180493, <0.228544, -1.785463, -0.657404>

  component 1.0, 0.353163, <0.336921, 1.679368, -1.300647>

  component 1.0, 0.353163, <0.47409, 1.818658, -1.483782>

  component 1.0, 0.180493, <0.407961, 1.453022, 0.087298>

  component 1.0, 0.180493, <0.385056, 1.627134, 0.072022>

  component 1.0, 0.180493, <0.415596, 1.766424, 0.087298>

  component 1.0, 0.180493, <0.404143, 1.313732, 0.083479>

  component 1.0, 0.180493, <0.411778, 1.13962, 0.091117>

  component 1.0, 0.180493, <0.411778, 0.965508, 0.098755>

  component 1.0, 0.180493, <0.407961, 0.791396, 0.098755>

  component 1.0, 0.180493, <0.411778, 0.617284, 0.091117>

  component 1.0, 0.180493, <0.407961, 0.460583, 0.091117>

  component 1.0, 0.180493, <0.396509, 0.286471, 0.075841>

  component 1.0, 0.180493, <0.407961, 0.147181, 0.072022>

  component 1.0, 0.180493, <0.404143, -0.00952, 0.083479>

  component 1.0, 0.180493, <0.400326, -0.166221, 0.087298>

  component 1.0, 0.180493, <0.396509, -0.322922, 0.091117>

  component 1.0, 0.180493, <0.411778, -0.462211, 0.106393>

  component 1.0, 0.180493, <0.404143, -0.601501, 0.07966>

  component 1.0, 0.180493, <0.392691, -0.740791, 0.094936>

  component 1.0, 0.180493, <0.396509, -0.897492, 0.091117>

  component 1.0, 0.180493, <0.404143, -1.071604, 0.102574>

  component 1.0, 0.180493, <0.411778, -1.210893, 0.083479>

  component 1.0, 0.180493, <0.404143, -1.385006, 0.087298>

  component 1.0, 0.180493, <0.381239, -1.524295, 0.102574>

  component 1.0, 0.180493, <0.388874, -1.680996, 0.091117>

  component 1.0, 0.180493, <0.369787, -1.820286, 0.075841>

  component 1.0, 0.180493, <0.476152, -1.750641, 0.140764>

  component 1.0, 0.180493, <0.51103, -1.663585, 0.129307>

  component 1.0, 0.180493, <0.580576, -1.73323, 0.159859>

  component 1.0, 0.180493, <0.541569, -1.924753, 0.140764>

  component 1.0, 0.353163, <-0.132985, 1.296321, -0.395644>

  texture {
    BigTreeTex
    rotate <-90.350601, 55.916195, 0.600598>
    translate <0.050000, -0.020000, -0.020000>
  }
  scale <1.24, 1.1, 1.25>
  rotate <91.299988, 0.0, -54.400002>
  translate  <-3.94, -3.19, 2.1>
}

union { // Flora
  object { BigTree }
  object { LeavePlant }
  object { // LeavePlant2->LeavePlant
    LeavePlant
    scale 1.17
    rotate <-0.0, 0.0, 67.600014>
    translate  <-13.21, -0.17, 0.18>
  }
  object { // LeavePlant3->LeavePlant
    LeavePlant
    rotate 0.0*y
    translate  <-3.71, 12.5, 0.0>
  }
  object { // LeavePlant4->LeavePlant
    LeavePlant
    translate  <-2.51, 11.46, 0.0>
  }
  object { PalmPlant }
  object { // PalmPlant1->PalmPlant
    PalmPlant
    rotate -113.200005*z
    translate  <3.26, 1.59, 0.0>
  }
  object { // PalmPlant2->PalmPlant
    PalmPlant
    rotate 122.399956*z
    translate  <-4.16, -0.23, 0.0>
  }
  object { // PalmPlant3->PalmPlant
    PalmPlant
    scale 1.3
    rotate 168.399994*z
    translate  <-5.29, 7.44, 0.36>
  }
  object { // PalmPlant4->PalmPlant
    PalmPlant
    rotate -98.200012*z
    translate  <7.91, -10.41, 0.0>
  }
  object { // PalmPlant5->PalmPlant
    PalmPlant
    rotate 0.0*z
    translate  <0.5, 13.74, 0.0>
  }
  object { Fern }
  object { // Fern1->Fern
    Fern
    scale 1.3
    rotate <-3.93138, -2.931793, -118.271278>
    translate  <7.15, -3.3, -0.52>
  }
  object { // Fern2->Fern
    Fern
    scale 1.0816
    rotate <-7.873857, -5.860162, -160.82431>
    translate  <2.08, -10.31, -1.06>
  }
}


union { // NativeStuff
  object { Hut }
  object { // Hut1->Hut
    Hut
    scale 0.87
    rotate <0.0, -0.0, 155.799973>
    translate  <-2.02, -1.74, 0.11>
  }
  object { // Hut2->Hut
    Hut
    scale 0.81
    rotate <0.0, -0.0, 74.999985>
    translate  <-1.58, 1.24, 0.0>
  }
  object { Spear }
  object { // Spear1->Spear
    Spear
    rotate <-36.947765, -10.219602, 18.118835>
    translate  <-0.61, -2.06, -3.22>
  }
  object { // Spear2->Spear
    Spear
    scale 0.9
    rotate <0.0, -0.0, -0.0>
    translate  <-5.76, 4.6, 0.12>
  }
  object { // Spear3->Spear
    Spear
    scale 0.9
    rotate <0.0, -0.0, 33.0>
    translate  <-7.51, 2.67, 0.12>
  }
  object { // Spear4->Spear
    Spear
    scale 0.83
    rotate <0.0, -0.0, -32.699997>
    translate  <0.76, 6.8, -0.04>
  }
  object { Mask }
  object { // Mask1->Mask
    Mask
    scale <0.8, 0.8, 0.8>
    rotate <-81.643623, -25.145084, 103.797188>
    translate  <-3.73, 0.21, -3.56>
  }
}


//
// Include file contains 'Canvas'
//
#include "byop.in1"
#declare Canvas = object {
  Canvas_Raw
  texture {
    CanvasTex
  }
  scale 0.1
  rotate -3.200001*z
  translate  <1.13, -6.5, 0.03>
}
//
// Include file contains 'HatBand'
//
#include "byop.in2"
#declare HatBand = object {
  HatBand_Raw
  texture {
    HatBandTex
  }
  scale <0.1, 0.1, 0.08>
  translate  <1.13, -6.5, 0.03>
}
#declare Hat = union {
  object { Canvas }
  object { HatBand }
  scale <1.01, 1.0, 1.0>
}
#declare Map = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.094966, -3.000000, -0.152653>, <-1.986122, -3.000000, -0.152653>, <-0.931701, -3.000000, -0.152653>, <0.075238, -2.972789, -0.222041>,
      <-3.000000, -2.000000, -0.083265>, <-2.000000, -2.000000, -0.083265>, <-1.000000, -2.000000, -0.083265>, <0.006939, -2.000000, -0.131837>,
      <-3.013878, -1.000000, -0.013878>, <-2.068299, -0.891156, -0.069388>, <-1.013878, -1.000000, -0.069388>, <-0.006939, -1.000000, -0.090204>,
      <-3.088571, 0.000000, 0.013878>, <-2.034150, 0.054422, -0.013878>, <-1.006939, 0.000000, -0.034694>, <-0.003469, 0.000000, -0.058980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.088571, 0.000000, 0.013878>, <-2.034150, 0.054422, -0.013878>, <-1.006939, 0.000000, -0.034694>, <-0.003469, 0.000000, -0.058980>,
      <-3.163265, 1.000000, 0.041633>, <-2.000000, 1.000000, 0.041633>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, -0.027755>,
      <-3.068299, 1.945578, 0.222041>, <-2.068299, 1.945578, 0.152653>, <-1.000000, 2.000000, 0.041633>, <0.000000, 2.000000, 0.020816>,
      <-2.972245, 2.836735, 0.693878>, <-2.096054, 2.945578, 0.444082>, <-1.068299, 3.000000, 0.208163>, <-0.041088, 2.945578, 0.222041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.075238, -2.972789, -0.222041>, <1.082177, -2.945578, -0.291429>, <1.877279, -2.945578, -0.249796>, <2.849524, -2.945578, -0.097143>,
      <0.006939, -2.000000, -0.131837>, <1.013878, -2.000000, -0.180408>, <1.986122, -2.000000, -0.124898>, <2.795102, -1.836735, -0.111020>,
      <-0.006939, -1.000000, -0.090204>, <1.000000, -1.000000, -0.111020>, <2.000000, -1.000000, 0.000000>, <2.822857, -1.000000, 0.083265>,
      <-0.003469, 0.000000, -0.058980>, <1.000000, 0.000000, -0.083265>, <2.000000, 0.000000, -0.027755>, <2.918367, 0.000000, -0.013878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.003469, 0.000000, -0.058980>, <1.000000, 0.000000, -0.083265>, <2.000000, 0.000000, -0.027755>, <2.918367, 0.000000, -0.013878>,
      <0.000000, 1.000000, -0.027755>, <1.000000, 1.000000, -0.055510>, <2.000000, 1.000000, -0.055510>, <3.013878, 1.000000, -0.111020>,
      <0.000000, 2.000000, 0.020816>, <1.000000, 2.000000, 0.000000>, <2.000000, 1.782313, 0.083265>, <3.000000, 1.782313, 0.097143>,
      <-0.041088, 2.945578, 0.222041>, <0.986122, 2.891156, 0.235918>, <2.000000, 2.782313, 0.360816>, <3.026667, 2.782313, 0.582857>
    }
  }
  texture {
    MapTex
    scale <3.1, 2.99, 3.21>
    translate <-0.040000, -0.030000, 0.000000>
  }
  scale <0.15, 0.18, 0.14>
  rotate -27.499998*z
  translate  <1.38, -7.41, 0.03>
}
union { // ExplorersStuff
  object { Hat }
  object { Map }
  scale <1.0, 1.01, 1.0>
}


#declare FireLights = union {
  object { // FireLight1->FireLight
    FireLight
    rotate 0.0*x
    translate  <-0.78, 0.21, 0.0>
  }
  object { // FireLight2->FireLight
    FireLight
    rotate 0.0*x
    translate  <0.73, 0.21, 0.0>
  }
  object { // FireLight3->FireLight
    FireLight
    rotate 0.0*x
    translate  <1.01, 0.97, 0.0>
  }
  object { // FireLight4->FireLight
    FireLight
    rotate 0.0*x
    translate  <0.75, 1.69, 0.0>
  }
  object { // FireLight5->FireLight
    FireLight
    rotate 0.0*x
    translate  2.0*y
  }
  object { // FireLight6->FireLight
    FireLight
    rotate 0.0*x
    translate  <-0.73, 1.72, 0.0>
  }
  object { // FireLight7->FireLight
    FireLight
    rotate 0.0*x
    translate  <-1.04, 0.96, 0.0>
  }
}
#declare SunLights = union {
  box { // Light_Block
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackTex
    }
    hollow
    scale <3.94, 20.25, 15.15>
    translate  <-164.78, 33.59, 0.0>
  }
  box { // Light_Block1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackTex
    }
    hollow
    scale <19.23, 7.51, 15.15>
    rotate -9.3*z
    translate  <-205.36, 67.64, 0.0>
  }
  translate  <139.81, -29.17, 0.0>
}
union { // Lights
  object { FireLights }
  object { SunLights }
}


//
// Include file contains 'Pot'
//
#include "byop.in3"
#declare Pot = object {
  Pot_Raw
  texture {
    PotTex
  }
  scale 0.46
  translate  <-0.71, -6.54, 0.41>
}
#declare Cauldron = union {
  object { Pot }
  cylinder { // PotWater
    <0,0,1>, <0,0,0>, 1
    texture {
      PotWaterTex
    }
    scale <0.63, 0.63, 0.082623>
    translate  <-0.71, -6.54, 0.86>
  }
  sphere { // Steam
    <0,0,0>,1
    texture {
      SteamTex
      rotate -16.6*z
    }
    hollow
    scale <0.608837, 0.636512, 1.19>
    rotate -14.699999*z
    translate  <-0.72, -6.53, 1.39>
  }
  translate  <0.0, 0.01, 0.15>
}
#declare Coals = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.093333, -2.185850, 0.000000>, <-1.481905, -2.204354, 0.471837>, <-0.481905, -3.092517, 0.000000>, <0.018503, -3.092517, 0.000000>,
      <-2.481905, -1.426395, 0.000000>, <-1.241361, -1.218231, 0.902041>, <-0.500408, -1.680816, 0.902041>, <0.000000, -1.666939, 0.797959>,
      <-2.851973, -0.500408, 0.138776>, <-1.777959, -0.412517, 0.693878>, <-0.523537, -0.426395, -0.111020>, <-0.023129, -0.426395, -0.111020>,
      <-2.861224, -0.006939, 0.208163>, <-1.773333, 0.060136, 0.936735>, <-0.532789, 0.046259, -0.111020>, <-0.032381, 0.046259, -0.111020>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.861224, -0.006939, 0.208163>, <-1.773333, 0.060136, 0.936735>, <-0.532789, 0.046259, -0.111020>, <-0.032381, 0.046259, -0.111020>,
      <-2.870476, 0.486531, 0.277551>, <-1.768707, 0.532789, 1.179592>, <-0.542041, 0.518912, -0.111020>, <-0.041633, 0.518912, -0.111020>,
      <-2.500408, 1.518912, 0.000000>, <-1.204354, 1.273741, 0.693878>, <-0.481905, 1.810340, 0.693878>, <0.018503, 1.810340, 0.693878>,
      <-2.000816, 2.093333, 0.000000>, <-1.472653, 2.505034, 0.416327>, <-0.458776, 2.824218, -0.013878>, <0.020816, 2.949116, -0.006939>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.018503, -3.092517, 0.000000>, <0.518912, -3.092517, 0.000000>, <1.518912, -2.440272, 0.180408>, <2.144218, -1.686259, 0.124898>,
      <0.000000, -1.666939, 0.797959>, <0.500408, -1.653061, 0.693878>, <1.259864, -1.111837, 0.943673>, <2.421769, -1.241361, 0.124898>,
      <-0.023129, -0.426395, -0.111020>, <0.477279, -0.426395, -0.111020>, <1.833469, -0.431020, 0.693878>, <2.870476, -0.426395, 0.000000>,
      <-0.032381, 0.046259, -0.111020>, <0.468027, 0.046259, -0.111020>, <1.824218, 0.041633, 0.693878>, <2.861224, 0.046259, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.032381, 0.046259, -0.111020>, <0.468027, 0.046259, -0.111020>, <1.824218, 0.041633, 0.693878>, <2.861224, 0.046259, 0.000000>,
      <-0.041633, 0.518912, -0.111020>, <0.458776, 0.518912, -0.111020>, <1.814966, 0.514286, 0.693878>, <2.851973, 0.518912, 0.000000>,
      <0.018503, 1.810340, 0.693878>, <0.518912, 1.810340, 0.693878>, <1.315374, 1.315374, 0.846531>, <2.888980, 1.653061, 0.124898>,
      <0.020816, 2.949116, -0.006939>, <0.500408, 3.074014, 0.000000>, <1.500408, 2.518912, 0.000000>, <2.500408, 2.208980, 0.124898>
    }
  }
  scale <0.334565, 0.297391, 0.57>
  rotate <12.466251, -12.386567, -45.43578>
  translate  <-0.7, -6.53, -0.27>
}
#declare CharcoalPile = union {
  object { Charcoal }
  object { // Charcoal1->Charcoal
    Charcoal
    scale 0.99
    rotate <-0.934404, -1.202749, -38.227154>
  }
  object { // Charcoal2->Charcoal
    Charcoal
    scale 0.9801
    rotate <-1.854646, -2.41091, -76.454666>
  }
  object { // Charcoal3->Charcoal
    Charcoal
    scale 0.970299
    rotate <-2.760668, -3.624359, -114.682899>
  }
  object { // Charcoal4->Charcoal
    Charcoal
    scale 0.960596
    rotate <-3.652393, -4.842963, -152.912231>
  }
  object { // Charcoal5->Charcoal
    Charcoal
    scale 0.95099
    rotate <-4.529727, -6.066595, 168.856934>
  }
  object { // Charcoal6->Charcoal
    Charcoal
    scale 0.94148
    rotate <-5.392556, -7.295117, 130.624222>
  }
  object { // Charcoal7->Charcoal
    Charcoal
    scale 0.932065
    rotate <-6.240741, -8.528393, 92.389183>
  }
  object { // Charcoal8->Charcoal
    Charcoal
    scale 0.922745
    rotate <-7.074126, -9.766287, 54.151436>
  }
  object { // Charcoal9->Charcoal
    Charcoal
    scale 0.913517
    rotate <-7.892525, -11.008653, 15.91047>
  }
  object { // Charcoal10->Charcoal
    Charcoal
    scale 0.904382
    rotate <-8.69573, -12.255348, -22.334127>
  }
  object { // Charcoal11->Charcoal
    Charcoal
    scale 0.895338
    rotate <-9.483503, -13.506223, -60.582909>
  }
  object { // Charcoal12->Charcoal
    Charcoal
    scale 0.886385
    rotate <-10.255578, -14.761124, -98.836327>
  }
  object { // Charcoal13->Charcoal
    Charcoal
    scale 0.877521
    rotate <-11.011654, -16.019888, -137.094986>
  }
  object { // Charcoal14->Charcoal
    Charcoal
    scale 0.868746
    rotate <-11.751396, -17.282362, -175.359436>
  }
  object { // Charcoal15->Charcoal
    Charcoal
    scale 0.860058
    rotate <-12.474434, -18.548372, 146.369797>
  }
  object { // Charcoal16->Charcoal
    Charcoal
    scale 0.851458
    rotate <-13.180352, -19.817747, 108.091934>
  }
  object { // Charcoal17->Charcoal
    Charcoal
    scale 0.842943
    rotate <-13.868696, -21.090305, 69.806358>
  }
  object { // Charcoal18->Charcoal
    Charcoal
    scale 0.834514
    rotate <-14.53896, -22.365856, 31.51235>
  }
  object { // Charcoal19->Charcoal
    Charcoal
    scale 0.826169
    rotate <-15.190582, -23.644211, -6.790802>
  }
  object { // Charcoal20->Charcoal
    Charcoal
    scale 0.817907
    rotate <-15.822951, -24.925159, -45.104046>
  }
  object { // Charcoal21->Charcoal
    Charcoal
    scale 0.809728
    rotate <-16.435387, -26.208492, -83.4282>
  }
  object { // Charcoal22->Charcoal
    Charcoal
    scale 0.801631
    rotate <-17.027143, -27.49398, -121.764214>
  }
  object { // Charcoal23->Charcoal
    Charcoal
    scale 0.793614
    rotate <-17.597397, -28.781385, -160.113037>
  }
  object { // Charcoal24->Charcoal
    Charcoal
    scale 0.785678
    rotate <-18.145239, -30.070463, 161.524094>
  }
  object { // Charcoal25->Charcoal
    Charcoal
    scale 0.777821
    rotate <-18.669676, -31.360945, 123.146065>
  }
  object { // Charcoal26->Charcoal
    Charcoal
    scale 0.770043
    rotate <-19.169607, -32.652546, 84.751595>
  }
  object { // Charcoal27->Charcoal
    Charcoal
    scale 0.762343
    rotate <-19.643822, -33.944969, 46.339283>
  }
  object { // Charcoal28->Charcoal
    Charcoal
    scale 0.754719
    rotate <-20.090984, -35.237885, 7.907622>
  }
  object { // Charcoal29->Charcoal
    Charcoal
    scale 0.747172
    rotate <-20.509621, -36.530956, -30.545033>
  }
  object { // Charcoal30->Charcoal
    Charcoal
    scale 0.7397
    rotate <-20.898104, -37.823807, -69.020355>
  }
  object { // Charcoal31->Charcoal
    Charcoal
    scale 0.732303
    rotate <-21.254639, -39.116035, -107.520561>
  }
  object { // Charcoal32->Charcoal
    Charcoal
    scale 0.72498
    rotate <-21.577234, -40.4072, -146.047684>
  }
  object { // Charcoal33->Charcoal
    Charcoal
    scale 0.717731
    rotate <-21.863695, -41.696827, 175.395935>
  }
  object { // Charcoal34->Charcoal
    Charcoal
    scale 0.710553
    rotate <-22.111576, -42.984406, 136.807693>
  }
  object { // Charcoal35->Charcoal
    Charcoal
    scale 0.703448
    rotate <-22.318172, -44.26936, 98.184708>
  }
  object { // Charcoal36->Charcoal
    Charcoal
    scale 0.696413
    rotate <-22.48048, -45.551064, 59.523842>
  }
  object { // Charcoal37->Charcoal
    Charcoal
    scale 0.689449
    rotate <-22.59516, -46.828831, 20.821602>
  }
  object { // Charcoal38->Charcoal
    Charcoal
    scale 0.682555
    rotate <-22.658485, -48.101902, -17.92576>
  }
  object { // Charcoal39->Charcoal
    Charcoal
    scale 0.675729
    rotate <-22.666325, -49.369419, -56.722771>
  }
  object { // Charcoal40->Charcoal
    Charcoal
    scale 0.668972
    rotate <-22.614046, -50.630451, -95.574074>
  }
  object { // Charcoal41->Charcoal
    Charcoal
    scale 0.662282
    rotate <-22.496508, -51.883923, -134.484955>
  }
  object { // Charcoal42->Charcoal
    Charcoal
    scale 0.655659
    rotate <-22.307951, -53.128658, -173.461319>
  }
  object { // Charcoal43->Charcoal
    Charcoal
    scale 0.649103
    rotate <-22.04195, -54.363327, 147.490295>
  }
  object { // Charcoal44->Charcoal
    Charcoal
    scale 0.642612
    rotate <-21.691349, -55.586407, 108.362595>
  }
  object { // Charcoal45->Charcoal
    Charcoal
    scale 0.636185
    rotate <-21.248144, -56.796207, 69.14743>
  }
  object { // Charcoal46->Charcoal
    Charcoal
    scale 0.629824
    rotate <-20.703447, -57.990772, 29.835917>
  }
  object { // Charcoal47->Charcoal
    Charcoal
    scale 0.623525
    rotate <-20.047375, -59.167904, -9.5822>
  }
  object { // Charcoal48->Charcoal
    Charcoal
    scale 0.61729
    rotate <-19.268984, -60.325089, -49.117863>
  }
  object { // Charcoal49->Charcoal
    Charcoal
    scale 0.611117
    rotate <-18.356262, -61.459446, -88.783211>
  }
  scale <0.66, 0.78, 0.74>
  rotate <-0.0, -19.1, -0.0>
  translate  <-0.54, -6.54, -0.64>
}
#declare CoalsASticks = union {
  object { Coals }
  object { FireStick }
  object { // FireStick1->FireStick
    FireStick
    rotate <12.323429, -15.490406, -39.282467>
    translate  <3.74, -2.84, 1.87>
  }
  object { // FireStick2->FireStick
    FireStick
    rotate <120.622787, 67.413452, 130.487259>
    translate  <-0.68, -0.15, 0.88>
  }
  object { // FireStick3->FireStick
    FireStick
    rotate <-10.239875, -16.920624, 31.827097>
    translate  <-2.71, -0.84, -0.43>
  }
  object { // FireStick4->FireStick
    FireStick
    rotate <0.0, -19.700001, -0.0>
    translate  <1.31, 0.56, 1.07>
  }
  object { CharcoalPile }
  texture {
    CoalsTex
    scale 1.42
    translate <-0.690000, -6.570000, -0.110000>
  }
  rotate 19.700001*y
}
union { // FireAPot
  object { Cauldron }
  object { CoalsASticks }
  hollow
}


#declare Dirt = object {
  height_field {
    tga "C:\Program Files\Graphics\POVMisc\Welcome\ground.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    DirtTex
    scale 0.2
  }
  scale <20.0, 20.0, 0.5>
  rotate -0.4*x
  translate  <3.22, 6.46, 0.0>
}
#declare Mountains = object {
  height_field {
    tga "C:\Program Files\Graphics\POVMisc\Welcome\mount.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    MountainTex
    translate <0.000000, 0.000000, -0.170000>
  }
  hollow
  scale <150.0, 150.0, 18.0>
  rotate 64.263908*z
  translate  <-28.22, 3.06, 5.4>
}
#declare Mounts = difference {
  object { Mountains }
  box { // MountainsSub
    <-1, -1, -1>, <1, 1, 1>
    scale <-20.4, -20.1, -3.32>
    rotate <-180.0, 0.0, -180.0>
    translate  <2.87, 6.7, 0.0>
  }
  texture {
    MountainTex
  }
}
union { // Ground
  object { Dirt }
  object { Mounts }
  hollow
}


union { // Sky
  sphere { // Moon
    <0,0,0>,1
    texture {
      MoonTex
      scale <1.16, 0.97, 1.98>
      rotate <-89.907089, -0.086861, -57.711796>
      translate <-0.810000, -0.390000, 0.000000>
    }
    hollow
    scale 3.0
    translate  <1.74, 233.78, 34.92>
  }
  sphere { // SkyBackdrop
    <0,0,0>,1
    texture {
      SkyBackdropTex
    }
    hollow
    scale <400.0, 400.0, 199.961945>
    translate  <53.81685, -52.890489, -20.083781>
  }
  sphere { // HaloClouds
    <0,0,0>,1
    texture {
      CloudHalo
    }
    hollow
    scale <186.0, 186.0, 30.0>
    translate  7.7*x
  }
  hollow
}


