#declare Is_Inc_File = true

#if ( Is_Inc_File = false )

// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date:
// Auth: Chris Hernandez


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
//#include "CHARS.INC"   // FIXME-add comments describing each of these
//#include "CONSTS.INC"
//#include "METALS.INC"
//#include "SHAPES.INC"
//#include "SHAPES2.INC"
//#include "SHAPESQ.INC"
//#include "SKIES.INC"
//#include "STONES.INC"
//#include "STONES2.INC"
//#include "WOODMAPS.INC"
//#include "WOODS.INC"

// -------------------------------- light sources ---------------
light_source { <0, 0.1, 0> color rgb <0.6, 0.6, 0.6> }
light_source { <0, 50, 0> color rgb <0.6, 0.6, 0.6> }
light_source { <0, -50, -50> color rgb <0.6, 0.6, 0.6> }
light_source { <-50, 0, -50> color rgb <0.6, 0.6, 0.6> }


background { color rgb <0.6, 0.6, 0.6> }


// ------------------------------------ Camera -------------------
camera {
  location  <0.0 , -0.1 ,-5.0>
  look_at   <0.0 , 0.180 , 0.0>
  //blur_samples 150  aperture 0.050  focal_point <0, 0, -2.75>  confidence 0.95
  angle 32.5
}

#declare TempTexture = texture {
	pigment { color rgb < 0.7, 0.7, 0.8 > }
	finish {
	   ambient 0.3
	   diffuse 0.25
	   specular 0.35
	   roughness 0.05
	   //reflection 0.05
	}
}

#declare RedT = texture { pigment { color rgb <1,0,0> } }

//#default { texture { TempTexture } }


#end


#declare HC_Chrome = texture{
   pigment { color rgb 0.55 }
   finish  {
      ambient 0.35
      diffuse 0.75
      //phong 0.5 phong_size 225
      specular 0.65 roughness 0.05
      brilliance 6
      metallic
      //reflection 0.10
      crand 0.05
   }
}

#declare HC_Chrome2 = texture{
   pigment { color rgb <0.27, 0.27, 0.30> }
   finish  {
      ambient 0.35
      diffuse 0.75
      //phong 0.5 phong_size 225
      specular 0.85 roughness 0.05
      brilliance 6
      metallic
      //reflection 0.10
      crand 0.15
   }
}

#declare HC_Rubber = texture {
   pigment { color rgb 0.15 }
      finish  {
      ambient 0.35
      diffuse 0.5
      //phong 0.5 phong_size 225
      specular 0.25 roughness 0.1
      crand 0.05
   }
   normal { gradient x 1.0 scale <0.05, 1, 1>}
}

#declare HC_Glass = texture {
    pigment { color rgbft /*<0.8, 0.775, 0.75, 0.5, 0.65>*/ <0.95, 0.95, 0.95, 1.0, 0> }
    finish {
        ambient 0.01
        diffuse 0.15
        reflection 0.10
        //refraction on //0.85 ior 1.5
        phong 0.10 phong_size 180 //60
        specular 0.70 roughness 0.025
        crand 0.05
    }
}

//#default { texture { HC_Chrome } }

#declare HC_Base = object {
   union {
      difference {
         box { <-1, 0, 0> < 1, 0.25, 0.95> }
         box { <-10, -100, -100> < -0.95, 100, 0.05> }
         box { < 10, -100, -100> <  0.95, 100, 0.05> }
      }
      cylinder { 0*y, 0.25*y, 0.05 translate <-0.95, 0, 0.05> }
      cylinder { 0*y, 0.25*y, 0.05 translate < 0.95, 0, 0.05> }
   }
}

#declare HC_Knob = object {
   union {
      sphere { 0*y, 0.075 scale <1, 1, 0.5> texture { HC_Chrome } }
      union {
         box { < -0.015, -0.06, -0.065> <0.015, 0.06, 0> }
         cylinder { -0.06*y, 0.06*y, 0.015 translate -z*0.065 }
         texture { HC_Rubber }
      }
   }
}

#declare HC_Switch = object {
   union {
      box { <-0.045, -0.07, 0> <0.045, 0.07, -0.015> texture { HC_Rubber } }
      union {
         box { <-0.035, -0.06, 0> <0.035, 0.05,  0.05> translate -z*0.03 }
         box { <-0.035, -0.06, 0> <0.035, 0.04,  0.05> rotate -x*35 translate -z*0.03 }
         texture {
            pigment { rgb <1, 0.2, 0.2> }
            finish  { ambient 0.5 diffuse 0.2 }
         }
      }
      texture { HC_Chrome }
   }
}

#declare HC_Leg = object {
   union {
      cylinder { -1.0*y, 0.75*y, 0.025 }
      difference {
         torus { 0.1, 0.025 rotate -z*90 }
         plane {  y, 0 }
         plane { -z, 0 }
         translate <0, 0.75, 0.10>
      }
   }
   texture { HC_Chrome }
}

#declare HC_Stand = object {
   union {
      object { HC_Leg }
      object { HC_Leg rotate y*180 translate z*0.85 }
      cylinder { 0.10*z, 0.75*z, 0.025 translate  y*0.85 }
      cylinder { 0.00*z, 0.85*z, 0.010 translate  y*0.50 }
      cylinder { 0.00*z, 0.85*z, 0.010 translate -y*0.50 }
   }
   texture { HC_Chrome }
}

#declare HC_MainShape = object {
   union {
      difference {
         object { HC_Base scale 0.9 scale <1, 3.5, 1> texture { HC_Chrome } }
         plane { z, 0 rotate x*60 translate y*0.40 }
         difference {
            cylinder { 100*y, -100*y, 0.25 inverse }
            plane {  x, 0 }
            plane { -z, 0 }
            translate z*0.25
            rotate x*60 translate <0.65, 0.40, 0>
         }
         difference {
            cylinder { 100*y, -100*y, 0.25 inverse }
            plane { -x, 0 }
            plane { -z, 0 }
            translate z*0.25
            rotate x*60 translate <-0.65, 0.40, 0>
         }
      }
   }
}

#declare HC_Main = object {
   union {
      difference {
         object { HC_MainShape }
         object { HC_MainShape scale <0.975, 1.01, 0.975> translate <0, -0.015, 0.01> }
         cylinder { 0.5*z, -100*z, 0.125 translate <  0.32, 0.185, 0> }
         cylinder { 0.5*z, -100*z, 0.125 translate < -0.32, 0.185, 0> }
      }
      torus { 0.125, 0.03 rotate -x*90 translate < 0.32, 0.185, 0> texture { HC_Rubber } }
      torus { 0.125, 0.03 rotate -x*90 translate <-0.32, 0.185, 0> texture { HC_Rubber } }
   }
   texture { HC_Glass }
}

#declare HumidiCrib = object {
   union {
      object { HC_Base texture { HC_Chrome2 } }
      object { HC_Knob rotate -z*20 translate < 0, 0.115, 0> }
      object { HC_Knob rotate  z*35 translate <-0.5, 0.115, 0> }
      object { HC_Knob rotate -z*75 translate < 0.5, 0.115, 0> }
      object { HC_Switch translate <-0.8, 0.115, 0> }
      object { HC_Stand translate <-0.95, 0, 0.05> }
      object { HC_Stand translate < 0.95, 0, 0.05> }
      object { HC_Main translate <0, 0.25, 0.05> }
   }
}

#if ( Is_Inc_File = false )
   object {
      HumidiCrib
      //HC_Main
      rotate  -y*10
      rotate  -x*30
   }
#end
