
/*\
***  BowTiles.inc
***
***  By Joel NewKirk
***
***  November 1997
***
***  For use with Persitence of Vision V3.1+
***
***  SingleTile() generates a single bow-tie shaped tile.
***  BowTiles() calls SingleTile() repeatedly to create
***  a specified x*y pattern of interlocking tiles,
***  applying the specified textures.
***  The field of tiles is generated with the 'zero' tile,
***  at the origin, always oriented longwise along the x-axis,
***  and spreads outward in the positive x and z directions.
***
\*/

#macro SingleTile(xpos,zpos,tex,orient)
     prism {
          conic_sweep
          linear_spline
          0.9, 1,
          9, <0,-2>,<4,-4>,<6,0>,<4,4>,
          <0,2>,<-4,4>,<-6,0>,<-4,-4>,<0,-2>
          rotate <180,0,0>
          translate <0,1,0>
//          texture { tex }
          scale 1/8
          #if (orient=1)
               rotate <0,90,0>
          #end
          translate <xpos,0,zpos>     
          texture { tex }
     }
#end          

#macro BowTiles(w,h,tex1,tex2)     
     union {
     #declare w1=w;
     #declare flipit = 1;
     #declare fliprow=1;
     #while (w1>0)
          #declare h1=h;
          #declare fliprow=abs(fliprow-1);
          #declare flipit=fliprow;
          #while (h1>0)
               #if(flipit=1)
                    SingleTile(w1,h1,tex1,flipit)
               #else
                    SingleTile(w1,h1,tex2,flipit)
               #end
               #declare h1=h1-1;
               #declare flipit=abs(flipit-1);
          #end
          #declare w1=w1-1;
     #end   
     }
#end
