// Persistence of Vision Ray Tracer Scene Description File
// File: voy-enc.pov
// Vers: POV-Ray 3.1
// Desc: This is written for the Nov-Dec 1998 IRTC whose theme is "First Encounters". 
//       The probe Voyager has passed beyond Pluto and entered deep space.  After who 
//       knows how long it meets up with an alien exploration vessel.  This is mankinds
//       first encounter with aliens.
// Date: Started Nov 8, 1998 
// Auth: David Ray
// 
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

light_source { <10, 5.5, -6> color White }

//#declare Draw_Axis_Lines = true;
#declare Draw_Axis_Lines = false;
   
// set viewer's position in the scene

#declare Use_Camera = 1; // Showoff camera
//#declare Use_Camera = 2; // Closeup of the mounting of the Low-Field Magnetometer
//#declare Use_Camera = 3; // Overview of electronics bus - directly underneath
//#declare Use_Camera = 4; // Closeup of side of electronics bus
//#declare Use_Camera = 5; // Closeup of legs and feet
//#declare Use_Camera = 6; // Good overview of Communication antenna
//#declare Use_Camera = 7; // Closeup on the Low Gain Antenna (LGA)
//#declare Use_Camera = 8; // Side view of the Voyager
//#declare Use_Camera = 9; // Closeup view of the RTG and mount
//#declare Use_Camera = 10; // Closeup view of the science boom's components
//#declare Use_Camera = 11; // Closeup view of the bus face with Gold Record on it
//#declare Use_Camera = 12; // Closeup view of the end of the magnetometer boom

#switch ( Use_Camera )

#case (1)
    // Showoff camera
    camera
    {
        location  <10.0, 2, -6.0> // position of camera <X Y Z>
        direction 2.0*z            // which way are we looking <X Y Z> & zoom
        up        y                // which way is +up <X Y Z>
        right     4/3*x            // which way is +right <X Y Z> and aspect ratio
        look_at   <0.0, 0.0,  0.0> // point center of view at this point <X Y Z>
    } 
    #break

#case (2)
    // Closeup of the mounting of the Low-Field Magnetometer
    camera { location  <-3.0, -1.7, 2.50>  direction 2.0*z   up y  right 4/3*x look_at <-2, -1.0, 1> } 
    light_source { <-5.0, 0, 3> color White }
    #break

#case (3)
    // Overview of electronics bus - directly underneath
    camera { location  <-1.0, -5.0, -0.0>  direction 2.0*z   up y  right 4/3*x look_at <-1.0, 0.0, 0.0> } 
    light_source { <0, -5.5, -6> color White }
    #break
    
#case (4)
    // Closeup of side of electronics bus
    camera { location  <3, -0.3, -1.0>  direction 2.0*z   up y  right 4/3*x look_at <1.0, -0.3, 0.0> } 
    light_source { <3, 0, -2> color White }
    #break

#case (5)    
    // Closeup of legs and feet
    camera { location  <3, -1.3, -1.0>  direction 2.0*z   up y  right 4/3*x look_at <1.0, -1.3, 0.0> } 
    light_source { <0, -5.5, -6> color White }
    #break
#case (6)
    // Good overview of Communication antenna
    camera { location  <0.0, 3.0, -6.0> direction 2.0*z up y right 4/3*x look_at <0.0, 1.0, 0.0> }
    light_source { <0, 3.5, -6> color White }
    #break
#case (7)
    // Closeup on the Low Gain Antenna (LGA)
    camera { location  <0.0, 1.65, -1.0> direction 2.0*z up y right 4/3*x look_at <0.0, 1.65, 0.0> }
    #break
#case (8)
    // Side view of the Voyager
    camera { location  <0.0, 0, -12.0> direction 2.0*z up y right 4/3*x look_at <0.0, 0,  0.0> } 
    #break
#case (9)
    // Closeup of the RTG and mounts
    camera { location  <-0.5, 0, -7.0> direction 2.0*z up y right 4/3*x look_at <-2.2, -0.5, 0> } 
    #break
#case (10)
    // Closeup view of the science boom's components
//    camera { location  <2.8, 3.6, 0> direction 2.0*z up y right 4/3*x look_at <2.8, -0.5, 0> } 
    camera { location  <3.5, 0, -5.0> direction 2.0*z up y right 4/3*x look_at <3.5, -0.5, 0> } 
//    camera { location  <4, -0.7, 3> direction 2.0*z up y right 4/3*x look_at <4, -0.7, 0> } 
//    light_source { <3, -3, -4> color White }
//    light_source { <4, 0, -4> color White }
    #break
#case (11)
    // Closeup of Gold Record
    camera { location  <0.0, 0, -3.0> direction 2.0*z up y right 4/3*x look_at <0.0, -1,  0.0> } 
    light_source { <0, -3, -4> color White }    
    #break
#case (12)
// Closeup view of the end of the magnetometer boom    
    camera { location  <-7.0, 5, -6.0> direction 2.0*z up y right 4/3*x look_at <-5.0, 5,  0.0> } 
    #break
#else
    // Error here - no camera defined
    #error "Variable Use_Camera not defined correctly - value does not exist"
#end

// Temporary background statement - to be replaced with stars later
background { color red 0.1 green 0.3 blue 0.8 }

// Display the voyager spacecraft
#include "voyager.inc"
object {
    NASA_Voyager 
}

// Display the x-y-z axes to help with positioning
#declare Show_Arrows=true;
#declare Axis_Length=3;
#declare Axis_Width=0.1;
#declare X_Axis_Colour = Green;
#declare Y_Axis_Colour = Yellow;
#declare Z_Axis_Colour = Red;
#include "axis.inc"
