// Persistence of Vision Ray Tracer Scene Description File
// File: axis.inc
// Vers: 3.1
// Desc: This include file is used to display a set of x-y-z axis in the middle of
//       the scene.  This is useful to get a feel for the position and orientation 
//       of the scene and/or objects within that scene.
//       
//       Variables : Axis_Length : Number of units an axis is long.  Default is 10 units.
//                   Show_Arrows : Determines whether to show a cone at the end of the axis.
//                                 Default is true. 
//                   Axis_Width  : Width of the axis cylinder. Default is 1% of length
// Date: November 17, 1998 
// Auth: David Ray

#ifndef (Draw_Axis_Lines) #declare Draw_Axis_Lines=true;            #end
#ifndef (Show_Arrows)     #declare Show_Arrows=true;                #end
#ifndef (Axis_Length)     #declare Axis_Length = 1.0;               #end
#ifndef (Axis_Width)      #declare Axis_Width = Axis_Length / 10;   #end
#ifndef (X_Axis_Colour)   #declare X_Axis_Colour = Green;           #end
#ifndef (Y_Axis_Colour)   #declare Y_Axis_Colour = Yellow;          #end
#ifndef (Z_Axis_Colour)   #declare Z_Axis_Colour = Red;             #end


#declare Axis_Length=Axis_Length*0.9;
                        
#if (Draw_Axis_Lines=true)                        
    // Draw the x-y-z axis        
    object {    
        union {        
            // X Axis
            cylinder { 
                <0, 0, 0>, <Axis_Length, 0, 0>, Axis_Width/2
                pigment { color X_Axis_Colour }
            }
            // Y Axis
            cylinder { 
                <0, 0, 0>, <0, Axis_Length, 0>, Axis_Width/2
                pigment { color Y_Axis_Colour }
            }
            // Z Axis
            cylinder { 
                <0, 0, 0>, <0, 0, Axis_Length>, Axis_Width/2
                pigment { color Z_Axis_Colour }
            }
        }
    }
     
    #if (Show_Arrows = true)
    object { 
        union {
            // X Axis arrow
            cone{ 
                <Axis_Length, 0, 0>, 1.3*Axis_Width, 
                <Axis_Length/9*10, 0, 0>, 0 
                pigment { color X_Axis_Colour }
            }
            // Y Axis arrow
            cone{ 
                <0, Axis_Length, 0>, 1.3*Axis_Width, 
                <0, Axis_Length/9*10, 0>, 0 
                pigment { color Y_Axis_Colour }
            }
            // Z Axis arrow
            cone{ 
                <0, 0, Axis_Length>, 1.3*Axis_Width, 
                <0, 0, Axis_Length/9*10>, 0 
                pigment { color Z_Axis_Colour }
            }
        }
    }
    #else
    object {    
        union {        
            // X Axis
            cylinder { 
                <Axis_Length, 0, 0>, <Axis_Length/9*10, 0, 0>, Axis_Width/2
                pigment { color X_Axis_Colour }
            }
            // Y Axis
            cylinder { 
                <0, Axis_Length, 0>, <0, Axis_Length/9*10, 0>, Axis_Width/2
                pigment { color Y_Axis_Colour }
            }
            // Z Axis
            cylinder { 
                <0, 0, Axis_Length>, <0, 0, Axis_Length/9*10>, Axis_Width/2
                pigment { color Z_Axis_Colour }
            }
        }
    }
    #end
#end
