// Persistence of Vision Ray Tracer Scene Description File
// File: voy-enc.pov
// Vers: POV-Ray 3.1
// Desc: This is written for the Nov-Dec 1998 IRTC whose theme is "First Encounters". 
//       The probe Voyager has passed beyond Pluto and entered deep space.  After who 
//       knows how long it meets up with an alien exploration vessel.  This is mankinds
//       first encounter with aliens.
// Date: Started Nov 8, 1998 
// Auth: David Ray
// 
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// set viewer's position in the scene

camera
{
  location  <0, 0, -1.0>     // position of camera <X Y Z>
  direction 2.0*z            // which way are we looking <X Y Z> & zoom
  up        y                // which way is +up <X Y Z>
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <0.0, 0.0,  0.0> // point center of view at this point <X Y Z>
} 
  
light_source { <30, 5.5, -6> color Gray75 }


// Starfield

// Anti-aliasing the sky-sphere starfield originally used caused the stars to disappear.
// So the stars are being represented by spheres randomly placed in the view of the camera.

// Set a color of the background (black)
background { color Black }


#declare Number_of_stars=3000;
#declare Min_Distance=500;
#declare Max_Distance=1000;
#declare Min_Rotation=-45;
#declare Max_Rotation=45;
#declare Star_Size=0.5;
#declare Star_Rand = seed(0);

#declare Count=1;
#while (Count <= Number_of_stars)
    sphere {
        // Describe the star
        <0, 0, 0>, Star_Size
        
        // Position the star
        #declare Star_Distance=rand(Star_Rand) * (Max_Distance - Min_Distance) + Min_Distance;
        translate <0, 0, Star_Distance> 
        #declare Rand_Rotate=rand(Star_Rand) * (Max_Rotation-Min_Rotation) + Min_Rotation;
        rotate <0, Rand_Rotate, 0>
        #declare Rand_Rotate=rand(Star_Rand) * (Max_Rotation-Min_Rotation) + Min_Rotation;
        rotate <Rand_Rotate, 0, 0>
        
        // Star's texture - ambient to ensure it glows without needing lights
        pigment { color White }
        finish  { ambient 1 }        
    }
    #declare Count=Count+1;
#end

// Display the voyager spacecraft
#include "voyager.inc"
object {
    NASA_Voyager 
    rotate < 0, -35, 0>
    rotate < -90, 60, 0>
    translate <4, -1, 30>
}

// Display the Alien Explorer craft
#include "Explorer.inc"
object { 
    Alien_Explorer 
    rotate <0, -55, 0>
    translate <-10, 10, 70>
}

