// Persistence of Vision Ray Tracer Scene Description File
// File: exp-test.pov
// Vers: POV-Ray 3.1
// Desc: This is a test file used to design the alien ship the Explorer. 
// Date: November 26, 1998 
// Auth: David Ray

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#declare Draw_Axis_Lines = true;
//#declare Draw_Axis_Lines = false;

// set viewer's position in the scene
camera
{
  location  <15.0, 5.0, -36.0> // position of camera <X Y Z>
  direction 2.0*z            // which way are we looking <X Y Z> & zoom
  up        y                // which way is +up <X Y Z>
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <0.0, 0.0,  0.0> // point center of view at this point <X Y Z>
}                 
                   
// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <20, 30, -20>
}

// Background - Should be starfield
background { color Black }

// Display the x-y-z axes to help with positioning
#declare Show_Arrows=true;
#declare Axis_Length=45;
#declare Axis_Width=0.1;
#declare X_Axis_Colour = Green;
#declare Y_Axis_Colour = Yellow;
#declare Z_Axis_Colour = Red;
#include "axis.inc"
                   
#include "Explorer.inc"

object { 
    Explorer 
//    rotate <75, 0, 0>
    rotate <0, 20, 0>
}
