// Persistence of Vision Ray Tracer Scene Description File
// File: Explorer.pov
// Vers: POV-Ray 3.1
// Desc: This descibes the Explorer - an alien spacecraft designed to explore the galaxy.
//       This is the ship that discovers the Voyager probe in deep space and hence begins
//       to learn about the existence of the planet Earth, it's location and it's
//       inhabitants.
// Date: November 26, 1998 
// Auth: David Ray

#declare Explorer_Texture = texture
{
  pigment
  {
    marble
    turbulence 1.0
    color_map
    {
      [0.00 color rgb<0.302, 0.294, 0.282>]
      [0.80 color rgb<0.804, 0.369, 0.369>]
      [0.80 color rgb<0.800, 0.400, 0.400>]
      [1.00 color rgb<0.741, 0.231, 0.031>]
    }
  }
  normal
  {
    wrinkles 0.0
  }
  finish {
    ambient 1.0
    brilliance 7.1
  }
}

#declare Laser_Road_Texture = texture {
    pigment { 
        agate
        turbulence 1.0
        color_map
        {
          [0.00 color rgbf<0.602, 0.7, 0.9, 0.1>]
          [0.90 color rgbf<0.302, 0.8, 1.0, 0.2>]
          [0.90 color rgbf<0.400, 0.750, 0.800, 0.1>]
          [1.00 color rgbf<1.0, 1.0, 1.0, 0.3>]
        }
    }
    finish {
        ambient 1.0
        brilliance 10.5
    }
    scale <1, 1, 100>
}

#declare Explorer_Ship = object {
    union {
        union {
            difference {
                lathe {
                    quadratic_spline
                    13, // number of points
                    <0, 3.6>,       // 1
                    <0.2, 8.0>,     // 2 
                    <1.4, 11.0>,    // 3
                    <3.0, 11.5>,    // 4
                    <5.0, 11.0>,    // 5
                    <7.0, 7.0>,     // 6
                    <5.5, 4.0>,     // 6.5  - Creates the kink back in to create the engine section  
                    <7.6, 1.0>,     // 7
                    <6.4, -5.0>,    // 8
                    <5.2, -7.4>,    // 9
                    <4.0, -7.4>,   // 10
                    <2, -5>,        // 11
                    <0, 0>          // 12
                }
                // The cutouts in the nose of the ship
                union {
                    #declare Count=1;
                    #while (Count <= 12) 
                        sphere { 
                            <0, 8, -6.5>, 1.0 
                            rotate <0, 30*Count, 0>
                        }
                    #declare Count=Count+1;
                    #end
                }
            }
            // Now the four large bulges in the aft section
            #declare Count=1;
            #while (Count <= 4)
                sphere { 
                    <0, -2.5, -6>, 3 
                    rotate <0, 45+90*Count, 0>
                }
                #declare Count=Count+1;
            #end
            // The top wing at rear of ship
            union {
                intersection {
                    torus {
                        10, 1.0
                        rotate <0, 0, -30>
                    }
                    box { <0, -30, -30>, <30, 30, 30> }
                }
                intersection {
                    torus {
                        10, 1.0
                        rotate <0, 0, 30>
                    }
                    box { <0, 30, 30>, <-30, -30, -30> }
                }
                translate <0, 0, -7>
            }           
            scale <0.5, 1.5, 0.2>
        }
        // The laser engine on top of "wings"
        union {
            cylinder {
                <0,  1.5, -4.5>,
                <0, -3.5, -4.5>, 1.0
            }
            torus {
                0.9 ,0.15
                translate <0, 1.5, -4.5>
            }
            torus {
                0.9 ,0.15
                translate <0, -3.5, -4.5>
            }
        }
        // The bulge where the laser road for the probe emits from the laser road engine
        // NOTE : This is oriented initially like the explorer road and then converted
        //        into orientation used by the explorer so the rotation of whole explorer
        //        will put the bulge in the right spot.
        sphere {
            <0.9, 0, 0>, 1
            rotate <0, 0, -15>
            rotate <0, 139, 0>
            translate <0, 4.5, 0>
            rotate <-90, 0, 0>  // Put it back into the orientation used by rest of explorer
        }
    }
    texture { Explorer_Texture }
    rotate <90, 0, 0>
}

#declare Explorer_Laser_Road = object {
    cylinder {
        <0, 4.5, -1000>, 
        <0, 4.5,  1000>, 0.8        
    }
    texture { Laser_Road_Texture }
}

#declare R1 = seed(0);

#declare Explorer_Probe = object {
    union {
        union {
            // Laser road engine
            cylinder {
                <-1.5, 0, 0>,
                <1.5, 0, 0>, 0.2
            }
            torus {
                0.15 ,0.05
                rotate <0, 0, 90>
                translate <-1.5, 0, 0>
            }
            torus {
                0.15 ,0.05
                rotate <0, 0, 90>
                translate <1.5, 0, 0>
            }
            // Laser road engine mounts
            difference {
                union {
                    torus {
                        1.5, 0.15
                        rotate <0, 0, 30>
                        rotate <-90, 0, 0>
                        scale <1, 0.25, 1>
                        translate <0, 0, 0.75>
                    }        
                    torus {
                        1.5, 0.15
                        rotate <0, 0, -30>
                        rotate <-90, 0, 0>
                        scale <1, 0.25, 1>
                        translate <0, 0, 0.75>
                    }        
                }
                box { <-2, -2, 0.75>, <2, 2, 3> }
            }
            // Main body of the probe
            union {
                // Sphere at rear where the engine mounts join
                sphere { <0, -0.7, 0>, 0.4 }
                // Main body shape
                difference {
                    union {
                        lathe {
                            quadratic_spline
                            9, // number of points
                            <0, -1.0>,       // 1
                            <0.4, -0.7>,     // 2 
                            <0.4, -0.4>,     // 3
                            <0.2, 0.2>,      // 4
                            <0.17, 0.35>,    // 5
                            <0.2, 0.5>,      // 6
                            <0.3, 0.6>,      // 7
                            <0.36, 0.68>,    // 8
                            <0, 0.86>        // 9
                        }
                        #declare Count=1;
                        #while (Count <= 10)
                            torus {
                                0.25, 0.05
                                rotate <0, 0, 90>
                                translate <0, 0.2, 0>
                                rotate <0, Count * 18, 0>
                            }
                            #declare Count=Count+1;
                        #end
                    }
                    // The cutout for the "mouth" of the probe
                    sphere { <0, 1.4, 0>, 1.0 }
                }
                // The four bumps on the sides of the probe
                #declare Count=1;
                #while (Count <=4)
                    sphere { 
                        <0, 0, 0>, 0.24
                        scale <0.4, 1, 0.4>
                        translate <0.36, -0.4, 0>
                        rotate <0, 45+(Count*90), 0>
                    }
                    #declare Count=Count+1;
                #end
                scale <2, 1, 1>
                rotate <90, 0, 0>
                translate <0, 0, 1.5>
            }
            texture { Explorer_Texture }
        }
        // Scanner beam
        intersection {
            cone { 
                <0, 0, 1.5>, 0,
                <0, 0, 7.0>, 2.0
//                <0, 0, 6.0>, 2.0
                scale <1, 0.1, 1>
            }
            sphere {
                <0, 0, -4>, 10.1
            }
            pigment { color rgbf<0.5, 0.8, 0.95, 0.7> }
            finish {
                ambient 1.0
                brilliance 7.1
            }
        }
    }
    translate <57, 0, 0>  // Move it along the road x amount
    //rotate <15, 0, 0>
    rotate <0, 0, -15>     // Swing it round into position
    rotate <0, 139, 0>
    translate <0, 4.5, 0>  // Lift it up a fraction
}

// The light for the scanner beam
// create a point "spotlight" (conical directed) light source
light_source
{
    0*x                     // light's position (translated below)
    color rgb <0.5, 0.8, 0.95>       // light's color
    //spotlight               // this kind of light source
    translate <57, 0, 2.5> // <x y z> position of light
/*    point_at <57, 0, 6>      // direction of spotlight
    radius 2                // hotspot (inner, in degrees)
    tightness 100            // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 1               // intensity falloff radius (outer, in degrees)
*/    rotate <0, 0, -15>     // Swing it round into position
    rotate <0, 139, 0>
    translate <0, 4.5, 0>  // Lift it up a fraction
    rotate <0, -55, 0>
    translate <-10, 10, 70>
}


#declare Probe_Laser_Road = object {
    cylinder { 
        <0, 0, 0>,
        <158, 0, 0>, 0.1
    }
    texture { 
        Laser_Road_Texture 
        scale <1, 0.1, 0.1>
        rotate <0, 90, 0>
    }
    rotate <0, 0, -15>
    rotate <0, 139, 0>
    translate <0, 4.5, 0>
}

#declare Alien_Explorer = object {
    union {
        object { Explorer_Ship }
        object { Explorer_Laser_Road }
        object { Explorer_Probe }
        object { Probe_Laser_Road }
    }
} 

