//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 21 textures and 233 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 12/24/1998    (24.12.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

Electric Love - (C) 1998 Alberto Campione

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.800,0.800,0.800> }

camera {  //  Camera StdCam
  location  <80.000, -60.000, 20.000>
  direction <0.0,     0.0,  3.7809>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.400, 1.000, 8.000>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <0.000, -0.100, 0.000>
  direction <0.0,     0.0,  1.8660>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

*/

//
// *******  L I G H T S *******
//

light_source { // AreaLite001
  <30.000, -50.000, 60.000>
  color  rgb<1.000, 1.000, 1.000>
  area_light <1.732, 1.000, 0.000>, <-0.866, 1.500, 1.000>, 5, 5
  adaptive 1
  jitter
}



//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//
// ********  TEXTURES  *******
//

#include "el_love.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare CSG001 = union {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 1.0, 5.0>
    translate  <-27.3, -2.0, 5.7>
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 1.0, 60.0>
    rotate -90.0*y
    translate  <2.7, -2.0, 10.7>
  }
}
#declare Zoccoletto1 = difference {
  object { CSG001 }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 61.0>
    rotate -90.0*y
    translate  <3.25, -3.0, 9.0>
  }
  plane { // Plane001
    z,0
    rotate <0.0, -90.0, -315.0>
    translate  <2.0, -2.3, 0.0>
  }
  plane { // Plane45
    z,0
    rotate <0.0, -90.0, -225.0>
    translate  <-56.6, -2.3, 0.0>
  }
  translate  0.15*x
}


#declare Mattonella1 = object {
  superellipsoid { // Mattonella1
    <0.1, 0.1>
    scale <20.0, 20.0, 3.0>
    translate  <20.0, -20.0, -2.4>
  }
}


#declare SopraccigilioDX = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.597053, 0.000000, 0.459250>, <1.597053, 0.000000, 0.459250>, <1.597053, 0.000000, 0.459250>, <1.597053, 0.000000, 0.459250>, 
      <-0.453127, -0.000001, 1.560306>, <-0.453127, -0.632813, 1.560306>, <0.037437, -0.632813, 2.000000>, <0.037437, -0.000001, 2.000000>, 
      <-0.453127, -0.000001, 5.468105>, <-0.453127, -0.632813, 5.468105>, <0.037437, -0.632813, 5.028411>, <0.037437, -0.000001, 5.028411>, 
      <1.597053, 0.000000, 5.540750>, <1.597053, 0.000000, 5.540750>, <1.597053, 0.000000, 5.540750>, <1.597053, 0.000000, 5.540750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.597053, 0.000000, 0.459250>, <1.597053, 0.000000, 0.459250>, <1.597053, 0.000000, 0.459250>, <1.597053, 0.000000, 0.459250>, 
      <0.037437, -0.000001, 2.000000>, <0.037437, 0.632811, 2.000000>, <-0.453127, 0.632810, 1.560306>, <-0.453127, -0.000001, 1.560306>, 
      <0.037437, -0.000001, 5.028411>, <0.037437, 0.632811, 5.028411>, <-0.453127, 0.632810, 5.468105>, <-0.453127, -0.000001, 5.468105>, 
      <1.597053, 0.000000, 5.540750>, <1.597053, 0.000000, 5.540750>, <1.597053, 0.000000, 5.540750>, <1.597053, 0.000000, 5.540750>
    }
  }
  texture {
    Roscio
  }
  scale 0.4
  rotate -270.0*y
  translate  <-2.5, -1.2, 1.7>
}
#declare Cylndr2 = object {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Nero
    }
    scale <0.25, 0.25, 2.0>
    translate  <-1.3, 0.0, -0.8>
  }
}
#declare Cube003 = object {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 0.06>
    rotate -45.0*z
    translate  <0.0, -1.15, -1.3>
  }
}
#declare BezPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.319610, -2.329374>, <0.000000, -1.319610, -2.329374>, <0.000000, -1.319610, -2.329374>, <0.000000, -1.319610, -2.329374>, 
      <-0.128443, 0.000000, -0.805863>, <-0.128443, -0.175576, -0.805863>, <0.128443, -0.175576, -0.805863>, <0.128443, 0.000000, -0.805863>, 
      <-0.128443, 0.000000, 0.805863>, <-0.128443, -0.175576, 0.805863>, <0.128443, -0.175576, 0.805863>, <0.128443, 0.000000, 0.805863>, 
      <0.000000, -1.319610, 2.470626>, <0.000000, -1.319610, 2.470626>, <0.000000, -1.319610, 2.470626>, <0.000000, -1.319610, 2.470626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.319610, -2.329374>, <0.000000, -1.319610, -2.329374>, <0.000000, -1.319610, -2.329374>, <0.000000, -1.319610, -2.329374>, 
      <0.128443, 0.000000, -0.805863>, <0.128443, 0.175576, -0.805863>, <-0.128443, 0.175576, -0.805863>, <-0.128443, 0.000000, -0.805863>, 
      <0.128443, 0.000000, 0.805863>, <0.128443, 0.175576, 0.805863>, <-0.128443, 0.175576, 0.805863>, <-0.128443, 0.000000, 0.805863>, 
      <0.000000, -1.319610, 2.470626>, <0.000000, -1.319610, 2.470626>, <0.000000, -1.319610, 2.470626>, <0.000000, -1.319610, 2.470626>
    }
  }
  texture {
    Roscio
  }
  scale 0.2
  rotate <-130.0, 40.0, 0.0>
  translate  <0.6, -0.55, 0.6>
}
#declare CigliaDX = union {
  object { BezPtch001 }
  object { // BezPtch2->BezPtch001
    BezPtch001
    rotate <-0.0, -6.299999, -0.0>
    translate  <-0.005799, 0.0, 0.004605>
  }
  object { // BezPtch3->BezPtch001
    BezPtch001
    rotate <0.0, -12.6, -0.0>
    translate  <-0.012573, 0.0, 0.007826>
  }
  object { // BezPtch4->BezPtch001
    BezPtch001
    rotate <-0.0, -18.9, -0.0>
    translate  <-0.020075, 0.0, 0.009511>
  }
  object { // BezPtch5->BezPtch001
    BezPtch001
    rotate <0.0, -25.200001, -0.0>
    translate  <-0.028038, 0.0, 0.009545>
  }
  object { // BezPtch6->BezPtch001
    BezPtch001
    rotate <0.0, -31.5, -0.0>
    translate  <-0.036178, 0.0, 0.007855>
  }
  object { // BezPtch7->BezPtch001
    BezPtch001
    rotate <0.0, -37.799999, -0.0>
    translate  <-0.044204, 0.0, 0.004412>
  }
  object { // BezPtch8->BezPtch001
    BezPtch001
    rotate <0.0, -44.099998, -0.0>
    translate  <-0.05182, 0.0, -0.000769>
  }
  object { // BezPtch9->BezPtch001
    BezPtch001
    rotate <0.0, -50.400002, -0.0>
    translate  <-0.058733, 0.0, -0.007628>
  }
  object { // BezPtch10->BezPtch001
    BezPtch001
    rotate <0.0, -56.700001, -0.0>
    translate  <-0.064661, 0.0, -0.016062>
  }
  object { // BezPtch11->BezPtch001
    BezPtch001
    rotate <0.0, -63.0, -0.0>
    translate  <-0.069337, 0.0, -0.025924>
  }
  object { // BezPtch12->BezPtch001
    BezPtch001
    rotate <0.0, -69.300003, -0.0>
    translate  <-0.072515, 0.0, -0.037028>
  }
  object { // BezPtch13->BezPtch001
    BezPtch001
    rotate <0.0, -75.599998, -0.0>
    translate  <-0.073978, 0.0, -0.049151>
  }
  object { // BezPtch14->BezPtch001
    BezPtch001
    rotate <0.0, -81.900002, -0.0>
    translate  <-0.07354, 0.0, -0.062036>
  }
  rotate 5.0*y
  translate  <-1.136, -1.196, 0.45>
}
#declare OrecchinoDX = union {
  sphere { // Sphere003
    <0,0,0>,1
    scale <0.1, 0.2, 0.2>
  }
  sphere { // Sphere4
    <0,0,0>,1
    scale <0.1, 0.2, 0.4>
    translate  -0.6*z
  }
  texture {
    Rosso
  }
  rotate -135.0*z
  translate  <-2.042753, -0.76, 0.5>
}
#declare BezPtch27 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -1.679104>, <0.000000, 0.000000, -1.679104>, <0.000000, 0.000000, -1.679104>, <0.000000, 0.000000, -1.679104>, 
      <-1.767915, 0.000000, -1.605915>, <-1.767915, -1.142001, -1.605915>, <1.767915, -1.142001, -1.605915>, <1.767915, 0.000000, -1.605915>, 
      <-1.767915, -0.406881, 1.000000>, <-1.767915, -1.419871, 1.000000>, <1.767915, -1.419871, 1.000000>, <1.767915, -0.406881, 1.000000>, 
      <0.000000, 0.416805, 2.023657>, <0.000000, 0.416805, 2.023657>, <0.000000, 0.416805, 2.023657>, <0.000000, 0.416805, 2.023657>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -1.679104>, <0.000000, 0.000000, -1.679104>, <0.000000, 0.000000, -1.679104>, <0.000000, 0.000000, -1.679104>, 
      <1.767915, 0.000000, -1.605915>, <1.767915, 1.142001, -1.605915>, <-1.767915, 1.142001, -1.605915>, <-1.767915, 0.000000, -1.605915>, 
      <1.767915, -0.406881, 1.000000>, <1.767915, 0.606109, 1.000000>, <-1.767915, 0.606109, 1.000000>, <-1.767915, -0.406881, 1.000000>, 
      <0.000000, 0.416805, 2.023657>, <0.000000, 0.416805, 2.023657>, <0.000000, 0.416805, 2.023657>, <0.000000, 0.416805, 2.023657>
    }
  }
  rotate -240.0*x
  translate  <0.0, -0.1, -0.1>
}
#declare Scarpa_pr_DX = union {
  object { BezPtch27 }
  cone { // Cone2
    <0,0,0>, 0.2, <0,0,1>, 0.4
    scale <1.5, 1.0, 1.4>
    translate  <0.0, 0.9, -1.0>
  }
  texture {
    Bianco
  }
  scale <0.4, 0.5, 0.5>
  rotate -10.0*x
  translate  <0.0, -0.2, -7.9>
}
#declare Indice1 = union {
  sphere { // Sphere13
    <0,0,0>,1
    scale <0.15, 0.4, 0.15>
    translate  -1.3*y
  }
  sphere { // Sphere14
    <0,0,0>,1
    scale <0.13, 0.3, 0.13>
    rotate 90.0*z
    translate  <-0.25, -1.65, 0.0>
  }
  rotate -90.0*z
  translate  <0.98, -0.7, -0.48>
}
#declare Cylndr5 = object {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.5, 0.1>
    translate  -0.1*z
  }
}
#declare Indice = union {
  sphere { // Sphere3
    <0,0,0>,1
    scale <0.15, 0.4, 0.15>
    translate  -1.3*y
  }
  sphere { // Sphere10
    <0,0,0>,1
    scale <0.13, 0.3, 0.13>
    rotate 10.0*z
    translate  <0.05, -1.8, 0.0>
  }
  rotate 5.0*z
  translate  <-0.1, 0.3, -0.48>
}


#declare Lente = difference {
  sphere { // Sphere004
    <0,0,0>,1
    scale 1.5
    translate  2.4*y
  }
  sphere { // Sphere6
    <0,0,0>,1
    scale <3.0, 2.0, 3.0>
    translate  3.2*y
  }
  texture {
    Vetro
  }
  translate  <-1.1, -2.8, 0.8>
}
#declare OcchialeDX = union {
  object { Lente }
  torus { // Torus4
    1.05, 0.05  rotate -x*90
    rotate -90.0*x
    translate  <-1.1, -1.5, 0.8>
  }
  translate  <-0.1, -0.2, 0.0>
}
#declare SopraccigilioDX1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.597053, 0.000000, 0.459250>, <1.597053, 0.000000, 0.459250>, <1.597053, 0.000000, 0.459250>, <1.597053, 0.000000, 0.459250>, 
      <-0.453127, -0.000001, 1.560306>, <-0.453127, -0.632813, 1.560306>, <0.037437, -0.632813, 2.000000>, <0.037437, -0.000001, 2.000000>, 
      <-0.453127, -0.000001, 5.468105>, <-0.453127, -0.632813, 5.468105>, <0.037437, -0.632813, 5.028411>, <0.037437, -0.000001, 5.028411>, 
      <1.597053, 0.000000, 5.540750>, <1.597053, 0.000000, 5.540750>, <1.597053, 0.000000, 5.540750>, <1.597053, 0.000000, 5.540750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.597053, 0.000000, 0.459250>, <1.597053, 0.000000, 0.459250>, <1.597053, 0.000000, 0.459250>, <1.597053, 0.000000, 0.459250>, 
      <0.037437, -0.000001, 2.000000>, <0.037437, 0.632811, 2.000000>, <-0.453127, 0.632810, 1.560306>, <-0.453127, -0.000001, 1.560306>, 
      <0.037437, -0.000001, 5.028411>, <0.037437, 0.632811, 5.028411>, <-0.453127, 0.632810, 5.468105>, <-0.453127, -0.000001, 5.468105>, 
      <1.597053, 0.000000, 5.540750>, <1.597053, 0.000000, 5.540750>, <1.597053, 0.000000, 5.540750>, <1.597053, 0.000000, 5.540750>
    }
  }
  texture {
    Nero
  }
  scale 0.4
  rotate -270.0*y
  translate  <-2.5, -1.2, 1.7>
}
#declare Spinotto1 = union {
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Nero
    }
    scale <0.25, 0.25, 1.1>
    translate  <-1.3, 0.0, 1.0>
  }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cromo_Lucidato
    }
    scale <0.26, 0.26, 0.64>
    translate  <-1.3, 0.0, 2.1>
  }
  sphere { // Sphere2
    <0,0,0>,1
    texture {
      Cromo_Lucidato
    }
    scale 0.26
    translate  <-1.3, 0.0, 2.74>
  }
}
#declare Cube11 = object {
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 0.06>
    rotate -45.0*z
    translate  <0.0, -1.15, -1.3>
  }
}
#declare BezPtch15 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.636176, -1.292338, -0.438185>, <-2.106066, -1.685169, -0.438185>, <0.477627, -1.685169, -0.438185>, <0.990727, -1.513253, -0.438185>, 
      <-3.197650, -1.013035, -0.933132>, <-2.123759, -1.000000, 0.000000>, <0.495320, -1.000000, 0.000000>, <3.234525, -0.986965, -0.933132>, 
      <-3.197650, -0.013035, -0.933132>, <-2.123759, -0.000000, 0.000000>, <0.495320, 0.000000, 0.000000>, <3.234525, 0.013035, -0.933132>, 
      <-2.636176, 0.292338, -0.438185>, <-2.106066, 0.685169, -0.438185>, <0.477627, 0.685169, -0.438185>, <0.934680, 0.475888, -0.438185>
    }
  }
  texture {
    Petali
  }
  rotate 10.0*y
  translate  <-3.2, 0.4, 1.0>
}
#declare Fiore = union {
  object { BezPtch15 }
  object { // BezPtch16->BezPtch15
    BezPtch15
    rotate -45.0*z
    translate  0.1*z
  }
  object { // BezPtch17->BezPtch15
    BezPtch15
    rotate -90.0*z
    translate  <0.0, 0.0, -0.1>
  }
  object { // BezPtch18->BezPtch15
    BezPtch15
    rotate -135.0*z
    translate  <0.0, 0.0, 0.1>
  }
  object { // BezPtch19->BezPtch15
    BezPtch15
    rotate 180.0*z
    translate  -0.1*z
  }
  object { // BezPtch20->BezPtch15
    BezPtch15
    rotate 135.0*z
    translate  0.1*z
  }
  object { // BezPtch21->BezPtch15
    BezPtch15
    rotate 90.0*z
    translate  <0.0, 0.0, -0.1>
  }
  object { // BezPtch22->BezPtch15
    BezPtch15
    rotate 45.0*z
    translate  <0.0, 0.0, 0.1>
  }
  sphere { // Sphere15
    <0,0,0>,1
    texture {
      Bottone
    }
    scale <1.5, 1.5, 0.2>
    translate  0.2*z
  }
  scale 1.5
  rotate 40.0*y
  translate  <29.4, 0.0, 3.8>
}
#declare BezPtch002 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -1.300000, 0.000000>, <1.000000, -1.300000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-7.974897, 0.000000, 56.953060>, <-7.974897, -1.300000, 56.953060>, <-5.989698, -1.300000, 57.195922>, <-5.989698, 0.000000, 57.195922>, 
      <2.941108, 0.000000, 114.966734>, <2.941108, -1.300000, 114.966734>, <4.939934, -1.300000, 114.898203>, <4.939934, 0.000000, 114.898203>, 
      <61.904706, 0.000000, 160.905461>, <61.904706, -1.300000, 160.905461>, <63.767130, -1.300000, 160.176506>, <63.767130, 0.000000, 160.176506>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 1.300000, 0.000000>, <-1.000000, 1.300000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
      <-5.989698, 0.000000, 57.195922>, <-5.989698, 1.300000, 57.195922>, <-7.974897, 1.300000, 56.953060>, <-7.974897, 0.000000, 56.953060>, 
      <4.939934, 0.000000, 114.898203>, <4.939934, 1.300000, 114.898203>, <2.941108, 1.300000, 114.966734>, <2.941108, 0.000000, 114.966734>, 
      <63.767130, 0.000000, 160.176506>, <63.767130, 1.300000, 160.176506>, <61.904706, 1.300000, 160.905461>, <61.904706, 0.000000, 160.905461>
    }
  }
  texture {
    Stelo
  }
  scale <0.3, 0.3, 0.5>
  translate  <10.5, -0.1, -76.4>
}
#declare Margherita1 = union {
  object { Fiore }
  object { BezPtch002 }
  translate  <-10.7, 0.0, -0.4>
}
#declare BezPtch24 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -3.304653>, <0.000000, 0.000000, -3.304653>, <0.000000, 0.000000, -3.304653>, <0.000000, 0.000000, -3.304653>, 
      <-1.000000, 0.000000, -3.339623>, <-1.000000, -1.300000, -3.339623>, <1.000000, -1.300000, -3.339623>, <1.000000, 0.000000, -3.339623>, 
      <-1.000000, 0.000000, 3.339623>, <-1.000000, -1.300000, 3.339623>, <1.000000, -1.300000, 3.339623>, <1.000000, 0.000000, 3.339623>, 
      <0.000000, 0.000000, 3.304653>, <0.000000, 0.000000, 3.304653>, <0.000000, 0.000000, 3.304653>, <0.000000, 0.000000, 3.304653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -3.304653>, <0.000000, 0.000000, -3.304653>, <0.000000, 0.000000, -3.304653>, <0.000000, 0.000000, -3.304653>, 
      <1.000000, 0.000000, -3.339623>, <1.000000, 1.300000, -3.339623>, <-1.000000, 1.300000, -3.339623>, <-1.000000, 0.000000, -3.339623>, 
      <1.000000, 0.000000, 3.339623>, <1.000000, 1.300000, 3.339623>, <-1.000000, 1.300000, 3.339623>, <-1.000000, 0.000000, 3.339623>, 
      <0.000000, 0.000000, 3.304653>, <0.000000, 0.000000, 3.304653>, <0.000000, 0.000000, 3.304653>, <0.000000, 0.000000, 3.304653>
    }
  }
  scale 0.5
  rotate -50.0*x
  translate  -9.5*z
}
#declare Indice2 = union {
  sphere { // Sphere16
    <0,0,0>,1
    scale <0.15, 0.4, 0.15>
    translate  -1.3*y
  }
  sphere { // Sphere17
    <0,0,0>,1
    scale <0.13, 0.3, 0.13>
    rotate 90.0*z
    translate  <-0.25, -1.65, 0.0>
  }
  rotate -90.0*z
  translate  <0.98, -0.7, -0.48>
}
#declare Indice3 = union {
  sphere { // Sphere8
    <0,0,0>,1
    scale <0.15, 0.4, 0.15>
    translate  -1.3*y
  }
  sphere { // Sphere11
    <0,0,0>,1
    scale <0.13, 0.3, 0.13>
    rotate 10.0*z
    translate  <0.05, -1.8, 0.0>
  }
  rotate 5.0*z
  translate  <-0.1, 0.3, -0.48>
}




//
// ********  OBJECTS  *******
//



union { // Zoccoletti
  object { Zoccoletto1 }
  object { // Zoccoletto2->Zoccoletto1
    Zoccoletto1
    rotate -270.0*z
    translate  54.3*y
  }
  texture {
    Mattonelle
  }
}


union { // Pavimento
  object { Mattonella1 }
  object { // Mattonella2->Mattonella1
    Mattonella1
    translate  40.5*y
  }
  object { // Mattonella3->Mattonella1
    Mattonella1
    translate  -40.5*x
  }
  texture {
    Mattonelle
  }
}


union { // Pareti
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 50.0, 100.0>
    translate  <0.0, 49.5, 100.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 1.0, 100.0>
    translate  <-49.5, 0.0, 100.0>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 200.0>
    translate  <0.5, -0.5, 0.0>
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.1>
    translate  <2.6, -2.6, 0.6>
  }
  texture {
    Intonaco
  }
}


box { // Cemento
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Intonaco
  }
  scale <100.0, 100.0, 1.0>
  translate  -1.0*z
}


#declare Piani_Sez1 = union {
  plane { // Plane1
    z,0
    rotate <-45.0, -90.0, 0.0>
    translate  <2.0, -0.7, 0.0>
  }
  plane { // Plane2
    z,0
    rotate <-135.0, -90.0, 0.0>
    translate  <-2.0, -0.7, 0.0>
  }
  plane { // Plane3
    z,0
    rotate <-225.0, -90.0, 0.0>
    translate  <-2.0, 0.7, 0.0>
  }
  plane { // Plane4
    z,0
    rotate <-315.0, -90.0, 0.0>
    translate  <2.0, 0.7, 0.0>
  }
  plane { // Plane9
    z,0
    rotate -66.0*y
    translate  <1.4, 0.0, -2.8>
  }
  plane { // Plane10
    z,0
    rotate -294.0*y
    translate  <-1.4, 0.0, -2.8>
  }
  plane { // Plane11
    z,0
    rotate <0.0, -76.699997, -45.0>
    translate  <1.3, -0.8, -2.8>
  }
  plane { // Plane12
    z,0
    rotate <0.0, -76.699997, -135.0>
    translate  <-1.3, -0.8, -2.8>
  }
  plane { // Plane13
    z,0
    rotate <0.0, -76.699997, -225.0>
    translate  <-1.3, 0.8, -1.8>
  }
  plane { // Plane14
    z,0
    rotate <0.0, -76.699997, -315.0>
    translate  <1.3, 0.8, -2.8>
  }
}
#declare Superiore = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 0.9, 1.9>
    translate  -0.9*z
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.2, 1.0>
    rotate 7.0*x
    translate  <0.0, -1.0, -1.8>
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.2, 1.0>
    rotate -7.0*x
    translate  <0.0, 1.0, -1.8>
  }
  object { Piani_Sez1 }
  object { Cylndr2 }
  object { // Cylndr3->Cylndr2
    Cylndr2
    translate  <1.3, 0.0, 0.0>
  }
  object { // Cylndr4->Cylndr2
    Cylndr2
    translate  <2.6, 0.0, 0.0>
  }
}
#declare Piani_Sez2 = union {
  plane { // Plane5
    z,0
    rotate <-315.0, -90.0, 0.0>
    translate  <1.3, 0.8, -3.55>
  }
  plane { // Plane6
    z,0
    rotate <-45.0, -90.0, 0.0>
    translate  <1.3, -0.8, -3.55>
  }
  plane { // Plane7
    z,0
    rotate <-135.0, -90.0, 0.0>
    translate  <-1.3, -0.8, -3.55>
  }
  plane { // Plane8
    z,0
    rotate <-225.0, -90.0, 0.0>
    translate  <-1.3, 0.8, -3.55>
  }
  plane { // Plane15
    z,0
    rotate -45.0*x
    translate  <0.0, -0.8, -4.2>
  }
  plane { // Plane16
    z,0
    rotate -315.0*x
    translate  <0.0, 0.8, -4.2>
  }
  plane { // Plane17
    z,0
    rotate <-45.0, 0.0, -90.0>
    translate  <-1.3, 0.0, -4.2>
  }
  plane { // Plane18
    z,0
    rotate <-45.0, 0.0, -270.0>
    translate  <1.3, 0.0, -4.2>
  }
  plane { // Plane19
    z,0
    rotate <-45.0, 0.0, -315.0>
    translate  <1.3, -0.8, -4.1>
  }
  plane { // Plane20
    z,0
    rotate <-45.0, 0.0, -225.0>
    translate  <1.3, 0.8, -4.1>
  }
  plane { // Plane21
    z,0
    rotate <-45.0, 0.0, -135.0>
    translate  <-1.3, 0.8, -4.1>
  }
  plane { // Plane22
    z,0
    rotate <-45.0, 0.0, -45.0>
    translate  <-1.3, -0.8, -4.1>
  }
}
#declare Inferiore = difference {
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.4, 0.9, 0.75>
    translate  -3.55*z
  }
  object { Piani_Sez2 }
}
#declare Vite = difference {
  sphere { // Sphere002
    <0,0,0>,1
    scale <0.3, 0.2, 0.3>
    translate  <0.0, -1.0, -1.3>
  }
  object { Cube003 }
  object { // Cube6->Cube003
    Cube003
    rotate -90.0*y
    translate  <-1.3, 0.0, -1.3>
  }
  texture {
    Cromo_Lucidato
  }
}
#declare Presa_reale = union {
  object { Superiore }
  object { Inferiore }
  superellipsoid { // Passacavo
    <1.0, 0.2>
    texture {
      Giallino
    }
    scale 0.6
    translate  -4.8*z
  }
  torus { // SedeVite
    0.35, 0.05  rotate -x*90
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.9, -1.3>
  }
  object { Vite }
  texture {
    Corpo_pr
    scale <3.5, 2.0, 1.0>
    rotate <-90.0, -180.0, -180.0>
    translate <-1.800000, 0.000000, -1.000000>
  }
  translate  1.0*z
}
#declare Labbro_Sup = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.211384, 0.000000, -4.792587>, <-0.211384, 0.000000, -4.792587>, <-0.211384, 0.000000, -4.792587>, <-0.211384, 0.000000, -4.792587>, 
      <-3.194417, 0.000000, -1.995319>, <-3.194417, -1.300000, -1.995319>, <-0.354097, -1.300000, -1.969855>, <-0.354097, 0.000000, -1.969855>, 
      <-1.519612, 0.000000, 0.010146>, <-1.519612, -1.300000, 0.010146>, <0.015688, -1.300000, 0.010146>, <0.015688, 0.000000, 0.010146>, 
      <-1.519612, 0.000000, 0.011805>, <-1.519612, -1.300000, 0.011805>, <0.015688, -1.300000, 0.011805>, <0.023824, 0.000000, 0.011805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.211384, 0.000000, -4.792587>, <-0.211384, 0.000000, -4.792587>, <-0.211384, 0.000000, -4.792587>, <-0.211384, 0.000000, -4.792587>, 
      <-0.354097, 0.000000, -1.969855>, <-0.354097, 1.300000, -1.969855>, <-3.194417, 1.300000, -1.995319>, <-3.194417, 0.000000, -1.995319>, 
      <0.015688, 0.000000, 0.010146>, <0.015688, 1.300000, 0.010146>, <-1.519612, 1.300000, 0.010146>, <-1.519612, 0.000000, 0.010146>, 
      <0.023824, 0.000000, 0.011805>, <0.015688, 1.300000, 0.011805>, <-1.519612, 1.300000, 0.011805>, <-1.519612, 0.000000, 0.011805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.519612, 0.000000, 0.011805>, <-1.519612, -1.300000, 0.011805>, <0.015688, -1.300000, 0.011805>, <0.023824, 0.000000, 0.011805>, 
      <-1.519612, 0.000000, 0.013465>, <-1.519612, -1.300000, 0.013465>, <0.015688, -1.300000, 0.013465>, <0.015688, 0.000000, 0.013465>, 
      <-3.194417, 0.000000, 1.995319>, <-3.194417, -1.300000, 1.995319>, <-0.354097, -1.300000, 2.020783>, <-0.354097, 0.000000, 2.020783>, 
      <-0.211384, 0.000000, 4.792587>, <-0.211384, 0.000000, 4.792587>, <-0.211384, 0.000000, 4.792587>, <-0.211384, 0.000000, 4.792587>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.023824, 0.000000, 0.011805>, <0.015688, 1.300000, 0.011805>, <-1.519612, 1.300000, 0.011805>, <-1.519612, 0.000000, 0.011805>, 
      <0.015688, 0.000000, 0.013465>, <0.015688, 1.300000, 0.013465>, <-1.519612, 1.300000, 0.013465>, <-1.519612, 0.000000, 0.013465>, 
      <-0.354097, 0.000000, 2.020783>, <-0.354097, 1.300000, 2.020783>, <-3.194417, 1.300000, 1.995319>, <-3.194417, 0.000000, 1.995319>, 
      <-0.211384, 0.000000, 4.792587>, <-0.211384, 0.000000, 4.792587>, <-0.211384, 0.000000, 4.792587>, <-0.211384, 0.000000, 4.792587>
    }
  }
}
#declare Labbro_Inf = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.404768, 0.000000, -4.723111>, <-0.404768, 0.000000, -4.723111>, <-0.404768, 0.000000, -4.723111>, <-0.404768, 0.000000, -4.723111>, 
      <1.593948, 0.000000, -0.008049>, <1.593948, -1.881535, -0.008049>, <4.746334, -1.881535, -2.589078>, <4.746334, 0.000000, -2.589078>, 
      <1.593948, 0.000000, -0.026872>, <1.593948, -1.881535, -0.026872>, <4.746334, -1.881535, 2.589078>, <4.746334, 0.000000, 2.589078>, 
      <-0.404768, 0.000000, 4.723111>, <-0.404768, 0.000000, 4.723111>, <-0.404768, 0.000000, 4.723111>, <-0.404768, 0.000000, 4.723111>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.404768, 0.000000, -4.723111>, <-0.404768, 0.000000, -4.723111>, <-0.404768, 0.000000, -4.723111>, <-0.404768, 0.000000, -4.723111>, 
      <4.746334, 0.000000, -2.589078>, <4.746334, 1.881535, -2.589078>, <1.593948, 1.881535, -0.008049>, <1.593948, 0.000000, -0.008049>, 
      <4.746334, 0.000000, 2.589078>, <4.746334, 1.881535, 2.589078>, <1.593948, 1.881535, -0.026872>, <1.593948, 0.000000, -0.026872>, 
      <-0.404768, 0.000000, 4.723111>, <-0.404768, 0.000000, 4.723111>, <-0.404768, 0.000000, 4.723111>, <-0.404768, 0.000000, 4.723111>
    }
  }
  translate  0.3*x
}
#declare Bocca_F = union {
  object { Labbro_Sup }
  object { Labbro_Inf }
  texture {
    Rosso
  }
  scale 0.15
  rotate -270.0*y
  translate  <0.0, -1.1, -2.0>
}
#declare Presa_Corpo = union {
  sphere { // OcchioSX
    <0,0,0>,1
    texture {
      occhio_sx_pr
      scale 2.05
      rotate <-90.0, -180.0, -180.0>
      translate <-1.000000, 0.500000, -1.000000>
    }
    scale <0.572, 0.1, 0.39>
    rotate -5.0*y
    translate  <1.1, -1.2, 0.8>
  }
  object { // SopracciglioSX->SopraccigilioDX
    SopraccigilioDX
    texture {
      Roscio
    }
    rotate -180.0*z
    translate  -2.4*y
  }
  object { SopraccigilioDX }
  object { Presa_reale }
  sphere { // Occhiodx
    <0,0,0>,1
    texture {
      occhio_dx_pr
      scale 2.05
      rotate <-90.0, -180.0, -180.0>
      translate <-1.000000, 0.500000, -1.000000>
    }
    scale <0.572, 0.1, 0.39>
    rotate 5.0*y
    translate  <-1.1, -1.2, 0.8>
  }
  sphere { // SpallaSX
    <0,0,0>,1
    texture {
      Rosso
    }
    scale 0.4
    rotate <0.0, -20.0, 90.0>
    translate  <2.4, -0.002929, 0.411076>
  }
  sphere { // SpallaDX
    <0,0,0>,1
    texture {
      Rosso
    }
    scale 0.4
    rotate <-0.0, -20.0, -90.0>
    translate  <-2.4, 0.002929, 0.411076>
  }
  sphere { // AncaDX
    <0,0,0>,1
    texture {
      Rosso
    }
    scale 0.4
    rotate 10.0*x
    translate  <-0.9, 0.05, -3.5>
  }
  sphere { // AncaSX
    <0,0,0>,1
    texture {
      Rosso
    }
    scale 0.4
    rotate -30.0*x
    translate  <0.9, 0.05, -3.5>
  }
  object { Bocca_F }
  object { CigliaDX }
  object { // CigliaSX->CigliaDX
    CigliaDX
    rotate <-0.0, -10.0, 0.0>
    translate  <2.316387, 0.0, 0.18>
  }
  object { OrecchinoDX }
  object { // OrecchinoDX1->OrecchinoDX
    OrecchinoDX
    rotate <-0.0, -0.0, -270.0>
    translate  <1.3, 1.28, 0.0>
  }
  rotate 10.0*x
}
#declare GambaDX = union {
  cylinder { // CosciaDX
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 2.5>
    rotate <-23.0, 10.0, 0.0>
    translate  <0.0, -0.5, -6.0>
  }
  sphere { // GinocchioDX
    <0,0,0>,1
    texture {
      Rosso
    }
    scale 0.3
    translate  <0.0, -0.5, -6.1>
  }
  cylinder { // PolpaccioDX
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 2.0>
    rotate 20.0*x
    translate  <0.0, 0.2, -8.0>
  }
  object { Scarpa_pr_DX }
  texture {
    Ottone_Lucidato
  }
  rotate 10.0*x
  translate  <-1.3, -0.5, 0.0>
}
#declare GambaSX = union {
  sphere { // GinocchioSX
    <0,0,0>,1
    texture {
      Rosso
    }
    scale 0.3
    translate  <0.0, -0.5, -6.1>
  }
  cylinder { // PolpaccioSX
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 2.0>
    rotate 20.0*x
    translate  <0.0, 0.2, -8.0>
  }
  cylinder { // CosciaSX
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 2.5>
    rotate <-23.0, -10.0, 0.0>
    translate  <0.0, -0.5, -6.0>
  }
  object { // Scarpa_pr_SX->Scarpa_pr_DX
    Scarpa_pr_DX
    texture {
      Bianco
    }
    rotate -0.0*x
    translate  <0.0, -0.0, -0.0>
  }
  texture {
    Ottone_Lucidato
  }
  rotate 10.0*x
  translate  <1.3, -0.5, 0.0>
}
#declare ManoChiusa_DX = union {
  sphere { // Palmo1
    <0,0,0>,1
    scale <0.2, 0.6, 0.65>
    translate  -0.4*y
  }
  sphere { // Pollice1
    <0,0,0>,1
    scale <0.17, 0.5, 0.17>
    rotate -90.0*z
    translate  <-0.45, 0.1, -0.3>
  }
  object { Indice1 }
  object { // Medio1->Indice1
    Indice1
    translate  <-0.05, -0.2, 0.35>
  }
  object { // Anulare1->Indice1
    Indice1
    translate  <0.0, -0.1, 0.7>
  }
  object { // Mignolo1->Indice1
    Indice1
    scale 0.8
    translate  0.92*z
  }
  torus { // Torus3
    0.2, 0.1  rotate -x*90
    scale <0.9, 1.5, 1.0>
    rotate -90.0*x
    translate  0.1*y
  }
  torus { // Anello1
    0.15, 0.05  rotate -x*90
    texture {
      Rosso
    }
    rotate -90.0*y
    translate  <-0.2, -0.7, -0.475>
  }
  texture {
    Bianco
  }
  scale 0.9
  rotate <-30.0, -180.0, -270.0>
  translate  <0.7, 0.05, -7.9>
}
#declare Specchio = union {
  object { Cylndr5 }
  torus { // Torus001
    1.0, 0.1  rotate -x*90
    scale <1.0, 1.5, 1.0>
  }
  cone { // Cone001
    <0,0,0>, 0.1, <0,0,1>, 0.2
    scale <1.0, 0.5, 2.0>
    rotate -270.0*x
    translate  -1.5*y
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale <0.2, 0.1, 0.1>
    translate  -3.5*y
  }
  object { // Cylndr6->Cylndr5
    Cylndr5
    texture {
      Cromo_Lucidato
    }
    scale <1.0, 1.0, 0.5>
    translate  0.05*z
  }
  texture {
    Rosa
  }
  rotate <50.0, -10.0, -100.0>
  translate  <3.0, 0.4, -5.8>
}
#declare BraccioDX = union {
  object { ManoChiusa_DX }
  cylinder { // AvambraccioDX
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 2.0>
    rotate <10.0, -20.0, 0.0>
    translate  <0.7, 0.05, -7.9>
  }
  cylinder { // Braccio1
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 2.5>
    rotate -20.0*x
    translate  <0.0, -0.3, -5.9>
  }
  sphere { // GomitoDX
    <0,0,0>,1
    texture {
      Rosso
    }
    scale 0.3
    translate  <0.0, -0.3, -6.0>
  }
  object { Specchio }
  texture {
    Ottone_Lucidato
  }
  rotate <0.0, -30.0, -90.0>
  translate  <-3.0, 1.7, 3.3>
}
#declare ManoAperta_SX = union {
  sphere { // Palmo
    <0,0,0>,1
    scale <0.2, 0.6, 0.65>
    translate  -0.4*y
  }
  sphere { // Pollice
    <0,0,0>,1
    scale <0.17, 0.5, 0.17>
    rotate -140.0*z
    translate  <0.3, -0.25, -0.3>
  }
  object { Indice }
  object { // Medio->Indice
    Indice
    translate  <-0.05, -0.2, 0.35>
  }
  object { // Anulare->Indice
    Indice
    translate  <0.0, -0.1, 0.7>
  }
  object { // Mignolo->Indice
    Indice
    scale 0.8
    translate  0.92*z
  }
  torus { // Torus2
    0.2, 0.1  rotate -x*90
    scale <0.9, 1.5, 1.0>
    rotate -90.0*x
    translate  0.1*y
  }
  torus { // Anello
    0.15, 0.05  rotate -x*90
    texture {
      Rosso
    }
    rotate <-90.0, -90.0, 0.0>
    translate  <0.007901, -0.763574, -0.494715>
  }
  texture {
    Bianco
  }
  scale 0.9
  rotate <-70.0, -150.0, -90.0>
  translate  <-0.35, 0.8, -6.3>
}
#declare BraccioSX = union {
  sphere { // GomitoSX
    <0,0,0>,1
    texture {
      Rosso
    }
    scale 0.3
    translate  <0.1, -1.4, -5.5>
  }
  object { ManoAperta_SX }
  cylinder { // Braccio2
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 2.5>
    rotate -50.0*x
    translate  <-0.1, -1.4, -5.3>
  }
  cylinder { // AvambraccioSX
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 2.2>
    rotate <70.0, 20.0, 0.0>
    translate  <-0.3, 0.8, -6.25>
  }
  torus { // Braccialetto
    0.35, 0.05  rotate -x*90
    texture {
      Rosso
    }
    rotate <-130.0, 20.0, 0.0>
    translate  <-0.252682, 0.440582, -6.101647>
  }
  texture {
    Ottone_Lucidato
  }
  rotate <0.0, -20.0, -270.0>
  translate  <3.0, -1.2, 3.7>
}
#declare CSG3 = difference {
  torus { // Torus8
    2.6, 0.4  rotate -x*90
    rotate -90.0*y
    translate  <0.0, 20.0, 3.6>
  }
  plane { // Plane46
    z,0
    rotate -270.0*x
    translate  <0.0, 20.0, 3.6>
  }
  plane { // Plane47
    z,0
    rotate -170.0*x
    translate  <0.0, 20.0, 3.6>
  }
}
#declare Cavo_pr = union {
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 3.0>
    rotate 10.0*x
    translate  <0.0, 17.444, 3.14774>
  }
  object { CSG3 }
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 20.0>
    rotate -90.0*x
    translate  <0.0, 20.0, 1.0>
  }
  texture {
    Nero
  }
  rotate 10.0*z
  translate  <3.0, -16.2, -8.9>
}
union { // Presa_Tot
  object { Presa_Corpo }
  object { GambaDX }
  object { GambaSX }
  object { BraccioDX }
  object { BraccioSX }
  object { Cavo_pr }
  rotate -290.0*z
  translate  <-4.3, -10.0, 8.9>
}


#declare Occhiali = union {
  object { OcchialeDX }
  object { // OcchialeSX->OcchialeDX
    OcchialeDX
    translate  2.4*x
  }
  cylinder { // Ponte
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.05, 0.35>
    rotate -90.0*y
    translate  <0.175, -1.7, 0.8>
  }
  texture {
    Nero
  }
}
#declare Piani_Sez3 = union {
  plane { // Plane23
    z,0
    rotate <-45.0, -90.0, 0.0>
    translate  <2.0, -0.7, 0.0>
  }
  plane { // Plane24
    z,0
    rotate <-135.0, -90.0, 0.0>
    translate  <-2.0, -0.7, 0.0>
  }
  plane { // Plane25
    z,0
    rotate <-225.0, -90.0, 0.0>
    translate  <-2.0, 0.7, 0.0>
  }
  plane { // Plane26
    z,0
    rotate <-315.0, -90.0, 0.0>
    translate  <2.0, 0.7, 0.0>
  }
  plane { // Plane27
    z,0
    rotate -66.0*y
    translate  <1.4, 0.0, -2.8>
  }
  plane { // Plane28
    z,0
    rotate -294.0*y
    translate  <-1.4, 0.0, -2.8>
  }
  plane { // Plane29
    z,0
    rotate <0.0, -76.699997, -45.0>
    translate  <1.3, -0.8, -2.8>
  }
  plane { // Plane30
    z,0
    rotate <0.0, -76.699997, -135.0>
    translate  <-1.3, -0.8, -2.8>
  }
  plane { // Plane31
    z,0
    rotate <0.0, -76.699997, -225.0>
    translate  <-1.3, 0.8, -1.8>
  }
  plane { // Plane32
    z,0
    rotate <0.0, -76.699997, -315.0>
    translate  <1.3, 0.8, -2.8>
  }
}
#declare Superiore1 = difference {
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 0.9, 1.9>
    translate  -0.9*z
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.2, 1.0>
    rotate 7.0*x
    translate  <0.0, -1.0, -1.8>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.2, 1.0>
    rotate -7.0*x
    translate  <0.0, 1.0, -1.8>
  }
  object { Piani_Sez3 }
}
#declare Piani_Sez4 = union {
  plane { // Plane33
    z,0
    rotate <-315.0, -90.0, 0.0>
    translate  <1.3, 0.8, -3.55>
  }
  plane { // Plane34
    z,0
    rotate <-45.0, -90.0, 0.0>
    translate  <1.3, -0.8, -3.55>
  }
  plane { // Plane35
    z,0
    rotate <-135.0, -90.0, 0.0>
    translate  <-1.3, -0.8, -3.55>
  }
  plane { // Plane36
    z,0
    rotate <-225.0, -90.0, 0.0>
    translate  <-1.3, 0.8, -3.55>
  }
  plane { // Plane37
    z,0
    rotate -45.0*x
    translate  <0.0, -0.8, -4.2>
  }
  plane { // Plane38
    z,0
    rotate -315.0*x
    translate  <0.0, 0.8, -4.2>
  }
  plane { // Plane39
    z,0
    rotate <-45.0, 0.0, -90.0>
    translate  <-1.3, 0.0, -4.2>
  }
  plane { // Plane40
    z,0
    rotate <-45.0, 0.0, -270.0>
    translate  <1.3, 0.0, -4.2>
  }
  plane { // Plane41
    z,0
    rotate <-45.0, 0.0, -315.0>
    translate  <1.3, -0.8, -4.1>
  }
  plane { // Plane42
    z,0
    rotate <-45.0, 0.0, -225.0>
    translate  <1.3, 0.8, -4.1>
  }
  plane { // Plane43
    z,0
    rotate <-45.0, 0.0, -135.0>
    translate  <-1.3, 0.8, -4.1>
  }
  plane { // Plane44
    z,0
    rotate <-45.0, 0.0, -45.0>
    translate  <-1.3, -0.8, -4.1>
  }
}
#declare Inferiore1 = difference {
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <1.4, 0.9, 0.75>
    translate  -3.55*z
  }
  object { Piani_Sez4 }
}
#declare SpinottoTerra = union {
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1 
    scale <0.26, 0.26, 1.74>
    translate  <-1.3, 0.0, 1.0>
  }
  sphere { // Sphere5
    <0,0,0>,1
    scale 0.26
    translate  <-1.3, 0.0, 2.74>
  }
  texture {
    Cromo_Lucidato
  }
  translate  1.3*x
}
#declare Vite1 = difference {
  sphere { // Sphere7
    <0,0,0>,1
    scale <0.3, 0.2, 0.3>
    translate  <0.0, -1.0, -1.3>
  }
  object { Cube11 }
  object { // Cube12->Cube11
    Cube11
    rotate -90.0*y
    translate  <-1.3, 0.0, -1.3>
  }
  texture {
    Cromo_Lucidato
  }
}
#declare Spina_reale = union {
  object { Superiore1 }
  object { Inferiore1 }
  object { Spinotto1 }
  object { // Spinotto2->Spinotto1
    Spinotto1
    translate  2.6*x
  }
  object { SpinottoTerra }
  superellipsoid { // Passacavo1
    <1.0, 0.2>
    texture {
      Giallino
    }
    scale 0.6
    translate  -4.8*z
  }
  torus { // SedeVite1
    0.35, 0.05  rotate -x*90
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.9, -1.3>
  }
  object { Vite1 }
  texture {
    Corpo_sp
    scale <3.5, 2.0, 1.0>
    rotate <-90.0, -180.0, -180.0>
    translate <-1.800000, 0.000000, -1.000000>
  }
  translate  1.0*z
}
#declare Mazzo = union {
  object { Margherita1 }
  object { // Margherita2->Margherita1
    Margherita1
    rotate <0.0, 0.0, -45.0>
    translate  <1.3, 0.8, -1.4>
  }
  object { // Margherita3->Margherita1
    Margherita1
    rotate <0.0, 0.0, -90.0>
    translate  <-0.6, -1.4, 3.4>
  }
  object { // Margherita4->Margherita1
    Margherita1
    rotate <0.0, 0.0, -135.0>
    translate  <-1.4, -0.5, -2.7>
  }
  object { // Margherita5->Margherita1
    Margherita1
    rotate <0.0, 0.0, 180.0>
    translate  <-0.4, -0.1, 3.9>
  }
  object { // Margherita6->Margherita1
    Margherita1
    rotate <-0.0, 0.0, 135.0>
    translate  <-1.7, -0.1, -1.4>
  }
  object { // Margherita7->Margherita1
    Margherita1
    rotate -300.0*z
    translate  <1.5, 0.5, -1.6>
  }
  scale 0.05
  translate  <-2.8, -3.1, -0.2>
}
#declare BezPtch23 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -9.700000>, <0.000000, 0.000000, -9.700000>, <0.000000, 0.000000, -9.700000>, <0.000000, 0.000000, -9.700000>, 
      <-1.611570, -3.567505, -1.000000>, <-1.611570, -5.047088, -1.000000>, <1.611570, -5.047088, -1.000000>, <1.611570, -3.567505, -1.000000>, 
      <-1.611570, -3.567505, 1.000000>, <-1.611570, -5.047088, 1.000000>, <1.611570, -5.047088, 1.000000>, <1.611570, -3.567505, 1.000000>, 
      <0.000000, 0.000000, 9.700000>, <0.000000, 0.000000, 9.700000>, <0.000000, 0.000000, 9.700000>, <0.000000, 0.000000, 9.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -9.700000>, <0.000000, 0.000000, -9.700000>, <0.000000, 0.000000, -9.700000>, <0.000000, 0.000000, -9.700000>, 
      <1.611570, -3.567505, -1.000000>, <1.611570, -2.087923, -1.000000>, <-1.611570, -2.087923, -1.000000>, <-1.611570, -3.567505, -1.000000>, 
      <1.611570, -3.567505, 1.000000>, <1.611570, -2.087923, 1.000000>, <-1.611570, -2.087923, 1.000000>, <-1.611570, -3.567505, 1.000000>, 
      <0.000000, 0.000000, 9.700000>, <0.000000, 0.000000, 9.700000>, <0.000000, 0.000000, 9.700000>, <0.000000, 0.000000, 9.700000>
    }
  }
}
#declare BezPtch26 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -9.700000>, <0.000000, 0.000000, -9.700000>, <0.000000, 0.000000, -9.700000>, <0.000000, 0.000000, -9.700000>, 
      <-2.156177, -10.015080, -1.000000>, <-2.156177, -11.996487, -1.000000>, <2.156177, -11.996487, -1.000000>, <2.156177, -10.015080, -1.000000>, 
      <-2.156177, -10.015080, 1.000000>, <-2.156177, -11.996487, 1.000000>, <2.156177, -11.996487, 1.000000>, <2.156177, -10.015080, 1.000000>, 
      <0.000000, 0.000000, 9.700000>, <0.000000, 0.000000, 9.700000>, <0.000000, 0.000000, 9.700000>, <0.000000, 0.000000, 9.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -9.700000>, <0.000000, 0.000000, -9.700000>, <0.000000, 0.000000, -9.700000>, <0.000000, 0.000000, -9.700000>, 
      <2.156177, -10.015080, -1.000000>, <2.156177, -8.033672, -1.000000>, <-2.156177, -8.033672, -1.000000>, <-2.156177, -10.015080, -1.000000>, 
      <2.156177, -10.015080, 1.000000>, <2.156177, -8.033672, 1.000000>, <-2.156177, -8.033672, 1.000000>, <-2.156177, -10.015080, 1.000000>, 
      <0.000000, 0.000000, 9.700000>, <0.000000, 0.000000, 9.700000>, <0.000000, 0.000000, 9.700000>, <0.000000, 0.000000, 9.700000>
    }
  }
}
#declare Denti = union {
  superellipsoid { // DenteDX1
    <0.1, 0.4>
    scale <0.2, 2.0, 1.5>
    rotate <0.0, 5.0, -200.0>
    translate  <-0.9, -4.2, -1.6>
  }
  superellipsoid { // DenteDX2
    <0.1, 0.4>
    scale <0.2, 1.5, 1.125>
    rotate <-5.0, 5.0, -200.0>
    translate  <-0.5, -3.4, -4.4>
  }
  superellipsoid { // DenteSX1
    <0.1, 0.4>
    scale <0.2, 2.0, 1.5>
    rotate <0.0, -5.0, -200.0>
    translate  <-0.9, -4.2, 1.6>
  }
  superellipsoid { // DenteSX2
    <0.1, 0.4>
    scale <0.2, 1.5, 1.125>
    rotate <5.0, -5.0, -200.0>
    translate  <-0.5, -3.4, 4.4>
  }
  texture {
    Petali
    rotate -95.0*x
  }
  translate  -0.1*x
}
#declare Bocca_M = union {
  object { BezPtch23 }
  object { BezPtch24 }
  object { // BezPtch25->BezPtch24
    BezPtch24
    rotate -90.0*x
    translate  <0.0, 9.6, 9.4>
  }
  object { BezPtch26 }
  object { Denti }
  texture {
    Rosso
  }
  scale 0.1
  rotate <-100.0, -180.0, -90.0>
  translate  <0.0, -1.2, -1.7>
}
#declare Spina_Corpo = union {
  sphere { // OcchioSX1
    <0,0,0>,1
    texture {
      occhio_sx_sp
      scale 2.05
      rotate <-90.0, -180.0, -180.0>
      translate <-1.000000, 0.500000, -1.000000>
    }
    scale <0.572, 0.1, 0.39>
    rotate -5.0*y
    translate  <1.2, -1.2, 0.8>
  }
  object { Occhiali }
  object { // SopracciglioSX1->SopraccigilioDX1
    SopraccigilioDX1
    texture {
      Nero
    }
    rotate -180.0*z
    translate  -2.4*y
  }
  object { SopraccigilioDX1 }
  object { Spina_reale }
  sphere { // Occhiodx1
    <0,0,0>,1
    texture {
      occhio_dx_sp
      scale 2.05
      rotate <-90.0, -180.0, -180.0>
      translate <-1.000000, 0.500000, -1.000000>
    }
    scale <0.572, 0.1, 0.39>
    rotate 5.0*y
    translate  <-1.2, -1.2, 0.8>
  }
  object { Mazzo }
  object { Bocca_M }
  sphere { // SpallaSX1
    <0,0,0>,1
    texture {
      Nero
    }
    scale 0.4
    rotate <0.0, -20.0, 90.0>
    translate  <2.4, -0.002929, 0.411076>
  }
  sphere { // SpallaDX1
    <0,0,0>,1
    texture {
      Nero
    }
    scale 0.4
    rotate <-0.0, -20.0, -90.0>
    translate  <-2.4, 0.002929, 0.411076>
  }
  sphere { // AncaDX1
    <0,0,0>,1
    texture {
      Nero
    }
    scale 0.4
    rotate 10.0*x
    translate  <-0.9, 0.05, -3.5>
  }
  sphere { // AncaSX1
    <0,0,0>,1
    texture {
      Nero
    }
    scale 0.4
    rotate -30.0*x
    translate  <0.9, 0.0, -3.5>
  }
  rotate 10.0*x
}
#declare ScarpaDX = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.068032, -1.504185>, <0.000000, 0.068032, -1.504185>, <0.000000, 0.068032, -1.504185>, <0.000000, 0.068032, -1.504185>, 
      <-1.667750, 0.427822, -1.436606>, <-2.027808, -0.505491, -1.395902>, <2.027808, -0.505491, -1.395902>, <1.667750, 0.427822, -1.436606>, 
      <-0.607583, 0.243396, -0.563819>, <-0.734782, -0.097086, -0.563819>, <0.734782, -0.097086, -0.563819>, <0.607583, 0.243396, -0.563819>, 
      <-0.936185, 0.405325, -0.131909>, <-1.132179, -0.131289, -0.131909>, <1.132179, -0.131289, -0.131909>, <0.936185, 0.405325, -0.131909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.068032, -1.504185>, <0.000000, 0.068032, -1.504185>, <0.000000, 0.068032, -1.504185>, <0.000000, 0.068032, -1.504185>, 
      <1.667750, 0.427822, -1.436606>, <1.307692, 1.361134, -1.477309>, <-1.307692, 1.361134, -1.477309>, <-1.667750, 0.427822, -1.436606>, 
      <0.607583, 0.243396, -0.563819>, <0.480383, 0.583879, -0.563819>, <-0.480383, 0.583879, -0.563819>, <-0.607583, 0.243396, -0.563819>, 
      <0.936185, 0.405325, -0.131909>, <0.740191, 0.941939, -0.131909>, <-0.740191, 0.941939, -0.131909>, <-0.936185, 0.405325, -0.131909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.936185, 0.405325, -0.131909>, <-1.132179, -0.131289, -0.131909>, <1.132179, -0.131289, -0.131909>, <0.936185, 0.405325, -0.131909>, 
      <-1.264788, 0.567254, 0.300000>, <-1.529576, -0.165491, 0.300000>, <1.529576, -0.165491, 0.300000>, <1.264788, 0.567254, 0.300000>, 
      <-1.264788, 0.443153, 1.472335>, <-1.529576, -0.413694, 1.472335>, <1.529576, -0.413694, 1.472335>, <1.264788, 0.443153, 1.472335>, 
      <0.000000, 0.260905, 1.517199>, <0.000000, 0.260905, 1.517199>, <0.000000, 0.260905, 1.517199>, <0.000000, 0.260905, 1.517199>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.936185, 0.405325, -0.131909>, <0.740191, 0.941939, -0.131909>, <-0.740191, 0.941939, -0.131909>, <-0.936185, 0.405325, -0.131909>, 
      <1.264788, 0.567254, 0.300000>, <1.000000, 1.300000, 0.300000>, <-1.000000, 1.300000, 0.300000>, <-1.264788, 0.567254, 0.300000>, 
      <1.264788, 0.443153, 1.472335>, <1.000000, 1.300000, 1.472335>, <-1.000000, 1.300000, 1.472335>, <-1.264788, 0.443153, 1.472335>, 
      <0.000000, 0.260905, 1.517199>, <0.000000, 0.260905, 1.517199>, <0.000000, 0.260905, 1.517199>, <0.000000, 0.260905, 1.517199>
    }
  }
  texture {
    Giallone
  }
  scale <0.6, 0.8, 0.8>
  rotate -290.0*x
  translate  <0.0, -0.7, -8.1>
}
#declare GambaDX1 = union {
  object { ScarpaDX }
  cylinder { // CosciaDX1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cromo_Lucidato
    }
    scale <0.2, 0.2, 2.5>
    rotate <-23.0, 10.0, 0.0>
    translate  <0.0, -0.5, -6.0>
  }
  sphere { // GinocchioDX1
    <0,0,0>,1
    scale 0.3
    translate  <0.0, -0.5, -6.1>
  }
  cylinder { // PolpaccioDX1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cromo_Lucidato
    }
    scale <0.2, 0.2, 2.0>
    rotate 20.0*x
    translate  <0.0, 0.2, -8.0>
  }
  torus { // Torus5
    0.25, 0.1  rotate -x*90
    texture {
      Giallone
    }
    rotate -25.0*x
    translate  <0.0, 0.15, -7.8>
  }
  texture {
    Nero
  }
  rotate 20.0*x
  translate  <-1.3, -1.1, 0.0>
}
#declare ScarpaSX = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.068032, -1.504185>, <0.000000, 0.068032, -1.504185>, <0.000000, 0.068032, -1.504185>, <0.000000, 0.068032, -1.504185>, 
      <-1.667750, 0.427822, -1.436606>, <-2.027808, -0.505491, -1.395902>, <2.027808, -0.505491, -1.395902>, <1.667750, 0.427822, -1.436606>, 
      <-0.607583, 0.243396, -0.563819>, <-0.734782, -0.097086, -0.563819>, <0.734782, -0.097086, -0.563819>, <0.607583, 0.243396, -0.563819>, 
      <-0.936185, 0.405325, -0.131909>, <-1.132179, -0.131289, -0.131909>, <1.132179, -0.131289, -0.131909>, <0.936185, 0.405325, -0.131909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.068032, -1.504185>, <0.000000, 0.068032, -1.504185>, <0.000000, 0.068032, -1.504185>, <0.000000, 0.068032, -1.504185>, 
      <1.667750, 0.427822, -1.436606>, <1.307692, 1.361134, -1.477309>, <-1.307692, 1.361134, -1.477309>, <-1.667750, 0.427822, -1.436606>, 
      <0.607583, 0.243396, -0.563819>, <0.480383, 0.583879, -0.563819>, <-0.480383, 0.583879, -0.563819>, <-0.607583, 0.243396, -0.563819>, 
      <0.936185, 0.405325, -0.131909>, <0.740191, 0.941939, -0.131909>, <-0.740191, 0.941939, -0.131909>, <-0.936185, 0.405325, -0.131909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.936185, 0.405325, -0.131909>, <-1.132179, -0.131289, -0.131909>, <1.132179, -0.131289, -0.131909>, <0.936185, 0.405325, -0.131909>, 
      <-1.264788, 0.567254, 0.300000>, <-1.529576, -0.165491, 0.300000>, <1.529576, -0.165491, 0.300000>, <1.264788, 0.567254, 0.300000>, 
      <-1.264788, 0.443153, 1.472335>, <-1.529576, -0.413694, 1.472335>, <1.529576, -0.413694, 1.472335>, <1.264788, 0.443153, 1.472335>, 
      <0.000000, 0.260905, 1.517199>, <0.000000, 0.260905, 1.517199>, <0.000000, 0.260905, 1.517199>, <0.000000, 0.260905, 1.517199>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.936185, 0.405325, -0.131909>, <0.740191, 0.941939, -0.131909>, <-0.740191, 0.941939, -0.131909>, <-0.936185, 0.405325, -0.131909>, 
      <1.264788, 0.567254, 0.300000>, <1.000000, 1.300000, 0.300000>, <-1.000000, 1.300000, 0.300000>, <-1.264788, 0.567254, 0.300000>, 
      <1.264788, 0.443153, 1.472335>, <1.000000, 1.300000, 1.472335>, <-1.000000, 1.300000, 1.472335>, <-1.264788, 0.443153, 1.472335>, 
      <0.000000, 0.260905, 1.517199>, <0.000000, 0.260905, 1.517199>, <0.000000, 0.260905, 1.517199>, <0.000000, 0.260905, 1.517199>
    }
  }
  texture {
    Giallone
  }
  scale <0.6, 0.8, 0.8>
  rotate -270.0*x
  translate  <0.0, -0.6, -8.4>
}
#declare GambaSX1 = union {
  sphere { // GinocchioSX1
    <0,0,0>,1
    scale 0.3
    translate  <0.0, -0.5, -6.1>
  }
  object { ScarpaSX }
  cylinder { // PolpaccioSX1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cromo_Lucidato
    }
    scale <0.2, 0.2, 2.0>
    rotate 20.0*x
    translate  <0.0, 0.2, -8.0>
  }
  cylinder { // CosciaSX1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cromo_Lucidato
    }
    scale <0.2, 0.2, 2.5>
    rotate <-23.0, -10.0, 0.0>
    translate  <0.0, -0.5, -6.0>
  }
  torus { // Torus002
    0.25, 0.1  rotate -x*90
    texture {
      Giallone
    }
    rotate -5.0*x
    translate  <0.0, 0.1, -7.8>
  }
  texture {
    Nero
  }
  rotate -20.0*x
  translate  <1.3, 1.43, 0.25>
}
#declare ManoChiusa_DX1 = union {
  sphere { // Palmo2
    <0,0,0>,1
    scale <0.2, 0.6, 0.65>
    translate  -0.4*y
  }
  sphere { // Pollice2
    <0,0,0>,1
    scale <0.17, 0.5, 0.17>
    rotate -90.0*z
    translate  <-0.45, 0.1, -0.3>
  }
  object { Indice2 }
  object { // Medio2->Indice2
    Indice2
    translate  <-0.05, -0.2, 0.35>
  }
  object { // Anulare2->Indice2
    Indice2
    translate  <0.0, -0.1, 0.7>
  }
  object { // Mignolo2->Indice2
    Indice2
    scale 0.8
    translate  0.92*z
  }
  torus { // Torus6
    0.2, 0.1  rotate -x*90
    scale <0.9, 1.5, 1.0>
    rotate -90.0*x
    translate  0.1*y
  }
  texture {
    Giallone
  }
  rotate <-30.0, -180.0, -270.0>
  translate  <0.7, -0.05, -7.9>
}
#declare BraccioDX1 = union {
  object { ManoChiusa_DX1 }
  cylinder { // AvambraccioDX1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cromo_Lucidato
    }
    scale <0.2, 0.2, 2.0>
    rotate <10.0, -20.0, 0.0>
    translate  <0.7, -0.05, -7.9>
  }
  cylinder { // Braccio3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cromo_Lucidato
    }
    scale <0.2, 0.2, 2.5>
    rotate -20.0*x
    translate  <0.0, -0.3, -5.9>
  }
  sphere { // GomitoDX1
    <0,0,0>,1
    scale 0.3
    translate  <0.0, -0.3, -6.0>
  }
  texture {
    Nero
  }
  rotate <0.0, -20.0, -90.0>
  translate  <-3.0, 1.2, 3.7>
}
#declare ManoAperta_SX1 = union {
  sphere { // Palmo3
    <0,0,0>,1
    scale <0.2, 0.6, 0.65>
    translate  -0.4*y
  }
  sphere { // Pollice3
    <0,0,0>,1
    scale <0.17, 0.5, 0.17>
    rotate -140.0*z
    translate  <0.3, -0.25, -0.3>
  }
  object { Indice3 }
  object { // Medio3->Indice3
    Indice3
    translate  <-0.05, -0.2, 0.35>
  }
  object { // Anulare3->Indice3
    Indice3
    translate  <0.0, -0.1, 0.7>
  }
  object { // Mignolo3->Indice3
    Indice3
    scale 0.8
    translate  0.92*z
  }
  torus { // Torus7
    0.2, 0.1  rotate -x*90
    scale <0.9, 1.5, 1.0>
    rotate -90.0*x
    translate  0.1*y
  }
  texture {
    Giallone
  }
  rotate <-70.0, -160.0, -90.0>
  translate  <-0.7, 0.05, -7.9>
}
#declare BraccioSX1 = union {
  sphere { // GomitoSX1
    <0,0,0>,1
    scale 0.3
    translate  <0.0, -0.3, -6.0>
  }
  object { ManoAperta_SX1 }
  cylinder { // Braccio4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cromo_Lucidato
    }
    scale <0.2, 0.2, 2.5>
    rotate -20.0*x
    translate  <0.0, -0.3, -5.9>
  }
  cylinder { // AvambraccioSX1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cromo_Lucidato
    }
    scale <0.2, 0.2, 2.0>
    rotate <10.0, 20.0, 0.0>
    translate  <-0.7, 0.05, -7.9>
  }
  texture {
    Nero
  }
  rotate <0.0, -20.0, -270.0>
  translate  <3.0, -1.2, 3.7>
}
#declare CSG002 = difference {
  torus { // Torus003
    2.6, 0.4  rotate -x*90
    rotate -90.0*y
    translate  <0.0, 20.0, 3.6>
  }
  plane { // Plane002
    z,0
    rotate -270.0*x
    translate  <0.0, 20.0, 3.6>
  }
  plane { // Plane003
    z,0
    rotate -170.0*x
    translate  <0.0, 20.0, 3.6>
  }
}
#declare Cavo_sp = union {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 3.0>
    rotate 10.0*x
    translate  <0.0, 17.444, 3.14774>
  }
  object { CSG002 }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 20.0>
    rotate -90.0*x
    translate  <0.0, 20.0, 1.0>
  }
  texture {
    Nero
  }
  translate  <0.0, -16.5, -8.9>
}
union { // Spina_Tot
  object { Spina_Corpo }
  object { GambaDX1 }
  object { GambaSX1 }
  object { BraccioDX1 }
  object { BraccioSX1 }
  object { Cavo_sp }
  rotate 10.0*z
  translate  <13.6, 5.2, 8.9>
}


