#include "colors.inc"
#include "mestex.inc"
#include "fmenc.inc"
#include "ocedar.inc"

camera {location <80,80,45> direction z*.8 look_at <0,75,75>
blur_samples 512 focal_point <40,82,55> aperture 2
}

box {0,1 pigment {image_map {png "compo2"}} finish {ambient 0}
        scale <24.8*1.5,58.2*1.5,1> rotate y*-90 translate <-147,80,20>
        }

#declare r1=seed(23);

#declare Socle=union {
cylinder {<0,0,0>,<0,1,0>,3.5 pigment {Feldspar} finish {phong .9}}
cylinder {<0,0,0>,<0,1.5,0>,3 pigment {Feldspar} finish {phong .9}}
torus {3 .5 pigment {Feldspar} finish {phong .9} translate y*1}
cylinder {0,y*19,.15 texture {T_Chrome_5E}}
}

object {Socle translate <40,70,55>}
object {Socle translate <56,70,78>}

object {Ocedar_Pose_1 rotate y*120 scale .1 translate <50,78,65>}
object {Ocedar_Pose_2 rotate y*-30 scale .1 translate <40,87.5,55>}

box {<-150,0,-150>,<150,300,150> pigment {White}}
union {
cylinder {<5,0,5>,<5,67,5>,2}
cylinder {<5,0,84-5>,<5,67,84-5>,2}
cylinder {<59-5,0,5>,<59-5,67,5>,2}
cylinder {<59-5,0,84-5>,<59-5,67,84-5>,2}
pigment {White} finish {phong .8 reflection .2}
}

box {<0,70,0>,<59.4,67,84> pigment {Wheat}
 finish {phong .6 specular .1 phong_size 25 reflection .2}
 normal {bozo .01 scale .02}
}

//cylinder {<50,70,75>,<50,95,75>,3 pigment {Yellow filter .5}}
//cylinder {<40,70,55>,<40,95,55>,3 pigment {SpicyPink filter .5}}

object {Rotring (MandarinOrange) rotate z*-90 translate <50,70.5,60>}
object {Rotring (SeaGreen) rotate z*-90 rotate y*20 translate <50,71.1,57>}
object {Rotring (BlueViolet) rotate z*-90 rotate y*30 translate <45,70.5,45>}
//#macro Pencil (Pentype,Penlenght,Penradius,Penpoint,Pencolor,Penfollow)

union {
#declare boucle=1;
#while (boucle < 15)
object {Pencil (int(rand(r1)*2),4+rand(r1)*10,.3,.08,
        rgb <int(rand(r1)*5)/5+.2,int(rand(r1)*5)/5+.2,int(rand(r1)*5)/5+.2>,
        int(rand(r1)*2))
        rotate x*((rand(r1)*10)-5)
        translate y*rand(r1)*3
        rotate z*-90
        translate <45,70.3,45+boucle>}
#declare boucle=boucle+1;
#end
}

object {Pantone (rgb <1,1,.7>) rotate z*-90   rotate y*180 translate <35,70.8,40>}
object {Pantone (rgb <.2,.7,.4>) rotate z*-90 rotate y*170 translate <40,70.8,37>}
object {Pantone (rgb <.8,.3,.7>) rotate z*-90 rotate y*140 translate <40,70.8,34>}
object {Pantone (rgb <.4,.8,.1>) rotate z*-90  rotate y*200 translate <55,70.8,35>}

light_source {<0,290,-130> White*<1,1,.8>*1}
light_source {<130,290,130> White*<.8,.8,1>*.8 shadowless}
light_source {<80,80,45> White*<.8,.8,1>*1 shadowless}

