//      December 24 of 1998
//      "First Christmas"
//      IRTC Nov-Dec/98
//      Author:  Guillermo Espitia R.
//
//


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


background { color <0.976,0.600,0.000> }


camera {
  location  <2.000, -101.483, 39.862>
  direction <0.0,     0.0,  1.8317>
  sky       <0.0,     0.0,  1.0>
  up        <0.0,     0.0,  1.0>
  right     <1.33333,  0.0,  0.0>
  look_at   <-3.229, -2.776, 31.665>
}



//      *******  LIGHTS *******
//      ***********************


// Light Front
light_source {
  <13.286, -183.610, 154.048>
  color rgb <0.700, 0.700, 0.700>
}


//  Light Baby
light_source {
  <7.474, -13.345, 35.677>
  color rgb <0.943, 0.757, 0.843>
  shadowless
  fade_distance  15.0
  fade_power 2.0
}


//  Light bulb
light_source {
  <-10.546, -34.197, 43.456>
  color rgb <0.314, 0.314, 1.000>
  fade_distance  0.2
  fade_power 2.0
}


//  Light bulb
light_source {
  <-6.531, -19.994, 47.689>
  color rgb <1.000, 0.543, 0.014>
  fade_distance  0.2
  fade_power 2.0
}


//  Light bulb
light_source {
  <-19.115, -46.487, 38.041>
  color rgb <1.000, 0.000, 0.014>
  fade_distance  0.2
  fade_power 2.0
}


//  Light bulb
light_source {
  <-21.559, 9.213, 54.508>
  color rgb <0.000, 1.000, 0.000>
  fade_distance  0.2
  fade_power 2.0
  atmospheric_attenuation on
}


//  Light bulb
light_source {
  <-5.220, -26.756, 31.601>
  color rgb <0.000, 1.000, 0.000>
  fade_distance  0.2
  fade_power 2.0
}


//  Light bulb
light_source {
  <-2.214, -10.014, 34.432>
  color rgb <1.000, 0.000, 0.014>
  fade_distance  0.2
  fade_power 2.0
}


//  Light bulb
light_source {
  <-12.296, -39.504, 29.949>
  color rgb <1.000, 0.543, 0.014>
  fade_distance  0.2
  fade_power 2.0
}


//  Light bulb
light_source {
  <-39.331, 28.638, 39.251>
  color rgb <0.314, 0.314, 1.000>
  fade_distance  0.2
  fade_power 2.0
}



//      ********  TEXTURES  *******
//      ***************************

#include "Textures_ge_first.inc"


//
//      ********  DECLARE OBJECTS  *******
//      **********************************



//   ****  Adornment Christmas


#declare Ribbon_A1 = object {
  box {
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 2.5, 20.0>
    translate  <-20.5, 0.0, 20.2>
  }
}


#declare Petal1 = object {
  cone { // Petal1
    <0,0,0>, 0.3, <0,0,1>, 1.0
    open
    scale <1.0, 0.7, 1.8>
    rotate 81.700317*x
    translate  <0.0, 4.2, 0.450446>
  }
}


#declare Petal9 = object {
  cone { // Petal9
    <0,0,0>, 0.3, <0,0,1>, 1.0
    open
    scale <1.0, 0.7, 1.8>
    rotate 116.868919*x
    translate  <0.0, 2.763032, 2.258074>
  }
}


#declare Petal13 = object {
  cone { // Petal13
    <0,0,0>, 0.3, <0,0,1>, 1.0
    open
    scale <1.0, 0.7, 1.8>
    rotate 81.700317*x
    translate  <0.0, 4.2, 0.450446>
  }
}


#declare Petal21 = object {
  cone { // Petal21
    <0,0,0>, 0.3, <0,0,1>, 1.0
    open
    scale <1.0, 0.7, 1.8>
    rotate 116.868919*x
    translate  <0.0, 2.763032, 2.258074>
  }
}


#declare Petal_A1 = object {
  cylinder { // Petal_A1
    <0,0,1>, <0,0,0>, 1 open
    scale <0.5, 1.5, 0.6>
    rotate 11.81384*x
    translate  <0.0, 1.134458, 0.207433>
  }
}


#declare Petal_A13 = object {
  cylinder { // Petal_A13
    <0,0,1>, <0,0,0>, 1 open
    scale <0.5, 1.5, 0.6>
    rotate 37.572533*x
    translate  <0.0, 0.71255, 0.503765>
  }
}


#declare Cone2 = object {
  cone { // Cone2
    <0,0,0>, 0.5, <0,0,1>, 0.15
    open
    texture {
      T_Ribbon100
    }
    scale <5.0, 10.0, 10.0>
    rotate <-180.0, 79.633896, -180.0>
    translate  <6.0, 0.0, 2.924601>
  }
}


#declare Cylndr004 = object {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 0.2, 0.3>
    rotate <-90.0, 11.172589, 0.0>
    translate  -0.15*y
  }
}


#declare Cylndr005 = object {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.12, 0.2>
    rotate 26.870848*y
  }
}



//    ****  Cable electric


#include "cable8.inc"


#declare Cable8_Ref = object {
  Cable8  texture {
    T_Cable
  }
  rotate <78.696999, -4.83876, 67.116997>
  translate  <-6.5842, -25.644, 34.5773>
}


#declare Cable8_Ref = object {
  Cable8  texture {
    T_Cable
  }
  rotate <78.696999, -4.83876, 67.116997>
  translate  <-6.5842, -25.644, 34.5773>
}


#declare Cylndr003 = object {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.002, 0.001>
    rotate -38.610817*y
    translate  <0.008805, 0.0, 0.02087>
  }
}


#declare Guardaescoba = union {
  box {
    <-1, -1, -1>, <1, 1, 1>
    scale <250.0, 1.0, 6.0>
    translate  <100.0, 89.0, 6.1>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <1.5, 0.5, 500.0>
    rotate 90.0*y
    translate  <-150.0, 88.0, 1.6>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 500.0>
    rotate 90.0*y
    translate  <-150.0, 89.0, 12.1>
  }
  texture {
    T_Guardaescoba
  }
}





//  ****  Room

union {
  box { // Wall_Left
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Wall
    }
    scale <10.0, 220.0, 110.0>
    translate  <-160.0, -50.0, 110.0>
  }
  box { // Wall_Right
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Wall
    }
    scale <10.0, 220.0, 110.0>
    translate  <360.0, -50.0, 110.0>
  }
  box { // Wall_Back
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Wallpaper2
    }
    scale <250.0, 10.0, 110.0>
    translate  <100.0, 100.0, 110.0>
  }
  box { // Wall_Fore
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Wall
    }
    scale <250.0, 10.0, 110.0>
    translate  <100.0, -260.0, 110.0>
  }
  box { // Carpet
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Carpet
    }
    scale <270.0, 220.0, 10.0>
    translate  <100.0, -50.0, -10.0>
  }
  box { // Roof
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Wall
    }
    scale <270.0, 220.0, 10.0>
    translate  <100.0, -50.0, 230.0>
  }
  object { Guardaescoba }
}



//   ****   Dress baby


#include "belt.inc"


#declare Belt_Ref = object {
  Belt
  texture {
    T_Anillos1
  }
}


#include "bolero.inc"


#declare Bolero_Ref = object {
  Bolero
  texture {
    T_Bolero
  }
}


#include "dress.inc"


#declare Dress_Ref = object {
  Dress
  texture {
    T_Body_Dress
  }
}


#include "fists.inc"


#declare Fists_Ref = object {
  Fists
  texture {
    T_Anillos1
  }
}


#include "neck.inc"


#declare Neck_Ref = object {
  Neck
  texture {
    T_Anillos1
  }
}


#include "sleeves.inc"


#declare Sleeves_Ref = object {
  Sleeves
  texture {
    T_Mangas
  }
}


//    ****   Head and hands


#include "hands.inc"


#declare Hands_Ref = object {
  Hands
  texture {
    T_Face
  }
}


#include "face.inc"

#declare Face_Ref = object {
  Face
  texture {
    T_Face
  }
}


#include "hair.inc"


#declare Hair_Ref = object {
  Hair
  texture {
    T_Hair
  }
}


#include "lips.inc"


#declare Lips_Ref = object {
  Lips
  texture {
    T_Lips
  }
}


#include "eyebrows.inc"


#declare Eyebrows_Ref = object {
  Eyebrows
  texture {
    T_Hair
  }
}


#declare Head = union {
  object { Face_Ref }
  object { Hair_Ref }
  object { Lips_Ref }
  object { Eyebrows_Ref }
  sphere { // Eye_L
    <0,0,0>,1
    texture {
      T_Eye
    }
    scale 1.01
    rotate <-90.0, 88.0, -0.0>
    translate  <2.19, 31.693967, 4.667687>
  }
  sphere { // Eye_R
    <0,0,0>,1
    texture {
      T_Eye
    }
    scale 1.01
    rotate <90.0, 88.0, -180.0>
    translate  <-2.19, 31.693967, 4.667687>
  }
  sphere { // Earring
    <0,0,0>,1
    texture {
      T_Earring
    }
    scale 0.24854
    rotate <-90.0, 90.0, 0.0>
    translate  <6.060741, 29.161591, -0.018535>
  }
  rotate -10.0*x
  translate  <0.0, 0.426707, 5.143744>
}


//   ****  Baby

union {
  object { Belt_Ref }
  object { Bolero_Ref }
  object { Dress_Ref }
  object { Fists_Ref }
  object { Hands_Ref }
  object { Neck_Ref }
  object { Sleeves_Ref }
  object { Head }
  rotate <90.0, 0.0, -55.0>
  translate  <21.08, 1.33703, 0.0>
}


//   ****  Card

box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    T_Card
  }
  scale <7.45, 4.5, 0.05>
  rotate <26.0, 0.0, 40.0>
  translate  <-20.534023, -13.2611, 11.953655>
}



//   ****  Presents


#declare Ribbon_A = union {
  object { Ribbon_A1 }
  box { // Ribbon_A2
    <-1, -1, -1>, <1, 1, 1>
    scale <20.51, 2.5, 0.01>
    translate  40.19*z
  }
  object { // Ribbon_A3->Ribbon_A1
    Ribbon_A1
    translate  41.0*x
  }
  texture {
    T_Ribbon_Yellow1
  }
}


#declare Rosette1 = union {
  object { Petal1 }
  object { // Petal2->Petal1
    Petal1
    rotate <-0.0, 0.0, -45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Petal3->Petal1
    Petal1
    rotate <-0.0, 0.0, -90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Petal4->Petal1
    Petal1
    rotate <-0.0, 0.0, -135.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Petal5->Petal1
    Petal1
    rotate <-0.0, 0.0, 180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal6->Petal1
    Petal1
    rotate <-0.0, 0.0, 135.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal7->Petal1
    Petal1
    rotate <-0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Petal8->Petal1
    Petal1
    rotate <-0.0, 0.0, 45.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { Petal9 }
  object { // Petal10->Petal9
    Petal9
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal11->Petal9
    Petal9
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Petal12->Petal9
    Petal9
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, -0.0, 0.0>
  }
  texture {
    T_Ribbon_Yellow1
  }
  scale 3.5
  translate  40.2*z
}


#declare Present_1 = union {
  box { // Box_1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Present5
    }
    scale 20.0
    translate  20.0*z
  }
  object { Ribbon_A }
  object { Rosette1 }
  scale 0.75
  translate  <8.33792, 67.892, 0.0>
}


#declare Ribbon4 = union {
  box { // Ribbon_4A
    <-1, -1, -1>, <1, 1, 1>
    scale <41.0, 2.5, 0.01>
    translate  21.3*z
  }
  box { // Ribbon__4B
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 2.5, 10.6>
    translate  <-41.0, 0.0, 10.6>
  }
  box { // Ribbon_4C
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 2.5, 10.6>
    translate  <41.0, 0.0, 10.6>
  }
  box { // Ribbon_4D
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 26.0, 0.01>
    translate  21.3*z
  }
  box { // Ribbon_4E
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.01, 10.6>
    translate  <0.0, -26.0, 10.6>
  }
  scale <0.285714, 0.285714, 0.25>
  translate  -5.3*z
}


#declare Rosette4 = union {
  object { Petal13 }
  object { // Petal14->Petal13
    Petal13
    rotate <-0.0, 0.0, -45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Petal15->Petal13
    Petal13
    rotate <-0.0, 0.0, -90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Petal16->Petal13
    Petal13
    rotate <-0.0, 0.0, -135.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Petal17->Petal13
    Petal13
    rotate <-0.0, 0.0, 180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal18->Petal13
    Petal13
    rotate <-0.0, 0.0, 135.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal19->Petal13
    Petal13
    rotate <-0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Petal20->Petal13
    Petal13
    rotate <-0.0, 0.0, 45.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { Petal21 }
  object { // Petal22->Petal21
    Petal21
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal23->Petal21
    Petal21
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Petal24->Petal21
    Petal21
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { Ribbon4 }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1
    scale <2.5, 2.5, 0.01>
    translate  0.03*z
  }
  texture {
    T_Ribbon_Red1
  }
  scale <3.5, 3.5, 4.0>
  translate  21.2*z
}


#declare Present_4 = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Present8_B
    }
    scale <40.0, 25.0, 10.0>
    translate  10.0*z
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Present8_A
    }
    scale <40.599998, 25.6, 3.0>
    translate  18.0*z
  }
  object { Rosette4 }
  scale 0.5
  rotate <0.7412, -74.5159, 37.848999>
  translate  <-16.825408, 80.0, 19.491746>
}


#declare Giro_Box = union {
  object { Present_1 }
  object { Present_4 }
  rotate 10.159*z
  translate  <12.0, 1.8, 0.0>
}


#declare Rosette2 = union {
  object { Petal_A1 }
  object { // Petal_A2->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, -30.0>
    translate  0.0*z
  }
  object { // Petal_A3->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, -60.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Petal_A4->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, -90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Petal_A5->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, -120.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Petal_A6->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, -150.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Petal_A7->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, 180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal_A8->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, 150.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal_A9->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, 120.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal_A10->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Petal_A11->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, 60.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Petal_A12->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, 30.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { Petal_A13 }
  object { // Petal_A14->Petal_A13
    Petal_A13
    rotate -45.0*z
  }
  object { // Petal_A15->Petal_A13
    Petal_A13
    rotate -90.0*z
    translate  -0.0*y
  }
  object { // Petal_A16->Petal_A13
    Petal_A13
    rotate -135.0*z
  }
  object { // Petal_A17->Petal_A13
    Petal_A13
    rotate 180.0*z
    translate  -0.0*x
  }
  object { // Petal_A18->Petal_A13
    Petal_A13
    rotate 135.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal_A19->Petal_A13
    Petal_A13
    rotate 90.0*z
    translate  0.0*y
  }
  object { // Petal_A20->Petal_A13
    Petal_A13
    rotate 45.0*z
    translate  <0.0, 0.0, 0.0>
  }
  texture {
    T_Ribbon_Yellow2
  }
  scale 2.5
  translate  13.6*z
}


#declare Present_2 = union {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Present2
    }
    scale <15.0, 10.0, 7.0>
    translate  7.0*z
  }
  object { Rosette2 }
  rotate -19.3815*z
  translate  <8.587, -30.79, 0.0>
}


#declare Rosette5 = union {
  cylinder { // Petal_A21
    <0,0,1>, <0,0,0>, 1 open
    scale <0.5, 1.5, 0.6>
    rotate 11.81384*x
    translate  <0.0, 1.134458, 0.207433>
  }
  object { // Petal_A22->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, -30.0>
    translate  0.0*z
  }
  object { // Petal_A23->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, -60.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Petal_A24->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, -90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Petal_A25->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, -120.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Petal_A26->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, -150.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Petal_A27->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, 180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal_A28->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, 150.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal_A29->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, 120.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal_A30->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Petal_A31->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, 60.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Petal_A32->Petal_A1
    Petal_A1
    rotate <-0.0, 0.0, 30.0>
    translate  <0.0, 0.0, 0.0>
  }
  cylinder { // Petal_A33
    <0,0,1>, <0,0,0>, 1 open
    scale <0.5, 1.5, 0.6>
    rotate 37.572533*x
    translate  <0.0, 0.71255, 0.503765>
  }
  object { // Petal_A34->Petal_A13
    Petal_A13
    rotate -45.0*z
  }
  object { // Petal_A35->Petal_A13
    Petal_A13
    rotate -90.0*z
    translate  -0.0*y
  }
  object { // Petal_A36->Petal_A13
    Petal_A13
    rotate -135.0*z
  }
  object { // Petal_A37->Petal_A13
    Petal_A13
    rotate 180.0*z
    translate  -0.0*x
  }
  object { // Petal_A38->Petal_A13
    Petal_A13
    rotate 135.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Petal_A39->Petal_A13
    Petal_A13
    rotate 90.0*z
    translate  0.0*y
  }
  object { // Petal_A40->Petal_A13
    Petal_A13
    rotate 45.0*z
    translate  <0.0, 0.0, 0.0>
  }
  texture {
    T_Ribbon_Green
  }
  scale 2.5
  rotate 56.3689*z
  translate  <-6.880613, -3.246803, 9.79041>
}


#declare Present_3 = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_PresentN
    }
    scale <15.0, 12.0, 5.0>
    translate  5.0*z
  }
  object { Rosette5 }
  rotate -56.3689*z
  translate  <-23.01, -13.95, 0.0>
}


#declare Ribbon_A7 = union {
  box { // Ribbon_A4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 2.5, 20.0>
    translate  <-20.5, 0.0, 20.2>
  }
  box { // Ribbon_A5
    <-1, -1, -1>, <1, 1, 1>
    scale <20.51, 2.5, 0.01>
    translate  40.19*z
  }
  object { // Ribbon_A6->Ribbon_A1
    Ribbon_A1
    translate  41.0*x
  }
  texture {
    T_Ribbon_Yellow1
  }
}


#declare Present_6 = union {
  box { // Box_2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Present6
    }
    scale 20.0
    translate  20.0*z
  }
  object { Ribbon_A7 }
  scale <0.75, 0.75, 0.7>
  rotate -19.89529*z
  translate  <47.798385, 67.892, 0.0>
}


#declare Rosette3 = union {
  object { Cone2 }
  object { // Cone3->Cone2
    Cone2
    rotate <-0.0, -0.0, -60.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cone4->Cone2
    Cone2
    rotate <-0.0, -0.0, -120.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cone5->Cone2
    Cone2
    rotate <-0.0, -0.0, -180.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cone6->Cone2
    Cone2
    rotate <-0.0, -0.0, 120.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cone7->Cone2
    Cone2
    rotate <-0.0, -0.0, 60.0>
    translate  <0.0, 0.0, 0.0>
  }
  sphere { // Sphere002
    <0,0,0>,1
    texture {
      T_Adorn_Rosette
    }
    scale <6.0, 6.0, 4.0>
    translate  4.0*z
  }
  texture {
    T_Ribbon_Red2
  }
  scale 0.5
  rotate <-0.000052, -0.000075, -0.00004>
  translate  <-0.000048, -0.000047, 13.599916>
}


#declare PresentN = union {
  superellipsoid { // SuperQ001
    <0.05, 0.05>
    texture {
      T_Present3
    }
    scale <15.0, 10.0, 7.0>
    translate  7.0*z
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Present3
    }
    scale <9.95, 1.0, 6.95>
    rotate -90.0*z
    translate  <-14.001, 0.0, 7.0>
  }
  rotate <-2.249779, 1.551446, 41.774899>
  translate  <2.069527, -0.005467, 0.146906>
}


#declare Present_7 = union {
  object { Rosette3 }
  object { PresentN }
  rotate <0.010654, 4.061175, 0.15044>
  translate  <37.020877, 66.199647, 29.30193>
}
#declare Ribbon5 = union {
  box { // Ribbon_4A1
    <-1, -1, -1>, <1, 1, 1>
    scale <41.0, 2.5, 0.01>
    translate  21.3*z
  }
  box { // Ribbon__4B1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 2.5, 10.6>
    translate  <-41.0, 0.0, 10.6>
  }
  box { // Ribbon_4C1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 2.5, 10.6>
    translate  <41.0, 0.0, 10.6>
  }
  box { // Ribbon_4D1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 26.0, 0.01>
    translate  21.3*z
  }
  box { // Ribbon_4E1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.01, 10.6>
    translate  <0.0, -26.0, 10.6>
  }
  scale <0.285714, 0.285714, 0.25>
  translate  -5.3*z
}


#declare Rosette7 = union {
  object { Cylndr004 }
  object { // Cylndr13->Cylndr004
    Cylndr004
    rotate <0.0, -0.0, -30.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr14->Cylndr004
    Cylndr004
    rotate <0.0, -0.0, -60.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr15->Cylndr004
    Cylndr004
    rotate <0.0, -0.0, -90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr16->Cylndr004
    Cylndr004
    rotate <0.0, -0.0, -120.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr17->Cylndr004
    Cylndr004
    rotate <0.0, -0.0, -150.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr18->Cylndr004
    Cylndr004
    rotate <0.0, -0.0, 180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr19->Cylndr004
    Cylndr004
    rotate <0.0, -0.0, 150.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr20->Cylndr004
    Cylndr004
    rotate <0.0, -0.0, 120.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr21->Cylndr004
    Cylndr004
    rotate <0.0, -0.0, 90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr22->Cylndr004
    Cylndr004
    rotate <0.0, -0.0, 60.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr23->Cylndr004
    Cylndr004
    rotate <0.0, -0.0, 30.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { Cylndr005 }
  object { // Cylndr24->Cylndr005
    Cylndr005
    rotate <0.0, 0.0, -30.0>
  }
  object { // Cylndr25->Cylndr005
    Cylndr005
    rotate <0.0, 0.0, -60.0>
  }
  object { // Cylndr26->Cylndr005
    Cylndr005
    rotate <0.0, 0.0, -90.0>
  }
  object { // Cylndr27->Cylndr005
    Cylndr005
    rotate <-0.0, 0.0, -120.0>
  }
  object { // Cylndr28->Cylndr005
    Cylndr005
    rotate <0.0, 0.0, -150.0>
  }
  object { // Cylndr29->Cylndr005
    Cylndr005
    rotate <0.0, 0.0, 180.0>
  }
  object { // Cylndr30->Cylndr005
    Cylndr005
    rotate <0.0, 0.0, 150.0>
  }
  object { // Cylndr31->Cylndr005
    Cylndr005
    rotate <0.0, 0.0, 120.0>
  }
  object { // Cylndr32->Cylndr005
    Cylndr005
    rotate <0.0, 0.0, 90.0>
  }
  object { // Cylndr33->Cylndr005
    Cylndr005
    rotate <0.0, 0.0, 60.0>
  }
  object { // Cylndr34->Cylndr005
    Cylndr005
    rotate <-0.0, 0.0, 30.0>
  }
  torus { // Torus002
    0.1, 0.1  rotate -x*90
    translate  <0.011099, 0.0, 0.288578>
  }
  scale <4.285712, 4.285713, 3.750003>
  rotate <-0.081662, -0.107579, -48.727444>
  translate  <-0.037502, 0.069067, -0.182552>
}


#declare Adorn = union {
  object { Ribbon5 }
  object { Rosette7 }
  texture {
    T_Ribbon_Red1
  }
  scale <3.5, 3.5, 4.0>
  translate  21.2*z
}


#declare Present_8 = union {
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Present4_B
    }
    scale <40.0, 25.0, 10.0>
    translate  10.0*z
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Present4_A
    }
    scale <40.599998, 25.6, 3.0>
    translate  18.0*z
  }
  object { Adorn }
  scale 0.5
  rotate <0.153968, 0.010958, 48.727558>
  translate  <-7.639926, 27.117565, 0.07508>
}


union { // Presents
  object { Giro_Box }
  object { Present_2 }
  object { Present_3 }
  object { Present_6 }
  object { Present_7 }
  object { Present_8 }
}


//   ****  Tree


#include "Tree.inc"



//   ****  Support bulb

#declare Recept_Verde = union {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <0.0035, 0.0035, 0.008>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.01>
    translate  0.008*z
  }
  texture {
    T_Plastico_Verde
  }
}


#declare Anillo = difference {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <0.0055, 0.0055, 0.006>
    translate  0.013002*z
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.008>
    translate  <-0.000145, 0.0, 0.012>
  }
}


#declare Roseta = union {
  object { Anillo }
  object { Cylndr003 }
  object { // Cylndr4->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -22.5>
    translate  -0.0*y
  }
  object { // Cylndr7->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr8->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -67.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr9->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr10->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -112.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr12->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -135.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr35->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -157.5>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr36->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr37->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 157.5>
    translate  0.0*y
  }
  object { // Cylndr38->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 135.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr39->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 112.5>
    translate  0.0*x
  }
  object { // Cylndr40->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 90.0>
    translate  0.0*x
  }
  object { // Cylndr41->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 67.5>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr42->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr43->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 22.5>
    translate  <-0.0, -0.0, 0.0>
  }
  texture {
    T_Plast_Transp
  }
}


//    ****  Bulb


#include "Bulb.inc"


#declare Bulbo = object {
  Bulbo_Raw
  texture {
    T_Bulbo_Azul
  }
  hollow
  translate  0.0175*z
}


#declare Lamp_Blue1 = union {
  object { Recept_Verde }
  object { Roseta }
  object { Bulbo }
  cylinder { // Filamento
    <0,0,1>, <0,0,0>, 1
    texture {
      T_Filamento
    }
    scale <0.0003, 0.0003, 0.005>
    translate  0.028*z
  }
  sphere { // Halo
    <0,0,0>,1
    texture {
      T_Halo_Azul
    }
    hollow
    scale 0.06
    rotate -157.90831*x
    translate  <-0.000022, 0.000172, 0.034593>
  }
  scale 100.0
  rotate 157.90831*x
  translate  <-39.330539, 29.78512, 42.075769>
}


#declare Recept_Verde1 = union {
  cylinder { // Cylndr44
    <0,0,1>, <0,0,0>, 1
    scale <0.0035, 0.0035, 0.008>
  }
  cylinder { // Cylndr45
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.01>
    translate  0.008*z
  }
  texture {
    T_Plastico_Verde
  }
}


#declare Anillo1 = difference {
  cylinder { // Cylndr46
    <0,0,1>, <0,0,0>, 1
    scale <0.0055, 0.0055, 0.006>
    translate  0.013002*z
  }
  cylinder { // Cylndr47
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.008>
    translate  <-0.000145, 0.0, 0.012>
  }
}


#declare Roseta1 = union {
  object { Anillo1 }
  cylinder { // Cylndr48
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.002, 0.001>
    rotate -38.610817*y
    translate  <0.008805, 0.0, 0.02087>
  }
  object { // Cylndr49->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -22.5>
    translate  -0.0*y
  }
  object { // Cylndr50->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr51->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -67.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr52->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr53->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -112.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr54->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -135.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr55->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -157.5>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr56->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr57->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 157.5>
    translate  0.0*y
  }
  object { // Cylndr58->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 135.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr59->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 112.5>
    translate  0.0*x
  }
  object { // Cylndr60->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 90.0>
    translate  0.0*x
  }
  object { // Cylndr61->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 67.5>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr62->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr63->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 22.5>
    translate  <-0.0, -0.0, 0.0>
  }
  texture {
    T_Plast_Transp
  }
}


//   ****  Bulb 1


#declare Bulbo1 = object {
  Bulbo_Raw
  texture {
    T_Bulbo_Naranja
  }
  hollow
  translate  0.0175*z
}


#declare Lamp_Orange1 = union {
  object { Recept_Verde1 }
  object { Roseta1 }
  object { Bulbo1 }
  cylinder { // Filamento1
    <0,0,1>, <0,0,0>, 1
    texture {
      T_Filamento
    }
    scale <0.0003, 0.0003, 0.005>
    translate  0.028*z
  }
  sphere { // Halo1
    <0,0,0>,1
    texture {
      T_Halo_Naranja
    }
    hollow
    scale 0.06
    rotate -157.90831*x
    translate  <-0.000022, 0.000172, 0.034593>
  }
  scale 100.0
  rotate 178.72438*x
  translate  <-12.294675, -39.425715, 33.000621>
}


#declare Recept_Verde2 = union {
  cylinder { // Cylndr64
    <0,0,1>, <0,0,0>, 1
    scale <0.0035, 0.0035, 0.008>
  }
  cylinder { // Cylndr65
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.01>
    translate  0.008*z
  }
  texture {
    T_Plastico_Verde
  }
}


#declare Anillo2 = difference {
  cylinder { // Cylndr66
    <0,0,1>, <0,0,0>, 1
    scale <0.0055, 0.0055, 0.006>
    translate  0.013002*z
  }
  cylinder { // Cylndr67
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.008>
    translate  <-0.000145, 0.0, 0.012>
  }
}


#declare Roseta2 = union {
  object { Anillo2 }
  cylinder { // Cylndr68
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.002, 0.001>
    rotate -38.610817*y
    translate  <0.008805, 0.0, 0.02087>
  }
  object { // Cylndr69->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -22.5>
    translate  -0.0*y
  }
  object { // Cylndr70->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr71->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -67.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr72->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr73->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -112.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr74->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -135.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr75->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -157.5>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr76->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr77->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 157.5>
    translate  0.0*y
  }
  object { // Cylndr78->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 135.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr79->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 112.5>
    translate  0.0*x
  }
  object { // Cylndr80->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 90.0>
    translate  0.0*x
  }
  object { // Cylndr81->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 67.5>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr82->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr83->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 22.5>
    translate  <-0.0, -0.0, 0.0>
  }
  texture {
    T_Plast_Transp
  }
}


//   ****  Bulb2


#declare Bulbo2 = object {
  Bulbo_Raw
  texture {
    T_Bulbo_Rojo
  }
  hollow
  translate  0.0175*z
}


#declare Lamp_Red1 = union {
  object { Recept_Verde2 }
  object { Roseta2 }
  object { Bulbo2 }
  cylinder { // Filamento2
    <0,0,1>, <0,0,0>, 1
    texture {
      T_Filamento
    }
    scale <0.0003, 0.0003, 0.005>
    translate  0.028*z
  }
  sphere { // Halo2
    <0,0,0>,1
    texture {
      T_Halo_Rojo
    }
    hollow
    scale 0.06
    rotate -157.90831*x
    translate  <-0.000022, 0.000172, 0.034593>
  }
  scale 100.0
  rotate <157.90831, -88.147194, 38.837082>
  translate  <-5.132481, -10.890879, 34.524035>
}


#declare Recept_Verde3 = union {
  cylinder { // Cylndr84
    <0,0,1>, <0,0,0>, 1
    scale <0.0035, 0.0035, 0.008>
  }
  cylinder { // Cylndr85
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.01>
    translate  0.008*z
  }
  texture {
    T_Plastico_Verde
  }
}


#declare Anillo3 = difference {
  cylinder { // Cylndr86
    <0,0,1>, <0,0,0>, 1
    scale <0.0055, 0.0055, 0.006>
    translate  0.013002*z
  }
  cylinder { // Cylndr87
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.008>
    translate  <-0.000145, 0.0, 0.012>
  }
}


#declare Roseta3 = union {
  object { Anillo3 }
  cylinder { // Cylndr88
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.002, 0.001>
    rotate -38.610817*y
    translate  <0.008805, 0.0, 0.02087>
  }
  object { // Cylndr89->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -22.5>
    translate  -0.0*y
  }
  object { // Cylndr90->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr91->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -67.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr92->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr93->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -112.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr94->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -135.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr95->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -157.5>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr96->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr97->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 157.5>
    translate  0.0*y
  }
  object { // Cylndr98->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 135.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr99->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 112.5>
    translate  0.0*x
  }
  object { // Cylndr100->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 90.0>
    translate  0.0*x
  }
  object { // Cylndr101->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 67.5>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr102->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr103->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 22.5>
    translate  <-0.0, -0.0, 0.0>
  }
  texture {
    T_Plast_Transp
  }
}


//   ****  Bulb3


#declare Bulbo3 = object {
  Bulbo_Raw
  texture {
    T_Bulbo_Verde
  }
  hollow
  translate  0.0175*z
}


#declare Lamp_Green1 = union {
  object { Recept_Verde3 }
  object { Roseta3 }
  object { Bulbo3 }
  cylinder { // Filamento3
    <0,0,1>, <0,0,0>, 1
    texture {
      T_Filamento
    }
    scale <0.0003, 0.0003, 0.005>
    translate  0.028*z
  }
  sphere { // Halo3
    <0,0,0>,1
    texture {
      T_Halo_Verde
    }
    hollow
    scale 0.06
    rotate -157.90831*x
    translate  <-0.000022, 0.000172, 0.034593>
  }
  scale 100.0
  rotate <157.90831, -25.527573, 0.0>
  translate  <-6.435316, -25.608655, 34.147541>
}


#declare Recept_Verde4 = union {
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1
    scale <0.0035, 0.0035, 0.008>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.01>
    translate  0.008*z
  }
  texture {
    T_Plastico_Verde
  }
}


#declare Anillo4 = difference {
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1
    scale <0.0055, 0.0055, 0.006>
    translate  0.013002*z
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.008>
    translate  <-0.000145, 0.0, 0.012>
  }
}


#declare Roseta4 = union {
  object { Anillo4 }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.002, 0.001>
    rotate -38.610817*y
    translate  <0.008805, 0.0, 0.02087>
  }
  object { // Cylndr109->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -22.5>
    translate  -0.0*y
  }
  object { // Cylndr110->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr111->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -67.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr112->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr113->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -112.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr114->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -135.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr115->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -157.5>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr116->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr117->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 157.5>
    translate  0.0*y
  }
  object { // Cylndr118->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 135.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr119->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 112.5>
    translate  0.0*x
  }
  object { // Cylndr120->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 90.0>
    translate  0.0*x
  }
  object { // Cylndr121->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 67.5>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr122->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr123->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 22.5>
    translate  <-0.0, -0.0, 0.0>
  }
  texture {
    T_Plast_Transp
  }
}


//   ****  Bulb4


#declare Bulbo4 = object {
  Bulbo_Raw
  texture {
    T_Bulbo_Verde
  }
  hollow
  translate  0.0175*z
}


#declare Lamp_Green2 = union {
  object { Recept_Verde4 }
  object { Roseta4 }
  object { Bulbo4 }
  cylinder { // Filamento4
    <0,0,1>, <0,0,0>, 1
    texture {
      T_Filamento
    }
    scale <0.0003, 0.0003, 0.005>
    translate  0.028*z
  }
  sphere { // Halo4
    <0,0,0>,1
    texture {
      T_Halo_Verde
    }
    hollow
    scale 0.06
    rotate -157.90831*x
    translate  <-0.000022, 0.000172, 0.034593>
  }
  scale 100.0
  rotate <157.90831, -11.687662, -0.0>
  translate  <-22.130064, 10.360042, 57.27121>
}


#declare Recept_Verde5 = union {
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1
    scale <0.0035, 0.0035, 0.008>
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.01>
    translate  0.008*z
  }
  texture {
    T_Plastico_Verde
  }
}


#declare Anillo5 = difference {
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1
    scale <0.0055, 0.0055, 0.006>
    translate  0.013002*z
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.008>
    translate  <-0.000145, 0.0, 0.012>
  }
}


#declare Roseta5 = union {
  object { Anillo5 }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.002, 0.001>
    rotate -38.610817*y
    translate  <0.008805, 0.0, 0.02087>
  }
  object { // Cylndr129->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -22.5>
    translate  -0.0*y
  }
  object { // Cylndr130->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr131->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -67.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr132->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr133->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -112.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr134->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -135.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr135->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -157.5>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr136->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr137->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 157.5>
    translate  0.0*y
  }
  object { // Cylndr138->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 135.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr139->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 112.5>
    translate  0.0*x
  }
  object { // Cylndr140->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 90.0>
    translate  0.0*x
  }
  object { // Cylndr141->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 67.5>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr142->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr143->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 22.5>
    translate  <-0.0, -0.0, 0.0>
  }
  texture {
    T_Plast_Transp
  }
}


//   ****  Bulb5


#declare Bulbo5 = object {
  Bulbo_Raw
  texture {
    T_Bulbo_Rojo
  }
  hollow
  translate  0.0175*z
}


#declare Lamp_Red2 = union {
  object { Recept_Verde5 }
  object { Roseta5 }
  object { Bulbo5 }
  cylinder { // Filamento5
    <0,0,1>, <0,0,0>, 1
    texture {
      T_Filamento
    }
    scale <0.0003, 0.0003, 0.005>
    translate  0.028*z
  }
  sphere { // Halo5
    <0,0,0>,1
    texture {
      T_Halo_Rojo
    }
    hollow
    scale 0.06
    rotate -157.90831*x
    translate  <-0.000022, 0.000172, 0.034593>
  }
  scale 100.0
  rotate <157.90831, -24.673101, 0.0>
  translate  <-20.29333, -45.339095, 40.607793>
}


#declare Recept_Verde6 = union {
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1
    scale <0.0035, 0.0035, 0.008>
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.01>
    translate  0.008*z
  }
  texture {
    T_Plastico_Verde
  }
}


#declare Anillo6 = difference {
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1
    scale <0.0055, 0.0055, 0.006>
    translate  0.013002*z
  }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.008>
    translate  <-0.000145, 0.0, 0.012>
  }
}


#declare Roseta6 = union {
  object { Anillo6 }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.002, 0.001>
    rotate -38.610817*y
    translate  <0.008805, 0.0, 0.02087>
  }
  object { // Cylndr149->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -22.5>
    translate  -0.0*y
  }
  object { // Cylndr150->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr151->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -67.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr152->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr153->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -112.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr154->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -135.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr155->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -157.5>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr156->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr157->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 157.5>
    translate  0.0*y
  }
  object { // Cylndr158->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 135.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr159->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 112.5>
    translate  0.0*x
  }
  object { // Cylndr160->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 90.0>
    translate  0.0*x
  }
  object { // Cylndr161->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 67.5>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr162->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr163->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 22.5>
    translate  <-0.0, -0.0, 0.0>
  }
  texture {
    T_Plast_Transp
  }
}


//    ****  Bulb6


#declare Bulbo6 = object {
  Bulbo_Raw
  texture {
    T_Bulbo_Naranja
  }
  hollow
  translate  0.0175*z
}


#declare Lamp_Orange2 = union {
  object { Recept_Verde6 }
  object { Roseta6 }
  object { Bulbo6 }
  cylinder { // Filamento6
    <0,0,1>, <0,0,0>, 1
    texture {
      T_Filamento
    }
    scale <0.0003, 0.0003, 0.005>
    translate  0.028*z
  }
  sphere { // Halo6
    <0,0,0>,1
    texture {
      T_Halo_Naranja
    }
    hollow
    scale 0.06
    rotate -157.90831*x
    translate  <-0.000022, 0.000172, 0.034593>
  }
  scale 100.0
  rotate <-22.09169, -84.788795, 180.0>
  translate  <-9.343459, -18.836355, 47.433354>
}


#declare Recept_Verde7 = union {
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1
    scale <0.0035, 0.0035, 0.008>
  }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.01>
    translate  0.008*z
  }
  texture {
    T_Plastico_Verde
  }
}


#declare Anillo7 = difference {
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1
    scale <0.0055, 0.0055, 0.006>
    translate  0.013002*z
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1
    scale <0.0045, 0.0045, 0.008>
    translate  <-0.000145, 0.0, 0.012>
  }
}


#declare Roseta7 = union {
  object { Anillo7 }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.002, 0.001>
    rotate -38.610817*y
    translate  <0.008805, 0.0, 0.02087>
  }
  object { // Cylndr169->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -22.5>
    translate  -0.0*y
  }
  object { // Cylndr170->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr171->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -67.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr172->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr173->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, -112.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr174->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -135.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr175->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -157.5>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr176->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, -180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr177->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 157.5>
    translate  0.0*y
  }
  object { // Cylndr178->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 135.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr179->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 112.5>
    translate  0.0*x
  }
  object { // Cylndr180->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 90.0>
    translate  0.0*x
  }
  object { // Cylndr181->Cylndr003
    Cylndr003
    rotate <-0.0, 0.0, 67.5>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr182->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 45.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr183->Cylndr003
    Cylndr003
    rotate <0.0, 0.0, 22.5>
    translate  <-0.0, -0.0, 0.0>
  }
  texture {
    T_Plast_Transp
  }
}


//   ****  Bulb7


#declare Bulbo7 = object {
  Bulbo_Raw
  texture {
    T_Bulbo_Azul
  }
  hollow
  translate  0.0175*z
}


#declare Lamp_Blue2 = union {
  object { Recept_Verde7 }
  object { Roseta7 }
  object { Bulbo7 }
  cylinder { // Filamento7
    <0,0,1>, <0,0,0>, 1
    texture {
      T_Filamento
    }
    scale <0.0003, 0.0003, 0.005>
    translate  0.028*z
  }
  sphere { // Halo7
    <0,0,0>,1
    texture {
      T_Halo_Azul
    }
    hollow
    scale 0.06
    rotate -157.90831*x
    translate  <-0.000022, 0.000172, 0.034593>
  }
  scale 100.0
  rotate <157.90831, -57.690144, -0.0>
  translate  <-12.932921, -33.049874, 44.966521>
}


//    ****  Balls Christmas


#declare Cilindro = difference {
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1
    scale 0.8
    translate  2.95*z
  }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1
    scale <0.35, 0.35, 1.0>
    translate  3.0*z
  }
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1
    scale 0.7
    translate  3.0*z
  }
  texture {
    T_Gold_Rug
  }
  translate  0.001*z
}


#declare Ball_Yellow = union {
  sphere { // Sphere2
    <0,0,0>,1
    texture {
      T_Ball_Yellow
    }
    scale 3.0
  }
  object { Cilindro }
  torus { // Torus001
    0.5, 0.04  rotate -x*90
    texture {
      T_Gold_Rug
    }
    rotate 90.0*x
    translate  4.2*z
  }
  translate  <-17.518566, 13.26396, 42.51752>
}


#declare Cilindro1 = difference {
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1
    scale 0.8
    translate  2.95*z
  }
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1
    scale <0.35, 0.35, 1.0>
    translate  3.0*z
  }
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1
    scale 0.7
    translate  3.0*z
  }
  texture {
    T_Gold_Rug
  }
  translate  0.001*z
}


#declare Ball_Blue = union {
  sphere { // Sphere4
    <0,0,0>,1
    texture {
      T_Ball_Blue
    }
    scale 3.0
  }
  object { Cilindro1 }
  torus { // Torus2
    0.5, 0.04  rotate -x*90
    texture {
      T_Gold_Rug
    }
    rotate 90.0*x
    translate  4.2*z
  }
  scale 0.6
  translate  <-10.95098, -37.687903, 38.987323>
}


#declare Cilindro2 = difference {
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1
    scale 0.8
    translate  2.95*z
  }
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1
    scale <0.35, 0.35, 1.0>
    translate  3.0*z
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1
    scale 0.7
    translate  3.0*z
  }
  texture {
    T_Gold_Rug
  }
  translate  0.001*z
}


#declare Ball_Red = union {
  sphere { // Sphere5
    <0,0,0>,1
    texture {
      T_Ball_Red
    }
    scale 3.0
  }
  object { Cilindro2 }
  torus { // Torus3
    0.5, 0.04  rotate -x*90
    texture {
      T_Gold_Rug
    }
    rotate 90.0*x
    translate  4.2*z
  }
  rotate -20.0*z
  translate  <-22.896756, 31.339286, 27.011348>
}


#declare Cilindro3 = difference {
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1
    scale 0.8
    translate  2.95*z
  }
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1
    scale <0.35, 0.35, 1.0>
    translate  3.0*z
  }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1
    scale 0.7
    translate  3.0*z
  }
  texture {
    T_Gold_Rug
  }
  translate  0.001*z
}


#declare Ball_Red_Gilt = union {
  sphere { // Sphere6
    <0,0,0>,1
    texture {
      T_Ball_Red_Gilt
    }
    scale 3.0
  }
  object { Cilindro3 }
  torus { // Torus4
    0.5, 0.04  rotate -x*90
    texture {
      T_Gold_Rug
    }
    rotate 90.0*x
    translate  4.2*z
  }
  rotate -30.0*z
  translate  <-21.639031, -39.322953, 49.441219>
}


//   ****  Balls broken

#declare Ball_Broken_1 = difference {
  sphere { // Sphere3
    <0,0,0>,1
    texture {
      T_Ball_Broken_Ext
    }
    scale 3.0
    rotate 20.0*x
    translate  <1.8, 23.3, 13.8>
  }
  sphere { // Sphere7
    <0,0,0>,1
    texture {
      T_Ball_Broken_Int
    }
    scale 2.98
    rotate 20.0*x
    translate  <1.8, 23.3, 13.8>
  }
}


#declare Ball_Broken_2 = difference {
  sphere { // Sphere003
    <0,0,0>,1
    texture {
      T_Ball_Broken_Ext2
    }
    scale 3.0
    translate  <-2.0, 18.0, 13.8>
  }
  sphere { // Sphere004
    <0,0,0>,1
    texture {
      T_Ball_Broken_Int2
    }
    scale 2.98
    translate  <-2.0, 18.0, 13.8>
  }
}


#declare Balls = union {
  object { Ball_Yellow }
  object { Ball_Blue }
  object { Ball_Red }
  object { Ball_Red_Gilt }
  object { Ball_Broken_1 }
  object { Ball_Broken_2 }
}


//   ****  Adornment Christmas, Cane


#declare CSG001 = difference {
  torus { // Torus5
    1.5, 0.4  rotate -x*90
    rotate 90.0*x
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 1.0>
    translate  -1.0*z
  }
}


#declare Adorn1 = union {
  object { CSG001 }
  sphere { // Sphere8
    <0,0,0>,1
    scale 0.4
    translate  <1.5, 0.0, -5.5>
  }
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1
    scale <0.4, 0.4, 5.5>
    translate  <1.5, 0.0, -5.5>
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.4
    translate  -1.5*x
  }
  texture {
    T_Baston
  }
  scale 0.8
  rotate <-30.0, 0.0, 34.649891>
  translate  <-7.540433, -28.438805, 35.342536>
}


//   ****  Element created by the program Helixir


#include "adorno1.inc"

#declare Helix_Ref = object {
  Helix
  texture {
    T_Adorn_Black_Gilt
  }
  scale 0.1
  translate  <-3.067894, 0.0385, -2.056449>
}


#declare Adorn2 = union {
  object { Helix_Ref }
  torus { // Torus6
    0.3, 0.04  rotate -x*90
    texture {
      T_Gold_Rug
    }
    rotate 90.0*x
    translate  <-3.066605, 0.0, 1.797365>
  }
  scale 0.9
  rotate -40.0*z
  translate  <-14.656906, -36.184291, 52.745948>
}


//    ****  Stockings of christmas


#declare HF1 = object {
  height_field {
    gif "hf_stoc1.gif"
    water_level 0.01
  }
  rotate    <-90, 0, 0>
  scale     <  2, 2,-2>
  translate < -1,-1,-1>
  texture {
    T_Stocking1
  }
  scale <3.3, 5.0, 0.1>
  rotate 90.0*x
  translate  -12.0*x
}


#declare CSG2 = difference {
  torus { // Torus8
    0.045, 0.005  rotate -x*90
    rotate 90.0*x
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale 0.06
    translate  0.06*z
  }
}


#declare CSG002 = difference {
  torus { // Torus003
    0.3, 0.005  rotate -x*90
    rotate 90.0*x
    translate  3.0*z
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale 0.6
    translate  2.4*z
  }
}


#declare Cuerda1 = union {
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.005, 3.012>
    rotate -4.853692*y
    translate  <-0.044895, 0.0, -0.000731>
  }
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.005, 3.012>
    rotate 4.85369*y
    translate  <0.045105, 0.0, -0.000731>
  }
  object { CSG2 }
  object { CSG002 }
  texture {
    T_Aro
  }
  rotate -70.0*z
  translate  <-12.001462, 0.0, 5.49444>
}


#declare Stocking1 = union {
  object { HF1 }
  torus { // Torus7
    0.25, 0.04  rotate -x*90
    texture {
      T_Aro
    }
    scale <1.0, 1.0, 0.5>
    rotate 90.0*x
    translate  <-12.0, 0.0, 5.25>
  }
  object { Cuerda1 }
  rotate 51.385582*z
  translate  <-10.500875, -39.557403, 27.901687>
}


#declare HF2 = object {
  height_field {
    gif "hf_stoc2.gif"
    water_level 0.01
  }
  rotate    <-90, 0, 0>
  scale     <  2, 2,-2>
  translate < -1,-1,-1>
  texture {
    T_Stocking2
  }
  scale <3.3, 5.0, 0.1>
  rotate 90.0*x
  translate  -4.0*x
}


#declare CSG3 = difference {
  torus { // Torus10
    0.045, 0.005  rotate -x*90
    rotate 90.0*x
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale 0.06
    translate  0.06*z
  }
}


#declare CSG4 = difference {
  torus { // Torus11
    0.3, 0.005  rotate -x*90
    rotate 90.0*x
    translate  3.0*z
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale 0.6
    translate  2.4*z
  }
}


#declare Cuerda2 = union {
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.005, 3.012>
    rotate -4.853692*y
    translate  <-0.044895, 0.0, -0.000731>
  }
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.005, 3.012>
    rotate 4.85369*y
    translate  <0.045105, 0.0, -0.000731>
  }
  object { CSG3 }
  object { CSG4 }
  texture {
    T_Aro
  }
  rotate -70.0*z
  translate  <-3.599488, 0.0, 5.4939>
}


#declare Stocking2 = union {
  object { HF2 }
  torus { // Torus9
    0.25, 0.04  rotate -x*90
    texture {
      T_Aro
    }
    scale <1.0, 1.0, 0.5>
    rotate 90.0*x
    translate  <-3.6, 0.0, 5.25>
  }
  object { Cuerda2 }
  rotate 60.546597*z
  translate  <-12.485055, -37.455147, 39.286336>
}


#declare HF3 = object {
  height_field {
    gif "hf_stoc3.gif"
    water_level 0.01
  }
  rotate    <-90, 0, 0>
  scale     <  2, 2,-2>
  translate < -1,-1,-1>
  texture {
    T_Stocking3
  }
  scale <2.8, 6.0, 0.1>
  rotate 90.0*x
  translate  4.0*x
}


#declare CSG5 = difference {
  torus { // Torus13
    0.045, 0.005  rotate -x*90
    rotate 90.0*x
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale 0.06
    translate  0.06*z
  }
}


#declare CSG6 = difference {
  torus { // Torus14
    0.3, 0.005  rotate -x*90
    rotate 90.0*x
    translate  3.0*z
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale 0.6
    translate  2.4*z
  }
}


#declare Cuerda3 = union {
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.005, 3.012>
    rotate -4.853692*y
    translate  <-0.044895, 0.0, -0.000731>
  }
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.005, 3.012>
    rotate 4.85369*y
    translate  <0.045105, 0.0, -0.000731>
  }
  object { CSG5 }
  object { CSG6 }
  texture {
    T_Aro
  }
  rotate -70.0*z
  translate  <3.281909, 0.0, 5.79203>
}


#declare Stocking3 = union {
  object { HF3 }
  torus { // Torus12
    0.25, 0.04  rotate -x*90
    texture {
      T_Aro
    }
    scale <1.0, 1.0, 0.5>
    rotate 90.0*x
    translate  <3.282525, 0.0, 5.546934>
  }
  object { Cuerda3 }
  rotate <0.0, -0.0, 11.953938>
  translate  <-4.224544, -26.18785, 31.632354>
}


#declare HF4 = object {
  height_field {
    gif "hf_stoc4.gif"
    water_level 0.01
  }
  rotate    <-90, 0, 0>
  scale     <  2, 2,-2>
  translate < -1,-1,-1>
  texture {
    T_Stocking4
  }
  scale <3.3, 5.0, 0.1>
  rotate 90.0*x
  translate  12.0*x
}


#declare CSG7 = difference {
  torus { // Torus16
    0.045, 0.005  rotate -x*90
    rotate 90.0*x
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale 0.06
    translate  0.06*z
  }
}


#declare CSG8 = difference {
  torus { // Torus17
    0.3, 0.005  rotate -x*90
    rotate 90.0*x
    translate  3.0*z
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale 0.6
    translate  2.4*z
  }
}


#declare Cuerda4 = union {
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.005, 3.012>
    rotate -4.853692*y
    translate  <-0.044895, 0.0, -0.000731>
  }
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.005, 3.012>
    rotate 4.85369*y
    translate  <0.045105, 0.0, -0.000731>
  }
  object { CSG7 }
  object { CSG8 }
  texture {
    T_Aro
  }
  rotate -70.0*z
  translate  <12.000235, 0.0, 5.49444>
}


#declare Stocking4 = union {
  object { HF4 }
  torus { // Torus15
    0.25, 0.04  rotate -x*90
    texture {
      T_Aro
    }
    scale <1.0, 1.0, 0.5>
    rotate 90.0*x
    translate  <12.0, 0.0, 5.25>
  }
  object { Cuerda4 }
  rotate 29.360704*z
  translate  <-19.596678, -22.078551, 51.790631>
}


#declare Adorn3 = union {
  object { Stocking1 }
  object { Stocking2 }
  object { Stocking3 }
  object { Stocking4 }
}


//   ****  Tree, Lamps, Cable and Adornments


union {
  object { Tree }
  object { // Cable9->Cable8
    Cable8_Ref
    rotate <6.858742, -16.18049, -11.693754>
    translate  <7.515389, -7.115632, 17.192188>
  }
  object { Cable8_Ref }
  object { Lamp_Blue1 }
  object { Lamp_Orange1 }
  object { Lamp_Red1 }
  object { Lamp_Green1 }
  object { Lamp_Green2 }
  object { Lamp_Red2 }
  object { Lamp_Orange2 }
  object { Lamp_Blue2 }
  object { Balls }
  object { Adorn1 }
  object { Adorn2 }
  object { Adorn3 }
}

