#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

#declare ball = difference
{
sphere
{
    <0, 0, 0> 2
    }
    cylinder
    {
    <0,0,-10><0,0,10> 0.075}
    pigment { P_Chrome3} finish {F_MetalC}
}

#declare link = difference
{
    torus
    {
        1, 0.5
    }
    box
    {
        <0, -10, -10> <10, 10, 10>
    }
    box
    {
        <-10, -10, -10> <10, 10, 0>
    }
}

//
// Build the frame of the cradle...
//

#declare frame = union
{
    //
    // front left verticle
    //

    cylinder
    {
        <0.5, 1.5, 0.5> <0.5, 12.5, 0.5> 0.5
    }

    object
    {
        link
        rotate <90,0,0>
        rotate <0,-90,0>
        translate <0.5,1.5,1.5>
    }

    //
    // left bottom horizontal front to back
    //

    cylinder
    {
        <0.5, 0.5, 1.5> <0.5, 0.5, 12.5> 0.5
    }

    object
    {
        link
        rotate <90,0,0>
        rotate <0,90,0>
        translate <0.5,1.5,12.5>
    }

    //
    // back left verticle
    //

    cylinder
    {
        <0.5, 1.5, 13.5> <0.5, 12.5, 13.5> 0.5
    }

    object
    {
        link
        rotate <90,0,0>
        rotate <0,0,-90>
        translate <1.5,12.5,0.5>
    }

    //
    // back horizontal left to right
    //

    difference
    {
        cylinder
        {
            <1.5, 13.5, 13.5> <22.5, 13.5, 13.5> 0.5
        }

        //
        // and the holes...
        //

        cylinder
        {
            <4, 13.5, 12> <4, 13.5, 15> 0.2
        }
        cylinder
        {
            <8, 13.5, 12> <8, 13.5, 15> 0.2
        }
        cylinder
        {
            <12, 13.5, 12> <12, 13.5, 15> 0.2
        }
        cylinder
        {
            <16, 13.5, 12> <16, 13.5, 15> 0.2
        }
        cylinder
        {
            <20, 13.5, 12> <20, 13.5, 15> 0.2
        }
    }

    object
    {
        link
        rotate <90,0,0>
        rotate <0,0,-90>
        translate <1.5,12.5,13.5>
    }

    //
    // right back verticle
    //

    cylinder
    {
        <23.5, 1.5, 13.5> <23.5, 12.5, 13.5> 0.5
    }

    object
    {
        link
        rotate <90,0,0>
        rotate <0,90,0>
        translate <23.5,1.5,12.5>
    }

    //
    // right horizontal back to front
    //

    difference
    {
        cylinder
        {
            <23.5, 0.5, 1.5> <23.5, 0.5, 12.5> 0.5
        }
        box
        {
            <22, -1, 6> <26,2,8>
        }
    }

    sphere
    {
        <23.5, 0.5, 6> 0.5
    }

    sphere
    {
        <23.5, 0.5, 8> 0.5
    }

    object
    {
        link
        rotate <90,0,0>
        rotate <0,-90,0>
        translate <23.5,1.5,1.5>
    }

    //
    // front right verticle
    //

    cylinder
    {
        <23.5, 1.5, 0.5> <23.5, 12.5, 0.5> 0.5
    }

    object
    {
        link
        rotate <90,0,0>
        rotate <0,180,0>
        rotate <0,0,90>
        translate <22.5,12.5,13.5>
    }

    //
    // front horizontal right to left
    //

    difference
    {
        cylinder
        {
            <1.5, 13.5, 0.5> <22.5, 13.5, 0.5> 0.5
        }

        //
        // and the holes...
        //

        cylinder
        {
            <4, 13.5, -1> <4, 13.5, 2> 0.2
        }
        cylinder
        {
            <8, 13.5, -1> <8, 13.5, 2> 0.2
        }
        cylinder
        {
            <12, 13.5, -1> <12, 13.5, 2> 0.2
        }
        cylinder
        {
            <16, 13.5, -1> <16, 13.5, 2> 0.2
        }
        cylinder
        {
            <20, 13.5, -1> <20, 13.5, 2> 0.2
        }
    }

    object
    {
        link
        rotate <90,0,0>
        rotate <0,180,0>
        rotate <0,0,90>
        translate <22.5,12.5,0.5>
    }

  pigment { P_Chrome3} finish {F_MetalC}
  }


#declare plug = union
{
    difference
    {
        sphere
        {
            <0,0,-0.3> 0.4
        }
        box
        {
            <-5,-5,-0.5>, <5,5,5>
        }
        cylinder
        {
            <0,0,-5>,<0,0,0.25> 0.1
        }
    }
    difference
    {
        cylinder
        {
            <0,0,-0.5><0,0,0.5> 0.19
        }
        cylinder
        {
            <0,0,-5>,<0,0,0.25> 0.1
        }
        cylinder
        {
            <0,0,-5>,<0,0,5> 0.05
        }
    }
    pigment { Black} finish { Dull }
}

#declare string = union
{
    cylinder
    {
        <0,4,5> <0,4,9> 0.05
    }
    cylinder
    {
        <0,13.5,0.25> <0,13.5,1> 0.05
    }
    cylinder
    {
        <0,13.5,13> <0,13.5,13.75> 0.05
    }
    cylinder
    {
        <0,13.5,1> <0,4,5> 0.05
    }
    sphere
    {
        <0,13.5,1> 0.05
    }
    sphere
    {
        <0,4,5> 0.05
    }
    cylinder
    {
        <0,4,9> <0,13.5,13> 0.05
    }
    sphere
    {
        <0,4,9> 0.05
    }
    sphere
    {
        <0,13.5,13> 0.05
    }


    pigment
    {
        colour rgb <0.1, 0.05, 0.1>
    }
}

#declare toy = union
{
object {frame}
object {ball translate <4, 4, 7>}
object {ball translate <8, 4, 7>}
object {ball translate <12, 4, 7>}
object {ball translate <16, 4, 7>}
object {ball translate <20, 4, 7>}
object {plug translate <4,13.5, 0.5>}
object {plug translate <8,13.5, 0.5>}
object {plug translate <12,13.5, 0.5>}
object {plug translate <16,13.5, 0.5>}
object {plug translate <20,13.5, 0.5>}
object {plug rotate <0,180,0> translate <4,13.5, 13.5>}
object {plug rotate <0,180,0> translate <8,13.5, 13.5>}
object {plug rotate <0,180,0> translate <12,13.5, 13.5>}
object {plug rotate <0,180,0> translate <16,13.5, 13.5>}
object {plug rotate <0,180,0> translate <20,13.5, 13.5>}
object {string translate <4,0,0>}
object {string translate <8,0,0>}
object {string translate <12,0,0>}
object {string translate <16,0,0>}
object {string translate <20,0,0>}
}

#declare newtons_cradle = union {
object {toy translate <0,0.2,0>}

cylinder {<0.5, 0, 3> <0.5, 0.3, 3> 0.5 pigment { Black} finish { Dull }}
cylinder {<0.5, 0, 11> <0.5, 0.3, 11> 0.5 pigment { Black} finish { Dull }}
cylinder {<23.5, 0, 3> <23.5, 0.3, 3> 0.5 pigment { Black} finish { Dull }}
cylinder {<23.5, 0, 11> <23.5, 0.3, 11> 0.5 pigment { Black} finish { Dull }}

}

