//Man posed picking up a Phi
//(C) 1998 Ben Jackson

//parameters to locate and rotate objects
//required by "man.inc"                                     

#declare theta = 0;
#declare iota = -90;
#declare rot1 = <cos(theta), cos(iota), sin(theta)>;
#declare rot2 = <sin(theta)*sin(iota), 0, cos(theta)*sin(iota)>;

#declare torso = <0,6,0>;
#declare left_hip = torso + <2,-2,0>;
#declare right_hip = torso + <-2,-2,0>;
#declare left_shoulder = torso + <2,2,2>*rot1 + <2,2,2> * rot2;
#declare right_shoulder = torso + <-2,2,-2>*rot1 + <2,2,2> * rot2;
#declare chest = torso + <0,2,0>*rot1 + <2,2,2> * rot2;
#declare hips = torso + <0,-3,0>;
 
//universal legs
#declare lower_leg = <0,3,0>;
#declare upper_leg = <0,3,0>;
#declare lower_thickness = .5;
#declare upper_thickness = .4; 

//right leg
#declare right_shoe_rotate = <40,0,10>;
#declare right_knee_bend = <-90,0,0>;
#declare right_leg_rotate = <50,25,-10>;

//left leg
#declare left_shoe_rotate = <40,0,-10>;
#declare left_knee_bend = <-90,0,0>;
#declare left_leg_rotate = <50,-25,10>;

//head 
#declare head_rotate = <-60,0,0>;
#declare head_location = <0,7,-4>;

//Eyes
#declare eye_dialation = .452;

#declare left_eye_size = <2,2,2>;
#declare left_eye_rotate=<-120,20,0>;
#declare left_eye_upper = 0;
#declare r_left_eye_upper = <0,0,-10>;
#declare left_eye_lower = .25;
#declare r_left_eye_lower = <0,0,15>;
#declare left_eye_brow = <0,0,0>;

#declare right_eye_size = <2,2,2>;
#declare right_eye_rotate=<-120,-20,0>;
#declare right_eye_upper = 0;
#declare r_right_eye_upper = <0,0,10>;
#declare right_eye_lower = .25;
#declare r_right_eye_lower = <0,0,-15>;
#declare right_eye_brow = <0,0,0>;

//arm settings
#declare lower_arm = 2;
#declare lower_arm_thickness = .4;
#declare upper_arm = 3;
#declare upper_arm_thickness = .3;

//left hand
#declare r_left_thumb_01 = <0,0,-5>;
#declare r_left_thumb = <-10,0,30>;
#declare r_left_index_01 = <-20,0,0>;
#declare r_left_index_02 = <-10,0,0>;
#declare r_left_index_03 = <-15,0,-5>;
#declare r_left_middle_01 = <-20,0,0>;
#declare r_left_middle_02 = <-15,0,0>;
#declare r_left_middle_03 = <-20,0,0>;
#declare r_left_pinky_01 = <-15,0,0>;
#declare r_left_pinky_02 = <-25,0,0>;
#declare r_left_pinky_03 = <-15,0,5>;

//left_arm
#declare r_left_hand = <-5,0,0>;
#declare r_left_lower_arm = <-10,90,-5>;
#declare r_left_arm = <-150,0,0>;

//right hand
#declare r_right_thumb_01 = <0,0,5>;
#declare r_right_thumb = <-10,0,-30>;
#declare r_right_index_01 = <-20,0,0>;
#declare r_right_index_02 = <-10,0,0>;
#declare r_right_index_03 = <-10,0,5>;
#declare r_right_middle_01 = <-20,0,0>;
#declare r_right_middle_02 = <-20,0,0>;
#declare r_right_middle_03 = <-15,0,0>;
#declare r_right_pinky_01 = <-20,0,0>;
#declare r_right_pinky_02 = <-25,0,0>;
#declare r_right_pinky_03 = <-20,0,-.5>;

//right arm
#declare r_right_hand = <-5,0,0>;
#declare r_right_lower_arm = <-10,-90,5>;
#declare r_right_arm = <-150,0,0>;


#include "colors.inc"
#include "man_texture.inc"
#include "man.inc"

camera {location<-.5,-7,-8> look_at<0,4,-4>}

light_source {<-.5,-7,-8> color rgb <.8,.8,.8> 
  media_interaction off
  area_light x,z,3,3
  adaptive 2
  jitter
}
 
media {
  intervals 40
  scattering {2, rgb 0.02}
  samples 1, 20
  confidence 1/1000
  ratio 0.9
}


object {man}

//Light from ball

light_source {
  <0,0.05,-5> 
  color rgb<1,1,0> 
  media_interaction off  
  fade_distance 4 
  fade_power 2
}
//light_source {
//  <0.025,0.025,-5> 
//  color rgb<1,1,.2> 
//  media_interaction off 
//  fade_distance 6 
//  fade_power 2
//}
light_source {
  <0,0,-5> 
  color rgb<1,1,.5> 
  media_interaction on 
  media_attenuation on 
  fade_distance 10 
  fade_power 2
}
                                                                                              
sphere {<0,0,-5>,1
      hollow 
      texture{
       finish {ambient .8 diffuse .2}
       pigment {
         agate
         color_map{
          [0.0 rgbt<.2,0,.3,1>]
          [0.7 rgbt<.2,0,.3,1>]
          [0.75 rgbt<.2,0,.3,.3>]
          [0.85 rgbt<.2,0,.3,.3>]
          [0.9 rgbt<.2,0,.3,1>]
          [1.0 rgbt<.2,0,.3,1>]
         }  
       }
      }   
      interior{
       media{
         scattering {.2,.05}
         emission .6
         density {
          agate
          scale .1
          color_map{
           [0.0 rgb<1,.8,0>]
           [0.5 rgb<1,1,0>]
           [0.9 rgb<1,1,1>]
           [1.0 rgb<0,0,1>]
          }
         }        
       }
      }
}

box {<-10,-10,-3.5> <10,-1.6,10> 
 texture {
  pigment {color rgb<.5,.2,.2>}
  normal {bumps .2 scale .02}
  finish {diffuse .4 reflection .5}}
}
box {<-15,-10,-20> <-5,10,20> 
 texture {
  pigment {color rgb<.5,.2,.2>}}
  normal {bumps .1 scale .06}
  finish {diffuse .2 reflection .5}
}
box {<5,-10,-20> <15,10,20> 
 texture {
  pigment {color rgb<.5,.2,.2>}
  normal {bumps .1 scale .06}
  finish {diffuse .2 reflection .5}}
}  
box {<-5,10,-20> <5,12,20> 
 texture {
  pigment {color rgb<.5,.2,.2>}
  normal {bumps .1 scale .2}
  finish {diffuse .2 reflection .5}}
}
box {<-5,-10,-20> <5,10,-20> 
 texture {
  pigment {color rgb<.5,.2,.2>}
  normal {bumps .1 scale .06}
  finish {diffuse .2 reflection .5}}
}       