#include "colors.inc"
#include "textures.inc"
camera {location <4600,240,5650>
        look_at  <4602,100,0>}

background {SummerSky}

light_source { <4600,3000,5650> 
               rgb <1,1,1>
               area_light <1000,0,0>,<0,-300,0>,5,5}
light_source {<4600,3000,5650> rgb <1,1,1>}
light_source {<4600,240,5650> rgb <1,1,1>}
//light_source {<4000,2700,6000> rgb <1,1,1>}

height_field {tga "whirl.tga"
              smooth
              pigment { gradient y
                        pigment_map {
                         [0.25 Gold]
                         [0.3 crackle pigment_map{ [0.4 Gold]
                                                    [0.8 MandarinOrange]}]
                         }}
		      normal { gradient y
                       normal_map {
                       [0.25 bumps scale <10,1,1>]
                       [0.25 crackle ]
                       }}
              scale <7000,700,7000>}


#include "plane2.inc"

sky_sphere {
pigment{gradient y
        color_map { 
   [0 SummerSky]               
   [1 SkyBlue]} 
   scale 2}
pigment{
  bozo
  turbulence 0.65
  octaves 6
  omega 0.7
  lambda 2
  color_map {
 [0.0 0.1 color rgb  <0.85, 0.85, 0.85>
          color rgb  <0.75, 0.75, 0.75>]
 [0.1 0.5 color rgb  <0.75, 0.75, 0.75>
          color rgbt <1, 1, 1, 1>]
 [0.5 1.0 color rgbt <1, 1, 1, 1>
          color rgbt <1, 1, 1, 1>]
 }
scale <1,1,1>
}
scale <4,1,4>
rotate <0,0,0> }

// *************************************************** pillar

#declare R1 = seed(45645)

#declare desert_marble = pigment {marble 
                                  color_map {
                                  [0.0 Gray60]
                                  [0.2 Gray60]
                                  [0.6 Gray30]
                                  [0.7 Gray30]
                                  [0.7 White ]
                                  [0.9 Black]}
								  frequency 10
                                  turbulence 0.5
								  octaves 3
								  translate <rand(R1),rand(R1),rand(R1)>};

difference{
cylinder {<0,0,0>,<0,10,0>, 0.5 pigment{desert_marble}
                                finish {phong 0.6}
								normal {crackle scale 0.3} 
 }

#declare i=0;
#while (i<20)
 box {<0,0,0>,<rand(R1),  rand(R1),  rand(R1)>
         pigment {desert_marble}
         rotate <rand(R1)*45,  rand(R1)*45,  rand(R1)*45>
         translate <rand(R1) - 0.5,  9.7,  rand(R1) - 0.5>}
 #declare i = i+1;
#end
rotate <15,20,0>
translate <4600,228,5635>
}


difference{
cylinder {<0,0,0>,<0,10,0>, 0.5 pigment{desert_marble}
                                finish {phong 0.6}
								normal {crackle scale 0.3} 
 }

#declare i=0;
#while (i<20)
 box {<0,0,0>,<rand(R1),  rand(R1),  rand(R1)>
         pigment {desert_marble}
         rotate <rand(R1)*45,  rand(R1)*45,  rand(R1)*45>
         translate <rand(R1) - 0.5,  9.7,  rand(R1) - 0.5>}
 #declare i = i+1;
#end
rotate <30,15,3>
translate <4596,229.5,5637>
}

difference{
cylinder {<0,0,0>,<0,10,0>, 0.5 pigment{desert_marble}
                                finish {phong 0.6}
								normal {crackle scale 0.3} 
 }

#declare i=0;
#while (i<20)
 box {<0,0,0>,<rand(R1),  rand(R1),  rand(R1)>
         pigment {desert_marble}
         rotate <rand(R1)*45,  rand(R1)*45,  rand(R1)*45>
         translate <rand(R1) - 0.5,  9.7,  rand(R1) - 0.5>}
 #declare i = i+1;
#end
rotate <10,18,7>
translate <4598,229,5636>
}

// ************************************ face

height_field {
 tga "body.tga"
 water_level 0.09
 smooth
// pigment {Gray90}
 pigment {desert_marble}
 finish {phong 0.6}
 scale <2,0.4,2>
 rotate <120,0,180>
 translate <4596,236.2,5641>}
