// Persistence of Vision Ray Tracer Scene Description File
// File: mg_rose.pov
// Vers: 3.1
// Desc: first encounter topic  
// Date: December 29 1998
// Auth: Marjorie Graterol




#include "colors.inc"
#include "textures.inc" 
#include "emecolor.inc"
#include "finish.inc" 
#include "mg_rose1.inc" 
#include "mg_rose2.inc" 

global_settings { assumed_gamma 1.8 }  
camera {
	location <2.15, 4.5, -5.0>  
	look_at <-0.16, 0.50, -0.70>
}

//Lights-luces
 light_source {
   <-1, 6, -1> color VeryDarkBrown 

   area_light <4, 0, 0>, <0, 0, 4>, 9, 9
   adaptive 1
   jitter

   looks_like {
      box {
         <-0.5, 0, -0.5>, <0.5, 0.25, 0.5>
         pigment { White } finish { Luminous }
      }
   }
}

 
light_source {<0,0,-19.99> Tan
media_attenuation on
}
 
 //otro light source  //insect
light_source
{
  0*x                     
  White 
  spotlight               
  translate <0, 20, 0> 
  point_at <1.35,2.85,-3.1>      
  radius 20             
  tightness 7           
  falloff 15               
  media_attenuation on
}
 


//mantis light
light_source
{
  <0, 18, 0>                   
  rj23 filter 0.5 transmit 0.5
       
  spotlight               
  
  point_at <-3,.80,-1.50>     
  radius 15              
  tightness 15           
  falloff 15               
  media_attenuation on
}


//rose light
 light_source
{
  <-2, 18, -3>                   
  rj8 
  
  spotlight               
  
   
  point_at <0,0,-0.50>    
  radius 15              
  tightness 15            
  falloff 15              
  media_attenuation on
}
 

 

sphere{<0,0,0>, 20
 hollow  yes
 pigment{
 // gif image to simulate leaves
 image_map
          {
  gif "fondoe.gif" 
  map_type 1 
  interpolate 2
   
  
} 
}
//same image posterized 
normal {
bump_map
{ 
  gif "fondof.gif" 
  map_type 1 
  interpolate 2
 
  
  bump_size 2.0 
} 
}
 
 
 finish {
    ambient 0.0
    diffuse 0.5
    phong 0.65
     
    }
  
  
  interior { ior 1.43 }} 
  
  

 
#declare gota=
blob {
   threshold 0.600000
   component 1.000000, 0.485524, <-0.144028, 0.121037, 0.000000>
   component 1.000000, 0.141559, <-0.178594, 0.259366, 0.000000>

   texture {Glass3
      
   }
}

object {gota
translate <1,-0.05,-2.05>}  

object {gota
translate <1.6,.90,-1.65>}

//rosa

object {Rose
translate <0,0,-0.50>
} 



//mantis
object {mantis

rotate -50*y
translate <-2.5,.80,-1.25>}
 

   
//object {insect}

object {beeplane
rotate y*130
rotate z*15
translate <1.35,2.85,-3.0>}



 


