//include file for mg_rose.pov
 
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
 
#declare texcab= texture{

	pigment{
image_map
          {
  gif "texcab1.gif" 
  map_type 1 
  interpolate 4 
   once
} 
}
	normal {
bump_map
{ 
  gif "texcab.gif" 
  map_type 1 
  interpolate 4 
   once
  bump_size 0.10 
} 
}
finish {
      ambient 0.1
      diffuse 0.1
      phong 0.23
      phong_size 50
   }

}


#declare texojo=texture{
     pigment{ 
	image_map  {
          gif "ojo2.gif" 
          map_type 1 
          interpolate 0 
          once }
          }
          finish
          {
         ambient 0.266167
         diffuse 0.323733
         brilliance 0.375667
         phong 0.9
         phong_size 25.163333
          } 
          } 

}
	normal {
bump_map
{
  gif "texojo.gif" 
  map_type 1 
  interpolate 4
 
   once
  bump_size 2.0 
} 
}
finish {phong 0.7 reflection .25}
}
 









#declare beeplane=
 union{
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.548, -1.686, -0.529> <-0.548, -1.686, -0.529> <-0.548, -1.686, -0.529> <-0.548, -1.686, -0.529> 
		<-0.544, -1.687, -0.531> <-0.551, -1.685, -0.527> <-0.551, -1.685, -0.527> <-0.555, -1.685, -0.526> 
		<-0.544, -1.689, -0.536> <-0.552, -1.687, -0.532> <-0.566, -1.685, -0.526> <-0.574, -1.683, -0.522> 
		<-0.540, -1.689, -0.536> <-0.548, -1.687, -0.532> <-0.559, -1.685, -0.526> <-0.567, -1.683, -0.522> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.548, -1.686, -0.529> <-0.544, -1.687, -0.531> <-0.544, -1.689, -0.536> <-0.540, -1.689, -0.536> 
		<-0.648, -1.903, -0.407> <-0.644, -1.904, -0.409> <-0.640, -1.908, -0.418> <-0.636, -1.908, -0.418> 
		<-0.781, -2.192, -0.244> <-0.787, -2.201, -0.251> <-0.776, -2.200, -0.261> <-0.763, -2.200, -0.261> 
		<-0.882, -2.409, -0.122> <-0.887, -2.418, -0.129> <-0.871, -2.419, -0.143> <-0.858, -2.419, -0.143> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.548, -1.686, -0.529> <-0.648, -1.903, -0.407> <-0.781, -2.192, -0.244> <-0.882, -2.409, -0.122> 
		<-0.555, -1.685, -0.526> <-0.655, -1.901, -0.403> <-0.775, -2.181, -0.236> <-0.875, -2.398, -0.114> 
		<-0.574, -1.683, -0.522> <-0.658, -1.898, -0.404> <-0.776, -2.184, -0.246> <-0.860, -2.398, -0.127> 
		<-0.567, -1.683, -0.522> <-0.650, -1.897, -0.404> <-0.761, -2.184, -0.246> <-0.845, -2.398, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.533, -1.686, -0.529> <-0.544, -1.683, -0.523> <-0.553, -1.683, -0.523> <-0.567, -1.683, -0.522> 
		<-0.623, -1.903, -0.407> <-0.635, -1.900, -0.401> <-0.637, -1.897, -0.404> <-0.650, -1.897, -0.404> 
		<-0.744, -2.192, -0.244> <-0.741, -2.188, -0.241> <-0.755, -2.184, -0.246> <-0.761, -2.184, -0.246> 
		<-0.834, -2.409, -0.122> <-0.832, -2.404, -0.119> <-0.839, -2.398, -0.127> <-0.845, -2.398, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.533, -1.686, -0.529> <-0.533, -1.686, -0.529> <-0.533, -1.686, -0.529> <-0.533, -1.686, -0.529> 
		<-0.544, -1.683, -0.523> <-0.541, -1.684, -0.525> <-0.541, -1.684, -0.525> <-0.529, -1.687, -0.531> 
		<-0.553, -1.683, -0.523> <-0.545, -1.685, -0.527> <-0.544, -1.687, -0.532> <-0.536, -1.689, -0.536> 
		<-0.567, -1.683, -0.522> <-0.559, -1.685, -0.526> <-0.548, -1.687, -0.532> <-0.540, -1.689, -0.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.533, -1.686, -0.529> <-0.623, -1.903, -0.407> <-0.744, -2.192, -0.244> <-0.834, -2.409, -0.122> 
		<-0.529, -1.687, -0.531> <-0.620, -1.904, -0.409> <-0.750, -2.201, -0.251> <-0.840, -2.418, -0.129> 
		<-0.536, -1.689, -0.536> <-0.632, -1.908, -0.418> <-0.750, -2.200, -0.261> <-0.845, -2.419, -0.143> 
		<-0.540, -1.689, -0.536> <-0.636, -1.908, -0.418> <-0.763, -2.200, -0.261> <-0.858, -2.419, -0.143> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.882, -2.409, -0.122> <-0.882, -2.409, -0.122> <-0.882, -2.409, -0.122> <-0.882, -2.409, -0.122> 
		<-0.875, -2.398, -0.114> <-0.881, -2.407, -0.121> <-0.881, -2.407, -0.121> <-0.887, -2.418, -0.129> 
		<-0.860, -2.398, -0.127> <-0.864, -2.404, -0.132> <-0.867, -2.413, -0.138> <-0.871, -2.419, -0.143> 
		<-0.845, -2.398, -0.127> <-0.849, -2.404, -0.132> <-0.854, -2.413, -0.138> <-0.858, -2.419, -0.143> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.834, -2.409, -0.122> <-0.834, -2.409, -0.122> <-0.834, -2.409, -0.122> <-0.834, -2.409, -0.122> 
		<-0.840, -2.418, -0.129> <-0.838, -2.413, -0.126> <-0.838, -2.413, -0.126> <-0.832, -2.404, -0.119> 
		<-0.845, -2.419, -0.143> <-0.841, -2.413, -0.138> <-0.843, -2.404, -0.132> <-0.839, -2.398, -0.127> 
		<-0.858, -2.419, -0.143> <-0.854, -2.413, -0.138> <-0.849, -2.404, -0.132> <-0.845, -2.398, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.903, -1.851, -0.160> <-0.903, -1.851, -0.160> <-0.903, -1.851, -0.160> <-0.903, -1.851, -0.160> 
		<-0.903, -1.848, -0.159> <-0.903, -1.851, -0.160> <-0.903, -1.851, -0.160> <-0.903, -1.853, -0.161> 
		<-0.900, -1.846, -0.158> <-0.900, -1.849, -0.159> <-0.900, -1.852, -0.161> <-0.900, -1.855, -0.162> 
		<-0.898, -1.846, -0.158> <-0.898, -1.849, -0.159> <-0.898, -1.852, -0.161> <-0.898, -1.855, -0.162> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.903, -1.851, -0.160> <-0.903, -1.848, -0.159> <-0.900, -1.846, -0.158> <-0.898, -1.846, -0.158> 
		<-0.798, -1.792, -0.271> <-0.798, -1.790, -0.270> <-0.793, -1.789, -0.268> <-0.791, -1.789, -0.268> 
		<-0.659, -1.714, -0.419> <-0.659, -1.709, -0.416> <-0.654, -1.713, -0.414> <-0.648, -1.713, -0.414> 
		<-0.555, -1.656, -0.530> <-0.555, -1.650, -0.527> <-0.546, -1.656, -0.524> <-0.540, -1.656, -0.524> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.903, -1.851, -0.160> <-0.798, -1.792, -0.271> <-0.659, -1.714, -0.419> <-0.555, -1.656, -0.530> 
		<-0.903, -1.853, -0.161> <-0.798, -1.794, -0.272> <-0.659, -1.725, -0.424> <-0.555, -1.667, -0.535> 
		<-0.900, -1.855, -0.162> <-0.793, -1.803, -0.274> <-0.659, -1.734, -0.424> <-0.552, -1.682, -0.536> 
		<-0.898, -1.855, -0.162> <-0.791, -1.803, -0.274> <-0.648, -1.734, -0.424> <-0.540, -1.682, -0.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.893, -1.851, -0.160> <-0.893, -1.853, -0.161> <-0.895, -1.855, -0.162> <-0.898, -1.855, -0.162> 
		<-0.783, -1.792, -0.271> <-0.783, -1.794, -0.272> <-0.788, -1.803, -0.274> <-0.791, -1.803, -0.274> 
		<-0.636, -1.714, -0.419> <-0.636, -1.725, -0.424> <-0.636, -1.734, -0.424> <-0.648, -1.734, -0.424> 
		<-0.526, -1.656, -0.530> <-0.526, -1.667, -0.535> <-0.529, -1.682, -0.536> <-0.540, -1.682, -0.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.893, -1.851, -0.160> <-0.893, -1.851, -0.160> <-0.893, -1.851, -0.160> <-0.893, -1.851, -0.160> 
		<-0.893, -1.853, -0.161> <-0.893, -1.851, -0.160> <-0.893, -1.851, -0.160> <-0.893, -1.848, -0.159> 
		<-0.895, -1.855, -0.162> <-0.895, -1.852, -0.161> <-0.895, -1.849, -0.159> <-0.895, -1.846, -0.158> 
		<-0.898, -1.855, -0.162> <-0.898, -1.852, -0.161> <-0.898, -1.849, -0.159> <-0.898, -1.846, -0.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.893, -1.851, -0.160> <-0.783, -1.792, -0.271> <-0.636, -1.714, -0.419> <-0.526, -1.656, -0.530> 
		<-0.893, -1.848, -0.159> <-0.783, -1.790, -0.270> <-0.636, -1.709, -0.416> <-0.526, -1.650, -0.527> 
		<-0.895, -1.846, -0.158> <-0.788, -1.789, -0.268> <-0.642, -1.713, -0.414> <-0.534, -1.656, -0.524> 
		<-0.898, -1.846, -0.158> <-0.791, -1.789, -0.268> <-0.648, -1.713, -0.414> <-0.540, -1.656, -0.524> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.555, -1.656, -0.530> <-0.555, -1.656, -0.530> <-0.555, -1.656, -0.530> <-0.555, -1.656, -0.530> 
		<-0.555, -1.667, -0.535> <-0.555, -1.661, -0.532> <-0.555, -1.661, -0.532> <-0.555, -1.650, -0.527> 
		<-0.552, -1.682, -0.536> <-0.552, -1.674, -0.532> <-0.546, -1.664, -0.527> <-0.546, -1.656, -0.524> 
		<-0.540, -1.682, -0.536> <-0.540, -1.674, -0.532> <-0.540, -1.664, -0.527> <-0.540, -1.656, -0.524> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.526, -1.656, -0.530> <-0.526, -1.656, -0.530> <-0.526, -1.656, -0.530> <-0.526, -1.656, -0.530> 
		<-0.526, -1.650, -0.527> <-0.526, -1.661, -0.532> <-0.526, -1.661, -0.532> <-0.526, -1.667, -0.535> 
		<-0.534, -1.656, -0.524> <-0.534, -1.664, -0.527> <-0.529, -1.674, -0.532> <-0.529, -1.682, -0.536> 
		<-0.540, -1.656, -0.524> <-0.540, -1.664, -0.527> <-0.540, -1.674, -0.532> <-0.540, -1.682, -0.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.588, -1.556, -0.512> <-1.588, -1.556, -0.512> <-1.588, -1.556, -0.512> <-1.588, -1.556, -0.512> 
		<-1.588, -1.557, -0.516> <-1.588, -1.556, -0.512> <-1.588, -1.556, -0.512> <-1.588, -1.554, -0.508> 
		<-1.592, -1.559, -0.519> <-1.592, -1.557, -0.515> <-1.592, -1.554, -0.509> <-1.592, -1.552, -0.505> 
		<-1.596, -1.559, -0.519> <-1.596, -1.557, -0.515> <-1.596, -1.554, -0.509> <-1.596, -1.552, -0.505> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.588, -1.556, -0.512> <-1.588, -1.557, -0.516> <-1.592, -1.559, -0.519> <-1.596, -1.559, -0.519> 
		<-1.519, -1.870, -0.390> <-1.519, -1.872, -0.394> <-1.528, -1.876, -0.401> <-1.532, -1.876, -0.401> 
		<-1.428, -2.290, -0.227> <-1.428, -2.296, -0.239> <-1.434, -2.298, -0.244> <-1.447, -2.298, -0.244> 
		<-1.359, -2.605, -0.105> <-1.359, -2.610, -0.116> <-1.370, -2.615, -0.126> <-1.383, -2.615, -0.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.588, -1.556, -0.512> <-1.519, -1.870, -0.390> <-1.428, -2.290, -0.227> <-1.359, -2.605, -0.105> 
		<-1.588, -1.554, -0.508> <-1.519, -1.868, -0.386> <-1.428, -2.284, -0.215> <-1.359, -2.599, -0.093> 
		<-1.592, -1.552, -0.505> <-1.528, -1.865, -0.379> <-1.434, -2.282, -0.210> <-1.370, -2.594, -0.084> 
		<-1.596, -1.552, -0.505> <-1.532, -1.865, -0.379> <-1.447, -2.282, -0.210> <-1.383, -2.594, -0.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.603, -1.555, -0.512> <-1.603, -1.554, -0.508> <-1.600, -1.552, -0.505> <-1.596, -1.552, -0.505> 
		<-1.544, -1.870, -0.390> <-1.544, -1.868, -0.386> <-1.536, -1.865, -0.379> <-1.532, -1.865, -0.379> 
		<-1.465, -2.290, -0.227> <-1.465, -2.284, -0.216> <-1.460, -2.282, -0.210> <-1.447, -2.282, -0.210> 
		<-1.406, -2.605, -0.105> <-1.406, -2.599, -0.093> <-1.396, -2.594, -0.084> <-1.383, -2.594, -0.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.603, -1.555, -0.512> <-1.603, -1.555, -0.512> <-1.603, -1.555, -0.512> <-1.603, -1.555, -0.512> 
		<-1.603, -1.554, -0.508> <-1.603, -1.555, -0.512> <-1.603, -1.555, -0.512> <-1.603, -1.557, -0.516> 
		<-1.600, -1.552, -0.505> <-1.600, -1.554, -0.509> <-1.600, -1.557, -0.515> <-1.600, -1.559, -0.519> 
		<-1.596, -1.552, -0.505> <-1.596, -1.554, -0.509> <-1.596, -1.557, -0.515> <-1.596, -1.559, -0.519> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.603, -1.555, -0.512> <-1.544, -1.870, -0.390> <-1.465, -2.290, -0.227> <-1.406, -2.605, -0.105> 
		<-1.603, -1.557, -0.516> <-1.544, -1.872, -0.394> <-1.465, -2.296, -0.239> <-1.406, -2.610, -0.116> 
		<-1.600, -1.559, -0.519> <-1.536, -1.876, -0.401> <-1.460, -2.298, -0.244> <-1.396, -2.615, -0.126> 
		<-1.596, -1.559, -0.519> <-1.532, -1.876, -0.401> <-1.447, -2.298, -0.244> <-1.383, -2.615, -0.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.359, -2.605, -0.105> <-1.359, -2.605, -0.105> <-1.359, -2.605, -0.105> <-1.359, -2.605, -0.105> 
		<-1.359, -2.599, -0.093> <-1.359, -2.605, -0.105> <-1.359, -2.605, -0.105> <-1.359, -2.610, -0.116> 
		<-1.370, -2.594, -0.084> <-1.370, -2.601, -0.096> <-1.370, -2.609, -0.113> <-1.370, -2.615, -0.126> 
		<-1.383, -2.594, -0.084> <-1.383, -2.601, -0.096> <-1.383, -2.609, -0.113> <-1.383, -2.615, -0.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.406, -2.605, -0.105> <-1.406, -2.605, -0.105> <-1.406, -2.605, -0.105> <-1.406, -2.605, -0.105> 
		<-1.406, -2.610, -0.116> <-1.406, -2.605, -0.105> <-1.406, -2.605, -0.105> <-1.406, -2.599, -0.093> 
		<-1.396, -2.615, -0.126> <-1.396, -2.609, -0.113> <-1.396, -2.601, -0.096> <-1.396, -2.594, -0.084> 
		<-1.383, -2.615, -0.126> <-1.383, -2.609, -0.113> <-1.383, -2.601, -0.096> <-1.383, -2.594, -0.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.312, -1.837, -0.143> <-1.312, -1.837, -0.143> <-1.312, -1.837, -0.143> <-1.312, -1.837, -0.143> 
		<-1.312, -1.835, -0.142> <-1.312, -1.837, -0.143> <-1.312, -1.837, -0.143> <-1.312, -1.840, -0.144> 
		<-1.314, -1.833, -0.141> <-1.314, -1.836, -0.142> <-1.314, -1.839, -0.144> <-1.314, -1.842, -0.145> 
		<-1.317, -1.833, -0.141> <-1.317, -1.836, -0.142> <-1.317, -1.839, -0.144> <-1.317, -1.842, -0.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.312, -1.837, -0.143> <-1.312, -1.835, -0.142> <-1.314, -1.833, -0.141> <-1.317, -1.833, -0.141> 
		<-1.393, -1.744, -0.254> <-1.393, -1.741, -0.253> <-1.398, -1.741, -0.251> <-1.400, -1.741, -0.251> 
		<-1.501, -1.619, -0.402> <-1.501, -1.613, -0.399> <-1.507, -1.618, -0.401> <-1.512, -1.618, -0.397> 
		<-1.581, -1.525, -0.513> <-1.581, -1.520, -0.510> <-1.591, -1.525, -0.511> <-1.596, -1.525, -0.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.312, -1.837, -0.143> <-1.393, -1.744, -0.254> <-1.501, -1.619, -0.402> <-1.581, -1.525, -0.513> 
		<-1.312, -1.840, -0.144> <-1.393, -1.746, -0.255> <-1.501, -1.630, -0.407> <-1.581, -1.536, -0.518> 
		<-1.314, -1.842, -0.145> <-1.398, -1.755, -0.257> <-1.503, -1.639, -0.414> <-1.587, -1.551, -0.526> 
		<-1.317, -1.842, -0.145> <-1.400, -1.755, -0.257> <-1.512, -1.639, -0.407> <-1.596, -1.551, -0.519> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.321, -1.837, -0.143> <-1.321, -1.840, -0.144> <-1.319, -1.842, -0.145> <-1.317, -1.842, -0.145> 
		<-1.404, -1.744, -0.250> <-1.404, -1.746, -0.251> <-1.403, -1.755, -0.257> <-1.400, -1.755, -0.257> 
		<-1.514, -1.619, -0.393> <-1.514, -1.630, -0.398> <-1.522, -1.639, -0.398> <-1.512, -1.639, -0.407> 
		<-1.597, -1.525, -0.500> <-1.597, -1.537, -0.505> <-1.605, -1.551, -0.511> <-1.596, -1.551, -0.519> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.321, -1.837, -0.143> <-1.321, -1.837, -0.143> <-1.321, -1.837, -0.143> <-1.321, -1.837, -0.143> 
		<-1.321, -1.840, -0.144> <-1.321, -1.837, -0.143> <-1.321, -1.837, -0.143> <-1.321, -1.835, -0.142> 
		<-1.319, -1.842, -0.145> <-1.319, -1.839, -0.144> <-1.319, -1.836, -0.142> <-1.319, -1.833, -0.141> 
		<-1.317, -1.842, -0.145> <-1.317, -1.839, -0.144> <-1.317, -1.836, -0.142> <-1.317, -1.833, -0.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.321, -1.837, -0.143> <-1.404, -1.744, -0.250> <-1.514, -1.619, -0.393> <-1.597, -1.525, -0.500> 
		<-1.321, -1.835, -0.142> <-1.404, -1.742, -0.249> <-1.514, -1.616, -0.391> <-1.597, -1.523, -0.498> 
		<-1.319, -1.833, -0.141> <-1.403, -1.741, -0.251> <-1.514, -1.618, -0.395> <-1.598, -1.525, -0.505> 
		<-1.317, -1.833, -0.141> <-1.400, -1.741, -0.251> <-1.512, -1.618, -0.397> <-1.596, -1.525, -0.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.581, -1.525, -0.513> <-1.581, -1.525, -0.513> <-1.581, -1.525, -0.513> <-1.581, -1.525, -0.513> 
		<-1.581, -1.536, -0.518> <-1.581, -1.530, -0.515> <-1.581, -1.530, -0.515> <-1.581, -1.520, -0.510> 
		<-1.587, -1.551, -0.526> <-1.587, -1.544, -0.523> <-1.591, -1.533, -0.514> <-1.591, -1.525, -0.511> 
		<-1.596, -1.551, -0.519> <-1.596, -1.544, -0.515> <-1.596, -1.533, -0.510> <-1.596, -1.525, -0.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.597, -1.525, -0.500> <-1.597, -1.525, -0.500> <-1.597, -1.525, -0.500> <-1.597, -1.525, -0.500> 
		<-1.597, -1.523, -0.498> <-1.597, -1.534, -0.504> <-1.597, -1.534, -0.504> <-1.597, -1.537, -0.505> 
		<-1.598, -1.525, -0.505> <-1.598, -1.533, -0.508> <-1.605, -1.544, -0.507> <-1.605, -1.551, -0.511> 
		<-1.596, -1.525, -0.507> <-1.596, -1.533, -0.510> <-1.596, -1.544, -0.515> <-1.596, -1.551, -0.519> 
	}
	#ifndef (IMPORT_SPATCH)
	pigment { Orange }
	finish { phong 0.9 }
	#end
}

union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.239, -1.981, 0.687> <-2.239, -1.930, 1.297> <-1.718, -1.981, 1.820> <-1.106, -1.981, 1.820> 
		<-2.239, -2.030, 0.094> <-2.239, -1.979, 0.704> <-1.718, -2.541, 1.828> <-1.106, -2.541, 1.828> 
		<-1.446, -2.109, -0.051> <-1.446, -2.339, 0.270> <-1.106, -2.925, 0.759> <-1.106, -2.883, 1.259> 
		<-1.106, -2.164, -0.367> <-1.106, -2.394, -0.047> <-1.106, -2.972, 0.200> <-1.106, -2.930, 0.700> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.239, -1.981, 0.687> <-2.239, -1.981, 0.687> <-2.239, -1.981, 0.687> <-2.239, -1.981, 0.687> 
		<-2.239, -2.545, 0.695> <-2.239, -2.595, 0.102> <-2.239, -2.595, 0.102> <-2.239, -2.030, 0.094> 
		<-1.671, -2.930, 0.700> <-1.671, -2.972, 0.200> <-1.446, -2.339, 0.270> <-1.446, -2.109, -0.051> 
		<-1.106, -2.930, 0.700> <-1.106, -2.972, 0.200> <-1.106, -2.394, -0.047> <-1.106, -2.164, -0.367> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.239, -1.981, 0.687> <-2.239, -2.030, 0.094> <-1.446, -2.109, -0.051> <-1.106, -2.164, -0.367> 
		<-2.239, -1.435, 0.679> <-2.239, -1.485, 0.086> <-1.446, -1.913, 0.004> <-1.106, -1.968, -0.312> 
		<-1.652, -1.110, 0.674> <-1.652, -1.027, 0.322> <-1.106, -1.454, -0.127> <-1.106, -1.656, -0.327> 
		<-1.106, -1.110, 0.674> <-1.106, -1.027, 0.322> <-1.106, -1.309, 0.016> <-1.106, -1.511, -0.184> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.239, -1.981, 0.687> <-2.239, -2.030, 0.094> <-1.446, -2.109, -0.051> <-1.106, -2.164, -0.367> 
		<-2.239, -1.435, 0.679> <-2.239, -1.485, 0.086> <-1.106, -2.054, 0.266> <-0.766, -2.109, -0.051> 
		<-1.652, -1.110, 0.674> <-1.106, -1.110, 0.674> <0.026, -1.485, 0.086> <0.026, -2.030, 0.094> 
		<-1.106, -1.110, 0.674> <-0.560, -1.110, 0.674> <0.026, -1.435, 0.679> <0.026, -1.981, 0.687> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.239, -1.981, 0.687> <-2.239, -2.030, 0.094> <-1.446, -2.109, -0.051> <-1.106, -2.164, -0.367> 
		<-2.239, -2.545, 0.695> <-2.239, -2.595, 0.102> <-1.106, -2.054, 0.266> <-0.766, -2.109, -0.051> 
		<-1.671, -2.930, 0.700> <-1.106, -2.930, 0.700> <0.026, -2.595, 0.102> <0.026, -2.030, 0.094> 
		<-1.106, -2.930, 0.700> <-0.541, -2.930, 0.700> <0.026, -2.545, 0.695> <0.026, -1.981, 0.687> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.239, -1.981, 0.687> <-2.239, -1.981, 0.687> <-2.239, -1.981, 0.687> <-2.239, -1.981, 0.687> 
		<-2.239, -1.930, 1.297> <-2.239, -1.384, 1.289> <-2.239, -1.384, 1.289> <-2.239, -1.435, 0.679> 
		<-1.718, -1.981, 1.820> <-1.718, -1.431, 1.812> <-1.652, -1.235, 1.209> <-1.652, -1.110, 0.674> 
		<-1.106, -1.981, 1.820> <-1.106, -1.431, 1.812> <-1.106, -1.235, 1.209> <-1.106, -1.110, 0.674> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.239, -1.981, 0.687> <-2.239, -1.981, 0.687> <-2.239, -1.981, 0.687> <-2.239, -1.981, 0.687> 
		<-2.239, -1.930, 1.297> <-2.239, -2.494, 1.305> <-2.239, -2.494, 1.305> <-2.239, -2.545, 0.695> 
		<-1.718, -1.981, 1.820> <-1.718, -2.541, 1.828> <-1.671, -2.883, 1.259> <-1.671, -2.930, 0.700> 
		<-1.106, -1.981, 1.820> <-1.106, -2.541, 1.828> <-1.106, -2.883, 1.259> <-1.106, -2.930, 0.700> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.239, -1.981, 0.687> <-2.239, -1.435, 0.679> <-1.652, -1.110, 0.674> <-1.106, -1.110, 0.674> 
		<-2.239, -1.930, 1.297> <-2.239, -1.384, 1.289> <-1.106, -1.110, 0.674> <-0.560, -1.110, 0.674> 
		<-1.718, -1.981, 1.820> <-1.106, -1.981, 1.820> <0.026, -1.384, 1.289> <0.026, -1.435, 0.679> 
		<-1.106, -1.981, 1.820> <-0.494, -1.981, 1.820> <0.026, -1.930, 1.297> <0.026, -1.981, 0.687> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.239, -1.981, 0.687> <-2.239, -1.930, 1.297> <-1.718, -1.981, 1.820> <-1.106, -1.981, 1.820> 
		<-2.239, -2.545, 0.695> <-2.239, -2.494, 1.305> <-1.106, -1.981, 1.820> <-0.494, -1.981, 1.820> 
		<-1.671, -2.930, 0.700> <-1.106, -2.930, 0.700> <0.026, -2.494, 1.305> <0.026, -1.930, 1.297> 
		<-1.106, -2.930, 0.700> <-0.541, -2.930, 0.700> <0.026, -2.545, 0.695> <0.026, -1.981, 0.687> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.239, -1.981, 0.687> <-2.239, -2.545, 0.695> <-1.671, -2.930, 0.700> <-1.106, -2.930, 0.700> 
		<-2.239, -1.435, 0.679> <-2.239, -2.000, 0.688> <-1.671, -2.883, 1.259> <-1.106, -2.883, 1.259> 
		<-1.652, -1.110, 0.674> <-1.652, -1.235, 1.209> <-1.106, -1.992, 1.820> <-1.106, -2.541, 1.828> 
		<-1.106, -1.110, 0.674> <-1.106, -1.235, 1.209> <-1.106, -1.431, 1.812> <-1.106, -1.981, 1.820> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, -1.981, 0.687> <0.026, -1.981, 0.687> <0.026, -1.981, 0.687> <0.026, -1.981, 0.687> 
		<0.026, -1.435, 0.679> <0.026, -1.384, 1.289> <0.026, -1.384, 1.289> <0.026, -1.930, 1.297> 
		<-0.560, -1.110, 0.674> <-0.560, -1.235, 1.209> <-0.494, -1.431, 1.812> <-0.494, -1.981, 1.820> 
		<-1.106, -1.110, 0.674> <-1.106, -1.235, 1.209> <-1.106, -1.431, 1.812> <-1.106, -1.981, 1.820> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, -1.981, 0.687> <0.026, -2.030, 0.094> <-0.766, -2.109, -0.051> <-1.106, -2.164, -0.367> 
		<0.026, -1.930, 1.297> <0.026, -1.979, 0.704> <-0.766, -2.339, 0.270> <-1.106, -2.394, -0.047> 
		<-0.494, -1.981, 1.820> <-0.494, -2.541, 1.828> <-1.106, -2.925, 0.759> <-1.106, -2.972, 0.200> 
		<-1.106, -1.981, 1.820> <-1.106, -2.541, 1.828> <-1.106, -2.883, 1.259> <-1.106, -2.930, 0.700> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, -1.981, 0.687> <0.026, -1.981, 0.687> <0.026, -1.981, 0.687> <0.026, -1.981, 0.687> 
		<0.026, -2.545, 0.695> <0.026, -2.494, 1.305> <0.026, -2.494, 1.305> <0.026, -1.930, 1.297> 
		<-0.541, -2.930, 0.700> <-0.541, -2.883, 1.259> <-0.494, -2.541, 1.828> <-0.494, -1.981, 1.820> 
		<-1.106, -2.930, 0.700> <-1.106, -2.883, 1.259> <-1.106, -2.541, 1.828> <-1.106, -1.981, 1.820> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, -1.981, 0.687> <0.026, -1.981, 0.687> <0.026, -1.981, 0.687> <0.026, -1.981, 0.687> 
		<0.026, -2.545, 0.695> <0.026, -2.595, 0.102> <0.026, -2.595, 0.102> <0.026, -2.030, 0.094> 
		<-0.541, -2.930, 0.700> <-0.541, -2.972, 0.200> <-0.766, -2.339, 0.270> <-0.766, -2.109, -0.051> 
		<-1.106, -2.930, 0.700> <-1.106, -2.972, 0.200> <-1.106, -2.394, -0.047> <-1.106, -2.164, -0.367> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, -1.981, 0.687> <0.026, -2.030, 0.094> <-0.766, -2.109, -0.051> <-1.106, -2.164, -0.367> 
		<0.026, -1.435, 0.679> <0.026, -1.485, 0.086> <-0.766, -1.913, 0.004> <-1.106, -1.968, -0.312> 
		<-0.560, -1.110, 0.674> <-0.560, -1.027, 0.322> <-1.106, -1.454, -0.127> <-1.106, -1.656, -0.327> 
		<-1.106, -1.110, 0.674> <-1.106, -1.027, 0.322> <-1.106, -1.309, 0.016> <-1.106, -1.511, -0.184> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, -1.981, 0.687> <0.026, -1.435, 0.679> <-0.560, -1.110, 0.674> <-1.106, -1.110, 0.674> 
		<0.026, -2.545, 0.695> <0.026, -2.000, 0.688> <-0.560, -1.235, 1.209> <-1.106, -1.235, 1.209> 
		<-0.541, -2.930, 0.700> <-0.541, -2.883, 1.259> <-1.106, -1.992, 1.820> <-1.106, -1.431, 1.812> 
		<-1.106, -2.930, 0.700> <-1.106, -2.883, 1.259> <-1.106, -2.541, 1.828> <-1.106, -1.981, 1.820> 
	}
	#ifndef (IMPORT_SPATCH)
	
	texture{texcab}
	
	
	#end
}

union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, -1.957, 0.298> <-0.688, -2.263, 0.318> <-0.600, -2.653, 0.343> <-0.294, -2.653, 0.343> 
		<-0.688, -1.643, 0.278> <-0.688, -1.949, 0.298> <-0.600, -2.674, 0.020> <-0.294, -2.674, 0.020> 
		<-0.609, -1.235, 0.252> <-0.609, -1.257, -0.087> <-0.294, -1.986, -0.201> <-0.294, -2.326, -0.179> 
		<-0.294, -1.235, 0.252> <-0.294, -1.257, -0.087> <-0.294, -1.663, -0.222> <-0.294, -2.003, -0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, -1.957, 0.298> <-0.688, -1.957, 0.298> <-0.688, -1.957, 0.298> <-0.688, -1.957, 0.298> 
		<-0.688, -1.973, 0.056> <-0.688, -1.659, 0.035> <-0.688, -1.659, 0.035> <-0.688, -1.643, 0.278> 
		<-0.537, -2.003, -0.200> <-0.537, -1.663, -0.222> <-0.609, -1.257, -0.087> <-0.609, -1.235, 0.252> 
		<-0.294, -2.003, -0.200> <-0.294, -1.663, -0.222> <-0.294, -1.257, -0.087> <-0.294, -1.235, 0.252> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, -1.957, 0.298> <-0.688, -1.643, 0.278> <-0.609, -1.235, 0.252> <-0.294, -1.235, 0.252> 
		<-0.688, -2.263, 0.318> <-0.688, -1.949, 0.298> <-0.609, -1.213, 0.592> <-0.294, -1.213, 0.592> 
		<-0.600, -2.653, 0.343> <-0.600, -2.633, 0.666> <-0.294, -1.922, 0.797> <-0.294, -1.599, 0.776> 
		<-0.294, -2.653, 0.343> <-0.294, -2.633, 0.666> <-0.294, -2.262, 0.819> <-0.294, -1.939, 0.798> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, -1.957, 0.298> <-0.688, -1.957, 0.298> <-0.688, -1.957, 0.298> <-0.688, -1.957, 0.298> 
		<-0.688, -1.942, 0.541> <-0.688, -1.628, 0.521> <-0.688, -1.628, 0.521> <-0.688, -1.643, 0.278> 
		<-0.537, -1.939, 0.798> <-0.537, -1.599, 0.776> <-0.609, -1.213, 0.592> <-0.609, -1.235, 0.252> 
		<-0.294, -1.939, 0.798> <-0.294, -1.599, 0.776> <-0.294, -1.213, 0.592> <-0.294, -1.235, 0.252> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, -1.957, 0.298> <-0.688, -1.643, 0.278> <-0.609, -1.235, 0.252> <-0.294, -1.235, 0.252> 
		<-0.688, -1.942, 0.541> <-0.688, -1.628, 0.521> <-0.270, -1.235, 0.252> <0.045, -1.235, 0.252> 
		<-0.537, -1.939, 0.798> <-0.263, -1.939, 0.798> <0.219, -1.602, 0.550> <0.219, -1.619, 0.277> 
		<-0.294, -1.939, 0.798> <-0.020, -1.939, 0.798> <0.219, -1.940, 0.572> <0.219, -1.957, 0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, -1.957, 0.298> <-0.688, -1.643, 0.278> <-0.609, -1.235, 0.252> <-0.294, -1.235, 0.252> 
		<-0.688, -1.973, 0.056> <-0.688, -1.659, 0.035> <-0.270, -1.235, 0.252> <0.045, -1.235, 0.252> 
		<-0.537, -2.003, -0.200> <-0.263, -2.003, -0.200> <0.219, -1.637, 0.003> <0.219, -1.619, 0.277> 
		<-0.294, -2.003, -0.200> <-0.020, -2.003, -0.200> <0.219, -1.975, 0.025> <0.219, -1.957, 0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, -1.957, 0.298> <-0.688, -1.957, 0.298> <-0.688, -1.957, 0.298> <-0.688, -1.957, 0.298> 
		<-0.688, -1.942, 0.541> <-0.688, -2.247, 0.561> <-0.688, -2.247, 0.561> <-0.688, -2.263, 0.318> 
		<-0.537, -1.939, 0.798> <-0.537, -2.262, 0.819> <-0.600, -2.633, 0.666> <-0.600, -2.653, 0.343> 
		<-0.294, -1.939, 0.798> <-0.294, -2.262, 0.819> <-0.294, -2.633, 0.666> <-0.294, -2.653, 0.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, -1.957, 0.298> <-0.688, -1.957, 0.298> <-0.688, -1.957, 0.298> <-0.688, -1.957, 0.298> 
		<-0.688, -2.263, 0.318> <-0.688, -2.279, 0.075> <-0.688, -2.279, 0.075> <-0.688, -1.973, 0.056> 
		<-0.600, -2.653, 0.343> <-0.600, -2.674, 0.020> <-0.537, -2.326, -0.179> <-0.537, -2.003, -0.200> 
		<-0.294, -2.653, 0.343> <-0.294, -2.674, 0.020> <-0.294, -2.326, -0.179> <-0.294, -2.003, -0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, -1.957, 0.298> <-0.688, -1.942, 0.541> <-0.537, -1.939, 0.798> <-0.294, -1.939, 0.798> 
		<-0.688, -2.263, 0.318> <-0.688, -2.247, 0.561> <-0.263, -1.939, 0.798> <-0.020, -1.939, 0.798> 
		<-0.600, -2.653, 0.343> <-0.269, -2.653, 0.343> <0.219, -2.270, 0.593> <0.219, -1.940, 0.572> 
		<-0.294, -2.653, 0.343> <0.037, -2.653, 0.343> <0.219, -2.288, 0.320> <0.219, -1.957, 0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, -1.957, 0.298> <-0.688, -2.263, 0.318> <-0.600, -2.653, 0.343> <-0.294, -2.653, 0.343> 
		<-0.688, -1.973, 0.056> <-0.688, -2.279, 0.075> <-0.269, -2.653, 0.343> <0.037, -2.653, 0.343> 
		<-0.537, -2.003, -0.200> <-0.263, -2.003, -0.200> <0.219, -2.305, 0.046> <0.219, -2.288, 0.320> 
		<-0.294, -2.003, -0.200> <-0.020, -2.003, -0.200> <0.219, -1.975, 0.025> <0.219, -1.957, 0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, -1.957, 0.298> <-0.688, -1.973, 0.056> <-0.537, -2.003, -0.200> <-0.294, -2.003, -0.200> 
		<-0.688, -1.942, 0.541> <-0.688, -1.957, 0.298> <-0.537, -2.326, -0.179> <-0.294, -2.326, -0.179> 
		<-0.537, -1.939, 0.798> <-0.537, -2.262, 0.819> <-0.294, -2.653, 0.343> <-0.294, -2.674, 0.020> 
		<-0.294, -1.939, 0.798> <-0.294, -2.262, 0.819> <-0.294, -2.633, 0.666> <-0.294, -2.653, 0.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, -1.957, 0.298> <-0.688, -1.973, 0.056> <-0.537, -2.003, -0.200> <-0.294, -2.003, -0.200> 
		<-0.688, -1.942, 0.541> <-0.688, -1.957, 0.298> <-0.537, -1.663, -0.222> <-0.294, -1.663, -0.222> 
		<-0.537, -1.939, 0.798> <-0.537, -1.599, 0.776> <-0.294, -1.235, 0.252> <-0.294, -1.257, -0.087> 
		<-0.294, -1.939, 0.798> <-0.294, -1.599, 0.776> <-0.294, -1.213, 0.592> <-0.294, -1.235, 0.252> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.219, -1.957, 0.298> <0.219, -2.288, 0.320> <0.037, -2.653, 0.343> <-0.294, -2.653, 0.343> 
		<0.219, -1.619, 0.277> <0.219, -1.949, 0.298> <0.037, -2.633, 0.666> <-0.294, -2.633, 0.666> 
		<0.045, -1.235, 0.252> <0.045, -1.213, 0.592> <-0.294, -1.922, 0.797> <-0.294, -2.262, 0.819> 
		<-0.294, -1.235, 0.252> <-0.294, -1.213, 0.592> <-0.294, -1.599, 0.776> <-0.294, -1.939, 0.798> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.219, -1.957, 0.298> <0.219, -1.957, 0.298> <0.219, -1.957, 0.298> <0.219, -1.957, 0.298> 
		<0.219, -1.940, 0.572> <0.219, -2.270, 0.593> <0.219, -2.270, 0.593> <0.219, -2.288, 0.320> 
		<-0.020, -1.939, 0.798> <-0.020, -2.262, 0.819> <0.037, -2.633, 0.666> <0.037, -2.653, 0.343> 
		<-0.294, -1.939, 0.798> <-0.294, -2.262, 0.819> <-0.294, -2.633, 0.666> <-0.294, -2.653, 0.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.219, -1.957, 0.298> <0.219, -1.619, 0.277> <0.045, -1.235, 0.252> <-0.294, -1.235, 0.252> 
		<0.219, -2.288, 0.320> <0.219, -1.949, 0.298> <0.045, -1.257, -0.087> <-0.294, -1.257, -0.087> 
		<0.037, -2.653, 0.343> <0.037, -2.674, 0.020> <-0.294, -1.986, -0.201> <-0.294, -1.663, -0.222> 
		<-0.294, -2.653, 0.343> <-0.294, -2.674, 0.020> <-0.294, -2.326, -0.179> <-0.294, -2.003, -0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.219, -1.957, 0.298> <0.219, -1.957, 0.298> <0.219, -1.957, 0.298> <0.219, -1.957, 0.298> 
		<0.219, -1.975, 0.025> <0.219, -2.305, 0.046> <0.219, -2.305, 0.046> <0.219, -2.288, 0.320> 
		<-0.020, -2.003, -0.200> <-0.020, -2.326, -0.179> <0.037, -2.674, 0.020> <0.037, -2.653, 0.343> 
		<-0.294, -2.003, -0.200> <-0.294, -2.326, -0.179> <-0.294, -2.674, 0.020> <-0.294, -2.653, 0.343> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.219, -1.957, 0.298> <0.219, -1.957, 0.298> <0.219, -1.957, 0.298> <0.219, -1.957, 0.298> 
		<0.219, -1.975, 0.025> <0.219, -1.637, 0.003> <0.219, -1.637, 0.003> <0.219, -1.619, 0.277> 
		<-0.020, -2.003, -0.200> <-0.020, -1.663, -0.222> <0.045, -1.257, -0.087> <0.045, -1.235, 0.252> 
		<-0.294, -2.003, -0.200> <-0.294, -1.663, -0.222> <-0.294, -1.257, -0.087> <-0.294, -1.235, 0.252> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.219, -1.957, 0.298> <0.219, -1.957, 0.298> <0.219, -1.957, 0.298> <0.219, -1.957, 0.298> 
		<0.219, -1.940, 0.572> <0.219, -1.602, 0.550> <0.219, -1.602, 0.550> <0.219, -1.619, 0.277> 
		<-0.020, -1.939, 0.798> <-0.020, -1.599, 0.776> <0.045, -1.213, 0.592> <0.045, -1.235, 0.252> 
		<-0.294, -1.939, 0.798> <-0.294, -1.599, 0.776> <-0.294, -1.213, 0.592> <-0.294, -1.235, 0.252> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.219, -1.957, 0.298> <0.219, -1.940, 0.572> <-0.020, -1.939, 0.798> <-0.294, -1.939, 0.798> 
		<0.219, -1.975, 0.025> <0.219, -1.957, 0.298> <-0.020, -1.599, 0.776> <-0.294, -1.599, 0.776> 
		<-0.020, -2.003, -0.200> <-0.020, -1.663, -0.222> <-0.294, -1.235, 0.252> <-0.294, -1.213, 0.592> 
		<-0.294, -2.003, -0.200> <-0.294, -1.663, -0.222> <-0.294, -1.257, -0.087> <-0.294, -1.235, 0.252> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.219, -1.957, 0.298> <0.219, -1.940, 0.572> <-0.020, -1.939, 0.798> <-0.294, -1.939, 0.798> 
		<0.219, -1.975, 0.025> <0.219, -1.957, 0.298> <-0.020, -2.262, 0.819> <-0.294, -2.262, 0.819> 
		<-0.020, -2.003, -0.200> <-0.020, -2.326, -0.179> <-0.294, -2.653, 0.343> <-0.294, -2.633, 0.666> 
		<-0.294, -2.003, -0.200> <-0.294, -2.326, -0.179> <-0.294, -2.674, 0.020> <-0.294, -2.653, 0.343> 
	}
	#ifndef (IMPORT_SPATCH)
     texture {NBbeerbottle}
     interior { ior 1.546 }
     #end
}
// Layer 4  ojo derecho
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.520, -1.950, 0.286> <-1.516, -1.644, 0.273> <-1.599, -1.252, 0.256> <-1.905, -1.248, 0.256> 
		<-1.524, -2.265, 0.299> <-1.520, -1.959, 0.286> <-1.599, -1.266, -0.067> <-1.905, -1.261, -0.067> 
		<-1.610, -2.672, 0.316> <-1.610, -2.686, -0.024> <-1.915, -1.969, -0.214> <-1.910, -1.629, -0.228> 
		<-1.925, -2.668, 0.316> <-1.925, -2.682, -0.024> <-1.919, -2.292, -0.201> <-1.915, -1.952, -0.215> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.520, -1.950, 0.286> <-1.520, -1.950, 0.286> <-1.520, -1.950, 0.286> <-1.520, -1.950, 0.286> 
		<-1.520, -1.960, 0.042> <-1.524, -2.275, 0.055> <-1.524, -2.275, 0.055> <-1.524, -2.265, 0.299> 
		<-1.671, -1.956, -0.215> <-1.676, -2.296, -0.200> <-1.610, -2.686, -0.024> <-1.610, -2.672, 0.316> 
		<-1.915, -1.952, -0.215> <-1.919, -2.292, -0.201> <-1.925, -2.682, -0.024> <-1.925, -2.668, 0.316> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.520, -1.950, 0.286> <-1.524, -2.265, 0.299> <-1.610, -2.672, 0.316> <-1.925, -2.668, 0.316> 
		<-1.516, -1.644, 0.273> <-1.520, -1.959, 0.286> <-1.610, -2.658, 0.656> <-1.925, -2.653, 0.655> 
		<-1.599, -1.252, 0.256> <-1.599, -1.239, 0.580> <-1.915, -1.927, 0.785> <-1.919, -2.250, 0.799> 
		<-1.905, -1.248, 0.256> <-1.905, -1.234, 0.580> <-1.910, -1.587, 0.771> <-1.915, -1.911, 0.784> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.520, -1.950, 0.286> <-1.520, -1.950, 0.286> <-1.520, -1.950, 0.286> <-1.520, -1.950, 0.286> 
		<-1.520, -1.940, 0.529> <-1.524, -2.255, 0.542> <-1.524, -2.255, 0.542> <-1.524, -2.265, 0.299> 
		<-1.671, -1.914, 0.784> <-1.676, -2.254, 0.799> <-1.610, -2.658, 0.656> <-1.610, -2.672, 0.316> 
		<-1.915, -1.911, 0.784> <-1.919, -2.250, 0.799> <-1.925, -2.653, 0.655> <-1.925, -2.668, 0.316> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.520, -1.950, 0.286> <-1.524, -2.265, 0.299> <-1.610, -2.672, 0.316> <-1.925, -2.668, 0.316> 
		<-1.520, -1.940, 0.529> <-1.524, -2.255, 0.542> <-1.946, -2.667, 0.316> <-2.261, -2.663, 0.315> 
		<-1.671, -1.914, 0.784> <-1.941, -1.910, 0.784> <-2.419, -2.262, 0.569> <-2.419, -2.273, 0.299> 
		<-1.915, -1.911, 0.784> <-2.185, -1.907, 0.784> <-2.415, -1.926, 0.555> <-2.415, -1.938, 0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.520, -1.950, 0.286> <-1.524, -2.265, 0.299> <-1.610, -2.672, 0.316> <-1.925, -2.668, 0.316> 
		<-1.520, -1.960, 0.042> <-1.524, -2.275, 0.055> <-1.946, -2.667, 0.316> <-2.261, -2.663, 0.315> 
		<-1.671, -1.956, -0.215> <-1.941, -1.952, -0.215> <-2.419, -2.285, 0.029> <-2.419, -2.273, 0.299> 
		<-1.915, -1.952, -0.215> <-2.185, -1.949, -0.215> <-2.415, -1.949, 0.015> <-2.415, -1.938, 0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.520, -1.950, 0.286> <-1.520, -1.950, 0.286> <-1.520, -1.950, 0.286> <-1.520, -1.950, 0.286> 
		<-1.520, -1.940, 0.529> <-1.516, -1.634, 0.516> <-1.516, -1.634, 0.516> <-1.516, -1.644, 0.273> 
		<-1.671, -1.914, 0.784> <-1.667, -1.591, 0.771> <-1.599, -1.239, 0.580> <-1.599, -1.252, 0.256> 
		<-1.915, -1.911, 0.784> <-1.910, -1.587, 0.771> <-1.905, -1.234, 0.580> <-1.905, -1.248, 0.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.520, -1.950, 0.286> <-1.520, -1.950, 0.286> <-1.520, -1.950, 0.286> <-1.520, -1.950, 0.286> 
		<-1.516, -1.644, 0.273> <-1.516, -1.654, 0.029> <-1.516, -1.654, 0.029> <-1.520, -1.960, 0.042> 
		<-1.599, -1.252, 0.256> <-1.599, -1.266, -0.067> <-1.667, -1.632, -0.228> <-1.671, -1.956, -0.215> 
		<-1.905, -1.248, 0.256> <-1.905, -1.261, -0.067> <-1.910, -1.629, -0.228> <-1.915, -1.952, -0.215> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.520, -1.950, 0.286> <-1.520, -1.940, 0.529> <-1.671, -1.914, 0.784> <-1.915, -1.911, 0.784> 
		<-1.516, -1.644, 0.273> <-1.516, -1.634, 0.516> <-1.941, -1.910, 0.784> <-2.185, -1.907, 0.784> 
		<-1.599, -1.252, 0.256> <-1.927, -1.248, 0.256> <-2.410, -1.599, 0.541> <-2.415, -1.926, 0.555> 
		<-1.905, -1.248, 0.256> <-2.233, -1.243, 0.256> <-2.410, -1.610, 0.271> <-2.415, -1.938, 0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.520, -1.950, 0.286> <-1.516, -1.644, 0.273> <-1.599, -1.252, 0.256> <-1.905, -1.248, 0.256> 
		<-1.520, -1.960, 0.042> <-1.516, -1.654, 0.029> <-1.927, -1.248, 0.256> <-2.233, -1.243, 0.256> 
		<-1.671, -1.956, -0.215> <-1.941, -1.952, -0.215> <-2.410, -1.621, 0.001> <-2.410, -1.610, 0.271> 
		<-1.915, -1.952, -0.215> <-2.185, -1.949, -0.215> <-2.415, -1.949, 0.015> <-2.415, -1.938, 0.285> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.520, -1.950, 0.286> <-1.520, -1.960, 0.042> <-1.671, -1.956, -0.215> <-1.915, -1.952, -0.215> 
		<-1.520, -1.940, 0.529> <-1.520, -1.950, 0.286> <-1.667, -1.632, -0.228> <-1.910, -1.629, -0.228> 
		<-1.671, -1.914, 0.784> <-1.667, -1.591, 0.771> <-1.905, -1.248, 0.256> <-1.905, -1.261, -0.067> 
		<-1.915, -1.911, 0.784> <-1.910, -1.587, 0.771> <-1.905, -1.234, 0.580> <-1.905, -1.248, 0.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.520, -1.950, 0.286> <-1.520, -1.960, 0.042> <-1.671, -1.956, -0.215> <-1.915, -1.952, -0.215> 
		<-1.520, -1.940, 0.529> <-1.520, -1.950, 0.286> <-1.676, -2.296, -0.200> <-1.919, -2.292, -0.201> 
		<-1.671, -1.914, 0.784> <-1.676, -2.254, 0.799> <-1.925, -2.668, 0.316> <-1.925, -2.682, -0.024> 
		<-1.915, -1.911, 0.784> <-1.919, -2.250, 0.799> <-1.925, -2.653, 0.655> <-1.925, -2.668, 0.316> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.415, -1.938, 0.285> <-2.410, -1.610, 0.271> <-2.233, -1.243, 0.256> <-1.905, -1.248, 0.256> 
		<-2.419, -2.273, 0.299> <-2.415, -1.946, 0.285> <-2.233, -1.230, 0.579> <-1.905, -1.234, 0.580> 
		<-2.261, -2.663, 0.315> <-2.261, -2.649, 0.655> <-1.915, -1.927, 0.785> <-1.910, -1.587, 0.771> 
		<-1.925, -2.668, 0.316> <-1.925, -2.653, 0.655> <-1.919, -2.250, 0.799> <-1.915, -1.911, 0.784> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.415, -1.938, 0.285> <-2.415, -1.938, 0.285> <-2.415, -1.938, 0.285> <-2.415, -1.938, 0.285> 
		<-2.415, -1.926, 0.555> <-2.410, -1.599, 0.541> <-2.410, -1.599, 0.541> <-2.410, -1.610, 0.271> 
		<-2.185, -1.907, 0.784> <-2.180, -1.583, 0.771> <-2.233, -1.230, 0.579> <-2.233, -1.243, 0.256> 
		<-1.915, -1.911, 0.784> <-1.910, -1.587, 0.771> <-1.905, -1.234, 0.580> <-1.905, -1.248, 0.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.415, -1.938, 0.285> <-2.419, -2.273, 0.299> <-2.261, -2.663, 0.315> <-1.925, -2.668, 0.316> 
		<-2.410, -1.610, 0.271> <-2.415, -1.946, 0.285> <-2.261, -2.677, -0.025> <-1.925, -2.682, -0.024> 
		<-2.233, -1.243, 0.256> <-2.233, -1.257, -0.068> <-1.915, -1.969, -0.214> <-1.919, -2.292, -0.201> 
		<-1.905, -1.248, 0.256> <-1.905, -1.261, -0.067> <-1.910, -1.629, -0.228> <-1.915, -1.952, -0.215> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.415, -1.938, 0.285> <-2.415, -1.938, 0.285> <-2.415, -1.938, 0.285> <-2.415, -1.938, 0.285> 
		<-2.415, -1.949, 0.015> <-2.410, -1.621, 0.001> <-2.410, -1.621, 0.001> <-2.410, -1.610, 0.271> 
		<-2.185, -1.949, -0.215> <-2.180, -1.625, -0.229> <-2.233, -1.257, -0.068> <-2.233, -1.243, 0.256> 
		<-1.915, -1.952, -0.215> <-1.910, -1.629, -0.228> <-1.905, -1.261, -0.067> <-1.905, -1.248, 0.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.415, -1.938, 0.285> <-2.415, -1.938, 0.285> <-2.415, -1.938, 0.285> <-2.415, -1.938, 0.285> 
		<-2.415, -1.949, 0.015> <-2.419, -2.285, 0.029> <-2.419, -2.285, 0.029> <-2.419, -2.273, 0.299> 
		<-2.185, -1.949, -0.215> <-2.189, -2.288, -0.201> <-2.261, -2.677, -0.025> <-2.261, -2.663, 0.315> 
		<-1.915, -1.952, -0.215> <-1.919, -2.292, -0.201> <-1.925, -2.682, -0.024> <-1.925, -2.668, 0.316> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.415, -1.938, 0.285> <-2.415, -1.938, 0.285> <-2.415, -1.938, 0.285> <-2.415, -1.938, 0.285> 
		<-2.415, -1.926, 0.555> <-2.419, -2.262, 0.569> <-2.419, -2.262, 0.569> <-2.419, -2.273, 0.299> 
		<-2.185, -1.907, 0.784> <-2.189, -2.247, 0.798> <-2.261, -2.649, 0.655> <-2.261, -2.663, 0.315> 
		<-1.915, -1.911, 0.784> <-1.919, -2.250, 0.799> <-1.925, -2.653, 0.655> <-1.925, -2.668, 0.316> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.415, -1.938, 0.285> <-2.415, -1.926, 0.555> <-2.185, -1.907, 0.784> <-1.915, -1.911, 0.784> 
		<-2.415, -1.949, 0.015> <-2.415, -1.938, 0.285> <-2.189, -2.247, 0.798> <-1.919, -2.250, 0.799> 
		<-2.185, -1.949, -0.215> <-2.189, -2.288, -0.201> <-1.925, -2.668, 0.316> <-1.925, -2.653, 0.655> 
		<-1.915, -1.952, -0.215> <-1.919, -2.292, -0.201> <-1.925, -2.682, -0.024> <-1.925, -2.668, 0.316> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.415, -1.938, 0.285> <-2.415, -1.926, 0.555> <-2.185, -1.907, 0.784> <-1.915, -1.911, 0.784> 
		<-2.415, -1.949, 0.015> <-2.415, -1.938, 0.285> <-2.180, -1.583, 0.771> <-1.910, -1.587, 0.771> 
		<-2.185, -1.949, -0.215> <-2.180, -1.625, -0.229> <-1.905, -1.248, 0.256> <-1.905, -1.234, 0.580> 
		<-1.915, -1.952, -0.215> <-1.910, -1.629, -0.228> <-1.905, -1.261, -0.067> <-1.905, -1.248, 0.256> 
	}
	#ifndef (IMPORT_SPATCH)
	texture {NBbeerbottle}
     interior { ior 1.546 }
	
	#end
}
	
 }