/* game.inc.  Scrabble game (board, tiles, racks) and a couple
of other accessories  */


#include "include/scrbrd2.inc"
#include "include/scrbtile.inc"
#include "include/rack.inc"

/* objects Board, Tile_*, and Rack are defined in these include files */

#declare TileLevel = TileThickness + BottomThickness
#declare TableSurfaceHeight = TableHeight+TableThickness+CS

#declare Game = union {

 object {Board}
 object {Tile_A translate <SquareSize*0, TileLevel,SquareSize*3>}
 object {Tile_X translate <SquareSize*0, TileLevel,SquareSize*2>}
 object {Tile_O translate <SquareSize*0, TileLevel,SquareSize*1>}
 object {Tile_N translate <SquareSize*0, TileLevel,SquareSize*0>}

 object {Tile_M translate <-SquareSize*1, TileLevel,SquareSize*1>}
 object {Tile_U translate <SquareSize*1, TileLevel,SquareSize*1>}
 object {Tile_R translate <SquareSize*2, TileLevel,SquareSize*1>}
 object {Tile_N translate <SquareSize*3, TileLevel,SquareSize*1>}
 object {Tile_I translate <SquareSize*4, TileLevel,SquareSize*1>}
 object {Tile_N translate <SquareSize*5, TileLevel,SquareSize*1>}
 object {Tile_G translate <SquareSize*6, TileLevel,SquareSize*1>}

//This lucky SOB bingoed!  :-)

#declare Rack1= union {

 object {Rack}

 object {Tile_T rotate -(90-TileAngle)*x 
 translate <TileDistX,TileDistY,TileDistZ>}

 object {Tile_E rotate -(90-TileAngle)*x 
 translate <TileDistX+TileSep,TileDistY,TileDistZ>}

 object {Tile_A rotate -(90-TileAngle)*x 
 translate <TileDistX+2*TileSep,TileDistY,TileDistZ>}

 object {Tile_R rotate -(90-TileAngle)*x 
 translate <TileDistX+3*TileSep,TileDistY,TileDistZ>}

 object {Tile_U rotate -(90-TileAngle)*x 
 translate <TileDistX+4*TileSep,TileDistY,TileDistZ>}

 object {Tile_N rotate -(90-TileAngle)*x 
 translate <TileDistX+5*TileSep,TileDistY,TileDistZ>}

 object {Tile_S rotate -(90-TileAngle)*x 
 translate <TileDistX+6*TileSep,TileDistY,TileDistZ>}

 translate <-RackLength/2,0,-16> rotate y*0}

#declare Rack2= union{

 object {Rack}

 object {Tile_B rotate -(90-TileAngle)*x 
 translate <TileDistX,TileDistY,TileDistZ>}

 object {Tile_L rotate -(90-TileAngle)*x 
 translate <TileDistX+TileSep,TileDistY,TileDistZ>}

 object {Tile_F rotate -(90-TileAngle)*x 
 translate <TileDistX+2*TileSep,TileDistY,TileDistZ>}

 object {Tile_A rotate -(90-TileAngle)*x 
 translate <TileDistX+3*TileSep,TileDistY,TileDistZ>}

 object {Tile_A rotate -(90-TileAngle)*x 
 translate <TileDistX+4*TileSep,TileDistY,TileDistZ>}

 object {Tile_V rotate -(90-TileAngle)*x 
 translate <TileDistX+5*TileSep,TileDistY,TileDistZ>}

 object {Tile_R rotate -(90-TileAngle)*x 
 translate <TileDistX+6*TileSep,TileDistY,TileDistZ>}

 translate <-RackLength/2,0,-16> rotate y*90}

#declare Rack3= union {

 object {Rack}

 object {Tile_J rotate -(90-TileAngle)*x 
 translate <TileDistX,TileDistY,TileDistZ>}

 object {Tile_Y rotate -(90-TileAngle)*x 
 translate <TileDistX+TileSep,TileDistY,TileDistZ>}

 object {Tile_E rotate -(90-TileAngle)*x 
  translate <TileDistX+2*TileSep,TileDistY,TileDistZ>}

 object {Tile_F rotate -(90-TileAngle)*x 
 translate <TileDistX+3*TileSep,TileDistY,TileDistZ>}

 object {Tile_W rotate -(90-TileAngle)*x 
 translate <TileDistX+4*TileSep,TileDistY,TileDistZ>}

 object {Tile_O rotate -(90-TileAngle)*x 
 translate <TileDistX+5*TileSep,TileDistY,TileDistZ>}

 object {Tile_N rotate -(90-TileAngle)*x 
 translate <TileDistX+6*TileSep,TileDistY,TileDistZ>}

 translate <-RackLength/2,0,-16> rotate y*180}

#declare Rack4= union {

 object {Rack}

 object {Tile_Q rotate -(90-TileAngle)*x 
 translate <TileDistX,TileDistY,TileDistZ>}

 object {Tile_A rotate -(90-TileAngle)*x 
 translate <TileDistX+TileSep,TileDistY,TileDistZ>}

 object {Tile_I rotate -(90-TileAngle)*x 
 translate <TileDistX+2*TileSep,TileDistY,TileDistZ>}

 object {Tile_D rotate -(90-TileAngle)*x 
 translate <TileDistX+3*TileSep,TileDistY,TileDistZ>}

 object {Tile_E rotate -(90-TileAngle)*x 
 translate <TileDistX+4*TileSep,TileDistY,TileDistZ>}

 object {Tile_E rotate -(90-TileAngle)*x 
 translate <TileDistX+5*TileSep,TileDistY,TileDistZ>}

 object {Tile_S rotate -(90-TileAngle)*x 
 translate <TileDistX+6*TileSep,TileDistY,TileDistZ>}

 translate <-RackLength/2,0,-16> rotate y*270}


 object {Rack1} 
 object {Rack2} 
 object {Rack3} 
 object {Rack4}

 scale 0.03 translate <0,TableSurfaceHeight,0>
 }  // Scrabble game union

#declare ScoreStuff = union {

//pad is just two boxes colored with a simple "ruled lines on yellow paper"
//image.  *Probably* not too hard to do this in POV-Ray but this was quicker

//the cleverest bit of the pad is the spiral binding.  I created an .inc file
//solely to do smooth helices and spirals ...

#declare PadThick=0.005
#declare PadWidth=0.08
#declare PadLength=0.15
#declare PadSep=0.005

#declare PadTexture1 = texture {
  pigment {
   image_map {gif "lines.gif"}
   scale PadLength*0.8
  }
  finish {Dull}}

#declare PadTexture2 = texture {
  pigment {
   image_map {gif "lines.gif"}
   scale PadLength*0.8
  }
  finish {Dull}}

#declare Pad = union {

  box {<-PadWidth/2, -PadLength, -PadThick/2>, <PadWidth/2, 0, PadThick/2>
   translate <0,-PadSep/2,0>
   texture {PadTexture1}
  }
 
  box {<-PadWidth/2, 0, -PadThick/2>, <PadWidth/2, PadLength, PadThick/2>
   translate <0,PadSep/2,0>
   texture {PadTexture2}
  }

  object {Spring rotate -z*90 translate <-PadWidth/2,0,0>
  } 
 }

 object {Pad rotate x*90 rotate y*90 
 translate <0, TableSurfaceHeight+PadThick,-0.85*TableRadius>
 }


//Pencil:  make out of a cylinder that gets turned into a hexagonal
//prism with clipping planes ... solution is general for prisms with
//regular polygons as cross-sections.

#declare PencilLength = 0.2
#declare PencilRadius = 0.005
#declare LeadRadius = 0.002
#declare TipLength = 0.025
#declare LeadStart = TipLength *((PencilRadius-LeadRadius)/PencilRadius)
#declare Sides = 6
#declare Theta = 360/Sides
#declare ThetaR = radians(Theta)
#declare ClipHeight = PencilRadius * cos(ThetaR/2)

#declare PencilTexture = texture {
 pigment {color Yellow}
 finish {specular 0.5 roughness 0.05}
 }

#declare LeadTexture = texture {
 pigment {color White*0.001}
 normal {dents 0.5 scale 0.001}
 finish {diffuse 0.8 ambient 0.05 specular 0.25 roughness 0.5}
 }

#declare WoodTexture = 
 texture {DPNWood1 rotate y*90 scale 0.05}

#declare  PencilCylinder = union {
 
 cylinder { <-(PencilLength/2 +CS), 0, 0>, <PencilLength/2,0,0>, LeadRadius
  texture {LeadTexture}
 }

 cylinder { <-PencilLength/2, 0, 0>, <PencilLength/2 + CS,0,0>, PencilRadius
  texture {PencilTexture}
 }
}

#declare ClipPlane =
  box {<-(PencilLength/2 + CS), ClipHeight+CS, -(PencilRadius+CS)>, 
       <PencilLength/2+CS, PencilRadius+CS, PencilRadius+CS>
  texture {PencilTexture}
  }

#declare Counter = 0

#while (Counter < Sides)
#declare PencilCylinder = 
 difference {
  object {PencilCylinder}
  object {ClipPlane rotate x*(Counter*Theta)}
 }
#declare Counter = Counter + 1
#end

#declare PencilTip = cone {
 <0,0,0>,PencilRadius,<TipLength,0,0>, 0
 texture {
   gradient x
   texture_map {
   [0.0 WoodTexture]
   [LeadStart WoodTexture]
   [LeadStart LeadTexture]
   [TipLength LeadTexture]
   }
 }
 translate <PencilLength/2+CS, 0, 0>
}

#declare Pencil = union {
 object {PencilCylinder}
 object {PencilTip}
 }

 object {Pencil rotate y*30 
 translate <0.25, TableSurfaceHeight+PencilRadius,-0.8*TableRadius>}
} //ScoreStuff union
