/*helix.inc.  Makes smooth, continous helices with
rectangular cross sections. Last modified Dec 17 1998  */

#declare Pi = 3.141592653589
#declare Count = 0


/*

   Helix constants:  Pitch = height change per complete turn
                     TurnTotal = total # of turns
                     (helix height = Pitch*TurnTotal)
                     HelixRadius = distance from helix axis to helix
                     Height = breadth of helix "ribbon"
                     Thickness = "ribbon" thickness 


   Construction:     Helix ribbon is made of small "prisms" with parallelogram
                       cross sections.
	             Spring is made of tilted cylinders with squared-off
                       ends (cross section is a parallelogram 

*/



/*  Define textures... */

#declare HelixTexture = 
 texture {pigment {color Red} finish {Shiny}}

/* These numbers should be set by the user.
   

#declare Pitch = 0.08 / 12
#declare TurnTotal = 12
#declare HelixRadius = 2
#declare Height=0.3
#declare Thickness=0.1



/* The following ones generally be left alone, except for HeightInc.
   Make HeightInc as large as is reasonably possible without introducing
   artifacts.  It'll need to be smaller if Pitch is small.  0.01 is a decent        starting place */

/* HeightInc = increment in height between successive helix  pieces */

#declare HeightInc = 0.0001

/* PerTurn is the number of such pieces per full turn   */

#declare PerTurn = Pitch/HeightInc

/* Alpha is the angle between pieces */

#declare Alpha = 360 / PerTurn

/* Total is the total number of pieces */

#declare Total = TurnTotal*PerTurn

/* PhiH is the angle the helix's "trace" makes with the horizontal */

#declare PhiH = degrees(atan2(Pitch, 2*Pi*HelixRadius)) 

/* For helices, calculate how wide each segment needs to be for a
   given radius and height increment   */

#declare Width= 
 2*(HelixRadius+Thickness)*tan(radians(Alpha/2)) 

/* A shifts the corners of the helix piece from a rectangle to a
   parallelogram with sides at the right angle to make a smooth
   helix   */

#declare A = Width*tan(radians(PhiH)) / 2


/* ===============================  */

/* Define the pieces of a helix... */

#declare HelixPiece = prism {
  linear_sweep linear_spline
  0, Thickness   // this is in +y, will need to move it later

  5, 

  <-Width/2, Height/2 - A>
  <Width/2, Height/2 + A>
  <Width/2, A -Height/2>
  <-Width/2, -Height/2 - A>
  <-Width/2, Height/2 - A>

  rotate -90*x translate <0,0,HelixRadius>
  }


#declare Helix = union {
 #while (Count < Total)
  object {HelixPiece 
   rotate y*(Count*Alpha)            // to move along helix locus
   translate y*(Count*HeightInc) }   // to move to proper height
  #declare Count=Count+1
  #end
 }


/* ==========================  */

