/* rack.inc -- racks for Scrabble game.
 Load "scrbtile.inc" before referring this file.
 Rack is centered on y-axis, with back flush against x-y plane */

#declare TileAngle = 10
#declare TileAngleR = radians (TileAngle)
#declare TileSep = 1.1 * TileSize


/* Rack is L - shaped:

   __
   | |
   | |
   | |
   | |
   | |   __
   | |___| |
   |_______|

*/

#declare RackWidth = 1.2
#declare RackLength = 12.5
#declare BackHeight = 1.75
#declare BackThickness = 0.4
#declare RackLipHeight = 0.3
#declare RackLipWidth = 0.2
#declare RackGrooveHeight = 0.2

//Figure out where the tiles go.  X is easy, Y and Z are affected by 
//the angle the tile makes with the vertical.

#declare TileDistX = TileSize/2
#declare TileDistY = TileSize/2+RackGrooveHeight + sin(TileAngleR) *   
         TileThickness/2
#declare TileDistZ = -(BackThickness + TileThickness + sin (TileAngleR) * 
         TileSize/2)

#declare Rack = prism {
 linear_sweep linear_spline 
 -RackLength/2,  RackLength/2,

 9 <0,0>, <RackWidth, 0>, <RackWidth, RackLipHeight>, 
 <RackWidth-RackLipWidth, RackLipHeight>, 
 <RackWidth-RackLipWidth,  RackGrooveHeight>, 
 <BackThickness, RackGrooveHeight>,
 <BackThickness, BackHeight>,<0,BackHeight>, <0,0> 

 texture {DPNWood2 scale 0.5}

//Rack is originally a prism along y-axis, from y=0 to y=RackLength.  
//Want it to have its bottom parallel to the x-z plane, back parallel to x-y

 rotate -x*90
 rotate y*90

//Close.  Last step is to center the rack on the origin.

 translate <RackLength/2, 0, 0>
 } //Rack prism

