
/* scrbtile.inc ... makes lettered tiles, centered on <0,0,0>.
   Use with scrabbleboard.inc or scrbrd2.inc, and rack.inc if
   desired. 

   Good defaults for the "standard" tiles are:

    texture {T_Wood11 finish{Dull}} for the tiles: 
     (a nice straight-grained light wood)

    pigment {color Black} for the letters

    Letters are simply POV-Ray text objects "stamped" (i.e., using difference)
    into the tiles themselves.

*/

#declare TileSize=1.4
#declare TileThickness=0.2

#declare TileTexture =
 texture {DPNWood1 scale 1 finish {FlatMatte}}
#declare LetterTexture =
 texture {pigment {color Black}}
#declare NumberTexture =
 texture {pigment {color Black}}

/* This is a somewhat clumsy, but effective, way of getting each tile (or,
at least, the tiles for different letters) to have a different wood grain
pattern if a wood texture is used: shift the texture a random amount from 0 to T_Shift each time.  */

#declare Seed1 = seed(1)
#declare T_Shift = 12

/* Letters and point values: */

#declare Letter_A = union {
  text { ttf "cyrvetic.ttf" "A" 0.1, 0
  texture {LetterTexture}  scale <1.25,1.25,1>
  translate <0.25,0.2,0>}

  text {ttf "cyrvetic.ttf" "1" 0.1, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}

#declare Letter_B = union {
  text { ttf "cyrvetic.ttf" "B" 0.1, 0
  texture {LetterTexture}
  scale <1.25,1.25,1>
  translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "3" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_C = union {
  text { ttf "cyrvetic.ttf" "C" 0.1, 0
  texture {LetterTexture}
  scale <1.25,1.25,1>
  translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "3" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_D = union {
  text { ttf "cyrvetic.ttf" "D" 0.1, 0
  texture {LetterTexture}
    scale <1.25,1.25,1>
 translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "2" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_E = union {
  text { ttf "cyrvetic.ttf" "E" 0.1, 0
  texture {LetterTexture}
   scale <1.25,1.25,1>
  translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "1" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_F = union {
  text { ttf "cyrvetic.ttf" "F" 0.1, 0
  texture {LetterTexture}
   scale <1.25,1.25,1>
  translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "4" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_G = union {
  text { ttf "cyrvetic.ttf" "G" 0.1, 0
  texture {LetterTexture}
   scale <1.25,1.25,1>
  translate <0.25,0.2,0>}

  text {ttf "cyrvetic.ttf" "2" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_H = union {
  text { ttf "cyrvetic.ttf" "H" 0.1, 0
  texture {LetterTexture}
    scale <1.25,1.25,1>
 translate <0.25,0.2,0>}

  text {ttf "cyrvetic.ttf" "4" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_I = union {
  text { ttf "cyrvetic.ttf" "I" 0.1, 0
  texture {LetterTexture}
   scale <1.25,1.25,1>
  translate <0.6,0.2,0>}

  text {ttf "cyrvetic.ttf" "1" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_J = union {
  text { ttf "cyrvetic.ttf" "J" 0.1, 0
  texture {LetterTexture}
   scale <1.25,1.25,1>
  translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "8" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_K = union {
  text { ttf "cyrvetic.ttf" "K" 0.1, 0
  texture {LetterTexture}
   scale <1.25,1.25,1>
  translate <0.25,0.2,0>}

  text {ttf "cyrvetic.ttf" "5" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_L = union {
  text { ttf "cyrvetic.ttf" "L" 0.1, 0
  texture {LetterTexture}
    scale <1.25,1.25,1>
 translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "1" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_M = union {
  text { ttf "cyrvetic.ttf" "M" 0.1, 0
  texture {LetterTexture}
   scale <1.25,1.25,1>
  translate <0.25,0.2,0>}

  text {ttf "cyrvetic.ttf" "3" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_N = union {
  text { ttf "cyrvetic.ttf" "N" 0.1, 0
  texture {LetterTexture}
    scale <1.25,1.25,1>
 translate <0.25,0.2,0>}

  text {ttf "cyrvetic.ttf" "1" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_O = union {
  text { ttf "cyrvetic.ttf" "O" 0.1, 0
  texture {LetterTexture}
    scale <1.25,1.25,1>
 translate <0.25,0.2,0>}

  text {ttf "cyrvetic.ttf" "1" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_P = union {
  text { ttf "cyrvetic.ttf" "P" 0.1, 0
  texture {LetterTexture}
    scale <1.25,1.25,1>
 translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "3" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_Q = union {
  text { ttf "cyrvetic.ttf" "Q" 0.1, 0
  texture {LetterTexture}
    scale <1.25,1.25,1>
 translate <0.15,0.2,0>}

  text {ttf "cyrvetic.ttf" "10" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate <1.0,0.1,0>}
}
#declare Letter_R = union {
  text { ttf "cyrvetic.ttf" "R" 0.1, 0
  texture {LetterTexture}
    scale <1.25,1.25,1>
 translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "1" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_S = union {
  text { ttf "cyrvetic.ttf" "S" 0.1, 0
  texture {LetterTexture}
    scale <1.25,1.25,1>
 translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "1" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_T = union {
  text { ttf "cyrvetic.ttf" "T" 0.1, 0
  texture {LetterTexture}
    scale <1.25,1.25,1>
 translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "1" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_U = union {
  text { ttf "cyrvetic.ttf" "U" 0.1, 0
  texture {LetterTexture}
   scale <1.25,1.25,1>
  translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "1" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_V = union {
  text { ttf "cyrvetic.ttf" "V" 0.1, 0
  texture {LetterTexture}
   scale <1.25,1.25,1>
  translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "4" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.0,0.15,0>}
}
#declare Letter_W = union {
  text { ttf "cyrvetic.ttf" "W" 0.1, 0
  texture {LetterTexture}
   scale <1.25,1.25,1>
  translate <0.2,0.2,0>}

  text {ttf "cyrvetic.ttf" "4" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_X = union {
  text { ttf "cyrvetic.ttf" "X" 0.1, 0
  texture {LetterTexture}
    scale <1.25,1.25,1>
 translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "8" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_Y = union {
  text { ttf "cyrvetic.ttf" "Y" 0.1, 0
  texture {LetterTexture}
  scale <1.25,1.25,1>
  translate <0.3,0.2,0>}

  text {ttf "cyrvetic.ttf" "4" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate<1.1,0.15,0>}
}
#declare Letter_Z = union {
  text { ttf "cyrvetic.ttf" "Z" 0.1, 0
  texture {LetterTexture}
  scale <1.25,1.25,1>
  translate <0.25,0.2,0>}

  text {ttf "cyrvetic.ttf" "10" 0.25, 0
  texture {NumberTexture}
  scale 0.4 translate <1.0,0.1,0>}
}

/* The tiles themselves */

#declare Tile_A = difference {
  
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}  
 }
 
 object {Letter_A} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_B = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
 } 

 object {Letter_B} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_C = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
 } 

 object {Letter_C}
 translate <-TileSize/2, -TileSize/2, 0>  rotate 90*x}

#declare Tile_D = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
 
}
 object {Letter_D} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_E = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
 
}
 object {Letter_E} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_F = difference {
  
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
 
}
 object {Letter_F} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_G = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
} 
 object {Letter_G} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_H = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_H} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_I = difference {
  
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_I} 
translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_J = difference {
  
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_J} 
translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_K = difference {
  
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_K} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_L = difference {
  
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_L} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_M = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_M} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_N = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_N} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_O = difference {
  
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_O} 
 translate <-TileSize/2, -TileSize/2, 0>  rotate 90*x}

#declare Tile_P = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_P} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_Q = difference {
  
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_Q} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_R = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 } 
 object {Letter_R} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_S = difference {
  
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_S} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_T = difference {
  
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_T} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_U = difference {
  
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_U} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_V = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_V} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_W = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_W} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_X = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
  
 }
 object {Letter_X} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_Y = difference {
 
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
  texture {TileTexture translate <K,K,0>}
   
  }
 object {Letter_Y} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_Z = difference {
 
 box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
  texture {TileTexture translate <K,K,0>}
   
 }
 object {Letter_Z} 
 translate <-TileSize/2, -TileSize/2, 0> rotate 90*x}

#declare Tile_Blank = 
  
box {<0,0,0.01>,<TileSize, TileSize, TileThickness> 
 #declare K = rand(Seed1)*T_Shift
 texture {TileTexture translate <K,K,0>}
   
 translate <-TileSize/2, -TileSize/2, 0>  rotate 90*x}
