/* newvenus.pov 
A representation of the first tourist voyage to the newly terraformed
Venus....
(C) 1998 David Nash

*/

global_settings {max_trace_level 10}

// generic coincident surfaces fixer, many include files use this!

#declare CS = 0.0001 

//Standard POV-Ray include files...

#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "textures.inc"
#include "finish.inc"

/*Scene-specific stuff */
/* Load dpntxtr.inc first, since many of the later include files
   use textures from it   */

#include "include/dpntxtr.inc"
#include "include/roomwall.inc"
#include "include/furnish.inc"
#include "include/lights.inc"
#include "include/venus.inc"
#include "include/dpnstars.inc"
#include "include/spring.inc"
#include "include/game.inc"

//Random number seeds, for convenience

#declare Seed0 = seed(0)  
#declare Seed1 = seed(1) 

//Lights.  Declared in lights.inc.  Four fixtures that look like fluorescent
//lights, flush (nearly) with the ceiling, plus a weak "fill" light (point
//source) to soften remaining shadows


object {LightFixture translate     
     <MainRoomLength*0.25,MainRoomHeight-LightBoxDepth-CS,MainRoomDepth*0.3>}
object {LightFixture translate 
     <MainRoomLength*0.25,MainRoomHeight-LightBoxDepth-CS,MainRoomDepth*0.7>}
object {LightFixture translate     
     <MainRoomLength*0.75,MainRoomHeight-LightBoxDepth-CS,MainRoomDepth*0.3>}
object {LightFixture translate 
     <MainRoomLength*0.75,MainRoomHeight-LightBoxDepth-CS,MainRoomDepth*0.7>}

object {FillLight}


//Test light source -- bright point light for quick renditions


/* light_source { <MainRoomLength/2,MainRoomHeight*0.99,MainRoomDepth/2> 
               color rgb <0.8,1,1>}
*/

camera {angle 45
        location <6,1.8,2>
        look_at <25,-1.75,10> }

#declare PosterHeight = 0.8
#declare PosterWidth = PosterHeight * 4 / 3

//poster image was created in POV-Ray, preserve aspect ratio of 4:3

#declare WallPoster = box {
 <0,0,-CS>,<1, 1, CS>

 texture {pigment {image_map {gif "logo.gif" map_type 0}}}
 translate <-0.5,-0.5,0>
 rotate y*90
 scale <1, MainRoomHeight*PosterHeight,MainRoomHeight*PosterWidth>
 translate <MainRoomLength, MainRoomHeight/2, 
            MainRoomDepth-(PosterWidth*2)>
 }

// Add the room walls, declared in roomwall.inc

object {Room}
object {WallPoster}
 
/* Furnish the room.

Want tables etc. to be in somewhat random locations, but also want all
objects on them to have positions that can be easily controlled.  */

#declare X1 = 3.5+rand(Seed0)
#declare Y1 = 0
#declare Z1 = 2 + rand(Seed0)

#declare X2 = 8+rand(Seed0)
#declare Y2 = 0
#declare Z2 = 2 + rand(Seed0)

#declare X3 = 12.5+rand(Seed0)
#declare Y3 = 0
#declare Z3 = 2 + rand(Seed0)

#declare TableCenter1 = <X1,Y1,Z1>
#declare TableCenter2 = <X2,Y2,Z2>
#declare TableCenter3 = <X3,Y3,Z3>

//Tables go here:

 object {Table translate TableCenter1}
 object {Table translate TableCenter2}
 object {Table translate TableCenter3}

//Make groups of 4 chairs, at angles differing somewhat from
//90 degrees wrt. each other.  One group for each table.

#declare BasicChair = object {Chair rotate y*90 translate <0,0,1>}

#declare Chairs1 = union {
 object {BasicChair}
 object {BasicChair rotate y*(70+40*rand(Seed1))}
 object {BasicChair rotate y*(160+40*rand(Seed1))}
 object {BasicChair rotate y*(250+40*rand(Seed1))}
}

#declare Chairs2 = union {
 object {BasicChair}
 object {BasicChair rotate y*(75+30*rand(Seed1))}
 object {BasicChair rotate y*(165+30*rand(Seed1))}
 object {BasicChair rotate y*(255+30*rand(Seed1))}
}

#declare Chairs3 = union {
 object {BasicChair}
 object {BasicChair rotate y*(70+40*rand(Seed1))}
 object {BasicChair rotate y*(160+40*rand(Seed1))}
 object {BasicChair rotate y*(250+40*rand(Seed1))}
}

//Center the chair groups on the table centers

object {Chairs1 translate TableCenter1} 
object {Chairs2 translate TableCenter2}
object {Chairs3 translate TableCenter3}

//Position the spotting scope

object {Scope rotate y*20 translate <10.5,0,4>}

//The Scrabble game is already at the correct height in furniture.inc,
// so OK for Y2 = 0 here

object {Game translate TableCenter2}
object {ScoreStuff translate TableCenter2}

//Drinks and such 
#declare DrinkGroup1 = union {
 object {FilledGlass3 translate <0,0,TableRadius*0.8>
  rotate y*(-10+20*rand(Seed1))}
 object {FilledGlass1 translate <0,0,TableRadius*0.8> 
  rotate y*(80+20*rand(Seed1))}
 object {FilledGlass3 translate <0,0,TableRadius*0.8> 
  rotate y*(170+20*rand(Seed1))}
 object {FilledGlass2 translate <0,0,TableRadius*0.8> 
  rotate y*(260+20*rand(Seed1))}
 }

#declare DrinkGroup2 = union {

 object {FilledGlass1 translate <0,0,TableRadius*0.8>
  rotate y*(35+20*rand(Seed1))}   
 object {FilledGlass2 translate <0,0,TableRadius*0.8> 
  rotate y*(125+20*rand(Seed1))}
 object {FilledGlass1 translate <0,0,TableRadius*0.8> 
  rotate y*(215+20*rand(Seed1))}
 object {FilledGlass3 translate <0,0,TableRadius*0.8> 
  rotate y*(305+20*rand(Seed1))}
 }

#declare DrinkGroup3 = union {
 
  object {FilledGlass3 translate <0,0,TableRadius*0.6>
   rotate y*(35+20*rand(Seed1))}
  object {FilledGlass1 translate <0,0,TableRadius*0.6> 
   rotate y*(125+30*rand(Seed1))}
  object {FilledGlass3 translate <0,0,TableRadius*0.6> 
   rotate y*(215+20*rand(Seed1))}
  object {FilledGlass2 translate <0,0,TableRadius*0.6> 
   rotate y*(305+20*rand(Seed1))}
 }

object {DrinkGroup1 translate <X1,TableHeight+TableThickness+CS,Z1>}
object {DrinkGroup2 translate <X2,TableHeight+TableThickness+CS,Z2>}
object {DrinkGroup3 translate <X3,TableHeight+TableThickness+CS,Z3>}

//Finally, put in Venus and some background stars.

object {StarGroup}
object {Venus rotate y*10 scale 80 translate <750,10,600>}

