//Copyright 1998 Nick Porter
//porternw@slu.edu

//-------------nppolar.pov---------------//

#include "nppolar.inc"

//lights & camera

light_source {       //natural moon-lighting
   <-150,200,-50>
   rgb .6 //.6
   rotate <0,140,0>
   area_light 
      <5, 0, 0>, <0, 0, 5>, 5, 5
      adaptive 1
      jitter
   }

light_source {        //mountain-plains lighting
   <-30,100,-5>, rgb .5
   spotlight
   point_at <-4,28,12>
   radius 10
   falloff 12 
   }
light_source {  // bear and dolphin highlighting
   <1,2,-5>, rgb .4
   fade_distance 3
   fade_power 2
   shadowless
   }         
        
camera {
   location <2.5,1,-7.5>
   look_at <2.9,1,0>
   }

//sky
difference{
sphere {
   0,300}
sphere {
   0,299.5}   
   texture {
      pigment {
         granite  
         color_map {
            [0.72 rgb <0,0,.2> ]  //stars
            [0.72 rgb <0,0,.2> ] 
            [0.75 rgb <0,0,.2> ] 
            [0.78 rgb <0,0,.2> ] 
            [0.81 rgb <0,0,.2> ] 
            [0.85 rgb 0.60 ] 
            [0.91 rgb <0,0,.2> ] 
            [0.91 rgb <0,0,.2> ] 
        }
      scale 20
      }
    finish { 
      ambient .8 
      diffuse 0
      reflection 0}
    scale .6
   }     
}  

//ocean

plane { 
   y, 0
   texture {
      pigment {
         bozo
         color_map {
            [0 MidnightBlue filter .4]
            [.5 Silver filter .4]
            }
         turbulence .3
         }
      normal {
         bumps .3
         scale .3
         translate <0,0,500>
         turbulence .1
         }
      finish {
         reflection .5
         ambient 0
         diffuse .5
         specular .9
         }
      translate <1,0,0>         
      }         
   }        


//ground
   
object {   
   difference {   
      box {
         <-100,-.1,-100> <100,.3,100>
      }
      sphere {
         <0,.6,0>,.5   
         }
      }      
   translate <0,-.275,-.5>
   scale <10,1,10> 
   texture {
      pigment {rgb 1}
      normal {
         bumps .5
         scale .5
         }
      finish {
         ambient .1 
         }           
      }
   }

//edge of Ground  

difference {
   sphere {
      <0,.6,0>,.5
      }
   sphere {
      <0,.6,0>,.499   
      }
   box {
      <-100,-.1,-100> <100,-2,100>
       
      }
   box {   
      <100,.3,100> <-100,2,-100>
      
      }     
   translate <0,-.275,-.5>
   scale <10,1,10>
   pigment {color White}
   normal {
      bumps 1
      scale .1
      }
   finish {
   ambient .2
   crand .1
   }
}       


//mountains

height_field {
   gif "mountains.gif"
   smooth
   rotate <0,-60,0>
   translate <.15,-.5,-.04>
   scale <50,30,40>
   pigment {rgb 1}
   finish {
      ambient .25   
      phong .9 
      }
   } 
   
//moon

union {
light_source { 
   <0,95,240>
   rgb 2
   spotlight
   point_at <0,100,250>
   radius 10
   falloff 11
   }

sphere {
   <0,100,250> 10
   texture { 
      pigment {
         bozo
         color_map {
            [0 color Gray70]
            [.4 color  White]
            [.8 color Gray60]
            }
         turbulence .9
         scale 15
         translate 3
         }
      normal {
         bumps .5
         scale 10
         turbulence .5
         }            
      finish {
         reflection 0
         ambient .9
         diffuse .1 
         crand .04
         }
      }   
   }
translate <23,0,0>
}




   
//santa

plane {
   z, 0
   pigment {
      image_map {
         tga "santa1.tga"
         once
         map_type 0
         interpolate 2
         }
      translate <5.455,10.2,0> 
      scale <.52,.35,.35> 
      }
   }

//Bear

object {
   Bear
   rotate <-7.75,60,0>
   translate <20,2.7,-30>
   scale .15
   }  

//Bear ripples

sphere {
   <3.4,-10,-4.1>, 10.01
   texture {
      pigment {
         bozo
         color_map {
            [0 MidnightBlue filter .4]
            [.5 Silver filter .4]
            }
         scale .75   
         turbulence .3
         }
      normal {
         ripples 1
         scale .1
         translate <3.4,0,-4.1>      
         }
       finish {
         reflection .5
         ambient 0
         diffuse .5
         specular .9
         }
      }
   }               

union {   

//Dolphin

object {
   Dolphin
   scale .2
   rotate <5,-90,0>
   translate <3.2,.2,-4.75>
   }  
// Dolphin ripples
   
sphere {
   <2.69,-10,-4.6>, 10.0175
   texture {
      pigment {
         bozo
         color_map {
            [0 MidnightBlue filter .4]
            [.5 Silver filter .4]
            }
         scale 1   
         turbulence .3
         }
      normal {
         ripples 1
         scale .1
         translate <2.69,0,-4.6>      
         }
       finish {
         reflection .5
         ambient 0
         diffuse .5
         specular .9
         }
      }
   }               
translate <-1,0,0>
}     

//Igloo

object {
   Igloo
   scale .15
   translate <-4,0,12>
   }  
   
object {
   Smoke
   scale .1
   translate <-5.25,0,12>
   }   
                   